/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils.stats;

import java.time.Clock;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jitsi.utils.DurationKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B#\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B#\b\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\fH\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\fH\u0002J\u0012\u0010\u001c\u001a\u00020\f2\b\b\u0002\u0010\u001d\u001a\u00020\fH\u0007J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\fH\u0016J\u001c\u0010\u001e\u001a\u00020\u001a2\b\b\u0002\u0010\u001f\u001a\u00020\f2\b\b\u0002\u0010\u001d\u001a\u00020\fH\u0007R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jitsi/utils/stats/RateTracker;", "", "windowSize", "Ljava/time/Duration;", "bucketSize", "clock", "Ljava/time/Clock;", "(Ljava/time/Duration;Ljava/time/Duration;Ljava/time/Clock;)V", "numBuckets", "", "(ILjava/time/Duration;Ljava/time/Clock;)V", "accumulatedCount", "", "bucketSizeMs", "buckets", "", "firstInsertTimeMs", "oldestIndex", "oldestTime", "rate", "getRate", "()J", "windowSizeMs", "coerceMs", "timeMs", "eraseOld", "", "now", "getAccumulatedCount", "nowMs", "update", "count", "jitsi-utils"})
public class RateTracker {
    private final int numBuckets;
    @NotNull
    private final Duration bucketSize;
    @NotNull
    private final Clock clock;
    private long accumulatedCount;
    @NotNull
    private final long[] buckets;
    private int oldestIndex;
    private long oldestTime;
    private long firstInsertTimeMs;
    private final long windowSizeMs;
    private final long bucketSizeMs;

    @JvmOverloads
    public RateTracker(int numBuckets, @NotNull Duration bucketSize, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)bucketSize, (String)"bucketSize");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.numBuckets = numBuckets;
        this.bucketSize = bucketSize;
        this.clock = clock;
        this.buckets = new long[this.numBuckets + 1];
        this.firstInsertTimeMs = -1L;
        this.windowSizeMs = (long)this.numBuckets * this.bucketSize.toMillis();
        this.bucketSizeMs = this.bucketSize.toMillis();
    }

    public /* synthetic */ RateTracker(int n, Duration duration, Clock clock, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            duration = DurationKt.getMs(1);
        }
        if ((n2 & 4) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC()");
            clock = clock2;
        }
        this(n, duration, clock);
    }

    @JvmOverloads
    public RateTracker(@NotNull Duration windowSize, @NotNull Duration bucketSize, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)windowSize, (String)"windowSize");
        Intrinsics.checkNotNullParameter((Object)bucketSize, (String)"bucketSize");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this((int)(windowSize.toMillis() / bucketSize.toMillis()), bucketSize, clock);
        if (bucketSize.toMillis() * (long)this.numBuckets != windowSize.toMillis()) {
            throw new IllegalArgumentException("The bucketSize (" + bucketSize.toMillis() + " ms) must divide the window size (" + windowSize.toMillis() + " ms) evenly.");
        }
    }

    public /* synthetic */ RateTracker(Duration duration, Duration duration2, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            duration2 = DurationKt.getMs(1);
        }
        if ((n & 4) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC()");
            clock = clock2;
        }
        this(duration, duration2, clock);
    }

    private final long coerceMs(long timeMs) {
        return timeMs / this.bucketSizeMs;
    }

    private final synchronized void eraseOld(long now) {
        long newOldestTime = now - (long)this.buckets.length + 1L;
        if (newOldestTime <= this.oldestTime) {
            return;
        }
        while (this.oldestTime < newOldestTime) {
            long countInOldestBucket = this.buckets[this.oldestIndex];
            RateTracker rateTracker = this;
            rateTracker.accumulatedCount -= countInOldestBucket;
            this.buckets[this.oldestIndex] = 0L;
            rateTracker = this;
            ++rateTracker.oldestIndex;
            if (rateTracker.oldestIndex >= this.buckets.length) {
                this.oldestIndex = 0;
            }
            rateTracker = this;
            ++rateTracker.oldestTime;
            long cfr_ignored_0 = rateTracker.oldestTime;
            if (this.accumulatedCount != 0L) continue;
        }
        this.oldestTime = newOldestTime;
        if (this.accumulatedCount == 0L) {
            this.firstInsertTimeMs = -1L;
        }
    }

    public synchronized long getRate(long nowMs) {
        this.eraseOld(this.coerceMs(nowMs));
        long effectiveWindowSizeMs = RangesKt.coerceIn((long)(nowMs - this.firstInsertTimeMs), (long)this.bucketSizeMs, (long)this.windowSizeMs);
        return MathKt.roundToLong((double)((double)this.accumulatedCount * (double)1000 / (double)effectiveWindowSizeMs));
    }

    public final long getRate() {
        return this.getRate(this.clock.millis());
    }

    @JvmOverloads
    public final synchronized long getAccumulatedCount(long nowMs) {
        this.eraseOld(this.coerceMs(nowMs));
        return this.accumulatedCount;
    }

    public static /* synthetic */ long getAccumulatedCount$default(RateTracker rateTracker, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getAccumulatedCount");
        }
        if ((n & 1) != 0) {
            l = rateTracker.clock.millis();
        }
        return rateTracker.getAccumulatedCount(l);
    }

    @JvmOverloads
    public final synchronized void update(long count, long nowMs) {
        long now = this.coerceMs(nowMs);
        if (now < this.oldestTime) {
            return;
        }
        if (this.firstInsertTimeMs < 0L) {
            this.firstInsertTimeMs = nowMs;
        }
        this.eraseOld(now);
        int nowOffset = (int)(now - this.oldestTime);
        int index = this.oldestIndex + nowOffset;
        if (index >= this.buckets.length) {
            index -= this.buckets.length;
        }
        this.buckets[index] = this.buckets[index] + count;
        RateTracker rateTracker = this;
        rateTracker.accumulatedCount += count;
    }

    public static /* synthetic */ void update$default(RateTracker rateTracker, long l, long l2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: update");
        }
        if ((n & 1) != 0) {
            l = 1L;
        }
        if ((n & 2) != 0) {
            l2 = rateTracker.clock.millis();
        }
        rateTracker.update(l, l2);
    }

    @JvmOverloads
    public RateTracker(int numBuckets, @NotNull Duration bucketSize) {
        Intrinsics.checkNotNullParameter((Object)bucketSize, (String)"bucketSize");
        this(numBuckets, bucketSize, null, 4, null);
    }

    @JvmOverloads
    public RateTracker(int numBuckets) {
        this(numBuckets, null, null, 6, null);
    }

    @JvmOverloads
    public RateTracker(@NotNull Duration windowSize, @NotNull Duration bucketSize) {
        Intrinsics.checkNotNullParameter((Object)windowSize, (String)"windowSize");
        Intrinsics.checkNotNullParameter((Object)bucketSize, (String)"bucketSize");
        this(windowSize, bucketSize, null, 4, null);
    }

    @JvmOverloads
    public RateTracker(@NotNull Duration windowSize) {
        Intrinsics.checkNotNullParameter((Object)windowSize, (String)"windowSize");
        this(windowSize, null, null, 6, null);
    }

    @JvmOverloads
    public final long getAccumulatedCount() {
        return RateTracker.getAccumulatedCount$default(this, 0L, 1, null);
    }

    @JvmOverloads
    public final void update(long count) {
        RateTracker.update$default(this, count, 0L, 2, null);
    }

    @JvmOverloads
    public final void update() {
        RateTracker.update$default(this, 0L, 0L, 3, null);
    }
}

