/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.extension;

import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.JsonSchemaMappingsProjectConfiguration;
import com.jetbrains.jsonSchema.UserDefinedJsonSchemaConfiguration;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaImportedProviderMarker;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaVersion;
import com.jetbrains.jsonSchema.remote.JsonFileResolver;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaUserDefinedProviderFactory
implements JsonSchemaProviderFactory,
DumbAware {
    @Override
    @NotNull
    public List<JsonSchemaFileProvider> getProviders(@NotNull Project project) {
        List providers;
        if (project == null) {
            JsonSchemaUserDefinedProviderFactory.$$$reportNull$$$0(0);
        }
        JsonSchemaMappingsProjectConfiguration configuration = JsonSchemaMappingsProjectConfiguration.getInstance(project);
        Map<String, UserDefinedJsonSchemaConfiguration> map = configuration.getStateMap();
        List list = providers = ContainerUtil.map(map.values(), schema -> this.createProvider(project, (UserDefinedJsonSchemaConfiguration)schema));
        if (list == null) {
            JsonSchemaUserDefinedProviderFactory.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public MyProvider createProvider(@NotNull Project project, UserDefinedJsonSchemaConfiguration schema) {
        if (project == null) {
            JsonSchemaUserDefinedProviderFactory.$$$reportNull$$$0(2);
        }
        String relPath = schema.getRelativePathToSchema();
        return new MyProvider(project, schema.getSchemaVersion(), schema.getName(), JsonFileResolver.isAbsoluteUrl(relPath) || new File(relPath).isAbsolute() ? relPath : new File(project.getBasePath(), relPath).getAbsolutePath(), schema.getCalculatedPatterns());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/extension/JsonSchemaUserDefinedProviderFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/extension/JsonSchemaUserDefinedProviderFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProviders";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createProvider";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    static final class MyProvider
    implements JsonSchemaFileProvider,
    JsonSchemaImportedProviderMarker {
        @NotNull
        private final Project myProject;
        @NotNull
        private final JsonSchemaVersion myVersion;
        @NotNull
        @Nls
        private final String myName;
        @NotNull
        private final String myFile;
        private VirtualFile myVirtualFile;
        @NotNull
        private final List<? extends PairProcessor<Project, VirtualFile>> myPatterns;

        MyProvider(@NotNull Project project, @NotNull JsonSchemaVersion version, @NotNull @Nls String name, @NotNull String file, @NotNull List<? extends PairProcessor<Project, VirtualFile>> patterns) {
            if (project == null) {
                MyProvider.$$$reportNull$$$0(0);
            }
            if (version == null) {
                MyProvider.$$$reportNull$$$0(1);
            }
            if (name == null) {
                MyProvider.$$$reportNull$$$0(2);
            }
            if (file == null) {
                MyProvider.$$$reportNull$$$0(3);
            }
            if (patterns == null) {
                MyProvider.$$$reportNull$$$0(4);
            }
            this.myProject = project;
            this.myVersion = version;
            this.myName = name;
            this.myFile = file;
            this.myPatterns = patterns;
        }

        @Override
        public JsonSchemaVersion getSchemaVersion() {
            return this.myVersion;
        }

        @Override
        @Nullable
        public VirtualFile getSchemaFile() {
            if (this.myVirtualFile != null && this.myVirtualFile.isValid()) {
                return this.myVirtualFile;
            }
            String path = this.myFile;
            if (JsonFileResolver.isAbsoluteUrl(path)) {
                this.myVirtualFile = JsonFileResolver.urlToFile(path);
            } else {
                LocalFileSystem lfs = LocalFileSystem.getInstance();
                this.myVirtualFile = lfs.findFileByPath(this.myFile);
                if (this.myVirtualFile == null) {
                    this.myVirtualFile = lfs.refreshAndFindFileByPath(this.myFile);
                }
            }
            return this.myVirtualFile;
        }

        @Override
        @NotNull
        public SchemaType getSchemaType() {
            SchemaType schemaType = SchemaType.userSchema;
            if (schemaType == null) {
                MyProvider.$$$reportNull$$$0(5);
            }
            return schemaType;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                MyProvider.$$$reportNull$$$0(6);
            }
            return string;
        }

        @Override
        public boolean isAvailable(@NotNull VirtualFile file) {
            if (file == null) {
                MyProvider.$$$reportNull$$$0(7);
            }
            if (this.myPatterns.isEmpty() || file.isDirectory() || !file.isValid()) {
                return false;
            }
            return this.myPatterns.stream().anyMatch(processor -> processor.process((Object)this.myProject, (Object)file));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyProvider provider = (MyProvider)o;
            if (!this.myName.equals(provider.myName)) {
                return false;
            }
            return FileUtil.pathsEqual((String)this.myFile, (String)provider.myFile);
        }

        public int hashCode() {
            int result = this.myName.hashCode();
            result = 31 * result + FileUtil.pathHashCode((String)this.myFile);
            return result;
        }

        @Override
        @Nullable
        public String getRemoteSource() {
            return JsonFileResolver.isHttpPath(this.myFile) ? this.myFile : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patterns";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/jsonSchema/extension/JsonSchemaUserDefinedProviderFactory$MyProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/jsonSchema/extension/JsonSchemaUserDefinedProviderFactory$MyProvider";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSchemaType";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6 -> new IllegalStateException(string);
            };
        }
    }
}

