;; Tests for f64x2 comparison operations on major boundary values and all special values.


(module
  (func (export "f64x2.eq") (param v128 v128) (result v128) (f64x2.eq (local.get 0) (local.get 1)))
  (func (export "f64x2.ne") (param v128 v128) (result v128) (f64x2.ne (local.get 0) (local.get 1)))
  (func (export "f64x2.lt") (param v128 v128) (result v128) (f64x2.lt (local.get 0) (local.get 1)))
  (func (export "f64x2.le") (param v128 v128) (result v128) (f64x2.le (local.get 0) (local.get 1)))
  (func (export "f64x2.gt") (param v128 v128) (result v128) (f64x2.gt (local.get 0) (local.get 1)))
  (func (export "f64x2.ge") (param v128 v128) (result v128) (f64x2.ge (local.get 0) (local.get 1)))
)

(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 01234567890123456789e038 01234567890123456789e038)
                                  (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 01234567890123456789e038 01234567890123456789e038)
                                  (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 01234567890123456789e038 01234567890123456789e038)
                                  (v128.const f64x2 0123456789.e038 0123456789.e038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 01234567890123456789e038 01234567890123456789e038)
                                  (v128.const f64x2 0123456789.e+038 0123456789.e+038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 01234567890123456789e038 01234567890123456789e038)
                                  (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038)
                                  (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038)
                                  (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038)
                                  (v128.const f64x2 0123456789.e038 0123456789.e038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038)
                                  (v128.const f64x2 0123456789.e+038 0123456789.e+038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038)
                                  (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0123456789.e038 0123456789.e038)
                                  (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0123456789.e038 0123456789.e038)
                                  (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0123456789.e038 0123456789.e038)
                                  (v128.const f64x2 0123456789.e038 0123456789.e038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0123456789.e038 0123456789.e038)
                                  (v128.const f64x2 0123456789.e+038 0123456789.e+038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0123456789.e038 0123456789.e038)
                                  (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0123456789.e+038 0123456789.e+038)
                                  (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0123456789.e+038 0123456789.e+038)
                                  (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0123456789.e+038 0123456789.e+038)
                                  (v128.const f64x2 0123456789.e038 0123456789.e038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0123456789.e+038 0123456789.e+038)
                                  (v128.const f64x2 0123456789.e+038 0123456789.e+038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0123456789.e+038 0123456789.e+038)
                                  (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789)
                                  (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789)
                                  (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789)
                                  (v128.const f64x2 0123456789.e038 0123456789.e038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789)
                                  (v128.const f64x2 0123456789.e+038 0123456789.e+038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789)
                                  (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 01234567890123456789e038 01234567890123456789e038)
                                  (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 01234567890123456789e038 01234567890123456789e038)
                                  (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 01234567890123456789e038 01234567890123456789e038)
                                  (v128.const f64x2 0123456789.e038 0123456789.e038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 01234567890123456789e038 01234567890123456789e038)
                                  (v128.const f64x2 0123456789.e+038 0123456789.e+038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 01234567890123456789e038 01234567890123456789e038)
                                  (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038)
                                  (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038)
                                  (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038)
                                  (v128.const f64x2 0123456789.e038 0123456789.e038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038)
                                  (v128.const f64x2 0123456789.e+038 0123456789.e+038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038)
                                  (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0123456789.e038 0123456789.e038)
                                  (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0123456789.e038 0123456789.e038)
                                  (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0123456789.e038 0123456789.e038)
                                  (v128.const f64x2 0123456789.e038 0123456789.e038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0123456789.e038 0123456789.e038)
                                  (v128.const f64x2 0123456789.e+038 0123456789.e+038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0123456789.e038 0123456789.e038)
                                  (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0123456789.e+038 0123456789.e+038)
                                  (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0123456789.e+038 0123456789.e+038)
                                  (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0123456789.e+038 0123456789.e+038)
                                  (v128.const f64x2 0123456789.e038 0123456789.e038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0123456789.e+038 0123456789.e+038)
                                  (v128.const f64x2 0123456789.e+038 0123456789.e+038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0123456789.e+038 0123456789.e+038)
                                  (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789)
                                  (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789)
                                  (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789)
                                  (v128.const f64x2 0123456789.e038 0123456789.e038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789)
                                  (v128.const f64x2 0123456789.e+038 0123456789.e+038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789)
                                  (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 01234567890123456789e038 01234567890123456789e038)
                                  (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 01234567890123456789e038 01234567890123456789e038)
                                  (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 01234567890123456789e038 01234567890123456789e038)
                                  (v128.const f64x2 0123456789.e038 0123456789.e038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 01234567890123456789e038 01234567890123456789e038)
                                  (v128.const f64x2 0123456789.e+038 0123456789.e+038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 01234567890123456789e038 01234567890123456789e038)
                                  (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038)
                                  (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038)
                                  (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038)
                                  (v128.const f64x2 0123456789.e038 0123456789.e038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038)
                                  (v128.const f64x2 0123456789.e+038 0123456789.e+038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038)
                                  (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0123456789.e038 0123456789.e038)
                                  (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0123456789.e038 0123456789.e038)
                                  (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0123456789.e038 0123456789.e038)
                                  (v128.const f64x2 0123456789.e038 0123456789.e038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0123456789.e038 0123456789.e038)
                                  (v128.const f64x2 0123456789.e+038 0123456789.e+038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0123456789.e038 0123456789.e038)
                                  (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0123456789.e+038 0123456789.e+038)
                                  (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0123456789.e+038 0123456789.e+038)
                                  (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0123456789.e+038 0123456789.e+038)
                                  (v128.const f64x2 0123456789.e038 0123456789.e038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0123456789.e+038 0123456789.e+038)
                                  (v128.const f64x2 0123456789.e+038 0123456789.e+038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0123456789.e+038 0123456789.e+038)
                                  (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789)
                                  (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789)
                                  (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789)
                                  (v128.const f64x2 0123456789.e038 0123456789.e038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789)
                                  (v128.const f64x2 0123456789.e+038 0123456789.e+038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789)
                                  (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 01234567890123456789e038 01234567890123456789e038)
                                  (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 01234567890123456789e038 01234567890123456789e038)
                                  (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 01234567890123456789e038 01234567890123456789e038)
                                  (v128.const f64x2 0123456789.e038 0123456789.e038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 01234567890123456789e038 01234567890123456789e038)
                                  (v128.const f64x2 0123456789.e+038 0123456789.e+038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 01234567890123456789e038 01234567890123456789e038)
                                  (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038)
                                  (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038)
                                  (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038)
                                  (v128.const f64x2 0123456789.e038 0123456789.e038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038)
                                  (v128.const f64x2 0123456789.e+038 0123456789.e+038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038)
                                  (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0123456789.e038 0123456789.e038)
                                  (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0123456789.e038 0123456789.e038)
                                  (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0123456789.e038 0123456789.e038)
                                  (v128.const f64x2 0123456789.e038 0123456789.e038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0123456789.e038 0123456789.e038)
                                  (v128.const f64x2 0123456789.e+038 0123456789.e+038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0123456789.e038 0123456789.e038)
                                  (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0123456789.e+038 0123456789.e+038)
                                  (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0123456789.e+038 0123456789.e+038)
                                  (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0123456789.e+038 0123456789.e+038)
                                  (v128.const f64x2 0123456789.e038 0123456789.e038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0123456789.e+038 0123456789.e+038)
                                  (v128.const f64x2 0123456789.e+038 0123456789.e+038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0123456789.e+038 0123456789.e+038)
                                  (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789)
                                  (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789)
                                  (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789)
                                  (v128.const f64x2 0123456789.e038 0123456789.e038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789)
                                  (v128.const f64x2 0123456789.e+038 0123456789.e+038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789)
                                  (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 01234567890123456789e038 01234567890123456789e038)
                                  (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 01234567890123456789e038 01234567890123456789e038)
                                  (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 01234567890123456789e038 01234567890123456789e038)
                                  (v128.const f64x2 0123456789.e038 0123456789.e038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 01234567890123456789e038 01234567890123456789e038)
                                  (v128.const f64x2 0123456789.e+038 0123456789.e+038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 01234567890123456789e038 01234567890123456789e038)
                                  (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038)
                                  (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038)
                                  (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038)
                                  (v128.const f64x2 0123456789.e038 0123456789.e038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038)
                                  (v128.const f64x2 0123456789.e+038 0123456789.e+038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038)
                                  (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0123456789.e038 0123456789.e038)
                                  (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0123456789.e038 0123456789.e038)
                                  (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0123456789.e038 0123456789.e038)
                                  (v128.const f64x2 0123456789.e038 0123456789.e038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0123456789.e038 0123456789.e038)
                                  (v128.const f64x2 0123456789.e+038 0123456789.e+038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0123456789.e038 0123456789.e038)
                                  (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0123456789.e+038 0123456789.e+038)
                                  (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0123456789.e+038 0123456789.e+038)
                                  (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0123456789.e+038 0123456789.e+038)
                                  (v128.const f64x2 0123456789.e038 0123456789.e038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0123456789.e+038 0123456789.e+038)
                                  (v128.const f64x2 0123456789.e+038 0123456789.e+038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0123456789.e+038 0123456789.e+038)
                                  (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789)
                                  (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789)
                                  (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789)
                                  (v128.const f64x2 0123456789.e038 0123456789.e038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789)
                                  (v128.const f64x2 0123456789.e+038 0123456789.e+038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789)
                                  (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -inf -inf)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p+0 0x1p+0)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1 0x1p-1)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x0p+0 0x0p+0)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 inf inf)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 01234567890123456789e038 01234567890123456789e038)
                                  (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 01234567890123456789e038 01234567890123456789e038)
                                  (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 01234567890123456789e038 01234567890123456789e038)
                                  (v128.const f64x2 0123456789.e038 0123456789.e038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 01234567890123456789e038 01234567890123456789e038)
                                  (v128.const f64x2 0123456789.e+038 0123456789.e+038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 01234567890123456789e038 01234567890123456789e038)
                                  (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038)
                                  (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038)
                                  (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038)
                                  (v128.const f64x2 0123456789.e038 0123456789.e038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038)
                                  (v128.const f64x2 0123456789.e+038 0123456789.e+038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038)
                                  (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0123456789.e038 0123456789.e038)
                                  (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0123456789.e038 0123456789.e038)
                                  (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0123456789.e038 0123456789.e038)
                                  (v128.const f64x2 0123456789.e038 0123456789.e038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0123456789.e038 0123456789.e038)
                                  (v128.const f64x2 0123456789.e+038 0123456789.e+038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0123456789.e038 0123456789.e038)
                                  (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0123456789.e+038 0123456789.e+038)
                                  (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0123456789.e+038 0123456789.e+038)
                                  (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0123456789.e+038 0123456789.e+038)
                                  (v128.const f64x2 0123456789.e038 0123456789.e038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0123456789.e+038 0123456789.e+038)
                                  (v128.const f64x2 0123456789.e+038 0123456789.e+038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0123456789.e+038 0123456789.e+038)
                                  (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789)
                                  (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789)
                                  (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789)
                                  (v128.const f64x2 0123456789.e038 0123456789.e038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789)
                                  (v128.const f64x2 0123456789.e+038 0123456789.e+038))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789)
                                  (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 nan nan)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -nan -nan)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x1p-1074 0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -inf -inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x1p+0 0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x0p+0 -0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p-1 -0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x1p-1 0x1p-1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x0p+0 0x0p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 inf inf))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -0x1p+0 -0x1p+0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 0x1p-1022 0x1p-1022))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 nan nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -nan -nan))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                  (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -1 -1)
                                  (v128.const f64x2 -1 -1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -1 -1)
                                  (v128.const f64x2 0 0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -1 -1)
                                  (v128.const f64x2 1 1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 -1 -1)
                                  (v128.const f64x2 2.0 2.0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0 0)
                                  (v128.const f64x2 -1 -1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0 0)
                                  (v128.const f64x2 0 0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0 0)
                                  (v128.const f64x2 1 1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 0 0)
                                  (v128.const f64x2 2.0 2.0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 1 1)
                                  (v128.const f64x2 -1 -1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 1 1)
                                  (v128.const f64x2 0 0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 1 1)
                                  (v128.const f64x2 1 1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 1 1)
                                  (v128.const f64x2 2.0 2.0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 2.0 2.0)
                                  (v128.const f64x2 -1 -1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 2.0 2.0)
                                  (v128.const f64x2 0 0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 2.0 2.0)
                                  (v128.const f64x2 1 1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.eq" (v128.const f64x2 2.0 2.0)
                                  (v128.const f64x2 2.0 2.0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -1 -1)
                                  (v128.const f64x2 -1 -1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -1 -1)
                                  (v128.const f64x2 0 0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -1 -1)
                                  (v128.const f64x2 1 1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 -1 -1)
                                  (v128.const f64x2 2.0 2.0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0 0)
                                  (v128.const f64x2 -1 -1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0 0)
                                  (v128.const f64x2 0 0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0 0)
                                  (v128.const f64x2 1 1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 0 0)
                                  (v128.const f64x2 2.0 2.0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 1 1)
                                  (v128.const f64x2 -1 -1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 1 1)
                                  (v128.const f64x2 0 0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 1 1)
                                  (v128.const f64x2 1 1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 1 1)
                                  (v128.const f64x2 2.0 2.0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 2.0 2.0)
                                  (v128.const f64x2 -1 -1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 2.0 2.0)
                                  (v128.const f64x2 0 0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 2.0 2.0)
                                  (v128.const f64x2 1 1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ne" (v128.const f64x2 2.0 2.0)
                                  (v128.const f64x2 2.0 2.0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -1 -1)
                                  (v128.const f64x2 -1 -1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -1 -1)
                                  (v128.const f64x2 0 0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -1 -1)
                                  (v128.const f64x2 1 1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 -1 -1)
                                  (v128.const f64x2 2.0 2.0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0 0)
                                  (v128.const f64x2 -1 -1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0 0)
                                  (v128.const f64x2 0 0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0 0)
                                  (v128.const f64x2 1 1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 0 0)
                                  (v128.const f64x2 2.0 2.0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 1 1)
                                  (v128.const f64x2 -1 -1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 1 1)
                                  (v128.const f64x2 0 0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 1 1)
                                  (v128.const f64x2 1 1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 1 1)
                                  (v128.const f64x2 2.0 2.0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 2.0 2.0)
                                  (v128.const f64x2 -1 -1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 2.0 2.0)
                                  (v128.const f64x2 0 0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 2.0 2.0)
                                  (v128.const f64x2 1 1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.lt" (v128.const f64x2 2.0 2.0)
                                  (v128.const f64x2 2.0 2.0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -1 -1)
                                  (v128.const f64x2 -1 -1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -1 -1)
                                  (v128.const f64x2 0 0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -1 -1)
                                  (v128.const f64x2 1 1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 -1 -1)
                                  (v128.const f64x2 2.0 2.0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0 0)
                                  (v128.const f64x2 -1 -1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0 0)
                                  (v128.const f64x2 0 0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0 0)
                                  (v128.const f64x2 1 1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 0 0)
                                  (v128.const f64x2 2.0 2.0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 1 1)
                                  (v128.const f64x2 -1 -1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 1 1)
                                  (v128.const f64x2 0 0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 1 1)
                                  (v128.const f64x2 1 1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 1 1)
                                  (v128.const f64x2 2.0 2.0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.le" (v128.const f64x2 2.0 2.0)
                                  (v128.const f64x2 -1 -1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 2.0 2.0)
                                  (v128.const f64x2 0 0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 2.0 2.0)
                                  (v128.const f64x2 1 1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.le" (v128.const f64x2 2.0 2.0)
                                  (v128.const f64x2 2.0 2.0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -1 -1)
                                  (v128.const f64x2 -1 -1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -1 -1)
                                  (v128.const f64x2 0 0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -1 -1)
                                  (v128.const f64x2 1 1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 -1 -1)
                                  (v128.const f64x2 2.0 2.0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0 0)
                                  (v128.const f64x2 -1 -1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0 0)
                                  (v128.const f64x2 0 0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0 0)
                                  (v128.const f64x2 1 1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 0 0)
                                  (v128.const f64x2 2.0 2.0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 1 1)
                                  (v128.const f64x2 -1 -1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 1 1)
                                  (v128.const f64x2 0 0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 1 1)
                                  (v128.const f64x2 1 1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 1 1)
                                  (v128.const f64x2 2.0 2.0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 2.0 2.0)
                                  (v128.const f64x2 -1 -1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 2.0 2.0)
                                  (v128.const f64x2 0 0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 2.0 2.0)
                                  (v128.const f64x2 1 1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.gt" (v128.const f64x2 2.0 2.0)
                                  (v128.const f64x2 2.0 2.0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -1 -1)
                                  (v128.const f64x2 -1 -1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -1 -1)
                                  (v128.const f64x2 0 0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -1 -1)
                                  (v128.const f64x2 1 1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 -1 -1)
                                  (v128.const f64x2 2.0 2.0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0 0)
                                  (v128.const f64x2 -1 -1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0 0)
                                  (v128.const f64x2 0 0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0 0)
                                  (v128.const f64x2 1 1))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 0 0)
                                  (v128.const f64x2 2.0 2.0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 1 1)
                                  (v128.const f64x2 -1 -1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 1 1)
                                  (v128.const f64x2 0 0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 1 1)
                                  (v128.const f64x2 1 1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 1 1)
                                  (v128.const f64x2 2.0 2.0))
                                  (v128.const i64x2 0 0))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 2.0 2.0)
                                  (v128.const f64x2 -1 -1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 2.0 2.0)
                                  (v128.const f64x2 0 0))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 2.0 2.0)
                                  (v128.const f64x2 1 1))
                                  (v128.const i64x2 -1 -1))
(assert_return (invoke "f64x2.ge" (v128.const f64x2 2.0 2.0)
                                  (v128.const f64x2 2.0 2.0))
                                  (v128.const i64x2 -1 -1))


;; unknown operators
(assert_malformed (module quote "(memory 1) (func  (param $x v128) (param $y v128) (result v128) (f2x64.eq (local.get $x) (local.get $y)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func  (param $x v128) (param $y v128) (result v128) (f2x64.ne (local.get $x) (local.get $y)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func  (param $x v128) (param $y v128) (result v128) (f2x64.lt (local.get $x) (local.get $y)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func  (param $x v128) (param $y v128) (result v128) (f2x64.le (local.get $x) (local.get $y)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func  (param $x v128) (param $y v128) (result v128) (f2x64.gt (local.get $x) (local.get $y)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func  (param $x v128) (param $y v128) (result v128) (f2x64.ge (local.get $x) (local.get $y)))") "unknown operator")

;; type check
(assert_invalid (module (func (result v128) (f64x2.eq (i32.const 0) (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (f64x2.ne (i32.const 0) (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (f64x2.lt (i32.const 0) (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (f64x2.le (i32.const 0) (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (f64x2.gt (i32.const 0) (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (f64x2.ge (i32.const 0) (f32.const 0.0)))) "type mismatch")

;; Test operation with empty argument

(assert_invalid
  (module
    (func $f64x2.eq-1st-arg-empty (result v128)
      (f64x2.eq (v128.const f64x2 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f64x2.eq-arg-empty (result v128)
      (f64x2.eq)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f64x2.ne-1st-arg-empty (result v128)
      (f64x2.ne (v128.const f64x2 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f64x2.ne-arg-empty (result v128)
      (f64x2.ne)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f64x2.lt-1st-arg-empty (result v128)
      (f64x2.lt (v128.const f64x2 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f64x2.lt-arg-empty (result v128)
      (f64x2.lt)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f64x2.le-1st-arg-empty (result v128)
      (f64x2.le (v128.const f64x2 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f64x2.le-arg-empty (result v128)
      (f64x2.le)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f64x2.gt-1st-arg-empty (result v128)
      (f64x2.gt (v128.const f64x2 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f64x2.gt-arg-empty (result v128)
      (f64x2.gt)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f64x2.ge-1st-arg-empty (result v128)
      (f64x2.ge (v128.const f64x2 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f64x2.ge-arg-empty (result v128)
      (f64x2.ge)
    )
  )
  "type mismatch"
)

;; combination
(module (memory 1)
  (func (export "f64x2.eq-in-block")
    (block
      (drop
        (block (result v128)
          (f64x2.eq
            (block (result v128) (v128.load (i32.const 0)))
            (block (result v128) (v128.load (i32.const 1)))
          )
        )
      )
    )
  )
  (func (export "f64x2.ne-in-block")
    (block
      (drop
        (block (result v128)
          (f64x2.ne
            (block (result v128) (v128.load (i32.const 0)))
            (block (result v128) (v128.load (i32.const 1)))
          )
        )
      )
    )
  )
  (func (export "f64x2.lt-in-block")
    (block
      (drop
        (block (result v128)
          (f64x2.lt
            (block (result v128) (v128.load (i32.const 0)))
            (block (result v128) (v128.load (i32.const 1)))
          )
        )
      )
    )
  )
  (func (export "f64x2.le-in-block")
    (block
      (drop
        (block (result v128)
          (f64x2.le
            (block (result v128) (v128.load (i32.const 0)))
            (block (result v128) (v128.load (i32.const 1)))
          )
        )
      )
    )
  )
  (func (export "f64x2.gt-in-block")
    (block
      (drop
        (block (result v128)
          (f64x2.gt
            (block (result v128) (v128.load (i32.const 0)))
            (block (result v128) (v128.load (i32.const 1)))
          )
        )
      )
    )
  )
  (func (export "f64x2.ge-in-block")
    (block
      (drop
        (block (result v128)
          (f64x2.ge
            (block (result v128) (v128.load (i32.const 0)))
            (block (result v128) (v128.load (i32.const 1)))
          )
        )
      )
    )
  )
  (func (export "nested-f64x2.eq")
    (drop
      (f64x2.eq
        (f64x2.eq
          (f64x2.eq
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (f64x2.eq
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
        (f64x2.eq
          (f64x2.eq
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (f64x2.eq
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
      )
    )
  )
  (func (export "nested-f64x2.ne")
    (drop
      (f64x2.ne
        (f64x2.ne
          (f64x2.ne
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (f64x2.ne
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
        (f64x2.ne
          (f64x2.ne
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (f64x2.ne
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
      )
    )
  )
  (func (export "nested-f64x2.lt")
    (drop
      (f64x2.lt
        (f64x2.lt
          (f64x2.lt
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (f64x2.lt
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
        (f64x2.lt
          (f64x2.lt
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (f64x2.lt
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
      )
    )
  )
  (func (export "nested-f64x2.le")
    (drop
      (f64x2.le
        (f64x2.le
          (f64x2.le
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (f64x2.le
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
        (f64x2.le
          (f64x2.le
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (f64x2.le
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
      )
    )
  )
  (func (export "nested-f64x2.gt")
    (drop
      (f64x2.gt
        (f64x2.gt
          (f64x2.gt
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (f64x2.gt
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
        (f64x2.gt
          (f64x2.gt
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (f64x2.gt
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
      )
    )
  )
  (func (export "nested-f64x2.ge")
    (drop
      (f64x2.ge
        (f64x2.ge
          (f64x2.ge
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (f64x2.ge
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
        (f64x2.ge
          (f64x2.ge
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (f64x2.ge
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
      )
    )
  )
  (func (export "as-param")
    (drop
      (f64x2.eq
        (f64x2.ne
          (f64x2.lt
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (f64x2.le
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
        (f64x2.gt
          (f64x2.ge
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (f64x2.eq
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
      )
    )
  )
)
(assert_return (invoke "f64x2.eq-in-block"))
(assert_return (invoke "f64x2.ne-in-block"))
(assert_return (invoke "f64x2.lt-in-block"))
(assert_return (invoke "f64x2.le-in-block"))
(assert_return (invoke "f64x2.gt-in-block"))
(assert_return (invoke "f64x2.ge-in-block"))
(assert_return (invoke "nested-f64x2.eq"))
(assert_return (invoke "nested-f64x2.ne"))
(assert_return (invoke "nested-f64x2.lt"))
(assert_return (invoke "nested-f64x2.le"))
(assert_return (invoke "nested-f64x2.gt"))
(assert_return (invoke "nested-f64x2.ge"))
(assert_return (invoke "as-param"))
