;; Tests for f32x4 [abs, min, max] operations on major boundary values and all special values.


(module
  (func (export "f32x4.min") (param v128 v128) (result v128) (f32x4.min (local.get 0) (local.get 1)))
  (func (export "f32x4.max") (param v128 v128) (result v128) (f32x4.max (local.get 0) (local.get 1)))
  (func (export "f32x4.abs") (param v128) (result v128) (f32x4.abs (local.get 0)))
  ;; f32x4.min const vs const
  (func (export "f32x4.min_with_const_0") (result v128) (f32x4.min (v128.const f32x4 0 1 2 -3) (v128.const f32x4 0 2 1 3)))
  (func (export "f32x4.min_with_const_1") (result v128) (f32x4.min (v128.const f32x4 0 1 2 3) (v128.const f32x4 0 1 2 3)))
  (func (export "f32x4.min_with_const_2") (result v128) (f32x4.min (v128.const f32x4 0x00 0x01 0x02 0x80000000) (v128.const f32x4 0x00 0x02 0x01 2147483648)))
  (func (export "f32x4.min_with_const_3") (result v128) (f32x4.min (v128.const f32x4 0x00 0x01 0x02 0x80000000) (v128.const f32x4 0x00 0x01 0x02 0x80000000)))
  ;; f32x4.min param vs const
  (func (export "f32x4.min_with_const_5")(param v128) (result v128) (f32x4.min (local.get 0) (v128.const f32x4 0 1 2 -3)))
  (func (export "f32x4.min_with_const_6")(param v128) (result v128) (f32x4.min (v128.const f32x4 0 1 2 3) (local.get 0)))
  (func (export "f32x4.min_with_const_7")(param v128) (result v128) (f32x4.min (v128.const f32x4 0x00 0x01 0x02 0x80000000) (local.get 0)))
  (func (export "f32x4.min_with_const_8")(param v128) (result v128) (f32x4.min (local.get 0) (v128.const f32x4 0x00 0x01 0x02 0x80000000)))
  ;; f32x4.max const vs const
  (func (export "f32x4.max_with_const_10") (result v128) (f32x4.max (v128.const f32x4 0 1 2 -3) (v128.const f32x4 0 2 1 3)))
  (func (export "f32x4.max_with_const_11") (result v128) (f32x4.max (v128.const f32x4 0 1 2 3) (v128.const f32x4 0 1 2 3)))
  (func (export "f32x4.max_with_const_12") (result v128) (f32x4.max (v128.const f32x4 0x00 0x01 0x02 0x80000000) (v128.const f32x4 0x00 0x02 0x01 2147483648)))
  (func (export "f32x4.max_with_const_13") (result v128) (f32x4.max (v128.const f32x4 0x00 0x01 0x02 0x80000000) (v128.const f32x4 0x00 0x01 0x02 0x80000000)))
  ;; f32x4.max param vs const
  (func (export "f32x4.max_with_const_15")(param v128) (result v128) (f32x4.max (local.get 0) (v128.const f32x4 0 1 2 -3)))
  (func (export "f32x4.max_with_const_16")(param v128) (result v128) (f32x4.max (v128.const f32x4 0 1 2 3) (local.get 0)))
  (func (export "f32x4.max_with_const_17")(param v128) (result v128) (f32x4.max (v128.const f32x4 0x00 0x01 0x02 0x80000000) (local.get 0)))
  (func (export "f32x4.max_with_const_18")(param v128) (result v128) (f32x4.max (local.get 0) (v128.const f32x4 0x00 0x01 0x02 0x80000000)))

  (func (export "f32x4.abs_with_const") (result v128) (f32x4.abs (v128.const f32x4 -0 -1 -2 -3)))
)

;; f32x4.min const vs const
(assert_return (invoke "f32x4.min_with_const_0") (v128.const f32x4 0 1 1 -3))
(assert_return (invoke "f32x4.min_with_const_1") (v128.const f32x4 0 1 2 3))
(assert_return (invoke "f32x4.min_with_const_2") (v128.const f32x4 0x00 0x01 0x01 0x80000000))
(assert_return (invoke "f32x4.min_with_const_3") (v128.const f32x4 0x00 0x01 0x02 0x80000000))
;; f32x4.min param vs const
(assert_return (invoke "f32x4.min_with_const_5" (v128.const f32x4 0 2 1 3))
                                                (v128.const f32x4 0 1 1 -3))
(assert_return (invoke "f32x4.min_with_const_6" (v128.const f32x4 0 1 2 3))
                                                (v128.const f32x4 0 1 2 3))
(assert_return (invoke "f32x4.min_with_const_7" (v128.const f32x4 0x00 0x02 0x01 2147483648))
                                                (v128.const f32x4 0x00 0x01 0x01 0x80000000))
(assert_return (invoke "f32x4.min_with_const_8" (v128.const f32x4 0x00 0x01 0x02 0x80000000))
                                                (v128.const f32x4 0x00 0x01 0x02 0x80000000))
;; f32x4.max const vs const
(assert_return (invoke "f32x4.max_with_const_10") (v128.const f32x4 0 2 2 3))
(assert_return (invoke "f32x4.max_with_const_11") (v128.const f32x4 0 1 2 3))
(assert_return (invoke "f32x4.max_with_const_12") (v128.const f32x4 0x00 0x02 0x02 2147483648))
(assert_return (invoke "f32x4.max_with_const_13") (v128.const f32x4 0x00 0x01 0x02 0x80000000))
;; f32x4.max param vs const
(assert_return (invoke "f32x4.max_with_const_15" (v128.const f32x4 0 2 1 3))
                                                 (v128.const f32x4 0 2 2 3))
(assert_return (invoke "f32x4.max_with_const_16" (v128.const f32x4 0 1 2 3))
                                                 (v128.const f32x4 0 1 2 3))
(assert_return (invoke "f32x4.max_with_const_17" (v128.const f32x4 0x00 0x02 0x01 2147483648))
                                                 (v128.const f32x4 0x00 0x02 0x02 2147483648))
(assert_return (invoke "f32x4.max_with_const_18" (v128.const f32x4 0x00 0x01 0x02 0x80000000))
                                                 (v128.const f32x4 0x00 0x01 0x02 0x80000000))

(assert_return (invoke "f32x4.abs_with_const") (v128.const f32x4 0 1 2 3))

;; Test different lanes go through different if-then clauses
;; f32x4.min
(assert_return
  (invoke "f32x4.min"
    (v128.const f32x4 nan 0 0 1)
    (v128.const f32x4 0 -nan 1 0)
  )
  (v128.const f32x4 nan:canonical nan:canonical 0 0)
)
;; f32x4.min
(assert_return
  (invoke "f32x4.min"
    (v128.const f32x4 nan 0 0 0)
    (v128.const f32x4 0 -nan 1 0)
  )
  (v128.const f32x4 nan:canonical nan:canonical 0 0)
)
;; f32x4.max
(assert_return
  (invoke "f32x4.max"
    (v128.const f32x4 nan 0 0 1)
    (v128.const f32x4 0 -nan 1 0)
  )
  (v128.const f32x4 nan:canonical nan:canonical 1 1)
)
;; f32x4.max
(assert_return
  (invoke "f32x4.max"
    (v128.const f32x4 nan 0 0 0)
    (v128.const f32x4 0 -nan 1 0)
  )
  (v128.const f32x4 nan:canonical nan:canonical 1 0)
)

(assert_return (invoke "f32x4.min" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.min" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.min" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.min" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.min" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.min" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.min" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.min" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.min" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.min" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.min" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.min" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.min" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                   (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                   (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                   (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                   (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                   (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                   (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                   (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                   (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                   (v128.const f32x4 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789))
                                   (v128.const f32x4 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                   (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                   (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                   (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                   (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                   (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                   (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                   (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                   (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                   (v128.const f32x4 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789))
                                   (v128.const f32x4 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                   (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                   (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                   (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                   (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                   (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                   (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                   (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                   (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                   (v128.const f32x4 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789))
                                   (v128.const f32x4 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                   (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                   (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                   (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                   (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                   (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                   (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                   (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                   (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
(assert_return (invoke "f32x4.min" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                   (v128.const f32x4 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789))
                                   (v128.const f32x4 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789)
                                   (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                   (v128.const f32x4 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789)
                                   (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                   (v128.const f32x4 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789)
                                   (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                   (v128.const f32x4 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789)
                                   (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                   (v128.const f32x4 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789)
                                   (v128.const f32x4 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789))
                                   (v128.const f32x4 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789))
(assert_return (invoke "f32x4.min" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.min" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.min" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.min" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.min" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.min" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.min" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.min" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.min" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.min" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.min" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.min" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.min" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.min" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.min" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.min" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.min" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.min" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.min" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.max" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.max" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.max" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.max" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.max" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.max" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.max" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.max" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.max" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.max" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.max" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.max" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.max" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.max" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.max" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.max" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                   (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                   (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                   (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                   (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                   (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                   (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                   (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                   (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                   (v128.const f32x4 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789))
                                   (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                   (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                   (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                   (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                   (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                   (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                   (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                   (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                   (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                   (v128.const f32x4 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789))
                                   (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                   (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                   (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                   (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                   (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                   (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                   (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                   (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                   (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                   (v128.const f32x4 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789))
                                   (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                   (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                   (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                   (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                   (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                   (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                   (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                   (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                   (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                   (v128.const f32x4 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789))
                                   (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789)
                                   (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                   (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789)
                                   (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                   (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789)
                                   (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                   (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789)
                                   (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                   (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789)
                                   (v128.const f32x4 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789))
                                   (v128.const f32x4 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789))
(assert_return (invoke "f32x4.max" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.max" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.max" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.max" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.max" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.max" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.max" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.max" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.max" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.max" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.max" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.max" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.max" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.max" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.max" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.max" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.max" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.max" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.max" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))

;; Test opposite signs of zero
(assert_return (invoke "f32x4.min" (v128.const f32x4 0 0 -0 +0)
                                   (v128.const f32x4 +0 -0 +0 -0))
                                   (v128.const f32x4 0 -0 -0 -0))
(assert_return (invoke "f32x4.min" (v128.const f32x4 -0 -0 -0 -0)
                                   (v128.const f32x4 +0 +0 +0 +0))
                                   (v128.const f32x4 -0 -0 -0 -0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 0 0 -0 +0)
                                   (v128.const f32x4 +0 -0 +0 -0))
                                   (v128.const f32x4 0 0 0 0))
(assert_return (invoke "f32x4.max" (v128.const f32x4 -0 -0 -0 -0)
                                   (v128.const f32x4 +0 +0 +0 +0))
                                   (v128.const f32x4 +0 +0 +0 +0))


(assert_return (invoke "f32x4.abs" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.abs" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.abs" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.abs" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.abs" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.abs" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.abs" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.abs" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.abs" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.abs" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.abs" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.abs" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.abs" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.abs" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.abs" (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.abs" (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.abs" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                   (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
(assert_return (invoke "f32x4.abs" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                   (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
(assert_return (invoke "f32x4.abs" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                   (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
(assert_return (invoke "f32x4.abs" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                   (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
(assert_return (invoke "f32x4.abs" (v128.const f32x4 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789 -0123456789.0123456789))
                                   (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))


;; Unknown operators

(assert_malformed (module quote "(memory 1) (func (result v128) (i8x16.min (v128.const i32x4 0 0 0 0) (v128.const i32x4 0 0 0 0)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (i8x16.max (v128.const i32x4 0 0 0 0) (v128.const i32x4 0 0 0 0)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (i16x8.min (v128.const i32x4 0 0 0 0) (v128.const i32x4 0 0 0 0)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (i16x8.max (v128.const i32x4 0 0 0 0) (v128.const i32x4 0 0 0 0)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (i32x4.min (v128.const i32x4 0 0 0 0) (v128.const i32x4 0 0 0 0)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (i32x4.max (v128.const i32x4 0 0 0 0) (v128.const i32x4 0 0 0 0)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (i64x2.min (v128.const i32x4 0 0 0 0) (v128.const i32x4 0 0 0 0)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (i64x2.max (v128.const i32x4 0 0 0 0) (v128.const i32x4 0 0 0 0)))") "unknown operator")

;; type check
(assert_invalid (module (func (result v128) (f32x4.abs (i32.const 0)))) "type mismatch")
(assert_invalid (module (func (result v128) (f32x4.min (i32.const 0) (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (f32x4.max (i32.const 0) (f32.const 0.0)))) "type mismatch")

;; Test operation with empty argument

(assert_invalid
  (module
    (func $f32x4.abs-arg-empty (result v128)
      (f32x4.abs)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f32x4.min-1st-arg-empty (result v128)
      (f32x4.min (v128.const f32x4 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f32x4.min-arg-empty (result v128)
      (f32x4.min)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f32x4.max-1st-arg-empty (result v128)
      (f32x4.max (v128.const f32x4 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f32x4.max-arg-empty (result v128)
      (f32x4.max)
    )
  )
  "type mismatch"
)

;; combination
(module
  (func (export "max-min") (param v128 v128 v128) (result v128)
    (f32x4.max (f32x4.min (local.get 0) (local.get 1))(local.get 2)))
  (func (export "min-max") (param v128 v128 v128) (result v128)
    (f32x4.min (f32x4.max (local.get 0) (local.get 1))(local.get 2)))
  (func (export "max-abs") (param v128 v128) (result v128)
    (f32x4.max (f32x4.abs (local.get 0)) (local.get 1)))
  (func (export "min-abs") (param v128 v128) (result v128)
    (f32x4.min (f32x4.abs (local.get 0)) (local.get 1)))
)

(assert_return (invoke "max-min" (v128.const f32x4 1.125 1.125 1.125 1.125)
                                 (v128.const f32x4 0.25 0.25 0.25 0.25)
                                 (v128.const f32x4 0.125 0.125 0.125 0.125))
                                 (v128.const f32x4 0.25 0.25 0.25 0.25))
(assert_return (invoke "min-max" (v128.const f32x4 1.125 1.125 1.125 1.125)
                                 (v128.const f32x4 0.25 0.25 0.25 0.25)
                                 (v128.const f32x4 0.125 0.125 0.125 0.125))
                                 (v128.const f32x4 0.125 0.125 0.125 0.125))
(assert_return (invoke "max-abs" (v128.const f32x4 -1.125 -1.125 -1.125 -1.125)
                                 (v128.const f32x4 0.125 0.125 0.125 0.125))
                                 (v128.const f32x4 1.125 1.125 1.125 1.125))
(assert_return (invoke "min-abs" (v128.const f32x4 -1.125 -1.125 -1.125 -1.125)
                                 (v128.const f32x4 0.125 0.125 0.125 0.125))
                                 (v128.const f32x4 0.125 0.125 0.125 0.125))