   /*******************************************************/
   /*      "C" Language Integrated Production System      */
   /*                                                     */
   /*             CLIPS Version 6.40  08/25/16            */
   /*                                                     */
   /*                 AGENDA HEADER FILE                  */
   /*******************************************************/

/*************************************************************/
/* Purpose:                                                  */
/*   Provides functionality for examining, manipulating,     */
/*   adding, and removing activations from the agenda.       */
/*                                                           */
/* Principal Programmer(s):                                  */
/*      Gary D. Riley                                        */
/*                                                           */
/* Contributing Programmer(s):                               */
/*                                                           */
/* Revision History:                                         */
/*      6.23: Corrected compilation errors for files         */
/*            generated by constructs-to-c. DR0861           */
/*                                                           */
/*      6.24: Removed CONFLICT_RESOLUTION_STRATEGIES and     */
/*            DYNAMIC_SALIENCE compilation flags.            */
/*                                                           */
/*            Renamed BOOLEAN macro type to intBool.         */
/*                                                           */
/*            Added EnvGetActivationBasisPPForm function.    */
/*                                                           */
/*      6.30: Added salience groups to improve performance   */
/*            with large numbers of activations of different */
/*            saliences.                                     */
/*                                                           */
/*            Borland C (IBM_TBC) and Metrowerks CodeWarrior */
/*            (MAC_MCW, IBM_MCW) are no longer supported.    */
/*                                                           */
/*            Support for long long integers.                */
/*                                                           */
/*            Added const qualifiers to remove C++           */
/*            deprecation warnings.                          */
/*                                                           */
/*            Converted API macros to function calls.        */
/*                                                           */
/*      6.40: Removed LOCALE definition.                     */
/*                                                           */
/*            Pragma once and other inclusion changes.       */
/*                                                           */
/*            Added support for booleans with <stdbool.h>.   */
/*                                                           */
/*            Removed use of void pointers for specific      */
/*            data structures.                               */
/*                                                           */
/*            ALLOW_ENVIRONMENT_GLOBALS no longer supported. */
/*                                                           */
/*            UDF redesign.                                  */
/*                                                           */
/*************************************************************/

#ifndef _H_agenda

#pragma once

#define _H_agenda

typedef struct activation Activation;

#include "ruledef.h"
#include "symbol.h"
#include "match.h"

typedef enum
  {
   WHEN_DEFINED,
   WHEN_ACTIVATED,
   EVERY_CYCLE
  } SalienceEvaluationType;

#define MAX_DEFRULE_SALIENCE  10000
#define MIN_DEFRULE_SALIENCE -10000

/*******************/
/* DATA STRUCTURES */
/*******************/

struct activation
  {
   Defrule *theRule;
   struct partialMatch *basis;
   int salience;
   unsigned long long timetag;
   int randomID;
   struct activation *prev;
   struct activation *next;
  };

struct salienceGroup
  {
   int salience;
   struct activation *first;
   struct activation *last;
   struct salienceGroup *next;
   struct salienceGroup *prev;
  };

#include "crstrtgy.h"

#define AGENDA_DATA 17

struct agendaData
  {
#if DEBUGGING_FUNCTIONS
   bool WatchActivations;
#endif
   unsigned long NumberOfActivations;
   unsigned long long CurrentTimetag;
   bool AgendaChanged;
   SalienceEvaluationType SalienceEvaluation;
   StrategyType Strategy;
  };

#define AgendaData(theEnv) ((struct agendaData *) GetEnvironmentData(theEnv,AGENDA_DATA))

/****************************************/
/* GLOBAL EXTERNAL FUNCTION DEFINITIONS */
/****************************************/

   void                    AddActivation(Environment *,Defrule *,PartialMatch *);
   void                    ClearRuleFromAgenda(Environment *,Defrule *);
   Activation             *GetNextActivation(Environment *,Activation *);
   struct partialMatch    *GetActivationBasis(Environment *,Activation *);
   const char             *ActivationRuleName(Activation *);
   Defrule                *GetActivationRule(Environment *,Activation *);
   int                     ActivationGetSalience(Activation *);
   int                     ActivationSetSalience(Activation *,int);
   void                    ActivationPPForm(Activation *,StringBuilder *);
   void                    GetActivationBasisPPForm(Environment *,char *,size_t,Activation *);
   bool                    MoveActivationToTop(Environment *,Activation *);
   void                    DeleteActivation(Activation *);
   bool                    DetachActivation(Environment *,Activation *);
   void                    DeleteAllActivations(Defmodule *);
   void                    Agenda(Environment *,const char *,Defmodule *);
   void                    RemoveActivation(Environment *,Activation *,bool,bool);
   void                    RemoveAllActivations(Environment *);
   bool                    GetAgendaChanged(Environment *);
   void                    SetAgendaChanged(Environment *,bool);
   unsigned long           GetNumberOfActivations(Environment *);
   SalienceEvaluationType  GetSalienceEvaluation(Environment *);
   SalienceEvaluationType  SetSalienceEvaluation(Environment *,SalienceEvaluationType);
   void                    RefreshAgenda(Defmodule *);
   void                    RefreshAllAgendas(Environment *);
   void                    ReorderAgenda(Defmodule *);
   void                    ReorderAllAgendas(Environment *);
   void                    InitializeAgenda(Environment *);
   void                    SetSalienceEvaluationCommand(Environment *,UDFContext *,UDFValue *);
   void                    GetSalienceEvaluationCommand(Environment *,UDFContext *,UDFValue *);
   void                    RefreshAgendaCommand(Environment *,UDFContext *,UDFValue *);
   void                    RefreshCommand(Environment *,UDFContext *,UDFValue *);
   void                    Refresh(Defrule *);
#if DEBUGGING_FUNCTIONS
   void                    AgendaCommand(Environment *,UDFContext *,UDFValue *);
#endif

#endif






