// SPDX-License-Identifier: GPL-3.0-or-later

package api

import (
	"strconv"
	"time"

	"layeh.com/radius"
	"layeh.com/radius/rfc2865"
)

/*
The response from the freeradius 3.0.12+dfsg-5+deb9u1

Sent Status-Server Id 23 from 0.0.0.0:37131 to 127.0.0.1:18121 length 50
	Message-Authenticator = 0x00
	FreeRADIUS-Statistics-Type = All
Received Access-Accept Id 23 from 127.0.0.1:18121 to 0.0.0.0:0 length 536
	FreeRADIUS-Total-Access-Requests = 3
	FreeRADIUS-Total-Access-Accepts = 0
	FreeRADIUS-Total-Access-Rejects = 0
	FreeRADIUS-Total-Access-Challenges = 0
	FreeRADIUS-Total-Auth-Responses = 0
	FreeRADIUS-Total-Auth-Duplicate-Requests = 0
	FreeRADIUS-Total-Auth-Malformed-Requests = 0
	FreeRADIUS-Total-Auth-Invalid-Requests = 0
	FreeRADIUS-Total-Auth-Dropped-Requests = 0
	FreeRADIUS-Total-Auth-Unknown-Types = 0
	FreeRADIUS-Total-Accounting-Requests = 0
	FreeRADIUS-Total-Accounting-Responses = 0
	FreeRADIUS-Total-Acct-Duplicate-Requests = 0
	FreeRADIUS-Total-Acct-Malformed-Requests = 0
	FreeRADIUS-Total-Acct-Invalid-Requests = 0
	FreeRADIUS-Total-Acct-Dropped-Requests = 0
	FreeRADIUS-Total-Acct-Unknown-Types = 0
	FreeRADIUS-Total-Proxy-Access-Requests = 0
	FreeRADIUS-Total-Proxy-Access-Accepts = 0
	FreeRADIUS-Total-Proxy-Access-Rejects = 0
	FreeRADIUS-Total-Proxy-Access-Challenges = 0
	FreeRADIUS-Total-Proxy-Auth-Responses = 0
	FreeRADIUS-Total-Proxy-Auth-Duplicate-Requests = 0
	FreeRADIUS-Total-Proxy-Auth-Malformed-Requests = 0
	FreeRADIUS-Total-Proxy-Auth-Invalid-Requests = 0
	FreeRADIUS-Total-Proxy-Auth-Dropped-Requests = 0
	FreeRADIUS-Total-Proxy-Auth-Unknown-Types = 0
	FreeRADIUS-Total-Proxy-Accounting-Requests = 0
	FreeRADIUS-Total-Proxy-Accounting-Responses = 0
	FreeRADIUS-Total-Proxy-Acct-Duplicate-Requests = 0
	FreeRADIUS-Total-Proxy-Acct-Malformed-Requests = 0
	FreeRADIUS-Total-Proxy-Acct-Invalid-Requests = 0
	FreeRADIUS-Total-Proxy-Acct-Dropped-Requests = 0
	FreeRADIUS-Total-Proxy-Acct-Unknown-Types = 0
	FreeRADIUS-Stats-Start-Time = "Dec 27 2018 05:08:02 +09"
	FreeRADIUS-Stats-HUP-Time = "Dec 27 2018 05:08:02 +09"
	FreeRADIUS-Queue-Len-Internal = 0
	FreeRADIUS-Queue-Len-Proxy = 0
	FreeRADIUS-Queue-Len-Auth = 0
	FreeRADIUS-Queue-Len-Acct = 0
	FreeRADIUS-Queue-Len-Detail = 0
	FreeRADIUS-Queue-PPS-In = 0
	FreeRADIUS-Queue-PPS-Out = 0
*/

// Code generation tool https://github.com/layeh/radius/tree/master/cmd/radius-dict-gen.
// Used dictionary: dictionary.freeradius from /usr/share/freeradius/ directory (freeradius 3.0.12+dfsg-5+deb9u1)
// All attributes that are not in response were removed to reduce the amount of generated code.

// Code generated by radius-dict-gen. DO NOT EDIT.

const (
	_FreeRADIUS_VendorID = 11344
)

func _FreeRADIUS_AddVendor(p *radius.Packet, typ byte, attr radius.Attribute) (err error) {
	var vsa radius.Attribute
	vendor := make(radius.Attribute, 2+len(attr))
	vendor[0] = typ
	vendor[1] = byte(len(vendor))
	copy(vendor[2:], attr)
	vsa, err = radius.NewVendorSpecific(_FreeRADIUS_VendorID, vendor)
	if err != nil {
		return
	}
	p.Add(rfc2865.VendorSpecific_Type, vsa)
	return
}

func _FreeRADIUS_GetsVendor(p *radius.Packet, typ byte) (values []radius.Attribute) {
	for _, attr := range p.Attributes[rfc2865.VendorSpecific_Type] {
		vendorID, vsa, err := radius.VendorSpecific(attr)
		if err != nil || vendorID != _FreeRADIUS_VendorID {
			continue
		}
		for len(vsa) >= 3 {
			vsaTyp, vsaLen := vsa[0], vsa[1]
			if int(vsaLen) > len(vsa) || vsaLen < 3 {
				break
			}
			if vsaTyp == typ {
				values = append(values, vsa[2:int(vsaLen)])
			}
			vsa = vsa[int(vsaLen):]
		}
	}
	return
}

func _FreeRADIUS_LookupVendor(p *radius.Packet, typ byte) (attr radius.Attribute, ok bool) {
	for _, a := range p.Attributes[rfc2865.VendorSpecific_Type] {
		vendorID, vsa, err := radius.VendorSpecific(a)
		if err != nil || vendorID != _FreeRADIUS_VendorID {
			continue
		}
		for len(vsa) >= 3 {
			vsaTyp, vsaLen := vsa[0], vsa[1]
			if int(vsaLen) > len(vsa) || vsaLen < 3 {
				break
			}
			if vsaTyp == typ {
				return vsa[2:int(vsaLen)], true
			}
			vsa = vsa[int(vsaLen):]
		}
	}
	return
}

func _FreeRADIUS_SetVendor(p *radius.Packet, typ byte, attr radius.Attribute) (err error) {
	for i := 0; i < len(p.Attributes[rfc2865.VendorSpecific_Type]); {
		vendorID, vsa, err := radius.VendorSpecific(p.Attributes[rfc2865.VendorSpecific_Type][i])
		if err != nil || vendorID != _FreeRADIUS_VendorID {
			i++
			continue
		}
		for j := 0; len(vsa[j:]) >= 3; {
			vsaTyp, vsaLen := vsa[0], vsa[1]
			if int(vsaLen) > len(vsa[j:]) || vsaLen < 3 {
				i++
				break
			}
			if vsaTyp == typ {
				vsa = append(vsa[:j], vsa[j+int(vsaLen):]...)
			}
			j += int(vsaLen)
		}
		if len(vsa) > 0 {
			copy(p.Attributes[rfc2865.VendorSpecific_Type][i][4:], vsa)
			i++
		} else {
			p.Attributes[rfc2865.VendorSpecific_Type] = append(p.Attributes[rfc2865.VendorSpecific_Type][:i], p.Attributes[rfc2865.VendorSpecific_Type][i+i:]...)
		}
	}
	return _FreeRADIUS_AddVendor(p, typ, attr)
}

func _FreeRADIUS_DelVendor(p *radius.Packet, typ byte) {
vsaLoop:
	for i := 0; i < len(p.Attributes[rfc2865.VendorSpecific_Type]); {
		attr := p.Attributes[rfc2865.VendorSpecific_Type][i]
		vendorID, vsa, err := radius.VendorSpecific(attr)
		if err != nil || vendorID != _FreeRADIUS_VendorID {
			continue
		}
		offset := 0
		for len(vsa[offset:]) >= 3 {
			vsaTyp, vsaLen := vsa[offset], vsa[offset+1]
			if int(vsaLen) > len(vsa) || vsaLen < 3 {
				continue vsaLoop
			}
			if vsaTyp == typ {
				copy(vsa[offset:], vsa[offset+int(vsaLen):])
				vsa = vsa[:len(vsa)-int(vsaLen)]
			} else {
				offset += int(vsaLen)
			}
		}
		if offset == 0 {
			p.Attributes[rfc2865.VendorSpecific_Type] = append(p.Attributes[rfc2865.VendorSpecific_Type][:i], p.Attributes[rfc2865.VendorSpecific_Type][i+1:]...)
		} else {
			i++
		}
	}
	return
}

type FreeRADIUSStatisticsType uint32

const (
	FreeRADIUSStatisticsType_Value_All FreeRADIUSStatisticsType = 31
)

var FreeRADIUSStatisticsType_Strings = map[FreeRADIUSStatisticsType]string{
	FreeRADIUSStatisticsType_Value_All: "All",
}

func (a FreeRADIUSStatisticsType) String() string {
	if str, ok := FreeRADIUSStatisticsType_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSStatisticsType(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSStatisticsType_Add(p *radius.Packet, value FreeRADIUSStatisticsType) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 127, a)
}

func FreeRADIUSStatisticsType_Get(p *radius.Packet) (value FreeRADIUSStatisticsType) {
	value, _ = FreeRADIUSStatisticsType_Lookup(p)
	return
}

func FreeRADIUSStatisticsType_Gets(p *radius.Packet) (values []FreeRADIUSStatisticsType, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 127) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSStatisticsType(i))
	}
	return
}

func FreeRADIUSStatisticsType_Lookup(p *radius.Packet) (value FreeRADIUSStatisticsType, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 127)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSStatisticsType(i)
	return
}

func FreeRADIUSStatisticsType_Set(p *radius.Packet, value FreeRADIUSStatisticsType) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 127, a)
}

func FreeRADIUSStatisticsType_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 127)
}

type FreeRADIUSTotalAccessRequests uint32

var FreeRADIUSTotalAccessRequests_Strings = map[FreeRADIUSTotalAccessRequests]string{}

func (a FreeRADIUSTotalAccessRequests) String() string {
	if str, ok := FreeRADIUSTotalAccessRequests_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSTotalAccessRequests(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSTotalAccessRequests_Add(p *radius.Packet, value FreeRADIUSTotalAccessRequests) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 128, a)
}

func FreeRADIUSTotalAccessRequests_Get(p *radius.Packet) (value FreeRADIUSTotalAccessRequests) {
	value, _ = FreeRADIUSTotalAccessRequests_Lookup(p)
	return
}

func FreeRADIUSTotalAccessRequests_Gets(p *radius.Packet) (values []FreeRADIUSTotalAccessRequests, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 128) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSTotalAccessRequests(i))
	}
	return
}

func FreeRADIUSTotalAccessRequests_Lookup(p *radius.Packet) (value FreeRADIUSTotalAccessRequests, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 128)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSTotalAccessRequests(i)
	return
}

func FreeRADIUSTotalAccessRequests_Set(p *radius.Packet, value FreeRADIUSTotalAccessRequests) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 128, a)
}

func FreeRADIUSTotalAccessRequests_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 128)
}

type FreeRADIUSTotalAccessAccepts uint32

var FreeRADIUSTotalAccessAccepts_Strings = map[FreeRADIUSTotalAccessAccepts]string{}

func (a FreeRADIUSTotalAccessAccepts) String() string {
	if str, ok := FreeRADIUSTotalAccessAccepts_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSTotalAccessAccepts(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSTotalAccessAccepts_Add(p *radius.Packet, value FreeRADIUSTotalAccessAccepts) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 129, a)
}

func FreeRADIUSTotalAccessAccepts_Get(p *radius.Packet) (value FreeRADIUSTotalAccessAccepts) {
	value, _ = FreeRADIUSTotalAccessAccepts_Lookup(p)
	return
}

func FreeRADIUSTotalAccessAccepts_Gets(p *radius.Packet) (values []FreeRADIUSTotalAccessAccepts, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 129) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSTotalAccessAccepts(i))
	}
	return
}

func FreeRADIUSTotalAccessAccepts_Lookup(p *radius.Packet) (value FreeRADIUSTotalAccessAccepts, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 129)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSTotalAccessAccepts(i)
	return
}

func FreeRADIUSTotalAccessAccepts_Set(p *radius.Packet, value FreeRADIUSTotalAccessAccepts) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 129, a)
}

func FreeRADIUSTotalAccessAccepts_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 129)
}

type FreeRADIUSTotalAccessRejects uint32

var FreeRADIUSTotalAccessRejects_Strings = map[FreeRADIUSTotalAccessRejects]string{}

func (a FreeRADIUSTotalAccessRejects) String() string {
	if str, ok := FreeRADIUSTotalAccessRejects_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSTotalAccessRejects(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSTotalAccessRejects_Add(p *radius.Packet, value FreeRADIUSTotalAccessRejects) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 130, a)
}

func FreeRADIUSTotalAccessRejects_Get(p *radius.Packet) (value FreeRADIUSTotalAccessRejects) {
	value, _ = FreeRADIUSTotalAccessRejects_Lookup(p)
	return
}

func FreeRADIUSTotalAccessRejects_Gets(p *radius.Packet) (values []FreeRADIUSTotalAccessRejects, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 130) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSTotalAccessRejects(i))
	}
	return
}

func FreeRADIUSTotalAccessRejects_Lookup(p *radius.Packet) (value FreeRADIUSTotalAccessRejects, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 130)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSTotalAccessRejects(i)
	return
}

func FreeRADIUSTotalAccessRejects_Set(p *radius.Packet, value FreeRADIUSTotalAccessRejects) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 130, a)
}

func FreeRADIUSTotalAccessRejects_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 130)
}

type FreeRADIUSTotalAccessChallenges uint32

var FreeRADIUSTotalAccessChallenges_Strings = map[FreeRADIUSTotalAccessChallenges]string{}

func (a FreeRADIUSTotalAccessChallenges) String() string {
	if str, ok := FreeRADIUSTotalAccessChallenges_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSTotalAccessChallenges(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSTotalAccessChallenges_Add(p *radius.Packet, value FreeRADIUSTotalAccessChallenges) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 131, a)
}

func FreeRADIUSTotalAccessChallenges_Get(p *radius.Packet) (value FreeRADIUSTotalAccessChallenges) {
	value, _ = FreeRADIUSTotalAccessChallenges_Lookup(p)
	return
}

func FreeRADIUSTotalAccessChallenges_Gets(p *radius.Packet) (values []FreeRADIUSTotalAccessChallenges, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 131) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSTotalAccessChallenges(i))
	}
	return
}

func FreeRADIUSTotalAccessChallenges_Lookup(p *radius.Packet) (value FreeRADIUSTotalAccessChallenges, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 131)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSTotalAccessChallenges(i)
	return
}

func FreeRADIUSTotalAccessChallenges_Set(p *radius.Packet, value FreeRADIUSTotalAccessChallenges) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 131, a)
}

func FreeRADIUSTotalAccessChallenges_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 131)
}

type FreeRADIUSTotalAuthResponses uint32

var FreeRADIUSTotalAuthResponses_Strings = map[FreeRADIUSTotalAuthResponses]string{}

func (a FreeRADIUSTotalAuthResponses) String() string {
	if str, ok := FreeRADIUSTotalAuthResponses_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSTotalAuthResponses(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSTotalAuthResponses_Add(p *radius.Packet, value FreeRADIUSTotalAuthResponses) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 132, a)
}

func FreeRADIUSTotalAuthResponses_Get(p *radius.Packet) (value FreeRADIUSTotalAuthResponses) {
	value, _ = FreeRADIUSTotalAuthResponses_Lookup(p)
	return
}

func FreeRADIUSTotalAuthResponses_Gets(p *radius.Packet) (values []FreeRADIUSTotalAuthResponses, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 132) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSTotalAuthResponses(i))
	}
	return
}

func FreeRADIUSTotalAuthResponses_Lookup(p *radius.Packet) (value FreeRADIUSTotalAuthResponses, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 132)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSTotalAuthResponses(i)
	return
}

func FreeRADIUSTotalAuthResponses_Set(p *radius.Packet, value FreeRADIUSTotalAuthResponses) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 132, a)
}

func FreeRADIUSTotalAuthResponses_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 132)
}

type FreeRADIUSTotalAuthDuplicateRequests uint32

var FreeRADIUSTotalAuthDuplicateRequests_Strings = map[FreeRADIUSTotalAuthDuplicateRequests]string{}

func (a FreeRADIUSTotalAuthDuplicateRequests) String() string {
	if str, ok := FreeRADIUSTotalAuthDuplicateRequests_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSTotalAuthDuplicateRequests(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSTotalAuthDuplicateRequests_Add(p *radius.Packet, value FreeRADIUSTotalAuthDuplicateRequests) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 133, a)
}

func FreeRADIUSTotalAuthDuplicateRequests_Get(p *radius.Packet) (value FreeRADIUSTotalAuthDuplicateRequests) {
	value, _ = FreeRADIUSTotalAuthDuplicateRequests_Lookup(p)
	return
}

func FreeRADIUSTotalAuthDuplicateRequests_Gets(p *radius.Packet) (values []FreeRADIUSTotalAuthDuplicateRequests, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 133) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSTotalAuthDuplicateRequests(i))
	}
	return
}

func FreeRADIUSTotalAuthDuplicateRequests_Lookup(p *radius.Packet) (value FreeRADIUSTotalAuthDuplicateRequests, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 133)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSTotalAuthDuplicateRequests(i)
	return
}

func FreeRADIUSTotalAuthDuplicateRequests_Set(p *radius.Packet, value FreeRADIUSTotalAuthDuplicateRequests) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 133, a)
}

func FreeRADIUSTotalAuthDuplicateRequests_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 133)
}

type FreeRADIUSTotalAuthMalformedRequests uint32

var FreeRADIUSTotalAuthMalformedRequests_Strings = map[FreeRADIUSTotalAuthMalformedRequests]string{}

func (a FreeRADIUSTotalAuthMalformedRequests) String() string {
	if str, ok := FreeRADIUSTotalAuthMalformedRequests_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSTotalAuthMalformedRequests(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSTotalAuthMalformedRequests_Add(p *radius.Packet, value FreeRADIUSTotalAuthMalformedRequests) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 134, a)
}

func FreeRADIUSTotalAuthMalformedRequests_Get(p *radius.Packet) (value FreeRADIUSTotalAuthMalformedRequests) {
	value, _ = FreeRADIUSTotalAuthMalformedRequests_Lookup(p)
	return
}

func FreeRADIUSTotalAuthMalformedRequests_Gets(p *radius.Packet) (values []FreeRADIUSTotalAuthMalformedRequests, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 134) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSTotalAuthMalformedRequests(i))
	}
	return
}

func FreeRADIUSTotalAuthMalformedRequests_Lookup(p *radius.Packet) (value FreeRADIUSTotalAuthMalformedRequests, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 134)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSTotalAuthMalformedRequests(i)
	return
}

func FreeRADIUSTotalAuthMalformedRequests_Set(p *radius.Packet, value FreeRADIUSTotalAuthMalformedRequests) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 134, a)
}

func FreeRADIUSTotalAuthMalformedRequests_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 134)
}

type FreeRADIUSTotalAuthInvalidRequests uint32

var FreeRADIUSTotalAuthInvalidRequests_Strings = map[FreeRADIUSTotalAuthInvalidRequests]string{}

func (a FreeRADIUSTotalAuthInvalidRequests) String() string {
	if str, ok := FreeRADIUSTotalAuthInvalidRequests_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSTotalAuthInvalidRequests(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSTotalAuthInvalidRequests_Add(p *radius.Packet, value FreeRADIUSTotalAuthInvalidRequests) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 135, a)
}

func FreeRADIUSTotalAuthInvalidRequests_Get(p *radius.Packet) (value FreeRADIUSTotalAuthInvalidRequests) {
	value, _ = FreeRADIUSTotalAuthInvalidRequests_Lookup(p)
	return
}

func FreeRADIUSTotalAuthInvalidRequests_Gets(p *radius.Packet) (values []FreeRADIUSTotalAuthInvalidRequests, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 135) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSTotalAuthInvalidRequests(i))
	}
	return
}

func FreeRADIUSTotalAuthInvalidRequests_Lookup(p *radius.Packet) (value FreeRADIUSTotalAuthInvalidRequests, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 135)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSTotalAuthInvalidRequests(i)
	return
}

func FreeRADIUSTotalAuthInvalidRequests_Set(p *radius.Packet, value FreeRADIUSTotalAuthInvalidRequests) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 135, a)
}

func FreeRADIUSTotalAuthInvalidRequests_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 135)
}

type FreeRADIUSTotalAuthDroppedRequests uint32

var FreeRADIUSTotalAuthDroppedRequests_Strings = map[FreeRADIUSTotalAuthDroppedRequests]string{}

func (a FreeRADIUSTotalAuthDroppedRequests) String() string {
	if str, ok := FreeRADIUSTotalAuthDroppedRequests_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSTotalAuthDroppedRequests(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSTotalAuthDroppedRequests_Add(p *radius.Packet, value FreeRADIUSTotalAuthDroppedRequests) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 136, a)
}

func FreeRADIUSTotalAuthDroppedRequests_Get(p *radius.Packet) (value FreeRADIUSTotalAuthDroppedRequests) {
	value, _ = FreeRADIUSTotalAuthDroppedRequests_Lookup(p)
	return
}

func FreeRADIUSTotalAuthDroppedRequests_Gets(p *radius.Packet) (values []FreeRADIUSTotalAuthDroppedRequests, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 136) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSTotalAuthDroppedRequests(i))
	}
	return
}

func FreeRADIUSTotalAuthDroppedRequests_Lookup(p *radius.Packet) (value FreeRADIUSTotalAuthDroppedRequests, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 136)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSTotalAuthDroppedRequests(i)
	return
}

func FreeRADIUSTotalAuthDroppedRequests_Set(p *radius.Packet, value FreeRADIUSTotalAuthDroppedRequests) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 136, a)
}

func FreeRADIUSTotalAuthDroppedRequests_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 136)
}

type FreeRADIUSTotalAuthUnknownTypes uint32

var FreeRADIUSTotalAuthUnknownTypes_Strings = map[FreeRADIUSTotalAuthUnknownTypes]string{}

func (a FreeRADIUSTotalAuthUnknownTypes) String() string {
	if str, ok := FreeRADIUSTotalAuthUnknownTypes_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSTotalAuthUnknownTypes(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSTotalAuthUnknownTypes_Add(p *radius.Packet, value FreeRADIUSTotalAuthUnknownTypes) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 137, a)
}

func FreeRADIUSTotalAuthUnknownTypes_Get(p *radius.Packet) (value FreeRADIUSTotalAuthUnknownTypes) {
	value, _ = FreeRADIUSTotalAuthUnknownTypes_Lookup(p)
	return
}

func FreeRADIUSTotalAuthUnknownTypes_Gets(p *radius.Packet) (values []FreeRADIUSTotalAuthUnknownTypes, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 137) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSTotalAuthUnknownTypes(i))
	}
	return
}

func FreeRADIUSTotalAuthUnknownTypes_Lookup(p *radius.Packet) (value FreeRADIUSTotalAuthUnknownTypes, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 137)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSTotalAuthUnknownTypes(i)
	return
}

func FreeRADIUSTotalAuthUnknownTypes_Set(p *radius.Packet, value FreeRADIUSTotalAuthUnknownTypes) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 137, a)
}

func FreeRADIUSTotalAuthUnknownTypes_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 137)
}

type FreeRADIUSTotalProxyAccessRequests uint32

var FreeRADIUSTotalProxyAccessRequests_Strings = map[FreeRADIUSTotalProxyAccessRequests]string{}

func (a FreeRADIUSTotalProxyAccessRequests) String() string {
	if str, ok := FreeRADIUSTotalProxyAccessRequests_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSTotalProxyAccessRequests(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSTotalProxyAccessRequests_Add(p *radius.Packet, value FreeRADIUSTotalProxyAccessRequests) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 138, a)
}

func FreeRADIUSTotalProxyAccessRequests_Get(p *radius.Packet) (value FreeRADIUSTotalProxyAccessRequests) {
	value, _ = FreeRADIUSTotalProxyAccessRequests_Lookup(p)
	return
}

func FreeRADIUSTotalProxyAccessRequests_Gets(p *radius.Packet) (values []FreeRADIUSTotalProxyAccessRequests, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 138) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSTotalProxyAccessRequests(i))
	}
	return
}

func FreeRADIUSTotalProxyAccessRequests_Lookup(p *radius.Packet) (value FreeRADIUSTotalProxyAccessRequests, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 138)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSTotalProxyAccessRequests(i)
	return
}

func FreeRADIUSTotalProxyAccessRequests_Set(p *radius.Packet, value FreeRADIUSTotalProxyAccessRequests) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 138, a)
}

func FreeRADIUSTotalProxyAccessRequests_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 138)
}

type FreeRADIUSTotalProxyAccessAccepts uint32

var FreeRADIUSTotalProxyAccessAccepts_Strings = map[FreeRADIUSTotalProxyAccessAccepts]string{}

func (a FreeRADIUSTotalProxyAccessAccepts) String() string {
	if str, ok := FreeRADIUSTotalProxyAccessAccepts_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSTotalProxyAccessAccepts(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSTotalProxyAccessAccepts_Add(p *radius.Packet, value FreeRADIUSTotalProxyAccessAccepts) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 139, a)
}

func FreeRADIUSTotalProxyAccessAccepts_Get(p *radius.Packet) (value FreeRADIUSTotalProxyAccessAccepts) {
	value, _ = FreeRADIUSTotalProxyAccessAccepts_Lookup(p)
	return
}

func FreeRADIUSTotalProxyAccessAccepts_Gets(p *radius.Packet) (values []FreeRADIUSTotalProxyAccessAccepts, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 139) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSTotalProxyAccessAccepts(i))
	}
	return
}

func FreeRADIUSTotalProxyAccessAccepts_Lookup(p *radius.Packet) (value FreeRADIUSTotalProxyAccessAccepts, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 139)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSTotalProxyAccessAccepts(i)
	return
}

func FreeRADIUSTotalProxyAccessAccepts_Set(p *radius.Packet, value FreeRADIUSTotalProxyAccessAccepts) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 139, a)
}

func FreeRADIUSTotalProxyAccessAccepts_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 139)
}

type FreeRADIUSTotalProxyAccessRejects uint32

var FreeRADIUSTotalProxyAccessRejects_Strings = map[FreeRADIUSTotalProxyAccessRejects]string{}

func (a FreeRADIUSTotalProxyAccessRejects) String() string {
	if str, ok := FreeRADIUSTotalProxyAccessRejects_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSTotalProxyAccessRejects(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSTotalProxyAccessRejects_Add(p *radius.Packet, value FreeRADIUSTotalProxyAccessRejects) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 140, a)
}

func FreeRADIUSTotalProxyAccessRejects_Get(p *radius.Packet) (value FreeRADIUSTotalProxyAccessRejects) {
	value, _ = FreeRADIUSTotalProxyAccessRejects_Lookup(p)
	return
}

func FreeRADIUSTotalProxyAccessRejects_Gets(p *radius.Packet) (values []FreeRADIUSTotalProxyAccessRejects, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 140) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSTotalProxyAccessRejects(i))
	}
	return
}

func FreeRADIUSTotalProxyAccessRejects_Lookup(p *radius.Packet) (value FreeRADIUSTotalProxyAccessRejects, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 140)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSTotalProxyAccessRejects(i)
	return
}

func FreeRADIUSTotalProxyAccessRejects_Set(p *radius.Packet, value FreeRADIUSTotalProxyAccessRejects) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 140, a)
}

func FreeRADIUSTotalProxyAccessRejects_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 140)
}

type FreeRADIUSTotalProxyAccessChallenges uint32

var FreeRADIUSTotalProxyAccessChallenges_Strings = map[FreeRADIUSTotalProxyAccessChallenges]string{}

func (a FreeRADIUSTotalProxyAccessChallenges) String() string {
	if str, ok := FreeRADIUSTotalProxyAccessChallenges_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSTotalProxyAccessChallenges(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSTotalProxyAccessChallenges_Add(p *radius.Packet, value FreeRADIUSTotalProxyAccessChallenges) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 141, a)
}

func FreeRADIUSTotalProxyAccessChallenges_Get(p *radius.Packet) (value FreeRADIUSTotalProxyAccessChallenges) {
	value, _ = FreeRADIUSTotalProxyAccessChallenges_Lookup(p)
	return
}

func FreeRADIUSTotalProxyAccessChallenges_Gets(p *radius.Packet) (values []FreeRADIUSTotalProxyAccessChallenges, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 141) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSTotalProxyAccessChallenges(i))
	}
	return
}

func FreeRADIUSTotalProxyAccessChallenges_Lookup(p *radius.Packet) (value FreeRADIUSTotalProxyAccessChallenges, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 141)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSTotalProxyAccessChallenges(i)
	return
}

func FreeRADIUSTotalProxyAccessChallenges_Set(p *radius.Packet, value FreeRADIUSTotalProxyAccessChallenges) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 141, a)
}

func FreeRADIUSTotalProxyAccessChallenges_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 141)
}

type FreeRADIUSTotalProxyAuthResponses uint32

var FreeRADIUSTotalProxyAuthResponses_Strings = map[FreeRADIUSTotalProxyAuthResponses]string{}

func (a FreeRADIUSTotalProxyAuthResponses) String() string {
	if str, ok := FreeRADIUSTotalProxyAuthResponses_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSTotalProxyAuthResponses(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSTotalProxyAuthResponses_Add(p *radius.Packet, value FreeRADIUSTotalProxyAuthResponses) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 142, a)
}

func FreeRADIUSTotalProxyAuthResponses_Get(p *radius.Packet) (value FreeRADIUSTotalProxyAuthResponses) {
	value, _ = FreeRADIUSTotalProxyAuthResponses_Lookup(p)
	return
}

func FreeRADIUSTotalProxyAuthResponses_Gets(p *radius.Packet) (values []FreeRADIUSTotalProxyAuthResponses, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 142) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSTotalProxyAuthResponses(i))
	}
	return
}

func FreeRADIUSTotalProxyAuthResponses_Lookup(p *radius.Packet) (value FreeRADIUSTotalProxyAuthResponses, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 142)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSTotalProxyAuthResponses(i)
	return
}

func FreeRADIUSTotalProxyAuthResponses_Set(p *radius.Packet, value FreeRADIUSTotalProxyAuthResponses) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 142, a)
}

func FreeRADIUSTotalProxyAuthResponses_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 142)
}

type FreeRADIUSTotalProxyAuthDuplicateRequests uint32

var FreeRADIUSTotalProxyAuthDuplicateRequests_Strings = map[FreeRADIUSTotalProxyAuthDuplicateRequests]string{}

func (a FreeRADIUSTotalProxyAuthDuplicateRequests) String() string {
	if str, ok := FreeRADIUSTotalProxyAuthDuplicateRequests_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSTotalProxyAuthDuplicateRequests(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSTotalProxyAuthDuplicateRequests_Add(p *radius.Packet, value FreeRADIUSTotalProxyAuthDuplicateRequests) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 143, a)
}

func FreeRADIUSTotalProxyAuthDuplicateRequests_Get(p *radius.Packet) (value FreeRADIUSTotalProxyAuthDuplicateRequests) {
	value, _ = FreeRADIUSTotalProxyAuthDuplicateRequests_Lookup(p)
	return
}

func FreeRADIUSTotalProxyAuthDuplicateRequests_Gets(p *radius.Packet) (values []FreeRADIUSTotalProxyAuthDuplicateRequests, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 143) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSTotalProxyAuthDuplicateRequests(i))
	}
	return
}

func FreeRADIUSTotalProxyAuthDuplicateRequests_Lookup(p *radius.Packet) (value FreeRADIUSTotalProxyAuthDuplicateRequests, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 143)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSTotalProxyAuthDuplicateRequests(i)
	return
}

func FreeRADIUSTotalProxyAuthDuplicateRequests_Set(p *radius.Packet, value FreeRADIUSTotalProxyAuthDuplicateRequests) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 143, a)
}

func FreeRADIUSTotalProxyAuthDuplicateRequests_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 143)
}

type FreeRADIUSTotalProxyAuthMalformedRequests uint32

var FreeRADIUSTotalProxyAuthMalformedRequests_Strings = map[FreeRADIUSTotalProxyAuthMalformedRequests]string{}

func (a FreeRADIUSTotalProxyAuthMalformedRequests) String() string {
	if str, ok := FreeRADIUSTotalProxyAuthMalformedRequests_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSTotalProxyAuthMalformedRequests(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSTotalProxyAuthMalformedRequests_Add(p *radius.Packet, value FreeRADIUSTotalProxyAuthMalformedRequests) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 144, a)
}

func FreeRADIUSTotalProxyAuthMalformedRequests_Get(p *radius.Packet) (value FreeRADIUSTotalProxyAuthMalformedRequests) {
	value, _ = FreeRADIUSTotalProxyAuthMalformedRequests_Lookup(p)
	return
}

func FreeRADIUSTotalProxyAuthMalformedRequests_Gets(p *radius.Packet) (values []FreeRADIUSTotalProxyAuthMalformedRequests, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 144) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSTotalProxyAuthMalformedRequests(i))
	}
	return
}

func FreeRADIUSTotalProxyAuthMalformedRequests_Lookup(p *radius.Packet) (value FreeRADIUSTotalProxyAuthMalformedRequests, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 144)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSTotalProxyAuthMalformedRequests(i)
	return
}

func FreeRADIUSTotalProxyAuthMalformedRequests_Set(p *radius.Packet, value FreeRADIUSTotalProxyAuthMalformedRequests) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 144, a)
}

func FreeRADIUSTotalProxyAuthMalformedRequests_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 144)
}

type FreeRADIUSTotalProxyAuthInvalidRequests uint32

var FreeRADIUSTotalProxyAuthInvalidRequests_Strings = map[FreeRADIUSTotalProxyAuthInvalidRequests]string{}

func (a FreeRADIUSTotalProxyAuthInvalidRequests) String() string {
	if str, ok := FreeRADIUSTotalProxyAuthInvalidRequests_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSTotalProxyAuthInvalidRequests(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSTotalProxyAuthInvalidRequests_Add(p *radius.Packet, value FreeRADIUSTotalProxyAuthInvalidRequests) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 145, a)
}

func FreeRADIUSTotalProxyAuthInvalidRequests_Get(p *radius.Packet) (value FreeRADIUSTotalProxyAuthInvalidRequests) {
	value, _ = FreeRADIUSTotalProxyAuthInvalidRequests_Lookup(p)
	return
}

func FreeRADIUSTotalProxyAuthInvalidRequests_Gets(p *radius.Packet) (values []FreeRADIUSTotalProxyAuthInvalidRequests, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 145) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSTotalProxyAuthInvalidRequests(i))
	}
	return
}

func FreeRADIUSTotalProxyAuthInvalidRequests_Lookup(p *radius.Packet) (value FreeRADIUSTotalProxyAuthInvalidRequests, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 145)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSTotalProxyAuthInvalidRequests(i)
	return
}

func FreeRADIUSTotalProxyAuthInvalidRequests_Set(p *radius.Packet, value FreeRADIUSTotalProxyAuthInvalidRequests) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 145, a)
}

func FreeRADIUSTotalProxyAuthInvalidRequests_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 145)
}

type FreeRADIUSTotalProxyAuthDroppedRequests uint32

var FreeRADIUSTotalProxyAuthDroppedRequests_Strings = map[FreeRADIUSTotalProxyAuthDroppedRequests]string{}

func (a FreeRADIUSTotalProxyAuthDroppedRequests) String() string {
	if str, ok := FreeRADIUSTotalProxyAuthDroppedRequests_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSTotalProxyAuthDroppedRequests(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSTotalProxyAuthDroppedRequests_Add(p *radius.Packet, value FreeRADIUSTotalProxyAuthDroppedRequests) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 146, a)
}

func FreeRADIUSTotalProxyAuthDroppedRequests_Get(p *radius.Packet) (value FreeRADIUSTotalProxyAuthDroppedRequests) {
	value, _ = FreeRADIUSTotalProxyAuthDroppedRequests_Lookup(p)
	return
}

func FreeRADIUSTotalProxyAuthDroppedRequests_Gets(p *radius.Packet) (values []FreeRADIUSTotalProxyAuthDroppedRequests, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 146) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSTotalProxyAuthDroppedRequests(i))
	}
	return
}

func FreeRADIUSTotalProxyAuthDroppedRequests_Lookup(p *radius.Packet) (value FreeRADIUSTotalProxyAuthDroppedRequests, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 146)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSTotalProxyAuthDroppedRequests(i)
	return
}

func FreeRADIUSTotalProxyAuthDroppedRequests_Set(p *radius.Packet, value FreeRADIUSTotalProxyAuthDroppedRequests) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 146, a)
}

func FreeRADIUSTotalProxyAuthDroppedRequests_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 146)
}

type FreeRADIUSTotalProxyAuthUnknownTypes uint32

var FreeRADIUSTotalProxyAuthUnknownTypes_Strings = map[FreeRADIUSTotalProxyAuthUnknownTypes]string{}

func (a FreeRADIUSTotalProxyAuthUnknownTypes) String() string {
	if str, ok := FreeRADIUSTotalProxyAuthUnknownTypes_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSTotalProxyAuthUnknownTypes(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSTotalProxyAuthUnknownTypes_Add(p *radius.Packet, value FreeRADIUSTotalProxyAuthUnknownTypes) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 147, a)
}

func FreeRADIUSTotalProxyAuthUnknownTypes_Get(p *radius.Packet) (value FreeRADIUSTotalProxyAuthUnknownTypes) {
	value, _ = FreeRADIUSTotalProxyAuthUnknownTypes_Lookup(p)
	return
}

func FreeRADIUSTotalProxyAuthUnknownTypes_Gets(p *radius.Packet) (values []FreeRADIUSTotalProxyAuthUnknownTypes, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 147) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSTotalProxyAuthUnknownTypes(i))
	}
	return
}

func FreeRADIUSTotalProxyAuthUnknownTypes_Lookup(p *radius.Packet) (value FreeRADIUSTotalProxyAuthUnknownTypes, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 147)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSTotalProxyAuthUnknownTypes(i)
	return
}

func FreeRADIUSTotalProxyAuthUnknownTypes_Set(p *radius.Packet, value FreeRADIUSTotalProxyAuthUnknownTypes) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 147, a)
}

func FreeRADIUSTotalProxyAuthUnknownTypes_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 147)
}

type FreeRADIUSTotalAccountingRequests uint32

var FreeRADIUSTotalAccountingRequests_Strings = map[FreeRADIUSTotalAccountingRequests]string{}

func (a FreeRADIUSTotalAccountingRequests) String() string {
	if str, ok := FreeRADIUSTotalAccountingRequests_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSTotalAccountingRequests(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSTotalAccountingRequests_Add(p *radius.Packet, value FreeRADIUSTotalAccountingRequests) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 148, a)
}

func FreeRADIUSTotalAccountingRequests_Get(p *radius.Packet) (value FreeRADIUSTotalAccountingRequests) {
	value, _ = FreeRADIUSTotalAccountingRequests_Lookup(p)
	return
}

func FreeRADIUSTotalAccountingRequests_Gets(p *radius.Packet) (values []FreeRADIUSTotalAccountingRequests, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 148) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSTotalAccountingRequests(i))
	}
	return
}

func FreeRADIUSTotalAccountingRequests_Lookup(p *radius.Packet) (value FreeRADIUSTotalAccountingRequests, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 148)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSTotalAccountingRequests(i)
	return
}

func FreeRADIUSTotalAccountingRequests_Set(p *radius.Packet, value FreeRADIUSTotalAccountingRequests) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 148, a)
}

func FreeRADIUSTotalAccountingRequests_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 148)
}

type FreeRADIUSTotalAccountingResponses uint32

var FreeRADIUSTotalAccountingResponses_Strings = map[FreeRADIUSTotalAccountingResponses]string{}

func (a FreeRADIUSTotalAccountingResponses) String() string {
	if str, ok := FreeRADIUSTotalAccountingResponses_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSTotalAccountingResponses(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSTotalAccountingResponses_Add(p *radius.Packet, value FreeRADIUSTotalAccountingResponses) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 149, a)
}

func FreeRADIUSTotalAccountingResponses_Get(p *radius.Packet) (value FreeRADIUSTotalAccountingResponses) {
	value, _ = FreeRADIUSTotalAccountingResponses_Lookup(p)
	return
}

func FreeRADIUSTotalAccountingResponses_Gets(p *radius.Packet) (values []FreeRADIUSTotalAccountingResponses, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 149) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSTotalAccountingResponses(i))
	}
	return
}

func FreeRADIUSTotalAccountingResponses_Lookup(p *radius.Packet) (value FreeRADIUSTotalAccountingResponses, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 149)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSTotalAccountingResponses(i)
	return
}

func FreeRADIUSTotalAccountingResponses_Set(p *radius.Packet, value FreeRADIUSTotalAccountingResponses) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 149, a)
}

func FreeRADIUSTotalAccountingResponses_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 149)
}

type FreeRADIUSTotalAcctDuplicateRequests uint32

var FreeRADIUSTotalAcctDuplicateRequests_Strings = map[FreeRADIUSTotalAcctDuplicateRequests]string{}

func (a FreeRADIUSTotalAcctDuplicateRequests) String() string {
	if str, ok := FreeRADIUSTotalAcctDuplicateRequests_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSTotalAcctDuplicateRequests(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSTotalAcctDuplicateRequests_Add(p *radius.Packet, value FreeRADIUSTotalAcctDuplicateRequests) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 150, a)
}

func FreeRADIUSTotalAcctDuplicateRequests_Get(p *radius.Packet) (value FreeRADIUSTotalAcctDuplicateRequests) {
	value, _ = FreeRADIUSTotalAcctDuplicateRequests_Lookup(p)
	return
}

func FreeRADIUSTotalAcctDuplicateRequests_Gets(p *radius.Packet) (values []FreeRADIUSTotalAcctDuplicateRequests, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 150) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSTotalAcctDuplicateRequests(i))
	}
	return
}

func FreeRADIUSTotalAcctDuplicateRequests_Lookup(p *radius.Packet) (value FreeRADIUSTotalAcctDuplicateRequests, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 150)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSTotalAcctDuplicateRequests(i)
	return
}

func FreeRADIUSTotalAcctDuplicateRequests_Set(p *radius.Packet, value FreeRADIUSTotalAcctDuplicateRequests) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 150, a)
}

func FreeRADIUSTotalAcctDuplicateRequests_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 150)
}

type FreeRADIUSTotalAcctMalformedRequests uint32

var FreeRADIUSTotalAcctMalformedRequests_Strings = map[FreeRADIUSTotalAcctMalformedRequests]string{}

func (a FreeRADIUSTotalAcctMalformedRequests) String() string {
	if str, ok := FreeRADIUSTotalAcctMalformedRequests_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSTotalAcctMalformedRequests(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSTotalAcctMalformedRequests_Add(p *radius.Packet, value FreeRADIUSTotalAcctMalformedRequests) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 151, a)
}

func FreeRADIUSTotalAcctMalformedRequests_Get(p *radius.Packet) (value FreeRADIUSTotalAcctMalformedRequests) {
	value, _ = FreeRADIUSTotalAcctMalformedRequests_Lookup(p)
	return
}

func FreeRADIUSTotalAcctMalformedRequests_Gets(p *radius.Packet) (values []FreeRADIUSTotalAcctMalformedRequests, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 151) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSTotalAcctMalformedRequests(i))
	}
	return
}

func FreeRADIUSTotalAcctMalformedRequests_Lookup(p *radius.Packet) (value FreeRADIUSTotalAcctMalformedRequests, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 151)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSTotalAcctMalformedRequests(i)
	return
}

func FreeRADIUSTotalAcctMalformedRequests_Set(p *radius.Packet, value FreeRADIUSTotalAcctMalformedRequests) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 151, a)
}

func FreeRADIUSTotalAcctMalformedRequests_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 151)
}

type FreeRADIUSTotalAcctInvalidRequests uint32

var FreeRADIUSTotalAcctInvalidRequests_Strings = map[FreeRADIUSTotalAcctInvalidRequests]string{}

func (a FreeRADIUSTotalAcctInvalidRequests) String() string {
	if str, ok := FreeRADIUSTotalAcctInvalidRequests_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSTotalAcctInvalidRequests(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSTotalAcctInvalidRequests_Add(p *radius.Packet, value FreeRADIUSTotalAcctInvalidRequests) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 152, a)
}

func FreeRADIUSTotalAcctInvalidRequests_Get(p *radius.Packet) (value FreeRADIUSTotalAcctInvalidRequests) {
	value, _ = FreeRADIUSTotalAcctInvalidRequests_Lookup(p)
	return
}

func FreeRADIUSTotalAcctInvalidRequests_Gets(p *radius.Packet) (values []FreeRADIUSTotalAcctInvalidRequests, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 152) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSTotalAcctInvalidRequests(i))
	}
	return
}

func FreeRADIUSTotalAcctInvalidRequests_Lookup(p *radius.Packet) (value FreeRADIUSTotalAcctInvalidRequests, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 152)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSTotalAcctInvalidRequests(i)
	return
}

func FreeRADIUSTotalAcctInvalidRequests_Set(p *radius.Packet, value FreeRADIUSTotalAcctInvalidRequests) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 152, a)
}

func FreeRADIUSTotalAcctInvalidRequests_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 152)
}

type FreeRADIUSTotalAcctDroppedRequests uint32

var FreeRADIUSTotalAcctDroppedRequests_Strings = map[FreeRADIUSTotalAcctDroppedRequests]string{}

func (a FreeRADIUSTotalAcctDroppedRequests) String() string {
	if str, ok := FreeRADIUSTotalAcctDroppedRequests_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSTotalAcctDroppedRequests(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSTotalAcctDroppedRequests_Add(p *radius.Packet, value FreeRADIUSTotalAcctDroppedRequests) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 153, a)
}

func FreeRADIUSTotalAcctDroppedRequests_Get(p *radius.Packet) (value FreeRADIUSTotalAcctDroppedRequests) {
	value, _ = FreeRADIUSTotalAcctDroppedRequests_Lookup(p)
	return
}

func FreeRADIUSTotalAcctDroppedRequests_Gets(p *radius.Packet) (values []FreeRADIUSTotalAcctDroppedRequests, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 153) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSTotalAcctDroppedRequests(i))
	}
	return
}

func FreeRADIUSTotalAcctDroppedRequests_Lookup(p *radius.Packet) (value FreeRADIUSTotalAcctDroppedRequests, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 153)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSTotalAcctDroppedRequests(i)
	return
}

func FreeRADIUSTotalAcctDroppedRequests_Set(p *radius.Packet, value FreeRADIUSTotalAcctDroppedRequests) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 153, a)
}

func FreeRADIUSTotalAcctDroppedRequests_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 153)
}

type FreeRADIUSTotalAcctUnknownTypes uint32

var FreeRADIUSTotalAcctUnknownTypes_Strings = map[FreeRADIUSTotalAcctUnknownTypes]string{}

func (a FreeRADIUSTotalAcctUnknownTypes) String() string {
	if str, ok := FreeRADIUSTotalAcctUnknownTypes_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSTotalAcctUnknownTypes(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSTotalAcctUnknownTypes_Add(p *radius.Packet, value FreeRADIUSTotalAcctUnknownTypes) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 154, a)
}

func FreeRADIUSTotalAcctUnknownTypes_Get(p *radius.Packet) (value FreeRADIUSTotalAcctUnknownTypes) {
	value, _ = FreeRADIUSTotalAcctUnknownTypes_Lookup(p)
	return
}

func FreeRADIUSTotalAcctUnknownTypes_Gets(p *radius.Packet) (values []FreeRADIUSTotalAcctUnknownTypes, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 154) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSTotalAcctUnknownTypes(i))
	}
	return
}

func FreeRADIUSTotalAcctUnknownTypes_Lookup(p *radius.Packet) (value FreeRADIUSTotalAcctUnknownTypes, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 154)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSTotalAcctUnknownTypes(i)
	return
}

func FreeRADIUSTotalAcctUnknownTypes_Set(p *radius.Packet, value FreeRADIUSTotalAcctUnknownTypes) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 154, a)
}

func FreeRADIUSTotalAcctUnknownTypes_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 154)
}

type FreeRADIUSTotalProxyAccountingRequests uint32

var FreeRADIUSTotalProxyAccountingRequests_Strings = map[FreeRADIUSTotalProxyAccountingRequests]string{}

func (a FreeRADIUSTotalProxyAccountingRequests) String() string {
	if str, ok := FreeRADIUSTotalProxyAccountingRequests_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSTotalProxyAccountingRequests(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSTotalProxyAccountingRequests_Add(p *radius.Packet, value FreeRADIUSTotalProxyAccountingRequests) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 155, a)
}

func FreeRADIUSTotalProxyAccountingRequests_Get(p *radius.Packet) (value FreeRADIUSTotalProxyAccountingRequests) {
	value, _ = FreeRADIUSTotalProxyAccountingRequests_Lookup(p)
	return
}

func FreeRADIUSTotalProxyAccountingRequests_Gets(p *radius.Packet) (values []FreeRADIUSTotalProxyAccountingRequests, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 155) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSTotalProxyAccountingRequests(i))
	}
	return
}

func FreeRADIUSTotalProxyAccountingRequests_Lookup(p *radius.Packet) (value FreeRADIUSTotalProxyAccountingRequests, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 155)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSTotalProxyAccountingRequests(i)
	return
}

func FreeRADIUSTotalProxyAccountingRequests_Set(p *radius.Packet, value FreeRADIUSTotalProxyAccountingRequests) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 155, a)
}

func FreeRADIUSTotalProxyAccountingRequests_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 155)
}

type FreeRADIUSTotalProxyAccountingResponses uint32

var FreeRADIUSTotalProxyAccountingResponses_Strings = map[FreeRADIUSTotalProxyAccountingResponses]string{}

func (a FreeRADIUSTotalProxyAccountingResponses) String() string {
	if str, ok := FreeRADIUSTotalProxyAccountingResponses_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSTotalProxyAccountingResponses(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSTotalProxyAccountingResponses_Add(p *radius.Packet, value FreeRADIUSTotalProxyAccountingResponses) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 156, a)
}

func FreeRADIUSTotalProxyAccountingResponses_Get(p *radius.Packet) (value FreeRADIUSTotalProxyAccountingResponses) {
	value, _ = FreeRADIUSTotalProxyAccountingResponses_Lookup(p)
	return
}

func FreeRADIUSTotalProxyAccountingResponses_Gets(p *radius.Packet) (values []FreeRADIUSTotalProxyAccountingResponses, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 156) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSTotalProxyAccountingResponses(i))
	}
	return
}

func FreeRADIUSTotalProxyAccountingResponses_Lookup(p *radius.Packet) (value FreeRADIUSTotalProxyAccountingResponses, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 156)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSTotalProxyAccountingResponses(i)
	return
}

func FreeRADIUSTotalProxyAccountingResponses_Set(p *radius.Packet, value FreeRADIUSTotalProxyAccountingResponses) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 156, a)
}

func FreeRADIUSTotalProxyAccountingResponses_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 156)
}

type FreeRADIUSTotalProxyAcctDuplicateRequests uint32

var FreeRADIUSTotalProxyAcctDuplicateRequests_Strings = map[FreeRADIUSTotalProxyAcctDuplicateRequests]string{}

func (a FreeRADIUSTotalProxyAcctDuplicateRequests) String() string {
	if str, ok := FreeRADIUSTotalProxyAcctDuplicateRequests_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSTotalProxyAcctDuplicateRequests(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSTotalProxyAcctDuplicateRequests_Add(p *radius.Packet, value FreeRADIUSTotalProxyAcctDuplicateRequests) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 157, a)
}

func FreeRADIUSTotalProxyAcctDuplicateRequests_Get(p *radius.Packet) (value FreeRADIUSTotalProxyAcctDuplicateRequests) {
	value, _ = FreeRADIUSTotalProxyAcctDuplicateRequests_Lookup(p)
	return
}

func FreeRADIUSTotalProxyAcctDuplicateRequests_Gets(p *radius.Packet) (values []FreeRADIUSTotalProxyAcctDuplicateRequests, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 157) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSTotalProxyAcctDuplicateRequests(i))
	}
	return
}

func FreeRADIUSTotalProxyAcctDuplicateRequests_Lookup(p *radius.Packet) (value FreeRADIUSTotalProxyAcctDuplicateRequests, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 157)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSTotalProxyAcctDuplicateRequests(i)
	return
}

func FreeRADIUSTotalProxyAcctDuplicateRequests_Set(p *radius.Packet, value FreeRADIUSTotalProxyAcctDuplicateRequests) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 157, a)
}

func FreeRADIUSTotalProxyAcctDuplicateRequests_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 157)
}

type FreeRADIUSTotalProxyAcctMalformedRequests uint32

var FreeRADIUSTotalProxyAcctMalformedRequests_Strings = map[FreeRADIUSTotalProxyAcctMalformedRequests]string{}

func (a FreeRADIUSTotalProxyAcctMalformedRequests) String() string {
	if str, ok := FreeRADIUSTotalProxyAcctMalformedRequests_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSTotalProxyAcctMalformedRequests(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSTotalProxyAcctMalformedRequests_Add(p *radius.Packet, value FreeRADIUSTotalProxyAcctMalformedRequests) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 158, a)
}

func FreeRADIUSTotalProxyAcctMalformedRequests_Get(p *radius.Packet) (value FreeRADIUSTotalProxyAcctMalformedRequests) {
	value, _ = FreeRADIUSTotalProxyAcctMalformedRequests_Lookup(p)
	return
}

func FreeRADIUSTotalProxyAcctMalformedRequests_Gets(p *radius.Packet) (values []FreeRADIUSTotalProxyAcctMalformedRequests, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 158) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSTotalProxyAcctMalformedRequests(i))
	}
	return
}

func FreeRADIUSTotalProxyAcctMalformedRequests_Lookup(p *radius.Packet) (value FreeRADIUSTotalProxyAcctMalformedRequests, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 158)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSTotalProxyAcctMalformedRequests(i)
	return
}

func FreeRADIUSTotalProxyAcctMalformedRequests_Set(p *radius.Packet, value FreeRADIUSTotalProxyAcctMalformedRequests) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 158, a)
}

func FreeRADIUSTotalProxyAcctMalformedRequests_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 158)
}

type FreeRADIUSTotalProxyAcctInvalidRequests uint32

var FreeRADIUSTotalProxyAcctInvalidRequests_Strings = map[FreeRADIUSTotalProxyAcctInvalidRequests]string{}

func (a FreeRADIUSTotalProxyAcctInvalidRequests) String() string {
	if str, ok := FreeRADIUSTotalProxyAcctInvalidRequests_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSTotalProxyAcctInvalidRequests(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSTotalProxyAcctInvalidRequests_Add(p *radius.Packet, value FreeRADIUSTotalProxyAcctInvalidRequests) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 159, a)
}

func FreeRADIUSTotalProxyAcctInvalidRequests_Get(p *radius.Packet) (value FreeRADIUSTotalProxyAcctInvalidRequests) {
	value, _ = FreeRADIUSTotalProxyAcctInvalidRequests_Lookup(p)
	return
}

func FreeRADIUSTotalProxyAcctInvalidRequests_Gets(p *radius.Packet) (values []FreeRADIUSTotalProxyAcctInvalidRequests, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 159) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSTotalProxyAcctInvalidRequests(i))
	}
	return
}

func FreeRADIUSTotalProxyAcctInvalidRequests_Lookup(p *radius.Packet) (value FreeRADIUSTotalProxyAcctInvalidRequests, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 159)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSTotalProxyAcctInvalidRequests(i)
	return
}

func FreeRADIUSTotalProxyAcctInvalidRequests_Set(p *radius.Packet, value FreeRADIUSTotalProxyAcctInvalidRequests) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 159, a)
}

func FreeRADIUSTotalProxyAcctInvalidRequests_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 159)
}

type FreeRADIUSTotalProxyAcctDroppedRequests uint32

var FreeRADIUSTotalProxyAcctDroppedRequests_Strings = map[FreeRADIUSTotalProxyAcctDroppedRequests]string{}

func (a FreeRADIUSTotalProxyAcctDroppedRequests) String() string {
	if str, ok := FreeRADIUSTotalProxyAcctDroppedRequests_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSTotalProxyAcctDroppedRequests(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSTotalProxyAcctDroppedRequests_Add(p *radius.Packet, value FreeRADIUSTotalProxyAcctDroppedRequests) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 160, a)
}

func FreeRADIUSTotalProxyAcctDroppedRequests_Get(p *radius.Packet) (value FreeRADIUSTotalProxyAcctDroppedRequests) {
	value, _ = FreeRADIUSTotalProxyAcctDroppedRequests_Lookup(p)
	return
}

func FreeRADIUSTotalProxyAcctDroppedRequests_Gets(p *radius.Packet) (values []FreeRADIUSTotalProxyAcctDroppedRequests, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 160) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSTotalProxyAcctDroppedRequests(i))
	}
	return
}

func FreeRADIUSTotalProxyAcctDroppedRequests_Lookup(p *radius.Packet) (value FreeRADIUSTotalProxyAcctDroppedRequests, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 160)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSTotalProxyAcctDroppedRequests(i)
	return
}

func FreeRADIUSTotalProxyAcctDroppedRequests_Set(p *radius.Packet, value FreeRADIUSTotalProxyAcctDroppedRequests) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 160, a)
}

func FreeRADIUSTotalProxyAcctDroppedRequests_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 160)
}

type FreeRADIUSTotalProxyAcctUnknownTypes uint32

var FreeRADIUSTotalProxyAcctUnknownTypes_Strings = map[FreeRADIUSTotalProxyAcctUnknownTypes]string{}

func (a FreeRADIUSTotalProxyAcctUnknownTypes) String() string {
	if str, ok := FreeRADIUSTotalProxyAcctUnknownTypes_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSTotalProxyAcctUnknownTypes(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSTotalProxyAcctUnknownTypes_Add(p *radius.Packet, value FreeRADIUSTotalProxyAcctUnknownTypes) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 161, a)
}

func FreeRADIUSTotalProxyAcctUnknownTypes_Get(p *radius.Packet) (value FreeRADIUSTotalProxyAcctUnknownTypes) {
	value, _ = FreeRADIUSTotalProxyAcctUnknownTypes_Lookup(p)
	return
}

func FreeRADIUSTotalProxyAcctUnknownTypes_Gets(p *radius.Packet) (values []FreeRADIUSTotalProxyAcctUnknownTypes, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 161) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSTotalProxyAcctUnknownTypes(i))
	}
	return
}

func FreeRADIUSTotalProxyAcctUnknownTypes_Lookup(p *radius.Packet) (value FreeRADIUSTotalProxyAcctUnknownTypes, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 161)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSTotalProxyAcctUnknownTypes(i)
	return
}

func FreeRADIUSTotalProxyAcctUnknownTypes_Set(p *radius.Packet, value FreeRADIUSTotalProxyAcctUnknownTypes) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 161, a)
}

func FreeRADIUSTotalProxyAcctUnknownTypes_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 161)
}

type FreeRADIUSQueueLenInternal uint32

var FreeRADIUSQueueLenInternal_Strings = map[FreeRADIUSQueueLenInternal]string{}

func (a FreeRADIUSQueueLenInternal) String() string {
	if str, ok := FreeRADIUSQueueLenInternal_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSQueueLenInternal(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSQueueLenInternal_Add(p *radius.Packet, value FreeRADIUSQueueLenInternal) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 162, a)
}

func FreeRADIUSQueueLenInternal_Get(p *radius.Packet) (value FreeRADIUSQueueLenInternal) {
	value, _ = FreeRADIUSQueueLenInternal_Lookup(p)
	return
}

func FreeRADIUSQueueLenInternal_Gets(p *radius.Packet) (values []FreeRADIUSQueueLenInternal, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 162) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSQueueLenInternal(i))
	}
	return
}

func FreeRADIUSQueueLenInternal_Lookup(p *radius.Packet) (value FreeRADIUSQueueLenInternal, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 162)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSQueueLenInternal(i)
	return
}

func FreeRADIUSQueueLenInternal_Set(p *radius.Packet, value FreeRADIUSQueueLenInternal) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 162, a)
}

func FreeRADIUSQueueLenInternal_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 162)
}

type FreeRADIUSQueueLenProxy uint32

var FreeRADIUSQueueLenProxy_Strings = map[FreeRADIUSQueueLenProxy]string{}

func (a FreeRADIUSQueueLenProxy) String() string {
	if str, ok := FreeRADIUSQueueLenProxy_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSQueueLenProxy(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSQueueLenProxy_Add(p *radius.Packet, value FreeRADIUSQueueLenProxy) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 163, a)
}

func FreeRADIUSQueueLenProxy_Get(p *radius.Packet) (value FreeRADIUSQueueLenProxy) {
	value, _ = FreeRADIUSQueueLenProxy_Lookup(p)
	return
}

func FreeRADIUSQueueLenProxy_Gets(p *radius.Packet) (values []FreeRADIUSQueueLenProxy, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 163) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSQueueLenProxy(i))
	}
	return
}

func FreeRADIUSQueueLenProxy_Lookup(p *radius.Packet) (value FreeRADIUSQueueLenProxy, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 163)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSQueueLenProxy(i)
	return
}

func FreeRADIUSQueueLenProxy_Set(p *radius.Packet, value FreeRADIUSQueueLenProxy) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 163, a)
}

func FreeRADIUSQueueLenProxy_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 163)
}

type FreeRADIUSQueueLenAuth uint32

var FreeRADIUSQueueLenAuth_Strings = map[FreeRADIUSQueueLenAuth]string{}

func (a FreeRADIUSQueueLenAuth) String() string {
	if str, ok := FreeRADIUSQueueLenAuth_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSQueueLenAuth(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSQueueLenAuth_Add(p *radius.Packet, value FreeRADIUSQueueLenAuth) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 164, a)
}

func FreeRADIUSQueueLenAuth_Get(p *radius.Packet) (value FreeRADIUSQueueLenAuth) {
	value, _ = FreeRADIUSQueueLenAuth_Lookup(p)
	return
}

func FreeRADIUSQueueLenAuth_Gets(p *radius.Packet) (values []FreeRADIUSQueueLenAuth, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 164) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSQueueLenAuth(i))
	}
	return
}

func FreeRADIUSQueueLenAuth_Lookup(p *radius.Packet) (value FreeRADIUSQueueLenAuth, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 164)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSQueueLenAuth(i)
	return
}

func FreeRADIUSQueueLenAuth_Set(p *radius.Packet, value FreeRADIUSQueueLenAuth) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 164, a)
}

func FreeRADIUSQueueLenAuth_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 164)
}

type FreeRADIUSQueueLenAcct uint32

var FreeRADIUSQueueLenAcct_Strings = map[FreeRADIUSQueueLenAcct]string{}

func (a FreeRADIUSQueueLenAcct) String() string {
	if str, ok := FreeRADIUSQueueLenAcct_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSQueueLenAcct(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSQueueLenAcct_Add(p *radius.Packet, value FreeRADIUSQueueLenAcct) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 165, a)
}

func FreeRADIUSQueueLenAcct_Get(p *radius.Packet) (value FreeRADIUSQueueLenAcct) {
	value, _ = FreeRADIUSQueueLenAcct_Lookup(p)
	return
}

func FreeRADIUSQueueLenAcct_Gets(p *radius.Packet) (values []FreeRADIUSQueueLenAcct, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 165) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSQueueLenAcct(i))
	}
	return
}

func FreeRADIUSQueueLenAcct_Lookup(p *radius.Packet) (value FreeRADIUSQueueLenAcct, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 165)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSQueueLenAcct(i)
	return
}

func FreeRADIUSQueueLenAcct_Set(p *radius.Packet, value FreeRADIUSQueueLenAcct) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 165, a)
}

func FreeRADIUSQueueLenAcct_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 165)
}

type FreeRADIUSQueueLenDetail uint32

var FreeRADIUSQueueLenDetail_Strings = map[FreeRADIUSQueueLenDetail]string{}

func (a FreeRADIUSQueueLenDetail) String() string {
	if str, ok := FreeRADIUSQueueLenDetail_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSQueueLenDetail(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSQueueLenDetail_Add(p *radius.Packet, value FreeRADIUSQueueLenDetail) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 166, a)
}

func FreeRADIUSQueueLenDetail_Get(p *radius.Packet) (value FreeRADIUSQueueLenDetail) {
	value, _ = FreeRADIUSQueueLenDetail_Lookup(p)
	return
}

func FreeRADIUSQueueLenDetail_Gets(p *radius.Packet) (values []FreeRADIUSQueueLenDetail, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 166) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSQueueLenDetail(i))
	}
	return
}

func FreeRADIUSQueueLenDetail_Lookup(p *radius.Packet) (value FreeRADIUSQueueLenDetail, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 166)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSQueueLenDetail(i)
	return
}

func FreeRADIUSQueueLenDetail_Set(p *radius.Packet, value FreeRADIUSQueueLenDetail) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 166, a)
}

func FreeRADIUSQueueLenDetail_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 166)
}

func FreeRADIUSStatsStartTime_Add(p *radius.Packet, value time.Time) (err error) {
	var a radius.Attribute
	a, err = radius.NewDate(value)
	if err != nil {
		return
	}
	return _FreeRADIUS_AddVendor(p, 176, a)
}

func FreeRADIUSStatsStartTime_Get(p *radius.Packet) (value time.Time) {
	value, _ = FreeRADIUSStatsStartTime_Lookup(p)
	return
}

func FreeRADIUSStatsStartTime_Gets(p *radius.Packet) (values []time.Time, err error) {
	var i time.Time
	for _, attr := range _FreeRADIUS_GetsVendor(p, 176) {
		i, err = radius.Date(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func FreeRADIUSStatsStartTime_Lookup(p *radius.Packet) (value time.Time, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 176)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value, err = radius.Date(a)
	return
}

func FreeRADIUSStatsStartTime_Set(p *radius.Packet, value time.Time) (err error) {
	var a radius.Attribute
	a, err = radius.NewDate(value)
	if err != nil {
		return
	}
	return _FreeRADIUS_SetVendor(p, 176, a)
}

func FreeRADIUSStatsStartTime_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 176)
}

func FreeRADIUSStatsHUPTime_Add(p *radius.Packet, value time.Time) (err error) {
	var a radius.Attribute
	a, err = radius.NewDate(value)
	if err != nil {
		return
	}
	return _FreeRADIUS_AddVendor(p, 177, a)
}

func FreeRADIUSStatsHUPTime_Get(p *radius.Packet) (value time.Time) {
	value, _ = FreeRADIUSStatsHUPTime_Lookup(p)
	return
}

func FreeRADIUSStatsHUPTime_Gets(p *radius.Packet) (values []time.Time, err error) {
	var i time.Time
	for _, attr := range _FreeRADIUS_GetsVendor(p, 177) {
		i, err = radius.Date(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func FreeRADIUSStatsHUPTime_Lookup(p *radius.Packet) (value time.Time, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 177)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value, err = radius.Date(a)
	return
}

func FreeRADIUSStatsHUPTime_Set(p *radius.Packet, value time.Time) (err error) {
	var a radius.Attribute
	a, err = radius.NewDate(value)
	if err != nil {
		return
	}
	return _FreeRADIUS_SetVendor(p, 177, a)
}

func FreeRADIUSStatsHUPTime_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 177)
}

type FreeRADIUSQueuePPSIn uint32

var FreeRADIUSQueuePPSIn_Strings = map[FreeRADIUSQueuePPSIn]string{}

func (a FreeRADIUSQueuePPSIn) String() string {
	if str, ok := FreeRADIUSQueuePPSIn_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSQueuePPSIn(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSQueuePPSIn_Add(p *radius.Packet, value FreeRADIUSQueuePPSIn) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 181, a)
}

func FreeRADIUSQueuePPSIn_Get(p *radius.Packet) (value FreeRADIUSQueuePPSIn) {
	value, _ = FreeRADIUSQueuePPSIn_Lookup(p)
	return
}

func FreeRADIUSQueuePPSIn_Gets(p *radius.Packet) (values []FreeRADIUSQueuePPSIn, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 181) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSQueuePPSIn(i))
	}
	return
}

func FreeRADIUSQueuePPSIn_Lookup(p *radius.Packet) (value FreeRADIUSQueuePPSIn, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 181)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSQueuePPSIn(i)
	return
}

func FreeRADIUSQueuePPSIn_Set(p *radius.Packet, value FreeRADIUSQueuePPSIn) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 181, a)
}

func FreeRADIUSQueuePPSIn_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 181)
}

type FreeRADIUSQueuePPSOut uint32

var FreeRADIUSQueuePPSOut_Strings = map[FreeRADIUSQueuePPSOut]string{}

func (a FreeRADIUSQueuePPSOut) String() string {
	if str, ok := FreeRADIUSQueuePPSOut_Strings[a]; ok {
		return str
	}
	return "FreeRADIUSQueuePPSOut(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func FreeRADIUSQueuePPSOut_Add(p *radius.Packet, value FreeRADIUSQueuePPSOut) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_AddVendor(p, 182, a)
}

func FreeRADIUSQueuePPSOut_Get(p *radius.Packet) (value FreeRADIUSQueuePPSOut) {
	value, _ = FreeRADIUSQueuePPSOut_Lookup(p)
	return
}

func FreeRADIUSQueuePPSOut_Gets(p *radius.Packet) (values []FreeRADIUSQueuePPSOut, err error) {
	var i uint32
	for _, attr := range _FreeRADIUS_GetsVendor(p, 182) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, FreeRADIUSQueuePPSOut(i))
	}
	return
}

func FreeRADIUSQueuePPSOut_Lookup(p *radius.Packet) (value FreeRADIUSQueuePPSOut, err error) {
	a, ok := _FreeRADIUS_LookupVendor(p, 182)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = FreeRADIUSQueuePPSOut(i)
	return
}

func FreeRADIUSQueuePPSOut_Set(p *radius.Packet, value FreeRADIUSQueuePPSOut) (err error) {
	a := radius.NewInteger(uint32(value))
	return _FreeRADIUS_SetVendor(p, 182, a)
}

func FreeRADIUSQueuePPSOut_Del(p *radius.Packet) {
	_FreeRADIUS_DelVendor(p, 182)
}
