/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1 "k8s.io/api/networking/v1"
	networkingv1 "k8s.io/client-go/applyconfigurations/networking/v1"
	gentype "k8s.io/client-go/gentype"
	typednetworkingv1 "k8s.io/client-go/kubernetes/typed/networking/v1"
)

// fakeIngresses implements IngressInterface
type fakeIngresses struct {
	*gentype.FakeClientWithListAndApply[*v1.Ingress, *v1.IngressList, *networkingv1.IngressApplyConfiguration]
	Fake *FakeNetworkingV1
}

func newFakeIngresses(fake *FakeNetworkingV1, namespace string) typednetworkingv1.IngressInterface {
	return &fakeIngresses{
		gentype.NewFakeClientWithListAndApply[*v1.Ingress, *v1.IngressList, *networkingv1.IngressApplyConfiguration](
			fake.Fake,
			namespace,
			v1.SchemeGroupVersion.WithResource("ingresses"),
			v1.SchemeGroupVersion.WithKind("Ingress"),
			func() *v1.Ingress { return &v1.Ingress{} },
			func() *v1.IngressList { return &v1.IngressList{} },
			func(dst, src *v1.IngressList) { dst.ListMeta = src.ListMeta },
			func(list *v1.IngressList) []*v1.Ingress { return gentype.ToPointerSlice(list.Items) },
			func(list *v1.IngressList, items []*v1.Ingress) { list.Items = gentype.FromPointerSlice(items) },
		),
		fake,
	}
}
