/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta1

import (
	resourcev1beta1 "k8s.io/api/resource/v1beta1"
)

// DeviceRequestApplyConfiguration represents a declarative configuration of the DeviceRequest type for use
// with apply.
type DeviceRequestApplyConfiguration struct {
	Name            *string                               `json:"name,omitempty"`
	DeviceClassName *string                               `json:"deviceClassName,omitempty"`
	Selectors       []DeviceSelectorApplyConfiguration    `json:"selectors,omitempty"`
	AllocationMode  *resourcev1beta1.DeviceAllocationMode `json:"allocationMode,omitempty"`
	Count           *int64                                `json:"count,omitempty"`
	AdminAccess     *bool                                 `json:"adminAccess,omitempty"`
}

// DeviceRequestApplyConfiguration constructs a declarative configuration of the DeviceRequest type for use with
// apply.
func DeviceRequest() *DeviceRequestApplyConfiguration {
	return &DeviceRequestApplyConfiguration{}
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *DeviceRequestApplyConfiguration) WithName(value string) *DeviceRequestApplyConfiguration {
	b.Name = &value
	return b
}

// WithDeviceClassName sets the DeviceClassName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DeviceClassName field is set to the value of the last call.
func (b *DeviceRequestApplyConfiguration) WithDeviceClassName(value string) *DeviceRequestApplyConfiguration {
	b.DeviceClassName = &value
	return b
}

// WithSelectors adds the given value to the Selectors field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Selectors field.
func (b *DeviceRequestApplyConfiguration) WithSelectors(values ...*DeviceSelectorApplyConfiguration) *DeviceRequestApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithSelectors")
		}
		b.Selectors = append(b.Selectors, *values[i])
	}
	return b
}

// WithAllocationMode sets the AllocationMode field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the AllocationMode field is set to the value of the last call.
func (b *DeviceRequestApplyConfiguration) WithAllocationMode(value resourcev1beta1.DeviceAllocationMode) *DeviceRequestApplyConfiguration {
	b.AllocationMode = &value
	return b
}

// WithCount sets the Count field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Count field is set to the value of the last call.
func (b *DeviceRequestApplyConfiguration) WithCount(value int64) *DeviceRequestApplyConfiguration {
	b.Count = &value
	return b
}

// WithAdminAccess sets the AdminAccess field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the AdminAccess field is set to the value of the last call.
func (b *DeviceRequestApplyConfiguration) WithAdminAccess(value bool) *DeviceRequestApplyConfiguration {
	b.AdminAccess = &value
	return b
}
