// Code generated by 'ccgo -lmodernc.org/z/lib -o internal/example_linux_ppc64le.go -trace-translation-units /tmp/go-generate-526959028/cdb.json example64', DO NOT EDIT.

package main

import (
	"math"
	"reflect"
	"sync/atomic"
	"unsafe"

	"modernc.org/libc"
	"modernc.org/libc/sys/types"
	"modernc.org/z/lib"
)

var _ = math.Pi
var _ reflect.Kind
var _ atomic.Value
var _ unsafe.Pointer
var _ *libc.TLS
var _ types.Size_t

func main() { libc.Start(main1) }

// Get the `_PC_*' symbols for the NAME argument to `pathconf' and `fpathconf';
//    the `_SC_*' symbols for the NAME argument to `sysconf';
//    and the `_CS_*' symbols for the NAME argument to `confstr'.
// `sysconf', `pathconf', and `confstr' NAME values.  Generic version.
//    Copyright (C) 1993-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

// Values for the NAME argument to `pathconf' and `fpathconf'.
const ( /* confname.h:24:1: */
	_PC_LINK_MAX           = 0
	_PC_MAX_CANON          = 1
	_PC_MAX_INPUT          = 2
	_PC_NAME_MAX           = 3
	_PC_PATH_MAX           = 4
	_PC_PIPE_BUF           = 5
	_PC_CHOWN_RESTRICTED   = 6
	_PC_NO_TRUNC           = 7
	_PC_VDISABLE           = 8
	_PC_SYNC_IO            = 9
	_PC_ASYNC_IO           = 10
	_PC_PRIO_IO            = 11
	_PC_SOCK_MAXBUF        = 12
	_PC_FILESIZEBITS       = 13
	_PC_REC_INCR_XFER_SIZE = 14
	_PC_REC_MAX_XFER_SIZE  = 15
	_PC_REC_MIN_XFER_SIZE  = 16
	_PC_REC_XFER_ALIGN     = 17
	_PC_ALLOC_SIZE_MIN     = 18
	_PC_SYMLINK_MAX        = 19
	_PC_2_SYMLINKS         = 20
)

// Values for the NAME argument to `confstr'.
const ( /* confname.h:533:1: */
	_CS_PATH = 0 // The default search path.

	_CS_V6_WIDTH_RESTRICTED_ENVS = 1

	_CS_GNU_LIBC_VERSION       = 2
	_CS_GNU_LIBPTHREAD_VERSION = 3

	_CS_V5_WIDTH_RESTRICTED_ENVS = 4

	_CS_V7_WIDTH_RESTRICTED_ENVS = 5

	_CS_LFS_CFLAGS      = 1000
	_CS_LFS_LDFLAGS     = 1001
	_CS_LFS_LIBS        = 1002
	_CS_LFS_LINTFLAGS   = 1003
	_CS_LFS64_CFLAGS    = 1004
	_CS_LFS64_LDFLAGS   = 1005
	_CS_LFS64_LIBS      = 1006
	_CS_LFS64_LINTFLAGS = 1007

	_CS_XBS5_ILP32_OFF32_CFLAGS     = 1100
	_CS_XBS5_ILP32_OFF32_LDFLAGS    = 1101
	_CS_XBS5_ILP32_OFF32_LIBS       = 1102
	_CS_XBS5_ILP32_OFF32_LINTFLAGS  = 1103
	_CS_XBS5_ILP32_OFFBIG_CFLAGS    = 1104
	_CS_XBS5_ILP32_OFFBIG_LDFLAGS   = 1105
	_CS_XBS5_ILP32_OFFBIG_LIBS      = 1106
	_CS_XBS5_ILP32_OFFBIG_LINTFLAGS = 1107
	_CS_XBS5_LP64_OFF64_CFLAGS      = 1108
	_CS_XBS5_LP64_OFF64_LDFLAGS     = 1109
	_CS_XBS5_LP64_OFF64_LIBS        = 1110
	_CS_XBS5_LP64_OFF64_LINTFLAGS   = 1111
	_CS_XBS5_LPBIG_OFFBIG_CFLAGS    = 1112
	_CS_XBS5_LPBIG_OFFBIG_LDFLAGS   = 1113
	_CS_XBS5_LPBIG_OFFBIG_LIBS      = 1114
	_CS_XBS5_LPBIG_OFFBIG_LINTFLAGS = 1115

	_CS_POSIX_V6_ILP32_OFF32_CFLAGS     = 1116
	_CS_POSIX_V6_ILP32_OFF32_LDFLAGS    = 1117
	_CS_POSIX_V6_ILP32_OFF32_LIBS       = 1118
	_CS_POSIX_V6_ILP32_OFF32_LINTFLAGS  = 1119
	_CS_POSIX_V6_ILP32_OFFBIG_CFLAGS    = 1120
	_CS_POSIX_V6_ILP32_OFFBIG_LDFLAGS   = 1121
	_CS_POSIX_V6_ILP32_OFFBIG_LIBS      = 1122
	_CS_POSIX_V6_ILP32_OFFBIG_LINTFLAGS = 1123
	_CS_POSIX_V6_LP64_OFF64_CFLAGS      = 1124
	_CS_POSIX_V6_LP64_OFF64_LDFLAGS     = 1125
	_CS_POSIX_V6_LP64_OFF64_LIBS        = 1126
	_CS_POSIX_V6_LP64_OFF64_LINTFLAGS   = 1127
	_CS_POSIX_V6_LPBIG_OFFBIG_CFLAGS    = 1128
	_CS_POSIX_V6_LPBIG_OFFBIG_LDFLAGS   = 1129
	_CS_POSIX_V6_LPBIG_OFFBIG_LIBS      = 1130
	_CS_POSIX_V6_LPBIG_OFFBIG_LINTFLAGS = 1131

	_CS_POSIX_V7_ILP32_OFF32_CFLAGS     = 1132
	_CS_POSIX_V7_ILP32_OFF32_LDFLAGS    = 1133
	_CS_POSIX_V7_ILP32_OFF32_LIBS       = 1134
	_CS_POSIX_V7_ILP32_OFF32_LINTFLAGS  = 1135
	_CS_POSIX_V7_ILP32_OFFBIG_CFLAGS    = 1136
	_CS_POSIX_V7_ILP32_OFFBIG_LDFLAGS   = 1137
	_CS_POSIX_V7_ILP32_OFFBIG_LIBS      = 1138
	_CS_POSIX_V7_ILP32_OFFBIG_LINTFLAGS = 1139
	_CS_POSIX_V7_LP64_OFF64_CFLAGS      = 1140
	_CS_POSIX_V7_LP64_OFF64_LDFLAGS     = 1141
	_CS_POSIX_V7_LP64_OFF64_LIBS        = 1142
	_CS_POSIX_V7_LP64_OFF64_LINTFLAGS   = 1143
	_CS_POSIX_V7_LPBIG_OFFBIG_CFLAGS    = 1144
	_CS_POSIX_V7_LPBIG_OFFBIG_LDFLAGS   = 1145
	_CS_POSIX_V7_LPBIG_OFFBIG_LIBS      = 1146
	_CS_POSIX_V7_LPBIG_OFFBIG_LINTFLAGS = 1147

	_CS_V6_ENV = 1148
	_CS_V7_ENV = 1149
)

// Values for the argument to `sysconf'.
const ( /* confname.h:71:1: */
	_SC_ARG_MAX               = 0
	_SC_CHILD_MAX             = 1
	_SC_CLK_TCK               = 2
	_SC_NGROUPS_MAX           = 3
	_SC_OPEN_MAX              = 4
	_SC_STREAM_MAX            = 5
	_SC_TZNAME_MAX            = 6
	_SC_JOB_CONTROL           = 7
	_SC_SAVED_IDS             = 8
	_SC_REALTIME_SIGNALS      = 9
	_SC_PRIORITY_SCHEDULING   = 10
	_SC_TIMERS                = 11
	_SC_ASYNCHRONOUS_IO       = 12
	_SC_PRIORITIZED_IO        = 13
	_SC_SYNCHRONIZED_IO       = 14
	_SC_FSYNC                 = 15
	_SC_MAPPED_FILES          = 16
	_SC_MEMLOCK               = 17
	_SC_MEMLOCK_RANGE         = 18
	_SC_MEMORY_PROTECTION     = 19
	_SC_MESSAGE_PASSING       = 20
	_SC_SEMAPHORES            = 21
	_SC_SHARED_MEMORY_OBJECTS = 22
	_SC_AIO_LISTIO_MAX        = 23
	_SC_AIO_MAX               = 24
	_SC_AIO_PRIO_DELTA_MAX    = 25
	_SC_DELAYTIMER_MAX        = 26
	_SC_MQ_OPEN_MAX           = 27
	_SC_MQ_PRIO_MAX           = 28
	_SC_VERSION               = 29
	_SC_PAGESIZE              = 30
	_SC_RTSIG_MAX             = 31
	_SC_SEM_NSEMS_MAX         = 32
	_SC_SEM_VALUE_MAX         = 33
	_SC_SIGQUEUE_MAX          = 34
	_SC_TIMER_MAX             = 35

	// Values for the argument to `sysconf'
	//        corresponding to _POSIX2_* symbols.
	_SC_BC_BASE_MAX        = 36
	_SC_BC_DIM_MAX         = 37
	_SC_BC_SCALE_MAX       = 38
	_SC_BC_STRING_MAX      = 39
	_SC_COLL_WEIGHTS_MAX   = 40
	_SC_EQUIV_CLASS_MAX    = 41
	_SC_EXPR_NEST_MAX      = 42
	_SC_LINE_MAX           = 43
	_SC_RE_DUP_MAX         = 44
	_SC_CHARCLASS_NAME_MAX = 45

	_SC_2_VERSION   = 46
	_SC_2_C_BIND    = 47
	_SC_2_C_DEV     = 48
	_SC_2_FORT_DEV  = 49
	_SC_2_FORT_RUN  = 50
	_SC_2_SW_DEV    = 51
	_SC_2_LOCALEDEF = 52

	_SC_PII                 = 53
	_SC_PII_XTI             = 54
	_SC_PII_SOCKET          = 55
	_SC_PII_INTERNET        = 56
	_SC_PII_OSI             = 57
	_SC_POLL                = 58
	_SC_SELECT              = 59
	_SC_UIO_MAXIOV          = 60
	_SC_IOV_MAX             = 60
	_SC_PII_INTERNET_STREAM = 61
	_SC_PII_INTERNET_DGRAM  = 62
	_SC_PII_OSI_COTS        = 63
	_SC_PII_OSI_CLTS        = 64
	_SC_PII_OSI_M           = 65
	_SC_T_IOV_MAX           = 66

	// Values according to POSIX 1003.1c (POSIX threads).
	_SC_THREADS                      = 67
	_SC_THREAD_SAFE_FUNCTIONS        = 68
	_SC_GETGR_R_SIZE_MAX             = 69
	_SC_GETPW_R_SIZE_MAX             = 70
	_SC_LOGIN_NAME_MAX               = 71
	_SC_TTY_NAME_MAX                 = 72
	_SC_THREAD_DESTRUCTOR_ITERATIONS = 73
	_SC_THREAD_KEYS_MAX              = 74
	_SC_THREAD_STACK_MIN             = 75
	_SC_THREAD_THREADS_MAX           = 76
	_SC_THREAD_ATTR_STACKADDR        = 77
	_SC_THREAD_ATTR_STACKSIZE        = 78
	_SC_THREAD_PRIORITY_SCHEDULING   = 79
	_SC_THREAD_PRIO_INHERIT          = 80
	_SC_THREAD_PRIO_PROTECT          = 81
	_SC_THREAD_PROCESS_SHARED        = 82

	_SC_NPROCESSORS_CONF = 83
	_SC_NPROCESSORS_ONLN = 84
	_SC_PHYS_PAGES       = 85
	_SC_AVPHYS_PAGES     = 86
	_SC_ATEXIT_MAX       = 87
	_SC_PASS_MAX         = 88

	_SC_XOPEN_VERSION     = 89
	_SC_XOPEN_XCU_VERSION = 90
	_SC_XOPEN_UNIX        = 91
	_SC_XOPEN_CRYPT       = 92
	_SC_XOPEN_ENH_I18N    = 93
	_SC_XOPEN_SHM         = 94

	_SC_2_CHAR_TERM = 95
	_SC_2_C_VERSION = 96
	_SC_2_UPE       = 97

	_SC_XOPEN_XPG2 = 98
	_SC_XOPEN_XPG3 = 99
	_SC_XOPEN_XPG4 = 100

	_SC_CHAR_BIT   = 101
	_SC_CHAR_MAX   = 102
	_SC_CHAR_MIN   = 103
	_SC_INT_MAX    = 104
	_SC_INT_MIN    = 105
	_SC_LONG_BIT   = 106
	_SC_WORD_BIT   = 107
	_SC_MB_LEN_MAX = 108
	_SC_NZERO      = 109
	_SC_SSIZE_MAX  = 110
	_SC_SCHAR_MAX  = 111
	_SC_SCHAR_MIN  = 112
	_SC_SHRT_MAX   = 113
	_SC_SHRT_MIN   = 114
	_SC_UCHAR_MAX  = 115
	_SC_UINT_MAX   = 116
	_SC_ULONG_MAX  = 117
	_SC_USHRT_MAX  = 118

	_SC_NL_ARGMAX  = 119
	_SC_NL_LANGMAX = 120
	_SC_NL_MSGMAX  = 121
	_SC_NL_NMAX    = 122
	_SC_NL_SETMAX  = 123
	_SC_NL_TEXTMAX = 124

	_SC_XBS5_ILP32_OFF32  = 125
	_SC_XBS5_ILP32_OFFBIG = 126
	_SC_XBS5_LP64_OFF64   = 127
	_SC_XBS5_LPBIG_OFFBIG = 128

	_SC_XOPEN_LEGACY           = 129
	_SC_XOPEN_REALTIME         = 130
	_SC_XOPEN_REALTIME_THREADS = 131

	_SC_ADVISORY_INFO          = 132
	_SC_BARRIERS               = 133
	_SC_BASE                   = 134
	_SC_C_LANG_SUPPORT         = 135
	_SC_C_LANG_SUPPORT_R       = 136
	_SC_CLOCK_SELECTION        = 137
	_SC_CPUTIME                = 138
	_SC_THREAD_CPUTIME         = 139
	_SC_DEVICE_IO              = 140
	_SC_DEVICE_SPECIFIC        = 141
	_SC_DEVICE_SPECIFIC_R      = 142
	_SC_FD_MGMT                = 143
	_SC_FIFO                   = 144
	_SC_PIPE                   = 145
	_SC_FILE_ATTRIBUTES        = 146
	_SC_FILE_LOCKING           = 147
	_SC_FILE_SYSTEM            = 148
	_SC_MONOTONIC_CLOCK        = 149
	_SC_MULTI_PROCESS          = 150
	_SC_SINGLE_PROCESS         = 151
	_SC_NETWORKING             = 152
	_SC_READER_WRITER_LOCKS    = 153
	_SC_SPIN_LOCKS             = 154
	_SC_REGEXP                 = 155
	_SC_REGEX_VERSION          = 156
	_SC_SHELL                  = 157
	_SC_SIGNALS                = 158
	_SC_SPAWN                  = 159
	_SC_SPORADIC_SERVER        = 160
	_SC_THREAD_SPORADIC_SERVER = 161
	_SC_SYSTEM_DATABASE        = 162
	_SC_SYSTEM_DATABASE_R      = 163
	_SC_TIMEOUTS               = 164
	_SC_TYPED_MEMORY_OBJECTS   = 165
	_SC_USER_GROUPS            = 166
	_SC_USER_GROUPS_R          = 167
	_SC_2_PBS                  = 168
	_SC_2_PBS_ACCOUNTING       = 169
	_SC_2_PBS_LOCATE           = 170
	_SC_2_PBS_MESSAGE          = 171
	_SC_2_PBS_TRACK            = 172
	_SC_SYMLOOP_MAX            = 173
	_SC_STREAMS                = 174
	_SC_2_PBS_CHECKPOINT       = 175

	_SC_V6_ILP32_OFF32  = 176
	_SC_V6_ILP32_OFFBIG = 177
	_SC_V6_LP64_OFF64   = 178
	_SC_V6_LPBIG_OFFBIG = 179

	_SC_HOST_NAME_MAX      = 180
	_SC_TRACE              = 181
	_SC_TRACE_EVENT_FILTER = 182
	_SC_TRACE_INHERIT      = 183
	_SC_TRACE_LOG          = 184

	_SC_LEVEL1_ICACHE_SIZE     = 185
	_SC_LEVEL1_ICACHE_ASSOC    = 186
	_SC_LEVEL1_ICACHE_LINESIZE = 187
	_SC_LEVEL1_DCACHE_SIZE     = 188
	_SC_LEVEL1_DCACHE_ASSOC    = 189
	_SC_LEVEL1_DCACHE_LINESIZE = 190
	_SC_LEVEL2_CACHE_SIZE      = 191
	_SC_LEVEL2_CACHE_ASSOC     = 192
	_SC_LEVEL2_CACHE_LINESIZE  = 193
	_SC_LEVEL3_CACHE_SIZE      = 194
	_SC_LEVEL3_CACHE_ASSOC     = 195
	_SC_LEVEL3_CACHE_LINESIZE  = 196
	_SC_LEVEL4_CACHE_SIZE      = 197
	_SC_LEVEL4_CACHE_ASSOC     = 198
	_SC_LEVEL4_CACHE_LINESIZE  = 199
	// Leave room here, maybe we need a few more cache levels some day.

	_SC_IPV6        = 235
	_SC_RAW_SOCKETS = 236

	_SC_V7_ILP32_OFF32  = 237
	_SC_V7_ILP32_OFFBIG = 238
	_SC_V7_LP64_OFF64   = 239
	_SC_V7_LPBIG_OFFBIG = 240

	_SC_SS_REPL_MAX = 241

	_SC_TRACE_EVENT_NAME_MAX = 242
	_SC_TRACE_NAME_MAX       = 243
	_SC_TRACE_SYS_MAX        = 244
	_SC_TRACE_USER_EVENT_MAX = 245

	_SC_XOPEN_STREAMS = 246

	_SC_THREAD_ROBUST_PRIO_INHERIT = 247
	_SC_THREAD_ROBUST_PRIO_PROTECT = 248
)

// Copyright (C) 1991-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

//	ISO C99 Standard: 7.20 General utilities	<stdlib.h>

// Handle feature test macros at the start of a header.
//    Copyright (C) 2016-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

// This header is internal to glibc and should not be included outside
//    of glibc headers.  Headers including it must define
//    __GLIBC_INTERNAL_STARTING_HEADER_IMPLEMENTATION first.  This header
//    cannot have multiple include guards because ISO C feature test
//    macros depend on the definition of the macro when an affected
//    header is included, not when the first system header is
//    included.

// Copyright (C) 1991-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

// ISO/IEC TR 24731-2:2010 defines the __STDC_WANT_LIB_EXT2__
//    macro.

// ISO/IEC TS 18661-1:2014 defines the __STDC_WANT_IEC_60559_BFP_EXT__
//    macro.  Most but not all symbols enabled by that macro in TS
//    18661-1 are enabled unconditionally in C2X; the symbols in Annex F
//    still require that macro in C2X.

// ISO/IEC TS 18661-4:2015 defines the
//    __STDC_WANT_IEC_60559_FUNCS_EXT__ macro.  Other than the reduction
//    functions, the symbols from this TS are enabled unconditionally in
//    C2X.

// ISO/IEC TS 18661-3:2015 defines the
//    __STDC_WANT_IEC_60559_TYPES_EXT__ macro.

// Get size_t, wchar_t and NULL from <stddef.h>.
// Copyright (C) 1989-2020 Free Software Foundation, Inc.
//
// This file is part of GCC.
//
// GCC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// GCC is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// Under Section 7 of GPL version 3, you are granted additional
// permissions described in the GCC Runtime Library Exception, version
// 3.1, as published by the Free Software Foundation.
//
// You should have received a copy of the GNU General Public License and
// a copy of the GCC Runtime Library Exception along with this program;
// see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
// <http://www.gnu.org/licenses/>.

// ISO C Standard:  7.17  Common definitions  <stddef.h>

// Any one of these symbols __need_* means that GNU libc
//    wants us just to define one data type.  So don't define
//    the symbols that indicate this file's entire job has been done.

// This avoids lossage on SunOS but only if stdtypes.h comes first.
//    There's no way to win with the other order!  Sun lossage.

// Sequent's header files use _PTRDIFF_T_ in some conflicting way.
//    Just ignore it.

// On VxWorks, <type/vxTypesBase.h> may have defined macros like
//    _TYPE_size_t which will typedef size_t.  fixincludes patched the
//    vxTypesBase.h so that this macro is only defined if _GCC_SIZE_T is
//    not defined, and so that defining this macro defines _GCC_SIZE_T.
//    If we find that the macros are still defined at this point, we must
//    invoke them so that the type is defined as expected.

// In case nobody has defined these types, but we aren't running under
//    GCC 2.00, make sure that __PTRDIFF_TYPE__, __SIZE_TYPE__, and
//    __WCHAR_TYPE__ have reasonable values.  This can happen if the
//    parts of GCC is compiled by an older compiler, that actually
//    include gstddef.h, such as collect2.

// Signed type of difference of two pointers.

// Define this type if we are doing the whole job,
//    or if we want this type in particular.

// If this symbol has done its job, get rid of it.

// Unsigned type of `sizeof' something.

// Define this type if we are doing the whole job,
//    or if we want this type in particular.

// Wide character type.
//    Locale-writers should change this as necessary to
//    be big enough to hold unique values not between 0 and 127,
//    and not (wchar_t) -1, for each defined multibyte character.

// Define this type if we are doing the whole job,
//    or if we want this type in particular.

// A null pointer constant.

// Offset of member MEMBER in a struct of type TYPE.

// XPG requires a few symbols from <sys/wait.h> being defined.
// Definitions of flag bits for `waitpid' et al.
//    Copyright (C) 1992-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

// Bits in the third argument to `waitpid'.

// Bits in the fourth argument to `waitid'.

// The following values are used by the `waitid' function.

// The Linux kernel defines these bare, rather than an enum,
//    which causes a conflict if the include order is reversed.

const ( /* waitflags.h:52:1: */
	P_ALL  = 0 // Wait for any child.
	P_PID  = 1 // Wait for specified process.
	P_PGID = 2
)

type ptrdiff_t = int64 /* <builtin>:3:26 */

type size_t = uint64 /* <builtin>:9:23 */

type wchar_t = int32 /* <builtin>:15:24 */

// A null pointer constant.

// Offset of member MEMBER in a struct of type TYPE.

// Type whose alignment is supported in every context and is at least
//    as great as that of any standard type not using alignment
//    specifiers.
type max_align_t = struct {
	__max_align_ll int64
	__max_align_ld float64
} /* stddef.h:426:3 */

type z_size_t = size_t /* zconf.h:248:21 */

// Maximum value for memLevel in deflateInit2

// Maximum value for windowBits in deflateInit2 and inflateInit2.
// WARNING: reducing MAX_WBITS makes minigzip unable to extract .gz files
// created by gzip. (Files created by minigzip can still be extracted by
// gzip.)

// The memory requirements for deflate are (in bytes):
//             (1 << (windowBits+2)) +  (1 << (memLevel+9))
//  that is: 128K for windowBits=15  +  128K for memLevel = 8  (default values)
//  plus a few kilobytes for small objects. For example, if you want to reduce
//  the default memory requirements from 256K to 128K, compile with
//      make CFLAGS="-O -DMAX_WBITS=14 -DMAX_MEM_LEVEL=7"
//  Of course this will generally degrade compression (there's no free lunch).
//
//    The memory requirements for inflate are (in bytes) 1 << windowBits
//  that is, 32K for windowBits=15 (default value) plus about 7 kilobytes
//  for small objects.

// Type declarations

// The following definitions for FAR are needed only for MSDOS mixed
// model programming (small or medium model with some far allocations).
// This was tested only with MSC; for other MSDOS compilers you may have
// to define NO_MEMCPY in zutil.h.  If you don't need the mixed model,
// just define FAR to be empty.

type Byte = uint8   /* zconf.h:391:24 */ // 8 bits
type uInt = uint32  /* zconf.h:393:24 */ // 16 bits or more
type uLong = uint64 /* zconf.h:394:24 */ // 32 bits or more

type Bytef = Byte   /* zconf.h:400:22 */
type charf = uint8  /* zconf.h:402:19 */
type intf = int32   /* zconf.h:403:19 */
type uIntf = uInt   /* zconf.h:404:19 */
type uLongf = uLong /* zconf.h:405:19 */

type voidpc = uintptr /* zconf.h:408:23 */
type voidpf = uintptr /* zconf.h:409:23 */
type voidp = uintptr  /* zconf.h:410:23 */

// Copyright (C) 1992-2020 Free Software Foundation, Inc.
//
// This file is part of GCC.
//
// GCC is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 3, or (at your option) any later
// version.
//
// GCC is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// Under Section 7 of GPL version 3, you are granted additional
// permissions described in the GCC Runtime Library Exception, version
// 3.1, as published by the Free Software Foundation.
//
// You should have received a copy of the GNU General Public License and
// a copy of the GCC Runtime Library Exception along with this program;
// see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
// <http://www.gnu.org/licenses/>.

// This administrivia gets added to the beginning of limits.h
//    if the system has its own version of limits.h.

// We use _GCC_LIMITS_H_ because we want this not to match
//    any macros that the system's limits.h uses for its own purposes.

// Use "..." so that we find syslimits.h only in this same directory.
// syslimits.h stands for the system's own limits.h file.
//    If we can use it ok unmodified, then we install this text.
//    If fixincludes fixes it, then the fixed version is installed
//    instead of this text.

// Copyright (C) 1991-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

//	ISO C99 Standard: 7.10/5.2.4.2.1 Sizes of integer types	<limits.h>

// Handle feature test macros at the start of a header.
//    Copyright (C) 2016-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

// This header is internal to glibc and should not be included outside
//    of glibc headers.  Headers including it must define
//    __GLIBC_INTERNAL_STARTING_HEADER_IMPLEMENTATION first.  This header
//    cannot have multiple include guards because ISO C feature test
//    macros depend on the definition of the macro when an affected
//    header is included, not when the first system header is
//    included.

// Copyright (C) 1991-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

// These are defined by the user (or the compiler)
//    to specify the desired environment:
//
//    __STRICT_ANSI__	ISO Standard C.
//    _ISOC99_SOURCE	Extensions to ISO C89 from ISO C99.
//    _ISOC11_SOURCE	Extensions to ISO C99 from ISO C11.
//    _ISOC2X_SOURCE	Extensions to ISO C99 from ISO C2X.
//    __STDC_WANT_LIB_EXT2__
// 			Extensions to ISO C99 from TR 27431-2:2010.
//    __STDC_WANT_IEC_60559_BFP_EXT__
// 			Extensions to ISO C11 from TS 18661-1:2014.
//    __STDC_WANT_IEC_60559_FUNCS_EXT__
// 			Extensions to ISO C11 from TS 18661-4:2015.
//    __STDC_WANT_IEC_60559_TYPES_EXT__
// 			Extensions to ISO C11 from TS 18661-3:2015.
//
//    _POSIX_SOURCE	IEEE Std 1003.1.
//    _POSIX_C_SOURCE	If ==1, like _POSIX_SOURCE; if >=2 add IEEE Std 1003.2;
// 			if >=199309L, add IEEE Std 1003.1b-1993;
// 			if >=199506L, add IEEE Std 1003.1c-1995;
// 			if >=200112L, all of IEEE 1003.1-2004
// 			if >=200809L, all of IEEE 1003.1-2008
//    _XOPEN_SOURCE	Includes POSIX and XPG things.  Set to 500 if
// 			Single Unix conformance is wanted, to 600 for the
// 			sixth revision, to 700 for the seventh revision.
//    _XOPEN_SOURCE_EXTENDED XPG things and X/Open Unix extensions.
//    _LARGEFILE_SOURCE	Some more functions for correct standard I/O.
//    _LARGEFILE64_SOURCE	Additional functionality from LFS for large files.
//    _FILE_OFFSET_BITS=N	Select default filesystem interface.
//    _ATFILE_SOURCE	Additional *at interfaces.
//    _GNU_SOURCE		All of the above, plus GNU extensions.
//    _DEFAULT_SOURCE	The default set of features (taking precedence over
// 			__STRICT_ANSI__).
//
//    _FORTIFY_SOURCE	Add security hardening to many library functions.
// 			Set to 1 or 2; 2 performs stricter checks than 1.
//
//    _REENTRANT, _THREAD_SAFE
// 			Obsolete; equivalent to _POSIX_C_SOURCE=199506L.
//
//    The `-ansi' switch to the GNU C compiler, and standards conformance
//    options such as `-std=c99', define __STRICT_ANSI__.  If none of
//    these are defined, or if _DEFAULT_SOURCE is defined, the default is
//    to have _POSIX_SOURCE set to one and _POSIX_C_SOURCE set to
//    200809L, as well as enabling miscellaneous functions from BSD and
//    SVID.  If more than one of these are defined, they accumulate.  For
//    example __STRICT_ANSI__, _POSIX_SOURCE and _POSIX_C_SOURCE together
//    give you ISO C, 1003.1, and 1003.2, but nothing else.
//
//    These are defined by this file and are used by the
//    header files to decide what to declare or define:
//
//    __GLIBC_USE (F)	Define things from feature set F.  This is defined
// 			to 1 or 0; the subsequent macros are either defined
// 			or undefined, and those tests should be moved to
// 			__GLIBC_USE.
//    __USE_ISOC11		Define ISO C11 things.
//    __USE_ISOC99		Define ISO C99 things.
//    __USE_ISOC95		Define ISO C90 AMD1 (C95) things.
//    __USE_ISOCXX11	Define ISO C++11 things.
//    __USE_POSIX		Define IEEE Std 1003.1 things.
//    __USE_POSIX2		Define IEEE Std 1003.2 things.
//    __USE_POSIX199309	Define IEEE Std 1003.1, and .1b things.
//    __USE_POSIX199506	Define IEEE Std 1003.1, .1b, .1c and .1i things.
//    __USE_XOPEN		Define XPG things.
//    __USE_XOPEN_EXTENDED	Define X/Open Unix things.
//    __USE_UNIX98		Define Single Unix V2 things.
//    __USE_XOPEN2K        Define XPG6 things.
//    __USE_XOPEN2KXSI     Define XPG6 XSI things.
//    __USE_XOPEN2K8       Define XPG7 things.
//    __USE_XOPEN2K8XSI    Define XPG7 XSI things.
//    __USE_LARGEFILE	Define correct standard I/O things.
//    __USE_LARGEFILE64	Define LFS things with separate names.
//    __USE_FILE_OFFSET64	Define 64bit interface as default.
//    __USE_MISC		Define things from 4.3BSD or System V Unix.
//    __USE_ATFILE		Define *at interfaces and AT_* constants for them.
//    __USE_GNU		Define GNU extensions.
//    __USE_FORTIFY_LEVEL	Additional security measures used, according to level.
//
//    The macros `__GNU_LIBRARY__', `__GLIBC__', and `__GLIBC_MINOR__' are
//    defined by this file unconditionally.  `__GNU_LIBRARY__' is provided
//    only for compatibility.  All new code should use the other symbols
//    to test for features.
//
//    All macros listed above as possibly being defined by this file are
//    explicitly undefined if they are not explicitly defined.
//    Feature-test macros that are not defined by the user or compiler
//    but are implied by the other feature-test macros defined (or by the
//    lack of any definitions) are defined by the file.
//
//    ISO C feature test macros depend on the definition of the macro
//    when an affected header is included, not when the first system
//    header is included, and so they are handled in
//    <bits/libc-header-start.h>, which does not have a multiple include
//    guard.  Feature test macros that can be handled from the first
//    system header included are handled here.

// Undefine everything, so we get a clean slate.

// Suppress kernel-name space pollution unless user expressedly asks
//    for it.

// Convenience macro to test the version of gcc.
//    Use like this:
//    #if __GNUC_PREREQ (2,8)
//    ... code requiring gcc 2.8 or later ...
//    #endif
//    Note: only works for GCC 2.0 and later, because __GNUC_MINOR__ was
//    added in 2.0.

// Similarly for clang.  Features added to GCC after version 4.2 may
//    or may not also be available in clang, and clang's definitions of
//    __GNUC(_MINOR)__ are fixed at 4 and 2 respectively.  Not all such
//    features can be queried via __has_extension/__has_feature.

// Whether to use feature set F.

// _BSD_SOURCE and _SVID_SOURCE are deprecated aliases for
//    _DEFAULT_SOURCE.  If _DEFAULT_SOURCE is present we do not
//    issue a warning; the expectation is that the source is being
//    transitioned to use the new macro.

// If _GNU_SOURCE was defined by the user, turn on all the other features.

// If nothing (other than _GNU_SOURCE and _DEFAULT_SOURCE) is defined,
//    define _DEFAULT_SOURCE.

// This is to enable the ISO C2X extension.

// This is to enable the ISO C11 extension.

// This is to enable the ISO C99 extension.

// This is to enable the ISO C90 Amendment 1:1995 extension.

// If none of the ANSI/POSIX macros are defined, or if _DEFAULT_SOURCE
//    is defined, use POSIX.1-2008 (or another version depending on
//    _XOPEN_SOURCE).

// Some C libraries once required _REENTRANT and/or _THREAD_SAFE to be
//    defined in all multithreaded code.  GNU libc has not required this
//    for many years.  We now treat them as compatibility synonyms for
//    _POSIX_C_SOURCE=199506L, which is the earliest level of POSIX with
//    comprehensive support for multithreaded code.  Using them never
//    lowers the selected level of POSIX conformance, only raises it.

// The function 'gets' existed in C89, but is impossible to use
//    safely.  It has been removed from ISO C11 and ISO C++14.  Note: for
//    compatibility with various implementations of <cstdio>, this test
//    must consider only the value of __cplusplus when compiling C++.

// GNU formerly extended the scanf functions with modified format
//    specifiers %as, %aS, and %a[...] that allocate a buffer for the
//    input using malloc.  This extension conflicts with ISO C99, which
//    defines %a as a standalone format specifier that reads a floating-
//    point number; moreover, POSIX.1-2008 provides the same feature
//    using the modifier letter 'm' instead (%ms, %mS, %m[...]).
//
//    We now follow C99 unless GNU extensions are active and the compiler
//    is specifically in C89 or C++98 mode (strict or not).  For
//    instance, with GCC, -std=gnu11 will have C99-compliant scanf with
//    or without -D_GNU_SOURCE, but -std=c89 -D_GNU_SOURCE will have the
//    old extension.

// Get definitions of __STDC_* predefined macros, if the compiler has
//    not preincluded this header automatically.
// Copyright (C) 1991-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

// This macro indicates that the installed library is the GNU C Library.
//    For historic reasons the value now is 6 and this will stay from now
//    on.  The use of this variable is deprecated.  Use __GLIBC__ and
//    __GLIBC_MINOR__ now (see below) when you want to test for a specific
//    GNU C library version and use the values in <gnu/lib-names.h> to get
//    the sonames of the shared libraries.

// Major and minor version number of the GNU C library package.  Use
//    these macros to test for features in specific releases.

// This is here only because every header file already includes this one.
// Copyright (C) 1992-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

// We are almost always included from features.h.

// The GNU libc does not support any K&R compilers or the traditional mode
//    of ISO C compilers anymore.  Check for some of the combinations not
//    anymore supported.

// Some user header file might have defined this before.

// All functions, except those with callbacks or those that
//    synchronize memory, are leaf functions.

// GCC can always grok prototypes.  For C++ programs we add throw()
//    to help it optimize the function calls.  But this works only with
//    gcc 2.8.x and egcs.  For gcc 3.2 and up we even mark C functions
//    as non-throwing using a function attribute since programs can use
//    the -fexceptions options for C code as well.

// Compilers that are not clang may object to
//        #if defined __clang__ && __has_extension(...)
//    even though they do not need to evaluate the right-hand side of the &&.

// These two macros are not used in glibc anymore.  They are kept here
//    only because some other projects expect the macros to be defined.

// For these things, GCC behaves the ANSI way normally,
//    and the non-ANSI way under -traditional.

// This is not a typedef so `const __ptr_t' does the right thing.

// C++ needs to know that types and declarations are C, not C++.

// Fortify support.

// Support for flexible arrays.
//    Headers that should use flexible arrays only if they're "real"
//    (e.g. only if they won't affect sizeof()) should test
//    #if __glibc_c99_flexarr_available.

// __asm__ ("xyz") is used throughout the headers to rename functions
//    at the assembly language level.  This is wrapped by the __REDIRECT
//    macro, in order to support compilers that can do this some other
//    way.  When compilers don't support asm-names at all, we have to do
//    preprocessor tricks instead (which don't have exactly the right
//    semantics, but it's the best we can do).
//
//    Example:
//    int __REDIRECT(setpgrp, (__pid_t pid, __pid_t pgrp), setpgid);

//
// #elif __SOME_OTHER_COMPILER__
//
// # define __REDIRECT(name, proto, alias) name proto; 	_Pragma("let " #name " = " #alias)

// GCC has various useful declarations that can be made with the
//    `__attribute__' syntax.  All of the ways we use this do fine if
//    they are omitted for compilers that don't understand it.

// At some point during the gcc 2.96 development the `malloc' attribute
//    for functions was introduced.  We don't want to use it unconditionally
//    (although this would be possible) since it generates warnings.

// Tell the compiler which arguments to an allocation function
//    indicate the size of the allocation.

// At some point during the gcc 2.96 development the `pure' attribute
//    for functions was introduced.  We don't want to use it unconditionally
//    (although this would be possible) since it generates warnings.

// This declaration tells the compiler that the value is constant.

// At some point during the gcc 3.1 development the `used' attribute
//    for functions was introduced.  We don't want to use it unconditionally
//    (although this would be possible) since it generates warnings.

// Since version 3.2, gcc allows marking deprecated functions.

// Since version 4.5, gcc also allows one to specify the message printed
//    when a deprecated function is used.  clang claims to be gcc 4.2, but
//    may also support this feature.

// At some point during the gcc 2.8 development the `format_arg' attribute
//    for functions was introduced.  We don't want to use it unconditionally
//    (although this would be possible) since it generates warnings.
//    If several `format_arg' attributes are given for the same function, in
//    gcc-3.0 and older, all but the last one are ignored.  In newer gccs,
//    all designated arguments are considered.

// At some point during the gcc 2.97 development the `strfmon' format
//    attribute for functions was introduced.  We don't want to use it
//    unconditionally (although this would be possible) since it
//    generates warnings.

// The nonull function attribute allows to mark pointer parameters which
//    must not be NULL.

// If fortification mode, we warn about unused results of certain
//    function calls which can lead to problems.

// Forces a function to be always inlined.
// The Linux kernel defines __always_inline in stddef.h (283d7573), and
//    it conflicts with this definition.  Therefore undefine it first to
//    allow either header to be included first.

// Associate error messages with the source location of the call site rather
//    than with the source location inside the function.

// GCC 4.3 and above with -std=c99 or -std=gnu99 implements ISO C99
//    inline semantics, unless -fgnu89-inline is used.  Using __GNUC_STDC_INLINE__
//    or __GNUC_GNU_INLINE is not a good enough check for gcc because gcc versions
//    older than 4.3 may define these macros and still not guarantee GNU inlining
//    semantics.
//
//    clang++ identifies itself as gcc-4.2, but has support for GNU inlining
//    semantics, that can be checked for by using the __GNUC_STDC_INLINE_ and
//    __GNUC_GNU_INLINE__ macro definitions.

// GCC 4.3 and above allow passing all anonymous arguments of an
//    __extern_always_inline function to some other vararg function.

// It is possible to compile containing GCC extensions even if GCC is
//    run in pedantic mode if the uses are carefully marked using the
//    `__extension__' keyword.  But this is not generally available before
//    version 2.8.

// __restrict is known in EGCS 1.2 and above.

// ISO C99 also allows to declare arrays as non-overlapping.  The syntax is
//      array_name[restrict]
//    GCC 3.1 supports this.

// Describes a char array whose address can safely be passed as the first
//    argument to strncpy and strncat, as the char array is not necessarily
//    a NUL-terminated string.

// Undefine (also defined in libc-symbols.h).
// Copies attributes from the declaration or type referenced by
//    the argument.

// Determine the wordsize from the preprocessor defines.

// Properties of long double type.  ldbl-opt version.
//    Copyright (C) 2016-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License  published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

// __glibc_macro_warning (MESSAGE) issues warning MESSAGE.  This is
//    intended for use in preprocessor macros.
//
//    Note: MESSAGE must be a _single_ string; concatenation of string
//    literals is not supported.

// Generic selection (ISO C11) is a C-only feature, available in GCC
//    since version 4.9.  Previous versions do not provide generic
//    selection, even though they might set __STDC_VERSION__ to 201112L,
//    when in -std=c11 mode.  Thus, we must check for !defined __GNUC__
//    when testing __STDC_VERSION__ for generic selection support.
//    On the other hand, Clang also defines __GNUC__, so a clang-specific
//    check is required to enable the use of generic selection.

// If we don't have __REDIRECT, prototypes will be missing if
//    __USE_FILE_OFFSET64 but not __USE_LARGEFILE[64].

// Decide whether we can define 'extern inline' functions in headers.

// This is here only because every header file already includes this one.
//    Get the definitions of all the appropriate `__stub_FUNCTION' symbols.
//    <gnu/stubs.h> contains `#define __stub_FUNCTION' when FUNCTION is a stub
//    that will always return failure (and set errno to ENOSYS).
// This file is automatically generated.
//    This file selects the right generated file of `__stub_FUNCTION' macros
//    based on the architecture being compiled for.

// Determine the wordsize from the preprocessor defines.

// This file is automatically generated.
//    It defines a symbol `__stub_FUNCTION' for each function
//    in the C library which is a stub, meaning it will fail
//    every time called, usually setting errno to ENOSYS.

// ISO/IEC TR 24731-2:2010 defines the __STDC_WANT_LIB_EXT2__
//    macro.

// ISO/IEC TS 18661-1:2014 defines the __STDC_WANT_IEC_60559_BFP_EXT__
//    macro.  Most but not all symbols enabled by that macro in TS
//    18661-1 are enabled unconditionally in C2X; the symbols in Annex F
//    still require that macro in C2X.

// ISO/IEC TS 18661-4:2015 defines the
//    __STDC_WANT_IEC_60559_FUNCS_EXT__ macro.  Other than the reduction
//    functions, the symbols from this TS are enabled unconditionally in
//    C2X.

// ISO/IEC TS 18661-3:2015 defines the
//    __STDC_WANT_IEC_60559_TYPES_EXT__ macro.

// Maximum length of any multibyte character in any locale.
//    We define this value here since the gcc header does not define
//    the correct value.

// If we are not using GNU CC we have to define all the symbols ourself.
//    Otherwise use gcc's definitions (see below).

// Get the compiler's limits.h, which defines almost all the ISO constants.
//
//     We put this #include_next outside the double inclusion check because
//     it should be possible to include this file more than once and still get
//     the definitions from gcc's header.

// The <limits.h> files in some gcc versions don't define LLONG_MIN,
//    LLONG_MAX, and ULLONG_MAX.  Instead only the values gcc defined for
//    ages are available.

// The integer width macros are not defined by GCC's <limits.h> before
//    GCC 7, or if _GNU_SOURCE rather than
//    __STDC_WANT_IEC_60559_BFP_EXT__ is used to enable this feature.

// POSIX adds things to <limits.h>.
// Copyright (C) 1991-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

//	POSIX Standard: 2.9.2 Minimum Values	Added to <limits.h>
//
//	Never include this file directly; use <limits.h> instead.

// Determine the wordsize from the preprocessor defines.

// These are the standard-mandated minimum values.

// Minimum number of operations in one list I/O call.

// Minimal number of outstanding asynchronous I/O operations.

// Maximum length of arguments to `execve', including environment.

// Maximum simultaneous processes per real user ID.

// Minimal number of timer expiration overruns.

// Maximum length of a host name (not including the terminating null)
//    as returned from the GETHOSTNAME function.

// Maximum link count of a file.

// Maximum length of login name.

// Number of bytes in a terminal canonical input queue.

// Number of bytes for which space will be
//    available in a terminal input queue.

// Maximum number of message queues open for a process.

// Maximum number of supported message priorities.

// Number of bytes in a filename.

// Number of simultaneous supplementary group IDs per process.

// Number of files one process can have open at once.

// Number of bytes in a pathname.

// Number of bytes than can be written atomically to a pipe.

// The number of repeated occurrences of a BRE permitted by the
//    REGEXEC and REGCOMP functions when using the interval notation.

// Minimal number of realtime signals reserved for the application.

// Number of semaphores a process can have.

// Maximal value of a semaphore.

// Number of pending realtime signals.

// Largest value of a `ssize_t'.

// Number of streams a process can have open at once.

// The number of bytes in a symbolic link.

// The number of symbolic links that can be traversed in the
//    resolution of a pathname in the absence of a loop.

// Number of timer for a process.

// Maximum number of characters in a tty name.

// Maximum length of a timezone name (element of `tzname').

// Maximum clock resolution in nanoseconds.

// Get the implementation-specific values for the above.
// Minimum guaranteed maximum values for system limits.  Linux/PPC version.
//    Copyright (C) 1993-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public License as
//    published by the Free Software Foundation; either version 2.1 of the
//    License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; see the file COPYING.LIB.  If
//    not, see <https://www.gnu.org/licenses/>.

// The kernel header pollutes the namespace with the NR_OPEN symbol
//    and defines LINK_MAX although filesystems have different maxima.  A
//    similar thing is true for OPEN_MAX: the limit can be changed at
//    runtime and therefore the macro must not be defined.  Remove this
//    after including the header if necessary.

// The kernel sources contain a file with all the needed information.
// SPDX-License-Identifier: GPL-2.0 WITH Linux-syscall-note

// Have to remove NR_OPEN?
// Have to remove LINK_MAX?
// Have to remove OPEN_MAX?
// Have to remove ARG_MAX?

// The number of data keys per process.
// This is the value this implementation supports.

// Controlling the iterations of destructors for thread-specific data.
// Number of iterations this implementation does.

// The number of threads per process.
// We have no predefined limit on the number of threads.

// Maximum amount by which a process can descrease its asynchronous I/O
//    priority level.

// Minimum size for a thread.  At least two pages for systems with 64k
//    pages.

// Maximum number of timer expiration overruns.

// Maximum tty name length.

// Maximum login name length.  This is arbitrary.

// Maximum host name length.

// Maximum message queue priority level.

// Maximum value the semaphore can have.

// ssize_t is not formally required to be the signed type
//    corresponding to size_t, but it is for all configurations supported
//    by glibc.

// This value is a guaranteed minimum maximum.
//    The current maximum can be got from `sysconf'.

// Copyright (C) 1991-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

// Never include this file directly; include <limits.h> instead.

// The maximum `ibase' and `obase' values allowed by the `bc' utility.

// The maximum number of elements allowed in an array by the `bc' utility.

// The maximum `scale' value allowed by the `bc' utility.

// The maximum length of a string constant accepted by the `bc' utility.

// The maximum number of weights that can be assigned to an entry of
//    the LC_COLLATE `order' keyword in the locale definition file.

// The maximum number of expressions that can be nested
//    within parentheses by the `expr' utility.

// The maximum length, in bytes, of an input line.

// The maximum number of repeated occurrences of a regular expression
//    permitted when using the interval notation `\{M,N\}'.

// The maximum number of bytes in a character class name.  We have no
//    fixed limit, 2048 is a high number.

// These values are implementation-specific,
//    and may vary within the implementation.
//    Their precise values can be obtained from sysconf.

// This value is defined like this in regex.h.

// Copyright (C) 1991-2020 Free Software Foundation, Inc.
//
// This file is part of GCC.
//
// GCC is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 3, or (at your option) any later
// version.
//
// GCC is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// Under Section 7 of GPL version 3, you are granted additional
// permissions described in the GCC Runtime Library Exception, version
// 3.1, as published by the Free Software Foundation.
//
// You should have received a copy of the GNU General Public License and
// a copy of the GCC Runtime Library Exception along with this program;
// see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
// <http://www.gnu.org/licenses/>.

// Number of bits in a `char'.

// Maximum length of a multibyte character.

// Minimum and maximum values a `signed char' can hold.

// Maximum value an `unsigned char' can hold.  (Minimum is 0).

// Minimum and maximum values a `char' can hold.

// Minimum and maximum values a `signed short int' can hold.

// Maximum value an `unsigned short int' can hold.  (Minimum is 0).

// Minimum and maximum values a `signed int' can hold.

// Maximum value an `unsigned int' can hold.  (Minimum is 0).

// Minimum and maximum values a `signed long int' can hold.
//    (Same as `int').

// Maximum value an `unsigned long int' can hold.  (Minimum is 0).

// Minimum and maximum values a `signed long long int' can hold.

// Maximum value an `unsigned long long int' can hold.  (Minimum is 0).

// This administrivia gets added to the end of limits.h
//    if the system has its own version of limits.h.

type z_crc_t = uint32 /* zconf.h:429:17 */

// Seconds since the Epoch, visible to user code when time_t is too
//    narrow only for consistency with the old way of widening too-narrow
//    types.  User code should never use __time64_t.

type u_char = uint8                    /* types.h:33:18 */
type u_short = uint16                  /* types.h:34:19 */
type u_int = uint32                    /* types.h:35:17 */
type u_long = uint64                   /* types.h:36:18 */
type quad_t = int64                    /* types.h:37:18 */
type u_quad_t = uint64                 /* types.h:38:20 */
type fsid_t = struct{ __val [2]int32 } /* types.h:39:18 */
type loff_t = int64                    /* types.h:42:18 */

type ino_t = uint64   /* types.h:49:19 */
type ino64_t = uint64 /* types.h:54:19 */

type dev_t = uint64 /* types.h:59:17 */

type gid_t = uint32 /* types.h:64:17 */

type mode_t = uint32 /* types.h:69:18 */

type nlink_t = uint64 /* types.h:74:19 */

type uid_t = uint32 /* types.h:79:17 */

type off_t = int64   /* types.h:87:19 */
type off64_t = int64 /* types.h:92:19 */

type pid_t = int32 /* types.h:97:17 */

type id_t = uint32 /* types.h:103:16 */

type ssize_t = int64 /* types.h:108:19 */

type daddr_t = int32   /* types.h:114:19 */
type caddr_t = uintptr /* types.h:115:19 */

type key_t = int32 /* types.h:121:17 */

// bits/types.h -- definitions of __*_t types underlying *_t types.
//    Copyright (C) 2002-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

// Never include this file directly; use <sys/types.h> instead.

// Returned by `clock'.
type clock_t = int64 /* clock_t.h:7:19 */

// bits/types.h -- definitions of __*_t types underlying *_t types.
//    Copyright (C) 2002-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

// Never include this file directly; use <sys/types.h> instead.

// Clock ID used in clock and timer functions.
type clockid_t = int32 /* clockid_t.h:7:21 */

// bits/types.h -- definitions of __*_t types underlying *_t types.
//    Copyright (C) 2002-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

// Never include this file directly; use <sys/types.h> instead.

// Returned by `time'.
type time_t = int64 /* time_t.h:7:18 */

// bits/types.h -- definitions of __*_t types underlying *_t types.
//    Copyright (C) 2002-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

// Never include this file directly; use <sys/types.h> instead.

// Timer ID returned by `timer_create'.
type timer_t = uintptr /* timer_t.h:7:19 */

// Copyright (C) 1989-2020 Free Software Foundation, Inc.
//
// This file is part of GCC.
//
// GCC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// GCC is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// Under Section 7 of GPL version 3, you are granted additional
// permissions described in the GCC Runtime Library Exception, version
// 3.1, as published by the Free Software Foundation.
//
// You should have received a copy of the GNU General Public License and
// a copy of the GCC Runtime Library Exception along with this program;
// see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
// <http://www.gnu.org/licenses/>.

// ISO C Standard:  7.17  Common definitions  <stddef.h>

// Any one of these symbols __need_* means that GNU libc
//    wants us just to define one data type.  So don't define
//    the symbols that indicate this file's entire job has been done.

// This avoids lossage on SunOS but only if stdtypes.h comes first.
//    There's no way to win with the other order!  Sun lossage.

// Sequent's header files use _PTRDIFF_T_ in some conflicting way.
//    Just ignore it.

// On VxWorks, <type/vxTypesBase.h> may have defined macros like
//    _TYPE_size_t which will typedef size_t.  fixincludes patched the
//    vxTypesBase.h so that this macro is only defined if _GCC_SIZE_T is
//    not defined, and so that defining this macro defines _GCC_SIZE_T.
//    If we find that the macros are still defined at this point, we must
//    invoke them so that the type is defined as expected.

// In case nobody has defined these types, but we aren't running under
//    GCC 2.00, make sure that __PTRDIFF_TYPE__, __SIZE_TYPE__, and
//    __WCHAR_TYPE__ have reasonable values.  This can happen if the
//    parts of GCC is compiled by an older compiler, that actually
//    include gstddef.h, such as collect2.

// Signed type of difference of two pointers.

// Define this type if we are doing the whole job,
//    or if we want this type in particular.

// If this symbol has done its job, get rid of it.

// Unsigned type of `sizeof' something.

// Define this type if we are doing the whole job,
//    or if we want this type in particular.

// Wide character type.
//    Locale-writers should change this as necessary to
//    be big enough to hold unique values not between 0 and 127,
//    and not (wchar_t) -1, for each defined multibyte character.

// Define this type if we are doing the whole job,
//    or if we want this type in particular.

// A null pointer constant.

// Offset of member MEMBER in a struct of type TYPE.

// Old compatibility names for C types.
type ulong = uint64  /* types.h:148:27 */
type ushort = uint16 /* types.h:149:28 */
type uint = uint32   /* types.h:150:22 */

// These size-specific names are used by some of the inet code.

// Define intN_t types.
//    Copyright (C) 2017-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

// bits/types.h -- definitions of __*_t types underlying *_t types.
//    Copyright (C) 2002-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

// Never include this file directly; use <sys/types.h> instead.

type int8_t = int8   /* stdint-intn.h:24:18 */
type int16_t = int16 /* stdint-intn.h:25:19 */
type int32_t = int32 /* stdint-intn.h:26:19 */
type int64_t = int64 /* stdint-intn.h:27:19 */

// These were defined by ISO C without the first `_'.
type u_int8_t = uint8   /* types.h:158:19 */
type u_int16_t = uint16 /* types.h:159:20 */
type u_int32_t = uint32 /* types.h:160:20 */
type u_int64_t = uint64 /* types.h:161:20 */

type register_t = int32 /* types.h:164:13 */

// A set of signals to be blocked, unblocked, or waited for.
type sigset_t = struct{ __val [16]uint64 } /* sigset_t.h:7:20 */

// Get definition of timer specification structures.

// bits/types.h -- definitions of __*_t types underlying *_t types.
//    Copyright (C) 2002-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

// Never include this file directly; use <sys/types.h> instead.

// A time value that is accurate to the nearest
//    microsecond but also has a range of years.
type timeval = struct {
	tv_sec  int64
	tv_usec int64
} /* struct_timeval.h:8:1 */

// NB: Include guard matches what <linux/time.h> uses.

// bits/types.h -- definitions of __*_t types underlying *_t types.
//    Copyright (C) 2002-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

// Never include this file directly; use <sys/types.h> instead.

// Endian macros for string.h functions
//    Copyright (C) 1992-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <http://www.gnu.org/licenses/>.

// POSIX.1b structure for a time value.  This is like a `struct timeval' but
//    has nanoseconds instead of microseconds.
type timespec = struct {
	tv_sec  int64
	tv_nsec int64
} /* struct_timespec.h:10:1 */

type suseconds_t = int64 /* select.h:43:23 */

// Some versions of <linux/posix_types.h> define this macros.
// It's easier to assume 8-bit bytes than to get CHAR_BIT.

// fd_set for select and pselect.
type fd_set = struct{ __fds_bits [16]int64 } /* select.h:70:5 */

// Maximum number of file descriptors in `fd_set'.

// Sometimes the fd_set member is assumed to have this type.
type fd_mask = int64 /* select.h:77:19 */

// Define some inlines helping to catch common problems.

type blksize_t = int64 /* types.h:185:21 */

// Types from the Large File Support interface.
type blkcnt_t = int64    /* types.h:205:22 */ // Type to count number of disk blocks.
type fsblkcnt_t = uint64 /* types.h:209:24 */ // Type to count file system blocks.
type fsfilcnt_t = uint64 /* types.h:213:24 */ // Type to count file system inodes.

type blkcnt64_t = int64    /* types.h:219:22 */ // Type to count number of disk blocks.
type fsblkcnt64_t = uint64 /* types.h:220:24 */ // Type to count file system blocks.
type fsfilcnt64_t = uint64 /* types.h:221:24 */ // Type to count file system inodes.

// Now add the thread types.
// Declaration of common pthread types for all architectures.
//    Copyright (C) 2017-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

// For internal mutex and condition variable definitions.
// Common threading primitives definitions for both POSIX and C11.
//    Copyright (C) 2017-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

// Arch-specific definitions.  Each architecture must define the following
//    macros to define the expected sizes of pthread data types:
//
//    __SIZEOF_PTHREAD_ATTR_T        - size of pthread_attr_t.
//    __SIZEOF_PTHREAD_MUTEX_T       - size of pthread_mutex_t.
//    __SIZEOF_PTHREAD_MUTEXATTR_T   - size of pthread_mutexattr_t.
//    __SIZEOF_PTHREAD_COND_T        - size of pthread_cond_t.
//    __SIZEOF_PTHREAD_CONDATTR_T    - size of pthread_condattr_t.
//    __SIZEOF_PTHREAD_RWLOCK_T      - size of pthread_rwlock_t.
//    __SIZEOF_PTHREAD_RWLOCKATTR_T  - size of pthread_rwlockattr_t.
//    __SIZEOF_PTHREAD_BARRIER_T     - size of pthread_barrier_t.
//    __SIZEOF_PTHREAD_BARRIERATTR_T - size of pthread_barrierattr_t.
//
//    The additional macro defines any constraint for the lock alignment
//    inside the thread structures:
//
//    __LOCK_ALIGNMENT - for internal lock/futex usage.
//
//    Same idea but for the once locking primitive:
//
//    __ONCE_ALIGNMENT - for pthread_once_t/once_flag definition.

// Machine-specific pthread type layouts.  Generic version.
//    Copyright (C) 2019-2020 Free Software Foundation, Inc.
//
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <http://www.gnu.org/licenses/>.

// Determine the wordsize from the preprocessor defines.

// Common definition of pthread_mutex_t.

type __pthread_internal_list = struct {
	__prev uintptr
	__next uintptr
} /* thread-shared-types.h:49:9 */

type __pthread_internal_slist = struct{ __next uintptr } /* thread-shared-types.h:55:9 */

// Arch-specific mutex definitions.  A generic implementation is provided
//    by sysdeps/nptl/bits/struct_mutex.h.  If required, an architecture
//    can override it by defining:
//
//    1. struct __pthread_mutex_s (used on both pthread_mutex_t and mtx_t
//       definition).  It should contains at least the internal members
//       defined in the generic version.
//
//    2. __LOCK_ALIGNMENT for any extra attribute for internal lock used with
//       atomic operations.
//
//    3. The macro __PTHREAD_MUTEX_INITIALIZER used for static initialization.
//       It should initialize the mutex internal flag.

// PowerPC internal mutex struct definitions.
//    Copyright (C) 2019-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <http://www.gnu.org/licenses/>.

type __pthread_mutex_s = struct {
	__lock    int32
	__count   uint32
	__owner   int32
	__nusers  uint32
	__kind    int32
	__spins   int16
	__elision int16
	__list    struct {
		__prev uintptr
		__next uintptr
	}
} /* struct_mutex.h:22:1 */

// Arch-sepecific read-write lock definitions.  A generic implementation is
//    provided by struct_rwlock.h.  If required, an architecture can override it
//    by defining:
//
//    1. struct __pthread_rwlock_arch_t (used on pthread_rwlock_t definition).
//       It should contain at least the internal members defined in the
//       generic version.
//
//    2. The macro __PTHREAD_RWLOCK_INITIALIZER used for static initialization.
//       It should initialize the rwlock internal type.

// PowerPC internal rwlock struct definitions.
//    Copyright (C) 2019-2020 Free Software Foundation, Inc.
//
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <http://www.gnu.org/licenses/>.

type __pthread_rwlock_arch_t = struct {
	__readers       uint32
	__writers       uint32
	__wrphase_futex uint32
	__writers_futex uint32
	__pad3          uint32
	__pad4          uint32
	__cur_writer    int32
	__shared        int32
	__rwelision     uint8
	__pad1          [7]uint8
	__pad2          uint64
	__flags         uint32
	_               [4]byte
} /* struct_rwlock.h:23:1 */

// Common definition of pthread_cond_t.

type __pthread_cond_s = struct {
	__0            struct{ __wseq uint64 }
	__8            struct{ __g1_start uint64 }
	__g_refs       [2]uint32
	__g_size       [2]uint32
	__g1_orig_size uint32
	__wrefs        uint32
	__g_signals    [2]uint32
} /* thread-shared-types.h:92:1 */

// Thread identifiers.  The structure of the attribute type is not
//    exposed on purpose.
type pthread_t = uint64 /* pthreadtypes.h:27:27 */

// Data structures for mutex handling.  The structure of the attribute
//    type is not exposed on purpose.
type pthread_mutexattr_t = struct {
	_      [0]uint32
	__size [4]uint8
} /* pthreadtypes.h:36:3 */

// Data structure for condition variable handling.  The structure of
//    the attribute type is not exposed on purpose.
type pthread_condattr_t = struct {
	_      [0]uint32
	__size [4]uint8
} /* pthreadtypes.h:45:3 */

// Keys for thread-specific data
type pthread_key_t = uint32 /* pthreadtypes.h:49:22 */

// Once-only execution
type pthread_once_t = int32 /* pthreadtypes.h:53:30 */

type pthread_attr_t1 = struct {
	_      [0]uint64
	__size [56]uint8
} /* pthreadtypes.h:56:1 */

type pthread_attr_t = pthread_attr_t1 /* pthreadtypes.h:62:30 */

type pthread_mutex_t = struct{ __data __pthread_mutex_s } /* pthreadtypes.h:72:3 */

type pthread_cond_t = struct{ __data __pthread_cond_s } /* pthreadtypes.h:80:3 */

// Data structure for reader-writer lock variable handling.  The
//    structure of the attribute type is deliberately not exposed.
type pthread_rwlock_t = struct{ __data __pthread_rwlock_arch_t } /* pthreadtypes.h:91:3 */

type pthread_rwlockattr_t = struct {
	_      [0]uint64
	__size [8]uint8
} /* pthreadtypes.h:97:3 */

// POSIX spinlock data type.
type pthread_spinlock_t = int32 /* pthreadtypes.h:103:22 */

// POSIX barriers data type.  The structure of the type is
//    deliberately not exposed.
type pthread_barrier_t = struct {
	_      [0]uint64
	__size [32]uint8
} /* pthreadtypes.h:112:3 */

type pthread_barrierattr_t = struct {
	_      [0]uint32
	__size [4]uint8
} /* pthreadtypes.h:118:3 */

// Define the standard macros for the user,
//    if this invocation was from the user program.

// Define va_list, if desired, from __gnuc_va_list.
// We deliberately do not define va_list when called from
//    stdio.h, because ANSI C says that stdio.h is not supposed to define
//    va_list.  stdio.h needs to have access to that data type,
//    but must not use that name.  It should use the name __gnuc_va_list,
//    which is safe because it is reserved for the implementation.

// The macro _VA_LIST_ is the same thing used by this file in Ultrix.
//    But on BSD NET2 we must not test or define or undef it.
//    (Note that the comments in NET 2's ansi.h
//    are incorrect for _VA_LIST_--see stdio.h!)
// The macro _VA_LIST_DEFINED is used in Windows NT 3.5
// The macro _VA_LIST is used in SCO Unix 3.2.
// The macro _VA_LIST_T_H is used in the Bull dpx2
// The macro __va_list__ is used by BeOS.
type va_list = uintptr /* stdarg.h:99:24 */

// a little trick to accommodate both "#define _LARGEFILE64_SOURCE" and
// "#define _LARGEFILE64_SOURCE 1" as requesting 64-bit operations, (even
// though the former does not conform to the LFS document), but considering
// both "#undef _LARGEFILE64_SOURCE" and "#define _LARGEFILE64_SOURCE 0" as
// equivalently requesting no 64-bit operations

// Copyright (C) 1991-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

//	POSIX Standard: 2.10 Symbolic Constants		<unistd.h>

// Copyright (C) 1991-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

// These may be used to determine what facilities are present at compile time.
//    Their values can be obtained at run time from `sysconf'.

// POSIX Standard approved as ISO/IEC 9945-1 as of September 2008.

// These are not #ifdef __USE_POSIX2 because they are
//    in the theoretically application-owned namespace.

// The utilities on GNU systems also correspond to this version.

// The utilities on GNU systems also correspond to this version.

// This symbol was required until the 2001 edition of POSIX.

// If defined, the implementation supports the
//    C Language Bindings Option.

// If defined, the implementation supports the
//    C Language Development Utilities Option.

// If defined, the implementation supports the
//    Software Development Utilities Option.

// If defined, the implementation supports the
//    creation of locales with the localedef utility.

// X/Open version number to which the library conforms.  It is selectable.

// Commands and utilities from XPG4 are available.

// We are compatible with the old published standards as well.

// The X/Open Unix extensions are available.

// The enhanced internationalization capabilities according to XPG4.2
//    are present.

// The legacy interfaces are also available.

// Get values of POSIX options:
//
//    If these symbols are defined, the corresponding features are
//    always available.  If not, they may be available sometimes.
//    The current values can be obtained with `sysconf'.
//
//    _POSIX_JOB_CONTROL		Job control is supported.
//    _POSIX_SAVED_IDS		Processes have a saved set-user-ID
// 				and a saved set-group-ID.
//    _POSIX_REALTIME_SIGNALS	Real-time, queued signals are supported.
//    _POSIX_PRIORITY_SCHEDULING	Priority scheduling is supported.
//    _POSIX_TIMERS		POSIX.4 clocks and timers are supported.
//    _POSIX_ASYNCHRONOUS_IO	Asynchronous I/O is supported.
//    _POSIX_PRIORITIZED_IO	Prioritized asynchronous I/O is supported.
//    _POSIX_SYNCHRONIZED_IO	Synchronizing file data is supported.
//    _POSIX_FSYNC			The fsync function is present.
//    _POSIX_MAPPED_FILES		Mapping of files to memory is supported.
//    _POSIX_MEMLOCK		Locking of all memory is supported.
//    _POSIX_MEMLOCK_RANGE		Locking of ranges of memory is supported.
//    _POSIX_MEMORY_PROTECTION	Setting of memory protections is supported.
//    _POSIX_MESSAGE_PASSING	POSIX.4 message queues are supported.
//    _POSIX_SEMAPHORES		POSIX.4 counting semaphores are supported.
//    _POSIX_SHARED_MEMORY_OBJECTS	POSIX.4 shared memory objects are supported.
//    _POSIX_THREADS		POSIX.1c pthreads are supported.
//    _POSIX_THREAD_ATTR_STACKADDR	Thread stack address attribute option supported.
//    _POSIX_THREAD_ATTR_STACKSIZE	Thread stack size attribute option supported.
//    _POSIX_THREAD_SAFE_FUNCTIONS	Thread-safe functions are supported.
//    _POSIX_THREAD_PRIORITY_SCHEDULING
// 				POSIX.1c thread execution scheduling supported.
//    _POSIX_THREAD_PRIO_INHERIT	Thread priority inheritance option supported.
//    _POSIX_THREAD_PRIO_PROTECT	Thread priority protection option supported.
//    _POSIX_THREAD_PROCESS_SHARED	Process-shared synchronization supported.
//    _POSIX_PII			Protocol-independent interfaces are supported.
//    _POSIX_PII_XTI		XTI protocol-indep. interfaces are supported.
//    _POSIX_PII_SOCKET		Socket protocol-indep. interfaces are supported.
//    _POSIX_PII_INTERNET		Internet family of protocols supported.
//    _POSIX_PII_INTERNET_STREAM	Connection-mode Internet protocol supported.
//    _POSIX_PII_INTERNET_DGRAM	Connectionless Internet protocol supported.
//    _POSIX_PII_OSI		ISO/OSI family of protocols supported.
//    _POSIX_PII_OSI_COTS		Connection-mode ISO/OSI service supported.
//    _POSIX_PII_OSI_CLTS		Connectionless ISO/OSI service supported.
//    _POSIX_POLL			Implementation supports `poll' function.
//    _POSIX_SELECT		Implementation supports `select' and `pselect'.
//
//    _XOPEN_REALTIME		X/Open realtime support is available.
//    _XOPEN_REALTIME_THREADS	X/Open realtime thread support is available.
//    _XOPEN_SHM			Shared memory interface according to XPG4.2.
//
//    _XBS5_ILP32_OFF32		Implementation provides environment with 32-bit
// 				int, long, pointer, and off_t types.
//    _XBS5_ILP32_OFFBIG		Implementation provides environment with 32-bit
// 				int, long, and pointer and off_t with at least
// 				64 bits.
//    _XBS5_LP64_OFF64		Implementation provides environment with 32-bit
// 				int, and 64-bit long, pointer, and off_t types.
//    _XBS5_LPBIG_OFFBIG		Implementation provides environment with at
// 				least 32 bits int and long, pointer, and off_t
// 				with at least 64 bits.
//
//    If any of these symbols is defined as -1, the corresponding option is not
//    true for any file.  If any is defined as other than -1, the corresponding
//    option is true for all files.  If a symbol is not defined at all, the value
//    for a specific file can be obtained from `pathconf' and `fpathconf'.
//
//    _POSIX_CHOWN_RESTRICTED	Only the super user can use `chown' to change
// 				the owner of a file.  `chown' can only be used
// 				to change the group ID of a file to a group of
// 				which the calling process is a member.
//    _POSIX_NO_TRUNC		Pathname components longer than
// 				NAME_MAX generate an error.
//    _POSIX_VDISABLE		If defined, if the value of an element of the
// 				`c_cc' member of `struct termios' is
// 				_POSIX_VDISABLE, no character will have the
// 				effect associated with that element.
//    _POSIX_SYNC_IO		Synchronous I/O may be performed.
//    _POSIX_ASYNC_IO		Asynchronous I/O may be performed.
//    _POSIX_PRIO_IO		Prioritized Asynchronous I/O may be performed.
//
//    Support for the Large File Support interface is not generally available.
//    If it is available the following constants are defined to one.
//    _LFS64_LARGEFILE		Low-level I/O supports large files.
//    _LFS64_STDIO			Standard I/O supports large files.
//

// Define POSIX options for Linux.
//    Copyright (C) 1996-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public License as
//    published by the Free Software Foundation; either version 2.1 of the
//    License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; see the file COPYING.LIB.  If
//    not, see <https://www.gnu.org/licenses/>.

// Job control is supported.

// Processes have a saved set-user-ID and a saved set-group-ID.

// Priority scheduling is not supported with the correct semantics,
//    but GNU/Linux applications expect that the corresponding interfaces
//    are available, even though the semantics do not meet the POSIX
//    requirements.  See glibc bug 14829.

// Synchronizing file data is supported.

// The fsync function is present.

// Mapping of files to memory is supported.

// Locking of all memory is supported.

// Locking of ranges of memory is supported.

// Setting of memory protections is supported.

// Some filesystems allow all users to change file ownership.

// `c_cc' member of 'struct termios' structure can be disabled by
//    using the value _POSIX_VDISABLE.

// Filenames are not silently truncated.

// X/Open realtime support is available.

// X/Open thread realtime support is available.

// XPG4.2 shared memory is supported.

// Tell we have POSIX threads.

// We have the reentrant functions described in POSIX.

// We provide priority scheduling for threads.

// We support user-defined stack sizes.

// We support user-defined stacks.

// We support priority inheritence.

// We support priority protection, though only for non-robust
//    mutexes.

// We support priority inheritence for robust mutexes.

// We do not support priority protection for robust mutexes.

// We support POSIX.1b semaphores.

// Real-time signals are supported.

// We support asynchronous I/O.
// Alternative name for Unix98.
// Support for prioritization is also available.

// The LFS support in asynchronous I/O is also available.

// The rest of the LFS is also available.

// POSIX shared memory objects are implemented.

// CPU-time clocks support needs to be checked at runtime.

// Clock support in threads must be also checked at runtime.

// GNU libc provides regular expression handling.

// Reader/Writer locks are available.

// We have a POSIX shell.

// We support the Timeouts option.

// We support spinlocks.

// The `spawn' function family is supported.

// We have POSIX timers.

// The barrier functions are available.

// POSIX message queues are available.

// Thread process-shared synchronization is supported.

// The monotonic clock might be available.

// The clock selection interfaces are available.

// Advisory information interfaces are available.

// IPv6 support is available.

// Raw socket support is available.

// We have at least one terminal.

// Neither process nor thread sporadic server interfaces is available.

// trace.h is not available.

// Typed memory objects are not available.

// Get the environment definitions from Unix98.
// Copyright (C) 1999-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

// Determine the wordsize from the preprocessor defines.

// This header should define the following symbols under the described
//    situations.  A value `1' means that the model is always supported,
//    `-1' means it is never supported.  Undefined means it cannot be
//    statically decided.
//
//    _POSIX_V7_ILP32_OFF32   32bit int, long, pointers, and off_t type
//    _POSIX_V7_ILP32_OFFBIG  32bit int, long, and pointers and larger off_t type
//
//    _POSIX_V7_LP64_OFF32	   64bit long and pointers and 32bit off_t type
//    _POSIX_V7_LPBIG_OFFBIG  64bit long and pointers and large off_t type
//
//    The macros _POSIX_V6_ILP32_OFF32, _POSIX_V6_ILP32_OFFBIG,
//    _POSIX_V6_LP64_OFF32, _POSIX_V6_LPBIG_OFFBIG, _XBS5_ILP32_OFF32,
//    _XBS5_ILP32_OFFBIG, _XBS5_LP64_OFF32, and _XBS5_LPBIG_OFFBIG were
//    used in previous versions of the Unix standard and are available
//    only for compatibility.

// Environments with 32-bit wide pointers are optionally provided.
//    Therefore following macros aren't defined:
//    # undef _POSIX_V7_ILP32_OFF32
//    # undef _POSIX_V7_ILP32_OFFBIG
//    # undef _POSIX_V6_ILP32_OFF32
//    # undef _POSIX_V6_ILP32_OFFBIG
//    # undef _XBS5_ILP32_OFF32
//    # undef _XBS5_ILP32_OFFBIG
//    and users need to check at runtime.

// We also have no use (for now) for an environment with bigger pointers
//    and offsets.

// By default we have 64-bit wide `long int', pointers and `off_t'.

// Standard file descriptors.

// All functions that are not declared anywhere else.

// bits/types.h -- definitions of __*_t types underlying *_t types.
//    Copyright (C) 2002-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

// Never include this file directly; use <sys/types.h> instead.

// Copyright (C) 1989-2020 Free Software Foundation, Inc.
//
// This file is part of GCC.
//
// GCC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// GCC is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// Under Section 7 of GPL version 3, you are granted additional
// permissions described in the GCC Runtime Library Exception, version
// 3.1, as published by the Free Software Foundation.
//
// You should have received a copy of the GNU General Public License and
// a copy of the GCC Runtime Library Exception along with this program;
// see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
// <http://www.gnu.org/licenses/>.

// ISO C Standard:  7.17  Common definitions  <stddef.h>

// Any one of these symbols __need_* means that GNU libc
//    wants us just to define one data type.  So don't define
//    the symbols that indicate this file's entire job has been done.

// This avoids lossage on SunOS but only if stdtypes.h comes first.
//    There's no way to win with the other order!  Sun lossage.

// Sequent's header files use _PTRDIFF_T_ in some conflicting way.
//    Just ignore it.

// On VxWorks, <type/vxTypesBase.h> may have defined macros like
//    _TYPE_size_t which will typedef size_t.  fixincludes patched the
//    vxTypesBase.h so that this macro is only defined if _GCC_SIZE_T is
//    not defined, and so that defining this macro defines _GCC_SIZE_T.
//    If we find that the macros are still defined at this point, we must
//    invoke them so that the type is defined as expected.

// In case nobody has defined these types, but we aren't running under
//    GCC 2.00, make sure that __PTRDIFF_TYPE__, __SIZE_TYPE__, and
//    __WCHAR_TYPE__ have reasonable values.  This can happen if the
//    parts of GCC is compiled by an older compiler, that actually
//    include gstddef.h, such as collect2.

// Signed type of difference of two pointers.

// Define this type if we are doing the whole job,
//    or if we want this type in particular.

// If this symbol has done its job, get rid of it.

// Unsigned type of `sizeof' something.

// Define this type if we are doing the whole job,
//    or if we want this type in particular.

// Wide character type.
//    Locale-writers should change this as necessary to
//    be big enough to hold unique values not between 0 and 127,
//    and not (wchar_t) -1, for each defined multibyte character.

// Define this type if we are doing the whole job,
//    or if we want this type in particular.

// A null pointer constant.

// Offset of member MEMBER in a struct of type TYPE.

// The Single Unix specification says that some more types are
//    available here.

type useconds_t = uint32 /* unistd.h:255:22 */

type intptr_t = int64 /* unistd.h:267:20 */

type socklen_t = uint32 /* unistd.h:274:21 */

// Define some macros helping to catch buffer overflows.

// System-specific extensions.
// System-specific extensions of <unistd.h>, Linux version.
//    Copyright (C) 2019-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

// MVS linker does not support external names larger than 8 bytes

//
//     The 'zlib' compression library provides in-memory compression and
//   decompression functions, including integrity checks of the uncompressed data.
//   This version of the library supports only one compression method (deflation)
//   but other algorithms will be added later and will have the same stream
//   interface.
//
//     Compression can be done in a single step if the buffers are large enough,
//   or can be done by repeated calls of the compression function.  In the latter
//   case, the application must provide more input and/or consume the output
//   (providing more output space) before each call.
//
//     The compressed data format used by default by the in-memory functions is
//   the zlib format, which is a zlib wrapper documented in RFC 1950, wrapped
//   around a deflate stream, which is itself documented in RFC 1951.
//
//     The library also supports reading and writing files in gzip (.gz) format
//   with an interface similar to that of stdio using the functions that start
//   with "gz".  The gzip format is different from the zlib format.  gzip is a
//   gzip wrapper, documented in RFC 1952, wrapped around a deflate stream.
//
//     This library can optionally read and write gzip and raw deflate streams in
//   memory as well.
//
//     The zlib format was designed to be compact and fast for use in memory
//   and on communications channels.  The gzip format was designed for single-
//   file compression on file systems, has a larger header than zlib to maintain
//   directory information, and uses a different, slower check method than zlib.
//
//     The library does not install any signal handler.  The decoder checks
//   the consistency of the compressed data, so the library should never crash
//   even in the case of corrupted input.

type alloc_func = uintptr /* zlib.h:81:16 */
type free_func = uintptr  /* zlib.h:82:16 */

type z_stream_s = struct {
	next_in   uintptr
	avail_in  uInt
	_         [4]byte
	total_in  uLong
	next_out  uintptr
	avail_out uInt
	_         [4]byte
	total_out uLong
	msg       uintptr
	state     uintptr
	zalloc    alloc_func
	zfree     free_func
	opaque    voidpf
	data_type int32
	_         [4]byte
	adler     uLong
	reserved  uLong
} /* zlib.h:86:9 */

type z_stream = z_stream_s /* zlib.h:106:3 */

type z_streamp = uintptr /* zlib.h:108:22 */

//
//      gzip header information passed to and from zlib routines.  See RFC 1952
//   for more details on the meanings of these fields.
type gz_header_s = struct {
	text      int32
	_         [4]byte
	time      uLong
	xflags    int32
	os        int32
	extra     uintptr
	extra_len uInt
	extra_max uInt
	name      uintptr
	name_max  uInt
	_         [4]byte
	comment   uintptr
	comm_max  uInt
	hcrc      int32
	done      int32
	_         [4]byte
} /* zlib.h:114:9 */

//
//      gzip header information passed to and from zlib routines.  See RFC 1952
//   for more details on the meanings of these fields.
type gz_header = gz_header_s /* zlib.h:129:3 */

type gz_headerp = uintptr /* zlib.h:131:23 */
//
//      inflateGetHeader() requests that gzip header information be stored in the
//    provided gz_header structure.  inflateGetHeader() may be called after
//    inflateInit2() or inflateReset(), and before the first call of inflate().
//    As inflate() processes the gzip stream, head->done is zero until the header
//    is completed, at which time head->done is set to one.  If a zlib stream is
//    being decoded, then head->done is set to -1 to indicate that there will be
//    no gzip header information forthcoming.  Note that Z_BLOCK or Z_TREES can be
//    used to force inflate() to return immediately after header processing is
//    complete and before any actual data is decompressed.
//
//      The text, time, xflags, and os fields are filled in with the gzip header
//    contents.  hcrc is set to true if there is a header CRC.  (The header CRC
//    was valid if done is set to one.) If extra is not Z_NULL, then extra_max
//    contains the maximum number of bytes to write to extra.  Once done is true,
//    extra_len contains the actual extra field length, and extra contains the
//    extra field, or that field truncated if extra_max is less than extra_len.
//    If name is not Z_NULL, then up to name_max characters are written there,
//    terminated with a zero unless the length is greater than name_max.  If
//    comment is not Z_NULL, then up to comm_max characters are written there,
//    terminated with a zero unless the length is greater than comm_max.  When any
//    of extra, name, or comment are not Z_NULL and the respective field is not
//    present in the header, then that field is set to Z_NULL to signal its
//    absence.  This allows the use of deflateSetHeader() with the returned
//    structure to duplicate the header.  However if those fields are set to
//    allocated memory, then the application will need to save those pointers
//    elsewhere so that they can be eventually freed.
//
//      If inflateGetHeader is not used, then the header information is simply
//    discarded.  The header is always checked for validity, including the header
//    CRC if present.  inflateReset() will reset the process to discard the header
//    information.  The application would need to call inflateGetHeader() again to
//    retrieve the header from the next gzip stream.
//
//      inflateGetHeader returns Z_OK if success, or Z_STREAM_ERROR if the source
//    stream state was inconsistent.

//
// ZEXTERN int ZEXPORT inflateBackInit OF((z_streamp strm, int windowBits,
//                                         unsigned char FAR *window));
//
//      Initialize the internal stream state for decompression using inflateBack()
//    calls.  The fields zalloc, zfree and opaque in strm must be initialized
//    before the call.  If zalloc and zfree are Z_NULL, then the default library-
//    derived memory allocation routines are used.  windowBits is the base two
//    logarithm of the window size, in the range 8..15.  window is a caller
//    supplied buffer of that size.  Except for special applications where it is
//    assured that deflate was used with small window sizes, windowBits must be 15
//    and a 32K byte window must be supplied to be able to decompress general
//    deflate streams.
//
//      See inflateBack() for the usage of these routines.
//
//      inflateBackInit will return Z_OK on success, Z_STREAM_ERROR if any of
//    the parameters are invalid, Z_MEM_ERROR if the internal state could not be
//    allocated, or Z_VERSION_ERROR if the version of the library does not match
//    the version of the header file.

type in_func = uintptr  /* zlib.h:1092:18 */
type out_func = uintptr /* zlib.h:1094:13 */
//
//      Same as uncompress, except that sourceLen is a pointer, where the
//    length of the source is *sourceLen.  On return, *sourceLen is the number of
//    source bytes consumed.

// gzip file access functions

//
//      This library supports reading and writing files in gzip (.gz) format with
//    an interface similar to that of stdio, using the functions that start with
//    "gz".  The gzip format is different from the zlib format.  gzip is a gzip
//    wrapper, documented in RFC 1952, wrapped around a deflate stream.

type gzFile_s = struct {
	have uint32
	_    [4]byte
	next uintptr
	pos  off64_t
} /* zlib.h:1300:9 */

//
//      Same as uncompress, except that sourceLen is a pointer, where the
//    length of the source is *sourceLen.  On return, *sourceLen is the number of
//    source bytes consumed.

// gzip file access functions

//
//      This library supports reading and writing files in gzip (.gz) format with
//    an interface similar to that of stdio, using the functions that start with
//    "gz".  The gzip format is different from the zlib format.  gzip is a gzip
//    wrapper, documented in RFC 1952, wrapped around a deflate stream.

type gzFile = uintptr /* zlib.h:1300:25 */

// The tag name of this struct is _G_fpos_t to preserve historic
//    C++ mangled names for functions taking fpos_t arguments.
//    That name should not be used in new code.
type _G_fpos_t = struct {
	__pos   int64
	__state struct {
		__count int32
		__value struct{ __wch uint32 }
	}
} /* __fpos_t.h:10:9 */

// bits/types.h -- definitions of __*_t types underlying *_t types.
//    Copyright (C) 2002-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

// Never include this file directly; use <sys/types.h> instead.

// The tag name of this struct is _G_fpos64_t to preserve historic
//    C++ mangled names for functions taking fpos_t and/or fpos64_t
//    arguments.  That name should not be used in new code.
type _G_fpos64_t = struct {
	__pos   int64
	__state struct {
		__count int32
		__value struct{ __wch uint32 }
	}
} /* __fpos64_t.h:10:9 */

type _IO_FILE = struct {
	_flags          int32
	_               [4]byte
	_IO_read_ptr    uintptr
	_IO_read_end    uintptr
	_IO_read_base   uintptr
	_IO_write_base  uintptr
	_IO_write_ptr   uintptr
	_IO_write_end   uintptr
	_IO_buf_base    uintptr
	_IO_buf_end     uintptr
	_IO_save_base   uintptr
	_IO_backup_base uintptr
	_IO_save_end    uintptr
	_markers        uintptr
	_chain          uintptr
	_fileno         int32
	_flags2         int32
	_old_offset     int64
	_cur_column     uint16
	_vtable_offset  int8
	_shortbuf       [1]uint8
	_               [4]byte
	_lock           uintptr
	_offset         int64
	_codecvt        uintptr
	_wide_data      uintptr
	_freeres_list   uintptr
	_freeres_buf    uintptr
	__pad5          size_t
	_mode           int32
	_unused2        [20]uint8
} /* __FILE.h:4:1 */

// The opaque type of streams.  This is the definition used elsewhere.
type FILE = _IO_FILE /* FILE.h:7:25 */

// These macros are used by bits/stdio.h and internal headers.

// Many more flag bits are defined internally.

// The type of the second argument to `fgetpos' and `fsetpos'.
type fpos_t = _G_fpos64_t   /* stdio.h:86:20 */
type fpos64_t = _G_fpos64_t /* stdio.h:89:20 */

// POSIX.1-2008 extended locale interface (see locale.h).
// Definition of locale_t.
//    Copyright (C) 2017-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

// Definition of struct __locale_struct and __locale_t.
//    Copyright (C) 1997-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//    Contributed by Ulrich Drepper <drepper@cygnus.com>, 1997.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

// POSIX.1-2008: the locale_t type, representing a locale context
//    (implementation-namespace version).  This type should be treated
//    as opaque by applications; some details are exposed for the sake of
//    efficiency in e.g. ctype functions.

type __locale_struct = struct {
	__locales       [13]uintptr
	__ctype_b       uintptr
	__ctype_tolower uintptr
	__ctype_toupper uintptr
	__names         [13]uintptr
} /* __locale_t.h:28:1 */

type locale_t = uintptr /* locale_t.h:24:20 */

// Copyright (C) 1991-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

//	ISO C99 Standard: 7.20 General utilities	<stdlib.h>

// Handle feature test macros at the start of a header.
//    Copyright (C) 2016-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

// This header is internal to glibc and should not be included outside
//    of glibc headers.  Headers including it must define
//    __GLIBC_INTERNAL_STARTING_HEADER_IMPLEMENTATION first.  This header
//    cannot have multiple include guards because ISO C feature test
//    macros depend on the definition of the macro when an affected
//    header is included, not when the first system header is
//    included.

// Copyright (C) 1991-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

// ISO/IEC TR 24731-2:2010 defines the __STDC_WANT_LIB_EXT2__
//    macro.

// ISO/IEC TS 18661-1:2014 defines the __STDC_WANT_IEC_60559_BFP_EXT__
//    macro.  Most but not all symbols enabled by that macro in TS
//    18661-1 are enabled unconditionally in C2X; the symbols in Annex F
//    still require that macro in C2X.

// ISO/IEC TS 18661-4:2015 defines the
//    __STDC_WANT_IEC_60559_FUNCS_EXT__ macro.  Other than the reduction
//    functions, the symbols from this TS are enabled unconditionally in
//    C2X.

// ISO/IEC TS 18661-3:2015 defines the
//    __STDC_WANT_IEC_60559_TYPES_EXT__ macro.

// Get size_t, wchar_t and NULL from <stddef.h>.
// Copyright (C) 1989-2020 Free Software Foundation, Inc.
//
// This file is part of GCC.
//
// GCC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// GCC is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// Under Section 7 of GPL version 3, you are granted additional
// permissions described in the GCC Runtime Library Exception, version
// 3.1, as published by the Free Software Foundation.
//
// You should have received a copy of the GNU General Public License and
// a copy of the GCC Runtime Library Exception along with this program;
// see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
// <http://www.gnu.org/licenses/>.

// ISO C Standard:  7.17  Common definitions  <stddef.h>

// Any one of these symbols __need_* means that GNU libc
//    wants us just to define one data type.  So don't define
//    the symbols that indicate this file's entire job has been done.

// This avoids lossage on SunOS but only if stdtypes.h comes first.
//    There's no way to win with the other order!  Sun lossage.

// Sequent's header files use _PTRDIFF_T_ in some conflicting way.
//    Just ignore it.

// On VxWorks, <type/vxTypesBase.h> may have defined macros like
//    _TYPE_size_t which will typedef size_t.  fixincludes patched the
//    vxTypesBase.h so that this macro is only defined if _GCC_SIZE_T is
//    not defined, and so that defining this macro defines _GCC_SIZE_T.
//    If we find that the macros are still defined at this point, we must
//    invoke them so that the type is defined as expected.

// In case nobody has defined these types, but we aren't running under
//    GCC 2.00, make sure that __PTRDIFF_TYPE__, __SIZE_TYPE__, and
//    __WCHAR_TYPE__ have reasonable values.  This can happen if the
//    parts of GCC is compiled by an older compiler, that actually
//    include gstddef.h, such as collect2.

// Signed type of difference of two pointers.

// Define this type if we are doing the whole job,
//    or if we want this type in particular.

// If this symbol has done its job, get rid of it.

// Unsigned type of `sizeof' something.

// Define this type if we are doing the whole job,
//    or if we want this type in particular.

// Wide character type.
//    Locale-writers should change this as necessary to
//    be big enough to hold unique values not between 0 and 127,
//    and not (wchar_t) -1, for each defined multibyte character.

// Define this type if we are doing the whole job,
//    or if we want this type in particular.

// A null pointer constant.

// Offset of member MEMBER in a struct of type TYPE.

// XPG requires a few symbols from <sys/wait.h> being defined.
// Definitions of flag bits for `waitpid' et al.
//    Copyright (C) 1992-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

// Bits in the third argument to `waitpid'.

// Bits in the fourth argument to `waitid'.

// The following values are used by the `waitid' function.

// The Linux kernel defines these bare, rather than an enum,
//    which causes a conflict if the include order is reversed.

type idtype_t = uint32 /* waitflags.h:57:3 */
// Definitions of status bits for `wait' et al.
//    Copyright (C) 1992-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

// Everything extant so far uses these same bits.

// If WIFEXITED(STATUS), the low-order 8 bits of the status.

// If WIFSIGNALED(STATUS), the terminating signal.

// If WIFSTOPPED(STATUS), the signal that stopped the child.

// Nonzero if STATUS indicates normal termination.

// Nonzero if STATUS indicates termination by a signal.

// Nonzero if STATUS indicates the child is stopped.

// Nonzero if STATUS indicates the child continued after a stop.  We only
//    define this if <bits/waitflags.h> provides the WCONTINUED flag bit.

// Nonzero if STATUS indicates the child dumped core.

// Macros for constructing status values.

// Define the macros <sys/wait.h> also would define this way.

// _FloatN API tests for enablement.
// Macros to control TS 18661-3 glibc features on powerpc.
//    Copyright (C) 2017-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

// Copyright (C) 1991-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

// Properties of long double type.  ldbl-opt version.
//    Copyright (C) 2016-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License  published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

// Defined to 1 if the current compiler invocation provides a
//    floating-point type with the IEEE 754 binary128 format, and this glibc
//    includes corresponding *f128 interfaces for it.

// Defined to 1 if __HAVE_FLOAT128 is 1 and the type is ABI-distinct
//    from the default float, double and long double types in this glibc, i.e.
//    calls to the binary128 functions go to *f128 symbols instead of *l.

// Defined to 1 if the current compiler invocation provides a
//    floating-point type with the right format for _Float64x, and this
//    glibc includes corresponding *f64x interfaces for it.

// Defined to 1 if __HAVE_FLOAT64X is 1 and _Float64x has the format
//    of long double.  Otherwise, if __HAVE_FLOAT64X is 1, _Float64x has
//    the format of _Float128, which must be different from that of long
//    double.

// Defined to concatenate the literal suffix to be used with _Float128
//    types, if __HAVE_FLOAT128 is 1.

// Defined to a complex binary128 type if __HAVE_FLOAT128 is 1.

// The remaining of this file provides support for older compilers.
// Builtin __builtin_huge_valf128 doesn't exist before GCC 7.0.

// The following builtins (suffixed with 'q') are available in GCC >= 6.2,
//    which is the minimum version required for float128 support on powerpc64le.
//    Since GCC 7.0 the builtins suffixed with f128 are also available, then
//    there is no need to redefined them.

// In math/math.h, __MATH_TG will expand signbit to __builtin_signbit*,
//    e.g.: __builtin_signbitf128, before GCC 6.  However, there has never
//    been a __builtin_signbitf128 in GCC and the type-generic builtin is
//    only available since GCC 6.

// Macros to control TS 18661-3 glibc features where the same
//    definitions are appropriate for all platforms.
//    Copyright (C) 2017-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

// Copyright (C) 1991-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

// Properties of long double type.  ldbl-opt version.
//    Copyright (C) 2016-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License  published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

// This header should be included at the bottom of each bits/floatn.h.
//    It defines the following macros for each _FloatN and _FloatNx type,
//    where the same definitions, or definitions based only on the macros
//    in bits/floatn.h, are appropriate for all glibc configurations.

// Defined to 1 if the current compiler invocation provides a
//    floating-point type with the right format for this type, and this
//    glibc includes corresponding *fN or *fNx interfaces for it.

// Defined to 1 if the corresponding __HAVE_<type> macro is 1 and the
//    type is the first with its format in the sequence of (the default
//    choices for) float, double, long double, _Float16, _Float32,
//    _Float64, _Float128, _Float32x, _Float64x, _Float128x for this
//    glibc; that is, if functions present once per floating-point format
//    rather than once per type are present for this type.
//
//    All configurations supported by glibc have _Float32 the same format
//    as float, _Float64 and _Float32x the same format as double, the
//    _Float64x the same format as either long double or _Float128.  No
//    configurations support _Float128x or, as of GCC 7, have compiler
//    support for a type meeting the requirements for _Float128x.

// Defined to 1 if the corresponding _FloatN type is not binary compatible
//    with the corresponding ISO C type in the current compilation unit as
//    opposed to __HAVE_DISTINCT_FLOATN, which indicates the default types built
//    in glibc.

// Defined to 1 if any _FloatN or _FloatNx types that are not
//    ABI-distinct are however distinct types at the C language level (so
//    for the purposes of __builtin_types_compatible_p and _Generic).

// Defined to concatenate the literal suffix to be used with _FloatN
//    or _FloatNx types, if __HAVE_<type> is 1.  The corresponding
//    literal suffixes exist since GCC 7, for C only.

// Defined to a complex type if __HAVE_<type> is 1.

// The remaining of this file provides support for older compilers.

// If double, long double and _Float64 all have the same set of
//    values, TS 18661-3 requires the usual arithmetic conversions on
//    long double and _Float64 to produce _Float64.  For this to be the
//    case when building with a compiler without a distinct _Float64
//    type, _Float64 must be a typedef for long double, not for
//    double.

// Returned by `div'.
type div_t = struct {
	quot int32
	rem  int32
} /* stdlib.h:62:5 */

// Returned by `ldiv'.
type ldiv_t = struct {
	quot int64
	rem  int64
} /* stdlib.h:70:5 */

// Returned by `lldiv'.
type lldiv_t = struct {
	quot int64
	rem  int64
} /* stdlib.h:80:5 */

// Reentrant versions of the `random' family of functions.
//    These functions all use the following data structure to contain
//    state, rather than global state variables.

type random_data = struct {
	fptr      uintptr
	rptr      uintptr
	state     uintptr
	rand_type int32
	rand_deg  int32
	rand_sep  int32
	_         [4]byte
	end_ptr   uintptr
} /* stdlib.h:423:1 */

// Data structure for communication with thread safe versions.  This
//    type is to be regarded as opaque.  It's only exported because users
//    have to allocate objects of this type.
type drand48_data = struct {
	__x     [3]uint16
	__old_x [3]uint16
	__c     uint16
	__init  uint16
	__a     uint64
} /* stdlib.h:490:1 */

// Floating-point inline functions for stdlib.h.
//    Copyright (C) 2012-2020 Free Software Foundation, Inc.
//    This file is part of the GNU C Library.
//
//    The GNU C Library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    The GNU C Library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with the GNU C Library; if not, see
//    <https://www.gnu.org/licenses/>.

// Define some macros helping to catch buffer overflows.

var hello = *(*[14]uint8)(unsafe.Pointer(ts)) /* example.c:29:21 */
// "hello world" would be more standard, but the repeated "hello"
// stresses the compression code better, sorry...

var dictionary = *(*[6]uint8)(unsafe.Pointer(ts + 14)) /* example.c:34:19 */
var dictId uLong                                       /* example.c:35:14: */

var zalloc alloc_func = uintptr(0) /* example.c:77:19 */
var zfree free_func = uintptr(0)   /* example.c:78:18 */

// ===========================================================================
// Test compress() and uncompress()
func test_compress(tls *libc.TLS, compr uintptr, comprLen uLong, uncompr uintptr, uncomprLen uLong) { /* example.c:88:6: */
	bp := tls.Alloc(56)
	defer tls.Free(56)
	*(*uLong)(unsafe.Pointer(bp + 40)) = comprLen
	*(*uLong)(unsafe.Pointer(bp + 48)) = uncomprLen

	var err int32
	var len uLong = libc.Xstrlen(tls, uintptr(unsafe.Pointer(&hello))) + uint64(1)

	err = z.Xcompress(tls, compr, bp+40, uintptr(uintptr(unsafe.Pointer(&hello))), len)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.Xstderr, ts+20, libc.VaList(bp, ts+34, err))
			libc.Xexit(tls, 1)
		}
	}

	libc.Xstrcpy(tls, uncompr, ts+43)

	err = z.Xuncompress(tls, uncompr, bp+48, compr, *(*uLong)(unsafe.Pointer(bp + 40 /* comprLen */)))
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.Xstderr, ts+20, libc.VaList(bp+16, ts+51, err))
			libc.Xexit(tls, 1)
		}
	}

	if libc.Xstrcmp(tls, uncompr, uintptr(unsafe.Pointer(&hello))) != 0 {
		libc.Xfprintf(tls, libc.Xstderr, ts+62, 0)
		libc.Xexit(tls, 1)
	} else {
		libc.Xprintf(tls, ts+78, libc.VaList(bp+32, uncompr))
	}
}

// ===========================================================================
// Test read/write of .gz files
func test_gzio(tls *libc.TLS, fname uintptr, uncompr uintptr, uncomprLen uLong) { /* example.c:114:6: */
	bp := tls.Alloc(84)
	defer tls.Free(84)

	// var err int32 at bp+80, 4

	var len int32 = int32(libc.Xstrlen(tls, uintptr(unsafe.Pointer(&hello)))) + 1
	var file gzFile
	var pos off_t

	file = z.Xgzopen64(tls, fname, ts+96)
	if file == uintptr(0) {
		libc.Xfprintf(tls, libc.Xstderr, ts+99, 0)
		libc.Xexit(tls, 1)
	}
	z.Xgzputc(tls, file, 'h')
	if z.Xgzputs(tls, file, ts+113) != 4 {
		libc.Xfprintf(tls, libc.Xstderr, ts+118, libc.VaList(bp, z.Xgzerror(tls, file, bp+80)))
		libc.Xexit(tls, 1)
	}
	if z.Xgzprintf(tls, file, ts+134, libc.VaList(bp+8, ts+14)) != 8 {
		libc.Xfprintf(tls, libc.Xstderr, ts+140, libc.VaList(bp+16, z.Xgzerror(tls, file, bp+80)))
		libc.Xexit(tls, 1)
	}
	z.Xgzseek64(tls, file, 1, 1) // add one zero byte
	z.Xgzclose(tls, file)

	file = z.Xgzopen64(tls, fname, ts+158)
	if file == uintptr(0) {
		libc.Xfprintf(tls, libc.Xstderr, ts+99, 0)
		libc.Xexit(tls, 1)
	}
	libc.Xstrcpy(tls, uncompr, ts+43)

	if z.Xgzread(tls, file, uncompr, uint32(uncomprLen)) != len {
		libc.Xfprintf(tls, libc.Xstderr, ts+161, libc.VaList(bp+24, z.Xgzerror(tls, file, bp+80)))
		libc.Xexit(tls, 1)
	}
	if libc.Xstrcmp(tls, uncompr, uintptr(unsafe.Pointer(&hello))) != 0 {
		libc.Xfprintf(tls, libc.Xstderr, ts+177, libc.VaList(bp+32, uncompr))
		libc.Xexit(tls, 1)
	} else {
		libc.Xprintf(tls, ts+193, libc.VaList(bp+40, uncompr))
	}

	pos = z.Xgzseek64(tls, file, -8, 1)
	if pos != int64(6) || z.Xgztell64(tls, file) != pos {
		libc.Xfprintf(tls, libc.Xstderr, ts+207,
			libc.VaList(bp+48, pos, z.Xgztell64(tls, file)))
		libc.Xexit(tls, 1)
	}

	if func() int32 {
		if (*gzFile_s)(unsafe.Pointer(file)).have != 0 {
			return int32(func() uint8 {
				(*gzFile_s)(unsafe.Pointer(file)).have--
				(*gzFile_s)(unsafe.Pointer(file)).pos++
				return *(*uint8)(unsafe.Pointer(libc.PostIncUintptr(&(*gzFile_s)(unsafe.Pointer(file)).next, 1)))
			}())
		}
		return z.Xgzgetc(tls, file)
	}() != ' ' {
		libc.Xfprintf(tls, libc.Xstderr, ts+242, 0)
		libc.Xexit(tls, 1)
	}

	if z.Xgzungetc(tls, ' ', file) != ' ' {
		libc.Xfprintf(tls, libc.Xstderr, ts+256, 0)
		libc.Xexit(tls, 1)
	}

	z.Xgzgets(tls, file, uncompr, int32(uncomprLen))
	if libc.Xstrlen(tls, uncompr) != uint64(7) { // " hello!"
		libc.Xfprintf(tls, libc.Xstderr, ts+272, libc.VaList(bp+64, z.Xgzerror(tls, file, bp+80)))
		libc.Xexit(tls, 1)
	}
	if libc.Xstrcmp(tls, uncompr, uintptr(unsafe.Pointer(&hello))+uintptr(6)) != 0 {
		libc.Xfprintf(tls, libc.Xstderr, ts+301, 0)
		libc.Xexit(tls, 1)
	} else {
		libc.Xprintf(tls, ts+326, libc.VaList(bp+72, uncompr))
	}

	z.Xgzclose(tls, file)
}

// ===========================================================================
// Test deflate() with small buffers
func test_deflate(tls *libc.TLS, compr uintptr, comprLen uLong) { /* example.c:200:6: */
	bp := tls.Alloc(176)
	defer tls.Free(176)

	// var c_stream z_stream at bp+64, 112
	// compression stream
	var err int32
	var len uLong = libc.Xstrlen(tls, uintptr(unsafe.Pointer(&hello))) + uint64(1)

	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).zalloc = zalloc
	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).zfree = zfree
	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).opaque = uintptr(0)

	err = z.XdeflateInit_(tls, bp+64, -1, ts+353, int32(unsafe.Sizeof(z_stream{})))
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.Xstderr, ts+20, libc.VaList(bp, ts+360, err))
			libc.Xexit(tls, 1)
		}
	}

	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).next_in = uintptr(uintptr(unsafe.Pointer(&hello)))
	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).next_out = compr

	for (*z_stream)(unsafe.Pointer(bp+64)).total_in != len && (*z_stream)(unsafe.Pointer(bp+64)).total_out < comprLen {
		(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).avail_in = libc.AssignPtrUint32(bp+64+32, uInt(1)) // force small buffers
		err = z.Xdeflate(tls, bp+64, 0)
		{
			if err != 0 {
				libc.Xfprintf(tls, libc.Xstderr, ts+20, libc.VaList(bp+16, ts+372, err))
				libc.Xexit(tls, 1)
			}
		}

	}
	// Finish the stream, still forcing small buffers:
	for {
		(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).avail_out = uInt(1)
		err = z.Xdeflate(tls, bp+64, 4)
		if err == 1 {
			break
		}
		{
			if err != 0 {
				libc.Xfprintf(tls, libc.Xstderr, ts+20, libc.VaList(bp+32, ts+372, err))
				libc.Xexit(tls, 1)
			}
		}

	}

	err = z.XdeflateEnd(tls, bp+64)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.Xstderr, ts+20, libc.VaList(bp+48, ts+380, err))
			libc.Xexit(tls, 1)
		}
	}

}

// ===========================================================================
// Test inflate() with small buffers
func test_inflate(tls *libc.TLS, compr uintptr, comprLen uLong, uncompr uintptr, uncomprLen uLong) { /* example.c:238:6: */
	bp := tls.Alloc(168)
	defer tls.Free(168)

	var err int32
	// var d_stream z_stream at bp+56, 112
	// decompression stream

	libc.Xstrcpy(tls, uncompr, ts+43)

	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).zalloc = zalloc
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).zfree = zfree
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).opaque = uintptr(0)

	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).next_in = compr
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).avail_in = uInt(0)
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).next_out = uncompr

	err = z.XinflateInit_(tls, bp+56, ts+353, int32(unsafe.Sizeof(z_stream{})))
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.Xstderr, ts+20, libc.VaList(bp, ts+391, err))
			libc.Xexit(tls, 1)
		}
	}

	for (*z_stream)(unsafe.Pointer(bp+56)).total_out < uncomprLen && (*z_stream)(unsafe.Pointer(bp+56)).total_in < comprLen {
		(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).avail_in = libc.AssignPtrUint32(bp+56+32, uInt(1)) // force small buffers
		err = z.Xinflate(tls, bp+56, 0)
		if err == 1 {
			break
		}
		{
			if err != 0 {
				libc.Xfprintf(tls, libc.Xstderr, ts+20, libc.VaList(bp+16, ts+403, err))
				libc.Xexit(tls, 1)
			}
		}

	}

	err = z.XinflateEnd(tls, bp+56)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.Xstderr, ts+20, libc.VaList(bp+32, ts+411, err))
			libc.Xexit(tls, 1)
		}
	}

	if libc.Xstrcmp(tls, uncompr, uintptr(unsafe.Pointer(&hello))) != 0 {
		libc.Xfprintf(tls, libc.Xstderr, ts+422, 0)
		libc.Xexit(tls, 1)
	} else {
		libc.Xprintf(tls, ts+435, libc.VaList(bp+48, uncompr))
	}
}

// ===========================================================================
// Test deflate() with large buffers and dynamic change of compression level
func test_large_deflate(tls *libc.TLS, compr uintptr, comprLen uLong, uncompr uintptr, uncomprLen uLong) { /* example.c:279:6: */
	bp := tls.Alloc(192)
	defer tls.Free(192)

	// var c_stream z_stream at bp+80, 112
	// compression stream
	var err int32

	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).zalloc = zalloc
	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).zfree = zfree
	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).opaque = uintptr(0)

	err = z.XdeflateInit_(tls, bp+80, 1, ts+353, int32(unsafe.Sizeof(z_stream{})))
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.Xstderr, ts+20, libc.VaList(bp, ts+360, err))
			libc.Xexit(tls, 1)
		}
	}

	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).next_out = compr
	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).avail_out = uInt(comprLen)

	// At this point, uncompr is still mostly zeroes, so it should compress
	// very well:
	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).next_in = uncompr
	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).avail_in = uInt(uncomprLen)
	err = z.Xdeflate(tls, bp+80, 0)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.Xstderr, ts+20, libc.VaList(bp+16, ts+372, err))
			libc.Xexit(tls, 1)
		}
	}

	if (*z_stream)(unsafe.Pointer(bp+80)).avail_in != uInt(0) {
		libc.Xfprintf(tls, libc.Xstderr, ts+450, 0)
		libc.Xexit(tls, 1)
	}

	// Feed in already compressed data and switch to no compression:
	z.XdeflateParams(tls, bp+80, 0, 0)
	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).next_in = compr
	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).avail_in = uInt(comprLen) / uInt(2)
	err = z.Xdeflate(tls, bp+80, 0)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.Xstderr, ts+20, libc.VaList(bp+32, ts+372, err))
			libc.Xexit(tls, 1)
		}
	}

	// Switch back to compressing mode:
	z.XdeflateParams(tls, bp+80, 9, 1)
	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).next_in = uncompr
	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).avail_in = uInt(uncomprLen)
	err = z.Xdeflate(tls, bp+80, 0)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.Xstderr, ts+20, libc.VaList(bp+48, ts+372, err))
			libc.Xexit(tls, 1)
		}
	}

	err = z.Xdeflate(tls, bp+80, 4)
	if err != 1 {
		libc.Xfprintf(tls, libc.Xstderr, ts+470, 0)
		libc.Xexit(tls, 1)
	}
	err = z.XdeflateEnd(tls, bp+80)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.Xstderr, ts+20, libc.VaList(bp+64, ts+380, err))
			libc.Xexit(tls, 1)
		}
	}

}

// ===========================================================================
// Test inflate() with large buffers
func test_large_inflate(tls *libc.TLS, compr uintptr, comprLen uLong, uncompr uintptr, uncomprLen uLong) { /* example.c:334:6: */
	bp := tls.Alloc(168)
	defer tls.Free(168)

	var err int32
	// var d_stream z_stream at bp+56, 112
	// decompression stream

	libc.Xstrcpy(tls, uncompr, ts+43)

	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).zalloc = zalloc
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).zfree = zfree
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).opaque = uintptr(0)

	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).next_in = compr
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).avail_in = uInt(comprLen)

	err = z.XinflateInit_(tls, bp+56, ts+353, int32(unsafe.Sizeof(z_stream{})))
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.Xstderr, ts+20, libc.VaList(bp, ts+391, err))
			libc.Xexit(tls, 1)
		}
	}

	for {
		(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).next_out = uncompr // discard the output
		(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).avail_out = uInt(uncomprLen)
		err = z.Xinflate(tls, bp+56, 0)
		if err == 1 {
			break
		}
		{
			if err != 0 {
				libc.Xfprintf(tls, libc.Xstderr, ts+20, libc.VaList(bp+16, ts+506, err))
				libc.Xexit(tls, 1)
			}
		}

	}

	err = z.XinflateEnd(tls, bp+56)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.Xstderr, ts+20, libc.VaList(bp+32, ts+411, err))
			libc.Xexit(tls, 1)
		}
	}

	if (*z_stream)(unsafe.Pointer(bp+56)).total_out != uint64(2)*uncomprLen+comprLen/uint64(2) {
		libc.Xfprintf(tls, libc.Xstderr, ts+520, libc.VaList(bp+48, (*z_stream)(unsafe.Pointer(bp+56 /* &d_stream */)).total_out))
		libc.Xexit(tls, 1)
	} else {
		libc.Xprintf(tls, ts+544, 0)
	}
}

// ===========================================================================
// Test deflate() with full flush
func test_flush(tls *libc.TLS, compr uintptr, comprLen uintptr) { /* example.c:375:6: */
	bp := tls.Alloc(176)
	defer tls.Free(176)

	// var c_stream z_stream at bp+64, 112
	// compression stream
	var err int32
	var len uInt = uInt(libc.Xstrlen(tls, uintptr(unsafe.Pointer(&hello)))) + uInt(1)

	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).zalloc = zalloc
	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).zfree = zfree
	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).opaque = uintptr(0)

	err = z.XdeflateInit_(tls, bp+64, -1, ts+353, int32(unsafe.Sizeof(z_stream{})))
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.Xstderr, ts+20, libc.VaList(bp, ts+360, err))
			libc.Xexit(tls, 1)
		}
	}

	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).next_in = uintptr(uintptr(unsafe.Pointer(&hello)))
	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).next_out = compr
	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).avail_in = uInt(3)
	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).avail_out = uInt(*(*uLong)(unsafe.Pointer(comprLen)))
	err = z.Xdeflate(tls, bp+64, 3)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.Xstderr, ts+20, libc.VaList(bp+16, ts+372, err))
			libc.Xexit(tls, 1)
		}
	}

	*(*Byte)(unsafe.Pointer(compr + 3))++ // force an error in first compressed block
	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).avail_in = len - uInt(3)

	err = z.Xdeflate(tls, bp+64, 4)
	if err != 1 {
		{
			if err != 0 {
				libc.Xfprintf(tls, libc.Xstderr, ts+20, libc.VaList(bp+32, ts+372, err))
				libc.Xexit(tls, 1)
			}
		}

	}
	err = z.XdeflateEnd(tls, bp+64)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.Xstderr, ts+20, libc.VaList(bp+48, ts+380, err))
			libc.Xexit(tls, 1)
		}
	}

	*(*uLong)(unsafe.Pointer(comprLen)) = (*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).total_out
}

// ===========================================================================
// Test inflateSync()
func test_sync(tls *libc.TLS, compr uintptr, comprLen uLong, uncompr uintptr, uncomprLen uLong) { /* example.c:413:6: */
	bp := tls.Alloc(184)
	defer tls.Free(184)

	var err int32
	// var d_stream z_stream at bp+72, 112
	// decompression stream

	libc.Xstrcpy(tls, uncompr, ts+43)

	(*z_stream)(unsafe.Pointer(bp + 72 /* &d_stream */)).zalloc = zalloc
	(*z_stream)(unsafe.Pointer(bp + 72 /* &d_stream */)).zfree = zfree
	(*z_stream)(unsafe.Pointer(bp + 72 /* &d_stream */)).opaque = uintptr(0)

	(*z_stream)(unsafe.Pointer(bp + 72 /* &d_stream */)).next_in = compr
	(*z_stream)(unsafe.Pointer(bp + 72 /* &d_stream */)).avail_in = uInt(2) // just read the zlib header

	err = z.XinflateInit_(tls, bp+72, ts+353, int32(unsafe.Sizeof(z_stream{})))
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.Xstderr, ts+20, libc.VaList(bp, ts+391, err))
			libc.Xexit(tls, 1)
		}
	}

	(*z_stream)(unsafe.Pointer(bp + 72 /* &d_stream */)).next_out = uncompr
	(*z_stream)(unsafe.Pointer(bp + 72 /* &d_stream */)).avail_out = uInt(uncomprLen)

	err = z.Xinflate(tls, bp+72, 0)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.Xstderr, ts+20, libc.VaList(bp+16, ts+403, err))
			libc.Xexit(tls, 1)
		}
	}

	(*z_stream)(unsafe.Pointer(bp + 72 /* &d_stream */)).avail_in = uInt(comprLen) - uInt(2) // read all compressed data
	err = z.XinflateSync(tls, bp+72)                                                         /* but skip the damaged part */
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.Xstderr, ts+20, libc.VaList(bp+32, ts+565, err))
			libc.Xexit(tls, 1)
		}
	}

	err = z.Xinflate(tls, bp+72, 4)
	if err != -3 {
		libc.Xfprintf(tls, libc.Xstderr, ts+577, 0)
		// Because of incorrect adler32
		libc.Xexit(tls, 1)
	}
	err = z.XinflateEnd(tls, bp+72)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.Xstderr, ts+20, libc.VaList(bp+48, ts+411, err))
			libc.Xexit(tls, 1)
		}
	}

	libc.Xprintf(tls, ts+611, libc.VaList(bp+64, uncompr))
}

// ===========================================================================
// Test deflate() with preset dictionary
func test_dict_deflate(tls *libc.TLS, compr uintptr, comprLen uLong) { /* example.c:457:6: */
	bp := tls.Alloc(160)
	defer tls.Free(160)

	// var c_stream z_stream at bp+48, 112
	// compression stream
	var err int32

	(*z_stream)(unsafe.Pointer(bp + 48 /* &c_stream */)).zalloc = zalloc
	(*z_stream)(unsafe.Pointer(bp + 48 /* &c_stream */)).zfree = zfree
	(*z_stream)(unsafe.Pointer(bp + 48 /* &c_stream */)).opaque = uintptr(0)

	err = z.XdeflateInit_(tls, bp+48, 9, ts+353, int32(unsafe.Sizeof(z_stream{})))
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.Xstderr, ts+20, libc.VaList(bp, ts+360, err))
			libc.Xexit(tls, 1)
		}
	}

	err = z.XdeflateSetDictionary(tls, bp+48,
		uintptr(uintptr(unsafe.Pointer(&dictionary))), uint32(int32(unsafe.Sizeof(dictionary))))
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.Xstderr, ts+20, libc.VaList(bp+16, ts+639, err))
			libc.Xexit(tls, 1)
		}
	}

	dictId = (*z_stream)(unsafe.Pointer(bp + 48 /* &c_stream */)).adler
	(*z_stream)(unsafe.Pointer(bp + 48 /* &c_stream */)).next_out = compr
	(*z_stream)(unsafe.Pointer(bp + 48 /* &c_stream */)).avail_out = uInt(comprLen)

	(*z_stream)(unsafe.Pointer(bp + 48 /* &c_stream */)).next_in = uintptr(uintptr(unsafe.Pointer(&hello)))
	(*z_stream)(unsafe.Pointer(bp + 48 /* &c_stream */)).avail_in = uInt(libc.Xstrlen(tls, uintptr(unsafe.Pointer(&hello)))) + uInt(1)

	err = z.Xdeflate(tls, bp+48, 4)
	if err != 1 {
		libc.Xfprintf(tls, libc.Xstderr, ts+470, 0)
		libc.Xexit(tls, 1)
	}
	err = z.XdeflateEnd(tls, bp+48)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.Xstderr, ts+20, libc.VaList(bp+32, ts+380, err))
			libc.Xexit(tls, 1)
		}
	}

}

// ===========================================================================
// Test inflate() with a preset dictionary
func test_dict_inflate(tls *libc.TLS, compr uintptr, comprLen uLong, uncompr uintptr, uncomprLen uLong) { /* example.c:494:6: */
	bp := tls.Alloc(168)
	defer tls.Free(168)

	var err int32
	// var d_stream z_stream at bp+56, 112
	// decompression stream

	libc.Xstrcpy(tls, uncompr, ts+43)

	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).zalloc = zalloc
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).zfree = zfree
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).opaque = uintptr(0)

	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).next_in = compr
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).avail_in = uInt(comprLen)

	err = z.XinflateInit_(tls, bp+56, ts+353, int32(unsafe.Sizeof(z_stream{})))
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.Xstderr, ts+20, libc.VaList(bp, ts+391, err))
			libc.Xexit(tls, 1)
		}
	}

	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).next_out = uncompr
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).avail_out = uInt(uncomprLen)

	for {
		err = z.Xinflate(tls, bp+56, 0)
		if err == 1 {
			break
		}
		if err == 2 {
			if (*z_stream)(unsafe.Pointer(bp+56)).adler != dictId {
				libc.Xfprintf(tls, libc.Xstderr, ts+660, 0)
				libc.Xexit(tls, 1)
			}
			err = z.XinflateSetDictionary(tls, bp+56, uintptr(uintptr(unsafe.Pointer(&dictionary))),
				uint32(int32(unsafe.Sizeof(dictionary))))
		}
		{
			if err != 0 {
				libc.Xfprintf(tls, libc.Xstderr, ts+20, libc.VaList(bp+16, ts+682, err))
				libc.Xexit(tls, 1)
			}
		}

	}

	err = z.XinflateEnd(tls, bp+56)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.Xstderr, ts+20, libc.VaList(bp+32, ts+411, err))
			libc.Xexit(tls, 1)
		}
	}

	if libc.Xstrcmp(tls, uncompr, uintptr(unsafe.Pointer(&hello))) != 0 {
		libc.Xfprintf(tls, libc.Xstderr, ts+700, 0)
		libc.Xexit(tls, 1)
	} else {
		libc.Xprintf(tls, ts+723, libc.VaList(bp+48, uncompr))
	}
}

// ===========================================================================
// Usage:  example [output.gz  [input.gz]]

func main1(tls *libc.TLS, argc int32, argv uintptr) int32 { /* example.c:545:5: */
	bp := tls.Alloc(32)
	defer tls.Free(32)

	var compr uintptr
	var uncompr uintptr
	*(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)) = uint64(10000) * uint64(unsafe.Sizeof(int32(0))) // don't overflow on MSDOS
	var uncomprLen uLong = *(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */))

	if int32(*(*uint8)(unsafe.Pointer(z.XzlibVersion(tls)))) != int32(*(*uint8)(unsafe.Pointer(myVersion))) {
		libc.Xfprintf(tls, libc.Xstderr, ts+752, 0)
		libc.Xexit(tls, 1)

	} else if libc.Xstrcmp(tls, z.XzlibVersion(tls), ts+353) != 0 {
		libc.Xfprintf(tls, libc.Xstderr, ts+779, 0)
	}

	libc.Xprintf(tls, ts+812,
		libc.VaList(bp, ts+353, 0x12b0, z.XzlibCompileFlags(tls)))

	compr = libc.Xcalloc(tls, uint64(uInt(*(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)))), uint64(1))
	uncompr = libc.Xcalloc(tls, uint64(uInt(uncomprLen)), uint64(1))
	// compr and uncompr are cleared to avoid reading uninitialized
	// data and to ensure that uncompr compresses well.
	if compr == uintptr(0) || uncompr == uintptr(0) {
		libc.Xprintf(tls, ts+861, 0)
		libc.Xexit(tls, 1)
	}

	test_compress(tls, compr, *(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)), uncompr, uncomprLen)

	test_gzio(tls, func() uintptr {
		if argc > 1 {
			return *(*uintptr)(unsafe.Pointer(argv + 1*8))
		}
		return ts + 876
	}(),
		uncompr, uncomprLen)

	test_deflate(tls, compr, *(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)))
	test_inflate(tls, compr, *(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)), uncompr, uncomprLen)

	test_large_deflate(tls, compr, *(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)), uncompr, uncomprLen)
	test_large_inflate(tls, compr, *(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)), uncompr, uncomprLen)

	test_flush(tls, compr, bp+24)
	test_sync(tls, compr, *(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)), uncompr, uncomprLen)
	*(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)) = uncomprLen

	test_dict_deflate(tls, compr, *(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)))
	test_dict_inflate(tls, compr, *(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)), uncompr, uncomprLen)

	libc.Xfree(tls, compr)
	libc.Xfree(tls, uncompr)

	return 0
}

var myVersion uintptr = ts + 353 /* "1.2.11" */ /* example.c:552:22 */

var ts1 = "hello, hello!\x00hello\x00%s error: %d\n\x00compress\x00garbage\x00uncompress\x00bad uncompress\n\x00uncompress(): %s\n\x00wb\x00gzopen error\n\x00ello\x00gzputs err: %s\n\x00, %s!\x00gzprintf err: %s\n\x00rb\x00gzread err: %s\n\x00bad gzread: %s\n\x00gzread(): %s\n\x00gzseek error, pos=%ld, gztell=%ld\n\x00gzgetc error\n\x00gzungetc error\n\x00gzgets err after gzseek: %s\n\x00bad gzgets after gzseek\n\x00gzgets() after gzseek: %s\n\x001.2.11\x00deflateInit\x00deflate\x00deflateEnd\x00inflateInit\x00inflate\x00inflateEnd\x00bad inflate\n\x00inflate(): %s\n\x00deflate not greedy\n\x00deflate should report Z_STREAM_END\n\x00large inflate\x00bad large inflate: %ld\n\x00large_inflate(): OK\n\x00inflateSync\x00inflate should report DATA_ERROR\n\x00after inflateSync(): hel%s\n\x00deflateSetDictionary\x00unexpected dictionary\x00inflate with dict\x00bad inflate with dict\n\x00inflate with dictionary: %s\n\x00incompatible zlib version\n\x00warning: different zlib version\n\x00zlib version %s = 0x%04x, compile flags = 0x%lx\n\x00out of memory\n\x00foo.gz\x00"
var ts = (*reflect.StringHeader)(unsafe.Pointer(&ts1)).Data
