/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.CardinalityCheckingIterator;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.ItemTypeCheckingFunction;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.FunctionAnnotationHandler;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.pattern.LocalNameTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NamespaceTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.QNameTest;
import net.sf.saxon.pattern.SameNameTest;
import net.sf.saxon.query.Annotation;
import net.sf.saxon.query.AnnotationList;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyExternalObjectType;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.JavaExternalObjectType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.UType;
import net.sf.saxon.type.UnionType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.z.IntHashSet;
import net.sf.saxon.z.IntSet;
import net.sf.saxon.z.IntUniversalSet;

public class TypeHierarchy {
    private Map<ItemTypePair, Integer> map;
    protected Configuration config;
    public static final int SAME_TYPE = 0;
    public static final int SUBSUMES = 1;
    public static final int SUBSUMED_BY = 2;
    public static final int OVERLAPS = 3;
    public static final int DISJOINT = 4;

    public TypeHierarchy(Configuration config) {
        this.config = config;
        this.map = new ConcurrentHashMap<ItemTypePair, Integer>();
    }

    public Sequence<?> applyFunctionConversionRules(Sequence<?> value, SequenceType requiredType, RoleDiagnostic role, Location locator) throws XPathException {
        ItemType suppliedItemType = SequenceTool.getItemType(value, this);
        SequenceIterator<Object> iterator = value.iterate();
        ItemType requiredItemType = requiredType.getPrimaryType();
        if (requiredItemType.isPlainType()) {
            if (!suppliedItemType.isPlainType()) {
                try {
                    iterator = Atomizer.getAtomizingIterator(iterator, false);
                }
                catch (XPathException e) {
                    ValidationFailure vf = new ValidationFailure("Failed to atomize the " + role.getMessage() + ": " + e.getMessage());
                    vf.setErrorCode("XPTY0117");
                    throw vf.makeException();
                }
                suppliedItemType = suppliedItemType.getAtomizedItemType();
            }
            if (this.relationship(suppliedItemType, BuiltInAtomicType.UNTYPED_ATOMIC) != 4 && !this.isSubType(BuiltInAtomicType.UNTYPED_ATOMIC, requiredItemType)) {
                ItemMappingFunction<Item, Item> converter;
                boolean nsSensitive = ((SimpleType)((Object)requiredItemType)).isNamespaceSensitive();
                if (nsSensitive) {
                    converter = item -> {
                        if (item instanceof UntypedAtomicValue) {
                            ValidationFailure vf = new ValidationFailure("Failed to convert the " + role.getMessage() + ": Implicit conversion of untypedAtomic value to " + requiredItemType + " is not allowed");
                            vf.setErrorCode("XPTY0117");
                            throw vf.makeException();
                        }
                        return item;
                    };
                } else if (((SimpleType)((Object)requiredItemType)).isUnionType()) {
                    ConversionRules rules = this.config.getConversionRules();
                    converter = item -> {
                        if (item instanceof UntypedAtomicValue) {
                            try {
                                return ((SimpleType)((Object)requiredItemType)).getTypedValue(item.getStringValueCS(), null, rules).head();
                            }
                            catch (ValidationException ve) {
                                ve.setErrorCode("XPTY0004");
                                throw ve;
                            }
                        }
                        return item;
                    };
                } else {
                    converter = item -> {
                        if (item instanceof UntypedAtomicValue) {
                            return Converter.convert((UntypedAtomicValue)item, (AtomicType)requiredItemType, this.config.getConversionRules());
                        }
                        return item;
                    };
                }
                iterator = new ItemMappingIterator<Item, Item>(iterator, converter, true);
            }
            if (requiredItemType.equals(BuiltInAtomicType.DOUBLE)) {
                ItemMappingFunction<Item, Item> promoter = item -> {
                    if (item instanceof NumericValue) {
                        return (DoubleValue)Converter.convert((NumericValue)item, BuiltInAtomicType.DOUBLE, this.config.getConversionRules()).asAtomic();
                    }
                    throw new XPathException("Failed to convert the " + role.getMessage() + ": Cannot promote non-numeric value to xs:double", "XPTY0004");
                };
                iterator = new ItemMappingIterator<Item, Item>(iterator, promoter, true);
            } else if (requiredItemType.equals(BuiltInAtomicType.FLOAT)) {
                ItemMappingFunction<Item, Item> promoter = item -> {
                    if (item instanceof DoubleValue) {
                        throw new XPathException("Failed to convert the " + role.getMessage() + ": Cannot promote xs:double value to xs:float", "XPTY0004");
                    }
                    if (item instanceof NumericValue) {
                        return (FloatValue)Converter.convert((NumericValue)item, BuiltInAtomicType.FLOAT, this.config.getConversionRules()).asAtomic();
                    }
                    throw new XPathException("Failed to convert the " + role.getMessage() + ": Cannot promote non-numeric value to xs:float", "XPTY0004");
                };
                iterator = new ItemMappingIterator<Item, Item>(iterator, promoter, true);
            }
            if (requiredItemType.equals(BuiltInAtomicType.STRING) && this.relationship(suppliedItemType, BuiltInAtomicType.ANY_URI) != 4) {
                ItemMappingFunction<Item, Item> promoter = item -> {
                    if (item instanceof AnyURIValue) {
                        return new StringValue(item.getStringValueCS());
                    }
                    return item;
                };
                iterator = new ItemMappingIterator<Item, Item>(iterator, promoter, true);
            }
        }
        iterator = this.applyFunctionCoercion(iterator, suppliedItemType, requiredItemType, locator);
        int relation = this.relationship(suppliedItemType, requiredItemType);
        if (relation != 0 && relation != 2) {
            ItemTypeCheckingFunction itemChecker = new ItemTypeCheckingFunction(requiredItemType, role, locator, this.config);
            iterator = new ItemMappingIterator(iterator, itemChecker, true);
        }
        if (requiredType.getCardinality() != 57344) {
            iterator = new CardinalityCheckingIterator(iterator, requiredType.getCardinality(), role, locator);
        }
        return SequenceTool.toMemoSequence(iterator);
    }

    protected SequenceIterator<?> applyFunctionCoercion(SequenceIterator<?> iterator, ItemType suppliedItemType, ItemType requiredItemType, Location locator) {
        return iterator;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public boolean isSubType(ItemType subtype, ItemType supertype) {
        int relation = this.relationship(subtype, supertype);
        return relation == 0 || relation == 2;
    }

    public int relationship(ItemType t1, ItemType t2) {
        if (t1 == null) {
            throw new NullPointerException();
        }
        if ((t1 = TypeHierarchy.stabilize(t1)).equals(t2 = TypeHierarchy.stabilize(t2))) {
            return 0;
        }
        if (t2 instanceof AnyItemType) {
            return 2;
        }
        if (t1 instanceof AnyItemType) {
            return 1;
        }
        if (t1 instanceof ErrorType) {
            return 2;
        }
        if (t2 instanceof ErrorType) {
            return 1;
        }
        ItemTypePair pair = new ItemTypePair(t1, t2);
        Integer result = this.map.get(pair);
        if (result == null) {
            result = this.computeRelationship(t1, t2);
            this.map.put(pair, result);
        }
        return result;
    }

    private static ItemType stabilize(ItemType in) {
        if (in instanceof SameNameTest) {
            return ((SameNameTest)in).getEquivalentNameTest();
        }
        return in;
    }

    private int computeRelationship(ItemType t1, ItemType t2) {
        try {
            if (t1 == t2) {
                return 0;
            }
            if (t1 instanceof AnyItemType) {
                if (t2 instanceof AnyItemType) {
                    return 0;
                }
                return 1;
            }
            if (t2 instanceof AnyItemType) {
                return 2;
            }
            if (t1.isPlainType()) {
                if (t2 instanceof NodeTest || t2 instanceof FunctionItemType || t2 instanceof JavaExternalObjectType) {
                    return 4;
                }
                if (t1 == BuiltInAtomicType.ANY_ATOMIC && t2.isPlainType()) {
                    return 1;
                }
                if (t2 == BuiltInAtomicType.ANY_ATOMIC) {
                    return 2;
                }
                if (t1 instanceof AtomicType && t2 instanceof AtomicType) {
                    SchemaType st;
                    if (((AtomicType)t1).getFingerprint() == ((AtomicType)t2).getFingerprint()) {
                        return 0;
                    }
                    AtomicType t = (AtomicType)t2;
                    while (true) {
                        if (((AtomicType)t1).getFingerprint() == t.getFingerprint()) {
                            return 1;
                        }
                        st = t.getBaseType();
                        if (!(st instanceof AtomicType)) break;
                        t = (AtomicType)st;
                    }
                    t = (AtomicType)t1;
                    while (true) {
                        if (t.getFingerprint() == ((AtomicType)t2).getFingerprint()) {
                            return 2;
                        }
                        st = t.getBaseType();
                        if (!(st instanceof AtomicType)) break;
                        t = (AtomicType)st;
                    }
                    return 4;
                }
                if (!t1.isAtomicType() && t2 instanceof PlainType) {
                    Set<? extends PlainType> s2;
                    Set<? extends PlainType> s1 = TypeHierarchy.toSet(((PlainType)t1).getPlainMemberTypes());
                    if (!this.unionOverlaps(s1, s2 = TypeHierarchy.toSet(((PlainType)t2).getPlainMemberTypes()))) {
                        return 4;
                    }
                    boolean gt = s1.containsAll(s2);
                    boolean lt = s2.containsAll(s1);
                    if (gt && lt) {
                        return 0;
                    }
                    if (gt) {
                        return 1;
                    }
                    if (lt) {
                        return 2;
                    }
                    if (this.unionSubsumes(s1, s2)) {
                        return 1;
                    }
                    if (this.unionSubsumes(s2, s1)) {
                        return 2;
                    }
                    return 3;
                }
                if (t1 instanceof AtomicType) {
                    int r = this.relationship(t2, t1);
                    return TypeHierarchy.inverseRelationship(r);
                }
                throw new IllegalStateException();
            }
            if (t1 instanceof UnionType) {
                SchemaType st = (SchemaType)((Object)t1);
                if (t2 instanceof SchemaType) {
                    SchemaType t2s = (SchemaType)((Object)t2);
                    do {
                        if (st.getFingerprint() != t2s.getFingerprint()) continue;
                        return 2;
                    } while ((st = st.getBaseType()) != null);
                    return 4;
                }
                return 4;
            }
            if (t1 instanceof NodeTest) {
                IntSet n2;
                IntSet n1;
                UType m22;
                if (t2.isPlainType() || t2 instanceof FunctionItemType) {
                    return 4;
                }
                if (t1 instanceof AnyNodeTest) {
                    if (t2 instanceof AnyNodeTest) {
                        return 0;
                    }
                    return 1;
                }
                if (t2 instanceof AnyNodeTest) {
                    return 2;
                }
                if (t2 instanceof ErrorType) {
                    return 4;
                }
                UType m1 = t1.getUType();
                if (!m1.overlaps(m22 = t2.getUType())) {
                    return 4;
                }
                int nodeKindRelationship = m1.equals(m22) ? 0 : (m22.subsumes(m1) ? 2 : (m1.subsumes(m22) ? 1 : 3));
                Optional<IntSet> on1 = ((NodeTest)t1).getRequiredNodeNames();
                Optional<IntSet> on2 = ((NodeTest)t2).getRequiredNodeNames();
                int nodeNameRelationship = t1 instanceof QNameTest && t2 instanceof QNameTest ? TypeHierarchy.nameTestRelationship((QNameTest)((Object)t1), (QNameTest)((Object)t2)) : (on1.isPresent() && on1.get() instanceof IntUniversalSet ? (on2.isPresent() && on2.get() instanceof IntUniversalSet ? 0 : 1) : (on2.isPresent() && on2.get() instanceof IntUniversalSet ? 2 : (!on1.isPresent() || !on2.isPresent() ? (t1.equals(t2) ? 0 : 3) : ((n1 = on1.get()).containsAll(n2 = on2.get()) ? (n1.size() == n2.size() ? 0 : 1) : (n2.containsAll(n1) ? 2 : (IntHashSet.containsSome(n1, n2) ? 3 : 4))))));
                int contentRelationship = this.computeContentRelationship(t1, t2, on1, on2);
                if (nodeKindRelationship == 0 && nodeNameRelationship == 0 && contentRelationship == 0) {
                    return 0;
                }
                if (!(nodeKindRelationship != 0 && nodeKindRelationship != 1 || nodeNameRelationship != 0 && nodeNameRelationship != 1 || contentRelationship != 0 && contentRelationship != 1)) {
                    return 1;
                }
                if (!(nodeKindRelationship != 0 && nodeKindRelationship != 2 || nodeNameRelationship != 0 && nodeNameRelationship != 2 || contentRelationship != 0 && contentRelationship != 2)) {
                    return 2;
                }
                if (nodeNameRelationship == 4 || contentRelationship == 4) {
                    return 4;
                }
                return 3;
            }
            if (t1 instanceof AnyExternalObjectType) {
                if (!(t2 instanceof AnyExternalObjectType)) {
                    return 4;
                }
                if (t1 instanceof JavaExternalObjectType) {
                    if (t2 == AnyExternalObjectType.THE_INSTANCE) {
                        return 2;
                    }
                    if (t2 instanceof JavaExternalObjectType) {
                        return ((JavaExternalObjectType)t1).getRelationship((JavaExternalObjectType)t2);
                    }
                    return 4;
                }
                if (t2 instanceof JavaExternalObjectType) {
                    return 1;
                }
                return 4;
            }
            if (t1 instanceof MapType && t2 instanceof MapType) {
                int valueRel;
                if (t1 == MapType.EMPTY_MAP_TYPE) {
                    return 2;
                }
                if (t2 == MapType.EMPTY_MAP_TYPE) {
                    return 1;
                }
                if (t1 == MapType.ANY_MAP_TYPE) {
                    return 1;
                }
                if (t2 == MapType.ANY_MAP_TYPE) {
                    return 2;
                }
                AtomicType k1 = ((MapType)t1).getKeyType();
                AtomicType k2 = ((MapType)t2).getKeyType();
                SequenceType v1 = ((MapType)t1).getValueType();
                SequenceType v2 = ((MapType)t2).getValueType();
                int keyRel = this.relationship(k1, k2);
                int rel = TypeHierarchy.combineRelationships(keyRel, valueRel = this.sequenceTypeRelationship(v1, v2));
                if (rel == 0 || rel == 1 || rel == 2) {
                    return rel;
                }
            }
            if (t2 instanceof FunctionItemType) {
                int signatureRelationship = ((FunctionItemType)t1).relationship((FunctionItemType)t2, this);
                if (signatureRelationship == 4) {
                    return 4;
                }
                int assertionRelationship = 0;
                AnnotationList first = ((FunctionItemType)t1).getAnnotationAssertions();
                AnnotationList second = ((FunctionItemType)t2).getAnnotationAssertions();
                HashSet<String> namespaces = new HashSet<String>();
                for (Annotation a : first) {
                    namespaces.add(a.getAnnotationQName().getURI());
                }
                for (Annotation a : second) {
                    namespaces.add(a.getAnnotationQName().getURI());
                }
                for (String ns : namespaces) {
                    FunctionAnnotationHandler handler = this.config.getFunctionAnnotationHandler(ns);
                    if (handler == null) continue;
                    int localRel = 0;
                    AnnotationList firstFiltered = first.filterByNamespace(ns);
                    AnnotationList secondFiltered = second.filterByNamespace(ns);
                    if (firstFiltered.isEmpty()) {
                        if (!secondFiltered.isEmpty()) {
                            localRel = 1;
                        }
                    } else {
                        localRel = secondFiltered.isEmpty() ? 2 : handler.relationship(firstFiltered, secondFiltered);
                    }
                    assertionRelationship = TypeHierarchy.combineRelationships(assertionRelationship, localRel);
                }
                return TypeHierarchy.combineRelationships(signatureRelationship, assertionRelationship);
            }
            return 4;
        }
        catch (MissingComponentException e) {
            return 3;
        }
    }

    private static int nameTestRelationship(QNameTest t1, QNameTest t2) {
        if (t1.equals(t2)) {
            return 0;
        }
        if (t2 instanceof NameTest) {
            return t1.matches(((NameTest)t2).getMatchingNodeName()) ? 1 : 4;
        }
        if (t1 instanceof NameTest) {
            return t2.matches(((NameTest)t1).getMatchingNodeName()) ? 2 : 4;
        }
        if (t2 instanceof SameNameTest) {
            return t1.matches(((SameNameTest)t2).getMatchingNodeName()) ? 1 : 4;
        }
        if (t1 instanceof SameNameTest) {
            return t2.matches(((SameNameTest)t1).getMatchingNodeName()) ? 2 : 4;
        }
        if (t1 instanceof NamespaceTest && t2 instanceof NamespaceTest) {
            return 4;
        }
        if (t1 instanceof LocalNameTest && t2 instanceof LocalNameTest) {
            return 4;
        }
        return 3;
    }

    private static int combineRelationships(int rel1, int rel2) {
        if (rel1 == 0 && rel2 == 0) {
            return 0;
        }
        if (!(rel1 != 0 && rel1 != 1 || rel2 != 0 && rel2 != 1)) {
            return 1;
        }
        if (!(rel1 != 0 && rel1 != 2 || rel2 != 0 && rel2 != 2)) {
            return 2;
        }
        if (rel1 == 4 || rel2 == 4) {
            return 4;
        }
        return 3;
    }

    private static <X> Set<X> toSet(Iterable<X> in) {
        HashSet<X> s2 = new HashSet<X>();
        for (X x : in) {
            s2.add(x);
        }
        return s2;
    }

    private boolean unionSubsumes(Set<? extends PlainType> s1, Set<? extends PlainType> s2) {
        for (PlainType plainType : s2) {
            boolean t2isSubsumed = false;
            for (PlainType plainType2 : s1) {
                int rel = this.relationship(plainType2, plainType);
                if (rel != 1 && rel != 0) continue;
                t2isSubsumed = true;
                break;
            }
            if (t2isSubsumed) continue;
            return false;
        }
        return true;
    }

    private boolean unionOverlaps(Set<? extends PlainType> s1, Set<? extends PlainType> s2) {
        for (PlainType plainType : s2) {
            for (PlainType plainType2 : s1) {
                int rel = this.relationship(plainType2, plainType);
                if (rel == 4) continue;
                return true;
            }
        }
        return false;
    }

    protected int computeContentRelationship(ItemType t1, ItemType t2, Optional<IntSet> n1, Optional<IntSet> n2) {
        int contentRelationship;
        if (t1 instanceof DocumentNodeTest) {
            contentRelationship = t2 instanceof DocumentNodeTest ? this.relationship(((DocumentNodeTest)t1).getElementTest(), ((DocumentNodeTest)t2).getElementTest()) : 2;
        } else if (t2 instanceof DocumentNodeTest) {
            contentRelationship = 1;
        } else {
            SchemaType s1 = ((NodeTest)t1).getContentType();
            SchemaType s2 = ((NodeTest)t2).getContentType();
            contentRelationship = this.schemaTypeRelationship(s1, s2);
        }
        boolean nillable1 = ((NodeTest)t1).isNillable();
        boolean nillable2 = ((NodeTest)t2).isNillable();
        if (nillable1 != nillable2) {
            switch (contentRelationship) {
                case 1: {
                    if (nillable2) {
                        contentRelationship = 3;
                        break;
                    }
                }
                case 2: {
                    if (nillable1) {
                        contentRelationship = 3;
                        break;
                    }
                }
                case 0: {
                    if (nillable1) {
                        contentRelationship = 1;
                        break;
                    }
                    contentRelationship = 2;
                    break;
                }
            }
        }
        return contentRelationship;
    }

    public int sequenceTypeRelationship(SequenceType s1, SequenceType s2) {
        int cardRel;
        int c2;
        int c1 = s1.getCardinality();
        if (c1 == (c2 = s2.getCardinality())) {
            cardRel = 0;
        } else if (Cardinality.subsumes(c1, c2)) {
            cardRel = 1;
        } else if (Cardinality.subsumes(c2, c1)) {
            cardRel = 2;
        } else {
            if (c1 == 8192 && !Cardinality.allowsZero(c2)) {
                return 4;
            }
            if (c2 == 8192 && !Cardinality.allowsZero(c1)) {
                return 4;
            }
            cardRel = 3;
        }
        int itemRel = this.relationship(s1.getPrimaryType(), s2.getPrimaryType());
        if (itemRel == 4) {
            return 4;
        }
        if (cardRel == 0 || cardRel == itemRel) {
            return itemRel;
        }
        if (itemRel == 0) {
            return cardRel;
        }
        return 3;
    }

    public int schemaTypeRelationship(SchemaType s1, SchemaType s2) {
        if (s1.isSameType(s2)) {
            return 0;
        }
        if (s1 instanceof AnyType) {
            return 1;
        }
        if (s2 instanceof AnyType) {
            return 2;
        }
        if (s1 instanceof Untyped && (s2 == BuiltInAtomicType.ANY_ATOMIC || s2 == BuiltInAtomicType.UNTYPED_ATOMIC)) {
            return 3;
        }
        if (s2 instanceof Untyped && (s1 == BuiltInAtomicType.ANY_ATOMIC || s1 == BuiltInAtomicType.UNTYPED_ATOMIC)) {
            return 3;
        }
        if (s1 instanceof ItemType && s2 instanceof ItemType) {
            return this.relationship((ItemType)((Object)s1), (ItemType)((Object)s2));
        }
        SchemaType t1 = s1;
        while ((t1 = t1.getBaseType()) != null) {
            if (!t1.isSameType(s2)) continue;
            return 2;
        }
        SchemaType t2 = s2;
        while ((t2 = t2.getBaseType()) != null) {
            if (!t2.isSameType(s1)) continue;
            return 1;
        }
        return 4;
    }

    public static int inverseRelationship(int relation) {
        switch (relation) {
            case 0: {
                return 0;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
        }
        throw new IllegalArgumentException();
    }

    public ItemType getGenericFunctionItemType() {
        return AnyItemType.getInstance();
    }

    private static class ItemTypePair {
        ItemType s;
        ItemType t;

        public ItemTypePair(ItemType s2, ItemType t) {
            this.s = s2;
            this.t = t;
        }

        public int hashCode() {
            return this.s.hashCode() ^ this.t.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ItemTypePair) {
                ItemTypePair pair = (ItemTypePair)obj;
                return this.s.equals(pair.s) && this.t.equals(pair.t);
            }
            return false;
        }
    }
}

