/*
 * 86Box    A hypervisor and IBM PC system emulator that specializes in
 *          running old operating systems and software designed for IBM
 *          PC systems and compatibles from 1981 through fairly recent
 *          system designs based on the PCI bus.
 *
 *          This file is part of the 86Box distribution.
 *
 *          Define the various paper sizes for printers.
 *
 * Authors: Jasmine Iwanek, <jasmine@iwanek.co.uk>
 *
 *          Copyright 2025 Jasmine Iwanek
 */
#ifndef EMU_PRT_PAPERSIZES_H
#define EMU_PRT_PAPERSIZES_H

/* Standard U.S. Letter */
#define LETTER_PAGE_WIDTH   8.5
#define LETTER_PAGE_HEIGHT  11.0

/* Standard U.S. Legal */
#define LEGAL_PAGE_WIDTH   8.5
#define LEGAL_PAGE_HEIGHT  14.0

/* Standard U.S. Ledger */
#define LEDGER_PAGE_WIDTH   11.0
#define LEDGER_PAGE_HEIGHT  17.0

/* Standard A0 */
#define A0_PAGE_WIDTH   33.125
#define A0_PAGE_HEIGHT  46.75

/* Standard A1 */
#define A1_PAGE_WIDTH   23.375
#define A1_PAGE_HEIGHT  33.125

/* Standard A2 */
#define A2_PAGE_WIDTH   16.5
#define A2_PAGE_HEIGHT  23.375

/* Standard A3 */
#define A3_PAGE_WIDTH   11.75
#define A3_PAGE_HEIGHT  16.5

/* Standard A4 */
#define A4_PAGE_WIDTH   8.25
#define A4_PAGE_HEIGHT  11.75

#endif /*EMU_PLAT_FALLTHROUGH_H*/
