/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ee extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Greenwich ga\u0192o\u0192o me",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Apia nutome ga\u0192o\u0192o me",
               "",
               "Apia kele ga\u0192o\u0192o me",
               "",
               "Apia ga\u0192o\u0192o me",
               "",
            };
        final String[] Cook = new String[] {
               "Cook Islands nutome ga\u0192o\u0192o me",
               "",
               "Cook Islands dzome\u014b\u0254li ga\u0192o\u0192o me",
               "",
               "Cook Islands ga\u0192o\u0192o me",
               "",
            };
        final String[] Cuba = new String[] {
               "Cuba nutome ga\u0192o\u0192ome",
               "CST",
               "Cuba kele ga\u0192o\u0192ome",
               "CDT",
               "Cuba ga\u0192o\u0192ome",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Fiji nutome ga\u0192o\u0192o me",
               "",
               "Fiji dzome\u014b\u0254li ga\u0192o\u0192o me",
               "",
               "Fiji ga\u0192o\u0192o me",
               "",
            };
        final String[] Gulf = new String[] {
               "Gulf nutome ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Hovd nutome ga\u0192o\u0192o me",
               "",
               "Hovd dzome\u014b\u0254li ga\u0192o\u0192o me",
               "",
               "Hovd ga\u0192o\u0192o me",
               "",
            };
        final String[] Iran = new String[] {
               "Iran nutome ga\u0192o\u0192o me",
               "",
               "Iran kele ga\u0192o\u0192o me",
               "",
               "Iran ga\u0192o\u0192o me",
               "",
            };
        final String[] Niue = new String[] {
               "Niue ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Omsk nutome ga\u0192o\u0192o me",
               "",
               "Omsk dzome\u014b\u0254li ga\u0192o\u0192o me",
               "",
               "Omsk ga\u0192o\u0192o me",
               "",
            };
        final String[] Peru = new String[] {
               "Peru nutome ga\u0192o\u0192o me",
               "",
               "Peru dzome\u014b\u0254li ga\u0192o\u0192ome",
               "",
               "Peru ga\u0192o\u0192o me",
               "",
            };
        final String[] Truk = new String[] {
               "Chuuk ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Wake Island ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Chile nutome ga\u0192o\u0192o me",
               "",
               "Chile dzome\u014b\u0254li ga\u0192o\u0192o me",
               "",
               "Chile ga\u0192o\u0192o me",
               "",
            };
        final String[] China = new String[] {
               "China nutome ga\u0192o\u0192o me",
               "CST",
               "China kele ga\u0192o\u0192o me",
               "CDT",
               "China ga\u0192o\u0192o me",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Cocos Islands ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Davis ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "India ga\u0192o\u0192o me",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Japan nutome ga\u0192o\u0192o me",
               "JST",
               "Japan dzome\u014b\u0254li ga\u0192o\u0192o me",
               "JDT",
               "Japan ga\u0192o\u0192o me",
               "JT",
            };
        final String[] Korea = new String[] {
               "Korea nutome ga\u0192o\u0192o me",
               "KST",
               "Korea dzome\u014b\u0254li ga\u0192o\u0192o me",
               "KST",
               "Korea ga\u0192o\u0192o me",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Nauru ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Nepal ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Palau ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samoa nutome ga\u0192o\u0192o me",
               "SST",
               "Samoa kele ga\u0192o\u0192o me",
               "SST",
               "Samoa ga\u0192o\u0192o me",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Syowa ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tonga nutome ga\u0192o\u0192o me",
               "",
               "Tonga dzome\u014b\u0254li ga\u0192o\u0192o me",
               "",
               "Tonga ga\u0192o\u0192o me",
               "",
            };
        final String[] Alaska = new String[] {
               "Alaska nutome ga\u0192o\u0192o me",
               "AKST",
               "Alaska kele ga\u0192o\u0192o me",
               "AKDT",
               "Alaska ga\u0192o\u0192ome",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Amazon nutome ga\u0192o\u0192o me",
               "",
               "Amazon dzome\u014b\u0254li ga\u0192o\u0192o me",
               "",
               "Amazon ga\u0192o\u0192ome",
               "",
            };
        final String[] Azores = new String[] {
               "Azores nutome ga\u0192o\u0192o me",
               "",
               "Azores dzome\u014b\u0254li ga\u0192o\u0192o me",
               "",
               "Azores ga\u0192o\u0192o me",
               "",
            };
        final String[] Bhutan = new String[] {
               "Bhutan ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Brunei Darussalam ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Easter Island nutome ga\u0192o\u0192o me",
               "",
               "Easter Island dzome\u014b\u0254li ga\u0192o\u0192o me",
               "",
               "Easter Island ga\u0192o\u0192o me",
               "",
            };
        final String[] Guyana = new String[] {
               "Guyana ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Israel nutome ga\u0192o\u0192o me",
               "IST",
               "Israel kele ga\u0192o\u0192o me",
               "IDT",
               "Israel ga\u0192o\u0192o me",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Kosrae ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Mawson ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Moscow nutome ga\u0192o\u0192o me",
               "MSK",
               "Moscow dzome\u014b\u0254li ga\u0192o\u0192o me",
               "MSK",
               "Moscow ga\u0192o\u0192o me",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Ponape ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tahiti ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Taipei nutome ga\u0192o\u0192o me",
               "CST",
               "Taipei kele ga\u0192o\u0192o me",
               "CDT",
               "Taipei ga\u0192o\u0192o me",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalu ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Vostok ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Wallis & Futuna ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Arabia nutome ga\u0192o\u0192o me",
               "",
               "Arabia dzome\u014b\u0254li ga\u0192o\u0192o me",
               "",
               "Arabia ga\u0192o\u0192o me",
               "",
            };
        final String[] Armenia = new String[] {
               "Armenia nutome ga\u0192o\u0192o me",
               "",
               "Armenia dzome\u014b\u0254li ga\u0192o\u0192o me",
               "",
               "Armenia ga\u0192o\u0192o me",
               "",
            };
        final String[] Bolivia = new String[] {
               "Bolivia ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Chatham nutome ga\u0192o\u0192o me",
               "",
               "Chatham kele ga\u0192o\u0192o me",
               "",
               "Chatham ga\u0192o\u0192o me",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Xexeme ga\u0192o\u0192o\u0256oanyi me",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ecuador ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambier ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Georgia nutome ga\u0192o\u0192o me",
               "",
               "Georgia dzome\u014b\u0254li ga\u0192o\u0192o me",
               "",
               "Georgia ga\u0192o\u0192o me",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkutsk nutome ga\u0192o\u0192o me",
               "",
               "Irkutsk dzome\u014b\u0254li ga\u0192o\u0192o me",
               "",
               "Irkutsk ga\u0192o\u0192o me",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadan nutome ga\u0192o\u0192o me",
               "",
               "Magadan dzome\u014b\u0254li ga\u0192o\u0192o me",
               "",
               "Magadan ga\u0192o\u0192o me",
               "",
            };
        final String[] Myanmar = new String[] {
               "Myanmar ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Norfolk Island nutome ga\u0192o\u0192o me",
               "",
               "Norfolk Island dzome\u014b\u0254li ga\u0192o\u0192o me",
               "",
               "Norfolk Island ga\u0192o\u0192o me",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronha nutome ga\u0192o\u0192o me",
               "",
               "Fernando de Noronha dzome\u014b\u0254li ga\u0192o\u0192o me",
               "",
               "Fernando de Noronha ga\u0192o\u0192o me",
               "",
            };
        final String[] Reunion = new String[] {
               "Reunion ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Rothera ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Solomon Islands ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokelau ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Uruguay nutome ga\u0192o\u0192o me",
               "",
               "Uruguay dzome\u014b\u0254li ga\u0192o\u0192o me",
               "",
               "Uruguay ga\u0192o\u0192o me",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu nutome ga\u0192o\u0192o me",
               "",
               "Vanuatu dzome\u014b\u0254li ga\u0192o\u0192o me",
               "",
               "Vanuatu ga\u0192o\u0192o me",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Yakutsk nutome ga\u0192o\u0192o me",
               "",
               "Yakutsk dzome\u014b\u0254li ga\u0192o\u0192o me",
               "",
               "Yakutsk ga\u0192o\u0192o me",
               "",
            };
        final String[] Atlantic = new String[] {
               "Atlantic nutome ga\u0192o\u0192ome",
               "AST",
               "Atlantic kele ga\u0192o\u0192ome",
               "AST",
               "Atlantic ga\u0192o\u0192ome",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Brasilia nutome ga\u0192o\u0192o me",
               "",
               "Brasilia dzome\u014b\u0254li ga\u0192o\u0192o me",
               "",
               "Brasilia ga\u0192o\u0192o me",
               "",
            };
        final String[] Chamorro = new String[] {
               "Chamorro ga\u0192o\u0192o me",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Colombia nutome ga\u0192o\u0192o me",
               "",
               "Colombia dzome\u014b\u0254li ga\u0192o\u0192o me",
               "",
               "Colombia ga\u0192o\u0192o me",
               "",
            };
        final String[] Falkland = new String[] {
               "Falkland Islands nutome ga\u0192o\u0192o me",
               "",
               "Falkland Islands dzome\u014b\u0254li ga\u0192o\u0192o me",
               "",
               "Falkland Islands ga\u0192o\u0192o me",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malaysia ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Maldives ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ulan Bator nutome ga\u0192o\u0192o me",
               "",
               "Ulan Bator dzome\u014b\u0254li ga\u0192o\u0192o me",
               "",
               "Ulan Bator ga\u0192o\u0192o me",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakistan nutome ga\u0192o\u0192o me",
               "PKT",
               "Pakistan dzome\u014b\u0254li ga\u0192o\u0192o me",
               "PKST",
               "Pakistan ga\u0192o\u0192o me",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Paraguay nutome ga\u0192o\u0192o me",
               "",
               "Paraguay dzome\u014b\u0254li ga\u0192o\u0192o me",
               "",
               "Paraguay ga\u0192o\u0192o me",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairn ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Sakhalin nutome ga\u0192o\u0192o me",
               "",
               "Sakhalin dzome\u014b\u0254li ga\u0192o\u0192o me",
               "",
               "Sakhalin ga\u0192o\u0192o me",
               "",
            };
        final String[] Suriname = new String[] {
               "Suriname ga\u0192o\u0192ome",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Argentina nutome ga\u0192o\u0192o me",
               "",
               "Argentina dzome\u014b\u0254li ga\u0192o\u0192o me",
               "",
               "Argentina ga\u0192o\u0192o me",
               "",
            };
        final String[] Christmas = new String[] {
               "Christmas Island ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapagos ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hong Kong nutome ga\u0192o\u0192o me",
               "HKT",
               "Hong Kong dzome\u014b\u0254li ga\u0192o\u0192o me",
               "HKST",
               "Hong Kong ga\u0192o\u0192o me",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Indonesia ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kyrgystan ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howe nutome ga\u0192o\u0192o me",
               "",
               "Lord Howe kele ga\u0192o\u0192o me",
               "",
               "Lord Howe ga\u0192o\u0192o me",
               "",
            };
        final String[] Marquesas = new String[] {
               "Marquesas ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Mauritius nutome ga\u0192o\u0192o me",
               "",
               "Mauritius dzome\u014b\u0254li ga\u0192o\u0192o me",
               "",
               "Mauritius ga\u0192o\u0192o me",
               "",
            };
        final String[] Singapore = new String[] {
               "Singapore nutome ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Venezuela ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Volgograd nutome ga\u0192o\u0192o me",
               "MSK",
               "Vogograd dzome\u014b\u0254li ga\u0192o\u0192o me",
               "MSK",
               "Volgograd ga\u0192o\u0192o me",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Azerbaijan nutome ga\u0192o\u0192o me",
               "",
               "Azerbaijan dzome\u014b\u0254li ga\u0192o\u0192o me",
               "",
               "Azerbaijan ga\u0192o\u0192o me",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Bangladesh nutome ga\u0192o\u0192o me",
               "",
               "Bangladesh dzome\u014b\u0254li ga\u0192o\u0192o me",
               "",
               "Bangladesh ga\u0192o\u0192o me",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Cape Verde nutome ga\u0192o\u0192o me",
               "",
               "Cape Verde dzome\u014b\u0254li ga\u0192o\u0192o me",
               "",
               "Cape Verde ga\u0192o\u0192o me",
               "",
            };
        final String[] East_Timor = new String[] {
               "East Timor ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Seychelles ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tajikistan ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Uzbekistan nutome ga\u0192o\u0192o me",
               "",
               "Uzbekistan dzome\u014b\u0254li ga\u0192o\u0192o me",
               "",
               "Uzbekistan ga\u0192o\u0192o me",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afghanistan ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnoyarsk nutome ga\u0192o\u0192o me",
               "",
               "Krasnoyarsk dzome\u014b\u0254li ga\u0192o\u0192o me",
               "",
               "Krasnoyarsk ga\u0192o\u0192o me",
               "",
            };
        final String[] New_Zealand = new String[] {
               "New Zealand nutome ga\u0192o\u0192o me",
               "NZST",
               "New Zealand kele ga\u0192o\u0192o me",
               "NZDT",
               "New Zealand ga\u0192o\u0192o me",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirsk nutome ga\u0192o\u0192o me",
               "",
               "Novosibirsk dzome\u014b\u0254li ga\u0192o\u0192o me",
               "",
               "Novosibirsk ga\u0192o\u0192o me",
               "",
            };
        final String[] Philippines = new String[] {
               "Philippine nutome ga\u0192o\u0192o me",
               "PST",
               "Philippine dzome\u014b\u0254li ga\u0192o\u0192o me",
               "PDT",
               "Philippine ga\u0192o\u0192o me",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostok nutome ga\u0192o\u0192o me",
               "",
               "Vladivostok dzome\u014b\u0254li ga\u0192o\u0192o me",
               "",
               "Vladivostok ga\u0192o\u0192o me",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Indian Ocean ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Line Islands ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Newfoundland nutome ga\u0192o\u0192ome",
               "NST",
               "Newfoundland kele ga\u0192o\u0192ome",
               "NDT",
               "Newfoundland ga\u0192o\u0192ome",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmenistan nutome ga\u0192o\u0192o me",
               "",
               "Turkmenistan dzome\u014b\u0254li ga\u0192o\u0192o me",
               "",
               "Turkmenistan ga\u0192o\u0192o me",
               "",
            };
        final String[] French_Guiana = new String[] {
               "French Guiana ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "New Caledonia nutome ga\u0192o\u0192o me",
               "",
               "New Caledonia dzome\u014b\u0254li ga\u0192o\u0192o me",
               "",
               "New Caledonia ga\u0192o\u0192o me",
               "",
            };
        final String[] South_Georgia = new String[] {
               "South Georgia ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Yekaterinburg nutome ga\u0192o\u0192o me",
               "",
               "Yekaterinburg dzome\u014b\u0254li ga\u0192o\u0192o me",
               "",
               "Yekaterinburg ga\u0192o\u0192o me",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Central Africa ga\u0192o\u0192o me",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "East Africa ga\u0192o\u0192o me",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "West Africa nutome ga\u0192o\u0192o me",
               "WAT",
               "West Africa dzome\u014b\u0254li ga\u0192o\u0192o me",
               "WAST",
               "West Africa game",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont-d\u2019Urville ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Central Europe nutome ga\u0192o\u0192o me",
               "CET",
               "Central Europe dzome\u014b\u0254li ga\u0192o\u0192o me",
               "CEST",
               "Central Europe ga\u0192o\u0192o me",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "\u0194edze\u0192e Europe ga\u0192o\u0192o\u0256oanyime",
               "EET",
               "\u0194edze\u0192e Europe \u014bkekeme ga\u0192o\u0192ome",
               "EEST",
               "\u0194edze\u0192e Europe ga\u0192o\u0192ome",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Western Europe nutome ga\u0192o\u0192o me",
               "WET",
               "Western Europe dzome\u014b\u0254li ga\u0192o\u0192o me",
               "WEST",
               "Western Europe ga\u0192o\u0192o me",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Mexican Pacific nutome ga\u0192o\u0192o me",
               "MST",
               "Mexican Pacific kele ga\u0192o\u0192ome",
               "MDT",
               "Mexican Pacific ga\u0192o\u0192o me",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "South Africa nutome ga\u0192o\u0192o me",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Titina America nutome ga\u0192o\u0192o me",
               "CST",
               "Titina America kele ga\u0192o\u0192o me",
               "CDT",
               "Titina America ga\u0192o\u0192ome",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Eastern America nutome ga\u0192o\u0192o me",
               "EST",
               "Eastern America kele ga\u0192o\u0192o me",
               "EST",
               "Eastern America ga\u0192o\u0192o me",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Pacific nutome ga\u0192o\u0192o me",
               "PST",
               "Pacific kele ga\u0192o\u0192o me",
               "PDT",
               "Pacific ga\u0192o\u0192ome",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "French Southern & Antarctic ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilbert Islands ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaii-Aleutia nutome ga\u0192o\u0192o me",
               "HST",
               "Hawaii-Aleutia kele ga\u0192o\u0192o me",
               "HST",
               "Hawaii-Aleutia ga\u0192o\u0192o me",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Phoenix Islands ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "St. Pierre & Miquelon nutome ga\u0192o\u0192ome",
               "",
               "St. Pierre & Miquelon kele ga\u0192o\u0192ome",
               "",
               "St. Pierre & Miquelon ga\u0192o\u0192ome",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Mountain nutome ga\u0192o\u0192o me",
               "MST",
               "Mountain kele ga\u0192o\u0192o me",
               "MST",
               "Mountain ga\u0192o\u0192o me",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Marshall Islands ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua New Guinea ga\u0192o\u0192o me",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Australian Central nutome ga\u0192o\u0192o me",
               "ACST",
               "Australian Central dzomeli ga\u0192o\u0192o me",
               "ACDT",
               "Central Australia ga\u0192o\u0192o me",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Australian Eastern nutome ga\u0192o\u0192o me",
               "AEST",
               "Australian Eastern kele ga\u0192o\u0192o me",
               "AEDT",
               "Eastern Australia ga\u0192o\u0192o me",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Australian Western nutome ga\u0192o\u0192o me",
               "AWST",
               "Australian Western kele ga\u0192o\u0192o me",
               "AWDT",
               "Western Australia ga\u0192o\u0192o me",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Central Indonesia ga\u0192o\u0192o me",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Eastern Indonesia ga\u0192o\u0192o me",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Western Indonesia ga\u0192o\u0192o me",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Australian Central Western nutome ga\u0192o\u0192o me",
               "",
               "Australian Central Western kele ga\u0192o\u0192o me",
               "",
               "Australian Central Australia \u0263eto\u0256ofe ga\u0192o\u0192o me",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Greenwich ga\u0192o\u0192o me",
                    "GMT",
                    "British dzome\u014b\u0254li ga\u0192o\u0192o me",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Xexeme ga\u0192o\u0192o\u0256oanyi me",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Greenwich ga\u0192o\u0192o me",
                    "GMT",
                    "Ireland nutome ga\u0192o\u0192o me",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Xexeme ga\u0192o\u0192o\u0256oanyi me",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Xexeme ga\u0192o\u0192o\u0256oanyi me",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Greenwich ga\u0192o\u0192o me",
                    "GMT",
                    "British dzome\u014b\u0254li ga\u0192o\u0192o me",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Xexeme ga\u0192o\u0192o\u0256oanyi me",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "Xexeme ga\u0192o\u0192o\u0256oanyi me",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Xexeme ga\u0192o\u0192o\u0256oanyi me",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Greenwich ga\u0192o\u0192o me",
                    "GMT",
                    "Ireland nutome ga\u0192o\u0192o me",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Greenwich ga\u0192o\u0192o me",
                    "GMT",
                    "British dzome\u014b\u0254li ga\u0192o\u0192o me",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Greenwich ga\u0192o\u0192o me",
                    "GMT",
                    "British dzome\u014b\u0254li ga\u0192o\u0192o me",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Greenwich ga\u0192o\u0192o me",
                    "GMT",
                    "British dzome\u014b\u0254li ga\u0192o\u0192o me",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Greenwich ga\u0192o\u0192o me",
                    "GMT",
                    "British dzome\u014b\u0254li ga\u0192o\u0192o me",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Greenwich ga\u0192o\u0192o me",
                    "GMT",
                    "British dzome\u014b\u0254li ga\u0192o\u0192o me",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Macau", "Macau" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Etc/Unknown", "Du manya" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Asia/Katmandu", "Kathmandu nutomega\u0192o\u0192ome" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.America/Cancun", "Cancun" },
            { "timezone.excity.America/Merida", "Merida" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia Banderas" },
        };
        return data;
    }
}
