# Semantic Convention Changes

The `go.opentelemetry.io/otel/semconv/v1.30.0` should be a drop-in replacement for `go.opentelemetry.io/otel/semconv/v1.28.0` with the following exceptions.

Note: `go.opentelemetry.io/otel/semconv/v1.29.0` does not exist due to bugs from the upstream [OpenTelemetry Semantic Conventions].

## Dropped deprecations

The following declarations have been deprecated in the [OpenTelemetry Semantic Conventions].
Refer to the respective documentation in that repository for deprecation instructions for each type.

- `CodeColumn`
- `CodeColumnKey`
- `CodeFunction`
- `CodeFunctionKey`
- `DBCassandraConsistencyLevelAll`
- `DBCassandraConsistencyLevelAny`
- `DBCassandraConsistencyLevelEachQuorum`
- `DBCassandraConsistencyLevelKey`
- `DBCassandraConsistencyLevelLocalOne`
- `DBCassandraConsistencyLevelLocalQuorum`
- `DBCassandraConsistencyLevelLocalSerial`
- `DBCassandraConsistencyLevelOne`
- `DBCassandraConsistencyLevelQuorum`
- `DBCassandraConsistencyLevelSerial`
- `DBCassandraConsistencyLevelThree`
- `DBCassandraConsistencyLevelTwo`
- `DBCassandraCoordinatorDC`
- `DBCassandraCoordinatorDCKey`
- `DBCassandraCoordinatorID`
- `DBCassandraCoordinatorIDKey`
- `DBCassandraIdempotence`
- `DBCassandraIdempotenceKey`
- `DBCassandraPageSize`
- `DBCassandraPageSizeKey`
- `DBCassandraSpeculativeExecutionCount`
- `DBCassandraSpeculativeExecutionCountKey`
- `DBCosmosDBClientID`
- `DBCosmosDBClientIDKey`
- `DBCosmosDBConnectionModeDirect`
- `DBCosmosDBConnectionModeGateway`
- `DBCosmosDBConnectionModeKey`
- `DBCosmosDBOperationTypeBatch`
- `DBCosmosDBOperationTypeCreate`
- `DBCosmosDBOperationTypeDelete`
- `DBCosmosDBOperationTypeExecute`
- `DBCosmosDBOperationTypeExecuteJavascript`
- `DBCosmosDBOperationTypeHead`
- `DBCosmosDBOperationTypeHeadFeed`
- `DBCosmosDBOperationTypeInvalid`
- `DBCosmosDBOperationTypeKey`
- `DBCosmosDBOperationTypePatch`
- `DBCosmosDBOperationTypeQuery`
- `DBCosmosDBOperationTypeQueryPlan`
- `DBCosmosDBOperationTypeRead`
- `DBCosmosDBOperationTypeReadFeed`
- `DBCosmosDBOperationTypeReplace`
- `DBCosmosDBOperationTypeUpsert`
- `DBCosmosDBRequestCharge`
- `DBCosmosDBRequestChargeKey`
- `DBCosmosDBRequestContentLength`
- `DBCosmosDBRequestContentLengthKey`
- `DBCosmosDBSubStatusCode`
- `DBCosmosDBSubStatusCodeKey`
- `DBElasticsearchNodeName`
- `DBElasticsearchNodeNameKey`
- `DBSystemAdabas`
- `DBSystemCache`
- `DBSystemCassandra`
- `DBSystemClickhouse`
- `DBSystemCloudscape`
- `DBSystemCockroachdb`
- `DBSystemColdfusion`
- `DBSystemCosmosDB`
- `DBSystemCouchDB`
- `DBSystemCouchbase`
- `DBSystemDb2`
- `DBSystemDerby`
- `DBSystemDynamoDB`
- `DBSystemEDB`
- `DBSystemElasticsearch`
- `DBSystemFilemaker`
- `DBSystemFirebird`
- `DBSystemFirstSQL`
- `DBSystemGeode`
- `DBSystemH2`
- `DBSystemHBase`
- `DBSystemHSQLDB`
- `DBSystemHanaDB`
- `DBSystemHive`
- `DBSystemInfluxdb`
- `DBSystemInformix`
- `DBSystemIngres`
- `DBSystemInstantDB`
- `DBSystemInterbase`
- `DBSystemIntersystemsCache`
- `DBSystemKey`
- `DBSystemMSSQL`
- `DBSystemMariaDB`
- `DBSystemMaxDB`
- `DBSystemMemcached`
- `DBSystemMongoDB`
- `DBSystemMssqlcompact`
- `DBSystemMySQL`
- `DBSystemNeo4j`
- `DBSystemNetezza`
- `DBSystemOpensearch`
- `DBSystemOracle`
- `DBSystemOtherSQL`
- `DBSystemPervasive`
- `DBSystemPointbase`
- `DBSystemPostgreSQL`
- `DBSystemProgress`
- `DBSystemRedis`
- `DBSystemRedshift`
- `DBSystemSpanner`
- `DBSystemSqlite`
- `DBSystemSybase`
- `DBSystemTeradata`
- `DBSystemTrino`
- `DBSystemVertica`
- `EventName`
- `EventNameKey`
- `ExceptionEscaped`
- `ExceptionEscapedKey`
- `GenAIOpenaiRequestSeed`
- `GenAIOpenaiRequestSeedKey`
- `ProcessExecutableBuildIDProfiling`
- `ProcessExecutableBuildIDProfilingKey`
- `SystemNetworkStateClose`
- `SystemNetworkStateCloseWait`
- `SystemNetworkStateClosing`
- `SystemNetworkStateDelete`
- `SystemNetworkStateEstablished`
- `SystemNetworkStateFinWait1`
- `SystemNetworkStateFinWait2`
- `SystemNetworkStateKey`
- `SystemNetworkStateLastAck`
- `SystemNetworkStateListen`
- `SystemNetworkStateSynRecv`
- `SystemNetworkStateSynSent`
- `SystemNetworkStateTimeWait`
- `VCSRepositoryChangeID`
- `VCSRepositoryChangeIDKey`
- `VCSRepositoryChangeTitle`
- `VCSRepositoryChangeTitleKey`
- `VCSRepositoryRefName`
- `VCSRepositoryRefNameKey`
- `VCSRepositoryRefRevision`
- `VCSRepositoryRefRevisionKey`
- `VCSRepositoryRefTypeBranch`
- `VCSRepositoryRefTypeKey`
- `VCSRepositoryRefTypeTag`

[OpenTelemetry Semantic Conventions]: https://github.com/open-telemetry/semantic-conventions
