/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.addons;

import java.lang.reflect.Field;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.java.codegen.Reified;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.Java;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class ClassJavaAddons {
    @JRubyMethod
    public static IRubyObject java_class(ThreadContext context, IRubyObject self2) {
        Class<?> reifiedClass = RubyClass.nearestReifiedClass((RubyClass)self2);
        if (reifiedClass == null) {
            return context.nil;
        }
        return ClassJavaAddons.asJavaClass(context.runtime, reifiedClass);
    }

    private static JavaProxy asJavaClass(Ruby runtime2, Class<?> reifiedClass) {
        return (JavaProxy)Java.getInstance(runtime2, reifiedClass);
    }

    @JRubyMethod(name={"become_java!"})
    public static IRubyObject become_java(ThreadContext context, IRubyObject self2) {
        return ClassJavaAddons.becomeJava(context, (RubyClass)self2, null, true);
    }

    @JRubyMethod(name={"become_java!"}, required=1, optional=1, checkArity=false)
    public static IRubyObject become_java(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        RubyClass klass = (RubyClass)self2;
        int argc = Arity.checkArgumentCount(context, args2, 1, 2);
        String dumpDir = null;
        boolean useChildLoader = true;
        if (args2[0] instanceof RubyString) {
            dumpDir = args2[0].asJavaString();
            if (argc > 1) {
                useChildLoader = args2[1].isTrue();
            }
        } else {
            useChildLoader = args2[0].isTrue();
            if (argc > 1 && args2[1] instanceof RubyString) {
                dumpDir = args2[1].asJavaString();
            }
        }
        return ClassJavaAddons.becomeJava(context, klass, dumpDir, useChildLoader);
    }

    private static IRubyObject becomeJava(ThreadContext context, RubyClass klass, String dumpDir, boolean useChildLoader) {
        klass.reifyWithAncestors(dumpDir, useChildLoader);
        Class<? extends Reified> reifiedClass = klass.getReifiedClass();
        if (reifiedClass == null) {
            throw context.runtime.newTypeError("requested class " + klass.getName() + " was not reifiable");
        }
        ClassJavaAddons.generateFieldAccessors(context, klass, reifiedClass);
        return ClassJavaAddons.asJavaClass(context.runtime, reifiedClass);
    }

    private static void generateFieldAccessors(ThreadContext context, RubyClass klass, Class<?> javaClass) {
        for (String name2 : ClassJavaAddons.getJavaFieldNames(klass)) {
            Field field;
            try {
                field = javaClass.getDeclaredField(name2);
            }
            catch (NoSuchFieldException e) {
                throw context.runtime.newRuntimeError("no field: '" + name2 + "' in reified class for " + klass.getName());
            }
            JavaProxy.installField(context, name2, field, klass);
        }
    }

    private static Set<String> getJavaFieldNames(RubyClass klass) {
        return klass.getFieldSignatures().keySet();
    }
}

