/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import org.jruby.RubyBoolean;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.ImmutableLiteral;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.runtime.ThreadContext;

public class Boolean
extends ImmutableLiteral {
    private final boolean truthy;

    public Boolean(boolean truthy) {
        this.truthy = truthy;
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.BOOLEAN;
    }

    public Object createCacheObject(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.isTrue());
    }

    public boolean isTrue() {
        return this.truthy;
    }

    public boolean isFalse() {
        return !this.truthy;
    }

    public boolean equals(Object other) {
        return other instanceof Boolean && this.truthy == ((Boolean)other).truthy;
    }

    public int hashCode() {
        return 287 + (this.truthy ? 1 : 0);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.Boolean(this);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.isTrue());
    }

    public static Boolean decode(IRReaderDecoder d) {
        return d.decodeBoolean() ? d.getCurrentScope().getManager().getTrue() : d.getCurrentScope().getManager().getFalse();
    }

    public String toString() {
        return this.isTrue() ? "true" : "false";
    }

    @Override
    public boolean isTruthyImmediate() {
        return this.truthy;
    }

    @Override
    public boolean isFalseyImmediate() {
        return !this.truthy;
    }
}

