/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.thread;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyNumeric;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.thread.Queue;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"SizedQueue"}, parent="Queue")
public class SizedQueue
extends Queue {
    private final RubyThread.Task<IRubyObject, IRubyObject> blockingPushTask = new RubyThread.Task<IRubyObject, IRubyObject>(){

        @Override
        public IRubyObject run(ThreadContext context, IRubyObject value2) throws InterruptedException {
            SizedQueue.this.putInternal(context, value2);
            return SizedQueue.this;
        }

        @Override
        public void wakeup(RubyThread thread2, IRubyObject value2) {
            thread2.getNativeThread().interrupt();
        }
    };
    private final RubyThread.Task<IRubyObject, IRubyObject> nonblockingPushTask = new RubyThread.Task<IRubyObject, IRubyObject>(){

        @Override
        public IRubyObject run(ThreadContext context, IRubyObject value2) {
            if (!SizedQueue.this.offerInternal(context, value2)) {
                throw context.runtime.newThreadError("queue full");
            }
            return SizedQueue.this;
        }

        @Override
        public void wakeup(RubyThread thread2, IRubyObject value2) {
            thread2.getNativeThread().interrupt();
        }
    };

    protected SizedQueue(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    public SizedQueue(Ruby runtime2, RubyClass type2, int max2) {
        super(runtime2, type2);
        this.initialize(runtime2.getCurrentContext(), runtime2.newFixnum(max2));
    }

    public static RubyClass setup(RubyClass threadClass, RubyClass queueClass, RubyClass objectClass) {
        RubyClass cSizedQueue = threadClass.defineClassUnder("SizedQueue", queueClass, SizedQueue::new);
        cSizedQueue.setReifiedClass(SizedQueue.class);
        cSizedQueue.defineAnnotatedMethods(SizedQueue.class);
        objectClass.setConstant("SizedQueue", cSizedQueue);
        return cSizedQueue;
    }

    @JRubyMethod
    public RubyNumeric max(ThreadContext context) {
        return RubyNumeric.int2fix(context.runtime, this.capacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"max="})
    public synchronized IRubyObject max_set(ThreadContext context, IRubyObject arg2) {
        this.initializedCheck();
        Ruby runtime2 = context.runtime;
        int max2 = RubyNumeric.num2int(arg2);
        int diff = 0;
        if (max2 <= 0) {
            throw runtime2.newArgumentError("queue size must be positive");
        }
        this.fullyLock();
        try {
            if (this.count.get() >= this.capacity && max2 > this.capacity) {
                diff = max2 - this.capacity;
            }
            this.capacity = max2;
            while (diff-- > 0) {
                this.notFull.signal();
            }
            IRubyObject iRubyObject = arg2;
            return iRubyObject;
        }
        finally {
            this.fullyUnlock();
        }
    }

    @Override
    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public synchronized IRubyObject initialize(ThreadContext context, IRubyObject arg2) {
        this.capacity = Integer.MAX_VALUE;
        this.max_set(context, arg2);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    @JRubyMethod
    public RubyNumeric num_waiting(ThreadContext context) {
        this.initializedCheck();
        ReentrantLock takeLock = this.takeLock;
        ReentrantLock putLock = this.putLock;
        try {
            takeLock.lockInterruptibly();
            try {
                putLock.lockInterruptibly();
                try {
                    RubyFixnum rubyFixnum = context.runtime.newFixnum(takeLock.getWaitQueueLength(this.notEmpty) + putLock.getWaitQueueLength(this.notFull));
                    putLock.unlock();
                    return rubyFixnum;
                }
                catch (Throwable throwable) {
                    putLock.unlock();
                    throw throwable;
                }
            }
            finally {
                takeLock.unlock();
            }
        }
        catch (InterruptedException ie) {
            throw this.createInterruptedError(context, "num_waiting");
        }
    }

    @Override
    @JRubyMethod(name={"push", "<<", "enq"})
    public IRubyObject push(ThreadContext context, IRubyObject arg0) {
        this.initializedCheck();
        try {
            return context.getThread().executeTaskBlocking(context, arg0, this.blockingPushTask);
        }
        catch (InterruptedException ie) {
            throw this.createInterruptedError(context, "push");
        }
    }

    @JRubyMethod(name={"push", "<<", "enq"})
    public IRubyObject push(ThreadContext context, IRubyObject arg0, IRubyObject nonblock2) {
        this.initializedCheck();
        try {
            RubyThread thread2 = context.getThread();
            if (nonblock2.isTrue()) {
                return thread2.executeTask(context, arg0, this.nonblockingPushTask);
            }
            return thread2.executeTaskBlocking(context, arg0, this.blockingPushTask);
        }
        catch (InterruptedException ie) {
            throw this.createInterruptedError(context, "push");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean offerInternal(ThreadContext context, IRubyObject e) {
        if (e == null) {
            throw new NullPointerException();
        }
        AtomicInteger count2 = this.count;
        if (count2.get() == this.capacity) {
            return false;
        }
        int c = -1;
        Queue.Node node = new Queue.Node(e);
        ReentrantLock putLock = this.putLock;
        putLock.lock();
        try {
            if (this.closed) {
                this.raiseClosedError(context);
            }
            if (count2.get() < this.capacity) {
                this.enqueue(node);
                c = count2.getAndIncrement();
                if (c + 1 < this.capacity) {
                    this.notFull.signal();
                }
            }
        }
        finally {
            putLock.unlock();
        }
        if (c == 0) {
            this.signalNotEmpty();
        }
        return c >= 0;
    }

    @Deprecated
    public IRubyObject push(ThreadContext context, IRubyObject[] argv2) {
        switch (argv2.length) {
            case 1: {
                return this.push(context, argv2[0]);
            }
            case 2: {
                return this.push(context, argv2[0], argv2[1]);
            }
        }
        throw context.runtime.newArgumentError(argv2.length, 1, 2);
    }
}

