## RabbitMQ 4.0.7

RabbitMQ `4.0.7` is a maintenance release in the `4.0.x` [release series](https://www.rabbitmq.com/release-information).

Starting June 1st, 2024, community support for this series will only be provided to [regularly contributing users](https://github.com/rabbitmq/rabbitmq-server/blob/main/COMMUNITY_SUPPORT.md) and those
who hold a valid [commercial support license](https://tanzu.vmware.com/rabbitmq/oss).

It is **strongly recommended** that you read [4.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v4.0.1)
in detail if upgrading from a version prior to `4.0.0`.


### Minimum Supported Erlang Version

This release requires Erlang 26 and supports Erlang versions up to `27.2.x`.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/docs/which-erlang) has more details on
Erlang version requirements for RabbitMQ.

Nodes **will fail to start** on older Erlang releases.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v4.0.x/release-notes).

### Core Broker

#### Bug Fixes

 * Classic queue message store did not remove segment files with large messages (over 4 MB) in some cases.

   GitHub issue: [#13430](https://github.com/rabbitmq/rabbitmq-server/pull/13430)

 * A node with Khepri enabled would fail to start if its metadata store contained an exclusive queue
   with at least one binding.

   GitHub issues: [#13352](https://github.com/rabbitmq/rabbitmq-server/issues/13352), [#13394](https://github.com/rabbitmq/rabbitmq-server/pull/13394)

#### Enhancements

 * Reduced memory usage and GC pressure for workloads where large (4 MB or greater) messages were published to classic queues.

   Contributed by @gomoripeti.

   GitHub issue: [#13375](https://github.com/rabbitmq/rabbitmq-server/pull/13375)


### CLI Tools

#### Deprecations

 * `rabbitmq-streams set_stream_retention_policy` is now a no-op.

   It was a leftover from the early days of streams. The modern and optimal way of configuring
   stream retention is [via a policy](https://www.rabbitmq.com/docs/streams#retention).

   GitHub issue: [#13358](https://github.com/rabbitmq/rabbitmq-server/pull/13358)


### Prometheus Plugin

#### Enhancements

 * New labels make it possible to differentiate between the metrics with the same name scraped from the aggregated
   metric endpoint and the [per-object metric endpoint](https://www.rabbitmq.com/docs/prometheus#metric-aggregation).

   GitHub issue: [#13239](https://github.com/rabbitmq/rabbitmq-server/pull/13239)


### Management Plugin

#### Bug Fixes

 * Who help tooltips were not updated for 4.0.x.

   GitHub issue: [#13357](https://github.com/rabbitmq/rabbitmq-server/pull/13357)

#### Enhancements

 * Consumer count is a new column that can be enabled for the channels table on the tab of the same name.

   Contributed by @gomoripeti.

   GitHub issue: [#13258](https://github.com/rabbitmq/rabbitmq-server/pull/13258)


### Caching Authentication and Authorization Backend Plugin

#### Enhancements

 * `rabbitmqctl clear_auth_backend_cache` is a new command that clears the [cache maintained by the plugin](https://www.rabbitmq.com/docs/auth-cache-backend).


### Dependency Changes

 * `ra` was upgraded to [`2.15.2`](https://github.com/rabbitmq/ra/releases)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-4.0.7.tar.xz`
instead of the source tarball produced by GitHub.
