RabbitMQ `3.9.14` is a maintenance release in the `3.9.x` release series.

Please refer to the **Upgrading to 3.9** section from [v3.9.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.9.0) if upgrading from a version prior to 3.9.0.

This release requires at least Erlang 23.2, and supports Erlang 24. [RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on Erlang version requirements for RabbitMQ.


## Changes Worth Mentioning

Release notes are kept under [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.9.x/release-notes).
Contributors are encouraged to update them together with their changes. This helps with release automation and a more consistent release schedule.

### Core Server

#### Bug Fixes

 * Restart of a node that hosted one or more stream leaders resulted in
   their consumers not "re-attaching" to the newly elected leader.

   GitHub issue: [#4133](https://github.com/rabbitmq/rabbitmq-server/issues/4133)

 * Large fanouts experienced a performance regression when streams were not
   enabled using a feature flag.

   GitHub issue: [#4086](https://github.com/rabbitmq/rabbitmq-server/pull/4086)

 * Stream management plugin did not support mixed version clusters.

   GitHub issue: [#4082](https://github.com/rabbitmq/rabbitmq-server/issues/4082)

 * Stream deletion did not result in a `basic.cancel` being sent to AMQP 0-9-1 consumers.

   GitHub issue: [#4192](https://github.com/rabbitmq/rabbitmq-server/issues/4192)

 * Stream clients did not receive a correct stream unavailability error in some
   cases.

   GitHub issue: [#4117](https://github.com/rabbitmq/rabbitmq-server/pull/4117)

 * It is again possible to clear user tags and update the password in a single operation.

   GitHub issue: [#4126](https://github.com/rabbitmq/rabbitmq-server/pull/4126)

#### Enhancements

 * Forward compatibility with Erlang 25.

   GitHub issue: [#4256](https://github.com/rabbitmq/rabbitmq-server/pull/4256)

 * File handle cache efficiency improvements.

   Contributed by @felixhuettner.

   GitHub issue: [#4324](https://github.com/rabbitmq/rabbitmq-server/pull/4324)

 * Uknown stream properties (e.g. those requested by a node that runs a newer version)
   are now handled gracefully.

   GitHub issue: [#4090](https://github.com/rabbitmq/rabbitmq-server/pull/4090)

 * Temporary hostname resolution issues (attempts that fail with `nxdomain`)
   are now handled more gracefully and with a delay of several seconds.

   GitHub issue: [#4233](https://github.com/rabbitmq/rabbitmq-server/pull/4233)

 * Build time compatibility with Elixir 1.13.

   GitHub issue: [#4019](https://github.com/rabbitmq/rabbitmq-server/issues/4019)


### OAuth 2 AuthN/AuthZ Backend Plugin

#### Bug Fixes

 * `auth_oauth2.additional_scopes_key` in `rabbitmq.conf` was not converted correctly
   during configuration translation and thus had no effect.

   Contributed by @luos.

   GitHub issue: [#4105](https://github.com/rabbitmq/rabbitmq-server/pull/4105)


### LDAP AuthN/AuthZ Backend Plugin

#### Enhancement

 * Adapt to a breaking Erlang 24.3 LDAP client change.

   GitHub issue: [#4287](https://github.com/rabbitmq/rabbitmq-server/pull/4287)


### Shovel Plugin

#### Enhacements

 * Shovels now can be declared with `delete-after` parameter set to `0`.
   Such shovels will immediately stop instead of erroring and failing to
   start after a node restart.

   Contributed by @luos.

   GitHub issue: [#4101](https://github.com/rabbitmq/rabbitmq-server/pull/4101)


### Consul Peer Discovery Plugin

#### Enhancements

 * Support for Consul 1.1 [response code changes](https://github.com/hashicorp/consul/pull/11950)
   when an operation is attempted on a non-existent health check.

   Suggested by @maestroes.

   GitHub issue: [#4155](https://github.com/rabbitmq/rabbitmq-server/pull/4155)



## Dependency Upgrades

 * Ra was [upgraded to `2.0.4`](https://github.com/rabbitmq/ra/compare/v2.0.3...v2.0.4)
 * `gen_batch_server` was [upgraded to `0.8.7`](https://github.com/rabbitmq/gen-batch-server/compare/38191672ee0f22a8d5291c6c09f8c07178d565ca...v0.8.7)

## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.9.14.tar.xz`
instead of the source tarball produced by GitHub.
