RabbitMQ `3.9.1` is a maintenance release in the `3.9.x` release series. [This is what changed since v3.9.0](https://github.com/rabbitmq/rabbitmq-server/compare/v3.9.0...v3.9.1).

Please refer to the **Upgrading to 3.9** section from [v3.9.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.9.0) if you are upgrading from a version prior to 3.9.0.

This release requires at least Erlang 23.2, and supports the latest Erlang 24 version, 24.0.5 at the time of release. [RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on Erlang version requirements for RabbitMQ.



## Changes Worth Mentioning

Release notes are kept under [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.9.x/release-notes).
Contributors are encouraged to update them together with their changes.  This helps with release automation and more
consistent release schedule.

### Core Server

#### Bug Fixes

 * Clients that used global QoS prefetch (deprecated as of 3.9.0) ran into an exception when acknowledging deliveries.

   GitHub issue: [#3230](https://github.com/rabbitmq/rabbitmq-server/pull/3230)

 * Improved resiliency of stream coordinator in certain conditions.

   GitHub issues: [#3176](https://github.com/rabbitmq/rabbitmq-server/pull/3176), [#3170](https://github.com/rabbitmq/rabbitmq-server/pull/3170)

 * Nodes failed to start when hostname contained non-ASCII (broader Unicode) characters.

   GitHub issue: [#3239](https://github.com/rabbitmq/rabbitmq-server/pull/3239)


### CLI Tools

#### Bug Fixes

 * `rabbitmq-diagnostics stream_status` fails with an exception when the `--tracking` option was used.

   GitHub issue: [#3229](https://github.com/rabbitmq/rabbitmq-server/pull/3229)

 * `rabbitmq-diagnostics stream_status` used an outdated documentation guide link.

   GitHub issue: [#3231](https://github.com/rabbitmq/rabbitmq-server/pull/3231)


### RabbitMQ Erlang Client

#### Bug Fixes

 * New releases of the client are again published to Hex.pm.

   GitHub issue: [#3247](https://github.com/rabbitmq/rabbitmq-server/pull/3247)

 * `connection_timeout` was adjusted to avoid a confusing warning.

   GitHub issue: [#3232](https://github.com/rabbitmq/rabbitmq-server/pull/3232) contributed by @britto

 * Corrected a typo in direct connection net tick time adjustment.

   GitHub issue: [#3233](https://github.com/rabbitmq/rabbitmq-server/pull/3233) contributed by @britto


## Dependency Upgrades

No dependency changes in this release.


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.9.1.tar.xz`
instead of the source tarball produced by GitHub.
