## RabbitMQ 3.7.8

RabbitMQ `3.7.8` a maintenance release. It focuses on bug fixes and
further improves [Erlang/OTP 21](http://www.erlang.org/news/123) compatibility.

### Compatibility Notes

This release has no known incompatibilities with earlier `3.7.x` releases.

#### Upgrading to Erlang 21.0

When upgrading to this release **and upgrading Erlang to 21.0** at the same time, extra care has to be taken.
Since CLI tools from RabbitMQ releases older than 3.7.7 will fail on Erlang 21, RabbitMQ **must be upgraded before Erlang**.

#### Documentation Guides and Change Log

See [3.7.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.7.0) upgrade and
compatibility notes if upgrading from an earlier release.

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades and
[RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.


## Changes

### Core Server

#### Bug Fixes

 * Virtual host (specifically binding) recovery has been optimized.

   GitHub issue: [rabbitmq/rabbitmq-server#1650](https://github.com/rabbitmq/rabbitmq-server/pull/1650)

 * A binding removal optimization was reverted because it could result in custom exchange type state not cleaned up
   as plugin authors intended.

   GitHub issue: [rabbitmq/rabbitmq-server#1691](https://github.com/rabbitmq/rabbitmq-server/pull/1691)

 * A queue sync operation now can be cancelled when a resource alarm is in effect on the receiving node.

   GitHub issue: [rabbitmq/rabbitmq-server#1636](https://github.com/rabbitmq/rabbitmq-server/issues/1636)

 * Inter-node communication port (a.k.a. distribution port) unintentionally used an excessively large
   buffer size (1.2 GB instead of 128 MB). Kudos to Chris Friesen for noticing and reporting this.

   GitHub issue: [rabbitmq/rabbitmq-server#1659](https://github.com/rabbitmq/rabbitmq-server/issues/1659)

 * More idempotent binding removal.

   When transactions that removed bindings were rolled back and retried, the code
   that performed the deletion could fail with a misleading assertion failure, `{error, not_found}`.   

   GitHub issue: [rabbitmq/rabbitmq-server#1689](https://github.com/rabbitmq/rabbitmq-server/pull/1689)

 * A resource alarm triggered during boot could prevent node from starting.

   GitHub issue: [rabbitmq/rabbitmq-server#1644](https://github.com/rabbitmq/rabbitmq-server/issues/1644)

 * Environments with high queue or channel churn could run into an exception in local process group.
 
   GitHub issue: [rabbitmq/rabbitmq-server#1699](https://github.com/rabbitmq/rabbitmq-server/issues/1699)

 * Priority queues no longer fail with an exception when used together with other `rabbit_backing_queue`
   behaviour implementations.

   Contributed by Matteo Cafasso.

   GitHub issue: [rabbitmq/rabbitmq-server#1669](https://github.com/rabbitmq/rabbitmq-server/pull/1669)

 * Syslog configuration parameters could be rejected by config validator.

   GitHub issue: [rabbitmq/rabbitmq-server#1639](https://github.com/rabbitmq/rabbitmq-server/issues/1639)

 * `rabbitmq-echopid.bat` now loads `rabbitmq-env.bat` correctly.

   GitHub issue: [rabbitmq/rabbitmq-server#1642](https://github.com/rabbitmq/rabbitmq-server/issues/1642)

#### Enhancements

 * Improved config file validation and loading. For example, `advanced.config` now can be used
   without the main `rabbitmq.conf` config file.

   GitHub issue: [rabbitmq/rabbitmq-server#1671](https://github.com/rabbitmq/rabbitmq-server/pull/1671)

 * On Erlang/OTP 21 Syslog server now can be configured using a hostname (not just an IP address).

   GitHub issue: [rabbitmq/rabbitmq-server#1658](https://github.com/rabbitmq/rabbitmq-server/pull/1658)

 * `rabbitmqctl rename_cluster_node` documentation improvements.

   GitHub issue: [rabbitmq/rabbitmq-server#1641](https://github.com/rabbitmq/rabbitmq-server/pull/1641)


### CLI Tools

#### Bug Fixes

 * Policies were unintentionally excluded from `rabbitmqctl report` output.

   Contributed by Ayanda Dube.

   GitHub issue: [rabbitmq/rabbitmq-cli#256](https://github.com/rabbitmq/rabbitmq-cli/pull/256)

 * Global parameters were unintentionally excluded from `rabbitmqctl report` output.

   GitHub issue: [rabbitmq/rabbitmq-cli#258](https://github.com/rabbitmq/rabbitmq-cli/pull/258)


### Management Plugin

#### Bug Fixes

 * Virtual host imported from definitions or created via HTTP API will explicitly await for the vhost to initialise
   on all cluster nodes. This change was previously scheduled for `3.7.6` but was only partially applied (didn't have any effect on HTTP API clients).

   GitHub issues: [rabbitmq/rabbitmq-management#575](https://github.com/rabbitmq/rabbitmq-management/issues/575), [rabbitmq/rabbitmq-management#591](https://github.com/rabbitmq/rabbitmq-management/pull/591)

 * HTTP API connection endpoints returned a duplicate key, `node`.

   GitHub issue: [rabbitmq/rabbitmq-management#601](https://github.com/rabbitmq/rabbitmq-management/issues/601)

 * Response compression wasn't enabled by default for compatible clients.
 
 * Failed login error message now clears automatically after successful login.
 
   GitHub issue: [rabbitmq/rabbitmq-management#609](https://github.com/rabbitmq/rabbitmq-management/issues/609)

#### Enhancements

 * Cowboy listener settings now can be configured using new style config file.

   GitHub issue: [rabbitmq/rabbitmq-management#596](https://github.com/rabbitmq/rabbitmq-management/issues/596)

 * Cowboy timeouts now can be configured.

   GitHub issues: [rabbitmq/rabbitmq-management#594](https://github.com/rabbitmq/rabbitmq-management/issues/594)

 * `rabbitmqadmin` now supports a new argument, `--request-timeout`.

   GitHub issue: [rabbitmq/rabbitmq-management#593](https://github.com/rabbitmq/rabbitmq-management/issues/593)

 * Switching sections will now scroll to the top of the newly rendered page.

   GitHub issue: [rabbitmq/rabbitmq-management#590](https://github.com/rabbitmq/rabbitmq-management/pull/590)


### Consistent Hashing Exchange Plugin

#### Enhancements

 * Message distribution uniformity has been significantly improved. [Jump Consistent Hash](https://arxiv.org/abs/1406.2294) is now used for
   the hashing function.

  GitHub issue: [rabbitmq/rabbitmq-consistent-hash-exchange#37](https://github.com/rabbitmq/rabbitmq-consistent-hash-exchange/issues/37)


### STOMP Plugin

#### Bug Fixes

 * Nodes experiencing very high connection churn could run out of Erlang processes.

   GitHub issues: [rabbitmq/rabbitmq-stomp#125](https://github.com/rabbitmq/rabbitmq-stomp/pull/125), [rabbitmq/rabbitmq-server#1640](https://github.com/rabbitmq/rabbitmq-server/pull/1640)


### Web STOMP Plugin

#### Enhancements

 * WebSocket endpoint path is now configurable.

   GitHub issue: [rabbitmq/rabbitmq-web-stomp#86](https://github.com/rabbitmq/rabbitmq-web-stomp/issues/86)


### MQTT Plugin

 * Session presence flag was always set to `true` regardless of the state of client connection session.

   GitHub issue: [rabbitmq/rabbitmq-mqtt#163](https://github.com/rabbitmq/rabbitmq-mqtt/issues/163)


### Web MQTT Plugin

#### Enhancements

 * WebSocket endpoint path is now configurable.

   Contributed by Thomas Sauzeau.

   GitHub issue: [rabbitmq/rabbitmq-web-mqtt#30](https://github.com/rabbitmq/rabbitmq-web-mqtt/pull/30)


### Shovel Plugin

#### Bug Fixes

 * The plugin could try to try to forward messages consumed from the source before receiving
   credit from the AMQP 1.0 destination.

   GitHub issue: [rabbitmq/rabbitmq-shovel#44](https://github.com/rabbitmq/rabbitmq-shovel/pull/44)

#### Enhancements

* `sasl=plain` is now added to connection URIs if no other mechanism is specified explicitly
   by the user.

   GitHub issue: [rabbitmq/rabbitmq-amqp1.0-client#10](https://github.com/rabbitmq/rabbitmq-amqp1.0-client/issues/10)

 * TLS version for AMQP 1.0 endpoints now can be configured via a connection URI query parameter.

   GitHub issue: [rabbitmq/rabbitmq-amqp1.0-client#19](https://github.com/rabbitmq/rabbitmq-amqp1.0-client/issues/19)

 * Specifying a port without a hostname in connection URI is now considered
   to be an unsupported combination and will throw an error.

   GitHub issue: [rabbitmq/rabbitmq-erlang-client#107](https://github.com/rabbitmq/rabbitmq-erlang-client/issues/107)


### Federation Plugin

#### Bug Fixes

 * Improved OTP release handling compatibility.

   Contributed by Ayanda Dube.

   GitHub issue: [rabbitmq/rabbitmq-federation#78](https://github.com/rabbitmq/rabbitmq-federation/pull/78)

#### Enhancements

 * Link initialization optimizations.

   Contributed by Ayanda Dube.

   GitHub issues: [rabbitmq/rabbitmq-federation#79](https://github.com/rabbitmq/rabbitmq-federation/pull/79), [rabbitmq/rabbitmq-federation#80](https://github.com/rabbitmq/rabbitmq-federation/pull/80)

 * Specifying a port without a hostname in connection URI is now considered
   to be an unsupported combination and will throw an error.

   GitHub issue: [rabbitmq/rabbitmq-erlang-client#107](https://github.com/rabbitmq/rabbitmq-erlang-client/issues/107)


### Peer Discovery Etcd Plugin

#### Bug Fixes

 * Node name is now correctly extracted from the keys returned by
   etcd even when key prefix includes slashes.

   GitHub issue: [rabbitmq/rabbitmq-peer-discovery-etcd#14](https://github.com/rabbitmq/rabbitmq-peer-discovery-etcd/issues/14)


### Debian Package

#### Bug Fixes

 * Package installation scripts will make sure that the `/etc/rabbitmq` directory is readable.

   GitHub issue: [rabbitmq/rabbitmq-server-release#72](https://github.com/rabbitmq/rabbitmq-server-release/pull/72)


### RPM Package

#### Bug Fixes

 * Package installation scripts will make sure that the `/etc/rabbitmq` directory is readable.

   GitHub issue: [rabbitmq/rabbitmq-server-release#72](https://github.com/rabbitmq/rabbitmq-server-release/pull/72)

 * If `rabbitmq-plugins` is invoked before first server start, Erlang cookie permissions will
   be correctly set to those of the RabbitMQ user and group (currently `rabbitmq`).
   
   GitHub issue: [rabbitmq/rabbitmq-server-release#85](https://github.com/rabbitmq/rabbitmq-server-release/issues/85)


### Event Exchange Plugin

#### Bug Fixes

 * `amq.rabbitmq.event` exchange is now deleted when plugin is disabled.

   GitHub issue: [rabbitmq/rabbitmq-event-exchange#33](https://github.com/rabbitmq/rabbitmq-event-exchange/issues/33)

#### Enhancements

 * The plugin now can be configured using new style config file:

``` ini
rabbitmq_event_exchange.vhost = audit   
```

   GitHub issue: [rabbitmq/rabbitmq-event-exchange#31](https://github.com/rabbitmq/rabbitmq-event-exchange/issues/31)


### Tracing Plugin

#### Enhancements

 * It is now possible to set up a tracer on any cluster node via management UI and HTTP API.

   GitHub issue: [rabbitmq/rabbitmq-tracing#24](https://github.com/rabbitmq/rabbitmq-tracing/pull/24)

 * Tracer connection credentials now can be specified via the management UI and HTTP API.

   GitHub issue: [rabbitmq/rabbitmq-tracing#25](https://github.com/rabbitmq/rabbitmq-tracing/pull/25)


### AMQP 1.0 Erlang Client

#### Enhancements

 * `sasl=plain` is now added to connection URIs if no other mechanism is specified explicitly
   by the user.

   GitHub issue: [rabbitmq/rabbitmq-amqp1.0-client#10](https://github.com/rabbitmq/rabbitmq-amqp1.0-client/issues/10)

 * `hostname` connection parameter will now be set to the value of the `address` parameter for improved
   compatibility with AMQP 1.0 implementations (e.g. Azure ServiceBus) that expect it to be set.

   GitHub issue: [rabbitmq/rabbitmq-amqp1.0-client#1](https://github.com/rabbitmq/rabbitmq-amqp1.0-client/issues/1)

 * TLS version now can be configured via a connection URI query parameter.

   GitHub issue: [rabbitmq/rabbitmq-amqp1.0-client#19](https://github.com/rabbitmq/rabbitmq-amqp1.0-client/issues/19)

### AMQP 0-9-1 Erlang Client

#### Enhancements

 * Specifying a port without a hostname in connection URI is now considered
   to be an unsupported combination and will throw an error.

   GitHub issue: [rabbitmq/rabbitmq-erlang-client#107](https://github.com/rabbitmq/rabbitmq-erlang-client/issues/107)


## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker,
not the plugins or the client libraries. Please download the archive named `rabbitmq-3.7.8.tar.gz`.
