## RabbitMQ 3.7.11

RabbitMQ `3.7.11` is a maintenance release. It focuses on bug fixes and
minor usability improvements. This is the first release to **require Erlang/OTP 20.3+**.

### Erlang/OTP Compatibility Notes

Per the new Erlang version support policy in effect starting with January 2019,
this release [**drops support for Erlang/OTP 19.3**](https://groups.google.com/d/msg/rabbitmq-users/G4UJ9zbIYHs/qCeyjkjyCQAJ). Make sure a [supported Erlang version](https://www.rabbitmq.com/which-erlang.html) is used before upgrading.

[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains what package repositories and tools can be used to provision latest patch versions of Erlang `20.3.x` and `21.x`.

### Compatibility Notes

 * This release requires Erlang/OTP 20.3 or later.
 * Default CLI command exit code has changed from 70 (`EX_UNAVAILABLE`) to 69 (`EX_SOFTWARE`).
   This does not affect all commands and all error conditions, e.g. argument validation still uses code 64 (`EX_USAGE`)

#### Upgrading to Erlang 21.x

When upgrading to this release **and upgrading Erlang to 21.x** at the same time, extra care has to be taken.
Since CLI tools from RabbitMQ releases older than 3.7.7 will fail on Erlang 21, RabbitMQ **must be upgraded before Erlang**.

#### Documentation Guides and Change Log

See [3.7.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.7.0) upgrade and
compatibility notes if upgrading from an earlier release.

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades and
[RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.


## Changes

### Core Server

#### Erlang Version Requirement

 * This release **requires Erlang/OTP `20.3.x`** or `21.x`.
 
   GitHub issue: [rabbitmq/rabbitmq-server#1820](https://github.com/rabbitmq/rabbitmq-server/issues/1820)

#### Bug Fixes

 * Number of socket file descriptors used is now correctly incremented.
 
   GitHub issue: [rabbitmq/rabbitmq-management#652](https://github.com/rabbitmq/rabbitmq-management/issues/652)

 * Configuration schema file was not copied during upgrades.
 
   GitHub issues: [rabbitmq/rabbitmq-server#1843](https://github.com/rabbitmq/rabbitmq-server/issues/1843)

 * First heartbeat frame on a successfully negotiated connection is now sent after a half of the negotiated heartbeat
   timeout. Previously it was sent after a complete timeout. Since most connections have other activity after
   connection handshake is complete, this didn't have any visible effects on most systems.
   
   GitHub issue: [rabbitmq/rabbitmq-common#293](https://github.com/rabbitmq/rabbitmq-common/pull/293)

 * If Syslog was configured to use TCP, the node could fail to start.
 
   GitHub issue: [rabbitmq/rabbitmq-server#1850](https://github.com/rabbitmq/rabbitmq-server/issues/1850)

### CLI Tools

#### Enhancements

  * Several new `rabbitmq-diagnostics` commands useful for diagnostics and health checks.
  
    GitHub issues: [rabbitmq/rabbitmq-cli/issues/292](https://github.com/rabbitmq/rabbitmq-cli/issues/292), [rabbitmq/rabbitmq-cli#303](https://github.com/rabbitmq/rabbitmq-cli/pull/303), [rabbitmq/rabbitmq-cli#303](https://github.com/rabbitmq/rabbitmq-cli/pull/303)

  * All CLI tools now can display command-specific help with `[command name] --help`, e.g. `rabbitmqctl set_policy --help`
  
    GitHub issue: [rabbitmq/rabbitmq-cli#306](https://github.com/rabbitmq/rabbitmq-cli/pull/306)


### Management Plugin

#### Enhancements

 * `rabbitmqadmin` now defines an exception not available in Python 2, making TCP connection
    error reporting more similar with that on Python 3.
    
    GitHub issue: [rabbitmq/rabbitmq-management#647](https://github.com/rabbitmq/rabbitmq-management/issues/647)


### AWS Peer Discovery Plugin

#### Bug Fixes

  * When an EC2 API endpoint could not be reached, the plugin terminated in a way that
    brought down the entire node with it.
  
    GitHib issue: [rabbitmq/rabbitmq-peer-discovery-aws#25](https://github.com/rabbitmq/rabbitmq-peer-discovery-aws/issues/25)


### STOMP Plugin

#### Enhancements

 * Avoid using a private socket API function that's likely going away in Erlang 22.
 
   GitHub issue: [rabbitmq/rabbitmq-stomp#128](https://github.com/rabbitmq/rabbitmq-stomp/pull/128)

 * Default topic exchange used by the plugin is now configurable.
 
   GitHub issue: [rabbitmq/rabbitmq-stomp#94](https://github.com/rabbitmq/rabbitmq-stomp/issues/94)


### MQTT Plugin

#### Enhancements

 * Avoid using a private socket API function that's likely going away in Erlang 22.
 
   GitHub issue: [rabbitmq/rabbitmq-mqtt#171](https://github.com/rabbitmq/rabbitmq-mqtt/pull/171)


### AuthN/AuthZ Backend Cache Plugin

#### Bug Fixes

 * The new style config format did not support `auth_cache.cache_refusals`
 
   GitHub issue: [rabbitmq/rabbitmq-auth-backend-cache#17](https://github.com/rabbitmq/rabbitmq-auth-backend-cache/issues/17)

### Erlang Client

#### Enhancements

 * Avoid using a private socket API function that's likely going away in Erlang 22.
 
   GitHub issue: [rabbitmq/rabbitmq-erlang-client#114](https://github.com/rabbitmq/rabbitmq-erlang-client/pull/114)



## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker,
not the plugins or the client libraries. Please download the archive named `rabbitmq-3.7.11.tar.gz`.
