## RabbitMQ 3.6.13

RabbitMQ `3.6.13` is a maintenance release.

### Upgrades and Compatibility

See the ["Upgrading clusters" section of the documentation](https://www.rabbitmq.com/clustering.html#upgrading)
for general documentation on upgrades.

This release has no known incompatibilities with versions 3.6.7 through 3.6.12.
See the upgrade and compatibility sections in the [3.6.7 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/rabbitmq_v3_6_7) if upgrading from an earlier release.

### 3.6.x Series Support Timeline

Please read this node on [RabbitMQ 3.6.x series support timeline](https://groups.google.com/forum/#!msg/rabbitmq-users/kXkI-f3pgEw/UFowJIK4BQAJ).


### Core Server

#### Bug Fixes

 * Memory usage monitor uses subprocesses a lot more sparingly. They are started
   roughly once a second or not started at all, depending on the strategy (e.g. on Windows
   Erlang VM allocator information is used instead).

   GitHub issues: [rabbitmq-server#1343](https://github.com/rabbitmq/rabbitmq-server/issues/1343), [rabbitmq-common#224](https://github.com/rabbitmq/rabbitmq-common/issues/224)

 * Very busy queues are now more efficient at prioritizing consumers, avoiding
   consumer delivery blocking when relatively long running operations (e.g. bulk flushing
   of transient messages to disk) happen.

   GitHub issues: [rabbitmq-server#1388](https://github.com/rabbitmq/rabbitmq-server/pull/1388), [rabbitmq-server#1407](https://github.com/rabbitmq/rabbitmq-server/pull/1407)

 * queue leader strategies now take additional queue HA arguments into account.

   GitHub issue: [rabbitmq-server#1371](https://github.com/rabbitmq/rabbitmq-server/issues/1371)

 * Logging to standard output using `RABBITMQ_LOGS=-` wasn't possible on Windows.

   GitHub issue: [rabbitmq-server#1348](https://github.com/rabbitmq/rabbitmq-server/issues/1348)

 * queue leader locator name now can be specified as Erlang strings.

   GitHub issue: [rabbitmq-server#1411](https://github.com/rabbitmq/rabbitmq-server/issues/1411)

 * Direct Erlang client connections could fail with obscure messages when
   target node was still booting.

   GitHub issue: [rabbitmq-server#1356](https://github.com/rabbitmq/rabbitmq-server/issues/1356)

#### Enhancements

 * `supervisor2` now can be used in environments that perform hot code upgrades.

   GitHub issue: [rabbitmq-common#230](https://github.com/rabbitmq/rabbitmq-common/pull/230)

 * systemd service file now white lists exit code 69.

   GitHub issue: [rabbitmq-server-release#51](https://github.com/rabbitmq/rabbitmq-server-release/issues/51)

 * Example systemd service file now includes service restart settings.

   GitHub issue: [rabbitmq-server#1359](https://github.com/rabbitmq/rabbitmq-server/issues/1359)

 * queue leader locator strategy now can be configured using strings.

   GitHub issue: [rabbitmq-server#1411](https://github.com/rabbitmq/rabbitmq-server/issues/1411)

 * Plugin activation avoids logs things that can be confusing.

   GitHub issue: [rabbitmq-server#1364](https://github.com/rabbitmq/rabbitmq-server/issues/1364)


### Management Plugin

#### Enhancements

 * Minor efficiency improvements around stats collection.

   GitHub issues: [rabbitmq-common#235](https://github.com/rabbitmq/rabbitmq-common/pull/235)

 * jQuery upgraded to 1.12.4.

   GitHub issue: [rabbitmq-management#502](https://github.com/rabbitmq/rabbitmq-management/pull/502)

 * UI improvements.

 * More detailed memory use breakdown on the node page.

   GitHub issue: [rabbitmq-management#500](https://github.com/rabbitmq/rabbitmq-management/pull/500)

 * It is now possible to configure an HTTP API path prefix for the plugin.

   GitHub issue: [rabbitmq-management#481](https://github.com/rabbitmq/rabbitmq-management/issues/481)

 * Queue details page no longer truncates node name.

   GitHub issue: [rabbitmq-management#473](https://github.com/rabbitmq/rabbitmq-management/issues/473)

 * Policy name in queue and exchange info is now a link.

   GitHub issue: [rabbitmq-management#493](https://github.com/rabbitmq/rabbitmq-management/issues/493)

 * `DELETE /api/connections/{name}` is now more defensive.

   GitHub issue: [rabbitmq-management#497](https://github.com/rabbitmq/rabbitmq-management/issues/497)


## Upgrading

To upgrade a non-clustered RabbitMQ simply install the new version. All configuration and persistent message data are retained.
When upgrading using definitions export/import from versions earlier than 3.6.0, see http://rabbitmq.com/passwords.html.

To upgrade a RabbitMQ cluster, follow the instructions [in RabbitMQ documentation](https://www.rabbitmq.com/clustering.html#upgrading).

## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker,
not the plugins or the client libraries. Please download the archive named `rabbitmq-3.6.13.tar.gz`.
