RabbitMQ `3.12.2` is a maintenance release in the `3.12.x` [release series](https://www.rabbitmq.com/versions.html).

Please refer to the upgrade section from the [3.12.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.12.0)
if upgrading from a version prior to 3.12.0.

This release requires Erlang 25 and supports Erlang versions up to `26.0.x`.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

As of 3.12.0, RabbitMQ requires Erlang 25. Nodes **will fail to start** on older Erlang releases.

Users upgrading from 3.11.x (or older releases) on Erlang 25 to 3.12.x on Erlang 26
(both RabbitMQ *and* Erlang are upgraded at the same time) **must** consult
the [v3.12.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.12.0) first.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.12.x/release-notes).

### Core Server

#### Enhancements

 * Free disk space monitor on Windows is now more selective in what errors are
   logged.

   GitHub issue: [#8837](https://github.com/rabbitmq/rabbitmq-server/pull/8837)

#### Bug Fixes

 * Queue recovery on node restart in certain conditions could run into an exception

   GitHub issue: [#8746](https://github.com/rabbitmq/rabbitmq-server/issues/8746)

 * `file_handle_cache` operations are now safer when handling non-existent keys.

   GitHub issue: [#8784](https://github.com/rabbitmq/rabbitmq-server/issues/8784)

 * Fixed a potential resource leak in at-least-once dead lettering from quorum queues.

   GitHub issue: [#8799](https://github.com/rabbitmq/rabbitmq-server/pull/8799)


### CLI Tools

#### Enhancements

 * A new command, `rabbitmqctl deactivate_free_disk_space_monitoring`, can be used to (temporarily or permanently) disable
   free disk space monitoring on a node.

   To re-activate it, use `rabbitmqctl activate_free_disk_space_monitoring`.

   GitHub issue: [#8801](https://github.com/rabbitmq/rabbitmq-server/pull/8801)


### AMQP 1.0 Plugin

#### Bug Fixes

 * AMQP 1.0 clients that try to publish in a way that results in the message not being routed
   anywhere are now notified with a more sensible settlement status.

   GitHub issue: [#7823](https://github.com/rabbitmq/rabbitmq-server/issues/7823)


### Prometheus Plugin

#### Enhancements

 * Prometheus scraping API endpoints now support optional authentication.

   Contributed by @SimonUnge (AWS).

   GitHub issue: [#8661](https://github.com/rabbitmq/rabbitmq-server/pull/8661)

 * The plugin now filters out values that are `undefined` or `NaN`, simply excluding
   them from the API endpoint response.

   Previously, if a metric was not computed for any reason (e.g. free disk space monitor
   was disabled on the node), its value could end up being rendered as `undefined` or `NaN`,
   two values that Prometheus scrapers cannot handle (for numerical types such as gauges).

   GitHub issue: [#8740](https://github.com/rabbitmq/rabbitmq-server/issues/8740)


### Management Plugin

#### Bug Fixes

 * It was not possible to close a table column selection pane on
   screens that had little vertical space.

   Contributed by @Antsthebul.

   GitHub issue: [#8701](https://github.com/rabbitmq/rabbitmq-server/pull/8701)


### STOMP Plugin

#### Bug Fixes

 *  This is a **potentially breaking change**.

    The plugin will now enforce maximum STOMP frame size. Frames larger than that
    size will be rejected. The default maximum size is 4 MiB. It can be increased or decreased:
    ``` ini
    # increase maximum supported STOMP frame size to 10 MiB
    stomp.max_frame_size = 10485760
    ```
    To reduce it from the default 4 MiB to 2 MiB:
    ``` ini
    # 2 MiB
    stomp.max_frame_size = 2097152
    ```

    GitHub issue: [#8802](https://github.com/rabbitmq/rabbitmq-server/pull/8802)


### Shovel Plugin

#### Bug Fixes

 * Shovel will gracefully stop when its destination (target) does not exist.
   Such shovels will then be periodically restarted to retry.

   Contributed by @markus812498 (CloudAMQP).

   GitHub issue: [#8697](https://github.com/rabbitmq/rabbitmq-server/pull/8697)


### Web MQTT Plugin

#### Enhacements

 * It is now possible to opt in to deactivate file handle cache use in the plugin:

   ``` ini
   web_mqtt.use_file_handle_cache = false
   ```

   GitHub issue: [#8790](https://github.com/rabbitmq/rabbitmq-server/pull/8790)


### Web STOMP Plugin

#### Enhacements

 * It is now possible to opt in to deactivate file handle cache use in the plugin:

   ``` ini
   web_stomp.use_file_handle_cache = false
   ```

   GitHub issue: [#8790](https://github.com/rabbitmq/rabbitmq-server/pull/8790)


## Dependency Upgrades

 * `ra` was upgraded to [`2.6.3`](https://github.com/rabbitmq/ra/releases)

## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.12.2.tar.xz`
instead of the source tarball produced by GitHub.
