RabbitMQ `3.12.12` is a maintenance release in the `3.12.x` [release series](https://www.rabbitmq.com/versions.html).

This release [goes out of community support](https://www.rabbitmq.com/release-information) on June 1st, 2024.

Please refer to the upgrade section from the [3.12.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.12.0)
if upgrading from a version prior to 3.12.0.

This release requires Erlang 25 and supports Erlang versions up to `26.2.x`.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

As of 3.12.0, RabbitMQ requires Erlang 25. Nodes **will fail to start** on older Erlang releases.

Users upgrading from 3.11.x (or older releases) on Erlang 25 to 3.12.x on Erlang 26
(both RabbitMQ *and* Erlang are upgraded at the same time) **must** consult
the [v3.12.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.12.0) first.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.12.x/release-notes).


### Core Broker

#### Bug Fixes

 * Environments with a lot of quorum queues could experience a large Erlang process
   build-up. The build-up was temporary but with a sufficiently large number of
   quorum queues it could last until the next round of periodic operations,
   making it permanent and depriving the node of CPU resources.

   GitHub issue: [#10242](https://github.com/rabbitmq/rabbitmq-server/pull/10242)

 * RabbitMQ core failed to propagate more authentication and authorization context, for example,
   MQTT client ID in case of MQTT connections, to authN and authZ backends. This was not intentional.

   GitHub issue: [#10230](https://github.com/rabbitmq/rabbitmq-server/pull/10230)

 * Nodes now takes more precaution about persisting feature flag state
   (specifically the effects of in-flight changes) during node shutdown.

   GitHub issue: [#10279](https://github.com/rabbitmq/rabbitmq-server/pull/10279)

#### Enhancements

 * Simplified some type specs.

   Contributed by @ariel-anieli.

   GitHub issue: [#10228](https://github.com/rabbitmq/rabbitmq-server/pull/10228)


### Stream Plugin

 * One returned error value did not match the [RabbitMQ Stream Protocol](https://github.com/rabbitmq/rabbitmq-server/blob/v3.9.x/deps/rabbitmq_stream/docs/PROTOCOL.adoc) specification.

   GitHub issue: [#10277](https://github.com/rabbitmq/rabbitmq-server/pull/10277)


### MQTT Plugin

#### Bug Fixes

 * Recovering connections from QoS 0 consumers (subscribers) could fail if they were previously connected to a failed node.

   GitHub issue: [#10252](https://github.com/rabbitmq/rabbitmq-server/pull/10252)


### CLI Tools

#### Bug Fixes

 * Since [#10131](https://github.com/rabbitmq/rabbitmq-server/pull/10131) (shipped in `3.12.11`), some CLI commands in certain scenarios could fail to accept input via standard output.

   GitHub issues: [#10270](https://github.com/rabbitmq/rabbitmq-server/pull/10270), [#10258](https://github.com/rabbitmq/rabbitmq-server/pull/10258)


### AWS Peer Discovery Plugin

#### Enhancements

 * Updated some type specs.

   Contributed by @ariel-anieli.

   GitHub issue: [#10226](https://github.com/rabbitmq/rabbitmq-server/pull/10226)


## Dependency Upgrades

None in this release.


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.12.12.tar.xz`
instead of the source tarball produced by GitHub.
