-file("/opt/homebrew/Cellar/erlang/26.2.5/lib/erlang/lib/parsetools-2.5/include/leexinc.hrl", 0).
%% The source of this file is part of leex distribution, as such it
%% has the same Copyright as the other files in the leex
%% distribution. The Copyright is defined in the accompanying file
%% COPYRIGHT. However, the resultant scanner generated by leex is the
%% property of the creator of the scanner and is not covered by that
%% Copyright.

-module(redbug_lexer).

-export([string/1,string/2,token/2,token/3,tokens/2,tokens/3]).
-export([format_error/1]).

%% User code. This is placed here to allow extra attributes.
-file("/Users/masse/git/redbug/src/redbug_lexer.xrl", 98).

%% @hidden

to_atom(Str) ->
    list_to_atom(Str).

char_to_int([$$, C]) ->
    C.

radix_to_int(Str) ->
    case erl_scan:tokens([], Str++". ", 0) of
        {done, {ok, [{integer, _, Int}, {dot, _}], 0}, []} -> Int;
        _ -> throw({error, {0, ?MODULE, "malformed_int: "++Str}, 0})
    end.

int_to_int(Str) ->
    list_to_integer(Str).

to_binary(Str) ->
    try
        {done, {ok, Toks, _}, []} = erl_scan:tokens([], Str++". ", 0),
        {ok, Exprs} = erl_parse:parse_exprs(Toks),
        {value, Val, _} = erl_eval:exprs(Exprs, erl_eval:new_bindings()),
        Val
    catch
        _:_ -> throw({error, {0, ?MODULE, "malformed_binary: "++Str}, 0})
    end.

trim(Str) ->
    lists:reverse(tl(lists:reverse(tl(Str)))).

-file("/opt/homebrew/Cellar/erlang/26.2.5/lib/erlang/lib/parsetools-2.5/include/leexinc.hrl", 14).

format_error({illegal,S}) -> ["illegal characters ",io_lib:write_string(S)];
format_error({user,S}) -> S.

%% string(InChars) ->
%% string(InChars, Loc) ->
%% {ok,Tokens,EndLoc} | {error,ErrorInfo,EndLoc}.
%% Loc is the starting location of the token, while EndLoc is the first not scanned
%% location. Location is either Line or {Line,Column}, depending on the "error_location" option.

string(Ics) -> 
    string(Ics,1).
string(Ics,L0) -> 
    string(Ics, L0, 1, Ics, []).
string(Ics, L0, C0, Tcs, Ts) -> 
    case do_string(Ics, L0, C0, Tcs, Ts) of
        {ok, T, {L,_}} -> {ok, T, L};
        {error, {{EL,_},M,D}, {L,_}} ->
            EI = {EL,M,D},
            {error, EI, L}
    end.

do_string([], L, C, [], Ts) ->                     % No partial tokens!
    {ok,yyrev(Ts),{L,C}};
do_string(Ics0, L0, C0, Tcs, Ts) ->
    case yystate(yystate(), Ics0, L0, C0, 0, reject, 0) of
        {A,Alen,Ics1,L1,_C1} ->                  % Accepting end state
            C2 = adjust_col(Tcs, Alen, C0),
            string_cont(Ics1, L1, C2, yyaction(A, Alen, Tcs, L0, C0), Ts);
        {A,Alen,Ics1,L1,_C1,_S1} ->              % Accepting transition state
            C2 = adjust_col(Tcs, Alen, C0),
            string_cont(Ics1, L1, C2, yyaction(A, Alen, Tcs, L0, C0), Ts);
        {reject,_Alen,Tlen,_Ics1,_L1,_C1,_S1} ->  % After a non-accepting state
            {error,{{L0, C0} ,?MODULE,{illegal,yypre(Tcs, Tlen+1)}},{L0, C0}};
        {A,Alen,Tlen,_Ics1,L1, C1,_S1}->
            Tcs1 = yysuf(Tcs, Alen),
            L2 = adjust_line(Tlen, Alen, Tcs1, L1),
            C2 = adjust_col(Tcs, Alen, C1),
            string_cont(Tcs1, L2, C2, yyaction(A, Alen, Tcs, L0,C0), Ts)
    end.

%% string_cont(RestChars, Line, Col, Token, Tokens)
%% Test for and remove the end token wrapper. Push back characters
%% are prepended to RestChars.

-dialyzer({nowarn_function, string_cont/5}).

string_cont(Rest, Line, Col, {token,T}, Ts) ->
    do_string(Rest, Line, Col, Rest, [T|Ts]);
string_cont(Rest, Line, Col, {token,T,Push}, Ts) ->
    NewRest = Push ++ Rest,
    do_string(NewRest, Line, Col, NewRest, [T|Ts]);
string_cont(Rest, Line, Col, {end_token,T}, Ts) ->
    do_string(Rest, Line, Col, Rest, [T|Ts]);
string_cont(Rest, Line, Col, {end_token,T,Push}, Ts) ->
    NewRest = Push ++ Rest,
    do_string(NewRest, Line, Col, NewRest, [T|Ts]);
string_cont(Rest, Line, Col, skip_token, Ts) ->
    do_string(Rest, Line, Col, Rest, Ts);
string_cont(Rest, Line, Col, {skip_token,Push}, Ts) ->
    NewRest = Push ++ Rest,
    do_string(NewRest, Line, Col, NewRest, Ts);
string_cont(_Rest, Line, Col, {error,S}, _Ts) ->
    {error,{{Line, Col},?MODULE,{user,S}},{Line,Col}}.

%% token(Continuation, Chars) ->
%% token(Continuation, Chars, Loc) ->
%% {more,Continuation} | {done,ReturnVal,RestChars}.
%% Must be careful when re-entering to append the latest characters to the
%% after characters in an accept. The continuation is:
%% {token,State,CurrLine,CurrCol,TokenChars,TokenLen,TokenLine,TokenCol,AccAction,AccLen}

token(Cont,Chars) -> 
    token(Cont,Chars,1).
token(Cont, Chars, Line) -> 
    case do_token(Cont,Chars,Line,1) of
        {more, _} = C -> C;
        {done, Ret0, R} ->
            Ret1 = case Ret0 of
                {ok, T, {L,_}} -> {ok, T, L};
                {eof, {L,_}} -> {eof, L};
                {error, {{EL,_},M,D},{L,_}} -> {error, {EL,M,D},L}
            end,
            {done, Ret1, R}
    end.

do_token([], Chars, Line, Col) ->
    token(yystate(), Chars, Line, Col, Chars, 0, Line, Col, reject, 0);
do_token({token,State,Line,Col,Tcs,Tlen,Tline,Tcol,Action,Alen}, Chars, _, _) ->
    token(State, Chars, Line, Col, Tcs ++ Chars, Tlen, Tline, Tcol, Action, Alen).

%% token(State, InChars, Line, Col, TokenChars, TokenLen, TokenLine, TokenCol
%% AcceptAction, AcceptLen) ->
%% {more,Continuation} | {done,ReturnVal,RestChars}.
%% The argument order is chosen to be more efficient.

token(S0, Ics0, L0, C0, Tcs, Tlen0, Tline, Tcol, A0, Alen0) ->
    case yystate(S0, Ics0, L0, C0, Tlen0, A0, Alen0) of
        %% Accepting end state, we have a token.
        {A1,Alen1,Ics1,L1,C1} ->
            C2 = adjust_col(Tcs, Alen1, C1),
            token_cont(Ics1, L1, C2, yyaction(A1, Alen1, Tcs, Tline,Tcol));
        %% Accepting transition state, can take more chars.
        {A1,Alen1,[],L1,C1,S1} ->                  % Need more chars to check
            {more,{token,S1,L1,C1,Tcs,Alen1,Tline,Tcol,A1,Alen1}};
        {A1,Alen1,Ics1,L1,C1,_S1} ->               % Take what we got
            C2 = adjust_col(Tcs, Alen1, C1),
            token_cont(Ics1, L1, C2, yyaction(A1, Alen1, Tcs, Tline,Tcol));
        %% After a non-accepting state, maybe reach accept state later.
        {A1,Alen1,Tlen1,[],L1,C1,S1} ->            % Need more chars to check
            {more,{token,S1,L1,C1,Tcs,Tlen1,Tline,Tcol,A1,Alen1}};
        {reject,_Alen1,Tlen1,eof,L1,C1,_S1} ->     % No token match
            %% Check for partial token which is error.
            Ret = if Tlen1 > 0 -> {error,{{Tline,Tcol},?MODULE,
                                          %% Skip eof tail in Tcs.
                                          {illegal,yypre(Tcs, Tlen1)}},{L1,C1}};
                     true -> {eof,{L1,C1}}
                  end,
            {done,Ret,eof};
        {reject,_Alen1,Tlen1,Ics1,_L1,_C1,_S1} ->    % No token match
            Error = {{Tline,Tcol},?MODULE,{illegal,yypre(Tcs, Tlen1+1)}},
            {done,{error,Error,{Tline,Tcol}},Ics1};
        {A1,Alen1,Tlen1,_Ics1,L1,_C1,_S1} ->       % Use last accept match
            Tcs1 = yysuf(Tcs, Alen1),
            L2 = adjust_line(Tlen1, Alen1, Tcs1, L1),
            C2 = C0 + Alen1,
            token_cont(Tcs1, L2, C2, yyaction(A1, Alen1, Tcs, Tline, Tcol))
    end.

%% token_cont(RestChars, Line, Col, Token)
%% If we have a token or error then return done, else if we have a
%% skip_token then continue.

-dialyzer({nowarn_function, token_cont/4}).

token_cont(Rest, Line, Col, {token,T}) ->
    {done,{ok,T,{Line,Col}},Rest};
token_cont(Rest, Line, Col, {token,T,Push}) ->
    NewRest = Push ++ Rest,
    {done,{ok,T,{Line,Col}},NewRest};
token_cont(Rest, Line, Col, {end_token,T}) ->
    {done,{ok,T,{Line,Col}},Rest};
token_cont(Rest, Line, Col, {end_token,T,Push}) ->
    NewRest = Push ++ Rest,
    {done,{ok,T,{Line,Col}},NewRest};
token_cont(Rest, Line, Col, skip_token) ->
    token(yystate(), Rest, Line, Col, Rest, 0, Line, Col, reject, 0);
token_cont(Rest, Line, Col, {skip_token,Push}) ->
    NewRest = Push ++ Rest,
    token(yystate(), NewRest, Line, Col, NewRest, 0, Line, Col, reject, 0);
token_cont(Rest, Line, Col, {error,S}) ->
    {done,{error,{{Line, Col},?MODULE,{user,S}},{Line, Col}},Rest}.

%% tokens(Continuation, Chars) ->
%% tokens(Continuation, Chars, Loc) ->
%% {more,Continuation} | {done,ReturnVal,RestChars}.
%% Must be careful when re-entering to append the latest characters to the
%% after characters in an accept. The continuation is:
%% {tokens,State,CurrLine,CurrCol,TokenChars,TokenLen,TokenLine,TokenCur,Tokens,AccAction,AccLen}
%% {skip_tokens,State,CurrLine,CurrCol,TokenChars,TokenLen,TokenLine,TokenCur,Error,AccAction,AccLen}

tokens(Cont,Chars) -> 
    tokens(Cont,Chars,1).
tokens(Cont, Chars, Line) -> 
    case do_tokens(Cont,Chars,Line,1) of
        {more, _} = C -> C;
        {done, Ret0, R} ->
            Ret1 = case Ret0 of
                {ok, T, {L,_}} -> {ok, T, L};
                {eof, {L,_}} -> {eof, L};
                {error, {{EL,_},M,D},{L,_}} -> {error, {EL,M,D},L}
            end,
            {done, Ret1, R}
    end.

do_tokens([], Chars, Line, Col) ->
    tokens(yystate(), Chars, Line, Col, Chars, 0, Line, Col, [], reject, 0);
do_tokens({tokens,State,Line,Col,Tcs,Tlen,Tline,Tcol,Ts,Action,Alen}, Chars, _,_) ->
    tokens(State, Chars, Line, Col, Tcs ++ Chars, Tlen, Tline, Tcol, Ts, Action, Alen);
do_tokens({skip_tokens,State,Line, Col, Tcs,Tlen,Tline,Tcol,Error,Action,Alen}, Chars, _,_) ->
    skip_tokens(State, Chars, Line, Col, Tcs ++ Chars, Tlen, Tline, Tcol, Error, Action, Alen).

%% tokens(State, InChars, Line, Col, TokenChars, TokenLen, TokenLine, TokenCol,Tokens,
%% AcceptAction, AcceptLen) ->
%% {more,Continuation} | {done,ReturnVal,RestChars}.

tokens(S0, Ics0, L0, C0, Tcs, Tlen0, Tline, Tcol, Ts, A0, Alen0) ->
    case yystate(S0, Ics0, L0, C0, Tlen0, A0, Alen0) of
        %% Accepting end state, we have a token.
        {A1,Alen1,Ics1,L1,C1} ->
            C2 = adjust_col(Tcs, Alen1, C1),
            tokens_cont(Ics1, L1, C2, yyaction(A1, Alen1, Tcs, Tline, Tcol), Ts);
        %% Accepting transition state, can take more chars.
        {A1,Alen1,[],L1,C1,S1} ->                  % Need more chars to check
            {more,{tokens,S1,L1,C1,Tcs,Alen1,Tline,Tcol,Ts,A1,Alen1}};
        {A1,Alen1,Ics1,L1,C1,_S1} ->               % Take what we got
            C2 = adjust_col(Tcs, Alen1, C1),
            tokens_cont(Ics1, L1, C2, yyaction(A1, Alen1, Tcs, Tline,Tcol), Ts);
        %% After a non-accepting state, maybe reach accept state later.
        {A1,Alen1,Tlen1,[],L1,C1,S1} ->            % Need more chars to check
            {more,{tokens,S1,L1,C1,Tcs,Tlen1,Tline,Tcol,Ts,A1,Alen1}};
        {reject,_Alen1,Tlen1,eof,L1,C1,_S1} ->     % No token match
            %% Check for partial token which is error, no need to skip here.
            Ret = if Tlen1 > 0 -> {error,{{Tline,Tcol},?MODULE,
                                          %% Skip eof tail in Tcs.
                                          {illegal,yypre(Tcs, Tlen1)}},{L1,C1}};
                     Ts == [] -> {eof,{L1,C1}};
                     true -> {ok,yyrev(Ts),{L1,C1}}
                  end,
            {done,Ret,eof};
        {reject,_Alen1,Tlen1,_Ics1,L1,C1,_S1} ->
            %% Skip rest of tokens.
            Error = {{L1,C1},?MODULE,{illegal,yypre(Tcs, Tlen1+1)}},
            skip_tokens(yysuf(Tcs, Tlen1+1), L1, C1, Error);
        {A1,Alen1,Tlen1,_Ics1,L1,_C1,_S1} ->
            Token = yyaction(A1, Alen1, Tcs, Tline,Tcol),
            Tcs1 = yysuf(Tcs, Alen1),
            L2 = adjust_line(Tlen1, Alen1, Tcs1, L1),
            C2 = C0 + Alen1,
            tokens_cont(Tcs1, L2, C2, Token, Ts)
    end.

%% tokens_cont(RestChars, Line, Column, Token, Tokens)
%% If we have an end_token or error then return done, else if we have
%% a token then save it and continue, else if we have a skip_token
%% just continue.

-dialyzer({nowarn_function, tokens_cont/5}).

tokens_cont(Rest, Line, Col, {token,T}, Ts) ->
    tokens(yystate(), Rest, Line, Col, Rest, 0, Line, Col, [T|Ts], reject, 0);
tokens_cont(Rest, Line, Col, {token,T,Push}, Ts) ->
    NewRest = Push ++ Rest,
    tokens(yystate(), NewRest, Line, Col, NewRest, 0, Line, Col, [T|Ts], reject, 0);
tokens_cont(Rest, Line, Col, {end_token,T}, Ts) ->
    {done,{ok,yyrev(Ts, [T]),{Line,Col}},Rest};
tokens_cont(Rest, Line, Col, {end_token,T,Push}, Ts) ->
    NewRest = Push ++ Rest,
    {done,{ok,yyrev(Ts, [T]),{Line, Col}},NewRest};
tokens_cont(Rest, Line, Col, skip_token, Ts) ->
    tokens(yystate(), Rest, Line, Col, Rest, 0, Line, Col, Ts, reject, 0);
tokens_cont(Rest, Line, Col, {skip_token,Push}, Ts) ->
    NewRest = Push ++ Rest,
    tokens(yystate(), NewRest, Line, Col, NewRest, 0, Line, Col, Ts, reject, 0);
tokens_cont(Rest, Line, Col, {error,S}, _Ts) ->
    skip_tokens(Rest, Line, Col, {{Line,Col},?MODULE,{user,S}}).

%% skip_tokens(InChars, Line, Col, Error) -> {done,{error,Error,{Line,Col}},Ics}.
%% Skip tokens until an end token, junk everything and return the error.

skip_tokens(Ics, Line, Col, Error) ->
    skip_tokens(yystate(), Ics, Line, Col, Ics, 0, Line, Col, Error, reject, 0).

%% skip_tokens(State, InChars, Line, Col, TokenChars, TokenLen, TokenLine, TokenCol, Tokens,
%% AcceptAction, AcceptLen) ->
%% {more,Continuation} | {done,ReturnVal,RestChars}.

skip_tokens(S0, Ics0, L0, C0, Tcs, Tlen0, Tline, Tcol, Error, A0, Alen0) ->
    case yystate(S0, Ics0, L0, C0, Tlen0, A0, Alen0) of
        {A1,Alen1,Ics1,L1, C1} ->                  % Accepting end state
            skip_cont(Ics1, L1, C1, yyaction(A1, Alen1, Tcs, Tline, Tcol), Error);
        {A1,Alen1,[],L1,C1, S1} ->                 % After an accepting state
            {more,{skip_tokens,S1,L1,C1,Tcs,Alen1,Tline,Tcol,Error,A1,Alen1}};
        {A1,Alen1,Ics1,L1,C1,_S1} ->
            skip_cont(Ics1, L1, C1, yyaction(A1, Alen1, Tcs, Tline, Tcol), Error);
        {A1,Alen1,Tlen1,[],L1,C1,S1} ->           % After a non-accepting state
            {more,{skip_tokens,S1,L1,C1,Tcs,Tlen1,Tline,Tcol,Error,A1,Alen1}};
        {reject,_Alen1,_Tlen1,eof,L1,C1,_S1} ->
            {done,{error,Error,{L1,C1}},eof};
        {reject,_Alen1,Tlen1,_Ics1,L1,C1,_S1} ->
            skip_tokens(yysuf(Tcs, Tlen1+1), L1, C1,Error);
        {A1,Alen1,Tlen1,_Ics1,L1,C1,_S1} ->
            Token = yyaction(A1, Alen1, Tcs, Tline, Tcol),
            Tcs1 = yysuf(Tcs, Alen1),
            L2 = adjust_line(Tlen1, Alen1, Tcs1, L1),
            skip_cont(Tcs1, L2, C1, Token, Error)
    end.

%% skip_cont(RestChars, Line, Col, Token, Error)
%% Skip tokens until we have an end_token or error then return done
%% with the original rror.

-dialyzer({nowarn_function, skip_cont/5}).

skip_cont(Rest, Line, Col, {token,_T}, Error) ->
    skip_tokens(yystate(), Rest, Line, Col, Rest, 0, Line, Col, Error, reject, 0);
skip_cont(Rest, Line, Col, {token,_T,Push}, Error) ->
    NewRest = Push ++ Rest,
    skip_tokens(yystate(), NewRest, Line, Col, NewRest, 0, Line, Col, Error, reject, 0);
skip_cont(Rest, Line, Col, {end_token,_T}, Error) ->
    {done,{error,Error,{Line,Col}},Rest};
skip_cont(Rest, Line, Col, {end_token,_T,Push}, Error) ->
    NewRest = Push ++ Rest,
    {done,{error,Error,{Line,Col}},NewRest};
skip_cont(Rest, Line, Col, skip_token, Error) ->
    skip_tokens(yystate(), Rest, Line, Col, Rest, 0, Line, Col, Error, reject, 0);
skip_cont(Rest, Line, Col, {skip_token,Push}, Error) ->
    NewRest = Push ++ Rest,
    skip_tokens(yystate(), NewRest, Line, Col, NewRest, 0, Line, Col, Error, reject, 0);
skip_cont(Rest, Line, Col, {error,_S}, Error) ->
    skip_tokens(yystate(), Rest, Line, Col, Rest, 0, Line, Col, Error, reject, 0).

-compile({nowarn_unused_function, [yyrev/1, yyrev/2, yypre/2, yysuf/2]}).

yyrev(List) -> lists:reverse(List).
yyrev(List, Tail) -> lists:reverse(List, Tail).
yypre(List, N) -> lists:sublist(List, N).
yysuf(List, N) -> lists:nthtail(N, List).

%% adjust_line(TokenLength, AcceptLength, Chars, Line) -> NewLine
%% Make sure that newlines in Chars are not counted twice.
%% Line has been updated with respect to newlines in the prefix of
%% Chars consisting of (TokenLength - AcceptLength) characters.

-compile({nowarn_unused_function, adjust_line/4}).

adjust_line(N, N, _Cs, L) -> L;
adjust_line(T, A, [$\n|Cs], L) ->
    adjust_line(T-1, A, Cs, L-1);
adjust_line(T, A, [_|Cs], L) ->
    adjust_line(T-1, A, Cs, L).

%% adjust_col(Chars, AcceptLength, Col) -> NewCol
%% Handle newlines, tabs and unicode chars.
adjust_col(_, 0, Col) ->
    Col;
adjust_col([$\n | R], L, _) ->
    adjust_col(R, L-1, 1);
adjust_col([$\t | R], L, Col) ->
    adjust_col(R, L-1, tab_forward(Col)+1);
adjust_col([C | R], L, Col) when C>=0 andalso C=< 16#7F ->
    adjust_col(R, L-1, Col+1);
adjust_col([C | R], L, Col) when C>= 16#80 andalso C=< 16#7FF ->
    adjust_col(R, L-1, Col+2);
adjust_col([C | R], L, Col) when C>= 16#800 andalso C=< 16#FFFF ->
    adjust_col(R, L-1, Col+3);
adjust_col([C | R], L, Col) when C>= 16#10000 andalso C=< 16#10FFFF ->
    adjust_col(R, L-1, Col+4).

tab_forward(C) ->
    D = C rem tab_size(),
    A = tab_size()-D,
    C+A.

tab_size() -> 8.

%% yystate() -> InitialState.
%% yystate(State, InChars, Line, Col, CurrTokLen, AcceptAction, AcceptLen) ->
%% {Action, AcceptLen, RestChars, Line, Col} |
%% {Action, AcceptLen, RestChars, Line, Col, State} |
%% {reject, AcceptLen, CurrTokLen, RestChars, Line, Col, State} |
%% {Action, AcceptLen, CurrTokLen, RestChars, Line, Col, State}.
%% Generated state transition functions. The non-accepting end state
%% return signal either an unrecognised character or end of current
%% input.

-file("/Users/masse/git/redbug/src/redbug_lexer.erl", 369).
yystate() -> 163.

yystate(178, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(164, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(178, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,178};
yystate(177, [112|Ics], Line, Col, Tlen, _, _) ->
    yystate(165, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(177, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(177, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(177, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(177, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 111 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(177, [C|Ics], Line, Col, Tlen, _, _) when C >= 113, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(177, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,177};
yystate(176, [100|Ics], Line, Col, Tlen, _, _) ->
    yystate(166, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(176, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(176, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(176, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(176, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 99 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(176, [C|Ics], Line, Col, Tlen, _, _) when C >= 101, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(176, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,176};
yystate(175, [116|Ics], Line, Col, Tlen, _, _) ->
    yystate(167, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(175, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(175, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(175, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(175, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 115 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(175, [C|Ics], Line, Col, Tlen, _, _) when C >= 117, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(175, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,175};
yystate(174, [97|Ics], Line, Col, Tlen, _, _) ->
    yystate(168, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(174, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(174, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(174, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(174, [C|Ics], Line, Col, Tlen, _, _) when C >= 98, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(174, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,174};
yystate(173, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(169, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(173, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,173};
yystate(172, [111|Ics], Line, Col, Tlen, _, _) ->
    yystate(170, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(172, [101|Ics], Line, Col, Tlen, _, _) ->
    yystate(134, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(172, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(172, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(172, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(172, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 100 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(172, [C|Ics], Line, Col, Tlen, _, _) when C >= 102, C =< 110 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(172, [C|Ics], Line, Col, Tlen, _, _) when C >= 112, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(172, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,172};
yystate(171, [10|Ics], Line, _, Tlen, _, _) ->
    yystate(171, Ics, Line+1, 1, Tlen+1, 0, Tlen);
yystate(171, [C|Ics], Line, Col, Tlen, _, _) when C >= 0, C =< 9 ->
    yystate(171, Ics, Line, Col, Tlen+1, 0, Tlen);
yystate(171, [C|Ics], Line, Col, Tlen, _, _) when C >= 11, C =< 32 ->
    yystate(171, Ics, Line, Col, Tlen+1, 0, Tlen);
yystate(171, Ics, Line, Col, Tlen, _, _) ->
    {0,Tlen,Ics,Line,Col,171};
yystate(170, [117|Ics], Line, Col, Tlen, _, _) ->
    yystate(154, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(170, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(170, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(170, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(170, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 116 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(170, [C|Ics], Line, Col, Tlen, _, _) when C >= 118, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(170, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,170};
yystate(169, [62|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(153, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(169, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(169, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(169, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,169};
yystate(168, [112|Ics], Line, Col, Tlen, _, _) ->
    yystate(141, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(168, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(168, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(168, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(168, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 111 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(168, [C|Ics], Line, Col, Tlen, _, _) when C >= 113, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(168, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,168};
yystate(167, [111|Ics], Line, Col, Tlen, _, _) ->
    yystate(151, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(167, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(167, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(167, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(167, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 110 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(167, [C|Ics], Line, Col, Tlen, _, _) when C >= 112, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(167, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,167};
yystate(166, [97|Ics], Line, Col, Tlen, _, _) ->
    yystate(158, Ics, Line, Col, Tlen+1, 13, Tlen);
yystate(166, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 13, Tlen);
yystate(166, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 13, Tlen);
yystate(166, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 13, Tlen);
yystate(166, [C|Ics], Line, Col, Tlen, _, _) when C >= 98, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 13, Tlen);
yystate(166, Ics, Line, Col, Tlen, _, _) ->
    {13,Tlen,Ics,Line,Col,166};
yystate(165, [108|Ics], Line, Col, Tlen, _, _) ->
    yystate(21, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(165, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(165, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(165, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(165, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 107 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(165, [C|Ics], Line, Col, Tlen, _, _) when C >= 109, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(165, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,165};
yystate(164, [46|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(148, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(164, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(164, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(164, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,164};
yystate(163, [125|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(147, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [124|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(147, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [123|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(147, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [121|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(83, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [122|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(83, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [120|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(131, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [119|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(67, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [117|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(83, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [118|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(83, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [116|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(3, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [115|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(76, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [114|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(172, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [112|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(83, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [113|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(83, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [111|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(102, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [110|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(22, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [109|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(83, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [108|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(33, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [106|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(83, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [107|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(83, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [105|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(113, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [104|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(135, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [102|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(83, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [103|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(83, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [101|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(119, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [100|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(7, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [99|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(83, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [98|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(24, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [97|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(160, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [95|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(98, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [93|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(147, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [91|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(147, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [62|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(74, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [61|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(58, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [60|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(18, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [59|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(147, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [58|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(137, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [51|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(89, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [50|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(73, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [49|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(41, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [48|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(25, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [47|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(17, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [45|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(14, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [44|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(147, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [43|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(30, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [42|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(46, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [41|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(147, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [40|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(147, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [39|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(78, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [36|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(94, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [35|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(126, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [34|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(155, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [10|Ics], Line, _, Tlen, Action, Alen) ->
    yystate(171, Ics, Line+1, 1, Tlen+1, Action, Alen);
yystate(163, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 0, C =< 9 ->
    yystate(171, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 11, C =< 32 ->
    yystate(171, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 52, C =< 57 ->
    yystate(57, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(163, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,163};
yystate(162, [60|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(178, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(162, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,162};
yystate(161, [117|Ics], Line, Col, Tlen, _, _) ->
    yystate(177, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(161, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(161, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(161, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(161, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 116 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(161, [C|Ics], Line, Col, Tlen, _, _) when C >= 118, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(161, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,161};
yystate(160, [110|Ics], Line, Col, Tlen, _, _) ->
    yystate(176, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(160, [98|Ics], Line, Col, Tlen, _, _) ->
    yystate(114, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(160, [97|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(160, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(160, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(160, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(160, [C|Ics], Line, Col, Tlen, _, _) when C >= 99, C =< 109 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(160, [C|Ics], Line, Col, Tlen, _, _) when C >= 111, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(160, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,160};
yystate(159, [122|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(159, [121|Ics], Line, Col, Tlen, _, _) ->
    yystate(141, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(159, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(159, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(159, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(159, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 120 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(159, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,159};
yystate(158, [108|Ics], Line, Col, Tlen, _, _) ->
    yystate(146, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(158, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(158, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(158, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(158, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 107 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(158, [C|Ics], Line, Col, Tlen, _, _) when C >= 109, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(158, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,158};
yystate(157, [46|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(173, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(157, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(157, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(157, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,157};
yystate(156, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 7, Tlen);
yystate(156, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 7, Tlen);
yystate(156, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 7, Tlen);
yystate(156, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 7, Tlen);
yystate(156, Ics, Line, Col, Tlen, _, _) ->
    {7,Tlen,Ics,Line,Col,156};
yystate(155, [92|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(107, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(155, [34|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(139, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(155, [10|Ics], Line, _, Tlen, Action, Alen) ->
    yystate(155, Ics, Line+1, 1, Tlen+1, Action, Alen);
yystate(155, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 0, C =< 9 ->
    yystate(155, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(155, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 11, C =< 33 ->
    yystate(155, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(155, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 35, C =< 91 ->
    yystate(155, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(155, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 93 ->
    yystate(155, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(155, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,155};
yystate(154, [110|Ics], Line, Col, Tlen, _, _) ->
    yystate(135, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(154, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(154, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(154, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(154, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 109 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(154, [C|Ics], Line, Col, Tlen, _, _) when C >= 111, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(154, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,154};
yystate(153, Ics, Line, Col, Tlen, _, _) ->
    {1,Tlen,Ics,Line,Col};
yystate(152, [105|Ics], Line, Col, Tlen, _, _) ->
    yystate(136, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(152, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(152, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(152, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(152, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 104 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(152, [C|Ics], Line, Col, Tlen, _, _) when C >= 106, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(152, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,152};
yystate(151, [109|Ics], Line, Col, Tlen, _, _) ->
    yystate(141, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(151, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(151, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(151, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(151, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 108 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(151, [C|Ics], Line, Col, Tlen, _, _) when C >= 110, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(151, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,151};
yystate(150, [102|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(162, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(150, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,150};
yystate(149, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(157, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(149, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,149};
yystate(148, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(132, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(148, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,148};
yystate(147, Ics, Line, Col, Tlen, _, _) ->
    {4,Tlen,Ics,Line,Col};
yystate(146, [115|Ics], Line, Col, Tlen, _, _) ->
    yystate(130, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(146, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(146, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(146, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(146, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 114 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(146, [C|Ics], Line, Col, Tlen, _, _) when C >= 116, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(146, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,146};
yystate(145, [116|Ics], Line, Col, Tlen, _, _) ->
    yystate(161, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(145, [115|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(145, [114|Ics], Line, Col, Tlen, _, _) ->
    yystate(125, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(145, [113|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(145, [112|Ics], Line, Col, Tlen, _, _) ->
    yystate(50, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(145, [111|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(145, [110|Ics], Line, Col, Tlen, _, _) ->
    yystate(106, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(145, [109|Ics], Line, Col, Tlen, _, _) ->
    yystate(174, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(145, [108|Ics], Line, Col, Tlen, _, _) ->
    yystate(152, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(145, [106|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(145, [107|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(145, [105|Ics], Line, Col, Tlen, _, _) ->
    yystate(104, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(145, [103|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(145, [104|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(145, [102|Ics], Line, Col, Tlen, _, _) ->
    yystate(16, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(145, [98|Ics], Line, Col, Tlen, _, _) ->
    yystate(95, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(145, [97|Ics], Line, Col, Tlen, _, _) ->
    yystate(175, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(145, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(145, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(145, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(145, [C|Ics], Line, Col, Tlen, _, _) when C >= 99, C =< 101 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(145, [C|Ics], Line, Col, Tlen, _, _) when C >= 117, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(145, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,145};
yystate(144, [100|Ics], Line, Col, Tlen, _, _) ->
    yystate(118, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(144, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(144, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(144, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(144, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 99 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(144, [C|Ics], Line, Col, Tlen, _, _) when C >= 101, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(144, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,144};
yystate(143, [114|Ics], Line, Col, Tlen, _, _) ->
    yystate(159, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(143, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(143, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(143, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(143, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 113 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(143, [C|Ics], Line, Col, Tlen, _, _) when C >= 115, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(143, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,143};
yystate(142, [101|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(150, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(142, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,142};
yystate(141, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 5, Tlen);
yystate(141, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 5, Tlen);
yystate(141, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 5, Tlen);
yystate(141, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 5, Tlen);
yystate(141, Ics, Line, Col, Tlen, _, _) ->
    {5,Tlen,Ics,Line,Col,141};
yystate(140, [102|Ics], Line, Col, Tlen, _, _) ->
    yystate(156, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(140, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(140, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(140, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(140, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 101 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(140, [C|Ics], Line, Col, Tlen, _, _) when C >= 103, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(140, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,140};
yystate(139, Ics, Line, Col, Tlen, _, _) ->
    {19,Tlen,Ics,Line,Col};
yystate(138, [98|Ics], Line, Col, Tlen, _, _) ->
    yystate(48, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(138, [97|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(138, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(138, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(138, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(138, [C|Ics], Line, Col, Tlen, _, _) when C >= 99, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(138, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,138};
yystate(137, [61|Ics], Line, Col, Tlen, _, _) ->
    yystate(147, Ics, Line, Col, Tlen+1, 4, Tlen);
yystate(137, Ics, Line, Col, Tlen, _, _) ->
    {4,Tlen,Ics,Line,Col,137};
yystate(136, [115|Ics], Line, Col, Tlen, _, _) ->
    yystate(120, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(136, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(136, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(136, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(136, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 114 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(136, [C|Ics], Line, Col, Tlen, _, _) when C >= 116, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(136, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,136};
yystate(135, [100|Ics], Line, Col, Tlen, _, _) ->
    yystate(60, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(135, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(135, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(135, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(135, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 99 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(135, [C|Ics], Line, Col, Tlen, _, _) when C >= 101, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(135, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,135};
yystate(134, [109|Ics], Line, Col, Tlen, _, _) ->
    yystate(118, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(134, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(134, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(134, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(134, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 108 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(134, [C|Ics], Line, Col, Tlen, _, _) when C >= 110, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(134, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,134};
yystate(133, [46|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(149, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(133, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(133, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(133, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,133};
yystate(132, [46|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(116, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(132, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(132, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(132, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,132};
yystate(131, [111|Ics], Line, Col, Tlen, _, _) ->
    yystate(115, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(131, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(131, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(131, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(131, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 110 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(131, [C|Ics], Line, Col, Tlen, _, _) when C >= 112, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(131, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,131};
yystate(130, [111|Ics], Line, Col, Tlen, _, _) ->
    yystate(99, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(130, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(130, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(130, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(130, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 110 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(130, [C|Ics], Line, Col, Tlen, _, _) when C >= 112, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(130, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,130};
yystate(129, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(145, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(129, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(129, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(129, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(129, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,129};
yystate(128, [110|Ics], Line, Col, Tlen, _, _) ->
    yystate(144, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(128, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(128, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(128, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(128, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 109 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(128, [C|Ics], Line, Col, Tlen, _, _) when C >= 111, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(128, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,128};
yystate(127, [97|Ics], Line, Col, Tlen, _, _) ->
    yystate(143, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(127, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(127, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(127, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(127, [C|Ics], Line, Col, Tlen, _, _) when C >= 98, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(127, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,127};
yystate(126, [123|Ics], Line, Col, Tlen, _, _) ->
    yystate(147, Ics, Line, Col, Tlen+1, 4, Tlen);
yystate(126, [82|Ics], Line, Col, Tlen, _, _) ->
    yystate(142, Ics, Line, Col, Tlen+1, 4, Tlen);
yystate(126, [80|Ics], Line, Col, Tlen, _, _) ->
    yystate(36, Ics, Line, Col, Tlen+1, 4, Tlen);
yystate(126, Ics, Line, Col, Tlen, _, _) ->
    {4,Tlen,Ics,Line,Col,126};
yystate(125, [101|Ics], Line, Col, Tlen, _, _) ->
    yystate(109, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(125, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(125, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(125, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(125, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 100 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(125, [C|Ics], Line, Col, Tlen, _, _) when C >= 102, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(125, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,125};
yystate(124, [108|Ics], Line, Col, Tlen, _, _) ->
    yystate(140, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(124, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(124, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(124, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(124, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 107 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(124, [C|Ics], Line, Col, Tlen, _, _) when C >= 109, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(124, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,124};
yystate(123, [92|Ics], Line, Col, Tlen, _, _) ->
    yystate(107, Ics, Line, Col, Tlen+1, 19, Tlen);
yystate(123, [34|Ics], Line, Col, Tlen, _, _) ->
    yystate(139, Ics, Line, Col, Tlen+1, 19, Tlen);
yystate(123, [10|Ics], Line, _, Tlen, _, _) ->
    yystate(155, Ics, Line+1, 1, Tlen+1, 19, Tlen);
yystate(123, [C|Ics], Line, Col, Tlen, _, _) when C >= 0, C =< 9 ->
    yystate(155, Ics, Line, Col, Tlen+1, 19, Tlen);
yystate(123, [C|Ics], Line, Col, Tlen, _, _) when C >= 11, C =< 33 ->
    yystate(155, Ics, Line, Col, Tlen+1, 19, Tlen);
yystate(123, [C|Ics], Line, Col, Tlen, _, _) when C >= 35, C =< 91 ->
    yystate(155, Ics, Line, Col, Tlen+1, 19, Tlen);
yystate(123, [C|Ics], Line, Col, Tlen, _, _) when C >= 93 ->
    yystate(155, Ics, Line, Col, Tlen+1, 19, Tlen);
yystate(123, Ics, Line, Col, Tlen, _, _) ->
    {19,Tlen,Ics,Line,Col,123};
yystate(122, [109|Ics], Line, Col, Tlen, _, _) ->
    yystate(138, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(122, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(122, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(122, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(122, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 108 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(122, [C|Ics], Line, Col, Tlen, _, _) when C >= 110, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(122, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,122};
yystate(121, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(105, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(121, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,121};
yystate(120, [116|Ics], Line, Col, Tlen, _, _) ->
    yystate(141, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(120, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(120, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(120, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(120, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 115 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(120, [C|Ics], Line, Col, Tlen, _, _) when C >= 117, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(120, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,120};
yystate(119, [108|Ics], Line, Col, Tlen, _, _) ->
    yystate(103, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(119, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(119, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(119, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(119, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 107 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(119, [C|Ics], Line, Col, Tlen, _, _) when C >= 109, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(119, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,119};
yystate(118, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 11, Tlen);
yystate(118, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 11, Tlen);
yystate(118, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 11, Tlen);
yystate(118, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 11, Tlen);
yystate(118, Ics, Line, Col, Tlen, _, _) ->
    {11,Tlen,Ics,Line,Col,118};
yystate(117, [62|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(2, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(117, [34|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(29, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(117, [10|Ics], Line, _, Tlen, Action, Alen) ->
    yystate(117, Ics, Line+1, 1, Tlen+1, Action, Alen);
yystate(117, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 0, C =< 9 ->
    yystate(117, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(117, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 11, C =< 33 ->
    yystate(117, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(117, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 35, C =< 61 ->
    yystate(117, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(117, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 63 ->
    yystate(117, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(117, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,117};
yystate(116, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(100, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(116, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,116};
yystate(115, [114|Ics], Line, Col, Tlen, _, _) ->
    yystate(99, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(115, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(115, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(115, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(115, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 113 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(115, [C|Ics], Line, Col, Tlen, _, _) when C >= 115, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(115, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,115};
yystate(114, [115|Ics], Line, Col, Tlen, _, _) ->
    yystate(60, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(114, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(114, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(114, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(114, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 114 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(114, [C|Ics], Line, Col, Tlen, _, _) when C >= 116, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(114, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,114};
yystate(113, [115|Ics], Line, Col, Tlen, _, _) ->
    yystate(129, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(113, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(113, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(113, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(113, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 114 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(113, [C|Ics], Line, Col, Tlen, _, _) when C >= 116, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(113, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,113};
yystate(112, [116|Ics], Line, Col, Tlen, _, _) ->
    yystate(118, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(112, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(112, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(112, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(112, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 115 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(112, [C|Ics], Line, Col, Tlen, _, _) when C >= 117, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(112, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,112};
yystate(111, [110|Ics], Line, Col, Tlen, _, _) ->
    yystate(127, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(111, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(111, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(111, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(111, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 109 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(111, [C|Ics], Line, Col, Tlen, _, _) when C >= 111, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(111, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,111};
yystate(110, Ics, Line, Col, Tlen, _, _) ->
    {14,Tlen,Ics,Line,Col};
yystate(109, [102|Ics], Line, Col, Tlen, _, _) ->
    yystate(101, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(109, [100|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(109, [101|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(109, [99|Ics], Line, Col, Tlen, _, _) ->
    yystate(5, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(109, [97|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(109, [98|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(109, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(109, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(109, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(109, [C|Ics], Line, Col, Tlen, _, _) when C >= 103, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(109, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,109};
yystate(108, [101|Ics], Line, Col, Tlen, _, _) ->
    yystate(60, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(108, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(108, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(108, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(108, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 100 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(108, [C|Ics], Line, Col, Tlen, _, _) when C >= 102, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(108, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,108};
yystate(107, [92|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(107, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(107, [34|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(123, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(107, [10|Ics], Line, _, Tlen, Action, Alen) ->
    yystate(155, Ics, Line+1, 1, Tlen+1, Action, Alen);
yystate(107, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 0, C =< 9 ->
    yystate(155, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(107, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 11, C =< 33 ->
    yystate(155, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(107, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 35, C =< 91 ->
    yystate(155, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(107, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 93 ->
    yystate(155, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(107, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,107};
yystate(106, [117|Ics], Line, Col, Tlen, _, _) ->
    yystate(122, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(106, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(106, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(106, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(106, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 116 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(106, [C|Ics], Line, Col, Tlen, _, _) when C >= 118, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(106, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,106};
yystate(105, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(105, Ics, Line, Col, Tlen+1, 15, Tlen);
yystate(105, Ics, Line, Col, Tlen, _, _) ->
    {15,Tlen,Ics,Line,Col,105};
yystate(104, [110|Ics], Line, Col, Tlen, _, _) ->
    yystate(88, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(104, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(104, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(104, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(104, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 109 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(104, [C|Ics], Line, Col, Tlen, _, _) when C >= 111, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(104, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,104};
yystate(103, [101|Ics], Line, Col, Tlen, _, _) ->
    yystate(87, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(103, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(103, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(103, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(103, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 100 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(103, [C|Ics], Line, Col, Tlen, _, _) when C >= 102, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(103, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,103};
yystate(102, [114|Ics], Line, Col, Tlen, _, _) ->
    yystate(86, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(102, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(102, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(102, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(102, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 113 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(102, [C|Ics], Line, Col, Tlen, _, _) when C >= 115, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(102, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,102};
yystate(101, [101|Ics], Line, Col, Tlen, _, _) ->
    yystate(85, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(101, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(101, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(101, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(101, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 100 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(101, [C|Ics], Line, Col, Tlen, _, _) when C >= 102, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(101, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,101};
yystate(100, [46|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(84, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(100, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(100, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(100, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,100};
yystate(99, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 13, Tlen);
yystate(99, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 13, Tlen);
yystate(99, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 13, Tlen);
yystate(99, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 13, Tlen);
yystate(99, Ics, Line, Col, Tlen, _, _) ->
    {13,Tlen,Ics,Line,Col,99};
yystate(98, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(82, Ics, Line, Col, Tlen+1, 17, Tlen);
yystate(98, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Col, Tlen+1, 17, Tlen);
yystate(98, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Col, Tlen+1, 17, Tlen);
yystate(98, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 122 ->
    yystate(82, Ics, Line, Col, Tlen+1, 17, Tlen);
yystate(98, Ics, Line, Col, Tlen, _, _) ->
    {17,Tlen,Ics,Line,Col,98};
yystate(97, [104|Ics], Line, Col, Tlen, _, _) ->
    yystate(60, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(97, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(97, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(97, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(97, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 103 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(97, [C|Ics], Line, Col, Tlen, _, _) when C >= 105, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(97, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,97};
yystate(96, [111|Ics], Line, Col, Tlen, _, _) ->
    yystate(112, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(96, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(96, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(96, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(96, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 110 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(96, [C|Ics], Line, Col, Tlen, _, _) when C >= 112, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(96, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,96};
yystate(95, [105|Ics], Line, Col, Tlen, _, _) ->
    yystate(111, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(95, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(95, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(95, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(95, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 104 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(95, [C|Ics], Line, Col, Tlen, _, _) when C >= 106, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(95, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,95};
yystate(94, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 32, C =< 126 ->
    yystate(110, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(94, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,94};
yystate(93, [92|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(61, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(93, [34|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(117, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(93, [10|Ics], Line, _, Tlen, Action, Alen) ->
    yystate(93, Ics, Line+1, 1, Tlen+1, Action, Alen);
yystate(93, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 0, C =< 9 ->
    yystate(93, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(93, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 11, C =< 33 ->
    yystate(93, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(93, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 35, C =< 91 ->
    yystate(93, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(93, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 93 ->
    yystate(93, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(93, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,93};
yystate(92, [122|Ics], Line, Col, Tlen, _, _) ->
    yystate(108, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(92, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(92, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(92, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(92, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 121 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(92, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,92};
yystate(91, Ics, Line, Col, Tlen, _, _) ->
    {3,Tlen,Ics,Line,Col};
yystate(90, [100|Ics], Line, Col, Tlen, _, _) ->
    yystate(141, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(90, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(90, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(90, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(90, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 99 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(90, [C|Ics], Line, Col, Tlen, _, _) when C >= 101, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(90, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,90};
yystate(89, [35|Ics], Line, Col, Tlen, _, _) ->
    yystate(121, Ics, Line, Col, Tlen+1, 16, Tlen);
yystate(89, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 54 ->
    yystate(57, Ics, Line, Col, Tlen+1, 16, Tlen);
yystate(89, [C|Ics], Line, Col, Tlen, _, _) when C >= 55, C =< 57 ->
    yystate(25, Ics, Line, Col, Tlen+1, 16, Tlen);
yystate(89, Ics, Line, Col, Tlen, _, _) ->
    {16,Tlen,Ics,Line,Col,89};
yystate(88, [116|Ics], Line, Col, Tlen, _, _) ->
    yystate(80, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(88, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(88, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(88, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(88, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 115 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(88, [C|Ics], Line, Col, Tlen, _, _) when C >= 117, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(88, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,88};
yystate(87, [109|Ics], Line, Col, Tlen, _, _) ->
    yystate(71, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(87, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(87, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(87, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(87, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 108 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(87, [C|Ics], Line, Col, Tlen, _, _) when C >= 110, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(87, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,87};
yystate(86, [101|Ics], Line, Col, Tlen, _, _) ->
    yystate(70, Ics, Line, Col, Tlen+1, 13, Tlen);
yystate(86, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 13, Tlen);
yystate(86, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 13, Tlen);
yystate(86, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 13, Tlen);
yystate(86, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 100 ->
    yystate(83, Ics, Line, Col, Tlen+1, 13, Tlen);
yystate(86, [C|Ics], Line, Col, Tlen, _, _) when C >= 102, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 13, Tlen);
yystate(86, Ics, Line, Col, Tlen, _, _) ->
    {13,Tlen,Ics,Line,Col,86};
yystate(85, [114|Ics], Line, Col, Tlen, _, _) ->
    yystate(69, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(85, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(85, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(85, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(85, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 113 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(85, [C|Ics], Line, Col, Tlen, _, _) when C >= 115, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(85, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,85};
yystate(84, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(68, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(84, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,84};
yystate(83, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(83, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(83, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(83, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(83, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,83};
yystate(82, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(82, Ics, Line, Col, Tlen+1, 18, Tlen);
yystate(82, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Col, Tlen+1, 18, Tlen);
yystate(82, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Col, Tlen+1, 18, Tlen);
yystate(82, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 122 ->
    yystate(82, Ics, Line, Col, Tlen+1, 18, Tlen);
yystate(82, Ics, Line, Col, Tlen, _, _) ->
    {18,Tlen,Ics,Line,Col,82};
yystate(81, [116|Ics], Line, Col, Tlen, _, _) ->
    yystate(97, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(81, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(81, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(81, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(81, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 115 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(81, [C|Ics], Line, Col, Tlen, _, _) when C >= 117, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(81, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,81};
yystate(80, [101|Ics], Line, Col, Tlen, _, _) ->
    yystate(64, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(80, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(80, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(80, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(80, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 100 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(80, [C|Ics], Line, Col, Tlen, _, _) when C >= 102, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(80, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,80};
yystate(79, [110|Ics], Line, Col, Tlen, _, _) ->
    yystate(141, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(79, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(79, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(79, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(79, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 109 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(79, [C|Ics], Line, Col, Tlen, _, _) when C >= 111, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(79, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,79};
yystate(78, [39|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(62, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(78, [10|Ics], Line, _, Tlen, Action, Alen) ->
    yystate(78, Ics, Line+1, 1, Tlen+1, Action, Alen);
yystate(78, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 0, C =< 9 ->
    yystate(78, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(78, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 11, C =< 38 ->
    yystate(78, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(78, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 40, C =< 91 ->
    yystate(78, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(78, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 93, C =< 123 ->
    yystate(78, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(78, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 125 ->
    yystate(78, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(78, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,78};
yystate(77, [92|Ics], Line, Col, Tlen, _, _) ->
    yystate(61, Ics, Line, Col, Tlen+1, 22, Tlen);
yystate(77, [34|Ics], Line, Col, Tlen, _, _) ->
    yystate(117, Ics, Line, Col, Tlen+1, 22, Tlen);
yystate(77, [10|Ics], Line, _, Tlen, _, _) ->
    yystate(93, Ics, Line+1, 1, Tlen+1, 22, Tlen);
yystate(77, [C|Ics], Line, Col, Tlen, _, _) when C >= 0, C =< 9 ->
    yystate(93, Ics, Line, Col, Tlen+1, 22, Tlen);
yystate(77, [C|Ics], Line, Col, Tlen, _, _) when C >= 11, C =< 33 ->
    yystate(93, Ics, Line, Col, Tlen+1, 22, Tlen);
yystate(77, [C|Ics], Line, Col, Tlen, _, _) when C >= 35, C =< 91 ->
    yystate(93, Ics, Line, Col, Tlen+1, 22, Tlen);
yystate(77, [C|Ics], Line, Col, Tlen, _, _) when C >= 93 ->
    yystate(93, Ics, Line, Col, Tlen+1, 22, Tlen);
yystate(77, Ics, Line, Col, Tlen, _, _) ->
    {22,Tlen,Ics,Line,Col,77};
yystate(76, [105|Ics], Line, Col, Tlen, _, _) ->
    yystate(92, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(76, [101|Ics], Line, Col, Tlen, _, _) ->
    yystate(124, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(76, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(76, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(76, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(76, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 100 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(76, [C|Ics], Line, Col, Tlen, _, _) when C >= 102, C =< 104 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(76, [C|Ics], Line, Col, Tlen, _, _) when C >= 106, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(76, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,76};
yystate(75, [62|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(91, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(75, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(75, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(75, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,75};
yystate(74, [61|Ics], Line, Col, Tlen, _, _) ->
    yystate(1, Ics, Line, Col, Tlen+1, 10, Tlen);
yystate(74, Ics, Line, Col, Tlen, _, _) ->
    {10,Tlen,Ics,Line,Col,74};
yystate(73, [35|Ics], Line, Col, Tlen, _, _) ->
    yystate(121, Ics, Line, Col, Tlen+1, 16, Tlen);
yystate(73, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(57, Ics, Line, Col, Tlen+1, 16, Tlen);
yystate(73, Ics, Line, Col, Tlen, _, _) ->
    {16,Tlen,Ics,Line,Col,73};
yystate(72, [114|Ics], Line, Col, Tlen, _, _) ->
    yystate(118, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(72, [108|Ics], Line, Col, Tlen, _, _) ->
    yystate(118, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(72, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(72, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(72, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(72, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 107 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(72, [C|Ics], Line, Col, Tlen, _, _) when C >= 109, C =< 113 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(72, [C|Ics], Line, Col, Tlen, _, _) when C >= 115, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(72, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,72};
yystate(71, [101|Ics], Line, Col, Tlen, _, _) ->
    yystate(55, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(71, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(71, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(71, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(71, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 100 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(71, [C|Ics], Line, Col, Tlen, _, _) when C >= 102, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(71, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,71};
yystate(70, [108|Ics], Line, Col, Tlen, _, _) ->
    yystate(54, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(70, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(70, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(70, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(70, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 107 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(70, [C|Ics], Line, Col, Tlen, _, _) when C >= 109, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(70, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,70};
yystate(69, [101|Ics], Line, Col, Tlen, _, _) ->
    yystate(53, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(69, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(69, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(69, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(69, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 100 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(69, [C|Ics], Line, Col, Tlen, _, _) when C >= 102, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(69, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,69};
yystate(68, [62|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(52, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(68, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(68, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(68, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,68};
yystate(67, [104|Ics], Line, Col, Tlen, _, _) ->
    yystate(51, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(67, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(67, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(67, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(67, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 103 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(67, [C|Ics], Line, Col, Tlen, _, _) when C >= 105, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(67, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,67};
yystate(66, [114|Ics], Line, Col, Tlen, _, _) ->
    yystate(120, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(66, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(66, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(66, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(66, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 113 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(66, [C|Ics], Line, Col, Tlen, _, _) when C >= 115, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(66, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,66};
yystate(65, [103|Ics], Line, Col, Tlen, _, _) ->
    yystate(81, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(65, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(65, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(65, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(65, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 102 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(65, [C|Ics], Line, Col, Tlen, _, _) when C >= 104, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(65, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,65};
yystate(64, [103|Ics], Line, Col, Tlen, _, _) ->
    yystate(48, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(64, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(64, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(64, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(64, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 102 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(64, [C|Ics], Line, Col, Tlen, _, _) when C >= 104, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(64, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,64};
yystate(63, [111|Ics], Line, Col, Tlen, _, _) ->
    yystate(79, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(63, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(63, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(63, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(63, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 110 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(63, [C|Ics], Line, Col, Tlen, _, _) when C >= 112, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(63, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,63};
yystate(62, Ics, Line, Col, Tlen, _, _) ->
    {21,Tlen,Ics,Line,Col};
yystate(61, [92|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(61, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(61, [34|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(29, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(61, [10|Ics], Line, _, Tlen, Action, Alen) ->
    yystate(93, Ics, Line+1, 1, Tlen+1, Action, Alen);
yystate(61, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 0, C =< 9 ->
    yystate(93, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(61, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 11, C =< 33 ->
    yystate(93, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(61, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 35, C =< 91 ->
    yystate(93, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(61, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 93 ->
    yystate(93, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(61, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,61};
yystate(60, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 8, Tlen);
yystate(60, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 8, Tlen);
yystate(60, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 8, Tlen);
yystate(60, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 8, Tlen);
yystate(60, Ics, Line, Col, Tlen, _, _) ->
    {8,Tlen,Ics,Line,Col,60};
yystate(59, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(75, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(59, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,59};
yystate(58, [62|Ics], Line, Col, Tlen, _, _) ->
    yystate(147, Ics, Line, Col, Tlen+1, 4, Tlen);
yystate(58, [61|Ics], Line, Col, Tlen, _, _) ->
    yystate(1, Ics, Line, Col, Tlen+1, 4, Tlen);
yystate(58, [60|Ics], Line, Col, Tlen, _, _) ->
    yystate(1, Ics, Line, Col, Tlen+1, 4, Tlen);
yystate(58, [58|Ics], Line, Col, Tlen, _, _) ->
    yystate(42, Ics, Line, Col, Tlen+1, 4, Tlen);
yystate(58, [47|Ics], Line, Col, Tlen, _, _) ->
    yystate(42, Ics, Line, Col, Tlen+1, 4, Tlen);
yystate(58, Ics, Line, Col, Tlen, _, _) ->
    {4,Tlen,Ics,Line,Col,58};
yystate(57, [35|Ics], Line, Col, Tlen, _, _) ->
    yystate(121, Ics, Line, Col, Tlen+1, 16, Tlen);
yystate(57, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(25, Ics, Line, Col, Tlen+1, 16, Tlen);
yystate(57, Ics, Line, Col, Tlen, _, _) ->
    {16,Tlen,Ics,Line,Col,57};
yystate(56, [114|Ics], Line, Col, Tlen, _, _) ->
    yystate(118, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(56, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(56, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(56, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(56, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 113 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(56, [C|Ics], Line, Col, Tlen, _, _) when C >= 115, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(56, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,56};
yystate(55, [110|Ics], Line, Col, Tlen, _, _) ->
    yystate(39, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(55, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(55, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(55, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(55, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 109 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(55, [C|Ics], Line, Col, Tlen, _, _) when C >= 111, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(55, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,55};
yystate(54, [115|Ics], Line, Col, Tlen, _, _) ->
    yystate(38, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(54, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(54, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(54, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(54, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 114 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(54, [C|Ics], Line, Col, Tlen, _, _) when C >= 116, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(54, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,54};
yystate(53, [110|Ics], Line, Col, Tlen, _, _) ->
    yystate(37, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(53, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(53, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(53, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(53, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 109 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(53, [C|Ics], Line, Col, Tlen, _, _) when C >= 111, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(53, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,53};
yystate(52, Ics, Line, Col, Tlen, _, _) ->
    {2,Tlen,Ics,Line,Col};
yystate(51, [101|Ics], Line, Col, Tlen, _, _) ->
    yystate(35, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(51, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(51, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(51, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(51, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 100 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(51, [C|Ics], Line, Col, Tlen, _, _) when C >= 102, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(51, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,51};
yystate(50, [111|Ics], Line, Col, Tlen, _, _) ->
    yystate(66, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(50, [105|Ics], Line, Col, Tlen, _, _) ->
    yystate(90, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(50, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(50, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(50, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(50, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 104 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(50, [C|Ics], Line, Col, Tlen, _, _) when C >= 106, C =< 110 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(50, [C|Ics], Line, Col, Tlen, _, _) when C >= 112, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(50, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,50};
yystate(49, [110|Ics], Line, Col, Tlen, _, _) ->
    yystate(65, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(49, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(49, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(49, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(49, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 109 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(49, [C|Ics], Line, Col, Tlen, _, _) when C >= 111, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(49, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,49};
yystate(48, [101|Ics], Line, Col, Tlen, _, _) ->
    yystate(32, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(48, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(48, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(48, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(48, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 100 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(48, [C|Ics], Line, Col, Tlen, _, _) when C >= 102, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(48, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,48};
yystate(47, [105|Ics], Line, Col, Tlen, _, _) ->
    yystate(63, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(47, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(47, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(47, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(47, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 104 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(47, [C|Ics], Line, Col, Tlen, _, _) when C >= 106, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(47, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,47};
yystate(46, Ics, Line, Col, Tlen, _, _) ->
    {11,Tlen,Ics,Line,Col};
yystate(45, [92|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(61, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(45, [62|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(77, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(45, [34|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(117, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(45, [10|Ics], Line, _, Tlen, Action, Alen) ->
    yystate(93, Ics, Line+1, 1, Tlen+1, Action, Alen);
yystate(45, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 0, C =< 9 ->
    yystate(93, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(45, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 11, C =< 33 ->
    yystate(93, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(45, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 35, C =< 61 ->
    yystate(93, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(45, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 63, C =< 91 ->
    yystate(93, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(45, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 93 ->
    yystate(93, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(45, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,45};
yystate(44, [99|Ics], Line, Col, Tlen, _, _) ->
    yystate(60, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(44, [97|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(44, [98|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(44, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(44, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(44, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(44, [C|Ics], Line, Col, Tlen, _, _) when C >= 100, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(44, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,44};
yystate(43, [46|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(59, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(43, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(43, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(43, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,43};
yystate(42, [61|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(1, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(42, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,42};
yystate(41, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(57, Ics, Line, Col, Tlen+1, 16, Tlen);
yystate(41, Ics, Line, Col, Tlen, _, _) ->
    {16,Tlen,Ics,Line,Col,41};
yystate(40, [111|Ics], Line, Col, Tlen, _, _) ->
    yystate(56, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(40, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(40, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(40, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(40, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 110 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(40, [C|Ics], Line, Col, Tlen, _, _) when C >= 112, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(40, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,40};
yystate(39, [116|Ics], Line, Col, Tlen, _, _) ->
    yystate(23, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(39, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(39, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(39, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(39, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 115 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(39, [C|Ics], Line, Col, Tlen, _, _) when C >= 117, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(39, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,39};
yystate(38, [101|Ics], Line, Col, Tlen, _, _) ->
    yystate(99, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(38, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(38, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(38, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(38, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 100 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(38, [C|Ics], Line, Col, Tlen, _, _) when C >= 102, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(38, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,38};
yystate(37, [99|Ics], Line, Col, Tlen, _, _) ->
    yystate(21, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(37, [97|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(37, [98|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(37, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(37, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(37, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(37, [C|Ics], Line, Col, Tlen, _, _) when C >= 100, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(37, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,37};
yystate(36, [111|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(20, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(36, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,36};
yystate(35, [110|Ics], Line, Col, Tlen, _, _) ->
    yystate(19, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(35, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(35, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(35, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(35, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 109 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(35, [C|Ics], Line, Col, Tlen, _, _) when C >= 111, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(35, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,35};
yystate(34, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 6, Tlen);
yystate(34, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 6, Tlen);
yystate(34, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 6, Tlen);
yystate(34, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 6, Tlen);
yystate(34, Ics, Line, Col, Tlen, _, _) ->
    {6,Tlen,Ics,Line,Col,34};
yystate(33, [101|Ics], Line, Col, Tlen, _, _) ->
    yystate(49, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(33, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(33, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(33, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(33, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 100 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(33, [C|Ics], Line, Col, Tlen, _, _) when C >= 102, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(33, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,33};
yystate(32, [114|Ics], Line, Col, Tlen, _, _) ->
    yystate(141, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(32, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(32, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(32, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(32, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 113 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(32, [C|Ics], Line, Col, Tlen, _, _) when C >= 115, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(32, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,32};
yystate(31, [116|Ics], Line, Col, Tlen, _, _) ->
    yystate(47, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(31, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(31, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(31, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(31, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 115 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(31, [C|Ics], Line, Col, Tlen, _, _) when C >= 117, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(31, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,31};
yystate(30, [43|Ics], Line, Col, Tlen, _, _) ->
    yystate(147, Ics, Line, Col, Tlen+1, 11, Tlen);
yystate(30, Ics, Line, Col, Tlen, _, _) ->
    {11,Tlen,Ics,Line,Col,30};
yystate(29, [92|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(29, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(29, [62|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(45, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(29, [34|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(29, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(29, [10|Ics], Line, _, Tlen, Action, Alen) ->
    yystate(29, Ics, Line+1, 1, Tlen+1, Action, Alen);
yystate(29, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 0, C =< 9 ->
    yystate(29, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(29, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 11, C =< 33 ->
    yystate(29, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(29, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 35, C =< 61 ->
    yystate(29, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(29, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 63, C =< 91 ->
    yystate(29, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(29, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 93 ->
    yystate(29, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(29, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,29};
yystate(28, [110|Ics], Line, Col, Tlen, _, _) ->
    yystate(44, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(28, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(28, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(28, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(28, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 109 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(28, [C|Ics], Line, Col, Tlen, _, _) when C >= 111, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(28, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,28};
yystate(27, [C|Ics], Line, Col, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(43, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(27, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,27};
yystate(26, [100|Ics], Line, Col, Tlen, _, _) ->
    yystate(34, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(26, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(26, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(26, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(26, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 99 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(26, [C|Ics], Line, Col, Tlen, _, _) when C >= 101, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(26, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,26};
yystate(25, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(25, Ics, Line, Col, Tlen+1, 16, Tlen);
yystate(25, Ics, Line, Col, Tlen, _, _) ->
    {16,Tlen,Ics,Line,Col,25};
yystate(24, [121|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(24, [122|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(24, [120|Ics], Line, Col, Tlen, _, _) ->
    yystate(40, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(24, [115|Ics], Line, Col, Tlen, _, _) ->
    yystate(72, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(24, [111|Ics], Line, Col, Tlen, _, _) ->
    yystate(56, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(24, [110|Ics], Line, Col, Tlen, _, _) ->
    yystate(96, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(24, [97|Ics], Line, Col, Tlen, _, _) ->
    yystate(128, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(24, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(24, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(24, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(24, [C|Ics], Line, Col, Tlen, _, _) when C >= 98, C =< 109 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(24, [C|Ics], Line, Col, Tlen, _, _) when C >= 112, C =< 114 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(24, [C|Ics], Line, Col, Tlen, _, _) when C >= 116, C =< 119 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(24, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,24};
yystate(23, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 9, Tlen);
yystate(23, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 9, Tlen);
yystate(23, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 9, Tlen);
yystate(23, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 9, Tlen);
yystate(23, Ics, Line, Col, Tlen, _, _) ->
    {9,Tlen,Ics,Line,Col,23};
yystate(22, [111|Ics], Line, Col, Tlen, _, _) ->
    yystate(6, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(22, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(22, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(22, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(22, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 110 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(22, [C|Ics], Line, Col, Tlen, _, _) when C >= 112, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(22, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,22};
yystate(21, [101|Ics], Line, Col, Tlen, _, _) ->
    yystate(141, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(21, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(21, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(21, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(21, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 100 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(21, [C|Ics], Line, Col, Tlen, _, _) when C >= 102, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(21, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,21};
yystate(20, [114|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(4, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(20, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,20};
yystate(19, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 4, Tlen);
yystate(19, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 4, Tlen);
yystate(19, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 4, Tlen);
yystate(19, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 4, Tlen);
yystate(19, Ics, Line, Col, Tlen, _, _) ->
    {4,Tlen,Ics,Line,Col,19};
yystate(18, [60|Ics], Line, Col, Tlen, _, _) ->
    yystate(117, Ics, Line, Col, Tlen+1, 10, Tlen);
yystate(18, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(133, Ics, Line, Col, Tlen+1, 10, Tlen);
yystate(18, Ics, Line, Col, Tlen, _, _) ->
    {10,Tlen,Ics,Line,Col,18};
yystate(17, [61|Ics], Line, Col, Tlen, _, _) ->
    yystate(1, Ics, Line, Col, Tlen+1, 4, Tlen);
yystate(17, Ics, Line, Col, Tlen, _, _) ->
    {4,Tlen,Ics,Line,Col,17};
yystate(16, [117|Ics], Line, Col, Tlen, _, _) ->
    yystate(0, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(16, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(16, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(16, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(16, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 116 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(16, [C|Ics], Line, Col, Tlen, _, _) when C >= 118, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(16, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,16};
yystate(15, [99|Ics], Line, Col, Tlen, _, _) ->
    yystate(31, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(15, [97|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(15, [98|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(15, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(15, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(15, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(15, [C|Ics], Line, Col, Tlen, _, _) when C >= 100, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(15, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,15};
yystate(14, [62|Ics], Line, Col, Tlen, _, _) ->
    yystate(147, Ics, Line, Col, Tlen+1, 11, Tlen);
yystate(14, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(25, Ics, Line, Col, Tlen+1, 11, Tlen);
yystate(14, Ics, Line, Col, Tlen, _, _) ->
    {11,Tlen,Ics,Line,Col,14};
yystate(13, Ics, Line, Col, Tlen, _, _) ->
    {22,Tlen,Ics,Line,Col};
yystate(12, [117|Ics], Line, Col, Tlen, _, _) ->
    yystate(28, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(12, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(12, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(12, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(12, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 116 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(12, [C|Ics], Line, Col, Tlen, _, _) when C >= 118, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(12, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,12};
yystate(11, [60|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(27, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(11, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,11};
yystate(10, [114|Ics], Line, Col, Tlen, _, _) ->
    yystate(26, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(10, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(10, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(10, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(10, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 113 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(10, [C|Ics], Line, Col, Tlen, _, _) when C >= 115, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(10, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,10};
yystate(9, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 12, Tlen);
yystate(9, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 12, Tlen);
yystate(9, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 12, Tlen);
yystate(9, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 12, Tlen);
yystate(9, Ics, Line, Col, Tlen, _, _) ->
    {12,Tlen,Ics,Line,Col,9};
yystate(8, [118|Ics], Line, Col, Tlen, _, _) ->
    yystate(118, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(8, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(8, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(8, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(8, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 117 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(8, [C|Ics], Line, Col, Tlen, _, _) when C >= 119, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(8, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,8};
yystate(7, [105|Ics], Line, Col, Tlen, _, _) ->
    yystate(8, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(7, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(7, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(7, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(7, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 104 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(7, [C|Ics], Line, Col, Tlen, _, _) when C >= 106, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(7, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,7};
yystate(6, [116|Ics], Line, Col, Tlen, _, _) ->
    yystate(9, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(6, [100|Ics], Line, Col, Tlen, _, _) ->
    yystate(108, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(6, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(6, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(6, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(6, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 99 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(6, [C|Ics], Line, Col, Tlen, _, _) when C >= 101, C =< 115 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(6, [C|Ics], Line, Col, Tlen, _, _) when C >= 117, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(6, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,6};
yystate(5, [111|Ics], Line, Col, Tlen, _, _) ->
    yystate(10, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(5, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(5, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(5, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(5, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 110 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(5, [C|Ics], Line, Col, Tlen, _, _) when C >= 112, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(5, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,5};
yystate(4, [116|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(11, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(4, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,4};
yystate(3, [114|Ics], Line, Col, Tlen, _, _) ->
    yystate(12, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(3, [108|Ics], Line, Col, Tlen, _, _) ->
    yystate(60, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(3, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(3, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(3, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(3, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 107 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(3, [C|Ics], Line, Col, Tlen, _, _) when C >= 109, C =< 113 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(3, [C|Ics], Line, Col, Tlen, _, _) when C >= 115, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(3, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,3};
yystate(2, [62|Ics], Line, Col, Tlen, Action, Alen) ->
    yystate(13, Ics, Line, Col, Tlen+1, Action, Alen);
yystate(2, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,2};
yystate(1, Ics, Line, Col, Tlen, _, _) ->
    {10,Tlen,Ics,Line,Col};
yystate(0, [110|Ics], Line, Col, Tlen, _, _) ->
    yystate(15, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(0, [95|Ics], Line, Col, Tlen, _, _) ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(0, [C|Ics], Line, Col, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(0, [C|Ics], Line, Col, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(0, [C|Ics], Line, Col, Tlen, _, _) when C >= 97, C =< 109 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(0, [C|Ics], Line, Col, Tlen, _, _) when C >= 111, C =< 122 ->
    yystate(83, Ics, Line, Col, Tlen+1, 20, Tlen);
yystate(0, Ics, Line, Col, Tlen, _, _) ->
    {20,Tlen,Ics,Line,Col,0};
yystate(S, Ics, Line, Col, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,Col,S}.

%% yyaction(Action, TokenLength, TokenChars, TokenLine, TokenCol) ->
%% {token,Token} | {end_token, Token} | skip_token | {error,String}.
%% Generated action function.

yyaction(0, _, _, _, _) ->
    yyaction_0();
yyaction(1, TokenLen, YYtcs, TokenLine, _) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_1(TokenChars, TokenLine);
yyaction(2, TokenLen, YYtcs, TokenLine, _) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_2(TokenChars, TokenLine);
yyaction(3, TokenLen, YYtcs, TokenLine, _) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_3(TokenChars, TokenLine);
yyaction(4, TokenLen, YYtcs, TokenLine, _) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_4(TokenChars, TokenLine);
yyaction(5, TokenLen, YYtcs, TokenLine, _) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_5(TokenChars, TokenLine);
yyaction(6, TokenLen, YYtcs, TokenLine, _) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_6(TokenChars, TokenLine);
yyaction(7, TokenLen, YYtcs, TokenLine, _) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_7(TokenChars, TokenLine);
yyaction(8, TokenLen, YYtcs, TokenLine, _) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_8(TokenChars, TokenLine);
yyaction(9, TokenLen, YYtcs, TokenLine, _) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_9(TokenChars, TokenLine);
yyaction(10, TokenLen, YYtcs, TokenLine, _) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_10(TokenChars, TokenLine);
yyaction(11, TokenLen, YYtcs, TokenLine, _) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_11(TokenChars, TokenLine);
yyaction(12, TokenLen, YYtcs, TokenLine, _) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_12(TokenChars, TokenLine);
yyaction(13, TokenLen, YYtcs, TokenLine, _) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_13(TokenChars, TokenLine);
yyaction(14, TokenLen, YYtcs, TokenLine, _) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_14(TokenChars, TokenLine);
yyaction(15, TokenLen, YYtcs, TokenLine, _) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_15(TokenChars, TokenLine);
yyaction(16, TokenLen, YYtcs, TokenLine, _) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_16(TokenChars, TokenLine);
yyaction(17, _, _, TokenLine, _) ->
    yyaction_17(TokenLine);
yyaction(18, TokenLen, YYtcs, TokenLine, _) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_18(TokenChars, TokenLine);
yyaction(19, TokenLen, YYtcs, TokenLine, _) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_19(TokenChars, TokenLine);
yyaction(20, TokenLen, YYtcs, TokenLine, _) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_20(TokenChars, TokenLine);
yyaction(21, TokenLen, YYtcs, TokenLine, _) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_21(TokenChars, TokenLine);
yyaction(22, TokenLen, YYtcs, TokenLine, _) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_22(TokenChars, TokenLine);
yyaction(_, _, _, _, _) -> error.

-compile({inline,yyaction_0/0}).
-file("/Users/masse/git/redbug/src/redbug_lexer.xrl", 28).
yyaction_0() ->
     skip_token .

-compile({inline,yyaction_1/2}).
-file("/Users/masse/git/redbug/src/redbug_lexer.xrl", 31).
yyaction_1(TokenChars, TokenLine) ->
     { token, { pid, TokenLine, list_to_pid (TokenChars) } } .

-compile({inline,yyaction_2/2}).
-file("/Users/masse/git/redbug/src/redbug_lexer.xrl", 34).
yyaction_2(TokenChars, TokenLine) ->
     { token, { ref, TokenLine, list_to_ref (TokenChars) } } .

-compile({inline,yyaction_3/2}).
-file("/Users/masse/git/redbug/src/redbug_lexer.xrl", 37).
yyaction_3(TokenChars, TokenLine) ->
     { token, { port, TokenLine, list_to_port (TokenChars) } } .

-compile({inline,yyaction_4/2}).
-file("/Users/masse/git/redbug/src/redbug_lexer.xrl", 40).
yyaction_4(TokenChars, TokenLine) ->
     { token, { to_atom (TokenChars), TokenLine } } .

-compile({inline,yyaction_5/2}).
-file("/Users/masse/git/redbug/src/redbug_lexer.xrl", 43).
yyaction_5(TokenChars, TokenLine) ->
     { token, { type_test1, TokenLine, to_atom (TokenChars) } } .

-compile({inline,yyaction_6/2}).
-file("/Users/masse/git/redbug/src/redbug_lexer.xrl", 46).
yyaction_6(TokenChars, TokenLine) ->
     { token, { type_isrec, TokenLine, to_atom (TokenChars) } } .

-compile({inline,yyaction_7/2}).
-file("/Users/masse/git/redbug/src/redbug_lexer.xrl", 49).
yyaction_7(TokenChars, TokenLine) ->
     { token, { bif0, TokenLine, to_atom (TokenChars) } } .

-compile({inline,yyaction_8/2}).
-file("/Users/masse/git/redbug/src/redbug_lexer.xrl", 52).
yyaction_8(TokenChars, TokenLine) ->
     { token, { bif1, TokenLine, to_atom (TokenChars) } } .

-compile({inline,yyaction_9/2}).
-file("/Users/masse/git/redbug/src/redbug_lexer.xrl", 55).
yyaction_9(TokenChars, TokenLine) ->
     { token, { bif2, TokenLine, to_atom (TokenChars) } } .

-compile({inline,yyaction_10/2}).
-file("/Users/masse/git/redbug/src/redbug_lexer.xrl", 58).
yyaction_10(TokenChars, TokenLine) ->
     { token, { comparison_op, TokenLine, to_atom (TokenChars) } } .

-compile({inline,yyaction_11/2}).
-file("/Users/masse/git/redbug/src/redbug_lexer.xrl", 61).
yyaction_11(TokenChars, TokenLine) ->
     { token, { arithmetic_op, TokenLine, to_atom (TokenChars) } } .

-compile({inline,yyaction_12/2}).
-file("/Users/masse/git/redbug/src/redbug_lexer.xrl", 64).
yyaction_12(TokenChars, TokenLine) ->
     { token, { boolean_op1, TokenLine, to_atom (TokenChars) } } .

-compile({inline,yyaction_13/2}).
-file("/Users/masse/git/redbug/src/redbug_lexer.xrl", 67).
yyaction_13(TokenChars, TokenLine) ->
     { token, { boolean_op2, TokenLine, to_atom (TokenChars) } } .

-compile({inline,yyaction_14/2}).
-file("/Users/masse/git/redbug/src/redbug_lexer.xrl", 70).
yyaction_14(TokenChars, TokenLine) ->
     { token, { int, TokenLine, char_to_int (TokenChars) } } .

-compile({inline,yyaction_15/2}).
-file("/Users/masse/git/redbug/src/redbug_lexer.xrl", 73).
yyaction_15(TokenChars, TokenLine) ->
     { token, { int, TokenLine, radix_to_int (TokenChars) } } .

-compile({inline,yyaction_16/2}).
-file("/Users/masse/git/redbug/src/redbug_lexer.xrl", 76).
yyaction_16(TokenChars, TokenLine) ->
     { token, { int, TokenLine, int_to_int (TokenChars) } } .

-compile({inline,yyaction_17/1}).
-file("/Users/masse/git/redbug/src/redbug_lexer.xrl", 79).
yyaction_17(TokenLine) ->
     { token, { wildcard, TokenLine, "_" } } .

-compile({inline,yyaction_18/2}).
-file("/Users/masse/git/redbug/src/redbug_lexer.xrl", 82).
yyaction_18(TokenChars, TokenLine) ->
     { token, { variable, TokenLine, TokenChars } } .

-compile({inline,yyaction_19/2}).
-file("/Users/masse/git/redbug/src/redbug_lexer.xrl", 85).
yyaction_19(TokenChars, TokenLine) ->
     { token, { string, TokenLine, trim (TokenChars) } } .

-compile({inline,yyaction_20/2}).
-file("/Users/masse/git/redbug/src/redbug_lexer.xrl", 88).
yyaction_20(TokenChars, TokenLine) ->
     { token, { atom, TokenLine, to_atom (TokenChars) } } .

-compile({inline,yyaction_21/2}).
-file("/Users/masse/git/redbug/src/redbug_lexer.xrl", 91).
yyaction_21(TokenChars, TokenLine) ->
     { token, { atom, TokenLine, to_atom (trim (TokenChars)) } } .

-compile({inline,yyaction_22/2}).
-file("/Users/masse/git/redbug/src/redbug_lexer.xrl", 94).
yyaction_22(TokenChars, TokenLine) ->
     { token, { bin, TokenLine, to_binary (TokenChars) } } .
-file("/opt/homebrew/Cellar/erlang/26.2.5/lib/erlang/lib/parsetools-2.5/include/leexinc.hrl", 344).
