/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io;

import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.JvmCoreKt;
import kotlinx.io.RawSource;
import kotlinx.io.Segment;
import kotlinx.io.SegmentKt;
import kotlinx.io.unsafe.UnsafeBufferOperations;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0012\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lkotlinx/io/InputStreamSource;", "Lkotlinx/io/RawSource;", "input", "Ljava/io/InputStream;", "<init>", "(Ljava/io/InputStream;)V", "readAtMostTo", "", "sink", "Lkotlinx/io/Buffer;", "byteCount", "close", "", "toString", "", "kotlinx-io-core"})
@SourceDebugExtension(value={"SMAP\nJvmCore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmCore.kt\nkotlinx/io/InputStreamSource\n+ 2 -Util.kt\nkotlinx/io/_UtilKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 UnsafeBufferOperations.kt\nkotlinx/io/unsafe/UnsafeBufferOperations\n*L\n1#1,112:1\n52#2:113\n53#2:115\n109#2:122\n1#3:114\n195#4,6:116\n203#4,20:123\n*S KotlinDebug\n*F\n+ 1 JvmCore.kt\nkotlinx/io/InputStreamSource\n*L\n80#1:113\n80#1:115\n84#1:122\n80#1:114\n83#1:116,6\n83#1:123,20\n*E\n"})
class InputStreamSource
implements RawSource {
    @NotNull
    private final InputStream input;

    public InputStreamSource(@NotNull InputStream input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.input = input;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long readAtMostTo(@NotNull Buffer sink, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        if (byteCount == 0L) {
            return 0L;
        }
        boolean $i$f$checkByteCount = false;
        if (!(byteCount >= 0L)) {
            boolean $i$a$-require-_UtilKt$checkByteCount$1$iv22 = false;
            String $i$a$-require-_UtilKt$checkByteCount$1$iv22 = "byteCount (" + byteCount + ") < 0";
            throw new IllegalArgumentException($i$a$-require-_UtilKt$checkByteCount$1$iv22.toString());
        }
        try {
            void pos;
            void limit;
            long readTotal = 0L;
            UnsafeBufferOperations $i$a$-require-_UtilKt$checkByteCount$1$iv22 = UnsafeBufferOperations.INSTANCE;
            int minimumCapacity$iv = 1;
            boolean $i$f$writeToTail = false;
            Segment tail$iv = sink.writableSegment(minimumCapacity$iv);
            byte[] data$iv = tail$iv.dataAsByteArray(false);
            int n = data$iv.length;
            int n2 = tail$iv.getLimit();
            byte[] data = data$iv;
            boolean bl = false;
            void b$iv = limit - pos;
            boolean $i$f$minOf = false;
            int maxToCopy = (int)Math.min(byteCount, (long)b$iv);
            readTotal = this.input.read(data, (int)pos, maxToCopy);
            int bytesWritten$iv = readTotal == -1L ? 0 : (int)readTotal;
            if (bytesWritten$iv == minimumCapacity$iv) {
                tail$iv.writeBackData(data$iv, bytesWritten$iv);
                tail$iv.setLimit(tail$iv.getLimit() + bytesWritten$iv);
                sink.setSizeMut(sink.getSizeMut() + (long)bytesWritten$iv);
            } else {
                if (!(0 <= bytesWritten$iv ? bytesWritten$iv <= tail$iv.getRemainingCapacity() : false)) {
                    boolean bl2 = false;
                    String string = "Invalid number of bytes written: " + bytesWritten$iv + ". Should be in 0.." + tail$iv.getRemainingCapacity();
                    throw new IllegalStateException(string.toString());
                }
                if (bytesWritten$iv != 0) {
                    tail$iv.writeBackData(data$iv, bytesWritten$iv);
                    tail$iv.setLimit(tail$iv.getLimit() + bytesWritten$iv);
                    sink.setSizeMut(sink.getSizeMut() + (long)bytesWritten$iv);
                } else if (SegmentKt.isEmpty(tail$iv)) {
                    sink.recycleTail();
                }
            }
            return readTotal;
        }
        catch (AssertionError e) {
            if (JvmCoreKt.isAndroidGetsocknameError(e)) {
                throw new IOException((Throwable)((Object)e));
            }
            throw e;
        }
    }

    @Override
    public void close() {
        this.input.close();
    }

    @NotNull
    public String toString() {
        return "RawSource(" + this.input + ')';
    }
}

