--
-- MULTI_ALTER_TABLE_ADD_CONSTRAINTS_WITHOUT_NAME
--
-- Test checks whether constraints of distributed tables can be adjusted using
-- the ALTER TABLE ... ADD without specifying a name.

-- Check "ADD PRIMARY KEY"
CREATE SCHEMA sc1;
SET search_path TO sc1;

CREATE TABLE products (
    product_no integer,
    name text,
    price numeric
);

SELECT create_distributed_table('products', 'product_no');

CREATE TABLE sc1.products_ref (
    product_no integer,
    name text,
    price numeric
);

CREATE TABLE products_ref_2 (
	    product_no integer,
	    name text,
	    price numeric
);

CREATE TABLE products_ref_3 (
            product_no integer,
            name text,
            price numeric
);

SELECT create_reference_table('products_ref');
SELECT create_reference_table('products_ref_3');

-- Check with max table name (63 chars)
CREATE TABLE verylonglonglonglonglonglonglonglonglonglonglonglonglonglonglonger (
	            product_no integer,
	            name text,
                    price numeric
		);

SELECT create_distributed_table('verylonglonglonglonglonglonglonglonglonglonglonglonglonglonglon', 'product_no');

-- Test the scenario where a partitioned distributed table has a child with max allowed name
-- Verify that we switch to sequential execution mode to avoid deadlock in this scenario
CREATE TABLE dist_partitioned_table (dist_col int, another_col int, partition_col timestamp) PARTITION BY RANGE (partition_col);
CREATE TABLE  p1 PARTITION OF dist_partitioned_table FOR VALUES FROM ('2021-01-01') TO ('2022-01-01');
CREATE TABLE  longlonglonglonglonglonglonglonglonglonglonglonglonglonglongabc PARTITION OF dist_partitioned_table FOR VALUES FROM ('2020-01-01') TO ('2021-01-01');
SELECT create_distributed_table('dist_partitioned_table', 'partition_col');

-- Test primary key name is generated by postgres for citus local table.
CREATE TABLE citus_local_table(id int, other_column int);
