/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_br extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_bn = "bengali";
        final String metaValue_chr = "cherokee";
        final String metaValue_gu = "gujarati";
        final String metaValue_km = "khmer";
        final String metaValue_la = "latin";
        final String metaValue_ml = "malayalam";
        final String metaValue_or = "oriya";
        final String metaValue_te = "telougou";
        final String metaValue_tl = "tagalog";
        final String metaValue_th = "thai";
        final String metaValue_vai = "vai";
        final String metaValue_Hans = "eeunaet";
        final Object[][] data = new Object[][] {
            { "001", "Bed" },
            { "002", "Afrika" },
            { "003", "Norzhamerika" },
            { "005", "Suamerika" },
            { "009", "Oseania" },
            { "011", "Afrika ar C\u02bchorn\u00f4g" },
            { "013", "Kreizamerika" },
            { "014", "Afrika ar Reter" },
            { "015", "Afrika an Norzh" },
            { "017", "Afrika ar C\u02bchreiz" },
            { "018", "Afrika ar Su" },
            { "019", "Amerikao\u00f9" },
            { "021", "Amerika an Norzh" },
            { "029", "Karib" },
            { "030", "Azia ar Reter" },
            { "034", "Azia ar Su" },
            { "035", "Azia ar Gevred" },
            { "039", "Europa ar Su" },
            { "053", "Aostralazia" },
            { "054", "Melanezia" },
            { "057", "Rannved Mikronezia" },
            { "061", "Polinezia" },
            { "142", "Azia" },
            { "143", "Azia ar C\u02bchreiz" },
            { "145", "Azia ar C\u02bchorn\u00f4g" },
            { "150", "Europa" },
            { "151", "Europa ar Reter" },
            { "154", "Europa an Norzh" },
            { "155", "Europa ar C\u02bchorn\u00f4g" },
            { "202", "Afrika issaharat" },
            { "419", "Amerika Latin" },
            { "AC", "Enez Ascension" },
            { "AD", "Andorra" },
            { "AE", "Emirelezhio\u00f9 Arab Unanet" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua ha Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "Antarktika" },
            { "AR", "Arc\u02bchantina" },
            { "AS", "Samoa Amerikan" },
            { "AT", "Aostria" },
            { "AU", "Aostralia" },
            { "AW", "Aruba" },
            { "AX", "Inizi \u00c5land" },
            { "AZ", "Azerbaidjan" },
            { "BA", "Bosnia ha Herzegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Belgia" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrein" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Karib Nederlandat" },
            { "BR", "Brazil" },
            { "BS", "Bahamas" },
            { "BT", "Bhoutan" },
            { "BV", "Enez Bouvet" },
            { "BW", "Botswana" },
            { "BY", "Belarus" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "CC", "Inizi Kokoz" },
            { "CD", "Kongo - Kinshasa" },
            { "CF", "Republik Kreizafrikan" },
            { "CG", "Kongo - Brazzaville" },
            { "CH", "Suis" },
            { "CI", "Aod an Olifant" },
            { "CK", "Inizi Cook" },
            { "CL", "Chile" },
            { "CM", "Kameroun" },
            { "CN", "Sina" },
            { "CO", "Kolombia" },
            { "CP", "Enez Clipperton" },
            { "CR", "Costa Rica" },
            { "CU", "Kuba" },
            { "CV", "Kab-Glas" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Enez Christmas" },
            { "CY", "Kiprenez" },
            { "CZ", "Tchekia" },
            { "DE", "Alamagn" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibouti" },
            { "DK", "Danmark" },
            { "DM", "Dominica" },
            { "DO", "Republik Dominikan" },
            { "DZ", "Aljeria" },
            { "EA", "Ceuta ha Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Estonia" },
            { "EG", "Egipt" },
            { "EH", "Sahara ar C\u02bchorn\u00f4g" },
            { "ER", "Eritrea" },
            { "ES", "Spagn" },
            { "ET", "Etiopia" },
            { "EU", "Unaniezh Europa" },
            { "EZ", "takad an euro" },
            { "FI", "Finland" },
            { "FJ", "Fidji" },
            { "FK", "Inizi Falkland" },
            { "FM", "Mikronezia" },
            { "FO", "Inizi Faero" },
            { "FR", "Fra\u00f1s" },
            { "GA", "Gabon" },
            { "GB", "Rouantelezh-Unanet" },
            { "GD", "Grenada" },
            { "GE", "Jorjia" },
            { "GF", "Gwiana c\u02bchall" },
            { "GG", "Gwernenez" },
            { "GH", "Ghana" },
            { "GI", "Jibraltar" },
            { "GL", "Greunland" },
            { "GM", "Gambia" },
            { "GN", "Ginea" },
            { "GP", "Gwadeloup" },
            { "GQ", "Ginea ar C\u02bcheheder" },
            { "GR", "Gres" },
            { "GS", "Inizi Georgia ar Su hag Inizi Sandwich ar Su" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Ginea-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Hong Kong RMD Sina" },
            { "HM", "Inizi Heard ha McDonald" },
            { "HN", "Honduras" },
            { "HR", "Kroatia" },
            { "HT", "Haiti" },
            { "HU", "Hungaria" },
            { "IC", "Inizi Kanariez" },
            { "ID", "Indonezia" },
            { "IE", "Iwerzhon" },
            { "IL", "Israel" },
            { "IM", "Enez Vanav" },
            { "IN", "India" },
            { "IQ", "Iraq" },
            { "IR", "Iran" },
            { "IS", "Island" },
            { "IT", "Italia" },
            { "JE", "Jerzenez" },
            { "JM", "Jamaika" },
            { "JO", "Jordania" },
            { "JP", "Japan" },
            { "KE", "Kenya" },
            { "KG", "Kyrgyzstan" },
            { "KH", "Kambodja" },
            { "KI", "Kiribati" },
            { "KM", "Komorez" },
            { "KN", "Saint Kitts ha Nevis" },
            { "KP", "Korea an Norzh" },
            { "KR", "Korea ar Su" },
            { "KW", "Koweit" },
            { "KY", "Inizi Cayman" },
            { "KZ", "Kazakstan" },
            { "LA", "Laos" },
            { "LB", "Liban" },
            { "LC", "Saint Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Lituania" },
            { "LU", "Luksembourg" },
            { "LV", "Latvia" },
            { "LY", "Libia" },
            { "MA", "Maroko" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MF", "Saint Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Inizi Marshall" },
            { "MK", "Makedonia an Norzh" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Birmania)" },
            { "MN", "Mongolia" },
            { "MO", "Macau RMD Sina" },
            { "MP", "Inizi Mariana an Norzh" },
            { "MQ", "Martinik" },
            { "MR", "Maouritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Moris" },
            { "MV", "Maldivez" },
            { "MW", "Malawi" },
            { "MX", "Mec\u02bchiko" },
            { "MY", "Malaysia" },
            { "MZ", "Mozambik" },
            { "NA", "Namibia" },
            { "NC", "Kaledonia Nevez" },
            { "NE", "Niger" },
            { "NF", "Enez Norfolk" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Izelvroio\u00f9" },
            { "NO", "Norvegia" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Zeland-Nevez" },
            { "OM", "Oman" },
            { "PA", "Panam\u00e1" },
            { "PE", "Perou" },
            { "PF", "Polinezia C\u02bchall" },
            { "PG", "Papoua Ginea-Nevez" },
            { "PH", "Filipinez" },
            { "PK", "Pakistan" },
            { "PL", "Polonia" },
            { "PM", "Sant-P\u00ear-ha-Mikelon" },
            { "PN", "Enez Pitcairn" },
            { "PR", "Puerto Rico" },
            { "PS", "Tiriado\u00f9 Palestina" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Qatar" },
            { "QO", "Oseania diabell" },
            { "RE", "Ar Re\u00fcnion" },
            { "RO", "Roumania" },
            { "RS", "Serbia" },
            { "RU", "Rusia" },
            { "RW", "Rwanda" },
            { "SA", "Arabia Saoudat" },
            { "SB", "Inizi Salomon" },
            { "SC", "Sechelez" },
            { "SD", "Soudan" },
            { "SE", "Sveden" },
            { "SG", "Singapour" },
            { "SH", "Saint-Helena" },
            { "SI", "Slovenia" },
            { "SJ", "Svalbard" },
            { "SK", "Slovakia" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Surinam" },
            { "SS", "Susoudan" },
            { "ST", "S\u00e3o Tom\u00e9 ha Pr\u00edncipe" },
            { "SV", "Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Siria" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Inizi Turks ha Caicos" },
            { "TD", "Tchad" },
            { "TF", "Douaro\u00f9 aostral Fra\u00f1s" },
            { "TG", "Togo" },
            { "TH", "Thailand" },
            { "TJ", "Tadjikistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunizia" },
            { "TO", "Tonga" },
            { "TR", "Turkia" },
            { "TT", "Trinidad ha Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tanzania" },
            { "UA", "Ukraina" },
            { "UG", "Ouganda" },
            { "UM", "Inizi diabell ar Stado\u00f9-Unanet" },
            { "UN", "Broado\u00f9 unanet" },
            { "US", "Stado\u00f9-Unanet" },
            { "UY", "Uruguay" },
            { "UZ", "Ouzbekistan" },
            { "VA", "Vatikan" },
            { "VC", "Sant Visant hag ar Grenadinez" },
            { "VE", "Venezuela" },
            { "VG", "Inizi Gwerc\u02bch Breizh-Veur" },
            { "VI", "Inizi Gwerc\u02bch ar Stado\u00f9-Unanet" },
            { "VN", "Vi\u00eat Nam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis ha Futuna" },
            { "WS", "Samoa" },
            { "XA", "pouez-mouezh gaou" },
            { "XB", "BiDi gaou" },
            { "XK", "Kosovo" },
            { "YE", "Yemen" },
            { "YT", "Mayotte" },
            { "ZA", "Suafrika" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Rannved dianav" },
            { "aa", "afar" },
            { "ab", "abkhazeg" },
            { "ae", "avesteg" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amhareg" },
            { "an", "aragoneg" },
            { "ar", "arabeg" },
            { "as", "asameg" },
            { "av", "avar" },
            { "ay", "aymara" },
            { "az", "azerbaidjaneg" },
            { "ba", "bachkir" },
            { "be", "belaruseg" },
            { "bg", "bulgareg" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", "tibetaneg" },
            { "br", "brezhoneg" },
            { "bs", "bosneg" },
            { "ca", "katalaneg" },
            { "ce", "tchetcheneg" },
            { "ch", "chamorru" },
            { "co", "korseg" },
            { "cr", "kri" },
            { "cs", "tchekeg" },
            { "cu", "slavoneg iliz" },
            { "cv", "tchouvatch" },
            { "cy", "kembraeg" },
            { "da", "daneg" },
            { "de", "alamaneg" },
            { "dv", "divehi" },
            { "dz", "dzongkha" },
            { "ee", "ewe" },
            { "el", "gresianeg" },
            { "en", "saozneg" },
            { "eo", "esperanteg" },
            { "es", "spagnoleg" },
            { "et", "estoneg" },
            { "eu", "euskareg" },
            { "fa", "perseg" },
            { "ff", "fula" },
            { "fi", "finneg" },
            { "fj", "fidjieg" },
            { "fo", "faeroeg" },
            { "fr", "galleg" },
            { "fy", "frizeg ar C\u02bchorn\u00f4g" },
            { "ga", "iwerzhoneg" },
            { "gd", "skoseg" },
            { "gl", "galizeg" },
            { "gn", "guarani" },
            { "gu", metaValue_gu },
            { "gv", "manaveg" },
            { "ha", "haousa" },
            { "he", "hebraeg" },
            { "hi", "hindi" },
            { "ho", "hiri motu" },
            { "hr", "kroateg" },
            { "ht", "haitieg" },
            { "hu", "hungareg" },
            { "hy", "armenianeg" },
            { "hz", "herero" },
            { "ia", "interlingua" },
            { "id", "indonezeg" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "yieg Sichuan" },
            { "ik", "inupiaq" },
            { "io", "ido" },
            { "is", "islandeg" },
            { "it", "italianeg" },
            { "iu", "inuktitut" },
            { "ja", "japaneg" },
            { "jv", "javaneg" },
            { "ka", "jorjianeg" },
            { "kg", "kongo" },
            { "ki", "kikuyu" },
            { "kj", "kwanyama" },
            { "kk", "kazak" },
            { "kl", "greunlandeg" },
            { "km", metaValue_km },
            { "kn", "kanareg" },
            { "ko", "koreaneg" },
            { "kr", "kanouri" },
            { "ks", "kashmiri" },
            { "ku", "kurdeg" },
            { "kv", "komieg" },
            { "kw", "kerneveureg" },
            { "ky", "kirgiz" },
            { "la", metaValue_la },
            { "lb", "luksembourgeg" },
            { "lg", "ganda" },
            { "li", "limbourgeg" },
            { "ln", "lingala" },
            { "lo", "laoseg" },
            { "lt", "lituaneg" },
            { "lu", "luba-katanga" },
            { "lv", "latvieg" },
            { "mg", "malgacheg" },
            { "mh", "marshall" },
            { "mi", "maori" },
            { "mk", "makedoneg" },
            { "ml", metaValue_ml },
            { "mn", "mongoleg" },
            { "mr", "marathi" },
            { "ms", "malayseg" },
            { "mt", "malteg" },
            { "my", "birmaneg" },
            { "na", "naurueg" },
            { "nb", "norvegeg bokm\u00e5l" },
            { "nd", "ndebele an Norzh" },
            { "ne", "nepaleg" },
            { "ng", "ndonga" },
            { "nl", "nederlandeg" },
            { "nn", "norvegeg nynorsk" },
            { "no", "norvegeg" },
            { "nr", "ndebele ar Su" },
            { "nv", "navac\u02bcho" },
            { "ny", "nyanja" },
            { "oc", "okitaneg" },
            { "oj", "ojibweg" },
            { "om", "oromoeg" },
            { "or", metaValue_or },
            { "os", "oseteg" },
            { "pa", "punjabi" },
            { "pi", "pali" },
            { "pl", "poloneg" },
            { "ps", "pachto" },
            { "pt", "portugaleg" },
            { "qu", "kechuaeg" },
            { "rm", "roma\u00f1cheg" },
            { "rn", "rundi" },
            { "ro", "roumaneg" },
            { "ru", "rusianeg" },
            { "rw", "kinyarwanda" },
            { "sa", "sanskriteg" },
            { "sc", "sardeg" },
            { "sd", "sindhi" },
            { "se", "s\u00e1mi an Norzh" },
            { "sg", "sango" },
            { "sh", "serb-kroateg" },
            { "si", "singhaleg" },
            { "sk", "slovakeg" },
            { "sl", "sloveneg" },
            { "sm", "samoan" },
            { "sn", "shona" },
            { "so", "somali" },
            { "sq", "albaneg" },
            { "sr", "serbeg" },
            { "ss", "swati" },
            { "st", "sotho ar Su" },
            { "su", "sundaneg" },
            { "sv", "svedeg" },
            { "sw", "swahili" },
            { "ta", "tamileg" },
            { "te", metaValue_te },
            { "tg", "tadjik" },
            { "th", metaValue_th },
            { "ti", "tigrigna" },
            { "tk", "turkmeneg" },
            { "tl", metaValue_tl },
            { "tn", "tswana" },
            { "to", "tonga" },
            { "tr", "turkeg" },
            { "ts", "tsonga" },
            { "tt", "tatar" },
            { "tw", "twi" },
            { "ty", "tahitianeg" },
            { "ug", "ouigoureg" },
            { "uk", "ukraineg" },
            { "ur", "ourdou" },
            { "uz", "ouzbekeg" },
            { "ve", "venda" },
            { "vi", "vietnameg" },
            { "vo", "volap\u00fck" },
            { "wa", "walloneg" },
            { "wo", "wolof" },
            { "xh", "xhosa" },
            { "yi", "yiddish" },
            { "yo", "yorouba" },
            { "za", "zhuang" },
            { "zh", "sinaeg" },
            { "zu", "zouloueg" },
            { "ace", "achineg" },
            { "ach", "acoli" },
            { "ada", "adangme" },
            { "ady", "adygeieg" },
            { "aeb", "arabeg Tunizia" },
            { "afh", "afrihili" },
            { "agq", "aghem" },
            { "ain", "ainoueg" },
            { "akk", "akadeg" },
            { "akz", "alabamaeg" },
            { "ale", "aleouteg" },
            { "aln", "gegeg" },
            { "alt", "altaieg ar Su" },
            { "ang", "hensaozneg" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "arc", "arameeg" },
            { "arn", "araoukaneg" },
            { "aro", "araona" },
            { "arp", "arapaho" },
            { "arq", "arabeg Aljeria" },
            { "ars", "arabeg nadjiek" },
            { "arw", "arawakeg" },
            { "ary", "arabeg Maroko" },
            { "arz", "arabeg Egipt" },
            { "asa", "asu" },
            { "ase", "yezh sino\u00f9 Amerika" },
            { "ast", "asturianeg" },
            { "atj", "atikamekweg" },
            { "awa", "awadhi" },
            { "bal", "baloutchi" },
            { "ban", "balineg" },
            { "bar", "bavarieg" },
            { "bas", "basaa" },
            { "bej", "bedawieg" },
            { "bem", "bemba" },
            { "bez", "bena" },
            { "bgn", "baloutchi ar C\u02bchorn\u00f4g" },
            { "bho", "bhojpuri" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "bla", "siksika" },
            { "bra", "braj" },
            { "brh", "brahweg" },
            { "brx", "bodo" },
            { "bss", "akoose" },
            { "bua", "bouriat" },
            { "bug", "bugi" },
            { "byn", "blin" },
            { "cad", "caddo" },
            { "car", "karibeg" },
            { "cay", "kayougeg" },
            { "cch", "atsam" },
            { "ccp", "chakmaeg" },
            { "ceb", "cebuano" },
            { "cgg", "chigaeg" },
            { "chb", "chibcha" },
            { "chk", "chuuk" },
            { "chm", "marieg" },
            { "cho", "choktaw" },
            { "chp", "chipewyan" },
            { "chr", metaValue_chr },
            { "chy", "cheyenne" },
            { "ckb", "kurdeg sorani" },
            { "clc", "chilkotineg" },
            { "cop", "kopteg" },
            { "crg", "michifeg" },
            { "crh", "turkeg Krimea" },
            { "crj", "krieg ar Gevred" },
            { "crk", "krieg ar c\u02bchompezenno\u00f9" },
            { "crl", "krieg ar Biz" },
            { "crm", "krieg ar c\u02bchorn\u00f4g" },
            { "crr", "algonkeg Carolina" },
            { "crs", "kreoleg Sechelez" },
            { "csb", "kachoubeg" },
            { "csw", "krieg ar gwernio\u00f9" },
            { "dak", "dakota" },
            { "dar", "dargwa" },
            { "dav", "taita" },
            { "del", "delaware" },
            { "dgr", "dogrib" },
            { "din", "dinka" },
            { "dje", "zarma" },
            { "doi", "dogri" },
            { "dsb", "izelsorabeg" },
            { "dua", "douala" },
            { "dum", "nederlandeg krenn" },
            { "dyo", "diola" },
            { "dyu", "dyula" },
            { "dzg", "dazagaeg" },
            { "ebu", "embu" },
            { "efi", "efik" },
            { "egy", "henegipteg" },
            { "eka", "ekajuk" },
            { "elx", "elameg" },
            { "enm", "krennsaozneg" },
            { "ewo", "ewondo" },
            { "fan", "fang" },
            { "fat", "fanti" },
            { "fil", "filipineg" },
            { "fit", "finneg trao\u00f1ienn an Torne" },
            { "fon", "fon" },
            { "frc", "galleg cajun" },
            { "frm", "krennc\u02bchalleg" },
            { "fro", "henc\u02bchalleg" },
            { "frp", "arpitaneg" },
            { "frr", "frizeg an Norzh" },
            { "frs", "frizeg ar Reter" },
            { "fur", "frioulaneg" },
            { "gaa", "ga" },
            { "gag", "gagaouzeg" },
            { "gan", "sinaeg Gan" },
            { "gay", "gayo" },
            { "gba", "gbaya" },
            { "gez", "gezeg" },
            { "gil", "gilberteg" },
            { "gmh", "krennalamaneg uhel" },
            { "goh", "henalamaneg uhel" },
            { "gor", "gorontalo" },
            { "got", "goteg" },
            { "grb", "grebo" },
            { "grc", "henc\u02bchresianeg" },
            { "gsw", "alamaneg Suis" },
            { "guz", "gusiieg" },
            { "gwi", "gwich\u2019in" },
            { "hai", "haideg" },
            { "hak", "sinaeg Hakka" },
            { "haw", "hawaieg" },
            { "hax", "haideg ar Su" },
            { "hil", "hiligaynon" },
            { "hmn", "hmong" },
            { "hsb", "uhelsorabeg" },
            { "hsn", "sinaeg Xian" },
            { "hup", "hupa" },
            { "hur", "halkomelemeg" },
            { "iba", "iban" },
            { "ibb", "ibibio" },
            { "ikt", "inuktitut Kanada ar C\u02bchorn\u00f4g" },
            { "ilo", "ilokanoeg" },
            { "inh", "ingoucheg" },
            { "jam", "kreoleg Jamaika" },
            { "jbo", "lojban" },
            { "jgo", "ngomba" },
            { "jmc", "machame" },
            { "jpr", "yuzev-perseg" },
            { "jrb", "yuzev-arabeg" },
            { "kaa", "karakalpak" },
            { "kab", "kabileg" },
            { "kac", "kachin" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kbd", "kabardeg" },
            { "kcg", "tyap" },
            { "kde", "makonde" },
            { "kea", "kabuverdianu" },
            { "kfo", "koroeg" },
            { "kgp", "kaingangeg" },
            { "kha", "khasi" },
            { "kho", "khotaneg" },
            { "khq", "koyra chiini" },
            { "kkj", "kakoeg" },
            { "kln", "kalendjineg" },
            { "kmb", "kimbundu" },
            { "kok", "konkani" },
            { "kos", "kosrae" },
            { "kpe", "kpelle" },
            { "krc", "karatchay-balkar" },
            { "kri", "krio" },
            { "krl", "karelieg" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "ksf", "bafiaeg" },
            { "ksh", "koluneg" },
            { "kum", "koumikeg" },
            { "kut", "kutenai" },
            { "kwk", "kwakwaleg" },
            { "lad", "ladino" },
            { "lag", "langi" },
            { "lah", "lahnda" },
            { "lam", "lamba" },
            { "lez", "lezgi" },
            { "lfn", "lingua franca nova" },
            { "lij", "ligurieg" },
            { "lil", "lillooet" },
            { "lkt", "lakota" },
            { "lol", "mongo" },
            { "lou", "kreoleg Louiziana" },
            { "loz", "lozi" },
            { "lrc", "loureg an Norzh" },
            { "lua", "luba-lulua" },
            { "lui", "luiseno" },
            { "lun", "lunda" },
            { "luo", "luo" },
            { "lus", "lushai" },
            { "luy", "luyia" },
            { "lzh", "sinaeg lennegel" },
            { "mad", "madoureg" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", "makasar" },
            { "mas", "masai" },
            { "mdf", "moksha" },
            { "mdr", "mandar" },
            { "men", "mende" },
            { "mer", "meru" },
            { "mfe", "moriseg" },
            { "mga", "krenniwerzhoneg" },
            { "mgh", "makhuwa-meetto" },
            { "mgo", "meta\u02bc" },
            { "mic", "mikmakeg" },
            { "min", "minangkabau" },
            { "mnc", "manchou" },
            { "mni", "manipuri" },
            { "moe", "montagneg" },
            { "moh", "mohawk" },
            { "mos", "more" },
            { "mrj", "marieg ar C\u02bchorn\u00f4g" },
            { "mua", "moundangeg" },
            { "mul", "yezho\u00f9 lies" },
            { "mus", "muskogi" },
            { "mwl", "mirandeg" },
            { "myv", "erza" },
            { "mzn", "mazanderaneg" },
            { "nan", "sinaeg Min Nan" },
            { "nap", "napolitaneg" },
            { "naq", "nama" },
            { "nds", "alamaneg izel" },
            { "new", "newari" },
            { "nia", "nias" },
            { "niu", "niue" },
            { "njo", "aoeg" },
            { "nmg", "ngoumbeg" },
            { "nnh", "ngiemboon" },
            { "nog", "nogay" },
            { "non", "hennorseg" },
            { "nov", "novial" },
            { "nqo", "nkoeg" },
            { "nso", "sotho an Norzh" },
            { "nus", "nouereg" },
            { "nwc", "newari klasel" },
            { "nym", "nyamwezi" },
            { "nyn", "nyankole" },
            { "nyo", "nyoro" },
            { "ojb", "ojibweg ar Gwalarn" },
            { "ojc", "ojibweg ar c\u02bchreiz" },
            { "ojs", "ojibweg Severn" },
            { "ojw", "ojibweg ar C\u02bchorn\u00f4g" },
            { "oka", "okanaganeg" },
            { "osa", "osage" },
            { "ota", "turkeg otoman" },
            { "pag", "pangasinan" },
            { "pal", "pahlavi" },
            { "pam", "pampanga" },
            { "pap", "papiamento" },
            { "pau", "palau" },
            { "pcd", "pikardeg" },
            { "pcm", "pidjin Nigeria" },
            { "pdc", "alamaneg Pennsylvania" },
            { "peo", "henberseg" },
            { "phn", "fenikianeg" },
            { "pis", "pidjin" },
            { "pms", "piemonteg" },
            { "pnt", "ponteg" },
            { "pon", "pohnpei" },
            { "pqm", "malisiteg-pasamawkodieg" },
            { "prg", "henbruseg" },
            { "pro", "henbrova\u00f1seg" },
            { "quc", "k\u02bciche\u02bc" },
            { "qug", "kichuaeg Chimborazo" },
            { "raj", "rajasthani" },
            { "rap", "rapanui" },
            { "rar", "rarotonga" },
            { "rgn", "romagnoleg" },
            { "rhg", "rohingya" },
            { "rof", "rombo" },
            { "rom", "romanieg" },
            { "rup", "aroumaneg" },
            { "rwk", "rwa" },
            { "sad", "sandawe" },
            { "sah", "yakouteg" },
            { "sam", "arameeg ar Samaritaned" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "sba", "ngambayeg" },
            { "sbp", "sangu" },
            { "scn", "sikilieg" },
            { "sco", "skoteg" },
            { "sdc", "sasareseg" },
            { "seh", "sena" },
            { "ses", "koyraboro senni" },
            { "sga", "heniwerzhoneg" },
            { "shi", "tacheliteg" },
            { "shn", "shan" },
            { "shu", "arabeg Tchad" },
            { "sid", "sidamo" },
            { "slh", "luchoutsideg ar Su" },
            { "sma", "s\u00e1mi ar Su" },
            { "smj", "s\u00e1mi Lule\u00e5" },
            { "smn", "s\u00e1mi Inari" },
            { "sms", "s\u00e1mi Skolt" },
            { "snk", "soninke" },
            { "sog", "sogdieg" },
            { "srn", "sranan tongo" },
            { "srr", "serer" },
            { "ssy", "sahoeg" },
            { "suk", "sukuma" },
            { "sux", "sumereg" },
            { "swb", "komoreg" },
            { "syc", "sirieg klasel" },
            { "syr", "sirieg" },
            { "szl", "silezieg" },
            { "tce", "tutchoneg ar Su" },
            { "tcy", "touloueg" },
            { "tem", "temne" },
            { "teo", "tesoeg" },
            { "ter", "tereno" },
            { "tet", "tetum" },
            { "tig", "tigreaneg" },
            { "tiv", "tiv" },
            { "tkl", "tokelau" },
            { "tlh", "klingon" },
            { "tli", "tinglit" },
            { "tmh", "tamacheg" },
            { "tog", "nyasa tonga" },
            { "tok", "toki pona" },
            { "tpi", "tok pisin" },
            { "tru", "turoyoeg" },
            { "trv", "taroko" },
            { "tsi", "tsimshian" },
            { "ttm", "tutchoneg an Norzh" },
            { "tum", "tumbuka" },
            { "tvl", "tuvalu" },
            { "twq", "tasawakeg" },
            { "tyv", "touva" },
            { "tzm", "tamazigteg Kreizatlas" },
            { "udm", "oudmourteg" },
            { "uga", "ougariteg" },
            { "umb", "umbundu" },
            { "und", "yezh dianav" },
            { "vai", metaValue_vai },
            { "vec", "venezieg" },
            { "vep", "vepseg" },
            { "vls", "flandrezeg ar c\u2019horn\u00f4g" },
            { "vot", "votyakeg" },
            { "vro", "voroeg" },
            { "vun", "vunjo" },
            { "wae", "walser" },
            { "wal", "walamo" },
            { "war", "waray" },
            { "was", "washo" },
            { "wuu", "sinaeg Wu" },
            { "xal", "kalmouk" },
            { "xmf", "megreleg" },
            { "xog", "sogaeg" },
            { "yao", "yao" },
            { "yap", "yapeg" },
            { "yav", "yangben" },
            { "ybb", "yemba" },
            { "yrl", "nengatoueg" },
            { "yue", "kantoneg" },
            { "zap", "zapoteg" },
            { "zbl", "arouezio\u00f9 Bliss" },
            { "zea", "zelandeg" },
            { "zen", "zenaga" },
            { "zgh", "tamacheg Maroko standart" },
            { "zun", "zuni" },
            { "zxx", "diyezh" },
            { "zza", "zazakeg" },
            { "Adlm", "adlam" },
            { "Arab", "arabek" },
            { "Armi", "arameek impalaerel" },
            { "Armn", "armenianek" },
            { "Avst", "avestek" },
            { "Bali", "balinek" },
            { "Bamu", "bamounek" },
            { "Batk", "batak" },
            { "Beng", metaValue_bn },
            { "Bopo", "bopomofo" },
            { "Brai", "Braille" },
            { "Bugi", "bougiek" },
            { "Cakm", "chakmaek" },
            { "Cans", "silabennaoueg engenidik unvan Kanada" },
            { "Cham", "cham" },
            { "Cher", metaValue_chr },
            { "Copt", "koptek" },
            { "Cprt", "silabennaoueg kipriek" },
            { "Cyrl", "kirillek" },
            { "Cyrs", "kirillek henslavonek" },
            { "Deva", "devanagari" },
            { "Dupl", "berrskriverezh Duploy\u00e9" },
            { "Egyp", "hieroglifo\u00f9 egiptek" },
            { "Ethi", "etiopek" },
            { "Geor", "jorjianek" },
            { "Glag", "glagolitek" },
            { "Goth", "gotek" },
            { "Grek", "gresianek" },
            { "Gujr", metaValue_gu },
            { "Guru", "gurmukhi" },
            { "Hanb", "han gant bopomofo" },
            { "Hang", "hangeul" },
            { "Hani", "sinalunio\u00f9 (han)" },
            { "Hans", metaValue_Hans },
            { "Hant", "hengounel" },
            { "Hebr", "hebraek" },
            { "Hira", "hiragana" },
            { "Hluw", "hieroglifo\u00f9 Anatolia" },
            { "Hrkt", "silabennaouego\u00f9 japanek" },
            { "Hung", "henhungarek" },
            { "Ital", "henitalek" },
            { "Jamo", "jamo" },
            { "Java", "javanek" },
            { "Jpan", "japanek" },
            { "Kana", "katakana" },
            { "Khmr", metaValue_km },
            { "Knda", "kannada" },
            { "Kore", "koreanek" },
            { "Laoo", "laosek" },
            { "Latg", "latin gouezelek" },
            { "Latn", metaValue_la },
            { "Lyci", "likiek" },
            { "Lydi", "lidiek" },
            { "Mani", "manikeek" },
            { "Maya", "hieroglifo\u00f9 mayaek" },
            { "Mlym", metaValue_ml },
            { "Mong", "mongolek" },
            { "Mymr", "myanmar" },
            { "Narb", "henarabek an Norzh" },
            { "Ogam", "ogam" },
            { "Orya", metaValue_or },
            { "Phnx", "fenikianek" },
            { "Runr", "runek" },
            { "Samr", "samaritek" },
            { "Sarb", "henarabek ar Su" },
            { "Sinh", "singhalek" },
            { "Sund", "sundanek" },
            { "Syrc", "siriek" },
            { "Syre", "siriek Estrangel\u0101" },
            { "Syrj", "siriek ar C\u2019horn\u00f4g" },
            { "Syrn", "siriek ar Reter" },
            { "Taml", "tamilek" },
            { "Telu", metaValue_te },
            { "Tglg", metaValue_tl },
            { "Thaa", "thaana" },
            { "Thai", metaValue_th },
            { "Tibt", "tibetanek" },
            { "Ugar", "ougaritek" },
            { "Vaii", metaValue_vai },
            { "Xpeo", "persek kozh" },
            { "Xsux", "gennhe\u00f1vel" },
            { "Zinh", "h\u00earezh" },
            { "Zmth", "notadur jedoniel" },
            { "Zsye", "fromlunio\u00f9" },
            { "Zsym", "arouezio\u00f9" },
            { "Zxxx", "anskrivet" },
            { "Zyyy", "boutin" },
            { "Zzzz", "skritur dianav" },
            { "de_AT", "alamaneg Aostria" },
            { "de_CH", "alamaneg uhel Suis" },
            { "en_AU", "saozneg Aostralia" },
            { "en_CA", "saozneg Kanada" },
            { "en_GB", "saozneg Breizh-Veur" },
            { "en_US", "saozneg Amerika" },
            { "es_ES", "spagnoleg Europa" },
            { "es_MX", "spagnoleg Mec\u02bchiko" },
            { "fa_AF", "dareg" },
            { "fr_CA", "galleg Kanada" },
            { "fr_CH", "galleg Suis" },
            { "nl_BE", "flandrezeg" },
            { "pt_BR", "portugaleg Brazil" },
            { "pt_PT", "portugaleg Europa" },
            { "ro_MD", "moldoveg" },
            { "sw_CD", "swahili Kongo" },
            { "%%1901", "reizhskrivadur alamanek hengounel" },
            { "%%1994", "reizhskrivadur resianek skoueriekaet" },
            { "%%1996", "reizhskrivadur alamanek 1996" },
            { "ar_001", "arabeg modern" },
            { "es_419", "spagnoleg Amerika latin" },
            { "key.ca", "deiziadur" },
            { "key.cf", "furmad moneiz" },
            { "key.co", "doare rumma\u00f1" },
            { "key.cu", "moneiz" },
            { "key.hc", "kelc\u02bchiad eurio\u00f9" },
            { "key.lb", "stil torr linenn" },
            { "key.ms", "reizhiad vuzulia\u00f1" },
            { "key.nu", "nivero\u00f9" },
            { "nds_NL", "saksoneg izel" },
            { "%%ALUKU", "rannyezh aloukou" },
            { "%%BARLA", "rannyezho\u00f9 Barlavento kreoleg ar C\u02bchab-Glas" },
            { "%%BISKE", "rannyezh San Giorgio/Bila" },
            { "%%BOONT", "boontling" },
            { "%%CORNU", "saozneg Kerne-Veur" },
            { "%%GALLO", "gallaoueg" },
            { "%%JAUER", "rannyezh roma\u00f1chek Jauer" },
            { "%%KKCOR", "kerneveureg kumun" },
            { "%%KSCOR", "kerneveureg standart" },
            { "%%LIPAW", "rannyezh resianek Lipovaz" },
            { "%%NEDIS", "rannyezh Natisone" },
            { "%%NJIVA", "rannyezh Gniva/Njiva" },
            { "%%NULIK", "volap\u00fck modern" },
            { "%%OSOJS", "rannyezh Oseacco/Osojane" },
            { "%%PEANO", "Peano" },
            { "%%POSIX", "stlenneg" },
            { "%%PUTER", "rannyezh roma\u00f1chek Puter" },
            { "%%RIGIK", "volap\u00fck klasel" },
            { "%%ROZAJ", "resianeg" },
            { "%%RUMGR", "roma\u00f1cheg Grischun" },
            { "%%SAAHO", "saho" },
            { "%%SOLBA", "rannyezh Stolvizza/Solbica" },
            { "%%SOTAV", "rannyezho\u00f9 Sotavento kreoleg ar C\u02bchab-Glas" },
            { "%%UCCOR", "kerneveureg unvan" },
            { "zh_Hans", "sinaeg eeunaet" },
            { "zh_Hant", "sinaeg hengounel" },
            { "%%AO1990", "emglev 1990 war ar reizhskrivadur portugalek" },
            { "%%ARANES", "araneg" },
            { "%%ASANTE", "achanti" },
            { "%%AUVERN", "arverneg" },
            { "%%CISAUP", "kizalpeg" },
            { "%%CREISS", "rannyezho\u00f9 Creissent" },
            { "%%DAJNKO", "lizherenneg Dajnko" },
            { "%%EKAVSK", "serbeg gant distagadur ekavian" },
            { "%%FONIPA", "lizherenneg fonetek etrebroadel" },
            { "%%FONUPA", "lizherenneg fonetek ouralek" },
            { "%%GASCON", "gwaskoneg" },
            { "%%GRITAL", "skritur okitanek Italia" },
            { "%%NDYUKA", "rannyezh Ndyuka" },
            { "%%NICARD", "nisardeg" },
            { "%%PAMAKA", "rannyezh Pamaka" },
            { "%%PINYIN", "romanekadur pinyin" },
            { "%%SCOUSE", "saozneg Liverpool (scouse)" },
            { "%%SIMPLE", metaValue_Hans },
            { "%%TARASK", "belaruseg Taraskievica" },
            { "%%UCRCOR", "kerneveureg unvan reizhet" },
            { "%%ULSTER", "rannyezh skotek Ulad" },
            { "%%UNIFON", "lizherenneg fonetek Unifon" },
            { "%%ABL1943", "doare reizhskriva\u00f1 1943" },
            { "%%AKUAPEM", "akuapem" },
            { "%%ALALC97", "romanekadur ALA-LC 1997" },
            { "%%AREVELA", "armenianeg ar Reter" },
            { "%%AREVMDA", "armenianeg ar C\u02bchorn\u00f4g" },
            { "%%ARKAIKA", "henesperanteg" },
            { "%%BALANKA", "rannyezh aniiek Balanka" },
            { "%%BAUDDHA", "sanskriteg hiron boudaat" },
            { "%%BOHORIC", "lizherenneg Bohori\u010d" },
            { "%%EMODENG", "saozneg rakvodern" },
            { "%%FONNAPA", "lizherenneg fonetek Norzh Amerika" },
            { "%%GRCLASS", "skritur okitanek klasel" },
            { "%%GRMISTR", "skritur okitanek mistralek" },
            { "%%HEPBURN", "romanekadur Hepburn" },
            { "%%ITIHASA", "sanskriteg itih\u00e2sa" },
            { "%%LAUKIKA", "sanskriteg klasel" },
            { "%%LEMOSIN", "rannyezh Limousin" },
            { "%%METELKO", "lizherenneg Metelko" },
            { "%%MONOTON", "gresianeg untonel" },
            { "%%PAHAWH2", "reizhskrivadur pahawh hmong lankad 2" },
            { "%%PAHAWH3", "reizhskrivadur pahawh hmong lankad 3" },
            { "%%PAHAWH4", "reizhskrivadur pahawh hmong doare diwezha\u00f1" },
            { "%%POLYTON", "gresianeg liestonel" },
            { "%%PROVENC", "prova\u00f1seg" },
            { "%%REVISED", "reizhskrivadur reizhet" },
            { "%%SURSILV", "rannyezh roma\u00f1chek sursilvan" },
            { "%%SUTSILV", "rannyezh roma\u00f1chek sutsilvan" },
            { "%%VAIDIKA", "sanskriteg vedek" },
            { "%%1606NICT", "krennc\u02bchalleg diwezha\u00f1" },
            { "%%1694ACAD", "galleg rakvodern" },
            { "%%1959ACAD", "belaruseg akademek" },
            { "%%BAKU1926", "lizherenneg latin turkek unvan" },
            { "%%BASICENG", "saozneg diazez" },
            { "%%BISCAYAN", "rannyezh euskarek Bizkaia" },
            { "%%BORNHOLM", "rannyezh Bornholm" },
            { "%%COLB1945", "emglev 1945 war reizhskrivadur portugaleg Brazil" },
            { "%%FONKIRSH", "lizherenneg fonetek Kirshenbaum" },
            { "%%FONXSAMP", "treuzskrivadur X-SAMPA" },
            { "%%HOGNORSK", "uhelnorvegeg" },
            { "%%HSISTEMO", "esperanteg sistem H" },
            { "%%IJEKAVSK", "serbeg gant distagadur ijekavian" },
            { "%%IVANCHOV", "reizhskrivadur bulgarek Ivanchov" },
            { "%%JYUTPING", "romanekadur kantonek Jyutping" },
            { "%%KOCIEWIE", "rannyezh polonek Kociewie" },
            { "%%LENGADOC", "lengadokeg" },
            { "%%LUNA1918", "reizhskrivadur rusianek goude 1917" },
            { "%%NEWFOUND", "saozneg an Douar-Nevez" },
            { "%%OXENDICT", "skritur Oxford English Dictionary" },
            { "%%PETR1708", "reizhskrivadur rusianek 1708 P\u00ear I" },
            { "%%SCOTLAND", "saozneg standart Skos" },
            { "%%SPANGLIS", "spanglish" },
            { "%%SURMIRAN", "rannyezh roma\u00f1chek surmiran" },
            { "%%SYNNEJYL", "rannyezh Jutland ar Su" },
            { "%%TONGYONG", "Tongyong Pinyin" },
            { "%%TUNUMIIT", "tunumiit" },
            { "%%VALENCIA", "valensianeg" },
            { "%%VALLADER", "rannyezh roma\u00f1chek Vallader" },
            { "%%VECDRUKA", "vec\u0101 druka" },
            { "%%VIVARAUP", "vivaroalpeg" },
            { "%%WADEGILE", "romanekadur Wade-Giles" },
            { "%%XSISTEMO", "esperanteg sistem X" },
            { "type.ca.roc", "deiziadur Republik Sina" },
            { "type.co.eor", "reolenno\u00f9 urzhia\u00f1 europat" },
            { "type.hc.h11", "reizhiad 12 eurvezh (0\u201311)" },
            { "type.hc.h12", "reizhiad 12 eurvezh (1\u201312)" },
            { "type.hc.h23", "reizhiad 24 eurvezh (0\u201323)" },
            { "type.hc.h24", "reizhiad 24 eurvezh (1\u201324)" },
            { "type.nu.ahom", "sifro\u00f9 ahomek" },
            { "type.nu.arab", "sifro\u00f9 arabek indian" },
            { "type.nu.armn", "nivero\u00f9 armenianek" },
            { "type.nu.bali", "sifro\u00f9 balinek" },
            { "type.nu.beng", "sifro\u00f9 bengali" },
            { "type.nu.brah", "sifro\u00f9 brahmi" },
            { "type.nu.cakm", "sifro\u00f9 chakma" },
            { "type.nu.cham", "sifro\u00f9 cham" },
            { "type.nu.cyrl", "nivero\u00f9 kirillek" },
            { "type.nu.deva", "sifro\u00f9 devanagari" },
            { "type.nu.diak", "sifro\u00f9 Divehi Akuru" },
            { "type.nu.ethi", "nivero\u00f9 etiopiat" },
            { "type.nu.geor", "nivero\u00f9 jorjianek" },
            { "type.nu.gong", "sifro\u00f9 gondi Gunjala" },
            { "type.nu.gonm", "sifro\u00f9 gondi Masaram" },
            { "type.nu.grek", "nivero\u00f9 gresianek" },
            { "type.nu.gujr", "sifro\u00f9 gujarati" },
            { "type.nu.guru", "sifro\u00f9 gurmukhi" },
            { "type.nu.hans", "nivero\u00f9 sinaek eeunaet" },
            { "type.nu.hant", "nivero\u00f9 sinaek hengounel" },
            { "type.nu.hebr", "nivero\u00f9 hebraek" },
            { "type.nu.hmng", "sifro\u00f9 Pahawh Hmong" },
            { "type.nu.hmnp", "sifro\u00f9 Nyiakeng Puachue Hmong" },
            { "type.nu.java", "sifro\u00f9 javanek" },
            { "type.nu.jpan", "nivero\u00f9 japanek" },
            { "type.nu.kali", "sifro\u00f9 Kayah Li" },
            { "type.nu.kawi", "sifro\u00f9 kawi" },
            { "type.nu.khmr", "sifro\u00f9 khmer" },
            { "type.nu.knda", "sifro\u00f9 kanarek" },
            { "type.nu.lana", "sifro\u00f9 Tai Tham Hora" },
            { "type.nu.laoo", "sifro\u00f9 laosek" },
            { "type.nu.latn", "sifro\u00f9 arabek ar C\u02bchorn\u00f4g" },
            { "type.nu.lepc", "sifro\u00f9 lepcha" },
            { "type.nu.limb", "sifro\u00f9 limbu" },
            { "type.nu.mlym", "sifro\u00f9 malayalam" },
            { "type.nu.mong", "sifro\u00f9 mongolek" },
            { "type.nu.mtei", "sifro\u00f9 meitei mayek" },
            { "type.nu.mymr", "sifro\u00f9 myanmar" },
            { "type.nu.nkoo", "sifro\u00f9 n\u02bcko" },
            { "type.nu.olck", "sifro\u00f9 ol chiki" },
            { "type.nu.orya", "sifro\u00f9 oriya" },
            { "type.nu.osma", "sifro\u00f9 osmanya" },
            { "type.nu.shrd", "sifro\u00f9 sharada" },
            { "type.nu.sind", "sifro\u00f9 khudawadi" },
            { "type.nu.sinh", "sifro\u00f9 singhalek lith" },
            { "type.nu.sora", "sifro\u00f9 Sora Sompeng" },
            { "type.nu.sund", "sifro\u00f9 sundanek" },
            { "type.nu.takr", "sifro\u00f9 takri" },
            { "type.nu.talu", "sifro\u00f9 tai lu nevez" },
            { "type.nu.taml", "nivero\u00f9 tamilek hengounel" },
            { "type.nu.telu", "sifro\u00f9 telougou" },
            { "type.nu.thai", "sifro\u00f9 thai" },
            { "type.nu.tibt", "sifro\u00f9 tibetan" },
            { "type.nu.tirh", "sifro\u00f9 tirhuta" },
            { "type.nu.tnsa", "sifro\u00f9 tasek" },
            { "type.nu.vaii", "sifro\u00f9 vai" },
            { "type.nu.wara", "sifro\u00f9 warang" },
            { "type.nu.wcho", "sifro\u00f9 wantcho" },
            { "type.ca.dangi", "deiziadur dangi" },
            { "type.co.ducet", "urzh rumma\u00f1 Unicode dre ziouer" },
            { "type.co.emoji", "urzh rumma\u00f1 ar fromlunio\u00f9" },
            { "type.lb.loose", "stil torr linenn lezober" },
            { "type.nu.roman", "nivero\u00f9 roman" },
            { "type.ca.coptic", "deiziadur kopt" },
            { "type.ca.hebrew", "deiziadur hebraek" },
            { "type.ca.indian", "deiziadur indian" },
            { "type.co.pinyin", "urzh rumma\u00f1 pinyin" },
            { "type.co.search", "enklask hollek" },
            { "type.co.stroke", "urzh rumma\u00f1 an treso\u00f9" },
            { "type.co.unihan", "urzh rumma\u00f1 UniHan" },
            { "type.co.zhuyin", "urzh rumma\u00f1 Zhuyin" },
            { "type.lb.normal", "stil torr linenn boas" },
            { "type.lb.strict", "stil torr linenn strizh" },
            { "type.ms.metric", "reizhiad vetrek" },
            { "type.ca.chinese", "deiziadur sinaat" },
            { "type.ca.iso8601", "deiziadur ISO-8601" },
            { "type.ca.persian", "deiziadur persek" },
            { "type.cf.account", "furmad unanenn jedi\u00f1" },
            { "type.co.big5han", "urzh rumma\u00f1 sinaek hengounel - Big5" },
            { "type.nu.arabext", "sifro\u00f9 arabek indian astennet" },
            { "type.nu.armnlow", "nivero\u00f9 armenianek bihan" },
            { "type.nu.greklow", "nivero\u00f9 gresianek bihan" },
            { "type.nu.hanidec", "nivero\u00f9 sinaek dekvedennek" },
            { "type.nu.hansfin", "nivero\u00f9 sinaek eeunaet an arc\u02bchant" },
            { "type.nu.hantfin", "nivero\u00f9 sinaek hengounel an arc\u02bchant" },
            { "type.nu.jpanfin", "nivero\u00f9 japanek an arc\u02bchant" },
            { "type.nu.tamldec", "sifro\u00f9 tamilek" },
            { "type.ca.buddhist", "deiziadur boudaat" },
            { "type.ca.ethiopic", "deiziadur etiopiat" },
            { "type.ca.japanese", "deiziadur japanat" },
            { "type.cf.standard", "furmad moneiz standart" },
            { "type.co.standard", "urzh rumma\u00f1 standart" },
            { "type.ms.uksystem", "reizhiad vuzulia\u00f1 RU" },
            { "type.ms.ussystem", "reizhiad vuzulia\u00f1 SU" },
            { "type.nu.fullwide", "sifro\u00f9 led plaen" },
            { "type.nu.lanatham", "sifro\u00f9 Tai Tham Tham" },
            { "type.nu.mathbold", "sifro\u00f9 tev matematiko\u00f9" },
            { "type.nu.mymrshan", "sifro\u00f9 shan Myanmar" },
            { "type.nu.mymrtlng", "sifro\u00f9 tai laing Myanmar" },
            { "type.nu.romanlow", "nivero\u00f9 roman bihan" },
            { "type.ca.gregorian", "deiziadur gregorian" },
            { "type.co.gb2312han", "urzh rumma\u00f1 sinaek eeunaet - GB2312" },
            { "type.co.phonebook", "urzh rumma\u00f1 al levr-pellgomz" },
            { "ListKeyTypePattern", "{0} : {1}" },
            { "type.co.dictionary", "urzh rumma\u00f1 ar geriadur" },
            { "type.co.traditional", "urzh rumma\u00f1 hengounel" },
            { "type.ca.ethiopic-amete-alem", "deiziadur etiopiat Amete Alem" },
        };
        return data;
    }
}
