//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfurlenumerator?language=objc)
#[repr(C)]
pub struct CFURLEnumerator {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    #[encoding_name = "__CFURLEnumerator"]
    unsafe impl CFURLEnumerator {}
);

#[cfg(feature = "CFBase")]
unsafe impl ConcreteType for CFURLEnumerator {
    #[doc(alias = "CFURLEnumeratorGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFURLEnumeratorGetTypeID() -> CFTypeID;
        }
        unsafe { CFURLEnumeratorGetTypeID() }
    }
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfurlenumeratoroptions?language=objc)
// NS_OPTIONS
#[cfg(feature = "CFBase")]
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFURLEnumeratorOptions(pub CFOptionFlags);
#[cfg(feature = "CFBase")]
bitflags::bitflags! {
    impl CFURLEnumeratorOptions: CFOptionFlags {
        #[doc(alias = "kCFURLEnumeratorDefaultBehavior")]
        const DefaultBehavior = 0;
        #[doc(alias = "kCFURLEnumeratorDescendRecursively")]
        const DescendRecursively = 1<<0;
        #[doc(alias = "kCFURLEnumeratorSkipInvisibles")]
        const SkipInvisibles = 1<<1;
        #[doc(alias = "kCFURLEnumeratorGenerateFileReferenceURLs")]
        const GenerateFileReferenceURLs = 1<<2;
        #[doc(alias = "kCFURLEnumeratorSkipPackageContents")]
        const SkipPackageContents = 1<<3;
        #[doc(alias = "kCFURLEnumeratorIncludeDirectoriesPreOrder")]
        const IncludeDirectoriesPreOrder = 1<<4;
        #[doc(alias = "kCFURLEnumeratorIncludeDirectoriesPostOrder")]
        const IncludeDirectoriesPostOrder = 1<<5;
        #[doc(alias = "kCFURLEnumeratorGenerateRelativePathURLs")]
        const GenerateRelativePathURLs = 1<<6;
    }
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl Encode for CFURLEnumeratorOptions {
    const ENCODING: Encoding = CFOptionFlags::ENCODING;
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl RefEncode for CFURLEnumeratorOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

#[cfg(all(feature = "CFArray", feature = "CFBase", feature = "CFURL"))]
#[inline]
pub unsafe extern "C-unwind" fn CFURLEnumeratorCreateForDirectoryURL(
    alloc: Option<&CFAllocator>,
    directory_url: Option<&CFURL>,
    option: CFURLEnumeratorOptions,
    property_keys: Option<&CFArray>,
) -> Option<CFRetained<CFURLEnumerator>> {
    extern "C-unwind" {
        fn CFURLEnumeratorCreateForDirectoryURL(
            alloc: Option<&CFAllocator>,
            directory_url: Option<&CFURL>,
            option: CFURLEnumeratorOptions,
            property_keys: Option<&CFArray>,
        ) -> Option<NonNull<CFURLEnumerator>>;
    }
    let ret = unsafe {
        CFURLEnumeratorCreateForDirectoryURL(alloc, directory_url, option, property_keys)
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CFArray", feature = "CFBase"))]
#[inline]
pub unsafe extern "C-unwind" fn CFURLEnumeratorCreateForMountedVolumes(
    alloc: Option<&CFAllocator>,
    option: CFURLEnumeratorOptions,
    property_keys: Option<&CFArray>,
) -> Option<CFRetained<CFURLEnumerator>> {
    extern "C-unwind" {
        fn CFURLEnumeratorCreateForMountedVolumes(
            alloc: Option<&CFAllocator>,
            option: CFURLEnumeratorOptions,
            property_keys: Option<&CFArray>,
        ) -> Option<NonNull<CFURLEnumerator>>;
    }
    let ret = unsafe { CFURLEnumeratorCreateForMountedVolumes(alloc, option, property_keys) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfurlenumeratorresult?language=objc)
// NS_ENUM
#[cfg(feature = "CFBase")]
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFURLEnumeratorResult(pub CFIndex);
#[cfg(feature = "CFBase")]
impl CFURLEnumeratorResult {
    #[doc(alias = "kCFURLEnumeratorSuccess")]
    pub const Success: Self = Self(1);
    #[doc(alias = "kCFURLEnumeratorEnd")]
    pub const End: Self = Self(2);
    #[doc(alias = "kCFURLEnumeratorError")]
    pub const Error: Self = Self(3);
    #[doc(alias = "kCFURLEnumeratorDirectoryPostOrderSuccess")]
    pub const DirectoryPostOrderSuccess: Self = Self(4);
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl Encode for CFURLEnumeratorResult {
    const ENCODING: Encoding = CFIndex::ENCODING;
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl RefEncode for CFURLEnumeratorResult {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C-unwind" {
    #[cfg(all(feature = "CFBase", feature = "CFError", feature = "CFURL"))]
    pub fn CFURLEnumeratorGetNextURL(
        enumerator: &CFURLEnumerator,
        url: *mut *const CFURL,
        error: *mut *mut CFError,
    ) -> CFURLEnumeratorResult;
}

extern "C-unwind" {
    pub fn CFURLEnumeratorSkipDescendents(enumerator: &CFURLEnumerator);
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFURLEnumeratorGetDescendentLevel(enumerator: &CFURLEnumerator) -> CFIndex;
}

#[deprecated = "Use File System Events API instead"]
#[inline]
pub unsafe extern "C-unwind" fn CFURLEnumeratorGetSourceDidChange(
    enumerator: &CFURLEnumerator,
) -> bool {
    extern "C-unwind" {
        fn CFURLEnumeratorGetSourceDidChange(enumerator: &CFURLEnumerator) -> Boolean;
    }
    let ret = unsafe { CFURLEnumeratorGetSourceDidChange(enumerator) };
    ret != 0
}
