[![crates.io](https://img.shields.io/crates/v/codepage.svg)](https://crates.io/crates/codepage)
[![docs.rs](https://docs.rs/codepage/badge.svg)](https://docs.rs/codepage/)
[![Apache 2 / MIT dual-licensed](https://img.shields.io/badge/license-Apache%202%20%2F%20MIT-blue.svg)](https://github.com/hsivonen/codepage/blob/master/COPYRIGHT)

# codepage

Mapping between Windows [code page identifiers][1] and
[encoding_rs][2] `Encoding`s.

[1]: https://docs.microsoft.com/en-us/windows/desktop/intl/code-page-identifiers
[2]: https://crates.io/crates/encoding_rs/

## Why a Separate Crate?

This crate isn't part of encoding_rs itself in order to avoid scope
creep for encoding_rs itself and to signal that Windows code page
applicability of encoding_rs is secondary. It's not completely
incidental due to Web history, but encoding_rs will prioritize
compliance with the WHATWG
[Encoding Standard](https://encoding.spec.whatwg.org/)
over matching the Windows system converters exactly. Still,
encoding_rs is in practice useful for decoding legacy Windows
data, because all the "ANSI code pages" that are the default
for some Windows locale are present in the Encoding Standard,
because those defaults have influenced the Web.

## Version 1.0

Logically this crate should be at version 1.0, but it's not worth the hassle
to do a version number semver break when there's no actual API break. The
expectation is to do 1.0 when `encoding_rs` 1.0 comes along.

## Licensing

Please see the file named
[COPYRIGHT](https://github.com/hsivonen/codepage/blob/master/COPYRIGHT).

## API Documentation

Generated [API documentation](https://docs.rs/codepage/) is available
online.

## Security Considerations

Only code page numbers whose corresponding labels map to the replacement
encoding in the Encoding Standard map to the replacement encoding here,
despite many other code page numbers referring to encodings with similar
security problems.

## Disclaimer

This is a personal project. It has a Mozilla copyright notice, because
it's partially generated by the Python script in the encoding_rs repo.
You should not try to read anything more into Mozilla's name appearing.

## Release Notes

### 0.1.2

* Make the crate `no_std`.

### 0.1.1

* Fix metadata.

### 0.1.0

Initial non-placeholder release.