// Package performancetimeline provides the Chrome DevTools Protocol
// commands, types, and events for the PerformanceTimeline domain.
//
// Reporting of performance timeline events, as specified in
// https://w3c.github.io/performance-timeline/#dom-performanceobserver.
//
// Generated by the cdproto-gen command.
package performancetimeline

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"context"

	"github.com/chromedp/cdproto/cdp"
)

// EnableParams previously buffered events would be reported before method
// returns. See also: timelineEventAdded.
type EnableParams struct {
	EventTypes []string `json:"eventTypes"` // The types of event to report, as specified in https://w3c.github.io/performance-timeline/#dom-performanceentry-entrytype The specified filter overrides any previous filters, passing empty filter disables recording. Note that not all types exposed to the web platform are currently supported.
}

// Enable previously buffered events would be reported before method returns.
// See also: timelineEventAdded.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/PerformanceTimeline#method-enable
//
// parameters:
//
//	eventTypes - The types of event to report, as specified in https://w3c.github.io/performance-timeline/#dom-performanceentry-entrytype The specified filter overrides any previous filters, passing empty filter disables recording. Note that not all types exposed to the web platform are currently supported.
func Enable(eventTypes []string) *EnableParams {
	return &EnableParams{
		EventTypes: eventTypes,
	}
}

// Do executes PerformanceTimeline.enable against the provided context.
func (p *EnableParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandEnable, p, nil)
}

// Command names.
const (
	CommandEnable = "PerformanceTimeline.enable"
)
