#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 5986
#define LARGE_STATE_COUNT 1167
#define SYMBOL_COUNT 393
#define ALIAS_COUNT 7
#define TOKEN_COUNT 172
#define EXTERNAL_TOKEN_COUNT 10
#define FIELD_COUNT 43
#define MAX_ALIAS_SEQUENCE_LENGTH 10
#define PRODUCTION_ID_COUNT 351

enum ts_symbol_identifiers {
  sym_identifier = 1,
  sym_hash_bang_line = 2,
  anon_sym_export = 3,
  anon_sym_STAR = 4,
  anon_sym_default = 5,
  anon_sym_type = 6,
  anon_sym_EQ = 7,
  anon_sym_as = 8,
  anon_sym_namespace = 9,
  anon_sym_LBRACE = 10,
  anon_sym_COMMA = 11,
  anon_sym_RBRACE = 12,
  anon_sym_typeof = 13,
  anon_sym_import = 14,
  anon_sym_from = 15,
  anon_sym_with = 16,
  anon_sym_assert = 17,
  anon_sym_var = 18,
  anon_sym_let = 19,
  anon_sym_const = 20,
  anon_sym_BANG = 21,
  anon_sym_else = 22,
  anon_sym_if = 23,
  anon_sym_switch = 24,
  anon_sym_for = 25,
  anon_sym_LPAREN = 26,
  anon_sym_SEMI = 27,
  anon_sym_RPAREN = 28,
  anon_sym_await = 29,
  anon_sym_in = 30,
  anon_sym_of = 31,
  anon_sym_while = 32,
  anon_sym_do = 33,
  anon_sym_try = 34,
  anon_sym_break = 35,
  anon_sym_continue = 36,
  anon_sym_debugger = 37,
  anon_sym_return = 38,
  anon_sym_throw = 39,
  anon_sym_COLON = 40,
  anon_sym_case = 41,
  anon_sym_catch = 42,
  anon_sym_finally = 43,
  anon_sym_yield = 44,
  anon_sym_LBRACK = 45,
  anon_sym_RBRACK = 46,
  sym_html_character_reference = 47,
  anon_sym_GT = 48,
  sym_jsx_identifier = 49,
  anon_sym_DOT = 50,
  anon_sym_LT_SLASH = 51,
  anon_sym_SLASH_GT = 52,
  anon_sym_DQUOTE = 53,
  anon_sym_SQUOTE = 54,
  sym_unescaped_double_jsx_string_fragment = 55,
  sym_unescaped_single_jsx_string_fragment = 56,
  anon_sym_class = 57,
  anon_sym_async = 58,
  anon_sym_function = 59,
  anon_sym_EQ_GT = 60,
  anon_sym_QMARK_DOT = 61,
  anon_sym_new = 62,
  anon_sym_using = 63,
  anon_sym_PLUS_EQ = 64,
  anon_sym_DASH_EQ = 65,
  anon_sym_STAR_EQ = 66,
  anon_sym_SLASH_EQ = 67,
  anon_sym_PERCENT_EQ = 68,
  anon_sym_CARET_EQ = 69,
  anon_sym_AMP_EQ = 70,
  anon_sym_PIPE_EQ = 71,
  anon_sym_GT_GT_EQ = 72,
  anon_sym_GT_GT_GT_EQ = 73,
  anon_sym_LT_LT_EQ = 74,
  anon_sym_STAR_STAR_EQ = 75,
  anon_sym_AMP_AMP_EQ = 76,
  anon_sym_PIPE_PIPE_EQ = 77,
  anon_sym_QMARK_QMARK_EQ = 78,
  anon_sym_DOT_DOT_DOT = 79,
  anon_sym_AMP_AMP = 80,
  anon_sym_PIPE_PIPE = 81,
  anon_sym_GT_GT = 82,
  anon_sym_GT_GT_GT = 83,
  anon_sym_LT_LT = 84,
  anon_sym_AMP = 85,
  anon_sym_CARET = 86,
  anon_sym_PIPE = 87,
  anon_sym_PLUS = 88,
  anon_sym_DASH = 89,
  anon_sym_SLASH = 90,
  anon_sym_PERCENT = 91,
  anon_sym_STAR_STAR = 92,
  anon_sym_LT = 93,
  anon_sym_LT_EQ = 94,
  anon_sym_EQ_EQ = 95,
  anon_sym_EQ_EQ_EQ = 96,
  anon_sym_BANG_EQ = 97,
  anon_sym_BANG_EQ_EQ = 98,
  anon_sym_GT_EQ = 99,
  anon_sym_QMARK_QMARK = 100,
  anon_sym_instanceof = 101,
  anon_sym_TILDE = 102,
  anon_sym_void = 103,
  anon_sym_delete = 104,
  anon_sym_PLUS_PLUS = 105,
  anon_sym_DASH_DASH = 106,
  sym_unescaped_double_string_fragment = 107,
  sym_unescaped_single_string_fragment = 108,
  sym_escape_sequence = 109,
  sym_comment = 110,
  anon_sym_BQUOTE = 111,
  anon_sym_DOLLAR_LBRACE = 112,
  anon_sym_SLASH2 = 113,
  sym_regex_pattern = 114,
  sym_regex_flags = 115,
  sym_number = 116,
  sym_private_property_identifier = 117,
  anon_sym_target = 118,
  anon_sym_meta = 119,
  sym_this = 120,
  sym_super = 121,
  sym_true = 122,
  sym_false = 123,
  sym_null = 124,
  sym_undefined = 125,
  anon_sym_AT = 126,
  anon_sym_static = 127,
  anon_sym_readonly = 128,
  anon_sym_get = 129,
  anon_sym_set = 130,
  anon_sym_QMARK = 131,
  anon_sym_declare = 132,
  anon_sym_public = 133,
  anon_sym_private = 134,
  anon_sym_protected = 135,
  anon_sym_override = 136,
  anon_sym_module = 137,
  anon_sym_any = 138,
  anon_sym_number = 139,
  anon_sym_boolean = 140,
  anon_sym_string = 141,
  anon_sym_symbol = 142,
  anon_sym_object = 143,
  anon_sym_abstract = 144,
  anon_sym_accessor = 145,
  anon_sym_satisfies = 146,
  anon_sym_require = 147,
  anon_sym_extends = 148,
  anon_sym_implements = 149,
  anon_sym_global = 150,
  anon_sym_interface = 151,
  anon_sym_enum = 152,
  anon_sym_DASH_QMARK_COLON = 153,
  anon_sym_PLUS_QMARK_COLON = 154,
  anon_sym_QMARK_COLON = 155,
  anon_sym_asserts = 156,
  anon_sym_infer = 157,
  anon_sym_is = 158,
  anon_sym_keyof = 159,
  anon_sym_unique = 160,
  anon_sym_unknown = 161,
  anon_sym_never = 162,
  anon_sym_LBRACE_PIPE = 163,
  anon_sym_PIPE_RBRACE = 164,
  sym__automatic_semicolon = 165,
  sym__template_chars = 166,
  sym__ternary_qmark = 167,
  sym_html_comment = 168,
  sym_jsx_text = 169,
  sym__function_signature_automatic_semicolon = 170,
  sym___error_recovery = 171,
  sym_program = 172,
  sym_export_statement = 173,
  sym_namespace_export = 174,
  sym_export_clause = 175,
  sym_export_specifier = 176,
  sym__module_export_name = 177,
  sym_declaration = 178,
  sym_import = 179,
  sym_import_statement = 180,
  sym_import_clause = 181,
  sym__from_clause = 182,
  sym_namespace_import = 183,
  sym_named_imports = 184,
  sym_import_specifier = 185,
  sym_import_attribute = 186,
  sym_statement = 187,
  sym_expression_statement = 188,
  sym_variable_declaration = 189,
  sym_lexical_declaration = 190,
  sym_variable_declarator = 191,
  sym_statement_block = 192,
  sym_else_clause = 193,
  sym_if_statement = 194,
  sym_switch_statement = 195,
  sym_for_statement = 196,
  sym_for_in_statement = 197,
  sym__for_header = 198,
  sym_while_statement = 199,
  sym_do_statement = 200,
  sym_try_statement = 201,
  sym_with_statement = 202,
  sym_break_statement = 203,
  sym_continue_statement = 204,
  sym_debugger_statement = 205,
  sym_return_statement = 206,
  sym_throw_statement = 207,
  sym_empty_statement = 208,
  sym_labeled_statement = 209,
  sym_switch_body = 210,
  sym_switch_case = 211,
  sym_switch_default = 212,
  sym_catch_clause = 213,
  sym_finally_clause = 214,
  sym_parenthesized_expression = 215,
  sym_expression = 216,
  sym_primary_expression = 217,
  sym_yield_expression = 218,
  sym_object = 219,
  sym_object_pattern = 220,
  sym_assignment_pattern = 221,
  sym_object_assignment_pattern = 222,
  sym_array = 223,
  sym_array_pattern = 224,
  sym_jsx_element = 225,
  sym_jsx_expression = 226,
  sym_jsx_opening_element = 227,
  sym_nested_identifier = 228,
  sym_jsx_namespace_name = 229,
  sym_jsx_closing_element = 230,
  sym_jsx_self_closing_element = 231,
  sym_jsx_attribute = 232,
  sym__jsx_string = 233,
  sym_class = 234,
  sym_class_declaration = 235,
  sym_class_heritage = 236,
  sym_function_expression = 237,
  sym_function_declaration = 238,
  sym_generator_function = 239,
  sym_generator_function_declaration = 240,
  sym_arrow_function = 241,
  sym__call_signature = 242,
  sym__formal_parameter = 243,
  sym_optional_chain = 244,
  sym_call_expression = 245,
  sym_new_expression = 246,
  sym_await_expression = 247,
  sym_member_expression = 248,
  sym_subscript_expression = 249,
  sym_assignment_expression = 250,
  sym__augmented_assignment_lhs = 251,
  sym_augmented_assignment_expression = 252,
  sym__initializer = 253,
  sym__destructuring_pattern = 254,
  sym_spread_element = 255,
  sym_ternary_expression = 256,
  sym_binary_expression = 257,
  sym_unary_expression = 258,
  sym_update_expression = 259,
  sym_sequence_expression = 260,
  sym_string = 261,
  sym_template_string = 262,
  sym_template_substitution = 263,
  sym_regex = 264,
  sym_meta_property = 265,
  sym_arguments = 266,
  sym_decorator = 267,
  sym_decorator_member_expression = 268,
  sym_decorator_call_expression = 269,
  sym_class_body = 270,
  sym_formal_parameters = 271,
  sym_class_static_block = 272,
  sym_pattern = 273,
  sym_rest_pattern = 274,
  sym_method_definition = 275,
  sym_pair = 276,
  sym_pair_pattern = 277,
  sym__property_name = 278,
  sym_computed_property_name = 279,
  sym_public_field_definition = 280,
  sym__import_identifier = 281,
  sym_non_null_expression = 282,
  sym_method_signature = 283,
  sym_abstract_method_signature = 284,
  sym_function_signature = 285,
  sym_decorator_parenthesized_expression = 286,
  sym_as_expression = 287,
  sym_satisfies_expression = 288,
  sym_instantiation_expression = 289,
  sym_import_require_clause = 290,
  sym_extends_clause = 291,
  sym__extends_clause_single = 292,
  sym_implements_clause = 293,
  sym_ambient_declaration = 294,
  sym_abstract_class_declaration = 295,
  sym_module = 296,
  sym_internal_module = 297,
  sym__module = 298,
  sym_import_alias = 299,
  sym_nested_type_identifier = 300,
  sym_interface_declaration = 301,
  sym_extends_type_clause = 302,
  sym_enum_declaration = 303,
  sym_enum_body = 304,
  sym_enum_assignment = 305,
  sym_type_alias_declaration = 306,
  sym_accessibility_modifier = 307,
  sym_override_modifier = 308,
  sym_required_parameter = 309,
  sym_optional_parameter = 310,
  sym__parameter_name = 311,
  sym_omitting_type_annotation = 312,
  sym_adding_type_annotation = 313,
  sym_opting_type_annotation = 314,
  sym_type_annotation = 315,
  sym__type_query_member_expression_in_type_annotation = 316,
  sym__type_query_call_expression_in_type_annotation = 317,
  sym_asserts = 318,
  sym_asserts_annotation = 319,
  sym_type = 320,
  sym_tuple_parameter = 321,
  sym_optional_tuple_parameter = 322,
  sym_optional_type = 323,
  sym_rest_type = 324,
  sym__tuple_type_member = 325,
  sym_constructor_type = 326,
  sym_primary_type = 327,
  sym_template_type = 328,
  sym_template_literal_type = 329,
  sym_infer_type = 330,
  sym_conditional_type = 331,
  sym_generic_type = 332,
  sym_type_predicate = 333,
  sym_type_predicate_annotation = 334,
  sym__type_query_member_expression = 335,
  sym__type_query_subscript_expression = 336,
  sym__type_query_call_expression = 337,
  sym__type_query_instantiation_expression = 338,
  sym_type_query = 339,
  sym_index_type_query = 340,
  sym_lookup_type = 341,
  sym_mapped_type_clause = 342,
  sym_literal_type = 343,
  sym__number = 344,
  sym_existential_type = 345,
  sym_flow_maybe_type = 346,
  sym_parenthesized_type = 347,
  sym_predefined_type = 348,
  sym_type_arguments = 349,
  sym_object_type = 350,
  sym_call_signature = 351,
  sym_property_signature = 352,
  sym_type_parameters = 353,
  sym_type_parameter = 354,
  sym_default_type = 355,
  sym_constraint = 356,
  sym_construct_signature = 357,
  sym_index_signature = 358,
  sym_array_type = 359,
  sym_tuple_type = 360,
  sym_readonly_type = 361,
  sym_union_type = 362,
  sym_intersection_type = 363,
  sym_function_type = 364,
  aux_sym_program_repeat1 = 365,
  aux_sym_export_statement_repeat1 = 366,
  aux_sym_export_clause_repeat1 = 367,
  aux_sym_named_imports_repeat1 = 368,
  aux_sym_variable_declaration_repeat1 = 369,
  aux_sym_switch_body_repeat1 = 370,
  aux_sym_object_repeat1 = 371,
  aux_sym_object_pattern_repeat1 = 372,
  aux_sym_array_repeat1 = 373,
  aux_sym_array_pattern_repeat1 = 374,
  aux_sym_jsx_element_repeat1 = 375,
  aux_sym__jsx_string_repeat1 = 376,
  aux_sym__jsx_string_repeat2 = 377,
  aux_sym_sequence_expression_repeat1 = 378,
  aux_sym_string_repeat1 = 379,
  aux_sym_string_repeat2 = 380,
  aux_sym_template_string_repeat1 = 381,
  aux_sym_class_body_repeat1 = 382,
  aux_sym_formal_parameters_repeat1 = 383,
  aux_sym__jsx_start_opening_element_repeat1 = 384,
  aux_sym_extends_clause_repeat1 = 385,
  aux_sym_implements_clause_repeat1 = 386,
  aux_sym_extends_type_clause_repeat1 = 387,
  aux_sym_enum_body_repeat1 = 388,
  aux_sym_template_literal_type_repeat1 = 389,
  aux_sym_object_type_repeat1 = 390,
  aux_sym_type_parameters_repeat1 = 391,
  aux_sym_tuple_type_repeat1 = 392,
  alias_sym_interface_body = 393,
  alias_sym_property_identifier = 394,
  alias_sym_shorthand_property_identifier = 395,
  alias_sym_shorthand_property_identifier_pattern = 396,
  alias_sym_statement_identifier = 397,
  alias_sym_this_type = 398,
  alias_sym_type_identifier = 399,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_hash_bang_line] = "hash_bang_line",
  [anon_sym_export] = "export",
  [anon_sym_STAR] = "*",
  [anon_sym_default] = "default",
  [anon_sym_type] = "type",
  [anon_sym_EQ] = "=",
  [anon_sym_as] = "as",
  [anon_sym_namespace] = "namespace",
  [anon_sym_LBRACE] = "{",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACE] = "}",
  [anon_sym_typeof] = "typeof",
  [anon_sym_import] = "import",
  [anon_sym_from] = "from",
  [anon_sym_with] = "with",
  [anon_sym_assert] = "assert",
  [anon_sym_var] = "var",
  [anon_sym_let] = "let",
  [anon_sym_const] = "const",
  [anon_sym_BANG] = "!",
  [anon_sym_else] = "else",
  [anon_sym_if] = "if",
  [anon_sym_switch] = "switch",
  [anon_sym_for] = "for",
  [anon_sym_LPAREN] = "(",
  [anon_sym_SEMI] = ";",
  [anon_sym_RPAREN] = ")",
  [anon_sym_await] = "await",
  [anon_sym_in] = "in",
  [anon_sym_of] = "of",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_try] = "try",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_debugger] = "debugger",
  [anon_sym_return] = "return",
  [anon_sym_throw] = "throw",
  [anon_sym_COLON] = ":",
  [anon_sym_case] = "case",
  [anon_sym_catch] = "catch",
  [anon_sym_finally] = "finally",
  [anon_sym_yield] = "yield",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [sym_html_character_reference] = "html_character_reference",
  [anon_sym_GT] = ">",
  [sym_jsx_identifier] = "identifier",
  [anon_sym_DOT] = ".",
  [anon_sym_LT_SLASH] = "</",
  [anon_sym_SLASH_GT] = "/>",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_SQUOTE] = "'",
  [sym_unescaped_double_jsx_string_fragment] = "string_fragment",
  [sym_unescaped_single_jsx_string_fragment] = "string_fragment",
  [anon_sym_class] = "class",
  [anon_sym_async] = "async",
  [anon_sym_function] = "function",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_QMARK_DOT] = "\?.",
  [anon_sym_new] = "new",
  [anon_sym_using] = "using",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_GT_GT_GT_EQ] = ">>>=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_STAR_STAR_EQ] = "**=",
  [anon_sym_AMP_AMP_EQ] = "&&=",
  [anon_sym_PIPE_PIPE_EQ] = "||=",
  [anon_sym_QMARK_QMARK_EQ] = "\?\?=",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_AMP] = "&",
  [anon_sym_CARET] = "^",
  [anon_sym_PIPE] = "|",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_EQ_EQ_EQ] = "===",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_BANG_EQ_EQ] = "!==",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_QMARK_QMARK] = "\?\?",
  [anon_sym_instanceof] = "instanceof",
  [anon_sym_TILDE] = "~",
  [anon_sym_void] = "void",
  [anon_sym_delete] = "delete",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [sym_unescaped_double_string_fragment] = "string_fragment",
  [sym_unescaped_single_string_fragment] = "string_fragment",
  [sym_escape_sequence] = "escape_sequence",
  [sym_comment] = "comment",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [anon_sym_SLASH2] = "/",
  [sym_regex_pattern] = "regex_pattern",
  [sym_regex_flags] = "regex_flags",
  [sym_number] = "number",
  [sym_private_property_identifier] = "private_property_identifier",
  [anon_sym_target] = "target",
  [anon_sym_meta] = "meta",
  [sym_this] = "this",
  [sym_super] = "super",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_null] = "null",
  [sym_undefined] = "undefined",
  [anon_sym_AT] = "@",
  [anon_sym_static] = "static",
  [anon_sym_readonly] = "readonly",
  [anon_sym_get] = "get",
  [anon_sym_set] = "set",
  [anon_sym_QMARK] = "\?",
  [anon_sym_declare] = "declare",
  [anon_sym_public] = "public",
  [anon_sym_private] = "private",
  [anon_sym_protected] = "protected",
  [anon_sym_override] = "override",
  [anon_sym_module] = "module",
  [anon_sym_any] = "any",
  [anon_sym_number] = "number",
  [anon_sym_boolean] = "boolean",
  [anon_sym_string] = "string",
  [anon_sym_symbol] = "symbol",
  [anon_sym_object] = "object",
  [anon_sym_abstract] = "abstract",
  [anon_sym_accessor] = "accessor",
  [anon_sym_satisfies] = "satisfies",
  [anon_sym_require] = "require",
  [anon_sym_extends] = "extends",
  [anon_sym_implements] = "implements",
  [anon_sym_global] = "global",
  [anon_sym_interface] = "interface",
  [anon_sym_enum] = "enum",
  [anon_sym_DASH_QMARK_COLON] = "-\?:",
  [anon_sym_PLUS_QMARK_COLON] = "+\?:",
  [anon_sym_QMARK_COLON] = "\?:",
  [anon_sym_asserts] = "asserts",
  [anon_sym_infer] = "infer",
  [anon_sym_is] = "is",
  [anon_sym_keyof] = "keyof",
  [anon_sym_unique] = "unique symbol",
  [anon_sym_unknown] = "unknown",
  [anon_sym_never] = "never",
  [anon_sym_LBRACE_PIPE] = "{|",
  [anon_sym_PIPE_RBRACE] = "|}",
  [sym__automatic_semicolon] = "_automatic_semicolon",
  [sym__template_chars] = "string_fragment",
  [sym__ternary_qmark] = "\?",
  [sym_html_comment] = "html_comment",
  [sym_jsx_text] = "jsx_text",
  [sym__function_signature_automatic_semicolon] = "_function_signature_automatic_semicolon",
  [sym___error_recovery] = "__error_recovery",
  [sym_program] = "program",
  [sym_export_statement] = "export_statement",
  [sym_namespace_export] = "namespace_export",
  [sym_export_clause] = "export_clause",
  [sym_export_specifier] = "export_specifier",
  [sym__module_export_name] = "_module_export_name",
  [sym_declaration] = "declaration",
  [sym_import] = "import",
  [sym_import_statement] = "import_statement",
  [sym_import_clause] = "import_clause",
  [sym__from_clause] = "_from_clause",
  [sym_namespace_import] = "namespace_import",
  [sym_named_imports] = "named_imports",
  [sym_import_specifier] = "import_specifier",
  [sym_import_attribute] = "import_attribute",
  [sym_statement] = "statement",
  [sym_expression_statement] = "expression_statement",
  [sym_variable_declaration] = "variable_declaration",
  [sym_lexical_declaration] = "lexical_declaration",
  [sym_variable_declarator] = "variable_declarator",
  [sym_statement_block] = "statement_block",
  [sym_else_clause] = "else_clause",
  [sym_if_statement] = "if_statement",
  [sym_switch_statement] = "switch_statement",
  [sym_for_statement] = "for_statement",
  [sym_for_in_statement] = "for_in_statement",
  [sym__for_header] = "_for_header",
  [sym_while_statement] = "while_statement",
  [sym_do_statement] = "do_statement",
  [sym_try_statement] = "try_statement",
  [sym_with_statement] = "with_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_debugger_statement] = "debugger_statement",
  [sym_return_statement] = "return_statement",
  [sym_throw_statement] = "throw_statement",
  [sym_empty_statement] = "empty_statement",
  [sym_labeled_statement] = "labeled_statement",
  [sym_switch_body] = "switch_body",
  [sym_switch_case] = "switch_case",
  [sym_switch_default] = "switch_default",
  [sym_catch_clause] = "catch_clause",
  [sym_finally_clause] = "finally_clause",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_expression] = "expression",
  [sym_primary_expression] = "primary_expression",
  [sym_yield_expression] = "yield_expression",
  [sym_object] = "object",
  [sym_object_pattern] = "object_pattern",
  [sym_assignment_pattern] = "assignment_pattern",
  [sym_object_assignment_pattern] = "object_assignment_pattern",
  [sym_array] = "array",
  [sym_array_pattern] = "array_pattern",
  [sym_jsx_element] = "jsx_element",
  [sym_jsx_expression] = "jsx_expression",
  [sym_jsx_opening_element] = "jsx_opening_element",
  [sym_nested_identifier] = "nested_identifier",
  [sym_jsx_namespace_name] = "jsx_namespace_name",
  [sym_jsx_closing_element] = "jsx_closing_element",
  [sym_jsx_self_closing_element] = "jsx_self_closing_element",
  [sym_jsx_attribute] = "jsx_attribute",
  [sym__jsx_string] = "string",
  [sym_class] = "class",
  [sym_class_declaration] = "class_declaration",
  [sym_class_heritage] = "class_heritage",
  [sym_function_expression] = "function_expression",
  [sym_function_declaration] = "function_declaration",
  [sym_generator_function] = "generator_function",
  [sym_generator_function_declaration] = "generator_function_declaration",
  [sym_arrow_function] = "arrow_function",
  [sym__call_signature] = "_call_signature",
  [sym__formal_parameter] = "_formal_parameter",
  [sym_optional_chain] = "optional_chain",
  [sym_call_expression] = "call_expression",
  [sym_new_expression] = "new_expression",
  [sym_await_expression] = "await_expression",
  [sym_member_expression] = "member_expression",
  [sym_subscript_expression] = "subscript_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym__augmented_assignment_lhs] = "_augmented_assignment_lhs",
  [sym_augmented_assignment_expression] = "augmented_assignment_expression",
  [sym__initializer] = "_initializer",
  [sym__destructuring_pattern] = "_destructuring_pattern",
  [sym_spread_element] = "spread_element",
  [sym_ternary_expression] = "ternary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_update_expression] = "update_expression",
  [sym_sequence_expression] = "sequence_expression",
  [sym_string] = "string",
  [sym_template_string] = "template_string",
  [sym_template_substitution] = "template_substitution",
  [sym_regex] = "regex",
  [sym_meta_property] = "meta_property",
  [sym_arguments] = "arguments",
  [sym_decorator] = "decorator",
  [sym_decorator_member_expression] = "member_expression",
  [sym_decorator_call_expression] = "call_expression",
  [sym_class_body] = "class_body",
  [sym_formal_parameters] = "formal_parameters",
  [sym_class_static_block] = "class_static_block",
  [sym_pattern] = "pattern",
  [sym_rest_pattern] = "rest_pattern",
  [sym_method_definition] = "method_definition",
  [sym_pair] = "pair",
  [sym_pair_pattern] = "pair_pattern",
  [sym__property_name] = "_property_name",
  [sym_computed_property_name] = "computed_property_name",
  [sym_public_field_definition] = "public_field_definition",
  [sym__import_identifier] = "_import_identifier",
  [sym_non_null_expression] = "non_null_expression",
  [sym_method_signature] = "method_signature",
  [sym_abstract_method_signature] = "abstract_method_signature",
  [sym_function_signature] = "function_signature",
  [sym_decorator_parenthesized_expression] = "parenthesized_expression",
  [sym_as_expression] = "as_expression",
  [sym_satisfies_expression] = "satisfies_expression",
  [sym_instantiation_expression] = "instantiation_expression",
  [sym_import_require_clause] = "import_require_clause",
  [sym_extends_clause] = "extends_clause",
  [sym__extends_clause_single] = "_extends_clause_single",
  [sym_implements_clause] = "implements_clause",
  [sym_ambient_declaration] = "ambient_declaration",
  [sym_abstract_class_declaration] = "abstract_class_declaration",
  [sym_module] = "module",
  [sym_internal_module] = "internal_module",
  [sym__module] = "_module",
  [sym_import_alias] = "import_alias",
  [sym_nested_type_identifier] = "nested_type_identifier",
  [sym_interface_declaration] = "interface_declaration",
  [sym_extends_type_clause] = "extends_type_clause",
  [sym_enum_declaration] = "enum_declaration",
  [sym_enum_body] = "enum_body",
  [sym_enum_assignment] = "enum_assignment",
  [sym_type_alias_declaration] = "type_alias_declaration",
  [sym_accessibility_modifier] = "accessibility_modifier",
  [sym_override_modifier] = "override_modifier",
  [sym_required_parameter] = "required_parameter",
  [sym_optional_parameter] = "optional_parameter",
  [sym__parameter_name] = "_parameter_name",
  [sym_omitting_type_annotation] = "omitting_type_annotation",
  [sym_adding_type_annotation] = "adding_type_annotation",
  [sym_opting_type_annotation] = "opting_type_annotation",
  [sym_type_annotation] = "type_annotation",
  [sym__type_query_member_expression_in_type_annotation] = "member_expression",
  [sym__type_query_call_expression_in_type_annotation] = "call_expression",
  [sym_asserts] = "asserts",
  [sym_asserts_annotation] = "asserts_annotation",
  [sym_type] = "type",
  [sym_tuple_parameter] = "required_parameter",
  [sym_optional_tuple_parameter] = "optional_parameter",
  [sym_optional_type] = "optional_type",
  [sym_rest_type] = "rest_type",
  [sym__tuple_type_member] = "_tuple_type_member",
  [sym_constructor_type] = "constructor_type",
  [sym_primary_type] = "primary_type",
  [sym_template_type] = "template_type",
  [sym_template_literal_type] = "template_literal_type",
  [sym_infer_type] = "infer_type",
  [sym_conditional_type] = "conditional_type",
  [sym_generic_type] = "generic_type",
  [sym_type_predicate] = "type_predicate",
  [sym_type_predicate_annotation] = "type_predicate_annotation",
  [sym__type_query_member_expression] = "member_expression",
  [sym__type_query_subscript_expression] = "subscript_expression",
  [sym__type_query_call_expression] = "call_expression",
  [sym__type_query_instantiation_expression] = "instantiation_expression",
  [sym_type_query] = "type_query",
  [sym_index_type_query] = "index_type_query",
  [sym_lookup_type] = "lookup_type",
  [sym_mapped_type_clause] = "mapped_type_clause",
  [sym_literal_type] = "literal_type",
  [sym__number] = "unary_expression",
  [sym_existential_type] = "existential_type",
  [sym_flow_maybe_type] = "flow_maybe_type",
  [sym_parenthesized_type] = "parenthesized_type",
  [sym_predefined_type] = "predefined_type",
  [sym_type_arguments] = "type_arguments",
  [sym_object_type] = "object_type",
  [sym_call_signature] = "call_signature",
  [sym_property_signature] = "property_signature",
  [sym_type_parameters] = "type_parameters",
  [sym_type_parameter] = "type_parameter",
  [sym_default_type] = "default_type",
  [sym_constraint] = "constraint",
  [sym_construct_signature] = "construct_signature",
  [sym_index_signature] = "index_signature",
  [sym_array_type] = "array_type",
  [sym_tuple_type] = "tuple_type",
  [sym_readonly_type] = "readonly_type",
  [sym_union_type] = "union_type",
  [sym_intersection_type] = "intersection_type",
  [sym_function_type] = "function_type",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_export_statement_repeat1] = "export_statement_repeat1",
  [aux_sym_export_clause_repeat1] = "export_clause_repeat1",
  [aux_sym_named_imports_repeat1] = "named_imports_repeat1",
  [aux_sym_variable_declaration_repeat1] = "variable_declaration_repeat1",
  [aux_sym_switch_body_repeat1] = "switch_body_repeat1",
  [aux_sym_object_repeat1] = "object_repeat1",
  [aux_sym_object_pattern_repeat1] = "object_pattern_repeat1",
  [aux_sym_array_repeat1] = "array_repeat1",
  [aux_sym_array_pattern_repeat1] = "array_pattern_repeat1",
  [aux_sym_jsx_element_repeat1] = "jsx_element_repeat1",
  [aux_sym__jsx_string_repeat1] = "_jsx_string_repeat1",
  [aux_sym__jsx_string_repeat2] = "_jsx_string_repeat2",
  [aux_sym_sequence_expression_repeat1] = "sequence_expression_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [aux_sym_template_string_repeat1] = "template_string_repeat1",
  [aux_sym_class_body_repeat1] = "class_body_repeat1",
  [aux_sym_formal_parameters_repeat1] = "formal_parameters_repeat1",
  [aux_sym__jsx_start_opening_element_repeat1] = "_jsx_start_opening_element_repeat1",
  [aux_sym_extends_clause_repeat1] = "extends_clause_repeat1",
  [aux_sym_implements_clause_repeat1] = "implements_clause_repeat1",
  [aux_sym_extends_type_clause_repeat1] = "extends_type_clause_repeat1",
  [aux_sym_enum_body_repeat1] = "enum_body_repeat1",
  [aux_sym_template_literal_type_repeat1] = "template_literal_type_repeat1",
  [aux_sym_object_type_repeat1] = "object_type_repeat1",
  [aux_sym_type_parameters_repeat1] = "type_parameters_repeat1",
  [aux_sym_tuple_type_repeat1] = "tuple_type_repeat1",
  [alias_sym_interface_body] = "interface_body",
  [alias_sym_property_identifier] = "property_identifier",
  [alias_sym_shorthand_property_identifier] = "shorthand_property_identifier",
  [alias_sym_shorthand_property_identifier_pattern] = "shorthand_property_identifier_pattern",
  [alias_sym_statement_identifier] = "statement_identifier",
  [alias_sym_this_type] = "this_type",
  [alias_sym_type_identifier] = "type_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_hash_bang_line] = sym_hash_bang_line,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_namespace] = anon_sym_namespace,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_typeof] = anon_sym_typeof,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_await] = anon_sym_await,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_of] = anon_sym_of,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_debugger] = anon_sym_debugger,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_throw] = anon_sym_throw,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_yield] = anon_sym_yield,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [sym_html_character_reference] = sym_html_character_reference,
  [anon_sym_GT] = anon_sym_GT,
  [sym_jsx_identifier] = sym_identifier,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_LT_SLASH] = anon_sym_LT_SLASH,
  [anon_sym_SLASH_GT] = anon_sym_SLASH_GT,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [sym_unescaped_double_jsx_string_fragment] = sym__template_chars,
  [sym_unescaped_single_jsx_string_fragment] = sym__template_chars,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_QMARK_DOT] = anon_sym_QMARK_DOT,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_using] = anon_sym_using,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_GT_GT_GT_EQ] = anon_sym_GT_GT_GT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_STAR_STAR_EQ] = anon_sym_STAR_STAR_EQ,
  [anon_sym_AMP_AMP_EQ] = anon_sym_AMP_AMP_EQ,
  [anon_sym_PIPE_PIPE_EQ] = anon_sym_PIPE_PIPE_EQ,
  [anon_sym_QMARK_QMARK_EQ] = anon_sym_QMARK_QMARK_EQ,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_EQ_EQ_EQ] = anon_sym_EQ_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_BANG_EQ_EQ] = anon_sym_BANG_EQ_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_QMARK_QMARK] = anon_sym_QMARK_QMARK,
  [anon_sym_instanceof] = anon_sym_instanceof,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_void] = anon_sym_void,
  [anon_sym_delete] = anon_sym_delete,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [sym_unescaped_double_string_fragment] = sym__template_chars,
  [sym_unescaped_single_string_fragment] = sym__template_chars,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_comment] = sym_comment,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [anon_sym_SLASH2] = anon_sym_SLASH,
  [sym_regex_pattern] = sym_regex_pattern,
  [sym_regex_flags] = sym_regex_flags,
  [sym_number] = sym_number,
  [sym_private_property_identifier] = sym_private_property_identifier,
  [anon_sym_target] = anon_sym_target,
  [anon_sym_meta] = anon_sym_meta,
  [sym_this] = sym_this,
  [sym_super] = sym_super,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_null] = sym_null,
  [sym_undefined] = sym_undefined,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_readonly] = anon_sym_readonly,
  [anon_sym_get] = anon_sym_get,
  [anon_sym_set] = anon_sym_set,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_declare] = anon_sym_declare,
  [anon_sym_public] = anon_sym_public,
  [anon_sym_private] = anon_sym_private,
  [anon_sym_protected] = anon_sym_protected,
  [anon_sym_override] = anon_sym_override,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_any] = anon_sym_any,
  [anon_sym_number] = anon_sym_number,
  [anon_sym_boolean] = anon_sym_boolean,
  [anon_sym_string] = anon_sym_string,
  [anon_sym_symbol] = anon_sym_symbol,
  [anon_sym_object] = anon_sym_object,
  [anon_sym_abstract] = anon_sym_abstract,
  [anon_sym_accessor] = anon_sym_accessor,
  [anon_sym_satisfies] = anon_sym_satisfies,
  [anon_sym_require] = anon_sym_require,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_implements] = anon_sym_implements,
  [anon_sym_global] = anon_sym_global,
  [anon_sym_interface] = anon_sym_interface,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_DASH_QMARK_COLON] = anon_sym_DASH_QMARK_COLON,
  [anon_sym_PLUS_QMARK_COLON] = anon_sym_PLUS_QMARK_COLON,
  [anon_sym_QMARK_COLON] = anon_sym_QMARK_COLON,
  [anon_sym_asserts] = anon_sym_asserts,
  [anon_sym_infer] = anon_sym_infer,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_keyof] = anon_sym_keyof,
  [anon_sym_unique] = anon_sym_unique,
  [anon_sym_unknown] = anon_sym_unknown,
  [anon_sym_never] = anon_sym_never,
  [anon_sym_LBRACE_PIPE] = anon_sym_LBRACE_PIPE,
  [anon_sym_PIPE_RBRACE] = anon_sym_PIPE_RBRACE,
  [sym__automatic_semicolon] = sym__automatic_semicolon,
  [sym__template_chars] = sym__template_chars,
  [sym__ternary_qmark] = anon_sym_QMARK,
  [sym_html_comment] = sym_html_comment,
  [sym_jsx_text] = sym_jsx_text,
  [sym__function_signature_automatic_semicolon] = sym__function_signature_automatic_semicolon,
  [sym___error_recovery] = sym___error_recovery,
  [sym_program] = sym_program,
  [sym_export_statement] = sym_export_statement,
  [sym_namespace_export] = sym_namespace_export,
  [sym_export_clause] = sym_export_clause,
  [sym_export_specifier] = sym_export_specifier,
  [sym__module_export_name] = sym__module_export_name,
  [sym_declaration] = sym_declaration,
  [sym_import] = sym_import,
  [sym_import_statement] = sym_import_statement,
  [sym_import_clause] = sym_import_clause,
  [sym__from_clause] = sym__from_clause,
  [sym_namespace_import] = sym_namespace_import,
  [sym_named_imports] = sym_named_imports,
  [sym_import_specifier] = sym_import_specifier,
  [sym_import_attribute] = sym_import_attribute,
  [sym_statement] = sym_statement,
  [sym_expression_statement] = sym_expression_statement,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym_lexical_declaration] = sym_lexical_declaration,
  [sym_variable_declarator] = sym_variable_declarator,
  [sym_statement_block] = sym_statement_block,
  [sym_else_clause] = sym_else_clause,
  [sym_if_statement] = sym_if_statement,
  [sym_switch_statement] = sym_switch_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_for_in_statement] = sym_for_in_statement,
  [sym__for_header] = sym__for_header,
  [sym_while_statement] = sym_while_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_with_statement] = sym_with_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_debugger_statement] = sym_debugger_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_throw_statement] = sym_throw_statement,
  [sym_empty_statement] = sym_empty_statement,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym_switch_body] = sym_switch_body,
  [sym_switch_case] = sym_switch_case,
  [sym_switch_default] = sym_switch_default,
  [sym_catch_clause] = sym_catch_clause,
  [sym_finally_clause] = sym_finally_clause,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_expression] = sym_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_yield_expression] = sym_yield_expression,
  [sym_object] = sym_object,
  [sym_object_pattern] = sym_object_pattern,
  [sym_assignment_pattern] = sym_assignment_pattern,
  [sym_object_assignment_pattern] = sym_object_assignment_pattern,
  [sym_array] = sym_array,
  [sym_array_pattern] = sym_array_pattern,
  [sym_jsx_element] = sym_jsx_element,
  [sym_jsx_expression] = sym_jsx_expression,
  [sym_jsx_opening_element] = sym_jsx_opening_element,
  [sym_nested_identifier] = sym_nested_identifier,
  [sym_jsx_namespace_name] = sym_jsx_namespace_name,
  [sym_jsx_closing_element] = sym_jsx_closing_element,
  [sym_jsx_self_closing_element] = sym_jsx_self_closing_element,
  [sym_jsx_attribute] = sym_jsx_attribute,
  [sym__jsx_string] = sym_string,
  [sym_class] = sym_class,
  [sym_class_declaration] = sym_class_declaration,
  [sym_class_heritage] = sym_class_heritage,
  [sym_function_expression] = sym_function_expression,
  [sym_function_declaration] = sym_function_declaration,
  [sym_generator_function] = sym_generator_function,
  [sym_generator_function_declaration] = sym_generator_function_declaration,
  [sym_arrow_function] = sym_arrow_function,
  [sym__call_signature] = sym__call_signature,
  [sym__formal_parameter] = sym__formal_parameter,
  [sym_optional_chain] = sym_optional_chain,
  [sym_call_expression] = sym_call_expression,
  [sym_new_expression] = sym_new_expression,
  [sym_await_expression] = sym_await_expression,
  [sym_member_expression] = sym_member_expression,
  [sym_subscript_expression] = sym_subscript_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym__augmented_assignment_lhs] = sym__augmented_assignment_lhs,
  [sym_augmented_assignment_expression] = sym_augmented_assignment_expression,
  [sym__initializer] = sym__initializer,
  [sym__destructuring_pattern] = sym__destructuring_pattern,
  [sym_spread_element] = sym_spread_element,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym_sequence_expression] = sym_sequence_expression,
  [sym_string] = sym_string,
  [sym_template_string] = sym_template_string,
  [sym_template_substitution] = sym_template_substitution,
  [sym_regex] = sym_regex,
  [sym_meta_property] = sym_meta_property,
  [sym_arguments] = sym_arguments,
  [sym_decorator] = sym_decorator,
  [sym_decorator_member_expression] = sym_member_expression,
  [sym_decorator_call_expression] = sym_call_expression,
  [sym_class_body] = sym_class_body,
  [sym_formal_parameters] = sym_formal_parameters,
  [sym_class_static_block] = sym_class_static_block,
  [sym_pattern] = sym_pattern,
  [sym_rest_pattern] = sym_rest_pattern,
  [sym_method_definition] = sym_method_definition,
  [sym_pair] = sym_pair,
  [sym_pair_pattern] = sym_pair_pattern,
  [sym__property_name] = sym__property_name,
  [sym_computed_property_name] = sym_computed_property_name,
  [sym_public_field_definition] = sym_public_field_definition,
  [sym__import_identifier] = sym__import_identifier,
  [sym_non_null_expression] = sym_non_null_expression,
  [sym_method_signature] = sym_method_signature,
  [sym_abstract_method_signature] = sym_abstract_method_signature,
  [sym_function_signature] = sym_function_signature,
  [sym_decorator_parenthesized_expression] = sym_parenthesized_expression,
  [sym_as_expression] = sym_as_expression,
  [sym_satisfies_expression] = sym_satisfies_expression,
  [sym_instantiation_expression] = sym_instantiation_expression,
  [sym_import_require_clause] = sym_import_require_clause,
  [sym_extends_clause] = sym_extends_clause,
  [sym__extends_clause_single] = sym__extends_clause_single,
  [sym_implements_clause] = sym_implements_clause,
  [sym_ambient_declaration] = sym_ambient_declaration,
  [sym_abstract_class_declaration] = sym_abstract_class_declaration,
  [sym_module] = sym_module,
  [sym_internal_module] = sym_internal_module,
  [sym__module] = sym__module,
  [sym_import_alias] = sym_import_alias,
  [sym_nested_type_identifier] = sym_nested_type_identifier,
  [sym_interface_declaration] = sym_interface_declaration,
  [sym_extends_type_clause] = sym_extends_type_clause,
  [sym_enum_declaration] = sym_enum_declaration,
  [sym_enum_body] = sym_enum_body,
  [sym_enum_assignment] = sym_enum_assignment,
  [sym_type_alias_declaration] = sym_type_alias_declaration,
  [sym_accessibility_modifier] = sym_accessibility_modifier,
  [sym_override_modifier] = sym_override_modifier,
  [sym_required_parameter] = sym_required_parameter,
  [sym_optional_parameter] = sym_optional_parameter,
  [sym__parameter_name] = sym__parameter_name,
  [sym_omitting_type_annotation] = sym_omitting_type_annotation,
  [sym_adding_type_annotation] = sym_adding_type_annotation,
  [sym_opting_type_annotation] = sym_opting_type_annotation,
  [sym_type_annotation] = sym_type_annotation,
  [sym__type_query_member_expression_in_type_annotation] = sym_member_expression,
  [sym__type_query_call_expression_in_type_annotation] = sym_call_expression,
  [sym_asserts] = sym_asserts,
  [sym_asserts_annotation] = sym_asserts_annotation,
  [sym_type] = sym_type,
  [sym_tuple_parameter] = sym_required_parameter,
  [sym_optional_tuple_parameter] = sym_optional_parameter,
  [sym_optional_type] = sym_optional_type,
  [sym_rest_type] = sym_rest_type,
  [sym__tuple_type_member] = sym__tuple_type_member,
  [sym_constructor_type] = sym_constructor_type,
  [sym_primary_type] = sym_primary_type,
  [sym_template_type] = sym_template_type,
  [sym_template_literal_type] = sym_template_literal_type,
  [sym_infer_type] = sym_infer_type,
  [sym_conditional_type] = sym_conditional_type,
  [sym_generic_type] = sym_generic_type,
  [sym_type_predicate] = sym_type_predicate,
  [sym_type_predicate_annotation] = sym_type_predicate_annotation,
  [sym__type_query_member_expression] = sym_member_expression,
  [sym__type_query_subscript_expression] = sym_subscript_expression,
  [sym__type_query_call_expression] = sym_call_expression,
  [sym__type_query_instantiation_expression] = sym_instantiation_expression,
  [sym_type_query] = sym_type_query,
  [sym_index_type_query] = sym_index_type_query,
  [sym_lookup_type] = sym_lookup_type,
  [sym_mapped_type_clause] = sym_mapped_type_clause,
  [sym_literal_type] = sym_literal_type,
  [sym__number] = sym_unary_expression,
  [sym_existential_type] = sym_existential_type,
  [sym_flow_maybe_type] = sym_flow_maybe_type,
  [sym_parenthesized_type] = sym_parenthesized_type,
  [sym_predefined_type] = sym_predefined_type,
  [sym_type_arguments] = sym_type_arguments,
  [sym_object_type] = sym_object_type,
  [sym_call_signature] = sym_call_signature,
  [sym_property_signature] = sym_property_signature,
  [sym_type_parameters] = sym_type_parameters,
  [sym_type_parameter] = sym_type_parameter,
  [sym_default_type] = sym_default_type,
  [sym_constraint] = sym_constraint,
  [sym_construct_signature] = sym_construct_signature,
  [sym_index_signature] = sym_index_signature,
  [sym_array_type] = sym_array_type,
  [sym_tuple_type] = sym_tuple_type,
  [sym_readonly_type] = sym_readonly_type,
  [sym_union_type] = sym_union_type,
  [sym_intersection_type] = sym_intersection_type,
  [sym_function_type] = sym_function_type,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_export_statement_repeat1] = aux_sym_export_statement_repeat1,
  [aux_sym_export_clause_repeat1] = aux_sym_export_clause_repeat1,
  [aux_sym_named_imports_repeat1] = aux_sym_named_imports_repeat1,
  [aux_sym_variable_declaration_repeat1] = aux_sym_variable_declaration_repeat1,
  [aux_sym_switch_body_repeat1] = aux_sym_switch_body_repeat1,
  [aux_sym_object_repeat1] = aux_sym_object_repeat1,
  [aux_sym_object_pattern_repeat1] = aux_sym_object_pattern_repeat1,
  [aux_sym_array_repeat1] = aux_sym_array_repeat1,
  [aux_sym_array_pattern_repeat1] = aux_sym_array_pattern_repeat1,
  [aux_sym_jsx_element_repeat1] = aux_sym_jsx_element_repeat1,
  [aux_sym__jsx_string_repeat1] = aux_sym__jsx_string_repeat1,
  [aux_sym__jsx_string_repeat2] = aux_sym__jsx_string_repeat2,
  [aux_sym_sequence_expression_repeat1] = aux_sym_sequence_expression_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [aux_sym_template_string_repeat1] = aux_sym_template_string_repeat1,
  [aux_sym_class_body_repeat1] = aux_sym_class_body_repeat1,
  [aux_sym_formal_parameters_repeat1] = aux_sym_formal_parameters_repeat1,
  [aux_sym__jsx_start_opening_element_repeat1] = aux_sym__jsx_start_opening_element_repeat1,
  [aux_sym_extends_clause_repeat1] = aux_sym_extends_clause_repeat1,
  [aux_sym_implements_clause_repeat1] = aux_sym_implements_clause_repeat1,
  [aux_sym_extends_type_clause_repeat1] = aux_sym_extends_type_clause_repeat1,
  [aux_sym_enum_body_repeat1] = aux_sym_enum_body_repeat1,
  [aux_sym_template_literal_type_repeat1] = aux_sym_template_literal_type_repeat1,
  [aux_sym_object_type_repeat1] = aux_sym_object_type_repeat1,
  [aux_sym_type_parameters_repeat1] = aux_sym_type_parameters_repeat1,
  [aux_sym_tuple_type_repeat1] = aux_sym_tuple_type_repeat1,
  [alias_sym_interface_body] = alias_sym_interface_body,
  [alias_sym_property_identifier] = alias_sym_property_identifier,
  [alias_sym_shorthand_property_identifier] = alias_sym_shorthand_property_identifier,
  [alias_sym_shorthand_property_identifier_pattern] = alias_sym_shorthand_property_identifier_pattern,
  [alias_sym_statement_identifier] = alias_sym_statement_identifier,
  [alias_sym_this_type] = alias_sym_this_type,
  [alias_sym_type_identifier] = alias_sym_type_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_hash_bang_line] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_namespace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typeof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_of] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_debugger] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [sym_html_character_reference] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [sym_jsx_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_unescaped_double_jsx_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_unescaped_single_jsx_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_using] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_instanceof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_void] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delete] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [sym_unescaped_double_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_unescaped_single_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH2] = {
    .visible = true,
    .named = false,
  },
  [sym_regex_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_regex_flags] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_private_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_target] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_meta] = {
    .visible = true,
    .named = false,
  },
  [sym_this] = {
    .visible = true,
    .named = true,
  },
  [sym_super] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_undefined] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_readonly] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_get] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_declare] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_public] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_protected] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_override] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_any] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_number] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_boolean] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_string] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_symbol] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_object] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_abstract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_accessor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_satisfies] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_require] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_implements] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_global] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_QMARK_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_QMARK_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_asserts] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_infer] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_keyof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unique] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unknown] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_never] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [sym__automatic_semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym__template_chars] = {
    .visible = true,
    .named = true,
  },
  [sym__ternary_qmark] = {
    .visible = true,
    .named = false,
  },
  [sym_html_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_text] = {
    .visible = true,
    .named = true,
  },
  [sym__function_signature_automatic_semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym___error_recovery] = {
    .visible = false,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_export_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace_export] = {
    .visible = true,
    .named = true,
  },
  [sym_export_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_export_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym__module_export_name] = {
    .visible = false,
    .named = true,
  },
  [sym_declaration] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__from_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_namespace_import] = {
    .visible = true,
    .named = true,
  },
  [sym_named_imports] = {
    .visible = true,
    .named = true,
  },
  [sym_import_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_import_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_lexical_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_statement_block] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_in_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__for_header] = {
    .visible = false,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_with_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_debugger_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_empty_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_body] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_case] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_default] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_yield_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_object] = {
    .visible = true,
    .named = true,
  },
  [sym_object_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_object_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_array_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_element] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_opening_element] = {
    .visible = true,
    .named = true,
  },
  [sym_nested_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_namespace_name] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_closing_element] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_self_closing_element] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym__jsx_string] = {
    .visible = true,
    .named = true,
  },
  [sym_class] = {
    .visible = true,
    .named = true,
  },
  [sym_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_class_heritage] = {
    .visible = true,
    .named = true,
  },
  [sym_function_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_arrow_function] = {
    .visible = true,
    .named = true,
  },
  [sym__call_signature] = {
    .visible = false,
    .named = true,
  },
  [sym__formal_parameter] = {
    .visible = false,
    .named = true,
  },
  [sym_optional_chain] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_new_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_await_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__augmented_assignment_lhs] = {
    .visible = false,
    .named = true,
  },
  [sym_augmented_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__initializer] = {
    .visible = false,
    .named = true,
  },
  [sym__destructuring_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_spread_element] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym_regex] = {
    .visible = true,
    .named = true,
  },
  [sym_meta_property] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_class_static_block] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_rest_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_method_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_pair_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__property_name] = {
    .visible = false,
    .named = true,
  },
  [sym_computed_property_name] = {
    .visible = true,
    .named = true,
  },
  [sym_public_field_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__import_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_non_null_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_method_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_method_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_function_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_as_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_satisfies_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_instantiation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_import_require_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_extends_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__extends_clause_single] = {
    .visible = false,
    .named = true,
  },
  [sym_implements_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_ambient_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym_internal_module] = {
    .visible = true,
    .named = true,
  },
  [sym__module] = {
    .visible = false,
    .named = true,
  },
  [sym_import_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_nested_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_extends_type_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_type_alias_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_accessibility_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_override_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_required_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__parameter_name] = {
    .visible = false,
    .named = true,
  },
  [sym_omitting_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_adding_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_opting_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_member_expression_in_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_call_expression_in_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_asserts] = {
    .visible = true,
    .named = true,
  },
  [sym_asserts_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_tuple_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_tuple_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_type] = {
    .visible = true,
    .named = true,
  },
  [sym_rest_type] = {
    .visible = true,
    .named = true,
  },
  [sym__tuple_type_member] = {
    .visible = false,
    .named = true,
  },
  [sym_constructor_type] = {
    .visible = true,
    .named = true,
  },
  [sym_primary_type] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_template_type] = {
    .visible = true,
    .named = true,
  },
  [sym_template_literal_type] = {
    .visible = true,
    .named = true,
  },
  [sym_infer_type] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_type] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_predicate] = {
    .visible = true,
    .named = true,
  },
  [sym_type_predicate_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_instantiation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_query] = {
    .visible = true,
    .named = true,
  },
  [sym_index_type_query] = {
    .visible = true,
    .named = true,
  },
  [sym_lookup_type] = {
    .visible = true,
    .named = true,
  },
  [sym_mapped_type_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_literal_type] = {
    .visible = true,
    .named = true,
  },
  [sym__number] = {
    .visible = true,
    .named = true,
  },
  [sym_existential_type] = {
    .visible = true,
    .named = true,
  },
  [sym_flow_maybe_type] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_type] = {
    .visible = true,
    .named = true,
  },
  [sym_predefined_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_object_type] = {
    .visible = true,
    .named = true,
  },
  [sym_call_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_property_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_default_type] = {
    .visible = true,
    .named = true,
  },
  [sym_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_construct_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_index_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_readonly_type] = {
    .visible = true,
    .named = true,
  },
  [sym_union_type] = {
    .visible = true,
    .named = true,
  },
  [sym_intersection_type] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_named_imports_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_jsx_element_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__jsx_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__jsx_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sequence_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__jsx_start_opening_element_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_extends_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_implements_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_extends_type_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_literal_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_interface_body] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier_pattern] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_statement_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_this_type] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_alias = 1,
  field_alternative = 2,
  field_argument = 3,
  field_arguments = 4,
  field_attribute = 5,
  field_body = 6,
  field_close_tag = 7,
  field_condition = 8,
  field_consequence = 9,
  field_constraint = 10,
  field_constructor = 11,
  field_declaration = 12,
  field_decorator = 13,
  field_finalizer = 14,
  field_flags = 15,
  field_function = 16,
  field_handler = 17,
  field_increment = 18,
  field_index = 19,
  field_index_type = 20,
  field_initializer = 21,
  field_key = 22,
  field_kind = 23,
  field_label = 24,
  field_left = 25,
  field_module = 26,
  field_name = 27,
  field_object = 28,
  field_open_tag = 29,
  field_operator = 30,
  field_optional_chain = 31,
  field_parameter = 32,
  field_parameters = 33,
  field_pattern = 34,
  field_property = 35,
  field_return_type = 36,
  field_right = 37,
  field_sign = 38,
  field_source = 39,
  field_type = 40,
  field_type_arguments = 41,
  field_type_parameters = 42,
  field_value = 43,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_attribute] = "attribute",
  [field_body] = "body",
  [field_close_tag] = "close_tag",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_constraint] = "constraint",
  [field_constructor] = "constructor",
  [field_declaration] = "declaration",
  [field_decorator] = "decorator",
  [field_finalizer] = "finalizer",
  [field_flags] = "flags",
  [field_function] = "function",
  [field_handler] = "handler",
  [field_increment] = "increment",
  [field_index] = "index",
  [field_index_type] = "index_type",
  [field_initializer] = "initializer",
  [field_key] = "key",
  [field_kind] = "kind",
  [field_label] = "label",
  [field_left] = "left",
  [field_module] = "module",
  [field_name] = "name",
  [field_object] = "object",
  [field_open_tag] = "open_tag",
  [field_operator] = "operator",
  [field_optional_chain] = "optional_chain",
  [field_parameter] = "parameter",
  [field_parameters] = "parameters",
  [field_pattern] = "pattern",
  [field_property] = "property",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_sign] = "sign",
  [field_source] = "source",
  [field_type] = "type",
  [field_type_arguments] = "type_arguments",
  [field_type_parameters] = "type_parameters",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [4] = {.index = 2, .length = 1},
  [5] = {.index = 3, .length = 1},
  [6] = {.index = 4, .length = 2},
  [8] = {.index = 6, .length = 2},
  [9] = {.index = 8, .length = 1},
  [10] = {.index = 9, .length = 2},
  [11] = {.index = 11, .length = 1},
  [12] = {.index = 12, .length = 1},
  [13] = {.index = 3, .length = 1},
  [14] = {.index = 13, .length = 2},
  [15] = {.index = 15, .length = 2},
  [16] = {.index = 17, .length = 1},
  [17] = {.index = 18, .length = 2},
  [18] = {.index = 20, .length = 2},
  [19] = {.index = 22, .length = 2},
  [20] = {.index = 24, .length = 2},
  [21] = {.index = 26, .length = 1},
  [22] = {.index = 27, .length = 2},
  [23] = {.index = 29, .length = 2},
  [24] = {.index = 31, .length = 2},
  [25] = {.index = 33, .length = 2},
  [29] = {.index = 35, .length = 1},
  [30] = {.index = 36, .length = 2},
  [31] = {.index = 38, .length = 2},
  [32] = {.index = 40, .length = 2},
  [33] = {.index = 42, .length = 1},
  [34] = {.index = 43, .length = 2},
  [35] = {.index = 45, .length = 2},
  [36] = {.index = 47, .length = 6},
  [37] = {.index = 53, .length = 1},
  [38] = {.index = 54, .length = 3},
  [39] = {.index = 57, .length = 3},
  [40] = {.index = 60, .length = 2},
  [41] = {.index = 62, .length = 2},
  [42] = {.index = 64, .length = 2},
  [43] = {.index = 66, .length = 2},
  [44] = {.index = 68, .length = 1},
  [45] = {.index = 69, .length = 2},
  [46] = {.index = 71, .length = 1},
  [47] = {.index = 72, .length = 2},
  [50] = {.index = 74, .length = 2},
  [51] = {.index = 76, .length = 2},
  [52] = {.index = 78, .length = 2},
  [53] = {.index = 80, .length = 1},
  [54] = {.index = 81, .length = 2},
  [55] = {.index = 83, .length = 4},
  [56] = {.index = 87, .length = 2},
  [57] = {.index = 89, .length = 2},
  [58] = {.index = 91, .length = 1},
  [59] = {.index = 91, .length = 1},
  [60] = {.index = 92, .length = 1},
  [61] = {.index = 93, .length = 2},
  [62] = {.index = 95, .length = 2},
  [63] = {.index = 91, .length = 1},
  [64] = {.index = 27, .length = 2},
  [65] = {.index = 31, .length = 2},
  [66] = {.index = 97, .length = 3},
  [67] = {.index = 69, .length = 2},
  [68] = {.index = 69, .length = 2},
  [69] = {.index = 100, .length = 2},
  [70] = {.index = 100, .length = 2},
  [71] = {.index = 102, .length = 3},
  [72] = {.index = 102, .length = 3},
  [73] = {.index = 105, .length = 3},
  [74] = {.index = 108, .length = 2},
  [75] = {.index = 110, .length = 2},
  [76] = {.index = 112, .length = 4},
  [77] = {.index = 116, .length = 3},
  [78] = {.index = 119, .length = 2},
  [79] = {.index = 121, .length = 2},
  [80] = {.index = 123, .length = 1},
  [81] = {.index = 124, .length = 1},
  [82] = {.index = 100, .length = 2},
  [83] = {.index = 27, .length = 2},
  [84] = {.index = 125, .length = 2},
  [85] = {.index = 127, .length = 5},
  [86] = {.index = 132, .length = 1},
  [87] = {.index = 133, .length = 1},
  [88] = {.index = 134, .length = 2},
  [89] = {.index = 136, .length = 3},
  [90] = {.index = 139, .length = 2},
  [91] = {.index = 141, .length = 3},
  [92] = {.index = 144, .length = 6},
  [93] = {.index = 150, .length = 1},
  [94] = {.index = 151, .length = 1},
  [95] = {.index = 152, .length = 3},
  [96] = {.index = 155, .length = 3},
  [97] = {.index = 158, .length = 4},
  [98] = {.index = 162, .length = 2},
  [99] = {.index = 164, .length = 2},
  [100] = {.index = 166, .length = 3},
  [101] = {.index = 169, .length = 4},
  [102] = {.index = 173, .length = 1},
  [103] = {.index = 174, .length = 2},
  [104] = {.index = 176, .length = 1},
  [105] = {.index = 177, .length = 2},
  [106] = {.index = 179, .length = 3},
  [107] = {.index = 182, .length = 2},
  [108] = {.index = 184, .length = 4},
  [109] = {.index = 188, .length = 3},
  [110] = {.index = 191, .length = 2},
  [111] = {.index = 193, .length = 2},
  [112] = {.index = 195, .length = 2},
  [113] = {.index = 197, .length = 2},
  [114] = {.index = 199, .length = 2},
  [117] = {.index = 199, .length = 2},
  [118] = {.index = 201, .length = 4},
  [119] = {.index = 205, .length = 2},
  [120] = {.index = 207, .length = 2},
  [121] = {.index = 209, .length = 4},
  [122] = {.index = 207, .length = 2},
  [123] = {.index = 213, .length = 4},
  [124] = {.index = 217, .length = 4},
  [125] = {.index = 221, .length = 5},
  [126] = {.index = 226, .length = 3},
  [127] = {.index = 229, .length = 2},
  [128] = {.index = 229, .length = 2},
  [129] = {.index = 231, .length = 2},
  [130] = {.index = 233, .length = 2},
  [131] = {.index = 235, .length = 2},
  [132] = {.index = 237, .length = 2},
  [133] = {.index = 239, .length = 2},
  [134] = {.index = 241, .length = 2},
  [135] = {.index = 243, .length = 3},
  [136] = {.index = 241, .length = 2},
  [137] = {.index = 237, .length = 2},
  [138] = {.index = 139, .length = 2},
  [139] = {.index = 246, .length = 1},
  [140] = {.index = 246, .length = 1},
  [141] = {.index = 177, .length = 2},
  [142] = {.index = 179, .length = 3},
  [143] = {.index = 247, .length = 2},
  [144] = {.index = 249, .length = 3},
  [145] = {.index = 252, .length = 2},
  [146] = {.index = 254, .length = 3},
  [147] = {.index = 257, .length = 2},
  [148] = {.index = 259, .length = 3},
  [149] = {.index = 262, .length = 1},
  [150] = {.index = 263, .length = 2},
  [151] = {.index = 265, .length = 2},
  [152] = {.index = 267, .length = 5},
  [153] = {.index = 263, .length = 2},
  [154] = {.index = 272, .length = 1},
  [155] = {.index = 273, .length = 4},
  [156] = {.index = 277, .length = 2},
  [157] = {.index = 279, .length = 1},
  [158] = {.index = 280, .length = 2},
  [159] = {.index = 282, .length = 2},
  [160] = {.index = 284, .length = 2},
  [161] = {.index = 286, .length = 4},
  [162] = {.index = 290, .length = 2},
  [163] = {.index = 292, .length = 3},
  [164] = {.index = 295, .length = 3},
  [165] = {.index = 298, .length = 3},
  [166] = {.index = 301, .length = 4},
  [167] = {.index = 305, .length = 1},
  [168] = {.index = 306, .length = 2},
  [169] = {.index = 308, .length = 4},
  [170] = {.index = 312, .length = 4},
  [171] = {.index = 316, .length = 4},
  [172] = {.index = 320, .length = 2},
  [173] = {.index = 322, .length = 2},
  [174] = {.index = 324, .length = 4},
  [175] = {.index = 324, .length = 4},
  [176] = {.index = 328, .length = 4},
  [177] = {.index = 328, .length = 4},
  [178] = {.index = 332, .length = 4},
  [179] = {.index = 336, .length = 4},
  [180] = {.index = 340, .length = 5},
  [181] = {.index = 345, .length = 3},
  [182] = {.index = 348, .length = 3},
  [183] = {.index = 348, .length = 3},
  [184] = {.index = 351, .length = 2},
  [185] = {.index = 353, .length = 3},
  [186] = {.index = 356, .length = 2},
  [187] = {.index = 356, .length = 2},
  [188] = {.index = 298, .length = 3},
  [189] = {.index = 358, .length = 3},
  [190] = {.index = 361, .length = 3},
  [191] = {.index = 134, .length = 2},
  [192] = {.index = 364, .length = 2},
  [193] = {.index = 366, .length = 3},
  [194] = {.index = 369, .length = 4},
  [195] = {.index = 373, .length = 3},
  [196] = {.index = 376, .length = 3},
  [197] = {.index = 379, .length = 2},
  [198] = {.index = 381, .length = 3},
  [199] = {.index = 384, .length = 5},
  [200] = {.index = 379, .length = 2},
  [201] = {.index = 389, .length = 3},
  [202] = {.index = 389, .length = 3},
  [203] = {.index = 392, .length = 3},
  [204] = {.index = 395, .length = 2},
  [205] = {.index = 397, .length = 4},
  [206] = {.index = 134, .length = 2},
  [207] = {.index = 401, .length = 1},
  [208] = {.index = 402, .length = 2},
  [209] = {.index = 404, .length = 2},
  [210] = {.index = 406, .length = 2},
  [211] = {.index = 408, .length = 2},
  [212] = {.index = 410, .length = 3},
  [213] = {.index = 413, .length = 1},
  [214] = {.index = 414, .length = 3},
  [215] = {.index = 417, .length = 2},
  [216] = {.index = 419, .length = 3},
  [217] = {.index = 422, .length = 3},
  [218] = {.index = 425, .length = 3},
  [219] = {.index = 428, .length = 3},
  [220] = {.index = 431, .length = 4},
  [221] = {.index = 435, .length = 2},
  [222] = {.index = 437, .length = 2},
  [223] = {.index = 439, .length = 1},
  [224] = {.index = 440, .length = 4},
  [225] = {.index = 440, .length = 4},
  [226] = {.index = 444, .length = 2},
  [227] = {.index = 446, .length = 3},
  [228] = {.index = 449, .length = 5},
  [229] = {.index = 454, .length = 3},
  [230] = {.index = 457, .length = 2},
  [231] = {.index = 459, .length = 2},
  [232] = {.index = 461, .length = 2},
  [233] = {.index = 463, .length = 1},
  [234] = {.index = 464, .length = 4},
  [235] = {.index = 468, .length = 3},
  [236] = {.index = 471, .length = 4},
  [237] = {.index = 475, .length = 5},
  [238] = {.index = 480, .length = 1},
  [239] = {.index = 481, .length = 2},
  [240] = {.index = 483, .length = 4},
  [241] = {.index = 487, .length = 4},
  [242] = {.index = 491, .length = 4},
  [243] = {.index = 495, .length = 3},
  [244] = {.index = 498, .length = 2},
  [245] = {.index = 500, .length = 4},
  [246] = {.index = 504, .length = 4},
  [247] = {.index = 508, .length = 2},
  [248] = {.index = 510, .length = 2},
  [249] = {.index = 512, .length = 3},
  [250] = {.index = 515, .length = 3},
  [251] = {.index = 518, .length = 2},
  [252] = {.index = 520, .length = 2},
  [253] = {.index = 522, .length = 1},
  [254] = {.index = 523, .length = 1},
  [255] = {.index = 524, .length = 3},
  [256] = {.index = 527, .length = 3},
  [257] = {.index = 530, .length = 3},
  [258] = {.index = 533, .length = 3},
  [259] = {.index = 536, .length = 4},
  [260] = {.index = 540, .length = 2},
  [261] = {.index = 542, .length = 4},
  [262] = {.index = 546, .length = 3},
  [263] = {.index = 549, .length = 2},
  [264] = {.index = 551, .length = 2},
  [265] = {.index = 553, .length = 4},
  [266] = {.index = 557, .length = 4},
  [267] = {.index = 561, .length = 4},
  [268] = {.index = 565, .length = 3},
  [269] = {.index = 568, .length = 2},
  [271] = {.index = 570, .length = 4},
  [272] = {.index = 574, .length = 5},
  [273] = {.index = 579, .length = 5},
  [274] = {.index = 584, .length = 5},
  [275] = {.index = 589, .length = 4},
  [276] = {.index = 593, .length = 5},
  [277] = {.index = 598, .length = 4},
  [278] = {.index = 602, .length = 4},
  [279] = {.index = 606, .length = 3},
  [280] = {.index = 609, .length = 3},
  [281] = {.index = 612, .length = 3},
  [282] = {.index = 609, .length = 3},
  [283] = {.index = 615, .length = 2},
  [284] = {.index = 617, .length = 4},
  [285] = {.index = 621, .length = 4},
  [286] = {.index = 625, .length = 3},
  [287] = {.index = 628, .length = 2},
  [288] = {.index = 630, .length = 2},
  [289] = {.index = 632, .length = 3},
  [290] = {.index = 635, .length = 2},
  [291] = {.index = 637, .length = 2},
  [292] = {.index = 639, .length = 1},
  [293] = {.index = 640, .length = 3},
  [294] = {.index = 643, .length = 3},
  [295] = {.index = 646, .length = 4},
  [296] = {.index = 650, .length = 4},
  [297] = {.index = 654, .length = 3},
  [298] = {.index = 657, .length = 3},
  [299] = {.index = 660, .length = 2},
  [300] = {.index = 662, .length = 3},
  [301] = {.index = 665, .length = 2},
  [302] = {.index = 667, .length = 4},
  [303] = {.index = 671, .length = 4},
  [304] = {.index = 675, .length = 4},
  [305] = {.index = 679, .length = 3},
  [306] = {.index = 682, .length = 5},
  [307] = {.index = 687, .length = 5},
  [308] = {.index = 692, .length = 5},
  [309] = {.index = 697, .length = 4},
  [310] = {.index = 701, .length = 4},
  [311] = {.index = 705, .length = 3},
  [312] = {.index = 708, .length = 3},
  [313] = {.index = 708, .length = 3},
  [314] = {.index = 711, .length = 2},
  [315] = {.index = 713, .length = 2},
  [316] = {.index = 715, .length = 3},
  [317] = {.index = 718, .length = 2},
  [318] = {.index = 720, .length = 2},
  [319] = {.index = 722, .length = 4},
  [320] = {.index = 726, .length = 3},
  [321] = {.index = 729, .length = 3},
  [322] = {.index = 732, .length = 4},
  [323] = {.index = 736, .length = 3},
  [324] = {.index = 739, .length = 3},
  [325] = {.index = 742, .length = 2},
  [326] = {.index = 744, .length = 4},
  [327] = {.index = 748, .length = 5},
  [328] = {.index = 753, .length = 5},
  [329] = {.index = 758, .length = 4},
  [330] = {.index = 758, .length = 4},
  [331] = {.index = 762, .length = 4},
  [332] = {.index = 766, .length = 3},
  [333] = {.index = 769, .length = 2},
  [334] = {.index = 771, .length = 2},
  [335] = {.index = 773, .length = 3},
  [336] = {.index = 776, .length = 4},
  [337] = {.index = 780, .length = 4},
  [338] = {.index = 784, .length = 3},
  [339] = {.index = 787, .length = 3},
  [340] = {.index = 790, .length = 4},
  [341] = {.index = 794, .length = 3},
  [342] = {.index = 797, .length = 3},
  [343] = {.index = 800, .length = 5},
  [344] = {.index = 805, .length = 3},
  [345] = {.index = 808, .length = 4},
  [346] = {.index = 812, .length = 4},
  [347] = {.index = 816, .length = 3},
  [348] = {.index = 819, .length = 3},
  [349] = {.index = 822, .length = 4},
  [350] = {.index = 826, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_decorator, 0},
  [1] =
    {field_parameters, 0},
  [2] =
    {field_declaration, 1},
  [3] =
    {field_name, 0},
  [4] =
    {field_body, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [6] =
    {field_argument, 1},
    {field_operator, 0},
  [8] =
    {field_pattern, 0},
  [9] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
  [11] =
    {field_body, 1},
  [12] =
    {field_constructor, 1},
  [13] =
    {field_arguments, 1},
    {field_function, 0},
  [15] =
    {field_argument, 0},
    {field_operator, 1},
  [17] =
    {field_type_arguments, 1},
  [18] =
    {field_close_tag, 1},
    {field_open_tag, 0},
  [20] =
    {field_parameters, 0},
    {field_return_type, 1},
  [22] =
    {field_parameters, 1},
    {field_type_parameters, 0},
  [24] =
    {field_decorator, 0, .inherited = true},
    {field_decorator, 1, .inherited = true},
  [26] =
    {field_declaration, 2},
  [27] =
    {field_left, 0},
    {field_right, 2},
  [29] =
    {field_body, 2},
    {field_label, 0},
  [31] =
    {field_body, 2},
    {field_parameter, 0},
  [33] =
    {field_body, 1},
    {field_name, 0},
  [35] =
    {field_source, 1},
  [36] =
    {field_body, 2},
    {field_object, 1},
  [38] =
    {field_name, 0},
    {field_value, 1, .inherited = true},
  [40] =
    {field_name, 0},
    {field_type, 1},
  [42] =
    {field_kind, 0},
  [43] =
    {field_condition, 1},
    {field_consequence, 2},
  [45] =
    {field_body, 2},
    {field_value, 1},
  [47] =
    {field_body, 2},
    {field_kind, 1, .inherited = true},
    {field_left, 1, .inherited = true},
    {field_operator, 1, .inherited = true},
    {field_right, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [53] =
    {field_pattern, 1},
  [54] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [57] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_type, 1},
  [60] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 1},
  [62] =
    {field_body, 2},
    {field_condition, 1},
  [64] =
    {field_body, 1},
    {field_handler, 2},
  [66] =
    {field_body, 1},
    {field_finalizer, 2},
  [68] =
    {field_label, 1},
  [69] =
    {field_body, 2},
    {field_name, 1},
  [71] =
    {field_value, 0},
  [72] =
    {field_type_arguments, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [74] =
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
  [76] =
    {field_arguments, 0, .inherited = true},
    {field_function, 0, .inherited = true},
  [78] =
    {field_argument, 0, .inherited = true},
    {field_operator, 0, .inherited = true},
  [80] =
    {field_body, 2},
  [81] =
    {field_body, 2},
    {field_type_parameters, 1},
  [83] =
    {field_body, 2},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [87] =
    {field_arguments, 2},
    {field_constructor, 1},
  [89] =
    {field_constructor, 1},
    {field_type_arguments, 2},
  [91] =
    {field_name, 1},
  [92] =
    {field_attribute, 0},
  [93] =
    {field_name, 0},
    {field_value, 1},
  [95] =
    {field_constraint, 1},
    {field_name, 0},
  [97] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [100] =
    {field_object, 0},
    {field_property, 2},
  [102] =
    {field_object, 0},
    {field_optional_chain, 1},
    {field_property, 2},
  [105] =
    {field_arguments, 2},
    {field_function, 0},
    {field_type_arguments, 1},
  [108] =
    {field_arguments, 2},
    {field_function, 0},
  [110] =
    {field_close_tag, 2},
    {field_open_tag, 0},
  [112] =
    {field_body, 2},
    {field_parameters, 0, .inherited = true},
    {field_return_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [116] =
    {field_parameters, 1},
    {field_return_type, 2},
    {field_type_parameters, 0},
  [119] =
    {field_declaration, 2},
    {field_decorator, 0, .inherited = true},
  [121] =
    {field_body, 2},
    {field_decorator, 0, .inherited = true},
  [123] =
    {field_source, 2, .inherited = true},
  [124] =
    {field_value, 2},
  [125] =
    {field_key, 0},
    {field_value, 2},
  [127] =
    {field_body, 2},
    {field_name, 0},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [132] =
    {field_source, 2},
  [133] =
    {field_value, 1},
  [134] =
    {field_name, 0},
    {field_type, 2},
  [136] =
    {field_name, 0},
    {field_type, 1},
    {field_value, 2, .inherited = true},
  [139] =
    {field_body, 3},
    {field_name, 2},
  [141] =
    {field_alternative, 3},
    {field_condition, 1},
    {field_consequence, 2},
  [144] =
    {field_body, 3},
    {field_kind, 2, .inherited = true},
    {field_left, 2, .inherited = true},
    {field_operator, 2, .inherited = true},
    {field_right, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [150] =
    {field_type, 2},
  [151] =
    {field_pattern, 2},
  [152] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_value, 2, .inherited = true},
  [155] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_type, 2},
  [158] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_type, 1},
    {field_value, 2, .inherited = true},
  [162] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 2},
  [164] =
    {field_body, 1},
    {field_condition, 3},
  [166] =
    {field_body, 1},
    {field_finalizer, 3},
    {field_handler, 2},
  [169] =
    {field_name, 0},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [173] =
    {field_decorator, 0, .inherited = true},
  [174] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
  [176] =
    {field_decorator, 1, .inherited = true},
  [177] =
    {field_body, 3},
    {field_name, 1},
  [179] =
    {field_body, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [182] =
    {field_type_arguments, 1},
    {field_value, 0},
  [184] =
    {field_type_arguments, 1, .inherited = true},
    {field_type_arguments, 2, .inherited = true},
    {field_value, 1, .inherited = true},
    {field_value, 2, .inherited = true},
  [188] =
    {field_parameters, 0, .inherited = true},
    {field_return_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [191] =
    {field_object, 1, .inherited = true},
    {field_property, 1, .inherited = true},
  [193] =
    {field_index, 1, .inherited = true},
    {field_object, 1, .inherited = true},
  [195] =
    {field_arguments, 1, .inherited = true},
    {field_function, 1, .inherited = true},
  [197] =
    {field_function, 1, .inherited = true},
    {field_type_arguments, 1, .inherited = true},
  [199] =
    {field_name, 0},
    {field_type_arguments, 1},
  [201] =
    {field_arguments, 1},
    {field_function, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
  [205] =
    {field_body, 3},
    {field_type_parameters, 1},
  [207] =
    {field_body, 3},
    {field_parameter, 1},
  [209] =
    {field_body, 3},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [213] =
    {field_body, 3},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [217] =
    {field_name, 1},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [221] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [226] =
    {field_arguments, 3},
    {field_constructor, 1},
    {field_type_arguments, 2},
  [229] =
    {field_left, 1},
    {field_right, 3},
  [231] =
    {field_flags, 3},
    {field_pattern, 1},
  [233] =
    {field_name, 1},
    {field_value, 2},
  [235] =
    {field_constraint, 2},
    {field_name, 1},
  [237] =
    {field_attribute, 2, .inherited = true},
    {field_name, 1},
  [239] =
    {field_attribute, 0, .inherited = true},
    {field_attribute, 1, .inherited = true},
  [241] =
    {field_name, 1},
    {field_type_arguments, 2},
  [243] =
    {field_constraint, 1},
    {field_name, 0},
    {field_value, 2},
  [246] =
    {field_type, 1},
  [247] =
    {field_index, 2},
    {field_object, 0},
  [249] =
    {field_arguments, 3},
    {field_function, 0},
    {field_type_arguments, 2},
  [252] =
    {field_declaration, 3},
    {field_decorator, 0, .inherited = true},
  [254] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [257] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
  [259] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_type_parameters, 2},
  [262] =
    {field_source, 3, .inherited = true},
  [263] =
    {field_alias, 2},
    {field_name, 0},
  [265] =
    {field_name, 1},
    {field_value, 3},
  [267] =
    {field_body, 3},
    {field_name, 0},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [272] =
    {field_pattern, 3},
  [273] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_type, 2},
    {field_value, 3, .inherited = true},
  [277] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 3},
  [279] =
    {field_name, 2},
  [280] =
    {field_name, 1},
    {field_value, 2, .inherited = true},
  [282] =
    {field_name, 1},
    {field_type, 2},
  [284] =
    {field_name, 0},
    {field_value, 2, .inherited = true},
  [286] =
    {field_name, 0},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [290] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [292] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_value, 2, .inherited = true},
  [295] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_type, 2},
  [298] =
    {field_body, 4},
    {field_name, 1},
    {field_type_parameters, 2},
  [301] =
    {field_type_arguments, 0, .inherited = true},
    {field_type_arguments, 1, .inherited = true},
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [305] =
    {field_parameters, 1},
  [306] =
    {field_function, 0},
    {field_type_arguments, 1},
  [308] =
    {field_function, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
    {field_type_arguments, 1},
  [312] =
    {field_arguments, 1},
    {field_function, 0},
    {field_index, 0, .inherited = true},
    {field_object, 0, .inherited = true},
  [316] =
    {field_function, 0},
    {field_index, 0, .inherited = true},
    {field_object, 0, .inherited = true},
    {field_type_arguments, 1},
  [320] =
    {field_module, 0},
    {field_name, 2},
  [322] =
    {field_parameters, 0},
    {field_return_type, 2},
  [324] =
    {field_object, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
    {field_property, 2},
  [328] =
    {field_arguments, 0, .inherited = true},
    {field_function, 0, .inherited = true},
    {field_object, 0},
    {field_property, 2},
  [332] =
    {field_body, 4},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [336] =
    {field_name, 2},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [340] =
    {field_body, 4},
    {field_name, 2},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [345] =
    {field_constraint, 2},
    {field_name, 1},
    {field_value, 3},
  [348] =
    {field_attribute, 3, .inherited = true},
    {field_name, 1},
    {field_type_arguments, 2},
  [351] =
    {field_body, 4},
    {field_name, 2},
  [353] =
    {field_body, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [356] =
    {field_type, 1},
    {field_type, 2, .inherited = true},
  [358] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [361] =
    {field_index, 3},
    {field_object, 0},
    {field_optional_chain, 1},
  [364] =
    {field_decorator, 0, .inherited = true},
    {field_value, 3},
  [366] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [369] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type_parameters, 3},
  [373] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_type_parameters, 2},
  [376] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
  [379] =
    {field_alias, 3},
    {field_name, 1},
  [381] =
    {field_name, 1},
    {field_type_parameters, 2},
    {field_value, 4},
  [384] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [389] =
    {field_left, 1},
    {field_operator, 2},
    {field_right, 3},
  [392] =
    {field_body, 5},
    {field_condition, 3},
    {field_initializer, 2},
  [395] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 4},
  [397] =
    {field_name, 1},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [401] =
    {field_type, 3},
  [402] =
    {field_name, 2},
    {field_value, 3, .inherited = true},
  [404] =
    {field_name, 2},
    {field_type, 3},
  [406] =
    {field_name, 1},
    {field_value, 3, .inherited = true},
  [408] =
    {field_name, 1},
    {field_type, 3},
  [410] =
    {field_name, 1},
    {field_type, 2},
    {field_value, 3, .inherited = true},
  [413] =
    {field_name, 3},
  [414] =
    {field_name, 0},
    {field_type, 2},
    {field_value, 3, .inherited = true},
  [417] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
  [419] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_value, 3, .inherited = true},
  [422] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type, 3},
  [425] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_value, 3, .inherited = true},
  [428] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_type, 3},
  [431] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_type, 2},
    {field_value, 3, .inherited = true},
  [435] =
    {field_parameters, 1},
    {field_type, 2},
  [437] =
    {field_parameters, 2},
    {field_type_parameters, 1},
  [439] =
    {field_parameters, 2},
  [440] =
    {field_index, 0, .inherited = true},
    {field_object, 0},
    {field_object, 0, .inherited = true},
    {field_property, 2},
  [444] =
    {field_parameters, 1},
    {field_type, 3},
  [446] =
    {field_parameters, 1},
    {field_return_type, 3},
    {field_type_parameters, 0},
  [449] =
    {field_body, 5},
    {field_name, 3},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [454] =
    {field_body, 5},
    {field_name, 2},
    {field_type_parameters, 3},
  [457] =
    {field_type, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [459] =
    {field_name, 1},
    {field_name, 2, .inherited = true},
  [461] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [463] =
    {field_name, 2, .inherited = true},
  [464] =
    {field_body, 5},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type_parameters, 3},
  [468] =
    {field_body, 5},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
  [471] =
    {field_body, 5},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type_parameters, 4},
  [475] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [480] =
    {field_source, 4},
  [481] =
    {field_body, 3},
    {field_value, 1},
  [483] =
    {field_kind, 1},
    {field_left, 2},
    {field_operator, 3},
    {field_right, 4},
  [487] =
    {field_body, 6},
    {field_condition, 3},
    {field_increment, 4},
    {field_initializer, 2},
  [491] =
    {field_body, 6},
    {field_condition, 3},
    {field_condition, 4},
    {field_initializer, 2},
  [495] =
    {field_body, 6},
    {field_condition, 4},
    {field_initializer, 2},
  [498] =
    {field_body, 4},
    {field_parameter, 2},
  [500] =
    {field_name, 2},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [504] =
    {field_name, 3},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [508] =
    {field_name, 2},
    {field_value, 4, .inherited = true},
  [510] =
    {field_name, 2},
    {field_type, 4},
  [512] =
    {field_name, 2},
    {field_type, 3},
    {field_value, 4, .inherited = true},
  [515] =
    {field_name, 1},
    {field_type, 3},
    {field_value, 4, .inherited = true},
  [518] =
    {field_name, 3},
    {field_value, 4, .inherited = true},
  [520] =
    {field_name, 3},
    {field_type, 4},
  [522] =
    {field_type, 4},
  [523] =
    {field_name, 4},
  [524] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_value, 4, .inherited = true},
  [527] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type, 4},
  [530] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_value, 4, .inherited = true},
  [533] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type, 4},
  [536] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type, 3},
    {field_value, 4, .inherited = true},
  [540] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
  [542] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_type, 3},
    {field_value, 4, .inherited = true},
  [546] =
    {field_parameters, 2},
    {field_type, 3},
    {field_type_parameters, 1},
  [549] =
    {field_parameters, 2},
    {field_type, 3},
  [551] =
    {field_parameters, 3},
    {field_type_parameters, 2},
  [553] =
    {field_index, 2},
    {field_object, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
  [557] =
    {field_index, 0, .inherited = true},
    {field_index, 2},
    {field_object, 0},
    {field_object, 0, .inherited = true},
  [561] =
    {field_arguments, 0, .inherited = true},
    {field_function, 0, .inherited = true},
    {field_index, 2},
    {field_object, 0},
  [565] =
    {field_parameters, 2},
    {field_type, 4},
    {field_type_parameters, 1},
  [568] =
    {field_parameters, 2},
    {field_type, 4},
  [570] =
    {field_body, 6},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type_parameters, 4},
  [574] =
    {field_body, 6},
    {field_name, 3},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [579] =
    {field_body, 6},
    {field_name, 4},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [584] =
    {field_kind, 1},
    {field_left, 2},
    {field_operator, 4},
    {field_right, 5},
    {field_value, 3, .inherited = true},
  [589] =
    {field_kind, 1},
    {field_left, 2},
    {field_operator, 4},
    {field_right, 5},
  [593] =
    {field_body, 7},
    {field_condition, 3},
    {field_condition, 4},
    {field_increment, 5},
    {field_initializer, 2},
  [598] =
    {field_body, 7},
    {field_condition, 4},
    {field_increment, 5},
    {field_initializer, 2},
  [602] =
    {field_body, 7},
    {field_condition, 4},
    {field_condition, 5},
    {field_initializer, 2},
  [606] =
    {field_body, 5},
    {field_parameter, 2},
    {field_type, 3},
  [609] =
    {field_index_type, 3},
    {field_name, 1},
    {field_type, 5},
  [612] =
    {field_alias, 4},
    {field_name, 0},
    {field_type, 2},
  [615] =
    {field_sign, 0},
    {field_type, 5},
  [617] =
    {field_name, 3},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [621] =
    {field_name, 4},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [625] =
    {field_name, 2},
    {field_type, 4},
    {field_value, 5, .inherited = true},
  [628] =
    {field_name, 3},
    {field_value, 5, .inherited = true},
  [630] =
    {field_name, 3},
    {field_type, 5},
  [632] =
    {field_name, 3},
    {field_type, 4},
    {field_value, 5, .inherited = true},
  [635] =
    {field_name, 4},
    {field_value, 5, .inherited = true},
  [637] =
    {field_name, 4},
    {field_type, 5},
  [639] =
    {field_name, 5},
  [640] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_value, 5, .inherited = true},
  [643] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type, 5},
  [646] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type, 4},
    {field_value, 5, .inherited = true},
  [650] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type, 4},
    {field_value, 5, .inherited = true},
  [654] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_value, 5, .inherited = true},
  [657] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_type, 5},
  [660] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
  [662] =
    {field_parameters, 3},
    {field_type, 4},
    {field_type_parameters, 2},
  [665] =
    {field_index, 3},
    {field_object, 0},
  [667] =
    {field_index, 3},
    {field_object, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
  [671] =
    {field_index, 0, .inherited = true},
    {field_index, 3},
    {field_object, 0},
    {field_object, 0, .inherited = true},
  [675] =
    {field_arguments, 0, .inherited = true},
    {field_function, 0, .inherited = true},
    {field_index, 3},
    {field_object, 0},
  [679] =
    {field_parameters, 3},
    {field_type, 5},
    {field_type_parameters, 2},
  [682] =
    {field_body, 7},
    {field_name, 4},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [687] =
    {field_body, 7},
    {field_name, 5},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [692] =
    {field_body, 8},
    {field_condition, 4},
    {field_condition, 5},
    {field_increment, 6},
    {field_initializer, 2},
  [697] =
    {field_name, 4},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [701] =
    {field_name, 5},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [705] =
    {field_name, 3},
    {field_type, 5},
    {field_value, 6, .inherited = true},
  [708] =
    {field_index_type, 4},
    {field_name, 2},
    {field_type, 6},
  [711] =
    {field_name, 4},
    {field_value, 6, .inherited = true},
  [713] =
    {field_name, 4},
    {field_type, 6},
  [715] =
    {field_name, 4},
    {field_type, 5},
    {field_value, 6, .inherited = true},
  [718] =
    {field_name, 5},
    {field_value, 6, .inherited = true},
  [720] =
    {field_name, 5},
    {field_type, 6},
  [722] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type, 5},
    {field_value, 6, .inherited = true},
  [726] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_value, 6, .inherited = true},
  [729] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_type, 6},
  [732] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_type, 5},
    {field_value, 6, .inherited = true},
  [736] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
    {field_value, 6, .inherited = true},
  [739] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
    {field_type, 6},
  [742] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
  [744] =
    {field_alternative, 6},
    {field_consequence, 4},
    {field_left, 0},
    {field_right, 2},
  [748] =
    {field_body, 8},
    {field_name, 5},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
  [753] =
    {field_body, 8},
    {field_name, 6},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
  [758] =
    {field_index_type, 5},
    {field_name, 3},
    {field_sign, 0},
    {field_type, 7},
  [762] =
    {field_name, 5},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
  [766] =
    {field_name, 4},
    {field_type, 6},
    {field_value, 7, .inherited = true},
  [769] =
    {field_name, 5},
    {field_value, 7, .inherited = true},
  [771] =
    {field_name, 5},
    {field_type, 7},
  [773] =
    {field_name, 5},
    {field_type, 6},
    {field_value, 7, .inherited = true},
  [776] =
    {field_name, 6},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
  [780] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_type, 6},
    {field_value, 7, .inherited = true},
  [784] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
    {field_value, 7, .inherited = true},
  [787] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
    {field_type, 7},
  [790] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
    {field_type, 6},
    {field_value, 7, .inherited = true},
  [794] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
    {field_value, 7, .inherited = true},
  [797] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
    {field_type, 7},
  [800] =
    {field_body, 9},
    {field_name, 6},
    {field_parameters, 8, .inherited = true},
    {field_return_type, 8, .inherited = true},
    {field_type_parameters, 8, .inherited = true},
  [805] =
    {field_name, 5},
    {field_type, 7},
    {field_value, 8, .inherited = true},
  [808] =
    {field_name, 6},
    {field_parameters, 8, .inherited = true},
    {field_return_type, 8, .inherited = true},
    {field_type_parameters, 8, .inherited = true},
  [812] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
    {field_type, 7},
    {field_value, 8, .inherited = true},
  [816] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
    {field_value, 8, .inherited = true},
  [819] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
    {field_type, 8},
  [822] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
    {field_type, 7},
    {field_value, 8, .inherited = true},
  [826] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
    {field_type, 8},
    {field_value, 9, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [7] = {
    [0] = alias_sym_property_identifier,
  },
  [13] = {
    [0] = alias_sym_type_identifier,
  },
  [22] = {
    [0] = sym_identifier,
  },
  [23] = {
    [0] = alias_sym_statement_identifier,
  },
  [24] = {
    [0] = sym_identifier,
  },
  [26] = {
    [1] = alias_sym_shorthand_property_identifier,
  },
  [27] = {
    [1] = alias_sym_shorthand_property_identifier_pattern,
  },
  [28] = {
    [1] = sym_identifier,
  },
  [44] = {
    [1] = alias_sym_statement_identifier,
  },
  [45] = {
    [1] = alias_sym_type_identifier,
  },
  [48] = {
    [0] = alias_sym_type_identifier,
  },
  [49] = {
    [0] = alias_sym_this_type,
  },
  [58] = {
    [1] = alias_sym_type_identifier,
  },
  [61] = {
    [0] = alias_sym_type_identifier,
  },
  [62] = {
    [0] = alias_sym_type_identifier,
  },
  [63] = {
    [1] = sym_member_expression,
  },
  [67] = {
    [1] = alias_sym_type_identifier,
    [2] = alias_sym_interface_body,
  },
  [69] = {
    [2] = alias_sym_property_identifier,
  },
  [71] = {
    [2] = alias_sym_property_identifier,
  },
  [82] = {
    [0] = sym_member_expression,
    [2] = alias_sym_property_identifier,
  },
  [83] = {
    [0] = alias_sym_shorthand_property_identifier_pattern,
  },
  [105] = {
    [1] = alias_sym_type_identifier,
  },
  [106] = {
    [1] = alias_sym_type_identifier,
  },
  [114] = {
    [0] = alias_sym_type_identifier,
  },
  [115] = {
    [1] = alias_sym_type_identifier,
  },
  [116] = {
    [1] = anon_sym_unique,
  },
  [120] = {
    [1] = sym_identifier,
  },
  [127] = {
    [1] = sym_identifier,
  },
  [130] = {
    [1] = alias_sym_type_identifier,
  },
  [131] = {
    [1] = alias_sym_type_identifier,
  },
  [135] = {
    [0] = alias_sym_type_identifier,
  },
  [136] = {
    [1] = sym_member_expression,
  },
  [137] = {
    [1] = sym_member_expression,
  },
  [138] = {
    [2] = alias_sym_type_identifier,
  },
  [139] = {
    [1] = alias_sym_type_identifier,
  },
  [141] = {
    [1] = alias_sym_type_identifier,
    [3] = alias_sym_interface_body,
  },
  [142] = {
    [1] = alias_sym_type_identifier,
    [3] = alias_sym_interface_body,
  },
  [146] = {
    [2] = alias_sym_type_identifier,
  },
  [151] = {
    [1] = alias_sym_type_identifier,
  },
  [153] = {
    [0] = sym_identifier,
  },
  [165] = {
    [1] = alias_sym_type_identifier,
  },
  [172] = {
    [2] = alias_sym_type_identifier,
  },
  [174] = {
    [2] = alias_sym_property_identifier,
  },
  [176] = {
    [2] = alias_sym_property_identifier,
  },
  [181] = {
    [1] = alias_sym_type_identifier,
  },
  [183] = {
    [1] = sym_member_expression,
  },
  [184] = {
    [2] = alias_sym_type_identifier,
  },
  [185] = {
    [2] = alias_sym_type_identifier,
  },
  [186] = {
    [1] = alias_sym_type_identifier,
  },
  [188] = {
    [1] = alias_sym_type_identifier,
    [4] = alias_sym_interface_body,
  },
  [191] = {
    [0] = sym_identifier,
  },
  [193] = {
    [2] = alias_sym_type_identifier,
  },
  [194] = {
    [2] = alias_sym_type_identifier,
  },
  [196] = {
    [3] = alias_sym_type_identifier,
  },
  [198] = {
    [1] = alias_sym_type_identifier,
  },
  [200] = {
    [1] = sym_identifier,
  },
  [201] = {
    [1] = sym_identifier,
  },
  [206] = {
    [0] = alias_sym_type_identifier,
  },
  [224] = {
    [2] = alias_sym_property_identifier,
  },
  [229] = {
    [2] = alias_sym_type_identifier,
  },
  [234] = {
    [2] = alias_sym_type_identifier,
  },
  [235] = {
    [3] = alias_sym_type_identifier,
  },
  [236] = {
    [3] = alias_sym_type_identifier,
  },
  [270] = {
    [3] = alias_sym_property_identifier,
  },
  [271] = {
    [3] = alias_sym_type_identifier,
  },
  [280] = {
    [1] = sym_identifier,
  },
  [281] = {
    [0] = alias_sym_type_identifier,
  },
  [312] = {
    [2] = sym_identifier,
  },
  [329] = {
    [3] = sym_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_nested_identifier, 2,
    sym_nested_identifier,
    sym_member_expression,
  sym_predefined_type, 2,
    sym_predefined_type,
    sym_identifier,
  sym_object_type, 2,
    sym_object_type,
    alias_sym_interface_body,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 2,
  [4] = 4,
  [5] = 4,
  [6] = 4,
  [7] = 4,
  [8] = 4,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 16,
  [19] = 16,
  [20] = 17,
  [21] = 16,
  [22] = 17,
  [23] = 17,
  [24] = 16,
  [25] = 17,
  [26] = 16,
  [27] = 17,
  [28] = 17,
  [29] = 16,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 31,
  [45] = 45,
  [46] = 32,
  [47] = 39,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 34,
  [52] = 33,
  [53] = 35,
  [54] = 36,
  [55] = 38,
  [56] = 40,
  [57] = 41,
  [58] = 42,
  [59] = 43,
  [60] = 45,
  [61] = 32,
  [62] = 35,
  [63] = 48,
  [64] = 35,
  [65] = 49,
  [66] = 50,
  [67] = 49,
  [68] = 35,
  [69] = 35,
  [70] = 35,
  [71] = 35,
  [72] = 35,
  [73] = 39,
  [74] = 48,
  [75] = 50,
  [76] = 34,
  [77] = 33,
  [78] = 36,
  [79] = 38,
  [80] = 40,
  [81] = 41,
  [82] = 42,
  [83] = 43,
  [84] = 31,
  [85] = 45,
  [86] = 35,
  [87] = 87,
  [88] = 87,
  [89] = 87,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 91,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 91,
  [100] = 97,
  [101] = 101,
  [102] = 101,
  [103] = 103,
  [104] = 101,
  [105] = 101,
  [106] = 101,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 109,
  [111] = 103,
  [112] = 112,
  [113] = 113,
  [114] = 108,
  [115] = 113,
  [116] = 103,
  [117] = 103,
  [118] = 108,
  [119] = 113,
  [120] = 103,
  [121] = 103,
  [122] = 112,
  [123] = 123,
  [124] = 124,
  [125] = 107,
  [126] = 126,
  [127] = 127,
  [128] = 103,
  [129] = 103,
  [130] = 130,
  [131] = 108,
  [132] = 109,
  [133] = 112,
  [134] = 108,
  [135] = 112,
  [136] = 103,
  [137] = 103,
  [138] = 108,
  [139] = 103,
  [140] = 103,
  [141] = 123,
  [142] = 108,
  [143] = 108,
  [144] = 103,
  [145] = 103,
  [146] = 124,
  [147] = 103,
  [148] = 103,
  [149] = 149,
  [150] = 149,
  [151] = 149,
  [152] = 149,
  [153] = 103,
  [154] = 149,
  [155] = 149,
  [156] = 149,
  [157] = 149,
  [158] = 108,
  [159] = 159,
  [160] = 149,
  [161] = 161,
  [162] = 162,
  [163] = 162,
  [164] = 162,
  [165] = 165,
  [166] = 166,
  [167] = 162,
  [168] = 162,
  [169] = 162,
  [170] = 162,
  [171] = 162,
  [172] = 162,
  [173] = 173,
  [174] = 173,
  [175] = 173,
  [176] = 173,
  [177] = 173,
  [178] = 173,
  [179] = 173,
  [180] = 173,
  [181] = 173,
  [182] = 182,
  [183] = 182,
  [184] = 182,
  [185] = 185,
  [186] = 186,
  [187] = 187,
  [188] = 188,
  [189] = 187,
  [190] = 188,
  [191] = 188,
  [192] = 188,
  [193] = 187,
  [194] = 187,
  [195] = 182,
  [196] = 185,
  [197] = 182,
  [198] = 182,
  [199] = 185,
  [200] = 186,
  [201] = 182,
  [202] = 182,
  [203] = 182,
  [204] = 204,
  [205] = 204,
  [206] = 206,
  [207] = 207,
  [208] = 208,
  [209] = 207,
  [210] = 206,
  [211] = 208,
  [212] = 208,
  [213] = 206,
  [214] = 207,
  [215] = 215,
  [216] = 216,
  [217] = 217,
  [218] = 218,
  [219] = 219,
  [220] = 220,
  [221] = 215,
  [222] = 215,
  [223] = 223,
  [224] = 215,
  [225] = 215,
  [226] = 226,
  [227] = 215,
  [228] = 228,
  [229] = 229,
  [230] = 230,
  [231] = 231,
  [232] = 232,
  [233] = 233,
  [234] = 234,
  [235] = 235,
  [236] = 236,
  [237] = 237,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 242,
  [243] = 243,
  [244] = 244,
  [245] = 245,
  [246] = 246,
  [247] = 247,
  [248] = 248,
  [249] = 249,
  [250] = 250,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 226,
  [255] = 255,
  [256] = 255,
  [257] = 255,
  [258] = 258,
  [259] = 259,
  [260] = 259,
  [261] = 226,
  [262] = 262,
  [263] = 262,
  [264] = 264,
  [265] = 265,
  [266] = 266,
  [267] = 266,
  [268] = 268,
  [269] = 269,
  [270] = 226,
  [271] = 266,
  [272] = 226,
  [273] = 226,
  [274] = 269,
  [275] = 275,
  [276] = 226,
  [277] = 226,
  [278] = 266,
  [279] = 226,
  [280] = 266,
  [281] = 226,
  [282] = 266,
  [283] = 266,
  [284] = 284,
  [285] = 268,
  [286] = 286,
  [287] = 286,
  [288] = 286,
  [289] = 286,
  [290] = 290,
  [291] = 291,
  [292] = 286,
  [293] = 286,
  [294] = 286,
  [295] = 286,
  [296] = 286,
  [297] = 291,
  [298] = 286,
  [299] = 286,
  [300] = 300,
  [301] = 286,
  [302] = 286,
  [303] = 303,
  [304] = 304,
  [305] = 286,
  [306] = 306,
  [307] = 307,
  [308] = 308,
  [309] = 306,
  [310] = 310,
  [311] = 311,
  [312] = 312,
  [313] = 311,
  [314] = 314,
  [315] = 306,
  [316] = 311,
  [317] = 317,
  [318] = 318,
  [319] = 319,
  [320] = 320,
  [321] = 321,
  [322] = 318,
  [323] = 319,
  [324] = 317,
  [325] = 320,
  [326] = 318,
  [327] = 319,
  [328] = 317,
  [329] = 320,
  [330] = 330,
  [331] = 331,
  [332] = 332,
  [333] = 330,
  [334] = 334,
  [335] = 335,
  [336] = 336,
  [337] = 337,
  [338] = 338,
  [339] = 339,
  [340] = 330,
  [341] = 332,
  [342] = 342,
  [343] = 343,
  [344] = 331,
  [345] = 330,
  [346] = 346,
  [347] = 347,
  [348] = 348,
  [349] = 349,
  [350] = 350,
  [351] = 343,
  [352] = 352,
  [353] = 330,
  [354] = 342,
  [355] = 331,
  [356] = 346,
  [357] = 347,
  [358] = 348,
  [359] = 342,
  [360] = 330,
  [361] = 342,
  [362] = 331,
  [363] = 346,
  [364] = 347,
  [365] = 348,
  [366] = 342,
  [367] = 331,
  [368] = 346,
  [369] = 347,
  [370] = 370,
  [371] = 331,
  [372] = 330,
  [373] = 342,
  [374] = 331,
  [375] = 346,
  [376] = 347,
  [377] = 348,
  [378] = 378,
  [379] = 346,
  [380] = 347,
  [381] = 348,
  [382] = 330,
  [383] = 342,
  [384] = 331,
  [385] = 346,
  [386] = 347,
  [387] = 348,
  [388] = 346,
  [389] = 347,
  [390] = 348,
  [391] = 330,
  [392] = 342,
  [393] = 331,
  [394] = 346,
  [395] = 347,
  [396] = 348,
  [397] = 350,
  [398] = 398,
  [399] = 342,
  [400] = 400,
  [401] = 401,
  [402] = 402,
  [403] = 403,
  [404] = 348,
  [405] = 405,
  [406] = 406,
  [407] = 407,
  [408] = 408,
  [409] = 409,
  [410] = 410,
  [411] = 411,
  [412] = 409,
  [413] = 413,
  [414] = 414,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 418,
  [419] = 419,
  [420] = 420,
  [421] = 421,
  [422] = 422,
  [423] = 423,
  [424] = 424,
  [425] = 414,
  [426] = 426,
  [427] = 427,
  [428] = 428,
  [429] = 429,
  [430] = 430,
  [431] = 431,
  [432] = 418,
  [433] = 410,
  [434] = 427,
  [435] = 435,
  [436] = 436,
  [437] = 411,
  [438] = 405,
  [439] = 435,
  [440] = 407,
  [441] = 413,
  [442] = 428,
  [443] = 443,
  [444] = 409,
  [445] = 414,
  [446] = 410,
  [447] = 411,
  [448] = 448,
  [449] = 413,
  [450] = 450,
  [451] = 414,
  [452] = 415,
  [453] = 416,
  [454] = 417,
  [455] = 418,
  [456] = 419,
  [457] = 420,
  [458] = 421,
  [459] = 422,
  [460] = 423,
  [461] = 424,
  [462] = 428,
  [463] = 426,
  [464] = 448,
  [465] = 407,
  [466] = 466,
  [467] = 409,
  [468] = 430,
  [469] = 431,
  [470] = 415,
  [471] = 416,
  [472] = 427,
  [473] = 417,
  [474] = 418,
  [475] = 436,
  [476] = 419,
  [477] = 407,
  [478] = 436,
  [479] = 409,
  [480] = 420,
  [481] = 410,
  [482] = 411,
  [483] = 483,
  [484] = 413,
  [485] = 414,
  [486] = 415,
  [487] = 416,
  [488] = 417,
  [489] = 418,
  [490] = 419,
  [491] = 420,
  [492] = 421,
  [493] = 422,
  [494] = 423,
  [495] = 424,
  [496] = 410,
  [497] = 426,
  [498] = 411,
  [499] = 499,
  [500] = 413,
  [501] = 430,
  [502] = 431,
  [503] = 421,
  [504] = 422,
  [505] = 427,
  [506] = 405,
  [507] = 423,
  [508] = 436,
  [509] = 424,
  [510] = 405,
  [511] = 435,
  [512] = 450,
  [513] = 426,
  [514] = 428,
  [515] = 450,
  [516] = 414,
  [517] = 409,
  [518] = 410,
  [519] = 411,
  [520] = 413,
  [521] = 413,
  [522] = 414,
  [523] = 415,
  [524] = 416,
  [525] = 417,
  [526] = 418,
  [527] = 419,
  [528] = 420,
  [529] = 421,
  [530] = 422,
  [531] = 423,
  [532] = 424,
  [533] = 415,
  [534] = 426,
  [535] = 416,
  [536] = 417,
  [537] = 418,
  [538] = 430,
  [539] = 431,
  [540] = 540,
  [541] = 417,
  [542] = 427,
  [543] = 419,
  [544] = 436,
  [545] = 420,
  [546] = 405,
  [547] = 435,
  [548] = 421,
  [549] = 428,
  [550] = 450,
  [551] = 422,
  [552] = 423,
  [553] = 409,
  [554] = 410,
  [555] = 411,
  [556] = 424,
  [557] = 413,
  [558] = 414,
  [559] = 415,
  [560] = 416,
  [561] = 417,
  [562] = 418,
  [563] = 419,
  [564] = 420,
  [565] = 421,
  [566] = 422,
  [567] = 423,
  [568] = 424,
  [569] = 427,
  [570] = 426,
  [571] = 426,
  [572] = 466,
  [573] = 407,
  [574] = 430,
  [575] = 431,
  [576] = 430,
  [577] = 431,
  [578] = 427,
  [579] = 419,
  [580] = 450,
  [581] = 436,
  [582] = 427,
  [583] = 405,
  [584] = 435,
  [585] = 585,
  [586] = 428,
  [587] = 450,
  [588] = 588,
  [589] = 430,
  [590] = 431,
  [591] = 591,
  [592] = 405,
  [593] = 435,
  [594] = 436,
  [595] = 407,
  [596] = 420,
  [597] = 421,
  [598] = 598,
  [599] = 407,
  [600] = 426,
  [601] = 409,
  [602] = 410,
  [603] = 411,
  [604] = 430,
  [605] = 413,
  [606] = 414,
  [607] = 415,
  [608] = 416,
  [609] = 417,
  [610] = 418,
  [611] = 419,
  [612] = 420,
  [613] = 421,
  [614] = 422,
  [615] = 423,
  [616] = 424,
  [617] = 431,
  [618] = 426,
  [619] = 591,
  [620] = 409,
  [621] = 427,
  [622] = 430,
  [623] = 431,
  [624] = 427,
  [625] = 427,
  [626] = 410,
  [627] = 627,
  [628] = 436,
  [629] = 427,
  [630] = 427,
  [631] = 435,
  [632] = 632,
  [633] = 405,
  [634] = 435,
  [635] = 635,
  [636] = 436,
  [637] = 411,
  [638] = 428,
  [639] = 450,
  [640] = 422,
  [641] = 429,
  [642] = 423,
  [643] = 427,
  [644] = 405,
  [645] = 435,
  [646] = 646,
  [647] = 407,
  [648] = 407,
  [649] = 428,
  [650] = 429,
  [651] = 450,
  [652] = 415,
  [653] = 416,
  [654] = 428,
  [655] = 424,
  [656] = 450,
  [657] = 429,
  [658] = 658,
  [659] = 658,
  [660] = 658,
  [661] = 661,
  [662] = 661,
  [663] = 661,
  [664] = 664,
  [665] = 664,
  [666] = 664,
  [667] = 667,
  [668] = 667,
  [669] = 667,
  [670] = 670,
  [671] = 670,
  [672] = 670,
  [673] = 673,
  [674] = 673,
  [675] = 675,
  [676] = 675,
  [677] = 673,
  [678] = 675,
  [679] = 679,
  [680] = 248,
  [681] = 241,
  [682] = 679,
  [683] = 679,
  [684] = 684,
  [685] = 685,
  [686] = 686,
  [687] = 687,
  [688] = 688,
  [689] = 689,
  [690] = 690,
  [691] = 691,
  [692] = 691,
  [693] = 689,
  [694] = 690,
  [695] = 691,
  [696] = 689,
  [697] = 690,
  [698] = 698,
  [699] = 698,
  [700] = 700,
  [701] = 700,
  [702] = 702,
  [703] = 700,
  [704] = 704,
  [705] = 700,
  [706] = 700,
  [707] = 704,
  [708] = 704,
  [709] = 700,
  [710] = 702,
  [711] = 700,
  [712] = 712,
  [713] = 713,
  [714] = 700,
  [715] = 249,
  [716] = 716,
  [717] = 717,
  [718] = 700,
  [719] = 700,
  [720] = 700,
  [721] = 717,
  [722] = 700,
  [723] = 717,
  [724] = 698,
  [725] = 246,
  [726] = 726,
  [727] = 727,
  [728] = 700,
  [729] = 242,
  [730] = 232,
  [731] = 246,
  [732] = 700,
  [733] = 700,
  [734] = 702,
  [735] = 252,
  [736] = 713,
  [737] = 234,
  [738] = 700,
  [739] = 249,
  [740] = 232,
  [741] = 242,
  [742] = 742,
  [743] = 743,
  [744] = 743,
  [745] = 743,
  [746] = 743,
  [747] = 743,
  [748] = 700,
  [749] = 743,
  [750] = 219,
  [751] = 223,
  [752] = 743,
  [753] = 743,
  [754] = 743,
  [755] = 755,
  [756] = 756,
  [757] = 229,
  [758] = 758,
  [759] = 759,
  [760] = 760,
  [761] = 760,
  [762] = 760,
  [763] = 760,
  [764] = 764,
  [765] = 765,
  [766] = 766,
  [767] = 767,
  [768] = 768,
  [769] = 239,
  [770] = 770,
  [771] = 771,
  [772] = 772,
  [773] = 773,
  [774] = 774,
  [775] = 775,
  [776] = 776,
  [777] = 777,
  [778] = 778,
  [779] = 779,
  [780] = 780,
  [781] = 216,
  [782] = 760,
  [783] = 783,
  [784] = 784,
  [785] = 785,
  [786] = 786,
  [787] = 787,
  [788] = 788,
  [789] = 789,
  [790] = 790,
  [791] = 791,
  [792] = 792,
  [793] = 793,
  [794] = 794,
  [795] = 784,
  [796] = 796,
  [797] = 797,
  [798] = 798,
  [799] = 799,
  [800] = 794,
  [801] = 784,
  [802] = 802,
  [803] = 803,
  [804] = 794,
  [805] = 784,
  [806] = 806,
  [807] = 807,
  [808] = 808,
  [809] = 809,
  [810] = 810,
  [811] = 811,
  [812] = 812,
  [813] = 813,
  [814] = 814,
  [815] = 815,
  [816] = 816,
  [817] = 817,
  [818] = 818,
  [819] = 819,
  [820] = 820,
  [821] = 821,
  [822] = 822,
  [823] = 823,
  [824] = 824,
  [825] = 825,
  [826] = 826,
  [827] = 827,
  [828] = 828,
  [829] = 829,
  [830] = 830,
  [831] = 831,
  [832] = 832,
  [833] = 833,
  [834] = 794,
  [835] = 835,
  [836] = 836,
  [837] = 837,
  [838] = 838,
  [839] = 839,
  [840] = 840,
  [841] = 841,
  [842] = 842,
  [843] = 843,
  [844] = 844,
  [845] = 845,
  [846] = 846,
  [847] = 847,
  [848] = 848,
  [849] = 849,
  [850] = 850,
  [851] = 851,
  [852] = 852,
  [853] = 234,
  [854] = 854,
  [855] = 252,
  [856] = 856,
  [857] = 857,
  [858] = 858,
  [859] = 859,
  [860] = 860,
  [861] = 861,
  [862] = 862,
  [863] = 863,
  [864] = 784,
  [865] = 865,
  [866] = 866,
  [867] = 867,
  [868] = 868,
  [869] = 869,
  [870] = 870,
  [871] = 871,
  [872] = 872,
  [873] = 873,
  [874] = 874,
  [875] = 875,
  [876] = 876,
  [877] = 877,
  [878] = 878,
  [879] = 879,
  [880] = 880,
  [881] = 881,
  [882] = 882,
  [883] = 883,
  [884] = 884,
  [885] = 885,
  [886] = 886,
  [887] = 887,
  [888] = 888,
  [889] = 889,
  [890] = 890,
  [891] = 891,
  [892] = 892,
  [893] = 893,
  [894] = 894,
  [895] = 895,
  [896] = 896,
  [897] = 897,
  [898] = 898,
  [899] = 899,
  [900] = 900,
  [901] = 901,
  [902] = 902,
  [903] = 903,
  [904] = 245,
  [905] = 905,
  [906] = 794,
  [907] = 907,
  [908] = 908,
  [909] = 909,
  [910] = 910,
  [911] = 247,
  [912] = 912,
  [913] = 913,
  [914] = 914,
  [915] = 915,
  [916] = 916,
  [917] = 917,
  [918] = 918,
  [919] = 919,
  [920] = 920,
  [921] = 918,
  [922] = 919,
  [923] = 923,
  [924] = 924,
  [925] = 925,
  [926] = 926,
  [927] = 919,
  [928] = 928,
  [929] = 929,
  [930] = 930,
  [931] = 931,
  [932] = 919,
  [933] = 933,
  [934] = 934,
  [935] = 918,
  [936] = 936,
  [937] = 923,
  [938] = 923,
  [939] = 919,
  [940] = 923,
  [941] = 919,
  [942] = 923,
  [943] = 923,
  [944] = 755,
  [945] = 919,
  [946] = 756,
  [947] = 923,
  [948] = 948,
  [949] = 949,
  [950] = 950,
  [951] = 949,
  [952] = 952,
  [953] = 950,
  [954] = 949,
  [955] = 949,
  [956] = 952,
  [957] = 957,
  [958] = 958,
  [959] = 952,
  [960] = 960,
  [961] = 949,
  [962] = 952,
  [963] = 949,
  [964] = 952,
  [965] = 952,
  [966] = 950,
  [967] = 952,
  [968] = 950,
  [969] = 949,
  [970] = 950,
  [971] = 971,
  [972] = 972,
  [973] = 973,
  [974] = 974,
  [975] = 975,
  [976] = 976,
  [977] = 977,
  [978] = 978,
  [979] = 979,
  [980] = 980,
  [981] = 981,
  [982] = 982,
  [983] = 983,
  [984] = 984,
  [985] = 982,
  [986] = 972,
  [987] = 973,
  [988] = 988,
  [989] = 989,
  [990] = 974,
  [991] = 975,
  [992] = 980,
  [993] = 981,
  [994] = 994,
  [995] = 995,
  [996] = 976,
  [997] = 972,
  [998] = 973,
  [999] = 974,
  [1000] = 975,
  [1001] = 976,
  [1002] = 978,
  [1003] = 978,
  [1004] = 983,
  [1005] = 984,
  [1006] = 971,
  [1007] = 988,
  [1008] = 989,
  [1009] = 1009,
  [1010] = 980,
  [1011] = 1011,
  [1012] = 1012,
  [1013] = 981,
  [1014] = 1014,
  [1015] = 1015,
  [1016] = 1016,
  [1017] = 1017,
  [1018] = 994,
  [1019] = 995,
  [1020] = 994,
  [1021] = 1021,
  [1022] = 995,
  [1023] = 974,
  [1024] = 980,
  [1025] = 981,
  [1026] = 975,
  [1027] = 972,
  [1028] = 973,
  [1029] = 976,
  [1030] = 978,
  [1031] = 994,
  [1032] = 995,
  [1033] = 1021,
  [1034] = 1034,
  [1035] = 974,
  [1036] = 975,
  [1037] = 1037,
  [1038] = 976,
  [1039] = 978,
  [1040] = 1034,
  [1041] = 1041,
  [1042] = 983,
  [1043] = 984,
  [1044] = 971,
  [1045] = 988,
  [1046] = 989,
  [1047] = 1009,
  [1048] = 1048,
  [1049] = 1049,
  [1050] = 1050,
  [1051] = 1051,
  [1052] = 1052,
  [1053] = 974,
  [1054] = 975,
  [1055] = 1037,
  [1056] = 972,
  [1057] = 973,
  [1058] = 1037,
  [1059] = 1059,
  [1060] = 1041,
  [1061] = 1061,
  [1062] = 1062,
  [1063] = 1063,
  [1064] = 1012,
  [1065] = 976,
  [1066] = 980,
  [1067] = 981,
  [1068] = 983,
  [1069] = 984,
  [1070] = 971,
  [1071] = 988,
  [1072] = 989,
  [1073] = 994,
  [1074] = 980,
  [1075] = 981,
  [1076] = 995,
  [1077] = 972,
  [1078] = 972,
  [1079] = 1009,
  [1080] = 978,
  [1081] = 1037,
  [1082] = 973,
  [1083] = 973,
  [1084] = 994,
  [1085] = 994,
  [1086] = 995,
  [1087] = 1009,
  [1088] = 995,
  [1089] = 983,
  [1090] = 984,
  [1091] = 971,
  [1092] = 988,
  [1093] = 989,
  [1094] = 1009,
  [1095] = 1037,
  [1096] = 1059,
  [1097] = 1097,
  [1098] = 1098,
  [1099] = 974,
  [1100] = 975,
  [1101] = 1009,
  [1102] = 1009,
  [1103] = 976,
  [1104] = 1017,
  [1105] = 983,
  [1106] = 984,
  [1107] = 983,
  [1108] = 984,
  [1109] = 971,
  [1110] = 988,
  [1111] = 989,
  [1112] = 971,
  [1113] = 1037,
  [1114] = 988,
  [1115] = 989,
  [1116] = 978,
  [1117] = 980,
  [1118] = 981,
  [1119] = 982,
  [1120] = 1037,
  [1121] = 982,
  [1122] = 982,
  [1123] = 982,
  [1124] = 982,
  [1125] = 1125,
  [1126] = 1125,
  [1127] = 1125,
  [1128] = 1125,
  [1129] = 1125,
  [1130] = 1125,
  [1131] = 1125,
  [1132] = 1125,
  [1133] = 1125,
  [1134] = 1125,
  [1135] = 1125,
  [1136] = 1125,
  [1137] = 1137,
  [1138] = 1138,
  [1139] = 1138,
  [1140] = 1140,
  [1141] = 1140,
  [1142] = 1138,
  [1143] = 1140,
  [1144] = 1137,
  [1145] = 1137,
  [1146] = 1146,
  [1147] = 1147,
  [1148] = 1147,
  [1149] = 1149,
  [1150] = 1146,
  [1151] = 1151,
  [1152] = 1151,
  [1153] = 1147,
  [1154] = 1154,
  [1155] = 1155,
  [1156] = 1149,
  [1157] = 1157,
  [1158] = 1157,
  [1159] = 1147,
  [1160] = 1155,
  [1161] = 1147,
  [1162] = 1157,
  [1163] = 1147,
  [1164] = 1154,
  [1165] = 1154,
  [1166] = 1155,
  [1167] = 1167,
  [1168] = 1168,
  [1169] = 1169,
  [1170] = 1167,
  [1171] = 1171,
  [1172] = 1172,
  [1173] = 1173,
  [1174] = 1174,
  [1175] = 1175,
  [1176] = 1167,
  [1177] = 1177,
  [1178] = 1178,
  [1179] = 1179,
  [1180] = 1180,
  [1181] = 1147,
  [1182] = 1182,
  [1183] = 1147,
  [1184] = 1184,
  [1185] = 756,
  [1186] = 1146,
  [1187] = 1175,
  [1188] = 1188,
  [1189] = 1189,
  [1190] = 1190,
  [1191] = 1191,
  [1192] = 1191,
  [1193] = 1147,
  [1194] = 1189,
  [1195] = 1195,
  [1196] = 1188,
  [1197] = 1188,
  [1198] = 1147,
  [1199] = 1190,
  [1200] = 1147,
  [1201] = 1201,
  [1202] = 1202,
  [1203] = 1190,
  [1204] = 1204,
  [1205] = 1191,
  [1206] = 1147,
  [1207] = 1147,
  [1208] = 755,
  [1209] = 1147,
  [1210] = 1147,
  [1211] = 1147,
  [1212] = 1149,
  [1213] = 1175,
  [1214] = 1214,
  [1215] = 1175,
  [1216] = 1147,
  [1217] = 1217,
  [1218] = 1218,
  [1219] = 1219,
  [1220] = 1175,
  [1221] = 1168,
  [1222] = 1222,
  [1223] = 1223,
  [1224] = 1224,
  [1225] = 1225,
  [1226] = 1225,
  [1227] = 1227,
  [1228] = 1224,
  [1229] = 1224,
  [1230] = 1175,
  [1231] = 1222,
  [1232] = 1175,
  [1233] = 1224,
  [1234] = 1227,
  [1235] = 1224,
  [1236] = 1175,
  [1237] = 1224,
  [1238] = 1202,
  [1239] = 1239,
  [1240] = 1224,
  [1241] = 1224,
  [1242] = 1224,
  [1243] = 1243,
  [1244] = 1219,
  [1245] = 1245,
  [1246] = 1175,
  [1247] = 1247,
  [1248] = 1147,
  [1249] = 1219,
  [1250] = 1250,
  [1251] = 1223,
  [1252] = 1202,
  [1253] = 1253,
  [1254] = 1202,
  [1255] = 1255,
  [1256] = 1255,
  [1257] = 1173,
  [1258] = 1214,
  [1259] = 1259,
  [1260] = 1173,
  [1261] = 1261,
  [1262] = 1195,
  [1263] = 1202,
  [1264] = 1175,
  [1265] = 1265,
  [1266] = 1171,
  [1267] = 1173,
  [1268] = 1265,
  [1269] = 1243,
  [1270] = 1270,
  [1271] = 1175,
  [1272] = 1175,
  [1273] = 1273,
  [1274] = 1274,
  [1275] = 1214,
  [1276] = 1202,
  [1277] = 1261,
  [1278] = 1171,
  [1279] = 1261,
  [1280] = 1243,
  [1281] = 1171,
  [1282] = 1282,
  [1283] = 1222,
  [1284] = 1284,
  [1285] = 1214,
  [1286] = 1243,
  [1287] = 1174,
  [1288] = 756,
  [1289] = 1195,
  [1290] = 1290,
  [1291] = 1291,
  [1292] = 1292,
  [1293] = 1172,
  [1294] = 1177,
  [1295] = 1178,
  [1296] = 1175,
  [1297] = 1245,
  [1298] = 1225,
  [1299] = 1179,
  [1300] = 1180,
  [1301] = 1202,
  [1302] = 1302,
  [1303] = 755,
  [1304] = 1222,
  [1305] = 1225,
  [1306] = 1222,
  [1307] = 1222,
  [1308] = 1214,
  [1309] = 1214,
  [1310] = 1225,
  [1311] = 1291,
  [1312] = 1291,
  [1313] = 1292,
  [1314] = 1225,
  [1315] = 1292,
  [1316] = 1202,
  [1317] = 1282,
  [1318] = 1202,
  [1319] = 1175,
  [1320] = 1169,
  [1321] = 1214,
  [1322] = 1171,
  [1323] = 1173,
  [1324] = 1214,
  [1325] = 1325,
  [1326] = 1173,
  [1327] = 1202,
  [1328] = 1273,
  [1329] = 1222,
  [1330] = 1171,
  [1331] = 1331,
  [1332] = 1332,
  [1333] = 1222,
  [1334] = 1325,
  [1335] = 1195,
  [1336] = 1336,
  [1337] = 1195,
  [1338] = 1214,
  [1339] = 1225,
  [1340] = 1225,
  [1341] = 1341,
  [1342] = 1250,
  [1343] = 1343,
  [1344] = 1344,
  [1345] = 1345,
  [1346] = 1225,
  [1347] = 1225,
  [1348] = 1348,
  [1349] = 1171,
  [1350] = 1227,
  [1351] = 1345,
  [1352] = 1345,
  [1353] = 1353,
  [1354] = 1354,
  [1355] = 1223,
  [1356] = 1173,
  [1357] = 1345,
  [1358] = 1225,
  [1359] = 1222,
  [1360] = 1222,
  [1361] = 1345,
  [1362] = 1225,
  [1363] = 1345,
  [1364] = 1222,
  [1365] = 1195,
  [1366] = 1214,
  [1367] = 1222,
  [1368] = 1225,
  [1369] = 1222,
  [1370] = 1265,
  [1371] = 1222,
  [1372] = 1222,
  [1373] = 1222,
  [1374] = 1195,
  [1375] = 1195,
  [1376] = 1245,
  [1377] = 1225,
  [1378] = 1341,
  [1379] = 1331,
  [1380] = 1225,
  [1381] = 1225,
  [1382] = 1195,
  [1383] = 1383,
  [1384] = 1384,
  [1385] = 1383,
  [1386] = 1386,
  [1387] = 1387,
  [1388] = 1386,
  [1389] = 1387,
  [1390] = 1387,
  [1391] = 1387,
  [1392] = 1392,
  [1393] = 1387,
  [1394] = 1386,
  [1395] = 1383,
  [1396] = 1387,
  [1397] = 1392,
  [1398] = 1392,
  [1399] = 1222,
  [1400] = 1387,
  [1401] = 1392,
  [1402] = 1386,
  [1403] = 1392,
  [1404] = 1384,
  [1405] = 1386,
  [1406] = 1195,
  [1407] = 1392,
  [1408] = 1384,
  [1409] = 1273,
  [1410] = 1387,
  [1411] = 1383,
  [1412] = 1383,
  [1413] = 1387,
  [1414] = 1383,
  [1415] = 1354,
  [1416] = 1392,
  [1417] = 1392,
  [1418] = 1386,
  [1419] = 1384,
  [1420] = 1392,
  [1421] = 1384,
  [1422] = 1384,
  [1423] = 1225,
  [1424] = 1424,
  [1425] = 1424,
  [1426] = 1424,
  [1427] = 1424,
  [1428] = 1424,
  [1429] = 1424,
  [1430] = 1424,
  [1431] = 1424,
  [1432] = 1424,
  [1433] = 1433,
  [1434] = 1433,
  [1435] = 1433,
  [1436] = 1433,
  [1437] = 1433,
  [1438] = 1438,
  [1439] = 1433,
  [1440] = 1440,
  [1441] = 1441,
  [1442] = 1442,
  [1443] = 1442,
  [1444] = 1441,
  [1445] = 1441,
  [1446] = 1440,
  [1447] = 1440,
  [1448] = 1448,
  [1449] = 1442,
  [1450] = 1441,
  [1451] = 1440,
  [1452] = 1442,
  [1453] = 1441,
  [1454] = 1440,
  [1455] = 1442,
  [1456] = 1456,
  [1457] = 1456,
  [1458] = 1456,
  [1459] = 1459,
  [1460] = 1456,
  [1461] = 1456,
  [1462] = 1456,
  [1463] = 1463,
  [1464] = 1464,
  [1465] = 1465,
  [1466] = 1466,
  [1467] = 241,
  [1468] = 1468,
  [1469] = 1469,
  [1470] = 248,
  [1471] = 1471,
  [1472] = 248,
  [1473] = 1473,
  [1474] = 948,
  [1475] = 1475,
  [1476] = 241,
  [1477] = 1477,
  [1478] = 1478,
  [1479] = 1479,
  [1480] = 957,
  [1481] = 217,
  [1482] = 1482,
  [1483] = 958,
  [1484] = 1484,
  [1485] = 1485,
  [1486] = 1486,
  [1487] = 1487,
  [1488] = 1488,
  [1489] = 1489,
  [1490] = 1490,
  [1491] = 1491,
  [1492] = 1492,
  [1493] = 1493,
  [1494] = 1494,
  [1495] = 1495,
  [1496] = 1496,
  [1497] = 219,
  [1498] = 223,
  [1499] = 1499,
  [1500] = 216,
  [1501] = 219,
  [1502] = 223,
  [1503] = 216,
  [1504] = 1504,
  [1505] = 246,
  [1506] = 1506,
  [1507] = 1507,
  [1508] = 1508,
  [1509] = 1509,
  [1510] = 1510,
  [1511] = 1511,
  [1512] = 1512,
  [1513] = 1513,
  [1514] = 1514,
  [1515] = 1515,
  [1516] = 684,
  [1517] = 1517,
  [1518] = 1518,
  [1519] = 1519,
  [1520] = 1520,
  [1521] = 1521,
  [1522] = 1522,
  [1523] = 1523,
  [1524] = 1524,
  [1525] = 1525,
  [1526] = 1526,
  [1527] = 1527,
  [1528] = 1528,
  [1529] = 1529,
  [1530] = 1530,
  [1531] = 1531,
  [1532] = 1532,
  [1533] = 1533,
  [1534] = 686,
  [1535] = 1535,
  [1536] = 1536,
  [1537] = 1537,
  [1538] = 1538,
  [1539] = 1539,
  [1540] = 1540,
  [1541] = 1541,
  [1542] = 1542,
  [1543] = 1543,
  [1544] = 1544,
  [1545] = 1545,
  [1546] = 1546,
  [1547] = 1547,
  [1548] = 1548,
  [1549] = 1549,
  [1550] = 1550,
  [1551] = 1551,
  [1552] = 1552,
  [1553] = 1553,
  [1554] = 1554,
  [1555] = 249,
  [1556] = 1556,
  [1557] = 1557,
  [1558] = 1558,
  [1559] = 687,
  [1560] = 1560,
  [1561] = 1561,
  [1562] = 1562,
  [1563] = 1563,
  [1564] = 1564,
  [1565] = 1565,
  [1566] = 1566,
  [1567] = 1567,
  [1568] = 1568,
  [1569] = 1569,
  [1570] = 1570,
  [1571] = 1571,
  [1572] = 1572,
  [1573] = 1573,
  [1574] = 1574,
  [1575] = 1575,
  [1576] = 1576,
  [1577] = 1577,
  [1578] = 1578,
  [1579] = 1579,
  [1580] = 1580,
  [1581] = 1581,
  [1582] = 1582,
  [1583] = 685,
  [1584] = 1584,
  [1585] = 1585,
  [1586] = 1586,
  [1587] = 1587,
  [1588] = 1588,
  [1589] = 1589,
  [1590] = 1590,
  [1591] = 1591,
  [1592] = 1592,
  [1593] = 1593,
  [1594] = 1594,
  [1595] = 1595,
  [1596] = 1596,
  [1597] = 688,
  [1598] = 1598,
  [1599] = 1599,
  [1600] = 1600,
  [1601] = 1601,
  [1602] = 1602,
  [1603] = 1603,
  [1604] = 1604,
  [1605] = 1605,
  [1606] = 1606,
  [1607] = 1607,
  [1608] = 1608,
  [1609] = 1609,
  [1610] = 1610,
  [1611] = 1611,
  [1612] = 1612,
  [1613] = 1613,
  [1614] = 1614,
  [1615] = 1615,
  [1616] = 1616,
  [1617] = 1617,
  [1618] = 1618,
  [1619] = 1619,
  [1620] = 1620,
  [1621] = 1621,
  [1622] = 1622,
  [1623] = 1623,
  [1624] = 1624,
  [1625] = 1625,
  [1626] = 1626,
  [1627] = 1627,
  [1628] = 245,
  [1629] = 1629,
  [1630] = 1630,
  [1631] = 1631,
  [1632] = 1632,
  [1633] = 1633,
  [1634] = 1634,
  [1635] = 1635,
  [1636] = 229,
  [1637] = 252,
  [1638] = 1638,
  [1639] = 247,
  [1640] = 1459,
  [1641] = 242,
  [1642] = 239,
  [1643] = 1643,
  [1644] = 1644,
  [1645] = 1645,
  [1646] = 1646,
  [1647] = 1647,
  [1648] = 1648,
  [1649] = 1649,
  [1650] = 1650,
  [1651] = 1651,
  [1652] = 1652,
  [1653] = 1653,
  [1654] = 1654,
  [1655] = 1655,
  [1656] = 1656,
  [1657] = 1657,
  [1658] = 1658,
  [1659] = 1617,
  [1660] = 1660,
  [1661] = 1661,
  [1662] = 1662,
  [1663] = 1663,
  [1664] = 1664,
  [1665] = 1665,
  [1666] = 1666,
  [1667] = 1667,
  [1668] = 1668,
  [1669] = 1669,
  [1670] = 1617,
  [1671] = 1671,
  [1672] = 1672,
  [1673] = 1673,
  [1674] = 1674,
  [1675] = 1675,
  [1676] = 1676,
  [1677] = 1677,
  [1678] = 1678,
  [1679] = 1679,
  [1680] = 1680,
  [1681] = 1681,
  [1682] = 1682,
  [1683] = 1683,
  [1684] = 1684,
  [1685] = 1685,
  [1686] = 1686,
  [1687] = 1687,
  [1688] = 1688,
  [1689] = 1689,
  [1690] = 1690,
  [1691] = 1691,
  [1692] = 1692,
  [1693] = 1693,
  [1694] = 1694,
  [1695] = 1695,
  [1696] = 1696,
  [1697] = 234,
  [1698] = 229,
  [1699] = 1699,
  [1700] = 239,
  [1701] = 232,
  [1702] = 1702,
  [1703] = 1703,
  [1704] = 1704,
  [1705] = 1705,
  [1706] = 1706,
  [1707] = 1707,
  [1708] = 1708,
  [1709] = 1709,
  [1710] = 1710,
  [1711] = 1711,
  [1712] = 1617,
  [1713] = 1713,
  [1714] = 1714,
  [1715] = 1715,
  [1716] = 1617,
  [1717] = 1717,
  [1718] = 1718,
  [1719] = 1719,
  [1720] = 1720,
  [1721] = 1721,
  [1722] = 1722,
  [1723] = 1723,
  [1724] = 1724,
  [1725] = 1725,
  [1726] = 1726,
  [1727] = 242,
  [1728] = 1728,
  [1729] = 252,
  [1730] = 1726,
  [1731] = 1731,
  [1732] = 1728,
  [1733] = 249,
  [1734] = 1734,
  [1735] = 1695,
  [1736] = 247,
  [1737] = 1737,
  [1738] = 1738,
  [1739] = 1726,
  [1740] = 245,
  [1741] = 1728,
  [1742] = 1465,
  [1743] = 232,
  [1744] = 1726,
  [1745] = 1466,
  [1746] = 1463,
  [1747] = 1468,
  [1748] = 1748,
  [1749] = 246,
  [1750] = 234,
  [1751] = 1726,
  [1752] = 1728,
  [1753] = 1728,
  [1754] = 1610,
  [1755] = 1676,
  [1756] = 1471,
  [1757] = 1488,
  [1758] = 1657,
  [1759] = 1488,
  [1760] = 1657,
  [1761] = 1496,
  [1762] = 1496,
  [1763] = 1496,
  [1764] = 1672,
  [1765] = 958,
  [1766] = 1557,
  [1767] = 1687,
  [1768] = 1710,
  [1769] = 1715,
  [1770] = 1770,
  [1771] = 1661,
  [1772] = 1770,
  [1773] = 1720,
  [1774] = 1688,
  [1775] = 1663,
  [1776] = 1776,
  [1777] = 1725,
  [1778] = 1624,
  [1779] = 1722,
  [1780] = 1625,
  [1781] = 1699,
  [1782] = 1708,
  [1783] = 1710,
  [1784] = 1626,
  [1785] = 1785,
  [1786] = 1488,
  [1787] = 1679,
  [1788] = 1671,
  [1789] = 1770,
  [1790] = 948,
  [1791] = 1791,
  [1792] = 1612,
  [1793] = 1791,
  [1794] = 1664,
  [1795] = 1661,
  [1796] = 1680,
  [1797] = 1624,
  [1798] = 1798,
  [1799] = 1715,
  [1800] = 1610,
  [1801] = 1663,
  [1802] = 957,
  [1803] = 1687,
  [1804] = 1475,
  [1805] = 1688,
  [1806] = 1791,
  [1807] = 1720,
  [1808] = 1672,
  [1809] = 1722,
  [1810] = 1723,
  [1811] = 1723,
  [1812] = 1632,
  [1813] = 1813,
  [1814] = 1478,
  [1815] = 1776,
  [1816] = 1656,
  [1817] = 1486,
  [1818] = 1632,
  [1819] = 1664,
  [1820] = 1708,
  [1821] = 1695,
  [1822] = 1679,
  [1823] = 1665,
  [1824] = 1612,
  [1825] = 1654,
  [1826] = 1490,
  [1827] = 1827,
  [1828] = 1484,
  [1829] = 1699,
  [1830] = 1625,
  [1831] = 1626,
  [1832] = 1666,
  [1833] = 1623,
  [1834] = 1506,
  [1835] = 1835,
  [1836] = 1667,
  [1837] = 1473,
  [1838] = 1680,
  [1839] = 1770,
  [1840] = 1477,
  [1841] = 1654,
  [1842] = 1770,
  [1843] = 1485,
  [1844] = 1482,
  [1845] = 1845,
  [1846] = 1656,
  [1847] = 1725,
  [1848] = 1665,
  [1849] = 1666,
  [1850] = 1667,
  [1851] = 1791,
  [1852] = 1623,
  [1853] = 1671,
  [1854] = 1676,
  [1855] = 1708,
  [1856] = 1856,
  [1857] = 1857,
  [1858] = 217,
  [1859] = 1558,
  [1860] = 1860,
  [1861] = 1861,
  [1862] = 1507,
  [1863] = 1508,
  [1864] = 1509,
  [1865] = 1510,
  [1866] = 1512,
  [1867] = 1513,
  [1868] = 1514,
  [1869] = 1515,
  [1870] = 1561,
  [1871] = 1562,
  [1872] = 1511,
  [1873] = 1675,
  [1874] = 1677,
  [1875] = 1738,
  [1876] = 1577,
  [1877] = 684,
  [1878] = 1517,
  [1879] = 1518,
  [1880] = 1519,
  [1881] = 1881,
  [1882] = 1827,
  [1883] = 1520,
  [1884] = 1521,
  [1885] = 1522,
  [1886] = 1523,
  [1887] = 1524,
  [1888] = 1525,
  [1889] = 1526,
  [1890] = 1527,
  [1891] = 1528,
  [1892] = 1529,
  [1893] = 1530,
  [1894] = 1531,
  [1895] = 1532,
  [1896] = 1491,
  [1897] = 1897,
  [1898] = 1898,
  [1899] = 1899,
  [1900] = 686,
  [1901] = 1535,
  [1902] = 1536,
  [1903] = 1537,
  [1904] = 1538,
  [1905] = 1609,
  [1906] = 1539,
  [1907] = 1540,
  [1908] = 1541,
  [1909] = 1909,
  [1910] = 1542,
  [1911] = 1543,
  [1912] = 1544,
  [1913] = 1545,
  [1914] = 1546,
  [1915] = 1547,
  [1916] = 1548,
  [1917] = 1549,
  [1918] = 1550,
  [1919] = 1551,
  [1920] = 1552,
  [1921] = 1553,
  [1922] = 1554,
  [1923] = 1556,
  [1924] = 1487,
  [1925] = 687,
  [1926] = 1560,
  [1927] = 1563,
  [1928] = 1564,
  [1929] = 1565,
  [1930] = 1566,
  [1931] = 1567,
  [1932] = 1568,
  [1933] = 1569,
  [1934] = 1570,
  [1935] = 1571,
  [1936] = 1572,
  [1937] = 1573,
  [1938] = 1574,
  [1939] = 1575,
  [1940] = 1576,
  [1941] = 1578,
  [1942] = 1579,
  [1943] = 1580,
  [1944] = 1581,
  [1945] = 1582,
  [1946] = 1499,
  [1947] = 685,
  [1948] = 1584,
  [1949] = 1585,
  [1950] = 1586,
  [1951] = 1587,
  [1952] = 1588,
  [1953] = 1589,
  [1954] = 1590,
  [1955] = 1591,
  [1956] = 1592,
  [1957] = 1593,
  [1958] = 1594,
  [1959] = 1595,
  [1960] = 1596,
  [1961] = 688,
  [1962] = 1598,
  [1963] = 1599,
  [1964] = 1600,
  [1965] = 1601,
  [1966] = 1602,
  [1967] = 1612,
  [1968] = 1604,
  [1969] = 1605,
  [1970] = 1606,
  [1971] = 1607,
  [1972] = 1608,
  [1973] = 1489,
  [1974] = 217,
  [1975] = 1860,
  [1976] = 1533,
  [1977] = 1677,
  [1978] = 1978,
  [1979] = 1488,
  [1980] = 1496,
  [1981] = 1492,
  [1982] = 1493,
  [1983] = 1494,
  [1984] = 1860,
  [1985] = 1985,
  [1986] = 1675,
  [1987] = 1987,
  [1988] = 1988,
  [1989] = 1989,
  [1990] = 1990,
  [1991] = 1495,
  [1992] = 1504,
  [1993] = 1638,
  [1994] = 1994,
  [1995] = 1881,
  [1996] = 1827,
  [1997] = 1860,
  [1998] = 1676,
  [1999] = 1488,
  [2000] = 1496,
  [2001] = 1506,
  [2002] = 1490,
  [2003] = 1860,
  [2004] = 1488,
  [2005] = 1496,
  [2006] = 1675,
  [2007] = 1638,
  [2008] = 1677,
  [2009] = 1557,
  [2010] = 1985,
  [2011] = 1495,
  [2012] = 1504,
  [2013] = 1638,
  [2014] = 1506,
  [2015] = 2015,
  [2016] = 1695,
  [2017] = 1860,
  [2018] = 2018,
  [2019] = 2019,
  [2020] = 2020,
  [2021] = 2021,
  [2022] = 1738,
  [2023] = 2023,
  [2024] = 2024,
  [2025] = 2025,
  [2026] = 1490,
  [2027] = 2027,
  [2028] = 2028,
  [2029] = 1610,
  [2030] = 1623,
  [2031] = 1624,
  [2032] = 1632,
  [2033] = 1654,
  [2034] = 1656,
  [2035] = 1657,
  [2036] = 1661,
  [2037] = 1663,
  [2038] = 1664,
  [2039] = 1665,
  [2040] = 1666,
  [2041] = 1667,
  [2042] = 1725,
  [2043] = 1671,
  [2044] = 1672,
  [2045] = 1679,
  [2046] = 1680,
  [2047] = 1687,
  [2048] = 1688,
  [2049] = 1715,
  [2050] = 1720,
  [2051] = 1722,
  [2052] = 1625,
  [2053] = 1626,
  [2054] = 1723,
  [2055] = 2055,
  [2056] = 1699,
  [2057] = 1710,
  [2058] = 1603,
  [2059] = 2059,
  [2060] = 243,
  [2061] = 244,
  [2062] = 2062,
  [2063] = 2063,
  [2064] = 250,
  [2065] = 251,
  [2066] = 231,
  [2067] = 2067,
  [2068] = 233,
  [2069] = 2069,
  [2070] = 2070,
  [2071] = 1696,
  [2072] = 2072,
  [2073] = 2073,
  [2074] = 2074,
  [2075] = 2075,
  [2076] = 2076,
  [2077] = 2077,
  [2078] = 2078,
  [2079] = 1813,
  [2080] = 1611,
  [2081] = 1738,
  [2082] = 2082,
  [2083] = 1647,
  [2084] = 2084,
  [2085] = 1648,
  [2086] = 1649,
  [2087] = 2087,
  [2088] = 1660,
  [2089] = 237,
  [2090] = 1650,
  [2091] = 2091,
  [2092] = 2092,
  [2093] = 2093,
  [2094] = 1692,
  [2095] = 1731,
  [2096] = 1622,
  [2097] = 1713,
  [2098] = 1714,
  [2099] = 1717,
  [2100] = 1719,
  [2101] = 2072,
  [2102] = 2102,
  [2103] = 2074,
  [2104] = 1721,
  [2105] = 1707,
  [2106] = 1675,
  [2107] = 2107,
  [2108] = 1629,
  [2109] = 1633,
  [2110] = 228,
  [2111] = 1646,
  [2112] = 2112,
  [2113] = 1638,
  [2114] = 231,
  [2115] = 240,
  [2116] = 1678,
  [2117] = 1634,
  [2118] = 1690,
  [2119] = 2072,
  [2120] = 233,
  [2121] = 2074,
  [2122] = 2122,
  [2123] = 2123,
  [2124] = 1702,
  [2125] = 1613,
  [2126] = 1674,
  [2127] = 1618,
  [2128] = 1813,
  [2129] = 1488,
  [2130] = 1496,
  [2131] = 1651,
  [2132] = 2122,
  [2133] = 2123,
  [2134] = 2134,
  [2135] = 1488,
  [2136] = 1496,
  [2137] = 2122,
  [2138] = 2123,
  [2139] = 2122,
  [2140] = 2123,
  [2141] = 2122,
  [2142] = 2123,
  [2143] = 1652,
  [2144] = 2144,
  [2145] = 2145,
  [2146] = 2146,
  [2147] = 1682,
  [2148] = 2148,
  [2149] = 1683,
  [2150] = 1623,
  [2151] = 1624,
  [2152] = 2152,
  [2153] = 2153,
  [2154] = 1632,
  [2155] = 1644,
  [2156] = 1658,
  [2157] = 1662,
  [2158] = 1654,
  [2159] = 1656,
  [2160] = 1657,
  [2161] = 2076,
  [2162] = 1661,
  [2163] = 2107,
  [2164] = 1663,
  [2165] = 1664,
  [2166] = 1665,
  [2167] = 1666,
  [2168] = 1667,
  [2169] = 1725,
  [2170] = 1671,
  [2171] = 1672,
  [2172] = 1684,
  [2173] = 2082,
  [2174] = 1679,
  [2175] = 1680,
  [2176] = 2148,
  [2177] = 1687,
  [2178] = 1688,
  [2179] = 1704,
  [2180] = 1715,
  [2181] = 1720,
  [2182] = 1722,
  [2183] = 1625,
  [2184] = 1626,
  [2185] = 1705,
  [2186] = 2153,
  [2187] = 1723,
  [2188] = 2188,
  [2189] = 1706,
  [2190] = 1711,
  [2191] = 1615,
  [2192] = 1616,
  [2193] = 1630,
  [2194] = 2076,
  [2195] = 2195,
  [2196] = 2196,
  [2197] = 2197,
  [2198] = 2198,
  [2199] = 1685,
  [2200] = 2072,
  [2201] = 2201,
  [2202] = 2202,
  [2203] = 2203,
  [2204] = 2076,
  [2205] = 2205,
  [2206] = 2206,
  [2207] = 2074,
  [2208] = 2208,
  [2209] = 2076,
  [2210] = 2210,
  [2211] = 2211,
  [2212] = 2076,
  [2213] = 2076,
  [2214] = 2214,
  [2215] = 1699,
  [2216] = 1978,
  [2217] = 1708,
  [2218] = 230,
  [2219] = 2219,
  [2220] = 1612,
  [2221] = 2221,
  [2222] = 2222,
  [2223] = 2223,
  [2224] = 235,
  [2225] = 1653,
  [2226] = 1655,
  [2227] = 2152,
  [2228] = 2077,
  [2229] = 1631,
  [2230] = 2198,
  [2231] = 2210,
  [2232] = 2232,
  [2233] = 2233,
  [2234] = 2234,
  [2235] = 2235,
  [2236] = 2236,
  [2237] = 1686,
  [2238] = 1689,
  [2239] = 1709,
  [2240] = 1614,
  [2241] = 2241,
  [2242] = 2242,
  [2243] = 2243,
  [2244] = 1623,
  [2245] = 1624,
  [2246] = 1632,
  [2247] = 1654,
  [2248] = 1656,
  [2249] = 1657,
  [2250] = 1661,
  [2251] = 1663,
  [2252] = 1664,
  [2253] = 1665,
  [2254] = 1666,
  [2255] = 1667,
  [2256] = 1725,
  [2257] = 1671,
  [2258] = 1672,
  [2259] = 1679,
  [2260] = 1680,
  [2261] = 1687,
  [2262] = 1688,
  [2263] = 1715,
  [2264] = 1720,
  [2265] = 1722,
  [2266] = 1625,
  [2267] = 1626,
  [2268] = 1723,
  [2269] = 2072,
  [2270] = 2270,
  [2271] = 1718,
  [2272] = 1673,
  [2273] = 1724,
  [2274] = 1627,
  [2275] = 1643,
  [2276] = 1645,
  [2277] = 1668,
  [2278] = 2278,
  [2279] = 1699,
  [2280] = 1708,
  [2281] = 1710,
  [2282] = 1612,
  [2283] = 2283,
  [2284] = 1557,
  [2285] = 2285,
  [2286] = 2074,
  [2287] = 2232,
  [2288] = 1691,
  [2289] = 2233,
  [2290] = 2290,
  [2291] = 2234,
  [2292] = 2292,
  [2293] = 2293,
  [2294] = 2294,
  [2295] = 2295,
  [2296] = 2296,
  [2297] = 2297,
  [2298] = 2298,
  [2299] = 2299,
  [2300] = 2201,
  [2301] = 243,
  [2302] = 2146,
  [2303] = 244,
  [2304] = 2304,
  [2305] = 1619,
  [2306] = 2306,
  [2307] = 2072,
  [2308] = 1693,
  [2309] = 2074,
  [2310] = 236,
  [2311] = 1978,
  [2312] = 250,
  [2313] = 1675,
  [2314] = 251,
  [2315] = 1620,
  [2316] = 2316,
  [2317] = 1621,
  [2318] = 1738,
  [2319] = 230,
  [2320] = 235,
  [2321] = 1827,
  [2322] = 237,
  [2323] = 2299,
  [2324] = 1694,
  [2325] = 1495,
  [2326] = 236,
  [2327] = 1504,
  [2328] = 1638,
  [2329] = 1738,
  [2330] = 1669,
  [2331] = 2331,
  [2332] = 2332,
  [2333] = 1635,
  [2334] = 1681,
  [2335] = 1703,
  [2336] = 2336,
  [2337] = 2337,
  [2338] = 2278,
  [2339] = 2339,
  [2340] = 2198,
  [2341] = 2341,
  [2342] = 2232,
  [2343] = 2233,
  [2344] = 2235,
  [2345] = 2235,
  [2346] = 1557,
  [2347] = 2299,
  [2348] = 2201,
  [2349] = 2278,
  [2350] = 228,
  [2351] = 240,
  [2352] = 2352,
  [2353] = 2236,
  [2354] = 1710,
  [2355] = 1557,
  [2356] = 2356,
  [2357] = 2357,
  [2358] = 2357,
  [2359] = 1677,
  [2360] = 2360,
  [2361] = 2361,
  [2362] = 2362,
  [2363] = 2363,
  [2364] = 1506,
  [2365] = 2365,
  [2366] = 1490,
  [2367] = 1610,
  [2368] = 1676,
  [2369] = 1695,
  [2370] = 2357,
  [2371] = 2371,
  [2372] = 1677,
  [2373] = 1738,
  [2374] = 1495,
  [2375] = 2375,
  [2376] = 1504,
  [2377] = 2377,
  [2378] = 2357,
  [2379] = 1675,
  [2380] = 1638,
  [2381] = 1676,
  [2382] = 2382,
  [2383] = 1488,
  [2384] = 1496,
  [2385] = 2385,
  [2386] = 2386,
  [2387] = 1835,
  [2388] = 2388,
  [2389] = 2389,
  [2390] = 2390,
  [2391] = 2391,
  [2392] = 2392,
  [2393] = 2392,
  [2394] = 2394,
  [2395] = 2395,
  [2396] = 2375,
  [2397] = 2389,
  [2398] = 2398,
  [2399] = 2399,
  [2400] = 2400,
  [2401] = 2401,
  [2402] = 2402,
  [2403] = 2357,
  [2404] = 2404,
  [2405] = 2405,
  [2406] = 2398,
  [2407] = 2407,
  [2408] = 2399,
  [2409] = 2409,
  [2410] = 253,
  [2411] = 2411,
  [2412] = 2412,
  [2413] = 253,
  [2414] = 1623,
  [2415] = 1624,
  [2416] = 1632,
  [2417] = 1654,
  [2418] = 1656,
  [2419] = 1657,
  [2420] = 1661,
  [2421] = 1663,
  [2422] = 1664,
  [2423] = 1665,
  [2424] = 1666,
  [2425] = 1667,
  [2426] = 1725,
  [2427] = 1671,
  [2428] = 1672,
  [2429] = 1679,
  [2430] = 1680,
  [2431] = 1687,
  [2432] = 1688,
  [2433] = 1715,
  [2434] = 1720,
  [2435] = 1722,
  [2436] = 1625,
  [2437] = 1626,
  [2438] = 1723,
  [2439] = 1699,
  [2440] = 1708,
  [2441] = 1710,
  [2442] = 1612,
  [2443] = 2443,
  [2444] = 2357,
  [2445] = 1813,
  [2446] = 1623,
  [2447] = 1624,
  [2448] = 1632,
  [2449] = 1654,
  [2450] = 1656,
  [2451] = 1657,
  [2452] = 1661,
  [2453] = 1663,
  [2454] = 1664,
  [2455] = 1665,
  [2456] = 1666,
  [2457] = 1667,
  [2458] = 1725,
  [2459] = 1671,
  [2460] = 1672,
  [2461] = 1679,
  [2462] = 1680,
  [2463] = 1687,
  [2464] = 1688,
  [2465] = 1715,
  [2466] = 1720,
  [2467] = 1722,
  [2468] = 1625,
  [2469] = 1626,
  [2470] = 1723,
  [2471] = 1699,
  [2472] = 1708,
  [2473] = 1710,
  [2474] = 1612,
  [2475] = 1738,
  [2476] = 1738,
  [2477] = 2386,
  [2478] = 1626,
  [2479] = 2479,
  [2480] = 2480,
  [2481] = 2481,
  [2482] = 2482,
  [2483] = 2483,
  [2484] = 1506,
  [2485] = 2485,
  [2486] = 1623,
  [2487] = 1624,
  [2488] = 948,
  [2489] = 1490,
  [2490] = 1632,
  [2491] = 1654,
  [2492] = 1656,
  [2493] = 1657,
  [2494] = 1661,
  [2495] = 1663,
  [2496] = 1664,
  [2497] = 1665,
  [2498] = 1666,
  [2499] = 1667,
  [2500] = 1725,
  [2501] = 1671,
  [2502] = 1672,
  [2503] = 1679,
  [2504] = 1680,
  [2505] = 1687,
  [2506] = 1688,
  [2507] = 1978,
  [2508] = 1715,
  [2509] = 1720,
  [2510] = 1722,
  [2511] = 1776,
  [2512] = 2481,
  [2513] = 2513,
  [2514] = 2514,
  [2515] = 2515,
  [2516] = 2516,
  [2517] = 2481,
  [2518] = 1625,
  [2519] = 1557,
  [2520] = 2481,
  [2521] = 957,
  [2522] = 2522,
  [2523] = 2523,
  [2524] = 1738,
  [2525] = 2525,
  [2526] = 2481,
  [2527] = 1723,
  [2528] = 1677,
  [2529] = 1675,
  [2530] = 1638,
  [2531] = 2531,
  [2532] = 2481,
  [2533] = 2533,
  [2534] = 2534,
  [2535] = 2535,
  [2536] = 2536,
  [2537] = 1610,
  [2538] = 2538,
  [2539] = 1676,
  [2540] = 2540,
  [2541] = 2541,
  [2542] = 2542,
  [2543] = 2543,
  [2544] = 2544,
  [2545] = 1695,
  [2546] = 2482,
  [2547] = 2015,
  [2548] = 1699,
  [2549] = 1708,
  [2550] = 1710,
  [2551] = 1612,
  [2552] = 2481,
  [2553] = 2553,
  [2554] = 2481,
  [2555] = 958,
  [2556] = 2556,
  [2557] = 2481,
  [2558] = 1557,
  [2559] = 2559,
  [2560] = 1677,
  [2561] = 2561,
  [2562] = 2562,
  [2563] = 2123,
  [2564] = 2564,
  [2565] = 1813,
  [2566] = 2566,
  [2567] = 2567,
  [2568] = 2122,
  [2569] = 2123,
  [2570] = 2122,
  [2571] = 2123,
  [2572] = 2572,
  [2573] = 2573,
  [2574] = 2567,
  [2575] = 2575,
  [2576] = 2576,
  [2577] = 2577,
  [2578] = 1557,
  [2579] = 2579,
  [2580] = 2580,
  [2581] = 2581,
  [2582] = 2582,
  [2583] = 2583,
  [2584] = 2584,
  [2585] = 2585,
  [2586] = 2586,
  [2587] = 2412,
  [2588] = 2122,
  [2589] = 2123,
  [2590] = 2590,
  [2591] = 2122,
  [2592] = 2123,
  [2593] = 2593,
  [2594] = 2594,
  [2595] = 2595,
  [2596] = 2122,
  [2597] = 2123,
  [2598] = 1557,
  [2599] = 2122,
  [2600] = 2600,
  [2601] = 242,
  [2602] = 2602,
  [2603] = 2600,
  [2604] = 2604,
  [2605] = 2605,
  [2606] = 1217,
  [2607] = 2607,
  [2608] = 2608,
  [2609] = 249,
  [2610] = 2610,
  [2611] = 2611,
  [2612] = 2612,
  [2613] = 2613,
  [2614] = 2614,
  [2615] = 2615,
  [2616] = 2616,
  [2617] = 2617,
  [2618] = 2618,
  [2619] = 2619,
  [2620] = 2620,
  [2621] = 2621,
  [2622] = 2600,
  [2623] = 246,
  [2624] = 2624,
  [2625] = 2625,
  [2626] = 2600,
  [2627] = 2600,
  [2628] = 2628,
  [2629] = 232,
  [2630] = 2630,
  [2631] = 2631,
  [2632] = 2600,
  [2633] = 2600,
  [2634] = 2634,
  [2635] = 2635,
  [2636] = 249,
  [2637] = 2637,
  [2638] = 2638,
  [2639] = 2639,
  [2640] = 2640,
  [2641] = 2641,
  [2642] = 2642,
  [2643] = 2643,
  [2644] = 2644,
  [2645] = 2645,
  [2646] = 2646,
  [2647] = 2647,
  [2648] = 2648,
  [2649] = 2649,
  [2650] = 2650,
  [2651] = 2651,
  [2652] = 2652,
  [2653] = 2653,
  [2654] = 2654,
  [2655] = 2600,
  [2656] = 2656,
  [2657] = 2657,
  [2658] = 2600,
  [2659] = 246,
  [2660] = 2660,
  [2661] = 1511,
  [2662] = 2662,
  [2663] = 2663,
  [2664] = 2664,
  [2665] = 2665,
  [2666] = 2666,
  [2667] = 2525,
  [2668] = 242,
  [2669] = 2523,
  [2670] = 1533,
  [2671] = 2671,
  [2672] = 2672,
  [2673] = 232,
  [2674] = 2674,
  [2675] = 2675,
  [2676] = 2676,
  [2677] = 2241,
  [2678] = 2678,
  [2679] = 2316,
  [2680] = 2680,
  [2681] = 2681,
  [2682] = 2112,
  [2683] = 2683,
  [2684] = 2684,
  [2685] = 2685,
  [2686] = 2686,
  [2687] = 2687,
  [2688] = 2202,
  [2689] = 1247,
  [2690] = 2690,
  [2691] = 2691,
  [2692] = 2692,
  [2693] = 2371,
  [2694] = 2399,
  [2695] = 2375,
  [2696] = 2409,
  [2697] = 2362,
  [2698] = 2698,
  [2699] = 2388,
  [2700] = 2411,
  [2701] = 2389,
  [2702] = 2390,
  [2703] = 2391,
  [2704] = 2375,
  [2705] = 2389,
  [2706] = 2398,
  [2707] = 2399,
  [2708] = 2692,
  [2709] = 2709,
  [2710] = 2405,
  [2711] = 2398,
  [2712] = 2712,
  [2713] = 2407,
  [2714] = 2362,
  [2715] = 2371,
  [2716] = 2388,
  [2717] = 1253,
  [2718] = 2405,
  [2719] = 2691,
  [2720] = 2720,
  [2721] = 2721,
  [2722] = 2722,
  [2723] = 2723,
  [2724] = 2724,
  [2725] = 2725,
  [2726] = 2726,
  [2727] = 2725,
  [2728] = 2728,
  [2729] = 2724,
  [2730] = 2730,
  [2731] = 2731,
  [2732] = 2732,
  [2733] = 2724,
  [2734] = 2720,
  [2735] = 2725,
  [2736] = 2730,
  [2737] = 2731,
  [2738] = 2721,
  [2739] = 2722,
  [2740] = 2724,
  [2741] = 2741,
  [2742] = 2742,
  [2743] = 2743,
  [2744] = 2744,
  [2745] = 2745,
  [2746] = 2746,
  [2747] = 1270,
  [2748] = 2748,
  [2749] = 1290,
  [2750] = 2750,
  [2751] = 1302,
  [2752] = 1284,
  [2753] = 1259,
  [2754] = 2754,
  [2755] = 2755,
  [2756] = 2756,
  [2757] = 2757,
  [2758] = 2758,
  [2759] = 2356,
  [2760] = 2760,
  [2761] = 2761,
  [2762] = 2762,
  [2763] = 2763,
  [2764] = 2764,
  [2765] = 2765,
  [2766] = 2766,
  [2767] = 2767,
  [2768] = 2768,
  [2769] = 2769,
  [2770] = 2770,
  [2771] = 2771,
  [2772] = 2772,
  [2773] = 2773,
  [2774] = 2774,
  [2775] = 2775,
  [2776] = 2776,
  [2777] = 2775,
  [2778] = 2778,
  [2779] = 2779,
  [2780] = 2772,
  [2781] = 2781,
  [2782] = 2782,
  [2783] = 2783,
  [2784] = 2767,
  [2785] = 2785,
  [2786] = 2786,
  [2787] = 2774,
  [2788] = 2788,
  [2789] = 2789,
  [2790] = 2790,
  [2791] = 2791,
  [2792] = 2792,
  [2793] = 2793,
  [2794] = 2794,
  [2795] = 2795,
  [2796] = 2796,
  [2797] = 2797,
  [2798] = 2798,
  [2799] = 2799,
  [2800] = 2800,
  [2801] = 2801,
  [2802] = 2802,
  [2803] = 2801,
  [2804] = 2804,
  [2805] = 2805,
  [2806] = 2771,
  [2807] = 2807,
  [2808] = 2808,
  [2809] = 2779,
  [2810] = 2770,
  [2811] = 2811,
  [2812] = 2812,
  [2813] = 2813,
  [2814] = 2814,
  [2815] = 2815,
  [2816] = 2816,
  [2817] = 2817,
  [2818] = 2811,
  [2819] = 2819,
  [2820] = 2820,
  [2821] = 2821,
  [2822] = 2816,
  [2823] = 2823,
  [2824] = 2824,
  [2825] = 2769,
  [2826] = 2776,
  [2827] = 2827,
  [2828] = 2828,
  [2829] = 1466,
  [2830] = 1468,
  [2831] = 1463,
  [2832] = 1573,
  [2833] = 1602,
  [2834] = 1600,
  [2835] = 1603,
  [2836] = 1607,
  [2837] = 1584,
  [2838] = 1589,
  [2839] = 1593,
  [2840] = 1590,
  [2841] = 1591,
  [2842] = 1604,
  [2843] = 1560,
  [2844] = 1605,
  [2845] = 1563,
  [2846] = 1564,
  [2847] = 1565,
  [2848] = 1601,
  [2849] = 1567,
  [2850] = 1586,
  [2851] = 1587,
  [2852] = 1588,
  [2853] = 1585,
  [2854] = 1568,
  [2855] = 1592,
  [2856] = 1569,
  [2857] = 1570,
  [2858] = 1571,
  [2859] = 1572,
  [2860] = 1574,
  [2861] = 1575,
  [2862] = 1598,
  [2863] = 1599,
  [2864] = 1606,
  [2865] = 1566,
  [2866] = 241,
  [2867] = 2867,
  [2868] = 2867,
  [2869] = 1484,
  [2870] = 248,
  [2871] = 1549,
  [2872] = 1609,
  [2873] = 2873,
  [2874] = 1551,
  [2875] = 1550,
  [2876] = 1537,
  [2877] = 1465,
  [2878] = 1552,
  [2879] = 1518,
  [2880] = 1535,
  [2881] = 1543,
  [2882] = 1544,
  [2883] = 1468,
  [2884] = 1466,
  [2885] = 1485,
  [2886] = 1545,
  [2887] = 1463,
  [2888] = 1546,
  [2889] = 1517,
  [2890] = 1530,
  [2891] = 1486,
  [2892] = 1487,
  [2893] = 1532,
  [2894] = 1499,
  [2895] = 1512,
  [2896] = 1482,
  [2897] = 1478,
  [2898] = 1491,
  [2899] = 1591,
  [2900] = 1524,
  [2901] = 1567,
  [2902] = 2902,
  [2903] = 1547,
  [2904] = 1568,
  [2905] = 1598,
  [2906] = 1599,
  [2907] = 1600,
  [2908] = 1553,
  [2909] = 1525,
  [2910] = 2902,
  [2911] = 2911,
  [2912] = 2912,
  [2913] = 2913,
  [2914] = 2914,
  [2915] = 1556,
  [2916] = 1569,
  [2917] = 1527,
  [2918] = 1601,
  [2919] = 1529,
  [2920] = 1570,
  [2921] = 1602,
  [2922] = 1531,
  [2923] = 2902,
  [2924] = 1603,
  [2925] = 1571,
  [2926] = 1509,
  [2927] = 1510,
  [2928] = 1604,
  [2929] = 1605,
  [2930] = 1606,
  [2931] = 1513,
  [2932] = 1514,
  [2933] = 1594,
  [2934] = 1607,
  [2935] = 1515,
  [2936] = 1492,
  [2937] = 2911,
  [2938] = 2912,
  [2939] = 2913,
  [2940] = 2914,
  [2941] = 1572,
  [2942] = 1573,
  [2943] = 2902,
  [2944] = 1574,
  [2945] = 1560,
  [2946] = 1466,
  [2947] = 1463,
  [2948] = 1468,
  [2949] = 2911,
  [2950] = 2912,
  [2951] = 1593,
  [2952] = 2914,
  [2953] = 1575,
  [2954] = 2902,
  [2955] = 1595,
  [2956] = 2911,
  [2957] = 2912,
  [2958] = 2913,
  [2959] = 2914,
  [2960] = 1563,
  [2961] = 1564,
  [2962] = 1565,
  [2963] = 1596,
  [2964] = 2902,
  [2965] = 1566,
  [2966] = 1584,
  [2967] = 1585,
  [2968] = 1586,
  [2969] = 2902,
  [2970] = 1507,
  [2971] = 1587,
  [2972] = 1519,
  [2973] = 2911,
  [2974] = 1588,
  [2975] = 1589,
  [2976] = 2912,
  [2977] = 1608,
  [2978] = 1465,
  [2979] = 1590,
  [2980] = 2913,
  [2981] = 1508,
  [2982] = 1520,
  [2983] = 2914,
  [2984] = 1576,
  [2985] = 1578,
  [2986] = 1580,
  [2987] = 1536,
  [2988] = 1581,
  [2989] = 1538,
  [2990] = 2902,
  [2991] = 1592,
  [2992] = 1539,
  [2993] = 1521,
  [2994] = 1540,
  [2995] = 1541,
  [2996] = 2902,
  [2997] = 1523,
  [2998] = 1542,
  [2999] = 2913,
  [3000] = 3000,
  [3001] = 3001,
  [3002] = 1475,
  [3003] = 3003,
  [3004] = 3004,
  [3005] = 3005,
  [3006] = 3006,
  [3007] = 3007,
  [3008] = 3008,
  [3009] = 3009,
  [3010] = 3010,
  [3011] = 3011,
  [3012] = 3012,
  [3013] = 3013,
  [3014] = 3014,
  [3015] = 3015,
  [3016] = 3007,
  [3017] = 3017,
  [3018] = 1473,
  [3019] = 3001,
  [3020] = 3020,
  [3021] = 3021,
  [3022] = 3022,
  [3023] = 3023,
  [3024] = 3007,
  [3025] = 3025,
  [3026] = 3026,
  [3027] = 3027,
  [3028] = 1484,
  [3029] = 1482,
  [3030] = 3001,
  [3031] = 3031,
  [3032] = 3032,
  [3033] = 3007,
  [3034] = 3034,
  [3035] = 3001,
  [3036] = 1477,
  [3037] = 3001,
  [3038] = 3001,
  [3039] = 3007,
  [3040] = 3040,
  [3041] = 3001,
  [3042] = 1607,
  [3043] = 1609,
  [3044] = 3044,
  [3045] = 1604,
  [3046] = 1535,
  [3047] = 957,
  [3048] = 3048,
  [3049] = 1602,
  [3050] = 1605,
  [3051] = 1593,
  [3052] = 3052,
  [3053] = 1549,
  [3054] = 3054,
  [3055] = 3055,
  [3056] = 1603,
  [3057] = 1598,
  [3058] = 1526,
  [3059] = 1606,
  [3060] = 1543,
  [3061] = 1528,
  [3062] = 1550,
  [3063] = 1579,
  [3064] = 1554,
  [3065] = 1545,
  [3066] = 1548,
  [3067] = 1494,
  [3068] = 1582,
  [3069] = 3069,
  [3070] = 1485,
  [3071] = 1537,
  [3072] = 1592,
  [3073] = 1546,
  [3074] = 3052,
  [3075] = 3075,
  [3076] = 1599,
  [3077] = 1600,
  [3078] = 1517,
  [3079] = 948,
  [3080] = 3080,
  [3081] = 3081,
  [3082] = 1493,
  [3083] = 1552,
  [3084] = 1465,
  [3085] = 1560,
  [3086] = 1563,
  [3087] = 1564,
  [3088] = 1565,
  [3089] = 1566,
  [3090] = 1567,
  [3091] = 1568,
  [3092] = 1569,
  [3093] = 1570,
  [3094] = 1571,
  [3095] = 1572,
  [3096] = 1573,
  [3097] = 1574,
  [3098] = 1575,
  [3099] = 1518,
  [3100] = 1544,
  [3101] = 1601,
  [3102] = 1551,
  [3103] = 1584,
  [3104] = 1585,
  [3105] = 1586,
  [3106] = 1587,
  [3107] = 1588,
  [3108] = 1589,
  [3109] = 1590,
  [3110] = 3110,
  [3111] = 3111,
  [3112] = 1489,
  [3113] = 1591,
  [3114] = 958,
  [3115] = 1522,
  [3116] = 1486,
  [3117] = 3117,
  [3118] = 3118,
  [3119] = 1491,
  [3120] = 3120,
  [3121] = 3121,
  [3122] = 1475,
  [3123] = 3123,
  [3124] = 3124,
  [3125] = 3117,
  [3126] = 3126,
  [3127] = 1484,
  [3128] = 1482,
  [3129] = 3129,
  [3130] = 3130,
  [3131] = 3131,
  [3132] = 3132,
  [3133] = 3133,
  [3134] = 3134,
  [3135] = 3135,
  [3136] = 3136,
  [3137] = 3137,
  [3138] = 3138,
  [3139] = 3117,
  [3140] = 3140,
  [3141] = 3129,
  [3142] = 3142,
  [3143] = 3143,
  [3144] = 3144,
  [3145] = 3145,
  [3146] = 3129,
  [3147] = 3147,
  [3148] = 3148,
  [3149] = 1487,
  [3150] = 3150,
  [3151] = 3151,
  [3152] = 3152,
  [3153] = 3153,
  [3154] = 3154,
  [3155] = 3155,
  [3156] = 3156,
  [3157] = 3157,
  [3158] = 1478,
  [3159] = 1512,
  [3160] = 3160,
  [3161] = 1473,
  [3162] = 3162,
  [3163] = 1477,
  [3164] = 1466,
  [3165] = 1463,
  [3166] = 1468,
  [3167] = 3167,
  [3168] = 3168,
  [3169] = 3129,
  [3170] = 3117,
  [3171] = 3171,
  [3172] = 1532,
  [3173] = 3129,
  [3174] = 1499,
  [3175] = 3175,
  [3176] = 1530,
  [3177] = 3177,
  [3178] = 1527,
  [3179] = 1579,
  [3180] = 1492,
  [3181] = 1543,
  [3182] = 3182,
  [3183] = 1546,
  [3184] = 686,
  [3185] = 3185,
  [3186] = 1535,
  [3187] = 1537,
  [3188] = 1553,
  [3189] = 1578,
  [3190] = 1609,
  [3191] = 1485,
  [3192] = 1554,
  [3193] = 1493,
  [3194] = 1494,
  [3195] = 1580,
  [3196] = 1465,
  [3197] = 1536,
  [3198] = 1581,
  [3199] = 3182,
  [3200] = 1594,
  [3201] = 1595,
  [3202] = 1596,
  [3203] = 688,
  [3204] = 1582,
  [3205] = 958,
  [3206] = 687,
  [3207] = 1538,
  [3208] = 1517,
  [3209] = 1539,
  [3210] = 1507,
  [3211] = 1508,
  [3212] = 1518,
  [3213] = 1509,
  [3214] = 1540,
  [3215] = 1510,
  [3216] = 3185,
  [3217] = 3217,
  [3218] = 1513,
  [3219] = 1515,
  [3220] = 1544,
  [3221] = 3221,
  [3222] = 1545,
  [3223] = 3223,
  [3224] = 1549,
  [3225] = 1550,
  [3226] = 684,
  [3227] = 1556,
  [3228] = 1489,
  [3229] = 1551,
  [3230] = 1552,
  [3231] = 1608,
  [3232] = 685,
  [3233] = 1541,
  [3234] = 948,
  [3235] = 1542,
  [3236] = 1548,
  [3237] = 957,
  [3238] = 3182,
  [3239] = 1519,
  [3240] = 1520,
  [3241] = 1521,
  [3242] = 1522,
  [3243] = 1523,
  [3244] = 1524,
  [3245] = 1525,
  [3246] = 1526,
  [3247] = 3185,
  [3248] = 3153,
  [3249] = 1528,
  [3250] = 1547,
  [3251] = 3185,
  [3252] = 3182,
  [3253] = 1576,
  [3254] = 3254,
  [3255] = 1529,
  [3256] = 1531,
  [3257] = 1514,
  [3258] = 3258,
  [3259] = 3259,
  [3260] = 3260,
  [3261] = 1532,
  [3262] = 3262,
  [3263] = 1482,
  [3264] = 3264,
  [3265] = 3264,
  [3266] = 3266,
  [3267] = 3267,
  [3268] = 3268,
  [3269] = 3269,
  [3270] = 3259,
  [3271] = 3271,
  [3272] = 3264,
  [3273] = 3273,
  [3274] = 3274,
  [3275] = 1475,
  [3276] = 1465,
  [3277] = 3274,
  [3278] = 3278,
  [3279] = 3279,
  [3280] = 1477,
  [3281] = 3281,
  [3282] = 3282,
  [3283] = 3262,
  [3284] = 1486,
  [3285] = 1478,
  [3286] = 1530,
  [3287] = 1512,
  [3288] = 3258,
  [3289] = 3274,
  [3290] = 3290,
  [3291] = 3262,
  [3292] = 1473,
  [3293] = 3264,
  [3294] = 3294,
  [3295] = 3295,
  [3296] = 1536,
  [3297] = 3297,
  [3298] = 3298,
  [3299] = 3299,
  [3300] = 3129,
  [3301] = 3301,
  [3302] = 3302,
  [3303] = 3303,
  [3304] = 3304,
  [3305] = 3305,
  [3306] = 1538,
  [3307] = 3307,
  [3308] = 3308,
  [3309] = 3309,
  [3310] = 3310,
  [3311] = 3309,
  [3312] = 3312,
  [3313] = 3310,
  [3314] = 3308,
  [3315] = 3315,
  [3316] = 3316,
  [3317] = 3317,
  [3318] = 3304,
  [3319] = 3319,
  [3320] = 3320,
  [3321] = 1513,
  [3322] = 3322,
  [3323] = 1539,
  [3324] = 3324,
  [3325] = 1514,
  [3326] = 1515,
  [3327] = 3327,
  [3328] = 3328,
  [3329] = 1540,
  [3330] = 1596,
  [3331] = 3316,
  [3332] = 3317,
  [3333] = 3333,
  [3334] = 3266,
  [3335] = 3335,
  [3336] = 3336,
  [3337] = 3308,
  [3338] = 1608,
  [3339] = 3339,
  [3340] = 3310,
  [3341] = 3299,
  [3342] = 3342,
  [3343] = 684,
  [3344] = 3344,
  [3345] = 3304,
  [3346] = 241,
  [3347] = 3347,
  [3348] = 3327,
  [3349] = 3309,
  [3350] = 3304,
  [3351] = 1519,
  [3352] = 1520,
  [3353] = 1521,
  [3354] = 1541,
  [3355] = 1522,
  [3356] = 1523,
  [3357] = 1524,
  [3358] = 1542,
  [3359] = 1526,
  [3360] = 1527,
  [3361] = 3129,
  [3362] = 1528,
  [3363] = 3339,
  [3364] = 3310,
  [3365] = 3327,
  [3366] = 3366,
  [3367] = 3367,
  [3368] = 3129,
  [3369] = 3316,
  [3370] = 3299,
  [3371] = 1529,
  [3372] = 3372,
  [3373] = 3307,
  [3374] = 3374,
  [3375] = 3375,
  [3376] = 1482,
  [3377] = 3377,
  [3378] = 3378,
  [3379] = 3379,
  [3380] = 3380,
  [3381] = 1547,
  [3382] = 1548,
  [3383] = 3383,
  [3384] = 3339,
  [3385] = 3129,
  [3386] = 3386,
  [3387] = 3129,
  [3388] = 3129,
  [3389] = 1489,
  [3390] = 3390,
  [3391] = 3391,
  [3392] = 1492,
  [3393] = 3393,
  [3394] = 3394,
  [3395] = 3299,
  [3396] = 3267,
  [3397] = 3316,
  [3398] = 1491,
  [3399] = 3399,
  [3400] = 3400,
  [3401] = 3401,
  [3402] = 3402,
  [3403] = 1553,
  [3404] = 1554,
  [3405] = 1556,
  [3406] = 3406,
  [3407] = 1487,
  [3408] = 3408,
  [3409] = 3344,
  [3410] = 3309,
  [3411] = 687,
  [3412] = 3307,
  [3413] = 3390,
  [3414] = 248,
  [3415] = 1493,
  [3416] = 1594,
  [3417] = 3417,
  [3418] = 688,
  [3419] = 3419,
  [3420] = 1507,
  [3421] = 3421,
  [3422] = 3279,
  [3423] = 3423,
  [3424] = 1595,
  [3425] = 1494,
  [3426] = 1576,
  [3427] = 1578,
  [3428] = 3307,
  [3429] = 3429,
  [3430] = 3430,
  [3431] = 3431,
  [3432] = 3432,
  [3433] = 3433,
  [3434] = 3339,
  [3435] = 3435,
  [3436] = 3436,
  [3437] = 3437,
  [3438] = 3308,
  [3439] = 3439,
  [3440] = 1579,
  [3441] = 1580,
  [3442] = 1581,
  [3443] = 1508,
  [3444] = 3444,
  [3445] = 3445,
  [3446] = 1582,
  [3447] = 3328,
  [3448] = 1525,
  [3449] = 1499,
  [3450] = 685,
  [3451] = 3451,
  [3452] = 3452,
  [3453] = 3390,
  [3454] = 3454,
  [3455] = 3455,
  [3456] = 1531,
  [3457] = 3322,
  [3458] = 3327,
  [3459] = 3459,
  [3460] = 3460,
  [3461] = 3328,
  [3462] = 3400,
  [3463] = 1509,
  [3464] = 3324,
  [3465] = 3391,
  [3466] = 3466,
  [3467] = 3467,
  [3468] = 3468,
  [3469] = 3469,
  [3470] = 686,
  [3471] = 3471,
  [3472] = 1510,
  [3473] = 3473,
  [3474] = 3474,
  [3475] = 3475,
  [3476] = 3153,
  [3477] = 3477,
  [3478] = 3478,
  [3479] = 3479,
  [3480] = 3480,
  [3481] = 241,
  [3482] = 3279,
  [3483] = 248,
  [3484] = 3484,
  [3485] = 3485,
  [3486] = 3486,
  [3487] = 3484,
  [3488] = 3488,
  [3489] = 3489,
  [3490] = 958,
  [3491] = 3484,
  [3492] = 957,
  [3493] = 948,
  [3494] = 3485,
  [3495] = 3485,
  [3496] = 3496,
  [3497] = 3497,
  [3498] = 3484,
  [3499] = 3485,
  [3500] = 3477,
  [3501] = 3484,
  [3502] = 219,
  [3503] = 1473,
  [3504] = 223,
  [3505] = 1477,
  [3506] = 3485,
  [3507] = 3485,
  [3508] = 3485,
  [3509] = 3478,
  [3510] = 3485,
  [3511] = 3484,
  [3512] = 229,
  [3513] = 239,
  [3514] = 1475,
  [3515] = 3515,
  [3516] = 3516,
  [3517] = 3517,
  [3518] = 3518,
  [3519] = 3519,
  [3520] = 3520,
  [3521] = 3521,
  [3522] = 3223,
  [3523] = 3523,
  [3524] = 3524,
  [3525] = 3525,
  [3526] = 3526,
  [3527] = 3527,
  [3528] = 3528,
  [3529] = 3529,
  [3530] = 3530,
  [3531] = 3531,
  [3532] = 3532,
  [3533] = 3533,
  [3534] = 3534,
  [3535] = 3535,
  [3536] = 3536,
  [3537] = 3537,
  [3538] = 3538,
  [3539] = 3539,
  [3540] = 3540,
  [3541] = 3541,
  [3542] = 3542,
  [3543] = 3543,
  [3544] = 3544,
  [3545] = 3545,
  [3546] = 3546,
  [3547] = 3547,
  [3548] = 3548,
  [3549] = 3549,
  [3550] = 3550,
  [3551] = 3551,
  [3552] = 3552,
  [3553] = 3553,
  [3554] = 3554,
  [3555] = 3555,
  [3556] = 3556,
  [3557] = 3557,
  [3558] = 3558,
  [3559] = 1489,
  [3560] = 3560,
  [3561] = 3561,
  [3562] = 3562,
  [3563] = 3563,
  [3564] = 3564,
  [3565] = 3565,
  [3566] = 3566,
  [3567] = 3567,
  [3568] = 3568,
  [3569] = 3569,
  [3570] = 3570,
  [3571] = 3571,
  [3572] = 3572,
  [3573] = 229,
  [3574] = 239,
  [3575] = 3575,
  [3576] = 3576,
  [3577] = 3571,
  [3578] = 3578,
  [3579] = 3579,
  [3580] = 3580,
  [3581] = 3581,
  [3582] = 3582,
  [3583] = 3583,
  [3584] = 3584,
  [3585] = 3585,
  [3586] = 3586,
  [3587] = 3587,
  [3588] = 3568,
  [3589] = 3589,
  [3590] = 3590,
  [3591] = 3591,
  [3592] = 3592,
  [3593] = 3593,
  [3594] = 3347,
  [3595] = 3595,
  [3596] = 3596,
  [3597] = 3597,
  [3598] = 3598,
  [3599] = 3599,
  [3600] = 3600,
  [3601] = 3601,
  [3602] = 3602,
  [3603] = 3603,
  [3604] = 3604,
  [3605] = 3605,
  [3606] = 3606,
  [3607] = 3587,
  [3608] = 3608,
  [3609] = 3609,
  [3610] = 3610,
  [3611] = 3611,
  [3612] = 3582,
  [3613] = 3613,
  [3614] = 3614,
  [3615] = 3615,
  [3616] = 3429,
  [3617] = 3587,
  [3618] = 3618,
  [3619] = 3619,
  [3620] = 3620,
  [3621] = 3621,
  [3622] = 3622,
  [3623] = 3623,
  [3624] = 3624,
  [3625] = 3625,
  [3626] = 3626,
  [3627] = 3627,
  [3628] = 3628,
  [3629] = 3629,
  [3630] = 3630,
  [3631] = 3596,
  [3632] = 1475,
  [3633] = 3582,
  [3634] = 3595,
  [3635] = 3536,
  [3636] = 3587,
  [3637] = 3637,
  [3638] = 3638,
  [3639] = 3639,
  [3640] = 3640,
  [3641] = 3641,
  [3642] = 3568,
  [3643] = 3643,
  [3644] = 3555,
  [3645] = 3582,
  [3646] = 3646,
  [3647] = 3647,
  [3648] = 3562,
  [3649] = 3603,
  [3650] = 3650,
  [3651] = 3582,
  [3652] = 1522,
  [3653] = 3653,
  [3654] = 1528,
  [3655] = 3587,
  [3656] = 3656,
  [3657] = 216,
  [3658] = 3271,
  [3659] = 3659,
  [3660] = 3660,
  [3661] = 3582,
  [3662] = 3662,
  [3663] = 3663,
  [3664] = 3664,
  [3665] = 3665,
  [3666] = 3666,
  [3667] = 3667,
  [3668] = 3668,
  [3669] = 3669,
  [3670] = 3670,
  [3671] = 3671,
  [3672] = 3672,
  [3673] = 3673,
  [3674] = 3674,
  [3675] = 3675,
  [3676] = 3676,
  [3677] = 3677,
  [3678] = 3678,
  [3679] = 3593,
  [3680] = 3528,
  [3681] = 3681,
  [3682] = 3682,
  [3683] = 3683,
  [3684] = 3587,
  [3685] = 3685,
  [3686] = 3541,
  [3687] = 3687,
  [3688] = 3688,
  [3689] = 3689,
  [3690] = 3690,
  [3691] = 3691,
  [3692] = 3638,
  [3693] = 3693,
  [3694] = 3681,
  [3695] = 3567,
  [3696] = 3696,
  [3697] = 3638,
  [3698] = 3698,
  [3699] = 3699,
  [3700] = 3700,
  [3701] = 3701,
  [3702] = 3702,
  [3703] = 3693,
  [3704] = 3582,
  [3705] = 3705,
  [3706] = 3643,
  [3707] = 3707,
  [3708] = 3708,
  [3709] = 3709,
  [3710] = 3571,
  [3711] = 3711,
  [3712] = 3712,
  [3713] = 3713,
  [3714] = 3714,
  [3715] = 3715,
  [3716] = 3716,
  [3717] = 3717,
  [3718] = 3718,
  [3719] = 3719,
  [3720] = 3720,
  [3721] = 3721,
  [3722] = 3722,
  [3723] = 1473,
  [3724] = 3724,
  [3725] = 1477,
  [3726] = 3527,
  [3727] = 3727,
  [3728] = 3728,
  [3729] = 3729,
  [3730] = 3730,
  [3731] = 3731,
  [3732] = 3732,
  [3733] = 3628,
  [3734] = 3294,
  [3735] = 3735,
  [3736] = 3736,
  [3737] = 3595,
  [3738] = 3738,
  [3739] = 3393,
  [3740] = 3668,
  [3741] = 3741,
  [3742] = 3647,
  [3743] = 3628,
  [3744] = 3744,
  [3745] = 3741,
  [3746] = 3746,
  [3747] = 3747,
  [3748] = 3748,
  [3749] = 1579,
  [3750] = 3750,
  [3751] = 3471,
  [3752] = 1582,
  [3753] = 1548,
  [3754] = 1554,
  [3755] = 3582,
  [3756] = 3756,
  [3757] = 1493,
  [3758] = 1494,
  [3759] = 3759,
  [3760] = 3760,
  [3761] = 3761,
  [3762] = 3762,
  [3763] = 3763,
  [3764] = 3764,
  [3765] = 3765,
  [3766] = 1526,
  [3767] = 3727,
  [3768] = 3768,
  [3769] = 3769,
  [3770] = 3770,
  [3771] = 3771,
  [3772] = 3772,
  [3773] = 3770,
  [3774] = 3774,
  [3775] = 3775,
  [3776] = 3776,
  [3777] = 687,
  [3778] = 3778,
  [3779] = 3779,
  [3780] = 3780,
  [3781] = 685,
  [3782] = 3782,
  [3783] = 3583,
  [3784] = 688,
  [3785] = 3785,
  [3786] = 3653,
  [3787] = 1491,
  [3788] = 3759,
  [3789] = 3682,
  [3790] = 3778,
  [3791] = 3791,
  [3792] = 3792,
  [3793] = 3793,
  [3794] = 3794,
  [3795] = 3795,
  [3796] = 3796,
  [3797] = 1487,
  [3798] = 3798,
  [3799] = 1493,
  [3800] = 1489,
  [3801] = 1494,
  [3802] = 3802,
  [3803] = 3803,
  [3804] = 3804,
  [3805] = 3805,
  [3806] = 3806,
  [3807] = 3807,
  [3808] = 3533,
  [3809] = 3778,
  [3810] = 3524,
  [3811] = 3529,
  [3812] = 3812,
  [3813] = 3813,
  [3814] = 3814,
  [3815] = 3770,
  [3816] = 3816,
  [3817] = 3659,
  [3818] = 3818,
  [3819] = 3812,
  [3820] = 3780,
  [3821] = 1499,
  [3822] = 1579,
  [3823] = 3544,
  [3824] = 3824,
  [3825] = 3825,
  [3826] = 3826,
  [3827] = 3827,
  [3828] = 3769,
  [3829] = 1582,
  [3830] = 3769,
  [3831] = 3771,
  [3832] = 3832,
  [3833] = 3816,
  [3834] = 3834,
  [3835] = 3770,
  [3836] = 3836,
  [3837] = 3825,
  [3838] = 3838,
  [3839] = 3683,
  [3840] = 3840,
  [3841] = 3841,
  [3842] = 3774,
  [3843] = 3575,
  [3844] = 3771,
  [3845] = 3845,
  [3846] = 3846,
  [3847] = 3660,
  [3848] = 3267,
  [3849] = 684,
  [3850] = 3850,
  [3851] = 3779,
  [3852] = 3852,
  [3853] = 3853,
  [3854] = 3854,
  [3855] = 3770,
  [3856] = 3662,
  [3857] = 3857,
  [3858] = 3778,
  [3859] = 3779,
  [3860] = 3266,
  [3861] = 3774,
  [3862] = 3862,
  [3863] = 3778,
  [3864] = 3791,
  [3865] = 3852,
  [3866] = 3850,
  [3867] = 3805,
  [3868] = 3853,
  [3869] = 3869,
  [3870] = 3792,
  [3871] = 3769,
  [3872] = 3803,
  [3873] = 1522,
  [3874] = 1526,
  [3875] = 1528,
  [3876] = 3771,
  [3877] = 3778,
  [3878] = 3780,
  [3879] = 3795,
  [3880] = 3221,
  [3881] = 3687,
  [3882] = 3688,
  [3883] = 3883,
  [3884] = 3803,
  [3885] = 3885,
  [3886] = 3769,
  [3887] = 3838,
  [3888] = 3883,
  [3889] = 3771,
  [3890] = 3834,
  [3891] = 3891,
  [3892] = 3862,
  [3893] = 3893,
  [3894] = 686,
  [3895] = 3794,
  [3896] = 3770,
  [3897] = 3579,
  [3898] = 1548,
  [3899] = 3670,
  [3900] = 3728,
  [3901] = 3576,
  [3902] = 3869,
  [3903] = 3780,
  [3904] = 3730,
  [3905] = 3841,
  [3906] = 3780,
  [3907] = 3862,
  [3908] = 3785,
  [3909] = 3909,
  [3910] = 3778,
  [3911] = 3911,
  [3912] = 3731,
  [3913] = 3732,
  [3914] = 3914,
  [3915] = 3763,
  [3916] = 3804,
  [3917] = 3917,
  [3918] = 3738,
  [3919] = 3805,
  [3920] = 3769,
  [3921] = 3764,
  [3922] = 1554,
  [3923] = 3771,
  [3924] = 3924,
  [3925] = 3780,
  [3926] = 3813,
  [3927] = 3927,
  [3928] = 3928,
  [3929] = 3929,
  [3930] = 3930,
  [3931] = 3931,
  [3932] = 3932,
  [3933] = 3933,
  [3934] = 3934,
  [3935] = 3935,
  [3936] = 3936,
  [3937] = 3937,
  [3938] = 3938,
  [3939] = 3939,
  [3940] = 3940,
  [3941] = 3941,
  [3942] = 3942,
  [3943] = 908,
  [3944] = 909,
  [3945] = 910,
  [3946] = 3946,
  [3947] = 3947,
  [3948] = 3948,
  [3949] = 3949,
  [3950] = 3950,
  [3951] = 3951,
  [3952] = 3952,
  [3953] = 3951,
  [3954] = 3954,
  [3955] = 3955,
  [3956] = 3956,
  [3957] = 3957,
  [3958] = 3818,
  [3959] = 3832,
  [3960] = 3836,
  [3961] = 3961,
  [3962] = 843,
  [3963] = 901,
  [3964] = 858,
  [3965] = 893,
  [3966] = 896,
  [3967] = 780,
  [3968] = 912,
  [3969] = 913,
  [3970] = 914,
  [3971] = 879,
  [3972] = 3972,
  [3973] = 3973,
  [3974] = 3974,
  [3975] = 3975,
  [3976] = 3976,
  [3977] = 3977,
  [3978] = 3549,
  [3979] = 3979,
  [3980] = 812,
  [3981] = 813,
  [3982] = 831,
  [3983] = 3983,
  [3984] = 3984,
  [3985] = 3985,
  [3986] = 3986,
  [3987] = 3987,
  [3988] = 3988,
  [3989] = 3989,
  [3990] = 3990,
  [3991] = 3991,
  [3992] = 3992,
  [3993] = 3993,
  [3994] = 3994,
  [3995] = 3995,
  [3996] = 3996,
  [3997] = 3997,
  [3998] = 3998,
  [3999] = 3999,
  [4000] = 790,
  [4001] = 792,
  [4002] = 4002,
  [4003] = 793,
  [4004] = 4004,
  [4005] = 4005,
  [4006] = 4006,
  [4007] = 4007,
  [4008] = 4008,
  [4009] = 4009,
  [4010] = 4010,
  [4011] = 4011,
  [4012] = 796,
  [4013] = 797,
  [4014] = 799,
  [4015] = 802,
  [4016] = 4016,
  [4017] = 4017,
  [4018] = 4018,
  [4019] = 3948,
  [4020] = 4020,
  [4021] = 4009,
  [4022] = 3998,
  [4023] = 4017,
  [4024] = 4024,
  [4025] = 4025,
  [4026] = 4026,
  [4027] = 3639,
  [4028] = 806,
  [4029] = 4029,
  [4030] = 4030,
  [4031] = 807,
  [4032] = 808,
  [4033] = 809,
  [4034] = 764,
  [4035] = 765,
  [4036] = 767,
  [4037] = 3979,
  [4038] = 814,
  [4039] = 4039,
  [4040] = 3992,
  [4041] = 3997,
  [4042] = 4042,
  [4043] = 4043,
  [4044] = 766,
  [4045] = 4045,
  [4046] = 819,
  [4047] = 4047,
  [4048] = 4048,
  [4049] = 4049,
  [4050] = 4050,
  [4051] = 4051,
  [4052] = 4052,
  [4053] = 4053,
  [4054] = 4054,
  [4055] = 4055,
  [4056] = 4056,
  [4057] = 4057,
  [4058] = 4058,
  [4059] = 771,
  [4060] = 772,
  [4061] = 4061,
  [4062] = 4062,
  [4063] = 4063,
  [4064] = 4064,
  [4065] = 4043,
  [4066] = 4066,
  [4067] = 4067,
  [4068] = 4068,
  [4069] = 776,
  [4070] = 4070,
  [4071] = 4071,
  [4072] = 4072,
  [4073] = 4045,
  [4074] = 4074,
  [4075] = 4075,
  [4076] = 4076,
  [4077] = 4077,
  [4078] = 4078,
  [4079] = 835,
  [4080] = 836,
  [4081] = 837,
  [4082] = 4082,
  [4083] = 838,
  [4084] = 4075,
  [4085] = 839,
  [4086] = 840,
  [4087] = 841,
  [4088] = 4088,
  [4089] = 842,
  [4090] = 783,
  [4091] = 4091,
  [4092] = 4092,
  [4093] = 4093,
  [4094] = 845,
  [4095] = 846,
  [4096] = 849,
  [4097] = 770,
  [4098] = 773,
  [4099] = 774,
  [4100] = 915,
  [4101] = 4101,
  [4102] = 4102,
  [4103] = 4103,
  [4104] = 4104,
  [4105] = 4105,
  [4106] = 3993,
  [4107] = 4107,
  [4108] = 3999,
  [4109] = 4002,
  [4110] = 4110,
  [4111] = 4111,
  [4112] = 4112,
  [4113] = 4113,
  [4114] = 4114,
  [4115] = 4026,
  [4116] = 4030,
  [4117] = 4117,
  [4118] = 866,
  [4119] = 867,
  [4120] = 868,
  [4121] = 869,
  [4122] = 870,
  [4123] = 871,
  [4124] = 872,
  [4125] = 4125,
  [4126] = 4126,
  [4127] = 4127,
  [4128] = 876,
  [4129] = 877,
  [4130] = 777,
  [4131] = 4131,
  [4132] = 4132,
  [4133] = 3993,
  [4134] = 4134,
  [4135] = 4135,
  [4136] = 3999,
  [4137] = 4137,
  [4138] = 4138,
  [4139] = 4139,
  [4140] = 4140,
  [4141] = 4141,
  [4142] = 4026,
  [4143] = 4143,
  [4144] = 887,
  [4145] = 888,
  [4146] = 889,
  [4147] = 890,
  [4148] = 892,
  [4149] = 4149,
  [4150] = 4150,
  [4151] = 4151,
  [4152] = 4152,
  [4153] = 4153,
  [4154] = 4048,
  [4155] = 4155,
  [4156] = 4156,
  [4157] = 3999,
  [4158] = 4158,
  [4159] = 4159,
  [4160] = 4160,
  [4161] = 4161,
  [4162] = 4026,
  [4163] = 4163,
  [4164] = 4164,
  [4165] = 4165,
  [4166] = 4166,
  [4167] = 4167,
  [4168] = 4168,
  [4169] = 4169,
  [4170] = 4170,
  [4171] = 4171,
  [4172] = 4172,
  [4173] = 4173,
  [4174] = 1611,
  [4175] = 1621,
  [4176] = 4176,
  [4177] = 4177,
  [4178] = 4178,
  [4179] = 4179,
  [4180] = 4180,
  [4181] = 4074,
  [4182] = 4182,
  [4183] = 4183,
  [4184] = 4184,
  [4185] = 4185,
  [4186] = 4186,
  [4187] = 1651,
  [4188] = 4188,
  [4189] = 4189,
  [4190] = 1652,
  [4191] = 4191,
  [4192] = 4192,
  [4193] = 4193,
  [4194] = 4194,
  [4195] = 1683,
  [4196] = 1684,
  [4197] = 4197,
  [4198] = 4167,
  [4199] = 4199,
  [4200] = 3993,
  [4201] = 4201,
  [4202] = 4202,
  [4203] = 4203,
  [4204] = 4204,
  [4205] = 4205,
  [4206] = 4206,
  [4207] = 4207,
  [4208] = 4208,
  [4209] = 4209,
  [4210] = 4210,
  [4211] = 4006,
  [4212] = 4020,
  [4213] = 4213,
  [4214] = 4113,
  [4215] = 4132,
  [4216] = 4216,
  [4217] = 4217,
  [4218] = 4218,
  [4219] = 4219,
  [4220] = 4220,
  [4221] = 4221,
  [4222] = 4222,
  [4223] = 4223,
  [4224] = 4224,
  [4225] = 4225,
  [4226] = 4226,
  [4227] = 4227,
  [4228] = 4102,
  [4229] = 1646,
  [4230] = 1678,
  [4231] = 1634,
  [4232] = 1690,
  [4233] = 1702,
  [4234] = 1618,
  [4235] = 4235,
  [4236] = 4236,
  [4237] = 4237,
  [4238] = 4238,
  [4239] = 4239,
  [4240] = 1658,
  [4241] = 1662,
  [4242] = 4242,
  [4243] = 4243,
  [4244] = 4244,
  [4245] = 4245,
  [4246] = 4078,
  [4247] = 4077,
  [4248] = 4248,
  [4249] = 4249,
  [4250] = 4250,
  [4251] = 4008,
  [4252] = 4252,
  [4253] = 4253,
  [4254] = 4254,
  [4255] = 4255,
  [4256] = 4256,
  [4257] = 4257,
  [4258] = 3996,
  [4259] = 4259,
  [4260] = 4260,
  [4261] = 4261,
  [4262] = 4262,
  [4263] = 4263,
  [4264] = 4264,
  [4265] = 4265,
  [4266] = 4266,
  [4267] = 4267,
  [4268] = 1689,
  [4269] = 1709,
  [4270] = 4270,
  [4271] = 4271,
  [4272] = 4272,
  [4273] = 4273,
  [4274] = 4274,
  [4275] = 4275,
  [4276] = 4076,
  [4277] = 4277,
  [4278] = 4278,
  [4279] = 4279,
  [4280] = 4056,
  [4281] = 4185,
  [4282] = 4282,
  [4283] = 4283,
  [4284] = 4284,
  [4285] = 4285,
  [4286] = 4286,
  [4287] = 4193,
  [4288] = 4288,
  [4289] = 4289,
  [4290] = 4201,
  [4291] = 4204,
  [4292] = 4237,
  [4293] = 4293,
  [4294] = 4222,
  [4295] = 4295,
  [4296] = 4296,
  [4297] = 4297,
  [4298] = 4298,
  [4299] = 4299,
  [4300] = 4300,
  [4301] = 4301,
  [4302] = 4302,
  [4303] = 3972,
  [4304] = 1611,
  [4305] = 1621,
  [4306] = 4306,
  [4307] = 4307,
  [4308] = 4308,
  [4309] = 4309,
  [4310] = 4310,
  [4311] = 4311,
  [4312] = 4312,
  [4313] = 4313,
  [4314] = 4314,
  [4315] = 1651,
  [4316] = 1652,
  [4317] = 4317,
  [4318] = 4062,
  [4319] = 4319,
  [4320] = 1683,
  [4321] = 1684,
  [4322] = 4322,
  [4323] = 4323,
  [4324] = 4324,
  [4325] = 4325,
  [4326] = 4326,
  [4327] = 4327,
  [4328] = 4328,
  [4329] = 4329,
  [4330] = 4330,
  [4331] = 4331,
  [4332] = 4332,
  [4333] = 4193,
  [4334] = 4334,
  [4335] = 4335,
  [4336] = 4336,
  [4337] = 1646,
  [4338] = 1678,
  [4339] = 1634,
  [4340] = 4340,
  [4341] = 1690,
  [4342] = 1702,
  [4343] = 1618,
  [4344] = 4344,
  [4345] = 4345,
  [4346] = 1658,
  [4347] = 1662,
  [4348] = 4348,
  [4349] = 4349,
  [4350] = 4350,
  [4351] = 4351,
  [4352] = 4352,
  [4353] = 4353,
  [4354] = 4354,
  [4355] = 4355,
  [4356] = 4356,
  [4357] = 4357,
  [4358] = 4358,
  [4359] = 4359,
  [4360] = 4360,
  [4361] = 1689,
  [4362] = 1709,
  [4363] = 4363,
  [4364] = 4364,
  [4365] = 4365,
  [4366] = 4366,
  [4367] = 4284,
  [4368] = 4368,
  [4369] = 4194,
  [4370] = 4370,
  [4371] = 4371,
  [4372] = 4372,
  [4373] = 4373,
  [4374] = 4026,
  [4375] = 4375,
  [4376] = 4376,
  [4377] = 4377,
  [4378] = 4378,
  [4379] = 4379,
  [4380] = 3948,
  [4381] = 4007,
  [4382] = 4382,
  [4383] = 3992,
  [4384] = 3997,
  [4385] = 4064,
  [4386] = 4222,
  [4387] = 4056,
  [4388] = 4030,
  [4389] = 4389,
  [4390] = 4390,
  [4391] = 245,
  [4392] = 247,
  [4393] = 852,
  [4394] = 4394,
  [4395] = 3999,
  [4396] = 4396,
  [4397] = 4397,
  [4398] = 885,
  [4399] = 811,
  [4400] = 4400,
  [4401] = 4401,
  [4402] = 4067,
  [4403] = 4403,
  [4404] = 4404,
  [4405] = 4405,
  [4406] = 4406,
  [4407] = 4407,
  [4408] = 4408,
  [4409] = 4185,
  [4410] = 4201,
  [4411] = 4204,
  [4412] = 4244,
  [4413] = 4002,
  [4414] = 4414,
  [4415] = 886,
  [4416] = 900,
  [4417] = 4417,
  [4418] = 4418,
  [4419] = 4419,
  [4420] = 4420,
  [4421] = 4421,
  [4422] = 4422,
  [4423] = 4423,
  [4424] = 4424,
  [4425] = 4425,
  [4426] = 4426,
  [4427] = 4427,
  [4428] = 3824,
  [4429] = 1543,
  [4430] = 4430,
  [4431] = 859,
  [4432] = 1546,
  [4433] = 4433,
  [4434] = 905,
  [4435] = 4435,
  [4436] = 4436,
  [4437] = 4437,
  [4438] = 4438,
  [4439] = 4439,
  [4440] = 4440,
  [4441] = 4441,
  [4442] = 4442,
  [4443] = 4443,
  [4444] = 4070,
  [4445] = 4445,
  [4446] = 4446,
  [4447] = 4447,
  [4448] = 4448,
  [4449] = 3586,
  [4450] = 3598,
  [4451] = 4451,
  [4452] = 4312,
  [4453] = 828,
  [4454] = 4454,
  [4455] = 829,
  [4456] = 4456,
  [4457] = 4457,
  [4458] = 4458,
  [4459] = 4459,
  [4460] = 4088,
  [4461] = 4461,
  [4462] = 4462,
  [4463] = 4463,
  [4464] = 4464,
  [4465] = 4465,
  [4466] = 4466,
  [4467] = 4467,
  [4468] = 4465,
  [4469] = 4469,
  [4470] = 4470,
  [4471] = 4471,
  [4472] = 4472,
  [4473] = 4473,
  [4474] = 4474,
  [4475] = 4475,
  [4476] = 4476,
  [4477] = 4477,
  [4478] = 3558,
  [4479] = 4466,
  [4480] = 4480,
  [4481] = 4465,
  [4482] = 4482,
  [4483] = 4466,
  [4484] = 4476,
  [4485] = 4485,
  [4486] = 4486,
  [4487] = 4487,
  [4488] = 4485,
  [4489] = 4489,
  [4490] = 4471,
  [4491] = 4491,
  [4492] = 4486,
  [4493] = 4493,
  [4494] = 4494,
  [4495] = 4465,
  [4496] = 4487,
  [4497] = 4475,
  [4498] = 4498,
  [4499] = 4491,
  [4500] = 4466,
  [4501] = 4462,
  [4502] = 4486,
  [4503] = 4463,
  [4504] = 4504,
  [4505] = 4505,
  [4506] = 4506,
  [4507] = 4498,
  [4508] = 4471,
  [4509] = 4471,
  [4510] = 4510,
  [4511] = 4491,
  [4512] = 4486,
  [4513] = 4513,
  [4514] = 4514,
  [4515] = 4465,
  [4516] = 4472,
  [4517] = 4489,
  [4518] = 4491,
  [4519] = 4465,
  [4520] = 4466,
  [4521] = 4521,
  [4522] = 4522,
  [4523] = 4523,
  [4524] = 4524,
  [4525] = 4485,
  [4526] = 4526,
  [4527] = 4485,
  [4528] = 4528,
  [4529] = 4475,
  [4530] = 4513,
  [4531] = 4531,
  [4532] = 4471,
  [4533] = 4533,
  [4534] = 4534,
  [4535] = 4535,
  [4536] = 4462,
  [4537] = 4537,
  [4538] = 4463,
  [4539] = 4539,
  [4540] = 4540,
  [4541] = 4498,
  [4542] = 4471,
  [4543] = 4543,
  [4544] = 4462,
  [4545] = 4463,
  [4546] = 4462,
  [4547] = 4547,
  [4548] = 4463,
  [4549] = 4486,
  [4550] = 4491,
  [4551] = 4551,
  [4552] = 4504,
  [4553] = 4475,
  [4554] = 4554,
  [4555] = 4555,
  [4556] = 4498,
  [4557] = 4462,
  [4558] = 4463,
  [4559] = 4559,
  [4560] = 4485,
  [4561] = 4561,
  [4562] = 4498,
  [4563] = 4475,
  [4564] = 4471,
  [4565] = 4480,
  [4566] = 4566,
  [4567] = 4567,
  [4568] = 4498,
  [4569] = 4569,
  [4570] = 4570,
  [4571] = 4462,
  [4572] = 4572,
  [4573] = 219,
  [4574] = 223,
  [4575] = 4506,
  [4576] = 4504,
  [4577] = 4486,
  [4578] = 4491,
  [4579] = 4579,
  [4580] = 4504,
  [4581] = 4463,
  [4582] = 4582,
  [4583] = 4504,
  [4584] = 3713,
  [4585] = 4585,
  [4586] = 4534,
  [4587] = 4473,
  [4588] = 4475,
  [4589] = 4589,
  [4590] = 4537,
  [4591] = 4498,
  [4592] = 4486,
  [4593] = 4491,
  [4594] = 4594,
  [4595] = 4504,
  [4596] = 4524,
  [4597] = 4597,
  [4598] = 4598,
  [4599] = 4599,
  [4600] = 4600,
  [4601] = 4601,
  [4602] = 4602,
  [4603] = 4504,
  [4604] = 4475,
  [4605] = 4605,
  [4606] = 4606,
  [4607] = 4607,
  [4608] = 4608,
  [4609] = 4609,
  [4610] = 4610,
  [4611] = 4611,
  [4612] = 4612,
  [4613] = 4613,
  [4614] = 4614,
  [4615] = 4615,
  [4616] = 4616,
  [4617] = 4617,
  [4618] = 4618,
  [4619] = 4619,
  [4620] = 4620,
  [4621] = 4621,
  [4622] = 4622,
  [4623] = 4623,
  [4624] = 4624,
  [4625] = 3659,
  [4626] = 4626,
  [4627] = 4627,
  [4628] = 4628,
  [4629] = 4629,
  [4630] = 4630,
  [4631] = 4631,
  [4632] = 4632,
  [4633] = 4633,
  [4634] = 4634,
  [4635] = 4635,
  [4636] = 4636,
  [4637] = 4637,
  [4638] = 4638,
  [4639] = 4639,
  [4640] = 4640,
  [4641] = 4624,
  [4642] = 4640,
  [4643] = 4643,
  [4644] = 4644,
  [4645] = 4645,
  [4646] = 4646,
  [4647] = 4647,
  [4648] = 4633,
  [4649] = 4649,
  [4650] = 4650,
  [4651] = 4651,
  [4652] = 4652,
  [4653] = 4653,
  [4654] = 4654,
  [4655] = 4655,
  [4656] = 4656,
  [4657] = 4657,
  [4658] = 4658,
  [4659] = 4610,
  [4660] = 4660,
  [4661] = 4661,
  [4662] = 4662,
  [4663] = 4663,
  [4664] = 4664,
  [4665] = 4665,
  [4666] = 4666,
  [4667] = 4667,
  [4668] = 4668,
  [4669] = 4669,
  [4670] = 4670,
  [4671] = 4671,
  [4672] = 3946,
  [4673] = 4633,
  [4674] = 4624,
  [4675] = 4624,
  [4676] = 4640,
  [4677] = 4677,
  [4678] = 4640,
  [4679] = 4679,
  [4680] = 4680,
  [4681] = 4681,
  [4682] = 4649,
  [4683] = 4650,
  [4684] = 4652,
  [4685] = 4685,
  [4686] = 4654,
  [4687] = 4687,
  [4688] = 4688,
  [4689] = 4689,
  [4690] = 4606,
  [4691] = 4607,
  [4692] = 4608,
  [4693] = 4609,
  [4694] = 4694,
  [4695] = 4610,
  [4696] = 4696,
  [4697] = 4697,
  [4698] = 4698,
  [4699] = 4699,
  [4700] = 4700,
  [4701] = 4701,
  [4702] = 4702,
  [4703] = 4703,
  [4704] = 4704,
  [4705] = 4705,
  [4706] = 4706,
  [4707] = 4624,
  [4708] = 4640,
  [4709] = 4709,
  [4710] = 4710,
  [4711] = 4652,
  [4712] = 4712,
  [4713] = 4654,
  [4714] = 4714,
  [4715] = 4715,
  [4716] = 4716,
  [4717] = 4717,
  [4718] = 4718,
  [4719] = 4719,
  [4720] = 4720,
  [4721] = 4646,
  [4722] = 4722,
  [4723] = 4624,
  [4724] = 4640,
  [4725] = 4725,
  [4726] = 4726,
  [4727] = 4727,
  [4728] = 4728,
  [4729] = 4652,
  [4730] = 4730,
  [4731] = 4654,
  [4732] = 4732,
  [4733] = 4733,
  [4734] = 4734,
  [4735] = 4735,
  [4736] = 4736,
  [4737] = 4737,
  [4738] = 4738,
  [4739] = 4739,
  [4740] = 4740,
  [4741] = 4741,
  [4742] = 4742,
  [4743] = 4743,
  [4744] = 4744,
  [4745] = 4745,
  [4746] = 4746,
  [4747] = 4747,
  [4748] = 4748,
  [4749] = 4749,
  [4750] = 4750,
  [4751] = 4751,
  [4752] = 4752,
  [4753] = 4753,
  [4754] = 4754,
  [4755] = 4755,
  [4756] = 4756,
  [4757] = 4757,
  [4758] = 4758,
  [4759] = 4759,
  [4760] = 4760,
  [4761] = 4761,
  [4762] = 4762,
  [4763] = 4763,
  [4764] = 4658,
  [4765] = 4765,
  [4766] = 4766,
  [4767] = 4767,
  [4768] = 4768,
  [4769] = 4769,
  [4770] = 4770,
  [4771] = 4771,
  [4772] = 4772,
  [4773] = 4773,
  [4774] = 4727,
  [4775] = 4738,
  [4776] = 4776,
  [4777] = 4777,
  [4778] = 4778,
  [4779] = 4779,
  [4780] = 4780,
  [4781] = 4781,
  [4782] = 4782,
  [4783] = 768,
  [4784] = 4649,
  [4785] = 4785,
  [4786] = 4633,
  [4787] = 4650,
  [4788] = 4606,
  [4789] = 4607,
  [4790] = 4790,
  [4791] = 4608,
  [4792] = 4792,
  [4793] = 4609,
  [4794] = 4794,
  [4795] = 4795,
  [4796] = 4796,
  [4797] = 4797,
  [4798] = 4798,
  [4799] = 4799,
  [4800] = 4800,
  [4801] = 4801,
  [4802] = 4802,
  [4803] = 4803,
  [4804] = 4804,
  [4805] = 4805,
  [4806] = 4806,
  [4807] = 4807,
  [4808] = 4808,
  [4809] = 4610,
  [4810] = 4810,
  [4811] = 4811,
  [4812] = 4812,
  [4813] = 4813,
  [4814] = 4814,
  [4815] = 4815,
  [4816] = 4816,
  [4817] = 4650,
  [4818] = 4818,
  [4819] = 4652,
  [4820] = 4820,
  [4821] = 4807,
  [4822] = 4822,
  [4823] = 4815,
  [4824] = 4824,
  [4825] = 4825,
  [4826] = 4652,
  [4827] = 4827,
  [4828] = 4654,
  [4829] = 4829,
  [4830] = 4654,
  [4831] = 4831,
  [4832] = 4832,
  [4833] = 4833,
  [4834] = 4665,
  [4835] = 4835,
  [4836] = 4836,
  [4837] = 4837,
  [4838] = 4838,
  [4839] = 4839,
  [4840] = 4840,
  [4841] = 4687,
  [4842] = 4842,
  [4843] = 4843,
  [4844] = 3576,
  [4845] = 4845,
  [4846] = 4846,
  [4847] = 4847,
  [4848] = 4618,
  [4849] = 4622,
  [4850] = 4850,
  [4851] = 4851,
  [4852] = 4852,
  [4853] = 4853,
  [4854] = 4854,
  [4855] = 4855,
  [4856] = 4856,
  [4857] = 4857,
  [4858] = 4858,
  [4859] = 4859,
  [4860] = 4860,
  [4861] = 4861,
  [4862] = 4862,
  [4863] = 4863,
  [4864] = 4864,
  [4865] = 4865,
  [4866] = 4866,
  [4867] = 4867,
  [4868] = 4868,
  [4869] = 4869,
  [4870] = 4610,
  [4871] = 4871,
  [4872] = 4872,
  [4873] = 4873,
  [4874] = 4874,
  [4875] = 4875,
  [4876] = 4876,
  [4877] = 4877,
  [4878] = 4878,
  [4879] = 4879,
  [4880] = 4880,
  [4881] = 4881,
  [4882] = 4882,
  [4883] = 4883,
  [4884] = 4884,
  [4885] = 4873,
  [4886] = 4886,
  [4887] = 4876,
  [4888] = 4888,
  [4889] = 4861,
  [4890] = 4890,
  [4891] = 4891,
  [4892] = 4892,
  [4893] = 4893,
  [4894] = 4894,
  [4895] = 4895,
  [4896] = 4896,
  [4897] = 4897,
  [4898] = 4898,
  [4899] = 4899,
  [4900] = 4900,
  [4901] = 4901,
  [4902] = 4902,
  [4903] = 4903,
  [4904] = 4904,
  [4905] = 4905,
  [4906] = 4906,
  [4907] = 4907,
  [4908] = 4908,
  [4909] = 4909,
  [4910] = 4910,
  [4911] = 4911,
  [4912] = 4912,
  [4913] = 4913,
  [4914] = 4914,
  [4915] = 4915,
  [4916] = 4916,
  [4917] = 4917,
  [4918] = 4918,
  [4919] = 4919,
  [4920] = 4920,
  [4921] = 4921,
  [4922] = 4922,
  [4923] = 4923,
  [4924] = 4633,
  [4925] = 1491,
  [4926] = 4926,
  [4927] = 4927,
  [4928] = 4928,
  [4929] = 4929,
  [4930] = 4930,
  [4931] = 4931,
  [4932] = 4932,
  [4933] = 4933,
  [4934] = 4934,
  [4935] = 4935,
  [4936] = 4936,
  [4937] = 4937,
  [4938] = 4938,
  [4939] = 4939,
  [4940] = 4940,
  [4941] = 4941,
  [4942] = 3544,
  [4943] = 4617,
  [4944] = 4944,
  [4945] = 4945,
  [4946] = 4946,
  [4947] = 4947,
  [4948] = 4948,
  [4949] = 4949,
  [4950] = 4950,
  [4951] = 4951,
  [4952] = 4952,
  [4953] = 4953,
  [4954] = 4954,
  [4955] = 4955,
  [4956] = 4956,
  [4957] = 4957,
  [4958] = 4749,
  [4959] = 4959,
  [4960] = 4960,
  [4961] = 4961,
  [4962] = 4962,
  [4963] = 4963,
  [4964] = 4964,
  [4965] = 4965,
  [4966] = 4966,
  [4967] = 4967,
  [4968] = 4968,
  [4969] = 4969,
  [4970] = 4970,
  [4971] = 4971,
  [4972] = 4972,
  [4973] = 4973,
  [4974] = 4974,
  [4975] = 4975,
  [4976] = 4976,
  [4977] = 4977,
  [4978] = 4978,
  [4979] = 4979,
  [4980] = 4980,
  [4981] = 4981,
  [4982] = 4982,
  [4983] = 4983,
  [4984] = 4984,
  [4985] = 4985,
  [4986] = 4986,
  [4987] = 4987,
  [4988] = 4988,
  [4989] = 4989,
  [4990] = 4990,
  [4991] = 4991,
  [4992] = 4992,
  [4993] = 4993,
  [4994] = 4994,
  [4995] = 4995,
  [4996] = 4996,
  [4997] = 4997,
  [4998] = 4998,
  [4999] = 4646,
  [5000] = 5000,
  [5001] = 5001,
  [5002] = 5002,
  [5003] = 5003,
  [5004] = 5004,
  [5005] = 5005,
  [5006] = 5006,
  [5007] = 5007,
  [5008] = 5008,
  [5009] = 5009,
  [5010] = 5010,
  [5011] = 3533,
  [5012] = 5012,
  [5013] = 5013,
  [5014] = 5014,
  [5015] = 5015,
  [5016] = 5016,
  [5017] = 5017,
  [5018] = 5018,
  [5019] = 5019,
  [5020] = 5020,
  [5021] = 5021,
  [5022] = 4257,
  [5023] = 5023,
  [5024] = 1487,
  [5025] = 5025,
  [5026] = 5026,
  [5027] = 5027,
  [5028] = 5028,
  [5029] = 4801,
  [5030] = 5030,
  [5031] = 5031,
  [5032] = 5032,
  [5033] = 5033,
  [5034] = 5034,
  [5035] = 5035,
  [5036] = 5036,
  [5037] = 5037,
  [5038] = 5038,
  [5039] = 5039,
  [5040] = 5040,
  [5041] = 5041,
  [5042] = 5042,
  [5043] = 5043,
  [5044] = 5044,
  [5045] = 5045,
  [5046] = 5046,
  [5047] = 5047,
  [5048] = 5048,
  [5049] = 5049,
  [5050] = 5050,
  [5051] = 5051,
  [5052] = 5052,
  [5053] = 5053,
  [5054] = 5054,
  [5055] = 5055,
  [5056] = 5056,
  [5057] = 5057,
  [5058] = 5058,
  [5059] = 5059,
  [5060] = 5060,
  [5061] = 4919,
  [5062] = 5062,
  [5063] = 5063,
  [5064] = 5064,
  [5065] = 5065,
  [5066] = 4649,
  [5067] = 5067,
  [5068] = 5068,
  [5069] = 4435,
  [5070] = 5070,
  [5071] = 1499,
  [5072] = 4753,
  [5073] = 5073,
  [5074] = 5074,
  [5075] = 5075,
  [5076] = 5076,
  [5077] = 4650,
  [5078] = 5078,
  [5079] = 5079,
  [5080] = 5080,
  [5081] = 5081,
  [5082] = 5082,
  [5083] = 4935,
  [5084] = 5084,
  [5085] = 5085,
  [5086] = 5086,
  [5087] = 5087,
  [5088] = 5088,
  [5089] = 4650,
  [5090] = 5090,
  [5091] = 5091,
  [5092] = 5092,
  [5093] = 4750,
  [5094] = 5094,
  [5095] = 5095,
  [5096] = 5096,
  [5097] = 5097,
  [5098] = 5098,
  [5099] = 5099,
  [5100] = 4687,
  [5101] = 4618,
  [5102] = 5102,
  [5103] = 5103,
  [5104] = 5104,
  [5105] = 5105,
  [5106] = 5106,
  [5107] = 5107,
  [5108] = 5108,
  [5109] = 4861,
  [5110] = 5110,
  [5111] = 5111,
  [5112] = 4901,
  [5113] = 5113,
  [5114] = 5114,
  [5115] = 4633,
  [5116] = 5116,
  [5117] = 5117,
  [5118] = 5118,
  [5119] = 4912,
  [5120] = 5120,
  [5121] = 5121,
  [5122] = 5122,
  [5123] = 5123,
  [5124] = 5124,
  [5125] = 5125,
  [5126] = 5126,
  [5127] = 5127,
  [5128] = 5128,
  [5129] = 5129,
  [5130] = 5130,
  [5131] = 5131,
  [5132] = 4921,
  [5133] = 5133,
  [5134] = 4923,
  [5135] = 5135,
  [5136] = 5129,
  [5137] = 5094,
  [5138] = 5138,
  [5139] = 5139,
  [5140] = 5140,
  [5141] = 4617,
  [5142] = 5142,
  [5143] = 1525,
  [5144] = 5144,
  [5145] = 5145,
  [5146] = 5146,
  [5147] = 5147,
  [5148] = 5148,
  [5149] = 1531,
  [5150] = 5150,
  [5151] = 5151,
  [5152] = 5152,
  [5153] = 4633,
  [5154] = 5154,
  [5155] = 5155,
  [5156] = 5156,
  [5157] = 5157,
  [5158] = 5158,
  [5159] = 5159,
  [5160] = 5160,
  [5161] = 4619,
  [5162] = 4743,
  [5163] = 5163,
  [5164] = 5164,
  [5165] = 5165,
  [5166] = 768,
  [5167] = 4624,
  [5168] = 4640,
  [5169] = 5169,
  [5170] = 5170,
  [5171] = 5171,
  [5172] = 5172,
  [5173] = 5173,
  [5174] = 5174,
  [5175] = 4620,
  [5176] = 5176,
  [5177] = 5177,
  [5178] = 4760,
  [5179] = 4646,
  [5180] = 4663,
  [5181] = 5181,
  [5182] = 5182,
  [5183] = 3596,
  [5184] = 5184,
  [5185] = 5185,
  [5186] = 5186,
  [5187] = 5187,
  [5188] = 4743,
  [5189] = 5189,
  [5190] = 5190,
  [5191] = 5129,
  [5192] = 5131,
  [5193] = 5193,
  [5194] = 4649,
  [5195] = 5195,
  [5196] = 5196,
  [5197] = 5060,
  [5198] = 5198,
  [5199] = 5199,
  [5200] = 5200,
  [5201] = 4650,
  [5202] = 5202,
  [5203] = 5203,
  [5204] = 5204,
  [5205] = 5205,
  [5206] = 5206,
  [5207] = 5094,
  [5208] = 5208,
  [5209] = 4652,
  [5210] = 5210,
  [5211] = 4654,
  [5212] = 5212,
  [5213] = 5213,
  [5214] = 5214,
  [5215] = 5215,
  [5216] = 5216,
  [5217] = 4667,
  [5218] = 5218,
  [5219] = 5219,
  [5220] = 5220,
  [5221] = 5221,
  [5222] = 5222,
  [5223] = 5223,
  [5224] = 5224,
  [5225] = 3832,
  [5226] = 5226,
  [5227] = 5227,
  [5228] = 5228,
  [5229] = 5229,
  [5230] = 5230,
  [5231] = 5231,
  [5232] = 2615,
  [5233] = 5233,
  [5234] = 2618,
  [5235] = 5235,
  [5236] = 5236,
  [5237] = 5237,
  [5238] = 5238,
  [5239] = 5239,
  [5240] = 5240,
  [5241] = 5241,
  [5242] = 5242,
  [5243] = 5243,
  [5244] = 5244,
  [5245] = 5245,
  [5246] = 5246,
  [5247] = 5247,
  [5248] = 5248,
  [5249] = 5249,
  [5250] = 5250,
  [5251] = 5251,
  [5252] = 5252,
  [5253] = 5253,
  [5254] = 5254,
  [5255] = 5255,
  [5256] = 5235,
  [5257] = 5257,
  [5258] = 5222,
  [5259] = 5237,
  [5260] = 5260,
  [5261] = 5261,
  [5262] = 5262,
  [5263] = 5263,
  [5264] = 5264,
  [5265] = 5223,
  [5266] = 5266,
  [5267] = 5240,
  [5268] = 5268,
  [5269] = 5243,
  [5270] = 5270,
  [5271] = 5271,
  [5272] = 2639,
  [5273] = 5244,
  [5274] = 2641,
  [5275] = 5247,
  [5276] = 5240,
  [5277] = 5277,
  [5278] = 5278,
  [5279] = 5279,
  [5280] = 5235,
  [5281] = 5281,
  [5282] = 5250,
  [5283] = 5283,
  [5284] = 5266,
  [5285] = 5251,
  [5286] = 5264,
  [5287] = 5253,
  [5288] = 5288,
  [5289] = 5289,
  [5290] = 5290,
  [5291] = 5291,
  [5292] = 1630,
  [5293] = 5293,
  [5294] = 5294,
  [5295] = 5295,
  [5296] = 5296,
  [5297] = 5297,
  [5298] = 5298,
  [5299] = 5260,
  [5300] = 5300,
  [5301] = 5301,
  [5302] = 3836,
  [5303] = 5303,
  [5304] = 5304,
  [5305] = 5305,
  [5306] = 5306,
  [5307] = 5307,
  [5308] = 5308,
  [5309] = 5309,
  [5310] = 5310,
  [5311] = 5311,
  [5312] = 5240,
  [5313] = 5313,
  [5314] = 5314,
  [5315] = 5315,
  [5316] = 5316,
  [5317] = 5317,
  [5318] = 5318,
  [5319] = 5319,
  [5320] = 5320,
  [5321] = 5321,
  [5322] = 5322,
  [5323] = 5323,
  [5324] = 5324,
  [5325] = 5325,
  [5326] = 5326,
  [5327] = 5327,
  [5328] = 5268,
  [5329] = 5277,
  [5330] = 5278,
  [5331] = 5331,
  [5332] = 5309,
  [5333] = 5333,
  [5334] = 5334,
  [5335] = 5335,
  [5336] = 5336,
  [5337] = 5337,
  [5338] = 5338,
  [5339] = 5231,
  [5340] = 5340,
  [5341] = 5341,
  [5342] = 5342,
  [5343] = 5343,
  [5344] = 5310,
  [5345] = 5345,
  [5346] = 5346,
  [5347] = 5347,
  [5348] = 5348,
  [5349] = 5338,
  [5350] = 5350,
  [5351] = 2631,
  [5352] = 2621,
  [5353] = 5324,
  [5354] = 5354,
  [5355] = 5335,
  [5356] = 5356,
  [5357] = 5233,
  [5358] = 2608,
  [5359] = 5359,
  [5360] = 2614,
  [5361] = 5268,
  [5362] = 5277,
  [5363] = 5343,
  [5364] = 5278,
  [5365] = 2611,
  [5366] = 5366,
  [5367] = 5346,
  [5368] = 2635,
  [5369] = 5369,
  [5370] = 5370,
  [5371] = 5371,
  [5372] = 5371,
  [5373] = 5373,
  [5374] = 2634,
  [5375] = 5336,
  [5376] = 5376,
  [5377] = 5298,
  [5378] = 5331,
  [5379] = 5320,
  [5380] = 5268,
  [5381] = 5381,
  [5382] = 5382,
  [5383] = 5383,
  [5384] = 5384,
  [5385] = 5385,
  [5386] = 2619,
  [5387] = 5337,
  [5388] = 5249,
  [5389] = 1692,
  [5390] = 5281,
  [5391] = 1693,
  [5392] = 5392,
  [5393] = 5283,
  [5394] = 5392,
  [5395] = 5252,
  [5396] = 5396,
  [5397] = 5266,
  [5398] = 5398,
  [5399] = 5347,
  [5400] = 5255,
  [5401] = 5264,
  [5402] = 5402,
  [5403] = 5403,
  [5404] = 5288,
  [5405] = 5366,
  [5406] = 2660,
  [5407] = 2662,
  [5408] = 5408,
  [5409] = 5409,
  [5410] = 5410,
  [5411] = 2628,
  [5412] = 5412,
  [5413] = 2624,
  [5414] = 5414,
  [5415] = 5415,
  [5416] = 5416,
  [5417] = 5277,
  [5418] = 5418,
  [5419] = 5419,
  [5420] = 5307,
  [5421] = 5303,
  [5422] = 5422,
  [5423] = 5222,
  [5424] = 5408,
  [5425] = 5425,
  [5426] = 5426,
  [5427] = 5385,
  [5428] = 5428,
  [5429] = 5249,
  [5430] = 5430,
  [5431] = 5410,
  [5432] = 5432,
  [5433] = 5268,
  [5434] = 5252,
  [5435] = 5231,
  [5436] = 5436,
  [5437] = 5255,
  [5438] = 5438,
  [5439] = 5439,
  [5440] = 5440,
  [5441] = 5441,
  [5442] = 5277,
  [5443] = 5443,
  [5444] = 5277,
  [5445] = 5249,
  [5446] = 5446,
  [5447] = 5409,
  [5448] = 5252,
  [5449] = 5255,
  [5450] = 5450,
  [5451] = 5426,
  [5452] = 5278,
  [5453] = 5348,
  [5454] = 5425,
  [5455] = 5403,
  [5456] = 5456,
  [5457] = 5457,
  [5458] = 5458,
  [5459] = 5459,
  [5460] = 5460,
  [5461] = 5278,
  [5462] = 5240,
  [5463] = 5463,
  [5464] = 5464,
  [5465] = 5432,
  [5466] = 5248,
  [5467] = 5304,
  [5468] = 5468,
  [5469] = 2644,
  [5470] = 5430,
  [5471] = 5290,
  [5472] = 5472,
  [5473] = 5281,
  [5474] = 5283,
  [5475] = 3818,
  [5476] = 5240,
  [5477] = 5266,
  [5478] = 5478,
  [5479] = 5264,
  [5480] = 5480,
  [5481] = 5278,
  [5482] = 5482,
  [5483] = 5483,
  [5484] = 5484,
  [5485] = 5485,
  [5486] = 5486,
  [5487] = 5268,
  [5488] = 5242,
  [5489] = 3824,
  [5490] = 5263,
  [5491] = 2613,
  [5492] = 5492,
  [5493] = 5311,
  [5494] = 5257,
  [5495] = 5321,
  [5496] = 5496,
  [5497] = 2607,
  [5498] = 5314,
  [5499] = 2620,
  [5500] = 5305,
  [5501] = 5315,
  [5502] = 5262,
  [5503] = 5369,
  [5504] = 5504,
  [5505] = 2645,
  [5506] = 5506,
  [5507] = 5419,
  [5508] = 5508,
  [5509] = 5300,
  [5510] = 5510,
  [5511] = 5254,
  [5512] = 5512,
  [5513] = 5316,
  [5514] = 5514,
  [5515] = 5298,
  [5516] = 5307,
  [5517] = 5438,
  [5518] = 5518,
  [5519] = 5337,
  [5520] = 5520,
  [5521] = 5440,
  [5522] = 5342,
  [5523] = 5223,
  [5524] = 5382,
  [5525] = 5418,
  [5526] = 5305,
  [5527] = 5527,
  [5528] = 5436,
  [5529] = 5529,
  [5530] = 5439,
  [5531] = 5253,
  [5532] = 5443,
  [5533] = 5533,
  [5534] = 5222,
  [5535] = 5535,
  [5536] = 5536,
  [5537] = 5537,
  [5538] = 5371,
  [5539] = 5539,
  [5540] = 5540,
  [5541] = 5541,
  [5542] = 5281,
  [5543] = 5283,
  [5544] = 5266,
  [5545] = 5545,
  [5546] = 5546,
  [5547] = 5547,
  [5548] = 5325,
  [5549] = 5224,
  [5550] = 5264,
  [5551] = 5551,
  [5552] = 5249,
  [5553] = 5553,
  [5554] = 5252,
  [5555] = 5255,
  [5556] = 5376,
  [5557] = 5430,
  [5558] = 5482,
  [5559] = 5268,
  [5560] = 5410,
  [5561] = 5277,
  [5562] = 5562,
  [5563] = 5432,
  [5564] = 5278,
  [5565] = 2656,
  [5566] = 5253,
  [5567] = 5240,
  [5568] = 5369,
  [5569] = 5300,
  [5570] = 5283,
  [5571] = 5571,
  [5572] = 5239,
  [5573] = 5281,
  [5574] = 5574,
  [5575] = 5575,
  [5576] = 5576,
  [5577] = 5577,
  [5578] = 5578,
  [5579] = 5579,
  [5580] = 5580,
  [5581] = 5581,
  [5582] = 5582,
  [5583] = 5583,
  [5584] = 5584,
  [5585] = 5585,
  [5586] = 5586,
  [5587] = 5587,
  [5588] = 5585,
  [5589] = 5589,
  [5590] = 5590,
  [5591] = 5591,
  [5592] = 5592,
  [5593] = 5593,
  [5594] = 5594,
  [5595] = 5589,
  [5596] = 5596,
  [5597] = 5597,
  [5598] = 5598,
  [5599] = 5599,
  [5600] = 5600,
  [5601] = 5601,
  [5602] = 5602,
  [5603] = 5603,
  [5604] = 5604,
  [5605] = 5605,
  [5606] = 5576,
  [5607] = 5607,
  [5608] = 5585,
  [5609] = 5589,
  [5610] = 5610,
  [5611] = 5611,
  [5612] = 5612,
  [5613] = 5575,
  [5614] = 5614,
  [5615] = 5615,
  [5616] = 5616,
  [5617] = 5615,
  [5618] = 5618,
  [5619] = 5619,
  [5620] = 5620,
  [5621] = 5621,
  [5622] = 5622,
  [5623] = 5623,
  [5624] = 5624,
  [5625] = 5625,
  [5626] = 5626,
  [5627] = 5627,
  [5628] = 5628,
  [5629] = 5629,
  [5630] = 5610,
  [5631] = 5631,
  [5632] = 5632,
  [5633] = 5633,
  [5634] = 5634,
  [5635] = 5602,
  [5636] = 5615,
  [5637] = 5637,
  [5638] = 5638,
  [5639] = 5639,
  [5640] = 5640,
  [5641] = 5601,
  [5642] = 5642,
  [5643] = 5579,
  [5644] = 5581,
  [5645] = 5614,
  [5646] = 5599,
  [5647] = 5647,
  [5648] = 5612,
  [5649] = 5649,
  [5650] = 5642,
  [5651] = 5651,
  [5652] = 5652,
  [5653] = 5629,
  [5654] = 5652,
  [5655] = 5655,
  [5656] = 5580,
  [5657] = 5576,
  [5658] = 5586,
  [5659] = 5659,
  [5660] = 5575,
  [5661] = 5642,
  [5662] = 5662,
  [5663] = 5634,
  [5664] = 5664,
  [5665] = 5665,
  [5666] = 5594,
  [5667] = 5600,
  [5668] = 5668,
  [5669] = 5614,
  [5670] = 5670,
  [5671] = 5671,
  [5672] = 5585,
  [5673] = 5614,
  [5674] = 5574,
  [5675] = 5625,
  [5676] = 5596,
  [5677] = 5640,
  [5678] = 5678,
  [5679] = 5652,
  [5680] = 5625,
  [5681] = 5611,
  [5682] = 5662,
  [5683] = 5670,
  [5684] = 5684,
  [5685] = 5602,
  [5686] = 5686,
  [5687] = 5687,
  [5688] = 5582,
  [5689] = 5689,
  [5690] = 5589,
  [5691] = 5691,
  [5692] = 5692,
  [5693] = 5629,
  [5694] = 5600,
  [5695] = 5695,
  [5696] = 5691,
  [5697] = 5697,
  [5698] = 5687,
  [5699] = 5618,
  [5700] = 5625,
  [5701] = 5593,
  [5702] = 5625,
  [5703] = 5618,
  [5704] = 5704,
  [5705] = 5610,
  [5706] = 5633,
  [5707] = 5615,
  [5708] = 5642,
  [5709] = 5662,
  [5710] = 5628,
  [5711] = 5652,
  [5712] = 5712,
  [5713] = 5662,
  [5714] = 5580,
  [5715] = 5619,
  [5716] = 5628,
  [5717] = 5620,
  [5718] = 5692,
  [5719] = 5623,
  [5720] = 5582,
  [5721] = 5721,
  [5722] = 5684,
  [5723] = 5586,
  [5724] = 5687,
  [5725] = 5638,
  [5726] = 5626,
  [5727] = 5651,
  [5728] = 5584,
  [5729] = 5627,
  [5730] = 5593,
  [5731] = 5659,
  [5732] = 5586,
  [5733] = 5684,
  [5734] = 5625,
  [5735] = 5634,
  [5736] = 5665,
  [5737] = 5737,
  [5738] = 5612,
  [5739] = 5575,
  [5740] = 5655,
  [5741] = 5623,
  [5742] = 5691,
  [5743] = 5604,
  [5744] = 5580,
  [5745] = 5664,
  [5746] = 5582,
  [5747] = 5687,
  [5748] = 5748,
  [5749] = 5749,
  [5750] = 5750,
  [5751] = 5607,
  [5752] = 5689,
  [5753] = 5639,
  [5754] = 5586,
  [5755] = 5692,
  [5756] = 5756,
  [5757] = 5590,
  [5758] = 5758,
  [5759] = 5638,
  [5760] = 5600,
  [5761] = 5590,
  [5762] = 5691,
  [5763] = 5692,
  [5764] = 5594,
  [5765] = 5601,
  [5766] = 5671,
  [5767] = 5610,
  [5768] = 5618,
  [5769] = 5612,
  [5770] = 5575,
  [5771] = 5593,
  [5772] = 5772,
  [5773] = 5619,
  [5774] = 5774,
  [5775] = 5775,
  [5776] = 5604,
  [5777] = 5777,
  [5778] = 5778,
  [5779] = 5590,
  [5780] = 5594,
  [5781] = 5620,
  [5782] = 5596,
  [5783] = 5783,
  [5784] = 5687,
  [5785] = 5596,
  [5786] = 5584,
  [5787] = 5684,
  [5788] = 5610,
  [5789] = 5612,
  [5790] = 5575,
  [5791] = 5616,
  [5792] = 5758,
  [5793] = 5622,
  [5794] = 5691,
  [5795] = 5795,
  [5796] = 5619,
  [5797] = 5692,
  [5798] = 5622,
  [5799] = 5627,
  [5800] = 5800,
  [5801] = 5801,
  [5802] = 5628,
  [5803] = 5637,
  [5804] = 5616,
  [5805] = 5590,
  [5806] = 5639,
  [5807] = 5692,
  [5808] = 5808,
  [5809] = 5590,
  [5810] = 5810,
  [5811] = 5664,
  [5812] = 5812,
  [5813] = 5594,
  [5814] = 5814,
  [5815] = 5808,
  [5816] = 5623,
  [5817] = 5638,
  [5818] = 5800,
  [5819] = 5622,
  [5820] = 5614,
  [5821] = 5628,
  [5822] = 5621,
  [5823] = 5578,
  [5824] = 5810,
  [5825] = 5580,
  [5826] = 5582,
  [5827] = 5620,
  [5828] = 5637,
  [5829] = 5586,
  [5830] = 5687,
  [5831] = 5579,
  [5832] = 5581,
  [5833] = 5599,
  [5834] = 5639,
  [5835] = 5684,
  [5836] = 5668,
  [5837] = 5576,
  [5838] = 5585,
  [5839] = 5604,
  [5840] = 5840,
  [5841] = 5589,
  [5842] = 5622,
  [5843] = 5615,
  [5844] = 5637,
  [5845] = 5845,
  [5846] = 5642,
  [5847] = 5847,
  [5848] = 5848,
  [5849] = 5662,
  [5850] = 5850,
  [5851] = 5851,
  [5852] = 5579,
  [5853] = 5596,
  [5854] = 5629,
  [5855] = 5607,
  [5856] = 5856,
  [5857] = 5651,
  [5858] = 5687,
  [5859] = 5800,
  [5860] = 5580,
  [5861] = 5810,
  [5862] = 5862,
  [5863] = 5610,
  [5864] = 5840,
  [5865] = 5624,
  [5866] = 5750,
  [5867] = 5581,
  [5868] = 5868,
  [5869] = 5590,
  [5870] = 5592,
  [5871] = 5600,
  [5872] = 5601,
  [5873] = 5596,
  [5874] = 5750,
  [5875] = 5579,
  [5876] = 5876,
  [5877] = 5877,
  [5878] = 5590,
  [5879] = 5593,
  [5880] = 5840,
  [5881] = 5594,
  [5882] = 5618,
  [5883] = 5596,
  [5884] = 5619,
  [5885] = 5614,
  [5886] = 5610,
  [5887] = 5602,
  [5888] = 5612,
  [5889] = 5575,
  [5890] = 5651,
  [5891] = 5891,
  [5892] = 5604,
  [5893] = 5620,
  [5894] = 5894,
  [5895] = 5593,
  [5896] = 5877,
  [5897] = 5631,
  [5898] = 5622,
  [5899] = 5639,
  [5900] = 5604,
  [5901] = 5655,
  [5902] = 5623,
  [5903] = 5638,
  [5904] = 5586,
  [5905] = 5671,
  [5906] = 5906,
  [5907] = 5594,
  [5908] = 5689,
  [5909] = 5651,
  [5910] = 5616,
  [5911] = 5577,
  [5912] = 5659,
  [5913] = 5601,
  [5914] = 5627,
  [5915] = 5795,
  [5916] = 5634,
  [5917] = 5848,
  [5918] = 5596,
  [5919] = 5655,
  [5920] = 5614,
  [5921] = 5629,
  [5922] = 5610,
  [5923] = 5664,
  [5924] = 5612,
  [5925] = 5575,
  [5926] = 5590,
  [5927] = 5629,
  [5928] = 5594,
  [5929] = 5596,
  [5930] = 5655,
  [5931] = 5931,
  [5932] = 5610,
  [5933] = 5659,
  [5934] = 5612,
  [5935] = 5652,
  [5936] = 5575,
  [5937] = 5937,
  [5938] = 5938,
  [5939] = 5599,
  [5940] = 5691,
  [5941] = 5941,
  [5942] = 5772,
  [5943] = 5634,
  [5944] = 5625,
  [5945] = 5664,
  [5946] = 5598,
  [5947] = 5652,
  [5948] = 5756,
  [5949] = 5949,
  [5950] = 5655,
  [5951] = 5580,
  [5952] = 5952,
  [5953] = 5953,
  [5954] = 5581,
  [5955] = 5778,
  [5956] = 5622,
  [5957] = 5957,
  [5958] = 5627,
  [5959] = 5959,
  [5960] = 5622,
  [5961] = 5721,
  [5962] = 5684,
  [5963] = 5605,
  [5964] = 5576,
  [5965] = 5953,
  [5966] = 5639,
  [5967] = 5622,
  [5968] = 5941,
  [5969] = 5684,
  [5970] = 5692,
  [5971] = 5750,
  [5972] = 5599,
  [5973] = 5612,
  [5974] = 5584,
  [5975] = 5659,
  [5976] = 5750,
  [5977] = 5756,
  [5978] = 5637,
  [5979] = 5597,
  [5980] = 5980,
  [5981] = 5655,
  [5982] = 5982,
  [5983] = 5594,
  [5984] = 5984,
  [5985] = 5691,
};

static TSCharacterRange extras_character_set_1[] = {
  {'\t', '\r'}, {' ', ' '}, {0xa0, 0xa0}, {0x1680, 0x1680}, {0x2000, 0x200b}, {0x2028, 0x2029}, {0x202f, 0x202f}, {0x205f, 0x2060},
  {0x3000, 0x3000}, {0xfeff, 0xfeff},
};

static TSCharacterRange sym_identifier_character_set_1[] = {
  {'$', '$'}, {'A', 'Z'}, {'\\', '\\'}, {'_', '_'}, {'a', 'z'}, {0x7f, 0x9f}, {0xa1, 0x167f}, {0x1681, 0x1fff},
  {0x200c, 0x2027}, {0x202a, 0x202e}, {0x2030, 0x205e}, {0x2061, 0x2fff}, {0x3001, 0xfefe}, {0xff00, 0x10ffff},
};

static TSCharacterRange sym_identifier_character_set_2[] = {
  {'$', '$'}, {'0', '9'}, {'A', 'Z'}, {'\\', '\\'}, {'_', '_'}, {'a', 'z'}, {0x7f, 0x9f}, {0xa1, 0x167f},
  {0x1681, 0x1fff}, {0x200c, 0x2027}, {0x202a, 0x202e}, {0x2030, 0x205e}, {0x2061, 0x2fff}, {0x3001, 0xfefe}, {0xff00, 0x10ffff},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(129);
      ADVANCE_MAP(
        '!', 143,
        '"', 160,
        '#', 6,
        '$', 281,
        '%', 224,
        '&', 203,
        '\'', 161,
        '(', 144,
        ')', 146,
        '*', 132,
        '+', 216,
        ',', 140,
        '-', 220,
        '.', 156,
        '/', 266,
        '0', 271,
        ':', 147,
        ';', 145,
        '<', 229,
        '=', 136,
        '>', 152,
        '?', 287,
        '@', 284,
        '[', 148,
        '\\', 82,
        ']', 149,
        '^', 206,
        '`', 264,
        '{', 139,
        '|', 209,
        '}', 141,
        '~', 240,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(272);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(126);
      if (lookahead > '@') ADVANCE(282);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(34);
      if (lookahead == '/') ADVANCE(24);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(125);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(267);
      if (lookahead != 0) ADVANCE(268);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '!', 143,
        '"', 160,
        '#', 80,
        '%', 224,
        '&', 203,
        '\'', 161,
        '(', 144,
        ')', 146,
        '*', 132,
        '+', 215,
        ',', 140,
        '-', 219,
        '.', 156,
        '/', 222,
        '0', 271,
        ':', 147,
        ';', 145,
        '<', 230,
        '=', 136,
        '>', 152,
        '?', 287,
        '@', 284,
        '[', 148,
        '\\', 84,
        ']', 149,
        '^', 206,
        '`', 264,
        '{', 139,
        '|', 209,
        '}', 141,
        '~', 240,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(272);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(2);
      if (lookahead > '#') ADVANCE(282);
      END_STATE();
    case 3:
      ADVANCE_MAP(
        '!', 143,
        '"', 160,
        '#', 80,
        '%', 224,
        '&', 203,
        '\'', 161,
        '(', 144,
        ')', 146,
        '*', 132,
        '+', 215,
        ',', 140,
        '-', 219,
        '.', 156,
        '/', 222,
        '0', 271,
        ':', 147,
        ';', 145,
        '<', 230,
        '=', 136,
        '>', 152,
        '?', 287,
        '@', 284,
        '[', 148,
        '\\', 84,
        ']', 149,
        '^', 206,
        '`', 264,
        '{', 138,
        '|', 208,
        '}', 141,
        '~', 240,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(272);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(3);
      if (lookahead > '#') ADVANCE(282);
      END_STATE();
    case 4:
      ADVANCE_MAP(
        '!', 143,
        '%', 223,
        '&', 204,
        '(', 144,
        ')', 146,
        '*', 133,
        '+', 214,
        ',', 140,
        '-', 218,
        '.', 155,
        '/', 221,
        ':', 147,
        ';', 145,
        '<', 231,
        '=', 77,
        '>', 153,
        '?', 31,
        '[', 148,
        '\\', 84,
        ']', 149,
        '^', 205,
        '`', 264,
        '{', 138,
        '|', 210,
        '}', 141,
      );
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(269);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(5);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '`' || '~' < lookahead)) ADVANCE(282);
      END_STATE();
    case 5:
      ADVANCE_MAP(
        '!', 143,
        '%', 223,
        '&', 204,
        '(', 144,
        ')', 146,
        '*', 133,
        '+', 214,
        ',', 140,
        '-', 218,
        '.', 155,
        '/', 221,
        ':', 147,
        ';', 145,
        '<', 231,
        '=', 77,
        '>', 153,
        '?', 31,
        '[', 148,
        '\\', 84,
        ']', 149,
        '^', 205,
        '`', 264,
        '{', 138,
        '|', 210,
        '}', 141,
      );
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(5);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(282);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(130);
      if (lookahead == '\\') ADVANCE(83);
      if (set_contains(sym_identifier_character_set_1, 14, lookahead)) ADVANCE(283);
      END_STATE();
    case 7:
      ADVANCE_MAP(
        '!', 142,
        '"', 160,
        '#', 80,
        '&', 202,
        '\'', 161,
        '(', 144,
        ')', 146,
        '*', 131,
        '+', 214,
        ',', 140,
        '-', 218,
        '.', 156,
        '/', 221,
        '0', 271,
        ':', 147,
        ';', 145,
        '<', 227,
        '=', 137,
        '>', 151,
        '?', 286,
        '@', 284,
        '[', 148,
        '\\', 84,
        ']', 149,
        '`', 264,
        '{', 138,
        '|', 212,
        '}', 141,
        '~', 240,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(272);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(7);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead)) ADVANCE(282);
      END_STATE();
    case 8:
      ADVANCE_MAP(
        '!', 142,
        '"', 160,
        '#', 80,
        '&', 202,
        '\'', 161,
        '(', 144,
        ')', 146,
        '*', 131,
        '+', 214,
        ',', 140,
        '-', 218,
        '.', 156,
        '/', 221,
        '0', 271,
        '<', 227,
        '?', 285,
        '@', 284,
        '[', 148,
        '\\', 84,
        ']', 149,
        '`', 264,
        '{', 139,
        '|', 207,
        '~', 240,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(272);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(8);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(282);
      END_STATE();
    case 9:
      ADVANCE_MAP(
        '"', 160,
        '#', 80,
        '&', 202,
        '\'', 161,
        '(', 144,
        '*', 131,
        '+', 213,
        ',', 140,
        '-', 217,
        '.', 30,
        '/', 24,
        '0', 271,
        ';', 145,
        '<', 227,
        '>', 151,
        '?', 285,
        '@', 284,
        '[', 148,
        '\\', 84,
        ']', 149,
        '`', 264,
        '{', 139,
        '|', 212,
        '}', 141,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(272);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(9);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(282);
      END_STATE();
    case 10:
      ADVANCE_MAP(
        '"', 160,
        '#', 80,
        '\'', 161,
        '(', 144,
        '*', 131,
        '+', 213,
        ',', 140,
        '-', 217,
        '.', 30,
        '/', 24,
        '0', 271,
        ';', 145,
        '<', 227,
        '@', 284,
        '[', 148,
        '\\', 84,
        '{', 138,
        '|', 94,
        '}', 141,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(272);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(10);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(282);
      END_STATE();
    case 11:
      ADVANCE_MAP(
        '"', 160,
        '&', 202,
        '\'', 161,
        '(', 144,
        '*', 131,
        '+', 213,
        '-', 217,
        '.', 101,
        '/', 25,
        '0', 271,
        '<', 227,
        '>', 151,
        '?', 285,
        '[', 148,
        '\\', 84,
        '`', 264,
        '{', 139,
        '|', 207,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(272);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(11);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(280);
      if (lookahead > '~') ADVANCE(282);
      END_STATE();
    case 12:
      if (lookahead == '"') ADVANCE(160);
      if (lookahead == '&') ADVANCE(16);
      if (lookahead == '/') ADVANCE(163);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(162);
      if (lookahead != 0) ADVANCE(164);
      END_STATE();
    case 13:
      if (lookahead == '"') ADVANCE(160);
      if (lookahead == '/') ADVANCE(24);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(13);
      END_STATE();
    case 14:
      if (lookahead == '"') ADVANCE(160);
      if (lookahead == '/') ADVANCE(243);
      if (lookahead == '\\') ADVANCE(85);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(13);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(246);
      if (lookahead != 0) ADVANCE(248);
      END_STATE();
    case 15:
      if (lookahead == '#') ADVANCE(97);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(76);
      END_STATE();
    case 16:
      if (lookahead == '#') ADVANCE(97);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(76);
      if (lookahead != 0) ADVANCE(164);
      END_STATE();
    case 17:
      if (lookahead == '#') ADVANCE(97);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(76);
      if (lookahead != 0) ADVANCE(170);
      END_STATE();
    case 18:
      if (lookahead == '$') ADVANCE(86);
      if (lookahead == '&') ADVANCE(15);
      if (lookahead == '/') ADVANCE(24);
      if (lookahead == '<') ADVANCE(228);
      if (lookahead == '\\') ADVANCE(85);
      if (lookahead == '`') ADVANCE(264);
      if (lookahead == '{') ADVANCE(138);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(19);
      END_STATE();
    case 19:
      if (lookahead == '$') ADVANCE(86);
      if (lookahead == '&') ADVANCE(15);
      if (lookahead == '/') ADVANCE(24);
      if (lookahead == '<') ADVANCE(228);
      if (lookahead == '`') ADVANCE(264);
      if (lookahead == '{') ADVANCE(138);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(19);
      END_STATE();
    case 20:
      ADVANCE_MAP(
        '&', 202,
        '(', 144,
        '+', 78,
        ',', 140,
        '-', 79,
        '.', 155,
        '/', 25,
        ':', 147,
        '<', 227,
        '=', 134,
        '>', 151,
        '?', 37,
        '[', 148,
        '\\', 84,
        '{', 138,
        '|', 207,
      );
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(20);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(280);
      if (lookahead > '~') ADVANCE(282);
      END_STATE();
    case 21:
      if (lookahead == '&') ADVANCE(17);
      if (lookahead == '\'') ADVANCE(161);
      if (lookahead == '/') ADVANCE(169);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(168);
      if (lookahead != 0) ADVANCE(170);
      END_STATE();
    case 22:
      if (lookahead == '\'') ADVANCE(161);
      if (lookahead == '/') ADVANCE(24);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(22);
      END_STATE();
    case 23:
      if (lookahead == '\'') ADVANCE(161);
      if (lookahead == '/') ADVANCE(249);
      if (lookahead == '\\') ADVANCE(85);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(22);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(252);
      if (lookahead != 0) ADVANCE(254);
      END_STATE();
    case 24:
      if (lookahead == '*') ADVANCE(27);
      if (lookahead == '/') ADVANCE(263);
      END_STATE();
    case 25:
      if (lookahead == '*') ADVANCE(27);
      if (lookahead == '/') ADVANCE(263);
      if (lookahead == '>') ADVANCE(159);
      END_STATE();
    case 26:
      if (lookahead == '*') ADVANCE(26);
      if (lookahead == '/') ADVANCE(260);
      if (lookahead != 0) ADVANCE(27);
      END_STATE();
    case 27:
      if (lookahead == '*') ADVANCE(26);
      if (lookahead != 0) ADVANCE(27);
      END_STATE();
    case 28:
      if (lookahead == '*') ADVANCE(165);
      if (lookahead == '#' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(27);
      if (lookahead != 0) ADVANCE(166);
      END_STATE();
    case 29:
      if (lookahead == '*') ADVANCE(171);
      if (lookahead == '#' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(27);
      if (lookahead != 0) ADVANCE(172);
      END_STATE();
    case 30:
      if (lookahead == '.') ADVANCE(32);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(277);
      END_STATE();
    case 31:
      if (lookahead == '.') ADVANCE(175);
      if (lookahead == '?') ADVANCE(238);
      END_STATE();
    case 32:
      if (lookahead == '.') ADVANCE(191);
      END_STATE();
    case 33:
      if (lookahead == '/') ADVANCE(266);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(34);
      END_STATE();
    case 34:
      if (lookahead == '/') ADVANCE(24);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(34);
      END_STATE();
    case 35:
      if (lookahead == ':') ADVANCE(290);
      END_STATE();
    case 36:
      if (lookahead == ':') ADVANCE(289);
      END_STATE();
    case 37:
      if (lookahead == ':') ADVANCE(291);
      END_STATE();
    case 38:
      if (lookahead == ';') ADVANCE(150);
      END_STATE();
    case 39:
      if (lookahead == ';') ADVANCE(150);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(38);
      END_STATE();
    case 40:
      if (lookahead == ';') ADVANCE(150);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(39);
      END_STATE();
    case 41:
      if (lookahead == ';') ADVANCE(150);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(40);
      END_STATE();
    case 42:
      if (lookahead == ';') ADVANCE(150);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(41);
      END_STATE();
    case 43:
      if (lookahead == ';') ADVANCE(150);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(38);
      END_STATE();
    case 44:
      if (lookahead == ';') ADVANCE(150);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(43);
      END_STATE();
    case 45:
      if (lookahead == ';') ADVANCE(150);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(44);
      END_STATE();
    case 46:
      if (lookahead == ';') ADVANCE(150);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(45);
      END_STATE();
    case 47:
      if (lookahead == ';') ADVANCE(150);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(46);
      END_STATE();
    case 48:
      if (lookahead == ';') ADVANCE(150);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(38);
      END_STATE();
    case 49:
      if (lookahead == ';') ADVANCE(150);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(48);
      END_STATE();
    case 50:
      if (lookahead == ';') ADVANCE(150);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(49);
      END_STATE();
    case 51:
      if (lookahead == ';') ADVANCE(150);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(50);
      END_STATE();
    case 52:
      if (lookahead == ';') ADVANCE(150);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(51);
      END_STATE();
    case 53:
      if (lookahead == ';') ADVANCE(150);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(52);
      END_STATE();
    case 54:
      if (lookahead == ';') ADVANCE(150);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(53);
      END_STATE();
    case 55:
      if (lookahead == ';') ADVANCE(150);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(54);
      END_STATE();
    case 56:
      if (lookahead == ';') ADVANCE(150);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(55);
      END_STATE();
    case 57:
      if (lookahead == ';') ADVANCE(150);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(56);
      END_STATE();
    case 58:
      if (lookahead == ';') ADVANCE(150);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(57);
      END_STATE();
    case 59:
      if (lookahead == ';') ADVANCE(150);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(58);
      END_STATE();
    case 60:
      if (lookahead == ';') ADVANCE(150);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(59);
      END_STATE();
    case 61:
      if (lookahead == ';') ADVANCE(150);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(60);
      END_STATE();
    case 62:
      if (lookahead == ';') ADVANCE(150);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(61);
      END_STATE();
    case 63:
      if (lookahead == ';') ADVANCE(150);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(62);
      END_STATE();
    case 64:
      if (lookahead == ';') ADVANCE(150);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(63);
      END_STATE();
    case 65:
      if (lookahead == ';') ADVANCE(150);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 66:
      if (lookahead == ';') ADVANCE(150);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(65);
      END_STATE();
    case 67:
      if (lookahead == ';') ADVANCE(150);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      END_STATE();
    case 68:
      if (lookahead == ';') ADVANCE(150);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(67);
      END_STATE();
    case 69:
      if (lookahead == ';') ADVANCE(150);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(68);
      END_STATE();
    case 70:
      if (lookahead == ';') ADVANCE(150);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(69);
      END_STATE();
    case 71:
      if (lookahead == ';') ADVANCE(150);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(70);
      END_STATE();
    case 72:
      if (lookahead == ';') ADVANCE(150);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(71);
      END_STATE();
    case 73:
      if (lookahead == ';') ADVANCE(150);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(72);
      END_STATE();
    case 74:
      if (lookahead == ';') ADVANCE(150);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(73);
      END_STATE();
    case 75:
      if (lookahead == ';') ADVANCE(150);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(74);
      END_STATE();
    case 76:
      if (lookahead == ';') ADVANCE(150);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      END_STATE();
    case 77:
      if (lookahead == '=') ADVANCE(233);
      END_STATE();
    case 78:
      if (lookahead == '?') ADVANCE(35);
      END_STATE();
    case 79:
      if (lookahead == '?') ADVANCE(36);
      END_STATE();
    case 80:
      if (lookahead == '\\') ADVANCE(83);
      if (set_contains(sym_identifier_character_set_1, 14, lookahead)) ADVANCE(283);
      END_STATE();
    case 81:
      if (lookahead == '\\') ADVANCE(124);
      if (lookahead == ']') ADVANCE(268);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(81);
      END_STATE();
    case 82:
      if (lookahead == 'u') ADVANCE(87);
      if (lookahead == 'x') ADVANCE(114);
      if (lookahead == '\r' ||
          lookahead == '?') ADVANCE(257);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(259);
      if (lookahead != 0) ADVANCE(255);
      END_STATE();
    case 83:
      if (lookahead == 'u') ADVANCE(88);
      END_STATE();
    case 84:
      if (lookahead == 'u') ADVANCE(89);
      END_STATE();
    case 85:
      if (lookahead == 'u') ADVANCE(90);
      if (lookahead == 'x') ADVANCE(114);
      if (lookahead == '\r' ||
          lookahead == '?') ADVANCE(257);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(259);
      if (lookahead != 0) ADVANCE(255);
      END_STATE();
    case 86:
      if (lookahead == '{') ADVANCE(265);
      END_STATE();
    case 87:
      if (lookahead == '{') ADVANCE(108);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(119);
      END_STATE();
    case 88:
      if (lookahead == '{') ADVANCE(112);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(120);
      END_STATE();
    case 89:
      if (lookahead == '{') ADVANCE(113);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(121);
      END_STATE();
    case 90:
      if (lookahead == '{') ADVANCE(115);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(111);
      END_STATE();
    case 91:
      if (lookahead == '}') ADVANCE(282);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(91);
      END_STATE();
    case 92:
      if (lookahead == '}') ADVANCE(283);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(92);
      END_STATE();
    case 93:
      if (lookahead == '}') ADVANCE(255);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(93);
      END_STATE();
    case 94:
      if (lookahead == '}') ADVANCE(293);
      END_STATE();
    case 95:
      if (lookahead == '}') ADVANCE(256);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(95);
      END_STATE();
    case 96:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(103);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(278);
      END_STATE();
    case 97:
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(110);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(42);
      END_STATE();
    case 98:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(274);
      END_STATE();
    case 99:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(275);
      END_STATE();
    case 100:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(272);
      END_STATE();
    case 101:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(277);
      END_STATE();
    case 102:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(273);
      END_STATE();
    case 103:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(278);
      END_STATE();
    case 104:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(282);
      END_STATE();
    case 105:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(283);
      END_STATE();
    case 106:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(255);
      END_STATE();
    case 107:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(276);
      END_STATE();
    case 108:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(95);
      END_STATE();
    case 109:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(256);
      END_STATE();
    case 110:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(47);
      END_STATE();
    case 111:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(114);
      END_STATE();
    case 112:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(92);
      END_STATE();
    case 113:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(91);
      END_STATE();
    case 114:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(106);
      END_STATE();
    case 115:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(93);
      END_STATE();
    case 116:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(109);
      END_STATE();
    case 117:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(105);
      END_STATE();
    case 118:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(104);
      END_STATE();
    case 119:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(116);
      END_STATE();
    case 120:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(117);
      END_STATE();
    case 121:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(118);
      END_STATE();
    case 122:
      if (lookahead != 0 &&
          lookahead != '#' &&
          (lookahead < 'A' || 'Z' < lookahead) &&
          (lookahead < 'a' || 'z' < lookahead)) ADVANCE(164);
      END_STATE();
    case 123:
      if (lookahead != 0 &&
          lookahead != '#' &&
          (lookahead < 'A' || 'Z' < lookahead) &&
          (lookahead < 'a' || 'z' < lookahead)) ADVANCE(170);
      END_STATE();
    case 124:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(81);
      END_STATE();
    case 125:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(268);
      END_STATE();
    case 126:
      if (eof) ADVANCE(129);
      ADVANCE_MAP(
        '!', 143,
        '"', 160,
        '#', 6,
        '$', 281,
        '%', 224,
        '&', 203,
        '\'', 161,
        '(', 144,
        ')', 146,
        '*', 132,
        '+', 216,
        ',', 140,
        '-', 220,
        '.', 156,
        '/', 222,
        '0', 271,
        ':', 147,
        ';', 145,
        '<', 229,
        '=', 136,
        '>', 152,
        '?', 287,
        '@', 284,
        '[', 148,
        '\\', 84,
        ']', 149,
        '^', 206,
        '`', 264,
        '{', 139,
        '|', 209,
        '}', 141,
        '~', 240,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(272);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(126);
      if (lookahead > '@') ADVANCE(282);
      END_STATE();
    case 127:
      if (eof) ADVANCE(129);
      ADVANCE_MAP(
        '!', 143,
        '"', 160,
        '#', 80,
        '%', 223,
        '&', 204,
        '\'', 161,
        '(', 144,
        ')', 146,
        '*', 133,
        '+', 214,
        ',', 140,
        '-', 218,
        '.', 157,
        '/', 221,
        '0', 271,
        ':', 147,
        ';', 145,
        '<', 231,
        '=', 135,
        '>', 153,
        '?', 288,
        '@', 284,
        '[', 148,
        '\\', 84,
        ']', 149,
        '^', 205,
        '`', 264,
        '{', 138,
        '|', 211,
        '}', 141,
        '~', 240,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(272);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(127);
      if (lookahead > '#') ADVANCE(282);
      END_STATE();
    case 128:
      if (eof) ADVANCE(129);
      ADVANCE_MAP(
        '!', 142,
        '"', 160,
        '#', 6,
        '&', 202,
        '\'', 161,
        '(', 144,
        ')', 146,
        '*', 131,
        '+', 214,
        ',', 140,
        '-', 218,
        '.', 156,
        '/', 221,
        '0', 271,
        ':', 147,
        ';', 145,
        '<', 227,
        '=', 137,
        '>', 151,
        '?', 285,
        '@', 284,
        '[', 148,
        '\\', 84,
        ']', 149,
        '`', 264,
        '{', 138,
        '|', 212,
        '}', 141,
        '~', 240,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(272);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(128);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead)) ADVANCE(282);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_hash_bang_line);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(130);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(226);
      if (lookahead == '=') ADVANCE(178);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(225);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(233);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(233);
      if (lookahead == '>') ADVANCE(174);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '>') ADVANCE(174);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      if (lookahead == '|') ADVANCE(292);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(235);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym_html_character_reference);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(237);
      if (lookahead == '>') ADVANCE(196);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(237);
      if (lookahead == '>') ADVANCE(197);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(sym_jsx_identifier);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(154);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(32);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(277);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(277);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_LT_SLASH);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_SLASH_GT);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym_unescaped_double_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(16);
      if (lookahead == '/') ADVANCE(163);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(162);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(164);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(sym_unescaped_double_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(122);
      if (lookahead == '*') ADVANCE(166);
      if (lookahead == '/') ADVANCE(167);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(164);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_unescaped_double_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(122);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(164);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_unescaped_double_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(28);
      if (lookahead == '*') ADVANCE(165);
      if (lookahead == '/') ADVANCE(164);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(166);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_unescaped_double_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(28);
      if (lookahead == '*') ADVANCE(165);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(166);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_unescaped_double_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(261);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(164);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(167);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_unescaped_single_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(17);
      if (lookahead == '/') ADVANCE(169);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(168);
      if (lookahead != 0 &&
          lookahead != '&' &&
          lookahead != '\'') ADVANCE(170);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_unescaped_single_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(123);
      if (lookahead == '*') ADVANCE(172);
      if (lookahead == '/') ADVANCE(173);
      if (lookahead != 0 &&
          lookahead != '&' &&
          lookahead != '\'') ADVANCE(170);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym_unescaped_single_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(123);
      if (lookahead != 0 &&
          lookahead != '&' &&
          lookahead != '\'') ADVANCE(170);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym_unescaped_single_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(29);
      if (lookahead == '*') ADVANCE(171);
      if (lookahead == '/') ADVANCE(170);
      if (lookahead != 0 &&
          lookahead != '&' &&
          lookahead != '\'') ADVANCE(172);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym_unescaped_single_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(29);
      if (lookahead == '*') ADVANCE(171);
      if (lookahead != 0 &&
          lookahead != '&' &&
          lookahead != '\'') ADVANCE(172);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym_unescaped_single_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(262);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(170);
      if (lookahead != 0 &&
          lookahead != '&' &&
          lookahead != '\'') ADVANCE(173);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_QMARK_DOT);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT_EQ);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_STAR_STAR_EQ);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_AMP_AMP_EQ);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE_EQ);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK_EQ);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      if (lookahead == '=') ADVANCE(188);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      if (lookahead == '=') ADVANCE(189);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(184);
      if (lookahead == '>') ADVANCE(199);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(198);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      if (lookahead == '=') ADVANCE(185);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(186);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(193);
      if (lookahead == '=') ADVANCE(182);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(192);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(181);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(183);
      if (lookahead == '|') ADVANCE(195);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(183);
      if (lookahead == '|') ADVANCE(195);
      if (lookahead == '}') ADVANCE(293);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(194);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(194);
      if (lookahead == '}') ADVANCE(293);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '}') ADVANCE(293);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(241);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(241);
      if (lookahead == '=') ADVANCE(176);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(241);
      if (lookahead == '=') ADVANCE(176);
      if (lookahead == '?') ADVANCE(35);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(242);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(242);
      if (lookahead == '=') ADVANCE(177);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(242);
      if (lookahead == '=') ADVANCE(177);
      if (lookahead == '?') ADVANCE(36);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(27);
      if (lookahead == '/') ADVANCE(263);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(27);
      if (lookahead == '/') ADVANCE(263);
      if (lookahead == '=') ADVANCE(179);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(180);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      if (lookahead == '=') ADVANCE(187);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '/') ADVANCE(158);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '/') ADVANCE(158);
      if (lookahead == '<') ADVANCE(201);
      if (lookahead == '=') ADVANCE(232);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(201);
      if (lookahead == '=') ADVANCE(232);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(200);
      if (lookahead == '=') ADVANCE(232);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '=') ADVANCE(234);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_EQ_EQ_EQ);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      if (lookahead == '=') ADVANCE(236);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_BANG_EQ_EQ);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      if (lookahead == '=') ADVANCE(190);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '/') ADVANCE(247);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(248);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(244);
      if (lookahead == '/') ADVANCE(248);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(245);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(244);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(245);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '/') ADVANCE(243);
      if ((set_contains(extras_character_set_1, 10, lookahead)) &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(246);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(248);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(248);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(247);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(248);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(251);
      if (lookahead == '/') ADVANCE(253);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(254);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(250);
      if (lookahead == '/') ADVANCE(254);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(251);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(250);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(251);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '/') ADVANCE(249);
      if ((set_contains(extras_character_set_1, 10, lookahead)) &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(252);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(254);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(254);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(253);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(254);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(84);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(282);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n' ||
          lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(255);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(255);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(258);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(164);
      if (lookahead == '#' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(263);
      if (lookahead != 0) ADVANCE(167);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(170);
      if (lookahead == '#' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(263);
      if (lookahead != 0) ADVANCE(173);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != 0x2028 &&
          lookahead != 0x2029) ADVANCE(263);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(anon_sym_SLASH2);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '\n') SKIP(34);
      if (lookahead == '/') ADVANCE(24);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(125);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(267);
      if (lookahead != 0) ADVANCE(268);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(125);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '/') ADVANCE(268);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(sym_regex_flags);
      if (lookahead == '\\') ADVANCE(84);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(269);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(282);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(sym_number);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(sym_number);
      ADVANCE_MAP(
        '.', 279,
        '0', 273,
        '_', 102,
        'n', 270,
        'B', 98,
        'b', 98,
        'E', 96,
        'e', 96,
        'O', 99,
        'o', 99,
        'X', 107,
        'x', 107,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(272);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(279);
      if (lookahead == '_') ADVANCE(100);
      if (lookahead == 'n') ADVANCE(270);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(96);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(272);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(102);
      if (lookahead == 'n') ADVANCE(270);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(273);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(98);
      if (lookahead == 'n') ADVANCE(270);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(274);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(99);
      if (lookahead == 'n') ADVANCE(270);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(275);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(107);
      if (lookahead == 'n') ADVANCE(270);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(276);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(101);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(96);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(277);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(103);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(278);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(96);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(277);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(154);
      if (lookahead == '\\') ADVANCE(84);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(280);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(282);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(84);
      if (lookahead == '{') ADVANCE(265);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(282);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(84);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(282);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(sym_private_property_identifier);
      if (lookahead == '\\') ADVANCE(83);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(283);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(175);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(175);
      if (lookahead == '?') ADVANCE(239);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(175);
      if (lookahead == '?') ADVANCE(238);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(anon_sym_DASH_QMARK_COLON);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(anon_sym_PLUS_QMARK_COLON);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_QMARK_COLON);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(anon_sym_LBRACE_PIPE);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(anon_sym_PIPE_RBRACE);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ADVANCE_MAP(
        'a', 1,
        'b', 2,
        'c', 3,
        'd', 4,
        'e', 5,
        'f', 6,
        'g', 7,
        'i', 8,
        'k', 9,
        'l', 10,
        'm', 11,
        'n', 12,
        'o', 13,
        'p', 14,
        'r', 15,
        's', 16,
        't', 17,
        'u', 18,
        'v', 19,
        'w', 20,
        'y', 21,
      );
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 'b') ADVANCE(22);
      if (lookahead == 'c') ADVANCE(23);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead == 's') ADVANCE(25);
      if (lookahead == 'w') ADVANCE(26);
      END_STATE();
    case 2:
      if (lookahead == 'o') ADVANCE(27);
      if (lookahead == 'r') ADVANCE(28);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(29);
      if (lookahead == 'l') ADVANCE(30);
      if (lookahead == 'o') ADVANCE(31);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(32);
      if (lookahead == 'o') ADVANCE(33);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(34);
      if (lookahead == 'n') ADVANCE(35);
      if (lookahead == 'x') ADVANCE(36);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(37);
      if (lookahead == 'i') ADVANCE(38);
      if (lookahead == 'o') ADVANCE(39);
      if (lookahead == 'r') ADVANCE(40);
      if (lookahead == 'u') ADVANCE(41);
      END_STATE();
    case 7:
      if (lookahead == 'e') ADVANCE(42);
      if (lookahead == 'l') ADVANCE(43);
      END_STATE();
    case 8:
      if (lookahead == 'f') ADVANCE(44);
      if (lookahead == 'm') ADVANCE(45);
      if (lookahead == 'n') ADVANCE(46);
      if (lookahead == 's') ADVANCE(47);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(48);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(49);
      END_STATE();
    case 11:
      if (lookahead == 'e') ADVANCE(50);
      if (lookahead == 'o') ADVANCE(51);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(52);
      if (lookahead == 'e') ADVANCE(53);
      if (lookahead == 'u') ADVANCE(54);
      END_STATE();
    case 13:
      if (lookahead == 'b') ADVANCE(55);
      if (lookahead == 'f') ADVANCE(56);
      if (lookahead == 'v') ADVANCE(57);
      END_STATE();
    case 14:
      if (lookahead == 'r') ADVANCE(58);
      if (lookahead == 'u') ADVANCE(59);
      END_STATE();
    case 15:
      if (lookahead == 'e') ADVANCE(60);
      END_STATE();
    case 16:
      if (lookahead == 'a') ADVANCE(61);
      if (lookahead == 'e') ADVANCE(62);
      if (lookahead == 't') ADVANCE(63);
      if (lookahead == 'u') ADVANCE(64);
      if (lookahead == 'w') ADVANCE(65);
      if (lookahead == 'y') ADVANCE(66);
      END_STATE();
    case 17:
      if (lookahead == 'a') ADVANCE(67);
      if (lookahead == 'h') ADVANCE(68);
      if (lookahead == 'r') ADVANCE(69);
      if (lookahead == 'y') ADVANCE(70);
      END_STATE();
    case 18:
      if (lookahead == 'n') ADVANCE(71);
      if (lookahead == 's') ADVANCE(72);
      END_STATE();
    case 19:
      if (lookahead == 'a') ADVANCE(73);
      if (lookahead == 'o') ADVANCE(74);
      END_STATE();
    case 20:
      if (lookahead == 'h') ADVANCE(75);
      if (lookahead == 'i') ADVANCE(76);
      END_STATE();
    case 21:
      if (lookahead == 'i') ADVANCE(77);
      END_STATE();
    case 22:
      if (lookahead == 's') ADVANCE(78);
      END_STATE();
    case 23:
      if (lookahead == 'c') ADVANCE(79);
      END_STATE();
    case 24:
      if (lookahead == 'y') ADVANCE(80);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(81);
      if (lookahead == 'y') ADVANCE(82);
      END_STATE();
    case 26:
      if (lookahead == 'a') ADVANCE(83);
      END_STATE();
    case 27:
      if (lookahead == 'o') ADVANCE(84);
      END_STATE();
    case 28:
      if (lookahead == 'e') ADVANCE(85);
      END_STATE();
    case 29:
      if (lookahead == 's') ADVANCE(86);
      if (lookahead == 't') ADVANCE(87);
      END_STATE();
    case 30:
      if (lookahead == 'a') ADVANCE(88);
      END_STATE();
    case 31:
      if (lookahead == 'n') ADVANCE(89);
      END_STATE();
    case 32:
      if (lookahead == 'b') ADVANCE(90);
      if (lookahead == 'c') ADVANCE(91);
      if (lookahead == 'f') ADVANCE(92);
      if (lookahead == 'l') ADVANCE(93);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 34:
      if (lookahead == 's') ADVANCE(94);
      END_STATE();
    case 35:
      if (lookahead == 'u') ADVANCE(95);
      END_STATE();
    case 36:
      if (lookahead == 'p') ADVANCE(96);
      if (lookahead == 't') ADVANCE(97);
      END_STATE();
    case 37:
      if (lookahead == 'l') ADVANCE(98);
      END_STATE();
    case 38:
      if (lookahead == 'n') ADVANCE(99);
      END_STATE();
    case 39:
      if (lookahead == 'r') ADVANCE(100);
      END_STATE();
    case 40:
      if (lookahead == 'o') ADVANCE(101);
      END_STATE();
    case 41:
      if (lookahead == 'n') ADVANCE(102);
      END_STATE();
    case 42:
      if (lookahead == 't') ADVANCE(103);
      END_STATE();
    case 43:
      if (lookahead == 'o') ADVANCE(104);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 45:
      if (lookahead == 'p') ADVANCE(105);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 'f') ADVANCE(106);
      if (lookahead == 's') ADVANCE(107);
      if (lookahead == 't') ADVANCE(108);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 48:
      if (lookahead == 'y') ADVANCE(109);
      END_STATE();
    case 49:
      if (lookahead == 't') ADVANCE(110);
      END_STATE();
    case 50:
      if (lookahead == 't') ADVANCE(111);
      END_STATE();
    case 51:
      if (lookahead == 'd') ADVANCE(112);
      END_STATE();
    case 52:
      if (lookahead == 'm') ADVANCE(113);
      END_STATE();
    case 53:
      if (lookahead == 'v') ADVANCE(114);
      if (lookahead == 'w') ADVANCE(115);
      END_STATE();
    case 54:
      if (lookahead == 'l') ADVANCE(116);
      if (lookahead == 'm') ADVANCE(117);
      END_STATE();
    case 55:
      if (lookahead == 'j') ADVANCE(118);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_of);
      END_STATE();
    case 57:
      if (lookahead == 'e') ADVANCE(119);
      END_STATE();
    case 58:
      if (lookahead == 'i') ADVANCE(120);
      if (lookahead == 'o') ADVANCE(121);
      END_STATE();
    case 59:
      if (lookahead == 'b') ADVANCE(122);
      END_STATE();
    case 60:
      if (lookahead == 'a') ADVANCE(123);
      if (lookahead == 'q') ADVANCE(124);
      if (lookahead == 't') ADVANCE(125);
      END_STATE();
    case 61:
      if (lookahead == 't') ADVANCE(126);
      END_STATE();
    case 62:
      if (lookahead == 't') ADVANCE(127);
      END_STATE();
    case 63:
      if (lookahead == 'a') ADVANCE(128);
      if (lookahead == 'r') ADVANCE(129);
      END_STATE();
    case 64:
      if (lookahead == 'p') ADVANCE(130);
      END_STATE();
    case 65:
      if (lookahead == 'i') ADVANCE(131);
      END_STATE();
    case 66:
      if (lookahead == 'm') ADVANCE(132);
      END_STATE();
    case 67:
      if (lookahead == 'r') ADVANCE(133);
      END_STATE();
    case 68:
      if (lookahead == 'i') ADVANCE(134);
      if (lookahead == 'r') ADVANCE(135);
      END_STATE();
    case 69:
      if (lookahead == 'u') ADVANCE(136);
      if (lookahead == 'y') ADVANCE(137);
      END_STATE();
    case 70:
      if (lookahead == 'p') ADVANCE(138);
      END_STATE();
    case 71:
      if (lookahead == 'd') ADVANCE(139);
      if (lookahead == 'i') ADVANCE(140);
      if (lookahead == 'k') ADVANCE(141);
      END_STATE();
    case 72:
      if (lookahead == 'i') ADVANCE(142);
      END_STATE();
    case 73:
      if (lookahead == 'r') ADVANCE(143);
      END_STATE();
    case 74:
      if (lookahead == 'i') ADVANCE(144);
      END_STATE();
    case 75:
      if (lookahead == 'i') ADVANCE(145);
      END_STATE();
    case 76:
      if (lookahead == 't') ADVANCE(146);
      END_STATE();
    case 77:
      if (lookahead == 'e') ADVANCE(147);
      END_STATE();
    case 78:
      if (lookahead == 't') ADVANCE(148);
      END_STATE();
    case 79:
      if (lookahead == 'e') ADVANCE(149);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_any);
      END_STATE();
    case 81:
      if (lookahead == 'e') ADVANCE(150);
      END_STATE();
    case 82:
      if (lookahead == 'n') ADVANCE(151);
      END_STATE();
    case 83:
      if (lookahead == 'i') ADVANCE(152);
      END_STATE();
    case 84:
      if (lookahead == 'l') ADVANCE(153);
      END_STATE();
    case 85:
      if (lookahead == 'a') ADVANCE(154);
      END_STATE();
    case 86:
      if (lookahead == 'e') ADVANCE(155);
      END_STATE();
    case 87:
      if (lookahead == 'c') ADVANCE(156);
      END_STATE();
    case 88:
      if (lookahead == 's') ADVANCE(157);
      END_STATE();
    case 89:
      if (lookahead == 's') ADVANCE(158);
      if (lookahead == 't') ADVANCE(159);
      END_STATE();
    case 90:
      if (lookahead == 'u') ADVANCE(160);
      END_STATE();
    case 91:
      if (lookahead == 'l') ADVANCE(161);
      END_STATE();
    case 92:
      if (lookahead == 'a') ADVANCE(162);
      END_STATE();
    case 93:
      if (lookahead == 'e') ADVANCE(163);
      END_STATE();
    case 94:
      if (lookahead == 'e') ADVANCE(164);
      END_STATE();
    case 95:
      if (lookahead == 'm') ADVANCE(165);
      END_STATE();
    case 96:
      if (lookahead == 'o') ADVANCE(166);
      END_STATE();
    case 97:
      if (lookahead == 'e') ADVANCE(167);
      END_STATE();
    case 98:
      if (lookahead == 's') ADVANCE(168);
      END_STATE();
    case 99:
      if (lookahead == 'a') ADVANCE(169);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 101:
      if (lookahead == 'm') ADVANCE(170);
      END_STATE();
    case 102:
      if (lookahead == 'c') ADVANCE(171);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_get);
      END_STATE();
    case 104:
      if (lookahead == 'b') ADVANCE(172);
      END_STATE();
    case 105:
      if (lookahead == 'l') ADVANCE(173);
      if (lookahead == 'o') ADVANCE(174);
      END_STATE();
    case 106:
      if (lookahead == 'e') ADVANCE(175);
      END_STATE();
    case 107:
      if (lookahead == 't') ADVANCE(176);
      END_STATE();
    case 108:
      if (lookahead == 'e') ADVANCE(177);
      END_STATE();
    case 109:
      if (lookahead == 'o') ADVANCE(178);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 111:
      if (lookahead == 'a') ADVANCE(179);
      END_STATE();
    case 112:
      if (lookahead == 'u') ADVANCE(180);
      END_STATE();
    case 113:
      if (lookahead == 'e') ADVANCE(181);
      END_STATE();
    case 114:
      if (lookahead == 'e') ADVANCE(182);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 116:
      if (lookahead == 'l') ADVANCE(183);
      END_STATE();
    case 117:
      if (lookahead == 'b') ADVANCE(184);
      END_STATE();
    case 118:
      if (lookahead == 'e') ADVANCE(185);
      END_STATE();
    case 119:
      if (lookahead == 'r') ADVANCE(186);
      END_STATE();
    case 120:
      if (lookahead == 'v') ADVANCE(187);
      END_STATE();
    case 121:
      if (lookahead == 't') ADVANCE(188);
      END_STATE();
    case 122:
      if (lookahead == 'l') ADVANCE(189);
      END_STATE();
    case 123:
      if (lookahead == 'd') ADVANCE(190);
      END_STATE();
    case 124:
      if (lookahead == 'u') ADVANCE(191);
      END_STATE();
    case 125:
      if (lookahead == 'u') ADVANCE(192);
      END_STATE();
    case 126:
      if (lookahead == 'i') ADVANCE(193);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_set);
      END_STATE();
    case 128:
      if (lookahead == 't') ADVANCE(194);
      END_STATE();
    case 129:
      if (lookahead == 'i') ADVANCE(195);
      END_STATE();
    case 130:
      if (lookahead == 'e') ADVANCE(196);
      END_STATE();
    case 131:
      if (lookahead == 't') ADVANCE(197);
      END_STATE();
    case 132:
      if (lookahead == 'b') ADVANCE(198);
      END_STATE();
    case 133:
      if (lookahead == 'g') ADVANCE(199);
      END_STATE();
    case 134:
      if (lookahead == 's') ADVANCE(200);
      END_STATE();
    case 135:
      if (lookahead == 'o') ADVANCE(201);
      END_STATE();
    case 136:
      if (lookahead == 'e') ADVANCE(202);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 138:
      if (lookahead == 'e') ADVANCE(203);
      END_STATE();
    case 139:
      if (lookahead == 'e') ADVANCE(204);
      END_STATE();
    case 140:
      if (lookahead == 'q') ADVANCE(205);
      END_STATE();
    case 141:
      if (lookahead == 'n') ADVANCE(206);
      END_STATE();
    case 142:
      if (lookahead == 'n') ADVANCE(207);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 144:
      if (lookahead == 'd') ADVANCE(208);
      END_STATE();
    case 145:
      if (lookahead == 'l') ADVANCE(209);
      END_STATE();
    case 146:
      if (lookahead == 'h') ADVANCE(210);
      END_STATE();
    case 147:
      if (lookahead == 'l') ADVANCE(211);
      END_STATE();
    case 148:
      if (lookahead == 'r') ADVANCE(212);
      END_STATE();
    case 149:
      if (lookahead == 's') ADVANCE(213);
      END_STATE();
    case 150:
      if (lookahead == 'r') ADVANCE(214);
      END_STATE();
    case 151:
      if (lookahead == 'c') ADVANCE(215);
      END_STATE();
    case 152:
      if (lookahead == 't') ADVANCE(216);
      END_STATE();
    case 153:
      if (lookahead == 'e') ADVANCE(217);
      END_STATE();
    case 154:
      if (lookahead == 'k') ADVANCE(218);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 156:
      if (lookahead == 'h') ADVANCE(219);
      END_STATE();
    case 157:
      if (lookahead == 's') ADVANCE(220);
      END_STATE();
    case 158:
      if (lookahead == 't') ADVANCE(221);
      END_STATE();
    case 159:
      if (lookahead == 'i') ADVANCE(222);
      END_STATE();
    case 160:
      if (lookahead == 'g') ADVANCE(223);
      END_STATE();
    case 161:
      if (lookahead == 'a') ADVANCE(224);
      END_STATE();
    case 162:
      if (lookahead == 'u') ADVANCE(225);
      END_STATE();
    case 163:
      if (lookahead == 't') ADVANCE(226);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 166:
      if (lookahead == 'r') ADVANCE(227);
      END_STATE();
    case 167:
      if (lookahead == 'n') ADVANCE(228);
      END_STATE();
    case 168:
      if (lookahead == 'e') ADVANCE(229);
      END_STATE();
    case 169:
      if (lookahead == 'l') ADVANCE(230);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 171:
      if (lookahead == 't') ADVANCE(231);
      END_STATE();
    case 172:
      if (lookahead == 'a') ADVANCE(232);
      END_STATE();
    case 173:
      if (lookahead == 'e') ADVANCE(233);
      END_STATE();
    case 174:
      if (lookahead == 'r') ADVANCE(234);
      END_STATE();
    case 175:
      if (lookahead == 'r') ADVANCE(235);
      END_STATE();
    case 176:
      if (lookahead == 'a') ADVANCE(236);
      END_STATE();
    case 177:
      if (lookahead == 'r') ADVANCE(237);
      END_STATE();
    case 178:
      if (lookahead == 'f') ADVANCE(238);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_meta);
      END_STATE();
    case 180:
      if (lookahead == 'l') ADVANCE(239);
      END_STATE();
    case 181:
      if (lookahead == 's') ADVANCE(240);
      END_STATE();
    case 182:
      if (lookahead == 'r') ADVANCE(241);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 184:
      if (lookahead == 'e') ADVANCE(242);
      END_STATE();
    case 185:
      if (lookahead == 'c') ADVANCE(243);
      END_STATE();
    case 186:
      if (lookahead == 'r') ADVANCE(244);
      END_STATE();
    case 187:
      if (lookahead == 'a') ADVANCE(245);
      END_STATE();
    case 188:
      if (lookahead == 'e') ADVANCE(246);
      END_STATE();
    case 189:
      if (lookahead == 'i') ADVANCE(247);
      END_STATE();
    case 190:
      if (lookahead == 'o') ADVANCE(248);
      END_STATE();
    case 191:
      if (lookahead == 'i') ADVANCE(249);
      END_STATE();
    case 192:
      if (lookahead == 'r') ADVANCE(250);
      END_STATE();
    case 193:
      if (lookahead == 's') ADVANCE(251);
      END_STATE();
    case 194:
      if (lookahead == 'i') ADVANCE(252);
      END_STATE();
    case 195:
      if (lookahead == 'n') ADVANCE(253);
      END_STATE();
    case 196:
      if (lookahead == 'r') ADVANCE(254);
      END_STATE();
    case 197:
      if (lookahead == 'c') ADVANCE(255);
      END_STATE();
    case 198:
      if (lookahead == 'o') ADVANCE(256);
      END_STATE();
    case 199:
      if (lookahead == 'e') ADVANCE(257);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_this);
      END_STATE();
    case 201:
      if (lookahead == 'w') ADVANCE(258);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_type);
      if (lookahead == 'o') ADVANCE(259);
      END_STATE();
    case 204:
      if (lookahead == 'f') ADVANCE(260);
      END_STATE();
    case 205:
      if (lookahead == 'u') ADVANCE(261);
      END_STATE();
    case 206:
      if (lookahead == 'o') ADVANCE(262);
      END_STATE();
    case 207:
      if (lookahead == 'g') ADVANCE(263);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_void);
      END_STATE();
    case 209:
      if (lookahead == 'e') ADVANCE(264);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 211:
      if (lookahead == 'd') ADVANCE(265);
      END_STATE();
    case 212:
      if (lookahead == 'a') ADVANCE(266);
      END_STATE();
    case 213:
      if (lookahead == 's') ADVANCE(267);
      END_STATE();
    case 214:
      if (lookahead == 't') ADVANCE(268);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_async);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 217:
      if (lookahead == 'a') ADVANCE(269);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 222:
      if (lookahead == 'n') ADVANCE(270);
      END_STATE();
    case 223:
      if (lookahead == 'g') ADVANCE(271);
      END_STATE();
    case 224:
      if (lookahead == 'r') ADVANCE(272);
      END_STATE();
    case 225:
      if (lookahead == 'l') ADVANCE(273);
      END_STATE();
    case 226:
      if (lookahead == 'e') ADVANCE(274);
      END_STATE();
    case 227:
      if (lookahead == 't') ADVANCE(275);
      END_STATE();
    case 228:
      if (lookahead == 'd') ADVANCE(276);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 230:
      if (lookahead == 'l') ADVANCE(277);
      END_STATE();
    case 231:
      if (lookahead == 'i') ADVANCE(278);
      END_STATE();
    case 232:
      if (lookahead == 'l') ADVANCE(279);
      END_STATE();
    case 233:
      if (lookahead == 'm') ADVANCE(280);
      END_STATE();
    case 234:
      if (lookahead == 't') ADVANCE(281);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_infer);
      END_STATE();
    case 236:
      if (lookahead == 'n') ADVANCE(282);
      END_STATE();
    case 237:
      if (lookahead == 'f') ADVANCE(283);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_keyof);
      END_STATE();
    case 239:
      if (lookahead == 'e') ADVANCE(284);
      END_STATE();
    case 240:
      if (lookahead == 'p') ADVANCE(285);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_never);
      END_STATE();
    case 242:
      if (lookahead == 'r') ADVANCE(286);
      END_STATE();
    case 243:
      if (lookahead == 't') ADVANCE(287);
      END_STATE();
    case 244:
      if (lookahead == 'i') ADVANCE(288);
      END_STATE();
    case 245:
      if (lookahead == 't') ADVANCE(289);
      END_STATE();
    case 246:
      if (lookahead == 'c') ADVANCE(290);
      END_STATE();
    case 247:
      if (lookahead == 'c') ADVANCE(291);
      END_STATE();
    case 248:
      if (lookahead == 'n') ADVANCE(292);
      END_STATE();
    case 249:
      if (lookahead == 'r') ADVANCE(293);
      END_STATE();
    case 250:
      if (lookahead == 'n') ADVANCE(294);
      END_STATE();
    case 251:
      if (lookahead == 'f') ADVANCE(295);
      END_STATE();
    case 252:
      if (lookahead == 'c') ADVANCE(296);
      END_STATE();
    case 253:
      if (lookahead == 'g') ADVANCE(297);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(sym_super);
      END_STATE();
    case 255:
      if (lookahead == 'h') ADVANCE(298);
      END_STATE();
    case 256:
      if (lookahead == 'l') ADVANCE(299);
      END_STATE();
    case 257:
      if (lookahead == 't') ADVANCE(300);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_throw);
      END_STATE();
    case 259:
      if (lookahead == 'f') ADVANCE(301);
      END_STATE();
    case 260:
      if (lookahead == 'i') ADVANCE(302);
      END_STATE();
    case 261:
      if (lookahead == 'e') ADVANCE(303);
      END_STATE();
    case 262:
      if (lookahead == 'w') ADVANCE(304);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_using);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 266:
      if (lookahead == 'c') ADVANCE(305);
      END_STATE();
    case 267:
      if (lookahead == 'o') ADVANCE(306);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_assert);
      if (lookahead == 's') ADVANCE(307);
      END_STATE();
    case 269:
      if (lookahead == 'n') ADVANCE(308);
      END_STATE();
    case 270:
      if (lookahead == 'u') ADVANCE(309);
      END_STATE();
    case 271:
      if (lookahead == 'e') ADVANCE(310);
      END_STATE();
    case 272:
      if (lookahead == 'e') ADVANCE(311);
      END_STATE();
    case 273:
      if (lookahead == 't') ADVANCE(312);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_delete);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 276:
      if (lookahead == 's') ADVANCE(313);
      END_STATE();
    case 277:
      if (lookahead == 'y') ADVANCE(314);
      END_STATE();
    case 278:
      if (lookahead == 'o') ADVANCE(315);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_global);
      END_STATE();
    case 280:
      if (lookahead == 'e') ADVANCE(316);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 282:
      if (lookahead == 'c') ADVANCE(317);
      END_STATE();
    case 283:
      if (lookahead == 'a') ADVANCE(318);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 285:
      if (lookahead == 'a') ADVANCE(319);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_number);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_object);
      END_STATE();
    case 288:
      if (lookahead == 'd') ADVANCE(320);
      END_STATE();
    case 289:
      if (lookahead == 'e') ADVANCE(321);
      END_STATE();
    case 290:
      if (lookahead == 't') ADVANCE(322);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_public);
      END_STATE();
    case 292:
      if (lookahead == 'l') ADVANCE(323);
      END_STATE();
    case 293:
      if (lookahead == 'e') ADVANCE(324);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 295:
      if (lookahead == 'i') ADVANCE(325);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(anon_sym_string);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(anon_sym_symbol);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(anon_sym_target);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(anon_sym_typeof);
      END_STATE();
    case 302:
      if (lookahead == 'n') ADVANCE(326);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(anon_sym_unique);
      END_STATE();
    case 304:
      if (lookahead == 'n') ADVANCE(327);
      END_STATE();
    case 305:
      if (lookahead == 't') ADVANCE(328);
      END_STATE();
    case 306:
      if (lookahead == 'r') ADVANCE(329);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(anon_sym_asserts);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(anon_sym_boolean);
      END_STATE();
    case 309:
      if (lookahead == 'e') ADVANCE(330);
      END_STATE();
    case 310:
      if (lookahead == 'r') ADVANCE(331);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(anon_sym_declare);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 315:
      if (lookahead == 'n') ADVANCE(332);
      END_STATE();
    case 316:
      if (lookahead == 'n') ADVANCE(333);
      END_STATE();
    case 317:
      if (lookahead == 'e') ADVANCE(334);
      END_STATE();
    case 318:
      if (lookahead == 'c') ADVANCE(335);
      END_STATE();
    case 319:
      if (lookahead == 'c') ADVANCE(336);
      END_STATE();
    case 320:
      if (lookahead == 'e') ADVANCE(337);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(anon_sym_private);
      END_STATE();
    case 322:
      if (lookahead == 'e') ADVANCE(338);
      END_STATE();
    case 323:
      if (lookahead == 'y') ADVANCE(339);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(anon_sym_require);
      END_STATE();
    case 325:
      if (lookahead == 'e') ADVANCE(340);
      END_STATE();
    case 326:
      if (lookahead == 'e') ADVANCE(341);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(anon_sym_unknown);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(anon_sym_abstract);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(anon_sym_accessor);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(anon_sym_debugger);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 333:
      if (lookahead == 't') ADVANCE(342);
      END_STATE();
    case 334:
      if (lookahead == 'o') ADVANCE(343);
      END_STATE();
    case 335:
      if (lookahead == 'e') ADVANCE(344);
      END_STATE();
    case 336:
      if (lookahead == 'e') ADVANCE(345);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(anon_sym_override);
      END_STATE();
    case 338:
      if (lookahead == 'd') ADVANCE(346);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(anon_sym_readonly);
      END_STATE();
    case 340:
      if (lookahead == 's') ADVANCE(347);
      END_STATE();
    case 341:
      if (lookahead == 'd') ADVANCE(348);
      END_STATE();
    case 342:
      if (lookahead == 's') ADVANCE(349);
      END_STATE();
    case 343:
      if (lookahead == 'f') ADVANCE(350);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(anon_sym_interface);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(anon_sym_namespace);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(anon_sym_protected);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(anon_sym_satisfies);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(sym_undefined);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(anon_sym_implements);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(anon_sym_instanceof);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 128, .external_lex_state = 2},
  [2] = {.lex_state = 2, .external_lex_state = 3},
  [3] = {.lex_state = 2, .external_lex_state = 3},
  [4] = {.lex_state = 128, .external_lex_state = 2},
  [5] = {.lex_state = 128, .external_lex_state = 2},
  [6] = {.lex_state = 128, .external_lex_state = 2},
  [7] = {.lex_state = 128, .external_lex_state = 2},
  [8] = {.lex_state = 128, .external_lex_state = 2},
  [9] = {.lex_state = 128, .external_lex_state = 2},
  [10] = {.lex_state = 128, .external_lex_state = 2},
  [11] = {.lex_state = 128, .external_lex_state = 2},
  [12] = {.lex_state = 128, .external_lex_state = 2},
  [13] = {.lex_state = 128, .external_lex_state = 2},
  [14] = {.lex_state = 128, .external_lex_state = 2},
  [15] = {.lex_state = 128, .external_lex_state = 2},
  [16] = {.lex_state = 128, .external_lex_state = 2},
  [17] = {.lex_state = 128, .external_lex_state = 2},
  [18] = {.lex_state = 128, .external_lex_state = 2},
  [19] = {.lex_state = 128, .external_lex_state = 2},
  [20] = {.lex_state = 128, .external_lex_state = 2},
  [21] = {.lex_state = 128, .external_lex_state = 2},
  [22] = {.lex_state = 128, .external_lex_state = 2},
  [23] = {.lex_state = 128, .external_lex_state = 2},
  [24] = {.lex_state = 128, .external_lex_state = 2},
  [25] = {.lex_state = 128, .external_lex_state = 2},
  [26] = {.lex_state = 128, .external_lex_state = 2},
  [27] = {.lex_state = 128, .external_lex_state = 2},
  [28] = {.lex_state = 128, .external_lex_state = 2},
  [29] = {.lex_state = 128, .external_lex_state = 2},
  [30] = {.lex_state = 128, .external_lex_state = 2},
  [31] = {.lex_state = 128, .external_lex_state = 2},
  [32] = {.lex_state = 128, .external_lex_state = 2},
  [33] = {.lex_state = 128, .external_lex_state = 2},
  [34] = {.lex_state = 128, .external_lex_state = 2},
  [35] = {.lex_state = 8, .external_lex_state = 2},
  [36] = {.lex_state = 128, .external_lex_state = 2},
  [37] = {.lex_state = 128, .external_lex_state = 2},
  [38] = {.lex_state = 128, .external_lex_state = 2},
  [39] = {.lex_state = 128, .external_lex_state = 2},
  [40] = {.lex_state = 128, .external_lex_state = 2},
  [41] = {.lex_state = 128, .external_lex_state = 2},
  [42] = {.lex_state = 128, .external_lex_state = 2},
  [43] = {.lex_state = 128, .external_lex_state = 2},
  [44] = {.lex_state = 128, .external_lex_state = 2},
  [45] = {.lex_state = 128, .external_lex_state = 2},
  [46] = {.lex_state = 128, .external_lex_state = 2},
  [47] = {.lex_state = 128, .external_lex_state = 2},
  [48] = {.lex_state = 128, .external_lex_state = 2},
  [49] = {.lex_state = 128, .external_lex_state = 2},
  [50] = {.lex_state = 128, .external_lex_state = 2},
  [51] = {.lex_state = 128, .external_lex_state = 2},
  [52] = {.lex_state = 128, .external_lex_state = 2},
  [53] = {.lex_state = 8, .external_lex_state = 2},
  [54] = {.lex_state = 128, .external_lex_state = 2},
  [55] = {.lex_state = 128, .external_lex_state = 2},
  [56] = {.lex_state = 128, .external_lex_state = 2},
  [57] = {.lex_state = 128, .external_lex_state = 2},
  [58] = {.lex_state = 128, .external_lex_state = 2},
  [59] = {.lex_state = 128, .external_lex_state = 2},
  [60] = {.lex_state = 128, .external_lex_state = 2},
  [61] = {.lex_state = 128, .external_lex_state = 2},
  [62] = {.lex_state = 8, .external_lex_state = 2},
  [63] = {.lex_state = 128, .external_lex_state = 2},
  [64] = {.lex_state = 8, .external_lex_state = 2},
  [65] = {.lex_state = 128, .external_lex_state = 2},
  [66] = {.lex_state = 128, .external_lex_state = 2},
  [67] = {.lex_state = 128, .external_lex_state = 2},
  [68] = {.lex_state = 8, .external_lex_state = 2},
  [69] = {.lex_state = 8, .external_lex_state = 2},
  [70] = {.lex_state = 8, .external_lex_state = 2},
  [71] = {.lex_state = 8, .external_lex_state = 2},
  [72] = {.lex_state = 8, .external_lex_state = 2},
  [73] = {.lex_state = 128, .external_lex_state = 2},
  [74] = {.lex_state = 128, .external_lex_state = 2},
  [75] = {.lex_state = 128, .external_lex_state = 2},
  [76] = {.lex_state = 128, .external_lex_state = 2},
  [77] = {.lex_state = 128, .external_lex_state = 2},
  [78] = {.lex_state = 128, .external_lex_state = 2},
  [79] = {.lex_state = 128, .external_lex_state = 2},
  [80] = {.lex_state = 128, .external_lex_state = 2},
  [81] = {.lex_state = 128, .external_lex_state = 2},
  [82] = {.lex_state = 128, .external_lex_state = 2},
  [83] = {.lex_state = 128, .external_lex_state = 2},
  [84] = {.lex_state = 128, .external_lex_state = 2},
  [85] = {.lex_state = 128, .external_lex_state = 2},
  [86] = {.lex_state = 8, .external_lex_state = 2},
  [87] = {.lex_state = 3, .external_lex_state = 4},
  [88] = {.lex_state = 3, .external_lex_state = 4},
  [89] = {.lex_state = 3, .external_lex_state = 4},
  [90] = {.lex_state = 3, .external_lex_state = 3},
  [91] = {.lex_state = 8, .external_lex_state = 2},
  [92] = {.lex_state = 3, .external_lex_state = 3},
  [93] = {.lex_state = 3, .external_lex_state = 3},
  [94] = {.lex_state = 3, .external_lex_state = 3},
  [95] = {.lex_state = 8, .external_lex_state = 2},
  [96] = {.lex_state = 3, .external_lex_state = 3},
  [97] = {.lex_state = 3, .external_lex_state = 3},
  [98] = {.lex_state = 3, .external_lex_state = 3},
  [99] = {.lex_state = 8, .external_lex_state = 2},
  [100] = {.lex_state = 3, .external_lex_state = 3},
  [101] = {.lex_state = 8, .external_lex_state = 2},
  [102] = {.lex_state = 8, .external_lex_state = 2},
  [103] = {.lex_state = 3, .external_lex_state = 3},
  [104] = {.lex_state = 8, .external_lex_state = 2},
  [105] = {.lex_state = 8, .external_lex_state = 2},
  [106] = {.lex_state = 8, .external_lex_state = 2},
  [107] = {.lex_state = 3, .external_lex_state = 3},
  [108] = {.lex_state = 3, .external_lex_state = 3},
  [109] = {.lex_state = 3, .external_lex_state = 3},
  [110] = {.lex_state = 3, .external_lex_state = 3},
  [111] = {.lex_state = 3, .external_lex_state = 3},
  [112] = {.lex_state = 3, .external_lex_state = 3},
  [113] = {.lex_state = 3, .external_lex_state = 4},
  [114] = {.lex_state = 3, .external_lex_state = 4},
  [115] = {.lex_state = 3, .external_lex_state = 4},
  [116] = {.lex_state = 3, .external_lex_state = 4},
  [117] = {.lex_state = 3, .external_lex_state = 4},
  [118] = {.lex_state = 3, .external_lex_state = 4},
  [119] = {.lex_state = 3, .external_lex_state = 4},
  [120] = {.lex_state = 3, .external_lex_state = 4},
  [121] = {.lex_state = 3, .external_lex_state = 4},
  [122] = {.lex_state = 3, .external_lex_state = 3},
  [123] = {.lex_state = 3, .external_lex_state = 3},
  [124] = {.lex_state = 3, .external_lex_state = 3},
  [125] = {.lex_state = 3, .external_lex_state = 3},
  [126] = {.lex_state = 3, .external_lex_state = 3},
  [127] = {.lex_state = 3, .external_lex_state = 3},
  [128] = {.lex_state = 3, .external_lex_state = 4},
  [129] = {.lex_state = 3, .external_lex_state = 4},
  [130] = {.lex_state = 3, .external_lex_state = 3},
  [131] = {.lex_state = 3, .external_lex_state = 4},
  [132] = {.lex_state = 3, .external_lex_state = 3},
  [133] = {.lex_state = 3, .external_lex_state = 3},
  [134] = {.lex_state = 3, .external_lex_state = 3},
  [135] = {.lex_state = 3, .external_lex_state = 3},
  [136] = {.lex_state = 3, .external_lex_state = 3},
  [137] = {.lex_state = 3, .external_lex_state = 3},
  [138] = {.lex_state = 3, .external_lex_state = 3},
  [139] = {.lex_state = 3, .external_lex_state = 3},
  [140] = {.lex_state = 3, .external_lex_state = 3},
  [141] = {.lex_state = 3, .external_lex_state = 3},
  [142] = {.lex_state = 3, .external_lex_state = 3},
  [143] = {.lex_state = 3, .external_lex_state = 3},
  [144] = {.lex_state = 3, .external_lex_state = 3},
  [145] = {.lex_state = 3, .external_lex_state = 3},
  [146] = {.lex_state = 3, .external_lex_state = 3},
  [147] = {.lex_state = 3, .external_lex_state = 3},
  [148] = {.lex_state = 3, .external_lex_state = 3},
  [149] = {.lex_state = 3, .external_lex_state = 3},
  [150] = {.lex_state = 3, .external_lex_state = 3},
  [151] = {.lex_state = 3, .external_lex_state = 3},
  [152] = {.lex_state = 3, .external_lex_state = 3},
  [153] = {.lex_state = 3, .external_lex_state = 3},
  [154] = {.lex_state = 3, .external_lex_state = 3},
  [155] = {.lex_state = 3, .external_lex_state = 3},
  [156] = {.lex_state = 3, .external_lex_state = 3},
  [157] = {.lex_state = 3, .external_lex_state = 3},
  [158] = {.lex_state = 3, .external_lex_state = 3},
  [159] = {.lex_state = 8, .external_lex_state = 2},
  [160] = {.lex_state = 3, .external_lex_state = 3},
  [161] = {.lex_state = 8, .external_lex_state = 2},
  [162] = {.lex_state = 8, .external_lex_state = 2},
  [163] = {.lex_state = 8, .external_lex_state = 2},
  [164] = {.lex_state = 8, .external_lex_state = 2},
  [165] = {.lex_state = 8, .external_lex_state = 2},
  [166] = {.lex_state = 8, .external_lex_state = 2},
  [167] = {.lex_state = 8, .external_lex_state = 2},
  [168] = {.lex_state = 8, .external_lex_state = 2},
  [169] = {.lex_state = 8, .external_lex_state = 2},
  [170] = {.lex_state = 8, .external_lex_state = 2},
  [171] = {.lex_state = 8, .external_lex_state = 2},
  [172] = {.lex_state = 8, .external_lex_state = 2},
  [173] = {.lex_state = 127, .external_lex_state = 3},
  [174] = {.lex_state = 127, .external_lex_state = 4},
  [175] = {.lex_state = 127, .external_lex_state = 4},
  [176] = {.lex_state = 127, .external_lex_state = 4},
  [177] = {.lex_state = 127, .external_lex_state = 3},
  [178] = {.lex_state = 127, .external_lex_state = 3},
  [179] = {.lex_state = 127, .external_lex_state = 3},
  [180] = {.lex_state = 127, .external_lex_state = 3},
  [181] = {.lex_state = 127, .external_lex_state = 3},
  [182] = {.lex_state = 2, .external_lex_state = 3},
  [183] = {.lex_state = 2, .external_lex_state = 4},
  [184] = {.lex_state = 2, .external_lex_state = 4},
  [185] = {.lex_state = 2, .external_lex_state = 3},
  [186] = {.lex_state = 2, .external_lex_state = 3},
  [187] = {.lex_state = 128, .external_lex_state = 2},
  [188] = {.lex_state = 128, .external_lex_state = 2},
  [189] = {.lex_state = 128, .external_lex_state = 2},
  [190] = {.lex_state = 128, .external_lex_state = 2},
  [191] = {.lex_state = 128, .external_lex_state = 2},
  [192] = {.lex_state = 128, .external_lex_state = 2},
  [193] = {.lex_state = 128, .external_lex_state = 2},
  [194] = {.lex_state = 128, .external_lex_state = 2},
  [195] = {.lex_state = 2, .external_lex_state = 3},
  [196] = {.lex_state = 2, .external_lex_state = 3},
  [197] = {.lex_state = 2, .external_lex_state = 4},
  [198] = {.lex_state = 2, .external_lex_state = 3},
  [199] = {.lex_state = 2, .external_lex_state = 3},
  [200] = {.lex_state = 2, .external_lex_state = 3},
  [201] = {.lex_state = 2, .external_lex_state = 3},
  [202] = {.lex_state = 2, .external_lex_state = 3},
  [203] = {.lex_state = 2, .external_lex_state = 3},
  [204] = {.lex_state = 128, .external_lex_state = 2},
  [205] = {.lex_state = 128, .external_lex_state = 2},
  [206] = {.lex_state = 128, .external_lex_state = 2},
  [207] = {.lex_state = 128, .external_lex_state = 2},
  [208] = {.lex_state = 128, .external_lex_state = 2},
  [209] = {.lex_state = 128, .external_lex_state = 2},
  [210] = {.lex_state = 128, .external_lex_state = 2},
  [211] = {.lex_state = 128, .external_lex_state = 2},
  [212] = {.lex_state = 128, .external_lex_state = 2},
  [213] = {.lex_state = 128, .external_lex_state = 2},
  [214] = {.lex_state = 128, .external_lex_state = 2},
  [215] = {.lex_state = 128, .external_lex_state = 2},
  [216] = {.lex_state = 127, .external_lex_state = 4},
  [217] = {.lex_state = 127, .external_lex_state = 4},
  [218] = {.lex_state = 128, .external_lex_state = 2},
  [219] = {.lex_state = 127, .external_lex_state = 4},
  [220] = {.lex_state = 128, .external_lex_state = 2},
  [221] = {.lex_state = 128, .external_lex_state = 2},
  [222] = {.lex_state = 128, .external_lex_state = 2},
  [223] = {.lex_state = 127, .external_lex_state = 4},
  [224] = {.lex_state = 128, .external_lex_state = 2},
  [225] = {.lex_state = 128, .external_lex_state = 2},
  [226] = {.lex_state = 128, .external_lex_state = 2},
  [227] = {.lex_state = 128, .external_lex_state = 2},
  [228] = {.lex_state = 127, .external_lex_state = 4},
  [229] = {.lex_state = 127, .external_lex_state = 4},
  [230] = {.lex_state = 127, .external_lex_state = 4},
  [231] = {.lex_state = 127, .external_lex_state = 4},
  [232] = {.lex_state = 127, .external_lex_state = 4},
  [233] = {.lex_state = 127, .external_lex_state = 4},
  [234] = {.lex_state = 127, .external_lex_state = 4},
  [235] = {.lex_state = 127, .external_lex_state = 4},
  [236] = {.lex_state = 127, .external_lex_state = 4},
  [237] = {.lex_state = 127, .external_lex_state = 4},
  [238] = {.lex_state = 128, .external_lex_state = 2},
  [239] = {.lex_state = 127, .external_lex_state = 4},
  [240] = {.lex_state = 127, .external_lex_state = 4},
  [241] = {.lex_state = 127, .external_lex_state = 4},
  [242] = {.lex_state = 127, .external_lex_state = 4},
  [243] = {.lex_state = 127, .external_lex_state = 4},
  [244] = {.lex_state = 127, .external_lex_state = 4},
  [245] = {.lex_state = 127, .external_lex_state = 4},
  [246] = {.lex_state = 127, .external_lex_state = 4},
  [247] = {.lex_state = 127, .external_lex_state = 4},
  [248] = {.lex_state = 127, .external_lex_state = 4},
  [249] = {.lex_state = 127, .external_lex_state = 4},
  [250] = {.lex_state = 127, .external_lex_state = 4},
  [251] = {.lex_state = 127, .external_lex_state = 4},
  [252] = {.lex_state = 127, .external_lex_state = 4},
  [253] = {.lex_state = 127, .external_lex_state = 4},
  [254] = {.lex_state = 128, .external_lex_state = 5},
  [255] = {.lex_state = 128, .external_lex_state = 2},
  [256] = {.lex_state = 128, .external_lex_state = 2},
  [257] = {.lex_state = 128, .external_lex_state = 2},
  [258] = {.lex_state = 128, .external_lex_state = 2},
  [259] = {.lex_state = 128, .external_lex_state = 2},
  [260] = {.lex_state = 128, .external_lex_state = 2},
  [261] = {.lex_state = 128, .external_lex_state = 2},
  [262] = {.lex_state = 128, .external_lex_state = 2},
  [263] = {.lex_state = 128, .external_lex_state = 2},
  [264] = {.lex_state = 128, .external_lex_state = 2},
  [265] = {.lex_state = 128, .external_lex_state = 2},
  [266] = {.lex_state = 128, .external_lex_state = 2},
  [267] = {.lex_state = 128, .external_lex_state = 2},
  [268] = {.lex_state = 3, .external_lex_state = 3},
  [269] = {.lex_state = 3, .external_lex_state = 3},
  [270] = {.lex_state = 128, .external_lex_state = 2},
  [271] = {.lex_state = 128, .external_lex_state = 2},
  [272] = {.lex_state = 128, .external_lex_state = 2},
  [273] = {.lex_state = 128, .external_lex_state = 2},
  [274] = {.lex_state = 3, .external_lex_state = 3},
  [275] = {.lex_state = 128, .external_lex_state = 2},
  [276] = {.lex_state = 128, .external_lex_state = 2},
  [277] = {.lex_state = 128, .external_lex_state = 2},
  [278] = {.lex_state = 128, .external_lex_state = 2},
  [279] = {.lex_state = 128, .external_lex_state = 2},
  [280] = {.lex_state = 128, .external_lex_state = 2},
  [281] = {.lex_state = 128, .external_lex_state = 2},
  [282] = {.lex_state = 128, .external_lex_state = 2},
  [283] = {.lex_state = 128, .external_lex_state = 2},
  [284] = {.lex_state = 128, .external_lex_state = 2},
  [285] = {.lex_state = 3, .external_lex_state = 3},
  [286] = {.lex_state = 128, .external_lex_state = 2},
  [287] = {.lex_state = 128, .external_lex_state = 2},
  [288] = {.lex_state = 128, .external_lex_state = 2},
  [289] = {.lex_state = 128, .external_lex_state = 2},
  [290] = {.lex_state = 128, .external_lex_state = 2},
  [291] = {.lex_state = 128, .external_lex_state = 2},
  [292] = {.lex_state = 128, .external_lex_state = 2},
  [293] = {.lex_state = 128, .external_lex_state = 2},
  [294] = {.lex_state = 128, .external_lex_state = 2},
  [295] = {.lex_state = 128, .external_lex_state = 2},
  [296] = {.lex_state = 128, .external_lex_state = 2},
  [297] = {.lex_state = 128, .external_lex_state = 2},
  [298] = {.lex_state = 128, .external_lex_state = 2},
  [299] = {.lex_state = 128, .external_lex_state = 2},
  [300] = {.lex_state = 128, .external_lex_state = 2},
  [301] = {.lex_state = 128, .external_lex_state = 2},
  [302] = {.lex_state = 128, .external_lex_state = 2},
  [303] = {.lex_state = 128, .external_lex_state = 2},
  [304] = {.lex_state = 128, .external_lex_state = 2},
  [305] = {.lex_state = 128, .external_lex_state = 2},
  [306] = {.lex_state = 128, .external_lex_state = 2},
  [307] = {.lex_state = 128, .external_lex_state = 5},
  [308] = {.lex_state = 128, .external_lex_state = 2},
  [309] = {.lex_state = 128, .external_lex_state = 2},
  [310] = {.lex_state = 128, .external_lex_state = 2},
  [311] = {.lex_state = 128, .external_lex_state = 2},
  [312] = {.lex_state = 128, .external_lex_state = 2},
  [313] = {.lex_state = 128, .external_lex_state = 2},
  [314] = {.lex_state = 128, .external_lex_state = 2},
  [315] = {.lex_state = 128, .external_lex_state = 2},
  [316] = {.lex_state = 128, .external_lex_state = 2},
  [317] = {.lex_state = 128, .external_lex_state = 2},
  [318] = {.lex_state = 128, .external_lex_state = 2},
  [319] = {.lex_state = 128, .external_lex_state = 2},
  [320] = {.lex_state = 128, .external_lex_state = 2},
  [321] = {.lex_state = 128, .external_lex_state = 2},
  [322] = {.lex_state = 128, .external_lex_state = 2},
  [323] = {.lex_state = 128, .external_lex_state = 2},
  [324] = {.lex_state = 128, .external_lex_state = 2},
  [325] = {.lex_state = 128, .external_lex_state = 2},
  [326] = {.lex_state = 128, .external_lex_state = 2},
  [327] = {.lex_state = 128, .external_lex_state = 2},
  [328] = {.lex_state = 128, .external_lex_state = 2},
  [329] = {.lex_state = 128, .external_lex_state = 2},
  [330] = {.lex_state = 128, .external_lex_state = 2},
  [331] = {.lex_state = 128, .external_lex_state = 2},
  [332] = {.lex_state = 128, .external_lex_state = 2},
  [333] = {.lex_state = 128, .external_lex_state = 2},
  [334] = {.lex_state = 128, .external_lex_state = 2},
  [335] = {.lex_state = 128, .external_lex_state = 2},
  [336] = {.lex_state = 128, .external_lex_state = 2},
  [337] = {.lex_state = 128, .external_lex_state = 2},
  [338] = {.lex_state = 128, .external_lex_state = 2},
  [339] = {.lex_state = 128, .external_lex_state = 2},
  [340] = {.lex_state = 128, .external_lex_state = 2},
  [341] = {.lex_state = 128, .external_lex_state = 2},
  [342] = {.lex_state = 128, .external_lex_state = 2},
  [343] = {.lex_state = 128, .external_lex_state = 2},
  [344] = {.lex_state = 128, .external_lex_state = 2},
  [345] = {.lex_state = 128, .external_lex_state = 2},
  [346] = {.lex_state = 128, .external_lex_state = 2},
  [347] = {.lex_state = 128, .external_lex_state = 2},
  [348] = {.lex_state = 128, .external_lex_state = 2},
  [349] = {.lex_state = 128, .external_lex_state = 2},
  [350] = {.lex_state = 128, .external_lex_state = 2},
  [351] = {.lex_state = 128, .external_lex_state = 2},
  [352] = {.lex_state = 128, .external_lex_state = 2},
  [353] = {.lex_state = 128, .external_lex_state = 2},
  [354] = {.lex_state = 128, .external_lex_state = 2},
  [355] = {.lex_state = 128, .external_lex_state = 2},
  [356] = {.lex_state = 128, .external_lex_state = 2},
  [357] = {.lex_state = 128, .external_lex_state = 2},
  [358] = {.lex_state = 128, .external_lex_state = 2},
  [359] = {.lex_state = 128, .external_lex_state = 2},
  [360] = {.lex_state = 128, .external_lex_state = 2},
  [361] = {.lex_state = 128, .external_lex_state = 2},
  [362] = {.lex_state = 128, .external_lex_state = 2},
  [363] = {.lex_state = 128, .external_lex_state = 2},
  [364] = {.lex_state = 128, .external_lex_state = 2},
  [365] = {.lex_state = 128, .external_lex_state = 2},
  [366] = {.lex_state = 128, .external_lex_state = 2},
  [367] = {.lex_state = 128, .external_lex_state = 2},
  [368] = {.lex_state = 128, .external_lex_state = 2},
  [369] = {.lex_state = 128, .external_lex_state = 2},
  [370] = {.lex_state = 128, .external_lex_state = 2},
  [371] = {.lex_state = 128, .external_lex_state = 2},
  [372] = {.lex_state = 128, .external_lex_state = 2},
  [373] = {.lex_state = 128, .external_lex_state = 2},
  [374] = {.lex_state = 128, .external_lex_state = 2},
  [375] = {.lex_state = 128, .external_lex_state = 2},
  [376] = {.lex_state = 128, .external_lex_state = 2},
  [377] = {.lex_state = 128, .external_lex_state = 2},
  [378] = {.lex_state = 128, .external_lex_state = 2},
  [379] = {.lex_state = 128, .external_lex_state = 2},
  [380] = {.lex_state = 128, .external_lex_state = 2},
  [381] = {.lex_state = 128, .external_lex_state = 2},
  [382] = {.lex_state = 128, .external_lex_state = 2},
  [383] = {.lex_state = 128, .external_lex_state = 2},
  [384] = {.lex_state = 128, .external_lex_state = 2},
  [385] = {.lex_state = 128, .external_lex_state = 2},
  [386] = {.lex_state = 128, .external_lex_state = 2},
  [387] = {.lex_state = 128, .external_lex_state = 2},
  [388] = {.lex_state = 128, .external_lex_state = 2},
  [389] = {.lex_state = 128, .external_lex_state = 2},
  [390] = {.lex_state = 128, .external_lex_state = 2},
  [391] = {.lex_state = 128, .external_lex_state = 2},
  [392] = {.lex_state = 128, .external_lex_state = 2},
  [393] = {.lex_state = 128, .external_lex_state = 2},
  [394] = {.lex_state = 128, .external_lex_state = 2},
  [395] = {.lex_state = 128, .external_lex_state = 2},
  [396] = {.lex_state = 128, .external_lex_state = 2},
  [397] = {.lex_state = 128, .external_lex_state = 2},
  [398] = {.lex_state = 128, .external_lex_state = 2},
  [399] = {.lex_state = 128, .external_lex_state = 2},
  [400] = {.lex_state = 128, .external_lex_state = 2},
  [401] = {.lex_state = 128, .external_lex_state = 2},
  [402] = {.lex_state = 128, .external_lex_state = 2},
  [403] = {.lex_state = 128, .external_lex_state = 2},
  [404] = {.lex_state = 128, .external_lex_state = 2},
  [405] = {.lex_state = 128, .external_lex_state = 2},
  [406] = {.lex_state = 128, .external_lex_state = 2},
  [407] = {.lex_state = 128, .external_lex_state = 2},
  [408] = {.lex_state = 128, .external_lex_state = 2},
  [409] = {.lex_state = 128, .external_lex_state = 2},
  [410] = {.lex_state = 128, .external_lex_state = 2},
  [411] = {.lex_state = 128, .external_lex_state = 2},
  [412] = {.lex_state = 128, .external_lex_state = 2},
  [413] = {.lex_state = 128, .external_lex_state = 2},
  [414] = {.lex_state = 128, .external_lex_state = 2},
  [415] = {.lex_state = 128, .external_lex_state = 2},
  [416] = {.lex_state = 128, .external_lex_state = 2},
  [417] = {.lex_state = 128, .external_lex_state = 2},
  [418] = {.lex_state = 128, .external_lex_state = 2},
  [419] = {.lex_state = 128, .external_lex_state = 2},
  [420] = {.lex_state = 128, .external_lex_state = 2},
  [421] = {.lex_state = 128, .external_lex_state = 2},
  [422] = {.lex_state = 128, .external_lex_state = 2},
  [423] = {.lex_state = 128, .external_lex_state = 2},
  [424] = {.lex_state = 128, .external_lex_state = 2},
  [425] = {.lex_state = 128, .external_lex_state = 2},
  [426] = {.lex_state = 128, .external_lex_state = 2},
  [427] = {.lex_state = 128, .external_lex_state = 2},
  [428] = {.lex_state = 128, .external_lex_state = 2},
  [429] = {.lex_state = 128, .external_lex_state = 2},
  [430] = {.lex_state = 128, .external_lex_state = 2},
  [431] = {.lex_state = 128, .external_lex_state = 2},
  [432] = {.lex_state = 128, .external_lex_state = 2},
  [433] = {.lex_state = 128, .external_lex_state = 2},
  [434] = {.lex_state = 128, .external_lex_state = 2},
  [435] = {.lex_state = 128, .external_lex_state = 2},
  [436] = {.lex_state = 128, .external_lex_state = 2},
  [437] = {.lex_state = 128, .external_lex_state = 2},
  [438] = {.lex_state = 128, .external_lex_state = 2},
  [439] = {.lex_state = 128, .external_lex_state = 2},
  [440] = {.lex_state = 128, .external_lex_state = 2},
  [441] = {.lex_state = 128, .external_lex_state = 2},
  [442] = {.lex_state = 128, .external_lex_state = 2},
  [443] = {.lex_state = 128, .external_lex_state = 2},
  [444] = {.lex_state = 128, .external_lex_state = 2},
  [445] = {.lex_state = 128, .external_lex_state = 2},
  [446] = {.lex_state = 128, .external_lex_state = 2},
  [447] = {.lex_state = 128, .external_lex_state = 2},
  [448] = {.lex_state = 128, .external_lex_state = 2},
  [449] = {.lex_state = 128, .external_lex_state = 2},
  [450] = {.lex_state = 128, .external_lex_state = 2},
  [451] = {.lex_state = 128, .external_lex_state = 2},
  [452] = {.lex_state = 128, .external_lex_state = 2},
  [453] = {.lex_state = 128, .external_lex_state = 2},
  [454] = {.lex_state = 128, .external_lex_state = 2},
  [455] = {.lex_state = 128, .external_lex_state = 2},
  [456] = {.lex_state = 128, .external_lex_state = 2},
  [457] = {.lex_state = 128, .external_lex_state = 2},
  [458] = {.lex_state = 128, .external_lex_state = 2},
  [459] = {.lex_state = 128, .external_lex_state = 2},
  [460] = {.lex_state = 128, .external_lex_state = 2},
  [461] = {.lex_state = 128, .external_lex_state = 2},
  [462] = {.lex_state = 128, .external_lex_state = 2},
  [463] = {.lex_state = 128, .external_lex_state = 2},
  [464] = {.lex_state = 128, .external_lex_state = 2},
  [465] = {.lex_state = 128, .external_lex_state = 2},
  [466] = {.lex_state = 128, .external_lex_state = 2},
  [467] = {.lex_state = 128, .external_lex_state = 2},
  [468] = {.lex_state = 128, .external_lex_state = 2},
  [469] = {.lex_state = 128, .external_lex_state = 2},
  [470] = {.lex_state = 128, .external_lex_state = 2},
  [471] = {.lex_state = 128, .external_lex_state = 2},
  [472] = {.lex_state = 128, .external_lex_state = 2},
  [473] = {.lex_state = 128, .external_lex_state = 2},
  [474] = {.lex_state = 128, .external_lex_state = 2},
  [475] = {.lex_state = 128, .external_lex_state = 2},
  [476] = {.lex_state = 128, .external_lex_state = 2},
  [477] = {.lex_state = 128, .external_lex_state = 2},
  [478] = {.lex_state = 128, .external_lex_state = 2},
  [479] = {.lex_state = 128, .external_lex_state = 2},
  [480] = {.lex_state = 128, .external_lex_state = 2},
  [481] = {.lex_state = 128, .external_lex_state = 2},
  [482] = {.lex_state = 128, .external_lex_state = 2},
  [483] = {.lex_state = 128, .external_lex_state = 2},
  [484] = {.lex_state = 128, .external_lex_state = 2},
  [485] = {.lex_state = 128, .external_lex_state = 2},
  [486] = {.lex_state = 128, .external_lex_state = 2},
  [487] = {.lex_state = 128, .external_lex_state = 2},
  [488] = {.lex_state = 128, .external_lex_state = 2},
  [489] = {.lex_state = 128, .external_lex_state = 2},
  [490] = {.lex_state = 128, .external_lex_state = 2},
  [491] = {.lex_state = 128, .external_lex_state = 2},
  [492] = {.lex_state = 128, .external_lex_state = 2},
  [493] = {.lex_state = 128, .external_lex_state = 2},
  [494] = {.lex_state = 128, .external_lex_state = 2},
  [495] = {.lex_state = 128, .external_lex_state = 2},
  [496] = {.lex_state = 128, .external_lex_state = 2},
  [497] = {.lex_state = 128, .external_lex_state = 2},
  [498] = {.lex_state = 128, .external_lex_state = 2},
  [499] = {.lex_state = 128, .external_lex_state = 2},
  [500] = {.lex_state = 128, .external_lex_state = 2},
  [501] = {.lex_state = 128, .external_lex_state = 2},
  [502] = {.lex_state = 128, .external_lex_state = 2},
  [503] = {.lex_state = 128, .external_lex_state = 2},
  [504] = {.lex_state = 128, .external_lex_state = 2},
  [505] = {.lex_state = 128, .external_lex_state = 2},
  [506] = {.lex_state = 128, .external_lex_state = 2},
  [507] = {.lex_state = 128, .external_lex_state = 2},
  [508] = {.lex_state = 128, .external_lex_state = 2},
  [509] = {.lex_state = 128, .external_lex_state = 2},
  [510] = {.lex_state = 128, .external_lex_state = 2},
  [511] = {.lex_state = 128, .external_lex_state = 2},
  [512] = {.lex_state = 128, .external_lex_state = 2},
  [513] = {.lex_state = 128, .external_lex_state = 2},
  [514] = {.lex_state = 128, .external_lex_state = 2},
  [515] = {.lex_state = 128, .external_lex_state = 2},
  [516] = {.lex_state = 128, .external_lex_state = 2},
  [517] = {.lex_state = 128, .external_lex_state = 2},
  [518] = {.lex_state = 128, .external_lex_state = 2},
  [519] = {.lex_state = 128, .external_lex_state = 2},
  [520] = {.lex_state = 128, .external_lex_state = 2},
  [521] = {.lex_state = 128, .external_lex_state = 2},
  [522] = {.lex_state = 128, .external_lex_state = 2},
  [523] = {.lex_state = 128, .external_lex_state = 2},
  [524] = {.lex_state = 128, .external_lex_state = 2},
  [525] = {.lex_state = 128, .external_lex_state = 2},
  [526] = {.lex_state = 128, .external_lex_state = 2},
  [527] = {.lex_state = 128, .external_lex_state = 2},
  [528] = {.lex_state = 128, .external_lex_state = 2},
  [529] = {.lex_state = 128, .external_lex_state = 2},
  [530] = {.lex_state = 128, .external_lex_state = 2},
  [531] = {.lex_state = 128, .external_lex_state = 2},
  [532] = {.lex_state = 128, .external_lex_state = 2},
  [533] = {.lex_state = 128, .external_lex_state = 2},
  [534] = {.lex_state = 128, .external_lex_state = 2},
  [535] = {.lex_state = 128, .external_lex_state = 2},
  [536] = {.lex_state = 128, .external_lex_state = 2},
  [537] = {.lex_state = 128, .external_lex_state = 2},
  [538] = {.lex_state = 128, .external_lex_state = 2},
  [539] = {.lex_state = 128, .external_lex_state = 2},
  [540] = {.lex_state = 128, .external_lex_state = 2},
  [541] = {.lex_state = 128, .external_lex_state = 2},
  [542] = {.lex_state = 128, .external_lex_state = 2},
  [543] = {.lex_state = 128, .external_lex_state = 2},
  [544] = {.lex_state = 128, .external_lex_state = 2},
  [545] = {.lex_state = 128, .external_lex_state = 2},
  [546] = {.lex_state = 128, .external_lex_state = 2},
  [547] = {.lex_state = 128, .external_lex_state = 2},
  [548] = {.lex_state = 128, .external_lex_state = 2},
  [549] = {.lex_state = 128, .external_lex_state = 2},
  [550] = {.lex_state = 128, .external_lex_state = 2},
  [551] = {.lex_state = 128, .external_lex_state = 2},
  [552] = {.lex_state = 128, .external_lex_state = 2},
  [553] = {.lex_state = 128, .external_lex_state = 2},
  [554] = {.lex_state = 128, .external_lex_state = 2},
  [555] = {.lex_state = 128, .external_lex_state = 2},
  [556] = {.lex_state = 128, .external_lex_state = 2},
  [557] = {.lex_state = 128, .external_lex_state = 2},
  [558] = {.lex_state = 128, .external_lex_state = 2},
  [559] = {.lex_state = 128, .external_lex_state = 2},
  [560] = {.lex_state = 128, .external_lex_state = 2},
  [561] = {.lex_state = 128, .external_lex_state = 2},
  [562] = {.lex_state = 128, .external_lex_state = 2},
  [563] = {.lex_state = 128, .external_lex_state = 2},
  [564] = {.lex_state = 128, .external_lex_state = 2},
  [565] = {.lex_state = 128, .external_lex_state = 2},
  [566] = {.lex_state = 128, .external_lex_state = 2},
  [567] = {.lex_state = 128, .external_lex_state = 2},
  [568] = {.lex_state = 128, .external_lex_state = 2},
  [569] = {.lex_state = 128, .external_lex_state = 2},
  [570] = {.lex_state = 128, .external_lex_state = 2},
  [571] = {.lex_state = 128, .external_lex_state = 2},
  [572] = {.lex_state = 128, .external_lex_state = 2},
  [573] = {.lex_state = 128, .external_lex_state = 2},
  [574] = {.lex_state = 128, .external_lex_state = 2},
  [575] = {.lex_state = 128, .external_lex_state = 2},
  [576] = {.lex_state = 128, .external_lex_state = 2},
  [577] = {.lex_state = 128, .external_lex_state = 2},
  [578] = {.lex_state = 128, .external_lex_state = 2},
  [579] = {.lex_state = 128, .external_lex_state = 2},
  [580] = {.lex_state = 128, .external_lex_state = 2},
  [581] = {.lex_state = 128, .external_lex_state = 2},
  [582] = {.lex_state = 128, .external_lex_state = 2},
  [583] = {.lex_state = 128, .external_lex_state = 2},
  [584] = {.lex_state = 128, .external_lex_state = 2},
  [585] = {.lex_state = 128, .external_lex_state = 2},
  [586] = {.lex_state = 128, .external_lex_state = 2},
  [587] = {.lex_state = 128, .external_lex_state = 2},
  [588] = {.lex_state = 128, .external_lex_state = 2},
  [589] = {.lex_state = 128, .external_lex_state = 2},
  [590] = {.lex_state = 128, .external_lex_state = 2},
  [591] = {.lex_state = 128, .external_lex_state = 2},
  [592] = {.lex_state = 128, .external_lex_state = 2},
  [593] = {.lex_state = 128, .external_lex_state = 2},
  [594] = {.lex_state = 128, .external_lex_state = 2},
  [595] = {.lex_state = 128, .external_lex_state = 2},
  [596] = {.lex_state = 128, .external_lex_state = 2},
  [597] = {.lex_state = 128, .external_lex_state = 2},
  [598] = {.lex_state = 128, .external_lex_state = 2},
  [599] = {.lex_state = 128, .external_lex_state = 2},
  [600] = {.lex_state = 128, .external_lex_state = 2},
  [601] = {.lex_state = 128, .external_lex_state = 2},
  [602] = {.lex_state = 128, .external_lex_state = 2},
  [603] = {.lex_state = 128, .external_lex_state = 2},
  [604] = {.lex_state = 128, .external_lex_state = 2},
  [605] = {.lex_state = 128, .external_lex_state = 2},
  [606] = {.lex_state = 128, .external_lex_state = 2},
  [607] = {.lex_state = 128, .external_lex_state = 2},
  [608] = {.lex_state = 128, .external_lex_state = 2},
  [609] = {.lex_state = 128, .external_lex_state = 2},
  [610] = {.lex_state = 128, .external_lex_state = 2},
  [611] = {.lex_state = 128, .external_lex_state = 2},
  [612] = {.lex_state = 128, .external_lex_state = 2},
  [613] = {.lex_state = 128, .external_lex_state = 2},
  [614] = {.lex_state = 128, .external_lex_state = 2},
  [615] = {.lex_state = 128, .external_lex_state = 2},
  [616] = {.lex_state = 128, .external_lex_state = 2},
  [617] = {.lex_state = 128, .external_lex_state = 2},
  [618] = {.lex_state = 128, .external_lex_state = 2},
  [619] = {.lex_state = 128, .external_lex_state = 2},
  [620] = {.lex_state = 128, .external_lex_state = 2},
  [621] = {.lex_state = 128, .external_lex_state = 2},
  [622] = {.lex_state = 128, .external_lex_state = 2},
  [623] = {.lex_state = 128, .external_lex_state = 2},
  [624] = {.lex_state = 128, .external_lex_state = 2},
  [625] = {.lex_state = 128, .external_lex_state = 2},
  [626] = {.lex_state = 128, .external_lex_state = 2},
  [627] = {.lex_state = 128, .external_lex_state = 2},
  [628] = {.lex_state = 128, .external_lex_state = 2},
  [629] = {.lex_state = 128, .external_lex_state = 2},
  [630] = {.lex_state = 128, .external_lex_state = 2},
  [631] = {.lex_state = 128, .external_lex_state = 2},
  [632] = {.lex_state = 128, .external_lex_state = 2},
  [633] = {.lex_state = 128, .external_lex_state = 2},
  [634] = {.lex_state = 128, .external_lex_state = 2},
  [635] = {.lex_state = 128, .external_lex_state = 2},
  [636] = {.lex_state = 128, .external_lex_state = 2},
  [637] = {.lex_state = 128, .external_lex_state = 2},
  [638] = {.lex_state = 128, .external_lex_state = 2},
  [639] = {.lex_state = 128, .external_lex_state = 2},
  [640] = {.lex_state = 128, .external_lex_state = 2},
  [641] = {.lex_state = 128, .external_lex_state = 2},
  [642] = {.lex_state = 128, .external_lex_state = 2},
  [643] = {.lex_state = 128, .external_lex_state = 2},
  [644] = {.lex_state = 128, .external_lex_state = 2},
  [645] = {.lex_state = 128, .external_lex_state = 2},
  [646] = {.lex_state = 128, .external_lex_state = 2},
  [647] = {.lex_state = 128, .external_lex_state = 2},
  [648] = {.lex_state = 128, .external_lex_state = 2},
  [649] = {.lex_state = 128, .external_lex_state = 2},
  [650] = {.lex_state = 128, .external_lex_state = 2},
  [651] = {.lex_state = 128, .external_lex_state = 2},
  [652] = {.lex_state = 128, .external_lex_state = 2},
  [653] = {.lex_state = 128, .external_lex_state = 2},
  [654] = {.lex_state = 128, .external_lex_state = 2},
  [655] = {.lex_state = 128, .external_lex_state = 2},
  [656] = {.lex_state = 128, .external_lex_state = 2},
  [657] = {.lex_state = 128, .external_lex_state = 2},
  [658] = {.lex_state = 3, .external_lex_state = 4},
  [659] = {.lex_state = 3, .external_lex_state = 4},
  [660] = {.lex_state = 3, .external_lex_state = 4},
  [661] = {.lex_state = 2, .external_lex_state = 4},
  [662] = {.lex_state = 2, .external_lex_state = 4},
  [663] = {.lex_state = 2, .external_lex_state = 4},
  [664] = {.lex_state = 2, .external_lex_state = 4},
  [665] = {.lex_state = 2, .external_lex_state = 4},
  [666] = {.lex_state = 2, .external_lex_state = 4},
  [667] = {.lex_state = 3, .external_lex_state = 4},
  [668] = {.lex_state = 3, .external_lex_state = 4},
  [669] = {.lex_state = 3, .external_lex_state = 4},
  [670] = {.lex_state = 2, .external_lex_state = 4},
  [671] = {.lex_state = 2, .external_lex_state = 4},
  [672] = {.lex_state = 2, .external_lex_state = 4},
  [673] = {.lex_state = 2, .external_lex_state = 4},
  [674] = {.lex_state = 2, .external_lex_state = 4},
  [675] = {.lex_state = 2, .external_lex_state = 4},
  [676] = {.lex_state = 2, .external_lex_state = 4},
  [677] = {.lex_state = 2, .external_lex_state = 4},
  [678] = {.lex_state = 2, .external_lex_state = 4},
  [679] = {.lex_state = 2, .external_lex_state = 4},
  [680] = {.lex_state = 128, .external_lex_state = 2},
  [681] = {.lex_state = 128, .external_lex_state = 2},
  [682] = {.lex_state = 2, .external_lex_state = 4},
  [683] = {.lex_state = 2, .external_lex_state = 4},
  [684] = {.lex_state = 128, .external_lex_state = 2},
  [685] = {.lex_state = 128, .external_lex_state = 2},
  [686] = {.lex_state = 128, .external_lex_state = 2},
  [687] = {.lex_state = 128, .external_lex_state = 2},
  [688] = {.lex_state = 128, .external_lex_state = 2},
  [689] = {.lex_state = 2, .external_lex_state = 4},
  [690] = {.lex_state = 2, .external_lex_state = 4},
  [691] = {.lex_state = 2, .external_lex_state = 4},
  [692] = {.lex_state = 2, .external_lex_state = 4},
  [693] = {.lex_state = 2, .external_lex_state = 4},
  [694] = {.lex_state = 2, .external_lex_state = 4},
  [695] = {.lex_state = 2, .external_lex_state = 4},
  [696] = {.lex_state = 2, .external_lex_state = 4},
  [697] = {.lex_state = 2, .external_lex_state = 4},
  [698] = {.lex_state = 2, .external_lex_state = 3},
  [699] = {.lex_state = 2, .external_lex_state = 3},
  [700] = {.lex_state = 2, .external_lex_state = 3},
  [701] = {.lex_state = 2, .external_lex_state = 3},
  [702] = {.lex_state = 2, .external_lex_state = 3},
  [703] = {.lex_state = 2, .external_lex_state = 4},
  [704] = {.lex_state = 2, .external_lex_state = 4},
  [705] = {.lex_state = 2, .external_lex_state = 4},
  [706] = {.lex_state = 2, .external_lex_state = 4},
  [707] = {.lex_state = 2, .external_lex_state = 4},
  [708] = {.lex_state = 2, .external_lex_state = 4},
  [709] = {.lex_state = 2, .external_lex_state = 4},
  [710] = {.lex_state = 2, .external_lex_state = 3},
  [711] = {.lex_state = 3, .external_lex_state = 3},
  [712] = {.lex_state = 2, .external_lex_state = 3},
  [713] = {.lex_state = 2, .external_lex_state = 3},
  [714] = {.lex_state = 3, .external_lex_state = 3},
  [715] = {.lex_state = 128, .external_lex_state = 5},
  [716] = {.lex_state = 2, .external_lex_state = 3},
  [717] = {.lex_state = 2, .external_lex_state = 4},
  [718] = {.lex_state = 2, .external_lex_state = 3},
  [719] = {.lex_state = 2, .external_lex_state = 4},
  [720] = {.lex_state = 2, .external_lex_state = 3},
  [721] = {.lex_state = 2, .external_lex_state = 4},
  [722] = {.lex_state = 2, .external_lex_state = 4},
  [723] = {.lex_state = 2, .external_lex_state = 4},
  [724] = {.lex_state = 2, .external_lex_state = 3},
  [725] = {.lex_state = 128, .external_lex_state = 5},
  [726] = {.lex_state = 2, .external_lex_state = 3},
  [727] = {.lex_state = 128, .external_lex_state = 2},
  [728] = {.lex_state = 2, .external_lex_state = 3},
  [729] = {.lex_state = 128, .external_lex_state = 5},
  [730] = {.lex_state = 128, .external_lex_state = 2},
  [731] = {.lex_state = 128, .external_lex_state = 5},
  [732] = {.lex_state = 2, .external_lex_state = 3},
  [733] = {.lex_state = 2, .external_lex_state = 3},
  [734] = {.lex_state = 2, .external_lex_state = 3},
  [735] = {.lex_state = 128, .external_lex_state = 5},
  [736] = {.lex_state = 2, .external_lex_state = 3},
  [737] = {.lex_state = 128, .external_lex_state = 5},
  [738] = {.lex_state = 2, .external_lex_state = 3},
  [739] = {.lex_state = 128, .external_lex_state = 5},
  [740] = {.lex_state = 128, .external_lex_state = 5},
  [741] = {.lex_state = 128, .external_lex_state = 2},
  [742] = {.lex_state = 128, .external_lex_state = 2},
  [743] = {.lex_state = 2, .external_lex_state = 3},
  [744] = {.lex_state = 2, .external_lex_state = 3},
  [745] = {.lex_state = 2, .external_lex_state = 3},
  [746] = {.lex_state = 2, .external_lex_state = 3},
  [747] = {.lex_state = 2, .external_lex_state = 3},
  [748] = {.lex_state = 2, .external_lex_state = 3},
  [749] = {.lex_state = 2, .external_lex_state = 3},
  [750] = {.lex_state = 128, .external_lex_state = 2},
  [751] = {.lex_state = 128, .external_lex_state = 2},
  [752] = {.lex_state = 2, .external_lex_state = 3},
  [753] = {.lex_state = 2, .external_lex_state = 3},
  [754] = {.lex_state = 2, .external_lex_state = 3},
  [755] = {.lex_state = 128, .external_lex_state = 5},
  [756] = {.lex_state = 128, .external_lex_state = 5},
  [757] = {.lex_state = 128, .external_lex_state = 2},
  [758] = {.lex_state = 128, .external_lex_state = 5},
  [759] = {.lex_state = 128, .external_lex_state = 2},
  [760] = {.lex_state = 9, .external_lex_state = 2},
  [761] = {.lex_state = 9, .external_lex_state = 2},
  [762] = {.lex_state = 9, .external_lex_state = 2},
  [763] = {.lex_state = 9, .external_lex_state = 2},
  [764] = {.lex_state = 128, .external_lex_state = 5},
  [765] = {.lex_state = 128, .external_lex_state = 5},
  [766] = {.lex_state = 128, .external_lex_state = 5},
  [767] = {.lex_state = 128, .external_lex_state = 5},
  [768] = {.lex_state = 128, .external_lex_state = 2},
  [769] = {.lex_state = 128, .external_lex_state = 2},
  [770] = {.lex_state = 128, .external_lex_state = 5},
  [771] = {.lex_state = 128, .external_lex_state = 5},
  [772] = {.lex_state = 128, .external_lex_state = 5},
  [773] = {.lex_state = 128, .external_lex_state = 5},
  [774] = {.lex_state = 128, .external_lex_state = 5},
  [775] = {.lex_state = 128, .external_lex_state = 2},
  [776] = {.lex_state = 128, .external_lex_state = 5},
  [777] = {.lex_state = 128, .external_lex_state = 5},
  [778] = {.lex_state = 128, .external_lex_state = 2},
  [779] = {.lex_state = 128, .external_lex_state = 2},
  [780] = {.lex_state = 128, .external_lex_state = 5},
  [781] = {.lex_state = 128, .external_lex_state = 2},
  [782] = {.lex_state = 9, .external_lex_state = 2},
  [783] = {.lex_state = 128, .external_lex_state = 2},
  [784] = {.lex_state = 9, .external_lex_state = 2},
  [785] = {.lex_state = 128, .external_lex_state = 2},
  [786] = {.lex_state = 128, .external_lex_state = 2},
  [787] = {.lex_state = 128, .external_lex_state = 2},
  [788] = {.lex_state = 128, .external_lex_state = 2},
  [789] = {.lex_state = 128, .external_lex_state = 2},
  [790] = {.lex_state = 128, .external_lex_state = 2},
  [791] = {.lex_state = 128, .external_lex_state = 2},
  [792] = {.lex_state = 128, .external_lex_state = 2},
  [793] = {.lex_state = 128, .external_lex_state = 2},
  [794] = {.lex_state = 9, .external_lex_state = 2},
  [795] = {.lex_state = 9, .external_lex_state = 2},
  [796] = {.lex_state = 128, .external_lex_state = 2},
  [797] = {.lex_state = 128, .external_lex_state = 2},
  [798] = {.lex_state = 128, .external_lex_state = 2},
  [799] = {.lex_state = 128, .external_lex_state = 2},
  [800] = {.lex_state = 9, .external_lex_state = 2},
  [801] = {.lex_state = 9, .external_lex_state = 2},
  [802] = {.lex_state = 128, .external_lex_state = 2},
  [803] = {.lex_state = 128, .external_lex_state = 2},
  [804] = {.lex_state = 9, .external_lex_state = 2},
  [805] = {.lex_state = 9, .external_lex_state = 2},
  [806] = {.lex_state = 128, .external_lex_state = 2},
  [807] = {.lex_state = 128, .external_lex_state = 2},
  [808] = {.lex_state = 128, .external_lex_state = 2},
  [809] = {.lex_state = 128, .external_lex_state = 2},
  [810] = {.lex_state = 128, .external_lex_state = 2},
  [811] = {.lex_state = 128, .external_lex_state = 2},
  [812] = {.lex_state = 128, .external_lex_state = 2},
  [813] = {.lex_state = 128, .external_lex_state = 2},
  [814] = {.lex_state = 128, .external_lex_state = 2},
  [815] = {.lex_state = 128, .external_lex_state = 2},
  [816] = {.lex_state = 128, .external_lex_state = 2},
  [817] = {.lex_state = 128, .external_lex_state = 2},
  [818] = {.lex_state = 128, .external_lex_state = 2},
  [819] = {.lex_state = 128, .external_lex_state = 2},
  [820] = {.lex_state = 128, .external_lex_state = 2},
  [821] = {.lex_state = 128, .external_lex_state = 2},
  [822] = {.lex_state = 128, .external_lex_state = 2},
  [823] = {.lex_state = 128, .external_lex_state = 2},
  [824] = {.lex_state = 128, .external_lex_state = 2},
  [825] = {.lex_state = 128, .external_lex_state = 2},
  [826] = {.lex_state = 128, .external_lex_state = 2},
  [827] = {.lex_state = 128, .external_lex_state = 2},
  [828] = {.lex_state = 128, .external_lex_state = 2},
  [829] = {.lex_state = 128, .external_lex_state = 2},
  [830] = {.lex_state = 128, .external_lex_state = 2},
  [831] = {.lex_state = 128, .external_lex_state = 2},
  [832] = {.lex_state = 128, .external_lex_state = 2},
  [833] = {.lex_state = 128, .external_lex_state = 2},
  [834] = {.lex_state = 9, .external_lex_state = 2},
  [835] = {.lex_state = 128, .external_lex_state = 2},
  [836] = {.lex_state = 128, .external_lex_state = 2},
  [837] = {.lex_state = 128, .external_lex_state = 2},
  [838] = {.lex_state = 128, .external_lex_state = 2},
  [839] = {.lex_state = 128, .external_lex_state = 2},
  [840] = {.lex_state = 128, .external_lex_state = 2},
  [841] = {.lex_state = 128, .external_lex_state = 2},
  [842] = {.lex_state = 128, .external_lex_state = 2},
  [843] = {.lex_state = 128, .external_lex_state = 2},
  [844] = {.lex_state = 128, .external_lex_state = 2},
  [845] = {.lex_state = 128, .external_lex_state = 2},
  [846] = {.lex_state = 128, .external_lex_state = 2},
  [847] = {.lex_state = 128, .external_lex_state = 2},
  [848] = {.lex_state = 128, .external_lex_state = 2},
  [849] = {.lex_state = 128, .external_lex_state = 2},
  [850] = {.lex_state = 128, .external_lex_state = 2},
  [851] = {.lex_state = 128, .external_lex_state = 2},
  [852] = {.lex_state = 128, .external_lex_state = 2},
  [853] = {.lex_state = 128, .external_lex_state = 2},
  [854] = {.lex_state = 128, .external_lex_state = 2},
  [855] = {.lex_state = 128, .external_lex_state = 2},
  [856] = {.lex_state = 128, .external_lex_state = 2},
  [857] = {.lex_state = 128, .external_lex_state = 2},
  [858] = {.lex_state = 128, .external_lex_state = 2},
  [859] = {.lex_state = 128, .external_lex_state = 2},
  [860] = {.lex_state = 128, .external_lex_state = 2},
  [861] = {.lex_state = 128, .external_lex_state = 2},
  [862] = {.lex_state = 128, .external_lex_state = 2},
  [863] = {.lex_state = 128, .external_lex_state = 2},
  [864] = {.lex_state = 9, .external_lex_state = 2},
  [865] = {.lex_state = 128, .external_lex_state = 2},
  [866] = {.lex_state = 128, .external_lex_state = 2},
  [867] = {.lex_state = 128, .external_lex_state = 2},
  [868] = {.lex_state = 128, .external_lex_state = 2},
  [869] = {.lex_state = 128, .external_lex_state = 2},
  [870] = {.lex_state = 128, .external_lex_state = 2},
  [871] = {.lex_state = 128, .external_lex_state = 2},
  [872] = {.lex_state = 128, .external_lex_state = 2},
  [873] = {.lex_state = 128, .external_lex_state = 2},
  [874] = {.lex_state = 128, .external_lex_state = 2},
  [875] = {.lex_state = 128, .external_lex_state = 2},
  [876] = {.lex_state = 128, .external_lex_state = 2},
  [877] = {.lex_state = 128, .external_lex_state = 2},
  [878] = {.lex_state = 128, .external_lex_state = 2},
  [879] = {.lex_state = 128, .external_lex_state = 2},
  [880] = {.lex_state = 128, .external_lex_state = 2},
  [881] = {.lex_state = 128, .external_lex_state = 2},
  [882] = {.lex_state = 128, .external_lex_state = 2},
  [883] = {.lex_state = 128, .external_lex_state = 2},
  [884] = {.lex_state = 128, .external_lex_state = 2},
  [885] = {.lex_state = 128, .external_lex_state = 2},
  [886] = {.lex_state = 128, .external_lex_state = 2},
  [887] = {.lex_state = 128, .external_lex_state = 2},
  [888] = {.lex_state = 128, .external_lex_state = 2},
  [889] = {.lex_state = 128, .external_lex_state = 2},
  [890] = {.lex_state = 128, .external_lex_state = 2},
  [891] = {.lex_state = 128, .external_lex_state = 2},
  [892] = {.lex_state = 128, .external_lex_state = 2},
  [893] = {.lex_state = 128, .external_lex_state = 2},
  [894] = {.lex_state = 128, .external_lex_state = 2},
  [895] = {.lex_state = 128, .external_lex_state = 2},
  [896] = {.lex_state = 128, .external_lex_state = 2},
  [897] = {.lex_state = 128, .external_lex_state = 2},
  [898] = {.lex_state = 128, .external_lex_state = 2},
  [899] = {.lex_state = 128, .external_lex_state = 2},
  [900] = {.lex_state = 128, .external_lex_state = 2},
  [901] = {.lex_state = 128, .external_lex_state = 2},
  [902] = {.lex_state = 128, .external_lex_state = 2},
  [903] = {.lex_state = 128, .external_lex_state = 2},
  [904] = {.lex_state = 128, .external_lex_state = 2},
  [905] = {.lex_state = 128, .external_lex_state = 2},
  [906] = {.lex_state = 9, .external_lex_state = 2},
  [907] = {.lex_state = 128, .external_lex_state = 2},
  [908] = {.lex_state = 128, .external_lex_state = 2},
  [909] = {.lex_state = 128, .external_lex_state = 2},
  [910] = {.lex_state = 128, .external_lex_state = 2},
  [911] = {.lex_state = 128, .external_lex_state = 2},
  [912] = {.lex_state = 128, .external_lex_state = 2},
  [913] = {.lex_state = 128, .external_lex_state = 2},
  [914] = {.lex_state = 128, .external_lex_state = 2},
  [915] = {.lex_state = 128, .external_lex_state = 2},
  [916] = {.lex_state = 9, .external_lex_state = 2},
  [917] = {.lex_state = 128, .external_lex_state = 2},
  [918] = {.lex_state = 9, .external_lex_state = 2},
  [919] = {.lex_state = 9, .external_lex_state = 2},
  [920] = {.lex_state = 128, .external_lex_state = 2},
  [921] = {.lex_state = 9, .external_lex_state = 2},
  [922] = {.lex_state = 9, .external_lex_state = 2},
  [923] = {.lex_state = 9, .external_lex_state = 2},
  [924] = {.lex_state = 128, .external_lex_state = 2},
  [925] = {.lex_state = 128, .external_lex_state = 2},
  [926] = {.lex_state = 128, .external_lex_state = 2},
  [927] = {.lex_state = 9, .external_lex_state = 2},
  [928] = {.lex_state = 128, .external_lex_state = 2},
  [929] = {.lex_state = 128, .external_lex_state = 2},
  [930] = {.lex_state = 128, .external_lex_state = 2},
  [931] = {.lex_state = 128, .external_lex_state = 2},
  [932] = {.lex_state = 9, .external_lex_state = 2},
  [933] = {.lex_state = 128, .external_lex_state = 2},
  [934] = {.lex_state = 128, .external_lex_state = 2},
  [935] = {.lex_state = 9, .external_lex_state = 2},
  [936] = {.lex_state = 128, .external_lex_state = 2},
  [937] = {.lex_state = 9, .external_lex_state = 2},
  [938] = {.lex_state = 9, .external_lex_state = 2},
  [939] = {.lex_state = 9, .external_lex_state = 2},
  [940] = {.lex_state = 9, .external_lex_state = 2},
  [941] = {.lex_state = 9, .external_lex_state = 2},
  [942] = {.lex_state = 9, .external_lex_state = 2},
  [943] = {.lex_state = 9, .external_lex_state = 2},
  [944] = {.lex_state = 128, .external_lex_state = 2},
  [945] = {.lex_state = 9, .external_lex_state = 2},
  [946] = {.lex_state = 128, .external_lex_state = 2},
  [947] = {.lex_state = 9, .external_lex_state = 2},
  [948] = {.lex_state = 7, .external_lex_state = 2},
  [949] = {.lex_state = 9, .external_lex_state = 2},
  [950] = {.lex_state = 9, .external_lex_state = 2},
  [951] = {.lex_state = 9, .external_lex_state = 2},
  [952] = {.lex_state = 9, .external_lex_state = 2},
  [953] = {.lex_state = 9, .external_lex_state = 2},
  [954] = {.lex_state = 9, .external_lex_state = 2},
  [955] = {.lex_state = 9, .external_lex_state = 2},
  [956] = {.lex_state = 9, .external_lex_state = 2},
  [957] = {.lex_state = 7, .external_lex_state = 2},
  [958] = {.lex_state = 7, .external_lex_state = 2},
  [959] = {.lex_state = 9, .external_lex_state = 2},
  [960] = {.lex_state = 11, .external_lex_state = 2},
  [961] = {.lex_state = 9, .external_lex_state = 2},
  [962] = {.lex_state = 9, .external_lex_state = 2},
  [963] = {.lex_state = 9, .external_lex_state = 2},
  [964] = {.lex_state = 9, .external_lex_state = 2},
  [965] = {.lex_state = 9, .external_lex_state = 2},
  [966] = {.lex_state = 9, .external_lex_state = 2},
  [967] = {.lex_state = 9, .external_lex_state = 2},
  [968] = {.lex_state = 9, .external_lex_state = 2},
  [969] = {.lex_state = 9, .external_lex_state = 2},
  [970] = {.lex_state = 9, .external_lex_state = 2},
  [971] = {.lex_state = 9, .external_lex_state = 2},
  [972] = {.lex_state = 9, .external_lex_state = 2},
  [973] = {.lex_state = 9, .external_lex_state = 2},
  [974] = {.lex_state = 9, .external_lex_state = 2},
  [975] = {.lex_state = 9, .external_lex_state = 2},
  [976] = {.lex_state = 9, .external_lex_state = 2},
  [977] = {.lex_state = 9, .external_lex_state = 2},
  [978] = {.lex_state = 9, .external_lex_state = 2},
  [979] = {.lex_state = 9, .external_lex_state = 2},
  [980] = {.lex_state = 9, .external_lex_state = 2},
  [981] = {.lex_state = 9, .external_lex_state = 2},
  [982] = {.lex_state = 9, .external_lex_state = 2},
  [983] = {.lex_state = 9, .external_lex_state = 2},
  [984] = {.lex_state = 9, .external_lex_state = 2},
  [985] = {.lex_state = 9, .external_lex_state = 2},
  [986] = {.lex_state = 9, .external_lex_state = 2},
  [987] = {.lex_state = 9, .external_lex_state = 2},
  [988] = {.lex_state = 9, .external_lex_state = 2},
  [989] = {.lex_state = 9, .external_lex_state = 2},
  [990] = {.lex_state = 9, .external_lex_state = 2},
  [991] = {.lex_state = 9, .external_lex_state = 2},
  [992] = {.lex_state = 9, .external_lex_state = 2},
  [993] = {.lex_state = 9, .external_lex_state = 2},
  [994] = {.lex_state = 9, .external_lex_state = 2},
  [995] = {.lex_state = 9, .external_lex_state = 2},
  [996] = {.lex_state = 9, .external_lex_state = 2},
  [997] = {.lex_state = 9, .external_lex_state = 2},
  [998] = {.lex_state = 9, .external_lex_state = 2},
  [999] = {.lex_state = 9, .external_lex_state = 2},
  [1000] = {.lex_state = 9, .external_lex_state = 2},
  [1001] = {.lex_state = 9, .external_lex_state = 2},
  [1002] = {.lex_state = 9, .external_lex_state = 2},
  [1003] = {.lex_state = 9, .external_lex_state = 2},
  [1004] = {.lex_state = 9, .external_lex_state = 2},
  [1005] = {.lex_state = 9, .external_lex_state = 2},
  [1006] = {.lex_state = 9, .external_lex_state = 2},
  [1007] = {.lex_state = 9, .external_lex_state = 2},
  [1008] = {.lex_state = 9, .external_lex_state = 2},
  [1009] = {.lex_state = 9, .external_lex_state = 2},
  [1010] = {.lex_state = 9, .external_lex_state = 2},
  [1011] = {.lex_state = 9, .external_lex_state = 2},
  [1012] = {.lex_state = 9, .external_lex_state = 2},
  [1013] = {.lex_state = 9, .external_lex_state = 2},
  [1014] = {.lex_state = 9, .external_lex_state = 2},
  [1015] = {.lex_state = 9, .external_lex_state = 2},
  [1016] = {.lex_state = 9, .external_lex_state = 2},
  [1017] = {.lex_state = 9, .external_lex_state = 2},
  [1018] = {.lex_state = 9, .external_lex_state = 2},
  [1019] = {.lex_state = 9, .external_lex_state = 2},
  [1020] = {.lex_state = 9, .external_lex_state = 2},
  [1021] = {.lex_state = 9, .external_lex_state = 2},
  [1022] = {.lex_state = 9, .external_lex_state = 2},
  [1023] = {.lex_state = 9, .external_lex_state = 2},
  [1024] = {.lex_state = 9, .external_lex_state = 2},
  [1025] = {.lex_state = 9, .external_lex_state = 2},
  [1026] = {.lex_state = 9, .external_lex_state = 2},
  [1027] = {.lex_state = 9, .external_lex_state = 2},
  [1028] = {.lex_state = 9, .external_lex_state = 2},
  [1029] = {.lex_state = 9, .external_lex_state = 2},
  [1030] = {.lex_state = 9, .external_lex_state = 2},
  [1031] = {.lex_state = 9, .external_lex_state = 2},
  [1032] = {.lex_state = 9, .external_lex_state = 2},
  [1033] = {.lex_state = 9, .external_lex_state = 2},
  [1034] = {.lex_state = 9, .external_lex_state = 2},
  [1035] = {.lex_state = 9, .external_lex_state = 2},
  [1036] = {.lex_state = 9, .external_lex_state = 2},
  [1037] = {.lex_state = 9, .external_lex_state = 2},
  [1038] = {.lex_state = 9, .external_lex_state = 2},
  [1039] = {.lex_state = 9, .external_lex_state = 2},
  [1040] = {.lex_state = 9, .external_lex_state = 2},
  [1041] = {.lex_state = 9, .external_lex_state = 2},
  [1042] = {.lex_state = 9, .external_lex_state = 2},
  [1043] = {.lex_state = 9, .external_lex_state = 2},
  [1044] = {.lex_state = 9, .external_lex_state = 2},
  [1045] = {.lex_state = 9, .external_lex_state = 2},
  [1046] = {.lex_state = 9, .external_lex_state = 2},
  [1047] = {.lex_state = 9, .external_lex_state = 2},
  [1048] = {.lex_state = 9, .external_lex_state = 2},
  [1049] = {.lex_state = 9, .external_lex_state = 2},
  [1050] = {.lex_state = 9, .external_lex_state = 2},
  [1051] = {.lex_state = 9, .external_lex_state = 2},
  [1052] = {.lex_state = 9, .external_lex_state = 2},
  [1053] = {.lex_state = 9, .external_lex_state = 2},
  [1054] = {.lex_state = 9, .external_lex_state = 2},
  [1055] = {.lex_state = 9, .external_lex_state = 2},
  [1056] = {.lex_state = 9, .external_lex_state = 2},
  [1057] = {.lex_state = 9, .external_lex_state = 2},
  [1058] = {.lex_state = 9, .external_lex_state = 2},
  [1059] = {.lex_state = 9, .external_lex_state = 2},
  [1060] = {.lex_state = 9, .external_lex_state = 2},
  [1061] = {.lex_state = 9, .external_lex_state = 2},
  [1062] = {.lex_state = 9, .external_lex_state = 2},
  [1063] = {.lex_state = 9, .external_lex_state = 2},
  [1064] = {.lex_state = 9, .external_lex_state = 2},
  [1065] = {.lex_state = 9, .external_lex_state = 2},
  [1066] = {.lex_state = 9, .external_lex_state = 2},
  [1067] = {.lex_state = 9, .external_lex_state = 2},
  [1068] = {.lex_state = 9, .external_lex_state = 2},
  [1069] = {.lex_state = 9, .external_lex_state = 2},
  [1070] = {.lex_state = 9, .external_lex_state = 2},
  [1071] = {.lex_state = 9, .external_lex_state = 2},
  [1072] = {.lex_state = 9, .external_lex_state = 2},
  [1073] = {.lex_state = 9, .external_lex_state = 2},
  [1074] = {.lex_state = 9, .external_lex_state = 2},
  [1075] = {.lex_state = 9, .external_lex_state = 2},
  [1076] = {.lex_state = 9, .external_lex_state = 2},
  [1077] = {.lex_state = 9, .external_lex_state = 2},
  [1078] = {.lex_state = 9, .external_lex_state = 2},
  [1079] = {.lex_state = 9, .external_lex_state = 2},
  [1080] = {.lex_state = 9, .external_lex_state = 2},
  [1081] = {.lex_state = 9, .external_lex_state = 2},
  [1082] = {.lex_state = 9, .external_lex_state = 2},
  [1083] = {.lex_state = 9, .external_lex_state = 2},
  [1084] = {.lex_state = 9, .external_lex_state = 2},
  [1085] = {.lex_state = 9, .external_lex_state = 2},
  [1086] = {.lex_state = 9, .external_lex_state = 2},
  [1087] = {.lex_state = 9, .external_lex_state = 2},
  [1088] = {.lex_state = 9, .external_lex_state = 2},
  [1089] = {.lex_state = 9, .external_lex_state = 2},
  [1090] = {.lex_state = 9, .external_lex_state = 2},
  [1091] = {.lex_state = 9, .external_lex_state = 2},
  [1092] = {.lex_state = 9, .external_lex_state = 2},
  [1093] = {.lex_state = 9, .external_lex_state = 2},
  [1094] = {.lex_state = 9, .external_lex_state = 2},
  [1095] = {.lex_state = 9, .external_lex_state = 2},
  [1096] = {.lex_state = 9, .external_lex_state = 2},
  [1097] = {.lex_state = 9, .external_lex_state = 2},
  [1098] = {.lex_state = 9, .external_lex_state = 2},
  [1099] = {.lex_state = 9, .external_lex_state = 2},
  [1100] = {.lex_state = 9, .external_lex_state = 2},
  [1101] = {.lex_state = 9, .external_lex_state = 2},
  [1102] = {.lex_state = 9, .external_lex_state = 2},
  [1103] = {.lex_state = 9, .external_lex_state = 2},
  [1104] = {.lex_state = 9, .external_lex_state = 2},
  [1105] = {.lex_state = 9, .external_lex_state = 2},
  [1106] = {.lex_state = 9, .external_lex_state = 2},
  [1107] = {.lex_state = 9, .external_lex_state = 2},
  [1108] = {.lex_state = 9, .external_lex_state = 2},
  [1109] = {.lex_state = 9, .external_lex_state = 2},
  [1110] = {.lex_state = 9, .external_lex_state = 2},
  [1111] = {.lex_state = 9, .external_lex_state = 2},
  [1112] = {.lex_state = 9, .external_lex_state = 2},
  [1113] = {.lex_state = 9, .external_lex_state = 2},
  [1114] = {.lex_state = 9, .external_lex_state = 2},
  [1115] = {.lex_state = 9, .external_lex_state = 2},
  [1116] = {.lex_state = 9, .external_lex_state = 2},
  [1117] = {.lex_state = 9, .external_lex_state = 2},
  [1118] = {.lex_state = 9, .external_lex_state = 2},
  [1119] = {.lex_state = 9, .external_lex_state = 2},
  [1120] = {.lex_state = 9, .external_lex_state = 2},
  [1121] = {.lex_state = 9, .external_lex_state = 2},
  [1122] = {.lex_state = 9, .external_lex_state = 2},
  [1123] = {.lex_state = 9, .external_lex_state = 2},
  [1124] = {.lex_state = 9, .external_lex_state = 2},
  [1125] = {.lex_state = 10, .external_lex_state = 2},
  [1126] = {.lex_state = 10, .external_lex_state = 2},
  [1127] = {.lex_state = 10, .external_lex_state = 2},
  [1128] = {.lex_state = 10, .external_lex_state = 2},
  [1129] = {.lex_state = 10, .external_lex_state = 2},
  [1130] = {.lex_state = 10, .external_lex_state = 2},
  [1131] = {.lex_state = 10, .external_lex_state = 2},
  [1132] = {.lex_state = 10, .external_lex_state = 2},
  [1133] = {.lex_state = 10, .external_lex_state = 2},
  [1134] = {.lex_state = 10, .external_lex_state = 2},
  [1135] = {.lex_state = 10, .external_lex_state = 2},
  [1136] = {.lex_state = 10, .external_lex_state = 2},
  [1137] = {.lex_state = 2, .external_lex_state = 4},
  [1138] = {.lex_state = 2, .external_lex_state = 4},
  [1139] = {.lex_state = 2, .external_lex_state = 4},
  [1140] = {.lex_state = 3, .external_lex_state = 4},
  [1141] = {.lex_state = 3, .external_lex_state = 4},
  [1142] = {.lex_state = 2, .external_lex_state = 4},
  [1143] = {.lex_state = 3, .external_lex_state = 4},
  [1144] = {.lex_state = 2, .external_lex_state = 4},
  [1145] = {.lex_state = 2, .external_lex_state = 4},
  [1146] = {.lex_state = 2, .external_lex_state = 3},
  [1147] = {.lex_state = 2, .external_lex_state = 3},
  [1148] = {.lex_state = 2, .external_lex_state = 3},
  [1149] = {.lex_state = 2, .external_lex_state = 3},
  [1150] = {.lex_state = 2, .external_lex_state = 3},
  [1151] = {.lex_state = 10, .external_lex_state = 2},
  [1152] = {.lex_state = 10, .external_lex_state = 2},
  [1153] = {.lex_state = 2, .external_lex_state = 4},
  [1154] = {.lex_state = 3, .external_lex_state = 4},
  [1155] = {.lex_state = 2, .external_lex_state = 4},
  [1156] = {.lex_state = 2, .external_lex_state = 3},
  [1157] = {.lex_state = 2, .external_lex_state = 4},
  [1158] = {.lex_state = 2, .external_lex_state = 4},
  [1159] = {.lex_state = 2, .external_lex_state = 4},
  [1160] = {.lex_state = 2, .external_lex_state = 4},
  [1161] = {.lex_state = 2, .external_lex_state = 4},
  [1162] = {.lex_state = 2, .external_lex_state = 4},
  [1163] = {.lex_state = 2, .external_lex_state = 4},
  [1164] = {.lex_state = 3, .external_lex_state = 4},
  [1165] = {.lex_state = 3, .external_lex_state = 4},
  [1166] = {.lex_state = 2, .external_lex_state = 4},
  [1167] = {.lex_state = 2, .external_lex_state = 4},
  [1168] = {.lex_state = 2, .external_lex_state = 3},
  [1169] = {.lex_state = 3, .external_lex_state = 3},
  [1170] = {.lex_state = 2, .external_lex_state = 4},
  [1171] = {.lex_state = 3, .external_lex_state = 3},
  [1172] = {.lex_state = 3, .external_lex_state = 3},
  [1173] = {.lex_state = 3, .external_lex_state = 3},
  [1174] = {.lex_state = 3, .external_lex_state = 3},
  [1175] = {.lex_state = 2, .external_lex_state = 3},
  [1176] = {.lex_state = 2, .external_lex_state = 4},
  [1177] = {.lex_state = 3, .external_lex_state = 3},
  [1178] = {.lex_state = 3, .external_lex_state = 3},
  [1179] = {.lex_state = 3, .external_lex_state = 3},
  [1180] = {.lex_state = 3, .external_lex_state = 3},
  [1181] = {.lex_state = 3, .external_lex_state = 3},
  [1182] = {.lex_state = 2, .external_lex_state = 3},
  [1183] = {.lex_state = 3, .external_lex_state = 3},
  [1184] = {.lex_state = 3, .external_lex_state = 3},
  [1185] = {.lex_state = 3, .external_lex_state = 3},
  [1186] = {.lex_state = 2, .external_lex_state = 3},
  [1187] = {.lex_state = 2, .external_lex_state = 4},
  [1188] = {.lex_state = 2, .external_lex_state = 4},
  [1189] = {.lex_state = 3, .external_lex_state = 4},
  [1190] = {.lex_state = 2, .external_lex_state = 4},
  [1191] = {.lex_state = 2, .external_lex_state = 4},
  [1192] = {.lex_state = 2, .external_lex_state = 4},
  [1193] = {.lex_state = 2, .external_lex_state = 4},
  [1194] = {.lex_state = 3, .external_lex_state = 4},
  [1195] = {.lex_state = 3, .external_lex_state = 3},
  [1196] = {.lex_state = 2, .external_lex_state = 4},
  [1197] = {.lex_state = 2, .external_lex_state = 4},
  [1198] = {.lex_state = 2, .external_lex_state = 3},
  [1199] = {.lex_state = 2, .external_lex_state = 4},
  [1200] = {.lex_state = 2, .external_lex_state = 4},
  [1201] = {.lex_state = 2, .external_lex_state = 3},
  [1202] = {.lex_state = 2, .external_lex_state = 3},
  [1203] = {.lex_state = 2, .external_lex_state = 4},
  [1204] = {.lex_state = 2, .external_lex_state = 3},
  [1205] = {.lex_state = 2, .external_lex_state = 4},
  [1206] = {.lex_state = 2, .external_lex_state = 4},
  [1207] = {.lex_state = 2, .external_lex_state = 3},
  [1208] = {.lex_state = 3, .external_lex_state = 3},
  [1209] = {.lex_state = 2, .external_lex_state = 3},
  [1210] = {.lex_state = 2, .external_lex_state = 3},
  [1211] = {.lex_state = 2, .external_lex_state = 3},
  [1212] = {.lex_state = 2, .external_lex_state = 3},
  [1213] = {.lex_state = 2, .external_lex_state = 4},
  [1214] = {.lex_state = 2, .external_lex_state = 3},
  [1215] = {.lex_state = 2, .external_lex_state = 4},
  [1216] = {.lex_state = 2, .external_lex_state = 3},
  [1217] = {.lex_state = 128, .external_lex_state = 2},
  [1218] = {.lex_state = 2, .external_lex_state = 3},
  [1219] = {.lex_state = 2, .external_lex_state = 4},
  [1220] = {.lex_state = 2, .external_lex_state = 3},
  [1221] = {.lex_state = 2, .external_lex_state = 3},
  [1222] = {.lex_state = 2, .external_lex_state = 3},
  [1223] = {.lex_state = 2, .external_lex_state = 3},
  [1224] = {.lex_state = 2, .external_lex_state = 3},
  [1225] = {.lex_state = 2, .external_lex_state = 3},
  [1226] = {.lex_state = 2, .external_lex_state = 3},
  [1227] = {.lex_state = 2, .external_lex_state = 3},
  [1228] = {.lex_state = 2, .external_lex_state = 3},
  [1229] = {.lex_state = 2, .external_lex_state = 3},
  [1230] = {.lex_state = 3, .external_lex_state = 3},
  [1231] = {.lex_state = 2, .external_lex_state = 3},
  [1232] = {.lex_state = 2, .external_lex_state = 4},
  [1233] = {.lex_state = 2, .external_lex_state = 3},
  [1234] = {.lex_state = 2, .external_lex_state = 3},
  [1235] = {.lex_state = 2, .external_lex_state = 3},
  [1236] = {.lex_state = 2, .external_lex_state = 3},
  [1237] = {.lex_state = 2, .external_lex_state = 3},
  [1238] = {.lex_state = 2, .external_lex_state = 4},
  [1239] = {.lex_state = 3, .external_lex_state = 3},
  [1240] = {.lex_state = 2, .external_lex_state = 3},
  [1241] = {.lex_state = 2, .external_lex_state = 3},
  [1242] = {.lex_state = 2, .external_lex_state = 3},
  [1243] = {.lex_state = 2, .external_lex_state = 4},
  [1244] = {.lex_state = 2, .external_lex_state = 3},
  [1245] = {.lex_state = 2, .external_lex_state = 3},
  [1246] = {.lex_state = 2, .external_lex_state = 3},
  [1247] = {.lex_state = 128, .external_lex_state = 2},
  [1248] = {.lex_state = 2, .external_lex_state = 3},
  [1249] = {.lex_state = 2, .external_lex_state = 3},
  [1250] = {.lex_state = 2, .external_lex_state = 3},
  [1251] = {.lex_state = 2, .external_lex_state = 3},
  [1252] = {.lex_state = 2, .external_lex_state = 4},
  [1253] = {.lex_state = 128, .external_lex_state = 2},
  [1254] = {.lex_state = 2, .external_lex_state = 3},
  [1255] = {.lex_state = 2, .external_lex_state = 3},
  [1256] = {.lex_state = 2, .external_lex_state = 3},
  [1257] = {.lex_state = 2, .external_lex_state = 4},
  [1258] = {.lex_state = 2, .external_lex_state = 4},
  [1259] = {.lex_state = 128, .external_lex_state = 2},
  [1260] = {.lex_state = 2, .external_lex_state = 3},
  [1261] = {.lex_state = 2, .external_lex_state = 4},
  [1262] = {.lex_state = 2, .external_lex_state = 3},
  [1263] = {.lex_state = 2, .external_lex_state = 4},
  [1264] = {.lex_state = 2, .external_lex_state = 3},
  [1265] = {.lex_state = 2, .external_lex_state = 3},
  [1266] = {.lex_state = 2, .external_lex_state = 4},
  [1267] = {.lex_state = 2, .external_lex_state = 4},
  [1268] = {.lex_state = 2, .external_lex_state = 3},
  [1269] = {.lex_state = 2, .external_lex_state = 3},
  [1270] = {.lex_state = 128, .external_lex_state = 2},
  [1271] = {.lex_state = 2, .external_lex_state = 3},
  [1272] = {.lex_state = 2, .external_lex_state = 3},
  [1273] = {.lex_state = 2, .external_lex_state = 3},
  [1274] = {.lex_state = 128, .external_lex_state = 2},
  [1275] = {.lex_state = 2, .external_lex_state = 4},
  [1276] = {.lex_state = 3, .external_lex_state = 3},
  [1277] = {.lex_state = 2, .external_lex_state = 4},
  [1278] = {.lex_state = 2, .external_lex_state = 3},
  [1279] = {.lex_state = 2, .external_lex_state = 4},
  [1280] = {.lex_state = 2, .external_lex_state = 3},
  [1281] = {.lex_state = 2, .external_lex_state = 4},
  [1282] = {.lex_state = 2, .external_lex_state = 3},
  [1283] = {.lex_state = 2, .external_lex_state = 4},
  [1284] = {.lex_state = 128, .external_lex_state = 2},
  [1285] = {.lex_state = 2, .external_lex_state = 4},
  [1286] = {.lex_state = 2, .external_lex_state = 3},
  [1287] = {.lex_state = 2, .external_lex_state = 4},
  [1288] = {.lex_state = 2, .external_lex_state = 4},
  [1289] = {.lex_state = 2, .external_lex_state = 4},
  [1290] = {.lex_state = 128, .external_lex_state = 2},
  [1291] = {.lex_state = 2, .external_lex_state = 4},
  [1292] = {.lex_state = 2, .external_lex_state = 4},
  [1293] = {.lex_state = 2, .external_lex_state = 4},
  [1294] = {.lex_state = 2, .external_lex_state = 4},
  [1295] = {.lex_state = 2, .external_lex_state = 4},
  [1296] = {.lex_state = 2, .external_lex_state = 3},
  [1297] = {.lex_state = 2, .external_lex_state = 3},
  [1298] = {.lex_state = 2, .external_lex_state = 4},
  [1299] = {.lex_state = 2, .external_lex_state = 4},
  [1300] = {.lex_state = 2, .external_lex_state = 4},
  [1301] = {.lex_state = 2, .external_lex_state = 3},
  [1302] = {.lex_state = 128, .external_lex_state = 2},
  [1303] = {.lex_state = 2, .external_lex_state = 4},
  [1304] = {.lex_state = 2, .external_lex_state = 4},
  [1305] = {.lex_state = 2, .external_lex_state = 4},
  [1306] = {.lex_state = 2, .external_lex_state = 4},
  [1307] = {.lex_state = 2, .external_lex_state = 4},
  [1308] = {.lex_state = 3, .external_lex_state = 3},
  [1309] = {.lex_state = 2, .external_lex_state = 3},
  [1310] = {.lex_state = 2, .external_lex_state = 4},
  [1311] = {.lex_state = 2, .external_lex_state = 4},
  [1312] = {.lex_state = 2, .external_lex_state = 4},
  [1313] = {.lex_state = 2, .external_lex_state = 4},
  [1314] = {.lex_state = 2, .external_lex_state = 4},
  [1315] = {.lex_state = 2, .external_lex_state = 4},
  [1316] = {.lex_state = 2, .external_lex_state = 3},
  [1317] = {.lex_state = 2, .external_lex_state = 3},
  [1318] = {.lex_state = 2, .external_lex_state = 3},
  [1319] = {.lex_state = 2, .external_lex_state = 3},
  [1320] = {.lex_state = 2, .external_lex_state = 4},
  [1321] = {.lex_state = 2, .external_lex_state = 3},
  [1322] = {.lex_state = 2, .external_lex_state = 3},
  [1323] = {.lex_state = 2, .external_lex_state = 3},
  [1324] = {.lex_state = 2, .external_lex_state = 3},
  [1325] = {.lex_state = 2, .external_lex_state = 4},
  [1326] = {.lex_state = 2, .external_lex_state = 4},
  [1327] = {.lex_state = 2, .external_lex_state = 3},
  [1328] = {.lex_state = 2, .external_lex_state = 3},
  [1329] = {.lex_state = 3, .external_lex_state = 3},
  [1330] = {.lex_state = 2, .external_lex_state = 4},
  [1331] = {.lex_state = 2, .external_lex_state = 3},
  [1332] = {.lex_state = 2, .external_lex_state = 3},
  [1333] = {.lex_state = 3, .external_lex_state = 3},
  [1334] = {.lex_state = 2, .external_lex_state = 4},
  [1335] = {.lex_state = 2, .external_lex_state = 4},
  [1336] = {.lex_state = 2, .external_lex_state = 3},
  [1337] = {.lex_state = 2, .external_lex_state = 4},
  [1338] = {.lex_state = 2, .external_lex_state = 3},
  [1339] = {.lex_state = 3, .external_lex_state = 3},
  [1340] = {.lex_state = 3, .external_lex_state = 3},
  [1341] = {.lex_state = 2, .external_lex_state = 3},
  [1342] = {.lex_state = 2, .external_lex_state = 3},
  [1343] = {.lex_state = 2, .external_lex_state = 3},
  [1344] = {.lex_state = 2, .external_lex_state = 3},
  [1345] = {.lex_state = 9, .external_lex_state = 2},
  [1346] = {.lex_state = 2, .external_lex_state = 4},
  [1347] = {.lex_state = 2, .external_lex_state = 4},
  [1348] = {.lex_state = 2, .external_lex_state = 3},
  [1349] = {.lex_state = 2, .external_lex_state = 3},
  [1350] = {.lex_state = 2, .external_lex_state = 3},
  [1351] = {.lex_state = 9, .external_lex_state = 2},
  [1352] = {.lex_state = 9, .external_lex_state = 2},
  [1353] = {.lex_state = 2, .external_lex_state = 3},
  [1354] = {.lex_state = 2, .external_lex_state = 3},
  [1355] = {.lex_state = 2, .external_lex_state = 3},
  [1356] = {.lex_state = 2, .external_lex_state = 3},
  [1357] = {.lex_state = 9, .external_lex_state = 2},
  [1358] = {.lex_state = 2, .external_lex_state = 3},
  [1359] = {.lex_state = 2, .external_lex_state = 3},
  [1360] = {.lex_state = 2, .external_lex_state = 4},
  [1361] = {.lex_state = 9, .external_lex_state = 2},
  [1362] = {.lex_state = 2, .external_lex_state = 3},
  [1363] = {.lex_state = 9, .external_lex_state = 2},
  [1364] = {.lex_state = 2, .external_lex_state = 3},
  [1365] = {.lex_state = 3, .external_lex_state = 3},
  [1366] = {.lex_state = 2, .external_lex_state = 3},
  [1367] = {.lex_state = 2, .external_lex_state = 4},
  [1368] = {.lex_state = 2, .external_lex_state = 3},
  [1369] = {.lex_state = 2, .external_lex_state = 3},
  [1370] = {.lex_state = 2, .external_lex_state = 3},
  [1371] = {.lex_state = 2, .external_lex_state = 3},
  [1372] = {.lex_state = 2, .external_lex_state = 3},
  [1373] = {.lex_state = 2, .external_lex_state = 3},
  [1374] = {.lex_state = 2, .external_lex_state = 4},
  [1375] = {.lex_state = 2, .external_lex_state = 3},
  [1376] = {.lex_state = 2, .external_lex_state = 3},
  [1377] = {.lex_state = 2, .external_lex_state = 3},
  [1378] = {.lex_state = 2, .external_lex_state = 3},
  [1379] = {.lex_state = 2, .external_lex_state = 3},
  [1380] = {.lex_state = 2, .external_lex_state = 3},
  [1381] = {.lex_state = 2, .external_lex_state = 3},
  [1382] = {.lex_state = 2, .external_lex_state = 3},
  [1383] = {.lex_state = 9, .external_lex_state = 2},
  [1384] = {.lex_state = 9, .external_lex_state = 2},
  [1385] = {.lex_state = 9, .external_lex_state = 2},
  [1386] = {.lex_state = 9, .external_lex_state = 2},
  [1387] = {.lex_state = 2, .external_lex_state = 3},
  [1388] = {.lex_state = 9, .external_lex_state = 2},
  [1389] = {.lex_state = 2, .external_lex_state = 3},
  [1390] = {.lex_state = 2, .external_lex_state = 3},
  [1391] = {.lex_state = 2, .external_lex_state = 3},
  [1392] = {.lex_state = 2, .external_lex_state = 3},
  [1393] = {.lex_state = 2, .external_lex_state = 3},
  [1394] = {.lex_state = 9, .external_lex_state = 2},
  [1395] = {.lex_state = 9, .external_lex_state = 2},
  [1396] = {.lex_state = 2, .external_lex_state = 3},
  [1397] = {.lex_state = 2, .external_lex_state = 3},
  [1398] = {.lex_state = 2, .external_lex_state = 3},
  [1399] = {.lex_state = 2, .external_lex_state = 3},
  [1400] = {.lex_state = 2, .external_lex_state = 3},
  [1401] = {.lex_state = 2, .external_lex_state = 3},
  [1402] = {.lex_state = 9, .external_lex_state = 2},
  [1403] = {.lex_state = 2, .external_lex_state = 3},
  [1404] = {.lex_state = 9, .external_lex_state = 2},
  [1405] = {.lex_state = 9, .external_lex_state = 2},
  [1406] = {.lex_state = 2, .external_lex_state = 3},
  [1407] = {.lex_state = 2, .external_lex_state = 3},
  [1408] = {.lex_state = 9, .external_lex_state = 2},
  [1409] = {.lex_state = 2, .external_lex_state = 3},
  [1410] = {.lex_state = 2, .external_lex_state = 3},
  [1411] = {.lex_state = 9, .external_lex_state = 2},
  [1412] = {.lex_state = 9, .external_lex_state = 2},
  [1413] = {.lex_state = 2, .external_lex_state = 3},
  [1414] = {.lex_state = 9, .external_lex_state = 2},
  [1415] = {.lex_state = 2, .external_lex_state = 3},
  [1416] = {.lex_state = 2, .external_lex_state = 3},
  [1417] = {.lex_state = 2, .external_lex_state = 3},
  [1418] = {.lex_state = 9, .external_lex_state = 2},
  [1419] = {.lex_state = 9, .external_lex_state = 2},
  [1420] = {.lex_state = 2, .external_lex_state = 3},
  [1421] = {.lex_state = 9, .external_lex_state = 2},
  [1422] = {.lex_state = 9, .external_lex_state = 2},
  [1423] = {.lex_state = 2, .external_lex_state = 3},
  [1424] = {.lex_state = 2, .external_lex_state = 3},
  [1425] = {.lex_state = 2, .external_lex_state = 3},
  [1426] = {.lex_state = 2, .external_lex_state = 3},
  [1427] = {.lex_state = 2, .external_lex_state = 3},
  [1428] = {.lex_state = 2, .external_lex_state = 3},
  [1429] = {.lex_state = 2, .external_lex_state = 3},
  [1430] = {.lex_state = 2, .external_lex_state = 3},
  [1431] = {.lex_state = 2, .external_lex_state = 3},
  [1432] = {.lex_state = 2, .external_lex_state = 3},
  [1433] = {.lex_state = 9, .external_lex_state = 2},
  [1434] = {.lex_state = 9, .external_lex_state = 2},
  [1435] = {.lex_state = 9, .external_lex_state = 2},
  [1436] = {.lex_state = 9, .external_lex_state = 2},
  [1437] = {.lex_state = 9, .external_lex_state = 2},
  [1438] = {.lex_state = 9, .external_lex_state = 2},
  [1439] = {.lex_state = 9, .external_lex_state = 2},
  [1440] = {.lex_state = 128, .external_lex_state = 5},
  [1441] = {.lex_state = 9, .external_lex_state = 2},
  [1442] = {.lex_state = 9, .external_lex_state = 2},
  [1443] = {.lex_state = 9, .external_lex_state = 2},
  [1444] = {.lex_state = 9, .external_lex_state = 2},
  [1445] = {.lex_state = 9, .external_lex_state = 2},
  [1446] = {.lex_state = 128, .external_lex_state = 5},
  [1447] = {.lex_state = 128, .external_lex_state = 5},
  [1448] = {.lex_state = 9, .external_lex_state = 2},
  [1449] = {.lex_state = 9, .external_lex_state = 2},
  [1450] = {.lex_state = 9, .external_lex_state = 2},
  [1451] = {.lex_state = 128, .external_lex_state = 5},
  [1452] = {.lex_state = 9, .external_lex_state = 2},
  [1453] = {.lex_state = 9, .external_lex_state = 2},
  [1454] = {.lex_state = 128, .external_lex_state = 5},
  [1455] = {.lex_state = 9, .external_lex_state = 2},
  [1456] = {.lex_state = 128, .external_lex_state = 2},
  [1457] = {.lex_state = 128, .external_lex_state = 2},
  [1458] = {.lex_state = 128, .external_lex_state = 2},
  [1459] = {.lex_state = 127, .external_lex_state = 3},
  [1460] = {.lex_state = 128, .external_lex_state = 2},
  [1461] = {.lex_state = 128, .external_lex_state = 2},
  [1462] = {.lex_state = 128, .external_lex_state = 2},
  [1463] = {.lex_state = 127, .external_lex_state = 3},
  [1464] = {.lex_state = 128, .external_lex_state = 5},
  [1465] = {.lex_state = 127, .external_lex_state = 3},
  [1466] = {.lex_state = 127, .external_lex_state = 3},
  [1467] = {.lex_state = 127, .external_lex_state = 4},
  [1468] = {.lex_state = 127, .external_lex_state = 3},
  [1469] = {.lex_state = 128, .external_lex_state = 5},
  [1470] = {.lex_state = 127, .external_lex_state = 4},
  [1471] = {.lex_state = 127, .external_lex_state = 3},
  [1472] = {.lex_state = 127, .external_lex_state = 3},
  [1473] = {.lex_state = 127, .external_lex_state = 3},
  [1474] = {.lex_state = 127, .external_lex_state = 3},
  [1475] = {.lex_state = 127, .external_lex_state = 3},
  [1476] = {.lex_state = 127, .external_lex_state = 3},
  [1477] = {.lex_state = 127, .external_lex_state = 3},
  [1478] = {.lex_state = 127, .external_lex_state = 3},
  [1479] = {.lex_state = 128, .external_lex_state = 2},
  [1480] = {.lex_state = 127, .external_lex_state = 3},
  [1481] = {.lex_state = 127, .external_lex_state = 4},
  [1482] = {.lex_state = 127, .external_lex_state = 3},
  [1483] = {.lex_state = 127, .external_lex_state = 3},
  [1484] = {.lex_state = 127, .external_lex_state = 3},
  [1485] = {.lex_state = 127, .external_lex_state = 3},
  [1486] = {.lex_state = 127, .external_lex_state = 3},
  [1487] = {.lex_state = 127, .external_lex_state = 3},
  [1488] = {.lex_state = 127, .external_lex_state = 3},
  [1489] = {.lex_state = 127, .external_lex_state = 3},
  [1490] = {.lex_state = 127, .external_lex_state = 3},
  [1491] = {.lex_state = 127, .external_lex_state = 3},
  [1492] = {.lex_state = 127, .external_lex_state = 3},
  [1493] = {.lex_state = 127, .external_lex_state = 3},
  [1494] = {.lex_state = 127, .external_lex_state = 3},
  [1495] = {.lex_state = 127, .external_lex_state = 3},
  [1496] = {.lex_state = 127, .external_lex_state = 3},
  [1497] = {.lex_state = 127, .external_lex_state = 4},
  [1498] = {.lex_state = 127, .external_lex_state = 4},
  [1499] = {.lex_state = 127, .external_lex_state = 3},
  [1500] = {.lex_state = 127, .external_lex_state = 4},
  [1501] = {.lex_state = 127, .external_lex_state = 3},
  [1502] = {.lex_state = 127, .external_lex_state = 3},
  [1503] = {.lex_state = 127, .external_lex_state = 3},
  [1504] = {.lex_state = 127, .external_lex_state = 3},
  [1505] = {.lex_state = 127, .external_lex_state = 4},
  [1506] = {.lex_state = 127, .external_lex_state = 3},
  [1507] = {.lex_state = 127, .external_lex_state = 3},
  [1508] = {.lex_state = 127, .external_lex_state = 3},
  [1509] = {.lex_state = 127, .external_lex_state = 3},
  [1510] = {.lex_state = 127, .external_lex_state = 3},
  [1511] = {.lex_state = 127, .external_lex_state = 3},
  [1512] = {.lex_state = 127, .external_lex_state = 3},
  [1513] = {.lex_state = 127, .external_lex_state = 3},
  [1514] = {.lex_state = 127, .external_lex_state = 3},
  [1515] = {.lex_state = 127, .external_lex_state = 3},
  [1516] = {.lex_state = 127, .external_lex_state = 3},
  [1517] = {.lex_state = 127, .external_lex_state = 3},
  [1518] = {.lex_state = 127, .external_lex_state = 3},
  [1519] = {.lex_state = 127, .external_lex_state = 3},
  [1520] = {.lex_state = 127, .external_lex_state = 3},
  [1521] = {.lex_state = 127, .external_lex_state = 3},
  [1522] = {.lex_state = 127, .external_lex_state = 3},
  [1523] = {.lex_state = 127, .external_lex_state = 3},
  [1524] = {.lex_state = 127, .external_lex_state = 3},
  [1525] = {.lex_state = 127, .external_lex_state = 3},
  [1526] = {.lex_state = 127, .external_lex_state = 3},
  [1527] = {.lex_state = 127, .external_lex_state = 3},
  [1528] = {.lex_state = 127, .external_lex_state = 3},
  [1529] = {.lex_state = 127, .external_lex_state = 3},
  [1530] = {.lex_state = 127, .external_lex_state = 3},
  [1531] = {.lex_state = 127, .external_lex_state = 3},
  [1532] = {.lex_state = 127, .external_lex_state = 3},
  [1533] = {.lex_state = 127, .external_lex_state = 3},
  [1534] = {.lex_state = 127, .external_lex_state = 3},
  [1535] = {.lex_state = 127, .external_lex_state = 3},
  [1536] = {.lex_state = 127, .external_lex_state = 3},
  [1537] = {.lex_state = 127, .external_lex_state = 3},
  [1538] = {.lex_state = 127, .external_lex_state = 3},
  [1539] = {.lex_state = 127, .external_lex_state = 3},
  [1540] = {.lex_state = 127, .external_lex_state = 3},
  [1541] = {.lex_state = 127, .external_lex_state = 3},
  [1542] = {.lex_state = 127, .external_lex_state = 3},
  [1543] = {.lex_state = 127, .external_lex_state = 3},
  [1544] = {.lex_state = 127, .external_lex_state = 3},
  [1545] = {.lex_state = 127, .external_lex_state = 3},
  [1546] = {.lex_state = 127, .external_lex_state = 3},
  [1547] = {.lex_state = 127, .external_lex_state = 3},
  [1548] = {.lex_state = 127, .external_lex_state = 3},
  [1549] = {.lex_state = 127, .external_lex_state = 3},
  [1550] = {.lex_state = 127, .external_lex_state = 3},
  [1551] = {.lex_state = 127, .external_lex_state = 3},
  [1552] = {.lex_state = 127, .external_lex_state = 3},
  [1553] = {.lex_state = 127, .external_lex_state = 3},
  [1554] = {.lex_state = 127, .external_lex_state = 3},
  [1555] = {.lex_state = 127, .external_lex_state = 4},
  [1556] = {.lex_state = 127, .external_lex_state = 3},
  [1557] = {.lex_state = 127, .external_lex_state = 3},
  [1558] = {.lex_state = 127, .external_lex_state = 3},
  [1559] = {.lex_state = 127, .external_lex_state = 3},
  [1560] = {.lex_state = 127, .external_lex_state = 3},
  [1561] = {.lex_state = 127, .external_lex_state = 3},
  [1562] = {.lex_state = 127, .external_lex_state = 3},
  [1563] = {.lex_state = 127, .external_lex_state = 3},
  [1564] = {.lex_state = 127, .external_lex_state = 3},
  [1565] = {.lex_state = 127, .external_lex_state = 3},
  [1566] = {.lex_state = 127, .external_lex_state = 3},
  [1567] = {.lex_state = 127, .external_lex_state = 3},
  [1568] = {.lex_state = 127, .external_lex_state = 3},
  [1569] = {.lex_state = 127, .external_lex_state = 3},
  [1570] = {.lex_state = 127, .external_lex_state = 3},
  [1571] = {.lex_state = 127, .external_lex_state = 3},
  [1572] = {.lex_state = 127, .external_lex_state = 3},
  [1573] = {.lex_state = 127, .external_lex_state = 3},
  [1574] = {.lex_state = 127, .external_lex_state = 3},
  [1575] = {.lex_state = 127, .external_lex_state = 3},
  [1576] = {.lex_state = 127, .external_lex_state = 3},
  [1577] = {.lex_state = 127, .external_lex_state = 3},
  [1578] = {.lex_state = 127, .external_lex_state = 3},
  [1579] = {.lex_state = 127, .external_lex_state = 3},
  [1580] = {.lex_state = 127, .external_lex_state = 3},
  [1581] = {.lex_state = 127, .external_lex_state = 3},
  [1582] = {.lex_state = 127, .external_lex_state = 3},
  [1583] = {.lex_state = 127, .external_lex_state = 3},
  [1584] = {.lex_state = 127, .external_lex_state = 3},
  [1585] = {.lex_state = 127, .external_lex_state = 3},
  [1586] = {.lex_state = 127, .external_lex_state = 3},
  [1587] = {.lex_state = 127, .external_lex_state = 3},
  [1588] = {.lex_state = 127, .external_lex_state = 3},
  [1589] = {.lex_state = 127, .external_lex_state = 3},
  [1590] = {.lex_state = 127, .external_lex_state = 3},
  [1591] = {.lex_state = 127, .external_lex_state = 3},
  [1592] = {.lex_state = 127, .external_lex_state = 3},
  [1593] = {.lex_state = 127, .external_lex_state = 3},
  [1594] = {.lex_state = 127, .external_lex_state = 3},
  [1595] = {.lex_state = 127, .external_lex_state = 3},
  [1596] = {.lex_state = 127, .external_lex_state = 3},
  [1597] = {.lex_state = 127, .external_lex_state = 3},
  [1598] = {.lex_state = 127, .external_lex_state = 3},
  [1599] = {.lex_state = 127, .external_lex_state = 3},
  [1600] = {.lex_state = 127, .external_lex_state = 3},
  [1601] = {.lex_state = 127, .external_lex_state = 3},
  [1602] = {.lex_state = 127, .external_lex_state = 3},
  [1603] = {.lex_state = 127, .external_lex_state = 3},
  [1604] = {.lex_state = 127, .external_lex_state = 3},
  [1605] = {.lex_state = 127, .external_lex_state = 3},
  [1606] = {.lex_state = 127, .external_lex_state = 3},
  [1607] = {.lex_state = 127, .external_lex_state = 3},
  [1608] = {.lex_state = 127, .external_lex_state = 3},
  [1609] = {.lex_state = 127, .external_lex_state = 3},
  [1610] = {.lex_state = 127, .external_lex_state = 3},
  [1611] = {.lex_state = 127, .external_lex_state = 3},
  [1612] = {.lex_state = 127, .external_lex_state = 3},
  [1613] = {.lex_state = 127, .external_lex_state = 3},
  [1614] = {.lex_state = 127, .external_lex_state = 3},
  [1615] = {.lex_state = 127, .external_lex_state = 3},
  [1616] = {.lex_state = 127, .external_lex_state = 3},
  [1617] = {.lex_state = 128, .external_lex_state = 5},
  [1618] = {.lex_state = 127, .external_lex_state = 3},
  [1619] = {.lex_state = 127, .external_lex_state = 3},
  [1620] = {.lex_state = 127, .external_lex_state = 3},
  [1621] = {.lex_state = 127, .external_lex_state = 3},
  [1622] = {.lex_state = 127, .external_lex_state = 3},
  [1623] = {.lex_state = 127, .external_lex_state = 3},
  [1624] = {.lex_state = 127, .external_lex_state = 3},
  [1625] = {.lex_state = 127, .external_lex_state = 3},
  [1626] = {.lex_state = 127, .external_lex_state = 3},
  [1627] = {.lex_state = 127, .external_lex_state = 3},
  [1628] = {.lex_state = 127, .external_lex_state = 3},
  [1629] = {.lex_state = 127, .external_lex_state = 3},
  [1630] = {.lex_state = 127, .external_lex_state = 3},
  [1631] = {.lex_state = 127, .external_lex_state = 3},
  [1632] = {.lex_state = 127, .external_lex_state = 3},
  [1633] = {.lex_state = 127, .external_lex_state = 3},
  [1634] = {.lex_state = 127, .external_lex_state = 3},
  [1635] = {.lex_state = 127, .external_lex_state = 3},
  [1636] = {.lex_state = 127, .external_lex_state = 3},
  [1637] = {.lex_state = 127, .external_lex_state = 3},
  [1638] = {.lex_state = 127, .external_lex_state = 3},
  [1639] = {.lex_state = 127, .external_lex_state = 3},
  [1640] = {.lex_state = 127, .external_lex_state = 4},
  [1641] = {.lex_state = 127, .external_lex_state = 3},
  [1642] = {.lex_state = 127, .external_lex_state = 3},
  [1643] = {.lex_state = 127, .external_lex_state = 3},
  [1644] = {.lex_state = 127, .external_lex_state = 3},
  [1645] = {.lex_state = 127, .external_lex_state = 3},
  [1646] = {.lex_state = 127, .external_lex_state = 3},
  [1647] = {.lex_state = 127, .external_lex_state = 3},
  [1648] = {.lex_state = 127, .external_lex_state = 3},
  [1649] = {.lex_state = 127, .external_lex_state = 3},
  [1650] = {.lex_state = 127, .external_lex_state = 3},
  [1651] = {.lex_state = 127, .external_lex_state = 3},
  [1652] = {.lex_state = 127, .external_lex_state = 3},
  [1653] = {.lex_state = 127, .external_lex_state = 3},
  [1654] = {.lex_state = 127, .external_lex_state = 3},
  [1655] = {.lex_state = 127, .external_lex_state = 3},
  [1656] = {.lex_state = 127, .external_lex_state = 3},
  [1657] = {.lex_state = 127, .external_lex_state = 3},
  [1658] = {.lex_state = 127, .external_lex_state = 3},
  [1659] = {.lex_state = 128, .external_lex_state = 5},
  [1660] = {.lex_state = 127, .external_lex_state = 3},
  [1661] = {.lex_state = 127, .external_lex_state = 3},
  [1662] = {.lex_state = 127, .external_lex_state = 3},
  [1663] = {.lex_state = 127, .external_lex_state = 3},
  [1664] = {.lex_state = 127, .external_lex_state = 3},
  [1665] = {.lex_state = 127, .external_lex_state = 3},
  [1666] = {.lex_state = 127, .external_lex_state = 3},
  [1667] = {.lex_state = 127, .external_lex_state = 3},
  [1668] = {.lex_state = 127, .external_lex_state = 3},
  [1669] = {.lex_state = 127, .external_lex_state = 3},
  [1670] = {.lex_state = 128, .external_lex_state = 5},
  [1671] = {.lex_state = 127, .external_lex_state = 3},
  [1672] = {.lex_state = 127, .external_lex_state = 3},
  [1673] = {.lex_state = 127, .external_lex_state = 3},
  [1674] = {.lex_state = 127, .external_lex_state = 3},
  [1675] = {.lex_state = 127, .external_lex_state = 3},
  [1676] = {.lex_state = 127, .external_lex_state = 3},
  [1677] = {.lex_state = 127, .external_lex_state = 3},
  [1678] = {.lex_state = 127, .external_lex_state = 3},
  [1679] = {.lex_state = 127, .external_lex_state = 3},
  [1680] = {.lex_state = 127, .external_lex_state = 3},
  [1681] = {.lex_state = 127, .external_lex_state = 3},
  [1682] = {.lex_state = 127, .external_lex_state = 3},
  [1683] = {.lex_state = 127, .external_lex_state = 3},
  [1684] = {.lex_state = 127, .external_lex_state = 3},
  [1685] = {.lex_state = 127, .external_lex_state = 3},
  [1686] = {.lex_state = 127, .external_lex_state = 3},
  [1687] = {.lex_state = 127, .external_lex_state = 3},
  [1688] = {.lex_state = 127, .external_lex_state = 3},
  [1689] = {.lex_state = 127, .external_lex_state = 3},
  [1690] = {.lex_state = 127, .external_lex_state = 3},
  [1691] = {.lex_state = 127, .external_lex_state = 3},
  [1692] = {.lex_state = 127, .external_lex_state = 3},
  [1693] = {.lex_state = 127, .external_lex_state = 3},
  [1694] = {.lex_state = 127, .external_lex_state = 3},
  [1695] = {.lex_state = 127, .external_lex_state = 3},
  [1696] = {.lex_state = 127, .external_lex_state = 3},
  [1697] = {.lex_state = 127, .external_lex_state = 3},
  [1698] = {.lex_state = 127, .external_lex_state = 4},
  [1699] = {.lex_state = 127, .external_lex_state = 3},
  [1700] = {.lex_state = 127, .external_lex_state = 4},
  [1701] = {.lex_state = 127, .external_lex_state = 3},
  [1702] = {.lex_state = 127, .external_lex_state = 3},
  [1703] = {.lex_state = 127, .external_lex_state = 3},
  [1704] = {.lex_state = 127, .external_lex_state = 3},
  [1705] = {.lex_state = 127, .external_lex_state = 3},
  [1706] = {.lex_state = 127, .external_lex_state = 3},
  [1707] = {.lex_state = 127, .external_lex_state = 3},
  [1708] = {.lex_state = 127, .external_lex_state = 3},
  [1709] = {.lex_state = 127, .external_lex_state = 3},
  [1710] = {.lex_state = 127, .external_lex_state = 3},
  [1711] = {.lex_state = 127, .external_lex_state = 3},
  [1712] = {.lex_state = 128, .external_lex_state = 5},
  [1713] = {.lex_state = 127, .external_lex_state = 3},
  [1714] = {.lex_state = 127, .external_lex_state = 3},
  [1715] = {.lex_state = 127, .external_lex_state = 3},
  [1716] = {.lex_state = 128, .external_lex_state = 5},
  [1717] = {.lex_state = 127, .external_lex_state = 3},
  [1718] = {.lex_state = 127, .external_lex_state = 3},
  [1719] = {.lex_state = 127, .external_lex_state = 3},
  [1720] = {.lex_state = 127, .external_lex_state = 3},
  [1721] = {.lex_state = 127, .external_lex_state = 3},
  [1722] = {.lex_state = 127, .external_lex_state = 3},
  [1723] = {.lex_state = 127, .external_lex_state = 3},
  [1724] = {.lex_state = 127, .external_lex_state = 3},
  [1725] = {.lex_state = 127, .external_lex_state = 3},
  [1726] = {.lex_state = 128, .external_lex_state = 5},
  [1727] = {.lex_state = 127, .external_lex_state = 4},
  [1728] = {.lex_state = 128, .external_lex_state = 5},
  [1729] = {.lex_state = 127, .external_lex_state = 4},
  [1730] = {.lex_state = 128, .external_lex_state = 5},
  [1731] = {.lex_state = 127, .external_lex_state = 3},
  [1732] = {.lex_state = 128, .external_lex_state = 5},
  [1733] = {.lex_state = 127, .external_lex_state = 4},
  [1734] = {.lex_state = 128, .external_lex_state = 5},
  [1735] = {.lex_state = 127, .external_lex_state = 3},
  [1736] = {.lex_state = 127, .external_lex_state = 4},
  [1737] = {.lex_state = 128, .external_lex_state = 5},
  [1738] = {.lex_state = 127, .external_lex_state = 3},
  [1739] = {.lex_state = 128, .external_lex_state = 5},
  [1740] = {.lex_state = 127, .external_lex_state = 4},
  [1741] = {.lex_state = 128, .external_lex_state = 5},
  [1742] = {.lex_state = 127, .external_lex_state = 4},
  [1743] = {.lex_state = 127, .external_lex_state = 4},
  [1744] = {.lex_state = 128, .external_lex_state = 5},
  [1745] = {.lex_state = 127, .external_lex_state = 4},
  [1746] = {.lex_state = 127, .external_lex_state = 4},
  [1747] = {.lex_state = 127, .external_lex_state = 4},
  [1748] = {.lex_state = 128, .external_lex_state = 5},
  [1749] = {.lex_state = 127, .external_lex_state = 4},
  [1750] = {.lex_state = 127, .external_lex_state = 4},
  [1751] = {.lex_state = 128, .external_lex_state = 5},
  [1752] = {.lex_state = 128, .external_lex_state = 5},
  [1753] = {.lex_state = 128, .external_lex_state = 5},
  [1754] = {.lex_state = 127, .external_lex_state = 3},
  [1755] = {.lex_state = 127, .external_lex_state = 3},
  [1756] = {.lex_state = 127, .external_lex_state = 4},
  [1757] = {.lex_state = 127, .external_lex_state = 4},
  [1758] = {.lex_state = 127, .external_lex_state = 4},
  [1759] = {.lex_state = 127, .external_lex_state = 3},
  [1760] = {.lex_state = 127, .external_lex_state = 4},
  [1761] = {.lex_state = 127, .external_lex_state = 4},
  [1762] = {.lex_state = 127, .external_lex_state = 4},
  [1763] = {.lex_state = 127, .external_lex_state = 3},
  [1764] = {.lex_state = 127, .external_lex_state = 4},
  [1765] = {.lex_state = 127, .external_lex_state = 4},
  [1766] = {.lex_state = 127, .external_lex_state = 3},
  [1767] = {.lex_state = 127, .external_lex_state = 4},
  [1768] = {.lex_state = 127, .external_lex_state = 4},
  [1769] = {.lex_state = 127, .external_lex_state = 4},
  [1770] = {.lex_state = 128, .external_lex_state = 5},
  [1771] = {.lex_state = 127, .external_lex_state = 4},
  [1772] = {.lex_state = 128, .external_lex_state = 5},
  [1773] = {.lex_state = 127, .external_lex_state = 4},
  [1774] = {.lex_state = 127, .external_lex_state = 4},
  [1775] = {.lex_state = 127, .external_lex_state = 4},
  [1776] = {.lex_state = 127, .external_lex_state = 3},
  [1777] = {.lex_state = 127, .external_lex_state = 4},
  [1778] = {.lex_state = 127, .external_lex_state = 4},
  [1779] = {.lex_state = 127, .external_lex_state = 4},
  [1780] = {.lex_state = 127, .external_lex_state = 4},
  [1781] = {.lex_state = 127, .external_lex_state = 4},
  [1782] = {.lex_state = 127, .external_lex_state = 4},
  [1783] = {.lex_state = 127, .external_lex_state = 4},
  [1784] = {.lex_state = 127, .external_lex_state = 4},
  [1785] = {.lex_state = 128, .external_lex_state = 5},
  [1786] = {.lex_state = 127, .external_lex_state = 4},
  [1787] = {.lex_state = 127, .external_lex_state = 4},
  [1788] = {.lex_state = 127, .external_lex_state = 4},
  [1789] = {.lex_state = 128, .external_lex_state = 5},
  [1790] = {.lex_state = 127, .external_lex_state = 4},
  [1791] = {.lex_state = 127, .external_lex_state = 3},
  [1792] = {.lex_state = 127, .external_lex_state = 4},
  [1793] = {.lex_state = 127, .external_lex_state = 3},
  [1794] = {.lex_state = 127, .external_lex_state = 4},
  [1795] = {.lex_state = 127, .external_lex_state = 4},
  [1796] = {.lex_state = 127, .external_lex_state = 4},
  [1797] = {.lex_state = 127, .external_lex_state = 4},
  [1798] = {.lex_state = 128, .external_lex_state = 5},
  [1799] = {.lex_state = 127, .external_lex_state = 4},
  [1800] = {.lex_state = 127, .external_lex_state = 3},
  [1801] = {.lex_state = 127, .external_lex_state = 4},
  [1802] = {.lex_state = 127, .external_lex_state = 4},
  [1803] = {.lex_state = 127, .external_lex_state = 4},
  [1804] = {.lex_state = 127, .external_lex_state = 4},
  [1805] = {.lex_state = 127, .external_lex_state = 4},
  [1806] = {.lex_state = 127, .external_lex_state = 3},
  [1807] = {.lex_state = 127, .external_lex_state = 4},
  [1808] = {.lex_state = 127, .external_lex_state = 4},
  [1809] = {.lex_state = 127, .external_lex_state = 4},
  [1810] = {.lex_state = 127, .external_lex_state = 4},
  [1811] = {.lex_state = 127, .external_lex_state = 4},
  [1812] = {.lex_state = 127, .external_lex_state = 4},
  [1813] = {.lex_state = 4, .external_lex_state = 3},
  [1814] = {.lex_state = 127, .external_lex_state = 4},
  [1815] = {.lex_state = 127, .external_lex_state = 3},
  [1816] = {.lex_state = 127, .external_lex_state = 4},
  [1817] = {.lex_state = 127, .external_lex_state = 4},
  [1818] = {.lex_state = 127, .external_lex_state = 4},
  [1819] = {.lex_state = 127, .external_lex_state = 4},
  [1820] = {.lex_state = 127, .external_lex_state = 4},
  [1821] = {.lex_state = 127, .external_lex_state = 3},
  [1822] = {.lex_state = 127, .external_lex_state = 4},
  [1823] = {.lex_state = 127, .external_lex_state = 4},
  [1824] = {.lex_state = 127, .external_lex_state = 4},
  [1825] = {.lex_state = 127, .external_lex_state = 4},
  [1826] = {.lex_state = 127, .external_lex_state = 3},
  [1827] = {.lex_state = 127, .external_lex_state = 4},
  [1828] = {.lex_state = 127, .external_lex_state = 4},
  [1829] = {.lex_state = 127, .external_lex_state = 4},
  [1830] = {.lex_state = 127, .external_lex_state = 4},
  [1831] = {.lex_state = 127, .external_lex_state = 4},
  [1832] = {.lex_state = 127, .external_lex_state = 4},
  [1833] = {.lex_state = 127, .external_lex_state = 4},
  [1834] = {.lex_state = 127, .external_lex_state = 3},
  [1835] = {.lex_state = 127, .external_lex_state = 3},
  [1836] = {.lex_state = 127, .external_lex_state = 4},
  [1837] = {.lex_state = 127, .external_lex_state = 4},
  [1838] = {.lex_state = 127, .external_lex_state = 4},
  [1839] = {.lex_state = 128, .external_lex_state = 5},
  [1840] = {.lex_state = 127, .external_lex_state = 4},
  [1841] = {.lex_state = 127, .external_lex_state = 4},
  [1842] = {.lex_state = 128, .external_lex_state = 5},
  [1843] = {.lex_state = 127, .external_lex_state = 4},
  [1844] = {.lex_state = 127, .external_lex_state = 4},
  [1845] = {.lex_state = 128, .external_lex_state = 5},
  [1846] = {.lex_state = 127, .external_lex_state = 4},
  [1847] = {.lex_state = 127, .external_lex_state = 4},
  [1848] = {.lex_state = 127, .external_lex_state = 4},
  [1849] = {.lex_state = 127, .external_lex_state = 4},
  [1850] = {.lex_state = 127, .external_lex_state = 4},
  [1851] = {.lex_state = 127, .external_lex_state = 3},
  [1852] = {.lex_state = 127, .external_lex_state = 4},
  [1853] = {.lex_state = 127, .external_lex_state = 4},
  [1854] = {.lex_state = 127, .external_lex_state = 3},
  [1855] = {.lex_state = 127, .external_lex_state = 3},
  [1856] = {.lex_state = 128, .external_lex_state = 5},
  [1857] = {.lex_state = 128, .external_lex_state = 5},
  [1858] = {.lex_state = 127, .external_lex_state = 4},
  [1859] = {.lex_state = 127, .external_lex_state = 4},
  [1860] = {.lex_state = 128, .external_lex_state = 2},
  [1861] = {.lex_state = 127, .external_lex_state = 4},
  [1862] = {.lex_state = 127, .external_lex_state = 4},
  [1863] = {.lex_state = 127, .external_lex_state = 4},
  [1864] = {.lex_state = 127, .external_lex_state = 4},
  [1865] = {.lex_state = 127, .external_lex_state = 4},
  [1866] = {.lex_state = 127, .external_lex_state = 4},
  [1867] = {.lex_state = 127, .external_lex_state = 4},
  [1868] = {.lex_state = 127, .external_lex_state = 4},
  [1869] = {.lex_state = 127, .external_lex_state = 4},
  [1870] = {.lex_state = 127, .external_lex_state = 4},
  [1871] = {.lex_state = 127, .external_lex_state = 4},
  [1872] = {.lex_state = 127, .external_lex_state = 4},
  [1873] = {.lex_state = 127, .external_lex_state = 4},
  [1874] = {.lex_state = 127, .external_lex_state = 4},
  [1875] = {.lex_state = 127, .external_lex_state = 4},
  [1876] = {.lex_state = 127, .external_lex_state = 4},
  [1877] = {.lex_state = 127, .external_lex_state = 4},
  [1878] = {.lex_state = 127, .external_lex_state = 4},
  [1879] = {.lex_state = 127, .external_lex_state = 4},
  [1880] = {.lex_state = 127, .external_lex_state = 4},
  [1881] = {.lex_state = 127, .external_lex_state = 3},
  [1882] = {.lex_state = 127, .external_lex_state = 3},
  [1883] = {.lex_state = 127, .external_lex_state = 4},
  [1884] = {.lex_state = 127, .external_lex_state = 4},
  [1885] = {.lex_state = 127, .external_lex_state = 4},
  [1886] = {.lex_state = 127, .external_lex_state = 4},
  [1887] = {.lex_state = 127, .external_lex_state = 4},
  [1888] = {.lex_state = 127, .external_lex_state = 4},
  [1889] = {.lex_state = 127, .external_lex_state = 4},
  [1890] = {.lex_state = 127, .external_lex_state = 4},
  [1891] = {.lex_state = 127, .external_lex_state = 4},
  [1892] = {.lex_state = 127, .external_lex_state = 4},
  [1893] = {.lex_state = 127, .external_lex_state = 4},
  [1894] = {.lex_state = 127, .external_lex_state = 4},
  [1895] = {.lex_state = 127, .external_lex_state = 4},
  [1896] = {.lex_state = 127, .external_lex_state = 4},
  [1897] = {.lex_state = 127, .external_lex_state = 4},
  [1898] = {.lex_state = 127, .external_lex_state = 4},
  [1899] = {.lex_state = 127, .external_lex_state = 4},
  [1900] = {.lex_state = 127, .external_lex_state = 4},
  [1901] = {.lex_state = 127, .external_lex_state = 4},
  [1902] = {.lex_state = 127, .external_lex_state = 4},
  [1903] = {.lex_state = 127, .external_lex_state = 4},
  [1904] = {.lex_state = 127, .external_lex_state = 4},
  [1905] = {.lex_state = 127, .external_lex_state = 4},
  [1906] = {.lex_state = 127, .external_lex_state = 4},
  [1907] = {.lex_state = 127, .external_lex_state = 4},
  [1908] = {.lex_state = 127, .external_lex_state = 4},
  [1909] = {.lex_state = 127, .external_lex_state = 4},
  [1910] = {.lex_state = 127, .external_lex_state = 4},
  [1911] = {.lex_state = 127, .external_lex_state = 4},
  [1912] = {.lex_state = 127, .external_lex_state = 4},
  [1913] = {.lex_state = 127, .external_lex_state = 4},
  [1914] = {.lex_state = 127, .external_lex_state = 4},
  [1915] = {.lex_state = 127, .external_lex_state = 4},
  [1916] = {.lex_state = 127, .external_lex_state = 4},
  [1917] = {.lex_state = 127, .external_lex_state = 4},
  [1918] = {.lex_state = 127, .external_lex_state = 4},
  [1919] = {.lex_state = 127, .external_lex_state = 4},
  [1920] = {.lex_state = 127, .external_lex_state = 4},
  [1921] = {.lex_state = 127, .external_lex_state = 4},
  [1922] = {.lex_state = 127, .external_lex_state = 4},
  [1923] = {.lex_state = 127, .external_lex_state = 4},
  [1924] = {.lex_state = 127, .external_lex_state = 4},
  [1925] = {.lex_state = 127, .external_lex_state = 4},
  [1926] = {.lex_state = 127, .external_lex_state = 4},
  [1927] = {.lex_state = 127, .external_lex_state = 4},
  [1928] = {.lex_state = 127, .external_lex_state = 4},
  [1929] = {.lex_state = 127, .external_lex_state = 4},
  [1930] = {.lex_state = 127, .external_lex_state = 4},
  [1931] = {.lex_state = 127, .external_lex_state = 4},
  [1932] = {.lex_state = 127, .external_lex_state = 4},
  [1933] = {.lex_state = 127, .external_lex_state = 4},
  [1934] = {.lex_state = 127, .external_lex_state = 4},
  [1935] = {.lex_state = 127, .external_lex_state = 4},
  [1936] = {.lex_state = 127, .external_lex_state = 4},
  [1937] = {.lex_state = 127, .external_lex_state = 4},
  [1938] = {.lex_state = 127, .external_lex_state = 4},
  [1939] = {.lex_state = 127, .external_lex_state = 4},
  [1940] = {.lex_state = 127, .external_lex_state = 4},
  [1941] = {.lex_state = 127, .external_lex_state = 4},
  [1942] = {.lex_state = 127, .external_lex_state = 4},
  [1943] = {.lex_state = 127, .external_lex_state = 4},
  [1944] = {.lex_state = 127, .external_lex_state = 4},
  [1945] = {.lex_state = 127, .external_lex_state = 4},
  [1946] = {.lex_state = 127, .external_lex_state = 4},
  [1947] = {.lex_state = 127, .external_lex_state = 4},
  [1948] = {.lex_state = 127, .external_lex_state = 4},
  [1949] = {.lex_state = 127, .external_lex_state = 4},
  [1950] = {.lex_state = 127, .external_lex_state = 4},
  [1951] = {.lex_state = 127, .external_lex_state = 4},
  [1952] = {.lex_state = 127, .external_lex_state = 4},
  [1953] = {.lex_state = 127, .external_lex_state = 4},
  [1954] = {.lex_state = 127, .external_lex_state = 4},
  [1955] = {.lex_state = 127, .external_lex_state = 4},
  [1956] = {.lex_state = 127, .external_lex_state = 4},
  [1957] = {.lex_state = 127, .external_lex_state = 4},
  [1958] = {.lex_state = 127, .external_lex_state = 4},
  [1959] = {.lex_state = 127, .external_lex_state = 4},
  [1960] = {.lex_state = 127, .external_lex_state = 4},
  [1961] = {.lex_state = 127, .external_lex_state = 4},
  [1962] = {.lex_state = 127, .external_lex_state = 4},
  [1963] = {.lex_state = 127, .external_lex_state = 4},
  [1964] = {.lex_state = 127, .external_lex_state = 4},
  [1965] = {.lex_state = 127, .external_lex_state = 4},
  [1966] = {.lex_state = 127, .external_lex_state = 4},
  [1967] = {.lex_state = 127, .external_lex_state = 3},
  [1968] = {.lex_state = 127, .external_lex_state = 4},
  [1969] = {.lex_state = 127, .external_lex_state = 4},
  [1970] = {.lex_state = 127, .external_lex_state = 4},
  [1971] = {.lex_state = 127, .external_lex_state = 4},
  [1972] = {.lex_state = 127, .external_lex_state = 4},
  [1973] = {.lex_state = 127, .external_lex_state = 4},
  [1974] = {.lex_state = 127, .external_lex_state = 4},
  [1975] = {.lex_state = 128, .external_lex_state = 2},
  [1976] = {.lex_state = 127, .external_lex_state = 4},
  [1977] = {.lex_state = 127, .external_lex_state = 3},
  [1978] = {.lex_state = 127, .external_lex_state = 4},
  [1979] = {.lex_state = 127, .external_lex_state = 3},
  [1980] = {.lex_state = 127, .external_lex_state = 3},
  [1981] = {.lex_state = 127, .external_lex_state = 4},
  [1982] = {.lex_state = 127, .external_lex_state = 4},
  [1983] = {.lex_state = 127, .external_lex_state = 4},
  [1984] = {.lex_state = 128, .external_lex_state = 2},
  [1985] = {.lex_state = 128, .external_lex_state = 2},
  [1986] = {.lex_state = 127, .external_lex_state = 3},
  [1987] = {.lex_state = 128, .external_lex_state = 5},
  [1988] = {.lex_state = 128, .external_lex_state = 5},
  [1989] = {.lex_state = 128, .external_lex_state = 5},
  [1990] = {.lex_state = 128, .external_lex_state = 5},
  [1991] = {.lex_state = 127, .external_lex_state = 4},
  [1992] = {.lex_state = 127, .external_lex_state = 4},
  [1993] = {.lex_state = 127, .external_lex_state = 3},
  [1994] = {.lex_state = 128, .external_lex_state = 5},
  [1995] = {.lex_state = 127, .external_lex_state = 3},
  [1996] = {.lex_state = 127, .external_lex_state = 3},
  [1997] = {.lex_state = 128, .external_lex_state = 2},
  [1998] = {.lex_state = 127, .external_lex_state = 4},
  [1999] = {.lex_state = 127, .external_lex_state = 3},
  [2000] = {.lex_state = 127, .external_lex_state = 3},
  [2001] = {.lex_state = 127, .external_lex_state = 4},
  [2002] = {.lex_state = 127, .external_lex_state = 4},
  [2003] = {.lex_state = 128, .external_lex_state = 2},
  [2004] = {.lex_state = 127, .external_lex_state = 3},
  [2005] = {.lex_state = 127, .external_lex_state = 3},
  [2006] = {.lex_state = 127, .external_lex_state = 4},
  [2007] = {.lex_state = 127, .external_lex_state = 4},
  [2008] = {.lex_state = 127, .external_lex_state = 4},
  [2009] = {.lex_state = 127, .external_lex_state = 4},
  [2010] = {.lex_state = 128, .external_lex_state = 2},
  [2011] = {.lex_state = 127, .external_lex_state = 4},
  [2012] = {.lex_state = 127, .external_lex_state = 4},
  [2013] = {.lex_state = 127, .external_lex_state = 4},
  [2014] = {.lex_state = 127, .external_lex_state = 4},
  [2015] = {.lex_state = 127, .external_lex_state = 3},
  [2016] = {.lex_state = 127, .external_lex_state = 4},
  [2017] = {.lex_state = 128, .external_lex_state = 2},
  [2018] = {.lex_state = 128, .external_lex_state = 5},
  [2019] = {.lex_state = 128, .external_lex_state = 5},
  [2020] = {.lex_state = 128, .external_lex_state = 5},
  [2021] = {.lex_state = 127, .external_lex_state = 3},
  [2022] = {.lex_state = 127, .external_lex_state = 4},
  [2023] = {.lex_state = 128, .external_lex_state = 5},
  [2024] = {.lex_state = 128, .external_lex_state = 5},
  [2025] = {.lex_state = 128, .external_lex_state = 5},
  [2026] = {.lex_state = 127, .external_lex_state = 4},
  [2027] = {.lex_state = 127, .external_lex_state = 4},
  [2028] = {.lex_state = 127, .external_lex_state = 4},
  [2029] = {.lex_state = 127, .external_lex_state = 4},
  [2030] = {.lex_state = 127, .external_lex_state = 3},
  [2031] = {.lex_state = 127, .external_lex_state = 3},
  [2032] = {.lex_state = 127, .external_lex_state = 3},
  [2033] = {.lex_state = 127, .external_lex_state = 3},
  [2034] = {.lex_state = 127, .external_lex_state = 3},
  [2035] = {.lex_state = 127, .external_lex_state = 3},
  [2036] = {.lex_state = 127, .external_lex_state = 3},
  [2037] = {.lex_state = 127, .external_lex_state = 3},
  [2038] = {.lex_state = 127, .external_lex_state = 3},
  [2039] = {.lex_state = 127, .external_lex_state = 3},
  [2040] = {.lex_state = 127, .external_lex_state = 3},
  [2041] = {.lex_state = 127, .external_lex_state = 3},
  [2042] = {.lex_state = 127, .external_lex_state = 3},
  [2043] = {.lex_state = 127, .external_lex_state = 3},
  [2044] = {.lex_state = 127, .external_lex_state = 3},
  [2045] = {.lex_state = 127, .external_lex_state = 3},
  [2046] = {.lex_state = 127, .external_lex_state = 3},
  [2047] = {.lex_state = 127, .external_lex_state = 3},
  [2048] = {.lex_state = 127, .external_lex_state = 3},
  [2049] = {.lex_state = 127, .external_lex_state = 3},
  [2050] = {.lex_state = 127, .external_lex_state = 3},
  [2051] = {.lex_state = 127, .external_lex_state = 3},
  [2052] = {.lex_state = 127, .external_lex_state = 3},
  [2053] = {.lex_state = 127, .external_lex_state = 3},
  [2054] = {.lex_state = 127, .external_lex_state = 3},
  [2055] = {.lex_state = 127, .external_lex_state = 4},
  [2056] = {.lex_state = 127, .external_lex_state = 3},
  [2057] = {.lex_state = 127, .external_lex_state = 3},
  [2058] = {.lex_state = 127, .external_lex_state = 4},
  [2059] = {.lex_state = 127, .external_lex_state = 3},
  [2060] = {.lex_state = 127, .external_lex_state = 4},
  [2061] = {.lex_state = 127, .external_lex_state = 4},
  [2062] = {.lex_state = 127, .external_lex_state = 3},
  [2063] = {.lex_state = 128, .external_lex_state = 5},
  [2064] = {.lex_state = 127, .external_lex_state = 4},
  [2065] = {.lex_state = 127, .external_lex_state = 4},
  [2066] = {.lex_state = 127, .external_lex_state = 4},
  [2067] = {.lex_state = 127, .external_lex_state = 3},
  [2068] = {.lex_state = 127, .external_lex_state = 4},
  [2069] = {.lex_state = 127, .external_lex_state = 3},
  [2070] = {.lex_state = 127, .external_lex_state = 3},
  [2071] = {.lex_state = 127, .external_lex_state = 4},
  [2072] = {.lex_state = 128, .external_lex_state = 2},
  [2073] = {.lex_state = 128, .external_lex_state = 5},
  [2074] = {.lex_state = 128, .external_lex_state = 2},
  [2075] = {.lex_state = 127, .external_lex_state = 3},
  [2076] = {.lex_state = 127, .external_lex_state = 3},
  [2077] = {.lex_state = 128, .external_lex_state = 5},
  [2078] = {.lex_state = 128, .external_lex_state = 5},
  [2079] = {.lex_state = 4, .external_lex_state = 4},
  [2080] = {.lex_state = 127, .external_lex_state = 4},
  [2081] = {.lex_state = 127, .external_lex_state = 4},
  [2082] = {.lex_state = 127, .external_lex_state = 3},
  [2083] = {.lex_state = 127, .external_lex_state = 4},
  [2084] = {.lex_state = 128, .external_lex_state = 5},
  [2085] = {.lex_state = 127, .external_lex_state = 4},
  [2086] = {.lex_state = 127, .external_lex_state = 4},
  [2087] = {.lex_state = 127, .external_lex_state = 4},
  [2088] = {.lex_state = 127, .external_lex_state = 4},
  [2089] = {.lex_state = 127, .external_lex_state = 4},
  [2090] = {.lex_state = 127, .external_lex_state = 4},
  [2091] = {.lex_state = 128, .external_lex_state = 5},
  [2092] = {.lex_state = 128, .external_lex_state = 5},
  [2093] = {.lex_state = 128, .external_lex_state = 5},
  [2094] = {.lex_state = 127, .external_lex_state = 4},
  [2095] = {.lex_state = 127, .external_lex_state = 4},
  [2096] = {.lex_state = 127, .external_lex_state = 4},
  [2097] = {.lex_state = 127, .external_lex_state = 4},
  [2098] = {.lex_state = 127, .external_lex_state = 4},
  [2099] = {.lex_state = 127, .external_lex_state = 4},
  [2100] = {.lex_state = 127, .external_lex_state = 4},
  [2101] = {.lex_state = 128, .external_lex_state = 2},
  [2102] = {.lex_state = 127, .external_lex_state = 4},
  [2103] = {.lex_state = 128, .external_lex_state = 2},
  [2104] = {.lex_state = 127, .external_lex_state = 4},
  [2105] = {.lex_state = 127, .external_lex_state = 4},
  [2106] = {.lex_state = 127, .external_lex_state = 3},
  [2107] = {.lex_state = 127, .external_lex_state = 3},
  [2108] = {.lex_state = 127, .external_lex_state = 4},
  [2109] = {.lex_state = 127, .external_lex_state = 4},
  [2110] = {.lex_state = 127, .external_lex_state = 4},
  [2111] = {.lex_state = 127, .external_lex_state = 4},
  [2112] = {.lex_state = 128, .external_lex_state = 5},
  [2113] = {.lex_state = 127, .external_lex_state = 3},
  [2114] = {.lex_state = 127, .external_lex_state = 4},
  [2115] = {.lex_state = 127, .external_lex_state = 4},
  [2116] = {.lex_state = 127, .external_lex_state = 4},
  [2117] = {.lex_state = 127, .external_lex_state = 4},
  [2118] = {.lex_state = 127, .external_lex_state = 4},
  [2119] = {.lex_state = 128, .external_lex_state = 2},
  [2120] = {.lex_state = 127, .external_lex_state = 4},
  [2121] = {.lex_state = 128, .external_lex_state = 2},
  [2122] = {.lex_state = 128, .external_lex_state = 5},
  [2123] = {.lex_state = 128, .external_lex_state = 5},
  [2124] = {.lex_state = 127, .external_lex_state = 4},
  [2125] = {.lex_state = 127, .external_lex_state = 4},
  [2126] = {.lex_state = 127, .external_lex_state = 4},
  [2127] = {.lex_state = 127, .external_lex_state = 4},
  [2128] = {.lex_state = 4, .external_lex_state = 4},
  [2129] = {.lex_state = 127, .external_lex_state = 4},
  [2130] = {.lex_state = 127, .external_lex_state = 4},
  [2131] = {.lex_state = 127, .external_lex_state = 4},
  [2132] = {.lex_state = 128, .external_lex_state = 5},
  [2133] = {.lex_state = 128, .external_lex_state = 5},
  [2134] = {.lex_state = 127, .external_lex_state = 4},
  [2135] = {.lex_state = 127, .external_lex_state = 3},
  [2136] = {.lex_state = 127, .external_lex_state = 3},
  [2137] = {.lex_state = 128, .external_lex_state = 5},
  [2138] = {.lex_state = 128, .external_lex_state = 5},
  [2139] = {.lex_state = 128, .external_lex_state = 5},
  [2140] = {.lex_state = 128, .external_lex_state = 5},
  [2141] = {.lex_state = 128, .external_lex_state = 5},
  [2142] = {.lex_state = 128, .external_lex_state = 5},
  [2143] = {.lex_state = 127, .external_lex_state = 4},
  [2144] = {.lex_state = 127, .external_lex_state = 3},
  [2145] = {.lex_state = 127, .external_lex_state = 3},
  [2146] = {.lex_state = 127, .external_lex_state = 3},
  [2147] = {.lex_state = 127, .external_lex_state = 4},
  [2148] = {.lex_state = 127, .external_lex_state = 3},
  [2149] = {.lex_state = 127, .external_lex_state = 4},
  [2150] = {.lex_state = 127, .external_lex_state = 4},
  [2151] = {.lex_state = 127, .external_lex_state = 4},
  [2152] = {.lex_state = 127, .external_lex_state = 3},
  [2153] = {.lex_state = 127, .external_lex_state = 3},
  [2154] = {.lex_state = 127, .external_lex_state = 4},
  [2155] = {.lex_state = 127, .external_lex_state = 4},
  [2156] = {.lex_state = 127, .external_lex_state = 4},
  [2157] = {.lex_state = 127, .external_lex_state = 4},
  [2158] = {.lex_state = 127, .external_lex_state = 4},
  [2159] = {.lex_state = 127, .external_lex_state = 4},
  [2160] = {.lex_state = 127, .external_lex_state = 4},
  [2161] = {.lex_state = 127, .external_lex_state = 3},
  [2162] = {.lex_state = 127, .external_lex_state = 4},
  [2163] = {.lex_state = 127, .external_lex_state = 3},
  [2164] = {.lex_state = 127, .external_lex_state = 4},
  [2165] = {.lex_state = 127, .external_lex_state = 4},
  [2166] = {.lex_state = 127, .external_lex_state = 4},
  [2167] = {.lex_state = 127, .external_lex_state = 4},
  [2168] = {.lex_state = 127, .external_lex_state = 4},
  [2169] = {.lex_state = 127, .external_lex_state = 4},
  [2170] = {.lex_state = 127, .external_lex_state = 4},
  [2171] = {.lex_state = 127, .external_lex_state = 4},
  [2172] = {.lex_state = 127, .external_lex_state = 4},
  [2173] = {.lex_state = 127, .external_lex_state = 3},
  [2174] = {.lex_state = 127, .external_lex_state = 4},
  [2175] = {.lex_state = 127, .external_lex_state = 4},
  [2176] = {.lex_state = 127, .external_lex_state = 3},
  [2177] = {.lex_state = 127, .external_lex_state = 4},
  [2178] = {.lex_state = 127, .external_lex_state = 4},
  [2179] = {.lex_state = 127, .external_lex_state = 4},
  [2180] = {.lex_state = 127, .external_lex_state = 4},
  [2181] = {.lex_state = 127, .external_lex_state = 4},
  [2182] = {.lex_state = 127, .external_lex_state = 4},
  [2183] = {.lex_state = 127, .external_lex_state = 4},
  [2184] = {.lex_state = 127, .external_lex_state = 4},
  [2185] = {.lex_state = 127, .external_lex_state = 4},
  [2186] = {.lex_state = 127, .external_lex_state = 3},
  [2187] = {.lex_state = 127, .external_lex_state = 4},
  [2188] = {.lex_state = 128, .external_lex_state = 2},
  [2189] = {.lex_state = 127, .external_lex_state = 4},
  [2190] = {.lex_state = 127, .external_lex_state = 4},
  [2191] = {.lex_state = 127, .external_lex_state = 4},
  [2192] = {.lex_state = 127, .external_lex_state = 4},
  [2193] = {.lex_state = 127, .external_lex_state = 4},
  [2194] = {.lex_state = 127, .external_lex_state = 3},
  [2195] = {.lex_state = 127, .external_lex_state = 3},
  [2196] = {.lex_state = 127, .external_lex_state = 3},
  [2197] = {.lex_state = 127, .external_lex_state = 3},
  [2198] = {.lex_state = 127, .external_lex_state = 3},
  [2199] = {.lex_state = 127, .external_lex_state = 4},
  [2200] = {.lex_state = 128, .external_lex_state = 2},
  [2201] = {.lex_state = 127, .external_lex_state = 3},
  [2202] = {.lex_state = 128, .external_lex_state = 5},
  [2203] = {.lex_state = 127, .external_lex_state = 3},
  [2204] = {.lex_state = 127, .external_lex_state = 3},
  [2205] = {.lex_state = 127, .external_lex_state = 3},
  [2206] = {.lex_state = 127, .external_lex_state = 3},
  [2207] = {.lex_state = 128, .external_lex_state = 2},
  [2208] = {.lex_state = 127, .external_lex_state = 3},
  [2209] = {.lex_state = 127, .external_lex_state = 3},
  [2210] = {.lex_state = 128, .external_lex_state = 5},
  [2211] = {.lex_state = 128, .external_lex_state = 5},
  [2212] = {.lex_state = 127, .external_lex_state = 3},
  [2213] = {.lex_state = 127, .external_lex_state = 3},
  [2214] = {.lex_state = 128, .external_lex_state = 5},
  [2215] = {.lex_state = 127, .external_lex_state = 4},
  [2216] = {.lex_state = 127, .external_lex_state = 3},
  [2217] = {.lex_state = 127, .external_lex_state = 4},
  [2218] = {.lex_state = 127, .external_lex_state = 4},
  [2219] = {.lex_state = 128, .external_lex_state = 5},
  [2220] = {.lex_state = 127, .external_lex_state = 4},
  [2221] = {.lex_state = 128, .external_lex_state = 5},
  [2222] = {.lex_state = 128, .external_lex_state = 5},
  [2223] = {.lex_state = 128, .external_lex_state = 5},
  [2224] = {.lex_state = 127, .external_lex_state = 4},
  [2225] = {.lex_state = 127, .external_lex_state = 4},
  [2226] = {.lex_state = 127, .external_lex_state = 4},
  [2227] = {.lex_state = 127, .external_lex_state = 3},
  [2228] = {.lex_state = 128, .external_lex_state = 5},
  [2229] = {.lex_state = 127, .external_lex_state = 4},
  [2230] = {.lex_state = 127, .external_lex_state = 3},
  [2231] = {.lex_state = 128, .external_lex_state = 5},
  [2232] = {.lex_state = 127, .external_lex_state = 3},
  [2233] = {.lex_state = 127, .external_lex_state = 3},
  [2234] = {.lex_state = 128, .external_lex_state = 5},
  [2235] = {.lex_state = 127, .external_lex_state = 3},
  [2236] = {.lex_state = 128, .external_lex_state = 5},
  [2237] = {.lex_state = 127, .external_lex_state = 4},
  [2238] = {.lex_state = 127, .external_lex_state = 4},
  [2239] = {.lex_state = 127, .external_lex_state = 4},
  [2240] = {.lex_state = 127, .external_lex_state = 4},
  [2241] = {.lex_state = 128, .external_lex_state = 5},
  [2242] = {.lex_state = 128, .external_lex_state = 5},
  [2243] = {.lex_state = 128, .external_lex_state = 5},
  [2244] = {.lex_state = 127, .external_lex_state = 3},
  [2245] = {.lex_state = 127, .external_lex_state = 3},
  [2246] = {.lex_state = 127, .external_lex_state = 3},
  [2247] = {.lex_state = 127, .external_lex_state = 3},
  [2248] = {.lex_state = 127, .external_lex_state = 3},
  [2249] = {.lex_state = 127, .external_lex_state = 3},
  [2250] = {.lex_state = 127, .external_lex_state = 3},
  [2251] = {.lex_state = 127, .external_lex_state = 3},
  [2252] = {.lex_state = 127, .external_lex_state = 3},
  [2253] = {.lex_state = 127, .external_lex_state = 3},
  [2254] = {.lex_state = 127, .external_lex_state = 3},
  [2255] = {.lex_state = 127, .external_lex_state = 3},
  [2256] = {.lex_state = 127, .external_lex_state = 3},
  [2257] = {.lex_state = 127, .external_lex_state = 3},
  [2258] = {.lex_state = 127, .external_lex_state = 3},
  [2259] = {.lex_state = 127, .external_lex_state = 3},
  [2260] = {.lex_state = 127, .external_lex_state = 3},
  [2261] = {.lex_state = 127, .external_lex_state = 3},
  [2262] = {.lex_state = 127, .external_lex_state = 3},
  [2263] = {.lex_state = 127, .external_lex_state = 3},
  [2264] = {.lex_state = 127, .external_lex_state = 3},
  [2265] = {.lex_state = 127, .external_lex_state = 3},
  [2266] = {.lex_state = 127, .external_lex_state = 3},
  [2267] = {.lex_state = 127, .external_lex_state = 3},
  [2268] = {.lex_state = 127, .external_lex_state = 3},
  [2269] = {.lex_state = 128, .external_lex_state = 2},
  [2270] = {.lex_state = 128, .external_lex_state = 5},
  [2271] = {.lex_state = 127, .external_lex_state = 4},
  [2272] = {.lex_state = 127, .external_lex_state = 4},
  [2273] = {.lex_state = 127, .external_lex_state = 4},
  [2274] = {.lex_state = 127, .external_lex_state = 4},
  [2275] = {.lex_state = 127, .external_lex_state = 4},
  [2276] = {.lex_state = 127, .external_lex_state = 4},
  [2277] = {.lex_state = 127, .external_lex_state = 4},
  [2278] = {.lex_state = 127, .external_lex_state = 3},
  [2279] = {.lex_state = 127, .external_lex_state = 3},
  [2280] = {.lex_state = 127, .external_lex_state = 3},
  [2281] = {.lex_state = 127, .external_lex_state = 3},
  [2282] = {.lex_state = 127, .external_lex_state = 3},
  [2283] = {.lex_state = 127, .external_lex_state = 3},
  [2284] = {.lex_state = 127, .external_lex_state = 4},
  [2285] = {.lex_state = 127, .external_lex_state = 3},
  [2286] = {.lex_state = 128, .external_lex_state = 2},
  [2287] = {.lex_state = 127, .external_lex_state = 3},
  [2288] = {.lex_state = 127, .external_lex_state = 4},
  [2289] = {.lex_state = 127, .external_lex_state = 3},
  [2290] = {.lex_state = 127, .external_lex_state = 3},
  [2291] = {.lex_state = 128, .external_lex_state = 5},
  [2292] = {.lex_state = 127, .external_lex_state = 3},
  [2293] = {.lex_state = 128, .external_lex_state = 5},
  [2294] = {.lex_state = 128, .external_lex_state = 5},
  [2295] = {.lex_state = 128, .external_lex_state = 5},
  [2296] = {.lex_state = 128, .external_lex_state = 5},
  [2297] = {.lex_state = 128, .external_lex_state = 5},
  [2298] = {.lex_state = 128, .external_lex_state = 5},
  [2299] = {.lex_state = 127, .external_lex_state = 3},
  [2300] = {.lex_state = 127, .external_lex_state = 3},
  [2301] = {.lex_state = 127, .external_lex_state = 4},
  [2302] = {.lex_state = 127, .external_lex_state = 3},
  [2303] = {.lex_state = 127, .external_lex_state = 4},
  [2304] = {.lex_state = 128, .external_lex_state = 5},
  [2305] = {.lex_state = 127, .external_lex_state = 4},
  [2306] = {.lex_state = 128, .external_lex_state = 2},
  [2307] = {.lex_state = 128, .external_lex_state = 2},
  [2308] = {.lex_state = 127, .external_lex_state = 4},
  [2309] = {.lex_state = 128, .external_lex_state = 2},
  [2310] = {.lex_state = 127, .external_lex_state = 4},
  [2311] = {.lex_state = 127, .external_lex_state = 4},
  [2312] = {.lex_state = 127, .external_lex_state = 4},
  [2313] = {.lex_state = 127, .external_lex_state = 3},
  [2314] = {.lex_state = 127, .external_lex_state = 4},
  [2315] = {.lex_state = 127, .external_lex_state = 4},
  [2316] = {.lex_state = 128, .external_lex_state = 5},
  [2317] = {.lex_state = 127, .external_lex_state = 4},
  [2318] = {.lex_state = 127, .external_lex_state = 3},
  [2319] = {.lex_state = 127, .external_lex_state = 4},
  [2320] = {.lex_state = 127, .external_lex_state = 4},
  [2321] = {.lex_state = 127, .external_lex_state = 3},
  [2322] = {.lex_state = 127, .external_lex_state = 4},
  [2323] = {.lex_state = 127, .external_lex_state = 3},
  [2324] = {.lex_state = 127, .external_lex_state = 4},
  [2325] = {.lex_state = 127, .external_lex_state = 3},
  [2326] = {.lex_state = 127, .external_lex_state = 4},
  [2327] = {.lex_state = 127, .external_lex_state = 3},
  [2328] = {.lex_state = 127, .external_lex_state = 3},
  [2329] = {.lex_state = 127, .external_lex_state = 3},
  [2330] = {.lex_state = 127, .external_lex_state = 4},
  [2331] = {.lex_state = 128, .external_lex_state = 5},
  [2332] = {.lex_state = 127, .external_lex_state = 3},
  [2333] = {.lex_state = 127, .external_lex_state = 4},
  [2334] = {.lex_state = 127, .external_lex_state = 4},
  [2335] = {.lex_state = 127, .external_lex_state = 4},
  [2336] = {.lex_state = 127, .external_lex_state = 3},
  [2337] = {.lex_state = 127, .external_lex_state = 3},
  [2338] = {.lex_state = 127, .external_lex_state = 3},
  [2339] = {.lex_state = 127, .external_lex_state = 3},
  [2340] = {.lex_state = 127, .external_lex_state = 3},
  [2341] = {.lex_state = 127, .external_lex_state = 3},
  [2342] = {.lex_state = 127, .external_lex_state = 3},
  [2343] = {.lex_state = 127, .external_lex_state = 3},
  [2344] = {.lex_state = 127, .external_lex_state = 3},
  [2345] = {.lex_state = 127, .external_lex_state = 3},
  [2346] = {.lex_state = 127, .external_lex_state = 4},
  [2347] = {.lex_state = 127, .external_lex_state = 3},
  [2348] = {.lex_state = 127, .external_lex_state = 3},
  [2349] = {.lex_state = 127, .external_lex_state = 3},
  [2350] = {.lex_state = 127, .external_lex_state = 4},
  [2351] = {.lex_state = 127, .external_lex_state = 4},
  [2352] = {.lex_state = 127, .external_lex_state = 3},
  [2353] = {.lex_state = 128, .external_lex_state = 5},
  [2354] = {.lex_state = 127, .external_lex_state = 4},
  [2355] = {.lex_state = 127, .external_lex_state = 3},
  [2356] = {.lex_state = 128, .external_lex_state = 5},
  [2357] = {.lex_state = 128, .external_lex_state = 2},
  [2358] = {.lex_state = 128, .external_lex_state = 2},
  [2359] = {.lex_state = 127, .external_lex_state = 3},
  [2360] = {.lex_state = 128, .external_lex_state = 5},
  [2361] = {.lex_state = 128, .external_lex_state = 5},
  [2362] = {.lex_state = 128, .external_lex_state = 5},
  [2363] = {.lex_state = 128, .external_lex_state = 5},
  [2364] = {.lex_state = 127, .external_lex_state = 4},
  [2365] = {.lex_state = 128, .external_lex_state = 5},
  [2366] = {.lex_state = 127, .external_lex_state = 4},
  [2367] = {.lex_state = 127, .external_lex_state = 3},
  [2368] = {.lex_state = 127, .external_lex_state = 3},
  [2369] = {.lex_state = 127, .external_lex_state = 3},
  [2370] = {.lex_state = 128, .external_lex_state = 2},
  [2371] = {.lex_state = 128, .external_lex_state = 5},
  [2372] = {.lex_state = 127, .external_lex_state = 4},
  [2373] = {.lex_state = 127, .external_lex_state = 3},
  [2374] = {.lex_state = 127, .external_lex_state = 3},
  [2375] = {.lex_state = 128, .external_lex_state = 5},
  [2376] = {.lex_state = 127, .external_lex_state = 3},
  [2377] = {.lex_state = 128, .external_lex_state = 5},
  [2378] = {.lex_state = 128, .external_lex_state = 2},
  [2379] = {.lex_state = 127, .external_lex_state = 4},
  [2380] = {.lex_state = 127, .external_lex_state = 4},
  [2381] = {.lex_state = 127, .external_lex_state = 3},
  [2382] = {.lex_state = 128, .external_lex_state = 2},
  [2383] = {.lex_state = 127, .external_lex_state = 3},
  [2384] = {.lex_state = 127, .external_lex_state = 3},
  [2385] = {.lex_state = 128, .external_lex_state = 2},
  [2386] = {.lex_state = 127, .external_lex_state = 4},
  [2387] = {.lex_state = 127, .external_lex_state = 3},
  [2388] = {.lex_state = 128, .external_lex_state = 5},
  [2389] = {.lex_state = 128, .external_lex_state = 5},
  [2390] = {.lex_state = 128, .external_lex_state = 5},
  [2391] = {.lex_state = 128, .external_lex_state = 5},
  [2392] = {.lex_state = 127, .external_lex_state = 4},
  [2393] = {.lex_state = 127, .external_lex_state = 4},
  [2394] = {.lex_state = 127, .external_lex_state = 3},
  [2395] = {.lex_state = 127, .external_lex_state = 3},
  [2396] = {.lex_state = 128, .external_lex_state = 5},
  [2397] = {.lex_state = 128, .external_lex_state = 5},
  [2398] = {.lex_state = 128, .external_lex_state = 5},
  [2399] = {.lex_state = 128, .external_lex_state = 5},
  [2400] = {.lex_state = 128, .external_lex_state = 2},
  [2401] = {.lex_state = 128, .external_lex_state = 2},
  [2402] = {.lex_state = 127, .external_lex_state = 3},
  [2403] = {.lex_state = 128, .external_lex_state = 2},
  [2404] = {.lex_state = 128, .external_lex_state = 5},
  [2405] = {.lex_state = 128, .external_lex_state = 5},
  [2406] = {.lex_state = 128, .external_lex_state = 5},
  [2407] = {.lex_state = 128, .external_lex_state = 5},
  [2408] = {.lex_state = 128, .external_lex_state = 5},
  [2409] = {.lex_state = 128, .external_lex_state = 5},
  [2410] = {.lex_state = 127, .external_lex_state = 4},
  [2411] = {.lex_state = 128, .external_lex_state = 5},
  [2412] = {.lex_state = 127, .external_lex_state = 3},
  [2413] = {.lex_state = 127, .external_lex_state = 4},
  [2414] = {.lex_state = 127, .external_lex_state = 3},
  [2415] = {.lex_state = 127, .external_lex_state = 3},
  [2416] = {.lex_state = 127, .external_lex_state = 3},
  [2417] = {.lex_state = 127, .external_lex_state = 3},
  [2418] = {.lex_state = 127, .external_lex_state = 3},
  [2419] = {.lex_state = 127, .external_lex_state = 3},
  [2420] = {.lex_state = 127, .external_lex_state = 3},
  [2421] = {.lex_state = 127, .external_lex_state = 3},
  [2422] = {.lex_state = 127, .external_lex_state = 3},
  [2423] = {.lex_state = 127, .external_lex_state = 3},
  [2424] = {.lex_state = 127, .external_lex_state = 3},
  [2425] = {.lex_state = 127, .external_lex_state = 3},
  [2426] = {.lex_state = 127, .external_lex_state = 3},
  [2427] = {.lex_state = 127, .external_lex_state = 3},
  [2428] = {.lex_state = 127, .external_lex_state = 3},
  [2429] = {.lex_state = 127, .external_lex_state = 3},
  [2430] = {.lex_state = 127, .external_lex_state = 3},
  [2431] = {.lex_state = 127, .external_lex_state = 3},
  [2432] = {.lex_state = 127, .external_lex_state = 3},
  [2433] = {.lex_state = 127, .external_lex_state = 3},
  [2434] = {.lex_state = 127, .external_lex_state = 3},
  [2435] = {.lex_state = 127, .external_lex_state = 3},
  [2436] = {.lex_state = 127, .external_lex_state = 3},
  [2437] = {.lex_state = 127, .external_lex_state = 3},
  [2438] = {.lex_state = 127, .external_lex_state = 3},
  [2439] = {.lex_state = 127, .external_lex_state = 3},
  [2440] = {.lex_state = 127, .external_lex_state = 3},
  [2441] = {.lex_state = 127, .external_lex_state = 3},
  [2442] = {.lex_state = 127, .external_lex_state = 3},
  [2443] = {.lex_state = 127, .external_lex_state = 4},
  [2444] = {.lex_state = 128, .external_lex_state = 2},
  [2445] = {.lex_state = 4, .external_lex_state = 3},
  [2446] = {.lex_state = 127, .external_lex_state = 3},
  [2447] = {.lex_state = 127, .external_lex_state = 3},
  [2448] = {.lex_state = 127, .external_lex_state = 3},
  [2449] = {.lex_state = 127, .external_lex_state = 3},
  [2450] = {.lex_state = 127, .external_lex_state = 3},
  [2451] = {.lex_state = 127, .external_lex_state = 3},
  [2452] = {.lex_state = 127, .external_lex_state = 3},
  [2453] = {.lex_state = 127, .external_lex_state = 3},
  [2454] = {.lex_state = 127, .external_lex_state = 3},
  [2455] = {.lex_state = 127, .external_lex_state = 3},
  [2456] = {.lex_state = 127, .external_lex_state = 3},
  [2457] = {.lex_state = 127, .external_lex_state = 3},
  [2458] = {.lex_state = 127, .external_lex_state = 3},
  [2459] = {.lex_state = 127, .external_lex_state = 3},
  [2460] = {.lex_state = 127, .external_lex_state = 3},
  [2461] = {.lex_state = 127, .external_lex_state = 3},
  [2462] = {.lex_state = 127, .external_lex_state = 3},
  [2463] = {.lex_state = 127, .external_lex_state = 3},
  [2464] = {.lex_state = 127, .external_lex_state = 3},
  [2465] = {.lex_state = 127, .external_lex_state = 3},
  [2466] = {.lex_state = 127, .external_lex_state = 3},
  [2467] = {.lex_state = 127, .external_lex_state = 3},
  [2468] = {.lex_state = 127, .external_lex_state = 3},
  [2469] = {.lex_state = 127, .external_lex_state = 3},
  [2470] = {.lex_state = 127, .external_lex_state = 3},
  [2471] = {.lex_state = 127, .external_lex_state = 3},
  [2472] = {.lex_state = 127, .external_lex_state = 3},
  [2473] = {.lex_state = 127, .external_lex_state = 3},
  [2474] = {.lex_state = 127, .external_lex_state = 3},
  [2475] = {.lex_state = 127, .external_lex_state = 3},
  [2476] = {.lex_state = 127, .external_lex_state = 3},
  [2477] = {.lex_state = 127, .external_lex_state = 4},
  [2478] = {.lex_state = 127, .external_lex_state = 3},
  [2479] = {.lex_state = 127, .external_lex_state = 3},
  [2480] = {.lex_state = 127, .external_lex_state = 3},
  [2481] = {.lex_state = 127, .external_lex_state = 3},
  [2482] = {.lex_state = 127, .external_lex_state = 3},
  [2483] = {.lex_state = 127, .external_lex_state = 3},
  [2484] = {.lex_state = 127, .external_lex_state = 3},
  [2485] = {.lex_state = 128, .external_lex_state = 2},
  [2486] = {.lex_state = 127, .external_lex_state = 3},
  [2487] = {.lex_state = 127, .external_lex_state = 3},
  [2488] = {.lex_state = 128, .external_lex_state = 2},
  [2489] = {.lex_state = 127, .external_lex_state = 3},
  [2490] = {.lex_state = 127, .external_lex_state = 3},
  [2491] = {.lex_state = 127, .external_lex_state = 3},
  [2492] = {.lex_state = 127, .external_lex_state = 3},
  [2493] = {.lex_state = 127, .external_lex_state = 3},
  [2494] = {.lex_state = 127, .external_lex_state = 3},
  [2495] = {.lex_state = 127, .external_lex_state = 3},
  [2496] = {.lex_state = 127, .external_lex_state = 3},
  [2497] = {.lex_state = 127, .external_lex_state = 3},
  [2498] = {.lex_state = 127, .external_lex_state = 3},
  [2499] = {.lex_state = 127, .external_lex_state = 3},
  [2500] = {.lex_state = 127, .external_lex_state = 3},
  [2501] = {.lex_state = 127, .external_lex_state = 3},
  [2502] = {.lex_state = 127, .external_lex_state = 3},
  [2503] = {.lex_state = 127, .external_lex_state = 3},
  [2504] = {.lex_state = 127, .external_lex_state = 3},
  [2505] = {.lex_state = 127, .external_lex_state = 3},
  [2506] = {.lex_state = 127, .external_lex_state = 3},
  [2507] = {.lex_state = 127, .external_lex_state = 3},
  [2508] = {.lex_state = 127, .external_lex_state = 3},
  [2509] = {.lex_state = 127, .external_lex_state = 3},
  [2510] = {.lex_state = 127, .external_lex_state = 3},
  [2511] = {.lex_state = 127, .external_lex_state = 3},
  [2512] = {.lex_state = 127, .external_lex_state = 3},
  [2513] = {.lex_state = 128, .external_lex_state = 5},
  [2514] = {.lex_state = 128, .external_lex_state = 5},
  [2515] = {.lex_state = 128, .external_lex_state = 5},
  [2516] = {.lex_state = 128, .external_lex_state = 5},
  [2517] = {.lex_state = 127, .external_lex_state = 3},
  [2518] = {.lex_state = 127, .external_lex_state = 3},
  [2519] = {.lex_state = 127, .external_lex_state = 4},
  [2520] = {.lex_state = 127, .external_lex_state = 3},
  [2521] = {.lex_state = 128, .external_lex_state = 2},
  [2522] = {.lex_state = 127, .external_lex_state = 3},
  [2523] = {.lex_state = 128, .external_lex_state = 5},
  [2524] = {.lex_state = 127, .external_lex_state = 3},
  [2525] = {.lex_state = 128, .external_lex_state = 5},
  [2526] = {.lex_state = 127, .external_lex_state = 3},
  [2527] = {.lex_state = 127, .external_lex_state = 3},
  [2528] = {.lex_state = 127, .external_lex_state = 3},
  [2529] = {.lex_state = 127, .external_lex_state = 3},
  [2530] = {.lex_state = 127, .external_lex_state = 3},
  [2531] = {.lex_state = 128, .external_lex_state = 2},
  [2532] = {.lex_state = 127, .external_lex_state = 3},
  [2533] = {.lex_state = 128, .external_lex_state = 2},
  [2534] = {.lex_state = 127, .external_lex_state = 3},
  [2535] = {.lex_state = 127, .external_lex_state = 3},
  [2536] = {.lex_state = 127, .external_lex_state = 3},
  [2537] = {.lex_state = 127, .external_lex_state = 3},
  [2538] = {.lex_state = 128, .external_lex_state = 2},
  [2539] = {.lex_state = 127, .external_lex_state = 3},
  [2540] = {.lex_state = 128, .external_lex_state = 5},
  [2541] = {.lex_state = 128, .external_lex_state = 5},
  [2542] = {.lex_state = 128, .external_lex_state = 5},
  [2543] = {.lex_state = 128, .external_lex_state = 5},
  [2544] = {.lex_state = 128, .external_lex_state = 2},
  [2545] = {.lex_state = 127, .external_lex_state = 3},
  [2546] = {.lex_state = 127, .external_lex_state = 3},
  [2547] = {.lex_state = 127, .external_lex_state = 3},
  [2548] = {.lex_state = 127, .external_lex_state = 3},
  [2549] = {.lex_state = 127, .external_lex_state = 3},
  [2550] = {.lex_state = 127, .external_lex_state = 3},
  [2551] = {.lex_state = 127, .external_lex_state = 3},
  [2552] = {.lex_state = 127, .external_lex_state = 3},
  [2553] = {.lex_state = 128, .external_lex_state = 5},
  [2554] = {.lex_state = 127, .external_lex_state = 3},
  [2555] = {.lex_state = 128, .external_lex_state = 2},
  [2556] = {.lex_state = 127, .external_lex_state = 3},
  [2557] = {.lex_state = 127, .external_lex_state = 3},
  [2558] = {.lex_state = 127, .external_lex_state = 3},
  [2559] = {.lex_state = 128, .external_lex_state = 5},
  [2560] = {.lex_state = 127, .external_lex_state = 3},
  [2561] = {.lex_state = 127, .external_lex_state = 3},
  [2562] = {.lex_state = 128, .external_lex_state = 5},
  [2563] = {.lex_state = 128, .external_lex_state = 2},
  [2564] = {.lex_state = 128, .external_lex_state = 5},
  [2565] = {.lex_state = 4, .external_lex_state = 3},
  [2566] = {.lex_state = 128, .external_lex_state = 5},
  [2567] = {.lex_state = 127, .external_lex_state = 3},
  [2568] = {.lex_state = 128, .external_lex_state = 2},
  [2569] = {.lex_state = 128, .external_lex_state = 2},
  [2570] = {.lex_state = 128, .external_lex_state = 2},
  [2571] = {.lex_state = 128, .external_lex_state = 2},
  [2572] = {.lex_state = 128, .external_lex_state = 5},
  [2573] = {.lex_state = 128, .external_lex_state = 2},
  [2574] = {.lex_state = 127, .external_lex_state = 3},
  [2575] = {.lex_state = 128, .external_lex_state = 5},
  [2576] = {.lex_state = 128, .external_lex_state = 5},
  [2577] = {.lex_state = 128, .external_lex_state = 5},
  [2578] = {.lex_state = 127, .external_lex_state = 3},
  [2579] = {.lex_state = 128, .external_lex_state = 5},
  [2580] = {.lex_state = 128, .external_lex_state = 5},
  [2581] = {.lex_state = 128, .external_lex_state = 5},
  [2582] = {.lex_state = 128, .external_lex_state = 5},
  [2583] = {.lex_state = 128, .external_lex_state = 2},
  [2584] = {.lex_state = 128, .external_lex_state = 5},
  [2585] = {.lex_state = 128, .external_lex_state = 2},
  [2586] = {.lex_state = 128, .external_lex_state = 5},
  [2587] = {.lex_state = 127, .external_lex_state = 3},
  [2588] = {.lex_state = 128, .external_lex_state = 2},
  [2589] = {.lex_state = 128, .external_lex_state = 2},
  [2590] = {.lex_state = 128, .external_lex_state = 5},
  [2591] = {.lex_state = 128, .external_lex_state = 2},
  [2592] = {.lex_state = 128, .external_lex_state = 2},
  [2593] = {.lex_state = 128, .external_lex_state = 5},
  [2594] = {.lex_state = 128, .external_lex_state = 5},
  [2595] = {.lex_state = 128, .external_lex_state = 2},
  [2596] = {.lex_state = 128, .external_lex_state = 2},
  [2597] = {.lex_state = 128, .external_lex_state = 2},
  [2598] = {.lex_state = 127, .external_lex_state = 3},
  [2599] = {.lex_state = 128, .external_lex_state = 2},
  [2600] = {.lex_state = 127, .external_lex_state = 3},
  [2601] = {.lex_state = 9, .external_lex_state = 5},
  [2602] = {.lex_state = 9, .external_lex_state = 5},
  [2603] = {.lex_state = 127, .external_lex_state = 3},
  [2604] = {.lex_state = 9, .external_lex_state = 5},
  [2605] = {.lex_state = 9, .external_lex_state = 5},
  [2606] = {.lex_state = 128, .external_lex_state = 2},
  [2607] = {.lex_state = 9, .external_lex_state = 5},
  [2608] = {.lex_state = 9, .external_lex_state = 5},
  [2609] = {.lex_state = 9, .external_lex_state = 5},
  [2610] = {.lex_state = 9, .external_lex_state = 5},
  [2611] = {.lex_state = 9, .external_lex_state = 5},
  [2612] = {.lex_state = 9, .external_lex_state = 5},
  [2613] = {.lex_state = 9, .external_lex_state = 5},
  [2614] = {.lex_state = 9, .external_lex_state = 5},
  [2615] = {.lex_state = 9, .external_lex_state = 5},
  [2616] = {.lex_state = 9, .external_lex_state = 5},
  [2617] = {.lex_state = 9, .external_lex_state = 5},
  [2618] = {.lex_state = 9, .external_lex_state = 5},
  [2619] = {.lex_state = 9, .external_lex_state = 5},
  [2620] = {.lex_state = 9, .external_lex_state = 5},
  [2621] = {.lex_state = 9, .external_lex_state = 5},
  [2622] = {.lex_state = 127, .external_lex_state = 3},
  [2623] = {.lex_state = 9, .external_lex_state = 5},
  [2624] = {.lex_state = 9, .external_lex_state = 5},
  [2625] = {.lex_state = 128, .external_lex_state = 2},
  [2626] = {.lex_state = 127, .external_lex_state = 3},
  [2627] = {.lex_state = 127, .external_lex_state = 3},
  [2628] = {.lex_state = 9, .external_lex_state = 5},
  [2629] = {.lex_state = 9, .external_lex_state = 5},
  [2630] = {.lex_state = 9, .external_lex_state = 5},
  [2631] = {.lex_state = 9, .external_lex_state = 5},
  [2632] = {.lex_state = 127, .external_lex_state = 3},
  [2633] = {.lex_state = 127, .external_lex_state = 3},
  [2634] = {.lex_state = 9, .external_lex_state = 5},
  [2635] = {.lex_state = 9, .external_lex_state = 5},
  [2636] = {.lex_state = 9, .external_lex_state = 5},
  [2637] = {.lex_state = 9, .external_lex_state = 5},
  [2638] = {.lex_state = 9, .external_lex_state = 5},
  [2639] = {.lex_state = 9, .external_lex_state = 5},
  [2640] = {.lex_state = 9, .external_lex_state = 5},
  [2641] = {.lex_state = 9, .external_lex_state = 5},
  [2642] = {.lex_state = 9, .external_lex_state = 5},
  [2643] = {.lex_state = 9, .external_lex_state = 5},
  [2644] = {.lex_state = 9, .external_lex_state = 5},
  [2645] = {.lex_state = 9, .external_lex_state = 5},
  [2646] = {.lex_state = 9, .external_lex_state = 5},
  [2647] = {.lex_state = 9, .external_lex_state = 5},
  [2648] = {.lex_state = 9, .external_lex_state = 5},
  [2649] = {.lex_state = 9, .external_lex_state = 5},
  [2650] = {.lex_state = 9, .external_lex_state = 5},
  [2651] = {.lex_state = 9, .external_lex_state = 5},
  [2652] = {.lex_state = 9, .external_lex_state = 5},
  [2653] = {.lex_state = 9, .external_lex_state = 5},
  [2654] = {.lex_state = 9, .external_lex_state = 5},
  [2655] = {.lex_state = 127, .external_lex_state = 3},
  [2656] = {.lex_state = 9, .external_lex_state = 5},
  [2657] = {.lex_state = 9, .external_lex_state = 5},
  [2658] = {.lex_state = 127, .external_lex_state = 3},
  [2659] = {.lex_state = 9, .external_lex_state = 5},
  [2660] = {.lex_state = 9, .external_lex_state = 5},
  [2661] = {.lex_state = 127, .external_lex_state = 3},
  [2662] = {.lex_state = 9, .external_lex_state = 5},
  [2663] = {.lex_state = 9, .external_lex_state = 5},
  [2664] = {.lex_state = 128, .external_lex_state = 2},
  [2665] = {.lex_state = 9, .external_lex_state = 2},
  [2666] = {.lex_state = 128, .external_lex_state = 2},
  [2667] = {.lex_state = 128, .external_lex_state = 2},
  [2668] = {.lex_state = 9, .external_lex_state = 2},
  [2669] = {.lex_state = 128, .external_lex_state = 2},
  [2670] = {.lex_state = 127, .external_lex_state = 3},
  [2671] = {.lex_state = 128, .external_lex_state = 2},
  [2672] = {.lex_state = 9, .external_lex_state = 2},
  [2673] = {.lex_state = 9, .external_lex_state = 2},
  [2674] = {.lex_state = 9, .external_lex_state = 2},
  [2675] = {.lex_state = 9, .external_lex_state = 2},
  [2676] = {.lex_state = 9, .external_lex_state = 2},
  [2677] = {.lex_state = 128, .external_lex_state = 2},
  [2678] = {.lex_state = 128, .external_lex_state = 2},
  [2679] = {.lex_state = 128, .external_lex_state = 2},
  [2680] = {.lex_state = 128, .external_lex_state = 2},
  [2681] = {.lex_state = 128, .external_lex_state = 2},
  [2682] = {.lex_state = 128, .external_lex_state = 2},
  [2683] = {.lex_state = 128, .external_lex_state = 2},
  [2684] = {.lex_state = 128, .external_lex_state = 2},
  [2685] = {.lex_state = 128, .external_lex_state = 2},
  [2686] = {.lex_state = 128, .external_lex_state = 2},
  [2687] = {.lex_state = 128, .external_lex_state = 2},
  [2688] = {.lex_state = 128, .external_lex_state = 2},
  [2689] = {.lex_state = 128, .external_lex_state = 2},
  [2690] = {.lex_state = 128, .external_lex_state = 2},
  [2691] = {.lex_state = 128, .external_lex_state = 2},
  [2692] = {.lex_state = 128, .external_lex_state = 2},
  [2693] = {.lex_state = 128, .external_lex_state = 2},
  [2694] = {.lex_state = 128, .external_lex_state = 2},
  [2695] = {.lex_state = 128, .external_lex_state = 2},
  [2696] = {.lex_state = 128, .external_lex_state = 2},
  [2697] = {.lex_state = 128, .external_lex_state = 2},
  [2698] = {.lex_state = 128, .external_lex_state = 2},
  [2699] = {.lex_state = 128, .external_lex_state = 2},
  [2700] = {.lex_state = 128, .external_lex_state = 2},
  [2701] = {.lex_state = 128, .external_lex_state = 2},
  [2702] = {.lex_state = 128, .external_lex_state = 2},
  [2703] = {.lex_state = 128, .external_lex_state = 2},
  [2704] = {.lex_state = 128, .external_lex_state = 2},
  [2705] = {.lex_state = 128, .external_lex_state = 2},
  [2706] = {.lex_state = 128, .external_lex_state = 2},
  [2707] = {.lex_state = 128, .external_lex_state = 2},
  [2708] = {.lex_state = 128, .external_lex_state = 2},
  [2709] = {.lex_state = 128, .external_lex_state = 2},
  [2710] = {.lex_state = 128, .external_lex_state = 2},
  [2711] = {.lex_state = 128, .external_lex_state = 2},
  [2712] = {.lex_state = 128, .external_lex_state = 2},
  [2713] = {.lex_state = 128, .external_lex_state = 2},
  [2714] = {.lex_state = 128, .external_lex_state = 2},
  [2715] = {.lex_state = 128, .external_lex_state = 2},
  [2716] = {.lex_state = 128, .external_lex_state = 2},
  [2717] = {.lex_state = 128, .external_lex_state = 2},
  [2718] = {.lex_state = 128, .external_lex_state = 2},
  [2719] = {.lex_state = 128, .external_lex_state = 2},
  [2720] = {.lex_state = 128, .external_lex_state = 2},
  [2721] = {.lex_state = 128, .external_lex_state = 2},
  [2722] = {.lex_state = 128, .external_lex_state = 2},
  [2723] = {.lex_state = 128, .external_lex_state = 2},
  [2724] = {.lex_state = 128, .external_lex_state = 2},
  [2725] = {.lex_state = 128, .external_lex_state = 2},
  [2726] = {.lex_state = 128, .external_lex_state = 2},
  [2727] = {.lex_state = 128, .external_lex_state = 2},
  [2728] = {.lex_state = 128, .external_lex_state = 2},
  [2729] = {.lex_state = 128, .external_lex_state = 2},
  [2730] = {.lex_state = 128, .external_lex_state = 2},
  [2731] = {.lex_state = 128, .external_lex_state = 2},
  [2732] = {.lex_state = 128, .external_lex_state = 2},
  [2733] = {.lex_state = 128, .external_lex_state = 2},
  [2734] = {.lex_state = 128, .external_lex_state = 2},
  [2735] = {.lex_state = 128, .external_lex_state = 2},
  [2736] = {.lex_state = 128, .external_lex_state = 2},
  [2737] = {.lex_state = 128, .external_lex_state = 2},
  [2738] = {.lex_state = 128, .external_lex_state = 2},
  [2739] = {.lex_state = 128, .external_lex_state = 2},
  [2740] = {.lex_state = 128, .external_lex_state = 2},
  [2741] = {.lex_state = 128, .external_lex_state = 2},
  [2742] = {.lex_state = 128, .external_lex_state = 2},
  [2743] = {.lex_state = 128, .external_lex_state = 2},
  [2744] = {.lex_state = 128, .external_lex_state = 2},
  [2745] = {.lex_state = 128, .external_lex_state = 2},
  [2746] = {.lex_state = 128, .external_lex_state = 2},
  [2747] = {.lex_state = 128, .external_lex_state = 2},
  [2748] = {.lex_state = 128, .external_lex_state = 2},
  [2749] = {.lex_state = 128, .external_lex_state = 2},
  [2750] = {.lex_state = 128, .external_lex_state = 2},
  [2751] = {.lex_state = 128, .external_lex_state = 2},
  [2752] = {.lex_state = 128, .external_lex_state = 2},
  [2753] = {.lex_state = 128, .external_lex_state = 2},
  [2754] = {.lex_state = 128, .external_lex_state = 2},
  [2755] = {.lex_state = 128, .external_lex_state = 2},
  [2756] = {.lex_state = 128, .external_lex_state = 2},
  [2757] = {.lex_state = 128, .external_lex_state = 2},
  [2758] = {.lex_state = 128, .external_lex_state = 2},
  [2759] = {.lex_state = 128, .external_lex_state = 2},
  [2760] = {.lex_state = 128, .external_lex_state = 2},
  [2761] = {.lex_state = 128, .external_lex_state = 2},
  [2762] = {.lex_state = 128, .external_lex_state = 2},
  [2763] = {.lex_state = 128, .external_lex_state = 2},
  [2764] = {.lex_state = 128, .external_lex_state = 2},
  [2765] = {.lex_state = 128, .external_lex_state = 2},
  [2766] = {.lex_state = 128, .external_lex_state = 2},
  [2767] = {.lex_state = 128, .external_lex_state = 2},
  [2768] = {.lex_state = 128, .external_lex_state = 2},
  [2769] = {.lex_state = 128, .external_lex_state = 2},
  [2770] = {.lex_state = 128, .external_lex_state = 2},
  [2771] = {.lex_state = 128, .external_lex_state = 2},
  [2772] = {.lex_state = 128, .external_lex_state = 2},
  [2773] = {.lex_state = 128, .external_lex_state = 2},
  [2774] = {.lex_state = 128, .external_lex_state = 2},
  [2775] = {.lex_state = 128, .external_lex_state = 2},
  [2776] = {.lex_state = 128, .external_lex_state = 2},
  [2777] = {.lex_state = 128, .external_lex_state = 2},
  [2778] = {.lex_state = 128, .external_lex_state = 2},
  [2779] = {.lex_state = 128, .external_lex_state = 2},
  [2780] = {.lex_state = 128, .external_lex_state = 2},
  [2781] = {.lex_state = 128, .external_lex_state = 2},
  [2782] = {.lex_state = 128, .external_lex_state = 2},
  [2783] = {.lex_state = 128, .external_lex_state = 2},
  [2784] = {.lex_state = 128, .external_lex_state = 2},
  [2785] = {.lex_state = 128, .external_lex_state = 2},
  [2786] = {.lex_state = 128, .external_lex_state = 2},
  [2787] = {.lex_state = 128, .external_lex_state = 2},
  [2788] = {.lex_state = 128, .external_lex_state = 2},
  [2789] = {.lex_state = 128, .external_lex_state = 2},
  [2790] = {.lex_state = 128, .external_lex_state = 2},
  [2791] = {.lex_state = 128, .external_lex_state = 2},
  [2792] = {.lex_state = 128, .external_lex_state = 2},
  [2793] = {.lex_state = 128, .external_lex_state = 2},
  [2794] = {.lex_state = 128, .external_lex_state = 2},
  [2795] = {.lex_state = 128, .external_lex_state = 2},
  [2796] = {.lex_state = 128, .external_lex_state = 2},
  [2797] = {.lex_state = 128, .external_lex_state = 2},
  [2798] = {.lex_state = 128, .external_lex_state = 2},
  [2799] = {.lex_state = 128, .external_lex_state = 2},
  [2800] = {.lex_state = 128, .external_lex_state = 2},
  [2801] = {.lex_state = 128, .external_lex_state = 2},
  [2802] = {.lex_state = 128, .external_lex_state = 2},
  [2803] = {.lex_state = 128, .external_lex_state = 2},
  [2804] = {.lex_state = 128, .external_lex_state = 2},
  [2805] = {.lex_state = 128, .external_lex_state = 2},
  [2806] = {.lex_state = 128, .external_lex_state = 2},
  [2807] = {.lex_state = 128, .external_lex_state = 2},
  [2808] = {.lex_state = 128, .external_lex_state = 2},
  [2809] = {.lex_state = 128, .external_lex_state = 2},
  [2810] = {.lex_state = 128, .external_lex_state = 2},
  [2811] = {.lex_state = 128, .external_lex_state = 2},
  [2812] = {.lex_state = 128, .external_lex_state = 2},
  [2813] = {.lex_state = 128, .external_lex_state = 2},
  [2814] = {.lex_state = 128, .external_lex_state = 2},
  [2815] = {.lex_state = 128, .external_lex_state = 2},
  [2816] = {.lex_state = 128, .external_lex_state = 2},
  [2817] = {.lex_state = 128, .external_lex_state = 2},
  [2818] = {.lex_state = 128, .external_lex_state = 2},
  [2819] = {.lex_state = 128, .external_lex_state = 2},
  [2820] = {.lex_state = 128, .external_lex_state = 2},
  [2821] = {.lex_state = 128, .external_lex_state = 2},
  [2822] = {.lex_state = 128, .external_lex_state = 2},
  [2823] = {.lex_state = 128, .external_lex_state = 2},
  [2824] = {.lex_state = 128, .external_lex_state = 2},
  [2825] = {.lex_state = 128, .external_lex_state = 2},
  [2826] = {.lex_state = 128, .external_lex_state = 2},
  [2827] = {.lex_state = 128, .external_lex_state = 2},
  [2828] = {.lex_state = 128, .external_lex_state = 2},
  [2829] = {.lex_state = 7, .external_lex_state = 2},
  [2830] = {.lex_state = 7, .external_lex_state = 2},
  [2831] = {.lex_state = 7, .external_lex_state = 2},
  [2832] = {.lex_state = 7, .external_lex_state = 2},
  [2833] = {.lex_state = 7, .external_lex_state = 2},
  [2834] = {.lex_state = 7, .external_lex_state = 2},
  [2835] = {.lex_state = 7, .external_lex_state = 2},
  [2836] = {.lex_state = 7, .external_lex_state = 2},
  [2837] = {.lex_state = 7, .external_lex_state = 2},
  [2838] = {.lex_state = 7, .external_lex_state = 2},
  [2839] = {.lex_state = 7, .external_lex_state = 2},
  [2840] = {.lex_state = 7, .external_lex_state = 2},
  [2841] = {.lex_state = 7, .external_lex_state = 2},
  [2842] = {.lex_state = 7, .external_lex_state = 2},
  [2843] = {.lex_state = 7, .external_lex_state = 2},
  [2844] = {.lex_state = 7, .external_lex_state = 2},
  [2845] = {.lex_state = 7, .external_lex_state = 2},
  [2846] = {.lex_state = 7, .external_lex_state = 2},
  [2847] = {.lex_state = 7, .external_lex_state = 2},
  [2848] = {.lex_state = 7, .external_lex_state = 2},
  [2849] = {.lex_state = 7, .external_lex_state = 2},
  [2850] = {.lex_state = 7, .external_lex_state = 2},
  [2851] = {.lex_state = 7, .external_lex_state = 2},
  [2852] = {.lex_state = 7, .external_lex_state = 2},
  [2853] = {.lex_state = 7, .external_lex_state = 2},
  [2854] = {.lex_state = 7, .external_lex_state = 2},
  [2855] = {.lex_state = 7, .external_lex_state = 2},
  [2856] = {.lex_state = 7, .external_lex_state = 2},
  [2857] = {.lex_state = 7, .external_lex_state = 2},
  [2858] = {.lex_state = 7, .external_lex_state = 2},
  [2859] = {.lex_state = 7, .external_lex_state = 2},
  [2860] = {.lex_state = 7, .external_lex_state = 2},
  [2861] = {.lex_state = 7, .external_lex_state = 2},
  [2862] = {.lex_state = 7, .external_lex_state = 2},
  [2863] = {.lex_state = 7, .external_lex_state = 2},
  [2864] = {.lex_state = 7, .external_lex_state = 2},
  [2865] = {.lex_state = 7, .external_lex_state = 2},
  [2866] = {.lex_state = 128, .external_lex_state = 5},
  [2867] = {.lex_state = 20, .external_lex_state = 2},
  [2868] = {.lex_state = 20, .external_lex_state = 2},
  [2869] = {.lex_state = 128, .external_lex_state = 2},
  [2870] = {.lex_state = 128, .external_lex_state = 5},
  [2871] = {.lex_state = 128, .external_lex_state = 2},
  [2872] = {.lex_state = 7, .external_lex_state = 2},
  [2873] = {.lex_state = 7, .external_lex_state = 2},
  [2874] = {.lex_state = 128, .external_lex_state = 2},
  [2875] = {.lex_state = 128, .external_lex_state = 2},
  [2876] = {.lex_state = 7, .external_lex_state = 2},
  [2877] = {.lex_state = 128, .external_lex_state = 2},
  [2878] = {.lex_state = 128, .external_lex_state = 2},
  [2879] = {.lex_state = 7, .external_lex_state = 2},
  [2880] = {.lex_state = 7, .external_lex_state = 2},
  [2881] = {.lex_state = 128, .external_lex_state = 2},
  [2882] = {.lex_state = 128, .external_lex_state = 2},
  [2883] = {.lex_state = 7, .external_lex_state = 5},
  [2884] = {.lex_state = 7, .external_lex_state = 5},
  [2885] = {.lex_state = 128, .external_lex_state = 2},
  [2886] = {.lex_state = 128, .external_lex_state = 2},
  [2887] = {.lex_state = 7, .external_lex_state = 5},
  [2888] = {.lex_state = 128, .external_lex_state = 2},
  [2889] = {.lex_state = 7, .external_lex_state = 2},
  [2890] = {.lex_state = 128, .external_lex_state = 2},
  [2891] = {.lex_state = 128, .external_lex_state = 2},
  [2892] = {.lex_state = 128, .external_lex_state = 2},
  [2893] = {.lex_state = 128, .external_lex_state = 2},
  [2894] = {.lex_state = 128, .external_lex_state = 2},
  [2895] = {.lex_state = 128, .external_lex_state = 2},
  [2896] = {.lex_state = 128, .external_lex_state = 2},
  [2897] = {.lex_state = 128, .external_lex_state = 2},
  [2898] = {.lex_state = 128, .external_lex_state = 2},
  [2899] = {.lex_state = 7, .external_lex_state = 5},
  [2900] = {.lex_state = 128, .external_lex_state = 2},
  [2901] = {.lex_state = 7, .external_lex_state = 5},
  [2902] = {.lex_state = 2, .external_lex_state = 2},
  [2903] = {.lex_state = 128, .external_lex_state = 2},
  [2904] = {.lex_state = 7, .external_lex_state = 5},
  [2905] = {.lex_state = 7, .external_lex_state = 5},
  [2906] = {.lex_state = 7, .external_lex_state = 5},
  [2907] = {.lex_state = 7, .external_lex_state = 5},
  [2908] = {.lex_state = 128, .external_lex_state = 2},
  [2909] = {.lex_state = 128, .external_lex_state = 2},
  [2910] = {.lex_state = 2, .external_lex_state = 2},
  [2911] = {.lex_state = 128, .external_lex_state = 2},
  [2912] = {.lex_state = 128, .external_lex_state = 2},
  [2913] = {.lex_state = 128, .external_lex_state = 2},
  [2914] = {.lex_state = 128, .external_lex_state = 2},
  [2915] = {.lex_state = 128, .external_lex_state = 2},
  [2916] = {.lex_state = 7, .external_lex_state = 5},
  [2917] = {.lex_state = 128, .external_lex_state = 2},
  [2918] = {.lex_state = 7, .external_lex_state = 5},
  [2919] = {.lex_state = 128, .external_lex_state = 2},
  [2920] = {.lex_state = 7, .external_lex_state = 5},
  [2921] = {.lex_state = 7, .external_lex_state = 5},
  [2922] = {.lex_state = 128, .external_lex_state = 2},
  [2923] = {.lex_state = 2, .external_lex_state = 2},
  [2924] = {.lex_state = 7, .external_lex_state = 5},
  [2925] = {.lex_state = 7, .external_lex_state = 5},
  [2926] = {.lex_state = 128, .external_lex_state = 2},
  [2927] = {.lex_state = 128, .external_lex_state = 2},
  [2928] = {.lex_state = 7, .external_lex_state = 5},
  [2929] = {.lex_state = 7, .external_lex_state = 5},
  [2930] = {.lex_state = 7, .external_lex_state = 5},
  [2931] = {.lex_state = 128, .external_lex_state = 2},
  [2932] = {.lex_state = 128, .external_lex_state = 2},
  [2933] = {.lex_state = 128, .external_lex_state = 2},
  [2934] = {.lex_state = 7, .external_lex_state = 5},
  [2935] = {.lex_state = 128, .external_lex_state = 2},
  [2936] = {.lex_state = 128, .external_lex_state = 2},
  [2937] = {.lex_state = 128, .external_lex_state = 2},
  [2938] = {.lex_state = 128, .external_lex_state = 2},
  [2939] = {.lex_state = 128, .external_lex_state = 2},
  [2940] = {.lex_state = 128, .external_lex_state = 2},
  [2941] = {.lex_state = 7, .external_lex_state = 5},
  [2942] = {.lex_state = 7, .external_lex_state = 5},
  [2943] = {.lex_state = 2, .external_lex_state = 2},
  [2944] = {.lex_state = 7, .external_lex_state = 5},
  [2945] = {.lex_state = 7, .external_lex_state = 5},
  [2946] = {.lex_state = 7, .external_lex_state = 6},
  [2947] = {.lex_state = 7, .external_lex_state = 6},
  [2948] = {.lex_state = 7, .external_lex_state = 6},
  [2949] = {.lex_state = 128, .external_lex_state = 2},
  [2950] = {.lex_state = 128, .external_lex_state = 2},
  [2951] = {.lex_state = 7, .external_lex_state = 5},
  [2952] = {.lex_state = 128, .external_lex_state = 2},
  [2953] = {.lex_state = 7, .external_lex_state = 5},
  [2954] = {.lex_state = 2, .external_lex_state = 2},
  [2955] = {.lex_state = 128, .external_lex_state = 2},
  [2956] = {.lex_state = 128, .external_lex_state = 2},
  [2957] = {.lex_state = 128, .external_lex_state = 2},
  [2958] = {.lex_state = 128, .external_lex_state = 2},
  [2959] = {.lex_state = 128, .external_lex_state = 2},
  [2960] = {.lex_state = 7, .external_lex_state = 5},
  [2961] = {.lex_state = 7, .external_lex_state = 5},
  [2962] = {.lex_state = 7, .external_lex_state = 5},
  [2963] = {.lex_state = 128, .external_lex_state = 2},
  [2964] = {.lex_state = 2, .external_lex_state = 2},
  [2965] = {.lex_state = 7, .external_lex_state = 5},
  [2966] = {.lex_state = 7, .external_lex_state = 5},
  [2967] = {.lex_state = 7, .external_lex_state = 5},
  [2968] = {.lex_state = 7, .external_lex_state = 5},
  [2969] = {.lex_state = 2, .external_lex_state = 2},
  [2970] = {.lex_state = 128, .external_lex_state = 2},
  [2971] = {.lex_state = 7, .external_lex_state = 5},
  [2972] = {.lex_state = 128, .external_lex_state = 2},
  [2973] = {.lex_state = 128, .external_lex_state = 2},
  [2974] = {.lex_state = 7, .external_lex_state = 5},
  [2975] = {.lex_state = 7, .external_lex_state = 5},
  [2976] = {.lex_state = 128, .external_lex_state = 2},
  [2977] = {.lex_state = 128, .external_lex_state = 2},
  [2978] = {.lex_state = 128, .external_lex_state = 5},
  [2979] = {.lex_state = 7, .external_lex_state = 5},
  [2980] = {.lex_state = 128, .external_lex_state = 2},
  [2981] = {.lex_state = 128, .external_lex_state = 2},
  [2982] = {.lex_state = 128, .external_lex_state = 2},
  [2983] = {.lex_state = 128, .external_lex_state = 2},
  [2984] = {.lex_state = 128, .external_lex_state = 2},
  [2985] = {.lex_state = 128, .external_lex_state = 2},
  [2986] = {.lex_state = 128, .external_lex_state = 2},
  [2987] = {.lex_state = 128, .external_lex_state = 2},
  [2988] = {.lex_state = 128, .external_lex_state = 2},
  [2989] = {.lex_state = 128, .external_lex_state = 2},
  [2990] = {.lex_state = 2, .external_lex_state = 2},
  [2991] = {.lex_state = 7, .external_lex_state = 5},
  [2992] = {.lex_state = 128, .external_lex_state = 2},
  [2993] = {.lex_state = 128, .external_lex_state = 2},
  [2994] = {.lex_state = 128, .external_lex_state = 2},
  [2995] = {.lex_state = 128, .external_lex_state = 2},
  [2996] = {.lex_state = 2, .external_lex_state = 2},
  [2997] = {.lex_state = 128, .external_lex_state = 2},
  [2998] = {.lex_state = 128, .external_lex_state = 2},
  [2999] = {.lex_state = 128, .external_lex_state = 2},
  [3000] = {.lex_state = 128, .external_lex_state = 5},
  [3001] = {.lex_state = 128, .external_lex_state = 2},
  [3002] = {.lex_state = 128, .external_lex_state = 2},
  [3003] = {.lex_state = 128, .external_lex_state = 5},
  [3004] = {.lex_state = 128, .external_lex_state = 5},
  [3005] = {.lex_state = 128, .external_lex_state = 5},
  [3006] = {.lex_state = 128, .external_lex_state = 5},
  [3007] = {.lex_state = 128, .external_lex_state = 5},
  [3008] = {.lex_state = 128, .external_lex_state = 5},
  [3009] = {.lex_state = 128, .external_lex_state = 5},
  [3010] = {.lex_state = 128, .external_lex_state = 5},
  [3011] = {.lex_state = 128, .external_lex_state = 5},
  [3012] = {.lex_state = 128, .external_lex_state = 5},
  [3013] = {.lex_state = 128, .external_lex_state = 2},
  [3014] = {.lex_state = 128, .external_lex_state = 5},
  [3015] = {.lex_state = 128, .external_lex_state = 5},
  [3016] = {.lex_state = 128, .external_lex_state = 5},
  [3017] = {.lex_state = 128, .external_lex_state = 5},
  [3018] = {.lex_state = 128, .external_lex_state = 2},
  [3019] = {.lex_state = 128, .external_lex_state = 2},
  [3020] = {.lex_state = 128, .external_lex_state = 5},
  [3021] = {.lex_state = 128, .external_lex_state = 5},
  [3022] = {.lex_state = 128, .external_lex_state = 5},
  [3023] = {.lex_state = 128, .external_lex_state = 5},
  [3024] = {.lex_state = 128, .external_lex_state = 5},
  [3025] = {.lex_state = 20, .external_lex_state = 2},
  [3026] = {.lex_state = 128, .external_lex_state = 5},
  [3027] = {.lex_state = 128, .external_lex_state = 5},
  [3028] = {.lex_state = 128, .external_lex_state = 5},
  [3029] = {.lex_state = 128, .external_lex_state = 5},
  [3030] = {.lex_state = 128, .external_lex_state = 2},
  [3031] = {.lex_state = 128, .external_lex_state = 5},
  [3032] = {.lex_state = 128, .external_lex_state = 5},
  [3033] = {.lex_state = 128, .external_lex_state = 5},
  [3034] = {.lex_state = 128, .external_lex_state = 5},
  [3035] = {.lex_state = 128, .external_lex_state = 2},
  [3036] = {.lex_state = 128, .external_lex_state = 2},
  [3037] = {.lex_state = 128, .external_lex_state = 2},
  [3038] = {.lex_state = 128, .external_lex_state = 2},
  [3039] = {.lex_state = 128, .external_lex_state = 5},
  [3040] = {.lex_state = 128, .external_lex_state = 5},
  [3041] = {.lex_state = 128, .external_lex_state = 2},
  [3042] = {.lex_state = 7, .external_lex_state = 6},
  [3043] = {.lex_state = 7, .external_lex_state = 5},
  [3044] = {.lex_state = 128, .external_lex_state = 5},
  [3045] = {.lex_state = 7, .external_lex_state = 6},
  [3046] = {.lex_state = 7, .external_lex_state = 5},
  [3047] = {.lex_state = 7, .external_lex_state = 5},
  [3048] = {.lex_state = 128, .external_lex_state = 5},
  [3049] = {.lex_state = 7, .external_lex_state = 6},
  [3050] = {.lex_state = 7, .external_lex_state = 6},
  [3051] = {.lex_state = 7, .external_lex_state = 6},
  [3052] = {.lex_state = 20, .external_lex_state = 2},
  [3053] = {.lex_state = 128, .external_lex_state = 5},
  [3054] = {.lex_state = 128, .external_lex_state = 5},
  [3055] = {.lex_state = 128, .external_lex_state = 5},
  [3056] = {.lex_state = 7, .external_lex_state = 6},
  [3057] = {.lex_state = 7, .external_lex_state = 6},
  [3058] = {.lex_state = 128, .external_lex_state = 2},
  [3059] = {.lex_state = 7, .external_lex_state = 6},
  [3060] = {.lex_state = 128, .external_lex_state = 5},
  [3061] = {.lex_state = 128, .external_lex_state = 2},
  [3062] = {.lex_state = 128, .external_lex_state = 5},
  [3063] = {.lex_state = 128, .external_lex_state = 2},
  [3064] = {.lex_state = 128, .external_lex_state = 2},
  [3065] = {.lex_state = 128, .external_lex_state = 5},
  [3066] = {.lex_state = 128, .external_lex_state = 2},
  [3067] = {.lex_state = 128, .external_lex_state = 2},
  [3068] = {.lex_state = 128, .external_lex_state = 2},
  [3069] = {.lex_state = 128, .external_lex_state = 5},
  [3070] = {.lex_state = 128, .external_lex_state = 5},
  [3071] = {.lex_state = 7, .external_lex_state = 5},
  [3072] = {.lex_state = 7, .external_lex_state = 6},
  [3073] = {.lex_state = 128, .external_lex_state = 5},
  [3074] = {.lex_state = 20, .external_lex_state = 2},
  [3075] = {.lex_state = 128, .external_lex_state = 5},
  [3076] = {.lex_state = 7, .external_lex_state = 6},
  [3077] = {.lex_state = 7, .external_lex_state = 6},
  [3078] = {.lex_state = 7, .external_lex_state = 5},
  [3079] = {.lex_state = 7, .external_lex_state = 5},
  [3080] = {.lex_state = 128, .external_lex_state = 5},
  [3081] = {.lex_state = 128, .external_lex_state = 5},
  [3082] = {.lex_state = 128, .external_lex_state = 2},
  [3083] = {.lex_state = 128, .external_lex_state = 5},
  [3084] = {.lex_state = 128, .external_lex_state = 6},
  [3085] = {.lex_state = 7, .external_lex_state = 6},
  [3086] = {.lex_state = 7, .external_lex_state = 6},
  [3087] = {.lex_state = 7, .external_lex_state = 6},
  [3088] = {.lex_state = 7, .external_lex_state = 6},
  [3089] = {.lex_state = 7, .external_lex_state = 6},
  [3090] = {.lex_state = 7, .external_lex_state = 6},
  [3091] = {.lex_state = 7, .external_lex_state = 6},
  [3092] = {.lex_state = 7, .external_lex_state = 6},
  [3093] = {.lex_state = 7, .external_lex_state = 6},
  [3094] = {.lex_state = 7, .external_lex_state = 6},
  [3095] = {.lex_state = 7, .external_lex_state = 6},
  [3096] = {.lex_state = 7, .external_lex_state = 6},
  [3097] = {.lex_state = 7, .external_lex_state = 6},
  [3098] = {.lex_state = 7, .external_lex_state = 6},
  [3099] = {.lex_state = 7, .external_lex_state = 5},
  [3100] = {.lex_state = 128, .external_lex_state = 5},
  [3101] = {.lex_state = 7, .external_lex_state = 6},
  [3102] = {.lex_state = 128, .external_lex_state = 5},
  [3103] = {.lex_state = 7, .external_lex_state = 6},
  [3104] = {.lex_state = 7, .external_lex_state = 6},
  [3105] = {.lex_state = 7, .external_lex_state = 6},
  [3106] = {.lex_state = 7, .external_lex_state = 6},
  [3107] = {.lex_state = 7, .external_lex_state = 6},
  [3108] = {.lex_state = 7, .external_lex_state = 6},
  [3109] = {.lex_state = 7, .external_lex_state = 6},
  [3110] = {.lex_state = 128, .external_lex_state = 5},
  [3111] = {.lex_state = 128, .external_lex_state = 5},
  [3112] = {.lex_state = 128, .external_lex_state = 2},
  [3113] = {.lex_state = 7, .external_lex_state = 6},
  [3114] = {.lex_state = 7, .external_lex_state = 5},
  [3115] = {.lex_state = 128, .external_lex_state = 2},
  [3116] = {.lex_state = 128, .external_lex_state = 5},
  [3117] = {.lex_state = 20, .external_lex_state = 2},
  [3118] = {.lex_state = 128, .external_lex_state = 5},
  [3119] = {.lex_state = 128, .external_lex_state = 5},
  [3120] = {.lex_state = 128, .external_lex_state = 5},
  [3121] = {.lex_state = 128, .external_lex_state = 5},
  [3122] = {.lex_state = 128, .external_lex_state = 5},
  [3123] = {.lex_state = 128, .external_lex_state = 5},
  [3124] = {.lex_state = 128, .external_lex_state = 5},
  [3125] = {.lex_state = 20, .external_lex_state = 2},
  [3126] = {.lex_state = 128, .external_lex_state = 5},
  [3127] = {.lex_state = 128, .external_lex_state = 6},
  [3128] = {.lex_state = 128, .external_lex_state = 6},
  [3129] = {.lex_state = 128, .external_lex_state = 5},
  [3130] = {.lex_state = 128, .external_lex_state = 5},
  [3131] = {.lex_state = 128, .external_lex_state = 5},
  [3132] = {.lex_state = 128, .external_lex_state = 5},
  [3133] = {.lex_state = 128, .external_lex_state = 5},
  [3134] = {.lex_state = 128, .external_lex_state = 5},
  [3135] = {.lex_state = 128, .external_lex_state = 5},
  [3136] = {.lex_state = 128, .external_lex_state = 5},
  [3137] = {.lex_state = 128, .external_lex_state = 5},
  [3138] = {.lex_state = 128, .external_lex_state = 5},
  [3139] = {.lex_state = 20, .external_lex_state = 2},
  [3140] = {.lex_state = 128, .external_lex_state = 5},
  [3141] = {.lex_state = 128, .external_lex_state = 5},
  [3142] = {.lex_state = 128, .external_lex_state = 5},
  [3143] = {.lex_state = 128, .external_lex_state = 5},
  [3144] = {.lex_state = 128, .external_lex_state = 5},
  [3145] = {.lex_state = 128, .external_lex_state = 5},
  [3146] = {.lex_state = 128, .external_lex_state = 5},
  [3147] = {.lex_state = 128, .external_lex_state = 5},
  [3148] = {.lex_state = 128, .external_lex_state = 5},
  [3149] = {.lex_state = 128, .external_lex_state = 5},
  [3150] = {.lex_state = 128, .external_lex_state = 5},
  [3151] = {.lex_state = 128, .external_lex_state = 5},
  [3152] = {.lex_state = 128, .external_lex_state = 5},
  [3153] = {.lex_state = 128, .external_lex_state = 2},
  [3154] = {.lex_state = 128, .external_lex_state = 5},
  [3155] = {.lex_state = 128, .external_lex_state = 2},
  [3156] = {.lex_state = 128, .external_lex_state = 5},
  [3157] = {.lex_state = 128, .external_lex_state = 2},
  [3158] = {.lex_state = 128, .external_lex_state = 5},
  [3159] = {.lex_state = 128, .external_lex_state = 5},
  [3160] = {.lex_state = 128, .external_lex_state = 5},
  [3161] = {.lex_state = 128, .external_lex_state = 5},
  [3162] = {.lex_state = 128, .external_lex_state = 5},
  [3163] = {.lex_state = 128, .external_lex_state = 5},
  [3164] = {.lex_state = 7, .external_lex_state = 2},
  [3165] = {.lex_state = 7, .external_lex_state = 2},
  [3166] = {.lex_state = 7, .external_lex_state = 2},
  [3167] = {.lex_state = 128, .external_lex_state = 5},
  [3168] = {.lex_state = 128, .external_lex_state = 5},
  [3169] = {.lex_state = 128, .external_lex_state = 5},
  [3170] = {.lex_state = 20, .external_lex_state = 2},
  [3171] = {.lex_state = 128, .external_lex_state = 5},
  [3172] = {.lex_state = 128, .external_lex_state = 5},
  [3173] = {.lex_state = 128, .external_lex_state = 5},
  [3174] = {.lex_state = 128, .external_lex_state = 5},
  [3175] = {.lex_state = 128, .external_lex_state = 5},
  [3176] = {.lex_state = 128, .external_lex_state = 5},
  [3177] = {.lex_state = 128, .external_lex_state = 5},
  [3178] = {.lex_state = 128, .external_lex_state = 5},
  [3179] = {.lex_state = 128, .external_lex_state = 5},
  [3180] = {.lex_state = 128, .external_lex_state = 5},
  [3181] = {.lex_state = 128, .external_lex_state = 6},
  [3182] = {.lex_state = 18, .external_lex_state = 7},
  [3183] = {.lex_state = 128, .external_lex_state = 6},
  [3184] = {.lex_state = 128, .external_lex_state = 5},
  [3185] = {.lex_state = 18, .external_lex_state = 7},
  [3186] = {.lex_state = 7, .external_lex_state = 6},
  [3187] = {.lex_state = 7, .external_lex_state = 6},
  [3188] = {.lex_state = 128, .external_lex_state = 5},
  [3189] = {.lex_state = 128, .external_lex_state = 5},
  [3190] = {.lex_state = 7, .external_lex_state = 6},
  [3191] = {.lex_state = 128, .external_lex_state = 6},
  [3192] = {.lex_state = 128, .external_lex_state = 5},
  [3193] = {.lex_state = 128, .external_lex_state = 5},
  [3194] = {.lex_state = 128, .external_lex_state = 5},
  [3195] = {.lex_state = 128, .external_lex_state = 5},
  [3196] = {.lex_state = 128, .external_lex_state = 2},
  [3197] = {.lex_state = 128, .external_lex_state = 5},
  [3198] = {.lex_state = 128, .external_lex_state = 5},
  [3199] = {.lex_state = 18, .external_lex_state = 7},
  [3200] = {.lex_state = 128, .external_lex_state = 5},
  [3201] = {.lex_state = 128, .external_lex_state = 5},
  [3202] = {.lex_state = 128, .external_lex_state = 5},
  [3203] = {.lex_state = 128, .external_lex_state = 5},
  [3204] = {.lex_state = 128, .external_lex_state = 5},
  [3205] = {.lex_state = 7, .external_lex_state = 6},
  [3206] = {.lex_state = 128, .external_lex_state = 5},
  [3207] = {.lex_state = 128, .external_lex_state = 5},
  [3208] = {.lex_state = 7, .external_lex_state = 6},
  [3209] = {.lex_state = 128, .external_lex_state = 5},
  [3210] = {.lex_state = 128, .external_lex_state = 5},
  [3211] = {.lex_state = 128, .external_lex_state = 5},
  [3212] = {.lex_state = 7, .external_lex_state = 6},
  [3213] = {.lex_state = 128, .external_lex_state = 5},
  [3214] = {.lex_state = 128, .external_lex_state = 5},
  [3215] = {.lex_state = 128, .external_lex_state = 5},
  [3216] = {.lex_state = 18, .external_lex_state = 7},
  [3217] = {.lex_state = 128, .external_lex_state = 5},
  [3218] = {.lex_state = 128, .external_lex_state = 5},
  [3219] = {.lex_state = 128, .external_lex_state = 5},
  [3220] = {.lex_state = 128, .external_lex_state = 6},
  [3221] = {.lex_state = 128, .external_lex_state = 5},
  [3222] = {.lex_state = 128, .external_lex_state = 6},
  [3223] = {.lex_state = 128, .external_lex_state = 5},
  [3224] = {.lex_state = 128, .external_lex_state = 6},
  [3225] = {.lex_state = 128, .external_lex_state = 6},
  [3226] = {.lex_state = 128, .external_lex_state = 5},
  [3227] = {.lex_state = 128, .external_lex_state = 5},
  [3228] = {.lex_state = 128, .external_lex_state = 5},
  [3229] = {.lex_state = 128, .external_lex_state = 6},
  [3230] = {.lex_state = 128, .external_lex_state = 6},
  [3231] = {.lex_state = 128, .external_lex_state = 5},
  [3232] = {.lex_state = 128, .external_lex_state = 5},
  [3233] = {.lex_state = 128, .external_lex_state = 5},
  [3234] = {.lex_state = 7, .external_lex_state = 6},
  [3235] = {.lex_state = 128, .external_lex_state = 5},
  [3236] = {.lex_state = 128, .external_lex_state = 5},
  [3237] = {.lex_state = 7, .external_lex_state = 6},
  [3238] = {.lex_state = 18, .external_lex_state = 7},
  [3239] = {.lex_state = 128, .external_lex_state = 5},
  [3240] = {.lex_state = 128, .external_lex_state = 5},
  [3241] = {.lex_state = 128, .external_lex_state = 5},
  [3242] = {.lex_state = 128, .external_lex_state = 5},
  [3243] = {.lex_state = 128, .external_lex_state = 5},
  [3244] = {.lex_state = 128, .external_lex_state = 5},
  [3245] = {.lex_state = 128, .external_lex_state = 5},
  [3246] = {.lex_state = 128, .external_lex_state = 5},
  [3247] = {.lex_state = 18, .external_lex_state = 7},
  [3248] = {.lex_state = 128, .external_lex_state = 5},
  [3249] = {.lex_state = 128, .external_lex_state = 5},
  [3250] = {.lex_state = 128, .external_lex_state = 5},
  [3251] = {.lex_state = 18, .external_lex_state = 7},
  [3252] = {.lex_state = 18, .external_lex_state = 7},
  [3253] = {.lex_state = 128, .external_lex_state = 5},
  [3254] = {.lex_state = 128, .external_lex_state = 2},
  [3255] = {.lex_state = 128, .external_lex_state = 5},
  [3256] = {.lex_state = 128, .external_lex_state = 5},
  [3257] = {.lex_state = 128, .external_lex_state = 5},
  [3258] = {.lex_state = 128, .external_lex_state = 2},
  [3259] = {.lex_state = 128, .external_lex_state = 2},
  [3260] = {.lex_state = 128, .external_lex_state = 2},
  [3261] = {.lex_state = 128, .external_lex_state = 6},
  [3262] = {.lex_state = 128, .external_lex_state = 2},
  [3263] = {.lex_state = 128, .external_lex_state = 2},
  [3264] = {.lex_state = 20, .external_lex_state = 2},
  [3265] = {.lex_state = 20, .external_lex_state = 2},
  [3266] = {.lex_state = 128, .external_lex_state = 5},
  [3267] = {.lex_state = 128, .external_lex_state = 5},
  [3268] = {.lex_state = 128, .external_lex_state = 5},
  [3269] = {.lex_state = 128, .external_lex_state = 2},
  [3270] = {.lex_state = 128, .external_lex_state = 2},
  [3271] = {.lex_state = 128, .external_lex_state = 5},
  [3272] = {.lex_state = 20, .external_lex_state = 2},
  [3273] = {.lex_state = 18, .external_lex_state = 7},
  [3274] = {.lex_state = 128, .external_lex_state = 2},
  [3275] = {.lex_state = 128, .external_lex_state = 6},
  [3276] = {.lex_state = 128, .external_lex_state = 2},
  [3277] = {.lex_state = 128, .external_lex_state = 2},
  [3278] = {.lex_state = 128, .external_lex_state = 2},
  [3279] = {.lex_state = 128, .external_lex_state = 5},
  [3280] = {.lex_state = 128, .external_lex_state = 6},
  [3281] = {.lex_state = 128, .external_lex_state = 2},
  [3282] = {.lex_state = 128, .external_lex_state = 2},
  [3283] = {.lex_state = 128, .external_lex_state = 2},
  [3284] = {.lex_state = 128, .external_lex_state = 6},
  [3285] = {.lex_state = 128, .external_lex_state = 6},
  [3286] = {.lex_state = 128, .external_lex_state = 6},
  [3287] = {.lex_state = 128, .external_lex_state = 6},
  [3288] = {.lex_state = 128, .external_lex_state = 2},
  [3289] = {.lex_state = 128, .external_lex_state = 2},
  [3290] = {.lex_state = 128, .external_lex_state = 5},
  [3291] = {.lex_state = 128, .external_lex_state = 2},
  [3292] = {.lex_state = 128, .external_lex_state = 6},
  [3293] = {.lex_state = 20, .external_lex_state = 2},
  [3294] = {.lex_state = 128, .external_lex_state = 2},
  [3295] = {.lex_state = 128, .external_lex_state = 5},
  [3296] = {.lex_state = 128, .external_lex_state = 6},
  [3297] = {.lex_state = 128, .external_lex_state = 5},
  [3298] = {.lex_state = 128, .external_lex_state = 5},
  [3299] = {.lex_state = 20, .external_lex_state = 2},
  [3300] = {.lex_state = 128, .external_lex_state = 2},
  [3301] = {.lex_state = 128, .external_lex_state = 5},
  [3302] = {.lex_state = 128, .external_lex_state = 5},
  [3303] = {.lex_state = 128, .external_lex_state = 5},
  [3304] = {.lex_state = 20, .external_lex_state = 2},
  [3305] = {.lex_state = 128, .external_lex_state = 5},
  [3306] = {.lex_state = 128, .external_lex_state = 6},
  [3307] = {.lex_state = 20, .external_lex_state = 2},
  [3308] = {.lex_state = 20, .external_lex_state = 2},
  [3309] = {.lex_state = 20, .external_lex_state = 2},
  [3310] = {.lex_state = 20, .external_lex_state = 2},
  [3311] = {.lex_state = 20, .external_lex_state = 2},
  [3312] = {.lex_state = 128, .external_lex_state = 5},
  [3313] = {.lex_state = 20, .external_lex_state = 2},
  [3314] = {.lex_state = 20, .external_lex_state = 2},
  [3315] = {.lex_state = 128, .external_lex_state = 5},
  [3316] = {.lex_state = 20, .external_lex_state = 2},
  [3317] = {.lex_state = 128, .external_lex_state = 2},
  [3318] = {.lex_state = 20, .external_lex_state = 2},
  [3319] = {.lex_state = 128, .external_lex_state = 5},
  [3320] = {.lex_state = 128, .external_lex_state = 5},
  [3321] = {.lex_state = 128, .external_lex_state = 6},
  [3322] = {.lex_state = 128, .external_lex_state = 2},
  [3323] = {.lex_state = 128, .external_lex_state = 6},
  [3324] = {.lex_state = 128, .external_lex_state = 2},
  [3325] = {.lex_state = 128, .external_lex_state = 6},
  [3326] = {.lex_state = 128, .external_lex_state = 6},
  [3327] = {.lex_state = 20, .external_lex_state = 2},
  [3328] = {.lex_state = 128, .external_lex_state = 2},
  [3329] = {.lex_state = 128, .external_lex_state = 6},
  [3330] = {.lex_state = 128, .external_lex_state = 6},
  [3331] = {.lex_state = 20, .external_lex_state = 2},
  [3332] = {.lex_state = 128, .external_lex_state = 2},
  [3333] = {.lex_state = 128, .external_lex_state = 5},
  [3334] = {.lex_state = 128, .external_lex_state = 6},
  [3335] = {.lex_state = 128, .external_lex_state = 2},
  [3336] = {.lex_state = 128, .external_lex_state = 5},
  [3337] = {.lex_state = 20, .external_lex_state = 2},
  [3338] = {.lex_state = 128, .external_lex_state = 6},
  [3339] = {.lex_state = 20, .external_lex_state = 2},
  [3340] = {.lex_state = 20, .external_lex_state = 2},
  [3341] = {.lex_state = 20, .external_lex_state = 2},
  [3342] = {.lex_state = 128, .external_lex_state = 5},
  [3343] = {.lex_state = 128, .external_lex_state = 6},
  [3344] = {.lex_state = 128, .external_lex_state = 2},
  [3345] = {.lex_state = 20, .external_lex_state = 2},
  [3346] = {.lex_state = 128, .external_lex_state = 6},
  [3347] = {.lex_state = 128, .external_lex_state = 2},
  [3348] = {.lex_state = 20, .external_lex_state = 2},
  [3349] = {.lex_state = 20, .external_lex_state = 2},
  [3350] = {.lex_state = 20, .external_lex_state = 2},
  [3351] = {.lex_state = 128, .external_lex_state = 6},
  [3352] = {.lex_state = 128, .external_lex_state = 6},
  [3353] = {.lex_state = 128, .external_lex_state = 6},
  [3354] = {.lex_state = 128, .external_lex_state = 6},
  [3355] = {.lex_state = 128, .external_lex_state = 6},
  [3356] = {.lex_state = 128, .external_lex_state = 6},
  [3357] = {.lex_state = 128, .external_lex_state = 6},
  [3358] = {.lex_state = 128, .external_lex_state = 6},
  [3359] = {.lex_state = 128, .external_lex_state = 6},
  [3360] = {.lex_state = 128, .external_lex_state = 6},
  [3361] = {.lex_state = 128, .external_lex_state = 2},
  [3362] = {.lex_state = 128, .external_lex_state = 6},
  [3363] = {.lex_state = 20, .external_lex_state = 2},
  [3364] = {.lex_state = 20, .external_lex_state = 2},
  [3365] = {.lex_state = 20, .external_lex_state = 2},
  [3366] = {.lex_state = 128, .external_lex_state = 5},
  [3367] = {.lex_state = 128, .external_lex_state = 5},
  [3368] = {.lex_state = 128, .external_lex_state = 2},
  [3369] = {.lex_state = 20, .external_lex_state = 2},
  [3370] = {.lex_state = 20, .external_lex_state = 2},
  [3371] = {.lex_state = 128, .external_lex_state = 6},
  [3372] = {.lex_state = 128, .external_lex_state = 5},
  [3373] = {.lex_state = 20, .external_lex_state = 2},
  [3374] = {.lex_state = 128, .external_lex_state = 2},
  [3375] = {.lex_state = 128, .external_lex_state = 5},
  [3376] = {.lex_state = 128, .external_lex_state = 2},
  [3377] = {.lex_state = 128, .external_lex_state = 2},
  [3378] = {.lex_state = 128, .external_lex_state = 5},
  [3379] = {.lex_state = 128, .external_lex_state = 5},
  [3380] = {.lex_state = 128, .external_lex_state = 5},
  [3381] = {.lex_state = 128, .external_lex_state = 6},
  [3382] = {.lex_state = 128, .external_lex_state = 6},
  [3383] = {.lex_state = 128, .external_lex_state = 5},
  [3384] = {.lex_state = 20, .external_lex_state = 2},
  [3385] = {.lex_state = 128, .external_lex_state = 2},
  [3386] = {.lex_state = 128, .external_lex_state = 5},
  [3387] = {.lex_state = 128, .external_lex_state = 2},
  [3388] = {.lex_state = 128, .external_lex_state = 2},
  [3389] = {.lex_state = 128, .external_lex_state = 6},
  [3390] = {.lex_state = 128, .external_lex_state = 2},
  [3391] = {.lex_state = 128, .external_lex_state = 2},
  [3392] = {.lex_state = 128, .external_lex_state = 6},
  [3393] = {.lex_state = 128, .external_lex_state = 2},
  [3394] = {.lex_state = 128, .external_lex_state = 5},
  [3395] = {.lex_state = 20, .external_lex_state = 2},
  [3396] = {.lex_state = 128, .external_lex_state = 6},
  [3397] = {.lex_state = 20, .external_lex_state = 2},
  [3398] = {.lex_state = 128, .external_lex_state = 6},
  [3399] = {.lex_state = 128, .external_lex_state = 5},
  [3400] = {.lex_state = 128, .external_lex_state = 2},
  [3401] = {.lex_state = 128, .external_lex_state = 5},
  [3402] = {.lex_state = 128, .external_lex_state = 5},
  [3403] = {.lex_state = 128, .external_lex_state = 6},
  [3404] = {.lex_state = 128, .external_lex_state = 6},
  [3405] = {.lex_state = 128, .external_lex_state = 6},
  [3406] = {.lex_state = 128, .external_lex_state = 5},
  [3407] = {.lex_state = 128, .external_lex_state = 6},
  [3408] = {.lex_state = 128, .external_lex_state = 5},
  [3409] = {.lex_state = 128, .external_lex_state = 2},
  [3410] = {.lex_state = 20, .external_lex_state = 2},
  [3411] = {.lex_state = 128, .external_lex_state = 6},
  [3412] = {.lex_state = 20, .external_lex_state = 2},
  [3413] = {.lex_state = 128, .external_lex_state = 2},
  [3414] = {.lex_state = 128, .external_lex_state = 6},
  [3415] = {.lex_state = 128, .external_lex_state = 6},
  [3416] = {.lex_state = 128, .external_lex_state = 6},
  [3417] = {.lex_state = 128, .external_lex_state = 5},
  [3418] = {.lex_state = 128, .external_lex_state = 6},
  [3419] = {.lex_state = 128, .external_lex_state = 5},
  [3420] = {.lex_state = 128, .external_lex_state = 6},
  [3421] = {.lex_state = 128, .external_lex_state = 5},
  [3422] = {.lex_state = 128, .external_lex_state = 2},
  [3423] = {.lex_state = 128, .external_lex_state = 5},
  [3424] = {.lex_state = 128, .external_lex_state = 6},
  [3425] = {.lex_state = 128, .external_lex_state = 6},
  [3426] = {.lex_state = 128, .external_lex_state = 6},
  [3427] = {.lex_state = 128, .external_lex_state = 6},
  [3428] = {.lex_state = 20, .external_lex_state = 2},
  [3429] = {.lex_state = 128, .external_lex_state = 2},
  [3430] = {.lex_state = 128, .external_lex_state = 5},
  [3431] = {.lex_state = 128, .external_lex_state = 5},
  [3432] = {.lex_state = 128, .external_lex_state = 5},
  [3433] = {.lex_state = 128, .external_lex_state = 5},
  [3434] = {.lex_state = 20, .external_lex_state = 2},
  [3435] = {.lex_state = 128, .external_lex_state = 5},
  [3436] = {.lex_state = 128, .external_lex_state = 5},
  [3437] = {.lex_state = 128, .external_lex_state = 5},
  [3438] = {.lex_state = 20, .external_lex_state = 2},
  [3439] = {.lex_state = 128, .external_lex_state = 5},
  [3440] = {.lex_state = 128, .external_lex_state = 6},
  [3441] = {.lex_state = 128, .external_lex_state = 6},
  [3442] = {.lex_state = 128, .external_lex_state = 6},
  [3443] = {.lex_state = 128, .external_lex_state = 6},
  [3444] = {.lex_state = 128, .external_lex_state = 5},
  [3445] = {.lex_state = 128, .external_lex_state = 5},
  [3446] = {.lex_state = 128, .external_lex_state = 6},
  [3447] = {.lex_state = 128, .external_lex_state = 2},
  [3448] = {.lex_state = 128, .external_lex_state = 6},
  [3449] = {.lex_state = 128, .external_lex_state = 6},
  [3450] = {.lex_state = 128, .external_lex_state = 6},
  [3451] = {.lex_state = 128, .external_lex_state = 5},
  [3452] = {.lex_state = 128, .external_lex_state = 5},
  [3453] = {.lex_state = 128, .external_lex_state = 2},
  [3454] = {.lex_state = 128, .external_lex_state = 5},
  [3455] = {.lex_state = 128, .external_lex_state = 5},
  [3456] = {.lex_state = 128, .external_lex_state = 6},
  [3457] = {.lex_state = 128, .external_lex_state = 2},
  [3458] = {.lex_state = 20, .external_lex_state = 2},
  [3459] = {.lex_state = 128, .external_lex_state = 2},
  [3460] = {.lex_state = 128, .external_lex_state = 2},
  [3461] = {.lex_state = 128, .external_lex_state = 2},
  [3462] = {.lex_state = 128, .external_lex_state = 2},
  [3463] = {.lex_state = 128, .external_lex_state = 6},
  [3464] = {.lex_state = 128, .external_lex_state = 2},
  [3465] = {.lex_state = 128, .external_lex_state = 2},
  [3466] = {.lex_state = 128, .external_lex_state = 5},
  [3467] = {.lex_state = 128, .external_lex_state = 5},
  [3468] = {.lex_state = 20, .external_lex_state = 2},
  [3469] = {.lex_state = 128, .external_lex_state = 5},
  [3470] = {.lex_state = 128, .external_lex_state = 6},
  [3471] = {.lex_state = 128, .external_lex_state = 2},
  [3472] = {.lex_state = 128, .external_lex_state = 6},
  [3473] = {.lex_state = 128, .external_lex_state = 5},
  [3474] = {.lex_state = 128, .external_lex_state = 2},
  [3475] = {.lex_state = 20, .external_lex_state = 2},
  [3476] = {.lex_state = 128, .external_lex_state = 2},
  [3477] = {.lex_state = 11, .external_lex_state = 2},
  [3478] = {.lex_state = 128, .external_lex_state = 2},
  [3479] = {.lex_state = 128, .external_lex_state = 2},
  [3480] = {.lex_state = 128, .external_lex_state = 5},
  [3481] = {.lex_state = 128, .external_lex_state = 2},
  [3482] = {.lex_state = 128, .external_lex_state = 6},
  [3483] = {.lex_state = 128, .external_lex_state = 2},
  [3484] = {.lex_state = 128, .external_lex_state = 2},
  [3485] = {.lex_state = 18, .external_lex_state = 8},
  [3486] = {.lex_state = 20, .external_lex_state = 2},
  [3487] = {.lex_state = 128, .external_lex_state = 2},
  [3488] = {.lex_state = 20, .external_lex_state = 2},
  [3489] = {.lex_state = 20, .external_lex_state = 2},
  [3490] = {.lex_state = 7, .external_lex_state = 2},
  [3491] = {.lex_state = 128, .external_lex_state = 2},
  [3492] = {.lex_state = 7, .external_lex_state = 2},
  [3493] = {.lex_state = 7, .external_lex_state = 2},
  [3494] = {.lex_state = 18, .external_lex_state = 8},
  [3495] = {.lex_state = 18, .external_lex_state = 8},
  [3496] = {.lex_state = 20, .external_lex_state = 2},
  [3497] = {.lex_state = 20, .external_lex_state = 2},
  [3498] = {.lex_state = 128, .external_lex_state = 2},
  [3499] = {.lex_state = 18, .external_lex_state = 8},
  [3500] = {.lex_state = 11, .external_lex_state = 2},
  [3501] = {.lex_state = 128, .external_lex_state = 2},
  [3502] = {.lex_state = 128, .external_lex_state = 5},
  [3503] = {.lex_state = 128, .external_lex_state = 2},
  [3504] = {.lex_state = 128, .external_lex_state = 5},
  [3505] = {.lex_state = 128, .external_lex_state = 2},
  [3506] = {.lex_state = 18, .external_lex_state = 8},
  [3507] = {.lex_state = 18, .external_lex_state = 8},
  [3508] = {.lex_state = 18, .external_lex_state = 8},
  [3509] = {.lex_state = 128, .external_lex_state = 2},
  [3510] = {.lex_state = 18, .external_lex_state = 8},
  [3511] = {.lex_state = 128, .external_lex_state = 2},
  [3512] = {.lex_state = 20, .external_lex_state = 2},
  [3513] = {.lex_state = 20, .external_lex_state = 2},
  [3514] = {.lex_state = 128, .external_lex_state = 2},
  [3515] = {.lex_state = 20, .external_lex_state = 2},
  [3516] = {.lex_state = 128, .external_lex_state = 5},
  [3517] = {.lex_state = 128, .external_lex_state = 5},
  [3518] = {.lex_state = 128, .external_lex_state = 5},
  [3519] = {.lex_state = 20, .external_lex_state = 2},
  [3520] = {.lex_state = 20, .external_lex_state = 2},
  [3521] = {.lex_state = 128, .external_lex_state = 5},
  [3522] = {.lex_state = 128, .external_lex_state = 2},
  [3523] = {.lex_state = 128, .external_lex_state = 2},
  [3524] = {.lex_state = 128, .external_lex_state = 5},
  [3525] = {.lex_state = 128, .external_lex_state = 2},
  [3526] = {.lex_state = 128, .external_lex_state = 2},
  [3527] = {.lex_state = 128, .external_lex_state = 2},
  [3528] = {.lex_state = 128, .external_lex_state = 2},
  [3529] = {.lex_state = 128, .external_lex_state = 5},
  [3530] = {.lex_state = 128, .external_lex_state = 5},
  [3531] = {.lex_state = 128, .external_lex_state = 5},
  [3532] = {.lex_state = 128, .external_lex_state = 5},
  [3533] = {.lex_state = 128, .external_lex_state = 5},
  [3534] = {.lex_state = 128, .external_lex_state = 5},
  [3535] = {.lex_state = 128, .external_lex_state = 5},
  [3536] = {.lex_state = 128, .external_lex_state = 2},
  [3537] = {.lex_state = 128, .external_lex_state = 5},
  [3538] = {.lex_state = 128, .external_lex_state = 5},
  [3539] = {.lex_state = 128, .external_lex_state = 5},
  [3540] = {.lex_state = 128, .external_lex_state = 5},
  [3541] = {.lex_state = 128, .external_lex_state = 2},
  [3542] = {.lex_state = 128, .external_lex_state = 5},
  [3543] = {.lex_state = 128, .external_lex_state = 5},
  [3544] = {.lex_state = 128, .external_lex_state = 5},
  [3545] = {.lex_state = 128, .external_lex_state = 5},
  [3546] = {.lex_state = 128, .external_lex_state = 5},
  [3547] = {.lex_state = 128, .external_lex_state = 5},
  [3548] = {.lex_state = 128, .external_lex_state = 5},
  [3549] = {.lex_state = 128, .external_lex_state = 5},
  [3550] = {.lex_state = 128, .external_lex_state = 5},
  [3551] = {.lex_state = 128, .external_lex_state = 2},
  [3552] = {.lex_state = 20, .external_lex_state = 2},
  [3553] = {.lex_state = 128, .external_lex_state = 5},
  [3554] = {.lex_state = 128, .external_lex_state = 5},
  [3555] = {.lex_state = 7, .external_lex_state = 2},
  [3556] = {.lex_state = 128, .external_lex_state = 5},
  [3557] = {.lex_state = 128, .external_lex_state = 5},
  [3558] = {.lex_state = 128, .external_lex_state = 2},
  [3559] = {.lex_state = 128, .external_lex_state = 2},
  [3560] = {.lex_state = 128, .external_lex_state = 5},
  [3561] = {.lex_state = 128, .external_lex_state = 5},
  [3562] = {.lex_state = 128, .external_lex_state = 2},
  [3563] = {.lex_state = 128, .external_lex_state = 5},
  [3564] = {.lex_state = 128, .external_lex_state = 5},
  [3565] = {.lex_state = 128, .external_lex_state = 5},
  [3566] = {.lex_state = 128, .external_lex_state = 2},
  [3567] = {.lex_state = 128, .external_lex_state = 2},
  [3568] = {.lex_state = 128, .external_lex_state = 2},
  [3569] = {.lex_state = 128, .external_lex_state = 5},
  [3570] = {.lex_state = 128, .external_lex_state = 2},
  [3571] = {.lex_state = 128, .external_lex_state = 2},
  [3572] = {.lex_state = 128, .external_lex_state = 5},
  [3573] = {.lex_state = 128, .external_lex_state = 5},
  [3574] = {.lex_state = 128, .external_lex_state = 5},
  [3575] = {.lex_state = 128, .external_lex_state = 5},
  [3576] = {.lex_state = 128, .external_lex_state = 5},
  [3577] = {.lex_state = 128, .external_lex_state = 2},
  [3578] = {.lex_state = 128, .external_lex_state = 5},
  [3579] = {.lex_state = 128, .external_lex_state = 5},
  [3580] = {.lex_state = 128, .external_lex_state = 5},
  [3581] = {.lex_state = 128, .external_lex_state = 5},
  [3582] = {.lex_state = 7, .external_lex_state = 2},
  [3583] = {.lex_state = 128, .external_lex_state = 5},
  [3584] = {.lex_state = 128, .external_lex_state = 5},
  [3585] = {.lex_state = 128, .external_lex_state = 5},
  [3586] = {.lex_state = 128, .external_lex_state = 5},
  [3587] = {.lex_state = 7, .external_lex_state = 2},
  [3588] = {.lex_state = 128, .external_lex_state = 2},
  [3589] = {.lex_state = 128, .external_lex_state = 5},
  [3590] = {.lex_state = 128, .external_lex_state = 5},
  [3591] = {.lex_state = 128, .external_lex_state = 5},
  [3592] = {.lex_state = 128, .external_lex_state = 5},
  [3593] = {.lex_state = 128, .external_lex_state = 2},
  [3594] = {.lex_state = 128, .external_lex_state = 5},
  [3595] = {.lex_state = 128, .external_lex_state = 2},
  [3596] = {.lex_state = 128, .external_lex_state = 2},
  [3597] = {.lex_state = 128, .external_lex_state = 5},
  [3598] = {.lex_state = 128, .external_lex_state = 5},
  [3599] = {.lex_state = 128, .external_lex_state = 5},
  [3600] = {.lex_state = 128, .external_lex_state = 5},
  [3601] = {.lex_state = 128, .external_lex_state = 5},
  [3602] = {.lex_state = 128, .external_lex_state = 5},
  [3603] = {.lex_state = 128, .external_lex_state = 2},
  [3604] = {.lex_state = 128, .external_lex_state = 5},
  [3605] = {.lex_state = 128, .external_lex_state = 5},
  [3606] = {.lex_state = 128, .external_lex_state = 5},
  [3607] = {.lex_state = 7, .external_lex_state = 2},
  [3608] = {.lex_state = 128, .external_lex_state = 5},
  [3609] = {.lex_state = 128, .external_lex_state = 5},
  [3610] = {.lex_state = 128, .external_lex_state = 5},
  [3611] = {.lex_state = 128, .external_lex_state = 5},
  [3612] = {.lex_state = 7, .external_lex_state = 2},
  [3613] = {.lex_state = 128, .external_lex_state = 5},
  [3614] = {.lex_state = 128, .external_lex_state = 2},
  [3615] = {.lex_state = 128, .external_lex_state = 5},
  [3616] = {.lex_state = 128, .external_lex_state = 5},
  [3617] = {.lex_state = 7, .external_lex_state = 2},
  [3618] = {.lex_state = 128, .external_lex_state = 5},
  [3619] = {.lex_state = 128, .external_lex_state = 5},
  [3620] = {.lex_state = 128, .external_lex_state = 5},
  [3621] = {.lex_state = 128, .external_lex_state = 5},
  [3622] = {.lex_state = 128, .external_lex_state = 5},
  [3623] = {.lex_state = 128, .external_lex_state = 5},
  [3624] = {.lex_state = 128, .external_lex_state = 5},
  [3625] = {.lex_state = 128, .external_lex_state = 5},
  [3626] = {.lex_state = 128, .external_lex_state = 2},
  [3627] = {.lex_state = 128, .external_lex_state = 2},
  [3628] = {.lex_state = 128, .external_lex_state = 2},
  [3629] = {.lex_state = 128, .external_lex_state = 5},
  [3630] = {.lex_state = 128, .external_lex_state = 5},
  [3631] = {.lex_state = 128, .external_lex_state = 2},
  [3632] = {.lex_state = 128, .external_lex_state = 2},
  [3633] = {.lex_state = 7, .external_lex_state = 2},
  [3634] = {.lex_state = 128, .external_lex_state = 2},
  [3635] = {.lex_state = 128, .external_lex_state = 2},
  [3636] = {.lex_state = 7, .external_lex_state = 2},
  [3637] = {.lex_state = 128, .external_lex_state = 5},
  [3638] = {.lex_state = 128, .external_lex_state = 2},
  [3639] = {.lex_state = 128, .external_lex_state = 2},
  [3640] = {.lex_state = 128, .external_lex_state = 5},
  [3641] = {.lex_state = 128, .external_lex_state = 5},
  [3642] = {.lex_state = 128, .external_lex_state = 2},
  [3643] = {.lex_state = 128, .external_lex_state = 2},
  [3644] = {.lex_state = 7, .external_lex_state = 2},
  [3645] = {.lex_state = 7, .external_lex_state = 2},
  [3646] = {.lex_state = 128, .external_lex_state = 5},
  [3647] = {.lex_state = 128, .external_lex_state = 2},
  [3648] = {.lex_state = 128, .external_lex_state = 2},
  [3649] = {.lex_state = 128, .external_lex_state = 2},
  [3650] = {.lex_state = 128, .external_lex_state = 5},
  [3651] = {.lex_state = 7, .external_lex_state = 2},
  [3652] = {.lex_state = 128, .external_lex_state = 2},
  [3653] = {.lex_state = 128, .external_lex_state = 5},
  [3654] = {.lex_state = 128, .external_lex_state = 2},
  [3655] = {.lex_state = 7, .external_lex_state = 2},
  [3656] = {.lex_state = 8, .external_lex_state = 2},
  [3657] = {.lex_state = 128, .external_lex_state = 5},
  [3658] = {.lex_state = 128, .external_lex_state = 2},
  [3659] = {.lex_state = 128, .external_lex_state = 5},
  [3660] = {.lex_state = 128, .external_lex_state = 5},
  [3661] = {.lex_state = 7, .external_lex_state = 2},
  [3662] = {.lex_state = 128, .external_lex_state = 5},
  [3663] = {.lex_state = 128, .external_lex_state = 2},
  [3664] = {.lex_state = 128, .external_lex_state = 5},
  [3665] = {.lex_state = 128, .external_lex_state = 5},
  [3666] = {.lex_state = 128, .external_lex_state = 5},
  [3667] = {.lex_state = 128, .external_lex_state = 5},
  [3668] = {.lex_state = 128, .external_lex_state = 2},
  [3669] = {.lex_state = 128, .external_lex_state = 5},
  [3670] = {.lex_state = 128, .external_lex_state = 5},
  [3671] = {.lex_state = 128, .external_lex_state = 5},
  [3672] = {.lex_state = 128, .external_lex_state = 5},
  [3673] = {.lex_state = 128, .external_lex_state = 5},
  [3674] = {.lex_state = 128, .external_lex_state = 5},
  [3675] = {.lex_state = 128, .external_lex_state = 5},
  [3676] = {.lex_state = 128, .external_lex_state = 5},
  [3677] = {.lex_state = 128, .external_lex_state = 5},
  [3678] = {.lex_state = 128, .external_lex_state = 5},
  [3679] = {.lex_state = 128, .external_lex_state = 2},
  [3680] = {.lex_state = 128, .external_lex_state = 2},
  [3681] = {.lex_state = 128, .external_lex_state = 2},
  [3682] = {.lex_state = 128, .external_lex_state = 5},
  [3683] = {.lex_state = 128, .external_lex_state = 5},
  [3684] = {.lex_state = 7, .external_lex_state = 2},
  [3685] = {.lex_state = 128, .external_lex_state = 5},
  [3686] = {.lex_state = 128, .external_lex_state = 2},
  [3687] = {.lex_state = 128, .external_lex_state = 5},
  [3688] = {.lex_state = 128, .external_lex_state = 5},
  [3689] = {.lex_state = 128, .external_lex_state = 5},
  [3690] = {.lex_state = 128, .external_lex_state = 5},
  [3691] = {.lex_state = 128, .external_lex_state = 5},
  [3692] = {.lex_state = 128, .external_lex_state = 2},
  [3693] = {.lex_state = 8, .external_lex_state = 2},
  [3694] = {.lex_state = 128, .external_lex_state = 2},
  [3695] = {.lex_state = 128, .external_lex_state = 2},
  [3696] = {.lex_state = 128, .external_lex_state = 5},
  [3697] = {.lex_state = 128, .external_lex_state = 2},
  [3698] = {.lex_state = 128, .external_lex_state = 5},
  [3699] = {.lex_state = 128, .external_lex_state = 5},
  [3700] = {.lex_state = 128, .external_lex_state = 5},
  [3701] = {.lex_state = 128, .external_lex_state = 5},
  [3702] = {.lex_state = 128, .external_lex_state = 5},
  [3703] = {.lex_state = 8, .external_lex_state = 2},
  [3704] = {.lex_state = 7, .external_lex_state = 2},
  [3705] = {.lex_state = 128, .external_lex_state = 2},
  [3706] = {.lex_state = 128, .external_lex_state = 2},
  [3707] = {.lex_state = 128, .external_lex_state = 5},
  [3708] = {.lex_state = 128, .external_lex_state = 5},
  [3709] = {.lex_state = 128, .external_lex_state = 5},
  [3710] = {.lex_state = 128, .external_lex_state = 2},
  [3711] = {.lex_state = 128, .external_lex_state = 5},
  [3712] = {.lex_state = 128, .external_lex_state = 5},
  [3713] = {.lex_state = 128, .external_lex_state = 2},
  [3714] = {.lex_state = 128, .external_lex_state = 5},
  [3715] = {.lex_state = 128, .external_lex_state = 5},
  [3716] = {.lex_state = 128, .external_lex_state = 5},
  [3717] = {.lex_state = 128, .external_lex_state = 5},
  [3718] = {.lex_state = 128, .external_lex_state = 5},
  [3719] = {.lex_state = 128, .external_lex_state = 2},
  [3720] = {.lex_state = 128, .external_lex_state = 5},
  [3721] = {.lex_state = 128, .external_lex_state = 5},
  [3722] = {.lex_state = 128, .external_lex_state = 5},
  [3723] = {.lex_state = 128, .external_lex_state = 2},
  [3724] = {.lex_state = 128, .external_lex_state = 5},
  [3725] = {.lex_state = 128, .external_lex_state = 2},
  [3726] = {.lex_state = 128, .external_lex_state = 2},
  [3727] = {.lex_state = 128, .external_lex_state = 5},
  [3728] = {.lex_state = 128, .external_lex_state = 5},
  [3729] = {.lex_state = 128, .external_lex_state = 2},
  [3730] = {.lex_state = 128, .external_lex_state = 5},
  [3731] = {.lex_state = 128, .external_lex_state = 5},
  [3732] = {.lex_state = 128, .external_lex_state = 5},
  [3733] = {.lex_state = 128, .external_lex_state = 2},
  [3734] = {.lex_state = 128, .external_lex_state = 5},
  [3735] = {.lex_state = 128, .external_lex_state = 5},
  [3736] = {.lex_state = 128, .external_lex_state = 5},
  [3737] = {.lex_state = 128, .external_lex_state = 2},
  [3738] = {.lex_state = 128, .external_lex_state = 5},
  [3739] = {.lex_state = 128, .external_lex_state = 5},
  [3740] = {.lex_state = 128, .external_lex_state = 2},
  [3741] = {.lex_state = 128, .external_lex_state = 2},
  [3742] = {.lex_state = 128, .external_lex_state = 2},
  [3743] = {.lex_state = 128, .external_lex_state = 2},
  [3744] = {.lex_state = 128, .external_lex_state = 5},
  [3745] = {.lex_state = 128, .external_lex_state = 2},
  [3746] = {.lex_state = 128, .external_lex_state = 5},
  [3747] = {.lex_state = 128, .external_lex_state = 5},
  [3748] = {.lex_state = 128, .external_lex_state = 5},
  [3749] = {.lex_state = 128, .external_lex_state = 2},
  [3750] = {.lex_state = 128, .external_lex_state = 5},
  [3751] = {.lex_state = 128, .external_lex_state = 5},
  [3752] = {.lex_state = 128, .external_lex_state = 2},
  [3753] = {.lex_state = 128, .external_lex_state = 2},
  [3754] = {.lex_state = 128, .external_lex_state = 2},
  [3755] = {.lex_state = 7, .external_lex_state = 2},
  [3756] = {.lex_state = 128, .external_lex_state = 5},
  [3757] = {.lex_state = 128, .external_lex_state = 2},
  [3758] = {.lex_state = 128, .external_lex_state = 2},
  [3759] = {.lex_state = 128, .external_lex_state = 5},
  [3760] = {.lex_state = 128, .external_lex_state = 5},
  [3761] = {.lex_state = 128, .external_lex_state = 5},
  [3762] = {.lex_state = 128, .external_lex_state = 5},
  [3763] = {.lex_state = 128, .external_lex_state = 5},
  [3764] = {.lex_state = 128, .external_lex_state = 5},
  [3765] = {.lex_state = 128, .external_lex_state = 5},
  [3766] = {.lex_state = 128, .external_lex_state = 2},
  [3767] = {.lex_state = 128, .external_lex_state = 6},
  [3768] = {.lex_state = 128, .external_lex_state = 2},
  [3769] = {.lex_state = 128, .external_lex_state = 5},
  [3770] = {.lex_state = 128, .external_lex_state = 5},
  [3771] = {.lex_state = 128, .external_lex_state = 5},
  [3772] = {.lex_state = 18, .external_lex_state = 8},
  [3773] = {.lex_state = 128, .external_lex_state = 5},
  [3774] = {.lex_state = 128, .external_lex_state = 2},
  [3775] = {.lex_state = 128, .external_lex_state = 2},
  [3776] = {.lex_state = 8, .external_lex_state = 2},
  [3777] = {.lex_state = 128, .external_lex_state = 2},
  [3778] = {.lex_state = 128, .external_lex_state = 2},
  [3779] = {.lex_state = 128, .external_lex_state = 2},
  [3780] = {.lex_state = 128, .external_lex_state = 5},
  [3781] = {.lex_state = 128, .external_lex_state = 2},
  [3782] = {.lex_state = 128, .external_lex_state = 2},
  [3783] = {.lex_state = 128, .external_lex_state = 6},
  [3784] = {.lex_state = 128, .external_lex_state = 2},
  [3785] = {.lex_state = 128, .external_lex_state = 2},
  [3786] = {.lex_state = 128, .external_lex_state = 6},
  [3787] = {.lex_state = 20, .external_lex_state = 2},
  [3788] = {.lex_state = 128, .external_lex_state = 6},
  [3789] = {.lex_state = 128, .external_lex_state = 6},
  [3790] = {.lex_state = 128, .external_lex_state = 2},
  [3791] = {.lex_state = 128, .external_lex_state = 2},
  [3792] = {.lex_state = 128, .external_lex_state = 2},
  [3793] = {.lex_state = 128, .external_lex_state = 2},
  [3794] = {.lex_state = 18, .external_lex_state = 8},
  [3795] = {.lex_state = 128, .external_lex_state = 2},
  [3796] = {.lex_state = 20, .external_lex_state = 2},
  [3797] = {.lex_state = 20, .external_lex_state = 2},
  [3798] = {.lex_state = 128, .external_lex_state = 2},
  [3799] = {.lex_state = 128, .external_lex_state = 2},
  [3800] = {.lex_state = 128, .external_lex_state = 2},
  [3801] = {.lex_state = 128, .external_lex_state = 2},
  [3802] = {.lex_state = 128, .external_lex_state = 2},
  [3803] = {.lex_state = 128, .external_lex_state = 2},
  [3804] = {.lex_state = 128, .external_lex_state = 2},
  [3805] = {.lex_state = 128, .external_lex_state = 2},
  [3806] = {.lex_state = 128, .external_lex_state = 2},
  [3807] = {.lex_state = 8, .external_lex_state = 2},
  [3808] = {.lex_state = 128, .external_lex_state = 6},
  [3809] = {.lex_state = 128, .external_lex_state = 2},
  [3810] = {.lex_state = 128, .external_lex_state = 6},
  [3811] = {.lex_state = 128, .external_lex_state = 6},
  [3812] = {.lex_state = 18, .external_lex_state = 8},
  [3813] = {.lex_state = 128, .external_lex_state = 2},
  [3814] = {.lex_state = 128, .external_lex_state = 2},
  [3815] = {.lex_state = 128, .external_lex_state = 5},
  [3816] = {.lex_state = 128, .external_lex_state = 2},
  [3817] = {.lex_state = 128, .external_lex_state = 6},
  [3818] = {.lex_state = 128, .external_lex_state = 5},
  [3819] = {.lex_state = 18, .external_lex_state = 8},
  [3820] = {.lex_state = 128, .external_lex_state = 5},
  [3821] = {.lex_state = 20, .external_lex_state = 2},
  [3822] = {.lex_state = 128, .external_lex_state = 2},
  [3823] = {.lex_state = 128, .external_lex_state = 6},
  [3824] = {.lex_state = 128, .external_lex_state = 5},
  [3825] = {.lex_state = 11, .external_lex_state = 2},
  [3826] = {.lex_state = 128, .external_lex_state = 2},
  [3827] = {.lex_state = 128, .external_lex_state = 2},
  [3828] = {.lex_state = 128, .external_lex_state = 5},
  [3829] = {.lex_state = 128, .external_lex_state = 2},
  [3830] = {.lex_state = 128, .external_lex_state = 5},
  [3831] = {.lex_state = 128, .external_lex_state = 5},
  [3832] = {.lex_state = 128, .external_lex_state = 5},
  [3833] = {.lex_state = 128, .external_lex_state = 2},
  [3834] = {.lex_state = 128, .external_lex_state = 2},
  [3835] = {.lex_state = 128, .external_lex_state = 5},
  [3836] = {.lex_state = 128, .external_lex_state = 5},
  [3837] = {.lex_state = 11, .external_lex_state = 2},
  [3838] = {.lex_state = 128, .external_lex_state = 2},
  [3839] = {.lex_state = 128, .external_lex_state = 6},
  [3840] = {.lex_state = 128, .external_lex_state = 2},
  [3841] = {.lex_state = 128, .external_lex_state = 2},
  [3842] = {.lex_state = 128, .external_lex_state = 2},
  [3843] = {.lex_state = 128, .external_lex_state = 6},
  [3844] = {.lex_state = 128, .external_lex_state = 5},
  [3845] = {.lex_state = 20, .external_lex_state = 2},
  [3846] = {.lex_state = 128, .external_lex_state = 2},
  [3847] = {.lex_state = 128, .external_lex_state = 6},
  [3848] = {.lex_state = 128, .external_lex_state = 2},
  [3849] = {.lex_state = 128, .external_lex_state = 2},
  [3850] = {.lex_state = 128, .external_lex_state = 2},
  [3851] = {.lex_state = 128, .external_lex_state = 2},
  [3852] = {.lex_state = 128, .external_lex_state = 2},
  [3853] = {.lex_state = 128, .external_lex_state = 2},
  [3854] = {.lex_state = 128, .external_lex_state = 2},
  [3855] = {.lex_state = 128, .external_lex_state = 5},
  [3856] = {.lex_state = 128, .external_lex_state = 6},
  [3857] = {.lex_state = 128, .external_lex_state = 2},
  [3858] = {.lex_state = 128, .external_lex_state = 2},
  [3859] = {.lex_state = 128, .external_lex_state = 2},
  [3860] = {.lex_state = 128, .external_lex_state = 2},
  [3861] = {.lex_state = 128, .external_lex_state = 2},
  [3862] = {.lex_state = 128, .external_lex_state = 2},
  [3863] = {.lex_state = 128, .external_lex_state = 2},
  [3864] = {.lex_state = 128, .external_lex_state = 2},
  [3865] = {.lex_state = 128, .external_lex_state = 2},
  [3866] = {.lex_state = 128, .external_lex_state = 2},
  [3867] = {.lex_state = 128, .external_lex_state = 2},
  [3868] = {.lex_state = 128, .external_lex_state = 2},
  [3869] = {.lex_state = 128, .external_lex_state = 2},
  [3870] = {.lex_state = 128, .external_lex_state = 2},
  [3871] = {.lex_state = 128, .external_lex_state = 5},
  [3872] = {.lex_state = 128, .external_lex_state = 2},
  [3873] = {.lex_state = 128, .external_lex_state = 2},
  [3874] = {.lex_state = 128, .external_lex_state = 2},
  [3875] = {.lex_state = 128, .external_lex_state = 2},
  [3876] = {.lex_state = 128, .external_lex_state = 5},
  [3877] = {.lex_state = 128, .external_lex_state = 2},
  [3878] = {.lex_state = 128, .external_lex_state = 5},
  [3879] = {.lex_state = 128, .external_lex_state = 2},
  [3880] = {.lex_state = 128, .external_lex_state = 2},
  [3881] = {.lex_state = 128, .external_lex_state = 6},
  [3882] = {.lex_state = 128, .external_lex_state = 6},
  [3883] = {.lex_state = 128, .external_lex_state = 2},
  [3884] = {.lex_state = 128, .external_lex_state = 2},
  [3885] = {.lex_state = 128, .external_lex_state = 5},
  [3886] = {.lex_state = 128, .external_lex_state = 5},
  [3887] = {.lex_state = 128, .external_lex_state = 2},
  [3888] = {.lex_state = 128, .external_lex_state = 2},
  [3889] = {.lex_state = 128, .external_lex_state = 5},
  [3890] = {.lex_state = 128, .external_lex_state = 2},
  [3891] = {.lex_state = 128, .external_lex_state = 2},
  [3892] = {.lex_state = 128, .external_lex_state = 2},
  [3893] = {.lex_state = 128, .external_lex_state = 2},
  [3894] = {.lex_state = 128, .external_lex_state = 2},
  [3895] = {.lex_state = 18, .external_lex_state = 8},
  [3896] = {.lex_state = 128, .external_lex_state = 5},
  [3897] = {.lex_state = 128, .external_lex_state = 6},
  [3898] = {.lex_state = 128, .external_lex_state = 2},
  [3899] = {.lex_state = 128, .external_lex_state = 6},
  [3900] = {.lex_state = 128, .external_lex_state = 6},
  [3901] = {.lex_state = 128, .external_lex_state = 6},
  [3902] = {.lex_state = 128, .external_lex_state = 2},
  [3903] = {.lex_state = 128, .external_lex_state = 5},
  [3904] = {.lex_state = 128, .external_lex_state = 6},
  [3905] = {.lex_state = 128, .external_lex_state = 2},
  [3906] = {.lex_state = 128, .external_lex_state = 5},
  [3907] = {.lex_state = 128, .external_lex_state = 2},
  [3908] = {.lex_state = 128, .external_lex_state = 2},
  [3909] = {.lex_state = 128, .external_lex_state = 2},
  [3910] = {.lex_state = 128, .external_lex_state = 2},
  [3911] = {.lex_state = 128, .external_lex_state = 2},
  [3912] = {.lex_state = 128, .external_lex_state = 6},
  [3913] = {.lex_state = 128, .external_lex_state = 6},
  [3914] = {.lex_state = 128, .external_lex_state = 2},
  [3915] = {.lex_state = 128, .external_lex_state = 6},
  [3916] = {.lex_state = 128, .external_lex_state = 2},
  [3917] = {.lex_state = 128, .external_lex_state = 2},
  [3918] = {.lex_state = 128, .external_lex_state = 6},
  [3919] = {.lex_state = 128, .external_lex_state = 2},
  [3920] = {.lex_state = 128, .external_lex_state = 5},
  [3921] = {.lex_state = 128, .external_lex_state = 6},
  [3922] = {.lex_state = 128, .external_lex_state = 2},
  [3923] = {.lex_state = 128, .external_lex_state = 5},
  [3924] = {.lex_state = 128, .external_lex_state = 2},
  [3925] = {.lex_state = 128, .external_lex_state = 5},
  [3926] = {.lex_state = 128, .external_lex_state = 2},
  [3927] = {.lex_state = 128, .external_lex_state = 5},
  [3928] = {.lex_state = 18, .external_lex_state = 7},
  [3929] = {.lex_state = 128, .external_lex_state = 5},
  [3930] = {.lex_state = 128, .external_lex_state = 5},
  [3931] = {.lex_state = 128, .external_lex_state = 2},
  [3932] = {.lex_state = 128, .external_lex_state = 5},
  [3933] = {.lex_state = 128, .external_lex_state = 5},
  [3934] = {.lex_state = 128, .external_lex_state = 5},
  [3935] = {.lex_state = 128, .external_lex_state = 5},
  [3936] = {.lex_state = 18, .external_lex_state = 7},
  [3937] = {.lex_state = 128, .external_lex_state = 5},
  [3938] = {.lex_state = 128, .external_lex_state = 5},
  [3939] = {.lex_state = 128, .external_lex_state = 5},
  [3940] = {.lex_state = 128, .external_lex_state = 5},
  [3941] = {.lex_state = 128, .external_lex_state = 5},
  [3942] = {.lex_state = 18, .external_lex_state = 7},
  [3943] = {.lex_state = 128, .external_lex_state = 5},
  [3944] = {.lex_state = 128, .external_lex_state = 5},
  [3945] = {.lex_state = 128, .external_lex_state = 5},
  [3946] = {.lex_state = 128, .external_lex_state = 2},
  [3947] = {.lex_state = 128, .external_lex_state = 5},
  [3948] = {.lex_state = 128, .external_lex_state = 2},
  [3949] = {.lex_state = 128, .external_lex_state = 5},
  [3950] = {.lex_state = 128, .external_lex_state = 5},
  [3951] = {.lex_state = 18, .external_lex_state = 7},
  [3952] = {.lex_state = 128, .external_lex_state = 5},
  [3953] = {.lex_state = 20, .external_lex_state = 2},
  [3954] = {.lex_state = 128, .external_lex_state = 5},
  [3955] = {.lex_state = 128, .external_lex_state = 5},
  [3956] = {.lex_state = 128, .external_lex_state = 5},
  [3957] = {.lex_state = 128, .external_lex_state = 5},
  [3958] = {.lex_state = 128, .external_lex_state = 6},
  [3959] = {.lex_state = 128, .external_lex_state = 6},
  [3960] = {.lex_state = 128, .external_lex_state = 6},
  [3961] = {.lex_state = 128, .external_lex_state = 5},
  [3962] = {.lex_state = 128, .external_lex_state = 5},
  [3963] = {.lex_state = 128, .external_lex_state = 5},
  [3964] = {.lex_state = 128, .external_lex_state = 5},
  [3965] = {.lex_state = 128, .external_lex_state = 5},
  [3966] = {.lex_state = 128, .external_lex_state = 5},
  [3967] = {.lex_state = 128, .external_lex_state = 5},
  [3968] = {.lex_state = 128, .external_lex_state = 5},
  [3969] = {.lex_state = 128, .external_lex_state = 5},
  [3970] = {.lex_state = 128, .external_lex_state = 5},
  [3971] = {.lex_state = 128, .external_lex_state = 5},
  [3972] = {.lex_state = 128, .external_lex_state = 2},
  [3973] = {.lex_state = 128, .external_lex_state = 5},
  [3974] = {.lex_state = 128, .external_lex_state = 5},
  [3975] = {.lex_state = 128, .external_lex_state = 5},
  [3976] = {.lex_state = 128, .external_lex_state = 5},
  [3977] = {.lex_state = 128, .external_lex_state = 5},
  [3978] = {.lex_state = 128, .external_lex_state = 2},
  [3979] = {.lex_state = 128, .external_lex_state = 2},
  [3980] = {.lex_state = 128, .external_lex_state = 5},
  [3981] = {.lex_state = 128, .external_lex_state = 5},
  [3982] = {.lex_state = 128, .external_lex_state = 5},
  [3983] = {.lex_state = 128, .external_lex_state = 5},
  [3984] = {.lex_state = 128, .external_lex_state = 5},
  [3985] = {.lex_state = 128, .external_lex_state = 5},
  [3986] = {.lex_state = 128, .external_lex_state = 5},
  [3987] = {.lex_state = 128, .external_lex_state = 5},
  [3988] = {.lex_state = 128, .external_lex_state = 5},
  [3989] = {.lex_state = 128, .external_lex_state = 5},
  [3990] = {.lex_state = 128, .external_lex_state = 5},
  [3991] = {.lex_state = 128, .external_lex_state = 2},
  [3992] = {.lex_state = 128, .external_lex_state = 2},
  [3993] = {.lex_state = 11, .external_lex_state = 2},
  [3994] = {.lex_state = 128, .external_lex_state = 5},
  [3995] = {.lex_state = 128, .external_lex_state = 5},
  [3996] = {.lex_state = 128, .external_lex_state = 2},
  [3997] = {.lex_state = 128, .external_lex_state = 2},
  [3998] = {.lex_state = 18, .external_lex_state = 7},
  [3999] = {.lex_state = 18, .external_lex_state = 9},
  [4000] = {.lex_state = 128, .external_lex_state = 5},
  [4001] = {.lex_state = 128, .external_lex_state = 5},
  [4002] = {.lex_state = 128, .external_lex_state = 6},
  [4003] = {.lex_state = 128, .external_lex_state = 5},
  [4004] = {.lex_state = 128, .external_lex_state = 5},
  [4005] = {.lex_state = 128, .external_lex_state = 2},
  [4006] = {.lex_state = 128, .external_lex_state = 2},
  [4007] = {.lex_state = 128, .external_lex_state = 2},
  [4008] = {.lex_state = 2, .external_lex_state = 2},
  [4009] = {.lex_state = 128, .external_lex_state = 6},
  [4010] = {.lex_state = 128, .external_lex_state = 5},
  [4011] = {.lex_state = 128, .external_lex_state = 5},
  [4012] = {.lex_state = 128, .external_lex_state = 5},
  [4013] = {.lex_state = 128, .external_lex_state = 5},
  [4014] = {.lex_state = 128, .external_lex_state = 5},
  [4015] = {.lex_state = 128, .external_lex_state = 5},
  [4016] = {.lex_state = 128, .external_lex_state = 5},
  [4017] = {.lex_state = 128, .external_lex_state = 5},
  [4018] = {.lex_state = 128, .external_lex_state = 5},
  [4019] = {.lex_state = 128, .external_lex_state = 2},
  [4020] = {.lex_state = 128, .external_lex_state = 2},
  [4021] = {.lex_state = 128, .external_lex_state = 6},
  [4022] = {.lex_state = 20, .external_lex_state = 2},
  [4023] = {.lex_state = 128, .external_lex_state = 5},
  [4024] = {.lex_state = 128, .external_lex_state = 5},
  [4025] = {.lex_state = 128, .external_lex_state = 5},
  [4026] = {.lex_state = 18, .external_lex_state = 9},
  [4027] = {.lex_state = 128, .external_lex_state = 2},
  [4028] = {.lex_state = 128, .external_lex_state = 5},
  [4029] = {.lex_state = 128, .external_lex_state = 5},
  [4030] = {.lex_state = 128, .external_lex_state = 6},
  [4031] = {.lex_state = 128, .external_lex_state = 5},
  [4032] = {.lex_state = 128, .external_lex_state = 5},
  [4033] = {.lex_state = 128, .external_lex_state = 5},
  [4034] = {.lex_state = 128, .external_lex_state = 5},
  [4035] = {.lex_state = 128, .external_lex_state = 5},
  [4036] = {.lex_state = 128, .external_lex_state = 5},
  [4037] = {.lex_state = 128, .external_lex_state = 2},
  [4038] = {.lex_state = 128, .external_lex_state = 5},
  [4039] = {.lex_state = 128, .external_lex_state = 5},
  [4040] = {.lex_state = 128, .external_lex_state = 2},
  [4041] = {.lex_state = 128, .external_lex_state = 2},
  [4042] = {.lex_state = 128, .external_lex_state = 5},
  [4043] = {.lex_state = 128, .external_lex_state = 6},
  [4044] = {.lex_state = 128, .external_lex_state = 5},
  [4045] = {.lex_state = 128, .external_lex_state = 5},
  [4046] = {.lex_state = 128, .external_lex_state = 5},
  [4047] = {.lex_state = 128, .external_lex_state = 5},
  [4048] = {.lex_state = 128, .external_lex_state = 2},
  [4049] = {.lex_state = 128, .external_lex_state = 2},
  [4050] = {.lex_state = 128, .external_lex_state = 5},
  [4051] = {.lex_state = 128, .external_lex_state = 2},
  [4052] = {.lex_state = 128, .external_lex_state = 5},
  [4053] = {.lex_state = 128, .external_lex_state = 5},
  [4054] = {.lex_state = 128, .external_lex_state = 5},
  [4055] = {.lex_state = 128, .external_lex_state = 5},
  [4056] = {.lex_state = 128, .external_lex_state = 2},
  [4057] = {.lex_state = 128, .external_lex_state = 5},
  [4058] = {.lex_state = 128, .external_lex_state = 5},
  [4059] = {.lex_state = 128, .external_lex_state = 5},
  [4060] = {.lex_state = 128, .external_lex_state = 5},
  [4061] = {.lex_state = 128, .external_lex_state = 5},
  [4062] = {.lex_state = 128, .external_lex_state = 2},
  [4063] = {.lex_state = 20, .external_lex_state = 2},
  [4064] = {.lex_state = 128, .external_lex_state = 2},
  [4065] = {.lex_state = 128, .external_lex_state = 6},
  [4066] = {.lex_state = 128, .external_lex_state = 5},
  [4067] = {.lex_state = 128, .external_lex_state = 5},
  [4068] = {.lex_state = 128, .external_lex_state = 5},
  [4069] = {.lex_state = 128, .external_lex_state = 5},
  [4070] = {.lex_state = 128, .external_lex_state = 2},
  [4071] = {.lex_state = 128, .external_lex_state = 5},
  [4072] = {.lex_state = 128, .external_lex_state = 5},
  [4073] = {.lex_state = 128, .external_lex_state = 5},
  [4074] = {.lex_state = 128, .external_lex_state = 2},
  [4075] = {.lex_state = 128, .external_lex_state = 2},
  [4076] = {.lex_state = 128, .external_lex_state = 2},
  [4077] = {.lex_state = 128, .external_lex_state = 2},
  [4078] = {.lex_state = 128, .external_lex_state = 2},
  [4079] = {.lex_state = 128, .external_lex_state = 5},
  [4080] = {.lex_state = 128, .external_lex_state = 5},
  [4081] = {.lex_state = 128, .external_lex_state = 5},
  [4082] = {.lex_state = 128, .external_lex_state = 5},
  [4083] = {.lex_state = 128, .external_lex_state = 5},
  [4084] = {.lex_state = 128, .external_lex_state = 2},
  [4085] = {.lex_state = 128, .external_lex_state = 5},
  [4086] = {.lex_state = 128, .external_lex_state = 5},
  [4087] = {.lex_state = 128, .external_lex_state = 5},
  [4088] = {.lex_state = 128, .external_lex_state = 2},
  [4089] = {.lex_state = 128, .external_lex_state = 5},
  [4090] = {.lex_state = 128, .external_lex_state = 5},
  [4091] = {.lex_state = 128, .external_lex_state = 5},
  [4092] = {.lex_state = 128, .external_lex_state = 5},
  [4093] = {.lex_state = 128, .external_lex_state = 5},
  [4094] = {.lex_state = 128, .external_lex_state = 5},
  [4095] = {.lex_state = 128, .external_lex_state = 5},
  [4096] = {.lex_state = 128, .external_lex_state = 5},
  [4097] = {.lex_state = 128, .external_lex_state = 5},
  [4098] = {.lex_state = 128, .external_lex_state = 5},
  [4099] = {.lex_state = 128, .external_lex_state = 5},
  [4100] = {.lex_state = 128, .external_lex_state = 5},
  [4101] = {.lex_state = 128, .external_lex_state = 5},
  [4102] = {.lex_state = 128, .external_lex_state = 2},
  [4103] = {.lex_state = 128, .external_lex_state = 5},
  [4104] = {.lex_state = 128, .external_lex_state = 5},
  [4105] = {.lex_state = 128, .external_lex_state = 2},
  [4106] = {.lex_state = 11, .external_lex_state = 2},
  [4107] = {.lex_state = 128, .external_lex_state = 5},
  [4108] = {.lex_state = 18, .external_lex_state = 9},
  [4109] = {.lex_state = 128, .external_lex_state = 6},
  [4110] = {.lex_state = 128, .external_lex_state = 5},
  [4111] = {.lex_state = 128, .external_lex_state = 5},
  [4112] = {.lex_state = 128, .external_lex_state = 5},
  [4113] = {.lex_state = 128, .external_lex_state = 2},
  [4114] = {.lex_state = 128, .external_lex_state = 5},
  [4115] = {.lex_state = 18, .external_lex_state = 9},
  [4116] = {.lex_state = 128, .external_lex_state = 6},
  [4117] = {.lex_state = 128, .external_lex_state = 5},
  [4118] = {.lex_state = 128, .external_lex_state = 5},
  [4119] = {.lex_state = 128, .external_lex_state = 5},
  [4120] = {.lex_state = 128, .external_lex_state = 5},
  [4121] = {.lex_state = 128, .external_lex_state = 5},
  [4122] = {.lex_state = 128, .external_lex_state = 5},
  [4123] = {.lex_state = 128, .external_lex_state = 5},
  [4124] = {.lex_state = 128, .external_lex_state = 5},
  [4125] = {.lex_state = 128, .external_lex_state = 5},
  [4126] = {.lex_state = 128, .external_lex_state = 5},
  [4127] = {.lex_state = 128, .external_lex_state = 5},
  [4128] = {.lex_state = 128, .external_lex_state = 5},
  [4129] = {.lex_state = 128, .external_lex_state = 5},
  [4130] = {.lex_state = 128, .external_lex_state = 5},
  [4131] = {.lex_state = 128, .external_lex_state = 5},
  [4132] = {.lex_state = 128, .external_lex_state = 2},
  [4133] = {.lex_state = 11, .external_lex_state = 2},
  [4134] = {.lex_state = 128, .external_lex_state = 5},
  [4135] = {.lex_state = 128, .external_lex_state = 2},
  [4136] = {.lex_state = 18, .external_lex_state = 9},
  [4137] = {.lex_state = 128, .external_lex_state = 5},
  [4138] = {.lex_state = 128, .external_lex_state = 5},
  [4139] = {.lex_state = 128, .external_lex_state = 5},
  [4140] = {.lex_state = 128, .external_lex_state = 5},
  [4141] = {.lex_state = 128, .external_lex_state = 5},
  [4142] = {.lex_state = 18, .external_lex_state = 9},
  [4143] = {.lex_state = 128, .external_lex_state = 5},
  [4144] = {.lex_state = 128, .external_lex_state = 5},
  [4145] = {.lex_state = 128, .external_lex_state = 5},
  [4146] = {.lex_state = 128, .external_lex_state = 5},
  [4147] = {.lex_state = 128, .external_lex_state = 5},
  [4148] = {.lex_state = 128, .external_lex_state = 5},
  [4149] = {.lex_state = 128, .external_lex_state = 2},
  [4150] = {.lex_state = 128, .external_lex_state = 5},
  [4151] = {.lex_state = 128, .external_lex_state = 2},
  [4152] = {.lex_state = 128, .external_lex_state = 2},
  [4153] = {.lex_state = 128, .external_lex_state = 5},
  [4154] = {.lex_state = 128, .external_lex_state = 2},
  [4155] = {.lex_state = 128, .external_lex_state = 5},
  [4156] = {.lex_state = 128, .external_lex_state = 5},
  [4157] = {.lex_state = 18, .external_lex_state = 9},
  [4158] = {.lex_state = 128, .external_lex_state = 5},
  [4159] = {.lex_state = 128, .external_lex_state = 5},
  [4160] = {.lex_state = 128, .external_lex_state = 5},
  [4161] = {.lex_state = 128, .external_lex_state = 5},
  [4162] = {.lex_state = 18, .external_lex_state = 9},
  [4163] = {.lex_state = 128, .external_lex_state = 5},
  [4164] = {.lex_state = 128, .external_lex_state = 5},
  [4165] = {.lex_state = 128, .external_lex_state = 5},
  [4166] = {.lex_state = 128, .external_lex_state = 5},
  [4167] = {.lex_state = 128, .external_lex_state = 2},
  [4168] = {.lex_state = 128, .external_lex_state = 5},
  [4169] = {.lex_state = 128, .external_lex_state = 5},
  [4170] = {.lex_state = 128, .external_lex_state = 5},
  [4171] = {.lex_state = 128, .external_lex_state = 5},
  [4172] = {.lex_state = 128, .external_lex_state = 5},
  [4173] = {.lex_state = 128, .external_lex_state = 5},
  [4174] = {.lex_state = 18, .external_lex_state = 7},
  [4175] = {.lex_state = 18, .external_lex_state = 7},
  [4176] = {.lex_state = 128, .external_lex_state = 5},
  [4177] = {.lex_state = 128, .external_lex_state = 5},
  [4178] = {.lex_state = 128, .external_lex_state = 5},
  [4179] = {.lex_state = 128, .external_lex_state = 5},
  [4180] = {.lex_state = 128, .external_lex_state = 5},
  [4181] = {.lex_state = 128, .external_lex_state = 2},
  [4182] = {.lex_state = 128, .external_lex_state = 5},
  [4183] = {.lex_state = 128, .external_lex_state = 5},
  [4184] = {.lex_state = 128, .external_lex_state = 5},
  [4185] = {.lex_state = 128, .external_lex_state = 2},
  [4186] = {.lex_state = 128, .external_lex_state = 5},
  [4187] = {.lex_state = 18, .external_lex_state = 7},
  [4188] = {.lex_state = 128, .external_lex_state = 5},
  [4189] = {.lex_state = 128, .external_lex_state = 5},
  [4190] = {.lex_state = 18, .external_lex_state = 7},
  [4191] = {.lex_state = 128, .external_lex_state = 5},
  [4192] = {.lex_state = 128, .external_lex_state = 5},
  [4193] = {.lex_state = 128, .external_lex_state = 2},
  [4194] = {.lex_state = 128, .external_lex_state = 2},
  [4195] = {.lex_state = 18, .external_lex_state = 7},
  [4196] = {.lex_state = 18, .external_lex_state = 7},
  [4197] = {.lex_state = 128, .external_lex_state = 5},
  [4198] = {.lex_state = 128, .external_lex_state = 2},
  [4199] = {.lex_state = 128, .external_lex_state = 5},
  [4200] = {.lex_state = 11, .external_lex_state = 2},
  [4201] = {.lex_state = 128, .external_lex_state = 2},
  [4202] = {.lex_state = 128, .external_lex_state = 5},
  [4203] = {.lex_state = 128, .external_lex_state = 5},
  [4204] = {.lex_state = 128, .external_lex_state = 2},
  [4205] = {.lex_state = 128, .external_lex_state = 5},
  [4206] = {.lex_state = 128, .external_lex_state = 5},
  [4207] = {.lex_state = 128, .external_lex_state = 5},
  [4208] = {.lex_state = 128, .external_lex_state = 5},
  [4209] = {.lex_state = 128, .external_lex_state = 2},
  [4210] = {.lex_state = 128, .external_lex_state = 5},
  [4211] = {.lex_state = 128, .external_lex_state = 2},
  [4212] = {.lex_state = 128, .external_lex_state = 2},
  [4213] = {.lex_state = 128, .external_lex_state = 5},
  [4214] = {.lex_state = 128, .external_lex_state = 2},
  [4215] = {.lex_state = 128, .external_lex_state = 2},
  [4216] = {.lex_state = 128, .external_lex_state = 5},
  [4217] = {.lex_state = 128, .external_lex_state = 5},
  [4218] = {.lex_state = 128, .external_lex_state = 5},
  [4219] = {.lex_state = 128, .external_lex_state = 5},
  [4220] = {.lex_state = 128, .external_lex_state = 5},
  [4221] = {.lex_state = 128, .external_lex_state = 2},
  [4222] = {.lex_state = 128, .external_lex_state = 2},
  [4223] = {.lex_state = 18, .external_lex_state = 9},
  [4224] = {.lex_state = 128, .external_lex_state = 5},
  [4225] = {.lex_state = 128, .external_lex_state = 5},
  [4226] = {.lex_state = 128, .external_lex_state = 5},
  [4227] = {.lex_state = 128, .external_lex_state = 5},
  [4228] = {.lex_state = 128, .external_lex_state = 2},
  [4229] = {.lex_state = 18, .external_lex_state = 7},
  [4230] = {.lex_state = 18, .external_lex_state = 7},
  [4231] = {.lex_state = 18, .external_lex_state = 7},
  [4232] = {.lex_state = 18, .external_lex_state = 7},
  [4233] = {.lex_state = 18, .external_lex_state = 7},
  [4234] = {.lex_state = 18, .external_lex_state = 7},
  [4235] = {.lex_state = 128, .external_lex_state = 5},
  [4236] = {.lex_state = 128, .external_lex_state = 5},
  [4237] = {.lex_state = 128, .external_lex_state = 2},
  [4238] = {.lex_state = 128, .external_lex_state = 5},
  [4239] = {.lex_state = 128, .external_lex_state = 5},
  [4240] = {.lex_state = 18, .external_lex_state = 7},
  [4241] = {.lex_state = 18, .external_lex_state = 7},
  [4242] = {.lex_state = 128, .external_lex_state = 5},
  [4243] = {.lex_state = 128, .external_lex_state = 5},
  [4244] = {.lex_state = 128, .external_lex_state = 2},
  [4245] = {.lex_state = 128, .external_lex_state = 5},
  [4246] = {.lex_state = 128, .external_lex_state = 2},
  [4247] = {.lex_state = 128, .external_lex_state = 2},
  [4248] = {.lex_state = 128, .external_lex_state = 5},
  [4249] = {.lex_state = 128, .external_lex_state = 5},
  [4250] = {.lex_state = 128, .external_lex_state = 5},
  [4251] = {.lex_state = 2, .external_lex_state = 2},
  [4252] = {.lex_state = 128, .external_lex_state = 2},
  [4253] = {.lex_state = 20, .external_lex_state = 2},
  [4254] = {.lex_state = 20, .external_lex_state = 2},
  [4255] = {.lex_state = 18, .external_lex_state = 7},
  [4256] = {.lex_state = 18, .external_lex_state = 7},
  [4257] = {.lex_state = 128, .external_lex_state = 2},
  [4258] = {.lex_state = 128, .external_lex_state = 2},
  [4259] = {.lex_state = 128, .external_lex_state = 5},
  [4260] = {.lex_state = 128, .external_lex_state = 2},
  [4261] = {.lex_state = 128, .external_lex_state = 2},
  [4262] = {.lex_state = 128, .external_lex_state = 5},
  [4263] = {.lex_state = 128, .external_lex_state = 5},
  [4264] = {.lex_state = 128, .external_lex_state = 5},
  [4265] = {.lex_state = 128, .external_lex_state = 5},
  [4266] = {.lex_state = 128, .external_lex_state = 5},
  [4267] = {.lex_state = 128, .external_lex_state = 5},
  [4268] = {.lex_state = 18, .external_lex_state = 7},
  [4269] = {.lex_state = 18, .external_lex_state = 7},
  [4270] = {.lex_state = 128, .external_lex_state = 5},
  [4271] = {.lex_state = 128, .external_lex_state = 5},
  [4272] = {.lex_state = 128, .external_lex_state = 2},
  [4273] = {.lex_state = 128, .external_lex_state = 5},
  [4274] = {.lex_state = 128, .external_lex_state = 5},
  [4275] = {.lex_state = 128, .external_lex_state = 5},
  [4276] = {.lex_state = 128, .external_lex_state = 2},
  [4277] = {.lex_state = 128, .external_lex_state = 5},
  [4278] = {.lex_state = 128, .external_lex_state = 5},
  [4279] = {.lex_state = 128, .external_lex_state = 5},
  [4280] = {.lex_state = 128, .external_lex_state = 2},
  [4281] = {.lex_state = 128, .external_lex_state = 2},
  [4282] = {.lex_state = 128, .external_lex_state = 5},
  [4283] = {.lex_state = 128, .external_lex_state = 5},
  [4284] = {.lex_state = 128, .external_lex_state = 2},
  [4285] = {.lex_state = 128, .external_lex_state = 5},
  [4286] = {.lex_state = 128, .external_lex_state = 5},
  [4287] = {.lex_state = 128, .external_lex_state = 2},
  [4288] = {.lex_state = 128, .external_lex_state = 5},
  [4289] = {.lex_state = 128, .external_lex_state = 2},
  [4290] = {.lex_state = 128, .external_lex_state = 2},
  [4291] = {.lex_state = 128, .external_lex_state = 2},
  [4292] = {.lex_state = 128, .external_lex_state = 2},
  [4293] = {.lex_state = 128, .external_lex_state = 5},
  [4294] = {.lex_state = 128, .external_lex_state = 2},
  [4295] = {.lex_state = 128, .external_lex_state = 5},
  [4296] = {.lex_state = 128, .external_lex_state = 5},
  [4297] = {.lex_state = 128, .external_lex_state = 5},
  [4298] = {.lex_state = 128, .external_lex_state = 5},
  [4299] = {.lex_state = 128, .external_lex_state = 2},
  [4300] = {.lex_state = 128, .external_lex_state = 2},
  [4301] = {.lex_state = 128, .external_lex_state = 2},
  [4302] = {.lex_state = 128, .external_lex_state = 2},
  [4303] = {.lex_state = 128, .external_lex_state = 2},
  [4304] = {.lex_state = 20, .external_lex_state = 2},
  [4305] = {.lex_state = 20, .external_lex_state = 2},
  [4306] = {.lex_state = 128, .external_lex_state = 5},
  [4307] = {.lex_state = 128, .external_lex_state = 5},
  [4308] = {.lex_state = 128, .external_lex_state = 2},
  [4309] = {.lex_state = 128, .external_lex_state = 5},
  [4310] = {.lex_state = 128, .external_lex_state = 2},
  [4311] = {.lex_state = 128, .external_lex_state = 5},
  [4312] = {.lex_state = 7, .external_lex_state = 2},
  [4313] = {.lex_state = 128, .external_lex_state = 5},
  [4314] = {.lex_state = 128, .external_lex_state = 5},
  [4315] = {.lex_state = 20, .external_lex_state = 2},
  [4316] = {.lex_state = 20, .external_lex_state = 2},
  [4317] = {.lex_state = 128, .external_lex_state = 5},
  [4318] = {.lex_state = 128, .external_lex_state = 2},
  [4319] = {.lex_state = 128, .external_lex_state = 5},
  [4320] = {.lex_state = 20, .external_lex_state = 2},
  [4321] = {.lex_state = 20, .external_lex_state = 2},
  [4322] = {.lex_state = 128, .external_lex_state = 5},
  [4323] = {.lex_state = 128, .external_lex_state = 5},
  [4324] = {.lex_state = 128, .external_lex_state = 5},
  [4325] = {.lex_state = 128, .external_lex_state = 5},
  [4326] = {.lex_state = 128, .external_lex_state = 5},
  [4327] = {.lex_state = 128, .external_lex_state = 5},
  [4328] = {.lex_state = 128, .external_lex_state = 5},
  [4329] = {.lex_state = 128, .external_lex_state = 5},
  [4330] = {.lex_state = 128, .external_lex_state = 2},
  [4331] = {.lex_state = 128, .external_lex_state = 5},
  [4332] = {.lex_state = 128, .external_lex_state = 5},
  [4333] = {.lex_state = 128, .external_lex_state = 2},
  [4334] = {.lex_state = 128, .external_lex_state = 5},
  [4335] = {.lex_state = 128, .external_lex_state = 5},
  [4336] = {.lex_state = 128, .external_lex_state = 5},
  [4337] = {.lex_state = 20, .external_lex_state = 2},
  [4338] = {.lex_state = 20, .external_lex_state = 2},
  [4339] = {.lex_state = 20, .external_lex_state = 2},
  [4340] = {.lex_state = 128, .external_lex_state = 5},
  [4341] = {.lex_state = 20, .external_lex_state = 2},
  [4342] = {.lex_state = 20, .external_lex_state = 2},
  [4343] = {.lex_state = 20, .external_lex_state = 2},
  [4344] = {.lex_state = 128, .external_lex_state = 2},
  [4345] = {.lex_state = 128, .external_lex_state = 5},
  [4346] = {.lex_state = 20, .external_lex_state = 2},
  [4347] = {.lex_state = 20, .external_lex_state = 2},
  [4348] = {.lex_state = 128, .external_lex_state = 5},
  [4349] = {.lex_state = 128, .external_lex_state = 2},
  [4350] = {.lex_state = 128, .external_lex_state = 5},
  [4351] = {.lex_state = 128, .external_lex_state = 5},
  [4352] = {.lex_state = 128, .external_lex_state = 5},
  [4353] = {.lex_state = 128, .external_lex_state = 5},
  [4354] = {.lex_state = 128, .external_lex_state = 5},
  [4355] = {.lex_state = 128, .external_lex_state = 5},
  [4356] = {.lex_state = 128, .external_lex_state = 5},
  [4357] = {.lex_state = 128, .external_lex_state = 5},
  [4358] = {.lex_state = 128, .external_lex_state = 5},
  [4359] = {.lex_state = 128, .external_lex_state = 5},
  [4360] = {.lex_state = 128, .external_lex_state = 5},
  [4361] = {.lex_state = 20, .external_lex_state = 2},
  [4362] = {.lex_state = 20, .external_lex_state = 2},
  [4363] = {.lex_state = 128, .external_lex_state = 5},
  [4364] = {.lex_state = 128, .external_lex_state = 2},
  [4365] = {.lex_state = 128, .external_lex_state = 2},
  [4366] = {.lex_state = 128, .external_lex_state = 5},
  [4367] = {.lex_state = 128, .external_lex_state = 2},
  [4368] = {.lex_state = 128, .external_lex_state = 5},
  [4369] = {.lex_state = 128, .external_lex_state = 2},
  [4370] = {.lex_state = 128, .external_lex_state = 5},
  [4371] = {.lex_state = 128, .external_lex_state = 5},
  [4372] = {.lex_state = 128, .external_lex_state = 5},
  [4373] = {.lex_state = 128, .external_lex_state = 5},
  [4374] = {.lex_state = 18, .external_lex_state = 9},
  [4375] = {.lex_state = 128, .external_lex_state = 5},
  [4376] = {.lex_state = 128, .external_lex_state = 5},
  [4377] = {.lex_state = 128, .external_lex_state = 5},
  [4378] = {.lex_state = 128, .external_lex_state = 5},
  [4379] = {.lex_state = 128, .external_lex_state = 2},
  [4380] = {.lex_state = 128, .external_lex_state = 2},
  [4381] = {.lex_state = 128, .external_lex_state = 2},
  [4382] = {.lex_state = 128, .external_lex_state = 5},
  [4383] = {.lex_state = 128, .external_lex_state = 2},
  [4384] = {.lex_state = 128, .external_lex_state = 2},
  [4385] = {.lex_state = 128, .external_lex_state = 2},
  [4386] = {.lex_state = 128, .external_lex_state = 2},
  [4387] = {.lex_state = 128, .external_lex_state = 2},
  [4388] = {.lex_state = 128, .external_lex_state = 6},
  [4389] = {.lex_state = 128, .external_lex_state = 5},
  [4390] = {.lex_state = 128, .external_lex_state = 5},
  [4391] = {.lex_state = 128, .external_lex_state = 5},
  [4392] = {.lex_state = 128, .external_lex_state = 5},
  [4393] = {.lex_state = 128, .external_lex_state = 5},
  [4394] = {.lex_state = 128, .external_lex_state = 5},
  [4395] = {.lex_state = 18, .external_lex_state = 9},
  [4396] = {.lex_state = 128, .external_lex_state = 5},
  [4397] = {.lex_state = 128, .external_lex_state = 5},
  [4398] = {.lex_state = 128, .external_lex_state = 5},
  [4399] = {.lex_state = 128, .external_lex_state = 5},
  [4400] = {.lex_state = 128, .external_lex_state = 5},
  [4401] = {.lex_state = 20, .external_lex_state = 2},
  [4402] = {.lex_state = 128, .external_lex_state = 5},
  [4403] = {.lex_state = 8, .external_lex_state = 2},
  [4404] = {.lex_state = 128, .external_lex_state = 5},
  [4405] = {.lex_state = 128, .external_lex_state = 5},
  [4406] = {.lex_state = 128, .external_lex_state = 5},
  [4407] = {.lex_state = 128, .external_lex_state = 5},
  [4408] = {.lex_state = 128, .external_lex_state = 5},
  [4409] = {.lex_state = 128, .external_lex_state = 2},
  [4410] = {.lex_state = 128, .external_lex_state = 2},
  [4411] = {.lex_state = 128, .external_lex_state = 2},
  [4412] = {.lex_state = 128, .external_lex_state = 2},
  [4413] = {.lex_state = 128, .external_lex_state = 6},
  [4414] = {.lex_state = 128, .external_lex_state = 5},
  [4415] = {.lex_state = 128, .external_lex_state = 5},
  [4416] = {.lex_state = 128, .external_lex_state = 5},
  [4417] = {.lex_state = 18, .external_lex_state = 7},
  [4418] = {.lex_state = 128, .external_lex_state = 5},
  [4419] = {.lex_state = 18, .external_lex_state = 7},
  [4420] = {.lex_state = 128, .external_lex_state = 5},
  [4421] = {.lex_state = 20, .external_lex_state = 2},
  [4422] = {.lex_state = 128, .external_lex_state = 5},
  [4423] = {.lex_state = 128, .external_lex_state = 5},
  [4424] = {.lex_state = 128, .external_lex_state = 2},
  [4425] = {.lex_state = 128, .external_lex_state = 5},
  [4426] = {.lex_state = 128, .external_lex_state = 5},
  [4427] = {.lex_state = 18, .external_lex_state = 7},
  [4428] = {.lex_state = 128, .external_lex_state = 6},
  [4429] = {.lex_state = 8, .external_lex_state = 2},
  [4430] = {.lex_state = 128, .external_lex_state = 5},
  [4431] = {.lex_state = 128, .external_lex_state = 5},
  [4432] = {.lex_state = 8, .external_lex_state = 2},
  [4433] = {.lex_state = 128, .external_lex_state = 5},
  [4434] = {.lex_state = 128, .external_lex_state = 5},
  [4435] = {.lex_state = 128, .external_lex_state = 2},
  [4436] = {.lex_state = 128, .external_lex_state = 5},
  [4437] = {.lex_state = 18, .external_lex_state = 7},
  [4438] = {.lex_state = 128, .external_lex_state = 5},
  [4439] = {.lex_state = 128, .external_lex_state = 5},
  [4440] = {.lex_state = 18, .external_lex_state = 7},
  [4441] = {.lex_state = 128, .external_lex_state = 2},
  [4442] = {.lex_state = 128, .external_lex_state = 5},
  [4443] = {.lex_state = 128, .external_lex_state = 5},
  [4444] = {.lex_state = 128, .external_lex_state = 2},
  [4445] = {.lex_state = 128, .external_lex_state = 5},
  [4446] = {.lex_state = 128, .external_lex_state = 5},
  [4447] = {.lex_state = 128, .external_lex_state = 5},
  [4448] = {.lex_state = 18, .external_lex_state = 7},
  [4449] = {.lex_state = 128, .external_lex_state = 2},
  [4450] = {.lex_state = 128, .external_lex_state = 2},
  [4451] = {.lex_state = 128, .external_lex_state = 5},
  [4452] = {.lex_state = 7, .external_lex_state = 2},
  [4453] = {.lex_state = 128, .external_lex_state = 5},
  [4454] = {.lex_state = 128, .external_lex_state = 5},
  [4455] = {.lex_state = 128, .external_lex_state = 5},
  [4456] = {.lex_state = 128, .external_lex_state = 5},
  [4457] = {.lex_state = 128, .external_lex_state = 2},
  [4458] = {.lex_state = 128, .external_lex_state = 5},
  [4459] = {.lex_state = 128, .external_lex_state = 5},
  [4460] = {.lex_state = 128, .external_lex_state = 2},
  [4461] = {.lex_state = 12, .external_lex_state = 2},
  [4462] = {.lex_state = 14, .external_lex_state = 10},
  [4463] = {.lex_state = 23, .external_lex_state = 10},
  [4464] = {.lex_state = 128, .external_lex_state = 2},
  [4465] = {.lex_state = 128, .external_lex_state = 2},
  [4466] = {.lex_state = 128, .external_lex_state = 2},
  [4467] = {.lex_state = 128, .external_lex_state = 2},
  [4468] = {.lex_state = 128, .external_lex_state = 2},
  [4469] = {.lex_state = 2, .external_lex_state = 2},
  [4470] = {.lex_state = 128, .external_lex_state = 5},
  [4471] = {.lex_state = 128, .external_lex_state = 2},
  [4472] = {.lex_state = 128, .external_lex_state = 5},
  [4473] = {.lex_state = 128, .external_lex_state = 5},
  [4474] = {.lex_state = 128, .external_lex_state = 2},
  [4475] = {.lex_state = 14, .external_lex_state = 10},
  [4476] = {.lex_state = 128, .external_lex_state = 5},
  [4477] = {.lex_state = 128, .external_lex_state = 2},
  [4478] = {.lex_state = 128, .external_lex_state = 5},
  [4479] = {.lex_state = 128, .external_lex_state = 2},
  [4480] = {.lex_state = 128, .external_lex_state = 2},
  [4481] = {.lex_state = 128, .external_lex_state = 2},
  [4482] = {.lex_state = 128, .external_lex_state = 2},
  [4483] = {.lex_state = 128, .external_lex_state = 2},
  [4484] = {.lex_state = 128, .external_lex_state = 5},
  [4485] = {.lex_state = 128, .external_lex_state = 2},
  [4486] = {.lex_state = 128, .external_lex_state = 2},
  [4487] = {.lex_state = 128, .external_lex_state = 5},
  [4488] = {.lex_state = 128, .external_lex_state = 2},
  [4489] = {.lex_state = 128, .external_lex_state = 5},
  [4490] = {.lex_state = 128, .external_lex_state = 2},
  [4491] = {.lex_state = 128, .external_lex_state = 2},
  [4492] = {.lex_state = 128, .external_lex_state = 2},
  [4493] = {.lex_state = 128, .external_lex_state = 2},
  [4494] = {.lex_state = 18, .external_lex_state = 8},
  [4495] = {.lex_state = 128, .external_lex_state = 2},
  [4496] = {.lex_state = 128, .external_lex_state = 5},
  [4497] = {.lex_state = 14, .external_lex_state = 10},
  [4498] = {.lex_state = 23, .external_lex_state = 10},
  [4499] = {.lex_state = 128, .external_lex_state = 2},
  [4500] = {.lex_state = 128, .external_lex_state = 2},
  [4501] = {.lex_state = 14, .external_lex_state = 10},
  [4502] = {.lex_state = 128, .external_lex_state = 2},
  [4503] = {.lex_state = 23, .external_lex_state = 10},
  [4504] = {.lex_state = 128, .external_lex_state = 2},
  [4505] = {.lex_state = 128, .external_lex_state = 2},
  [4506] = {.lex_state = 128, .external_lex_state = 5},
  [4507] = {.lex_state = 23, .external_lex_state = 10},
  [4508] = {.lex_state = 128, .external_lex_state = 2},
  [4509] = {.lex_state = 128, .external_lex_state = 2},
  [4510] = {.lex_state = 128, .external_lex_state = 5},
  [4511] = {.lex_state = 128, .external_lex_state = 2},
  [4512] = {.lex_state = 128, .external_lex_state = 2},
  [4513] = {.lex_state = 128, .external_lex_state = 2},
  [4514] = {.lex_state = 128, .external_lex_state = 2},
  [4515] = {.lex_state = 128, .external_lex_state = 2},
  [4516] = {.lex_state = 128, .external_lex_state = 5},
  [4517] = {.lex_state = 128, .external_lex_state = 5},
  [4518] = {.lex_state = 128, .external_lex_state = 2},
  [4519] = {.lex_state = 128, .external_lex_state = 2},
  [4520] = {.lex_state = 128, .external_lex_state = 2},
  [4521] = {.lex_state = 128, .external_lex_state = 2},
  [4522] = {.lex_state = 12, .external_lex_state = 2},
  [4523] = {.lex_state = 21, .external_lex_state = 2},
  [4524] = {.lex_state = 128, .external_lex_state = 2},
  [4525] = {.lex_state = 128, .external_lex_state = 2},
  [4526] = {.lex_state = 128, .external_lex_state = 6},
  [4527] = {.lex_state = 128, .external_lex_state = 2},
  [4528] = {.lex_state = 2, .external_lex_state = 2},
  [4529] = {.lex_state = 14, .external_lex_state = 10},
  [4530] = {.lex_state = 128, .external_lex_state = 2},
  [4531] = {.lex_state = 128, .external_lex_state = 2},
  [4532] = {.lex_state = 128, .external_lex_state = 2},
  [4533] = {.lex_state = 128, .external_lex_state = 2},
  [4534] = {.lex_state = 7, .external_lex_state = 2},
  [4535] = {.lex_state = 128, .external_lex_state = 2},
  [4536] = {.lex_state = 14, .external_lex_state = 10},
  [4537] = {.lex_state = 128, .external_lex_state = 2},
  [4538] = {.lex_state = 23, .external_lex_state = 10},
  [4539] = {.lex_state = 128, .external_lex_state = 2},
  [4540] = {.lex_state = 128, .external_lex_state = 2},
  [4541] = {.lex_state = 23, .external_lex_state = 10},
  [4542] = {.lex_state = 128, .external_lex_state = 2},
  [4543] = {.lex_state = 128, .external_lex_state = 2},
  [4544] = {.lex_state = 14, .external_lex_state = 10},
  [4545] = {.lex_state = 23, .external_lex_state = 10},
  [4546] = {.lex_state = 14, .external_lex_state = 10},
  [4547] = {.lex_state = 12, .external_lex_state = 2},
  [4548] = {.lex_state = 23, .external_lex_state = 10},
  [4549] = {.lex_state = 128, .external_lex_state = 2},
  [4550] = {.lex_state = 128, .external_lex_state = 2},
  [4551] = {.lex_state = 21, .external_lex_state = 2},
  [4552] = {.lex_state = 128, .external_lex_state = 2},
  [4553] = {.lex_state = 14, .external_lex_state = 10},
  [4554] = {.lex_state = 128, .external_lex_state = 2},
  [4555] = {.lex_state = 128, .external_lex_state = 5},
  [4556] = {.lex_state = 23, .external_lex_state = 10},
  [4557] = {.lex_state = 14, .external_lex_state = 10},
  [4558] = {.lex_state = 23, .external_lex_state = 10},
  [4559] = {.lex_state = 128, .external_lex_state = 2},
  [4560] = {.lex_state = 128, .external_lex_state = 2},
  [4561] = {.lex_state = 18, .external_lex_state = 8},
  [4562] = {.lex_state = 23, .external_lex_state = 10},
  [4563] = {.lex_state = 14, .external_lex_state = 10},
  [4564] = {.lex_state = 128, .external_lex_state = 2},
  [4565] = {.lex_state = 128, .external_lex_state = 2},
  [4566] = {.lex_state = 128, .external_lex_state = 2},
  [4567] = {.lex_state = 14, .external_lex_state = 10},
  [4568] = {.lex_state = 23, .external_lex_state = 10},
  [4569] = {.lex_state = 128, .external_lex_state = 2},
  [4570] = {.lex_state = 128, .external_lex_state = 2},
  [4571] = {.lex_state = 14, .external_lex_state = 10},
  [4572] = {.lex_state = 23, .external_lex_state = 10},
  [4573] = {.lex_state = 128, .external_lex_state = 2},
  [4574] = {.lex_state = 128, .external_lex_state = 2},
  [4575] = {.lex_state = 128, .external_lex_state = 5},
  [4576] = {.lex_state = 128, .external_lex_state = 2},
  [4577] = {.lex_state = 128, .external_lex_state = 2},
  [4578] = {.lex_state = 128, .external_lex_state = 2},
  [4579] = {.lex_state = 128, .external_lex_state = 2},
  [4580] = {.lex_state = 128, .external_lex_state = 2},
  [4581] = {.lex_state = 23, .external_lex_state = 10},
  [4582] = {.lex_state = 128, .external_lex_state = 2},
  [4583] = {.lex_state = 128, .external_lex_state = 2},
  [4584] = {.lex_state = 128, .external_lex_state = 5},
  [4585] = {.lex_state = 21, .external_lex_state = 2},
  [4586] = {.lex_state = 7, .external_lex_state = 2},
  [4587] = {.lex_state = 128, .external_lex_state = 5},
  [4588] = {.lex_state = 14, .external_lex_state = 10},
  [4589] = {.lex_state = 128, .external_lex_state = 2},
  [4590] = {.lex_state = 128, .external_lex_state = 2},
  [4591] = {.lex_state = 23, .external_lex_state = 10},
  [4592] = {.lex_state = 128, .external_lex_state = 2},
  [4593] = {.lex_state = 128, .external_lex_state = 2},
  [4594] = {.lex_state = 128, .external_lex_state = 2},
  [4595] = {.lex_state = 128, .external_lex_state = 2},
  [4596] = {.lex_state = 128, .external_lex_state = 2},
  [4597] = {.lex_state = 128, .external_lex_state = 2},
  [4598] = {.lex_state = 2, .external_lex_state = 2},
  [4599] = {.lex_state = 128, .external_lex_state = 2},
  [4600] = {.lex_state = 128, .external_lex_state = 2},
  [4601] = {.lex_state = 2, .external_lex_state = 2},
  [4602] = {.lex_state = 2, .external_lex_state = 2},
  [4603] = {.lex_state = 128, .external_lex_state = 2},
  [4604] = {.lex_state = 14, .external_lex_state = 10},
  [4605] = {.lex_state = 128, .external_lex_state = 5},
  [4606] = {.lex_state = 128, .external_lex_state = 2},
  [4607] = {.lex_state = 128, .external_lex_state = 2},
  [4608] = {.lex_state = 128, .external_lex_state = 2},
  [4609] = {.lex_state = 128, .external_lex_state = 2},
  [4610] = {.lex_state = 128, .external_lex_state = 2},
  [4611] = {.lex_state = 128, .external_lex_state = 5},
  [4612] = {.lex_state = 128, .external_lex_state = 2},
  [4613] = {.lex_state = 128, .external_lex_state = 5},
  [4614] = {.lex_state = 128, .external_lex_state = 5},
  [4615] = {.lex_state = 128, .external_lex_state = 2},
  [4616] = {.lex_state = 128, .external_lex_state = 5},
  [4617] = {.lex_state = 128, .external_lex_state = 2},
  [4618] = {.lex_state = 128, .external_lex_state = 2},
  [4619] = {.lex_state = 128, .external_lex_state = 2},
  [4620] = {.lex_state = 128, .external_lex_state = 2},
  [4621] = {.lex_state = 128, .external_lex_state = 5},
  [4622] = {.lex_state = 128, .external_lex_state = 2},
  [4623] = {.lex_state = 128, .external_lex_state = 5},
  [4624] = {.lex_state = 128, .external_lex_state = 2},
  [4625] = {.lex_state = 128, .external_lex_state = 2},
  [4626] = {.lex_state = 128, .external_lex_state = 5},
  [4627] = {.lex_state = 128, .external_lex_state = 5},
  [4628] = {.lex_state = 128, .external_lex_state = 5},
  [4629] = {.lex_state = 128, .external_lex_state = 2},
  [4630] = {.lex_state = 128, .external_lex_state = 5},
  [4631] = {.lex_state = 128, .external_lex_state = 5},
  [4632] = {.lex_state = 128, .external_lex_state = 5},
  [4633] = {.lex_state = 128, .external_lex_state = 2},
  [4634] = {.lex_state = 128, .external_lex_state = 5},
  [4635] = {.lex_state = 128, .external_lex_state = 5},
  [4636] = {.lex_state = 128, .external_lex_state = 5},
  [4637] = {.lex_state = 128, .external_lex_state = 5},
  [4638] = {.lex_state = 128, .external_lex_state = 5},
  [4639] = {.lex_state = 128, .external_lex_state = 5},
  [4640] = {.lex_state = 128, .external_lex_state = 2},
  [4641] = {.lex_state = 128, .external_lex_state = 2},
  [4642] = {.lex_state = 128, .external_lex_state = 2},
  [4643] = {.lex_state = 128, .external_lex_state = 5},
  [4644] = {.lex_state = 128, .external_lex_state = 5},
  [4645] = {.lex_state = 128, .external_lex_state = 5},
  [4646] = {.lex_state = 128, .external_lex_state = 2},
  [4647] = {.lex_state = 128, .external_lex_state = 5},
  [4648] = {.lex_state = 128, .external_lex_state = 2},
  [4649] = {.lex_state = 128, .external_lex_state = 2},
  [4650] = {.lex_state = 128, .external_lex_state = 2},
  [4651] = {.lex_state = 128, .external_lex_state = 5},
  [4652] = {.lex_state = 128, .external_lex_state = 2},
  [4653] = {.lex_state = 128, .external_lex_state = 5},
  [4654] = {.lex_state = 128, .external_lex_state = 2},
  [4655] = {.lex_state = 128, .external_lex_state = 2},
  [4656] = {.lex_state = 128, .external_lex_state = 5},
  [4657] = {.lex_state = 128, .external_lex_state = 2},
  [4658] = {.lex_state = 128, .external_lex_state = 2},
  [4659] = {.lex_state = 128, .external_lex_state = 2},
  [4660] = {.lex_state = 128, .external_lex_state = 5},
  [4661] = {.lex_state = 128, .external_lex_state = 5},
  [4662] = {.lex_state = 128, .external_lex_state = 5},
  [4663] = {.lex_state = 128, .external_lex_state = 2},
  [4664] = {.lex_state = 128, .external_lex_state = 5},
  [4665] = {.lex_state = 128, .external_lex_state = 2},
  [4666] = {.lex_state = 128, .external_lex_state = 2},
  [4667] = {.lex_state = 2, .external_lex_state = 2},
  [4668] = {.lex_state = 128, .external_lex_state = 5},
  [4669] = {.lex_state = 128, .external_lex_state = 5},
  [4670] = {.lex_state = 128, .external_lex_state = 5},
  [4671] = {.lex_state = 128, .external_lex_state = 5},
  [4672] = {.lex_state = 2, .external_lex_state = 2},
  [4673] = {.lex_state = 128, .external_lex_state = 2},
  [4674] = {.lex_state = 128, .external_lex_state = 2},
  [4675] = {.lex_state = 128, .external_lex_state = 2},
  [4676] = {.lex_state = 128, .external_lex_state = 2},
  [4677] = {.lex_state = 128, .external_lex_state = 5},
  [4678] = {.lex_state = 128, .external_lex_state = 2},
  [4679] = {.lex_state = 128, .external_lex_state = 5},
  [4680] = {.lex_state = 128, .external_lex_state = 5},
  [4681] = {.lex_state = 128, .external_lex_state = 5},
  [4682] = {.lex_state = 128, .external_lex_state = 2},
  [4683] = {.lex_state = 128, .external_lex_state = 2},
  [4684] = {.lex_state = 128, .external_lex_state = 2},
  [4685] = {.lex_state = 128, .external_lex_state = 5},
  [4686] = {.lex_state = 128, .external_lex_state = 2},
  [4687] = {.lex_state = 128, .external_lex_state = 2},
  [4688] = {.lex_state = 128, .external_lex_state = 5},
  [4689] = {.lex_state = 128, .external_lex_state = 5},
  [4690] = {.lex_state = 128, .external_lex_state = 2},
  [4691] = {.lex_state = 128, .external_lex_state = 2},
  [4692] = {.lex_state = 128, .external_lex_state = 2},
  [4693] = {.lex_state = 128, .external_lex_state = 2},
  [4694] = {.lex_state = 128, .external_lex_state = 5},
  [4695] = {.lex_state = 128, .external_lex_state = 2},
  [4696] = {.lex_state = 128, .external_lex_state = 5},
  [4697] = {.lex_state = 128, .external_lex_state = 5},
  [4698] = {.lex_state = 128, .external_lex_state = 5},
  [4699] = {.lex_state = 128, .external_lex_state = 5},
  [4700] = {.lex_state = 128, .external_lex_state = 5},
  [4701] = {.lex_state = 128, .external_lex_state = 5},
  [4702] = {.lex_state = 128, .external_lex_state = 5},
  [4703] = {.lex_state = 128, .external_lex_state = 5},
  [4704] = {.lex_state = 128, .external_lex_state = 5},
  [4705] = {.lex_state = 128, .external_lex_state = 5},
  [4706] = {.lex_state = 128, .external_lex_state = 5},
  [4707] = {.lex_state = 128, .external_lex_state = 2},
  [4708] = {.lex_state = 128, .external_lex_state = 2},
  [4709] = {.lex_state = 128, .external_lex_state = 5},
  [4710] = {.lex_state = 128, .external_lex_state = 5},
  [4711] = {.lex_state = 128, .external_lex_state = 2},
  [4712] = {.lex_state = 128, .external_lex_state = 5},
  [4713] = {.lex_state = 128, .external_lex_state = 2},
  [4714] = {.lex_state = 128, .external_lex_state = 2},
  [4715] = {.lex_state = 128, .external_lex_state = 2},
  [4716] = {.lex_state = 128, .external_lex_state = 5},
  [4717] = {.lex_state = 128, .external_lex_state = 5},
  [4718] = {.lex_state = 128, .external_lex_state = 2},
  [4719] = {.lex_state = 128, .external_lex_state = 5},
  [4720] = {.lex_state = 128, .external_lex_state = 5},
  [4721] = {.lex_state = 128, .external_lex_state = 2},
  [4722] = {.lex_state = 128, .external_lex_state = 5},
  [4723] = {.lex_state = 128, .external_lex_state = 2},
  [4724] = {.lex_state = 128, .external_lex_state = 2},
  [4725] = {.lex_state = 128, .external_lex_state = 5},
  [4726] = {.lex_state = 128, .external_lex_state = 2},
  [4727] = {.lex_state = 128, .external_lex_state = 5},
  [4728] = {.lex_state = 128, .external_lex_state = 5},
  [4729] = {.lex_state = 128, .external_lex_state = 2},
  [4730] = {.lex_state = 128, .external_lex_state = 5},
  [4731] = {.lex_state = 128, .external_lex_state = 2},
  [4732] = {.lex_state = 128, .external_lex_state = 5},
  [4733] = {.lex_state = 128, .external_lex_state = 5},
  [4734] = {.lex_state = 128, .external_lex_state = 5},
  [4735] = {.lex_state = 128, .external_lex_state = 5},
  [4736] = {.lex_state = 128, .external_lex_state = 5},
  [4737] = {.lex_state = 128, .external_lex_state = 5},
  [4738] = {.lex_state = 128, .external_lex_state = 5},
  [4739] = {.lex_state = 128, .external_lex_state = 5},
  [4740] = {.lex_state = 128, .external_lex_state = 5},
  [4741] = {.lex_state = 128, .external_lex_state = 5},
  [4742] = {.lex_state = 128, .external_lex_state = 5},
  [4743] = {.lex_state = 128, .external_lex_state = 2},
  [4744] = {.lex_state = 128, .external_lex_state = 5},
  [4745] = {.lex_state = 128, .external_lex_state = 5},
  [4746] = {.lex_state = 128, .external_lex_state = 5},
  [4747] = {.lex_state = 128, .external_lex_state = 5},
  [4748] = {.lex_state = 128, .external_lex_state = 5},
  [4749] = {.lex_state = 128, .external_lex_state = 2},
  [4750] = {.lex_state = 128, .external_lex_state = 2},
  [4751] = {.lex_state = 128, .external_lex_state = 5},
  [4752] = {.lex_state = 128, .external_lex_state = 5},
  [4753] = {.lex_state = 128, .external_lex_state = 2},
  [4754] = {.lex_state = 128, .external_lex_state = 5},
  [4755] = {.lex_state = 128, .external_lex_state = 5},
  [4756] = {.lex_state = 128, .external_lex_state = 5},
  [4757] = {.lex_state = 128, .external_lex_state = 5},
  [4758] = {.lex_state = 128, .external_lex_state = 5},
  [4759] = {.lex_state = 128, .external_lex_state = 5},
  [4760] = {.lex_state = 128, .external_lex_state = 2},
  [4761] = {.lex_state = 128, .external_lex_state = 2},
  [4762] = {.lex_state = 128, .external_lex_state = 5},
  [4763] = {.lex_state = 128, .external_lex_state = 5},
  [4764] = {.lex_state = 128, .external_lex_state = 2},
  [4765] = {.lex_state = 128, .external_lex_state = 5},
  [4766] = {.lex_state = 128, .external_lex_state = 5},
  [4767] = {.lex_state = 128, .external_lex_state = 5},
  [4768] = {.lex_state = 128, .external_lex_state = 2},
  [4769] = {.lex_state = 128, .external_lex_state = 2},
  [4770] = {.lex_state = 128, .external_lex_state = 5},
  [4771] = {.lex_state = 128, .external_lex_state = 5},
  [4772] = {.lex_state = 128, .external_lex_state = 5},
  [4773] = {.lex_state = 128, .external_lex_state = 5},
  [4774] = {.lex_state = 128, .external_lex_state = 5},
  [4775] = {.lex_state = 128, .external_lex_state = 5},
  [4776] = {.lex_state = 128, .external_lex_state = 5},
  [4777] = {.lex_state = 128, .external_lex_state = 5},
  [4778] = {.lex_state = 128, .external_lex_state = 5},
  [4779] = {.lex_state = 128, .external_lex_state = 5},
  [4780] = {.lex_state = 128, .external_lex_state = 5},
  [4781] = {.lex_state = 128, .external_lex_state = 5},
  [4782] = {.lex_state = 128, .external_lex_state = 5},
  [4783] = {.lex_state = 128, .external_lex_state = 2},
  [4784] = {.lex_state = 128, .external_lex_state = 2},
  [4785] = {.lex_state = 128, .external_lex_state = 5},
  [4786] = {.lex_state = 128, .external_lex_state = 2},
  [4787] = {.lex_state = 128, .external_lex_state = 2},
  [4788] = {.lex_state = 128, .external_lex_state = 2},
  [4789] = {.lex_state = 128, .external_lex_state = 2},
  [4790] = {.lex_state = 128, .external_lex_state = 5},
  [4791] = {.lex_state = 128, .external_lex_state = 2},
  [4792] = {.lex_state = 128, .external_lex_state = 5},
  [4793] = {.lex_state = 128, .external_lex_state = 2},
  [4794] = {.lex_state = 128, .external_lex_state = 5},
  [4795] = {.lex_state = 128, .external_lex_state = 5},
  [4796] = {.lex_state = 128, .external_lex_state = 5},
  [4797] = {.lex_state = 128, .external_lex_state = 5},
  [4798] = {.lex_state = 128, .external_lex_state = 5},
  [4799] = {.lex_state = 128, .external_lex_state = 5},
  [4800] = {.lex_state = 128, .external_lex_state = 2},
  [4801] = {.lex_state = 128, .external_lex_state = 2},
  [4802] = {.lex_state = 128, .external_lex_state = 5},
  [4803] = {.lex_state = 128, .external_lex_state = 5},
  [4804] = {.lex_state = 128, .external_lex_state = 5},
  [4805] = {.lex_state = 128, .external_lex_state = 2},
  [4806] = {.lex_state = 128, .external_lex_state = 5},
  [4807] = {.lex_state = 2, .external_lex_state = 2},
  [4808] = {.lex_state = 128, .external_lex_state = 5},
  [4809] = {.lex_state = 128, .external_lex_state = 2},
  [4810] = {.lex_state = 128, .external_lex_state = 5},
  [4811] = {.lex_state = 128, .external_lex_state = 5},
  [4812] = {.lex_state = 128, .external_lex_state = 5},
  [4813] = {.lex_state = 128, .external_lex_state = 5},
  [4814] = {.lex_state = 128, .external_lex_state = 5},
  [4815] = {.lex_state = 128, .external_lex_state = 2},
  [4816] = {.lex_state = 128, .external_lex_state = 5},
  [4817] = {.lex_state = 128, .external_lex_state = 2},
  [4818] = {.lex_state = 128, .external_lex_state = 5},
  [4819] = {.lex_state = 128, .external_lex_state = 2},
  [4820] = {.lex_state = 128, .external_lex_state = 5},
  [4821] = {.lex_state = 2, .external_lex_state = 2},
  [4822] = {.lex_state = 128, .external_lex_state = 5},
  [4823] = {.lex_state = 128, .external_lex_state = 2},
  [4824] = {.lex_state = 128, .external_lex_state = 5},
  [4825] = {.lex_state = 128, .external_lex_state = 5},
  [4826] = {.lex_state = 128, .external_lex_state = 2},
  [4827] = {.lex_state = 128, .external_lex_state = 5},
  [4828] = {.lex_state = 128, .external_lex_state = 2},
  [4829] = {.lex_state = 128, .external_lex_state = 5},
  [4830] = {.lex_state = 128, .external_lex_state = 2},
  [4831] = {.lex_state = 128, .external_lex_state = 5},
  [4832] = {.lex_state = 128, .external_lex_state = 5},
  [4833] = {.lex_state = 128, .external_lex_state = 2},
  [4834] = {.lex_state = 128, .external_lex_state = 2},
  [4835] = {.lex_state = 128, .external_lex_state = 2},
  [4836] = {.lex_state = 128, .external_lex_state = 5},
  [4837] = {.lex_state = 128, .external_lex_state = 5},
  [4838] = {.lex_state = 128, .external_lex_state = 5},
  [4839] = {.lex_state = 128, .external_lex_state = 5},
  [4840] = {.lex_state = 128, .external_lex_state = 5},
  [4841] = {.lex_state = 128, .external_lex_state = 2},
  [4842] = {.lex_state = 128, .external_lex_state = 5},
  [4843] = {.lex_state = 128, .external_lex_state = 5},
  [4844] = {.lex_state = 128, .external_lex_state = 2},
  [4845] = {.lex_state = 128, .external_lex_state = 5},
  [4846] = {.lex_state = 128, .external_lex_state = 5},
  [4847] = {.lex_state = 128, .external_lex_state = 2},
  [4848] = {.lex_state = 128, .external_lex_state = 2},
  [4849] = {.lex_state = 128, .external_lex_state = 2},
  [4850] = {.lex_state = 128, .external_lex_state = 5},
  [4851] = {.lex_state = 128, .external_lex_state = 5},
  [4852] = {.lex_state = 128, .external_lex_state = 5},
  [4853] = {.lex_state = 128, .external_lex_state = 5},
  [4854] = {.lex_state = 128, .external_lex_state = 5},
  [4855] = {.lex_state = 128, .external_lex_state = 2},
  [4856] = {.lex_state = 128, .external_lex_state = 5},
  [4857] = {.lex_state = 128, .external_lex_state = 5},
  [4858] = {.lex_state = 128, .external_lex_state = 5},
  [4859] = {.lex_state = 128, .external_lex_state = 5},
  [4860] = {.lex_state = 128, .external_lex_state = 5},
  [4861] = {.lex_state = 128, .external_lex_state = 2},
  [4862] = {.lex_state = 128, .external_lex_state = 5},
  [4863] = {.lex_state = 128, .external_lex_state = 5},
  [4864] = {.lex_state = 128, .external_lex_state = 5},
  [4865] = {.lex_state = 128, .external_lex_state = 5},
  [4866] = {.lex_state = 128, .external_lex_state = 5},
  [4867] = {.lex_state = 128, .external_lex_state = 5},
  [4868] = {.lex_state = 128, .external_lex_state = 2},
  [4869] = {.lex_state = 128, .external_lex_state = 5},
  [4870] = {.lex_state = 128, .external_lex_state = 2},
  [4871] = {.lex_state = 128, .external_lex_state = 5},
  [4872] = {.lex_state = 128, .external_lex_state = 5},
  [4873] = {.lex_state = 128, .external_lex_state = 2},
  [4874] = {.lex_state = 128, .external_lex_state = 5},
  [4875] = {.lex_state = 128, .external_lex_state = 5},
  [4876] = {.lex_state = 128, .external_lex_state = 2},
  [4877] = {.lex_state = 128, .external_lex_state = 5},
  [4878] = {.lex_state = 128, .external_lex_state = 5},
  [4879] = {.lex_state = 128, .external_lex_state = 5},
  [4880] = {.lex_state = 128, .external_lex_state = 5},
  [4881] = {.lex_state = 128, .external_lex_state = 2},
  [4882] = {.lex_state = 128, .external_lex_state = 5},
  [4883] = {.lex_state = 128, .external_lex_state = 5},
  [4884] = {.lex_state = 128, .external_lex_state = 5},
  [4885] = {.lex_state = 128, .external_lex_state = 2},
  [4886] = {.lex_state = 128, .external_lex_state = 5},
  [4887] = {.lex_state = 128, .external_lex_state = 2},
  [4888] = {.lex_state = 128, .external_lex_state = 5},
  [4889] = {.lex_state = 128, .external_lex_state = 2},
  [4890] = {.lex_state = 128, .external_lex_state = 5},
  [4891] = {.lex_state = 128, .external_lex_state = 5},
  [4892] = {.lex_state = 128, .external_lex_state = 5},
  [4893] = {.lex_state = 128, .external_lex_state = 5},
  [4894] = {.lex_state = 128, .external_lex_state = 5},
  [4895] = {.lex_state = 128, .external_lex_state = 5},
  [4896] = {.lex_state = 128, .external_lex_state = 5},
  [4897] = {.lex_state = 128, .external_lex_state = 5},
  [4898] = {.lex_state = 128, .external_lex_state = 5},
  [4899] = {.lex_state = 128, .external_lex_state = 5},
  [4900] = {.lex_state = 128, .external_lex_state = 5},
  [4901] = {.lex_state = 128, .external_lex_state = 2},
  [4902] = {.lex_state = 128, .external_lex_state = 5},
  [4903] = {.lex_state = 128, .external_lex_state = 5},
  [4904] = {.lex_state = 128, .external_lex_state = 5},
  [4905] = {.lex_state = 128, .external_lex_state = 5},
  [4906] = {.lex_state = 128, .external_lex_state = 5},
  [4907] = {.lex_state = 128, .external_lex_state = 5},
  [4908] = {.lex_state = 128, .external_lex_state = 5},
  [4909] = {.lex_state = 128, .external_lex_state = 5},
  [4910] = {.lex_state = 128, .external_lex_state = 5},
  [4911] = {.lex_state = 128, .external_lex_state = 5},
  [4912] = {.lex_state = 128, .external_lex_state = 2},
  [4913] = {.lex_state = 128, .external_lex_state = 5},
  [4914] = {.lex_state = 128, .external_lex_state = 5},
  [4915] = {.lex_state = 128, .external_lex_state = 5},
  [4916] = {.lex_state = 128, .external_lex_state = 5},
  [4917] = {.lex_state = 128, .external_lex_state = 5},
  [4918] = {.lex_state = 128, .external_lex_state = 5},
  [4919] = {.lex_state = 128, .external_lex_state = 2},
  [4920] = {.lex_state = 128, .external_lex_state = 5},
  [4921] = {.lex_state = 128, .external_lex_state = 2},
  [4922] = {.lex_state = 128, .external_lex_state = 5},
  [4923] = {.lex_state = 128, .external_lex_state = 2},
  [4924] = {.lex_state = 128, .external_lex_state = 2},
  [4925] = {.lex_state = 2, .external_lex_state = 2},
  [4926] = {.lex_state = 128, .external_lex_state = 5},
  [4927] = {.lex_state = 128, .external_lex_state = 5},
  [4928] = {.lex_state = 128, .external_lex_state = 5},
  [4929] = {.lex_state = 128, .external_lex_state = 5},
  [4930] = {.lex_state = 128, .external_lex_state = 5},
  [4931] = {.lex_state = 128, .external_lex_state = 5},
  [4932] = {.lex_state = 128, .external_lex_state = 5},
  [4933] = {.lex_state = 128, .external_lex_state = 5},
  [4934] = {.lex_state = 128, .external_lex_state = 5},
  [4935] = {.lex_state = 128, .external_lex_state = 2},
  [4936] = {.lex_state = 128, .external_lex_state = 5},
  [4937] = {.lex_state = 128, .external_lex_state = 5},
  [4938] = {.lex_state = 128, .external_lex_state = 5},
  [4939] = {.lex_state = 128, .external_lex_state = 5},
  [4940] = {.lex_state = 128, .external_lex_state = 5},
  [4941] = {.lex_state = 128, .external_lex_state = 5},
  [4942] = {.lex_state = 128, .external_lex_state = 2},
  [4943] = {.lex_state = 128, .external_lex_state = 2},
  [4944] = {.lex_state = 128, .external_lex_state = 2},
  [4945] = {.lex_state = 128, .external_lex_state = 5},
  [4946] = {.lex_state = 128, .external_lex_state = 5},
  [4947] = {.lex_state = 128, .external_lex_state = 5},
  [4948] = {.lex_state = 128, .external_lex_state = 5},
  [4949] = {.lex_state = 128, .external_lex_state = 5},
  [4950] = {.lex_state = 128, .external_lex_state = 5},
  [4951] = {.lex_state = 128, .external_lex_state = 5},
  [4952] = {.lex_state = 128, .external_lex_state = 5},
  [4953] = {.lex_state = 128, .external_lex_state = 5},
  [4954] = {.lex_state = 128, .external_lex_state = 5},
  [4955] = {.lex_state = 128, .external_lex_state = 5},
  [4956] = {.lex_state = 128, .external_lex_state = 5},
  [4957] = {.lex_state = 128, .external_lex_state = 5},
  [4958] = {.lex_state = 128, .external_lex_state = 2},
  [4959] = {.lex_state = 128, .external_lex_state = 5},
  [4960] = {.lex_state = 128, .external_lex_state = 5},
  [4961] = {.lex_state = 128, .external_lex_state = 5},
  [4962] = {.lex_state = 128, .external_lex_state = 5},
  [4963] = {.lex_state = 128, .external_lex_state = 5},
  [4964] = {.lex_state = 128, .external_lex_state = 5},
  [4965] = {.lex_state = 128, .external_lex_state = 5},
  [4966] = {.lex_state = 128, .external_lex_state = 5},
  [4967] = {.lex_state = 128, .external_lex_state = 5},
  [4968] = {.lex_state = 128, .external_lex_state = 5},
  [4969] = {.lex_state = 128, .external_lex_state = 5},
  [4970] = {.lex_state = 128, .external_lex_state = 5},
  [4971] = {.lex_state = 128, .external_lex_state = 5},
  [4972] = {.lex_state = 128, .external_lex_state = 5},
  [4973] = {.lex_state = 128, .external_lex_state = 5},
  [4974] = {.lex_state = 128, .external_lex_state = 5},
  [4975] = {.lex_state = 128, .external_lex_state = 5},
  [4976] = {.lex_state = 128, .external_lex_state = 5},
  [4977] = {.lex_state = 128, .external_lex_state = 5},
  [4978] = {.lex_state = 128, .external_lex_state = 5},
  [4979] = {.lex_state = 128, .external_lex_state = 5},
  [4980] = {.lex_state = 128, .external_lex_state = 5},
  [4981] = {.lex_state = 128, .external_lex_state = 5},
  [4982] = {.lex_state = 128, .external_lex_state = 5},
  [4983] = {.lex_state = 128, .external_lex_state = 5},
  [4984] = {.lex_state = 128, .external_lex_state = 5},
  [4985] = {.lex_state = 128, .external_lex_state = 2},
  [4986] = {.lex_state = 128, .external_lex_state = 5},
  [4987] = {.lex_state = 128, .external_lex_state = 5},
  [4988] = {.lex_state = 128, .external_lex_state = 5},
  [4989] = {.lex_state = 128, .external_lex_state = 5},
  [4990] = {.lex_state = 128, .external_lex_state = 5},
  [4991] = {.lex_state = 128, .external_lex_state = 5},
  [4992] = {.lex_state = 128, .external_lex_state = 5},
  [4993] = {.lex_state = 128, .external_lex_state = 5},
  [4994] = {.lex_state = 128, .external_lex_state = 5},
  [4995] = {.lex_state = 128, .external_lex_state = 5},
  [4996] = {.lex_state = 128, .external_lex_state = 5},
  [4997] = {.lex_state = 128, .external_lex_state = 5},
  [4998] = {.lex_state = 128, .external_lex_state = 5},
  [4999] = {.lex_state = 128, .external_lex_state = 2},
  [5000] = {.lex_state = 128, .external_lex_state = 5},
  [5001] = {.lex_state = 128, .external_lex_state = 5},
  [5002] = {.lex_state = 128, .external_lex_state = 5},
  [5003] = {.lex_state = 128, .external_lex_state = 5},
  [5004] = {.lex_state = 128, .external_lex_state = 5},
  [5005] = {.lex_state = 128, .external_lex_state = 5},
  [5006] = {.lex_state = 128, .external_lex_state = 5},
  [5007] = {.lex_state = 128, .external_lex_state = 5},
  [5008] = {.lex_state = 128, .external_lex_state = 5},
  [5009] = {.lex_state = 128, .external_lex_state = 5},
  [5010] = {.lex_state = 128, .external_lex_state = 5},
  [5011] = {.lex_state = 128, .external_lex_state = 2},
  [5012] = {.lex_state = 128, .external_lex_state = 5},
  [5013] = {.lex_state = 128, .external_lex_state = 5},
  [5014] = {.lex_state = 128, .external_lex_state = 5},
  [5015] = {.lex_state = 128, .external_lex_state = 5},
  [5016] = {.lex_state = 128, .external_lex_state = 5},
  [5017] = {.lex_state = 128, .external_lex_state = 5},
  [5018] = {.lex_state = 128, .external_lex_state = 5},
  [5019] = {.lex_state = 128, .external_lex_state = 5},
  [5020] = {.lex_state = 128, .external_lex_state = 5},
  [5021] = {.lex_state = 128, .external_lex_state = 5},
  [5022] = {.lex_state = 2, .external_lex_state = 2},
  [5023] = {.lex_state = 128, .external_lex_state = 2},
  [5024] = {.lex_state = 2, .external_lex_state = 2},
  [5025] = {.lex_state = 128, .external_lex_state = 5},
  [5026] = {.lex_state = 128, .external_lex_state = 5},
  [5027] = {.lex_state = 128, .external_lex_state = 2},
  [5028] = {.lex_state = 128, .external_lex_state = 5},
  [5029] = {.lex_state = 128, .external_lex_state = 2},
  [5030] = {.lex_state = 128, .external_lex_state = 5},
  [5031] = {.lex_state = 128, .external_lex_state = 5},
  [5032] = {.lex_state = 128, .external_lex_state = 5},
  [5033] = {.lex_state = 128, .external_lex_state = 5},
  [5034] = {.lex_state = 128, .external_lex_state = 5},
  [5035] = {.lex_state = 128, .external_lex_state = 5},
  [5036] = {.lex_state = 128, .external_lex_state = 5},
  [5037] = {.lex_state = 128, .external_lex_state = 5},
  [5038] = {.lex_state = 128, .external_lex_state = 5},
  [5039] = {.lex_state = 128, .external_lex_state = 5},
  [5040] = {.lex_state = 128, .external_lex_state = 5},
  [5041] = {.lex_state = 128, .external_lex_state = 5},
  [5042] = {.lex_state = 128, .external_lex_state = 5},
  [5043] = {.lex_state = 128, .external_lex_state = 5},
  [5044] = {.lex_state = 128, .external_lex_state = 5},
  [5045] = {.lex_state = 128, .external_lex_state = 5},
  [5046] = {.lex_state = 128, .external_lex_state = 5},
  [5047] = {.lex_state = 128, .external_lex_state = 2},
  [5048] = {.lex_state = 128, .external_lex_state = 5},
  [5049] = {.lex_state = 128, .external_lex_state = 5},
  [5050] = {.lex_state = 128, .external_lex_state = 5},
  [5051] = {.lex_state = 128, .external_lex_state = 5},
  [5052] = {.lex_state = 128, .external_lex_state = 5},
  [5053] = {.lex_state = 128, .external_lex_state = 5},
  [5054] = {.lex_state = 128, .external_lex_state = 5},
  [5055] = {.lex_state = 128, .external_lex_state = 5},
  [5056] = {.lex_state = 128, .external_lex_state = 5},
  [5057] = {.lex_state = 128, .external_lex_state = 5},
  [5058] = {.lex_state = 128, .external_lex_state = 5},
  [5059] = {.lex_state = 128, .external_lex_state = 5},
  [5060] = {.lex_state = 128, .external_lex_state = 2},
  [5061] = {.lex_state = 128, .external_lex_state = 2},
  [5062] = {.lex_state = 128, .external_lex_state = 5},
  [5063] = {.lex_state = 128, .external_lex_state = 5},
  [5064] = {.lex_state = 128, .external_lex_state = 5},
  [5065] = {.lex_state = 128, .external_lex_state = 5},
  [5066] = {.lex_state = 128, .external_lex_state = 2},
  [5067] = {.lex_state = 128, .external_lex_state = 5},
  [5068] = {.lex_state = 128, .external_lex_state = 5},
  [5069] = {.lex_state = 2, .external_lex_state = 2},
  [5070] = {.lex_state = 128, .external_lex_state = 5},
  [5071] = {.lex_state = 2, .external_lex_state = 2},
  [5072] = {.lex_state = 128, .external_lex_state = 2},
  [5073] = {.lex_state = 128, .external_lex_state = 5},
  [5074] = {.lex_state = 128, .external_lex_state = 5},
  [5075] = {.lex_state = 128, .external_lex_state = 5},
  [5076] = {.lex_state = 128, .external_lex_state = 5},
  [5077] = {.lex_state = 128, .external_lex_state = 2},
  [5078] = {.lex_state = 128, .external_lex_state = 5},
  [5079] = {.lex_state = 128, .external_lex_state = 5},
  [5080] = {.lex_state = 128, .external_lex_state = 5},
  [5081] = {.lex_state = 128, .external_lex_state = 5},
  [5082] = {.lex_state = 128, .external_lex_state = 5},
  [5083] = {.lex_state = 128, .external_lex_state = 2},
  [5084] = {.lex_state = 128, .external_lex_state = 5},
  [5085] = {.lex_state = 128, .external_lex_state = 5},
  [5086] = {.lex_state = 128, .external_lex_state = 5},
  [5087] = {.lex_state = 128, .external_lex_state = 5},
  [5088] = {.lex_state = 128, .external_lex_state = 2},
  [5089] = {.lex_state = 128, .external_lex_state = 2},
  [5090] = {.lex_state = 128, .external_lex_state = 5},
  [5091] = {.lex_state = 128, .external_lex_state = 5},
  [5092] = {.lex_state = 128, .external_lex_state = 5},
  [5093] = {.lex_state = 128, .external_lex_state = 2},
  [5094] = {.lex_state = 128, .external_lex_state = 2},
  [5095] = {.lex_state = 128, .external_lex_state = 2},
  [5096] = {.lex_state = 128, .external_lex_state = 5},
  [5097] = {.lex_state = 128, .external_lex_state = 5},
  [5098] = {.lex_state = 128, .external_lex_state = 5},
  [5099] = {.lex_state = 128, .external_lex_state = 2},
  [5100] = {.lex_state = 128, .external_lex_state = 2},
  [5101] = {.lex_state = 128, .external_lex_state = 2},
  [5102] = {.lex_state = 128, .external_lex_state = 5},
  [5103] = {.lex_state = 128, .external_lex_state = 5},
  [5104] = {.lex_state = 128, .external_lex_state = 2},
  [5105] = {.lex_state = 128, .external_lex_state = 5},
  [5106] = {.lex_state = 128, .external_lex_state = 2},
  [5107] = {.lex_state = 18, .external_lex_state = 9},
  [5108] = {.lex_state = 128, .external_lex_state = 5},
  [5109] = {.lex_state = 128, .external_lex_state = 2},
  [5110] = {.lex_state = 128, .external_lex_state = 5},
  [5111] = {.lex_state = 128, .external_lex_state = 2},
  [5112] = {.lex_state = 128, .external_lex_state = 2},
  [5113] = {.lex_state = 128, .external_lex_state = 5},
  [5114] = {.lex_state = 128, .external_lex_state = 5},
  [5115] = {.lex_state = 128, .external_lex_state = 2},
  [5116] = {.lex_state = 128, .external_lex_state = 2},
  [5117] = {.lex_state = 128, .external_lex_state = 5},
  [5118] = {.lex_state = 128, .external_lex_state = 5},
  [5119] = {.lex_state = 128, .external_lex_state = 2},
  [5120] = {.lex_state = 128, .external_lex_state = 5},
  [5121] = {.lex_state = 128, .external_lex_state = 5},
  [5122] = {.lex_state = 128, .external_lex_state = 5},
  [5123] = {.lex_state = 128, .external_lex_state = 5},
  [5124] = {.lex_state = 2, .external_lex_state = 2},
  [5125] = {.lex_state = 128, .external_lex_state = 5},
  [5126] = {.lex_state = 128, .external_lex_state = 5},
  [5127] = {.lex_state = 128, .external_lex_state = 5},
  [5128] = {.lex_state = 128, .external_lex_state = 5},
  [5129] = {.lex_state = 128, .external_lex_state = 2},
  [5130] = {.lex_state = 128, .external_lex_state = 5},
  [5131] = {.lex_state = 128, .external_lex_state = 2},
  [5132] = {.lex_state = 128, .external_lex_state = 2},
  [5133] = {.lex_state = 128, .external_lex_state = 2},
  [5134] = {.lex_state = 128, .external_lex_state = 2},
  [5135] = {.lex_state = 128, .external_lex_state = 5},
  [5136] = {.lex_state = 128, .external_lex_state = 2},
  [5137] = {.lex_state = 128, .external_lex_state = 2},
  [5138] = {.lex_state = 128, .external_lex_state = 5},
  [5139] = {.lex_state = 128, .external_lex_state = 2},
  [5140] = {.lex_state = 128, .external_lex_state = 2},
  [5141] = {.lex_state = 128, .external_lex_state = 2},
  [5142] = {.lex_state = 128, .external_lex_state = 5},
  [5143] = {.lex_state = 2, .external_lex_state = 2},
  [5144] = {.lex_state = 128, .external_lex_state = 5},
  [5145] = {.lex_state = 128, .external_lex_state = 5},
  [5146] = {.lex_state = 128, .external_lex_state = 5},
  [5147] = {.lex_state = 128, .external_lex_state = 5},
  [5148] = {.lex_state = 128, .external_lex_state = 5},
  [5149] = {.lex_state = 2, .external_lex_state = 2},
  [5150] = {.lex_state = 128, .external_lex_state = 5},
  [5151] = {.lex_state = 128, .external_lex_state = 5},
  [5152] = {.lex_state = 128, .external_lex_state = 5},
  [5153] = {.lex_state = 128, .external_lex_state = 2},
  [5154] = {.lex_state = 128, .external_lex_state = 5},
  [5155] = {.lex_state = 128, .external_lex_state = 5},
  [5156] = {.lex_state = 128, .external_lex_state = 5},
  [5157] = {.lex_state = 128, .external_lex_state = 5},
  [5158] = {.lex_state = 128, .external_lex_state = 5},
  [5159] = {.lex_state = 128, .external_lex_state = 5},
  [5160] = {.lex_state = 128, .external_lex_state = 5},
  [5161] = {.lex_state = 128, .external_lex_state = 2},
  [5162] = {.lex_state = 128, .external_lex_state = 2},
  [5163] = {.lex_state = 128, .external_lex_state = 5},
  [5164] = {.lex_state = 128, .external_lex_state = 5},
  [5165] = {.lex_state = 128, .external_lex_state = 5},
  [5166] = {.lex_state = 128, .external_lex_state = 2},
  [5167] = {.lex_state = 128, .external_lex_state = 2},
  [5168] = {.lex_state = 128, .external_lex_state = 2},
  [5169] = {.lex_state = 128, .external_lex_state = 5},
  [5170] = {.lex_state = 128, .external_lex_state = 5},
  [5171] = {.lex_state = 128, .external_lex_state = 5},
  [5172] = {.lex_state = 128, .external_lex_state = 5},
  [5173] = {.lex_state = 128, .external_lex_state = 5},
  [5174] = {.lex_state = 128, .external_lex_state = 2},
  [5175] = {.lex_state = 128, .external_lex_state = 2},
  [5176] = {.lex_state = 128, .external_lex_state = 5},
  [5177] = {.lex_state = 128, .external_lex_state = 2},
  [5178] = {.lex_state = 128, .external_lex_state = 2},
  [5179] = {.lex_state = 128, .external_lex_state = 2},
  [5180] = {.lex_state = 128, .external_lex_state = 2},
  [5181] = {.lex_state = 128, .external_lex_state = 5},
  [5182] = {.lex_state = 128, .external_lex_state = 5},
  [5183] = {.lex_state = 128, .external_lex_state = 2},
  [5184] = {.lex_state = 128, .external_lex_state = 5},
  [5185] = {.lex_state = 128, .external_lex_state = 5},
  [5186] = {.lex_state = 128, .external_lex_state = 5},
  [5187] = {.lex_state = 128, .external_lex_state = 5},
  [5188] = {.lex_state = 128, .external_lex_state = 2},
  [5189] = {.lex_state = 128, .external_lex_state = 5},
  [5190] = {.lex_state = 128, .external_lex_state = 5},
  [5191] = {.lex_state = 128, .external_lex_state = 2},
  [5192] = {.lex_state = 128, .external_lex_state = 2},
  [5193] = {.lex_state = 128, .external_lex_state = 5},
  [5194] = {.lex_state = 128, .external_lex_state = 2},
  [5195] = {.lex_state = 128, .external_lex_state = 5},
  [5196] = {.lex_state = 128, .external_lex_state = 5},
  [5197] = {.lex_state = 128, .external_lex_state = 2},
  [5198] = {.lex_state = 128, .external_lex_state = 5},
  [5199] = {.lex_state = 128, .external_lex_state = 5},
  [5200] = {.lex_state = 128, .external_lex_state = 5},
  [5201] = {.lex_state = 128, .external_lex_state = 2},
  [5202] = {.lex_state = 128, .external_lex_state = 5},
  [5203] = {.lex_state = 128, .external_lex_state = 5},
  [5204] = {.lex_state = 128, .external_lex_state = 5},
  [5205] = {.lex_state = 128, .external_lex_state = 5},
  [5206] = {.lex_state = 128, .external_lex_state = 5},
  [5207] = {.lex_state = 128, .external_lex_state = 2},
  [5208] = {.lex_state = 128, .external_lex_state = 5},
  [5209] = {.lex_state = 128, .external_lex_state = 2},
  [5210] = {.lex_state = 128, .external_lex_state = 5},
  [5211] = {.lex_state = 128, .external_lex_state = 2},
  [5212] = {.lex_state = 128, .external_lex_state = 5},
  [5213] = {.lex_state = 128, .external_lex_state = 5},
  [5214] = {.lex_state = 128, .external_lex_state = 5},
  [5215] = {.lex_state = 128, .external_lex_state = 5},
  [5216] = {.lex_state = 128, .external_lex_state = 5},
  [5217] = {.lex_state = 2, .external_lex_state = 2},
  [5218] = {.lex_state = 128, .external_lex_state = 5},
  [5219] = {.lex_state = 128, .external_lex_state = 5},
  [5220] = {.lex_state = 128, .external_lex_state = 5},
  [5221] = {.lex_state = 128, .external_lex_state = 2},
  [5222] = {.lex_state = 128, .external_lex_state = 2},
  [5223] = {.lex_state = 128, .external_lex_state = 2},
  [5224] = {.lex_state = 128, .external_lex_state = 2},
  [5225] = {.lex_state = 128, .external_lex_state = 2},
  [5226] = {.lex_state = 128, .external_lex_state = 2},
  [5227] = {.lex_state = 128, .external_lex_state = 2},
  [5228] = {.lex_state = 128, .external_lex_state = 2},
  [5229] = {.lex_state = 128, .external_lex_state = 2},
  [5230] = {.lex_state = 128, .external_lex_state = 2},
  [5231] = {.lex_state = 128, .external_lex_state = 2},
  [5232] = {.lex_state = 128, .external_lex_state = 2},
  [5233] = {.lex_state = 128, .external_lex_state = 2},
  [5234] = {.lex_state = 128, .external_lex_state = 2},
  [5235] = {.lex_state = 128, .external_lex_state = 2},
  [5236] = {.lex_state = 128, .external_lex_state = 5},
  [5237] = {.lex_state = 128, .external_lex_state = 2},
  [5238] = {.lex_state = 128, .external_lex_state = 2},
  [5239] = {.lex_state = 128, .external_lex_state = 2},
  [5240] = {.lex_state = 128, .external_lex_state = 2},
  [5241] = {.lex_state = 128, .external_lex_state = 5},
  [5242] = {.lex_state = 128, .external_lex_state = 2},
  [5243] = {.lex_state = 128, .external_lex_state = 2},
  [5244] = {.lex_state = 128, .external_lex_state = 2},
  [5245] = {.lex_state = 128, .external_lex_state = 2},
  [5246] = {.lex_state = 128, .external_lex_state = 2},
  [5247] = {.lex_state = 128, .external_lex_state = 2},
  [5248] = {.lex_state = 128, .external_lex_state = 2},
  [5249] = {.lex_state = 128, .external_lex_state = 2},
  [5250] = {.lex_state = 128, .external_lex_state = 2},
  [5251] = {.lex_state = 128, .external_lex_state = 2},
  [5252] = {.lex_state = 128, .external_lex_state = 2},
  [5253] = {.lex_state = 128, .external_lex_state = 2},
  [5254] = {.lex_state = 128, .external_lex_state = 2},
  [5255] = {.lex_state = 128, .external_lex_state = 2},
  [5256] = {.lex_state = 128, .external_lex_state = 2},
  [5257] = {.lex_state = 128, .external_lex_state = 2},
  [5258] = {.lex_state = 128, .external_lex_state = 2},
  [5259] = {.lex_state = 128, .external_lex_state = 2},
  [5260] = {.lex_state = 128, .external_lex_state = 2},
  [5261] = {.lex_state = 128, .external_lex_state = 2},
  [5262] = {.lex_state = 128, .external_lex_state = 2},
  [5263] = {.lex_state = 128, .external_lex_state = 2},
  [5264] = {.lex_state = 128, .external_lex_state = 2},
  [5265] = {.lex_state = 128, .external_lex_state = 2},
  [5266] = {.lex_state = 128, .external_lex_state = 2},
  [5267] = {.lex_state = 128, .external_lex_state = 2},
  [5268] = {.lex_state = 128, .external_lex_state = 2},
  [5269] = {.lex_state = 128, .external_lex_state = 2},
  [5270] = {.lex_state = 128, .external_lex_state = 2},
  [5271] = {.lex_state = 128, .external_lex_state = 5},
  [5272] = {.lex_state = 128, .external_lex_state = 2},
  [5273] = {.lex_state = 128, .external_lex_state = 2},
  [5274] = {.lex_state = 128, .external_lex_state = 2},
  [5275] = {.lex_state = 128, .external_lex_state = 2},
  [5276] = {.lex_state = 128, .external_lex_state = 2},
  [5277] = {.lex_state = 128, .external_lex_state = 2},
  [5278] = {.lex_state = 128, .external_lex_state = 2},
  [5279] = {.lex_state = 128, .external_lex_state = 2},
  [5280] = {.lex_state = 128, .external_lex_state = 2},
  [5281] = {.lex_state = 128, .external_lex_state = 2},
  [5282] = {.lex_state = 128, .external_lex_state = 2},
  [5283] = {.lex_state = 128, .external_lex_state = 2},
  [5284] = {.lex_state = 128, .external_lex_state = 2},
  [5285] = {.lex_state = 128, .external_lex_state = 2},
  [5286] = {.lex_state = 128, .external_lex_state = 2},
  [5287] = {.lex_state = 128, .external_lex_state = 2},
  [5288] = {.lex_state = 128, .external_lex_state = 2},
  [5289] = {.lex_state = 128, .external_lex_state = 2},
  [5290] = {.lex_state = 128, .external_lex_state = 2},
  [5291] = {.lex_state = 128, .external_lex_state = 2},
  [5292] = {.lex_state = 128, .external_lex_state = 5},
  [5293] = {.lex_state = 128, .external_lex_state = 2},
  [5294] = {.lex_state = 128, .external_lex_state = 2},
  [5295] = {.lex_state = 128, .external_lex_state = 5},
  [5296] = {.lex_state = 128, .external_lex_state = 5},
  [5297] = {.lex_state = 128, .external_lex_state = 5},
  [5298] = {.lex_state = 128, .external_lex_state = 2},
  [5299] = {.lex_state = 128, .external_lex_state = 2},
  [5300] = {.lex_state = 128, .external_lex_state = 2},
  [5301] = {.lex_state = 128, .external_lex_state = 5},
  [5302] = {.lex_state = 128, .external_lex_state = 2},
  [5303] = {.lex_state = 128, .external_lex_state = 2},
  [5304] = {.lex_state = 128, .external_lex_state = 5},
  [5305] = {.lex_state = 128, .external_lex_state = 2},
  [5306] = {.lex_state = 128, .external_lex_state = 2},
  [5307] = {.lex_state = 128, .external_lex_state = 2},
  [5308] = {.lex_state = 128, .external_lex_state = 2},
  [5309] = {.lex_state = 128, .external_lex_state = 2},
  [5310] = {.lex_state = 128, .external_lex_state = 2},
  [5311] = {.lex_state = 128, .external_lex_state = 2},
  [5312] = {.lex_state = 128, .external_lex_state = 2},
  [5313] = {.lex_state = 128, .external_lex_state = 2},
  [5314] = {.lex_state = 128, .external_lex_state = 2},
  [5315] = {.lex_state = 128, .external_lex_state = 2},
  [5316] = {.lex_state = 128, .external_lex_state = 2},
  [5317] = {.lex_state = 128, .external_lex_state = 2},
  [5318] = {.lex_state = 128, .external_lex_state = 2},
  [5319] = {.lex_state = 128, .external_lex_state = 5},
  [5320] = {.lex_state = 128, .external_lex_state = 2},
  [5321] = {.lex_state = 128, .external_lex_state = 2},
  [5322] = {.lex_state = 128, .external_lex_state = 2},
  [5323] = {.lex_state = 128, .external_lex_state = 2},
  [5324] = {.lex_state = 128, .external_lex_state = 5},
  [5325] = {.lex_state = 128, .external_lex_state = 2},
  [5326] = {.lex_state = 128, .external_lex_state = 2},
  [5327] = {.lex_state = 128, .external_lex_state = 2},
  [5328] = {.lex_state = 128, .external_lex_state = 2},
  [5329] = {.lex_state = 128, .external_lex_state = 2},
  [5330] = {.lex_state = 128, .external_lex_state = 2},
  [5331] = {.lex_state = 128, .external_lex_state = 5},
  [5332] = {.lex_state = 128, .external_lex_state = 2},
  [5333] = {.lex_state = 128, .external_lex_state = 2},
  [5334] = {.lex_state = 128, .external_lex_state = 2},
  [5335] = {.lex_state = 128, .external_lex_state = 2},
  [5336] = {.lex_state = 128, .external_lex_state = 2},
  [5337] = {.lex_state = 128, .external_lex_state = 2},
  [5338] = {.lex_state = 128, .external_lex_state = 2},
  [5339] = {.lex_state = 128, .external_lex_state = 2},
  [5340] = {.lex_state = 128, .external_lex_state = 2},
  [5341] = {.lex_state = 128, .external_lex_state = 5},
  [5342] = {.lex_state = 128, .external_lex_state = 2},
  [5343] = {.lex_state = 128, .external_lex_state = 2},
  [5344] = {.lex_state = 128, .external_lex_state = 2},
  [5345] = {.lex_state = 128, .external_lex_state = 2},
  [5346] = {.lex_state = 128, .external_lex_state = 2},
  [5347] = {.lex_state = 128, .external_lex_state = 2},
  [5348] = {.lex_state = 128, .external_lex_state = 2},
  [5349] = {.lex_state = 128, .external_lex_state = 2},
  [5350] = {.lex_state = 128, .external_lex_state = 5},
  [5351] = {.lex_state = 128, .external_lex_state = 2},
  [5352] = {.lex_state = 128, .external_lex_state = 2},
  [5353] = {.lex_state = 128, .external_lex_state = 5},
  [5354] = {.lex_state = 128, .external_lex_state = 2},
  [5355] = {.lex_state = 128, .external_lex_state = 2},
  [5356] = {.lex_state = 128, .external_lex_state = 2},
  [5357] = {.lex_state = 128, .external_lex_state = 2},
  [5358] = {.lex_state = 128, .external_lex_state = 2},
  [5359] = {.lex_state = 128, .external_lex_state = 2},
  [5360] = {.lex_state = 128, .external_lex_state = 2},
  [5361] = {.lex_state = 128, .external_lex_state = 2},
  [5362] = {.lex_state = 128, .external_lex_state = 2},
  [5363] = {.lex_state = 128, .external_lex_state = 2},
  [5364] = {.lex_state = 128, .external_lex_state = 2},
  [5365] = {.lex_state = 128, .external_lex_state = 2},
  [5366] = {.lex_state = 128, .external_lex_state = 2},
  [5367] = {.lex_state = 128, .external_lex_state = 2},
  [5368] = {.lex_state = 128, .external_lex_state = 2},
  [5369] = {.lex_state = 128, .external_lex_state = 2},
  [5370] = {.lex_state = 128, .external_lex_state = 2},
  [5371] = {.lex_state = 128, .external_lex_state = 2},
  [5372] = {.lex_state = 128, .external_lex_state = 2},
  [5373] = {.lex_state = 128, .external_lex_state = 2},
  [5374] = {.lex_state = 128, .external_lex_state = 2},
  [5375] = {.lex_state = 128, .external_lex_state = 2},
  [5376] = {.lex_state = 128, .external_lex_state = 2},
  [5377] = {.lex_state = 128, .external_lex_state = 2},
  [5378] = {.lex_state = 128, .external_lex_state = 5},
  [5379] = {.lex_state = 128, .external_lex_state = 2},
  [5380] = {.lex_state = 128, .external_lex_state = 2},
  [5381] = {.lex_state = 128, .external_lex_state = 2},
  [5382] = {.lex_state = 128, .external_lex_state = 2},
  [5383] = {.lex_state = 128, .external_lex_state = 2},
  [5384] = {.lex_state = 128, .external_lex_state = 2},
  [5385] = {.lex_state = 128, .external_lex_state = 2},
  [5386] = {.lex_state = 128, .external_lex_state = 2},
  [5387] = {.lex_state = 128, .external_lex_state = 2},
  [5388] = {.lex_state = 128, .external_lex_state = 2},
  [5389] = {.lex_state = 128, .external_lex_state = 5},
  [5390] = {.lex_state = 128, .external_lex_state = 2},
  [5391] = {.lex_state = 128, .external_lex_state = 5},
  [5392] = {.lex_state = 128, .external_lex_state = 2},
  [5393] = {.lex_state = 128, .external_lex_state = 2},
  [5394] = {.lex_state = 128, .external_lex_state = 2},
  [5395] = {.lex_state = 128, .external_lex_state = 2},
  [5396] = {.lex_state = 128, .external_lex_state = 2},
  [5397] = {.lex_state = 128, .external_lex_state = 2},
  [5398] = {.lex_state = 128, .external_lex_state = 2},
  [5399] = {.lex_state = 128, .external_lex_state = 2},
  [5400] = {.lex_state = 128, .external_lex_state = 2},
  [5401] = {.lex_state = 128, .external_lex_state = 2},
  [5402] = {.lex_state = 128, .external_lex_state = 2},
  [5403] = {.lex_state = 128, .external_lex_state = 2},
  [5404] = {.lex_state = 128, .external_lex_state = 2},
  [5405] = {.lex_state = 128, .external_lex_state = 2},
  [5406] = {.lex_state = 128, .external_lex_state = 2},
  [5407] = {.lex_state = 128, .external_lex_state = 2},
  [5408] = {.lex_state = 128, .external_lex_state = 2},
  [5409] = {.lex_state = 128, .external_lex_state = 2},
  [5410] = {.lex_state = 128, .external_lex_state = 2},
  [5411] = {.lex_state = 128, .external_lex_state = 2},
  [5412] = {.lex_state = 128, .external_lex_state = 2},
  [5413] = {.lex_state = 128, .external_lex_state = 2},
  [5414] = {.lex_state = 128, .external_lex_state = 2},
  [5415] = {.lex_state = 128, .external_lex_state = 2},
  [5416] = {.lex_state = 128, .external_lex_state = 2},
  [5417] = {.lex_state = 128, .external_lex_state = 2},
  [5418] = {.lex_state = 128, .external_lex_state = 2},
  [5419] = {.lex_state = 128, .external_lex_state = 2},
  [5420] = {.lex_state = 128, .external_lex_state = 2},
  [5421] = {.lex_state = 128, .external_lex_state = 2},
  [5422] = {.lex_state = 128, .external_lex_state = 2},
  [5423] = {.lex_state = 128, .external_lex_state = 2},
  [5424] = {.lex_state = 128, .external_lex_state = 2},
  [5425] = {.lex_state = 128, .external_lex_state = 2},
  [5426] = {.lex_state = 128, .external_lex_state = 2},
  [5427] = {.lex_state = 128, .external_lex_state = 2},
  [5428] = {.lex_state = 128, .external_lex_state = 2},
  [5429] = {.lex_state = 128, .external_lex_state = 2},
  [5430] = {.lex_state = 128, .external_lex_state = 2},
  [5431] = {.lex_state = 128, .external_lex_state = 2},
  [5432] = {.lex_state = 128, .external_lex_state = 2},
  [5433] = {.lex_state = 128, .external_lex_state = 2},
  [5434] = {.lex_state = 128, .external_lex_state = 2},
  [5435] = {.lex_state = 128, .external_lex_state = 2},
  [5436] = {.lex_state = 128, .external_lex_state = 2},
  [5437] = {.lex_state = 128, .external_lex_state = 2},
  [5438] = {.lex_state = 128, .external_lex_state = 5},
  [5439] = {.lex_state = 128, .external_lex_state = 2},
  [5440] = {.lex_state = 128, .external_lex_state = 5},
  [5441] = {.lex_state = 128, .external_lex_state = 2},
  [5442] = {.lex_state = 128, .external_lex_state = 2},
  [5443] = {.lex_state = 128, .external_lex_state = 2},
  [5444] = {.lex_state = 128, .external_lex_state = 2},
  [5445] = {.lex_state = 128, .external_lex_state = 2},
  [5446] = {.lex_state = 128, .external_lex_state = 2},
  [5447] = {.lex_state = 128, .external_lex_state = 2},
  [5448] = {.lex_state = 128, .external_lex_state = 2},
  [5449] = {.lex_state = 128, .external_lex_state = 2},
  [5450] = {.lex_state = 128, .external_lex_state = 5},
  [5451] = {.lex_state = 128, .external_lex_state = 2},
  [5452] = {.lex_state = 128, .external_lex_state = 2},
  [5453] = {.lex_state = 128, .external_lex_state = 2},
  [5454] = {.lex_state = 128, .external_lex_state = 2},
  [5455] = {.lex_state = 128, .external_lex_state = 2},
  [5456] = {.lex_state = 128, .external_lex_state = 2},
  [5457] = {.lex_state = 128, .external_lex_state = 2},
  [5458] = {.lex_state = 128, .external_lex_state = 2},
  [5459] = {.lex_state = 128, .external_lex_state = 2},
  [5460] = {.lex_state = 128, .external_lex_state = 2},
  [5461] = {.lex_state = 128, .external_lex_state = 2},
  [5462] = {.lex_state = 128, .external_lex_state = 2},
  [5463] = {.lex_state = 128, .external_lex_state = 2},
  [5464] = {.lex_state = 128, .external_lex_state = 2},
  [5465] = {.lex_state = 128, .external_lex_state = 2},
  [5466] = {.lex_state = 128, .external_lex_state = 2},
  [5467] = {.lex_state = 128, .external_lex_state = 5},
  [5468] = {.lex_state = 128, .external_lex_state = 2},
  [5469] = {.lex_state = 128, .external_lex_state = 2},
  [5470] = {.lex_state = 128, .external_lex_state = 2},
  [5471] = {.lex_state = 128, .external_lex_state = 2},
  [5472] = {.lex_state = 128, .external_lex_state = 2},
  [5473] = {.lex_state = 128, .external_lex_state = 2},
  [5474] = {.lex_state = 128, .external_lex_state = 2},
  [5475] = {.lex_state = 128, .external_lex_state = 2},
  [5476] = {.lex_state = 128, .external_lex_state = 2},
  [5477] = {.lex_state = 128, .external_lex_state = 2},
  [5478] = {.lex_state = 128, .external_lex_state = 2},
  [5479] = {.lex_state = 128, .external_lex_state = 2},
  [5480] = {.lex_state = 128, .external_lex_state = 2},
  [5481] = {.lex_state = 128, .external_lex_state = 2},
  [5482] = {.lex_state = 128, .external_lex_state = 2},
  [5483] = {.lex_state = 128, .external_lex_state = 2},
  [5484] = {.lex_state = 128, .external_lex_state = 2},
  [5485] = {.lex_state = 128, .external_lex_state = 2},
  [5486] = {.lex_state = 128, .external_lex_state = 5},
  [5487] = {.lex_state = 128, .external_lex_state = 2},
  [5488] = {.lex_state = 128, .external_lex_state = 2},
  [5489] = {.lex_state = 128, .external_lex_state = 2},
  [5490] = {.lex_state = 128, .external_lex_state = 2},
  [5491] = {.lex_state = 128, .external_lex_state = 2},
  [5492] = {.lex_state = 128, .external_lex_state = 2},
  [5493] = {.lex_state = 128, .external_lex_state = 2},
  [5494] = {.lex_state = 128, .external_lex_state = 2},
  [5495] = {.lex_state = 128, .external_lex_state = 2},
  [5496] = {.lex_state = 128, .external_lex_state = 5},
  [5497] = {.lex_state = 128, .external_lex_state = 2},
  [5498] = {.lex_state = 128, .external_lex_state = 2},
  [5499] = {.lex_state = 128, .external_lex_state = 2},
  [5500] = {.lex_state = 128, .external_lex_state = 2},
  [5501] = {.lex_state = 128, .external_lex_state = 2},
  [5502] = {.lex_state = 128, .external_lex_state = 2},
  [5503] = {.lex_state = 128, .external_lex_state = 2},
  [5504] = {.lex_state = 128, .external_lex_state = 2},
  [5505] = {.lex_state = 128, .external_lex_state = 2},
  [5506] = {.lex_state = 128, .external_lex_state = 2},
  [5507] = {.lex_state = 128, .external_lex_state = 2},
  [5508] = {.lex_state = 128, .external_lex_state = 2},
  [5509] = {.lex_state = 128, .external_lex_state = 2},
  [5510] = {.lex_state = 11, .external_lex_state = 2},
  [5511] = {.lex_state = 128, .external_lex_state = 2},
  [5512] = {.lex_state = 128, .external_lex_state = 2},
  [5513] = {.lex_state = 128, .external_lex_state = 2},
  [5514] = {.lex_state = 128, .external_lex_state = 2},
  [5515] = {.lex_state = 128, .external_lex_state = 2},
  [5516] = {.lex_state = 128, .external_lex_state = 2},
  [5517] = {.lex_state = 128, .external_lex_state = 5},
  [5518] = {.lex_state = 128, .external_lex_state = 2},
  [5519] = {.lex_state = 128, .external_lex_state = 2},
  [5520] = {.lex_state = 128, .external_lex_state = 2},
  [5521] = {.lex_state = 128, .external_lex_state = 5},
  [5522] = {.lex_state = 128, .external_lex_state = 2},
  [5523] = {.lex_state = 128, .external_lex_state = 2},
  [5524] = {.lex_state = 128, .external_lex_state = 2},
  [5525] = {.lex_state = 128, .external_lex_state = 2},
  [5526] = {.lex_state = 128, .external_lex_state = 2},
  [5527] = {.lex_state = 128, .external_lex_state = 2},
  [5528] = {.lex_state = 128, .external_lex_state = 2},
  [5529] = {.lex_state = 128, .external_lex_state = 2},
  [5530] = {.lex_state = 128, .external_lex_state = 2},
  [5531] = {.lex_state = 128, .external_lex_state = 2},
  [5532] = {.lex_state = 128, .external_lex_state = 2},
  [5533] = {.lex_state = 128, .external_lex_state = 5},
  [5534] = {.lex_state = 128, .external_lex_state = 2},
  [5535] = {.lex_state = 128, .external_lex_state = 2},
  [5536] = {.lex_state = 128, .external_lex_state = 2},
  [5537] = {.lex_state = 128, .external_lex_state = 2},
  [5538] = {.lex_state = 128, .external_lex_state = 2},
  [5539] = {.lex_state = 128, .external_lex_state = 2},
  [5540] = {.lex_state = 128, .external_lex_state = 2},
  [5541] = {.lex_state = 128, .external_lex_state = 2},
  [5542] = {.lex_state = 128, .external_lex_state = 2},
  [5543] = {.lex_state = 128, .external_lex_state = 2},
  [5544] = {.lex_state = 128, .external_lex_state = 2},
  [5545] = {.lex_state = 128, .external_lex_state = 2},
  [5546] = {.lex_state = 128, .external_lex_state = 2},
  [5547] = {.lex_state = 128, .external_lex_state = 5},
  [5548] = {.lex_state = 128, .external_lex_state = 2},
  [5549] = {.lex_state = 128, .external_lex_state = 2},
  [5550] = {.lex_state = 128, .external_lex_state = 2},
  [5551] = {.lex_state = 128, .external_lex_state = 2},
  [5552] = {.lex_state = 128, .external_lex_state = 2},
  [5553] = {.lex_state = 128, .external_lex_state = 2},
  [5554] = {.lex_state = 128, .external_lex_state = 2},
  [5555] = {.lex_state = 128, .external_lex_state = 2},
  [5556] = {.lex_state = 128, .external_lex_state = 2},
  [5557] = {.lex_state = 128, .external_lex_state = 2},
  [5558] = {.lex_state = 128, .external_lex_state = 2},
  [5559] = {.lex_state = 128, .external_lex_state = 2},
  [5560] = {.lex_state = 128, .external_lex_state = 2},
  [5561] = {.lex_state = 128, .external_lex_state = 2},
  [5562] = {.lex_state = 128, .external_lex_state = 2},
  [5563] = {.lex_state = 128, .external_lex_state = 2},
  [5564] = {.lex_state = 128, .external_lex_state = 2},
  [5565] = {.lex_state = 128, .external_lex_state = 2},
  [5566] = {.lex_state = 128, .external_lex_state = 2},
  [5567] = {.lex_state = 128, .external_lex_state = 2},
  [5568] = {.lex_state = 128, .external_lex_state = 2},
  [5569] = {.lex_state = 128, .external_lex_state = 2},
  [5570] = {.lex_state = 128, .external_lex_state = 2},
  [5571] = {.lex_state = 128, .external_lex_state = 2},
  [5572] = {.lex_state = 128, .external_lex_state = 2},
  [5573] = {.lex_state = 128, .external_lex_state = 2},
  [5574] = {.lex_state = 128, .external_lex_state = 2},
  [5575] = {.lex_state = 128, .external_lex_state = 2},
  [5576] = {.lex_state = 128, .external_lex_state = 2},
  [5577] = {.lex_state = 128, .external_lex_state = 2},
  [5578] = {.lex_state = 128, .external_lex_state = 2},
  [5579] = {.lex_state = 128, .external_lex_state = 2},
  [5580] = {.lex_state = 128, .external_lex_state = 2},
  [5581] = {.lex_state = 128, .external_lex_state = 2},
  [5582] = {.lex_state = 128, .external_lex_state = 2},
  [5583] = {.lex_state = 128, .external_lex_state = 2},
  [5584] = {.lex_state = 128, .external_lex_state = 2},
  [5585] = {.lex_state = 128, .external_lex_state = 2},
  [5586] = {.lex_state = 128, .external_lex_state = 2},
  [5587] = {.lex_state = 128, .external_lex_state = 2},
  [5588] = {.lex_state = 128, .external_lex_state = 2},
  [5589] = {.lex_state = 128, .external_lex_state = 2},
  [5590] = {.lex_state = 128, .external_lex_state = 2},
  [5591] = {.lex_state = 128, .external_lex_state = 2},
  [5592] = {.lex_state = 128, .external_lex_state = 2},
  [5593] = {.lex_state = 128, .external_lex_state = 2},
  [5594] = {.lex_state = 128, .external_lex_state = 2},
  [5595] = {.lex_state = 128, .external_lex_state = 2},
  [5596] = {.lex_state = 128, .external_lex_state = 2},
  [5597] = {.lex_state = 128, .external_lex_state = 2},
  [5598] = {.lex_state = 128, .external_lex_state = 2},
  [5599] = {.lex_state = 128, .external_lex_state = 2},
  [5600] = {.lex_state = 128, .external_lex_state = 2},
  [5601] = {.lex_state = 128, .external_lex_state = 2},
  [5602] = {.lex_state = 128, .external_lex_state = 2},
  [5603] = {.lex_state = 128, .external_lex_state = 2},
  [5604] = {.lex_state = 128, .external_lex_state = 2},
  [5605] = {.lex_state = 128, .external_lex_state = 2},
  [5606] = {.lex_state = 128, .external_lex_state = 2},
  [5607] = {.lex_state = 128, .external_lex_state = 2},
  [5608] = {.lex_state = 128, .external_lex_state = 2},
  [5609] = {.lex_state = 128, .external_lex_state = 2},
  [5610] = {.lex_state = 128, .external_lex_state = 2},
  [5611] = {.lex_state = 128, .external_lex_state = 2},
  [5612] = {.lex_state = 128, .external_lex_state = 2},
  [5613] = {.lex_state = 128, .external_lex_state = 2},
  [5614] = {.lex_state = 128, .external_lex_state = 2},
  [5615] = {.lex_state = 128, .external_lex_state = 2},
  [5616] = {.lex_state = 128, .external_lex_state = 2},
  [5617] = {.lex_state = 128, .external_lex_state = 2},
  [5618] = {.lex_state = 128, .external_lex_state = 2},
  [5619] = {.lex_state = 128, .external_lex_state = 2},
  [5620] = {.lex_state = 128, .external_lex_state = 2},
  [5621] = {.lex_state = 128, .external_lex_state = 2},
  [5622] = {.lex_state = 128, .external_lex_state = 2},
  [5623] = {.lex_state = 128, .external_lex_state = 2},
  [5624] = {.lex_state = 128, .external_lex_state = 2},
  [5625] = {.lex_state = 128, .external_lex_state = 2},
  [5626] = {.lex_state = 128, .external_lex_state = 2},
  [5627] = {.lex_state = 1, .external_lex_state = 11},
  [5628] = {.lex_state = 128, .external_lex_state = 2},
  [5629] = {.lex_state = 128, .external_lex_state = 2},
  [5630] = {.lex_state = 128, .external_lex_state = 2},
  [5631] = {.lex_state = 128, .external_lex_state = 2},
  [5632] = {.lex_state = 128, .external_lex_state = 2},
  [5633] = {.lex_state = 128, .external_lex_state = 2},
  [5634] = {.lex_state = 128, .external_lex_state = 2},
  [5635] = {.lex_state = 128, .external_lex_state = 2},
  [5636] = {.lex_state = 128, .external_lex_state = 2},
  [5637] = {.lex_state = 128, .external_lex_state = 2},
  [5638] = {.lex_state = 128, .external_lex_state = 2},
  [5639] = {.lex_state = 128, .external_lex_state = 2},
  [5640] = {.lex_state = 128, .external_lex_state = 2},
  [5641] = {.lex_state = 128, .external_lex_state = 2},
  [5642] = {.lex_state = 128, .external_lex_state = 2},
  [5643] = {.lex_state = 128, .external_lex_state = 2},
  [5644] = {.lex_state = 128, .external_lex_state = 2},
  [5645] = {.lex_state = 128, .external_lex_state = 2},
  [5646] = {.lex_state = 128, .external_lex_state = 2},
  [5647] = {.lex_state = 128, .external_lex_state = 2},
  [5648] = {.lex_state = 128, .external_lex_state = 2},
  [5649] = {.lex_state = 128, .external_lex_state = 2},
  [5650] = {.lex_state = 128, .external_lex_state = 2},
  [5651] = {.lex_state = 128, .external_lex_state = 2},
  [5652] = {.lex_state = 128, .external_lex_state = 2},
  [5653] = {.lex_state = 128, .external_lex_state = 2},
  [5654] = {.lex_state = 128, .external_lex_state = 2},
  [5655] = {.lex_state = 128, .external_lex_state = 2},
  [5656] = {.lex_state = 128, .external_lex_state = 2},
  [5657] = {.lex_state = 128, .external_lex_state = 2},
  [5658] = {.lex_state = 128, .external_lex_state = 2},
  [5659] = {.lex_state = 128, .external_lex_state = 2},
  [5660] = {.lex_state = 128, .external_lex_state = 2},
  [5661] = {.lex_state = 128, .external_lex_state = 2},
  [5662] = {.lex_state = 128, .external_lex_state = 2},
  [5663] = {.lex_state = 128, .external_lex_state = 2},
  [5664] = {.lex_state = 128, .external_lex_state = 2},
  [5665] = {.lex_state = 128, .external_lex_state = 2},
  [5666] = {.lex_state = 128, .external_lex_state = 2},
  [5667] = {.lex_state = 128, .external_lex_state = 2},
  [5668] = {.lex_state = 128, .external_lex_state = 2},
  [5669] = {.lex_state = 128, .external_lex_state = 2},
  [5670] = {.lex_state = 128, .external_lex_state = 2},
  [5671] = {.lex_state = 128, .external_lex_state = 2},
  [5672] = {.lex_state = 128, .external_lex_state = 2},
  [5673] = {.lex_state = 128, .external_lex_state = 2},
  [5674] = {.lex_state = 128, .external_lex_state = 2},
  [5675] = {.lex_state = 128, .external_lex_state = 2},
  [5676] = {.lex_state = 128, .external_lex_state = 2},
  [5677] = {.lex_state = 128, .external_lex_state = 2},
  [5678] = {.lex_state = 128, .external_lex_state = 2},
  [5679] = {.lex_state = 128, .external_lex_state = 2},
  [5680] = {.lex_state = 128, .external_lex_state = 2},
  [5681] = {.lex_state = 128, .external_lex_state = 2},
  [5682] = {.lex_state = 128, .external_lex_state = 2},
  [5683] = {.lex_state = 128, .external_lex_state = 2},
  [5684] = {.lex_state = 128, .external_lex_state = 2},
  [5685] = {.lex_state = 128, .external_lex_state = 2},
  [5686] = {.lex_state = 128, .external_lex_state = 2},
  [5687] = {.lex_state = 128, .external_lex_state = 2},
  [5688] = {.lex_state = 128, .external_lex_state = 2},
  [5689] = {.lex_state = 128, .external_lex_state = 2},
  [5690] = {.lex_state = 128, .external_lex_state = 2},
  [5691] = {.lex_state = 128, .external_lex_state = 2},
  [5692] = {.lex_state = 128, .external_lex_state = 2},
  [5693] = {.lex_state = 128, .external_lex_state = 2},
  [5694] = {.lex_state = 128, .external_lex_state = 2},
  [5695] = {.lex_state = 128, .external_lex_state = 2},
  [5696] = {.lex_state = 128, .external_lex_state = 2},
  [5697] = {.lex_state = 128, .external_lex_state = 2},
  [5698] = {.lex_state = 128, .external_lex_state = 2},
  [5699] = {.lex_state = 128, .external_lex_state = 2},
  [5700] = {.lex_state = 128, .external_lex_state = 2},
  [5701] = {.lex_state = 128, .external_lex_state = 2},
  [5702] = {.lex_state = 128, .external_lex_state = 2},
  [5703] = {.lex_state = 128, .external_lex_state = 2},
  [5704] = {.lex_state = 128, .external_lex_state = 2},
  [5705] = {.lex_state = 128, .external_lex_state = 2},
  [5706] = {.lex_state = 128, .external_lex_state = 2},
  [5707] = {.lex_state = 128, .external_lex_state = 2},
  [5708] = {.lex_state = 128, .external_lex_state = 2},
  [5709] = {.lex_state = 128, .external_lex_state = 2},
  [5710] = {.lex_state = 128, .external_lex_state = 2},
  [5711] = {.lex_state = 128, .external_lex_state = 2},
  [5712] = {.lex_state = 128, .external_lex_state = 2},
  [5713] = {.lex_state = 128, .external_lex_state = 2},
  [5714] = {.lex_state = 128, .external_lex_state = 2},
  [5715] = {.lex_state = 128, .external_lex_state = 2},
  [5716] = {.lex_state = 128, .external_lex_state = 2},
  [5717] = {.lex_state = 128, .external_lex_state = 2},
  [5718] = {.lex_state = 128, .external_lex_state = 2},
  [5719] = {.lex_state = 128, .external_lex_state = 2},
  [5720] = {.lex_state = 128, .external_lex_state = 2},
  [5721] = {.lex_state = 128, .external_lex_state = 2},
  [5722] = {.lex_state = 128, .external_lex_state = 2},
  [5723] = {.lex_state = 128, .external_lex_state = 2},
  [5724] = {.lex_state = 128, .external_lex_state = 2},
  [5725] = {.lex_state = 128, .external_lex_state = 2},
  [5726] = {.lex_state = 128, .external_lex_state = 2},
  [5727] = {.lex_state = 128, .external_lex_state = 2},
  [5728] = {.lex_state = 128, .external_lex_state = 2},
  [5729] = {.lex_state = 1, .external_lex_state = 11},
  [5730] = {.lex_state = 128, .external_lex_state = 2},
  [5731] = {.lex_state = 128, .external_lex_state = 2},
  [5732] = {.lex_state = 128, .external_lex_state = 2},
  [5733] = {.lex_state = 128, .external_lex_state = 2},
  [5734] = {.lex_state = 128, .external_lex_state = 2},
  [5735] = {.lex_state = 128, .external_lex_state = 2},
  [5736] = {.lex_state = 128, .external_lex_state = 2},
  [5737] = {.lex_state = 128, .external_lex_state = 2},
  [5738] = {.lex_state = 128, .external_lex_state = 2},
  [5739] = {.lex_state = 128, .external_lex_state = 2},
  [5740] = {.lex_state = 128, .external_lex_state = 2},
  [5741] = {.lex_state = 128, .external_lex_state = 2},
  [5742] = {.lex_state = 128, .external_lex_state = 2},
  [5743] = {.lex_state = 128, .external_lex_state = 2},
  [5744] = {.lex_state = 128, .external_lex_state = 2},
  [5745] = {.lex_state = 128, .external_lex_state = 2},
  [5746] = {.lex_state = 128, .external_lex_state = 2},
  [5747] = {.lex_state = 128, .external_lex_state = 2},
  [5748] = {.lex_state = 128, .external_lex_state = 2},
  [5749] = {.lex_state = 128, .external_lex_state = 2},
  [5750] = {.lex_state = 33, .external_lex_state = 2},
  [5751] = {.lex_state = 128, .external_lex_state = 2},
  [5752] = {.lex_state = 128, .external_lex_state = 2},
  [5753] = {.lex_state = 128, .external_lex_state = 2},
  [5754] = {.lex_state = 128, .external_lex_state = 2},
  [5755] = {.lex_state = 128, .external_lex_state = 2},
  [5756] = {.lex_state = 128, .external_lex_state = 2},
  [5757] = {.lex_state = 128, .external_lex_state = 2},
  [5758] = {.lex_state = 128, .external_lex_state = 2},
  [5759] = {.lex_state = 128, .external_lex_state = 2},
  [5760] = {.lex_state = 128, .external_lex_state = 2},
  [5761] = {.lex_state = 128, .external_lex_state = 2},
  [5762] = {.lex_state = 128, .external_lex_state = 2},
  [5763] = {.lex_state = 128, .external_lex_state = 2},
  [5764] = {.lex_state = 128, .external_lex_state = 2},
  [5765] = {.lex_state = 128, .external_lex_state = 2},
  [5766] = {.lex_state = 128, .external_lex_state = 2},
  [5767] = {.lex_state = 128, .external_lex_state = 2},
  [5768] = {.lex_state = 128, .external_lex_state = 2},
  [5769] = {.lex_state = 128, .external_lex_state = 2},
  [5770] = {.lex_state = 128, .external_lex_state = 2},
  [5771] = {.lex_state = 128, .external_lex_state = 2},
  [5772] = {.lex_state = 128, .external_lex_state = 2},
  [5773] = {.lex_state = 128, .external_lex_state = 2},
  [5774] = {.lex_state = 128, .external_lex_state = 2},
  [5775] = {.lex_state = 128, .external_lex_state = 2},
  [5776] = {.lex_state = 128, .external_lex_state = 2},
  [5777] = {.lex_state = 128, .external_lex_state = 2},
  [5778] = {.lex_state = 128, .external_lex_state = 2},
  [5779] = {.lex_state = 128, .external_lex_state = 2},
  [5780] = {.lex_state = 128, .external_lex_state = 2},
  [5781] = {.lex_state = 128, .external_lex_state = 2},
  [5782] = {.lex_state = 128, .external_lex_state = 2},
  [5783] = {.lex_state = 128, .external_lex_state = 2},
  [5784] = {.lex_state = 128, .external_lex_state = 2},
  [5785] = {.lex_state = 128, .external_lex_state = 2},
  [5786] = {.lex_state = 128, .external_lex_state = 2},
  [5787] = {.lex_state = 128, .external_lex_state = 2},
  [5788] = {.lex_state = 128, .external_lex_state = 2},
  [5789] = {.lex_state = 128, .external_lex_state = 2},
  [5790] = {.lex_state = 128, .external_lex_state = 2},
  [5791] = {.lex_state = 128, .external_lex_state = 2},
  [5792] = {.lex_state = 128, .external_lex_state = 2},
  [5793] = {.lex_state = 128, .external_lex_state = 2},
  [5794] = {.lex_state = 128, .external_lex_state = 2},
  [5795] = {.lex_state = 128, .external_lex_state = 2},
  [5796] = {.lex_state = 128, .external_lex_state = 2},
  [5797] = {.lex_state = 128, .external_lex_state = 2},
  [5798] = {.lex_state = 128, .external_lex_state = 2},
  [5799] = {.lex_state = 1, .external_lex_state = 11},
  [5800] = {.lex_state = 128, .external_lex_state = 2},
  [5801] = {.lex_state = 128, .external_lex_state = 2},
  [5802] = {.lex_state = 128, .external_lex_state = 2},
  [5803] = {.lex_state = 128, .external_lex_state = 2},
  [5804] = {.lex_state = 128, .external_lex_state = 2},
  [5805] = {.lex_state = 128, .external_lex_state = 2},
  [5806] = {.lex_state = 128, .external_lex_state = 2},
  [5807] = {.lex_state = 128, .external_lex_state = 2},
  [5808] = {.lex_state = 128, .external_lex_state = 2},
  [5809] = {.lex_state = 128, .external_lex_state = 2},
  [5810] = {.lex_state = 128, .external_lex_state = 2},
  [5811] = {.lex_state = 128, .external_lex_state = 2},
  [5812] = {.lex_state = 128, .external_lex_state = 2},
  [5813] = {.lex_state = 128, .external_lex_state = 2},
  [5814] = {.lex_state = 128, .external_lex_state = 2},
  [5815] = {.lex_state = 128, .external_lex_state = 2},
  [5816] = {.lex_state = 128, .external_lex_state = 2},
  [5817] = {.lex_state = 128, .external_lex_state = 2},
  [5818] = {.lex_state = 128, .external_lex_state = 2},
  [5819] = {.lex_state = 128, .external_lex_state = 2},
  [5820] = {.lex_state = 128, .external_lex_state = 2},
  [5821] = {.lex_state = 128, .external_lex_state = 2},
  [5822] = {.lex_state = 128, .external_lex_state = 2},
  [5823] = {.lex_state = 128, .external_lex_state = 2},
  [5824] = {.lex_state = 128, .external_lex_state = 2},
  [5825] = {.lex_state = 128, .external_lex_state = 2},
  [5826] = {.lex_state = 128, .external_lex_state = 2},
  [5827] = {.lex_state = 128, .external_lex_state = 2},
  [5828] = {.lex_state = 128, .external_lex_state = 2},
  [5829] = {.lex_state = 128, .external_lex_state = 2},
  [5830] = {.lex_state = 128, .external_lex_state = 2},
  [5831] = {.lex_state = 128, .external_lex_state = 2},
  [5832] = {.lex_state = 128, .external_lex_state = 2},
  [5833] = {.lex_state = 128, .external_lex_state = 2},
  [5834] = {.lex_state = 128, .external_lex_state = 2},
  [5835] = {.lex_state = 128, .external_lex_state = 2},
  [5836] = {.lex_state = 128, .external_lex_state = 2},
  [5837] = {.lex_state = 128, .external_lex_state = 2},
  [5838] = {.lex_state = 128, .external_lex_state = 2},
  [5839] = {.lex_state = 128, .external_lex_state = 2},
  [5840] = {.lex_state = 128, .external_lex_state = 2},
  [5841] = {.lex_state = 128, .external_lex_state = 2},
  [5842] = {.lex_state = 128, .external_lex_state = 2},
  [5843] = {.lex_state = 128, .external_lex_state = 2},
  [5844] = {.lex_state = 128, .external_lex_state = 2},
  [5845] = {.lex_state = 128, .external_lex_state = 2},
  [5846] = {.lex_state = 128, .external_lex_state = 2},
  [5847] = {.lex_state = 128, .external_lex_state = 2},
  [5848] = {.lex_state = 128, .external_lex_state = 2},
  [5849] = {.lex_state = 128, .external_lex_state = 2},
  [5850] = {.lex_state = 128, .external_lex_state = 2},
  [5851] = {.lex_state = 128, .external_lex_state = 2},
  [5852] = {.lex_state = 128, .external_lex_state = 2},
  [5853] = {.lex_state = 128, .external_lex_state = 2},
  [5854] = {.lex_state = 128, .external_lex_state = 2},
  [5855] = {.lex_state = 128, .external_lex_state = 2},
  [5856] = {.lex_state = 128, .external_lex_state = 2},
  [5857] = {.lex_state = 128, .external_lex_state = 2},
  [5858] = {.lex_state = 128, .external_lex_state = 2},
  [5859] = {.lex_state = 128, .external_lex_state = 2},
  [5860] = {.lex_state = 128, .external_lex_state = 2},
  [5861] = {.lex_state = 128, .external_lex_state = 2},
  [5862] = {.lex_state = 128, .external_lex_state = 2},
  [5863] = {.lex_state = 128, .external_lex_state = 2},
  [5864] = {.lex_state = 128, .external_lex_state = 2},
  [5865] = {.lex_state = 128, .external_lex_state = 2},
  [5866] = {.lex_state = 33, .external_lex_state = 2},
  [5867] = {.lex_state = 128, .external_lex_state = 2},
  [5868] = {.lex_state = 128, .external_lex_state = 2},
  [5869] = {.lex_state = 128, .external_lex_state = 2},
  [5870] = {.lex_state = 128, .external_lex_state = 2},
  [5871] = {.lex_state = 128, .external_lex_state = 2},
  [5872] = {.lex_state = 128, .external_lex_state = 2},
  [5873] = {.lex_state = 128, .external_lex_state = 2},
  [5874] = {.lex_state = 33, .external_lex_state = 2},
  [5875] = {.lex_state = 128, .external_lex_state = 2},
  [5876] = {.lex_state = 128, .external_lex_state = 2},
  [5877] = {.lex_state = 128, .external_lex_state = 2},
  [5878] = {.lex_state = 128, .external_lex_state = 2},
  [5879] = {.lex_state = 128, .external_lex_state = 2},
  [5880] = {.lex_state = 128, .external_lex_state = 2},
  [5881] = {.lex_state = 128, .external_lex_state = 2},
  [5882] = {.lex_state = 128, .external_lex_state = 2},
  [5883] = {.lex_state = 128, .external_lex_state = 2},
  [5884] = {.lex_state = 128, .external_lex_state = 2},
  [5885] = {.lex_state = 128, .external_lex_state = 2},
  [5886] = {.lex_state = 128, .external_lex_state = 2},
  [5887] = {.lex_state = 128, .external_lex_state = 2},
  [5888] = {.lex_state = 128, .external_lex_state = 2},
  [5889] = {.lex_state = 128, .external_lex_state = 2},
  [5890] = {.lex_state = 128, .external_lex_state = 2},
  [5891] = {.lex_state = 128, .external_lex_state = 2},
  [5892] = {.lex_state = 128, .external_lex_state = 2},
  [5893] = {.lex_state = 128, .external_lex_state = 2},
  [5894] = {.lex_state = 128, .external_lex_state = 2},
  [5895] = {.lex_state = 128, .external_lex_state = 2},
  [5896] = {.lex_state = 128, .external_lex_state = 2},
  [5897] = {.lex_state = 128, .external_lex_state = 2},
  [5898] = {.lex_state = 128, .external_lex_state = 2},
  [5899] = {.lex_state = 128, .external_lex_state = 2},
  [5900] = {.lex_state = 128, .external_lex_state = 2},
  [5901] = {.lex_state = 128, .external_lex_state = 2},
  [5902] = {.lex_state = 128, .external_lex_state = 2},
  [5903] = {.lex_state = 128, .external_lex_state = 2},
  [5904] = {.lex_state = 128, .external_lex_state = 2},
  [5905] = {.lex_state = 128, .external_lex_state = 2},
  [5906] = {.lex_state = 128, .external_lex_state = 2},
  [5907] = {.lex_state = 128, .external_lex_state = 2},
  [5908] = {.lex_state = 128, .external_lex_state = 2},
  [5909] = {.lex_state = 128, .external_lex_state = 2},
  [5910] = {.lex_state = 128, .external_lex_state = 2},
  [5911] = {.lex_state = 128, .external_lex_state = 2},
  [5912] = {.lex_state = 128, .external_lex_state = 2},
  [5913] = {.lex_state = 128, .external_lex_state = 2},
  [5914] = {.lex_state = 1, .external_lex_state = 11},
  [5915] = {.lex_state = 128, .external_lex_state = 2},
  [5916] = {.lex_state = 128, .external_lex_state = 2},
  [5917] = {.lex_state = 128, .external_lex_state = 2},
  [5918] = {.lex_state = 128, .external_lex_state = 2},
  [5919] = {.lex_state = 128, .external_lex_state = 2},
  [5920] = {.lex_state = 128, .external_lex_state = 2},
  [5921] = {.lex_state = 128, .external_lex_state = 2},
  [5922] = {.lex_state = 128, .external_lex_state = 2},
  [5923] = {.lex_state = 128, .external_lex_state = 2},
  [5924] = {.lex_state = 128, .external_lex_state = 2},
  [5925] = {.lex_state = 128, .external_lex_state = 2},
  [5926] = {.lex_state = 128, .external_lex_state = 2},
  [5927] = {.lex_state = 128, .external_lex_state = 2},
  [5928] = {.lex_state = 128, .external_lex_state = 2},
  [5929] = {.lex_state = 128, .external_lex_state = 2},
  [5930] = {.lex_state = 128, .external_lex_state = 2},
  [5931] = {.lex_state = 128, .external_lex_state = 2},
  [5932] = {.lex_state = 128, .external_lex_state = 2},
  [5933] = {.lex_state = 128, .external_lex_state = 2},
  [5934] = {.lex_state = 128, .external_lex_state = 2},
  [5935] = {.lex_state = 128, .external_lex_state = 2},
  [5936] = {.lex_state = 128, .external_lex_state = 2},
  [5937] = {.lex_state = 128, .external_lex_state = 2},
  [5938] = {.lex_state = 128, .external_lex_state = 2},
  [5939] = {.lex_state = 128, .external_lex_state = 2},
  [5940] = {.lex_state = 128, .external_lex_state = 2},
  [5941] = {.lex_state = 128, .external_lex_state = 2},
  [5942] = {.lex_state = 128, .external_lex_state = 2},
  [5943] = {.lex_state = 128, .external_lex_state = 2},
  [5944] = {.lex_state = 128, .external_lex_state = 2},
  [5945] = {.lex_state = 128, .external_lex_state = 2},
  [5946] = {.lex_state = 128, .external_lex_state = 2},
  [5947] = {.lex_state = 128, .external_lex_state = 2},
  [5948] = {.lex_state = 128, .external_lex_state = 2},
  [5949] = {.lex_state = 128, .external_lex_state = 2},
  [5950] = {.lex_state = 128, .external_lex_state = 2},
  [5951] = {.lex_state = 128, .external_lex_state = 2},
  [5952] = {.lex_state = 128, .external_lex_state = 2},
  [5953] = {.lex_state = 128, .external_lex_state = 2},
  [5954] = {.lex_state = 128, .external_lex_state = 2},
  [5955] = {.lex_state = 128, .external_lex_state = 2},
  [5956] = {.lex_state = 128, .external_lex_state = 2},
  [5957] = {.lex_state = 128, .external_lex_state = 2},
  [5958] = {.lex_state = 1, .external_lex_state = 11},
  [5959] = {.lex_state = 128, .external_lex_state = 2},
  [5960] = {.lex_state = 128, .external_lex_state = 2},
  [5961] = {.lex_state = 128, .external_lex_state = 2},
  [5962] = {.lex_state = 128, .external_lex_state = 2},
  [5963] = {.lex_state = 128, .external_lex_state = 2},
  [5964] = {.lex_state = 128, .external_lex_state = 2},
  [5965] = {.lex_state = 128, .external_lex_state = 2},
  [5966] = {.lex_state = 128, .external_lex_state = 2},
  [5967] = {.lex_state = 128, .external_lex_state = 2},
  [5968] = {.lex_state = 128, .external_lex_state = 2},
  [5969] = {.lex_state = 128, .external_lex_state = 2},
  [5970] = {.lex_state = 128, .external_lex_state = 2},
  [5971] = {.lex_state = 33, .external_lex_state = 2},
  [5972] = {.lex_state = 128, .external_lex_state = 2},
  [5973] = {.lex_state = 128, .external_lex_state = 2},
  [5974] = {.lex_state = 128, .external_lex_state = 2},
  [5975] = {.lex_state = 128, .external_lex_state = 2},
  [5976] = {.lex_state = 33, .external_lex_state = 2},
  [5977] = {.lex_state = 128, .external_lex_state = 2},
  [5978] = {.lex_state = 128, .external_lex_state = 2},
  [5979] = {.lex_state = 128, .external_lex_state = 2},
  [5980] = {.lex_state = 128, .external_lex_state = 2},
  [5981] = {.lex_state = 128, .external_lex_state = 2},
  [5982] = {.lex_state = 128, .external_lex_state = 2},
  [5983] = {.lex_state = 128, .external_lex_state = 2},
  [5984] = {.lex_state = 128, .external_lex_state = 2},
  [5985] = {.lex_state = 128, .external_lex_state = 2},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_hash_bang_line] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_namespace] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_typeof] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_of] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_debugger] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_throw] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_LT_SLASH] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_async] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_QMARK_DOT] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_using] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK] = ACTIONS(1),
    [anon_sym_instanceof] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_void] = ACTIONS(1),
    [anon_sym_delete] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_SLASH2] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [sym_private_property_identifier] = ACTIONS(1),
    [anon_sym_target] = ACTIONS(1),
    [anon_sym_meta] = ACTIONS(1),
    [sym_this] = ACTIONS(1),
    [sym_super] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [sym_undefined] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_readonly] = ACTIONS(1),
    [anon_sym_get] = ACTIONS(1),
    [anon_sym_set] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_declare] = ACTIONS(1),
    [anon_sym_public] = ACTIONS(1),
    [anon_sym_private] = ACTIONS(1),
    [anon_sym_protected] = ACTIONS(1),
    [anon_sym_override] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_any] = ACTIONS(1),
    [anon_sym_number] = ACTIONS(1),
    [anon_sym_boolean] = ACTIONS(1),
    [anon_sym_string] = ACTIONS(1),
    [anon_sym_symbol] = ACTIONS(1),
    [anon_sym_object] = ACTIONS(1),
    [anon_sym_abstract] = ACTIONS(1),
    [anon_sym_accessor] = ACTIONS(1),
    [anon_sym_satisfies] = ACTIONS(1),
    [anon_sym_require] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_implements] = ACTIONS(1),
    [anon_sym_global] = ACTIONS(1),
    [anon_sym_interface] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_DASH_QMARK_COLON] = ACTIONS(1),
    [anon_sym_PLUS_QMARK_COLON] = ACTIONS(1),
    [anon_sym_asserts] = ACTIONS(1),
    [anon_sym_infer] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_keyof] = ACTIONS(1),
    [anon_sym_unique] = ACTIONS(1),
    [anon_sym_unknown] = ACTIONS(1),
    [anon_sym_never] = ACTIONS(1),
    [anon_sym_LBRACE_PIPE] = ACTIONS(1),
    [anon_sym_PIPE_RBRACE] = ACTIONS(1),
    [sym__automatic_semicolon] = ACTIONS(1),
    [sym__template_chars] = ACTIONS(1),
    [sym__ternary_qmark] = ACTIONS(1),
    [sym_html_comment] = ACTIONS(5),
    [sym_jsx_text] = ACTIONS(1),
    [sym__function_signature_automatic_semicolon] = ACTIONS(1),
    [sym___error_recovery] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(5712),
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(15),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(253),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_program_repeat1] = STATE(15),
    [aux_sym_export_statement_repeat1] = STATE(3919),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym_identifier] = ACTIONS(9),
    [sym_hash_bang_line] = ACTIONS(11),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_function] = ACTIONS(75),
    [anon_sym_new] = ACTIONS(77),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [2] = {
    [sym_import] = STATE(3582),
    [sym_parenthesized_expression] = STATE(1195),
    [sym_expression] = STATE(2574),
    [sym_primary_expression] = STATE(1471),
    [sym_yield_expression] = STATE(1674),
    [sym_object] = STATE(1673),
    [sym_object_pattern] = STATE(3631),
    [sym_array] = STATE(1673),
    [sym_array_pattern] = STATE(3631),
    [sym_jsx_element] = STATE(1674),
    [sym_jsx_opening_element] = STATE(3199),
    [sym_nested_identifier] = STATE(5753),
    [sym_jsx_self_closing_element] = STATE(1674),
    [sym_class] = STATE(1673),
    [sym_function_expression] = STATE(1673),
    [sym_generator_function] = STATE(1673),
    [sym_arrow_function] = STATE(1673),
    [sym__call_signature] = STATE(5813),
    [sym_call_expression] = STATE(1673),
    [sym_new_expression] = STATE(1511),
    [sym_await_expression] = STATE(1674),
    [sym_member_expression] = STATE(1265),
    [sym_subscript_expression] = STATE(1265),
    [sym_assignment_expression] = STATE(1674),
    [sym__augmented_assignment_lhs] = STATE(2923),
    [sym_augmented_assignment_expression] = STATE(1674),
    [sym__destructuring_pattern] = STATE(3631),
    [sym_ternary_expression] = STATE(1674),
    [sym_binary_expression] = STATE(1674),
    [sym_unary_expression] = STATE(1674),
    [sym_update_expression] = STATE(1674),
    [sym_string] = STATE(2313),
    [sym_template_string] = STATE(1673),
    [sym_regex] = STATE(1673),
    [sym_meta_property] = STATE(1673),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3948),
    [sym_pattern] = STATE(4302),
    [sym_rest_pattern] = STATE(3626),
    [sym_non_null_expression] = STATE(1265),
    [sym_as_expression] = STATE(1674),
    [sym_satisfies_expression] = STATE(1674),
    [sym_instantiation_expression] = STATE(1674),
    [sym_internal_module] = STATE(1674),
    [sym_nested_type_identifier] = STATE(2885),
    [sym__type_query_member_expression_in_type_annotation] = STATE(2896),
    [sym__type_query_call_expression_in_type_annotation] = STATE(2895),
    [sym_type] = STATE(3058),
    [sym_constructor_type] = STATE(2931),
    [sym_primary_type] = STATE(2932),
    [sym_template_literal_type] = STATE(2981),
    [sym_infer_type] = STATE(2931),
    [sym_conditional_type] = STATE(2981),
    [sym_generic_type] = STATE(2981),
    [sym_type_query] = STATE(2981),
    [sym_index_type_query] = STATE(2981),
    [sym_lookup_type] = STATE(2981),
    [sym_literal_type] = STATE(2981),
    [sym__number] = STATE(2935),
    [sym_existential_type] = STATE(2981),
    [sym_flow_maybe_type] = STATE(2981),
    [sym_parenthesized_type] = STATE(2981),
    [sym_predefined_type] = STATE(2981),
    [sym_object_type] = STATE(2981),
    [sym_type_parameters] = STATE(5431),
    [sym_array_type] = STATE(2981),
    [sym_tuple_type] = STATE(2981),
    [sym_readonly_type] = STATE(2931),
    [sym_union_type] = STATE(2981),
    [sym_intersection_type] = STATE(2981),
    [sym_function_type] = STATE(2931),
    [aux_sym_export_statement_repeat1] = STATE(4590),
    [sym_identifier] = ACTIONS(111),
    [anon_sym_export] = ACTIONS(113),
    [anon_sym_STAR] = ACTIONS(115),
    [anon_sym_type] = ACTIONS(113),
    [anon_sym_EQ] = ACTIONS(117),
    [anon_sym_as] = ACTIONS(120),
    [anon_sym_namespace] = ACTIONS(122),
    [anon_sym_LBRACE] = ACTIONS(124),
    [anon_sym_COMMA] = ACTIONS(126),
    [anon_sym_typeof] = ACTIONS(129),
    [anon_sym_import] = ACTIONS(131),
    [anon_sym_let] = ACTIONS(113),
    [anon_sym_const] = ACTIONS(133),
    [anon_sym_BANG] = ACTIONS(135),
    [anon_sym_LPAREN] = ACTIONS(138),
    [anon_sym_RPAREN] = ACTIONS(126),
    [anon_sym_await] = ACTIONS(140),
    [anon_sym_in] = ACTIONS(120),
    [anon_sym_COLON] = ACTIONS(126),
    [anon_sym_yield] = ACTIONS(142),
    [anon_sym_LBRACK] = ACTIONS(144),
    [anon_sym_GT] = ACTIONS(120),
    [anon_sym_DOT] = ACTIONS(120),
    [anon_sym_DQUOTE] = ACTIONS(146),
    [anon_sym_SQUOTE] = ACTIONS(148),
    [anon_sym_class] = ACTIONS(150),
    [anon_sym_async] = ACTIONS(152),
    [anon_sym_function] = ACTIONS(154),
    [anon_sym_EQ_GT] = ACTIONS(156),
    [anon_sym_QMARK_DOT] = ACTIONS(158),
    [anon_sym_new] = ACTIONS(160),
    [anon_sym_using] = ACTIONS(162),
    [anon_sym_PLUS_EQ] = ACTIONS(164),
    [anon_sym_DASH_EQ] = ACTIONS(164),
    [anon_sym_STAR_EQ] = ACTIONS(164),
    [anon_sym_SLASH_EQ] = ACTIONS(164),
    [anon_sym_PERCENT_EQ] = ACTIONS(164),
    [anon_sym_CARET_EQ] = ACTIONS(164),
    [anon_sym_AMP_EQ] = ACTIONS(164),
    [anon_sym_PIPE_EQ] = ACTIONS(164),
    [anon_sym_GT_GT_EQ] = ACTIONS(164),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(164),
    [anon_sym_LT_LT_EQ] = ACTIONS(164),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(164),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(164),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(164),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(164),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(166),
    [anon_sym_AMP_AMP] = ACTIONS(120),
    [anon_sym_PIPE_PIPE] = ACTIONS(120),
    [anon_sym_GT_GT] = ACTIONS(120),
    [anon_sym_GT_GT_GT] = ACTIONS(120),
    [anon_sym_LT_LT] = ACTIONS(120),
    [anon_sym_AMP] = ACTIONS(168),
    [anon_sym_CARET] = ACTIONS(120),
    [anon_sym_PIPE] = ACTIONS(170),
    [anon_sym_PLUS] = ACTIONS(172),
    [anon_sym_DASH] = ACTIONS(172),
    [anon_sym_SLASH] = ACTIONS(174),
    [anon_sym_PERCENT] = ACTIONS(120),
    [anon_sym_STAR_STAR] = ACTIONS(120),
    [anon_sym_LT] = ACTIONS(177),
    [anon_sym_LT_EQ] = ACTIONS(158),
    [anon_sym_EQ_EQ] = ACTIONS(120),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(158),
    [anon_sym_BANG_EQ] = ACTIONS(120),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(158),
    [anon_sym_GT_EQ] = ACTIONS(158),
    [anon_sym_QMARK_QMARK] = ACTIONS(120),
    [anon_sym_instanceof] = ACTIONS(120),
    [anon_sym_TILDE] = ACTIONS(179),
    [anon_sym_void] = ACTIONS(181),
    [anon_sym_delete] = ACTIONS(183),
    [anon_sym_PLUS_PLUS] = ACTIONS(185),
    [anon_sym_DASH_DASH] = ACTIONS(185),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(188),
    [sym_number] = ACTIONS(190),
    [sym_private_property_identifier] = ACTIONS(192),
    [sym_this] = ACTIONS(194),
    [sym_super] = ACTIONS(196),
    [sym_true] = ACTIONS(198),
    [sym_false] = ACTIONS(198),
    [sym_null] = ACTIONS(198),
    [sym_undefined] = ACTIONS(200),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(113),
    [anon_sym_readonly] = ACTIONS(202),
    [anon_sym_get] = ACTIONS(113),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_QMARK] = ACTIONS(204),
    [anon_sym_declare] = ACTIONS(113),
    [anon_sym_public] = ACTIONS(113),
    [anon_sym_private] = ACTIONS(113),
    [anon_sym_protected] = ACTIONS(113),
    [anon_sym_override] = ACTIONS(113),
    [anon_sym_module] = ACTIONS(113),
    [anon_sym_any] = ACTIONS(206),
    [anon_sym_number] = ACTIONS(206),
    [anon_sym_boolean] = ACTIONS(206),
    [anon_sym_string] = ACTIONS(206),
    [anon_sym_symbol] = ACTIONS(206),
    [anon_sym_object] = ACTIONS(206),
    [anon_sym_abstract] = ACTIONS(208),
    [anon_sym_satisfies] = ACTIONS(120),
    [anon_sym_infer] = ACTIONS(210),
    [anon_sym_keyof] = ACTIONS(212),
    [anon_sym_unique] = ACTIONS(214),
    [anon_sym_unknown] = ACTIONS(216),
    [anon_sym_never] = ACTIONS(216),
    [anon_sym_LBRACE_PIPE] = ACTIONS(218),
    [sym__ternary_qmark] = ACTIONS(158),
    [sym_html_comment] = ACTIONS(5),
  },
  [3] = {
    [sym_import] = STATE(3582),
    [sym_parenthesized_expression] = STATE(1195),
    [sym_expression] = STATE(2574),
    [sym_primary_expression] = STATE(1471),
    [sym_yield_expression] = STATE(1674),
    [sym_object] = STATE(1673),
    [sym_object_pattern] = STATE(3631),
    [sym_array] = STATE(1673),
    [sym_array_pattern] = STATE(3631),
    [sym_jsx_element] = STATE(1674),
    [sym_jsx_opening_element] = STATE(3199),
    [sym_nested_identifier] = STATE(5753),
    [sym_jsx_self_closing_element] = STATE(1674),
    [sym_class] = STATE(1673),
    [sym_function_expression] = STATE(1673),
    [sym_generator_function] = STATE(1673),
    [sym_arrow_function] = STATE(1673),
    [sym__call_signature] = STATE(5813),
    [sym_call_expression] = STATE(1673),
    [sym_new_expression] = STATE(1511),
    [sym_await_expression] = STATE(1674),
    [sym_member_expression] = STATE(1265),
    [sym_subscript_expression] = STATE(1265),
    [sym_assignment_expression] = STATE(1674),
    [sym__augmented_assignment_lhs] = STATE(2923),
    [sym_augmented_assignment_expression] = STATE(1674),
    [sym__destructuring_pattern] = STATE(3631),
    [sym_ternary_expression] = STATE(1674),
    [sym_binary_expression] = STATE(1674),
    [sym_unary_expression] = STATE(1674),
    [sym_update_expression] = STATE(1674),
    [sym_string] = STATE(2313),
    [sym_template_string] = STATE(1673),
    [sym_regex] = STATE(1673),
    [sym_meta_property] = STATE(1673),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3948),
    [sym_pattern] = STATE(4302),
    [sym_rest_pattern] = STATE(3626),
    [sym_non_null_expression] = STATE(1265),
    [sym_as_expression] = STATE(1674),
    [sym_satisfies_expression] = STATE(1674),
    [sym_instantiation_expression] = STATE(1674),
    [sym_internal_module] = STATE(1674),
    [sym_nested_type_identifier] = STATE(2885),
    [sym__type_query_member_expression_in_type_annotation] = STATE(2896),
    [sym__type_query_call_expression_in_type_annotation] = STATE(2895),
    [sym_type] = STATE(3058),
    [sym_constructor_type] = STATE(2931),
    [sym_primary_type] = STATE(2932),
    [sym_template_literal_type] = STATE(2981),
    [sym_infer_type] = STATE(2931),
    [sym_conditional_type] = STATE(2981),
    [sym_generic_type] = STATE(2981),
    [sym_type_query] = STATE(2981),
    [sym_index_type_query] = STATE(2981),
    [sym_lookup_type] = STATE(2981),
    [sym_literal_type] = STATE(2981),
    [sym__number] = STATE(2935),
    [sym_existential_type] = STATE(2981),
    [sym_flow_maybe_type] = STATE(2981),
    [sym_parenthesized_type] = STATE(2981),
    [sym_predefined_type] = STATE(2981),
    [sym_object_type] = STATE(2981),
    [sym_type_parameters] = STATE(5431),
    [sym_array_type] = STATE(2981),
    [sym_tuple_type] = STATE(2981),
    [sym_readonly_type] = STATE(2931),
    [sym_union_type] = STATE(2981),
    [sym_intersection_type] = STATE(2981),
    [sym_function_type] = STATE(2931),
    [aux_sym_export_statement_repeat1] = STATE(4590),
    [sym_identifier] = ACTIONS(111),
    [anon_sym_export] = ACTIONS(113),
    [anon_sym_STAR] = ACTIONS(115),
    [anon_sym_type] = ACTIONS(113),
    [anon_sym_EQ] = ACTIONS(220),
    [anon_sym_as] = ACTIONS(120),
    [anon_sym_namespace] = ACTIONS(122),
    [anon_sym_LBRACE] = ACTIONS(124),
    [anon_sym_COMMA] = ACTIONS(223),
    [anon_sym_typeof] = ACTIONS(129),
    [anon_sym_import] = ACTIONS(131),
    [anon_sym_let] = ACTIONS(113),
    [anon_sym_const] = ACTIONS(133),
    [anon_sym_BANG] = ACTIONS(135),
    [anon_sym_LPAREN] = ACTIONS(138),
    [anon_sym_RPAREN] = ACTIONS(223),
    [anon_sym_await] = ACTIONS(140),
    [anon_sym_in] = ACTIONS(120),
    [anon_sym_COLON] = ACTIONS(223),
    [anon_sym_yield] = ACTIONS(142),
    [anon_sym_LBRACK] = ACTIONS(144),
    [anon_sym_GT] = ACTIONS(120),
    [anon_sym_DOT] = ACTIONS(120),
    [anon_sym_DQUOTE] = ACTIONS(146),
    [anon_sym_SQUOTE] = ACTIONS(148),
    [anon_sym_class] = ACTIONS(150),
    [anon_sym_async] = ACTIONS(152),
    [anon_sym_function] = ACTIONS(154),
    [anon_sym_EQ_GT] = ACTIONS(225),
    [anon_sym_QMARK_DOT] = ACTIONS(158),
    [anon_sym_new] = ACTIONS(160),
    [anon_sym_using] = ACTIONS(162),
    [anon_sym_PLUS_EQ] = ACTIONS(164),
    [anon_sym_DASH_EQ] = ACTIONS(164),
    [anon_sym_STAR_EQ] = ACTIONS(164),
    [anon_sym_SLASH_EQ] = ACTIONS(164),
    [anon_sym_PERCENT_EQ] = ACTIONS(164),
    [anon_sym_CARET_EQ] = ACTIONS(164),
    [anon_sym_AMP_EQ] = ACTIONS(164),
    [anon_sym_PIPE_EQ] = ACTIONS(164),
    [anon_sym_GT_GT_EQ] = ACTIONS(164),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(164),
    [anon_sym_LT_LT_EQ] = ACTIONS(164),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(164),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(164),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(164),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(164),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(166),
    [anon_sym_AMP_AMP] = ACTIONS(120),
    [anon_sym_PIPE_PIPE] = ACTIONS(120),
    [anon_sym_GT_GT] = ACTIONS(120),
    [anon_sym_GT_GT_GT] = ACTIONS(120),
    [anon_sym_LT_LT] = ACTIONS(120),
    [anon_sym_AMP] = ACTIONS(168),
    [anon_sym_CARET] = ACTIONS(120),
    [anon_sym_PIPE] = ACTIONS(170),
    [anon_sym_PLUS] = ACTIONS(172),
    [anon_sym_DASH] = ACTIONS(172),
    [anon_sym_SLASH] = ACTIONS(174),
    [anon_sym_PERCENT] = ACTIONS(120),
    [anon_sym_STAR_STAR] = ACTIONS(120),
    [anon_sym_LT] = ACTIONS(177),
    [anon_sym_LT_EQ] = ACTIONS(158),
    [anon_sym_EQ_EQ] = ACTIONS(120),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(158),
    [anon_sym_BANG_EQ] = ACTIONS(120),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(158),
    [anon_sym_GT_EQ] = ACTIONS(158),
    [anon_sym_QMARK_QMARK] = ACTIONS(120),
    [anon_sym_instanceof] = ACTIONS(120),
    [anon_sym_TILDE] = ACTIONS(179),
    [anon_sym_void] = ACTIONS(181),
    [anon_sym_delete] = ACTIONS(183),
    [anon_sym_PLUS_PLUS] = ACTIONS(185),
    [anon_sym_DASH_DASH] = ACTIONS(185),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(188),
    [sym_number] = ACTIONS(190),
    [sym_private_property_identifier] = ACTIONS(192),
    [sym_this] = ACTIONS(194),
    [sym_super] = ACTIONS(196),
    [sym_true] = ACTIONS(198),
    [sym_false] = ACTIONS(198),
    [sym_null] = ACTIONS(198),
    [sym_undefined] = ACTIONS(200),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(113),
    [anon_sym_readonly] = ACTIONS(202),
    [anon_sym_get] = ACTIONS(113),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_QMARK] = ACTIONS(204),
    [anon_sym_declare] = ACTIONS(113),
    [anon_sym_public] = ACTIONS(113),
    [anon_sym_private] = ACTIONS(113),
    [anon_sym_protected] = ACTIONS(113),
    [anon_sym_override] = ACTIONS(113),
    [anon_sym_module] = ACTIONS(113),
    [anon_sym_any] = ACTIONS(206),
    [anon_sym_number] = ACTIONS(206),
    [anon_sym_boolean] = ACTIONS(206),
    [anon_sym_string] = ACTIONS(206),
    [anon_sym_symbol] = ACTIONS(206),
    [anon_sym_object] = ACTIONS(206),
    [anon_sym_abstract] = ACTIONS(208),
    [anon_sym_satisfies] = ACTIONS(120),
    [anon_sym_infer] = ACTIONS(210),
    [anon_sym_keyof] = ACTIONS(212),
    [anon_sym_unique] = ACTIONS(214),
    [anon_sym_unknown] = ACTIONS(216),
    [anon_sym_never] = ACTIONS(216),
    [anon_sym_LBRACE_PIPE] = ACTIONS(218),
    [sym__ternary_qmark] = ACTIONS(158),
    [sym_html_comment] = ACTIONS(5),
  },
  [4] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(16),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5647),
    [sym_object_assignment_pattern] = STATE(4665),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5647),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5647),
    [sym_spread_element] = STATE(4687),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2134),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_rest_pattern] = STATE(4665),
    [sym_method_definition] = STATE(4687),
    [sym_pair] = STATE(4687),
    [sym_pair_pattern] = STATE(4665),
    [sym__property_name] = STATE(3705),
    [sym_computed_property_name] = STATE(3705),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(253),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_accessibility_modifier] = STATE(2732),
    [sym_override_modifier] = STATE(2743),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_program_repeat1] = STATE(16),
    [aux_sym_export_statement_repeat1] = STATE(3919),
    [aux_sym_object_repeat1] = STATE(4618),
    [aux_sym_object_pattern_repeat1] = STATE(4622),
    [sym_identifier] = ACTIONS(227),
    [anon_sym_export] = ACTIONS(229),
    [anon_sym_STAR] = ACTIONS(231),
    [anon_sym_type] = ACTIONS(233),
    [anon_sym_namespace] = ACTIONS(235),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_COMMA] = ACTIONS(237),
    [anon_sym_RBRACE] = ACTIONS(239),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(241),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(243),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(245),
    [anon_sym_function] = ACTIONS(75),
    [anon_sym_new] = ACTIONS(247),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(249),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(251),
    [sym_private_property_identifier] = ACTIONS(253),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(255),
    [anon_sym_readonly] = ACTIONS(257),
    [anon_sym_get] = ACTIONS(259),
    [anon_sym_set] = ACTIONS(259),
    [anon_sym_declare] = ACTIONS(261),
    [anon_sym_public] = ACTIONS(263),
    [anon_sym_private] = ACTIONS(263),
    [anon_sym_protected] = ACTIONS(263),
    [anon_sym_override] = ACTIONS(265),
    [anon_sym_module] = ACTIONS(267),
    [anon_sym_any] = ACTIONS(269),
    [anon_sym_number] = ACTIONS(269),
    [anon_sym_boolean] = ACTIONS(269),
    [anon_sym_string] = ACTIONS(269),
    [anon_sym_symbol] = ACTIONS(269),
    [anon_sym_object] = ACTIONS(269),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [5] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(16),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5647),
    [sym_object_assignment_pattern] = STATE(4665),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5647),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5647),
    [sym_spread_element] = STATE(4687),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2134),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_rest_pattern] = STATE(4665),
    [sym_method_definition] = STATE(4687),
    [sym_pair] = STATE(4687),
    [sym_pair_pattern] = STATE(4665),
    [sym__property_name] = STATE(3705),
    [sym_computed_property_name] = STATE(3705),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(253),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_accessibility_modifier] = STATE(2732),
    [sym_override_modifier] = STATE(2743),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_program_repeat1] = STATE(16),
    [aux_sym_export_statement_repeat1] = STATE(3919),
    [aux_sym_object_repeat1] = STATE(4618),
    [aux_sym_object_pattern_repeat1] = STATE(4622),
    [sym_identifier] = ACTIONS(227),
    [anon_sym_export] = ACTIONS(229),
    [anon_sym_STAR] = ACTIONS(231),
    [anon_sym_type] = ACTIONS(233),
    [anon_sym_namespace] = ACTIONS(235),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_COMMA] = ACTIONS(237),
    [anon_sym_RBRACE] = ACTIONS(271),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(241),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(243),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(245),
    [anon_sym_function] = ACTIONS(75),
    [anon_sym_new] = ACTIONS(247),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(249),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(251),
    [sym_private_property_identifier] = ACTIONS(253),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(255),
    [anon_sym_readonly] = ACTIONS(257),
    [anon_sym_get] = ACTIONS(259),
    [anon_sym_set] = ACTIONS(259),
    [anon_sym_declare] = ACTIONS(261),
    [anon_sym_public] = ACTIONS(263),
    [anon_sym_private] = ACTIONS(263),
    [anon_sym_protected] = ACTIONS(263),
    [anon_sym_override] = ACTIONS(265),
    [anon_sym_module] = ACTIONS(267),
    [anon_sym_any] = ACTIONS(269),
    [anon_sym_number] = ACTIONS(269),
    [anon_sym_boolean] = ACTIONS(269),
    [anon_sym_string] = ACTIONS(269),
    [anon_sym_symbol] = ACTIONS(269),
    [anon_sym_object] = ACTIONS(269),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [6] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(21),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5647),
    [sym_object_assignment_pattern] = STATE(4665),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5647),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5647),
    [sym_spread_element] = STATE(4841),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2134),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_rest_pattern] = STATE(4665),
    [sym_method_definition] = STATE(4841),
    [sym_pair] = STATE(4841),
    [sym_pair_pattern] = STATE(4665),
    [sym__property_name] = STATE(3705),
    [sym_computed_property_name] = STATE(3705),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(253),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_accessibility_modifier] = STATE(2732),
    [sym_override_modifier] = STATE(2743),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_program_repeat1] = STATE(21),
    [aux_sym_export_statement_repeat1] = STATE(3919),
    [aux_sym_object_repeat1] = STATE(4848),
    [aux_sym_object_pattern_repeat1] = STATE(4622),
    [sym_identifier] = ACTIONS(273),
    [anon_sym_export] = ACTIONS(275),
    [anon_sym_STAR] = ACTIONS(231),
    [anon_sym_type] = ACTIONS(277),
    [anon_sym_namespace] = ACTIONS(279),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_COMMA] = ACTIONS(237),
    [anon_sym_RBRACE] = ACTIONS(281),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(283),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(243),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(285),
    [anon_sym_function] = ACTIONS(75),
    [anon_sym_new] = ACTIONS(287),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(249),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(251),
    [sym_private_property_identifier] = ACTIONS(253),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(289),
    [anon_sym_readonly] = ACTIONS(291),
    [anon_sym_get] = ACTIONS(293),
    [anon_sym_set] = ACTIONS(293),
    [anon_sym_declare] = ACTIONS(295),
    [anon_sym_public] = ACTIONS(297),
    [anon_sym_private] = ACTIONS(297),
    [anon_sym_protected] = ACTIONS(297),
    [anon_sym_override] = ACTIONS(299),
    [anon_sym_module] = ACTIONS(301),
    [anon_sym_any] = ACTIONS(303),
    [anon_sym_number] = ACTIONS(303),
    [anon_sym_boolean] = ACTIONS(303),
    [anon_sym_string] = ACTIONS(303),
    [anon_sym_symbol] = ACTIONS(303),
    [anon_sym_object] = ACTIONS(303),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [7] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(18),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5647),
    [sym_object_assignment_pattern] = STATE(4665),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5647),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5647),
    [sym_spread_element] = STATE(4687),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2134),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_rest_pattern] = STATE(4665),
    [sym_method_definition] = STATE(4687),
    [sym_pair] = STATE(4687),
    [sym_pair_pattern] = STATE(4665),
    [sym__property_name] = STATE(3705),
    [sym_computed_property_name] = STATE(3705),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(253),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_accessibility_modifier] = STATE(2732),
    [sym_override_modifier] = STATE(2743),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_program_repeat1] = STATE(18),
    [aux_sym_export_statement_repeat1] = STATE(3919),
    [aux_sym_object_repeat1] = STATE(4618),
    [aux_sym_object_pattern_repeat1] = STATE(4622),
    [sym_identifier] = ACTIONS(227),
    [anon_sym_export] = ACTIONS(229),
    [anon_sym_STAR] = ACTIONS(231),
    [anon_sym_type] = ACTIONS(233),
    [anon_sym_namespace] = ACTIONS(235),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_COMMA] = ACTIONS(237),
    [anon_sym_RBRACE] = ACTIONS(305),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(241),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(243),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(245),
    [anon_sym_function] = ACTIONS(75),
    [anon_sym_new] = ACTIONS(247),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(249),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(251),
    [sym_private_property_identifier] = ACTIONS(253),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(255),
    [anon_sym_readonly] = ACTIONS(257),
    [anon_sym_get] = ACTIONS(259),
    [anon_sym_set] = ACTIONS(259),
    [anon_sym_declare] = ACTIONS(261),
    [anon_sym_public] = ACTIONS(263),
    [anon_sym_private] = ACTIONS(263),
    [anon_sym_protected] = ACTIONS(263),
    [anon_sym_override] = ACTIONS(265),
    [anon_sym_module] = ACTIONS(267),
    [anon_sym_any] = ACTIONS(269),
    [anon_sym_number] = ACTIONS(269),
    [anon_sym_boolean] = ACTIONS(269),
    [anon_sym_string] = ACTIONS(269),
    [anon_sym_symbol] = ACTIONS(269),
    [anon_sym_object] = ACTIONS(269),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [8] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(21),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5647),
    [sym_object_assignment_pattern] = STATE(4665),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5647),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5647),
    [sym_spread_element] = STATE(4841),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2134),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_rest_pattern] = STATE(4665),
    [sym_method_definition] = STATE(4841),
    [sym_pair] = STATE(4841),
    [sym_pair_pattern] = STATE(4665),
    [sym__property_name] = STATE(3705),
    [sym_computed_property_name] = STATE(3705),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(253),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_accessibility_modifier] = STATE(2732),
    [sym_override_modifier] = STATE(2743),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_program_repeat1] = STATE(21),
    [aux_sym_export_statement_repeat1] = STATE(3919),
    [aux_sym_object_repeat1] = STATE(4848),
    [aux_sym_object_pattern_repeat1] = STATE(4622),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_export] = ACTIONS(309),
    [anon_sym_STAR] = ACTIONS(231),
    [anon_sym_type] = ACTIONS(311),
    [anon_sym_namespace] = ACTIONS(313),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_COMMA] = ACTIONS(237),
    [anon_sym_RBRACE] = ACTIONS(281),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(315),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(243),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(317),
    [anon_sym_function] = ACTIONS(75),
    [anon_sym_new] = ACTIONS(319),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(249),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(251),
    [sym_private_property_identifier] = ACTIONS(253),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(321),
    [anon_sym_readonly] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(325),
    [anon_sym_set] = ACTIONS(325),
    [anon_sym_declare] = ACTIONS(327),
    [anon_sym_public] = ACTIONS(329),
    [anon_sym_private] = ACTIONS(329),
    [anon_sym_protected] = ACTIONS(329),
    [anon_sym_override] = ACTIONS(331),
    [anon_sym_module] = ACTIONS(333),
    [anon_sym_any] = ACTIONS(335),
    [anon_sym_number] = ACTIONS(335),
    [anon_sym_boolean] = ACTIONS(335),
    [anon_sym_string] = ACTIONS(335),
    [anon_sym_symbol] = ACTIONS(335),
    [anon_sym_object] = ACTIONS(335),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [9] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(253),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3919),
    [ts_builtin_sym_end] = ACTIONS(337),
    [sym_identifier] = ACTIONS(339),
    [anon_sym_export] = ACTIONS(342),
    [anon_sym_default] = ACTIONS(345),
    [anon_sym_type] = ACTIONS(347),
    [anon_sym_namespace] = ACTIONS(350),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_RBRACE] = ACTIONS(337),
    [anon_sym_typeof] = ACTIONS(356),
    [anon_sym_import] = ACTIONS(359),
    [anon_sym_with] = ACTIONS(362),
    [anon_sym_var] = ACTIONS(365),
    [anon_sym_let] = ACTIONS(368),
    [anon_sym_const] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(374),
    [anon_sym_if] = ACTIONS(377),
    [anon_sym_switch] = ACTIONS(380),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_LPAREN] = ACTIONS(386),
    [anon_sym_SEMI] = ACTIONS(389),
    [anon_sym_await] = ACTIONS(392),
    [anon_sym_while] = ACTIONS(395),
    [anon_sym_do] = ACTIONS(398),
    [anon_sym_try] = ACTIONS(401),
    [anon_sym_break] = ACTIONS(404),
    [anon_sym_continue] = ACTIONS(407),
    [anon_sym_debugger] = ACTIONS(410),
    [anon_sym_return] = ACTIONS(413),
    [anon_sym_throw] = ACTIONS(416),
    [anon_sym_case] = ACTIONS(345),
    [anon_sym_yield] = ACTIONS(419),
    [anon_sym_LBRACK] = ACTIONS(422),
    [anon_sym_DQUOTE] = ACTIONS(425),
    [anon_sym_SQUOTE] = ACTIONS(428),
    [anon_sym_class] = ACTIONS(431),
    [anon_sym_async] = ACTIONS(434),
    [anon_sym_function] = ACTIONS(437),
    [anon_sym_new] = ACTIONS(440),
    [anon_sym_using] = ACTIONS(443),
    [anon_sym_PLUS] = ACTIONS(356),
    [anon_sym_DASH] = ACTIONS(356),
    [anon_sym_SLASH] = ACTIONS(446),
    [anon_sym_LT] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(374),
    [anon_sym_void] = ACTIONS(356),
    [anon_sym_delete] = ACTIONS(356),
    [anon_sym_PLUS_PLUS] = ACTIONS(452),
    [anon_sym_DASH_DASH] = ACTIONS(452),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(455),
    [sym_number] = ACTIONS(458),
    [sym_private_property_identifier] = ACTIONS(461),
    [sym_this] = ACTIONS(464),
    [sym_super] = ACTIONS(464),
    [sym_true] = ACTIONS(464),
    [sym_false] = ACTIONS(464),
    [sym_null] = ACTIONS(464),
    [sym_undefined] = ACTIONS(467),
    [anon_sym_AT] = ACTIONS(470),
    [anon_sym_static] = ACTIONS(473),
    [anon_sym_readonly] = ACTIONS(473),
    [anon_sym_get] = ACTIONS(473),
    [anon_sym_set] = ACTIONS(473),
    [anon_sym_declare] = ACTIONS(476),
    [anon_sym_public] = ACTIONS(473),
    [anon_sym_private] = ACTIONS(473),
    [anon_sym_protected] = ACTIONS(473),
    [anon_sym_override] = ACTIONS(473),
    [anon_sym_module] = ACTIONS(479),
    [anon_sym_any] = ACTIONS(473),
    [anon_sym_number] = ACTIONS(473),
    [anon_sym_boolean] = ACTIONS(473),
    [anon_sym_string] = ACTIONS(473),
    [anon_sym_symbol] = ACTIONS(473),
    [anon_sym_object] = ACTIONS(473),
    [anon_sym_abstract] = ACTIONS(482),
    [anon_sym_interface] = ACTIONS(485),
    [anon_sym_enum] = ACTIONS(488),
    [sym_html_comment] = ACTIONS(5),
  },
  [10] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(253),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3919),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_default] = ACTIONS(491),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(493),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(491),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_function] = ACTIONS(75),
    [anon_sym_new] = ACTIONS(77),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [11] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(10),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(253),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_program_repeat1] = STATE(10),
    [aux_sym_export_statement_repeat1] = STATE(3919),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_default] = ACTIONS(495),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(497),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(495),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_function] = ACTIONS(75),
    [anon_sym_new] = ACTIONS(77),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [12] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(13),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(253),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_program_repeat1] = STATE(13),
    [aux_sym_export_statement_repeat1] = STATE(3919),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_default] = ACTIONS(499),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(501),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(499),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_function] = ACTIONS(75),
    [anon_sym_new] = ACTIONS(77),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [13] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(253),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3919),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_default] = ACTIONS(503),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(505),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(503),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_function] = ACTIONS(75),
    [anon_sym_new] = ACTIONS(77),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [14] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(253),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3919),
    [ts_builtin_sym_end] = ACTIONS(507),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_function] = ACTIONS(75),
    [anon_sym_new] = ACTIONS(77),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [15] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(253),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3919),
    [ts_builtin_sym_end] = ACTIONS(509),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_function] = ACTIONS(75),
    [anon_sym_new] = ACTIONS(77),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [16] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(253),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3919),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(511),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_function] = ACTIONS(75),
    [anon_sym_new] = ACTIONS(77),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [17] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(16),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(253),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_program_repeat1] = STATE(16),
    [aux_sym_export_statement_repeat1] = STATE(3919),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(513),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_function] = ACTIONS(75),
    [anon_sym_new] = ACTIONS(77),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [18] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(253),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3919),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(515),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_function] = ACTIONS(75),
    [anon_sym_new] = ACTIONS(77),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [19] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(253),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3919),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(517),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_function] = ACTIONS(75),
    [anon_sym_new] = ACTIONS(77),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [20] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(19),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(253),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_program_repeat1] = STATE(19),
    [aux_sym_export_statement_repeat1] = STATE(3919),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(519),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_function] = ACTIONS(75),
    [anon_sym_new] = ACTIONS(77),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [21] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(253),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3919),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(521),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_function] = ACTIONS(75),
    [anon_sym_new] = ACTIONS(77),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [22] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(21),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(253),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_program_repeat1] = STATE(21),
    [aux_sym_export_statement_repeat1] = STATE(3919),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(523),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_function] = ACTIONS(75),
    [anon_sym_new] = ACTIONS(77),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [23] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(18),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(253),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_program_repeat1] = STATE(18),
    [aux_sym_export_statement_repeat1] = STATE(3919),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(525),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_function] = ACTIONS(75),
    [anon_sym_new] = ACTIONS(77),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [24] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(253),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3919),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(527),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_function] = ACTIONS(75),
    [anon_sym_new] = ACTIONS(77),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [25] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(24),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(253),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_program_repeat1] = STATE(24),
    [aux_sym_export_statement_repeat1] = STATE(3919),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(529),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_function] = ACTIONS(75),
    [anon_sym_new] = ACTIONS(77),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [26] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(253),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3919),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(531),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_function] = ACTIONS(75),
    [anon_sym_new] = ACTIONS(77),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [27] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(29),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(253),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_program_repeat1] = STATE(29),
    [aux_sym_export_statement_repeat1] = STATE(3919),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(533),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_function] = ACTIONS(75),
    [anon_sym_new] = ACTIONS(77),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [28] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(26),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(253),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_program_repeat1] = STATE(26),
    [aux_sym_export_statement_repeat1] = STATE(3919),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(535),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_function] = ACTIONS(75),
    [anon_sym_new] = ACTIONS(77),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [29] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(253),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3919),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(537),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_function] = ACTIONS(75),
    [anon_sym_new] = ACTIONS(77),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [30] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(14),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(253),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_program_repeat1] = STATE(14),
    [aux_sym_export_statement_repeat1] = STATE(3919),
    [ts_builtin_sym_end] = ACTIONS(509),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_function] = ACTIONS(75),
    [anon_sym_new] = ACTIONS(77),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [31] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(895),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(2410),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_export_statement_repeat1] = STATE(3805),
    [sym_identifier] = ACTIONS(539),
    [anon_sym_export] = ACTIONS(541),
    [anon_sym_type] = ACTIONS(543),
    [anon_sym_namespace] = ACTIONS(545),
    [anon_sym_LBRACE] = ACTIONS(547),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(549),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(551),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(553),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(555),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(557),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(567),
    [anon_sym_readonly] = ACTIONS(567),
    [anon_sym_get] = ACTIONS(567),
    [anon_sym_set] = ACTIONS(567),
    [anon_sym_declare] = ACTIONS(569),
    [anon_sym_public] = ACTIONS(567),
    [anon_sym_private] = ACTIONS(567),
    [anon_sym_protected] = ACTIONS(567),
    [anon_sym_override] = ACTIONS(567),
    [anon_sym_module] = ACTIONS(571),
    [anon_sym_any] = ACTIONS(567),
    [anon_sym_number] = ACTIONS(567),
    [anon_sym_boolean] = ACTIONS(567),
    [anon_sym_string] = ACTIONS(567),
    [anon_sym_symbol] = ACTIONS(567),
    [anon_sym_object] = ACTIONS(567),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [32] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(899),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(2410),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_export_statement_repeat1] = STATE(3867),
    [sym_identifier] = ACTIONS(573),
    [anon_sym_export] = ACTIONS(575),
    [anon_sym_type] = ACTIONS(577),
    [anon_sym_namespace] = ACTIONS(579),
    [anon_sym_LBRACE] = ACTIONS(547),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(581),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(583),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(585),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(587),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(589),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(591),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(593),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(595),
    [anon_sym_readonly] = ACTIONS(595),
    [anon_sym_get] = ACTIONS(595),
    [anon_sym_set] = ACTIONS(595),
    [anon_sym_declare] = ACTIONS(597),
    [anon_sym_public] = ACTIONS(595),
    [anon_sym_private] = ACTIONS(595),
    [anon_sym_protected] = ACTIONS(595),
    [anon_sym_override] = ACTIONS(595),
    [anon_sym_module] = ACTIONS(599),
    [anon_sym_any] = ACTIONS(595),
    [anon_sym_number] = ACTIONS(595),
    [anon_sym_boolean] = ACTIONS(595),
    [anon_sym_string] = ACTIONS(595),
    [anon_sym_symbol] = ACTIONS(595),
    [anon_sym_object] = ACTIONS(595),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [33] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(854),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(253),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_export_statement_repeat1] = STATE(3919),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_function] = ACTIONS(75),
    [anon_sym_new] = ACTIONS(77),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [34] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(861),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(253),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_export_statement_repeat1] = STATE(3919),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_function] = ACTIONS(75),
    [anon_sym_new] = ACTIONS(77),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [35] = {
    [sym_import] = STATE(3645),
    [sym_parenthesized_expression] = STATE(1262),
    [sym_expression] = STATE(2302),
    [sym_primary_expression] = STATE(1471),
    [sym_yield_expression] = STATE(1674),
    [sym_object] = STATE(1673),
    [sym_object_pattern] = STATE(3596),
    [sym_assignment_pattern] = STATE(5112),
    [sym_array] = STATE(1673),
    [sym_array_pattern] = STATE(3596),
    [sym_jsx_element] = STATE(1674),
    [sym_jsx_opening_element] = STATE(3199),
    [sym_nested_identifier] = STATE(5753),
    [sym_jsx_self_closing_element] = STATE(1674),
    [sym_class] = STATE(1673),
    [sym_function_expression] = STATE(1673),
    [sym_generator_function] = STATE(1673),
    [sym_arrow_function] = STATE(1673),
    [sym__call_signature] = STATE(5666),
    [sym_call_expression] = STATE(1673),
    [sym_new_expression] = STATE(1511),
    [sym_await_expression] = STATE(1674),
    [sym_member_expression] = STATE(1268),
    [sym_subscript_expression] = STATE(1268),
    [sym_assignment_expression] = STATE(1674),
    [sym__augmented_assignment_lhs] = STATE(2902),
    [sym_augmented_assignment_expression] = STATE(1674),
    [sym__destructuring_pattern] = STATE(3596),
    [sym_spread_element] = STATE(5119),
    [sym_ternary_expression] = STATE(1674),
    [sym_binary_expression] = STATE(1674),
    [sym_unary_expression] = STATE(1674),
    [sym_update_expression] = STATE(1674),
    [sym_string] = STATE(2313),
    [sym_template_string] = STATE(1673),
    [sym_regex] = STATE(1673),
    [sym_meta_property] = STATE(1673),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(4380),
    [sym_pattern] = STATE(4530),
    [sym_rest_pattern] = STATE(3991),
    [sym_non_null_expression] = STATE(1268),
    [sym_as_expression] = STATE(1674),
    [sym_satisfies_expression] = STATE(1674),
    [sym_instantiation_expression] = STATE(1674),
    [sym_internal_module] = STATE(1674),
    [sym_nested_type_identifier] = STATE(2885),
    [sym__type_query_member_expression_in_type_annotation] = STATE(3263),
    [sym__type_query_call_expression_in_type_annotation] = STATE(2895),
    [sym_type] = STATE(3806),
    [sym_tuple_parameter] = STATE(5066),
    [sym_optional_tuple_parameter] = STATE(5066),
    [sym_optional_type] = STATE(5066),
    [sym_rest_type] = STATE(5066),
    [sym__tuple_type_member] = STATE(5066),
    [sym_constructor_type] = STATE(2931),
    [sym_primary_type] = STATE(2932),
    [sym_template_literal_type] = STATE(2981),
    [sym_infer_type] = STATE(2931),
    [sym_conditional_type] = STATE(2981),
    [sym_generic_type] = STATE(2981),
    [sym_type_query] = STATE(2981),
    [sym_index_type_query] = STATE(2981),
    [sym_lookup_type] = STATE(2981),
    [sym_literal_type] = STATE(2981),
    [sym__number] = STATE(2935),
    [sym_existential_type] = STATE(2981),
    [sym_flow_maybe_type] = STATE(2981),
    [sym_parenthesized_type] = STATE(2981),
    [sym_predefined_type] = STATE(2981),
    [sym_object_type] = STATE(2981),
    [sym_type_parameters] = STATE(5560),
    [sym_array_type] = STATE(2981),
    [sym_tuple_type] = STATE(2981),
    [sym_readonly_type] = STATE(2931),
    [sym_union_type] = STATE(2981),
    [sym_intersection_type] = STATE(2981),
    [sym_function_type] = STATE(2931),
    [aux_sym_export_statement_repeat1] = STATE(4590),
    [aux_sym_array_repeat1] = STATE(5132),
    [aux_sym_array_pattern_repeat1] = STATE(5134),
    [sym_identifier] = ACTIONS(601),
    [anon_sym_export] = ACTIONS(603),
    [anon_sym_STAR] = ACTIONS(605),
    [anon_sym_type] = ACTIONS(603),
    [anon_sym_namespace] = ACTIONS(607),
    [anon_sym_LBRACE] = ACTIONS(609),
    [anon_sym_COMMA] = ACTIONS(611),
    [anon_sym_typeof] = ACTIONS(613),
    [anon_sym_import] = ACTIONS(131),
    [anon_sym_let] = ACTIONS(603),
    [anon_sym_const] = ACTIONS(133),
    [anon_sym_BANG] = ACTIONS(615),
    [anon_sym_LPAREN] = ACTIONS(138),
    [anon_sym_await] = ACTIONS(617),
    [anon_sym_yield] = ACTIONS(619),
    [anon_sym_LBRACK] = ACTIONS(621),
    [anon_sym_RBRACK] = ACTIONS(623),
    [anon_sym_DQUOTE] = ACTIONS(146),
    [anon_sym_SQUOTE] = ACTIONS(148),
    [anon_sym_class] = ACTIONS(150),
    [anon_sym_async] = ACTIONS(625),
    [anon_sym_function] = ACTIONS(154),
    [anon_sym_new] = ACTIONS(627),
    [anon_sym_using] = ACTIONS(629),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(631),
    [anon_sym_AMP] = ACTIONS(633),
    [anon_sym_PIPE] = ACTIONS(635),
    [anon_sym_PLUS] = ACTIONS(637),
    [anon_sym_DASH] = ACTIONS(637),
    [anon_sym_SLASH] = ACTIONS(639),
    [anon_sym_LT] = ACTIONS(641),
    [anon_sym_TILDE] = ACTIONS(615),
    [anon_sym_void] = ACTIONS(643),
    [anon_sym_delete] = ACTIONS(645),
    [anon_sym_PLUS_PLUS] = ACTIONS(647),
    [anon_sym_DASH_DASH] = ACTIONS(647),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(188),
    [sym_number] = ACTIONS(190),
    [sym_private_property_identifier] = ACTIONS(649),
    [sym_this] = ACTIONS(651),
    [sym_super] = ACTIONS(196),
    [sym_true] = ACTIONS(198),
    [sym_false] = ACTIONS(198),
    [sym_null] = ACTIONS(198),
    [sym_undefined] = ACTIONS(653),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(603),
    [anon_sym_readonly] = ACTIONS(655),
    [anon_sym_get] = ACTIONS(603),
    [anon_sym_set] = ACTIONS(603),
    [anon_sym_QMARK] = ACTIONS(657),
    [anon_sym_declare] = ACTIONS(603),
    [anon_sym_public] = ACTIONS(603),
    [anon_sym_private] = ACTIONS(603),
    [anon_sym_protected] = ACTIONS(603),
    [anon_sym_override] = ACTIONS(603),
    [anon_sym_module] = ACTIONS(603),
    [anon_sym_any] = ACTIONS(659),
    [anon_sym_number] = ACTIONS(659),
    [anon_sym_boolean] = ACTIONS(659),
    [anon_sym_string] = ACTIONS(659),
    [anon_sym_symbol] = ACTIONS(659),
    [anon_sym_object] = ACTIONS(659),
    [anon_sym_abstract] = ACTIONS(661),
    [anon_sym_infer] = ACTIONS(663),
    [anon_sym_keyof] = ACTIONS(665),
    [anon_sym_unique] = ACTIONS(214),
    [anon_sym_unknown] = ACTIONS(216),
    [anon_sym_never] = ACTIONS(216),
    [anon_sym_LBRACE_PIPE] = ACTIONS(218),
    [sym_html_comment] = ACTIONS(5),
  },
  [36] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(822),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(253),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_export_statement_repeat1] = STATE(3919),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_function] = ACTIONS(75),
    [anon_sym_new] = ACTIONS(77),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [37] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(5774),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(2410),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_export_statement_repeat1] = STATE(3805),
    [sym_identifier] = ACTIONS(539),
    [anon_sym_export] = ACTIONS(541),
    [anon_sym_type] = ACTIONS(543),
    [anon_sym_namespace] = ACTIONS(545),
    [anon_sym_LBRACE] = ACTIONS(547),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(549),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(551),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(553),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(555),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(557),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(567),
    [anon_sym_readonly] = ACTIONS(567),
    [anon_sym_get] = ACTIONS(567),
    [anon_sym_set] = ACTIONS(567),
    [anon_sym_declare] = ACTIONS(569),
    [anon_sym_public] = ACTIONS(567),
    [anon_sym_private] = ACTIONS(567),
    [anon_sym_protected] = ACTIONS(567),
    [anon_sym_override] = ACTIONS(567),
    [anon_sym_module] = ACTIONS(571),
    [anon_sym_any] = ACTIONS(567),
    [anon_sym_number] = ACTIONS(567),
    [anon_sym_boolean] = ACTIONS(567),
    [anon_sym_string] = ACTIONS(567),
    [anon_sym_symbol] = ACTIONS(567),
    [anon_sym_object] = ACTIONS(567),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [38] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(860),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(253),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_export_statement_repeat1] = STATE(3919),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_function] = ACTIONS(75),
    [anon_sym_new] = ACTIONS(77),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [39] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(878),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(253),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_export_statement_repeat1] = STATE(3919),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_function] = ACTIONS(75),
    [anon_sym_new] = ACTIONS(77),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [40] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(881),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(253),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_export_statement_repeat1] = STATE(3919),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_function] = ACTIONS(75),
    [anon_sym_new] = ACTIONS(77),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [41] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(882),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(253),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_export_statement_repeat1] = STATE(3919),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_function] = ACTIONS(75),
    [anon_sym_new] = ACTIONS(77),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [42] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(884),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(253),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_export_statement_repeat1] = STATE(3919),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_function] = ACTIONS(75),
    [anon_sym_new] = ACTIONS(77),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [43] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(894),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(253),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_export_statement_repeat1] = STATE(3919),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_function] = ACTIONS(75),
    [anon_sym_new] = ACTIONS(77),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [44] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(895),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(253),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_export_statement_repeat1] = STATE(3919),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_function] = ACTIONS(75),
    [anon_sym_new] = ACTIONS(77),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [45] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(897),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(253),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_export_statement_repeat1] = STATE(3919),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_function] = ACTIONS(75),
    [anon_sym_new] = ACTIONS(77),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [46] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(899),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(253),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_export_statement_repeat1] = STATE(3919),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_function] = ACTIONS(75),
    [anon_sym_new] = ACTIONS(77),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [47] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(878),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(2410),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_export_statement_repeat1] = STATE(3805),
    [sym_identifier] = ACTIONS(539),
    [anon_sym_export] = ACTIONS(541),
    [anon_sym_type] = ACTIONS(543),
    [anon_sym_namespace] = ACTIONS(545),
    [anon_sym_LBRACE] = ACTIONS(547),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(549),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(551),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(553),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(555),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(557),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(567),
    [anon_sym_readonly] = ACTIONS(567),
    [anon_sym_get] = ACTIONS(567),
    [anon_sym_set] = ACTIONS(567),
    [anon_sym_declare] = ACTIONS(569),
    [anon_sym_public] = ACTIONS(567),
    [anon_sym_private] = ACTIONS(567),
    [anon_sym_protected] = ACTIONS(567),
    [anon_sym_override] = ACTIONS(567),
    [anon_sym_module] = ACTIONS(571),
    [anon_sym_any] = ACTIONS(567),
    [anon_sym_number] = ACTIONS(567),
    [anon_sym_boolean] = ACTIONS(567),
    [anon_sym_string] = ACTIONS(567),
    [anon_sym_symbol] = ACTIONS(567),
    [anon_sym_object] = ACTIONS(567),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [48] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(826),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(2410),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_export_statement_repeat1] = STATE(3805),
    [sym_identifier] = ACTIONS(539),
    [anon_sym_export] = ACTIONS(541),
    [anon_sym_type] = ACTIONS(543),
    [anon_sym_namespace] = ACTIONS(545),
    [anon_sym_LBRACE] = ACTIONS(547),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(549),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(551),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(553),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(555),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(557),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(567),
    [anon_sym_readonly] = ACTIONS(567),
    [anon_sym_get] = ACTIONS(567),
    [anon_sym_set] = ACTIONS(567),
    [anon_sym_declare] = ACTIONS(569),
    [anon_sym_public] = ACTIONS(567),
    [anon_sym_private] = ACTIONS(567),
    [anon_sym_protected] = ACTIONS(567),
    [anon_sym_override] = ACTIONS(567),
    [anon_sym_module] = ACTIONS(571),
    [anon_sym_any] = ACTIONS(567),
    [anon_sym_number] = ACTIONS(567),
    [anon_sym_boolean] = ACTIONS(567),
    [anon_sym_string] = ACTIONS(567),
    [anon_sym_symbol] = ACTIONS(567),
    [anon_sym_object] = ACTIONS(567),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [49] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(4783),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(2410),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_export_statement_repeat1] = STATE(3867),
    [sym_identifier] = ACTIONS(573),
    [anon_sym_export] = ACTIONS(575),
    [anon_sym_type] = ACTIONS(577),
    [anon_sym_namespace] = ACTIONS(579),
    [anon_sym_LBRACE] = ACTIONS(547),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(581),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(583),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(585),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(587),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(589),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(591),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(593),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(595),
    [anon_sym_readonly] = ACTIONS(595),
    [anon_sym_get] = ACTIONS(595),
    [anon_sym_set] = ACTIONS(595),
    [anon_sym_declare] = ACTIONS(597),
    [anon_sym_public] = ACTIONS(595),
    [anon_sym_private] = ACTIONS(595),
    [anon_sym_protected] = ACTIONS(595),
    [anon_sym_override] = ACTIONS(595),
    [anon_sym_module] = ACTIONS(599),
    [anon_sym_any] = ACTIONS(595),
    [anon_sym_number] = ACTIONS(595),
    [anon_sym_boolean] = ACTIONS(595),
    [anon_sym_string] = ACTIONS(595),
    [anon_sym_symbol] = ACTIONS(595),
    [anon_sym_object] = ACTIONS(595),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [50] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(848),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(2410),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_export_statement_repeat1] = STATE(3805),
    [sym_identifier] = ACTIONS(539),
    [anon_sym_export] = ACTIONS(541),
    [anon_sym_type] = ACTIONS(543),
    [anon_sym_namespace] = ACTIONS(545),
    [anon_sym_LBRACE] = ACTIONS(547),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(549),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(551),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(553),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(555),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(557),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(567),
    [anon_sym_readonly] = ACTIONS(567),
    [anon_sym_get] = ACTIONS(567),
    [anon_sym_set] = ACTIONS(567),
    [anon_sym_declare] = ACTIONS(569),
    [anon_sym_public] = ACTIONS(567),
    [anon_sym_private] = ACTIONS(567),
    [anon_sym_protected] = ACTIONS(567),
    [anon_sym_override] = ACTIONS(567),
    [anon_sym_module] = ACTIONS(571),
    [anon_sym_any] = ACTIONS(567),
    [anon_sym_number] = ACTIONS(567),
    [anon_sym_boolean] = ACTIONS(567),
    [anon_sym_string] = ACTIONS(567),
    [anon_sym_symbol] = ACTIONS(567),
    [anon_sym_object] = ACTIONS(567),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [51] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(861),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(2410),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_export_statement_repeat1] = STATE(3805),
    [sym_identifier] = ACTIONS(539),
    [anon_sym_export] = ACTIONS(541),
    [anon_sym_type] = ACTIONS(543),
    [anon_sym_namespace] = ACTIONS(545),
    [anon_sym_LBRACE] = ACTIONS(547),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(549),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(551),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(553),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(555),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(557),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(567),
    [anon_sym_readonly] = ACTIONS(567),
    [anon_sym_get] = ACTIONS(567),
    [anon_sym_set] = ACTIONS(567),
    [anon_sym_declare] = ACTIONS(569),
    [anon_sym_public] = ACTIONS(567),
    [anon_sym_private] = ACTIONS(567),
    [anon_sym_protected] = ACTIONS(567),
    [anon_sym_override] = ACTIONS(567),
    [anon_sym_module] = ACTIONS(571),
    [anon_sym_any] = ACTIONS(567),
    [anon_sym_number] = ACTIONS(567),
    [anon_sym_boolean] = ACTIONS(567),
    [anon_sym_string] = ACTIONS(567),
    [anon_sym_symbol] = ACTIONS(567),
    [anon_sym_object] = ACTIONS(567),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [52] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(854),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(2410),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_export_statement_repeat1] = STATE(3805),
    [sym_identifier] = ACTIONS(539),
    [anon_sym_export] = ACTIONS(541),
    [anon_sym_type] = ACTIONS(543),
    [anon_sym_namespace] = ACTIONS(545),
    [anon_sym_LBRACE] = ACTIONS(547),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(549),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(551),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(553),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(555),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(557),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(567),
    [anon_sym_readonly] = ACTIONS(567),
    [anon_sym_get] = ACTIONS(567),
    [anon_sym_set] = ACTIONS(567),
    [anon_sym_declare] = ACTIONS(569),
    [anon_sym_public] = ACTIONS(567),
    [anon_sym_private] = ACTIONS(567),
    [anon_sym_protected] = ACTIONS(567),
    [anon_sym_override] = ACTIONS(567),
    [anon_sym_module] = ACTIONS(571),
    [anon_sym_any] = ACTIONS(567),
    [anon_sym_number] = ACTIONS(567),
    [anon_sym_boolean] = ACTIONS(567),
    [anon_sym_string] = ACTIONS(567),
    [anon_sym_symbol] = ACTIONS(567),
    [anon_sym_object] = ACTIONS(567),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [53] = {
    [sym_import] = STATE(3645),
    [sym_parenthesized_expression] = STATE(1262),
    [sym_expression] = STATE(2146),
    [sym_primary_expression] = STATE(1471),
    [sym_yield_expression] = STATE(1674),
    [sym_object] = STATE(1673),
    [sym_object_pattern] = STATE(3596),
    [sym_assignment_pattern] = STATE(5112),
    [sym_array] = STATE(1673),
    [sym_array_pattern] = STATE(3596),
    [sym_jsx_element] = STATE(1674),
    [sym_jsx_opening_element] = STATE(3199),
    [sym_nested_identifier] = STATE(5753),
    [sym_jsx_self_closing_element] = STATE(1674),
    [sym_class] = STATE(1673),
    [sym_function_expression] = STATE(1673),
    [sym_generator_function] = STATE(1673),
    [sym_arrow_function] = STATE(1673),
    [sym__call_signature] = STATE(5666),
    [sym_call_expression] = STATE(1673),
    [sym_new_expression] = STATE(1511),
    [sym_await_expression] = STATE(1674),
    [sym_member_expression] = STATE(1268),
    [sym_subscript_expression] = STATE(1268),
    [sym_assignment_expression] = STATE(1674),
    [sym__augmented_assignment_lhs] = STATE(2902),
    [sym_augmented_assignment_expression] = STATE(1674),
    [sym__destructuring_pattern] = STATE(3596),
    [sym_spread_element] = STATE(4912),
    [sym_ternary_expression] = STATE(1674),
    [sym_binary_expression] = STATE(1674),
    [sym_unary_expression] = STATE(1674),
    [sym_update_expression] = STATE(1674),
    [sym_string] = STATE(2313),
    [sym_template_string] = STATE(1673),
    [sym_regex] = STATE(1673),
    [sym_meta_property] = STATE(1673),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(4380),
    [sym_pattern] = STATE(4530),
    [sym_rest_pattern] = STATE(3991),
    [sym_non_null_expression] = STATE(1268),
    [sym_as_expression] = STATE(1674),
    [sym_satisfies_expression] = STATE(1674),
    [sym_instantiation_expression] = STATE(1674),
    [sym_internal_module] = STATE(1674),
    [sym_nested_type_identifier] = STATE(2885),
    [sym__type_query_member_expression_in_type_annotation] = STATE(3263),
    [sym__type_query_call_expression_in_type_annotation] = STATE(2895),
    [sym_type] = STATE(3806),
    [sym_tuple_parameter] = STATE(5066),
    [sym_optional_tuple_parameter] = STATE(5066),
    [sym_optional_type] = STATE(5066),
    [sym_rest_type] = STATE(5066),
    [sym__tuple_type_member] = STATE(5066),
    [sym_constructor_type] = STATE(2931),
    [sym_primary_type] = STATE(2932),
    [sym_template_literal_type] = STATE(2981),
    [sym_infer_type] = STATE(2931),
    [sym_conditional_type] = STATE(2981),
    [sym_generic_type] = STATE(2981),
    [sym_type_query] = STATE(2981),
    [sym_index_type_query] = STATE(2981),
    [sym_lookup_type] = STATE(2981),
    [sym_literal_type] = STATE(2981),
    [sym__number] = STATE(2935),
    [sym_existential_type] = STATE(2981),
    [sym_flow_maybe_type] = STATE(2981),
    [sym_parenthesized_type] = STATE(2981),
    [sym_predefined_type] = STATE(2981),
    [sym_object_type] = STATE(2981),
    [sym_type_parameters] = STATE(5560),
    [sym_array_type] = STATE(2981),
    [sym_tuple_type] = STATE(2981),
    [sym_readonly_type] = STATE(2931),
    [sym_union_type] = STATE(2981),
    [sym_intersection_type] = STATE(2981),
    [sym_function_type] = STATE(2931),
    [aux_sym_export_statement_repeat1] = STATE(4590),
    [aux_sym_array_repeat1] = STATE(4921),
    [aux_sym_array_pattern_repeat1] = STATE(5134),
    [sym_identifier] = ACTIONS(601),
    [anon_sym_export] = ACTIONS(603),
    [anon_sym_STAR] = ACTIONS(605),
    [anon_sym_type] = ACTIONS(603),
    [anon_sym_namespace] = ACTIONS(607),
    [anon_sym_LBRACE] = ACTIONS(609),
    [anon_sym_COMMA] = ACTIONS(611),
    [anon_sym_typeof] = ACTIONS(613),
    [anon_sym_import] = ACTIONS(131),
    [anon_sym_let] = ACTIONS(603),
    [anon_sym_const] = ACTIONS(133),
    [anon_sym_BANG] = ACTIONS(615),
    [anon_sym_LPAREN] = ACTIONS(138),
    [anon_sym_await] = ACTIONS(617),
    [anon_sym_yield] = ACTIONS(619),
    [anon_sym_LBRACK] = ACTIONS(621),
    [anon_sym_RBRACK] = ACTIONS(667),
    [anon_sym_DQUOTE] = ACTIONS(146),
    [anon_sym_SQUOTE] = ACTIONS(148),
    [anon_sym_class] = ACTIONS(150),
    [anon_sym_async] = ACTIONS(625),
    [anon_sym_function] = ACTIONS(154),
    [anon_sym_new] = ACTIONS(627),
    [anon_sym_using] = ACTIONS(629),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(631),
    [anon_sym_AMP] = ACTIONS(633),
    [anon_sym_PIPE] = ACTIONS(635),
    [anon_sym_PLUS] = ACTIONS(637),
    [anon_sym_DASH] = ACTIONS(637),
    [anon_sym_SLASH] = ACTIONS(639),
    [anon_sym_LT] = ACTIONS(641),
    [anon_sym_TILDE] = ACTIONS(615),
    [anon_sym_void] = ACTIONS(643),
    [anon_sym_delete] = ACTIONS(645),
    [anon_sym_PLUS_PLUS] = ACTIONS(647),
    [anon_sym_DASH_DASH] = ACTIONS(647),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(188),
    [sym_number] = ACTIONS(190),
    [sym_private_property_identifier] = ACTIONS(649),
    [sym_this] = ACTIONS(651),
    [sym_super] = ACTIONS(196),
    [sym_true] = ACTIONS(198),
    [sym_false] = ACTIONS(198),
    [sym_null] = ACTIONS(198),
    [sym_undefined] = ACTIONS(653),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(603),
    [anon_sym_readonly] = ACTIONS(655),
    [anon_sym_get] = ACTIONS(603),
    [anon_sym_set] = ACTIONS(603),
    [anon_sym_QMARK] = ACTIONS(657),
    [anon_sym_declare] = ACTIONS(603),
    [anon_sym_public] = ACTIONS(603),
    [anon_sym_private] = ACTIONS(603),
    [anon_sym_protected] = ACTIONS(603),
    [anon_sym_override] = ACTIONS(603),
    [anon_sym_module] = ACTIONS(603),
    [anon_sym_any] = ACTIONS(659),
    [anon_sym_number] = ACTIONS(659),
    [anon_sym_boolean] = ACTIONS(659),
    [anon_sym_string] = ACTIONS(659),
    [anon_sym_symbol] = ACTIONS(659),
    [anon_sym_object] = ACTIONS(659),
    [anon_sym_abstract] = ACTIONS(661),
    [anon_sym_infer] = ACTIONS(663),
    [anon_sym_keyof] = ACTIONS(665),
    [anon_sym_unique] = ACTIONS(214),
    [anon_sym_unknown] = ACTIONS(216),
    [anon_sym_never] = ACTIONS(216),
    [anon_sym_LBRACE_PIPE] = ACTIONS(218),
    [sym_html_comment] = ACTIONS(5),
  },
  [54] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(822),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(2410),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_export_statement_repeat1] = STATE(3805),
    [sym_identifier] = ACTIONS(539),
    [anon_sym_export] = ACTIONS(541),
    [anon_sym_type] = ACTIONS(543),
    [anon_sym_namespace] = ACTIONS(545),
    [anon_sym_LBRACE] = ACTIONS(547),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(549),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(551),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(553),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(555),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(557),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(567),
    [anon_sym_readonly] = ACTIONS(567),
    [anon_sym_get] = ACTIONS(567),
    [anon_sym_set] = ACTIONS(567),
    [anon_sym_declare] = ACTIONS(569),
    [anon_sym_public] = ACTIONS(567),
    [anon_sym_private] = ACTIONS(567),
    [anon_sym_protected] = ACTIONS(567),
    [anon_sym_override] = ACTIONS(567),
    [anon_sym_module] = ACTIONS(571),
    [anon_sym_any] = ACTIONS(567),
    [anon_sym_number] = ACTIONS(567),
    [anon_sym_boolean] = ACTIONS(567),
    [anon_sym_string] = ACTIONS(567),
    [anon_sym_symbol] = ACTIONS(567),
    [anon_sym_object] = ACTIONS(567),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [55] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(860),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(2410),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_export_statement_repeat1] = STATE(3805),
    [sym_identifier] = ACTIONS(539),
    [anon_sym_export] = ACTIONS(541),
    [anon_sym_type] = ACTIONS(543),
    [anon_sym_namespace] = ACTIONS(545),
    [anon_sym_LBRACE] = ACTIONS(547),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(549),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(551),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(553),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(555),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(557),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(567),
    [anon_sym_readonly] = ACTIONS(567),
    [anon_sym_get] = ACTIONS(567),
    [anon_sym_set] = ACTIONS(567),
    [anon_sym_declare] = ACTIONS(569),
    [anon_sym_public] = ACTIONS(567),
    [anon_sym_private] = ACTIONS(567),
    [anon_sym_protected] = ACTIONS(567),
    [anon_sym_override] = ACTIONS(567),
    [anon_sym_module] = ACTIONS(571),
    [anon_sym_any] = ACTIONS(567),
    [anon_sym_number] = ACTIONS(567),
    [anon_sym_boolean] = ACTIONS(567),
    [anon_sym_string] = ACTIONS(567),
    [anon_sym_symbol] = ACTIONS(567),
    [anon_sym_object] = ACTIONS(567),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [56] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(881),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(2410),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_export_statement_repeat1] = STATE(3805),
    [sym_identifier] = ACTIONS(539),
    [anon_sym_export] = ACTIONS(541),
    [anon_sym_type] = ACTIONS(543),
    [anon_sym_namespace] = ACTIONS(545),
    [anon_sym_LBRACE] = ACTIONS(547),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(549),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(551),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(553),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(555),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(557),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(567),
    [anon_sym_readonly] = ACTIONS(567),
    [anon_sym_get] = ACTIONS(567),
    [anon_sym_set] = ACTIONS(567),
    [anon_sym_declare] = ACTIONS(569),
    [anon_sym_public] = ACTIONS(567),
    [anon_sym_private] = ACTIONS(567),
    [anon_sym_protected] = ACTIONS(567),
    [anon_sym_override] = ACTIONS(567),
    [anon_sym_module] = ACTIONS(571),
    [anon_sym_any] = ACTIONS(567),
    [anon_sym_number] = ACTIONS(567),
    [anon_sym_boolean] = ACTIONS(567),
    [anon_sym_string] = ACTIONS(567),
    [anon_sym_symbol] = ACTIONS(567),
    [anon_sym_object] = ACTIONS(567),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [57] = {
    [sym_export_statement] = STATE(844),
    [sym_declaration] = STATE(844),
    [sym_import] = STATE(3555),
    [sym_import_statement] = STATE(844),
    [sym_statement] = STATE(882),
    [sym_expression_statement] = STATE(844),
    [sym_variable_declaration] = STATE(852),
    [sym_lexical_declaration] = STATE(852),
    [sym_statement_block] = STATE(844),
    [sym_if_statement] = STATE(844),
    [sym_switch_statement] = STATE(844),
    [sym_for_statement] = STATE(844),
    [sym_for_in_statement] = STATE(844),
    [sym_while_statement] = STATE(844),
    [sym_do_statement] = STATE(844),
    [sym_try_statement] = STATE(844),
    [sym_with_statement] = STATE(844),
    [sym_break_statement] = STATE(844),
    [sym_continue_statement] = STATE(844),
    [sym_debugger_statement] = STATE(844),
    [sym_return_statement] = STATE(844),
    [sym_throw_statement] = STATE(844),
    [sym_empty_statement] = STATE(844),
    [sym_labeled_statement] = STATE(844),
    [sym_parenthesized_expression] = STATE(1337),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(1756),
    [sym_yield_expression] = STATE(2126),
    [sym_object] = STATE(2272),
    [sym_object_pattern] = STATE(5785),
    [sym_array] = STATE(2272),
    [sym_array_pattern] = STATE(5785),
    [sym_jsx_element] = STATE(2126),
    [sym_jsx_opening_element] = STATE(3238),
    [sym_jsx_self_closing_element] = STATE(2126),
    [sym_class] = STATE(2272),
    [sym_class_declaration] = STATE(852),
    [sym_function_expression] = STATE(2272),
    [sym_function_declaration] = STATE(852),
    [sym_generator_function] = STATE(2272),
    [sym_generator_function_declaration] = STATE(852),
    [sym_arrow_function] = STATE(2272),
    [sym__call_signature] = STATE(5983),
    [sym_call_expression] = STATE(2272),
    [sym_new_expression] = STATE(1872),
    [sym_await_expression] = STATE(2126),
    [sym_member_expression] = STATE(1337),
    [sym_subscript_expression] = STATE(1337),
    [sym_assignment_expression] = STATE(2126),
    [sym__augmented_assignment_lhs] = STATE(2910),
    [sym_augmented_assignment_expression] = STATE(2126),
    [sym__destructuring_pattern] = STATE(5785),
    [sym_ternary_expression] = STATE(2126),
    [sym_binary_expression] = STATE(2126),
    [sym_unary_expression] = STATE(2126),
    [sym_update_expression] = STATE(2126),
    [sym_sequence_expression] = STATE(5350),
    [sym_string] = STATE(2272),
    [sym_template_string] = STATE(2272),
    [sym_regex] = STATE(2272),
    [sym_meta_property] = STATE(2272),
    [sym_decorator] = STATE(1290),
    [sym_formal_parameters] = STATE(3848),
    [sym_non_null_expression] = STATE(1337),
    [sym_function_signature] = STATE(852),
    [sym_as_expression] = STATE(2126),
    [sym_satisfies_expression] = STATE(2126),
    [sym_instantiation_expression] = STATE(2126),
    [sym_ambient_declaration] = STATE(852),
    [sym_abstract_class_declaration] = STATE(852),
    [sym_module] = STATE(852),
    [sym_internal_module] = STATE(2410),
    [sym_import_alias] = STATE(852),
    [sym_interface_declaration] = STATE(852),
    [sym_enum_declaration] = STATE(852),
    [sym_type_alias_declaration] = STATE(852),
    [sym_type_parameters] = STATE(5231),
    [aux_sym_export_statement_repeat1] = STATE(3805),
    [sym_identifier] = ACTIONS(539),
    [anon_sym_export] = ACTIONS(541),
    [anon_sym_type] = ACTIONS(543),
    [anon_sym_namespace] = ACTIONS(545),
    [anon_sym_LBRACE] = ACTIONS(547),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(549),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(551),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(553),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(555),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(557),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_SQUOTE] = ACTIONS(69),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_using] = ACTIONS(79),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_DASH_DASH] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [