/* automatically generated by rust-bindgen 0.71.1 */

pub const CUDA_VERSION: u32 = 12020;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CUstream_st {
    _unused: [u8; 0],
}
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Default, Copy, Clone, PartialOrd, PartialEq)]
pub struct float2 {
    pub x: f32,
    pub y: f32,
}
#[repr(C)]
#[repr(align(16))]
#[derive(Debug, Default, Copy, Clone, PartialOrd, PartialEq)]
pub struct double2 {
    pub x: f64,
    pub y: f64,
}
pub type cudaStream_t = *mut CUstream_st;
pub type cuFloatComplex = float2;
pub type cuDoubleComplex = double2;
pub type cuComplex = cuFloatComplex;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudaDataType_t {
    CUDA_R_16F = 2,
    CUDA_C_16F = 6,
    CUDA_R_16BF = 14,
    CUDA_C_16BF = 15,
    CUDA_R_32F = 0,
    CUDA_C_32F = 4,
    CUDA_R_64F = 1,
    CUDA_C_64F = 5,
    CUDA_R_4I = 16,
    CUDA_C_4I = 17,
    CUDA_R_4U = 18,
    CUDA_C_4U = 19,
    CUDA_R_8I = 3,
    CUDA_C_8I = 7,
    CUDA_R_8U = 8,
    CUDA_C_8U = 9,
    CUDA_R_16I = 20,
    CUDA_C_16I = 21,
    CUDA_R_16U = 22,
    CUDA_C_16U = 23,
    CUDA_R_32I = 10,
    CUDA_C_32I = 11,
    CUDA_R_32U = 12,
    CUDA_C_32U = 13,
    CUDA_R_64I = 24,
    CUDA_C_64I = 25,
    CUDA_R_64U = 26,
    CUDA_C_64U = 27,
    CUDA_R_8F_E4M3 = 28,
    CUDA_R_8F_E5M2 = 29,
}
pub use self::cudaDataType_t as cudaDataType;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum libraryPropertyType_t {
    MAJOR_VERSION = 0,
    MINOR_VERSION = 1,
    PATCH_LEVEL = 2,
}
pub use self::libraryPropertyType_t as libraryPropertyType;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cublasStatus_t {
    CUBLAS_STATUS_SUCCESS = 0,
    CUBLAS_STATUS_NOT_INITIALIZED = 1,
    CUBLAS_STATUS_ALLOC_FAILED = 3,
    CUBLAS_STATUS_INVALID_VALUE = 7,
    CUBLAS_STATUS_ARCH_MISMATCH = 8,
    CUBLAS_STATUS_MAPPING_ERROR = 11,
    CUBLAS_STATUS_EXECUTION_FAILED = 13,
    CUBLAS_STATUS_INTERNAL_ERROR = 14,
    CUBLAS_STATUS_NOT_SUPPORTED = 15,
    CUBLAS_STATUS_LICENSE_ERROR = 16,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cublasFillMode_t {
    CUBLAS_FILL_MODE_LOWER = 0,
    CUBLAS_FILL_MODE_UPPER = 1,
    CUBLAS_FILL_MODE_FULL = 2,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cublasDiagType_t {
    CUBLAS_DIAG_NON_UNIT = 0,
    CUBLAS_DIAG_UNIT = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cublasSideMode_t {
    CUBLAS_SIDE_LEFT = 0,
    CUBLAS_SIDE_RIGHT = 1,
}
impl cublasOperation_t {
    pub const CUBLAS_OP_HERMITAN: cublasOperation_t = cublasOperation_t::CUBLAS_OP_C;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cublasOperation_t {
    CUBLAS_OP_N = 0,
    CUBLAS_OP_T = 1,
    CUBLAS_OP_C = 2,
    CUBLAS_OP_CONJG = 3,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cublasPointerMode_t {
    CUBLAS_POINTER_MODE_HOST = 0,
    CUBLAS_POINTER_MODE_DEVICE = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cublasAtomicsMode_t {
    CUBLAS_ATOMICS_NOT_ALLOWED = 0,
    CUBLAS_ATOMICS_ALLOWED = 1,
}
impl cublasGemmAlgo_t {
    pub const CUBLAS_GEMM_DEFAULT: cublasGemmAlgo_t = cublasGemmAlgo_t::CUBLAS_GEMM_DFALT;
}
impl cublasGemmAlgo_t {
    pub const CUBLAS_GEMM_DFALT_TENSOR_OP: cublasGemmAlgo_t =
        cublasGemmAlgo_t::CUBLAS_GEMM_DEFAULT_TENSOR_OP;
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cublasGemmAlgo_t {
    CUBLAS_GEMM_DFALT = -1,
    CUBLAS_GEMM_ALGO0 = 0,
    CUBLAS_GEMM_ALGO1 = 1,
    CUBLAS_GEMM_ALGO2 = 2,
    CUBLAS_GEMM_ALGO3 = 3,
    CUBLAS_GEMM_ALGO4 = 4,
    CUBLAS_GEMM_ALGO5 = 5,
    CUBLAS_GEMM_ALGO6 = 6,
    CUBLAS_GEMM_ALGO7 = 7,
    CUBLAS_GEMM_ALGO8 = 8,
    CUBLAS_GEMM_ALGO9 = 9,
    CUBLAS_GEMM_ALGO10 = 10,
    CUBLAS_GEMM_ALGO11 = 11,
    CUBLAS_GEMM_ALGO12 = 12,
    CUBLAS_GEMM_ALGO13 = 13,
    CUBLAS_GEMM_ALGO14 = 14,
    CUBLAS_GEMM_ALGO15 = 15,
    CUBLAS_GEMM_ALGO16 = 16,
    CUBLAS_GEMM_ALGO17 = 17,
    CUBLAS_GEMM_ALGO18 = 18,
    CUBLAS_GEMM_ALGO19 = 19,
    CUBLAS_GEMM_ALGO20 = 20,
    CUBLAS_GEMM_ALGO21 = 21,
    CUBLAS_GEMM_ALGO22 = 22,
    CUBLAS_GEMM_ALGO23 = 23,
    CUBLAS_GEMM_DEFAULT_TENSOR_OP = 99,
    CUBLAS_GEMM_ALGO0_TENSOR_OP = 100,
    CUBLAS_GEMM_ALGO1_TENSOR_OP = 101,
    CUBLAS_GEMM_ALGO2_TENSOR_OP = 102,
    CUBLAS_GEMM_ALGO3_TENSOR_OP = 103,
    CUBLAS_GEMM_ALGO4_TENSOR_OP = 104,
    CUBLAS_GEMM_ALGO5_TENSOR_OP = 105,
    CUBLAS_GEMM_ALGO6_TENSOR_OP = 106,
    CUBLAS_GEMM_ALGO7_TENSOR_OP = 107,
    CUBLAS_GEMM_ALGO8_TENSOR_OP = 108,
    CUBLAS_GEMM_ALGO9_TENSOR_OP = 109,
    CUBLAS_GEMM_ALGO10_TENSOR_OP = 110,
    CUBLAS_GEMM_ALGO11_TENSOR_OP = 111,
    CUBLAS_GEMM_ALGO12_TENSOR_OP = 112,
    CUBLAS_GEMM_ALGO13_TENSOR_OP = 113,
    CUBLAS_GEMM_ALGO14_TENSOR_OP = 114,
    CUBLAS_GEMM_ALGO15_TENSOR_OP = 115,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cublasMath_t {
    CUBLAS_DEFAULT_MATH = 0,
    CUBLAS_TENSOR_OP_MATH = 1,
    CUBLAS_PEDANTIC_MATH = 2,
    CUBLAS_TF32_TENSOR_OP_MATH = 3,
    CUBLAS_MATH_DISALLOW_REDUCED_PRECISION_REDUCTION = 16,
}
pub use self::cudaDataType as cublasDataType_t;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cublasComputeType_t {
    CUBLAS_COMPUTE_16F = 64,
    CUBLAS_COMPUTE_16F_PEDANTIC = 65,
    CUBLAS_COMPUTE_32F = 68,
    CUBLAS_COMPUTE_32F_PEDANTIC = 69,
    CUBLAS_COMPUTE_32F_FAST_16F = 74,
    CUBLAS_COMPUTE_32F_FAST_16BF = 75,
    CUBLAS_COMPUTE_32F_FAST_TF32 = 77,
    CUBLAS_COMPUTE_64F = 70,
    CUBLAS_COMPUTE_64F_PEDANTIC = 71,
    CUBLAS_COMPUTE_32I = 72,
    CUBLAS_COMPUTE_32I_PEDANTIC = 73,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cublasContext {
    _unused: [u8; 0],
}
pub type cublasHandle_t = *mut cublasContext;
pub type cublasLogCallback =
    ::core::option::Option<unsafe extern "C" fn(msg: *const ::core::ffi::c_char)>;
pub struct Lib {
    __library: ::libloading::Library,
    pub cublasCreate_v2: Result<
        unsafe extern "C" fn(handle: *mut cublasHandle_t) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDestroy_v2:
        Result<unsafe extern "C" fn(handle: cublasHandle_t) -> cublasStatus_t, ::libloading::Error>,
    pub cublasGetVersion_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            version: *mut ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasGetProperty: Result<
        unsafe extern "C" fn(
            type_: libraryPropertyType,
            value: *mut ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasGetCudartVersion: Result<unsafe extern "C" fn() -> usize, ::libloading::Error>,
    pub cublasSetWorkspace_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            workspace: *mut ::core::ffi::c_void,
            workspaceSizeInBytes: usize,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSetStream_v2: Result<
        unsafe extern "C" fn(handle: cublasHandle_t, streamId: cudaStream_t) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasGetStream_v2: Result<
        unsafe extern "C" fn(handle: cublasHandle_t, streamId: *mut cudaStream_t) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasGetPointerMode_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            mode: *mut cublasPointerMode_t,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSetPointerMode_v2: Result<
        unsafe extern "C" fn(handle: cublasHandle_t, mode: cublasPointerMode_t) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasGetAtomicsMode: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            mode: *mut cublasAtomicsMode_t,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSetAtomicsMode: Result<
        unsafe extern "C" fn(handle: cublasHandle_t, mode: cublasAtomicsMode_t) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasGetMathMode: Result<
        unsafe extern "C" fn(handle: cublasHandle_t, mode: *mut cublasMath_t) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSetMathMode: Result<
        unsafe extern "C" fn(handle: cublasHandle_t, mode: cublasMath_t) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasGetSmCountTarget: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            smCountTarget: *mut ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSetSmCountTarget: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            smCountTarget: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasGetStatusName: Result<
        unsafe extern "C" fn(status: cublasStatus_t) -> *const ::core::ffi::c_char,
        ::libloading::Error,
    >,
    pub cublasGetStatusString: Result<
        unsafe extern "C" fn(status: cublasStatus_t) -> *const ::core::ffi::c_char,
        ::libloading::Error,
    >,
    pub cublasLoggerConfigure: Result<
        unsafe extern "C" fn(
            logIsOn: ::core::ffi::c_int,
            logToStdOut: ::core::ffi::c_int,
            logToStdErr: ::core::ffi::c_int,
            logFileName: *const ::core::ffi::c_char,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSetLoggerCallback: Result<
        unsafe extern "C" fn(userCallback: cublasLogCallback) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasGetLoggerCallback: Result<
        unsafe extern "C" fn(userCallback: *mut cublasLogCallback) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSetVector: Result<
        unsafe extern "C" fn(
            n: ::core::ffi::c_int,
            elemSize: ::core::ffi::c_int,
            x: *const ::core::ffi::c_void,
            incx: ::core::ffi::c_int,
            devicePtr: *mut ::core::ffi::c_void,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSetVector_64: Result<
        unsafe extern "C" fn(
            n: i64,
            elemSize: i64,
            x: *const ::core::ffi::c_void,
            incx: i64,
            devicePtr: *mut ::core::ffi::c_void,
            incy: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasGetVector: Result<
        unsafe extern "C" fn(
            n: ::core::ffi::c_int,
            elemSize: ::core::ffi::c_int,
            x: *const ::core::ffi::c_void,
            incx: ::core::ffi::c_int,
            y: *mut ::core::ffi::c_void,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasGetVector_64: Result<
        unsafe extern "C" fn(
            n: i64,
            elemSize: i64,
            x: *const ::core::ffi::c_void,
            incx: i64,
            y: *mut ::core::ffi::c_void,
            incy: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSetMatrix: Result<
        unsafe extern "C" fn(
            rows: ::core::ffi::c_int,
            cols: ::core::ffi::c_int,
            elemSize: ::core::ffi::c_int,
            A: *const ::core::ffi::c_void,
            lda: ::core::ffi::c_int,
            B: *mut ::core::ffi::c_void,
            ldb: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSetMatrix_64: Result<
        unsafe extern "C" fn(
            rows: i64,
            cols: i64,
            elemSize: i64,
            A: *const ::core::ffi::c_void,
            lda: i64,
            B: *mut ::core::ffi::c_void,
            ldb: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasGetMatrix: Result<
        unsafe extern "C" fn(
            rows: ::core::ffi::c_int,
            cols: ::core::ffi::c_int,
            elemSize: ::core::ffi::c_int,
            A: *const ::core::ffi::c_void,
            lda: ::core::ffi::c_int,
            B: *mut ::core::ffi::c_void,
            ldb: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasGetMatrix_64: Result<
        unsafe extern "C" fn(
            rows: i64,
            cols: i64,
            elemSize: i64,
            A: *const ::core::ffi::c_void,
            lda: i64,
            B: *mut ::core::ffi::c_void,
            ldb: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSetVectorAsync: Result<
        unsafe extern "C" fn(
            n: ::core::ffi::c_int,
            elemSize: ::core::ffi::c_int,
            hostPtr: *const ::core::ffi::c_void,
            incx: ::core::ffi::c_int,
            devicePtr: *mut ::core::ffi::c_void,
            incy: ::core::ffi::c_int,
            stream: cudaStream_t,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSetVectorAsync_64: Result<
        unsafe extern "C" fn(
            n: i64,
            elemSize: i64,
            hostPtr: *const ::core::ffi::c_void,
            incx: i64,
            devicePtr: *mut ::core::ffi::c_void,
            incy: i64,
            stream: cudaStream_t,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasGetVectorAsync: Result<
        unsafe extern "C" fn(
            n: ::core::ffi::c_int,
            elemSize: ::core::ffi::c_int,
            devicePtr: *const ::core::ffi::c_void,
            incx: ::core::ffi::c_int,
            hostPtr: *mut ::core::ffi::c_void,
            incy: ::core::ffi::c_int,
            stream: cudaStream_t,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasGetVectorAsync_64: Result<
        unsafe extern "C" fn(
            n: i64,
            elemSize: i64,
            devicePtr: *const ::core::ffi::c_void,
            incx: i64,
            hostPtr: *mut ::core::ffi::c_void,
            incy: i64,
            stream: cudaStream_t,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSetMatrixAsync: Result<
        unsafe extern "C" fn(
            rows: ::core::ffi::c_int,
            cols: ::core::ffi::c_int,
            elemSize: ::core::ffi::c_int,
            A: *const ::core::ffi::c_void,
            lda: ::core::ffi::c_int,
            B: *mut ::core::ffi::c_void,
            ldb: ::core::ffi::c_int,
            stream: cudaStream_t,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSetMatrixAsync_64: Result<
        unsafe extern "C" fn(
            rows: i64,
            cols: i64,
            elemSize: i64,
            A: *const ::core::ffi::c_void,
            lda: i64,
            B: *mut ::core::ffi::c_void,
            ldb: i64,
            stream: cudaStream_t,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasGetMatrixAsync: Result<
        unsafe extern "C" fn(
            rows: ::core::ffi::c_int,
            cols: ::core::ffi::c_int,
            elemSize: ::core::ffi::c_int,
            A: *const ::core::ffi::c_void,
            lda: ::core::ffi::c_int,
            B: *mut ::core::ffi::c_void,
            ldb: ::core::ffi::c_int,
            stream: cudaStream_t,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasGetMatrixAsync_64: Result<
        unsafe extern "C" fn(
            rows: i64,
            cols: i64,
            elemSize: i64,
            A: *const ::core::ffi::c_void,
            lda: i64,
            B: *mut ::core::ffi::c_void,
            ldb: i64,
            stream: cudaStream_t,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasXerbla: Result<
        unsafe extern "C" fn(srName: *const ::core::ffi::c_char, info: ::core::ffi::c_int),
        ::libloading::Error,
    >,
    pub cublasNrm2Ex: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const ::core::ffi::c_void,
            xType: cudaDataType,
            incx: ::core::ffi::c_int,
            result: *mut ::core::ffi::c_void,
            resultType: cudaDataType,
            executionType: cudaDataType,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasNrm2Ex_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const ::core::ffi::c_void,
            xType: cudaDataType,
            incx: i64,
            result: *mut ::core::ffi::c_void,
            resultType: cudaDataType,
            executionType: cudaDataType,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSnrm2_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const f32,
            incx: ::core::ffi::c_int,
            result: *mut f32,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSnrm2_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const f32,
            incx: i64,
            result: *mut f32,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDnrm2_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const f64,
            incx: ::core::ffi::c_int,
            result: *mut f64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDnrm2_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const f64,
            incx: i64,
            result: *mut f64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasScnrm2_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            result: *mut f32,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasScnrm2_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const cuComplex,
            incx: i64,
            result: *mut f32,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDznrm2_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            result: *mut f64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDznrm2_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const cuDoubleComplex,
            incx: i64,
            result: *mut f64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDotEx: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const ::core::ffi::c_void,
            xType: cudaDataType,
            incx: ::core::ffi::c_int,
            y: *const ::core::ffi::c_void,
            yType: cudaDataType,
            incy: ::core::ffi::c_int,
            result: *mut ::core::ffi::c_void,
            resultType: cudaDataType,
            executionType: cudaDataType,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDotEx_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const ::core::ffi::c_void,
            xType: cudaDataType,
            incx: i64,
            y: *const ::core::ffi::c_void,
            yType: cudaDataType,
            incy: i64,
            result: *mut ::core::ffi::c_void,
            resultType: cudaDataType,
            executionType: cudaDataType,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDotcEx: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const ::core::ffi::c_void,
            xType: cudaDataType,
            incx: ::core::ffi::c_int,
            y: *const ::core::ffi::c_void,
            yType: cudaDataType,
            incy: ::core::ffi::c_int,
            result: *mut ::core::ffi::c_void,
            resultType: cudaDataType,
            executionType: cudaDataType,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDotcEx_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const ::core::ffi::c_void,
            xType: cudaDataType,
            incx: i64,
            y: *const ::core::ffi::c_void,
            yType: cudaDataType,
            incy: i64,
            result: *mut ::core::ffi::c_void,
            resultType: cudaDataType,
            executionType: cudaDataType,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSdot_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const f32,
            incx: ::core::ffi::c_int,
            y: *const f32,
            incy: ::core::ffi::c_int,
            result: *mut f32,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSdot_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const f32,
            incx: i64,
            y: *const f32,
            incy: i64,
            result: *mut f32,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDdot_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const f64,
            incx: ::core::ffi::c_int,
            y: *const f64,
            incy: ::core::ffi::c_int,
            result: *mut f64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDdot_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const f64,
            incx: i64,
            y: *const f64,
            incy: i64,
            result: *mut f64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCdotu_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            y: *const cuComplex,
            incy: ::core::ffi::c_int,
            result: *mut cuComplex,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCdotu_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const cuComplex,
            incx: i64,
            y: *const cuComplex,
            incy: i64,
            result: *mut cuComplex,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCdotc_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            y: *const cuComplex,
            incy: ::core::ffi::c_int,
            result: *mut cuComplex,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCdotc_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const cuComplex,
            incx: i64,
            y: *const cuComplex,
            incy: i64,
            result: *mut cuComplex,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZdotu_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            y: *const cuDoubleComplex,
            incy: ::core::ffi::c_int,
            result: *mut cuDoubleComplex,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZdotu_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const cuDoubleComplex,
            incx: i64,
            y: *const cuDoubleComplex,
            incy: i64,
            result: *mut cuDoubleComplex,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZdotc_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            y: *const cuDoubleComplex,
            incy: ::core::ffi::c_int,
            result: *mut cuDoubleComplex,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZdotc_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const cuDoubleComplex,
            incx: i64,
            y: *const cuDoubleComplex,
            incy: i64,
            result: *mut cuDoubleComplex,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasScalEx: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            alpha: *const ::core::ffi::c_void,
            alphaType: cudaDataType,
            x: *mut ::core::ffi::c_void,
            xType: cudaDataType,
            incx: ::core::ffi::c_int,
            executionType: cudaDataType,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasScalEx_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            alpha: *const ::core::ffi::c_void,
            alphaType: cudaDataType,
            x: *mut ::core::ffi::c_void,
            xType: cudaDataType,
            incx: i64,
            executionType: cudaDataType,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSscal_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            x: *mut f32,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSscal_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            alpha: *const f32,
            x: *mut f32,
            incx: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDscal_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            x: *mut f64,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDscal_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            alpha: *const f64,
            x: *mut f64,
            incx: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCscal_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            x: *mut cuComplex,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCscal_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            alpha: *const cuComplex,
            x: *mut cuComplex,
            incx: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCsscal_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            x: *mut cuComplex,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCsscal_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            alpha: *const f32,
            x: *mut cuComplex,
            incx: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZscal_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            x: *mut cuDoubleComplex,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZscal_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            alpha: *const cuDoubleComplex,
            x: *mut cuDoubleComplex,
            incx: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZdscal_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            x: *mut cuDoubleComplex,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZdscal_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            alpha: *const f64,
            x: *mut cuDoubleComplex,
            incx: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasAxpyEx: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            alpha: *const ::core::ffi::c_void,
            alphaType: cudaDataType,
            x: *const ::core::ffi::c_void,
            xType: cudaDataType,
            incx: ::core::ffi::c_int,
            y: *mut ::core::ffi::c_void,
            yType: cudaDataType,
            incy: ::core::ffi::c_int,
            executiontype: cudaDataType,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasAxpyEx_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            alpha: *const ::core::ffi::c_void,
            alphaType: cudaDataType,
            x: *const ::core::ffi::c_void,
            xType: cudaDataType,
            incx: i64,
            y: *mut ::core::ffi::c_void,
            yType: cudaDataType,
            incy: i64,
            executiontype: cudaDataType,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSaxpy_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            x: *const f32,
            incx: ::core::ffi::c_int,
            y: *mut f32,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSaxpy_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            alpha: *const f32,
            x: *const f32,
            incx: i64,
            y: *mut f32,
            incy: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDaxpy_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            x: *const f64,
            incx: ::core::ffi::c_int,
            y: *mut f64,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDaxpy_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            alpha: *const f64,
            x: *const f64,
            incx: i64,
            y: *mut f64,
            incy: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCaxpy_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            y: *mut cuComplex,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCaxpy_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            alpha: *const cuComplex,
            x: *const cuComplex,
            incx: i64,
            y: *mut cuComplex,
            incy: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZaxpy_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            y: *mut cuDoubleComplex,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZaxpy_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            alpha: *const cuDoubleComplex,
            x: *const cuDoubleComplex,
            incx: i64,
            y: *mut cuDoubleComplex,
            incy: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCopyEx: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const ::core::ffi::c_void,
            xType: cudaDataType,
            incx: ::core::ffi::c_int,
            y: *mut ::core::ffi::c_void,
            yType: cudaDataType,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCopyEx_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const ::core::ffi::c_void,
            xType: cudaDataType,
            incx: i64,
            y: *mut ::core::ffi::c_void,
            yType: cudaDataType,
            incy: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasScopy_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const f32,
            incx: ::core::ffi::c_int,
            y: *mut f32,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasScopy_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const f32,
            incx: i64,
            y: *mut f32,
            incy: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDcopy_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const f64,
            incx: ::core::ffi::c_int,
            y: *mut f64,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDcopy_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const f64,
            incx: i64,
            y: *mut f64,
            incy: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCcopy_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            y: *mut cuComplex,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCcopy_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const cuComplex,
            incx: i64,
            y: *mut cuComplex,
            incy: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZcopy_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            y: *mut cuDoubleComplex,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZcopy_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const cuDoubleComplex,
            incx: i64,
            y: *mut cuDoubleComplex,
            incy: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSswap_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *mut f32,
            incx: ::core::ffi::c_int,
            y: *mut f32,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSswap_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *mut f32,
            incx: i64,
            y: *mut f32,
            incy: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDswap_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *mut f64,
            incx: ::core::ffi::c_int,
            y: *mut f64,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDswap_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *mut f64,
            incx: i64,
            y: *mut f64,
            incy: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCswap_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *mut cuComplex,
            incx: ::core::ffi::c_int,
            y: *mut cuComplex,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCswap_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *mut cuComplex,
            incx: i64,
            y: *mut cuComplex,
            incy: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZswap_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *mut cuDoubleComplex,
            incx: ::core::ffi::c_int,
            y: *mut cuDoubleComplex,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZswap_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *mut cuDoubleComplex,
            incx: i64,
            y: *mut cuDoubleComplex,
            incy: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSwapEx: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *mut ::core::ffi::c_void,
            xType: cudaDataType,
            incx: ::core::ffi::c_int,
            y: *mut ::core::ffi::c_void,
            yType: cudaDataType,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSwapEx_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *mut ::core::ffi::c_void,
            xType: cudaDataType,
            incx: i64,
            y: *mut ::core::ffi::c_void,
            yType: cudaDataType,
            incy: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasIsamax_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const f32,
            incx: ::core::ffi::c_int,
            result: *mut ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasIsamax_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const f32,
            incx: i64,
            result: *mut i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasIdamax_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const f64,
            incx: ::core::ffi::c_int,
            result: *mut ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasIdamax_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const f64,
            incx: i64,
            result: *mut i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasIcamax_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            result: *mut ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasIcamax_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const cuComplex,
            incx: i64,
            result: *mut i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasIzamax_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            result: *mut ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasIzamax_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const cuDoubleComplex,
            incx: i64,
            result: *mut i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasIamaxEx: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const ::core::ffi::c_void,
            xType: cudaDataType,
            incx: ::core::ffi::c_int,
            result: *mut ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasIamaxEx_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const ::core::ffi::c_void,
            xType: cudaDataType,
            incx: i64,
            result: *mut i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasIsamin_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const f32,
            incx: ::core::ffi::c_int,
            result: *mut ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasIsamin_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const f32,
            incx: i64,
            result: *mut i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasIdamin_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const f64,
            incx: ::core::ffi::c_int,
            result: *mut ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasIdamin_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const f64,
            incx: i64,
            result: *mut i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasIcamin_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            result: *mut ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasIcamin_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const cuComplex,
            incx: i64,
            result: *mut i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasIzamin_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            result: *mut ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasIzamin_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const cuDoubleComplex,
            incx: i64,
            result: *mut i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasIaminEx: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const ::core::ffi::c_void,
            xType: cudaDataType,
            incx: ::core::ffi::c_int,
            result: *mut ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasIaminEx_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const ::core::ffi::c_void,
            xType: cudaDataType,
            incx: i64,
            result: *mut i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasAsumEx: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const ::core::ffi::c_void,
            xType: cudaDataType,
            incx: ::core::ffi::c_int,
            result: *mut ::core::ffi::c_void,
            resultType: cudaDataType,
            executiontype: cudaDataType,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasAsumEx_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const ::core::ffi::c_void,
            xType: cudaDataType,
            incx: i64,
            result: *mut ::core::ffi::c_void,
            resultType: cudaDataType,
            executiontype: cudaDataType,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSasum_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const f32,
            incx: ::core::ffi::c_int,
            result: *mut f32,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSasum_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const f32,
            incx: i64,
            result: *mut f32,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDasum_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const f64,
            incx: ::core::ffi::c_int,
            result: *mut f64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDasum_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const f64,
            incx: i64,
            result: *mut f64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasScasum_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            result: *mut f32,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasScasum_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const cuComplex,
            incx: i64,
            result: *mut f32,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDzasum_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            result: *mut f64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDzasum_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const cuDoubleComplex,
            incx: i64,
            result: *mut f64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSrot_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *mut f32,
            incx: ::core::ffi::c_int,
            y: *mut f32,
            incy: ::core::ffi::c_int,
            c: *const f32,
            s: *const f32,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSrot_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *mut f32,
            incx: i64,
            y: *mut f32,
            incy: i64,
            c: *const f32,
            s: *const f32,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDrot_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *mut f64,
            incx: ::core::ffi::c_int,
            y: *mut f64,
            incy: ::core::ffi::c_int,
            c: *const f64,
            s: *const f64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDrot_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *mut f64,
            incx: i64,
            y: *mut f64,
            incy: i64,
            c: *const f64,
            s: *const f64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCrot_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *mut cuComplex,
            incx: ::core::ffi::c_int,
            y: *mut cuComplex,
            incy: ::core::ffi::c_int,
            c: *const f32,
            s: *const cuComplex,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCrot_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *mut cuComplex,
            incx: i64,
            y: *mut cuComplex,
            incy: i64,
            c: *const f32,
            s: *const cuComplex,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCsrot_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *mut cuComplex,
            incx: ::core::ffi::c_int,
            y: *mut cuComplex,
            incy: ::core::ffi::c_int,
            c: *const f32,
            s: *const f32,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCsrot_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *mut cuComplex,
            incx: i64,
            y: *mut cuComplex,
            incy: i64,
            c: *const f32,
            s: *const f32,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZrot_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *mut cuDoubleComplex,
            incx: ::core::ffi::c_int,
            y: *mut cuDoubleComplex,
            incy: ::core::ffi::c_int,
            c: *const f64,
            s: *const cuDoubleComplex,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZrot_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *mut cuDoubleComplex,
            incx: i64,
            y: *mut cuDoubleComplex,
            incy: i64,
            c: *const f64,
            s: *const cuDoubleComplex,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZdrot_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *mut cuDoubleComplex,
            incx: ::core::ffi::c_int,
            y: *mut cuDoubleComplex,
            incy: ::core::ffi::c_int,
            c: *const f64,
            s: *const f64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZdrot_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *mut cuDoubleComplex,
            incx: i64,
            y: *mut cuDoubleComplex,
            incy: i64,
            c: *const f64,
            s: *const f64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasRotEx: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *mut ::core::ffi::c_void,
            xType: cudaDataType,
            incx: ::core::ffi::c_int,
            y: *mut ::core::ffi::c_void,
            yType: cudaDataType,
            incy: ::core::ffi::c_int,
            c: *const ::core::ffi::c_void,
            s: *const ::core::ffi::c_void,
            csType: cudaDataType,
            executiontype: cudaDataType,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasRotEx_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *mut ::core::ffi::c_void,
            xType: cudaDataType,
            incx: i64,
            y: *mut ::core::ffi::c_void,
            yType: cudaDataType,
            incy: i64,
            c: *const ::core::ffi::c_void,
            s: *const ::core::ffi::c_void,
            csType: cudaDataType,
            executiontype: cudaDataType,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSrotg_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            a: *mut f32,
            b: *mut f32,
            c: *mut f32,
            s: *mut f32,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDrotg_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            a: *mut f64,
            b: *mut f64,
            c: *mut f64,
            s: *mut f64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCrotg_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            a: *mut cuComplex,
            b: *mut cuComplex,
            c: *mut f32,
            s: *mut cuComplex,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZrotg_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            a: *mut cuDoubleComplex,
            b: *mut cuDoubleComplex,
            c: *mut f64,
            s: *mut cuDoubleComplex,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasRotgEx: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            a: *mut ::core::ffi::c_void,
            b: *mut ::core::ffi::c_void,
            abType: cudaDataType,
            c: *mut ::core::ffi::c_void,
            s: *mut ::core::ffi::c_void,
            csType: cudaDataType,
            executiontype: cudaDataType,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSrotm_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *mut f32,
            incx: ::core::ffi::c_int,
            y: *mut f32,
            incy: ::core::ffi::c_int,
            param: *const f32,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSrotm_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *mut f32,
            incx: i64,
            y: *mut f32,
            incy: i64,
            param: *const f32,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDrotm_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *mut f64,
            incx: ::core::ffi::c_int,
            y: *mut f64,
            incy: ::core::ffi::c_int,
            param: *const f64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDrotm_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *mut f64,
            incx: i64,
            y: *mut f64,
            incy: i64,
            param: *const f64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasRotmEx: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *mut ::core::ffi::c_void,
            xType: cudaDataType,
            incx: ::core::ffi::c_int,
            y: *mut ::core::ffi::c_void,
            yType: cudaDataType,
            incy: ::core::ffi::c_int,
            param: *const ::core::ffi::c_void,
            paramType: cudaDataType,
            executiontype: cudaDataType,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasRotmEx_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *mut ::core::ffi::c_void,
            xType: cudaDataType,
            incx: i64,
            y: *mut ::core::ffi::c_void,
            yType: cudaDataType,
            incy: i64,
            param: *const ::core::ffi::c_void,
            paramType: cudaDataType,
            executiontype: cudaDataType,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSrotmg_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            d1: *mut f32,
            d2: *mut f32,
            x1: *mut f32,
            y1: *const f32,
            param: *mut f32,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDrotmg_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            d1: *mut f64,
            d2: *mut f64,
            x1: *mut f64,
            y1: *const f64,
            param: *mut f64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasRotmgEx: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            d1: *mut ::core::ffi::c_void,
            d1Type: cudaDataType,
            d2: *mut ::core::ffi::c_void,
            d2Type: cudaDataType,
            x1: *mut ::core::ffi::c_void,
            x1Type: cudaDataType,
            y1: *const ::core::ffi::c_void,
            y1Type: cudaDataType,
            param: *mut ::core::ffi::c_void,
            paramType: cudaDataType,
            executiontype: cudaDataType,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSgemv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            A: *const f32,
            lda: ::core::ffi::c_int,
            x: *const f32,
            incx: ::core::ffi::c_int,
            beta: *const f32,
            y: *mut f32,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSgemv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: i64,
            n: i64,
            alpha: *const f32,
            A: *const f32,
            lda: i64,
            x: *const f32,
            incx: i64,
            beta: *const f32,
            y: *mut f32,
            incy: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDgemv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            A: *const f64,
            lda: ::core::ffi::c_int,
            x: *const f64,
            incx: ::core::ffi::c_int,
            beta: *const f64,
            y: *mut f64,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDgemv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: i64,
            n: i64,
            alpha: *const f64,
            A: *const f64,
            lda: i64,
            x: *const f64,
            incx: i64,
            beta: *const f64,
            y: *mut f64,
            incy: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCgemv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            beta: *const cuComplex,
            y: *mut cuComplex,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCgemv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: i64,
            n: i64,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: i64,
            x: *const cuComplex,
            incx: i64,
            beta: *const cuComplex,
            y: *mut cuComplex,
            incy: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZgemv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            beta: *const cuDoubleComplex,
            y: *mut cuDoubleComplex,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZgemv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: i64,
            n: i64,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: i64,
            x: *const cuDoubleComplex,
            incx: i64,
            beta: *const cuDoubleComplex,
            y: *mut cuDoubleComplex,
            incy: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSgbmv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            kl: ::core::ffi::c_int,
            ku: ::core::ffi::c_int,
            alpha: *const f32,
            A: *const f32,
            lda: ::core::ffi::c_int,
            x: *const f32,
            incx: ::core::ffi::c_int,
            beta: *const f32,
            y: *mut f32,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSgbmv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: i64,
            n: i64,
            kl: i64,
            ku: i64,
            alpha: *const f32,
            A: *const f32,
            lda: i64,
            x: *const f32,
            incx: i64,
            beta: *const f32,
            y: *mut f32,
            incy: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDgbmv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            kl: ::core::ffi::c_int,
            ku: ::core::ffi::c_int,
            alpha: *const f64,
            A: *const f64,
            lda: ::core::ffi::c_int,
            x: *const f64,
            incx: ::core::ffi::c_int,
            beta: *const f64,
            y: *mut f64,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDgbmv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: i64,
            n: i64,
            kl: i64,
            ku: i64,
            alpha: *const f64,
            A: *const f64,
            lda: i64,
            x: *const f64,
            incx: i64,
            beta: *const f64,
            y: *mut f64,
            incy: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCgbmv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            kl: ::core::ffi::c_int,
            ku: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            beta: *const cuComplex,
            y: *mut cuComplex,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCgbmv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: i64,
            n: i64,
            kl: i64,
            ku: i64,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: i64,
            x: *const cuComplex,
            incx: i64,
            beta: *const cuComplex,
            y: *mut cuComplex,
            incy: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZgbmv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            kl: ::core::ffi::c_int,
            ku: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            beta: *const cuDoubleComplex,
            y: *mut cuDoubleComplex,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZgbmv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: i64,
            n: i64,
            kl: i64,
            ku: i64,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: i64,
            x: *const cuDoubleComplex,
            incx: i64,
            beta: *const cuDoubleComplex,
            y: *mut cuDoubleComplex,
            incy: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasStrmv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            A: *const f32,
            lda: ::core::ffi::c_int,
            x: *mut f32,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasStrmv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            A: *const f32,
            lda: i64,
            x: *mut f32,
            incx: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDtrmv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            A: *const f64,
            lda: ::core::ffi::c_int,
            x: *mut f64,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDtrmv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            A: *const f64,
            lda: i64,
            x: *mut f64,
            incx: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCtrmv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            x: *mut cuComplex,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCtrmv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            A: *const cuComplex,
            lda: i64,
            x: *mut cuComplex,
            incx: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZtrmv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            x: *mut cuDoubleComplex,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZtrmv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            A: *const cuDoubleComplex,
            lda: i64,
            x: *mut cuDoubleComplex,
            incx: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasStbmv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            A: *const f32,
            lda: ::core::ffi::c_int,
            x: *mut f32,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasStbmv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            k: i64,
            A: *const f32,
            lda: i64,
            x: *mut f32,
            incx: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDtbmv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            A: *const f64,
            lda: ::core::ffi::c_int,
            x: *mut f64,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDtbmv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            k: i64,
            A: *const f64,
            lda: i64,
            x: *mut f64,
            incx: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCtbmv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            x: *mut cuComplex,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCtbmv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            k: i64,
            A: *const cuComplex,
            lda: i64,
            x: *mut cuComplex,
            incx: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZtbmv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            x: *mut cuDoubleComplex,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZtbmv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            k: i64,
            A: *const cuDoubleComplex,
            lda: i64,
            x: *mut cuDoubleComplex,
            incx: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasStpmv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            AP: *const f32,
            x: *mut f32,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasStpmv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            AP: *const f32,
            x: *mut f32,
            incx: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDtpmv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            AP: *const f64,
            x: *mut f64,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDtpmv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            AP: *const f64,
            x: *mut f64,
            incx: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCtpmv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            AP: *const cuComplex,
            x: *mut cuComplex,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCtpmv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            AP: *const cuComplex,
            x: *mut cuComplex,
            incx: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZtpmv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            AP: *const cuDoubleComplex,
            x: *mut cuDoubleComplex,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZtpmv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            AP: *const cuDoubleComplex,
            x: *mut cuDoubleComplex,
            incx: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasStrsv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            A: *const f32,
            lda: ::core::ffi::c_int,
            x: *mut f32,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasStrsv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            A: *const f32,
            lda: i64,
            x: *mut f32,
            incx: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDtrsv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            A: *const f64,
            lda: ::core::ffi::c_int,
            x: *mut f64,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDtrsv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            A: *const f64,
            lda: i64,
            x: *mut f64,
            incx: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCtrsv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            x: *mut cuComplex,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCtrsv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            A: *const cuComplex,
            lda: i64,
            x: *mut cuComplex,
            incx: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZtrsv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            x: *mut cuDoubleComplex,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZtrsv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            A: *const cuDoubleComplex,
            lda: i64,
            x: *mut cuDoubleComplex,
            incx: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasStpsv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            AP: *const f32,
            x: *mut f32,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasStpsv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            AP: *const f32,
            x: *mut f32,
            incx: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDtpsv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            AP: *const f64,
            x: *mut f64,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDtpsv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            AP: *const f64,
            x: *mut f64,
            incx: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCtpsv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            AP: *const cuComplex,
            x: *mut cuComplex,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCtpsv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            AP: *const cuComplex,
            x: *mut cuComplex,
            incx: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZtpsv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            AP: *const cuDoubleComplex,
            x: *mut cuDoubleComplex,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZtpsv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            AP: *const cuDoubleComplex,
            x: *mut cuDoubleComplex,
            incx: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasStbsv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            A: *const f32,
            lda: ::core::ffi::c_int,
            x: *mut f32,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasStbsv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            k: i64,
            A: *const f32,
            lda: i64,
            x: *mut f32,
            incx: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDtbsv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            A: *const f64,
            lda: ::core::ffi::c_int,
            x: *mut f64,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDtbsv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            k: i64,
            A: *const f64,
            lda: i64,
            x: *mut f64,
            incx: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCtbsv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            x: *mut cuComplex,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCtbsv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            k: i64,
            A: *const cuComplex,
            lda: i64,
            x: *mut cuComplex,
            incx: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZtbsv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            x: *mut cuDoubleComplex,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZtbsv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            k: i64,
            A: *const cuDoubleComplex,
            lda: i64,
            x: *mut cuDoubleComplex,
            incx: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSsymv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            A: *const f32,
            lda: ::core::ffi::c_int,
            x: *const f32,
            incx: ::core::ffi::c_int,
            beta: *const f32,
            y: *mut f32,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSsymv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const f32,
            A: *const f32,
            lda: i64,
            x: *const f32,
            incx: i64,
            beta: *const f32,
            y: *mut f32,
            incy: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDsymv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            A: *const f64,
            lda: ::core::ffi::c_int,
            x: *const f64,
            incx: ::core::ffi::c_int,
            beta: *const f64,
            y: *mut f64,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDsymv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const f64,
            A: *const f64,
            lda: i64,
            x: *const f64,
            incx: i64,
            beta: *const f64,
            y: *mut f64,
            incy: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCsymv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            beta: *const cuComplex,
            y: *mut cuComplex,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCsymv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: i64,
            x: *const cuComplex,
            incx: i64,
            beta: *const cuComplex,
            y: *mut cuComplex,
            incy: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZsymv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            beta: *const cuDoubleComplex,
            y: *mut cuDoubleComplex,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZsymv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: i64,
            x: *const cuDoubleComplex,
            incx: i64,
            beta: *const cuDoubleComplex,
            y: *mut cuDoubleComplex,
            incy: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasChemv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            beta: *const cuComplex,
            y: *mut cuComplex,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasChemv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: i64,
            x: *const cuComplex,
            incx: i64,
            beta: *const cuComplex,
            y: *mut cuComplex,
            incy: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZhemv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            beta: *const cuDoubleComplex,
            y: *mut cuDoubleComplex,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZhemv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: i64,
            x: *const cuDoubleComplex,
            incx: i64,
            beta: *const cuDoubleComplex,
            y: *mut cuDoubleComplex,
            incy: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSsbmv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f32,
            A: *const f32,
            lda: ::core::ffi::c_int,
            x: *const f32,
            incx: ::core::ffi::c_int,
            beta: *const f32,
            y: *mut f32,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSsbmv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            k: i64,
            alpha: *const f32,
            A: *const f32,
            lda: i64,
            x: *const f32,
            incx: i64,
            beta: *const f32,
            y: *mut f32,
            incy: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDsbmv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f64,
            A: *const f64,
            lda: ::core::ffi::c_int,
            x: *const f64,
            incx: ::core::ffi::c_int,
            beta: *const f64,
            y: *mut f64,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDsbmv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            k: i64,
            alpha: *const f64,
            A: *const f64,
            lda: i64,
            x: *const f64,
            incx: i64,
            beta: *const f64,
            y: *mut f64,
            incy: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasChbmv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            beta: *const cuComplex,
            y: *mut cuComplex,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasChbmv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            k: i64,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: i64,
            x: *const cuComplex,
            incx: i64,
            beta: *const cuComplex,
            y: *mut cuComplex,
            incy: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZhbmv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            beta: *const cuDoubleComplex,
            y: *mut cuDoubleComplex,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZhbmv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            k: i64,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: i64,
            x: *const cuDoubleComplex,
            incx: i64,
            beta: *const cuDoubleComplex,
            y: *mut cuDoubleComplex,
            incy: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSspmv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            AP: *const f32,
            x: *const f32,
            incx: ::core::ffi::c_int,
            beta: *const f32,
            y: *mut f32,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSspmv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const f32,
            AP: *const f32,
            x: *const f32,
            incx: i64,
            beta: *const f32,
            y: *mut f32,
            incy: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDspmv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            AP: *const f64,
            x: *const f64,
            incx: ::core::ffi::c_int,
            beta: *const f64,
            y: *mut f64,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDspmv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const f64,
            AP: *const f64,
            x: *const f64,
            incx: i64,
            beta: *const f64,
            y: *mut f64,
            incy: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasChpmv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            AP: *const cuComplex,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            beta: *const cuComplex,
            y: *mut cuComplex,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasChpmv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const cuComplex,
            AP: *const cuComplex,
            x: *const cuComplex,
            incx: i64,
            beta: *const cuComplex,
            y: *mut cuComplex,
            incy: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZhpmv_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            AP: *const cuDoubleComplex,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            beta: *const cuDoubleComplex,
            y: *mut cuDoubleComplex,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZhpmv_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const cuDoubleComplex,
            AP: *const cuDoubleComplex,
            x: *const cuDoubleComplex,
            incx: i64,
            beta: *const cuDoubleComplex,
            y: *mut cuDoubleComplex,
            incy: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSger_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            x: *const f32,
            incx: ::core::ffi::c_int,
            y: *const f32,
            incy: ::core::ffi::c_int,
            A: *mut f32,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSger_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            m: i64,
            n: i64,
            alpha: *const f32,
            x: *const f32,
            incx: i64,
            y: *const f32,
            incy: i64,
            A: *mut f32,
            lda: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDger_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            x: *const f64,
            incx: ::core::ffi::c_int,
            y: *const f64,
            incy: ::core::ffi::c_int,
            A: *mut f64,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDger_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            m: i64,
            n: i64,
            alpha: *const f64,
            x: *const f64,
            incx: i64,
            y: *const f64,
            incy: i64,
            A: *mut f64,
            lda: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCgeru_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            y: *const cuComplex,
            incy: ::core::ffi::c_int,
            A: *mut cuComplex,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCgeru_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            m: i64,
            n: i64,
            alpha: *const cuComplex,
            x: *const cuComplex,
            incx: i64,
            y: *const cuComplex,
            incy: i64,
            A: *mut cuComplex,
            lda: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCgerc_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            y: *const cuComplex,
            incy: ::core::ffi::c_int,
            A: *mut cuComplex,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCgerc_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            m: i64,
            n: i64,
            alpha: *const cuComplex,
            x: *const cuComplex,
            incx: i64,
            y: *const cuComplex,
            incy: i64,
            A: *mut cuComplex,
            lda: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZgeru_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            y: *const cuDoubleComplex,
            incy: ::core::ffi::c_int,
            A: *mut cuDoubleComplex,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZgeru_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            m: i64,
            n: i64,
            alpha: *const cuDoubleComplex,
            x: *const cuDoubleComplex,
            incx: i64,
            y: *const cuDoubleComplex,
            incy: i64,
            A: *mut cuDoubleComplex,
            lda: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZgerc_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            y: *const cuDoubleComplex,
            incy: ::core::ffi::c_int,
            A: *mut cuDoubleComplex,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZgerc_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            m: i64,
            n: i64,
            alpha: *const cuDoubleComplex,
            x: *const cuDoubleComplex,
            incx: i64,
            y: *const cuDoubleComplex,
            incy: i64,
            A: *mut cuDoubleComplex,
            lda: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSsyr_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            x: *const f32,
            incx: ::core::ffi::c_int,
            A: *mut f32,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSsyr_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const f32,
            x: *const f32,
            incx: i64,
            A: *mut f32,
            lda: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDsyr_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            x: *const f64,
            incx: ::core::ffi::c_int,
            A: *mut f64,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDsyr_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const f64,
            x: *const f64,
            incx: i64,
            A: *mut f64,
            lda: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCsyr_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            A: *mut cuComplex,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCsyr_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const cuComplex,
            x: *const cuComplex,
            incx: i64,
            A: *mut cuComplex,
            lda: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZsyr_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            A: *mut cuDoubleComplex,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZsyr_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const cuDoubleComplex,
            x: *const cuDoubleComplex,
            incx: i64,
            A: *mut cuDoubleComplex,
            lda: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCher_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            A: *mut cuComplex,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCher_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const f32,
            x: *const cuComplex,
            incx: i64,
            A: *mut cuComplex,
            lda: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZher_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            A: *mut cuDoubleComplex,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZher_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const f64,
            x: *const cuDoubleComplex,
            incx: i64,
            A: *mut cuDoubleComplex,
            lda: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSspr_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            x: *const f32,
            incx: ::core::ffi::c_int,
            AP: *mut f32,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSspr_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const f32,
            x: *const f32,
            incx: i64,
            AP: *mut f32,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDspr_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            x: *const f64,
            incx: ::core::ffi::c_int,
            AP: *mut f64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDspr_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const f64,
            x: *const f64,
            incx: i64,
            AP: *mut f64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasChpr_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            AP: *mut cuComplex,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasChpr_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const f32,
            x: *const cuComplex,
            incx: i64,
            AP: *mut cuComplex,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZhpr_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            AP: *mut cuDoubleComplex,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZhpr_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const f64,
            x: *const cuDoubleComplex,
            incx: i64,
            AP: *mut cuDoubleComplex,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSsyr2_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            x: *const f32,
            incx: ::core::ffi::c_int,
            y: *const f32,
            incy: ::core::ffi::c_int,
            A: *mut f32,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSsyr2_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const f32,
            x: *const f32,
            incx: i64,
            y: *const f32,
            incy: i64,
            A: *mut f32,
            lda: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDsyr2_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            x: *const f64,
            incx: ::core::ffi::c_int,
            y: *const f64,
            incy: ::core::ffi::c_int,
            A: *mut f64,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDsyr2_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const f64,
            x: *const f64,
            incx: i64,
            y: *const f64,
            incy: i64,
            A: *mut f64,
            lda: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCsyr2_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            y: *const cuComplex,
            incy: ::core::ffi::c_int,
            A: *mut cuComplex,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCsyr2_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const cuComplex,
            x: *const cuComplex,
            incx: i64,
            y: *const cuComplex,
            incy: i64,
            A: *mut cuComplex,
            lda: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZsyr2_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            y: *const cuDoubleComplex,
            incy: ::core::ffi::c_int,
            A: *mut cuDoubleComplex,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZsyr2_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const cuDoubleComplex,
            x: *const cuDoubleComplex,
            incx: i64,
            y: *const cuDoubleComplex,
            incy: i64,
            A: *mut cuDoubleComplex,
            lda: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCher2_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            y: *const cuComplex,
            incy: ::core::ffi::c_int,
            A: *mut cuComplex,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCher2_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const cuComplex,
            x: *const cuComplex,
            incx: i64,
            y: *const cuComplex,
            incy: i64,
            A: *mut cuComplex,
            lda: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZher2_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            y: *const cuDoubleComplex,
            incy: ::core::ffi::c_int,
            A: *mut cuDoubleComplex,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZher2_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const cuDoubleComplex,
            x: *const cuDoubleComplex,
            incx: i64,
            y: *const cuDoubleComplex,
            incy: i64,
            A: *mut cuDoubleComplex,
            lda: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSspr2_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            x: *const f32,
            incx: ::core::ffi::c_int,
            y: *const f32,
            incy: ::core::ffi::c_int,
            AP: *mut f32,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSspr2_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const f32,
            x: *const f32,
            incx: i64,
            y: *const f32,
            incy: i64,
            AP: *mut f32,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDspr2_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            x: *const f64,
            incx: ::core::ffi::c_int,
            y: *const f64,
            incy: ::core::ffi::c_int,
            AP: *mut f64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDspr2_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const f64,
            x: *const f64,
            incx: i64,
            y: *const f64,
            incy: i64,
            AP: *mut f64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasChpr2_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            y: *const cuComplex,
            incy: ::core::ffi::c_int,
            AP: *mut cuComplex,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasChpr2_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const cuComplex,
            x: *const cuComplex,
            incx: i64,
            y: *const cuComplex,
            incy: i64,
            AP: *mut cuComplex,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZhpr2_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            y: *const cuDoubleComplex,
            incy: ::core::ffi::c_int,
            AP: *mut cuDoubleComplex,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZhpr2_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const cuDoubleComplex,
            x: *const cuDoubleComplex,
            incx: i64,
            y: *const cuDoubleComplex,
            incy: i64,
            AP: *mut cuDoubleComplex,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSgemvBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            Aarray: *const *const f32,
            lda: ::core::ffi::c_int,
            xarray: *const *const f32,
            incx: ::core::ffi::c_int,
            beta: *const f32,
            yarray: *const *mut f32,
            incy: ::core::ffi::c_int,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSgemvBatched_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: i64,
            n: i64,
            alpha: *const f32,
            Aarray: *const *const f32,
            lda: i64,
            xarray: *const *const f32,
            incx: i64,
            beta: *const f32,
            yarray: *const *mut f32,
            incy: i64,
            batchCount: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDgemvBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            Aarray: *const *const f64,
            lda: ::core::ffi::c_int,
            xarray: *const *const f64,
            incx: ::core::ffi::c_int,
            beta: *const f64,
            yarray: *const *mut f64,
            incy: ::core::ffi::c_int,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDgemvBatched_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: i64,
            n: i64,
            alpha: *const f64,
            Aarray: *const *const f64,
            lda: i64,
            xarray: *const *const f64,
            incx: i64,
            beta: *const f64,
            yarray: *const *mut f64,
            incy: i64,
            batchCount: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCgemvBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            Aarray: *const *const cuComplex,
            lda: ::core::ffi::c_int,
            xarray: *const *const cuComplex,
            incx: ::core::ffi::c_int,
            beta: *const cuComplex,
            yarray: *const *mut cuComplex,
            incy: ::core::ffi::c_int,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCgemvBatched_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: i64,
            n: i64,
            alpha: *const cuComplex,
            Aarray: *const *const cuComplex,
            lda: i64,
            xarray: *const *const cuComplex,
            incx: i64,
            beta: *const cuComplex,
            yarray: *const *mut cuComplex,
            incy: i64,
            batchCount: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZgemvBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            Aarray: *const *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            xarray: *const *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            beta: *const cuDoubleComplex,
            yarray: *const *mut cuDoubleComplex,
            incy: ::core::ffi::c_int,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZgemvBatched_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: i64,
            n: i64,
            alpha: *const cuDoubleComplex,
            Aarray: *const *const cuDoubleComplex,
            lda: i64,
            xarray: *const *const cuDoubleComplex,
            incx: i64,
            beta: *const cuDoubleComplex,
            yarray: *const *mut cuDoubleComplex,
            incy: i64,
            batchCount: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSgemvStridedBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            A: *const f32,
            lda: ::core::ffi::c_int,
            strideA: ::core::ffi::c_longlong,
            x: *const f32,
            incx: ::core::ffi::c_int,
            stridex: ::core::ffi::c_longlong,
            beta: *const f32,
            y: *mut f32,
            incy: ::core::ffi::c_int,
            stridey: ::core::ffi::c_longlong,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSgemvStridedBatched_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: i64,
            n: i64,
            alpha: *const f32,
            A: *const f32,
            lda: i64,
            strideA: ::core::ffi::c_longlong,
            x: *const f32,
            incx: i64,
            stridex: ::core::ffi::c_longlong,
            beta: *const f32,
            y: *mut f32,
            incy: i64,
            stridey: ::core::ffi::c_longlong,
            batchCount: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDgemvStridedBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            A: *const f64,
            lda: ::core::ffi::c_int,
            strideA: ::core::ffi::c_longlong,
            x: *const f64,
            incx: ::core::ffi::c_int,
            stridex: ::core::ffi::c_longlong,
            beta: *const f64,
            y: *mut f64,
            incy: ::core::ffi::c_int,
            stridey: ::core::ffi::c_longlong,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDgemvStridedBatched_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: i64,
            n: i64,
            alpha: *const f64,
            A: *const f64,
            lda: i64,
            strideA: ::core::ffi::c_longlong,
            x: *const f64,
            incx: i64,
            stridex: ::core::ffi::c_longlong,
            beta: *const f64,
            y: *mut f64,
            incy: i64,
            stridey: ::core::ffi::c_longlong,
            batchCount: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCgemvStridedBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            strideA: ::core::ffi::c_longlong,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            stridex: ::core::ffi::c_longlong,
            beta: *const cuComplex,
            y: *mut cuComplex,
            incy: ::core::ffi::c_int,
            stridey: ::core::ffi::c_longlong,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCgemvStridedBatched_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: i64,
            n: i64,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: i64,
            strideA: ::core::ffi::c_longlong,
            x: *const cuComplex,
            incx: i64,
            stridex: ::core::ffi::c_longlong,
            beta: *const cuComplex,
            y: *mut cuComplex,
            incy: i64,
            stridey: ::core::ffi::c_longlong,
            batchCount: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZgemvStridedBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            strideA: ::core::ffi::c_longlong,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            stridex: ::core::ffi::c_longlong,
            beta: *const cuDoubleComplex,
            y: *mut cuDoubleComplex,
            incy: ::core::ffi::c_int,
            stridey: ::core::ffi::c_longlong,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZgemvStridedBatched_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: i64,
            n: i64,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: i64,
            strideA: ::core::ffi::c_longlong,
            x: *const cuDoubleComplex,
            incx: i64,
            stridex: ::core::ffi::c_longlong,
            beta: *const cuDoubleComplex,
            y: *mut cuDoubleComplex,
            incy: i64,
            stridey: ::core::ffi::c_longlong,
            batchCount: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSgemm_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f32,
            A: *const f32,
            lda: ::core::ffi::c_int,
            B: *const f32,
            ldb: ::core::ffi::c_int,
            beta: *const f32,
            C: *mut f32,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSgemm_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const f32,
            A: *const f32,
            lda: i64,
            B: *const f32,
            ldb: i64,
            beta: *const f32,
            C: *mut f32,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDgemm_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f64,
            A: *const f64,
            lda: ::core::ffi::c_int,
            B: *const f64,
            ldb: ::core::ffi::c_int,
            beta: *const f64,
            C: *mut f64,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDgemm_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const f64,
            A: *const f64,
            lda: i64,
            B: *const f64,
            ldb: i64,
            beta: *const f64,
            C: *mut f64,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCgemm_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            B: *const cuComplex,
            ldb: ::core::ffi::c_int,
            beta: *const cuComplex,
            C: *mut cuComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCgemm_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: i64,
            B: *const cuComplex,
            ldb: i64,
            beta: *const cuComplex,
            C: *mut cuComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCgemm3m: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            B: *const cuComplex,
            ldb: ::core::ffi::c_int,
            beta: *const cuComplex,
            C: *mut cuComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCgemm3m_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: i64,
            B: *const cuComplex,
            ldb: i64,
            beta: *const cuComplex,
            C: *mut cuComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCgemm3mEx: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const ::core::ffi::c_void,
            Atype: cudaDataType,
            lda: ::core::ffi::c_int,
            B: *const ::core::ffi::c_void,
            Btype: cudaDataType,
            ldb: ::core::ffi::c_int,
            beta: *const cuComplex,
            C: *mut ::core::ffi::c_void,
            Ctype: cudaDataType,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCgemm3mEx_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const cuComplex,
            A: *const ::core::ffi::c_void,
            Atype: cudaDataType,
            lda: i64,
            B: *const ::core::ffi::c_void,
            Btype: cudaDataType,
            ldb: i64,
            beta: *const cuComplex,
            C: *mut ::core::ffi::c_void,
            Ctype: cudaDataType,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZgemm_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            B: *const cuDoubleComplex,
            ldb: ::core::ffi::c_int,
            beta: *const cuDoubleComplex,
            C: *mut cuDoubleComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZgemm_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: i64,
            B: *const cuDoubleComplex,
            ldb: i64,
            beta: *const cuDoubleComplex,
            C: *mut cuDoubleComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZgemm3m: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            B: *const cuDoubleComplex,
            ldb: ::core::ffi::c_int,
            beta: *const cuDoubleComplex,
            C: *mut cuDoubleComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZgemm3m_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: i64,
            B: *const cuDoubleComplex,
            ldb: i64,
            beta: *const cuDoubleComplex,
            C: *mut cuDoubleComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSgemmEx: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f32,
            A: *const ::core::ffi::c_void,
            Atype: cudaDataType,
            lda: ::core::ffi::c_int,
            B: *const ::core::ffi::c_void,
            Btype: cudaDataType,
            ldb: ::core::ffi::c_int,
            beta: *const f32,
            C: *mut ::core::ffi::c_void,
            Ctype: cudaDataType,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSgemmEx_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const f32,
            A: *const ::core::ffi::c_void,
            Atype: cudaDataType,
            lda: i64,
            B: *const ::core::ffi::c_void,
            Btype: cudaDataType,
            ldb: i64,
            beta: *const f32,
            C: *mut ::core::ffi::c_void,
            Ctype: cudaDataType,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasGemmEx: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const ::core::ffi::c_void,
            A: *const ::core::ffi::c_void,
            Atype: cudaDataType,
            lda: ::core::ffi::c_int,
            B: *const ::core::ffi::c_void,
            Btype: cudaDataType,
            ldb: ::core::ffi::c_int,
            beta: *const ::core::ffi::c_void,
            C: *mut ::core::ffi::c_void,
            Ctype: cudaDataType,
            ldc: ::core::ffi::c_int,
            computeType: cublasComputeType_t,
            algo: cublasGemmAlgo_t,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasGemmEx_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const ::core::ffi::c_void,
            A: *const ::core::ffi::c_void,
            Atype: cudaDataType,
            lda: i64,
            B: *const ::core::ffi::c_void,
            Btype: cudaDataType,
            ldb: i64,
            beta: *const ::core::ffi::c_void,
            C: *mut ::core::ffi::c_void,
            Ctype: cudaDataType,
            ldc: i64,
            computeType: cublasComputeType_t,
            algo: cublasGemmAlgo_t,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCgemmEx: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const ::core::ffi::c_void,
            Atype: cudaDataType,
            lda: ::core::ffi::c_int,
            B: *const ::core::ffi::c_void,
            Btype: cudaDataType,
            ldb: ::core::ffi::c_int,
            beta: *const cuComplex,
            C: *mut ::core::ffi::c_void,
            Ctype: cudaDataType,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCgemmEx_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const cuComplex,
            A: *const ::core::ffi::c_void,
            Atype: cudaDataType,
            lda: i64,
            B: *const ::core::ffi::c_void,
            Btype: cudaDataType,
            ldb: i64,
            beta: *const cuComplex,
            C: *mut ::core::ffi::c_void,
            Ctype: cudaDataType,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSsyrk_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f32,
            A: *const f32,
            lda: ::core::ffi::c_int,
            beta: *const f32,
            C: *mut f32,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSsyrk_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const f32,
            A: *const f32,
            lda: i64,
            beta: *const f32,
            C: *mut f32,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDsyrk_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f64,
            A: *const f64,
            lda: ::core::ffi::c_int,
            beta: *const f64,
            C: *mut f64,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDsyrk_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const f64,
            A: *const f64,
            lda: i64,
            beta: *const f64,
            C: *mut f64,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCsyrk_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            beta: *const cuComplex,
            C: *mut cuComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCsyrk_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: i64,
            beta: *const cuComplex,
            C: *mut cuComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZsyrk_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            beta: *const cuDoubleComplex,
            C: *mut cuDoubleComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZsyrk_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: i64,
            beta: *const cuDoubleComplex,
            C: *mut cuDoubleComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCsyrkEx: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const ::core::ffi::c_void,
            Atype: cudaDataType,
            lda: ::core::ffi::c_int,
            beta: *const cuComplex,
            C: *mut ::core::ffi::c_void,
            Ctype: cudaDataType,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCsyrkEx_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const cuComplex,
            A: *const ::core::ffi::c_void,
            Atype: cudaDataType,
            lda: i64,
            beta: *const cuComplex,
            C: *mut ::core::ffi::c_void,
            Ctype: cudaDataType,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCsyrk3mEx: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const ::core::ffi::c_void,
            Atype: cudaDataType,
            lda: ::core::ffi::c_int,
            beta: *const cuComplex,
            C: *mut ::core::ffi::c_void,
            Ctype: cudaDataType,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCsyrk3mEx_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const cuComplex,
            A: *const ::core::ffi::c_void,
            Atype: cudaDataType,
            lda: i64,
            beta: *const cuComplex,
            C: *mut ::core::ffi::c_void,
            Ctype: cudaDataType,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCherk_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f32,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            beta: *const f32,
            C: *mut cuComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCherk_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const f32,
            A: *const cuComplex,
            lda: i64,
            beta: *const f32,
            C: *mut cuComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZherk_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f64,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            beta: *const f64,
            C: *mut cuDoubleComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZherk_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const f64,
            A: *const cuDoubleComplex,
            lda: i64,
            beta: *const f64,
            C: *mut cuDoubleComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCherkEx: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f32,
            A: *const ::core::ffi::c_void,
            Atype: cudaDataType,
            lda: ::core::ffi::c_int,
            beta: *const f32,
            C: *mut ::core::ffi::c_void,
            Ctype: cudaDataType,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCherkEx_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const f32,
            A: *const ::core::ffi::c_void,
            Atype: cudaDataType,
            lda: i64,
            beta: *const f32,
            C: *mut ::core::ffi::c_void,
            Ctype: cudaDataType,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCherk3mEx: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f32,
            A: *const ::core::ffi::c_void,
            Atype: cudaDataType,
            lda: ::core::ffi::c_int,
            beta: *const f32,
            C: *mut ::core::ffi::c_void,
            Ctype: cudaDataType,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCherk3mEx_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const f32,
            A: *const ::core::ffi::c_void,
            Atype: cudaDataType,
            lda: i64,
            beta: *const f32,
            C: *mut ::core::ffi::c_void,
            Ctype: cudaDataType,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSsyr2k_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f32,
            A: *const f32,
            lda: ::core::ffi::c_int,
            B: *const f32,
            ldb: ::core::ffi::c_int,
            beta: *const f32,
            C: *mut f32,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSsyr2k_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const f32,
            A: *const f32,
            lda: i64,
            B: *const f32,
            ldb: i64,
            beta: *const f32,
            C: *mut f32,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDsyr2k_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f64,
            A: *const f64,
            lda: ::core::ffi::c_int,
            B: *const f64,
            ldb: ::core::ffi::c_int,
            beta: *const f64,
            C: *mut f64,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDsyr2k_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const f64,
            A: *const f64,
            lda: i64,
            B: *const f64,
            ldb: i64,
            beta: *const f64,
            C: *mut f64,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCsyr2k_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            B: *const cuComplex,
            ldb: ::core::ffi::c_int,
            beta: *const cuComplex,
            C: *mut cuComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCsyr2k_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: i64,
            B: *const cuComplex,
            ldb: i64,
            beta: *const cuComplex,
            C: *mut cuComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZsyr2k_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            B: *const cuDoubleComplex,
            ldb: ::core::ffi::c_int,
            beta: *const cuDoubleComplex,
            C: *mut cuDoubleComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZsyr2k_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: i64,
            B: *const cuDoubleComplex,
            ldb: i64,
            beta: *const cuDoubleComplex,
            C: *mut cuDoubleComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCher2k_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            B: *const cuComplex,
            ldb: ::core::ffi::c_int,
            beta: *const f32,
            C: *mut cuComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCher2k_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: i64,
            B: *const cuComplex,
            ldb: i64,
            beta: *const f32,
            C: *mut cuComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZher2k_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            B: *const cuDoubleComplex,
            ldb: ::core::ffi::c_int,
            beta: *const f64,
            C: *mut cuDoubleComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZher2k_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: i64,
            B: *const cuDoubleComplex,
            ldb: i64,
            beta: *const f64,
            C: *mut cuDoubleComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSsyrkx: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f32,
            A: *const f32,
            lda: ::core::ffi::c_int,
            B: *const f32,
            ldb: ::core::ffi::c_int,
            beta: *const f32,
            C: *mut f32,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSsyrkx_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const f32,
            A: *const f32,
            lda: i64,
            B: *const f32,
            ldb: i64,
            beta: *const f32,
            C: *mut f32,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDsyrkx: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f64,
            A: *const f64,
            lda: ::core::ffi::c_int,
            B: *const f64,
            ldb: ::core::ffi::c_int,
            beta: *const f64,
            C: *mut f64,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDsyrkx_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const f64,
            A: *const f64,
            lda: i64,
            B: *const f64,
            ldb: i64,
            beta: *const f64,
            C: *mut f64,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCsyrkx: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            B: *const cuComplex,
            ldb: ::core::ffi::c_int,
            beta: *const cuComplex,
            C: *mut cuComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCsyrkx_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: i64,
            B: *const cuComplex,
            ldb: i64,
            beta: *const cuComplex,
            C: *mut cuComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZsyrkx: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            B: *const cuDoubleComplex,
            ldb: ::core::ffi::c_int,
            beta: *const cuDoubleComplex,
            C: *mut cuDoubleComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZsyrkx_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: i64,
            B: *const cuDoubleComplex,
            ldb: i64,
            beta: *const cuDoubleComplex,
            C: *mut cuDoubleComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCherkx: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            B: *const cuComplex,
            ldb: ::core::ffi::c_int,
            beta: *const f32,
            C: *mut cuComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCherkx_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: i64,
            B: *const cuComplex,
            ldb: i64,
            beta: *const f32,
            C: *mut cuComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZherkx: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            B: *const cuDoubleComplex,
            ldb: ::core::ffi::c_int,
            beta: *const f64,
            C: *mut cuDoubleComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZherkx_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: i64,
            B: *const cuDoubleComplex,
            ldb: i64,
            beta: *const f64,
            C: *mut cuDoubleComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSsymm_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            A: *const f32,
            lda: ::core::ffi::c_int,
            B: *const f32,
            ldb: ::core::ffi::c_int,
            beta: *const f32,
            C: *mut f32,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSsymm_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            m: i64,
            n: i64,
            alpha: *const f32,
            A: *const f32,
            lda: i64,
            B: *const f32,
            ldb: i64,
            beta: *const f32,
            C: *mut f32,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDsymm_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            A: *const f64,
            lda: ::core::ffi::c_int,
            B: *const f64,
            ldb: ::core::ffi::c_int,
            beta: *const f64,
            C: *mut f64,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDsymm_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            m: i64,
            n: i64,
            alpha: *const f64,
            A: *const f64,
            lda: i64,
            B: *const f64,
            ldb: i64,
            beta: *const f64,
            C: *mut f64,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCsymm_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            B: *const cuComplex,
            ldb: ::core::ffi::c_int,
            beta: *const cuComplex,
            C: *mut cuComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCsymm_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            m: i64,
            n: i64,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: i64,
            B: *const cuComplex,
            ldb: i64,
            beta: *const cuComplex,
            C: *mut cuComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZsymm_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            B: *const cuDoubleComplex,
            ldb: ::core::ffi::c_int,
            beta: *const cuDoubleComplex,
            C: *mut cuDoubleComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZsymm_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            m: i64,
            n: i64,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: i64,
            B: *const cuDoubleComplex,
            ldb: i64,
            beta: *const cuDoubleComplex,
            C: *mut cuDoubleComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasChemm_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            B: *const cuComplex,
            ldb: ::core::ffi::c_int,
            beta: *const cuComplex,
            C: *mut cuComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasChemm_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            m: i64,
            n: i64,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: i64,
            B: *const cuComplex,
            ldb: i64,
            beta: *const cuComplex,
            C: *mut cuComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZhemm_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            B: *const cuDoubleComplex,
            ldb: ::core::ffi::c_int,
            beta: *const cuDoubleComplex,
            C: *mut cuDoubleComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZhemm_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            m: i64,
            n: i64,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: i64,
            B: *const cuDoubleComplex,
            ldb: i64,
            beta: *const cuDoubleComplex,
            C: *mut cuDoubleComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasStrsm_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            A: *const f32,
            lda: ::core::ffi::c_int,
            B: *mut f32,
            ldb: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasStrsm_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: i64,
            n: i64,
            alpha: *const f32,
            A: *const f32,
            lda: i64,
            B: *mut f32,
            ldb: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDtrsm_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            A: *const f64,
            lda: ::core::ffi::c_int,
            B: *mut f64,
            ldb: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDtrsm_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: i64,
            n: i64,
            alpha: *const f64,
            A: *const f64,
            lda: i64,
            B: *mut f64,
            ldb: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCtrsm_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            B: *mut cuComplex,
            ldb: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCtrsm_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: i64,
            n: i64,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: i64,
            B: *mut cuComplex,
            ldb: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZtrsm_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            B: *mut cuDoubleComplex,
            ldb: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZtrsm_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: i64,
            n: i64,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: i64,
            B: *mut cuDoubleComplex,
            ldb: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasStrmm_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            A: *const f32,
            lda: ::core::ffi::c_int,
            B: *const f32,
            ldb: ::core::ffi::c_int,
            C: *mut f32,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasStrmm_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: i64,
            n: i64,
            alpha: *const f32,
            A: *const f32,
            lda: i64,
            B: *const f32,
            ldb: i64,
            C: *mut f32,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDtrmm_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            A: *const f64,
            lda: ::core::ffi::c_int,
            B: *const f64,
            ldb: ::core::ffi::c_int,
            C: *mut f64,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDtrmm_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: i64,
            n: i64,
            alpha: *const f64,
            A: *const f64,
            lda: i64,
            B: *const f64,
            ldb: i64,
            C: *mut f64,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCtrmm_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            B: *const cuComplex,
            ldb: ::core::ffi::c_int,
            C: *mut cuComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCtrmm_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: i64,
            n: i64,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: i64,
            B: *const cuComplex,
            ldb: i64,
            C: *mut cuComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZtrmm_v2: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            B: *const cuDoubleComplex,
            ldb: ::core::ffi::c_int,
            C: *mut cuDoubleComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZtrmm_v2_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: i64,
            n: i64,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: i64,
            B: *const cuDoubleComplex,
            ldb: i64,
            C: *mut cuDoubleComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSgemmBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f32,
            Aarray: *const *const f32,
            lda: ::core::ffi::c_int,
            Barray: *const *const f32,
            ldb: ::core::ffi::c_int,
            beta: *const f32,
            Carray: *const *mut f32,
            ldc: ::core::ffi::c_int,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSgemmBatched_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const f32,
            Aarray: *const *const f32,
            lda: i64,
            Barray: *const *const f32,
            ldb: i64,
            beta: *const f32,
            Carray: *const *mut f32,
            ldc: i64,
            batchCount: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDgemmBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f64,
            Aarray: *const *const f64,
            lda: ::core::ffi::c_int,
            Barray: *const *const f64,
            ldb: ::core::ffi::c_int,
            beta: *const f64,
            Carray: *const *mut f64,
            ldc: ::core::ffi::c_int,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDgemmBatched_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const f64,
            Aarray: *const *const f64,
            lda: i64,
            Barray: *const *const f64,
            ldb: i64,
            beta: *const f64,
            Carray: *const *mut f64,
            ldc: i64,
            batchCount: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCgemmBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuComplex,
            Aarray: *const *const cuComplex,
            lda: ::core::ffi::c_int,
            Barray: *const *const cuComplex,
            ldb: ::core::ffi::c_int,
            beta: *const cuComplex,
            Carray: *const *mut cuComplex,
            ldc: ::core::ffi::c_int,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCgemmBatched_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const cuComplex,
            Aarray: *const *const cuComplex,
            lda: i64,
            Barray: *const *const cuComplex,
            ldb: i64,
            beta: *const cuComplex,
            Carray: *const *mut cuComplex,
            ldc: i64,
            batchCount: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCgemm3mBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuComplex,
            Aarray: *const *const cuComplex,
            lda: ::core::ffi::c_int,
            Barray: *const *const cuComplex,
            ldb: ::core::ffi::c_int,
            beta: *const cuComplex,
            Carray: *const *mut cuComplex,
            ldc: ::core::ffi::c_int,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCgemm3mBatched_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const cuComplex,
            Aarray: *const *const cuComplex,
            lda: i64,
            Barray: *const *const cuComplex,
            ldb: i64,
            beta: *const cuComplex,
            Carray: *const *mut cuComplex,
            ldc: i64,
            batchCount: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZgemmBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            Aarray: *const *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            Barray: *const *const cuDoubleComplex,
            ldb: ::core::ffi::c_int,
            beta: *const cuDoubleComplex,
            Carray: *const *mut cuDoubleComplex,
            ldc: ::core::ffi::c_int,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZgemmBatched_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const cuDoubleComplex,
            Aarray: *const *const cuDoubleComplex,
            lda: i64,
            Barray: *const *const cuDoubleComplex,
            ldb: i64,
            beta: *const cuDoubleComplex,
            Carray: *const *mut cuDoubleComplex,
            ldc: i64,
            batchCount: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSgemmStridedBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f32,
            A: *const f32,
            lda: ::core::ffi::c_int,
            strideA: ::core::ffi::c_longlong,
            B: *const f32,
            ldb: ::core::ffi::c_int,
            strideB: ::core::ffi::c_longlong,
            beta: *const f32,
            C: *mut f32,
            ldc: ::core::ffi::c_int,
            strideC: ::core::ffi::c_longlong,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSgemmStridedBatched_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const f32,
            A: *const f32,
            lda: i64,
            strideA: ::core::ffi::c_longlong,
            B: *const f32,
            ldb: i64,
            strideB: ::core::ffi::c_longlong,
            beta: *const f32,
            C: *mut f32,
            ldc: i64,
            strideC: ::core::ffi::c_longlong,
            batchCount: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDgemmStridedBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f64,
            A: *const f64,
            lda: ::core::ffi::c_int,
            strideA: ::core::ffi::c_longlong,
            B: *const f64,
            ldb: ::core::ffi::c_int,
            strideB: ::core::ffi::c_longlong,
            beta: *const f64,
            C: *mut f64,
            ldc: ::core::ffi::c_int,
            strideC: ::core::ffi::c_longlong,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDgemmStridedBatched_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const f64,
            A: *const f64,
            lda: i64,
            strideA: ::core::ffi::c_longlong,
            B: *const f64,
            ldb: i64,
            strideB: ::core::ffi::c_longlong,
            beta: *const f64,
            C: *mut f64,
            ldc: i64,
            strideC: ::core::ffi::c_longlong,
            batchCount: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCgemmStridedBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            strideA: ::core::ffi::c_longlong,
            B: *const cuComplex,
            ldb: ::core::ffi::c_int,
            strideB: ::core::ffi::c_longlong,
            beta: *const cuComplex,
            C: *mut cuComplex,
            ldc: ::core::ffi::c_int,
            strideC: ::core::ffi::c_longlong,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCgemmStridedBatched_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: i64,
            strideA: ::core::ffi::c_longlong,
            B: *const cuComplex,
            ldb: i64,
            strideB: ::core::ffi::c_longlong,
            beta: *const cuComplex,
            C: *mut cuComplex,
            ldc: i64,
            strideC: ::core::ffi::c_longlong,
            batchCount: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCgemm3mStridedBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            strideA: ::core::ffi::c_longlong,
            B: *const cuComplex,
            ldb: ::core::ffi::c_int,
            strideB: ::core::ffi::c_longlong,
            beta: *const cuComplex,
            C: *mut cuComplex,
            ldc: ::core::ffi::c_int,
            strideC: ::core::ffi::c_longlong,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCgemm3mStridedBatched_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: i64,
            strideA: ::core::ffi::c_longlong,
            B: *const cuComplex,
            ldb: i64,
            strideB: ::core::ffi::c_longlong,
            beta: *const cuComplex,
            C: *mut cuComplex,
            ldc: i64,
            strideC: ::core::ffi::c_longlong,
            batchCount: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZgemmStridedBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            strideA: ::core::ffi::c_longlong,
            B: *const cuDoubleComplex,
            ldb: ::core::ffi::c_int,
            strideB: ::core::ffi::c_longlong,
            beta: *const cuDoubleComplex,
            C: *mut cuDoubleComplex,
            ldc: ::core::ffi::c_int,
            strideC: ::core::ffi::c_longlong,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZgemmStridedBatched_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: i64,
            strideA: ::core::ffi::c_longlong,
            B: *const cuDoubleComplex,
            ldb: i64,
            strideB: ::core::ffi::c_longlong,
            beta: *const cuDoubleComplex,
            C: *mut cuDoubleComplex,
            ldc: i64,
            strideC: ::core::ffi::c_longlong,
            batchCount: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasGemmBatchedEx: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const ::core::ffi::c_void,
            Aarray: *const *const ::core::ffi::c_void,
            Atype: cudaDataType,
            lda: ::core::ffi::c_int,
            Barray: *const *const ::core::ffi::c_void,
            Btype: cudaDataType,
            ldb: ::core::ffi::c_int,
            beta: *const ::core::ffi::c_void,
            Carray: *const *mut ::core::ffi::c_void,
            Ctype: cudaDataType,
            ldc: ::core::ffi::c_int,
            batchCount: ::core::ffi::c_int,
            computeType: cublasComputeType_t,
            algo: cublasGemmAlgo_t,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasGemmBatchedEx_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const ::core::ffi::c_void,
            Aarray: *const *const ::core::ffi::c_void,
            Atype: cudaDataType,
            lda: i64,
            Barray: *const *const ::core::ffi::c_void,
            Btype: cudaDataType,
            ldb: i64,
            beta: *const ::core::ffi::c_void,
            Carray: *const *mut ::core::ffi::c_void,
            Ctype: cudaDataType,
            ldc: i64,
            batchCount: i64,
            computeType: cublasComputeType_t,
            algo: cublasGemmAlgo_t,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasGemmStridedBatchedEx: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const ::core::ffi::c_void,
            A: *const ::core::ffi::c_void,
            Atype: cudaDataType,
            lda: ::core::ffi::c_int,
            strideA: ::core::ffi::c_longlong,
            B: *const ::core::ffi::c_void,
            Btype: cudaDataType,
            ldb: ::core::ffi::c_int,
            strideB: ::core::ffi::c_longlong,
            beta: *const ::core::ffi::c_void,
            C: *mut ::core::ffi::c_void,
            Ctype: cudaDataType,
            ldc: ::core::ffi::c_int,
            strideC: ::core::ffi::c_longlong,
            batchCount: ::core::ffi::c_int,
            computeType: cublasComputeType_t,
            algo: cublasGemmAlgo_t,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasGemmStridedBatchedEx_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const ::core::ffi::c_void,
            A: *const ::core::ffi::c_void,
            Atype: cudaDataType,
            lda: i64,
            strideA: ::core::ffi::c_longlong,
            B: *const ::core::ffi::c_void,
            Btype: cudaDataType,
            ldb: i64,
            strideB: ::core::ffi::c_longlong,
            beta: *const ::core::ffi::c_void,
            C: *mut ::core::ffi::c_void,
            Ctype: cudaDataType,
            ldc: i64,
            strideC: ::core::ffi::c_longlong,
            batchCount: i64,
            computeType: cublasComputeType_t,
            algo: cublasGemmAlgo_t,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSgeam: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            A: *const f32,
            lda: ::core::ffi::c_int,
            beta: *const f32,
            B: *const f32,
            ldb: ::core::ffi::c_int,
            C: *mut f32,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSgeam_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            alpha: *const f32,
            A: *const f32,
            lda: i64,
            beta: *const f32,
            B: *const f32,
            ldb: i64,
            C: *mut f32,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDgeam: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            A: *const f64,
            lda: ::core::ffi::c_int,
            beta: *const f64,
            B: *const f64,
            ldb: ::core::ffi::c_int,
            C: *mut f64,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDgeam_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            alpha: *const f64,
            A: *const f64,
            lda: i64,
            beta: *const f64,
            B: *const f64,
            ldb: i64,
            C: *mut f64,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCgeam: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            beta: *const cuComplex,
            B: *const cuComplex,
            ldb: ::core::ffi::c_int,
            C: *mut cuComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCgeam_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: i64,
            beta: *const cuComplex,
            B: *const cuComplex,
            ldb: i64,
            C: *mut cuComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZgeam: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            beta: *const cuDoubleComplex,
            B: *const cuDoubleComplex,
            ldb: ::core::ffi::c_int,
            C: *mut cuDoubleComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZgeam_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: i64,
            beta: *const cuDoubleComplex,
            B: *const cuDoubleComplex,
            ldb: i64,
            C: *mut cuDoubleComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasStrsmBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            A: *const *const f32,
            lda: ::core::ffi::c_int,
            B: *const *mut f32,
            ldb: ::core::ffi::c_int,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasStrsmBatched_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: i64,
            n: i64,
            alpha: *const f32,
            A: *const *const f32,
            lda: i64,
            B: *const *mut f32,
            ldb: i64,
            batchCount: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDtrsmBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            A: *const *const f64,
            lda: ::core::ffi::c_int,
            B: *const *mut f64,
            ldb: ::core::ffi::c_int,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDtrsmBatched_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: i64,
            n: i64,
            alpha: *const f64,
            A: *const *const f64,
            lda: i64,
            B: *const *mut f64,
            ldb: i64,
            batchCount: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCtrsmBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const *const cuComplex,
            lda: ::core::ffi::c_int,
            B: *const *mut cuComplex,
            ldb: ::core::ffi::c_int,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCtrsmBatched_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: i64,
            n: i64,
            alpha: *const cuComplex,
            A: *const *const cuComplex,
            lda: i64,
            B: *const *mut cuComplex,
            ldb: i64,
            batchCount: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZtrsmBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            A: *const *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            B: *const *mut cuDoubleComplex,
            ldb: ::core::ffi::c_int,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZtrsmBatched_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: i64,
            n: i64,
            alpha: *const cuDoubleComplex,
            A: *const *const cuDoubleComplex,
            lda: i64,
            B: *const *mut cuDoubleComplex,
            ldb: i64,
            batchCount: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSdgmm: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            mode: cublasSideMode_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            A: *const f32,
            lda: ::core::ffi::c_int,
            x: *const f32,
            incx: ::core::ffi::c_int,
            C: *mut f32,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSdgmm_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            mode: cublasSideMode_t,
            m: i64,
            n: i64,
            A: *const f32,
            lda: i64,
            x: *const f32,
            incx: i64,
            C: *mut f32,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDdgmm: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            mode: cublasSideMode_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            A: *const f64,
            lda: ::core::ffi::c_int,
            x: *const f64,
            incx: ::core::ffi::c_int,
            C: *mut f64,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDdgmm_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            mode: cublasSideMode_t,
            m: i64,
            n: i64,
            A: *const f64,
            lda: i64,
            x: *const f64,
            incx: i64,
            C: *mut f64,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCdgmm: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            mode: cublasSideMode_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            C: *mut cuComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCdgmm_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            mode: cublasSideMode_t,
            m: i64,
            n: i64,
            A: *const cuComplex,
            lda: i64,
            x: *const cuComplex,
            incx: i64,
            C: *mut cuComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZdgmm: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            mode: cublasSideMode_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            C: *mut cuDoubleComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZdgmm_64: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            mode: cublasSideMode_t,
            m: i64,
            n: i64,
            A: *const cuDoubleComplex,
            lda: i64,
            x: *const cuDoubleComplex,
            incx: i64,
            C: *mut cuDoubleComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSmatinvBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            A: *const *const f32,
            lda: ::core::ffi::c_int,
            Ainv: *const *mut f32,
            lda_inv: ::core::ffi::c_int,
            info: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDmatinvBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            A: *const *const f64,
            lda: ::core::ffi::c_int,
            Ainv: *const *mut f64,
            lda_inv: ::core::ffi::c_int,
            info: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCmatinvBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            A: *const *const cuComplex,
            lda: ::core::ffi::c_int,
            Ainv: *const *mut cuComplex,
            lda_inv: ::core::ffi::c_int,
            info: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZmatinvBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            A: *const *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            Ainv: *const *mut cuDoubleComplex,
            lda_inv: ::core::ffi::c_int,
            info: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSgeqrfBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            Aarray: *const *mut f32,
            lda: ::core::ffi::c_int,
            TauArray: *const *mut f32,
            info: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDgeqrfBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            Aarray: *const *mut f64,
            lda: ::core::ffi::c_int,
            TauArray: *const *mut f64,
            info: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCgeqrfBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            Aarray: *const *mut cuComplex,
            lda: ::core::ffi::c_int,
            TauArray: *const *mut cuComplex,
            info: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZgeqrfBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            Aarray: *const *mut cuDoubleComplex,
            lda: ::core::ffi::c_int,
            TauArray: *const *mut cuDoubleComplex,
            info: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSgelsBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nrhs: ::core::ffi::c_int,
            Aarray: *const *mut f32,
            lda: ::core::ffi::c_int,
            Carray: *const *mut f32,
            ldc: ::core::ffi::c_int,
            info: *mut ::core::ffi::c_int,
            devInfoArray: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDgelsBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nrhs: ::core::ffi::c_int,
            Aarray: *const *mut f64,
            lda: ::core::ffi::c_int,
            Carray: *const *mut f64,
            ldc: ::core::ffi::c_int,
            info: *mut ::core::ffi::c_int,
            devInfoArray: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCgelsBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nrhs: ::core::ffi::c_int,
            Aarray: *const *mut cuComplex,
            lda: ::core::ffi::c_int,
            Carray: *const *mut cuComplex,
            ldc: ::core::ffi::c_int,
            info: *mut ::core::ffi::c_int,
            devInfoArray: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZgelsBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nrhs: ::core::ffi::c_int,
            Aarray: *const *mut cuDoubleComplex,
            lda: ::core::ffi::c_int,
            Carray: *const *mut cuDoubleComplex,
            ldc: ::core::ffi::c_int,
            info: *mut ::core::ffi::c_int,
            devInfoArray: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasStpttr: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            AP: *const f32,
            A: *mut f32,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDtpttr: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            AP: *const f64,
            A: *mut f64,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCtpttr: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            AP: *const cuComplex,
            A: *mut cuComplex,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZtpttr: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            AP: *const cuDoubleComplex,
            A: *mut cuDoubleComplex,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasStrttp: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            A: *const f32,
            lda: ::core::ffi::c_int,
            AP: *mut f32,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDtrttp: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            A: *const f64,
            lda: ::core::ffi::c_int,
            AP: *mut f64,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCtrttp: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            AP: *mut cuComplex,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZtrttp: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            AP: *mut cuDoubleComplex,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSgetrfBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            A: *const *mut f32,
            lda: ::core::ffi::c_int,
            P: *mut ::core::ffi::c_int,
            info: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDgetrfBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            A: *const *mut f64,
            lda: ::core::ffi::c_int,
            P: *mut ::core::ffi::c_int,
            info: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCgetrfBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            A: *const *mut cuComplex,
            lda: ::core::ffi::c_int,
            P: *mut ::core::ffi::c_int,
            info: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZgetrfBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            A: *const *mut cuDoubleComplex,
            lda: ::core::ffi::c_int,
            P: *mut ::core::ffi::c_int,
            info: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSgetriBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            A: *const *const f32,
            lda: ::core::ffi::c_int,
            P: *const ::core::ffi::c_int,
            C: *const *mut f32,
            ldc: ::core::ffi::c_int,
            info: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDgetriBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            A: *const *const f64,
            lda: ::core::ffi::c_int,
            P: *const ::core::ffi::c_int,
            C: *const *mut f64,
            ldc: ::core::ffi::c_int,
            info: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCgetriBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            A: *const *const cuComplex,
            lda: ::core::ffi::c_int,
            P: *const ::core::ffi::c_int,
            C: *const *mut cuComplex,
            ldc: ::core::ffi::c_int,
            info: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZgetriBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            A: *const *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            P: *const ::core::ffi::c_int,
            C: *const *mut cuDoubleComplex,
            ldc: ::core::ffi::c_int,
            info: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasSgetrsBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            nrhs: ::core::ffi::c_int,
            Aarray: *const *const f32,
            lda: ::core::ffi::c_int,
            devIpiv: *const ::core::ffi::c_int,
            Barray: *const *mut f32,
            ldb: ::core::ffi::c_int,
            info: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasDgetrsBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            nrhs: ::core::ffi::c_int,
            Aarray: *const *const f64,
            lda: ::core::ffi::c_int,
            devIpiv: *const ::core::ffi::c_int,
            Barray: *const *mut f64,
            ldb: ::core::ffi::c_int,
            info: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasCgetrsBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            nrhs: ::core::ffi::c_int,
            Aarray: *const *const cuComplex,
            lda: ::core::ffi::c_int,
            devIpiv: *const ::core::ffi::c_int,
            Barray: *const *mut cuComplex,
            ldb: ::core::ffi::c_int,
            info: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasZgetrsBatched: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            nrhs: ::core::ffi::c_int,
            Aarray: *const *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            devIpiv: *const ::core::ffi::c_int,
            Barray: *const *mut cuDoubleComplex,
            ldb: ::core::ffi::c_int,
            info: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
    pub cublasUint8gemmBias: Result<
        unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            transc: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            A: *const ::core::ffi::c_uchar,
            A_bias: ::core::ffi::c_int,
            lda: ::core::ffi::c_int,
            B: *const ::core::ffi::c_uchar,
            B_bias: ::core::ffi::c_int,
            ldb: ::core::ffi::c_int,
            C: *mut ::core::ffi::c_uchar,
            C_bias: ::core::ffi::c_int,
            ldc: ::core::ffi::c_int,
            C_mult: ::core::ffi::c_int,
            C_shift: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        ::libloading::Error,
    >,
}
impl Lib {
    pub unsafe fn new<P>(path: P) -> Result<Self, ::libloading::Error>
    where
        P: AsRef<::std::ffi::OsStr>,
    {
        let library = ::libloading::Library::new(path)?;
        Self::from_library(library)
    }
    pub unsafe fn from_library<L>(library: L) -> Result<Self, ::libloading::Error>
    where
        L: Into<::libloading::Library>,
    {
        let __library = library.into();
        let cublasCreate_v2 = __library.get(b"cublasCreate_v2\0").map(|sym| *sym);
        let cublasDestroy_v2 = __library.get(b"cublasDestroy_v2\0").map(|sym| *sym);
        let cublasGetVersion_v2 = __library.get(b"cublasGetVersion_v2\0").map(|sym| *sym);
        let cublasGetProperty = __library.get(b"cublasGetProperty\0").map(|sym| *sym);
        let cublasGetCudartVersion = __library.get(b"cublasGetCudartVersion\0").map(|sym| *sym);
        let cublasSetWorkspace_v2 = __library.get(b"cublasSetWorkspace_v2\0").map(|sym| *sym);
        let cublasSetStream_v2 = __library.get(b"cublasSetStream_v2\0").map(|sym| *sym);
        let cublasGetStream_v2 = __library.get(b"cublasGetStream_v2\0").map(|sym| *sym);
        let cublasGetPointerMode_v2 = __library.get(b"cublasGetPointerMode_v2\0").map(|sym| *sym);
        let cublasSetPointerMode_v2 = __library.get(b"cublasSetPointerMode_v2\0").map(|sym| *sym);
        let cublasGetAtomicsMode = __library.get(b"cublasGetAtomicsMode\0").map(|sym| *sym);
        let cublasSetAtomicsMode = __library.get(b"cublasSetAtomicsMode\0").map(|sym| *sym);
        let cublasGetMathMode = __library.get(b"cublasGetMathMode\0").map(|sym| *sym);
        let cublasSetMathMode = __library.get(b"cublasSetMathMode\0").map(|sym| *sym);
        let cublasGetSmCountTarget = __library.get(b"cublasGetSmCountTarget\0").map(|sym| *sym);
        let cublasSetSmCountTarget = __library.get(b"cublasSetSmCountTarget\0").map(|sym| *sym);
        let cublasGetStatusName = __library.get(b"cublasGetStatusName\0").map(|sym| *sym);
        let cublasGetStatusString = __library.get(b"cublasGetStatusString\0").map(|sym| *sym);
        let cublasLoggerConfigure = __library.get(b"cublasLoggerConfigure\0").map(|sym| *sym);
        let cublasSetLoggerCallback = __library.get(b"cublasSetLoggerCallback\0").map(|sym| *sym);
        let cublasGetLoggerCallback = __library.get(b"cublasGetLoggerCallback\0").map(|sym| *sym);
        let cublasSetVector = __library.get(b"cublasSetVector\0").map(|sym| *sym);
        let cublasSetVector_64 = __library.get(b"cublasSetVector_64\0").map(|sym| *sym);
        let cublasGetVector = __library.get(b"cublasGetVector\0").map(|sym| *sym);
        let cublasGetVector_64 = __library.get(b"cublasGetVector_64\0").map(|sym| *sym);
        let cublasSetMatrix = __library.get(b"cublasSetMatrix\0").map(|sym| *sym);
        let cublasSetMatrix_64 = __library.get(b"cublasSetMatrix_64\0").map(|sym| *sym);
        let cublasGetMatrix = __library.get(b"cublasGetMatrix\0").map(|sym| *sym);
        let cublasGetMatrix_64 = __library.get(b"cublasGetMatrix_64\0").map(|sym| *sym);
        let cublasSetVectorAsync = __library.get(b"cublasSetVectorAsync\0").map(|sym| *sym);
        let cublasSetVectorAsync_64 = __library.get(b"cublasSetVectorAsync_64\0").map(|sym| *sym);
        let cublasGetVectorAsync = __library.get(b"cublasGetVectorAsync\0").map(|sym| *sym);
        let cublasGetVectorAsync_64 = __library.get(b"cublasGetVectorAsync_64\0").map(|sym| *sym);
        let cublasSetMatrixAsync = __library.get(b"cublasSetMatrixAsync\0").map(|sym| *sym);
        let cublasSetMatrixAsync_64 = __library.get(b"cublasSetMatrixAsync_64\0").map(|sym| *sym);
        let cublasGetMatrixAsync = __library.get(b"cublasGetMatrixAsync\0").map(|sym| *sym);
        let cublasGetMatrixAsync_64 = __library.get(b"cublasGetMatrixAsync_64\0").map(|sym| *sym);
        let cublasXerbla = __library.get(b"cublasXerbla\0").map(|sym| *sym);
        let cublasNrm2Ex = __library.get(b"cublasNrm2Ex\0").map(|sym| *sym);
        let cublasNrm2Ex_64 = __library.get(b"cublasNrm2Ex_64\0").map(|sym| *sym);
        let cublasSnrm2_v2 = __library.get(b"cublasSnrm2_v2\0").map(|sym| *sym);
        let cublasSnrm2_v2_64 = __library.get(b"cublasSnrm2_v2_64\0").map(|sym| *sym);
        let cublasDnrm2_v2 = __library.get(b"cublasDnrm2_v2\0").map(|sym| *sym);
        let cublasDnrm2_v2_64 = __library.get(b"cublasDnrm2_v2_64\0").map(|sym| *sym);
        let cublasScnrm2_v2 = __library.get(b"cublasScnrm2_v2\0").map(|sym| *sym);
        let cublasScnrm2_v2_64 = __library.get(b"cublasScnrm2_v2_64\0").map(|sym| *sym);
        let cublasDznrm2_v2 = __library.get(b"cublasDznrm2_v2\0").map(|sym| *sym);
        let cublasDznrm2_v2_64 = __library.get(b"cublasDznrm2_v2_64\0").map(|sym| *sym);
        let cublasDotEx = __library.get(b"cublasDotEx\0").map(|sym| *sym);
        let cublasDotEx_64 = __library.get(b"cublasDotEx_64\0").map(|sym| *sym);
        let cublasDotcEx = __library.get(b"cublasDotcEx\0").map(|sym| *sym);
        let cublasDotcEx_64 = __library.get(b"cublasDotcEx_64\0").map(|sym| *sym);
        let cublasSdot_v2 = __library.get(b"cublasSdot_v2\0").map(|sym| *sym);
        let cublasSdot_v2_64 = __library.get(b"cublasSdot_v2_64\0").map(|sym| *sym);
        let cublasDdot_v2 = __library.get(b"cublasDdot_v2\0").map(|sym| *sym);
        let cublasDdot_v2_64 = __library.get(b"cublasDdot_v2_64\0").map(|sym| *sym);
        let cublasCdotu_v2 = __library.get(b"cublasCdotu_v2\0").map(|sym| *sym);
        let cublasCdotu_v2_64 = __library.get(b"cublasCdotu_v2_64\0").map(|sym| *sym);
        let cublasCdotc_v2 = __library.get(b"cublasCdotc_v2\0").map(|sym| *sym);
        let cublasCdotc_v2_64 = __library.get(b"cublasCdotc_v2_64\0").map(|sym| *sym);
        let cublasZdotu_v2 = __library.get(b"cublasZdotu_v2\0").map(|sym| *sym);
        let cublasZdotu_v2_64 = __library.get(b"cublasZdotu_v2_64\0").map(|sym| *sym);
        let cublasZdotc_v2 = __library.get(b"cublasZdotc_v2\0").map(|sym| *sym);
        let cublasZdotc_v2_64 = __library.get(b"cublasZdotc_v2_64\0").map(|sym| *sym);
        let cublasScalEx = __library.get(b"cublasScalEx\0").map(|sym| *sym);
        let cublasScalEx_64 = __library.get(b"cublasScalEx_64\0").map(|sym| *sym);
        let cublasSscal_v2 = __library.get(b"cublasSscal_v2\0").map(|sym| *sym);
        let cublasSscal_v2_64 = __library.get(b"cublasSscal_v2_64\0").map(|sym| *sym);
        let cublasDscal_v2 = __library.get(b"cublasDscal_v2\0").map(|sym| *sym);
        let cublasDscal_v2_64 = __library.get(b"cublasDscal_v2_64\0").map(|sym| *sym);
        let cublasCscal_v2 = __library.get(b"cublasCscal_v2\0").map(|sym| *sym);
        let cublasCscal_v2_64 = __library.get(b"cublasCscal_v2_64\0").map(|sym| *sym);
        let cublasCsscal_v2 = __library.get(b"cublasCsscal_v2\0").map(|sym| *sym);
        let cublasCsscal_v2_64 = __library.get(b"cublasCsscal_v2_64\0").map(|sym| *sym);
        let cublasZscal_v2 = __library.get(b"cublasZscal_v2\0").map(|sym| *sym);
        let cublasZscal_v2_64 = __library.get(b"cublasZscal_v2_64\0").map(|sym| *sym);
        let cublasZdscal_v2 = __library.get(b"cublasZdscal_v2\0").map(|sym| *sym);
        let cublasZdscal_v2_64 = __library.get(b"cublasZdscal_v2_64\0").map(|sym| *sym);
        let cublasAxpyEx = __library.get(b"cublasAxpyEx\0").map(|sym| *sym);
        let cublasAxpyEx_64 = __library.get(b"cublasAxpyEx_64\0").map(|sym| *sym);
        let cublasSaxpy_v2 = __library.get(b"cublasSaxpy_v2\0").map(|sym| *sym);
        let cublasSaxpy_v2_64 = __library.get(b"cublasSaxpy_v2_64\0").map(|sym| *sym);
        let cublasDaxpy_v2 = __library.get(b"cublasDaxpy_v2\0").map(|sym| *sym);
        let cublasDaxpy_v2_64 = __library.get(b"cublasDaxpy_v2_64\0").map(|sym| *sym);
        let cublasCaxpy_v2 = __library.get(b"cublasCaxpy_v2\0").map(|sym| *sym);
        let cublasCaxpy_v2_64 = __library.get(b"cublasCaxpy_v2_64\0").map(|sym| *sym);
        let cublasZaxpy_v2 = __library.get(b"cublasZaxpy_v2\0").map(|sym| *sym);
        let cublasZaxpy_v2_64 = __library.get(b"cublasZaxpy_v2_64\0").map(|sym| *sym);
        let cublasCopyEx = __library.get(b"cublasCopyEx\0").map(|sym| *sym);
        let cublasCopyEx_64 = __library.get(b"cublasCopyEx_64\0").map(|sym| *sym);
        let cublasScopy_v2 = __library.get(b"cublasScopy_v2\0").map(|sym| *sym);
        let cublasScopy_v2_64 = __library.get(b"cublasScopy_v2_64\0").map(|sym| *sym);
        let cublasDcopy_v2 = __library.get(b"cublasDcopy_v2\0").map(|sym| *sym);
        let cublasDcopy_v2_64 = __library.get(b"cublasDcopy_v2_64\0").map(|sym| *sym);
        let cublasCcopy_v2 = __library.get(b"cublasCcopy_v2\0").map(|sym| *sym);
        let cublasCcopy_v2_64 = __library.get(b"cublasCcopy_v2_64\0").map(|sym| *sym);
        let cublasZcopy_v2 = __library.get(b"cublasZcopy_v2\0").map(|sym| *sym);
        let cublasZcopy_v2_64 = __library.get(b"cublasZcopy_v2_64\0").map(|sym| *sym);
        let cublasSswap_v2 = __library.get(b"cublasSswap_v2\0").map(|sym| *sym);
        let cublasSswap_v2_64 = __library.get(b"cublasSswap_v2_64\0").map(|sym| *sym);
        let cublasDswap_v2 = __library.get(b"cublasDswap_v2\0").map(|sym| *sym);
        let cublasDswap_v2_64 = __library.get(b"cublasDswap_v2_64\0").map(|sym| *sym);
        let cublasCswap_v2 = __library.get(b"cublasCswap_v2\0").map(|sym| *sym);
        let cublasCswap_v2_64 = __library.get(b"cublasCswap_v2_64\0").map(|sym| *sym);
        let cublasZswap_v2 = __library.get(b"cublasZswap_v2\0").map(|sym| *sym);
        let cublasZswap_v2_64 = __library.get(b"cublasZswap_v2_64\0").map(|sym| *sym);
        let cublasSwapEx = __library.get(b"cublasSwapEx\0").map(|sym| *sym);
        let cublasSwapEx_64 = __library.get(b"cublasSwapEx_64\0").map(|sym| *sym);
        let cublasIsamax_v2 = __library.get(b"cublasIsamax_v2\0").map(|sym| *sym);
        let cublasIsamax_v2_64 = __library.get(b"cublasIsamax_v2_64\0").map(|sym| *sym);
        let cublasIdamax_v2 = __library.get(b"cublasIdamax_v2\0").map(|sym| *sym);
        let cublasIdamax_v2_64 = __library.get(b"cublasIdamax_v2_64\0").map(|sym| *sym);
        let cublasIcamax_v2 = __library.get(b"cublasIcamax_v2\0").map(|sym| *sym);
        let cublasIcamax_v2_64 = __library.get(b"cublasIcamax_v2_64\0").map(|sym| *sym);
        let cublasIzamax_v2 = __library.get(b"cublasIzamax_v2\0").map(|sym| *sym);
        let cublasIzamax_v2_64 = __library.get(b"cublasIzamax_v2_64\0").map(|sym| *sym);
        let cublasIamaxEx = __library.get(b"cublasIamaxEx\0").map(|sym| *sym);
        let cublasIamaxEx_64 = __library.get(b"cublasIamaxEx_64\0").map(|sym| *sym);
        let cublasIsamin_v2 = __library.get(b"cublasIsamin_v2\0").map(|sym| *sym);
        let cublasIsamin_v2_64 = __library.get(b"cublasIsamin_v2_64\0").map(|sym| *sym);
        let cublasIdamin_v2 = __library.get(b"cublasIdamin_v2\0").map(|sym| *sym);
        let cublasIdamin_v2_64 = __library.get(b"cublasIdamin_v2_64\0").map(|sym| *sym);
        let cublasIcamin_v2 = __library.get(b"cublasIcamin_v2\0").map(|sym| *sym);
        let cublasIcamin_v2_64 = __library.get(b"cublasIcamin_v2_64\0").map(|sym| *sym);
        let cublasIzamin_v2 = __library.get(b"cublasIzamin_v2\0").map(|sym| *sym);
        let cublasIzamin_v2_64 = __library.get(b"cublasIzamin_v2_64\0").map(|sym| *sym);
        let cublasIaminEx = __library.get(b"cublasIaminEx\0").map(|sym| *sym);
        let cublasIaminEx_64 = __library.get(b"cublasIaminEx_64\0").map(|sym| *sym);
        let cublasAsumEx = __library.get(b"cublasAsumEx\0").map(|sym| *sym);
        let cublasAsumEx_64 = __library.get(b"cublasAsumEx_64\0").map(|sym| *sym);
        let cublasSasum_v2 = __library.get(b"cublasSasum_v2\0").map(|sym| *sym);
        let cublasSasum_v2_64 = __library.get(b"cublasSasum_v2_64\0").map(|sym| *sym);
        let cublasDasum_v2 = __library.get(b"cublasDasum_v2\0").map(|sym| *sym);
        let cublasDasum_v2_64 = __library.get(b"cublasDasum_v2_64\0").map(|sym| *sym);
        let cublasScasum_v2 = __library.get(b"cublasScasum_v2\0").map(|sym| *sym);
        let cublasScasum_v2_64 = __library.get(b"cublasScasum_v2_64\0").map(|sym| *sym);
        let cublasDzasum_v2 = __library.get(b"cublasDzasum_v2\0").map(|sym| *sym);
        let cublasDzasum_v2_64 = __library.get(b"cublasDzasum_v2_64\0").map(|sym| *sym);
        let cublasSrot_v2 = __library.get(b"cublasSrot_v2\0").map(|sym| *sym);
        let cublasSrot_v2_64 = __library.get(b"cublasSrot_v2_64\0").map(|sym| *sym);
        let cublasDrot_v2 = __library.get(b"cublasDrot_v2\0").map(|sym| *sym);
        let cublasDrot_v2_64 = __library.get(b"cublasDrot_v2_64\0").map(|sym| *sym);
        let cublasCrot_v2 = __library.get(b"cublasCrot_v2\0").map(|sym| *sym);
        let cublasCrot_v2_64 = __library.get(b"cublasCrot_v2_64\0").map(|sym| *sym);
        let cublasCsrot_v2 = __library.get(b"cublasCsrot_v2\0").map(|sym| *sym);
        let cublasCsrot_v2_64 = __library.get(b"cublasCsrot_v2_64\0").map(|sym| *sym);
        let cublasZrot_v2 = __library.get(b"cublasZrot_v2\0").map(|sym| *sym);
        let cublasZrot_v2_64 = __library.get(b"cublasZrot_v2_64\0").map(|sym| *sym);
        let cublasZdrot_v2 = __library.get(b"cublasZdrot_v2\0").map(|sym| *sym);
        let cublasZdrot_v2_64 = __library.get(b"cublasZdrot_v2_64\0").map(|sym| *sym);
        let cublasRotEx = __library.get(b"cublasRotEx\0").map(|sym| *sym);
        let cublasRotEx_64 = __library.get(b"cublasRotEx_64\0").map(|sym| *sym);
        let cublasSrotg_v2 = __library.get(b"cublasSrotg_v2\0").map(|sym| *sym);
        let cublasDrotg_v2 = __library.get(b"cublasDrotg_v2\0").map(|sym| *sym);
        let cublasCrotg_v2 = __library.get(b"cublasCrotg_v2\0").map(|sym| *sym);
        let cublasZrotg_v2 = __library.get(b"cublasZrotg_v2\0").map(|sym| *sym);
        let cublasRotgEx = __library.get(b"cublasRotgEx\0").map(|sym| *sym);
        let cublasSrotm_v2 = __library.get(b"cublasSrotm_v2\0").map(|sym| *sym);
        let cublasSrotm_v2_64 = __library.get(b"cublasSrotm_v2_64\0").map(|sym| *sym);
        let cublasDrotm_v2 = __library.get(b"cublasDrotm_v2\0").map(|sym| *sym);
        let cublasDrotm_v2_64 = __library.get(b"cublasDrotm_v2_64\0").map(|sym| *sym);
        let cublasRotmEx = __library.get(b"cublasRotmEx\0").map(|sym| *sym);
        let cublasRotmEx_64 = __library.get(b"cublasRotmEx_64\0").map(|sym| *sym);
        let cublasSrotmg_v2 = __library.get(b"cublasSrotmg_v2\0").map(|sym| *sym);
        let cublasDrotmg_v2 = __library.get(b"cublasDrotmg_v2\0").map(|sym| *sym);
        let cublasRotmgEx = __library.get(b"cublasRotmgEx\0").map(|sym| *sym);
        let cublasSgemv_v2 = __library.get(b"cublasSgemv_v2\0").map(|sym| *sym);
        let cublasSgemv_v2_64 = __library.get(b"cublasSgemv_v2_64\0").map(|sym| *sym);
        let cublasDgemv_v2 = __library.get(b"cublasDgemv_v2\0").map(|sym| *sym);
        let cublasDgemv_v2_64 = __library.get(b"cublasDgemv_v2_64\0").map(|sym| *sym);
        let cublasCgemv_v2 = __library.get(b"cublasCgemv_v2\0").map(|sym| *sym);
        let cublasCgemv_v2_64 = __library.get(b"cublasCgemv_v2_64\0").map(|sym| *sym);
        let cublasZgemv_v2 = __library.get(b"cublasZgemv_v2\0").map(|sym| *sym);
        let cublasZgemv_v2_64 = __library.get(b"cublasZgemv_v2_64\0").map(|sym| *sym);
        let cublasSgbmv_v2 = __library.get(b"cublasSgbmv_v2\0").map(|sym| *sym);
        let cublasSgbmv_v2_64 = __library.get(b"cublasSgbmv_v2_64\0").map(|sym| *sym);
        let cublasDgbmv_v2 = __library.get(b"cublasDgbmv_v2\0").map(|sym| *sym);
        let cublasDgbmv_v2_64 = __library.get(b"cublasDgbmv_v2_64\0").map(|sym| *sym);
        let cublasCgbmv_v2 = __library.get(b"cublasCgbmv_v2\0").map(|sym| *sym);
        let cublasCgbmv_v2_64 = __library.get(b"cublasCgbmv_v2_64\0").map(|sym| *sym);
        let cublasZgbmv_v2 = __library.get(b"cublasZgbmv_v2\0").map(|sym| *sym);
        let cublasZgbmv_v2_64 = __library.get(b"cublasZgbmv_v2_64\0").map(|sym| *sym);
        let cublasStrmv_v2 = __library.get(b"cublasStrmv_v2\0").map(|sym| *sym);
        let cublasStrmv_v2_64 = __library.get(b"cublasStrmv_v2_64\0").map(|sym| *sym);
        let cublasDtrmv_v2 = __library.get(b"cublasDtrmv_v2\0").map(|sym| *sym);
        let cublasDtrmv_v2_64 = __library.get(b"cublasDtrmv_v2_64\0").map(|sym| *sym);
        let cublasCtrmv_v2 = __library.get(b"cublasCtrmv_v2\0").map(|sym| *sym);
        let cublasCtrmv_v2_64 = __library.get(b"cublasCtrmv_v2_64\0").map(|sym| *sym);
        let cublasZtrmv_v2 = __library.get(b"cublasZtrmv_v2\0").map(|sym| *sym);
        let cublasZtrmv_v2_64 = __library.get(b"cublasZtrmv_v2_64\0").map(|sym| *sym);
        let cublasStbmv_v2 = __library.get(b"cublasStbmv_v2\0").map(|sym| *sym);
        let cublasStbmv_v2_64 = __library.get(b"cublasStbmv_v2_64\0").map(|sym| *sym);
        let cublasDtbmv_v2 = __library.get(b"cublasDtbmv_v2\0").map(|sym| *sym);
        let cublasDtbmv_v2_64 = __library.get(b"cublasDtbmv_v2_64\0").map(|sym| *sym);
        let cublasCtbmv_v2 = __library.get(b"cublasCtbmv_v2\0").map(|sym| *sym);
        let cublasCtbmv_v2_64 = __library.get(b"cublasCtbmv_v2_64\0").map(|sym| *sym);
        let cublasZtbmv_v2 = __library.get(b"cublasZtbmv_v2\0").map(|sym| *sym);
        let cublasZtbmv_v2_64 = __library.get(b"cublasZtbmv_v2_64\0").map(|sym| *sym);
        let cublasStpmv_v2 = __library.get(b"cublasStpmv_v2\0").map(|sym| *sym);
        let cublasStpmv_v2_64 = __library.get(b"cublasStpmv_v2_64\0").map(|sym| *sym);
        let cublasDtpmv_v2 = __library.get(b"cublasDtpmv_v2\0").map(|sym| *sym);
        let cublasDtpmv_v2_64 = __library.get(b"cublasDtpmv_v2_64\0").map(|sym| *sym);
        let cublasCtpmv_v2 = __library.get(b"cublasCtpmv_v2\0").map(|sym| *sym);
        let cublasCtpmv_v2_64 = __library.get(b"cublasCtpmv_v2_64\0").map(|sym| *sym);
        let cublasZtpmv_v2 = __library.get(b"cublasZtpmv_v2\0").map(|sym| *sym);
        let cublasZtpmv_v2_64 = __library.get(b"cublasZtpmv_v2_64\0").map(|sym| *sym);
        let cublasStrsv_v2 = __library.get(b"cublasStrsv_v2\0").map(|sym| *sym);
        let cublasStrsv_v2_64 = __library.get(b"cublasStrsv_v2_64\0").map(|sym| *sym);
        let cublasDtrsv_v2 = __library.get(b"cublasDtrsv_v2\0").map(|sym| *sym);
        let cublasDtrsv_v2_64 = __library.get(b"cublasDtrsv_v2_64\0").map(|sym| *sym);
        let cublasCtrsv_v2 = __library.get(b"cublasCtrsv_v2\0").map(|sym| *sym);
        let cublasCtrsv_v2_64 = __library.get(b"cublasCtrsv_v2_64\0").map(|sym| *sym);
        let cublasZtrsv_v2 = __library.get(b"cublasZtrsv_v2\0").map(|sym| *sym);
        let cublasZtrsv_v2_64 = __library.get(b"cublasZtrsv_v2_64\0").map(|sym| *sym);
        let cublasStpsv_v2 = __library.get(b"cublasStpsv_v2\0").map(|sym| *sym);
        let cublasStpsv_v2_64 = __library.get(b"cublasStpsv_v2_64\0").map(|sym| *sym);
        let cublasDtpsv_v2 = __library.get(b"cublasDtpsv_v2\0").map(|sym| *sym);
        let cublasDtpsv_v2_64 = __library.get(b"cublasDtpsv_v2_64\0").map(|sym| *sym);
        let cublasCtpsv_v2 = __library.get(b"cublasCtpsv_v2\0").map(|sym| *sym);
        let cublasCtpsv_v2_64 = __library.get(b"cublasCtpsv_v2_64\0").map(|sym| *sym);
        let cublasZtpsv_v2 = __library.get(b"cublasZtpsv_v2\0").map(|sym| *sym);
        let cublasZtpsv_v2_64 = __library.get(b"cublasZtpsv_v2_64\0").map(|sym| *sym);
        let cublasStbsv_v2 = __library.get(b"cublasStbsv_v2\0").map(|sym| *sym);
        let cublasStbsv_v2_64 = __library.get(b"cublasStbsv_v2_64\0").map(|sym| *sym);
        let cublasDtbsv_v2 = __library.get(b"cublasDtbsv_v2\0").map(|sym| *sym);
        let cublasDtbsv_v2_64 = __library.get(b"cublasDtbsv_v2_64\0").map(|sym| *sym);
        let cublasCtbsv_v2 = __library.get(b"cublasCtbsv_v2\0").map(|sym| *sym);
        let cublasCtbsv_v2_64 = __library.get(b"cublasCtbsv_v2_64\0").map(|sym| *sym);
        let cublasZtbsv_v2 = __library.get(b"cublasZtbsv_v2\0").map(|sym| *sym);
        let cublasZtbsv_v2_64 = __library.get(b"cublasZtbsv_v2_64\0").map(|sym| *sym);
        let cublasSsymv_v2 = __library.get(b"cublasSsymv_v2\0").map(|sym| *sym);
        let cublasSsymv_v2_64 = __library.get(b"cublasSsymv_v2_64\0").map(|sym| *sym);
        let cublasDsymv_v2 = __library.get(b"cublasDsymv_v2\0").map(|sym| *sym);
        let cublasDsymv_v2_64 = __library.get(b"cublasDsymv_v2_64\0").map(|sym| *sym);
        let cublasCsymv_v2 = __library.get(b"cublasCsymv_v2\0").map(|sym| *sym);
        let cublasCsymv_v2_64 = __library.get(b"cublasCsymv_v2_64\0").map(|sym| *sym);
        let cublasZsymv_v2 = __library.get(b"cublasZsymv_v2\0").map(|sym| *sym);
        let cublasZsymv_v2_64 = __library.get(b"cublasZsymv_v2_64\0").map(|sym| *sym);
        let cublasChemv_v2 = __library.get(b"cublasChemv_v2\0").map(|sym| *sym);
        let cublasChemv_v2_64 = __library.get(b"cublasChemv_v2_64\0").map(|sym| *sym);
        let cublasZhemv_v2 = __library.get(b"cublasZhemv_v2\0").map(|sym| *sym);
        let cublasZhemv_v2_64 = __library.get(b"cublasZhemv_v2_64\0").map(|sym| *sym);
        let cublasSsbmv_v2 = __library.get(b"cublasSsbmv_v2\0").map(|sym| *sym);
        let cublasSsbmv_v2_64 = __library.get(b"cublasSsbmv_v2_64\0").map(|sym| *sym);
        let cublasDsbmv_v2 = __library.get(b"cublasDsbmv_v2\0").map(|sym| *sym);
        let cublasDsbmv_v2_64 = __library.get(b"cublasDsbmv_v2_64\0").map(|sym| *sym);
        let cublasChbmv_v2 = __library.get(b"cublasChbmv_v2\0").map(|sym| *sym);
        let cublasChbmv_v2_64 = __library.get(b"cublasChbmv_v2_64\0").map(|sym| *sym);
        let cublasZhbmv_v2 = __library.get(b"cublasZhbmv_v2\0").map(|sym| *sym);
        let cublasZhbmv_v2_64 = __library.get(b"cublasZhbmv_v2_64\0").map(|sym| *sym);
        let cublasSspmv_v2 = __library.get(b"cublasSspmv_v2\0").map(|sym| *sym);
        let cublasSspmv_v2_64 = __library.get(b"cublasSspmv_v2_64\0").map(|sym| *sym);
        let cublasDspmv_v2 = __library.get(b"cublasDspmv_v2\0").map(|sym| *sym);
        let cublasDspmv_v2_64 = __library.get(b"cublasDspmv_v2_64\0").map(|sym| *sym);
        let cublasChpmv_v2 = __library.get(b"cublasChpmv_v2\0").map(|sym| *sym);
        let cublasChpmv_v2_64 = __library.get(b"cublasChpmv_v2_64\0").map(|sym| *sym);
        let cublasZhpmv_v2 = __library.get(b"cublasZhpmv_v2\0").map(|sym| *sym);
        let cublasZhpmv_v2_64 = __library.get(b"cublasZhpmv_v2_64\0").map(|sym| *sym);
        let cublasSger_v2 = __library.get(b"cublasSger_v2\0").map(|sym| *sym);
        let cublasSger_v2_64 = __library.get(b"cublasSger_v2_64\0").map(|sym| *sym);
        let cublasDger_v2 = __library.get(b"cublasDger_v2\0").map(|sym| *sym);
        let cublasDger_v2_64 = __library.get(b"cublasDger_v2_64\0").map(|sym| *sym);
        let cublasCgeru_v2 = __library.get(b"cublasCgeru_v2\0").map(|sym| *sym);
        let cublasCgeru_v2_64 = __library.get(b"cublasCgeru_v2_64\0").map(|sym| *sym);
        let cublasCgerc_v2 = __library.get(b"cublasCgerc_v2\0").map(|sym| *sym);
        let cublasCgerc_v2_64 = __library.get(b"cublasCgerc_v2_64\0").map(|sym| *sym);
        let cublasZgeru_v2 = __library.get(b"cublasZgeru_v2\0").map(|sym| *sym);
        let cublasZgeru_v2_64 = __library.get(b"cublasZgeru_v2_64\0").map(|sym| *sym);
        let cublasZgerc_v2 = __library.get(b"cublasZgerc_v2\0").map(|sym| *sym);
        let cublasZgerc_v2_64 = __library.get(b"cublasZgerc_v2_64\0").map(|sym| *sym);
        let cublasSsyr_v2 = __library.get(b"cublasSsyr_v2\0").map(|sym| *sym);
        let cublasSsyr_v2_64 = __library.get(b"cublasSsyr_v2_64\0").map(|sym| *sym);
        let cublasDsyr_v2 = __library.get(b"cublasDsyr_v2\0").map(|sym| *sym);
        let cublasDsyr_v2_64 = __library.get(b"cublasDsyr_v2_64\0").map(|sym| *sym);
        let cublasCsyr_v2 = __library.get(b"cublasCsyr_v2\0").map(|sym| *sym);
        let cublasCsyr_v2_64 = __library.get(b"cublasCsyr_v2_64\0").map(|sym| *sym);
        let cublasZsyr_v2 = __library.get(b"cublasZsyr_v2\0").map(|sym| *sym);
        let cublasZsyr_v2_64 = __library.get(b"cublasZsyr_v2_64\0").map(|sym| *sym);
        let cublasCher_v2 = __library.get(b"cublasCher_v2\0").map(|sym| *sym);
        let cublasCher_v2_64 = __library.get(b"cublasCher_v2_64\0").map(|sym| *sym);
        let cublasZher_v2 = __library.get(b"cublasZher_v2\0").map(|sym| *sym);
        let cublasZher_v2_64 = __library.get(b"cublasZher_v2_64\0").map(|sym| *sym);
        let cublasSspr_v2 = __library.get(b"cublasSspr_v2\0").map(|sym| *sym);
        let cublasSspr_v2_64 = __library.get(b"cublasSspr_v2_64\0").map(|sym| *sym);
        let cublasDspr_v2 = __library.get(b"cublasDspr_v2\0").map(|sym| *sym);
        let cublasDspr_v2_64 = __library.get(b"cublasDspr_v2_64\0").map(|sym| *sym);
        let cublasChpr_v2 = __library.get(b"cublasChpr_v2\0").map(|sym| *sym);
        let cublasChpr_v2_64 = __library.get(b"cublasChpr_v2_64\0").map(|sym| *sym);
        let cublasZhpr_v2 = __library.get(b"cublasZhpr_v2\0").map(|sym| *sym);
        let cublasZhpr_v2_64 = __library.get(b"cublasZhpr_v2_64\0").map(|sym| *sym);
        let cublasSsyr2_v2 = __library.get(b"cublasSsyr2_v2\0").map(|sym| *sym);
        let cublasSsyr2_v2_64 = __library.get(b"cublasSsyr2_v2_64\0").map(|sym| *sym);
        let cublasDsyr2_v2 = __library.get(b"cublasDsyr2_v2\0").map(|sym| *sym);
        let cublasDsyr2_v2_64 = __library.get(b"cublasDsyr2_v2_64\0").map(|sym| *sym);
        let cublasCsyr2_v2 = __library.get(b"cublasCsyr2_v2\0").map(|sym| *sym);
        let cublasCsyr2_v2_64 = __library.get(b"cublasCsyr2_v2_64\0").map(|sym| *sym);
        let cublasZsyr2_v2 = __library.get(b"cublasZsyr2_v2\0").map(|sym| *sym);
        let cublasZsyr2_v2_64 = __library.get(b"cublasZsyr2_v2_64\0").map(|sym| *sym);
        let cublasCher2_v2 = __library.get(b"cublasCher2_v2\0").map(|sym| *sym);
        let cublasCher2_v2_64 = __library.get(b"cublasCher2_v2_64\0").map(|sym| *sym);
        let cublasZher2_v2 = __library.get(b"cublasZher2_v2\0").map(|sym| *sym);
        let cublasZher2_v2_64 = __library.get(b"cublasZher2_v2_64\0").map(|sym| *sym);
        let cublasSspr2_v2 = __library.get(b"cublasSspr2_v2\0").map(|sym| *sym);
        let cublasSspr2_v2_64 = __library.get(b"cublasSspr2_v2_64\0").map(|sym| *sym);
        let cublasDspr2_v2 = __library.get(b"cublasDspr2_v2\0").map(|sym| *sym);
        let cublasDspr2_v2_64 = __library.get(b"cublasDspr2_v2_64\0").map(|sym| *sym);
        let cublasChpr2_v2 = __library.get(b"cublasChpr2_v2\0").map(|sym| *sym);
        let cublasChpr2_v2_64 = __library.get(b"cublasChpr2_v2_64\0").map(|sym| *sym);
        let cublasZhpr2_v2 = __library.get(b"cublasZhpr2_v2\0").map(|sym| *sym);
        let cublasZhpr2_v2_64 = __library.get(b"cublasZhpr2_v2_64\0").map(|sym| *sym);
        let cublasSgemvBatched = __library.get(b"cublasSgemvBatched\0").map(|sym| *sym);
        let cublasSgemvBatched_64 = __library.get(b"cublasSgemvBatched_64\0").map(|sym| *sym);
        let cublasDgemvBatched = __library.get(b"cublasDgemvBatched\0").map(|sym| *sym);
        let cublasDgemvBatched_64 = __library.get(b"cublasDgemvBatched_64\0").map(|sym| *sym);
        let cublasCgemvBatched = __library.get(b"cublasCgemvBatched\0").map(|sym| *sym);
        let cublasCgemvBatched_64 = __library.get(b"cublasCgemvBatched_64\0").map(|sym| *sym);
        let cublasZgemvBatched = __library.get(b"cublasZgemvBatched\0").map(|sym| *sym);
        let cublasZgemvBatched_64 = __library.get(b"cublasZgemvBatched_64\0").map(|sym| *sym);
        let cublasSgemvStridedBatched = __library
            .get(b"cublasSgemvStridedBatched\0")
            .map(|sym| *sym);
        let cublasSgemvStridedBatched_64 = __library
            .get(b"cublasSgemvStridedBatched_64\0")
            .map(|sym| *sym);
        let cublasDgemvStridedBatched = __library
            .get(b"cublasDgemvStridedBatched\0")
            .map(|sym| *sym);
        let cublasDgemvStridedBatched_64 = __library
            .get(b"cublasDgemvStridedBatched_64\0")
            .map(|sym| *sym);
        let cublasCgemvStridedBatched = __library
            .get(b"cublasCgemvStridedBatched\0")
            .map(|sym| *sym);
        let cublasCgemvStridedBatched_64 = __library
            .get(b"cublasCgemvStridedBatched_64\0")
            .map(|sym| *sym);
        let cublasZgemvStridedBatched = __library
            .get(b"cublasZgemvStridedBatched\0")
            .map(|sym| *sym);
        let cublasZgemvStridedBatched_64 = __library
            .get(b"cublasZgemvStridedBatched_64\0")
            .map(|sym| *sym);
        let cublasSgemm_v2 = __library.get(b"cublasSgemm_v2\0").map(|sym| *sym);
        let cublasSgemm_v2_64 = __library.get(b"cublasSgemm_v2_64\0").map(|sym| *sym);
        let cublasDgemm_v2 = __library.get(b"cublasDgemm_v2\0").map(|sym| *sym);
        let cublasDgemm_v2_64 = __library.get(b"cublasDgemm_v2_64\0").map(|sym| *sym);
        let cublasCgemm_v2 = __library.get(b"cublasCgemm_v2\0").map(|sym| *sym);
        let cublasCgemm_v2_64 = __library.get(b"cublasCgemm_v2_64\0").map(|sym| *sym);
        let cublasCgemm3m = __library.get(b"cublasCgemm3m\0").map(|sym| *sym);
        let cublasCgemm3m_64 = __library.get(b"cublasCgemm3m_64\0").map(|sym| *sym);
        let cublasCgemm3mEx = __library.get(b"cublasCgemm3mEx\0").map(|sym| *sym);
        let cublasCgemm3mEx_64 = __library.get(b"cublasCgemm3mEx_64\0").map(|sym| *sym);
        let cublasZgemm_v2 = __library.get(b"cublasZgemm_v2\0").map(|sym| *sym);
        let cublasZgemm_v2_64 = __library.get(b"cublasZgemm_v2_64\0").map(|sym| *sym);
        let cublasZgemm3m = __library.get(b"cublasZgemm3m\0").map(|sym| *sym);
        let cublasZgemm3m_64 = __library.get(b"cublasZgemm3m_64\0").map(|sym| *sym);
        let cublasSgemmEx = __library.get(b"cublasSgemmEx\0").map(|sym| *sym);
        let cublasSgemmEx_64 = __library.get(b"cublasSgemmEx_64\0").map(|sym| *sym);
        let cublasGemmEx = __library.get(b"cublasGemmEx\0").map(|sym| *sym);
        let cublasGemmEx_64 = __library.get(b"cublasGemmEx_64\0").map(|sym| *sym);
        let cublasCgemmEx = __library.get(b"cublasCgemmEx\0").map(|sym| *sym);
        let cublasCgemmEx_64 = __library.get(b"cublasCgemmEx_64\0").map(|sym| *sym);
        let cublasSsyrk_v2 = __library.get(b"cublasSsyrk_v2\0").map(|sym| *sym);
        let cublasSsyrk_v2_64 = __library.get(b"cublasSsyrk_v2_64\0").map(|sym| *sym);
        let cublasDsyrk_v2 = __library.get(b"cublasDsyrk_v2\0").map(|sym| *sym);
        let cublasDsyrk_v2_64 = __library.get(b"cublasDsyrk_v2_64\0").map(|sym| *sym);
        let cublasCsyrk_v2 = __library.get(b"cublasCsyrk_v2\0").map(|sym| *sym);
        let cublasCsyrk_v2_64 = __library.get(b"cublasCsyrk_v2_64\0").map(|sym| *sym);
        let cublasZsyrk_v2 = __library.get(b"cublasZsyrk_v2\0").map(|sym| *sym);
        let cublasZsyrk_v2_64 = __library.get(b"cublasZsyrk_v2_64\0").map(|sym| *sym);
        let cublasCsyrkEx = __library.get(b"cublasCsyrkEx\0").map(|sym| *sym);
        let cublasCsyrkEx_64 = __library.get(b"cublasCsyrkEx_64\0").map(|sym| *sym);
        let cublasCsyrk3mEx = __library.get(b"cublasCsyrk3mEx\0").map(|sym| *sym);
        let cublasCsyrk3mEx_64 = __library.get(b"cublasCsyrk3mEx_64\0").map(|sym| *sym);
        let cublasCherk_v2 = __library.get(b"cublasCherk_v2\0").map(|sym| *sym);
        let cublasCherk_v2_64 = __library.get(b"cublasCherk_v2_64\0").map(|sym| *sym);
        let cublasZherk_v2 = __library.get(b"cublasZherk_v2\0").map(|sym| *sym);
        let cublasZherk_v2_64 = __library.get(b"cublasZherk_v2_64\0").map(|sym| *sym);
        let cublasCherkEx = __library.get(b"cublasCherkEx\0").map(|sym| *sym);
        let cublasCherkEx_64 = __library.get(b"cublasCherkEx_64\0").map(|sym| *sym);
        let cublasCherk3mEx = __library.get(b"cublasCherk3mEx\0").map(|sym| *sym);
        let cublasCherk3mEx_64 = __library.get(b"cublasCherk3mEx_64\0").map(|sym| *sym);
        let cublasSsyr2k_v2 = __library.get(b"cublasSsyr2k_v2\0").map(|sym| *sym);
        let cublasSsyr2k_v2_64 = __library.get(b"cublasSsyr2k_v2_64\0").map(|sym| *sym);
        let cublasDsyr2k_v2 = __library.get(b"cublasDsyr2k_v2\0").map(|sym| *sym);
        let cublasDsyr2k_v2_64 = __library.get(b"cublasDsyr2k_v2_64\0").map(|sym| *sym);
        let cublasCsyr2k_v2 = __library.get(b"cublasCsyr2k_v2\0").map(|sym| *sym);
        let cublasCsyr2k_v2_64 = __library.get(b"cublasCsyr2k_v2_64\0").map(|sym| *sym);
        let cublasZsyr2k_v2 = __library.get(b"cublasZsyr2k_v2\0").map(|sym| *sym);
        let cublasZsyr2k_v2_64 = __library.get(b"cublasZsyr2k_v2_64\0").map(|sym| *sym);
        let cublasCher2k_v2 = __library.get(b"cublasCher2k_v2\0").map(|sym| *sym);
        let cublasCher2k_v2_64 = __library.get(b"cublasCher2k_v2_64\0").map(|sym| *sym);
        let cublasZher2k_v2 = __library.get(b"cublasZher2k_v2\0").map(|sym| *sym);
        let cublasZher2k_v2_64 = __library.get(b"cublasZher2k_v2_64\0").map(|sym| *sym);
        let cublasSsyrkx = __library.get(b"cublasSsyrkx\0").map(|sym| *sym);
        let cublasSsyrkx_64 = __library.get(b"cublasSsyrkx_64\0").map(|sym| *sym);
        let cublasDsyrkx = __library.get(b"cublasDsyrkx\0").map(|sym| *sym);
        let cublasDsyrkx_64 = __library.get(b"cublasDsyrkx_64\0").map(|sym| *sym);
        let cublasCsyrkx = __library.get(b"cublasCsyrkx\0").map(|sym| *sym);
        let cublasCsyrkx_64 = __library.get(b"cublasCsyrkx_64\0").map(|sym| *sym);
        let cublasZsyrkx = __library.get(b"cublasZsyrkx\0").map(|sym| *sym);
        let cublasZsyrkx_64 = __library.get(b"cublasZsyrkx_64\0").map(|sym| *sym);
        let cublasCherkx = __library.get(b"cublasCherkx\0").map(|sym| *sym);
        let cublasCherkx_64 = __library.get(b"cublasCherkx_64\0").map(|sym| *sym);
        let cublasZherkx = __library.get(b"cublasZherkx\0").map(|sym| *sym);
        let cublasZherkx_64 = __library.get(b"cublasZherkx_64\0").map(|sym| *sym);
        let cublasSsymm_v2 = __library.get(b"cublasSsymm_v2\0").map(|sym| *sym);
        let cublasSsymm_v2_64 = __library.get(b"cublasSsymm_v2_64\0").map(|sym| *sym);
        let cublasDsymm_v2 = __library.get(b"cublasDsymm_v2\0").map(|sym| *sym);
        let cublasDsymm_v2_64 = __library.get(b"cublasDsymm_v2_64\0").map(|sym| *sym);
        let cublasCsymm_v2 = __library.get(b"cublasCsymm_v2\0").map(|sym| *sym);
        let cublasCsymm_v2_64 = __library.get(b"cublasCsymm_v2_64\0").map(|sym| *sym);
        let cublasZsymm_v2 = __library.get(b"cublasZsymm_v2\0").map(|sym| *sym);
        let cublasZsymm_v2_64 = __library.get(b"cublasZsymm_v2_64\0").map(|sym| *sym);
        let cublasChemm_v2 = __library.get(b"cublasChemm_v2\0").map(|sym| *sym);
        let cublasChemm_v2_64 = __library.get(b"cublasChemm_v2_64\0").map(|sym| *sym);
        let cublasZhemm_v2 = __library.get(b"cublasZhemm_v2\0").map(|sym| *sym);
        let cublasZhemm_v2_64 = __library.get(b"cublasZhemm_v2_64\0").map(|sym| *sym);
        let cublasStrsm_v2 = __library.get(b"cublasStrsm_v2\0").map(|sym| *sym);
        let cublasStrsm_v2_64 = __library.get(b"cublasStrsm_v2_64\0").map(|sym| *sym);
        let cublasDtrsm_v2 = __library.get(b"cublasDtrsm_v2\0").map(|sym| *sym);
        let cublasDtrsm_v2_64 = __library.get(b"cublasDtrsm_v2_64\0").map(|sym| *sym);
        let cublasCtrsm_v2 = __library.get(b"cublasCtrsm_v2\0").map(|sym| *sym);
        let cublasCtrsm_v2_64 = __library.get(b"cublasCtrsm_v2_64\0").map(|sym| *sym);
        let cublasZtrsm_v2 = __library.get(b"cublasZtrsm_v2\0").map(|sym| *sym);
        let cublasZtrsm_v2_64 = __library.get(b"cublasZtrsm_v2_64\0").map(|sym| *sym);
        let cublasStrmm_v2 = __library.get(b"cublasStrmm_v2\0").map(|sym| *sym);
        let cublasStrmm_v2_64 = __library.get(b"cublasStrmm_v2_64\0").map(|sym| *sym);
        let cublasDtrmm_v2 = __library.get(b"cublasDtrmm_v2\0").map(|sym| *sym);
        let cublasDtrmm_v2_64 = __library.get(b"cublasDtrmm_v2_64\0").map(|sym| *sym);
        let cublasCtrmm_v2 = __library.get(b"cublasCtrmm_v2\0").map(|sym| *sym);
        let cublasCtrmm_v2_64 = __library.get(b"cublasCtrmm_v2_64\0").map(|sym| *sym);
        let cublasZtrmm_v2 = __library.get(b"cublasZtrmm_v2\0").map(|sym| *sym);
        let cublasZtrmm_v2_64 = __library.get(b"cublasZtrmm_v2_64\0").map(|sym| *sym);
        let cublasSgemmBatched = __library.get(b"cublasSgemmBatched\0").map(|sym| *sym);
        let cublasSgemmBatched_64 = __library.get(b"cublasSgemmBatched_64\0").map(|sym| *sym);
        let cublasDgemmBatched = __library.get(b"cublasDgemmBatched\0").map(|sym| *sym);
        let cublasDgemmBatched_64 = __library.get(b"cublasDgemmBatched_64\0").map(|sym| *sym);
        let cublasCgemmBatched = __library.get(b"cublasCgemmBatched\0").map(|sym| *sym);
        let cublasCgemmBatched_64 = __library.get(b"cublasCgemmBatched_64\0").map(|sym| *sym);
        let cublasCgemm3mBatched = __library.get(b"cublasCgemm3mBatched\0").map(|sym| *sym);
        let cublasCgemm3mBatched_64 = __library.get(b"cublasCgemm3mBatched_64\0").map(|sym| *sym);
        let cublasZgemmBatched = __library.get(b"cublasZgemmBatched\0").map(|sym| *sym);
        let cublasZgemmBatched_64 = __library.get(b"cublasZgemmBatched_64\0").map(|sym| *sym);
        let cublasSgemmStridedBatched = __library
            .get(b"cublasSgemmStridedBatched\0")
            .map(|sym| *sym);
        let cublasSgemmStridedBatched_64 = __library
            .get(b"cublasSgemmStridedBatched_64\0")
            .map(|sym| *sym);
        let cublasDgemmStridedBatched = __library
            .get(b"cublasDgemmStridedBatched\0")
            .map(|sym| *sym);
        let cublasDgemmStridedBatched_64 = __library
            .get(b"cublasDgemmStridedBatched_64\0")
            .map(|sym| *sym);
        let cublasCgemmStridedBatched = __library
            .get(b"cublasCgemmStridedBatched\0")
            .map(|sym| *sym);
        let cublasCgemmStridedBatched_64 = __library
            .get(b"cublasCgemmStridedBatched_64\0")
            .map(|sym| *sym);
        let cublasCgemm3mStridedBatched = __library
            .get(b"cublasCgemm3mStridedBatched\0")
            .map(|sym| *sym);
        let cublasCgemm3mStridedBatched_64 = __library
            .get(b"cublasCgemm3mStridedBatched_64\0")
            .map(|sym| *sym);
        let cublasZgemmStridedBatched = __library
            .get(b"cublasZgemmStridedBatched\0")
            .map(|sym| *sym);
        let cublasZgemmStridedBatched_64 = __library
            .get(b"cublasZgemmStridedBatched_64\0")
            .map(|sym| *sym);
        let cublasGemmBatchedEx = __library.get(b"cublasGemmBatchedEx\0").map(|sym| *sym);
        let cublasGemmBatchedEx_64 = __library.get(b"cublasGemmBatchedEx_64\0").map(|sym| *sym);
        let cublasGemmStridedBatchedEx = __library
            .get(b"cublasGemmStridedBatchedEx\0")
            .map(|sym| *sym);
        let cublasGemmStridedBatchedEx_64 = __library
            .get(b"cublasGemmStridedBatchedEx_64\0")
            .map(|sym| *sym);
        let cublasSgeam = __library.get(b"cublasSgeam\0").map(|sym| *sym);
        let cublasSgeam_64 = __library.get(b"cublasSgeam_64\0").map(|sym| *sym);
        let cublasDgeam = __library.get(b"cublasDgeam\0").map(|sym| *sym);
        let cublasDgeam_64 = __library.get(b"cublasDgeam_64\0").map(|sym| *sym);
        let cublasCgeam = __library.get(b"cublasCgeam\0").map(|sym| *sym);
        let cublasCgeam_64 = __library.get(b"cublasCgeam_64\0").map(|sym| *sym);
        let cublasZgeam = __library.get(b"cublasZgeam\0").map(|sym| *sym);
        let cublasZgeam_64 = __library.get(b"cublasZgeam_64\0").map(|sym| *sym);
        let cublasStrsmBatched = __library.get(b"cublasStrsmBatched\0").map(|sym| *sym);
        let cublasStrsmBatched_64 = __library.get(b"cublasStrsmBatched_64\0").map(|sym| *sym);
        let cublasDtrsmBatched = __library.get(b"cublasDtrsmBatched\0").map(|sym| *sym);
        let cublasDtrsmBatched_64 = __library.get(b"cublasDtrsmBatched_64\0").map(|sym| *sym);
        let cublasCtrsmBatched = __library.get(b"cublasCtrsmBatched\0").map(|sym| *sym);
        let cublasCtrsmBatched_64 = __library.get(b"cublasCtrsmBatched_64\0").map(|sym| *sym);
        let cublasZtrsmBatched = __library.get(b"cublasZtrsmBatched\0").map(|sym| *sym);
        let cublasZtrsmBatched_64 = __library.get(b"cublasZtrsmBatched_64\0").map(|sym| *sym);
        let cublasSdgmm = __library.get(b"cublasSdgmm\0").map(|sym| *sym);
        let cublasSdgmm_64 = __library.get(b"cublasSdgmm_64\0").map(|sym| *sym);
        let cublasDdgmm = __library.get(b"cublasDdgmm\0").map(|sym| *sym);
        let cublasDdgmm_64 = __library.get(b"cublasDdgmm_64\0").map(|sym| *sym);
        let cublasCdgmm = __library.get(b"cublasCdgmm\0").map(|sym| *sym);
        let cublasCdgmm_64 = __library.get(b"cublasCdgmm_64\0").map(|sym| *sym);
        let cublasZdgmm = __library.get(b"cublasZdgmm\0").map(|sym| *sym);
        let cublasZdgmm_64 = __library.get(b"cublasZdgmm_64\0").map(|sym| *sym);
        let cublasSmatinvBatched = __library.get(b"cublasSmatinvBatched\0").map(|sym| *sym);
        let cublasDmatinvBatched = __library.get(b"cublasDmatinvBatched\0").map(|sym| *sym);
        let cublasCmatinvBatched = __library.get(b"cublasCmatinvBatched\0").map(|sym| *sym);
        let cublasZmatinvBatched = __library.get(b"cublasZmatinvBatched\0").map(|sym| *sym);
        let cublasSgeqrfBatched = __library.get(b"cublasSgeqrfBatched\0").map(|sym| *sym);
        let cublasDgeqrfBatched = __library.get(b"cublasDgeqrfBatched\0").map(|sym| *sym);
        let cublasCgeqrfBatched = __library.get(b"cublasCgeqrfBatched\0").map(|sym| *sym);
        let cublasZgeqrfBatched = __library.get(b"cublasZgeqrfBatched\0").map(|sym| *sym);
        let cublasSgelsBatched = __library.get(b"cublasSgelsBatched\0").map(|sym| *sym);
        let cublasDgelsBatched = __library.get(b"cublasDgelsBatched\0").map(|sym| *sym);
        let cublasCgelsBatched = __library.get(b"cublasCgelsBatched\0").map(|sym| *sym);
        let cublasZgelsBatched = __library.get(b"cublasZgelsBatched\0").map(|sym| *sym);
        let cublasStpttr = __library.get(b"cublasStpttr\0").map(|sym| *sym);
        let cublasDtpttr = __library.get(b"cublasDtpttr\0").map(|sym| *sym);
        let cublasCtpttr = __library.get(b"cublasCtpttr\0").map(|sym| *sym);
        let cublasZtpttr = __library.get(b"cublasZtpttr\0").map(|sym| *sym);
        let cublasStrttp = __library.get(b"cublasStrttp\0").map(|sym| *sym);
        let cublasDtrttp = __library.get(b"cublasDtrttp\0").map(|sym| *sym);
        let cublasCtrttp = __library.get(b"cublasCtrttp\0").map(|sym| *sym);
        let cublasZtrttp = __library.get(b"cublasZtrttp\0").map(|sym| *sym);
        let cublasSgetrfBatched = __library.get(b"cublasSgetrfBatched\0").map(|sym| *sym);
        let cublasDgetrfBatched = __library.get(b"cublasDgetrfBatched\0").map(|sym| *sym);
        let cublasCgetrfBatched = __library.get(b"cublasCgetrfBatched\0").map(|sym| *sym);
        let cublasZgetrfBatched = __library.get(b"cublasZgetrfBatched\0").map(|sym| *sym);
        let cublasSgetriBatched = __library.get(b"cublasSgetriBatched\0").map(|sym| *sym);
        let cublasDgetriBatched = __library.get(b"cublasDgetriBatched\0").map(|sym| *sym);
        let cublasCgetriBatched = __library.get(b"cublasCgetriBatched\0").map(|sym| *sym);
        let cublasZgetriBatched = __library.get(b"cublasZgetriBatched\0").map(|sym| *sym);
        let cublasSgetrsBatched = __library.get(b"cublasSgetrsBatched\0").map(|sym| *sym);
        let cublasDgetrsBatched = __library.get(b"cublasDgetrsBatched\0").map(|sym| *sym);
        let cublasCgetrsBatched = __library.get(b"cublasCgetrsBatched\0").map(|sym| *sym);
        let cublasZgetrsBatched = __library.get(b"cublasZgetrsBatched\0").map(|sym| *sym);
        let cublasUint8gemmBias = __library.get(b"cublasUint8gemmBias\0").map(|sym| *sym);
        Ok(Lib {
            __library,
            cublasCreate_v2,
            cublasDestroy_v2,
            cublasGetVersion_v2,
            cublasGetProperty,
            cublasGetCudartVersion,
            cublasSetWorkspace_v2,
            cublasSetStream_v2,
            cublasGetStream_v2,
            cublasGetPointerMode_v2,
            cublasSetPointerMode_v2,
            cublasGetAtomicsMode,
            cublasSetAtomicsMode,
            cublasGetMathMode,
            cublasSetMathMode,
            cublasGetSmCountTarget,
            cublasSetSmCountTarget,
            cublasGetStatusName,
            cublasGetStatusString,
            cublasLoggerConfigure,
            cublasSetLoggerCallback,
            cublasGetLoggerCallback,
            cublasSetVector,
            cublasSetVector_64,
            cublasGetVector,
            cublasGetVector_64,
            cublasSetMatrix,
            cublasSetMatrix_64,
            cublasGetMatrix,
            cublasGetMatrix_64,
            cublasSetVectorAsync,
            cublasSetVectorAsync_64,
            cublasGetVectorAsync,
            cublasGetVectorAsync_64,
            cublasSetMatrixAsync,
            cublasSetMatrixAsync_64,
            cublasGetMatrixAsync,
            cublasGetMatrixAsync_64,
            cublasXerbla,
            cublasNrm2Ex,
            cublasNrm2Ex_64,
            cublasSnrm2_v2,
            cublasSnrm2_v2_64,
            cublasDnrm2_v2,
            cublasDnrm2_v2_64,
            cublasScnrm2_v2,
            cublasScnrm2_v2_64,
            cublasDznrm2_v2,
            cublasDznrm2_v2_64,
            cublasDotEx,
            cublasDotEx_64,
            cublasDotcEx,
            cublasDotcEx_64,
            cublasSdot_v2,
            cublasSdot_v2_64,
            cublasDdot_v2,
            cublasDdot_v2_64,
            cublasCdotu_v2,
            cublasCdotu_v2_64,
            cublasCdotc_v2,
            cublasCdotc_v2_64,
            cublasZdotu_v2,
            cublasZdotu_v2_64,
            cublasZdotc_v2,
            cublasZdotc_v2_64,
            cublasScalEx,
            cublasScalEx_64,
            cublasSscal_v2,
            cublasSscal_v2_64,
            cublasDscal_v2,
            cublasDscal_v2_64,
            cublasCscal_v2,
            cublasCscal_v2_64,
            cublasCsscal_v2,
            cublasCsscal_v2_64,
            cublasZscal_v2,
            cublasZscal_v2_64,
            cublasZdscal_v2,
            cublasZdscal_v2_64,
            cublasAxpyEx,
            cublasAxpyEx_64,
            cublasSaxpy_v2,
            cublasSaxpy_v2_64,
            cublasDaxpy_v2,
            cublasDaxpy_v2_64,
            cublasCaxpy_v2,
            cublasCaxpy_v2_64,
            cublasZaxpy_v2,
            cublasZaxpy_v2_64,
            cublasCopyEx,
            cublasCopyEx_64,
            cublasScopy_v2,
            cublasScopy_v2_64,
            cublasDcopy_v2,
            cublasDcopy_v2_64,
            cublasCcopy_v2,
            cublasCcopy_v2_64,
            cublasZcopy_v2,
            cublasZcopy_v2_64,
            cublasSswap_v2,
            cublasSswap_v2_64,
            cublasDswap_v2,
            cublasDswap_v2_64,
            cublasCswap_v2,
            cublasCswap_v2_64,
            cublasZswap_v2,
            cublasZswap_v2_64,
            cublasSwapEx,
            cublasSwapEx_64,
            cublasIsamax_v2,
            cublasIsamax_v2_64,
            cublasIdamax_v2,
            cublasIdamax_v2_64,
            cublasIcamax_v2,
            cublasIcamax_v2_64,
            cublasIzamax_v2,
            cublasIzamax_v2_64,
            cublasIamaxEx,
            cublasIamaxEx_64,
            cublasIsamin_v2,
            cublasIsamin_v2_64,
            cublasIdamin_v2,
            cublasIdamin_v2_64,
            cublasIcamin_v2,
            cublasIcamin_v2_64,
            cublasIzamin_v2,
            cublasIzamin_v2_64,
            cublasIaminEx,
            cublasIaminEx_64,
            cublasAsumEx,
            cublasAsumEx_64,
            cublasSasum_v2,
            cublasSasum_v2_64,
            cublasDasum_v2,
            cublasDasum_v2_64,
            cublasScasum_v2,
            cublasScasum_v2_64,
            cublasDzasum_v2,
            cublasDzasum_v2_64,
            cublasSrot_v2,
            cublasSrot_v2_64,
            cublasDrot_v2,
            cublasDrot_v2_64,
            cublasCrot_v2,
            cublasCrot_v2_64,
            cublasCsrot_v2,
            cublasCsrot_v2_64,
            cublasZrot_v2,
            cublasZrot_v2_64,
            cublasZdrot_v2,
            cublasZdrot_v2_64,
            cublasRotEx,
            cublasRotEx_64,
            cublasSrotg_v2,
            cublasDrotg_v2,
            cublasCrotg_v2,
            cublasZrotg_v2,
            cublasRotgEx,
            cublasSrotm_v2,
            cublasSrotm_v2_64,
            cublasDrotm_v2,
            cublasDrotm_v2_64,
            cublasRotmEx,
            cublasRotmEx_64,
            cublasSrotmg_v2,
            cublasDrotmg_v2,
            cublasRotmgEx,
            cublasSgemv_v2,
            cublasSgemv_v2_64,
            cublasDgemv_v2,
            cublasDgemv_v2_64,
            cublasCgemv_v2,
            cublasCgemv_v2_64,
            cublasZgemv_v2,
            cublasZgemv_v2_64,
            cublasSgbmv_v2,
            cublasSgbmv_v2_64,
            cublasDgbmv_v2,
            cublasDgbmv_v2_64,
            cublasCgbmv_v2,
            cublasCgbmv_v2_64,
            cublasZgbmv_v2,
            cublasZgbmv_v2_64,
            cublasStrmv_v2,
            cublasStrmv_v2_64,
            cublasDtrmv_v2,
            cublasDtrmv_v2_64,
            cublasCtrmv_v2,
            cublasCtrmv_v2_64,
            cublasZtrmv_v2,
            cublasZtrmv_v2_64,
            cublasStbmv_v2,
            cublasStbmv_v2_64,
            cublasDtbmv_v2,
            cublasDtbmv_v2_64,
            cublasCtbmv_v2,
            cublasCtbmv_v2_64,
            cublasZtbmv_v2,
            cublasZtbmv_v2_64,
            cublasStpmv_v2,
            cublasStpmv_v2_64,
            cublasDtpmv_v2,
            cublasDtpmv_v2_64,
            cublasCtpmv_v2,
            cublasCtpmv_v2_64,
            cublasZtpmv_v2,
            cublasZtpmv_v2_64,
            cublasStrsv_v2,
            cublasStrsv_v2_64,
            cublasDtrsv_v2,
            cublasDtrsv_v2_64,
            cublasCtrsv_v2,
            cublasCtrsv_v2_64,
            cublasZtrsv_v2,
            cublasZtrsv_v2_64,
            cublasStpsv_v2,
            cublasStpsv_v2_64,
            cublasDtpsv_v2,
            cublasDtpsv_v2_64,
            cublasCtpsv_v2,
            cublasCtpsv_v2_64,
            cublasZtpsv_v2,
            cublasZtpsv_v2_64,
            cublasStbsv_v2,
            cublasStbsv_v2_64,
            cublasDtbsv_v2,
            cublasDtbsv_v2_64,
            cublasCtbsv_v2,
            cublasCtbsv_v2_64,
            cublasZtbsv_v2,
            cublasZtbsv_v2_64,
            cublasSsymv_v2,
            cublasSsymv_v2_64,
            cublasDsymv_v2,
            cublasDsymv_v2_64,
            cublasCsymv_v2,
            cublasCsymv_v2_64,
            cublasZsymv_v2,
            cublasZsymv_v2_64,
            cublasChemv_v2,
            cublasChemv_v2_64,
            cublasZhemv_v2,
            cublasZhemv_v2_64,
            cublasSsbmv_v2,
            cublasSsbmv_v2_64,
            cublasDsbmv_v2,
            cublasDsbmv_v2_64,
            cublasChbmv_v2,
            cublasChbmv_v2_64,
            cublasZhbmv_v2,
            cublasZhbmv_v2_64,
            cublasSspmv_v2,
            cublasSspmv_v2_64,
            cublasDspmv_v2,
            cublasDspmv_v2_64,
            cublasChpmv_v2,
            cublasChpmv_v2_64,
            cublasZhpmv_v2,
            cublasZhpmv_v2_64,
            cublasSger_v2,
            cublasSger_v2_64,
            cublasDger_v2,
            cublasDger_v2_64,
            cublasCgeru_v2,
            cublasCgeru_v2_64,
            cublasCgerc_v2,
            cublasCgerc_v2_64,
            cublasZgeru_v2,
            cublasZgeru_v2_64,
            cublasZgerc_v2,
            cublasZgerc_v2_64,
            cublasSsyr_v2,
            cublasSsyr_v2_64,
            cublasDsyr_v2,
            cublasDsyr_v2_64,
            cublasCsyr_v2,
            cublasCsyr_v2_64,
            cublasZsyr_v2,
            cublasZsyr_v2_64,
            cublasCher_v2,
            cublasCher_v2_64,
            cublasZher_v2,
            cublasZher_v2_64,
            cublasSspr_v2,
            cublasSspr_v2_64,
            cublasDspr_v2,
            cublasDspr_v2_64,
            cublasChpr_v2,
            cublasChpr_v2_64,
            cublasZhpr_v2,
            cublasZhpr_v2_64,
            cublasSsyr2_v2,
            cublasSsyr2_v2_64,
            cublasDsyr2_v2,
            cublasDsyr2_v2_64,
            cublasCsyr2_v2,
            cublasCsyr2_v2_64,
            cublasZsyr2_v2,
            cublasZsyr2_v2_64,
            cublasCher2_v2,
            cublasCher2_v2_64,
            cublasZher2_v2,
            cublasZher2_v2_64,
            cublasSspr2_v2,
            cublasSspr2_v2_64,
            cublasDspr2_v2,
            cublasDspr2_v2_64,
            cublasChpr2_v2,
            cublasChpr2_v2_64,
            cublasZhpr2_v2,
            cublasZhpr2_v2_64,
            cublasSgemvBatched,
            cublasSgemvBatched_64,
            cublasDgemvBatched,
            cublasDgemvBatched_64,
            cublasCgemvBatched,
            cublasCgemvBatched_64,
            cublasZgemvBatched,
            cublasZgemvBatched_64,
            cublasSgemvStridedBatched,
            cublasSgemvStridedBatched_64,
            cublasDgemvStridedBatched,
            cublasDgemvStridedBatched_64,
            cublasCgemvStridedBatched,
            cublasCgemvStridedBatched_64,
            cublasZgemvStridedBatched,
            cublasZgemvStridedBatched_64,
            cublasSgemm_v2,
            cublasSgemm_v2_64,
            cublasDgemm_v2,
            cublasDgemm_v2_64,
            cublasCgemm_v2,
            cublasCgemm_v2_64,
            cublasCgemm3m,
            cublasCgemm3m_64,
            cublasCgemm3mEx,
            cublasCgemm3mEx_64,
            cublasZgemm_v2,
            cublasZgemm_v2_64,
            cublasZgemm3m,
            cublasZgemm3m_64,
            cublasSgemmEx,
            cublasSgemmEx_64,
            cublasGemmEx,
            cublasGemmEx_64,
            cublasCgemmEx,
            cublasCgemmEx_64,
            cublasSsyrk_v2,
            cublasSsyrk_v2_64,
            cublasDsyrk_v2,
            cublasDsyrk_v2_64,
            cublasCsyrk_v2,
            cublasCsyrk_v2_64,
            cublasZsyrk_v2,
            cublasZsyrk_v2_64,
            cublasCsyrkEx,
            cublasCsyrkEx_64,
            cublasCsyrk3mEx,
            cublasCsyrk3mEx_64,
            cublasCherk_v2,
            cublasCherk_v2_64,
            cublasZherk_v2,
            cublasZherk_v2_64,
            cublasCherkEx,
            cublasCherkEx_64,
            cublasCherk3mEx,
            cublasCherk3mEx_64,
            cublasSsyr2k_v2,
            cublasSsyr2k_v2_64,
            cublasDsyr2k_v2,
            cublasDsyr2k_v2_64,
            cublasCsyr2k_v2,
            cublasCsyr2k_v2_64,
            cublasZsyr2k_v2,
            cublasZsyr2k_v2_64,
            cublasCher2k_v2,
            cublasCher2k_v2_64,
            cublasZher2k_v2,
            cublasZher2k_v2_64,
            cublasSsyrkx,
            cublasSsyrkx_64,
            cublasDsyrkx,
            cublasDsyrkx_64,
            cublasCsyrkx,
            cublasCsyrkx_64,
            cublasZsyrkx,
            cublasZsyrkx_64,
            cublasCherkx,
            cublasCherkx_64,
            cublasZherkx,
            cublasZherkx_64,
            cublasSsymm_v2,
            cublasSsymm_v2_64,
            cublasDsymm_v2,
            cublasDsymm_v2_64,
            cublasCsymm_v2,
            cublasCsymm_v2_64,
            cublasZsymm_v2,
            cublasZsymm_v2_64,
            cublasChemm_v2,
            cublasChemm_v2_64,
            cublasZhemm_v2,
            cublasZhemm_v2_64,
            cublasStrsm_v2,
            cublasStrsm_v2_64,
            cublasDtrsm_v2,
            cublasDtrsm_v2_64,
            cublasCtrsm_v2,
            cublasCtrsm_v2_64,
            cublasZtrsm_v2,
            cublasZtrsm_v2_64,
            cublasStrmm_v2,
            cublasStrmm_v2_64,
            cublasDtrmm_v2,
            cublasDtrmm_v2_64,
            cublasCtrmm_v2,
            cublasCtrmm_v2_64,
            cublasZtrmm_v2,
            cublasZtrmm_v2_64,
            cublasSgemmBatched,
            cublasSgemmBatched_64,
            cublasDgemmBatched,
            cublasDgemmBatched_64,
            cublasCgemmBatched,
            cublasCgemmBatched_64,
            cublasCgemm3mBatched,
            cublasCgemm3mBatched_64,
            cublasZgemmBatched,
            cublasZgemmBatched_64,
            cublasSgemmStridedBatched,
            cublasSgemmStridedBatched_64,
            cublasDgemmStridedBatched,
            cublasDgemmStridedBatched_64,
            cublasCgemmStridedBatched,
            cublasCgemmStridedBatched_64,
            cublasCgemm3mStridedBatched,
            cublasCgemm3mStridedBatched_64,
            cublasZgemmStridedBatched,
            cublasZgemmStridedBatched_64,
            cublasGemmBatchedEx,
            cublasGemmBatchedEx_64,
            cublasGemmStridedBatchedEx,
            cublasGemmStridedBatchedEx_64,
            cublasSgeam,
            cublasSgeam_64,
            cublasDgeam,
            cublasDgeam_64,
            cublasCgeam,
            cublasCgeam_64,
            cublasZgeam,
            cublasZgeam_64,
            cublasStrsmBatched,
            cublasStrsmBatched_64,
            cublasDtrsmBatched,
            cublasDtrsmBatched_64,
            cublasCtrsmBatched,
            cublasCtrsmBatched_64,
            cublasZtrsmBatched,
            cublasZtrsmBatched_64,
            cublasSdgmm,
            cublasSdgmm_64,
            cublasDdgmm,
            cublasDdgmm_64,
            cublasCdgmm,
            cublasCdgmm_64,
            cublasZdgmm,
            cublasZdgmm_64,
            cublasSmatinvBatched,
            cublasDmatinvBatched,
            cublasCmatinvBatched,
            cublasZmatinvBatched,
            cublasSgeqrfBatched,
            cublasDgeqrfBatched,
            cublasCgeqrfBatched,
            cublasZgeqrfBatched,
            cublasSgelsBatched,
            cublasDgelsBatched,
            cublasCgelsBatched,
            cublasZgelsBatched,
            cublasStpttr,
            cublasDtpttr,
            cublasCtpttr,
            cublasZtpttr,
            cublasStrttp,
            cublasDtrttp,
            cublasCtrttp,
            cublasZtrttp,
            cublasSgetrfBatched,
            cublasDgetrfBatched,
            cublasCgetrfBatched,
            cublasZgetrfBatched,
            cublasSgetriBatched,
            cublasDgetriBatched,
            cublasCgetriBatched,
            cublasZgetriBatched,
            cublasSgetrsBatched,
            cublasDgetrsBatched,
            cublasCgetrsBatched,
            cublasZgetrsBatched,
            cublasUint8gemmBias,
        })
    }
    pub unsafe fn cublasCreate_v2(&self, handle: *mut cublasHandle_t) -> cublasStatus_t {
        (self
            .cublasCreate_v2
            .as_ref()
            .expect("Expected function, got error."))(handle)
    }
    pub unsafe fn cublasDestroy_v2(&self, handle: cublasHandle_t) -> cublasStatus_t {
        (self
            .cublasDestroy_v2
            .as_ref()
            .expect("Expected function, got error."))(handle)
    }
    pub unsafe fn cublasGetVersion_v2(
        &self,
        handle: cublasHandle_t,
        version: *mut ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasGetVersion_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, version)
    }
    pub unsafe fn cublasGetProperty(
        &self,
        type_: libraryPropertyType,
        value: *mut ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasGetProperty
            .as_ref()
            .expect("Expected function, got error."))(type_, value)
    }
    pub unsafe fn cublasGetCudartVersion(&self) -> usize {
        (self
            .cublasGetCudartVersion
            .as_ref()
            .expect("Expected function, got error."))()
    }
    pub unsafe fn cublasSetWorkspace_v2(
        &self,
        handle: cublasHandle_t,
        workspace: *mut ::core::ffi::c_void,
        workspaceSizeInBytes: usize,
    ) -> cublasStatus_t {
        (self
            .cublasSetWorkspace_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, workspace, workspaceSizeInBytes
        )
    }
    pub unsafe fn cublasSetStream_v2(
        &self,
        handle: cublasHandle_t,
        streamId: cudaStream_t,
    ) -> cublasStatus_t {
        (self
            .cublasSetStream_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, streamId)
    }
    pub unsafe fn cublasGetStream_v2(
        &self,
        handle: cublasHandle_t,
        streamId: *mut cudaStream_t,
    ) -> cublasStatus_t {
        (self
            .cublasGetStream_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, streamId)
    }
    pub unsafe fn cublasGetPointerMode_v2(
        &self,
        handle: cublasHandle_t,
        mode: *mut cublasPointerMode_t,
    ) -> cublasStatus_t {
        (self
            .cublasGetPointerMode_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, mode)
    }
    pub unsafe fn cublasSetPointerMode_v2(
        &self,
        handle: cublasHandle_t,
        mode: cublasPointerMode_t,
    ) -> cublasStatus_t {
        (self
            .cublasSetPointerMode_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, mode)
    }
    pub unsafe fn cublasGetAtomicsMode(
        &self,
        handle: cublasHandle_t,
        mode: *mut cublasAtomicsMode_t,
    ) -> cublasStatus_t {
        (self
            .cublasGetAtomicsMode
            .as_ref()
            .expect("Expected function, got error."))(handle, mode)
    }
    pub unsafe fn cublasSetAtomicsMode(
        &self,
        handle: cublasHandle_t,
        mode: cublasAtomicsMode_t,
    ) -> cublasStatus_t {
        (self
            .cublasSetAtomicsMode
            .as_ref()
            .expect("Expected function, got error."))(handle, mode)
    }
    pub unsafe fn cublasGetMathMode(
        &self,
        handle: cublasHandle_t,
        mode: *mut cublasMath_t,
    ) -> cublasStatus_t {
        (self
            .cublasGetMathMode
            .as_ref()
            .expect("Expected function, got error."))(handle, mode)
    }
    pub unsafe fn cublasSetMathMode(
        &self,
        handle: cublasHandle_t,
        mode: cublasMath_t,
    ) -> cublasStatus_t {
        (self
            .cublasSetMathMode
            .as_ref()
            .expect("Expected function, got error."))(handle, mode)
    }
    pub unsafe fn cublasGetSmCountTarget(
        &self,
        handle: cublasHandle_t,
        smCountTarget: *mut ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasGetSmCountTarget
            .as_ref()
            .expect("Expected function, got error."))(handle, smCountTarget)
    }
    pub unsafe fn cublasSetSmCountTarget(
        &self,
        handle: cublasHandle_t,
        smCountTarget: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasSetSmCountTarget
            .as_ref()
            .expect("Expected function, got error."))(handle, smCountTarget)
    }
    pub unsafe fn cublasGetStatusName(&self, status: cublasStatus_t) -> *const ::core::ffi::c_char {
        (self
            .cublasGetStatusName
            .as_ref()
            .expect("Expected function, got error."))(status)
    }
    pub unsafe fn cublasGetStatusString(
        &self,
        status: cublasStatus_t,
    ) -> *const ::core::ffi::c_char {
        (self
            .cublasGetStatusString
            .as_ref()
            .expect("Expected function, got error."))(status)
    }
    pub unsafe fn cublasLoggerConfigure(
        &self,
        logIsOn: ::core::ffi::c_int,
        logToStdOut: ::core::ffi::c_int,
        logToStdErr: ::core::ffi::c_int,
        logFileName: *const ::core::ffi::c_char,
    ) -> cublasStatus_t {
        (self
            .cublasLoggerConfigure
            .as_ref()
            .expect("Expected function, got error."))(
            logIsOn,
            logToStdOut,
            logToStdErr,
            logFileName,
        )
    }
    pub unsafe fn cublasSetLoggerCallback(
        &self,
        userCallback: cublasLogCallback,
    ) -> cublasStatus_t {
        (self
            .cublasSetLoggerCallback
            .as_ref()
            .expect("Expected function, got error."))(userCallback)
    }
    pub unsafe fn cublasGetLoggerCallback(
        &self,
        userCallback: *mut cublasLogCallback,
    ) -> cublasStatus_t {
        (self
            .cublasGetLoggerCallback
            .as_ref()
            .expect("Expected function, got error."))(userCallback)
    }
    pub unsafe fn cublasSetVector(
        &self,
        n: ::core::ffi::c_int,
        elemSize: ::core::ffi::c_int,
        x: *const ::core::ffi::c_void,
        incx: ::core::ffi::c_int,
        devicePtr: *mut ::core::ffi::c_void,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasSetVector
            .as_ref()
            .expect("Expected function, got error."))(n, elemSize, x, incx, devicePtr, incy)
    }
    pub unsafe fn cublasSetVector_64(
        &self,
        n: i64,
        elemSize: i64,
        x: *const ::core::ffi::c_void,
        incx: i64,
        devicePtr: *mut ::core::ffi::c_void,
        incy: i64,
    ) -> cublasStatus_t {
        (self
            .cublasSetVector_64
            .as_ref()
            .expect("Expected function, got error."))(n, elemSize, x, incx, devicePtr, incy)
    }
    pub unsafe fn cublasGetVector(
        &self,
        n: ::core::ffi::c_int,
        elemSize: ::core::ffi::c_int,
        x: *const ::core::ffi::c_void,
        incx: ::core::ffi::c_int,
        y: *mut ::core::ffi::c_void,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasGetVector
            .as_ref()
            .expect("Expected function, got error."))(n, elemSize, x, incx, y, incy)
    }
    pub unsafe fn cublasGetVector_64(
        &self,
        n: i64,
        elemSize: i64,
        x: *const ::core::ffi::c_void,
        incx: i64,
        y: *mut ::core::ffi::c_void,
        incy: i64,
    ) -> cublasStatus_t {
        (self
            .cublasGetVector_64
            .as_ref()
            .expect("Expected function, got error."))(n, elemSize, x, incx, y, incy)
    }
    pub unsafe fn cublasSetMatrix(
        &self,
        rows: ::core::ffi::c_int,
        cols: ::core::ffi::c_int,
        elemSize: ::core::ffi::c_int,
        A: *const ::core::ffi::c_void,
        lda: ::core::ffi::c_int,
        B: *mut ::core::ffi::c_void,
        ldb: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasSetMatrix
            .as_ref()
            .expect("Expected function, got error."))(rows, cols, elemSize, A, lda, B, ldb)
    }
    pub unsafe fn cublasSetMatrix_64(
        &self,
        rows: i64,
        cols: i64,
        elemSize: i64,
        A: *const ::core::ffi::c_void,
        lda: i64,
        B: *mut ::core::ffi::c_void,
        ldb: i64,
    ) -> cublasStatus_t {
        (self
            .cublasSetMatrix_64
            .as_ref()
            .expect("Expected function, got error."))(rows, cols, elemSize, A, lda, B, ldb)
    }
    pub unsafe fn cublasGetMatrix(
        &self,
        rows: ::core::ffi::c_int,
        cols: ::core::ffi::c_int,
        elemSize: ::core::ffi::c_int,
        A: *const ::core::ffi::c_void,
        lda: ::core::ffi::c_int,
        B: *mut ::core::ffi::c_void,
        ldb: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasGetMatrix
            .as_ref()
            .expect("Expected function, got error."))(rows, cols, elemSize, A, lda, B, ldb)
    }
    pub unsafe fn cublasGetMatrix_64(
        &self,
        rows: i64,
        cols: i64,
        elemSize: i64,
        A: *const ::core::ffi::c_void,
        lda: i64,
        B: *mut ::core::ffi::c_void,
        ldb: i64,
    ) -> cublasStatus_t {
        (self
            .cublasGetMatrix_64
            .as_ref()
            .expect("Expected function, got error."))(rows, cols, elemSize, A, lda, B, ldb)
    }
    pub unsafe fn cublasSetVectorAsync(
        &self,
        n: ::core::ffi::c_int,
        elemSize: ::core::ffi::c_int,
        hostPtr: *const ::core::ffi::c_void,
        incx: ::core::ffi::c_int,
        devicePtr: *mut ::core::ffi::c_void,
        incy: ::core::ffi::c_int,
        stream: cudaStream_t,
    ) -> cublasStatus_t {
        (self
            .cublasSetVectorAsync
            .as_ref()
            .expect("Expected function, got error."))(
            n, elemSize, hostPtr, incx, devicePtr, incy, stream,
        )
    }
    pub unsafe fn cublasSetVectorAsync_64(
        &self,
        n: i64,
        elemSize: i64,
        hostPtr: *const ::core::ffi::c_void,
        incx: i64,
        devicePtr: *mut ::core::ffi::c_void,
        incy: i64,
        stream: cudaStream_t,
    ) -> cublasStatus_t {
        (self
            .cublasSetVectorAsync_64
            .as_ref()
            .expect("Expected function, got error."))(
            n, elemSize, hostPtr, incx, devicePtr, incy, stream,
        )
    }
    pub unsafe fn cublasGetVectorAsync(
        &self,
        n: ::core::ffi::c_int,
        elemSize: ::core::ffi::c_int,
        devicePtr: *const ::core::ffi::c_void,
        incx: ::core::ffi::c_int,
        hostPtr: *mut ::core::ffi::c_void,
        incy: ::core::ffi::c_int,
        stream: cudaStream_t,
    ) -> cublasStatus_t {
        (self
            .cublasGetVectorAsync
            .as_ref()
            .expect("Expected function, got error."))(
            n, elemSize, devicePtr, incx, hostPtr, incy, stream,
        )
    }
    pub unsafe fn cublasGetVectorAsync_64(
        &self,
        n: i64,
        elemSize: i64,
        devicePtr: *const ::core::ffi::c_void,
        incx: i64,
        hostPtr: *mut ::core::ffi::c_void,
        incy: i64,
        stream: cudaStream_t,
    ) -> cublasStatus_t {
        (self
            .cublasGetVectorAsync_64
            .as_ref()
            .expect("Expected function, got error."))(
            n, elemSize, devicePtr, incx, hostPtr, incy, stream,
        )
    }
    pub unsafe fn cublasSetMatrixAsync(
        &self,
        rows: ::core::ffi::c_int,
        cols: ::core::ffi::c_int,
        elemSize: ::core::ffi::c_int,
        A: *const ::core::ffi::c_void,
        lda: ::core::ffi::c_int,
        B: *mut ::core::ffi::c_void,
        ldb: ::core::ffi::c_int,
        stream: cudaStream_t,
    ) -> cublasStatus_t {
        (self
            .cublasSetMatrixAsync
            .as_ref()
            .expect("Expected function, got error."))(
            rows, cols, elemSize, A, lda, B, ldb, stream
        )
    }
    pub unsafe fn cublasSetMatrixAsync_64(
        &self,
        rows: i64,
        cols: i64,
        elemSize: i64,
        A: *const ::core::ffi::c_void,
        lda: i64,
        B: *mut ::core::ffi::c_void,
        ldb: i64,
        stream: cudaStream_t,
    ) -> cublasStatus_t {
        (self
            .cublasSetMatrixAsync_64
            .as_ref()
            .expect("Expected function, got error."))(
            rows, cols, elemSize, A, lda, B, ldb, stream
        )
    }
    pub unsafe fn cublasGetMatrixAsync(
        &self,
        rows: ::core::ffi::c_int,
        cols: ::core::ffi::c_int,
        elemSize: ::core::ffi::c_int,
        A: *const ::core::ffi::c_void,
        lda: ::core::ffi::c_int,
        B: *mut ::core::ffi::c_void,
        ldb: ::core::ffi::c_int,
        stream: cudaStream_t,
    ) -> cublasStatus_t {
        (self
            .cublasGetMatrixAsync
            .as_ref()
            .expect("Expected function, got error."))(
            rows, cols, elemSize, A, lda, B, ldb, stream
        )
    }
    pub unsafe fn cublasGetMatrixAsync_64(
        &self,
        rows: i64,
        cols: i64,
        elemSize: i64,
        A: *const ::core::ffi::c_void,
        lda: i64,
        B: *mut ::core::ffi::c_void,
        ldb: i64,
        stream: cudaStream_t,
    ) -> cublasStatus_t {
        (self
            .cublasGetMatrixAsync_64
            .as_ref()
            .expect("Expected function, got error."))(
            rows, cols, elemSize, A, lda, B, ldb, stream
        )
    }
    pub unsafe fn cublasXerbla(
        &self,
        srName: *const ::core::ffi::c_char,
        info: ::core::ffi::c_int,
    ) {
        (self
            .cublasXerbla
            .as_ref()
            .expect("Expected function, got error."))(srName, info)
    }
    pub unsafe fn cublasNrm2Ex(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_void,
        resultType: cudaDataType,
        executionType: cudaDataType,
    ) -> cublasStatus_t {
        (self
            .cublasNrm2Ex
            .as_ref()
            .expect("Expected function, got error."))(
            handle,
            n,
            x,
            xType,
            incx,
            result,
            resultType,
            executionType,
        )
    }
    pub unsafe fn cublasNrm2Ex_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: i64,
        result: *mut ::core::ffi::c_void,
        resultType: cudaDataType,
        executionType: cudaDataType,
    ) -> cublasStatus_t {
        (self
            .cublasNrm2Ex_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle,
            n,
            x,
            xType,
            incx,
            result,
            resultType,
            executionType,
        )
    }
    pub unsafe fn cublasSnrm2_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const f32,
        incx: ::core::ffi::c_int,
        result: *mut f32,
    ) -> cublasStatus_t {
        (self
            .cublasSnrm2_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, result)
    }
    pub unsafe fn cublasSnrm2_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *const f32,
        incx: i64,
        result: *mut f32,
    ) -> cublasStatus_t {
        (self
            .cublasSnrm2_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, result)
    }
    pub unsafe fn cublasDnrm2_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const f64,
        incx: ::core::ffi::c_int,
        result: *mut f64,
    ) -> cublasStatus_t {
        (self
            .cublasDnrm2_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, result)
    }
    pub unsafe fn cublasDnrm2_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *const f64,
        incx: i64,
        result: *mut f64,
    ) -> cublasStatus_t {
        (self
            .cublasDnrm2_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, result)
    }
    pub unsafe fn cublasScnrm2_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        result: *mut f32,
    ) -> cublasStatus_t {
        (self
            .cublasScnrm2_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, result)
    }
    pub unsafe fn cublasScnrm2_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *const cuComplex,
        incx: i64,
        result: *mut f32,
    ) -> cublasStatus_t {
        (self
            .cublasScnrm2_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, result)
    }
    pub unsafe fn cublasDznrm2_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        result: *mut f64,
    ) -> cublasStatus_t {
        (self
            .cublasDznrm2_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, result)
    }
    pub unsafe fn cublasDznrm2_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *const cuDoubleComplex,
        incx: i64,
        result: *mut f64,
    ) -> cublasStatus_t {
        (self
            .cublasDznrm2_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, result)
    }
    pub unsafe fn cublasDotEx(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: ::core::ffi::c_int,
        y: *const ::core::ffi::c_void,
        yType: cudaDataType,
        incy: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_void,
        resultType: cudaDataType,
        executionType: cudaDataType,
    ) -> cublasStatus_t {
        (self
            .cublasDotEx
            .as_ref()
            .expect("Expected function, got error."))(
            handle,
            n,
            x,
            xType,
            incx,
            y,
            yType,
            incy,
            result,
            resultType,
            executionType,
        )
    }
    pub unsafe fn cublasDotEx_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: i64,
        y: *const ::core::ffi::c_void,
        yType: cudaDataType,
        incy: i64,
        result: *mut ::core::ffi::c_void,
        resultType: cudaDataType,
        executionType: cudaDataType,
    ) -> cublasStatus_t {
        (self
            .cublasDotEx_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle,
            n,
            x,
            xType,
            incx,
            y,
            yType,
            incy,
            result,
            resultType,
            executionType,
        )
    }
    pub unsafe fn cublasDotcEx(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: ::core::ffi::c_int,
        y: *const ::core::ffi::c_void,
        yType: cudaDataType,
        incy: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_void,
        resultType: cudaDataType,
        executionType: cudaDataType,
    ) -> cublasStatus_t {
        (self
            .cublasDotcEx
            .as_ref()
            .expect("Expected function, got error."))(
            handle,
            n,
            x,
            xType,
            incx,
            y,
            yType,
            incy,
            result,
            resultType,
            executionType,
        )
    }
    pub unsafe fn cublasDotcEx_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: i64,
        y: *const ::core::ffi::c_void,
        yType: cudaDataType,
        incy: i64,
        result: *mut ::core::ffi::c_void,
        resultType: cudaDataType,
        executionType: cudaDataType,
    ) -> cublasStatus_t {
        (self
            .cublasDotcEx_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle,
            n,
            x,
            xType,
            incx,
            y,
            yType,
            incy,
            result,
            resultType,
            executionType,
        )
    }
    pub unsafe fn cublasSdot_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const f32,
        incx: ::core::ffi::c_int,
        y: *const f32,
        incy: ::core::ffi::c_int,
        result: *mut f32,
    ) -> cublasStatus_t {
        (self
            .cublasSdot_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy, result)
    }
    pub unsafe fn cublasSdot_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *const f32,
        incx: i64,
        y: *const f32,
        incy: i64,
        result: *mut f32,
    ) -> cublasStatus_t {
        (self
            .cublasSdot_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy, result)
    }
    pub unsafe fn cublasDdot_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const f64,
        incx: ::core::ffi::c_int,
        y: *const f64,
        incy: ::core::ffi::c_int,
        result: *mut f64,
    ) -> cublasStatus_t {
        (self
            .cublasDdot_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy, result)
    }
    pub unsafe fn cublasDdot_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *const f64,
        incx: i64,
        y: *const f64,
        incy: i64,
        result: *mut f64,
    ) -> cublasStatus_t {
        (self
            .cublasDdot_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy, result)
    }
    pub unsafe fn cublasCdotu_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        y: *const cuComplex,
        incy: ::core::ffi::c_int,
        result: *mut cuComplex,
    ) -> cublasStatus_t {
        (self
            .cublasCdotu_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy, result)
    }
    pub unsafe fn cublasCdotu_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *const cuComplex,
        incx: i64,
        y: *const cuComplex,
        incy: i64,
        result: *mut cuComplex,
    ) -> cublasStatus_t {
        (self
            .cublasCdotu_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy, result)
    }
    pub unsafe fn cublasCdotc_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        y: *const cuComplex,
        incy: ::core::ffi::c_int,
        result: *mut cuComplex,
    ) -> cublasStatus_t {
        (self
            .cublasCdotc_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy, result)
    }
    pub unsafe fn cublasCdotc_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *const cuComplex,
        incx: i64,
        y: *const cuComplex,
        incy: i64,
        result: *mut cuComplex,
    ) -> cublasStatus_t {
        (self
            .cublasCdotc_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy, result)
    }
    pub unsafe fn cublasZdotu_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        y: *const cuDoubleComplex,
        incy: ::core::ffi::c_int,
        result: *mut cuDoubleComplex,
    ) -> cublasStatus_t {
        (self
            .cublasZdotu_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy, result)
    }
    pub unsafe fn cublasZdotu_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *const cuDoubleComplex,
        incx: i64,
        y: *const cuDoubleComplex,
        incy: i64,
        result: *mut cuDoubleComplex,
    ) -> cublasStatus_t {
        (self
            .cublasZdotu_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy, result)
    }
    pub unsafe fn cublasZdotc_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        y: *const cuDoubleComplex,
        incy: ::core::ffi::c_int,
        result: *mut cuDoubleComplex,
    ) -> cublasStatus_t {
        (self
            .cublasZdotc_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy, result)
    }
    pub unsafe fn cublasZdotc_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *const cuDoubleComplex,
        incx: i64,
        y: *const cuDoubleComplex,
        incy: i64,
        result: *mut cuDoubleComplex,
    ) -> cublasStatus_t {
        (self
            .cublasZdotc_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy, result)
    }
    pub unsafe fn cublasScalEx(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        alpha: *const ::core::ffi::c_void,
        alphaType: cudaDataType,
        x: *mut ::core::ffi::c_void,
        xType: cudaDataType,
        incx: ::core::ffi::c_int,
        executionType: cudaDataType,
    ) -> cublasStatus_t {
        (self
            .cublasScalEx
            .as_ref()
            .expect("Expected function, got error."))(
            handle,
            n,
            alpha,
            alphaType,
            x,
            xType,
            incx,
            executionType,
        )
    }
    pub unsafe fn cublasScalEx_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        alpha: *const ::core::ffi::c_void,
        alphaType: cudaDataType,
        x: *mut ::core::ffi::c_void,
        xType: cudaDataType,
        incx: i64,
        executionType: cudaDataType,
    ) -> cublasStatus_t {
        (self
            .cublasScalEx_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle,
            n,
            alpha,
            alphaType,
            x,
            xType,
            incx,
            executionType,
        )
    }
    pub unsafe fn cublasSscal_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        x: *mut f32,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasSscal_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, alpha, x, incx)
    }
    pub unsafe fn cublasSscal_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        alpha: *const f32,
        x: *mut f32,
        incx: i64,
    ) -> cublasStatus_t {
        (self
            .cublasSscal_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, alpha, x, incx)
    }
    pub unsafe fn cublasDscal_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        x: *mut f64,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasDscal_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, alpha, x, incx)
    }
    pub unsafe fn cublasDscal_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        alpha: *const f64,
        x: *mut f64,
        incx: i64,
    ) -> cublasStatus_t {
        (self
            .cublasDscal_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, alpha, x, incx)
    }
    pub unsafe fn cublasCscal_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        x: *mut cuComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCscal_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, alpha, x, incx)
    }
    pub unsafe fn cublasCscal_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        alpha: *const cuComplex,
        x: *mut cuComplex,
        incx: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCscal_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, alpha, x, incx)
    }
    pub unsafe fn cublasCsscal_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        x: *mut cuComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCsscal_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, alpha, x, incx)
    }
    pub unsafe fn cublasCsscal_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        alpha: *const f32,
        x: *mut cuComplex,
        incx: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCsscal_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, alpha, x, incx)
    }
    pub unsafe fn cublasZscal_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        x: *mut cuDoubleComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZscal_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, alpha, x, incx)
    }
    pub unsafe fn cublasZscal_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        alpha: *const cuDoubleComplex,
        x: *mut cuDoubleComplex,
        incx: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZscal_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, alpha, x, incx)
    }
    pub unsafe fn cublasZdscal_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        x: *mut cuDoubleComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZdscal_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, alpha, x, incx)
    }
    pub unsafe fn cublasZdscal_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        alpha: *const f64,
        x: *mut cuDoubleComplex,
        incx: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZdscal_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, alpha, x, incx)
    }
    pub unsafe fn cublasAxpyEx(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        alpha: *const ::core::ffi::c_void,
        alphaType: cudaDataType,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: ::core::ffi::c_int,
        y: *mut ::core::ffi::c_void,
        yType: cudaDataType,
        incy: ::core::ffi::c_int,
        executiontype: cudaDataType,
    ) -> cublasStatus_t {
        (self
            .cublasAxpyEx
            .as_ref()
            .expect("Expected function, got error."))(
            handle,
            n,
            alpha,
            alphaType,
            x,
            xType,
            incx,
            y,
            yType,
            incy,
            executiontype,
        )
    }
    pub unsafe fn cublasAxpyEx_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        alpha: *const ::core::ffi::c_void,
        alphaType: cudaDataType,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: i64,
        y: *mut ::core::ffi::c_void,
        yType: cudaDataType,
        incy: i64,
        executiontype: cudaDataType,
    ) -> cublasStatus_t {
        (self
            .cublasAxpyEx_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle,
            n,
            alpha,
            alphaType,
            x,
            xType,
            incx,
            y,
            yType,
            incy,
            executiontype,
        )
    }
    pub unsafe fn cublasSaxpy_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        x: *const f32,
        incx: ::core::ffi::c_int,
        y: *mut f32,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasSaxpy_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, alpha, x, incx, y, incy)
    }
    pub unsafe fn cublasSaxpy_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        alpha: *const f32,
        x: *const f32,
        incx: i64,
        y: *mut f32,
        incy: i64,
    ) -> cublasStatus_t {
        (self
            .cublasSaxpy_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, alpha, x, incx, y, incy)
    }
    pub unsafe fn cublasDaxpy_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        x: *const f64,
        incx: ::core::ffi::c_int,
        y: *mut f64,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasDaxpy_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, alpha, x, incx, y, incy)
    }
    pub unsafe fn cublasDaxpy_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        alpha: *const f64,
        x: *const f64,
        incx: i64,
        y: *mut f64,
        incy: i64,
    ) -> cublasStatus_t {
        (self
            .cublasDaxpy_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, alpha, x, incx, y, incy)
    }
    pub unsafe fn cublasCaxpy_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        y: *mut cuComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCaxpy_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, alpha, x, incx, y, incy)
    }
    pub unsafe fn cublasCaxpy_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: i64,
        y: *mut cuComplex,
        incy: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCaxpy_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, alpha, x, incx, y, incy)
    }
    pub unsafe fn cublasZaxpy_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        y: *mut cuDoubleComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZaxpy_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, alpha, x, incx, y, incy)
    }
    pub unsafe fn cublasZaxpy_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: i64,
        y: *mut cuDoubleComplex,
        incy: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZaxpy_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, alpha, x, incx, y, incy)
    }
    pub unsafe fn cublasCopyEx(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: ::core::ffi::c_int,
        y: *mut ::core::ffi::c_void,
        yType: cudaDataType,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCopyEx
            .as_ref()
            .expect("Expected function, got error."))(
            handle, n, x, xType, incx, y, yType, incy
        )
    }
    pub unsafe fn cublasCopyEx_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: i64,
        y: *mut ::core::ffi::c_void,
        yType: cudaDataType,
        incy: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCopyEx_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, n, x, xType, incx, y, yType, incy
        )
    }
    pub unsafe fn cublasScopy_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const f32,
        incx: ::core::ffi::c_int,
        y: *mut f32,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasScopy_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy)
    }
    pub unsafe fn cublasScopy_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *const f32,
        incx: i64,
        y: *mut f32,
        incy: i64,
    ) -> cublasStatus_t {
        (self
            .cublasScopy_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy)
    }
    pub unsafe fn cublasDcopy_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const f64,
        incx: ::core::ffi::c_int,
        y: *mut f64,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasDcopy_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy)
    }
    pub unsafe fn cublasDcopy_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *const f64,
        incx: i64,
        y: *mut f64,
        incy: i64,
    ) -> cublasStatus_t {
        (self
            .cublasDcopy_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy)
    }
    pub unsafe fn cublasCcopy_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        y: *mut cuComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCcopy_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy)
    }
    pub unsafe fn cublasCcopy_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *const cuComplex,
        incx: i64,
        y: *mut cuComplex,
        incy: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCcopy_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy)
    }
    pub unsafe fn cublasZcopy_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        y: *mut cuDoubleComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZcopy_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy)
    }
    pub unsafe fn cublasZcopy_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *const cuDoubleComplex,
        incx: i64,
        y: *mut cuDoubleComplex,
        incy: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZcopy_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy)
    }
    pub unsafe fn cublasSswap_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut f32,
        incx: ::core::ffi::c_int,
        y: *mut f32,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasSswap_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy)
    }
    pub unsafe fn cublasSswap_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *mut f32,
        incx: i64,
        y: *mut f32,
        incy: i64,
    ) -> cublasStatus_t {
        (self
            .cublasSswap_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy)
    }
    pub unsafe fn cublasDswap_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut f64,
        incx: ::core::ffi::c_int,
        y: *mut f64,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasDswap_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy)
    }
    pub unsafe fn cublasDswap_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *mut f64,
        incx: i64,
        y: *mut f64,
        incy: i64,
    ) -> cublasStatus_t {
        (self
            .cublasDswap_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy)
    }
    pub unsafe fn cublasCswap_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut cuComplex,
        incx: ::core::ffi::c_int,
        y: *mut cuComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCswap_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy)
    }
    pub unsafe fn cublasCswap_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *mut cuComplex,
        incx: i64,
        y: *mut cuComplex,
        incy: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCswap_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy)
    }
    pub unsafe fn cublasZswap_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut cuDoubleComplex,
        incx: ::core::ffi::c_int,
        y: *mut cuDoubleComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZswap_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy)
    }
    pub unsafe fn cublasZswap_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *mut cuDoubleComplex,
        incx: i64,
        y: *mut cuDoubleComplex,
        incy: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZswap_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy)
    }
    pub unsafe fn cublasSwapEx(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut ::core::ffi::c_void,
        xType: cudaDataType,
        incx: ::core::ffi::c_int,
        y: *mut ::core::ffi::c_void,
        yType: cudaDataType,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasSwapEx
            .as_ref()
            .expect("Expected function, got error."))(
            handle, n, x, xType, incx, y, yType, incy
        )
    }
    pub unsafe fn cublasSwapEx_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *mut ::core::ffi::c_void,
        xType: cudaDataType,
        incx: i64,
        y: *mut ::core::ffi::c_void,
        yType: cudaDataType,
        incy: i64,
    ) -> cublasStatus_t {
        (self
            .cublasSwapEx_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, n, x, xType, incx, y, yType, incy
        )
    }
    pub unsafe fn cublasIsamax_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const f32,
        incx: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasIsamax_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, result)
    }
    pub unsafe fn cublasIsamax_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *const f32,
        incx: i64,
        result: *mut i64,
    ) -> cublasStatus_t {
        (self
            .cublasIsamax_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, result)
    }
    pub unsafe fn cublasIdamax_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const f64,
        incx: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasIdamax_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, result)
    }
    pub unsafe fn cublasIdamax_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *const f64,
        incx: i64,
        result: *mut i64,
    ) -> cublasStatus_t {
        (self
            .cublasIdamax_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, result)
    }
    pub unsafe fn cublasIcamax_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasIcamax_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, result)
    }
    pub unsafe fn cublasIcamax_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *const cuComplex,
        incx: i64,
        result: *mut i64,
    ) -> cublasStatus_t {
        (self
            .cublasIcamax_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, result)
    }
    pub unsafe fn cublasIzamax_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasIzamax_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, result)
    }
    pub unsafe fn cublasIzamax_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *const cuDoubleComplex,
        incx: i64,
        result: *mut i64,
    ) -> cublasStatus_t {
        (self
            .cublasIzamax_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, result)
    }
    pub unsafe fn cublasIamaxEx(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasIamaxEx
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, xType, incx, result)
    }
    pub unsafe fn cublasIamaxEx_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: i64,
        result: *mut i64,
    ) -> cublasStatus_t {
        (self
            .cublasIamaxEx_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, xType, incx, result)
    }
    pub unsafe fn cublasIsamin_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const f32,
        incx: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasIsamin_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, result)
    }
    pub unsafe fn cublasIsamin_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *const f32,
        incx: i64,
        result: *mut i64,
    ) -> cublasStatus_t {
        (self
            .cublasIsamin_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, result)
    }
    pub unsafe fn cublasIdamin_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const f64,
        incx: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasIdamin_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, result)
    }
    pub unsafe fn cublasIdamin_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *const f64,
        incx: i64,
        result: *mut i64,
    ) -> cublasStatus_t {
        (self
            .cublasIdamin_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, result)
    }
    pub unsafe fn cublasIcamin_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasIcamin_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, result)
    }
    pub unsafe fn cublasIcamin_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *const cuComplex,
        incx: i64,
        result: *mut i64,
    ) -> cublasStatus_t {
        (self
            .cublasIcamin_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, result)
    }
    pub unsafe fn cublasIzamin_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasIzamin_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, result)
    }
    pub unsafe fn cublasIzamin_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *const cuDoubleComplex,
        incx: i64,
        result: *mut i64,
    ) -> cublasStatus_t {
        (self
            .cublasIzamin_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, result)
    }
    pub unsafe fn cublasIaminEx(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasIaminEx
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, xType, incx, result)
    }
    pub unsafe fn cublasIaminEx_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: i64,
        result: *mut i64,
    ) -> cublasStatus_t {
        (self
            .cublasIaminEx_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, xType, incx, result)
    }
    pub unsafe fn cublasAsumEx(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_void,
        resultType: cudaDataType,
        executiontype: cudaDataType,
    ) -> cublasStatus_t {
        (self
            .cublasAsumEx
            .as_ref()
            .expect("Expected function, got error."))(
            handle,
            n,
            x,
            xType,
            incx,
            result,
            resultType,
            executiontype,
        )
    }
    pub unsafe fn cublasAsumEx_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: i64,
        result: *mut ::core::ffi::c_void,
        resultType: cudaDataType,
        executiontype: cudaDataType,
    ) -> cublasStatus_t {
        (self
            .cublasAsumEx_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle,
            n,
            x,
            xType,
            incx,
            result,
            resultType,
            executiontype,
        )
    }
    pub unsafe fn cublasSasum_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const f32,
        incx: ::core::ffi::c_int,
        result: *mut f32,
    ) -> cublasStatus_t {
        (self
            .cublasSasum_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, result)
    }
    pub unsafe fn cublasSasum_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *const f32,
        incx: i64,
        result: *mut f32,
    ) -> cublasStatus_t {
        (self
            .cublasSasum_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, result)
    }
    pub unsafe fn cublasDasum_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const f64,
        incx: ::core::ffi::c_int,
        result: *mut f64,
    ) -> cublasStatus_t {
        (self
            .cublasDasum_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, result)
    }
    pub unsafe fn cublasDasum_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *const f64,
        incx: i64,
        result: *mut f64,
    ) -> cublasStatus_t {
        (self
            .cublasDasum_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, result)
    }
    pub unsafe fn cublasScasum_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        result: *mut f32,
    ) -> cublasStatus_t {
        (self
            .cublasScasum_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, result)
    }
    pub unsafe fn cublasScasum_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *const cuComplex,
        incx: i64,
        result: *mut f32,
    ) -> cublasStatus_t {
        (self
            .cublasScasum_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, result)
    }
    pub unsafe fn cublasDzasum_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        result: *mut f64,
    ) -> cublasStatus_t {
        (self
            .cublasDzasum_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, result)
    }
    pub unsafe fn cublasDzasum_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *const cuDoubleComplex,
        incx: i64,
        result: *mut f64,
    ) -> cublasStatus_t {
        (self
            .cublasDzasum_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, result)
    }
    pub unsafe fn cublasSrot_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut f32,
        incx: ::core::ffi::c_int,
        y: *mut f32,
        incy: ::core::ffi::c_int,
        c: *const f32,
        s: *const f32,
    ) -> cublasStatus_t {
        (self
            .cublasSrot_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy, c, s)
    }
    pub unsafe fn cublasSrot_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *mut f32,
        incx: i64,
        y: *mut f32,
        incy: i64,
        c: *const f32,
        s: *const f32,
    ) -> cublasStatus_t {
        (self
            .cublasSrot_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy, c, s)
    }
    pub unsafe fn cublasDrot_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut f64,
        incx: ::core::ffi::c_int,
        y: *mut f64,
        incy: ::core::ffi::c_int,
        c: *const f64,
        s: *const f64,
    ) -> cublasStatus_t {
        (self
            .cublasDrot_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy, c, s)
    }
    pub unsafe fn cublasDrot_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *mut f64,
        incx: i64,
        y: *mut f64,
        incy: i64,
        c: *const f64,
        s: *const f64,
    ) -> cublasStatus_t {
        (self
            .cublasDrot_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy, c, s)
    }
    pub unsafe fn cublasCrot_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut cuComplex,
        incx: ::core::ffi::c_int,
        y: *mut cuComplex,
        incy: ::core::ffi::c_int,
        c: *const f32,
        s: *const cuComplex,
    ) -> cublasStatus_t {
        (self
            .cublasCrot_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy, c, s)
    }
    pub unsafe fn cublasCrot_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *mut cuComplex,
        incx: i64,
        y: *mut cuComplex,
        incy: i64,
        c: *const f32,
        s: *const cuComplex,
    ) -> cublasStatus_t {
        (self
            .cublasCrot_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy, c, s)
    }
    pub unsafe fn cublasCsrot_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut cuComplex,
        incx: ::core::ffi::c_int,
        y: *mut cuComplex,
        incy: ::core::ffi::c_int,
        c: *const f32,
        s: *const f32,
    ) -> cublasStatus_t {
        (self
            .cublasCsrot_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy, c, s)
    }
    pub unsafe fn cublasCsrot_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *mut cuComplex,
        incx: i64,
        y: *mut cuComplex,
        incy: i64,
        c: *const f32,
        s: *const f32,
    ) -> cublasStatus_t {
        (self
            .cublasCsrot_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy, c, s)
    }
    pub unsafe fn cublasZrot_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut cuDoubleComplex,
        incx: ::core::ffi::c_int,
        y: *mut cuDoubleComplex,
        incy: ::core::ffi::c_int,
        c: *const f64,
        s: *const cuDoubleComplex,
    ) -> cublasStatus_t {
        (self
            .cublasZrot_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy, c, s)
    }
    pub unsafe fn cublasZrot_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *mut cuDoubleComplex,
        incx: i64,
        y: *mut cuDoubleComplex,
        incy: i64,
        c: *const f64,
        s: *const cuDoubleComplex,
    ) -> cublasStatus_t {
        (self
            .cublasZrot_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy, c, s)
    }
    pub unsafe fn cublasZdrot_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut cuDoubleComplex,
        incx: ::core::ffi::c_int,
        y: *mut cuDoubleComplex,
        incy: ::core::ffi::c_int,
        c: *const f64,
        s: *const f64,
    ) -> cublasStatus_t {
        (self
            .cublasZdrot_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy, c, s)
    }
    pub unsafe fn cublasZdrot_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *mut cuDoubleComplex,
        incx: i64,
        y: *mut cuDoubleComplex,
        incy: i64,
        c: *const f64,
        s: *const f64,
    ) -> cublasStatus_t {
        (self
            .cublasZdrot_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy, c, s)
    }
    pub unsafe fn cublasRotEx(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut ::core::ffi::c_void,
        xType: cudaDataType,
        incx: ::core::ffi::c_int,
        y: *mut ::core::ffi::c_void,
        yType: cudaDataType,
        incy: ::core::ffi::c_int,
        c: *const ::core::ffi::c_void,
        s: *const ::core::ffi::c_void,
        csType: cudaDataType,
        executiontype: cudaDataType,
    ) -> cublasStatus_t {
        (self
            .cublasRotEx
            .as_ref()
            .expect("Expected function, got error."))(
            handle,
            n,
            x,
            xType,
            incx,
            y,
            yType,
            incy,
            c,
            s,
            csType,
            executiontype,
        )
    }
    pub unsafe fn cublasRotEx_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *mut ::core::ffi::c_void,
        xType: cudaDataType,
        incx: i64,
        y: *mut ::core::ffi::c_void,
        yType: cudaDataType,
        incy: i64,
        c: *const ::core::ffi::c_void,
        s: *const ::core::ffi::c_void,
        csType: cudaDataType,
        executiontype: cudaDataType,
    ) -> cublasStatus_t {
        (self
            .cublasRotEx_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle,
            n,
            x,
            xType,
            incx,
            y,
            yType,
            incy,
            c,
            s,
            csType,
            executiontype,
        )
    }
    pub unsafe fn cublasSrotg_v2(
        &self,
        handle: cublasHandle_t,
        a: *mut f32,
        b: *mut f32,
        c: *mut f32,
        s: *mut f32,
    ) -> cublasStatus_t {
        (self
            .cublasSrotg_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, a, b, c, s)
    }
    pub unsafe fn cublasDrotg_v2(
        &self,
        handle: cublasHandle_t,
        a: *mut f64,
        b: *mut f64,
        c: *mut f64,
        s: *mut f64,
    ) -> cublasStatus_t {
        (self
            .cublasDrotg_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, a, b, c, s)
    }
    pub unsafe fn cublasCrotg_v2(
        &self,
        handle: cublasHandle_t,
        a: *mut cuComplex,
        b: *mut cuComplex,
        c: *mut f32,
        s: *mut cuComplex,
    ) -> cublasStatus_t {
        (self
            .cublasCrotg_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, a, b, c, s)
    }
    pub unsafe fn cublasZrotg_v2(
        &self,
        handle: cublasHandle_t,
        a: *mut cuDoubleComplex,
        b: *mut cuDoubleComplex,
        c: *mut f64,
        s: *mut cuDoubleComplex,
    ) -> cublasStatus_t {
        (self
            .cublasZrotg_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, a, b, c, s)
    }
    pub unsafe fn cublasRotgEx(
        &self,
        handle: cublasHandle_t,
        a: *mut ::core::ffi::c_void,
        b: *mut ::core::ffi::c_void,
        abType: cudaDataType,
        c: *mut ::core::ffi::c_void,
        s: *mut ::core::ffi::c_void,
        csType: cudaDataType,
        executiontype: cudaDataType,
    ) -> cublasStatus_t {
        (self
            .cublasRotgEx
            .as_ref()
            .expect("Expected function, got error."))(
            handle,
            a,
            b,
            abType,
            c,
            s,
            csType,
            executiontype,
        )
    }
    pub unsafe fn cublasSrotm_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut f32,
        incx: ::core::ffi::c_int,
        y: *mut f32,
        incy: ::core::ffi::c_int,
        param: *const f32,
    ) -> cublasStatus_t {
        (self
            .cublasSrotm_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy, param)
    }
    pub unsafe fn cublasSrotm_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *mut f32,
        incx: i64,
        y: *mut f32,
        incy: i64,
        param: *const f32,
    ) -> cublasStatus_t {
        (self
            .cublasSrotm_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy, param)
    }
    pub unsafe fn cublasDrotm_v2(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut f64,
        incx: ::core::ffi::c_int,
        y: *mut f64,
        incy: ::core::ffi::c_int,
        param: *const f64,
    ) -> cublasStatus_t {
        (self
            .cublasDrotm_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy, param)
    }
    pub unsafe fn cublasDrotm_v2_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *mut f64,
        incx: i64,
        y: *mut f64,
        incy: i64,
        param: *const f64,
    ) -> cublasStatus_t {
        (self
            .cublasDrotm_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, n, x, incx, y, incy, param)
    }
    pub unsafe fn cublasRotmEx(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut ::core::ffi::c_void,
        xType: cudaDataType,
        incx: ::core::ffi::c_int,
        y: *mut ::core::ffi::c_void,
        yType: cudaDataType,
        incy: ::core::ffi::c_int,
        param: *const ::core::ffi::c_void,
        paramType: cudaDataType,
        executiontype: cudaDataType,
    ) -> cublasStatus_t {
        (self
            .cublasRotmEx
            .as_ref()
            .expect("Expected function, got error."))(
            handle,
            n,
            x,
            xType,
            incx,
            y,
            yType,
            incy,
            param,
            paramType,
            executiontype,
        )
    }
    pub unsafe fn cublasRotmEx_64(
        &self,
        handle: cublasHandle_t,
        n: i64,
        x: *mut ::core::ffi::c_void,
        xType: cudaDataType,
        incx: i64,
        y: *mut ::core::ffi::c_void,
        yType: cudaDataType,
        incy: i64,
        param: *const ::core::ffi::c_void,
        paramType: cudaDataType,
        executiontype: cudaDataType,
    ) -> cublasStatus_t {
        (self
            .cublasRotmEx_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle,
            n,
            x,
            xType,
            incx,
            y,
            yType,
            incy,
            param,
            paramType,
            executiontype,
        )
    }
    pub unsafe fn cublasSrotmg_v2(
        &self,
        handle: cublasHandle_t,
        d1: *mut f32,
        d2: *mut f32,
        x1: *mut f32,
        y1: *const f32,
        param: *mut f32,
    ) -> cublasStatus_t {
        (self
            .cublasSrotmg_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, d1, d2, x1, y1, param)
    }
    pub unsafe fn cublasDrotmg_v2(
        &self,
        handle: cublasHandle_t,
        d1: *mut f64,
        d2: *mut f64,
        x1: *mut f64,
        y1: *const f64,
        param: *mut f64,
    ) -> cublasStatus_t {
        (self
            .cublasDrotmg_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, d1, d2, x1, y1, param)
    }
    pub unsafe fn cublasRotmgEx(
        &self,
        handle: cublasHandle_t,
        d1: *mut ::core::ffi::c_void,
        d1Type: cudaDataType,
        d2: *mut ::core::ffi::c_void,
        d2Type: cudaDataType,
        x1: *mut ::core::ffi::c_void,
        x1Type: cudaDataType,
        y1: *const ::core::ffi::c_void,
        y1Type: cudaDataType,
        param: *mut ::core::ffi::c_void,
        paramType: cudaDataType,
        executiontype: cudaDataType,
    ) -> cublasStatus_t {
        (self
            .cublasRotmgEx
            .as_ref()
            .expect("Expected function, got error."))(
            handle,
            d1,
            d1Type,
            d2,
            d2Type,
            x1,
            x1Type,
            y1,
            y1Type,
            param,
            paramType,
            executiontype,
        )
    }
    pub unsafe fn cublasSgemv_v2(
        &self,
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        x: *const f32,
        incx: ::core::ffi::c_int,
        beta: *const f32,
        y: *mut f32,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasSgemv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, trans, m, n, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasSgemv_v2_64(
        &self,
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        x: *const f32,
        incx: i64,
        beta: *const f32,
        y: *mut f32,
        incy: i64,
    ) -> cublasStatus_t {
        (self
            .cublasSgemv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, trans, m, n, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasDgemv_v2(
        &self,
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        x: *const f64,
        incx: ::core::ffi::c_int,
        beta: *const f64,
        y: *mut f64,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasDgemv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, trans, m, n, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasDgemv_v2_64(
        &self,
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        x: *const f64,
        incx: i64,
        beta: *const f64,
        y: *mut f64,
        incy: i64,
    ) -> cublasStatus_t {
        (self
            .cublasDgemv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, trans, m, n, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasCgemv_v2(
        &self,
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCgemv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, trans, m, n, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasCgemv_v2_64(
        &self,
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        x: *const cuComplex,
        incx: i64,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCgemv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, trans, m, n, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasZgemv_v2(
        &self,
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZgemv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, trans, m, n, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasZgemv_v2_64(
        &self,
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        x: *const cuDoubleComplex,
        incx: i64,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZgemv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, trans, m, n, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasSgbmv_v2(
        &self,
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        kl: ::core::ffi::c_int,
        ku: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        x: *const f32,
        incx: ::core::ffi::c_int,
        beta: *const f32,
        y: *mut f32,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasSgbmv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, trans, m, n, kl, ku, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasSgbmv_v2_64(
        &self,
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        kl: i64,
        ku: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        x: *const f32,
        incx: i64,
        beta: *const f32,
        y: *mut f32,
        incy: i64,
    ) -> cublasStatus_t {
        (self
            .cublasSgbmv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, trans, m, n, kl, ku, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasDgbmv_v2(
        &self,
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        kl: ::core::ffi::c_int,
        ku: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        x: *const f64,
        incx: ::core::ffi::c_int,
        beta: *const f64,
        y: *mut f64,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasDgbmv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, trans, m, n, kl, ku, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasDgbmv_v2_64(
        &self,
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        kl: i64,
        ku: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        x: *const f64,
        incx: i64,
        beta: *const f64,
        y: *mut f64,
        incy: i64,
    ) -> cublasStatus_t {
        (self
            .cublasDgbmv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, trans, m, n, kl, ku, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasCgbmv_v2(
        &self,
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        kl: ::core::ffi::c_int,
        ku: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCgbmv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, trans, m, n, kl, ku, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasCgbmv_v2_64(
        &self,
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        kl: i64,
        ku: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        x: *const cuComplex,
        incx: i64,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCgbmv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, trans, m, n, kl, ku, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasZgbmv_v2(
        &self,
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        kl: ::core::ffi::c_int,
        ku: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZgbmv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, trans, m, n, kl, ku, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasZgbmv_v2_64(
        &self,
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        kl: i64,
        ku: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        x: *const cuDoubleComplex,
        incx: i64,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZgbmv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, trans, m, n, kl, ku, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasStrmv_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        A: *const f32,
        lda: ::core::ffi::c_int,
        x: *mut f32,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasStrmv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, A, lda, x, incx
        )
    }
    pub unsafe fn cublasStrmv_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        A: *const f32,
        lda: i64,
        x: *mut f32,
        incx: i64,
    ) -> cublasStatus_t {
        (self
            .cublasStrmv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, A, lda, x, incx
        )
    }
    pub unsafe fn cublasDtrmv_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        A: *const f64,
        lda: ::core::ffi::c_int,
        x: *mut f64,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasDtrmv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, A, lda, x, incx
        )
    }
    pub unsafe fn cublasDtrmv_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        A: *const f64,
        lda: i64,
        x: *mut f64,
        incx: i64,
    ) -> cublasStatus_t {
        (self
            .cublasDtrmv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, A, lda, x, incx
        )
    }
    pub unsafe fn cublasCtrmv_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        x: *mut cuComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCtrmv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, A, lda, x, incx
        )
    }
    pub unsafe fn cublasCtrmv_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        A: *const cuComplex,
        lda: i64,
        x: *mut cuComplex,
        incx: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCtrmv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, A, lda, x, incx
        )
    }
    pub unsafe fn cublasZtrmv_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        x: *mut cuDoubleComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZtrmv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, A, lda, x, incx
        )
    }
    pub unsafe fn cublasZtrmv_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        A: *const cuDoubleComplex,
        lda: i64,
        x: *mut cuDoubleComplex,
        incx: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZtrmv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, A, lda, x, incx
        )
    }
    pub unsafe fn cublasStbmv_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        A: *const f32,
        lda: ::core::ffi::c_int,
        x: *mut f32,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasStbmv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, k, A, lda, x, incx,
        )
    }
    pub unsafe fn cublasStbmv_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        k: i64,
        A: *const f32,
        lda: i64,
        x: *mut f32,
        incx: i64,
    ) -> cublasStatus_t {
        (self
            .cublasStbmv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, k, A, lda, x, incx,
        )
    }
    pub unsafe fn cublasDtbmv_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        A: *const f64,
        lda: ::core::ffi::c_int,
        x: *mut f64,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasDtbmv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, k, A, lda, x, incx,
        )
    }
    pub unsafe fn cublasDtbmv_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        k: i64,
        A: *const f64,
        lda: i64,
        x: *mut f64,
        incx: i64,
    ) -> cublasStatus_t {
        (self
            .cublasDtbmv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, k, A, lda, x, incx,
        )
    }
    pub unsafe fn cublasCtbmv_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        x: *mut cuComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCtbmv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, k, A, lda, x, incx,
        )
    }
    pub unsafe fn cublasCtbmv_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        k: i64,
        A: *const cuComplex,
        lda: i64,
        x: *mut cuComplex,
        incx: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCtbmv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, k, A, lda, x, incx,
        )
    }
    pub unsafe fn cublasZtbmv_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        x: *mut cuDoubleComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZtbmv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, k, A, lda, x, incx,
        )
    }
    pub unsafe fn cublasZtbmv_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        k: i64,
        A: *const cuDoubleComplex,
        lda: i64,
        x: *mut cuDoubleComplex,
        incx: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZtbmv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, k, A, lda, x, incx,
        )
    }
    pub unsafe fn cublasStpmv_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        AP: *const f32,
        x: *mut f32,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasStpmv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, AP, x, incx
        )
    }
    pub unsafe fn cublasStpmv_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        AP: *const f32,
        x: *mut f32,
        incx: i64,
    ) -> cublasStatus_t {
        (self
            .cublasStpmv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, AP, x, incx
        )
    }
    pub unsafe fn cublasDtpmv_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        AP: *const f64,
        x: *mut f64,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasDtpmv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, AP, x, incx
        )
    }
    pub unsafe fn cublasDtpmv_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        AP: *const f64,
        x: *mut f64,
        incx: i64,
    ) -> cublasStatus_t {
        (self
            .cublasDtpmv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, AP, x, incx
        )
    }
    pub unsafe fn cublasCtpmv_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        AP: *const cuComplex,
        x: *mut cuComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCtpmv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, AP, x, incx
        )
    }
    pub unsafe fn cublasCtpmv_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        AP: *const cuComplex,
        x: *mut cuComplex,
        incx: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCtpmv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, AP, x, incx
        )
    }
    pub unsafe fn cublasZtpmv_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        AP: *const cuDoubleComplex,
        x: *mut cuDoubleComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZtpmv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, AP, x, incx
        )
    }
    pub unsafe fn cublasZtpmv_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        AP: *const cuDoubleComplex,
        x: *mut cuDoubleComplex,
        incx: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZtpmv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, AP, x, incx
        )
    }
    pub unsafe fn cublasStrsv_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        A: *const f32,
        lda: ::core::ffi::c_int,
        x: *mut f32,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasStrsv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, A, lda, x, incx
        )
    }
    pub unsafe fn cublasStrsv_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        A: *const f32,
        lda: i64,
        x: *mut f32,
        incx: i64,
    ) -> cublasStatus_t {
        (self
            .cublasStrsv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, A, lda, x, incx
        )
    }
    pub unsafe fn cublasDtrsv_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        A: *const f64,
        lda: ::core::ffi::c_int,
        x: *mut f64,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasDtrsv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, A, lda, x, incx
        )
    }
    pub unsafe fn cublasDtrsv_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        A: *const f64,
        lda: i64,
        x: *mut f64,
        incx: i64,
    ) -> cublasStatus_t {
        (self
            .cublasDtrsv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, A, lda, x, incx
        )
    }
    pub unsafe fn cublasCtrsv_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        x: *mut cuComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCtrsv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, A, lda, x, incx
        )
    }
    pub unsafe fn cublasCtrsv_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        A: *const cuComplex,
        lda: i64,
        x: *mut cuComplex,
        incx: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCtrsv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, A, lda, x, incx
        )
    }
    pub unsafe fn cublasZtrsv_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        x: *mut cuDoubleComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZtrsv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, A, lda, x, incx
        )
    }
    pub unsafe fn cublasZtrsv_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        A: *const cuDoubleComplex,
        lda: i64,
        x: *mut cuDoubleComplex,
        incx: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZtrsv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, A, lda, x, incx
        )
    }
    pub unsafe fn cublasStpsv_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        AP: *const f32,
        x: *mut f32,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasStpsv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, AP, x, incx
        )
    }
    pub unsafe fn cublasStpsv_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        AP: *const f32,
        x: *mut f32,
        incx: i64,
    ) -> cublasStatus_t {
        (self
            .cublasStpsv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, AP, x, incx
        )
    }
    pub unsafe fn cublasDtpsv_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        AP: *const f64,
        x: *mut f64,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasDtpsv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, AP, x, incx
        )
    }
    pub unsafe fn cublasDtpsv_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        AP: *const f64,
        x: *mut f64,
        incx: i64,
    ) -> cublasStatus_t {
        (self
            .cublasDtpsv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, AP, x, incx
        )
    }
    pub unsafe fn cublasCtpsv_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        AP: *const cuComplex,
        x: *mut cuComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCtpsv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, AP, x, incx
        )
    }
    pub unsafe fn cublasCtpsv_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        AP: *const cuComplex,
        x: *mut cuComplex,
        incx: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCtpsv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, AP, x, incx
        )
    }
    pub unsafe fn cublasZtpsv_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        AP: *const cuDoubleComplex,
        x: *mut cuDoubleComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZtpsv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, AP, x, incx
        )
    }
    pub unsafe fn cublasZtpsv_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        AP: *const cuDoubleComplex,
        x: *mut cuDoubleComplex,
        incx: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZtpsv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, AP, x, incx
        )
    }
    pub unsafe fn cublasStbsv_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        A: *const f32,
        lda: ::core::ffi::c_int,
        x: *mut f32,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasStbsv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, k, A, lda, x, incx,
        )
    }
    pub unsafe fn cublasStbsv_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        k: i64,
        A: *const f32,
        lda: i64,
        x: *mut f32,
        incx: i64,
    ) -> cublasStatus_t {
        (self
            .cublasStbsv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, k, A, lda, x, incx,
        )
    }
    pub unsafe fn cublasDtbsv_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        A: *const f64,
        lda: ::core::ffi::c_int,
        x: *mut f64,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasDtbsv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, k, A, lda, x, incx,
        )
    }
    pub unsafe fn cublasDtbsv_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        k: i64,
        A: *const f64,
        lda: i64,
        x: *mut f64,
        incx: i64,
    ) -> cublasStatus_t {
        (self
            .cublasDtbsv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, k, A, lda, x, incx,
        )
    }
    pub unsafe fn cublasCtbsv_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        x: *mut cuComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCtbsv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, k, A, lda, x, incx,
        )
    }
    pub unsafe fn cublasCtbsv_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        k: i64,
        A: *const cuComplex,
        lda: i64,
        x: *mut cuComplex,
        incx: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCtbsv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, k, A, lda, x, incx,
        )
    }
    pub unsafe fn cublasZtbsv_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        x: *mut cuDoubleComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZtbsv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, k, A, lda, x, incx,
        )
    }
    pub unsafe fn cublasZtbsv_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        k: i64,
        A: *const cuDoubleComplex,
        lda: i64,
        x: *mut cuDoubleComplex,
        incx: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZtbsv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, diag, n, k, A, lda, x, incx,
        )
    }
    pub unsafe fn cublasSsymv_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        x: *const f32,
        incx: ::core::ffi::c_int,
        beta: *const f32,
        y: *mut f32,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasSsymv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasSsymv_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        x: *const f32,
        incx: i64,
        beta: *const f32,
        y: *mut f32,
        incy: i64,
    ) -> cublasStatus_t {
        (self
            .cublasSsymv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasDsymv_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        x: *const f64,
        incx: ::core::ffi::c_int,
        beta: *const f64,
        y: *mut f64,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasDsymv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasDsymv_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        x: *const f64,
        incx: i64,
        beta: *const f64,
        y: *mut f64,
        incy: i64,
    ) -> cublasStatus_t {
        (self
            .cublasDsymv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasCsymv_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCsymv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasCsymv_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        x: *const cuComplex,
        incx: i64,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCsymv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasZsymv_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZsymv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasZsymv_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        x: *const cuDoubleComplex,
        incx: i64,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZsymv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasChemv_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasChemv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasChemv_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        x: *const cuComplex,
        incx: i64,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: i64,
    ) -> cublasStatus_t {
        (self
            .cublasChemv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasZhemv_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZhemv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasZhemv_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        x: *const cuDoubleComplex,
        incx: i64,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZhemv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasSsbmv_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        x: *const f32,
        incx: ::core::ffi::c_int,
        beta: *const f32,
        y: *mut f32,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasSsbmv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, k, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasSsbmv_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        k: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        x: *const f32,
        incx: i64,
        beta: *const f32,
        y: *mut f32,
        incy: i64,
    ) -> cublasStatus_t {
        (self
            .cublasSsbmv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, k, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasDsbmv_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        x: *const f64,
        incx: ::core::ffi::c_int,
        beta: *const f64,
        y: *mut f64,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasDsbmv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, k, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasDsbmv_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        k: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        x: *const f64,
        incx: i64,
        beta: *const f64,
        y: *mut f64,
        incy: i64,
    ) -> cublasStatus_t {
        (self
            .cublasDsbmv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, k, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasChbmv_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasChbmv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, k, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasChbmv_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        x: *const cuComplex,
        incx: i64,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: i64,
    ) -> cublasStatus_t {
        (self
            .cublasChbmv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, k, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasZhbmv_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZhbmv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, k, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasZhbmv_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        k: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        x: *const cuDoubleComplex,
        incx: i64,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZhbmv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, k, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasSspmv_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        AP: *const f32,
        x: *const f32,
        incx: ::core::ffi::c_int,
        beta: *const f32,
        y: *mut f32,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasSspmv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, AP, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasSspmv_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f32,
        AP: *const f32,
        x: *const f32,
        incx: i64,
        beta: *const f32,
        y: *mut f32,
        incy: i64,
    ) -> cublasStatus_t {
        (self
            .cublasSspmv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, AP, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasDspmv_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        AP: *const f64,
        x: *const f64,
        incx: ::core::ffi::c_int,
        beta: *const f64,
        y: *mut f64,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasDspmv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, AP, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasDspmv_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f64,
        AP: *const f64,
        x: *const f64,
        incx: i64,
        beta: *const f64,
        y: *mut f64,
        incy: i64,
    ) -> cublasStatus_t {
        (self
            .cublasDspmv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, AP, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasChpmv_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        AP: *const cuComplex,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasChpmv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, AP, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasChpmv_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuComplex,
        AP: *const cuComplex,
        x: *const cuComplex,
        incx: i64,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: i64,
    ) -> cublasStatus_t {
        (self
            .cublasChpmv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, AP, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasZhpmv_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        AP: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZhpmv_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, AP, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasZhpmv_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuDoubleComplex,
        AP: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: i64,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZhpmv_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, AP, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasSger_v2(
        &self,
        handle: cublasHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        x: *const f32,
        incx: ::core::ffi::c_int,
        y: *const f32,
        incy: ::core::ffi::c_int,
        A: *mut f32,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasSger_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, m, n, alpha, x, incx, y, incy, A, lda
        )
    }
    pub unsafe fn cublasSger_v2_64(
        &self,
        handle: cublasHandle_t,
        m: i64,
        n: i64,
        alpha: *const f32,
        x: *const f32,
        incx: i64,
        y: *const f32,
        incy: i64,
        A: *mut f32,
        lda: i64,
    ) -> cublasStatus_t {
        (self
            .cublasSger_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, m, n, alpha, x, incx, y, incy, A, lda
        )
    }
    pub unsafe fn cublasDger_v2(
        &self,
        handle: cublasHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        x: *const f64,
        incx: ::core::ffi::c_int,
        y: *const f64,
        incy: ::core::ffi::c_int,
        A: *mut f64,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasDger_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, m, n, alpha, x, incx, y, incy, A, lda
        )
    }
    pub unsafe fn cublasDger_v2_64(
        &self,
        handle: cublasHandle_t,
        m: i64,
        n: i64,
        alpha: *const f64,
        x: *const f64,
        incx: i64,
        y: *const f64,
        incy: i64,
        A: *mut f64,
        lda: i64,
    ) -> cublasStatus_t {
        (self
            .cublasDger_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, m, n, alpha, x, incx, y, incy, A, lda
        )
    }
    pub unsafe fn cublasCgeru_v2(
        &self,
        handle: cublasHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        y: *const cuComplex,
        incy: ::core::ffi::c_int,
        A: *mut cuComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCgeru_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, m, n, alpha, x, incx, y, incy, A, lda
        )
    }
    pub unsafe fn cublasCgeru_v2_64(
        &self,
        handle: cublasHandle_t,
        m: i64,
        n: i64,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: i64,
        y: *const cuComplex,
        incy: i64,
        A: *mut cuComplex,
        lda: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCgeru_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, m, n, alpha, x, incx, y, incy, A, lda
        )
    }
    pub unsafe fn cublasCgerc_v2(
        &self,
        handle: cublasHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        y: *const cuComplex,
        incy: ::core::ffi::c_int,
        A: *mut cuComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCgerc_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, m, n, alpha, x, incx, y, incy, A, lda
        )
    }
    pub unsafe fn cublasCgerc_v2_64(
        &self,
        handle: cublasHandle_t,
        m: i64,
        n: i64,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: i64,
        y: *const cuComplex,
        incy: i64,
        A: *mut cuComplex,
        lda: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCgerc_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, m, n, alpha, x, incx, y, incy, A, lda
        )
    }
    pub unsafe fn cublasZgeru_v2(
        &self,
        handle: cublasHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        y: *const cuDoubleComplex,
        incy: ::core::ffi::c_int,
        A: *mut cuDoubleComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZgeru_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, m, n, alpha, x, incx, y, incy, A, lda
        )
    }
    pub unsafe fn cublasZgeru_v2_64(
        &self,
        handle: cublasHandle_t,
        m: i64,
        n: i64,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: i64,
        y: *const cuDoubleComplex,
        incy: i64,
        A: *mut cuDoubleComplex,
        lda: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZgeru_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, m, n, alpha, x, incx, y, incy, A, lda
        )
    }
    pub unsafe fn cublasZgerc_v2(
        &self,
        handle: cublasHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        y: *const cuDoubleComplex,
        incy: ::core::ffi::c_int,
        A: *mut cuDoubleComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZgerc_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, m, n, alpha, x, incx, y, incy, A, lda
        )
    }
    pub unsafe fn cublasZgerc_v2_64(
        &self,
        handle: cublasHandle_t,
        m: i64,
        n: i64,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: i64,
        y: *const cuDoubleComplex,
        incy: i64,
        A: *mut cuDoubleComplex,
        lda: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZgerc_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, m, n, alpha, x, incx, y, incy, A, lda
        )
    }
    pub unsafe fn cublasSsyr_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        x: *const f32,
        incx: ::core::ffi::c_int,
        A: *mut f32,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasSsyr_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, x, incx, A, lda
        )
    }
    pub unsafe fn cublasSsyr_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f32,
        x: *const f32,
        incx: i64,
        A: *mut f32,
        lda: i64,
    ) -> cublasStatus_t {
        (self
            .cublasSsyr_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, x, incx, A, lda
        )
    }
    pub unsafe fn cublasDsyr_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        x: *const f64,
        incx: ::core::ffi::c_int,
        A: *mut f64,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasDsyr_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, x, incx, A, lda
        )
    }
    pub unsafe fn cublasDsyr_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f64,
        x: *const f64,
        incx: i64,
        A: *mut f64,
        lda: i64,
    ) -> cublasStatus_t {
        (self
            .cublasDsyr_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, x, incx, A, lda
        )
    }
    pub unsafe fn cublasCsyr_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        A: *mut cuComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCsyr_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, x, incx, A, lda
        )
    }
    pub unsafe fn cublasCsyr_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: i64,
        A: *mut cuComplex,
        lda: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCsyr_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, x, incx, A, lda
        )
    }
    pub unsafe fn cublasZsyr_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        A: *mut cuDoubleComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZsyr_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, x, incx, A, lda
        )
    }
    pub unsafe fn cublasZsyr_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: i64,
        A: *mut cuDoubleComplex,
        lda: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZsyr_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, x, incx, A, lda
        )
    }
    pub unsafe fn cublasCher_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        A: *mut cuComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCher_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, x, incx, A, lda
        )
    }
    pub unsafe fn cublasCher_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f32,
        x: *const cuComplex,
        incx: i64,
        A: *mut cuComplex,
        lda: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCher_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, x, incx, A, lda
        )
    }
    pub unsafe fn cublasZher_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        A: *mut cuDoubleComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZher_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, x, incx, A, lda
        )
    }
    pub unsafe fn cublasZher_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f64,
        x: *const cuDoubleComplex,
        incx: i64,
        A: *mut cuDoubleComplex,
        lda: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZher_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, x, incx, A, lda
        )
    }
    pub unsafe fn cublasSspr_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        x: *const f32,
        incx: ::core::ffi::c_int,
        AP: *mut f32,
    ) -> cublasStatus_t {
        (self
            .cublasSspr_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, uplo, n, alpha, x, incx, AP)
    }
    pub unsafe fn cublasSspr_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f32,
        x: *const f32,
        incx: i64,
        AP: *mut f32,
    ) -> cublasStatus_t {
        (self
            .cublasSspr_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, uplo, n, alpha, x, incx, AP)
    }
    pub unsafe fn cublasDspr_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        x: *const f64,
        incx: ::core::ffi::c_int,
        AP: *mut f64,
    ) -> cublasStatus_t {
        (self
            .cublasDspr_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, uplo, n, alpha, x, incx, AP)
    }
    pub unsafe fn cublasDspr_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f64,
        x: *const f64,
        incx: i64,
        AP: *mut f64,
    ) -> cublasStatus_t {
        (self
            .cublasDspr_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, uplo, n, alpha, x, incx, AP)
    }
    pub unsafe fn cublasChpr_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        AP: *mut cuComplex,
    ) -> cublasStatus_t {
        (self
            .cublasChpr_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, uplo, n, alpha, x, incx, AP)
    }
    pub unsafe fn cublasChpr_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f32,
        x: *const cuComplex,
        incx: i64,
        AP: *mut cuComplex,
    ) -> cublasStatus_t {
        (self
            .cublasChpr_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, uplo, n, alpha, x, incx, AP)
    }
    pub unsafe fn cublasZhpr_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        AP: *mut cuDoubleComplex,
    ) -> cublasStatus_t {
        (self
            .cublasZhpr_v2
            .as_ref()
            .expect("Expected function, got error."))(handle, uplo, n, alpha, x, incx, AP)
    }
    pub unsafe fn cublasZhpr_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f64,
        x: *const cuDoubleComplex,
        incx: i64,
        AP: *mut cuDoubleComplex,
    ) -> cublasStatus_t {
        (self
            .cublasZhpr_v2_64
            .as_ref()
            .expect("Expected function, got error."))(handle, uplo, n, alpha, x, incx, AP)
    }
    pub unsafe fn cublasSsyr2_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        x: *const f32,
        incx: ::core::ffi::c_int,
        y: *const f32,
        incy: ::core::ffi::c_int,
        A: *mut f32,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasSsyr2_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, x, incx, y, incy, A, lda,
        )
    }
    pub unsafe fn cublasSsyr2_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f32,
        x: *const f32,
        incx: i64,
        y: *const f32,
        incy: i64,
        A: *mut f32,
        lda: i64,
    ) -> cublasStatus_t {
        (self
            .cublasSsyr2_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, x, incx, y, incy, A, lda,
        )
    }
    pub unsafe fn cublasDsyr2_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        x: *const f64,
        incx: ::core::ffi::c_int,
        y: *const f64,
        incy: ::core::ffi::c_int,
        A: *mut f64,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasDsyr2_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, x, incx, y, incy, A, lda,
        )
    }
    pub unsafe fn cublasDsyr2_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f64,
        x: *const f64,
        incx: i64,
        y: *const f64,
        incy: i64,
        A: *mut f64,
        lda: i64,
    ) -> cublasStatus_t {
        (self
            .cublasDsyr2_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, x, incx, y, incy, A, lda,
        )
    }
    pub unsafe fn cublasCsyr2_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        y: *const cuComplex,
        incy: ::core::ffi::c_int,
        A: *mut cuComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCsyr2_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, x, incx, y, incy, A, lda,
        )
    }
    pub unsafe fn cublasCsyr2_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: i64,
        y: *const cuComplex,
        incy: i64,
        A: *mut cuComplex,
        lda: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCsyr2_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, x, incx, y, incy, A, lda,
        )
    }
    pub unsafe fn cublasZsyr2_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        y: *const cuDoubleComplex,
        incy: ::core::ffi::c_int,
        A: *mut cuDoubleComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZsyr2_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, x, incx, y, incy, A, lda,
        )
    }
    pub unsafe fn cublasZsyr2_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: i64,
        y: *const cuDoubleComplex,
        incy: i64,
        A: *mut cuDoubleComplex,
        lda: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZsyr2_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, x, incx, y, incy, A, lda,
        )
    }
    pub unsafe fn cublasCher2_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        y: *const cuComplex,
        incy: ::core::ffi::c_int,
        A: *mut cuComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCher2_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, x, incx, y, incy, A, lda,
        )
    }
    pub unsafe fn cublasCher2_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: i64,
        y: *const cuComplex,
        incy: i64,
        A: *mut cuComplex,
        lda: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCher2_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, x, incx, y, incy, A, lda,
        )
    }
    pub unsafe fn cublasZher2_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        y: *const cuDoubleComplex,
        incy: ::core::ffi::c_int,
        A: *mut cuDoubleComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZher2_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, x, incx, y, incy, A, lda,
        )
    }
    pub unsafe fn cublasZher2_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: i64,
        y: *const cuDoubleComplex,
        incy: i64,
        A: *mut cuDoubleComplex,
        lda: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZher2_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, x, incx, y, incy, A, lda,
        )
    }
    pub unsafe fn cublasSspr2_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        x: *const f32,
        incx: ::core::ffi::c_int,
        y: *const f32,
        incy: ::core::ffi::c_int,
        AP: *mut f32,
    ) -> cublasStatus_t {
        (self
            .cublasSspr2_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, x, incx, y, incy, AP
        )
    }
    pub unsafe fn cublasSspr2_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f32,
        x: *const f32,
        incx: i64,
        y: *const f32,
        incy: i64,
        AP: *mut f32,
    ) -> cublasStatus_t {
        (self
            .cublasSspr2_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, x, incx, y, incy, AP
        )
    }
    pub unsafe fn cublasDspr2_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        x: *const f64,
        incx: ::core::ffi::c_int,
        y: *const f64,
        incy: ::core::ffi::c_int,
        AP: *mut f64,
    ) -> cublasStatus_t {
        (self
            .cublasDspr2_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, x, incx, y, incy, AP
        )
    }
    pub unsafe fn cublasDspr2_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f64,
        x: *const f64,
        incx: i64,
        y: *const f64,
        incy: i64,
        AP: *mut f64,
    ) -> cublasStatus_t {
        (self
            .cublasDspr2_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, x, incx, y, incy, AP
        )
    }
    pub unsafe fn cublasChpr2_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        y: *const cuComplex,
        incy: ::core::ffi::c_int,
        AP: *mut cuComplex,
    ) -> cublasStatus_t {
        (self
            .cublasChpr2_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, x, incx, y, incy, AP
        )
    }
    pub unsafe fn cublasChpr2_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: i64,
        y: *const cuComplex,
        incy: i64,
        AP: *mut cuComplex,
    ) -> cublasStatus_t {
        (self
            .cublasChpr2_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, x, incx, y, incy, AP
        )
    }
    pub unsafe fn cublasZhpr2_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        y: *const cuDoubleComplex,
        incy: ::core::ffi::c_int,
        AP: *mut cuDoubleComplex,
    ) -> cublasStatus_t {
        (self
            .cublasZhpr2_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, x, incx, y, incy, AP
        )
    }
    pub unsafe fn cublasZhpr2_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: i64,
        y: *const cuDoubleComplex,
        incy: i64,
        AP: *mut cuDoubleComplex,
    ) -> cublasStatus_t {
        (self
            .cublasZhpr2_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, n, alpha, x, incx, y, incy, AP
        )
    }
    pub unsafe fn cublasSgemvBatched(
        &self,
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        Aarray: *const *const f32,
        lda: ::core::ffi::c_int,
        xarray: *const *const f32,
        incx: ::core::ffi::c_int,
        beta: *const f32,
        yarray: *const *mut f32,
        incy: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasSgemvBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle, trans, m, n, alpha, Aarray, lda, xarray, incx, beta, yarray, incy, batchCount,
        )
    }
    pub unsafe fn cublasSgemvBatched_64(
        &self,
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const f32,
        Aarray: *const *const f32,
        lda: i64,
        xarray: *const *const f32,
        incx: i64,
        beta: *const f32,
        yarray: *const *mut f32,
        incy: i64,
        batchCount: i64,
    ) -> cublasStatus_t {
        (self
            .cublasSgemvBatched_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, trans, m, n, alpha, Aarray, lda, xarray, incx, beta, yarray, incy, batchCount,
        )
    }
    pub unsafe fn cublasDgemvBatched(
        &self,
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        Aarray: *const *const f64,
        lda: ::core::ffi::c_int,
        xarray: *const *const f64,
        incx: ::core::ffi::c_int,
        beta: *const f64,
        yarray: *const *mut f64,
        incy: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasDgemvBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle, trans, m, n, alpha, Aarray, lda, xarray, incx, beta, yarray, incy, batchCount,
        )
    }
    pub unsafe fn cublasDgemvBatched_64(
        &self,
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const f64,
        Aarray: *const *const f64,
        lda: i64,
        xarray: *const *const f64,
        incx: i64,
        beta: *const f64,
        yarray: *const *mut f64,
        incy: i64,
        batchCount: i64,
    ) -> cublasStatus_t {
        (self
            .cublasDgemvBatched_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, trans, m, n, alpha, Aarray, lda, xarray, incx, beta, yarray, incy, batchCount,
        )
    }
    pub unsafe fn cublasCgemvBatched(
        &self,
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        Aarray: *const *const cuComplex,
        lda: ::core::ffi::c_int,
        xarray: *const *const cuComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuComplex,
        yarray: *const *mut cuComplex,
        incy: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCgemvBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle, trans, m, n, alpha, Aarray, lda, xarray, incx, beta, yarray, incy, batchCount,
        )
    }
    pub unsafe fn cublasCgemvBatched_64(
        &self,
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const cuComplex,
        Aarray: *const *const cuComplex,
        lda: i64,
        xarray: *const *const cuComplex,
        incx: i64,
        beta: *const cuComplex,
        yarray: *const *mut cuComplex,
        incy: i64,
        batchCount: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCgemvBatched_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, trans, m, n, alpha, Aarray, lda, xarray, incx, beta, yarray, incy, batchCount,
        )
    }
    pub unsafe fn cublasZgemvBatched(
        &self,
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        Aarray: *const *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        xarray: *const *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        yarray: *const *mut cuDoubleComplex,
        incy: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZgemvBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle, trans, m, n, alpha, Aarray, lda, xarray, incx, beta, yarray, incy, batchCount,
        )
    }
    pub unsafe fn cublasZgemvBatched_64(
        &self,
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const cuDoubleComplex,
        Aarray: *const *const cuDoubleComplex,
        lda: i64,
        xarray: *const *const cuDoubleComplex,
        incx: i64,
        beta: *const cuDoubleComplex,
        yarray: *const *mut cuDoubleComplex,
        incy: i64,
        batchCount: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZgemvBatched_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, trans, m, n, alpha, Aarray, lda, xarray, incx, beta, yarray, incy, batchCount,
        )
    }
    pub unsafe fn cublasSgemvStridedBatched(
        &self,
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        strideA: ::core::ffi::c_longlong,
        x: *const f32,
        incx: ::core::ffi::c_int,
        stridex: ::core::ffi::c_longlong,
        beta: *const f32,
        y: *mut f32,
        incy: ::core::ffi::c_int,
        stridey: ::core::ffi::c_longlong,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasSgemvStridedBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle, trans, m, n, alpha, A, lda, strideA, x, incx, stridex, beta, y, incy, stridey,
            batchCount,
        )
    }
    pub unsafe fn cublasSgemvStridedBatched_64(
        &self,
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        strideA: ::core::ffi::c_longlong,
        x: *const f32,
        incx: i64,
        stridex: ::core::ffi::c_longlong,
        beta: *const f32,
        y: *mut f32,
        incy: i64,
        stridey: ::core::ffi::c_longlong,
        batchCount: i64,
    ) -> cublasStatus_t {
        (self
            .cublasSgemvStridedBatched_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, trans, m, n, alpha, A, lda, strideA, x, incx, stridex, beta, y, incy, stridey,
            batchCount,
        )
    }
    pub unsafe fn cublasDgemvStridedBatched(
        &self,
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        strideA: ::core::ffi::c_longlong,
        x: *const f64,
        incx: ::core::ffi::c_int,
        stridex: ::core::ffi::c_longlong,
        beta: *const f64,
        y: *mut f64,
        incy: ::core::ffi::c_int,
        stridey: ::core::ffi::c_longlong,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasDgemvStridedBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle, trans, m, n, alpha, A, lda, strideA, x, incx, stridex, beta, y, incy, stridey,
            batchCount,
        )
    }
    pub unsafe fn cublasDgemvStridedBatched_64(
        &self,
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        strideA: ::core::ffi::c_longlong,
        x: *const f64,
        incx: i64,
        stridex: ::core::ffi::c_longlong,
        beta: *const f64,
        y: *mut f64,
        incy: i64,
        stridey: ::core::ffi::c_longlong,
        batchCount: i64,
    ) -> cublasStatus_t {
        (self
            .cublasDgemvStridedBatched_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, trans, m, n, alpha, A, lda, strideA, x, incx, stridex, beta, y, incy, stridey,
            batchCount,
        )
    }
    pub unsafe fn cublasCgemvStridedBatched(
        &self,
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        strideA: ::core::ffi::c_longlong,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        stridex: ::core::ffi::c_longlong,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: ::core::ffi::c_int,
        stridey: ::core::ffi::c_longlong,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCgemvStridedBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle, trans, m, n, alpha, A, lda, strideA, x, incx, stridex, beta, y, incy, stridey,
            batchCount,
        )
    }
    pub unsafe fn cublasCgemvStridedBatched_64(
        &self,
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        strideA: ::core::ffi::c_longlong,
        x: *const cuComplex,
        incx: i64,
        stridex: ::core::ffi::c_longlong,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: i64,
        stridey: ::core::ffi::c_longlong,
        batchCount: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCgemvStridedBatched_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, trans, m, n, alpha, A, lda, strideA, x, incx, stridex, beta, y, incy, stridey,
            batchCount,
        )
    }
    pub unsafe fn cublasZgemvStridedBatched(
        &self,
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        strideA: ::core::ffi::c_longlong,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        stridex: ::core::ffi::c_longlong,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: ::core::ffi::c_int,
        stridey: ::core::ffi::c_longlong,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZgemvStridedBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle, trans, m, n, alpha, A, lda, strideA, x, incx, stridex, beta, y, incy, stridey,
            batchCount,
        )
    }
    pub unsafe fn cublasZgemvStridedBatched_64(
        &self,
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        strideA: ::core::ffi::c_longlong,
        x: *const cuDoubleComplex,
        incx: i64,
        stridex: ::core::ffi::c_longlong,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: i64,
        stridey: ::core::ffi::c_longlong,
        batchCount: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZgemvStridedBatched_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, trans, m, n, alpha, A, lda, strideA, x, incx, stridex, beta, y, incy, stridey,
            batchCount,
        )
    }
    pub unsafe fn cublasSgemm_v2(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        B: *const f32,
        ldb: ::core::ffi::c_int,
        beta: *const f32,
        C: *mut f32,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasSgemm_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasSgemm_v2_64(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        B: *const f32,
        ldb: i64,
        beta: *const f32,
        C: *mut f32,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasSgemm_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasDgemm_v2(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        B: *const f64,
        ldb: ::core::ffi::c_int,
        beta: *const f64,
        C: *mut f64,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasDgemm_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasDgemm_v2_64(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        B: *const f64,
        ldb: i64,
        beta: *const f64,
        C: *mut f64,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasDgemm_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasCgemm_v2(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCgemm_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasCgemm_v2_64(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        B: *const cuComplex,
        ldb: i64,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCgemm_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasCgemm3m(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCgemm3m
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasCgemm3m_64(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        B: *const cuComplex,
        ldb: i64,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCgemm3m_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasCgemm3mEx(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: ::core::ffi::c_int,
        B: *const ::core::ffi::c_void,
        Btype: cudaDataType,
        ldb: ::core::ffi::c_int,
        beta: *const cuComplex,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCgemm3mEx
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, k, alpha, A, Atype, lda, B, Btype, ldb, beta, C, Ctype,
            ldc,
        )
    }
    pub unsafe fn cublasCgemm3mEx_64(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: i64,
        B: *const ::core::ffi::c_void,
        Btype: cudaDataType,
        ldb: i64,
        beta: *const cuComplex,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCgemm3mEx_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, k, alpha, A, Atype, lda, B, Btype, ldb, beta, C, Ctype,
            ldc,
        )
    }
    pub unsafe fn cublasZgemm_v2(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZgemm_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasZgemm_v2_64(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        B: *const cuDoubleComplex,
        ldb: i64,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZgemm_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasZgemm3m(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZgemm3m
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasZgemm3m_64(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        B: *const cuDoubleComplex,
        ldb: i64,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZgemm3m_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasSgemmEx(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: ::core::ffi::c_int,
        B: *const ::core::ffi::c_void,
        Btype: cudaDataType,
        ldb: ::core::ffi::c_int,
        beta: *const f32,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasSgemmEx
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, k, alpha, A, Atype, lda, B, Btype, ldb, beta, C, Ctype,
            ldc,
        )
    }
    pub unsafe fn cublasSgemmEx_64(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const f32,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: i64,
        B: *const ::core::ffi::c_void,
        Btype: cudaDataType,
        ldb: i64,
        beta: *const f32,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasSgemmEx_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, k, alpha, A, Atype, lda, B, Btype, ldb, beta, C, Ctype,
            ldc,
        )
    }
    pub unsafe fn cublasGemmEx(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const ::core::ffi::c_void,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: ::core::ffi::c_int,
        B: *const ::core::ffi::c_void,
        Btype: cudaDataType,
        ldb: ::core::ffi::c_int,
        beta: *const ::core::ffi::c_void,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: ::core::ffi::c_int,
        computeType: cublasComputeType_t,
        algo: cublasGemmAlgo_t,
    ) -> cublasStatus_t {
        (self
            .cublasGemmEx
            .as_ref()
            .expect("Expected function, got error."))(
            handle,
            transa,
            transb,
            m,
            n,
            k,
            alpha,
            A,
            Atype,
            lda,
            B,
            Btype,
            ldb,
            beta,
            C,
            Ctype,
            ldc,
            computeType,
            algo,
        )
    }
    pub unsafe fn cublasGemmEx_64(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const ::core::ffi::c_void,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: i64,
        B: *const ::core::ffi::c_void,
        Btype: cudaDataType,
        ldb: i64,
        beta: *const ::core::ffi::c_void,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: i64,
        computeType: cublasComputeType_t,
        algo: cublasGemmAlgo_t,
    ) -> cublasStatus_t {
        (self
            .cublasGemmEx_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle,
            transa,
            transb,
            m,
            n,
            k,
            alpha,
            A,
            Atype,
            lda,
            B,
            Btype,
            ldb,
            beta,
            C,
            Ctype,
            ldc,
            computeType,
            algo,
        )
    }
    pub unsafe fn cublasCgemmEx(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: ::core::ffi::c_int,
        B: *const ::core::ffi::c_void,
        Btype: cudaDataType,
        ldb: ::core::ffi::c_int,
        beta: *const cuComplex,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCgemmEx
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, k, alpha, A, Atype, lda, B, Btype, ldb, beta, C, Ctype,
            ldc,
        )
    }
    pub unsafe fn cublasCgemmEx_64(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: i64,
        B: *const ::core::ffi::c_void,
        Btype: cudaDataType,
        ldb: i64,
        beta: *const cuComplex,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCgemmEx_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, k, alpha, A, Atype, lda, B, Btype, ldb, beta, C, Ctype,
            ldc,
        )
    }
    pub unsafe fn cublasSsyrk_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        beta: *const f32,
        C: *mut f32,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasSsyrk_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc,
        )
    }
    pub unsafe fn cublasSsyrk_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        beta: *const f32,
        C: *mut f32,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasSsyrk_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc,
        )
    }
    pub unsafe fn cublasDsyrk_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        beta: *const f64,
        C: *mut f64,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasDsyrk_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc,
        )
    }
    pub unsafe fn cublasDsyrk_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        beta: *const f64,
        C: *mut f64,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasDsyrk_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc,
        )
    }
    pub unsafe fn cublasCsyrk_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCsyrk_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc,
        )
    }
    pub unsafe fn cublasCsyrk_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCsyrk_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc,
        )
    }
    pub unsafe fn cublasZsyrk_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZsyrk_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc,
        )
    }
    pub unsafe fn cublasZsyrk_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZsyrk_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc,
        )
    }
    pub unsafe fn cublasCsyrkEx(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: ::core::ffi::c_int,
        beta: *const cuComplex,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCsyrkEx
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, Atype, lda, beta, C, Ctype, ldc,
        )
    }
    pub unsafe fn cublasCsyrkEx_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: i64,
        beta: *const cuComplex,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCsyrkEx_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, Atype, lda, beta, C, Ctype, ldc,
        )
    }
    pub unsafe fn cublasCsyrk3mEx(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: ::core::ffi::c_int,
        beta: *const cuComplex,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCsyrk3mEx
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, Atype, lda, beta, C, Ctype, ldc,
        )
    }
    pub unsafe fn cublasCsyrk3mEx_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: i64,
        beta: *const cuComplex,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCsyrk3mEx_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, Atype, lda, beta, C, Ctype, ldc,
        )
    }
    pub unsafe fn cublasCherk_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        beta: *const f32,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCherk_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc,
        )
    }
    pub unsafe fn cublasCherk_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const f32,
        A: *const cuComplex,
        lda: i64,
        beta: *const f32,
        C: *mut cuComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCherk_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc,
        )
    }
    pub unsafe fn cublasZherk_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        beta: *const f64,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZherk_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc,
        )
    }
    pub unsafe fn cublasZherk_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const f64,
        A: *const cuDoubleComplex,
        lda: i64,
        beta: *const f64,
        C: *mut cuDoubleComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZherk_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc,
        )
    }
    pub unsafe fn cublasCherkEx(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: ::core::ffi::c_int,
        beta: *const f32,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCherkEx
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, Atype, lda, beta, C, Ctype, ldc,
        )
    }
    pub unsafe fn cublasCherkEx_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const f32,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: i64,
        beta: *const f32,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCherkEx_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, Atype, lda, beta, C, Ctype, ldc,
        )
    }
    pub unsafe fn cublasCherk3mEx(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: ::core::ffi::c_int,
        beta: *const f32,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCherk3mEx
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, Atype, lda, beta, C, Ctype, ldc,
        )
    }
    pub unsafe fn cublasCherk3mEx_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const f32,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: i64,
        beta: *const f32,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCherk3mEx_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, Atype, lda, beta, C, Ctype, ldc,
        )
    }
    pub unsafe fn cublasSsyr2k_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        B: *const f32,
        ldb: ::core::ffi::c_int,
        beta: *const f32,
        C: *mut f32,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasSsyr2k_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasSsyr2k_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        B: *const f32,
        ldb: i64,
        beta: *const f32,
        C: *mut f32,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasSsyr2k_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasDsyr2k_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        B: *const f64,
        ldb: ::core::ffi::c_int,
        beta: *const f64,
        C: *mut f64,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasDsyr2k_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasDsyr2k_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        B: *const f64,
        ldb: i64,
        beta: *const f64,
        C: *mut f64,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasDsyr2k_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasCsyr2k_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCsyr2k_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasCsyr2k_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        B: *const cuComplex,
        ldb: i64,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCsyr2k_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasZsyr2k_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZsyr2k_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasZsyr2k_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        B: *const cuDoubleComplex,
        ldb: i64,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZsyr2k_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasCher2k_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        beta: *const f32,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCher2k_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasCher2k_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        B: *const cuComplex,
        ldb: i64,
        beta: *const f32,
        C: *mut cuComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCher2k_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasZher2k_v2(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        beta: *const f64,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZher2k_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasZher2k_v2_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        B: *const cuDoubleComplex,
        ldb: i64,
        beta: *const f64,
        C: *mut cuDoubleComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZher2k_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasSsyrkx(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        B: *const f32,
        ldb: ::core::ffi::c_int,
        beta: *const f32,
        C: *mut f32,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasSsyrkx
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasSsyrkx_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        B: *const f32,
        ldb: i64,
        beta: *const f32,
        C: *mut f32,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasSsyrkx_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasDsyrkx(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        B: *const f64,
        ldb: ::core::ffi::c_int,
        beta: *const f64,
        C: *mut f64,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasDsyrkx
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasDsyrkx_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        B: *const f64,
        ldb: i64,
        beta: *const f64,
        C: *mut f64,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasDsyrkx_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasCsyrkx(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCsyrkx
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasCsyrkx_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        B: *const cuComplex,
        ldb: i64,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCsyrkx_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasZsyrkx(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZsyrkx
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasZsyrkx_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        B: *const cuDoubleComplex,
        ldb: i64,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZsyrkx_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasCherkx(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        beta: *const f32,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCherkx
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasCherkx_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        B: *const cuComplex,
        ldb: i64,
        beta: *const f32,
        C: *mut cuComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCherkx_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasZherkx(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        beta: *const f64,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZherkx
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasZherkx_64(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        B: *const cuDoubleComplex,
        ldb: i64,
        beta: *const f64,
        C: *mut cuDoubleComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZherkx_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasSsymm_v2(
        &self,
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        B: *const f32,
        ldb: ::core::ffi::c_int,
        beta: *const f32,
        C: *mut f32,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasSsymm_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasSsymm_v2_64(
        &self,
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        m: i64,
        n: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        B: *const f32,
        ldb: i64,
        beta: *const f32,
        C: *mut f32,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasSsymm_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasDsymm_v2(
        &self,
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        B: *const f64,
        ldb: ::core::ffi::c_int,
        beta: *const f64,
        C: *mut f64,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasDsymm_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasDsymm_v2_64(
        &self,
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        m: i64,
        n: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        B: *const f64,
        ldb: i64,
        beta: *const f64,
        C: *mut f64,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasDsymm_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasCsymm_v2(
        &self,
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCsymm_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasCsymm_v2_64(
        &self,
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        m: i64,
        n: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        B: *const cuComplex,
        ldb: i64,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCsymm_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasZsymm_v2(
        &self,
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZsymm_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasZsymm_v2_64(
        &self,
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        m: i64,
        n: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        B: *const cuDoubleComplex,
        ldb: i64,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZsymm_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasChemm_v2(
        &self,
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasChemm_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasChemm_v2_64(
        &self,
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        m: i64,
        n: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        B: *const cuComplex,
        ldb: i64,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasChemm_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasZhemm_v2(
        &self,
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZhemm_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasZhemm_v2_64(
        &self,
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        m: i64,
        n: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        B: *const cuDoubleComplex,
        ldb: i64,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZhemm_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasStrsm_v2(
        &self,
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        B: *mut f32,
        ldb: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasStrsm_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb,
        )
    }
    pub unsafe fn cublasStrsm_v2_64(
        &self,
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: i64,
        n: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        B: *mut f32,
        ldb: i64,
    ) -> cublasStatus_t {
        (self
            .cublasStrsm_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb,
        )
    }
    pub unsafe fn cublasDtrsm_v2(
        &self,
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        B: *mut f64,
        ldb: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasDtrsm_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb,
        )
    }
    pub unsafe fn cublasDtrsm_v2_64(
        &self,
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: i64,
        n: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        B: *mut f64,
        ldb: i64,
    ) -> cublasStatus_t {
        (self
            .cublasDtrsm_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb,
        )
    }
    pub unsafe fn cublasCtrsm_v2(
        &self,
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        B: *mut cuComplex,
        ldb: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCtrsm_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb,
        )
    }
    pub unsafe fn cublasCtrsm_v2_64(
        &self,
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: i64,
        n: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        B: *mut cuComplex,
        ldb: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCtrsm_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb,
        )
    }
    pub unsafe fn cublasZtrsm_v2(
        &self,
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        B: *mut cuDoubleComplex,
        ldb: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZtrsm_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb,
        )
    }
    pub unsafe fn cublasZtrsm_v2_64(
        &self,
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: i64,
        n: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        B: *mut cuDoubleComplex,
        ldb: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZtrsm_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb,
        )
    }
    pub unsafe fn cublasStrmm_v2(
        &self,
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        B: *const f32,
        ldb: ::core::ffi::c_int,
        C: *mut f32,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasStrmm_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, C, ldc,
        )
    }
    pub unsafe fn cublasStrmm_v2_64(
        &self,
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: i64,
        n: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        B: *const f32,
        ldb: i64,
        C: *mut f32,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasStrmm_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, C, ldc,
        )
    }
    pub unsafe fn cublasDtrmm_v2(
        &self,
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        B: *const f64,
        ldb: ::core::ffi::c_int,
        C: *mut f64,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasDtrmm_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, C, ldc,
        )
    }
    pub unsafe fn cublasDtrmm_v2_64(
        &self,
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: i64,
        n: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        B: *const f64,
        ldb: i64,
        C: *mut f64,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasDtrmm_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, C, ldc,
        )
    }
    pub unsafe fn cublasCtrmm_v2(
        &self,
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCtrmm_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, C, ldc,
        )
    }
    pub unsafe fn cublasCtrmm_v2_64(
        &self,
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: i64,
        n: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        B: *const cuComplex,
        ldb: i64,
        C: *mut cuComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCtrmm_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, C, ldc,
        )
    }
    pub unsafe fn cublasZtrmm_v2(
        &self,
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZtrmm_v2
            .as_ref()
            .expect("Expected function, got error."))(
            handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, C, ldc,
        )
    }
    pub unsafe fn cublasZtrmm_v2_64(
        &self,
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: i64,
        n: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        B: *const cuDoubleComplex,
        ldb: i64,
        C: *mut cuDoubleComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZtrmm_v2_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, C, ldc,
        )
    }
    pub unsafe fn cublasSgemmBatched(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f32,
        Aarray: *const *const f32,
        lda: ::core::ffi::c_int,
        Barray: *const *const f32,
        ldb: ::core::ffi::c_int,
        beta: *const f32,
        Carray: *const *mut f32,
        ldc: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasSgemmBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, k, alpha, Aarray, lda, Barray, ldb, beta, Carray, ldc,
            batchCount,
        )
    }
    pub unsafe fn cublasSgemmBatched_64(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const f32,
        Aarray: *const *const f32,
        lda: i64,
        Barray: *const *const f32,
        ldb: i64,
        beta: *const f32,
        Carray: *const *mut f32,
        ldc: i64,
        batchCount: i64,
    ) -> cublasStatus_t {
        (self
            .cublasSgemmBatched_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, k, alpha, Aarray, lda, Barray, ldb, beta, Carray, ldc,
            batchCount,
        )
    }
    pub unsafe fn cublasDgemmBatched(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f64,
        Aarray: *const *const f64,
        lda: ::core::ffi::c_int,
        Barray: *const *const f64,
        ldb: ::core::ffi::c_int,
        beta: *const f64,
        Carray: *const *mut f64,
        ldc: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasDgemmBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, k, alpha, Aarray, lda, Barray, ldb, beta, Carray, ldc,
            batchCount,
        )
    }
    pub unsafe fn cublasDgemmBatched_64(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const f64,
        Aarray: *const *const f64,
        lda: i64,
        Barray: *const *const f64,
        ldb: i64,
        beta: *const f64,
        Carray: *const *mut f64,
        ldc: i64,
        batchCount: i64,
    ) -> cublasStatus_t {
        (self
            .cublasDgemmBatched_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, k, alpha, Aarray, lda, Barray, ldb, beta, Carray, ldc,
            batchCount,
        )
    }
    pub unsafe fn cublasCgemmBatched(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        Aarray: *const *const cuComplex,
        lda: ::core::ffi::c_int,
        Barray: *const *const cuComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuComplex,
        Carray: *const *mut cuComplex,
        ldc: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCgemmBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, k, alpha, Aarray, lda, Barray, ldb, beta, Carray, ldc,
            batchCount,
        )
    }
    pub unsafe fn cublasCgemmBatched_64(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        Aarray: *const *const cuComplex,
        lda: i64,
        Barray: *const *const cuComplex,
        ldb: i64,
        beta: *const cuComplex,
        Carray: *const *mut cuComplex,
        ldc: i64,
        batchCount: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCgemmBatched_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, k, alpha, Aarray, lda, Barray, ldb, beta, Carray, ldc,
            batchCount,
        )
    }
    pub unsafe fn cublasCgemm3mBatched(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        Aarray: *const *const cuComplex,
        lda: ::core::ffi::c_int,
        Barray: *const *const cuComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuComplex,
        Carray: *const *mut cuComplex,
        ldc: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCgemm3mBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, k, alpha, Aarray, lda, Barray, ldb, beta, Carray, ldc,
            batchCount,
        )
    }
    pub unsafe fn cublasCgemm3mBatched_64(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        Aarray: *const *const cuComplex,
        lda: i64,
        Barray: *const *const cuComplex,
        ldb: i64,
        beta: *const cuComplex,
        Carray: *const *mut cuComplex,
        ldc: i64,
        batchCount: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCgemm3mBatched_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, k, alpha, Aarray, lda, Barray, ldb, beta, Carray, ldc,
            batchCount,
        )
    }
    pub unsafe fn cublasZgemmBatched(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        Aarray: *const *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        Barray: *const *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        Carray: *const *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZgemmBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, k, alpha, Aarray, lda, Barray, ldb, beta, Carray, ldc,
            batchCount,
        )
    }
    pub unsafe fn cublasZgemmBatched_64(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const cuDoubleComplex,
        Aarray: *const *const cuDoubleComplex,
        lda: i64,
        Barray: *const *const cuDoubleComplex,
        ldb: i64,
        beta: *const cuDoubleComplex,
        Carray: *const *mut cuDoubleComplex,
        ldc: i64,
        batchCount: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZgemmBatched_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, k, alpha, Aarray, lda, Barray, ldb, beta, Carray, ldc,
            batchCount,
        )
    }
    pub unsafe fn cublasSgemmStridedBatched(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        strideA: ::core::ffi::c_longlong,
        B: *const f32,
        ldb: ::core::ffi::c_int,
        strideB: ::core::ffi::c_longlong,
        beta: *const f32,
        C: *mut f32,
        ldc: ::core::ffi::c_int,
        strideC: ::core::ffi::c_longlong,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasSgemmStridedBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, k, alpha, A, lda, strideA, B, ldb, strideB, beta, C, ldc,
            strideC, batchCount,
        )
    }
    pub unsafe fn cublasSgemmStridedBatched_64(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        strideA: ::core::ffi::c_longlong,
        B: *const f32,
        ldb: i64,
        strideB: ::core::ffi::c_longlong,
        beta: *const f32,
        C: *mut f32,
        ldc: i64,
        strideC: ::core::ffi::c_longlong,
        batchCount: i64,
    ) -> cublasStatus_t {
        (self
            .cublasSgemmStridedBatched_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, k, alpha, A, lda, strideA, B, ldb, strideB, beta, C, ldc,
            strideC, batchCount,
        )
    }
    pub unsafe fn cublasDgemmStridedBatched(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        strideA: ::core::ffi::c_longlong,
        B: *const f64,
        ldb: ::core::ffi::c_int,
        strideB: ::core::ffi::c_longlong,
        beta: *const f64,
        C: *mut f64,
        ldc: ::core::ffi::c_int,
        strideC: ::core::ffi::c_longlong,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasDgemmStridedBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, k, alpha, A, lda, strideA, B, ldb, strideB, beta, C, ldc,
            strideC, batchCount,
        )
    }
    pub unsafe fn cublasDgemmStridedBatched_64(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        strideA: ::core::ffi::c_longlong,
        B: *const f64,
        ldb: i64,
        strideB: ::core::ffi::c_longlong,
        beta: *const f64,
        C: *mut f64,
        ldc: i64,
        strideC: ::core::ffi::c_longlong,
        batchCount: i64,
    ) -> cublasStatus_t {
        (self
            .cublasDgemmStridedBatched_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, k, alpha, A, lda, strideA, B, ldb, strideB, beta, C, ldc,
            strideC, batchCount,
        )
    }
    pub unsafe fn cublasCgemmStridedBatched(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        strideA: ::core::ffi::c_longlong,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        strideB: ::core::ffi::c_longlong,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
        strideC: ::core::ffi::c_longlong,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCgemmStridedBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, k, alpha, A, lda, strideA, B, ldb, strideB, beta, C, ldc,
            strideC, batchCount,
        )
    }
    pub unsafe fn cublasCgemmStridedBatched_64(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        strideA: ::core::ffi::c_longlong,
        B: *const cuComplex,
        ldb: i64,
        strideB: ::core::ffi::c_longlong,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: i64,
        strideC: ::core::ffi::c_longlong,
        batchCount: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCgemmStridedBatched_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, k, alpha, A, lda, strideA, B, ldb, strideB, beta, C, ldc,
            strideC, batchCount,
        )
    }
    pub unsafe fn cublasCgemm3mStridedBatched(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        strideA: ::core::ffi::c_longlong,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        strideB: ::core::ffi::c_longlong,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
        strideC: ::core::ffi::c_longlong,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCgemm3mStridedBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, k, alpha, A, lda, strideA, B, ldb, strideB, beta, C, ldc,
            strideC, batchCount,
        )
    }
    pub unsafe fn cublasCgemm3mStridedBatched_64(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        strideA: ::core::ffi::c_longlong,
        B: *const cuComplex,
        ldb: i64,
        strideB: ::core::ffi::c_longlong,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: i64,
        strideC: ::core::ffi::c_longlong,
        batchCount: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCgemm3mStridedBatched_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, k, alpha, A, lda, strideA, B, ldb, strideB, beta, C, ldc,
            strideC, batchCount,
        )
    }
    pub unsafe fn cublasZgemmStridedBatched(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        strideA: ::core::ffi::c_longlong,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        strideB: ::core::ffi::c_longlong,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
        strideC: ::core::ffi::c_longlong,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZgemmStridedBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, k, alpha, A, lda, strideA, B, ldb, strideB, beta, C, ldc,
            strideC, batchCount,
        )
    }
    pub unsafe fn cublasZgemmStridedBatched_64(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        strideA: ::core::ffi::c_longlong,
        B: *const cuDoubleComplex,
        ldb: i64,
        strideB: ::core::ffi::c_longlong,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: i64,
        strideC: ::core::ffi::c_longlong,
        batchCount: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZgemmStridedBatched_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, k, alpha, A, lda, strideA, B, ldb, strideB, beta, C, ldc,
            strideC, batchCount,
        )
    }
    pub unsafe fn cublasGemmBatchedEx(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const ::core::ffi::c_void,
        Aarray: *const *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: ::core::ffi::c_int,
        Barray: *const *const ::core::ffi::c_void,
        Btype: cudaDataType,
        ldb: ::core::ffi::c_int,
        beta: *const ::core::ffi::c_void,
        Carray: *const *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
        computeType: cublasComputeType_t,
        algo: cublasGemmAlgo_t,
    ) -> cublasStatus_t {
        (self
            .cublasGemmBatchedEx
            .as_ref()
            .expect("Expected function, got error."))(
            handle,
            transa,
            transb,
            m,
            n,
            k,
            alpha,
            Aarray,
            Atype,
            lda,
            Barray,
            Btype,
            ldb,
            beta,
            Carray,
            Ctype,
            ldc,
            batchCount,
            computeType,
            algo,
        )
    }
    pub unsafe fn cublasGemmBatchedEx_64(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const ::core::ffi::c_void,
        Aarray: *const *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: i64,
        Barray: *const *const ::core::ffi::c_void,
        Btype: cudaDataType,
        ldb: i64,
        beta: *const ::core::ffi::c_void,
        Carray: *const *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: i64,
        batchCount: i64,
        computeType: cublasComputeType_t,
        algo: cublasGemmAlgo_t,
    ) -> cublasStatus_t {
        (self
            .cublasGemmBatchedEx_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle,
            transa,
            transb,
            m,
            n,
            k,
            alpha,
            Aarray,
            Atype,
            lda,
            Barray,
            Btype,
            ldb,
            beta,
            Carray,
            Ctype,
            ldc,
            batchCount,
            computeType,
            algo,
        )
    }
    pub unsafe fn cublasGemmStridedBatchedEx(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const ::core::ffi::c_void,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: ::core::ffi::c_int,
        strideA: ::core::ffi::c_longlong,
        B: *const ::core::ffi::c_void,
        Btype: cudaDataType,
        ldb: ::core::ffi::c_int,
        strideB: ::core::ffi::c_longlong,
        beta: *const ::core::ffi::c_void,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: ::core::ffi::c_int,
        strideC: ::core::ffi::c_longlong,
        batchCount: ::core::ffi::c_int,
        computeType: cublasComputeType_t,
        algo: cublasGemmAlgo_t,
    ) -> cublasStatus_t {
        (self
            .cublasGemmStridedBatchedEx
            .as_ref()
            .expect("Expected function, got error."))(
            handle,
            transa,
            transb,
            m,
            n,
            k,
            alpha,
            A,
            Atype,
            lda,
            strideA,
            B,
            Btype,
            ldb,
            strideB,
            beta,
            C,
            Ctype,
            ldc,
            strideC,
            batchCount,
            computeType,
            algo,
        )
    }
    pub unsafe fn cublasGemmStridedBatchedEx_64(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const ::core::ffi::c_void,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: i64,
        strideA: ::core::ffi::c_longlong,
        B: *const ::core::ffi::c_void,
        Btype: cudaDataType,
        ldb: i64,
        strideB: ::core::ffi::c_longlong,
        beta: *const ::core::ffi::c_void,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: i64,
        strideC: ::core::ffi::c_longlong,
        batchCount: i64,
        computeType: cublasComputeType_t,
        algo: cublasGemmAlgo_t,
    ) -> cublasStatus_t {
        (self
            .cublasGemmStridedBatchedEx_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle,
            transa,
            transb,
            m,
            n,
            k,
            alpha,
            A,
            Atype,
            lda,
            strideA,
            B,
            Btype,
            ldb,
            strideB,
            beta,
            C,
            Ctype,
            ldc,
            strideC,
            batchCount,
            computeType,
            algo,
        )
    }
    pub unsafe fn cublasSgeam(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        beta: *const f32,
        B: *const f32,
        ldb: ::core::ffi::c_int,
        C: *mut f32,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasSgeam
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, alpha, A, lda, beta, B, ldb, C, ldc,
        )
    }
    pub unsafe fn cublasSgeam_64(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        beta: *const f32,
        B: *const f32,
        ldb: i64,
        C: *mut f32,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasSgeam_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, alpha, A, lda, beta, B, ldb, C, ldc,
        )
    }
    pub unsafe fn cublasDgeam(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        beta: *const f64,
        B: *const f64,
        ldb: ::core::ffi::c_int,
        C: *mut f64,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasDgeam
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, alpha, A, lda, beta, B, ldb, C, ldc,
        )
    }
    pub unsafe fn cublasDgeam_64(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        beta: *const f64,
        B: *const f64,
        ldb: i64,
        C: *mut f64,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasDgeam_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, alpha, A, lda, beta, B, ldb, C, ldc,
        )
    }
    pub unsafe fn cublasCgeam(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        beta: *const cuComplex,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCgeam
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, alpha, A, lda, beta, B, ldb, C, ldc,
        )
    }
    pub unsafe fn cublasCgeam_64(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        beta: *const cuComplex,
        B: *const cuComplex,
        ldb: i64,
        C: *mut cuComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCgeam_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, alpha, A, lda, beta, B, ldb, C, ldc,
        )
    }
    pub unsafe fn cublasZgeam(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZgeam
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, alpha, A, lda, beta, B, ldb, C, ldc,
        )
    }
    pub unsafe fn cublasZgeam_64(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        beta: *const cuDoubleComplex,
        B: *const cuDoubleComplex,
        ldb: i64,
        C: *mut cuDoubleComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZgeam_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, m, n, alpha, A, lda, beta, B, ldb, C, ldc,
        )
    }
    pub unsafe fn cublasStrsmBatched(
        &self,
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const *const f32,
        lda: ::core::ffi::c_int,
        B: *const *mut f32,
        ldb: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasStrsmBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, batchCount,
        )
    }
    pub unsafe fn cublasStrsmBatched_64(
        &self,
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: i64,
        n: i64,
        alpha: *const f32,
        A: *const *const f32,
        lda: i64,
        B: *const *mut f32,
        ldb: i64,
        batchCount: i64,
    ) -> cublasStatus_t {
        (self
            .cublasStrsmBatched_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, batchCount,
        )
    }
    pub unsafe fn cublasDtrsmBatched(
        &self,
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const *const f64,
        lda: ::core::ffi::c_int,
        B: *const *mut f64,
        ldb: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasDtrsmBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, batchCount,
        )
    }
    pub unsafe fn cublasDtrsmBatched_64(
        &self,
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: i64,
        n: i64,
        alpha: *const f64,
        A: *const *const f64,
        lda: i64,
        B: *const *mut f64,
        ldb: i64,
        batchCount: i64,
    ) -> cublasStatus_t {
        (self
            .cublasDtrsmBatched_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, batchCount,
        )
    }
    pub unsafe fn cublasCtrsmBatched(
        &self,
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const *const cuComplex,
        lda: ::core::ffi::c_int,
        B: *const *mut cuComplex,
        ldb: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCtrsmBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, batchCount,
        )
    }
    pub unsafe fn cublasCtrsmBatched_64(
        &self,
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: i64,
        n: i64,
        alpha: *const cuComplex,
        A: *const *const cuComplex,
        lda: i64,
        B: *const *mut cuComplex,
        ldb: i64,
        batchCount: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCtrsmBatched_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, batchCount,
        )
    }
    pub unsafe fn cublasZtrsmBatched(
        &self,
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        B: *const *mut cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZtrsmBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, batchCount,
        )
    }
    pub unsafe fn cublasZtrsmBatched_64(
        &self,
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: i64,
        n: i64,
        alpha: *const cuDoubleComplex,
        A: *const *const cuDoubleComplex,
        lda: i64,
        B: *const *mut cuDoubleComplex,
        ldb: i64,
        batchCount: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZtrsmBatched_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, batchCount,
        )
    }
    pub unsafe fn cublasSdgmm(
        &self,
        handle: cublasHandle_t,
        mode: cublasSideMode_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        A: *const f32,
        lda: ::core::ffi::c_int,
        x: *const f32,
        incx: ::core::ffi::c_int,
        C: *mut f32,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasSdgmm
            .as_ref()
            .expect("Expected function, got error."))(
            handle, mode, m, n, A, lda, x, incx, C, ldc
        )
    }
    pub unsafe fn cublasSdgmm_64(
        &self,
        handle: cublasHandle_t,
        mode: cublasSideMode_t,
        m: i64,
        n: i64,
        A: *const f32,
        lda: i64,
        x: *const f32,
        incx: i64,
        C: *mut f32,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasSdgmm_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, mode, m, n, A, lda, x, incx, C, ldc
        )
    }
    pub unsafe fn cublasDdgmm(
        &self,
        handle: cublasHandle_t,
        mode: cublasSideMode_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        A: *const f64,
        lda: ::core::ffi::c_int,
        x: *const f64,
        incx: ::core::ffi::c_int,
        C: *mut f64,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasDdgmm
            .as_ref()
            .expect("Expected function, got error."))(
            handle, mode, m, n, A, lda, x, incx, C, ldc
        )
    }
    pub unsafe fn cublasDdgmm_64(
        &self,
        handle: cublasHandle_t,
        mode: cublasSideMode_t,
        m: i64,
        n: i64,
        A: *const f64,
        lda: i64,
        x: *const f64,
        incx: i64,
        C: *mut f64,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasDdgmm_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, mode, m, n, A, lda, x, incx, C, ldc
        )
    }
    pub unsafe fn cublasCdgmm(
        &self,
        handle: cublasHandle_t,
        mode: cublasSideMode_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCdgmm
            .as_ref()
            .expect("Expected function, got error."))(
            handle, mode, m, n, A, lda, x, incx, C, ldc
        )
    }
    pub unsafe fn cublasCdgmm_64(
        &self,
        handle: cublasHandle_t,
        mode: cublasSideMode_t,
        m: i64,
        n: i64,
        A: *const cuComplex,
        lda: i64,
        x: *const cuComplex,
        incx: i64,
        C: *mut cuComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasCdgmm_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, mode, m, n, A, lda, x, incx, C, ldc
        )
    }
    pub unsafe fn cublasZdgmm(
        &self,
        handle: cublasHandle_t,
        mode: cublasSideMode_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZdgmm
            .as_ref()
            .expect("Expected function, got error."))(
            handle, mode, m, n, A, lda, x, incx, C, ldc
        )
    }
    pub unsafe fn cublasZdgmm_64(
        &self,
        handle: cublasHandle_t,
        mode: cublasSideMode_t,
        m: i64,
        n: i64,
        A: *const cuDoubleComplex,
        lda: i64,
        x: *const cuDoubleComplex,
        incx: i64,
        C: *mut cuDoubleComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (self
            .cublasZdgmm_64
            .as_ref()
            .expect("Expected function, got error."))(
            handle, mode, m, n, A, lda, x, incx, C, ldc
        )
    }
    pub unsafe fn cublasSmatinvBatched(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        A: *const *const f32,
        lda: ::core::ffi::c_int,
        Ainv: *const *mut f32,
        lda_inv: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasSmatinvBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle, n, A, lda, Ainv, lda_inv, info, batchSize,
        )
    }
    pub unsafe fn cublasDmatinvBatched(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        A: *const *const f64,
        lda: ::core::ffi::c_int,
        Ainv: *const *mut f64,
        lda_inv: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasDmatinvBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle, n, A, lda, Ainv, lda_inv, info, batchSize,
        )
    }
    pub unsafe fn cublasCmatinvBatched(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        A: *const *const cuComplex,
        lda: ::core::ffi::c_int,
        Ainv: *const *mut cuComplex,
        lda_inv: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCmatinvBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle, n, A, lda, Ainv, lda_inv, info, batchSize,
        )
    }
    pub unsafe fn cublasZmatinvBatched(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        A: *const *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        Ainv: *const *mut cuDoubleComplex,
        lda_inv: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZmatinvBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle, n, A, lda, Ainv, lda_inv, info, batchSize,
        )
    }
    pub unsafe fn cublasSgeqrfBatched(
        &self,
        handle: cublasHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        Aarray: *const *mut f32,
        lda: ::core::ffi::c_int,
        TauArray: *const *mut f32,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasSgeqrfBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle, m, n, Aarray, lda, TauArray, info, batchSize,
        )
    }
    pub unsafe fn cublasDgeqrfBatched(
        &self,
        handle: cublasHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        Aarray: *const *mut f64,
        lda: ::core::ffi::c_int,
        TauArray: *const *mut f64,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasDgeqrfBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle, m, n, Aarray, lda, TauArray, info, batchSize,
        )
    }
    pub unsafe fn cublasCgeqrfBatched(
        &self,
        handle: cublasHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        Aarray: *const *mut cuComplex,
        lda: ::core::ffi::c_int,
        TauArray: *const *mut cuComplex,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCgeqrfBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle, m, n, Aarray, lda, TauArray, info, batchSize,
        )
    }
    pub unsafe fn cublasZgeqrfBatched(
        &self,
        handle: cublasHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        Aarray: *const *mut cuDoubleComplex,
        lda: ::core::ffi::c_int,
        TauArray: *const *mut cuDoubleComplex,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZgeqrfBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle, m, n, Aarray, lda, TauArray, info, batchSize,
        )
    }
    pub unsafe fn cublasSgelsBatched(
        &self,
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        Aarray: *const *mut f32,
        lda: ::core::ffi::c_int,
        Carray: *const *mut f32,
        ldc: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        devInfoArray: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasSgelsBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle,
            trans,
            m,
            n,
            nrhs,
            Aarray,
            lda,
            Carray,
            ldc,
            info,
            devInfoArray,
            batchSize,
        )
    }
    pub unsafe fn cublasDgelsBatched(
        &self,
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        Aarray: *const *mut f64,
        lda: ::core::ffi::c_int,
        Carray: *const *mut f64,
        ldc: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        devInfoArray: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasDgelsBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle,
            trans,
            m,
            n,
            nrhs,
            Aarray,
            lda,
            Carray,
            ldc,
            info,
            devInfoArray,
            batchSize,
        )
    }
    pub unsafe fn cublasCgelsBatched(
        &self,
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        Aarray: *const *mut cuComplex,
        lda: ::core::ffi::c_int,
        Carray: *const *mut cuComplex,
        ldc: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        devInfoArray: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCgelsBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle,
            trans,
            m,
            n,
            nrhs,
            Aarray,
            lda,
            Carray,
            ldc,
            info,
            devInfoArray,
            batchSize,
        )
    }
    pub unsafe fn cublasZgelsBatched(
        &self,
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        Aarray: *const *mut cuDoubleComplex,
        lda: ::core::ffi::c_int,
        Carray: *const *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        devInfoArray: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZgelsBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle,
            trans,
            m,
            n,
            nrhs,
            Aarray,
            lda,
            Carray,
            ldc,
            info,
            devInfoArray,
            batchSize,
        )
    }
    pub unsafe fn cublasStpttr(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        AP: *const f32,
        A: *mut f32,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasStpttr
            .as_ref()
            .expect("Expected function, got error."))(handle, uplo, n, AP, A, lda)
    }
    pub unsafe fn cublasDtpttr(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        AP: *const f64,
        A: *mut f64,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasDtpttr
            .as_ref()
            .expect("Expected function, got error."))(handle, uplo, n, AP, A, lda)
    }
    pub unsafe fn cublasCtpttr(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        AP: *const cuComplex,
        A: *mut cuComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCtpttr
            .as_ref()
            .expect("Expected function, got error."))(handle, uplo, n, AP, A, lda)
    }
    pub unsafe fn cublasZtpttr(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        AP: *const cuDoubleComplex,
        A: *mut cuDoubleComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZtpttr
            .as_ref()
            .expect("Expected function, got error."))(handle, uplo, n, AP, A, lda)
    }
    pub unsafe fn cublasStrttp(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        A: *const f32,
        lda: ::core::ffi::c_int,
        AP: *mut f32,
    ) -> cublasStatus_t {
        (self
            .cublasStrttp
            .as_ref()
            .expect("Expected function, got error."))(handle, uplo, n, A, lda, AP)
    }
    pub unsafe fn cublasDtrttp(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        A: *const f64,
        lda: ::core::ffi::c_int,
        AP: *mut f64,
    ) -> cublasStatus_t {
        (self
            .cublasDtrttp
            .as_ref()
            .expect("Expected function, got error."))(handle, uplo, n, A, lda, AP)
    }
    pub unsafe fn cublasCtrttp(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        AP: *mut cuComplex,
    ) -> cublasStatus_t {
        (self
            .cublasCtrttp
            .as_ref()
            .expect("Expected function, got error."))(handle, uplo, n, A, lda, AP)
    }
    pub unsafe fn cublasZtrttp(
        &self,
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        AP: *mut cuDoubleComplex,
    ) -> cublasStatus_t {
        (self
            .cublasZtrttp
            .as_ref()
            .expect("Expected function, got error."))(handle, uplo, n, A, lda, AP)
    }
    pub unsafe fn cublasSgetrfBatched(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        A: *const *mut f32,
        lda: ::core::ffi::c_int,
        P: *mut ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasSgetrfBatched
            .as_ref()
            .expect("Expected function, got error."))(handle, n, A, lda, P, info, batchSize)
    }
    pub unsafe fn cublasDgetrfBatched(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        A: *const *mut f64,
        lda: ::core::ffi::c_int,
        P: *mut ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasDgetrfBatched
            .as_ref()
            .expect("Expected function, got error."))(handle, n, A, lda, P, info, batchSize)
    }
    pub unsafe fn cublasCgetrfBatched(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        A: *const *mut cuComplex,
        lda: ::core::ffi::c_int,
        P: *mut ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCgetrfBatched
            .as_ref()
            .expect("Expected function, got error."))(handle, n, A, lda, P, info, batchSize)
    }
    pub unsafe fn cublasZgetrfBatched(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        A: *const *mut cuDoubleComplex,
        lda: ::core::ffi::c_int,
        P: *mut ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZgetrfBatched
            .as_ref()
            .expect("Expected function, got error."))(handle, n, A, lda, P, info, batchSize)
    }
    pub unsafe fn cublasSgetriBatched(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        A: *const *const f32,
        lda: ::core::ffi::c_int,
        P: *const ::core::ffi::c_int,
        C: *const *mut f32,
        ldc: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasSgetriBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle, n, A, lda, P, C, ldc, info, batchSize
        )
    }
    pub unsafe fn cublasDgetriBatched(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        A: *const *const f64,
        lda: ::core::ffi::c_int,
        P: *const ::core::ffi::c_int,
        C: *const *mut f64,
        ldc: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasDgetriBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle, n, A, lda, P, C, ldc, info, batchSize
        )
    }
    pub unsafe fn cublasCgetriBatched(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        A: *const *const cuComplex,
        lda: ::core::ffi::c_int,
        P: *const ::core::ffi::c_int,
        C: *const *mut cuComplex,
        ldc: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCgetriBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle, n, A, lda, P, C, ldc, info, batchSize
        )
    }
    pub unsafe fn cublasZgetriBatched(
        &self,
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        A: *const *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        P: *const ::core::ffi::c_int,
        C: *const *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZgetriBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle, n, A, lda, P, C, ldc, info, batchSize
        )
    }
    pub unsafe fn cublasSgetrsBatched(
        &self,
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        Aarray: *const *const f32,
        lda: ::core::ffi::c_int,
        devIpiv: *const ::core::ffi::c_int,
        Barray: *const *mut f32,
        ldb: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasSgetrsBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle, trans, n, nrhs, Aarray, lda, devIpiv, Barray, ldb, info, batchSize,
        )
    }
    pub unsafe fn cublasDgetrsBatched(
        &self,
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        Aarray: *const *const f64,
        lda: ::core::ffi::c_int,
        devIpiv: *const ::core::ffi::c_int,
        Barray: *const *mut f64,
        ldb: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasDgetrsBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle, trans, n, nrhs, Aarray, lda, devIpiv, Barray, ldb, info, batchSize,
        )
    }
    pub unsafe fn cublasCgetrsBatched(
        &self,
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        Aarray: *const *const cuComplex,
        lda: ::core::ffi::c_int,
        devIpiv: *const ::core::ffi::c_int,
        Barray: *const *mut cuComplex,
        ldb: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasCgetrsBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle, trans, n, nrhs, Aarray, lda, devIpiv, Barray, ldb, info, batchSize,
        )
    }
    pub unsafe fn cublasZgetrsBatched(
        &self,
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        Aarray: *const *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        devIpiv: *const ::core::ffi::c_int,
        Barray: *const *mut cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasZgetrsBatched
            .as_ref()
            .expect("Expected function, got error."))(
            handle, trans, n, nrhs, Aarray, lda, devIpiv, Barray, ldb, info, batchSize,
        )
    }
    pub unsafe fn cublasUint8gemmBias(
        &self,
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        transc: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        A: *const ::core::ffi::c_uchar,
        A_bias: ::core::ffi::c_int,
        lda: ::core::ffi::c_int,
        B: *const ::core::ffi::c_uchar,
        B_bias: ::core::ffi::c_int,
        ldb: ::core::ffi::c_int,
        C: *mut ::core::ffi::c_uchar,
        C_bias: ::core::ffi::c_int,
        ldc: ::core::ffi::c_int,
        C_mult: ::core::ffi::c_int,
        C_shift: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (self
            .cublasUint8gemmBias
            .as_ref()
            .expect("Expected function, got error."))(
            handle, transa, transb, transc, m, n, k, A, A_bias, lda, B, B_bias, ldb, C, C_bias,
            ldc, C_mult, C_shift,
        )
    }
}
