/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.open.resources;

import com.jeta.open.registry.JETARegistry;
import com.jeta.open.resources.ResourceLoader;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public class AppResourceLoader
implements ResourceLoader {
    private ClassLoader m_classloader;
    private static ImageIcon m_empty_icon;
    private static Hashtable m_imagecache;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ClassLoader getClassLoader() {
        if (this.m_classloader == null) {
            return AppResourceLoader.class.getClassLoader();
        }
        return this.m_classloader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageIcon getEmptyIcon() {
        Class clazz = AppResourceLoader.class;
        synchronized (clazz) {
            if (m_empty_icon == null) {
                int n = 16;
                int n2 = 16;
                BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setColor(UIManager.getColor("control"));
                graphics2D.fillRect(0, 0, n, n2);
                graphics2D.setColor(Color.red);
                graphics2D.drawRect(0, 0, n - 1, n2 - 1);
                graphics2D.drawLine(0, 0, n - 1, n2 - 1);
                graphics2D.drawLine(0, n2 - 1, n - 1, 0);
                graphics2D.dispose();
                m_empty_icon = new ImageIcon(bufferedImage);
            }
        }
        return m_empty_icon;
    }

    public InputStream getResourceAsStream(String string) throws IOException {
        ClassLoader classLoader = this.getClassLoader();
        return classLoader.getResourceAsStream(string);
    }

    public static ImageIcon getImage(String string) {
        if (string != null) {
            ImageIcon imageIcon = (ImageIcon)m_imagecache.get(string);
            if (imageIcon == null) {
                try {
                    ResourceLoader resourceLoader = (ResourceLoader)JETARegistry.lookup("jeta.resourceloader");
                    if (!$assertionsDisabled && resourceLoader == null) {
                        throw new AssertionError();
                    }
                    imageIcon = resourceLoader.loadImage(string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (imageIcon == null) {
                    imageIcon = new ImageIcon();
                }
                m_imagecache.put(string, imageIcon);
            }
            return imageIcon;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return m_empty_icon;
    }

    public ImageIcon loadImage(String string) {
        try {
            ClassLoader classLoader = this.getClassLoader();
            URL uRL = classLoader.getResource(string);
            if (uRL != null) {
                ImageIcon imageIcon = new ImageIcon(uRL);
                return imageIcon;
            }
            System.err.println("AppResourceLoader.loadImage failed: " + string);
        }
        catch (Exception exception) {
            System.err.println("AppResourceLoader.loadImage failed: " + string);
            exception.printStackTrace();
        }
        return AppResourceLoader.getEmptyIcon();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.m_classloader = classLoader;
    }

    static {
        $assertionsDisabled = !AppResourceLoader.class.desiredAssertionStatus();
        m_imagecache = new Hashtable();
    }
}

