/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.properties.effects;

import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.gui.effects.Paintable;
import com.jeta.forms.gui.effects.Painter;
import com.jeta.forms.gui.effects.TexturePainter;
import com.jeta.forms.store.properties.IconProperty;
import com.jeta.forms.store.properties.JETAProperty;
import com.jeta.forms.store.properties.effects.PaintSupport;
import com.jeta.open.i18n.I18N;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class TextureProperty
extends JETAProperty
implements Externalizable,
PaintSupport {
    static final long serialVersionUID = 6397209471447777696L;
    public static final int VERSION = 1;
    private IconProperty m_icon;
    private transient BufferedImage m_buffered_image;
    private transient TexturePainter m_painter;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Painter createPainter() {
        if (this.m_painter == null) {
            this.m_painter = new TexturePainter(this);
        }
        return this.m_painter;
    }

    public BufferedImage getBufferedImage() {
        if (this.m_buffered_image == null && this.m_icon != null) {
            int n = this.m_icon.getIconWidth();
            int n2 = this.m_icon.getIconHeight();
            this.m_buffered_image = new BufferedImage(n, n2, 1);
            Graphics2D graphics2D = this.m_buffered_image.createGraphics();
            graphics2D.drawImage(this.m_icon.imageIcon().getImage(), 0, 0, graphics2D.getColor(), null);
            graphics2D.dispose();
        }
        return this.m_buffered_image;
    }

    public IconProperty getIconProperty() {
        return this.m_icon;
    }

    public void setIconProperty(IconProperty iconProperty) {
        this.m_icon = iconProperty;
        this.m_buffered_image = null;
        this.m_painter = null;
    }

    public void setValue(Object object) {
        if (object instanceof TextureProperty) {
            TextureProperty textureProperty = (TextureProperty)object;
            this.m_icon = textureProperty.m_icon;
            this.m_painter = null;
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void updateBean(JETABean jETABean) {
        Component component;
        TexturePainter texturePainter = (TexturePainter)this.createPainter();
        if (jETABean != null && (component = jETABean.getDelegate()) instanceof Paintable) {
            ((Paintable)((Object)component)).setBackgroundPainter(texturePainter);
        }
    }

    public String toString() {
        return I18N.getLocalizedMessage("Texture");
    }

    public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        super.readExternal(objectInput);
        int n = objectInput.readInt();
        this.m_icon = (IconProperty)objectInput.readObject();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeInt(1);
        objectOutput.writeObject(this.m_icon);
    }

    static {
        $assertionsDisabled = !TextureProperty.class.desiredAssertionStatus();
    }
}

