/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.properties;

import java.awt.Font;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class FontProperty
implements Externalizable {
    static final long serialVersionUID = -1878354825497611389L;
    public static final int VERSION = 1;
    private String m_family;
    private int m_style;
    private int m_size;
    private transient Font m_font;

    public FontProperty() {
    }

    public FontProperty(Font font) {
        if (font != null) {
            this.m_family = font.getFamily();
            this.m_style = font.getStyle();
            this.m_size = font.getSize();
            this.m_font = font;
        }
    }

    public Font getFont() {
        if (this.m_font == null) {
            if (this.m_family == null) {
                this.m_family = "Dialog";
            }
            if (this.m_size == 0) {
                this.m_size = 12;
            }
            this.m_font = new Font(this.m_family, this.m_style, this.m_size);
        }
        return this.m_font;
    }

    public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        int n = objectInput.readInt();
        this.m_family = (String)objectInput.readObject();
        this.m_style = objectInput.readInt();
        this.m_size = objectInput.readInt();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(1);
        objectOutput.writeObject(this.m_family);
        objectOutput.writeInt(this.m_style);
        objectOutput.writeInt(this.m_size);
    }
}

