/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.form;

import com.jeta.forms.components.panel.FormPanel;
import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.gui.beans.JETABeanFactory;
import com.jeta.forms.gui.common.FormException;
import com.jeta.forms.gui.common.FormUtils;
import com.jeta.forms.gui.form.GridComponent;
import com.jeta.forms.gui.form.GridView;
import com.jeta.forms.store.memento.BeanMemento;
import com.jeta.forms.store.memento.ComponentMemento;
import com.jeta.forms.store.memento.StateRequest;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.border.Border;

public class StandardComponent
extends GridComponent {
    private static Border m_design_border = BorderFactory.createEmptyBorder(2, 2, 2, 2);

    public StandardComponent() {
        if (FormUtils.isDesignMode()) {
            this.setBorder(m_design_border);
        }
    }

    public StandardComponent(GridView gridView) {
        super(gridView);
        if (FormUtils.isDesignMode()) {
            this.setBorder(m_design_border);
        }
    }

    public StandardComponent(JETABean jETABean, GridView gridView) {
        super(jETABean, gridView);
        this.setBean(jETABean);
        if (FormUtils.isDesignMode()) {
            this.setBorder(m_design_border);
        }
    }

    public ComponentMemento getState(StateRequest stateRequest) throws FormException {
        BeanMemento beanMemento = new BeanMemento();
        beanMemento.setCellConstraints(this.getConstraints().createCellConstraints());
        beanMemento.setComponentClass(this.getClass().getName());
        JETABean jETABean = this.getBean();
        if (jETABean != null) {
            jETABean.getState(beanMemento, stateRequest);
        }
        return beanMemento;
    }

    public void print() {
        JETABean jETABean = this.getBean();
        if (jETABean == null) {
            System.out.println("StandardComponent  name = " + this.getName() + "   hash: " + this.hashCode() + "   bean:  null");
        } else {
            System.out.println("StandardComponent  name = " + this.getName() + "   hash: " + this.hashCode() + "   bean: " + jETABean.getDelegate());
        }
    }

    public void postInitialize(FormPanel formPanel) {
        JETABean jETABean = this.getBean();
        if (jETABean != null) {
            jETABean.postInitialize(formPanel);
        }
    }

    protected void setBean(JETABean jETABean) {
        FormUtils.safeAssert(this.getComponentCount() == 0);
        super.setBean(jETABean);
        this.removeAll();
        this.setLayout(new BorderLayout());
        if (jETABean != null) {
            this.add((Component)jETABean, "Center");
        }
    }

    public void setState(ComponentMemento componentMemento) throws FormException {
        try {
            JETABean jETABean;
            BeanMemento beanMemento = (BeanMemento)componentMemento;
            if (FormUtils.isRuntime()) {
                JETABeanFactory.tryRegisterCustomFactory(beanMemento.getBeanClass(), true);
            }
            if ((jETABean = JETABeanFactory.createBean(beanMemento.getBeanClass(), null, false, true)) == null) {
                jETABean = new JETABean();
            }
            if (jETABean != null) {
                this.setBean(jETABean);
                jETABean.setState(beanMemento);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

