/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.bootstrap;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.NoSuchElementException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.tanukisoftware.wrapper.WrapperInfo;

public class WrapperBootstrap {
    private static boolean c_bootstrapInstance;
    private static final int ENTRYPOINT_MAINCLASS = 1;
    private static final int ENTRYPOINT_JAR = 3;
    private static boolean m_debug;

    public static boolean isBootstrapInstance() {
        return c_bootstrapInstance;
    }

    public static void main(String[] args) {
        c_bootstrapInstance = true;
        LinkedHashMap<String, String> tm = new LinkedHashMap<String, String>();
        tm.put("wrapper_version", WrapperInfo.getVersion());
        if (args.length < 3) {
            tm.put("wrong_argument_number", Integer.toString(args.length));
            WrapperBootstrap.printParseInformation(tm);
            System.err.println("WrapperBootstrap Error: Wrong argument number.");
            return;
        }
        try {
            m_debug = Integer.parseInt(args[2]) != 0;
        }
        catch (NumberFormatException e) {
            m_debug = false;
        }
        Class<?> mainClassClass = null;
        boolean findMainModule = false;
        int javaVersion = WrapperBootstrap.getJavaVersion();
        int id = Integer.parseInt(args[0]);
        if (id == 1) {
            try {
                mainClassClass = Class.forName(args[1]);
            }
            catch (ClassNotFoundException e) {
                tm.put("mainclass", "not found");
                mainClassClass = null;
            }
            catch (Throwable t) {
                tm.put("mainclass", "load failed");
                WrapperBootstrap.printParseInformation(tm);
                t.printStackTrace();
                return;
            }
            if (javaVersion >= 9) {
                findMainModule = true;
            }
        } else if (id == 3) {
            File file = new File(args[1]);
            if (!file.exists()) {
                tm.put("mainjar", "not found");
            } else {
                JarFile jarFile;
                try {
                    jarFile = new JarFile(file);
                }
                catch (IOException e) {
                    if (m_debug) {
                        WrapperBootstrap.printDebug("Can't open jar file - " + e.getMessage());
                    }
                    tm.put("mainjar", "can't open");
                    jarFile = null;
                }
                catch (SecurityException e) {
                    if (m_debug) {
                        WrapperBootstrap.printDebug("Can't open jar file - " + e.getMessage());
                    }
                    tm.put("mainjar", "access denied");
                    jarFile = null;
                }
                if (jarFile != null) {
                    Manifest manifest;
                    try {
                        manifest = jarFile.getManifest();
                    }
                    catch (IOException e) {
                        if (m_debug) {
                            WrapperBootstrap.printDebug("Jar file doesn't have a manifest - " + e.getMessage());
                        }
                        tm.put("mainjar", "no manifest");
                        manifest = null;
                    }
                    if (manifest != null) {
                        Attributes attributes = manifest.getMainAttributes();
                        String mainClassName = attributes.getValue("Main-Class");
                        if (mainClassName == null) {
                            tm.put("mainjar", "no mainclass");
                        } else {
                            URLClassLoader cl;
                            try {
                                URL[] classURLs = new URL[]{new URL("file:" + file.getAbsolutePath())};
                                cl = URLClassLoader.newInstance(classURLs, WrapperBootstrap.class.getClassLoader());
                            }
                            catch (MalformedURLException e) {
                                if (m_debug) {
                                    WrapperBootstrap.printDebug("Unable to add jar to classpath: " + e.getMessage());
                                }
                                cl = null;
                            }
                            try {
                                mainClassClass = cl == null ? Class.forName(mainClassName) : Class.forName(mainClassName, false, cl);
                                if (javaVersion >= 9) {
                                    findMainModule = true;
                                }
                            }
                            catch (ClassNotFoundException e) {
                                if (m_debug) {
                                    WrapperBootstrap.printDebug("Failed to retrieve main class - " + e.getMessage());
                                }
                                mainClassClass = null;
                            }
                            catch (Throwable t) {
                                tm.put("mainclass", "load failed - " + mainClassName);
                                WrapperBootstrap.printParseInformation(tm);
                                t.printStackTrace();
                                return;
                            }
                            if (mainClassClass != null) {
                                tm.put("mainclass", mainClassName);
                            } else {
                                tm.put("mainclass", "not found - " + mainClassName);
                            }
                        }
                        String classPath = attributes.getValue("Class-Path");
                        if (classPath == null) {
                            tm.put("mainjar", "no classpath");
                        } else {
                            tm.put("classpath", classPath);
                        }
                    }
                }
            }
        } else {
            tm.put("invalid_argument", "");
            WrapperBootstrap.printParseInformation(tm);
            System.err.println("WrapperBootstrap Error: Invalid argument(s).");
            return;
        }
        if (mainClassClass != null) {
            Package pkg;
            if (findMainModule) {
                String moduleName = null;
                try {
                    Method m = Class.class.getMethod("getModule", new Class[0]);
                    Object module = m.invoke(mainClassClass, new Object[0]);
                    m = module.getClass().getMethod("getName", new Class[0]);
                    moduleName = (String)m.invoke(module, new Object[0]);
                    if (moduleName != null) {
                        tm.put("mainmodule", moduleName);
                    } else {
                        tm.put("mainmodule", "unnamed");
                    }
                }
                catch (Exception e) {
                    if (m_debug) {
                        WrapperBootstrap.printDebug("Failed to retrieve main module - " + e.getMessage());
                    }
                    tm.put("mainmodule", "not found");
                }
            }
            if ((pkg = mainClassClass.getPackage()) != null) {
                tm.put("package", pkg.getName());
            } else {
                tm.put("package", "not found");
            }
        }
        if (javaVersion >= 9 && WrapperBootstrap.getModuleByName("java.management") == null) {
            tm.put("java.management", "not available");
        }
        WrapperBootstrap.printParseInformation(tm);
    }

    private static void printParseInformation(HashMap tm) {
        StringBuffer sb = new StringBuffer();
        Iterator iter = tm.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            sb.append("WrapperBootstrap: ");
            sb.append(name);
            sb.append(": ");
            sb.append((String)tm.get(name));
            if (!iter.hasNext()) continue;
            sb.append(System.getProperty("line.separator"));
        }
        System.out.println(sb.toString());
    }

    private static void printDebug(String message) {
        System.out.println("WrapperBootstrap Debug: " + message);
    }

    private static int getJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int i = version.indexOf(".");
            if (i != -1) {
                version = version.substring(0, i);
            }
        }
        return Integer.parseInt(version);
    }

    private static Object getModuleByName(String moduleName) {
        Object module;
        block10: {
            Class<?> moduleLayerClass;
            module = null;
            try {
                moduleLayerClass = Class.forName("java.lang.ModuleLayer");
            }
            catch (ClassNotFoundException e) {
                if (m_debug) {
                    WrapperBootstrap.printDebug("java.lang.ModuleLayer not found");
                }
                moduleLayerClass = null;
            }
            if (moduleLayerClass != null) {
                try {
                    Method m = moduleLayerClass.getMethod("boot", new Class[0]);
                    Object boot = m.invoke(null, new Object[0]);
                    if (boot != null) {
                        m = moduleLayerClass.getMethod("findModule", String.class);
                        Object optional = m.invoke(boot, moduleName);
                        m = optional.getClass().getMethod("get", new Class[0]);
                        try {
                            module = m.invoke(optional, new Object[0]);
                        }
                        catch (InvocationTargetException e) {
                            if (m_debug && e.getCause() instanceof NoSuchElementException) {
                                WrapperBootstrap.printDebug("Failed to find module.");
                            }
                        }
                    }
                }
                catch (Exception e) {
                    if (!m_debug) break block10;
                    WrapperBootstrap.printDebug("Failed to retrieve " + moduleName + " module - " + e.getMessage());
                }
            }
        }
        return module;
    }
}

