/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.NodeExecutionContext;
import org.gradle.composite.internal.BuildTreeWorkGraphController;
import org.gradle.composite.internal.IncludedBuildTaskResource;
import org.gradle.composite.internal.TaskIdentifier;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.SelfExecutingNode;
import org.gradle.execution.plan.TaskDependencyResolver;
import org.gradle.execution.plan.TaskNode;
import org.gradle.internal.lazy.Lazy;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.util.Path;
import org.jspecify.annotations.Nullable;

public abstract class TaskInAnotherBuild
extends TaskNode
implements SelfExecutingNode {
    private IncludedBuildTaskResource.State taskState = IncludedBuildTaskResource.State.Scheduled;
    private final Path taskIdentityPath;
    private final String taskPath;
    private final BuildIdentifier targetBuild;

    public static TaskInAnotherBuild of(TaskInternal task, BuildTreeWorkGraphController taskGraph) {
        BuildIdentifier targetBuild = TaskInAnotherBuild.buildIdentifierOf(task);
        TaskIdentifier.TaskBasedTaskIdentifier taskIdentifier = TaskIdentifier.of(targetBuild, task);
        final IncludedBuildTaskResource taskResource = taskGraph.locateTask(taskIdentifier);
        return new TaskInAnotherBuild(task.getIdentityPath(), task.getPath(), targetBuild){

            @Override
            protected IncludedBuildTaskResource getTarget() {
                return taskResource;
            }
        };
    }

    public static TaskInAnotherBuild lazy(String taskPath, BuildIdentifier targetBuild, BuildTreeWorkGraphController taskGraph) {
        TaskIdentifier taskIdentifier = TaskIdentifier.of(targetBuild, taskPath);
        Path taskIdentityPath = Path.path((String)targetBuild.getBuildPath()).append(Path.path((String)taskPath));
        final Lazy target = Lazy.unsafe().of(() -> taskGraph.locateTask(taskIdentifier));
        return new TaskInAnotherBuild(taskIdentityPath, taskPath, targetBuild){

            @Override
            protected IncludedBuildTaskResource getTarget() {
                return (IncludedBuildTaskResource)target.get();
            }
        };
    }

    protected TaskInAnotherBuild(Path taskIdentityPath, String taskPath, BuildIdentifier targetBuild) {
        this.taskIdentityPath = taskIdentityPath;
        this.taskPath = taskPath;
        this.targetBuild = targetBuild;
    }

    public BuildIdentifier getTargetBuild() {
        return this.targetBuild;
    }

    public String getTaskPath() {
        return this.taskPath;
    }

    public Path getTaskIdentityPath() {
        return this.taskIdentityPath;
    }

    @Override
    public TaskInternal getTask() {
        return this.getTarget().getTask();
    }

    @Override
    protected Node.ExecutionState getInitialState() {
        switch (this.getTarget().getTaskState()) {
            case Scheduled: 
            case NotScheduled: {
                return null;
            }
            case Success: {
                return Node.ExecutionState.EXECUTED;
            }
            case Failed: {
                return Node.ExecutionState.FAILED_DEPENDENCY;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public Set<Node> getLifecycleSuccessors() {
        return Collections.emptySet();
    }

    @Override
    public void setLifecycleSuccessors(Set<Node> successors) {
        if (!successors.isEmpty()) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void prepareForExecution(Action<Node> monitor) {
        this.getTarget().onComplete(() -> monitor.execute((Object)this));
    }

    @Override
    public @Nullable ResourceLock getProjectToLock() {
        return null;
    }

    @Override
    public @Nullable ProjectInternal getOwningProject() {
        return null;
    }

    public List<ResourceLock> getResourcesToLock() {
        return Collections.emptyList();
    }

    @Override
    public Throwable getNodeFailure() {
        return null;
    }

    @Override
    public void resolveDependencies(TaskDependencyResolver dependencyResolver) {
        this.getTarget().queueForExecution();
    }

    @Override
    public Node.DependenciesState doCheckDependenciesComplete() {
        Node.DependenciesState dependenciesState = super.doCheckDependenciesComplete();
        if (dependenciesState != Node.DependenciesState.COMPLETE_AND_SUCCESSFUL) {
            return dependenciesState;
        }
        if (!this.taskState.isComplete()) {
            this.taskState = this.getTarget().getTaskState();
        }
        switch (this.taskState) {
            case Scheduled: {
                return Node.DependenciesState.NOT_COMPLETE;
            }
            case Success: {
                return Node.DependenciesState.COMPLETE_AND_SUCCESSFUL;
            }
            case NotScheduled: 
            case Failed: {
                return Node.DependenciesState.COMPLETE_AND_NOT_SUCCESSFUL;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public String toString() {
        return "other build task " + this.taskIdentityPath;
    }

    @Override
    protected void nodeSpecificHealthDiagnostics(StringBuilder builder) {
        super.nodeSpecificHealthDiagnostics(builder);
        builder.append(", taskState=").append((Object)this.taskState).append(", ").append(this.getTarget().healthDiagnostics());
    }

    @Override
    public void execute(NodeExecutionContext context) {
    }

    private static BuildIdentifier buildIdentifierOf(TaskInternal task) {
        return ((ProjectInternal)task.getProject()).getOwner().getOwner().getBuildIdentifier();
    }

    protected abstract IncludedBuildTaskResource getTarget();
}

