/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.encryption.impl;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.util.Set;
import javax.crypto.SecretKey;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.cache.scopes.GlobalScopedCacheBuilderFactory;
import org.gradle.internal.buildoption.InternalOptions;
import org.gradle.internal.encryption.EncryptionService;
import org.gradle.internal.encryption.impl.EncryptionKind;
import org.gradle.internal.encryption.impl.EnvironmentVarKeySource;
import org.gradle.internal.encryption.impl.KeyStoreKeySource;
import org.gradle.internal.encryption.impl.NoEncryptionKeySource;
import org.gradle.internal.encryption.impl.SecretKeySource;
import org.gradle.internal.extensions.core.InternalOptionsExtensionsKt;
import org.gradle.internal.file.FileSystem;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.util.internal.EncryptionAlgorithm;
import org.gradle.util.internal.SupportedEncryptionAlgorithm;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0010H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+H\u0016J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.H\u0016J\u0010\u00100\u001a\u00020\u001a2\u0006\u00101\u001a\u00020\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000f\u001a\u0004\u0018\u00010\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u001e\u001a\u00020\u001f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u0014\u001a\u0004\b \u0010!R\u0014\u0010#\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u001b\u0010%\u001a\u00020&8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\u0014\u001a\u0004\b'\u0010(\u00a8\u00062"}, d2={"Lorg/gradle/internal/encryption/impl/DefaultEncryptionService;", "Lorg/gradle/internal/encryption/EncryptionService;", "options", "Lorg/gradle/internal/buildoption/InternalOptions;", "cacheBuilderFactory", "Lorg/gradle/cache/scopes/GlobalScopedCacheBuilderFactory;", "fileSystem", "Lorg/gradle/internal/file/FileSystem;", "<init>", "(Lorg/gradle/internal/buildoption/InternalOptions;Lorg/gradle/cache/scopes/GlobalScopedCacheBuilderFactory;Lorg/gradle/internal/file/FileSystem;)V", "encryptionRequestedOption", "", "keystoreDirOption", "", "encryptionAlgorithmOption", "secretKey", "Ljavax/crypto/SecretKey;", "getSecretKey", "()Ljavax/crypto/SecretKey;", "secretKey$delegate", "Lkotlin/Lazy;", "produceSecretKey", "encryptionKind", "Lorg/gradle/internal/encryption/impl/EncryptionKind;", "secretKeyFrom", "keySource", "Lorg/gradle/internal/encryption/impl/SecretKeySource;", "assertKeyLength", "", "key", "encryptionAlgorithm", "Lorg/gradle/util/internal/EncryptionAlgorithm;", "getEncryptionAlgorithm", "()Lorg/gradle/util/internal/EncryptionAlgorithm;", "encryptionAlgorithm$delegate", "isEncrypting", "()Z", "encryptionKeyHashCode", "Lorg/gradle/internal/hash/HashCode;", "getEncryptionKeyHashCode", "()Lorg/gradle/internal/hash/HashCode;", "encryptionKeyHashCode$delegate", "outputStream", "Ljava/io/OutputStream;", "output", "inputStream", "Ljava/io/InputStream;", "input", "secretKeySource", "kind", "encryption-services"})
@SourceDebugExtension(value={"SMAP\nDefaultEncryptionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultEncryptionService.kt\norg/gradle/internal/encryption/impl/DefaultEncryptionService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,137:1\n1#2:138\n*E\n"})
public final class DefaultEncryptionService
implements EncryptionService {
    @NotNull
    private final GlobalScopedCacheBuilderFactory cacheBuilderFactory;
    @NotNull
    private final FileSystem fileSystem;
    private final boolean encryptionRequestedOption;
    @Nullable
    private final String keystoreDirOption;
    @NotNull
    private final String encryptionAlgorithmOption;
    @NotNull
    private final Lazy secretKey$delegate;
    @NotNull
    private final Lazy encryptionAlgorithm$delegate;
    @NotNull
    private final Lazy encryptionKeyHashCode$delegate;

    public DefaultEncryptionService(@NotNull InternalOptions options, @NotNull GlobalScopedCacheBuilderFactory cacheBuilderFactory, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)cacheBuilderFactory, (String)"cacheBuilderFactory");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.cacheBuilderFactory = cacheBuilderFactory;
        this.fileSystem = fileSystem;
        this.encryptionRequestedOption = InternalOptionsExtensionsKt.getInternalFlag((InternalOptions)options, (String)"org.gradle.configuration-cache.internal.encryption", (boolean)true);
        this.keystoreDirOption = InternalOptionsExtensionsKt.getInternalString((InternalOptions)options, (String)"org.gradle.configuration-cache.internal.key-store-dir", null);
        String string = InternalOptionsExtensionsKt.getInternalString((InternalOptions)options, (String)"org.gradle.configuration-cache.internal.encryption-alg", (String)SupportedEncryptionAlgorithm.getDefault().getTransformation());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInternalString(...)");
        this.encryptionAlgorithmOption = string;
        this.secretKey$delegate = LazyKt.lazy(() -> DefaultEncryptionService.secretKey_delegate$lambda$0(this));
        this.encryptionAlgorithm$delegate = LazyKt.lazy(() -> DefaultEncryptionService.encryptionAlgorithm_delegate$lambda$5(this));
        this.encryptionKeyHashCode$delegate = LazyKt.lazy(() -> DefaultEncryptionService.encryptionKeyHashCode_delegate$lambda$8(this));
    }

    private final SecretKey getSecretKey() {
        Lazy lazy = this.secretKey$delegate;
        return (SecretKey)lazy.getValue();
    }

    private final SecretKey produceSecretKey(EncryptionKind encryptionKind) {
        SecretKey secretKey;
        SecretKeySource keySource = this.secretKeySource(encryptionKind);
        boolean bl = false;
        try {
            SecretKey secretKey2;
            SecretKey secretKey3 = this.secretKeyFrom(keySource);
            if (secretKey3 != null) {
                SecretKey secretKey4;
                SecretKey key = secretKey4 = secretKey3;
                boolean bl2 = false;
                this.assertKeyLength(key);
                secretKey2 = secretKey4;
            } else {
                secretKey2 = null;
            }
            secretKey = secretKey2;
        }
        catch (Exception e) {
            throw new GradleException("Error loading encryption key from " + keySource.getSourceDescription(), (Throwable)e);
        }
        return secretKey;
    }

    private final SecretKey secretKeyFrom(SecretKeySource keySource) {
        return keySource.getKey();
    }

    private final void assertKeyLength(SecretKey key) {
        int keyLength = key.getEncoded().length;
        if (keyLength < 16) {
            throw new InvalidKeyException("Encryption key length is " + keyLength + " bytes, but must be at least 16 bytes long");
        }
    }

    @Override
    @NotNull
    public EncryptionAlgorithm getEncryptionAlgorithm() {
        Lazy lazy = this.encryptionAlgorithm$delegate;
        return (EncryptionAlgorithm)lazy.getValue();
    }

    @Override
    public boolean isEncrypting() {
        return this.getSecretKey() != null;
    }

    @Override
    @NotNull
    public HashCode getEncryptionKeyHashCode() {
        Lazy lazy = this.encryptionKeyHashCode$delegate;
        return (HashCode)lazy.getValue();
    }

    @Override
    @NotNull
    public OutputStream outputStream(@NotNull OutputStream output) {
        OutputStream outputStream;
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        if (this.isEncrypting()) {
            OutputStream outputStream2 = this.getEncryptionAlgorithm().encryptedStream(output, this.getSecretKey());
            outputStream = outputStream2;
            Intrinsics.checkNotNullExpressionValue((Object)outputStream2, (String)"encryptedStream(...)");
        } else {
            outputStream = output;
        }
        return outputStream;
    }

    @Override
    @NotNull
    public InputStream inputStream(@NotNull InputStream input) {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (this.isEncrypting()) {
            InputStream inputStream2 = this.getEncryptionAlgorithm().decryptedStream(input, this.getSecretKey());
            inputStream = inputStream2;
            Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"decryptedStream(...)");
        } else {
            inputStream = input;
        }
        return inputStream;
    }

    /*
     * WARNING - void declaration
     */
    private final SecretKeySource secretKeySource(EncryptionKind kind) {
        SecretKeySource secretKeySource;
        switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
            case 1: {
                File file;
                String string = this.getEncryptionAlgorithm().getAlgorithm();
                String string2 = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAlgorithm(...)");
                String string3 = this.keystoreDirOption;
                if (string3 != null) {
                    void it;
                    String string4 = string3;
                    String string5 = string2;
                    boolean bl = false;
                    file = new File((String)it);
                    string2 = string5;
                } else {
                    file = null;
                }
                FileSystem fileSystem = this.fileSystem;
                GlobalScopedCacheBuilderFactory globalScopedCacheBuilderFactory = this.cacheBuilderFactory;
                String string6 = "gradle-secret";
                File file2 = file;
                String string7 = string2;
                secretKeySource = new KeyStoreKeySource(string7, file2, string6, globalScopedCacheBuilderFactory, fileSystem);
                break;
            }
            case 2: {
                String string = this.getEncryptionAlgorithm().getAlgorithm();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAlgorithm(...)");
                secretKeySource = new EnvironmentVarKeySource(string);
                break;
            }
            case 3: {
                secretKeySource = new NoEncryptionKeySource();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return secretKeySource;
    }

    private static final SecretKey secretKey_delegate$lambda$0(DefaultEncryptionService this$0) {
        return this$0.produceSecretKey(EncryptionKind.Companion.select(this$0.encryptionRequestedOption));
    }

    private static final CharSequence encryptionAlgorithm_delegate$lambda$5$lambda$4(EncryptionAlgorithm it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getTransformation();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTransformation(...)");
        return string;
    }

    private static final EncryptionAlgorithm encryptionAlgorithm_delegate$lambda$5(DefaultEncryptionService this$0) {
        Object v1;
        block2: {
            Set set = SupportedEncryptionAlgorithm.getAll();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAll(...)");
            Iterable iterable = set;
            for (Object t : iterable) {
                EncryptionAlgorithm it = (EncryptionAlgorithm)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getTransformation(), (Object)this$0.encryptionAlgorithmOption)) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        EncryptionAlgorithm encryptionAlgorithm = v1;
        if (encryptionAlgorithm == null) {
            StringBuilder stringBuilder = new StringBuilder().append("Unsupported encryption algorithm: ").append(this$0.encryptionAlgorithmOption).append(". Supported algorithms are: ");
            Set set = SupportedEncryptionAlgorithm.getAll();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAll(...)");
            throw new InvalidUserDataException(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)set, null, null, null, (int)0, null, DefaultEncryptionService::encryptionAlgorithm_delegate$lambda$5$lambda$4, (int)31, null)).toString());
        }
        return encryptionAlgorithm;
    }

    private static final HashCode encryptionKeyHashCode_delegate$lambda$8(DefaultEncryptionService this$0) {
        SecretKey secretKey;
        block3: {
            block2: {
                Hasher hasher;
                secretKey = this$0.getSecretKey();
                if (secretKey == null) break block2;
                SecretKey it = secretKey;
                boolean bl = false;
                Hasher $this$encryptionKeyHashCode_delegate_u24lambda_u248_u24lambda_u247_u24lambda_u246 = hasher = Hashing.sha512().newHasher();
                boolean bl2 = false;
                $this$encryptionKeyHashCode_delegate_u24lambda_u248_u24lambda_u247_u24lambda_u246.putBytes(it.getEncoded());
                $this$encryptionKeyHashCode_delegate_u24lambda_u248_u24lambda_u247_u24lambda_u246.putString((CharSequence)this$0.getEncryptionAlgorithm().getTransformation());
                HashCode hashCode = hasher.hash();
                secretKey = hashCode;
                if (hashCode != null) break block3;
            }
            HashCode hashCode = Hashing.newHasher().hash();
            secretKey = hashCode;
            Intrinsics.checkNotNullExpressionValue((Object)hashCode, (String)"hash(...)");
        }
        return secretKey;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EncryptionKind.values().length];
            try {
                nArray[EncryptionKind.KEYSTORE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EncryptionKind.ENV_VAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EncryptionKind.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

