/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.file;

import java.io.IOException;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheLockingAccessCoordinator;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.DefaultExternalResourceCachePolicy;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.cache.internal.ProducerGuard;
import org.gradle.internal.hash.ChecksumService;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ExternalResourceRepository;
import org.gradle.internal.resource.cached.CachedExternalResourceIndex;
import org.gradle.internal.resource.local.FileResourceRepository;
import org.gradle.internal.resource.local.LocallyAvailableExternalResource;
import org.gradle.internal.resource.local.LocallyAvailableResourceCandidates;
import org.gradle.internal.resource.transfer.CacheAwareExternalResourceAccessor;
import org.gradle.internal.resource.transfer.DefaultCacheAwareExternalResourceAccessor;
import org.gradle.internal.resource.transport.AbstractRepositoryTransport;
import org.gradle.util.internal.BuildCommencedTimeProvider;
import org.jspecify.annotations.Nullable;

public class FileTransport
extends AbstractRepositoryTransport {
    private final FileResourceRepository repository;
    private final FileCacheAwareExternalResourceAccessor resourceAccessor;

    public FileTransport(String name, FileResourceRepository repository, CachedExternalResourceIndex<String> cachedExternalResourceIndex, TemporaryFileProvider temporaryFileProvider, BuildCommencedTimeProvider timeProvider, ArtifactCacheLockingAccessCoordinator cacheAccessCoordinator, ProducerGuard<ExternalResourceName> producerGuard, ChecksumService checksumService) {
        super(name);
        this.repository = repository;
        DefaultExternalResourceCachePolicy cachePolicy = new DefaultExternalResourceCachePolicy();
        this.resourceAccessor = new FileCacheAwareExternalResourceAccessor(new DefaultCacheAwareExternalResourceAccessor((ExternalResourceRepository)repository, cachedExternalResourceIndex, timeProvider, temporaryFileProvider, cacheAccessCoordinator, cachePolicy, producerGuard, repository, checksumService));
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public ExternalResourceRepository getRepository() {
        return this.repository;
    }

    @Override
    public CacheAwareExternalResourceAccessor getResourceAccessor() {
        return this.resourceAccessor;
    }

    private class FileCacheAwareExternalResourceAccessor
    implements CacheAwareExternalResourceAccessor {
        private final CacheAwareExternalResourceAccessor delegate;

        FileCacheAwareExternalResourceAccessor(CacheAwareExternalResourceAccessor delegate) {
            this.delegate = delegate;
        }

        @Override
        public @Nullable LocallyAvailableExternalResource getResource(ExternalResourceName source, @Nullable String baseName, CacheAwareExternalResourceAccessor.ResourceFileStore fileStore, @Nullable LocallyAvailableResourceCandidates additionalCandidates) throws IOException {
            LocallyAvailableExternalResource resource = FileTransport.this.repository.resource(source);
            if (!resource.exists()) {
                return null;
            }
            if (baseName == null || resource.getFile().getName().equals(baseName)) {
                return resource;
            }
            return this.delegate.getResource(source, baseName, fileStore, additionalCandidates);
        }
    }
}

