/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes.immutable;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import org.gradle.api.Action;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.CompatibilityCheckDetails;
import org.gradle.api.attributes.MultipleCandidatesDetails;
import org.gradle.api.internal.attributes.CompatibilityCheckResult;
import org.gradle.api.internal.attributes.CompatibilityRule;
import org.gradle.api.internal.attributes.DisambiguationRule;
import org.gradle.api.internal.attributes.MultipleCandidatesResult;
import org.jspecify.annotations.Nullable;

public class ImmutableAttributesSchema {
    public static final ImmutableAttributesSchema EMPTY = new ImmutableAttributesSchema(ImmutableMap.of(), ImmutableList.of());
    final ImmutableMap<Attribute<?>, ImmutableAttributeMatchingStrategy<?>> strategies;
    final ImmutableList<Attribute<?>> precedence;
    private final ImmutableMap<String, Attribute<?>> attributesByName;
    private final int hashCode;

    ImmutableAttributesSchema(ImmutableMap<Attribute<?>, ImmutableAttributeMatchingStrategy<?>> strategies, ImmutableList<Attribute<?>> precedence) {
        this.strategies = strategies;
        this.precedence = precedence;
        this.attributesByName = ImmutableAttributesSchema.computeAttributesByName(strategies);
        this.hashCode = ImmutableAttributesSchema.computeHashCode(strategies, precedence);
    }

    private static ImmutableMap<String, Attribute<?>> computeAttributesByName(ImmutableMap<Attribute<?>, ?> strategies) {
        ImmutableMap.Builder attributesByName = ImmutableMap.builder();
        for (Attribute attribute : strategies.keySet()) {
            attributesByName.put((Object)attribute.getName(), (Object)attribute);
        }
        return attributesByName.buildKeepingLast();
    }

    private static int computeHashCode(ImmutableMap<Attribute<?>, ImmutableAttributeMatchingStrategy<?>> strategies, ImmutableList<Attribute<?>> precedence) {
        int result = strategies.hashCode();
        result = 31 * result + precedence.hashCode();
        return result;
    }

    public ImmutableSet<Attribute<?>> getAttributes() {
        return this.strategies.keySet();
    }

    public <T> DisambiguationRule<T> disambiguationRules(Attribute<T> attribute) {
        ImmutableAttributeMatchingStrategy<T> matchingStrategy = this.getStrategy(attribute);
        if (matchingStrategy != null) {
            return matchingStrategy.getDisambiguationRules();
        }
        return DisambiguationRule.doNothing();
    }

    public <T> CompatibilityRule<T> compatibilityRules(Attribute<T> attribute) {
        ImmutableAttributeMatchingStrategy<T> matchingStrategy = this.getStrategy(attribute);
        if (matchingStrategy != null) {
            return matchingStrategy.getCompatibilityRules();
        }
        return CompatibilityRule.doNothing();
    }

    public @Nullable Attribute<?> getAttributeByName(String name) {
        return (Attribute)this.attributesByName.get((Object)name);
    }

    public ImmutableList<Attribute<?>> getAttributeDisambiguationPrecedence() {
        return this.precedence;
    }

    <T> @Nullable ImmutableAttributeMatchingStrategy<T> getStrategy(Attribute<T> attribute) {
        return (ImmutableAttributeMatchingStrategy)this.strategies.get(attribute);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableAttributesSchema that = (ImmutableAttributesSchema)o;
        return this.strategies.equals(that.strategies) && this.precedence.equals(that.precedence);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static class ImmutableAttributeMatchingStrategy<T> {
        final ChainedCompatibilityRule<T> compatibilityRules;
        final ChainedDisambiguationRule<T> disambiguationRules;

        public ImmutableAttributeMatchingStrategy(ImmutableList<Action<? super CompatibilityCheckDetails<T>>> compatibilityRules, ImmutableList<Action<? super MultipleCandidatesDetails<T>>> disambiguationRules) {
            this.compatibilityRules = new ChainedCompatibilityRule(compatibilityRules);
            this.disambiguationRules = new ChainedDisambiguationRule(disambiguationRules);
        }

        public CompatibilityRule<T> getCompatibilityRules() {
            return this.compatibilityRules;
        }

        public DisambiguationRule<T> getDisambiguationRules() {
            return this.disambiguationRules;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImmutableAttributeMatchingStrategy that = (ImmutableAttributeMatchingStrategy)o;
            return this.compatibilityRules.equals(that.compatibilityRules) && this.disambiguationRules.equals(that.disambiguationRules);
        }

        public int hashCode() {
            return Objects.hash(this.compatibilityRules, this.disambiguationRules);
        }

        static class ChainedCompatibilityRule<T>
        implements CompatibilityRule<T> {
            final ImmutableList<Action<? super CompatibilityCheckDetails<T>>> rules;

            public ChainedCompatibilityRule(ImmutableList<Action<? super CompatibilityCheckDetails<T>>> rules) {
                this.rules = rules;
            }

            @Override
            public void execute(CompatibilityCheckResult<T> result) {
                for (Action rule : this.rules) {
                    rule.execute(result);
                    if (!result.hasResult()) continue;
                    return;
                }
            }

            @Override
            public boolean doesSomething() {
                return !this.rules.isEmpty();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                ChainedCompatibilityRule that = (ChainedCompatibilityRule)o;
                return this.rules.equals(that.rules);
            }

            public int hashCode() {
                return this.rules.hashCode();
            }
        }

        static class ChainedDisambiguationRule<T>
        implements DisambiguationRule<T> {
            final ImmutableList<Action<? super MultipleCandidatesDetails<T>>> rules;

            public ChainedDisambiguationRule(ImmutableList<Action<? super MultipleCandidatesDetails<T>>> rules) {
                this.rules = rules;
            }

            @Override
            public void execute(MultipleCandidatesResult<T> details) {
                for (Action rule : this.rules) {
                    rule.execute(details);
                    if (!details.hasResult()) continue;
                    return;
                }
            }

            @Override
            public boolean doesSomething() {
                return !this.rules.isEmpty();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                ChainedDisambiguationRule that = (ChainedDisambiguationRule)o;
                return this.rules.equals(that.rules);
            }

            public int hashCode() {
                return this.rules.hashCode();
            }
        }
    }
}

