//===----------------------------------------------------------------------===//
// This file is automatically generated by scripts/generate_enums.py
// Do not edit this file manually, your changes will be overwritten
//===----------------------------------------------------------------------===//

#include "json_enums.hpp"
#include "duckdb/common/string_util.hpp"

namespace duckdb {

template<>
const char* EnumUtil::ToChars<JSONScanType>(JSONScanType value) {
	switch(value) {
	case JSONScanType::INVALID:
		return "INVALID";
	case JSONScanType::READ_JSON:
		return "READ_JSON";
	case JSONScanType::READ_JSON_OBJECTS:
		return "READ_JSON_OBJECTS";
	case JSONScanType::SAMPLE:
		return "SAMPLE";
	default:
		throw NotImplementedException(StringUtil::Format("Enum value of type JSONScanType: '%d' not implemented", value));
	}
}

template<>
JSONScanType EnumUtil::FromString<JSONScanType>(const char *value) {
    if (StringUtil::Equals(value, "INVALID")) {
		return JSONScanType::INVALID;
	}
    if (StringUtil::Equals(value, "READ_JSON")) {
		return JSONScanType::READ_JSON;
	}
    if (StringUtil::Equals(value, "READ_JSON_OBJECTS")) {
		return JSONScanType::READ_JSON_OBJECTS;
	}
    if (StringUtil::Equals(value, "SAMPLE")) {
		return JSONScanType::SAMPLE;
	}
   throw NotImplementedException(StringUtil::Format("Enum value of type JSONScanType: '%s' not implemented", value));
}

template<>
const char* EnumUtil::ToChars<JSONRecordType>(JSONRecordType value) {
	switch(value) {
	case JSONRecordType::AUTO_DETECT:
		return "AUTO_DETECT";
	case JSONRecordType::RECORDS:
		return "RECORDS";
	case JSONRecordType::VALUES:
		return "VALUES";
	default:
		throw NotImplementedException(StringUtil::Format("Enum value of type JSONRecordType: '%d' not implemented", value));
	}
}

template<>
JSONRecordType EnumUtil::FromString<JSONRecordType>(const char *value) {
    if (StringUtil::Equals(value, "AUTO_DETECT")) {
		return JSONRecordType::AUTO_DETECT;
	}
    if (StringUtil::Equals(value, "RECORDS")) {
		return JSONRecordType::RECORDS;
	}
    if (StringUtil::Equals(value, "VALUES")) {
		return JSONRecordType::VALUES;
	}
   throw NotImplementedException(StringUtil::Format("Enum value of type JSONRecordType: '%s' not implemented", value));
}

template<>
const char* EnumUtil::ToChars<JSONFormat>(JSONFormat value) {
	switch(value) {
	case JSONFormat::AUTO_DETECT:
		return "AUTO_DETECT";
	case JSONFormat::UNSTRUCTURED:
		return "UNSTRUCTURED";
	case JSONFormat::NEWLINE_DELIMITED:
		return "NEWLINE_DELIMITED";
	case JSONFormat::ARRAY:
		return "ARRAY";
	default:
		throw NotImplementedException(StringUtil::Format("Enum value of type JSONFormat: '%d' not implemented", value));
	}
}

template<>
JSONFormat EnumUtil::FromString<JSONFormat>(const char *value) {
    if (StringUtil::Equals(value, "AUTO_DETECT")) {
		return JSONFormat::AUTO_DETECT;
	}
    if (StringUtil::Equals(value, "UNSTRUCTURED")) {
		return JSONFormat::UNSTRUCTURED;
	}
    if (StringUtil::Equals(value, "NEWLINE_DELIMITED")) {
		return JSONFormat::NEWLINE_DELIMITED;
	}
    if (StringUtil::Equals(value, "ARRAY")) {
		return JSONFormat::ARRAY;
	}
   throw NotImplementedException(StringUtil::Format("Enum value of type JSONFormat: '%s' not implemented", value));
}

} // namespace duckdb
