import type { CleanupFn } from '../../internal-types';
import type { DroppableRegistry } from '../droppable-registry';
import type { DragController, StartKeyboardDrag } from '../types';
export declare function useKeyboardControls({ dragController, droppableRegistry, contextId, setKeyboardCleanupFn, }: {
    dragController: DragController;
    droppableRegistry: DroppableRegistry;
    contextId: string;
    /**
     * Sets the cleanup function that should run whenever:
     * - A user drops
     * - A user cancels a drag
     * - There is an error, cancelling a drag
     *
     * Because this hook has no visibility of when a drag is cancelled due to
     * an error, the cleanup is handled at the level above.
     */
    setKeyboardCleanupFn: (cleanupFn: CleanupFn) => void;
}): {
    startKeyboardDrag: StartKeyboardDrag;
};
