import _defineProperty from "@babel/runtime/helpers/defineProperty";
import { useMemo } from 'react';
/**
 * Private symbol that is intentionally not exported from this file.
 */
var privateKey = Symbol('DraggableData');

/**
 * Data that is attached to drags. The same data is used for the `draggable()`
 * and `dropTargetForElements()` calls related to a `<Draggable>` instance.
 */

/**
 * Checks if the passed data satisfies `DraggableData` using the private symbol.
 */
export function isDraggableData(data) {
  return data[privateKey] === true;
}

/**
 * Adds the private symbol to the passed data.
 *
 * The symbol allows us to quickly check if an object satisfies `DraggableData`.
 */
export function useDraggableData(_ref) {
  var draggableId = _ref.draggableId,
    droppableId = _ref.droppableId,
    getIndex = _ref.getIndex,
    contextId = _ref.contextId,
    type = _ref.type;
  return useMemo(function () {
    return _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty({}, privateKey, true), "draggableId", draggableId), "droppableId", droppableId), "getIndex", getIndex), "contextId", contextId), "type", type);
  }, [draggableId, droppableId, getIndex, contextId, type]);
}