"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DraggableClone = DraggableClone;
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _reactDom = require("react-dom");
var _combine = require("@atlaskit/pragmatic-drag-and-drop/combine");
var _adapter = require("@atlaskit/pragmatic-drag-and-drop/element/adapter");
var _useHiddenTextElement = require("../drag-drop-context/hooks/use-hidden-text-element");
var _internalContext = require("../drag-drop-context/internal-context");
var _lifecycleContext = require("../drag-drop-context/lifecycle-context");
var _rbdInvariant = require("../drag-drop-context/rbd-invariant");
var _data = require("../draggable/data");
var _getDraggableProvidedStyle = require("../draggable/get-draggable-provided-style");
var _state = require("../draggable/state");
var _useDraggableStateSnapshot = require("../draggable/use-draggable-state-snapshot");
var _useCapturedDimensions = require("../hooks/use-captured-dimensions");
var _attributes = require("../utils/attributes");
var _findDragHandle = require("../utils/find-drag-handle");
var _findDropIndicator = require("../utils/find-drop-indicator");
var _findPlaceholder = require("../utils/find-placeholder");
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); return f; })(e, t); }
function getBody() {
  return document.body;
}

/**
 * Calls the `renderClone` function.
 *
 * Only rendered during drags.
 */
function DraggableCloneInner(_ref) {
  var children = _ref.children,
    droppableId = _ref.droppableId,
    type = _ref.type,
    draggableId = _ref.draggableId,
    index = _ref.index,
    draggingOver = _ref.draggingOver,
    style = _ref.style,
    _ref$getContainerForC = _ref.getContainerForClone,
    getContainerForClone = _ref$getContainerForC === void 0 ? getBody : _ref$getContainerForC,
    mode = _ref.mode;
  var _useDragDropContext = (0, _internalContext.useDragDropContext)(),
    contextId = _useDragDropContext.contextId;

  /**
   * The handle should maintain focus during a drag,
   * if it had focus before the drag started.
   */
  var focusDragHandle = (0, _react.useCallback)(function (element) {
    if (!element) {
      return;
    }
    var dragHandle = (0, _findDragHandle.findDragHandle)({
      contextId: contextId,
      draggableId: draggableId
    });
    dragHandle === null || dragHandle === void 0 || dragHandle.focus();
  }, [contextId, draggableId]);
  var provided = (0, _react.useMemo)(function () {
    return {
      innerRef: focusDragHandle,
      draggableProps: (0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)({}, _attributes.attributes.draggable.contextId, contextId), _attributes.attributes.draggable.id, draggableId), "style", style),
      dragHandleProps: (0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)({
        role: 'button',
        'aria-describedby': (0, _useHiddenTextElement.getHiddenTextElementId)(contextId)
      }, _attributes.attributes.dragHandle.contextId, contextId), _attributes.attributes.dragHandle.draggableId, draggableId), "tabIndex", 0), "draggable", false), "onDragStart", function onDragStart() {})
    };
  }, [contextId, draggableId, focusDragHandle, style]);
  var snapshot = (0, _useDraggableStateSnapshot.useDraggableStateSnapshot)({
    draggingOver: draggingOver,
    isClone: true,
    isDragging: true,
    mode: mode
  });
  var rubric = (0, _react.useMemo)(function () {
    return {
      draggableId: draggableId,
      type: type,
      source: {
        droppableId: droppableId,
        index: index
      }
    };
  }, [draggableId, droppableId, index, type]);
  return /*#__PURE__*/(0, _reactDom.createPortal)(children(provided, snapshot, rubric), getContainerForClone());
}

/**
 * Wrapper that is always rendered if there is a `renderClone` function.
 *
 * It sets up a monitor, and needs to observe the entire lifecycle.
 */
function DraggableClone(_ref2) {
  var children = _ref2.children,
    droppableId = _ref2.droppableId,
    type = _ref2.type,
    getContainerForClone = _ref2.getContainerForClone;
  var _useDragDropContext2 = (0, _internalContext.useDragDropContext)(),
    contextId = _useDragDropContext2.contextId,
    getDragState = _useDragDropContext2.getDragState;
  var draggableDimensions = (0, _useCapturedDimensions.useDraggableDimensions)();
  var _useReducer = (0, _react.useReducer)(_state.reducer, _state.idleState),
    _useReducer2 = (0, _slicedToArray2.default)(_useReducer, 2),
    state = _useReducer2[0],
    dispatch = _useReducer2[1];
  var monitorForLifecycle = (0, _lifecycleContext.useMonitorForLifecycle)();
  (0, _react.useEffect)(function () {
    return (0, _combine.combine)(monitorForLifecycle({
      onPendingDragStart: function onPendingDragStart(_ref3) {
        var start = _ref3.start,
          droppable = _ref3.droppable;
        if (droppableId !== start.source.droppableId) {
          return;
        }
        if (start.mode === 'FLUID') {
          return dispatch({
            type: 'START_POINTER_DRAG',
            payload: {
              start: start
            }
          });
        }
        if (start.mode === 'SNAP') {
          var dragState = getDragState();
          (0, _rbdInvariant.rbdInvariant)(dragState.isDragging && dragState.draggableDimensions);
          return dispatch({
            type: 'START_KEYBOARD_DRAG',
            payload: {
              start: start,
              draggableDimensions: dragState.draggableDimensions,
              droppable: droppable
            }
          });
        }
      },
      onPendingDragUpdate: function onPendingDragUpdate(_ref4) {
        var update = _ref4.update,
          droppable = _ref4.droppable;
        if (state.type !== 'dragging') {
          return;
        }
        if (state.draggableId !== update.draggableId) {
          return;
        }
        dispatch({
          type: 'UPDATE_DRAG',
          payload: {
            update: update
          }
        });
        if (update.mode === 'SNAP') {
          /**
           * Updating the position in a microtask to resolve timing issues.
           *
           * When doing cross-axis dragging, the drop indicator in the new
           * droppable will mount and update in a `onPendingDragUpdate` too.
           *
           * The microtask ensures that the indicator will have updated by
           * the time this runs, so the preview will have the correct
           * location of the indicator.
           */
          queueMicrotask(function () {
            /**
             * Because this update occurs in a microtask, we need to check
             * that the drag is still happening.
             *
             * If it has ended we should not try to update the preview.
             */
            var dragState = getDragState();
            if (!dragState.isDragging) {
              return;
            }

            /**
             * The placeholder might not exist if its associated
             * draggable unmounts in a virtual list.
             */
            var placeholder = (0, _findPlaceholder.findPlaceholder)(contextId);
            var placeholderRect = placeholder ? placeholder.getBoundingClientRect() : null;

            /**
             * The drop indicator might not exist if the current target
             * is null
             */
            var dropIndicator = (0, _findDropIndicator.findDropIndicator)();
            var dropIndicatorRect = dropIndicator ? dropIndicator.getBoundingClientRect() : null;
            dispatch({
              type: 'UPDATE_KEYBOARD_PREVIEW',
              payload: {
                update: update,
                draggableDimensions: draggableDimensions,
                droppable: droppable,
                placeholderRect: placeholderRect,
                dropIndicatorRect: dropIndicatorRect
              }
            });
          });
        }
      },
      onBeforeDragEnd: function onBeforeDragEnd(_ref5) {
        var draggableId = _ref5.draggableId;
        if (state.type !== 'dragging') {
          return;
        }
        if (draggableId !== state.draggableId) {
          return;
        }
        dispatch({
          type: 'DROP'
        });
      }
    }), (0, _adapter.monitorForElements)({
      canMonitor: function canMonitor(_ref6) {
        var source = _ref6.source;
        if (!(0, _data.isDraggableData)(source.data)) {
          // not dragging something from the migration layer
          // we should not monitor it
          return false;
        }
        return source.data.contextId === contextId && source.data.droppableId === droppableId;
      },
      onDrag: function onDrag(_ref7) {
        var location = _ref7.location;
        dispatch({
          type: 'UPDATE_POINTER_PREVIEW',
          payload: {
            pointerLocation: location
          }
        });
      }
    }));
  }, [droppableId, contextId, monitorForLifecycle, state, draggableDimensions, getDragState]);
  if (state.type !== 'dragging') {
    return null;
  }
  var style = (0, _getDraggableProvidedStyle.getDraggableProvidedStyle)({
    draggableDimensions: draggableDimensions,
    draggableState: state
  });
  return /*#__PURE__*/_react.default.createElement(DraggableCloneInner, {
    droppableId: droppableId,
    type: type,
    draggableId: state.draggableId,
    index: state.start.index,
    draggingOver: state.draggingOver,
    mode: state.mode
    // eslint-disable-next-line @atlaskit/ui-styling-standard/enforce-style-prop -- Ignored via go/DSP-18766
    ,
    style: style,
    getContainerForClone: getContainerForClone
  }, children);
}