import { isFedRamp } from '@atlaskit/atlassian-context';
import { EvaluationReason } from './compat/types';
import { PerimeterType } from './types';
export const getOptionsWithDefaults = options => ({
  /**
   * If more federal PerimeterTypes are added in the future, this should be updated so
   * that isFedRamp() === true always returns the strictest perimeter.
   */
  perimeter: isFedRamp() ? PerimeterType.FEDRAMP_MODERATE : PerimeterType.COMMERCIAL,
  ...options
});
export const shallowEquals = (objectA, objectB) => {
  if (!objectA && !objectB) {
    return true;
  }
  if (!objectA || !objectB) {
    return false;
  }
  const aEntries = Object.entries(objectA);
  const bEntries = Object.entries(objectB);
  if (aEntries.length !== bEntries.length) {
    return false;
  }
  const ascendingKeyOrder = ([key1], [key2]) => key1.localeCompare(key2);
  aEntries.sort(ascendingKeyOrder);
  bEntries.sort(ascendingKeyOrder);
  for (let i = 0; i < aEntries.length; i++) {
    const [, aValue] = aEntries[i];
    const [, bValue] = bEntries[i];
    if (aValue !== bValue) {
      return false;
    }
  }
  return true;
};

/**
 * This method creates an instance of StatsigUser from the given set of identifiers and
 * attributes.
 */
export const toStatsigUser = (identifiers, customAttributes) => {
  const user = {
    customIDs: identifiers,
    custom: customAttributes
  };
  if (identifiers.atlassianAccountId) {
    user.userID = identifiers.atlassianAccountId;
  }
  return user;
};
export const migrateInitializationOptions = options => {
  const {
    api,
    disableCurrentPageLogging,
    loggingIntervalMillis,
    loggingBufferMaxSize,
    localMode,
    eventLoggingApi,
    eventLoggingApiForRetries,
    disableLocalStorage,
    ignoreWindowUndefined,
    disableAllLogging,
    // No equivalent but is pointless anyway since our Statsig init is synchronous
    initTimeoutMs: _initTimeoutMs,
    // No equivalent in new client but probably not important?
    disableNetworkKeepalive: _disableNetworkKeepalive,
    // Needs to be implemented manually but unused according to zoekt
    overrideStableID: _overrideStableID,
    // No equivalent for these but can't see them actually used anywhere in old client?
    disableErrorLogging: _disableErrorLogging,
    disableAutoMetricsLogging: _disableAutoMetricsLogging,
    ...rest
  } = options;
  return {
    ...rest,
    networkConfig: {
      api,
      logEventUrl: eventLoggingApi ? eventLoggingApi + 'rgstr' : undefined,
      logEventFallbackUrls: eventLoggingApiForRetries ? [eventLoggingApiForRetries] : undefined,
      preventAllNetworkTraffic: localMode || !ignoreWindowUndefined && typeof window === 'undefined'
    },
    includeCurrentPageUrlWithEvents: !disableCurrentPageLogging,
    loggingIntervalMs: loggingIntervalMillis,
    loggingBufferMaxSize,
    disableStorage: disableLocalStorage === undefined ? localMode : disableLocalStorage,
    disableLogging: disableAllLogging === undefined ? localMode : disableAllLogging
  };
};
const evaluationReasonMappings = Object.entries(EvaluationReason).map(([key, value]) => [key.toLowerCase(), value]);
export const migrateEvaluationDetails = details => {
  var _evaluationReasonMapp, _evaluationReasonMapp2, _details$receivedAt;
  const reasonLower = details.reason.toLowerCase();
  return {
    reason: (_evaluationReasonMapp = (_evaluationReasonMapp2 = evaluationReasonMappings.find(([key]) => reasonLower.includes(key))) === null || _evaluationReasonMapp2 === void 0 ? void 0 : _evaluationReasonMapp2[1]) !== null && _evaluationReasonMapp !== void 0 ? _evaluationReasonMapp : EvaluationReason.Unknown,
    time: (_details$receivedAt = details.receivedAt) !== null && _details$receivedAt !== void 0 ? _details$receivedAt : Date.now()
  };
};
export const migrateSecondaryExposures = secondaryExposures => {
  return secondaryExposures.map(exposure => {
    if (typeof exposure === 'string') {
      // This should ideally have gateValue and ruleID fields too, but it's not possible for us
      // to determine the correct values for these.
      return {
        gate: exposure
      };
    }
    return exposure;
  });
};