/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.ole.win32.FORMATETC;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.DROPFILES;
import org.eclipse.swt.internal.win32.OS;

public class FileTransfer
extends ByteArrayTransfer {
    private static FileTransfer _instance = new FileTransfer();
    private static final String CF_HDROP = "CF_HDROP";
    private static final int CF_HDROPID = 15;
    private static final String CFSTR_SHELLIDLIST = "Shell IDList Array";
    private static final int CFSTR_SHELLIDLISTID = FileTransfer.registerType("Shell IDList Array");

    private FileTransfer() {
    }

    public static FileTransfer getInstance() {
        return _instance;
    }

    @Override
    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkFile(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        String[] fileNames = (String[])object;
        long newPtr = 0L;
        if (transferData.type == 15) {
            StringBuilder allFiles = new StringBuilder();
            String[] stringArray = fileNames;
            int n = fileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                allFiles.append(fileName);
                allFiles.append('\u0000');
                ++n2;
            }
            allFiles.append('\u0000');
            char[] buffer = new char[allFiles.length()];
            allFiles.getChars(0, allFiles.length(), buffer, 0);
            DROPFILES dropfiles = new DROPFILES();
            dropfiles.pFiles = DROPFILES.sizeof;
            dropfiles.pt_y = 0;
            dropfiles.pt_x = 0;
            dropfiles.fNC = 0;
            dropfiles.fWide = 1;
            int byteCount = buffer.length * 2;
            newPtr = OS.GlobalAlloc(64, DROPFILES.sizeof + byteCount);
            if (newPtr != 0L) {
                OS.MoveMemory(newPtr, dropfiles, DROPFILES.sizeof);
                OS.MoveMemory(newPtr + (long)DROPFILES.sizeof, buffer, byteCount);
            }
        } else if (transferData.type == CFSTR_SHELLIDLISTID) {
            newPtr = this.generateCidaFromFilepaths(fileNames);
        }
        transferData.stgmedium = new STGMEDIUM();
        transferData.stgmedium.tymed = 1;
        transferData.stgmedium.unionField = newPtr;
        transferData.stgmedium.pUnkForRelease = 0L;
        transferData.result = newPtr != 0L ? 0 : -2147467259;
    }

    @Override
    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pIDataObject == 0L) {
            return null;
        }
        IDataObject dataObject = new IDataObject(transferData.pIDataObject);
        dataObject.AddRef();
        FORMATETC formatetc = new FORMATETC();
        formatetc.cfFormat = 15;
        formatetc.ptd = 0L;
        formatetc.dwAspect = 1;
        formatetc.lindex = -1;
        formatetc.tymed = 1;
        STGMEDIUM stgmedium = new STGMEDIUM();
        stgmedium.tymed = 1;
        transferData.result = this.getData(dataObject, formatetc, stgmedium);
        dataObject.Release();
        if (transferData.result != 0) {
            return null;
        }
        int count = OS.DragQueryFile(stgmedium.unionField, -1, null, 0);
        String[] fileNames = new String[count];
        int i = 0;
        while (i < count) {
            int size = OS.DragQueryFile(stgmedium.unionField, i, null, 0);
            char[] lpszFile = new char[size + 1];
            OS.DragQueryFile(stgmedium.unionField, i, lpszFile, size + 1);
            fileNames[i] = new String(lpszFile, 0, size);
            ++i;
        }
        OS.DragFinish(stgmedium.unionField);
        return fileNames;
    }

    /*
     * Exception decompiling
     */
    private long generateCidaFromFilepaths(String[] fileNames) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[DOLOOP]], but top level block is 6[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean isSupportedType(TransferData transferData) {
        if (transferData != null && transferData.pIDataObject != 0L && transferData.type == CFSTR_SHELLIDLISTID) {
            return false;
        }
        return super.isSupportedType(transferData);
    }

    @Override
    protected int[] getTypeIds() {
        return new int[]{15, CFSTR_SHELLIDLISTID};
    }

    @Override
    protected String[] getTypeNames() {
        return new String[]{CF_HDROP, CFSTR_SHELLIDLIST};
    }

    boolean checkFile(Object object) {
        if (object == null || !(object instanceof String[]) || ((String[])object).length == 0) {
            return false;
        }
        String[] stringArray = (String[])object;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (string == null || string.length() == 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    protected boolean validate(Object object) {
        return this.checkFile(object);
    }
}

