/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import org.eclipse.swt.internal.image.JPEGVariableSizeSegment;
import org.eclipse.swt.internal.image.LEDataInputStream;

final class JPEGQuantizationTable
extends JPEGVariableSizeSegment {
    public static byte[] DefaultLuminanceQTable = new byte[]{-1, -37, 0, 67, 0, 16, 11, 10, 16, 24, 40, 51, 61, 12, 12, 14, 19, 26, 58, 60, 55, 14, 13, 16, 24, 40, 57, 69, 56, 14, 17, 22, 29, 51, 87, 80, 62, 18, 22, 37, 56, 68, 109, 103, 77, 24, 35, 55, 64, 81, 104, 113, 92, 49, 64, 78, 87, 103, 121, 120, 101, 72, 92, 95, 98, 112, 100, 103, 99};
    public static byte[] DefaultChrominanceQTable = new byte[]{-1, -37, 0, 67, 1, 17, 18, 24, 47, 99, 99, 99, 99, 18, 21, 26, 66, 99, 99, 99, 99, 24, 26, 56, 99, 99, 99, 99, 99, 47, 66, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99};

    public JPEGQuantizationTable(byte[] reference) {
        super(reference);
    }

    public JPEGQuantizationTable(LEDataInputStream byteStream) {
        super(byteStream);
    }

    public static JPEGQuantizationTable defaultChrominanceTable() {
        byte[] data = new byte[DefaultChrominanceQTable.length];
        System.arraycopy(DefaultChrominanceQTable, 0, data, 0, data.length);
        return new JPEGQuantizationTable(data);
    }

    public static JPEGQuantizationTable defaultLuminanceTable() {
        byte[] data = new byte[DefaultLuminanceQTable.length];
        System.arraycopy(DefaultLuminanceQTable, 0, data, 0, data.length);
        return new JPEGQuantizationTable(data);
    }

    public int[] getQuantizationTablesKeys() {
        int[] keys = new int[4];
        int keysIndex = 0;
        int totalLength = this.getSegmentLength() - 2;
        int ofs = 4;
        while (totalLength > 64) {
            int tq = this.reference[ofs] & 0xF;
            int pq = (this.reference[ofs] & 0xFF) >> 4;
            if (pq == 0) {
                ofs += 65;
                totalLength -= 65;
            } else {
                ofs += 129;
                totalLength -= 129;
            }
            if (keysIndex >= keys.length) {
                int[] newKeys = new int[keys.length + 4];
                System.arraycopy(keys, 0, newKeys, 0, keys.length);
                keys = newKeys;
            }
            keys[keysIndex] = tq;
            ++keysIndex;
        }
        int[] newKeys = new int[keysIndex];
        System.arraycopy(keys, 0, newKeys, 0, keysIndex);
        return newKeys;
    }

    public int[][] getQuantizationTablesValues() {
        int[][] values = new int[4][];
        int valuesIndex = 0;
        int totalLength = this.getSegmentLength() - 2;
        int ofs = 4;
        while (totalLength > 64) {
            int i;
            int[] qk = new int[64];
            int pq = (this.reference[ofs] & 0xFF) >> 4;
            if (pq == 0) {
                for (i = 0; i < qk.length; ++i) {
                    qk[i] = this.reference[ofs + i + 1] & 0xFF;
                }
                ofs += 65;
                totalLength -= 65;
            } else {
                for (i = 0; i < qk.length; ++i) {
                    int idx = (i - 1) * 2;
                    qk[i] = (this.reference[ofs + idx + 1] & 0xFF) * 256 + (this.reference[ofs + idx + 2] & 0xFF);
                }
                ofs += 129;
                totalLength -= 129;
            }
            if (valuesIndex >= values.length) {
                int[][] newValues = new int[values.length + 4][];
                System.arraycopy(values, 0, newValues, 0, values.length);
                values = newValues;
            }
            values[valuesIndex] = qk;
            ++valuesIndex;
        }
        int[][] newValues = new int[valuesIndex][];
        System.arraycopy(values, 0, newValues, 0, valuesIndex);
        return newValues;
    }

    public void scaleBy(int qualityFactor) {
        int qFactor = qualityFactor;
        if (qFactor <= 0) {
            qFactor = 1;
        }
        if (qFactor > 100) {
            qFactor = 100;
        }
        qFactor = qFactor < 50 ? 5000 / qFactor : 200 - qFactor * 2;
        int totalLength = this.getSegmentLength() - 2;
        int ofs = 4;
        while (totalLength > 64) {
            int temp;
            int i;
            int pq = (this.reference[ofs] & 0xFF) >> 4;
            if (pq == 0) {
                for (i = ofs + 1; i <= ofs + 64; ++i) {
                    temp = ((this.reference[i] & 0xFF) * qFactor + 50) / 100;
                    if (temp <= 0) {
                        temp = 1;
                    }
                    if (temp > 255) {
                        temp = 255;
                    }
                    this.reference[i] = (byte)temp;
                }
                ofs += 65;
                totalLength -= 65;
                continue;
            }
            for (i = ofs + 1; i <= ofs + 128; i += 2) {
                temp = (((this.reference[i] & 0xFF) * 256 + (this.reference[i + 1] & 0xFF)) * qFactor + 50) / 100;
                if (temp <= 0) {
                    temp = 1;
                }
                if (temp > Short.MAX_VALUE) {
                    temp = Short.MAX_VALUE;
                }
                this.reference[i] = (byte)(temp >> 8);
                this.reference[i + 1] = (byte)(temp & 0xFF);
            }
            ofs += 129;
            totalLength -= 129;
        }
    }

    @Override
    public int signature() {
        return 65499;
    }
}

