/**
# Copyright (c) NVIDIA CORPORATION.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
**/

package crio

import (
	"github.com/NVIDIA/nvidia-container-toolkit/internal/logger"
	"github.com/NVIDIA/nvidia-container-toolkit/pkg/config/toml"
)

type builder struct {
	logger             logger.Interface
	configSource       toml.Loader
	configDestination  toml.Loader
	topLevelConfigPath string
}

// Option defines a function that can be used to configure the config builder
type Option func(*builder)

// WithLogger sets the logger for the config builder
func WithLogger(logger logger.Interface) Option {
	return func(b *builder) {
		b.logger = logger
	}
}

// WithTopLevelConfigPath sets the path for the top-level containerd config.
func WithTopLevelConfigPath(path string) Option {
	return func(b *builder) {
		b.topLevelConfigPath = path
	}
}

// WithConfigSource sets the TOML source for the config.
func WithConfigSource(configSource toml.Loader) Option {
	return func(b *builder) {
		b.configSource = configSource
	}
}

// WithConfigDestination sets the TOML destination for the config.
func WithConfigDestination(configDestination toml.Loader) Option {
	return func(b *builder) {
		b.configDestination = configDestination
	}
}
